function table=table_cube_QMC

% QMC MZ PARAMETERS ON THE UNIT CUBE [-1,1]^3.
%
% card  : 2.^table(:,1)
% 1-eta : table(:,2)
% A       : table(:,3)
% B       : table(:,4)
%cond  : table(:,5)

table=[
    1   0   4.44e-16  1.00e+00  1.00e+00  1.00e+00
    1   1   4.79e+00  1.33e-16  5.79e+00  1.75e+18
    1   2   2.50e+01  2.94e-15  2.60e+01  1.13e+34
    1   3   9.45e+01  9.20e-15  9.55e+01  7.73e+33
    1   4   2.76e+02  2.02e-14  2.77e+02  6.36e+33
    1   5   6.85e+02  4.67e-14  6.86e+02  2.19e+47
    1   6   1.51e+03  1.27e-13  1.51e+03  5.52e+49
    1   7   3.04e+03  2.88e-13  3.04e+03  2.17e+49
    1   8   5.69e+03  5.43e-13  5.69e+03  3.06e+67
    1   9   1.00e+04  1.92e-12  1.00e+04  2.43e+66
    1   10  1.69e+04  1.78e-12  1.69e+04  1.19e+65
    1   11  2.72e+04  5.51e-12  2.72e+04  3.45e+65
    1   12  4.24e+04  4.15e-12  4.24e+04  8.09e+65
    1   13  6.40e+04  1.73e-11  6.40e+04  7.49e+65
    1   14  9.41e+04  2.71e-11  9.41e+04  1.96e+83
    1   15  1.35e+05  3.93e-11  1.35e+05  1.36e+67
    1   16  1.90e+05  5.42e-11  1.90e+05  4.55e+67
    1   17  2.63e+05  9.01e-11  2.63e+05  2.50e+69
    1   18  3.58e+05  1.35e-10  3.58e+05  3.60e+68
    1   19  4.79e+05  2.35e-10  4.79e+05  7.74e+68
    1   20  6.33e+05  4.18e-10  6.33e+05  1.05e+68
    2   0   4.44e-16  1.00e+00  1.00e+00  1.00e+00
    2   1   2.10e+00  1.05e-01  3.10e+00  2.95e+01
    2   2   1.21e+01  4.99e-16  1.31e+01  2.37e+17
    2   3   4.69e+01  4.01e-15  4.79e+01  1.41e+18
    2   4   1.38e+02  6.42e-15  1.39e+02  5.63e+17
    2   5   3.42e+02  3.45e-14  3.43e+02  3.04e+18
    2   6   7.55e+02  1.14e-13  7.56e+02  7.13e+18
    2   7   1.52e+03  1.83e-13  1.52e+03  6.44e+18
    2   8   2.85e+03  4.11e-13  2.85e+03  2.79e+19
    2   9   5.02e+03  9.30e-13  5.02e+03  6.31e+19
    2   10  8.44e+03  1.04e-12  8.44e+03  1.44e+20
    2   11  1.36e+04  1.63e-12  1.36e+04  1.19e+20
    2   12  2.12e+04  5.87e-12  2.12e+04  3.46e+20
    2   13  3.20e+04  8.36e-12  3.20e+04  1.68e+20
    2   14  4.71e+04  1.35e-11  4.71e+04  4.01e+20
    2   15  6.76e+04  2.16e-11  6.76e+04  3.16e+20
    2   16  9.52e+04  1.83e-11  9.52e+04  7.41e+21
    2   17  1.32e+05  5.12e-11  1.32e+05  5.18e+20
    2   18  1.79e+05  6.23e-11  1.79e+05  2.10e+21
    2   19  2.40e+05  9.76e-11  2.40e+05  1.26e+21
    2   20  3.17e+05  1.41e-10  3.17e+05  1.61e+22
    3   0   4.44e-16  1.00e+00  1.00e+00  1.00e+00
    3   1   1.01e+00  4.42e-01  2.01e+00  4.55e+00
    3   2   5.79e+00  2.89e-16  6.79e+00  9.21e+16
    3   3   2.31e+01  1.07e-15  2.41e+01  1.23e+18
    3   4   6.86e+01  1.38e-14  6.96e+01  2.96e+18
    3   5   1.71e+02  9.67e-15  1.72e+02  3.31e+18
    3   6   3.77e+02  3.28e-14  3.78e+02  8.01e+18
    3   7   7.60e+02  1.38e-13  7.61e+02  3.54e+19
    3   8   1.42e+03  1.54e-13  1.42e+03  2.99e+19
    3   9   2.51e+03  2.67e-13  2.51e+03  3.04e+19
    3   10  4.22e+03  5.05e-13  4.22e+03  5.73e+20
    3   11  6.80e+03  8.46e-13  6.80e+03  2.45e+20
    3   12  1.06e+04  1.47e-12  1.06e+04  1.82e+20
    3   13  1.60e+04  5.66e-12  1.60e+04  9.65e+20
    3   14  2.35e+04  7.27e-12  2.35e+04  5.56e+21
    3   15  3.38e+04  1.23e-11  3.38e+04  1.86e+20
    3   16  4.76e+04  1.83e-11  4.76e+04  4.53e+20
    3   17  6.58e+04  2.18e-11  6.58e+04  2.67e+21
    3   18  8.94e+04  3.73e-11  8.94e+04  3.37e+21
    3   19  1.20e+05  3.59e-11  1.20e+05  3.07e+21
    3   20  1.58e+05  4.48e-11  1.58e+05  3.32e+21
    4   0   2.22e-16  1.00e+00  1.00e+00  1.00e+00
    4   1   5.34e-01  7.07e-01  1.53e+00  2.17e+00
    4   2   2.73e+00  1.55e-01  3.73e+00  2.41e+01
    4   3   1.11e+01  9.03e-17  1.21e+01  3.05e+18
    4   4   3.40e+01  1.63e-15  3.50e+01  7.83e+17
    4   5   8.51e+01  4.29e-15  8.61e+01  5.34e+18
    4   6   1.88e+02  1.10e-14  1.89e+02  5.72e+18
    4   7   3.80e+02  2.22e-14  3.81e+02  9.07e+18
    4   8   7.11e+02  7.30e-14  7.12e+02  6.13e+19
    4   9   1.25e+03  1.01e-13  1.26e+03  2.55e+19
    4   10  2.11e+03  1.61e-13  2.11e+03  6.07e+19
    4   11  3.40e+03  3.93e-13  3.40e+03  1.81e+20
    4   12  5.29e+03  4.73e-13  5.30e+03  2.87e+20
    4   13  8.00e+03  7.89e-13  8.00e+03  5.22e+20
    4   14  1.18e+04  1.94e-12  1.18e+04  2.55e+20
    4   15  1.69e+04  3.24e-12  1.69e+04  7.17e+20
    4   16  2.38e+04  2.96e-12  2.38e+04  1.73e+21
    4   17  3.29e+04  5.55e-12  3.29e+04  1.23e+21
    4   18  4.47e+04  6.45e-12  4.47e+04  1.93e+21
    4   19  5.99e+04  8.79e-12  5.99e+04  2.92e+21
    4   20  7.91e+04  3.02e-11  7.91e+04  7.07e+21
    5   0   1.11e-16  1.00e+00  1.00e+00  1.00e+00
    5   1   2.98e-01  8.06e-01  1.30e+00  1.61e+00
    5   2   1.18e+00  4.79e-01  2.18e+00  4.54e+00
    5   3   5.28e+00  6.72e-02  6.28e+00  9.35e+01
    5   4   1.66e+01  3.46e-17  1.76e+01  5.86e+16
    5   5   4.22e+01  3.04e-15  4.32e+01  3.37e+18
    5   6   9.37e+01  5.14e-15  9.47e+01  7.74e+19
    5   7   1.89e+02  1.28e-14  1.90e+02  3.15e+18
    5   8   3.55e+02  2.99e-14  3.56e+02  8.77e+18
    5   9   6.27e+02  3.41e-14  6.28e+02  1.95e+19
    5   10  1.05e+03  1.40e-13  1.05e+03  6.68e+19
    5   11  1.70e+03  2.76e-13  1.70e+03  1.81e+20
    5   12  2.65e+03  3.06e-13  2.65e+03  2.65e+20
    5   13  4.00e+03  4.27e-13  4.00e+03  1.47e+20
    5   14  5.88e+03  1.01e-12  5.88e+03  2.84e+20
    5   15  8.45e+03  1.25e-12  8.45e+03  1.50e+20
    5   16  1.19e+04  1.55e-12  1.19e+04  2.74e+20
    5   17  1.64e+04  3.98e-12  1.64e+04  2.67e+20
    5   18  2.24e+04  6.34e-12  2.24e+04  6.32e+20
    5   19  2.99e+04  7.76e-12  2.99e+04  5.40e+20
    5   20  3.96e+04  1.37e-11  3.96e+04  1.05e+21
    6   0   4.44e-16  1.00e+00  1.00e+00  1.00e+00
    6   1   1.46e-01  8.84e-01  1.15e+00  1.30e+00
    6   2   5.29e-01  6.88e-01  1.53e+00  2.22e+00
    6   3   2.47e+00  3.07e-01  3.47e+00  1.13e+01
    6   4   7.96e+00  5.03e-02  8.96e+00  1.78e+02
    6   5   2.08e+01  1.64e-03  2.18e+01  1.33e+04
    6   6   4.66e+01  8.60e-16  4.76e+01  5.16e+18
    6   7   9.43e+01  2.96e-15  9.53e+01  2.36e+19
    6   8   1.77e+02  7.12e-15  1.78e+02  2.21e+19
    6   9   3.13e+02  2.73e-14  3.14e+02  7.41e+19
    6   10  5.27e+02  2.48e-14  5.28e+02  2.07e+19
    6   11  8.49e+02  7.52e-14  8.50e+02  1.02e+20
    6   12  1.32e+03  2.93e-13  1.32e+03  1.54e+20
    6   13  2.00e+03  2.71e-13  2.00e+03  5.02e+19
    6   14  2.94e+03  6.64e-13  2.94e+03  1.14e+20
    6   15  4.23e+03  1.02e-12  4.23e+03  7.75e+20
    6   16  5.95e+03  1.04e-12  5.95e+03  1.23e+21
    6   17  8.22e+03  1.11e-12  8.22e+03  5.26e+20
    6   18  1.12e+04  1.99e-12  1.12e+04  2.89e+21
    6   19  1.50e+04  2.35e-12  1.50e+04  6.91e+20
    6   20  1.98e+04  6.04e-12  1.98e+04  1.13e+23
    7   0   4.44e-16  1.00e+00  1.00e+00  1.00e+00
    7   1   6.53e-02  9.41e-01  1.07e+00  1.13e+00
    7   2   2.34e-01  8.42e-01  1.23e+00  1.47e+00
    7   3   1.02e+00  5.73e-01  2.02e+00  3.53e+00
    7   4   3.63e+00  2.73e-01  4.63e+00  1.70e+01
    7   5   1.00e+01  7.78e-02  1.10e+01  1.42e+02
    7   6   2.30e+01  8.51e-03  2.40e+01  2.82e+03
    7   7   4.68e+01  8.51e-05  4.78e+01  5.62e+05
    7   8   8.82e+01  1.80e-15  8.92e+01  3.34e+18
    7   9   1.56e+02  6.70e-15  1.57e+02  6.13e+19
    7   10  2.63e+02  1.11e-14  2.64e+02  5.15e+19
    7   11  4.24e+02  3.38e-14  4.25e+02  6.66e+19
    7   12  6.61e+02  7.30e-14  6.62e+02  6.32e+19
    7   13  9.99e+02  1.05e-13  1.00e+03  4.61e+19
    7   14  1.47e+03  1.69e-13  1.47e+03  7.55e+19
    7   15  2.11e+03  2.53e-13  2.11e+03  1.86e+20
    7   16  2.97e+03  4.54e-13  2.98e+03  2.93e+21
    7   17  4.11e+03  7.55e-13  4.11e+03  2.95e+20
    7   18  5.59e+03  7.97e-13  5.59e+03  7.02e+21
    7   19  7.49e+03  1.71e-12  7.49e+03  3.39e+20
    7   20  9.89e+03  2.15e-12  9.89e+03  3.27e+21
    8   0   2.22e-16  1.00e+00  1.00e+00  1.00e+00
    8   1   3.68e-02  9.68e-01  1.04e+00  1.07e+00
    8   2   9.82e-02  9.07e-01  1.10e+00  1.21e+00
    8   3   4.11e-01  7.20e-01  1.41e+00  1.96e+00
    8   4   1.63e+00  4.74e-01  2.63e+00  5.54e+00
    8   5   4.73e+00  2.36e-01  5.73e+00  2.43e+01
    8   6   1.12e+01  8.06e-02  1.22e+01  1.51e+02
    8   7   2.31e+01  1.96e-02  2.41e+01  1.23e+03
    8   8   4.38e+01  2.64e-03  4.48e+01  1.70e+04
    8   9   7.78e+01  4.91e-05  7.88e+01  1.60e+06
    8   10  1.31e+02  9.41e-16  1.32e+02  7.18e+18
    8   11  2.12e+02  7.86e-15  2.13e+02  9.52e+19
    8   12  3.30e+02  1.27e-14  3.31e+02  2.36e+19
    8   13  4.99e+02  2.89e-14  5.00e+02  5.55e+20
    8   14  7.35e+02  1.01e-13  7.36e+02  6.04e+19
    8   15  1.06e+03  2.09e-13  1.06e+03  1.39e+20
    8   16  1.49e+03  1.59e-13  1.49e+03  1.59e+20
    8   17  2.06e+03  5.25e-13  2.06e+03  3.27e+20
    8   18  2.79e+03  4.89e-13  2.80e+03  3.10e+20
    8   19  3.74e+03  6.52e-13  3.74e+03  4.62e+20
    8   20  4.95e+03  1.55e-12  4.95e+03  1.60e+22
    9   0   1.11e-16  1.00e+00  1.00e+00  1.00e+00
    9   1   2.05e-02  9.83e-01  1.02e+00  1.04e+00
    9   2   4.40e-02  9.65e-01  1.04e+00  1.08e+00
    9   3   1.80e-01  8.66e-01  1.18e+00  1.36e+00
    9   4   7.25e-01  6.61e-01  1.72e+00  2.61e+00
    9   5   2.18e+00  4.24e-01  3.18e+00  7.50e+00
    9   6   5.27e+00  2.28e-01  6.27e+00  2.75e+01
    9   7   1.12e+01  8.76e-02  1.22e+01  1.39e+02
    9   8   2.16e+01  2.65e-02  2.26e+01  8.52e+02
    9   9   3.87e+01  6.85e-03  3.97e+01  5.79e+03
    9   10  6.53e+01  1.06e-03  6.63e+01  6.26e+04
    9   11  1.06e+02  7.07e-05  1.07e+02  1.51e+06
    9   12  1.65e+02  1.56e-06  1.66e+02  1.06e+08
    9   13  2.49e+02  1.35e-15  2.50e+02  2.68e+19
    9   14  3.67e+02  5.31e-15  3.68e+02  3.30e+19
    9   15  5.28e+02  1.56e-14  5.29e+02  5.48e+19
    9   16  7.43e+02  4.36e-14  7.44e+02  5.69e+19
    9   17  1.03e+03  8.44e-14  1.03e+03  3.74e+21
    9   18  1.40e+03  1.29e-13  1.40e+03  2.85e+20
    9   19  1.87e+03  1.79e-13  1.87e+03  4.09e+20
    9   20  2.47e+03  1.17e-12  2.47e+03  2.68e+21
    10  0   1.11e-16  1.00e+00  1.00e+00  1.00e+00
    10  1   1.06e-02  9.89e-01  1.01e+00  1.02e+00
    10  2   2.70e-02  9.73e-01  1.03e+00  1.05e+00
    10  3   9.27e-02  9.23e-01  1.09e+00  1.18e+00
    10  4   3.29e-01  8.37e-01  1.33e+00  1.59e+00
    10  5   9.96e-01  7.16e-01  2.00e+00  2.79e+00
    10  6   2.48e+00  5.60e-01  3.48e+00  6.21e+00
    10  7   5.38e+00  3.68e-01  6.38e+00  1.73e+01
    10  8   1.05e+01  1.79e-01  1.15e+01  6.44e+01
    10  9   1.90e+01  6.83e-02  2.00e+01  2.93e+02
    10  10  3.22e+01  2.17e-02  3.32e+01  1.53e+03
    10  11  5.24e+01  5.61e-03  5.34e+01  9.52e+03
    10  12  8.20e+01  1.05e-03  8.30e+01  7.92e+04
    10  13  1.24e+02  1.51e-04  1.25e+02  8.28e+05
    10  14  1.83e+02  1.34e-05  1.84e+02  1.37e+07
    10  15  2.63e+02  6.50e-07  2.64e+02  4.07e+08
    10  16  3.71e+02  3.18e-09  3.72e+02  1.17e+11
    10  17  5.13e+02  2.67e-15  5.14e+02  5.87e+19
    10  18  6.98e+02  6.91e-15  6.99e+02  7.17e+19
    10  19  9.35e+02  2.65e-14  9.36e+02  1.48e+20
    10  20  1.24e+03  3.30e-13  1.24e+03  6.67e+20
    11  0   1.11e-16  1.00e+00  1.00e+00  1.00e+00
    11  1   5.93e-03  9.94e-01  1.01e+00  1.01e+00
    11  2   1.40e-02  9.87e-01  1.01e+00  1.03e+00
    11  3   4.56e-02  9.55e-01  1.05e+00  1.09e+00
    11  4   1.41e-01  8.97e-01  1.14e+00  1.27e+00
    11  5   4.25e-01  8.00e-01  1.43e+00  1.78e+00
    11  6   1.10e+00  6.31e-01  2.10e+00  3.32e+00
    11  7   2.46e+00  4.33e-01  3.46e+00  8.00e+00
    11  8   4.96e+00  2.61e-01  5.96e+00  2.29e+01
    11  9   9.15e+00  1.39e-01  1.02e+01  7.28e+01
    11  10  1.58e+01  5.85e-02  1.68e+01  2.87e+02
    11  11  2.59e+01  2.07e-02  2.69e+01  1.30e+03
    11  12  4.07e+01  6.68e-03  4.17e+01  6.24e+03
    11  13  6.18e+01  2.21e-03  6.28e+01  2.84e+04
    11  14  9.12e+01  6.29e-04  9.22e+01  1.46e+05
    11  15  1.31e+02  1.23e-04  1.32e+02  1.07e+06
    11  16  1.85e+02  1.85e-05  1.86e+02  1.01e+07
    11  17  2.56e+02  2.11e-06  2.57e+02  1.22e+08
    11  18  3.49e+02  1.94e-07  3.50e+02  1.80e+09
    11  19  4.67e+02  1.23e-08  4.68e+02  3.81e+10
    11  20  6.18e+02  2.97e-10  6.19e+02  2.08e+12
    12  0   1.11e-16  1.00e+00  1.00e+00  1.00e+00
    12  1   3.49e-03  9.97e-01  1.00e+00  1.01e+00
    12  2   9.34e-03  9.92e-01  1.01e+00  1.02e+00
    12  3   2.73e-02  9.77e-01  1.03e+00  1.05e+00
    12  4   7.95e-02  9.33e-01  1.08e+00  1.16e+00
    12  5   2.13e-01  8.52e-01  1.21e+00  1.42e+00
    12  6   5.06e-01  7.33e-01  1.51e+00  2.05e+00
    12  7   1.11e+00  5.81e-01  2.11e+00  3.64e+00
    12  8   2.28e+00  4.09e-01  3.28e+00  8.01e+00
    12  9   4.30e+00  2.61e-01  5.30e+00  2.03e+01
    12  10  7.58e+00  1.56e-01  8.58e+00  5.51e+01
    12  11  1.26e+01  8.49e-02  1.36e+01  1.61e+02
    12  12  2.01e+01  4.11e-02  2.11e+01  5.12e+02
    12  13  3.07e+01  1.87e-02  3.17e+01  1.69e+03
    12  14  4.54e+01  7.50e-03  4.64e+01  6.18e+03
    12  15  6.54e+01  2.56e-03  6.64e+01  2.59e+04
    12  16  9.23e+01  7.53e-04  9.33e+01  1.24e+05
    12  17  1.28e+02  2.02e-04  1.29e+02  6.36e+05
    12  18  1.74e+02  5.26e-05  1.75e+02  3.33e+06
    12  19  2.33e+02  1.28e-05  2.34e+02  1.84e+07
    12  20  3.08e+02  2.85e-06  3.09e+02  1.08e+08
    13  0   1.11e-16  1.00e+00  1.00e+00  1.00e+00
    13  1   2.01e-03  9.98e-01  1.00e+00  1.00e+00
    13  2   4.72e-03  9.96e-01  1.00e+00  1.01e+00
    13  3   1.43e-02  9.89e-01  1.01e+00  1.03e+00
    13  4   3.98e-02  9.77e-01  1.04e+00  1.06e+00
    13  5   9.89e-02  9.54e-01  1.10e+00  1.15e+00
    13  6   2.27e-01  8.94e-01  1.23e+00  1.37e+00
    13  7   4.91e-01  8.01e-01  1.49e+00  1.86e+00
    13  8   1.00e+00  6.87e-01  2.00e+00  2.91e+00
    13  9   1.93e+00  5.70e-01  2.93e+00  5.14e+00
    13  10  3.49e+00  4.55e-01  4.49e+00  9.86e+00
    13  11  5.98e+00  3.37e-01  6.98e+00  2.07e+01
    13  12  9.69e+00  2.25e-01  1.07e+01  4.75e+01
    13  13  1.50e+01  1.36e-01  1.60e+01  1.18e+02
    13  14  2.24e+01  7.35e-02  2.34e+01  3.18e+02
    13  15  3.24e+01  3.62e-02  3.34e+01  9.23e+02
    13  16  4.58e+01  1.46e-02  4.68e+01  3.21e+03
    13  17  6.35e+01  5.79e-03  6.45e+01  1.11e+04
    13  18  8.66e+01  2.23e-03  8.76e+01  3.94e+04
    13  19  1.16e+02  7.67e-04  1.17e+02  1.53e+05
    13  20  1.54e+02  2.29e-04  1.55e+02  6.76e+05
    14  0   1.11e-16  1.00e+00  1.00e+00  1.00e+00
    14  1   8.85e-04  9.99e-01  1.00e+00  1.00e+00
    14  2   2.20e-03  9.98e-01  1.00e+00  1.00e+00
    14  3   6.74e-03  9.96e-01  1.01e+00  1.01e+00
    14  4   1.79e-02  9.89e-01  1.02e+00  1.03e+00
    14  5   4.47e-02  9.74e-01  1.04e+00  1.07e+00
    14  6   1.09e-01  9.40e-01  1.11e+00  1.18e+00
    14  7   2.45e-01  8.73e-01  1.25e+00  1.43e+00
    14  8   4.98e-01  7.70e-01  1.50e+00  1.95e+00
    14  9   9.40e-01  6.35e-01  1.94e+00  3.06e+00
    14  10  1.67e+00  4.89e-01  2.67e+00  5.47e+00
    14  11  2.85e+00  3.53e-01  3.85e+00  1.09e+01
    14  12  4.63e+00  2.40e-01  5.63e+00  2.35e+01
    14  13  7.23e+00  1.55e-01  8.23e+00  5.31e+01
    14  14  1.09e+01  9.53e-02  1.19e+01  1.25e+02
    14  15  1.59e+01  5.72e-02  1.69e+01  2.95e+02
    14  16  2.26e+01  3.32e-02  2.36e+01  7.11e+02
    14  17  3.14e+01  1.82e-02  3.24e+01  1.79e+03
    14  18  4.30e+01  9.08e-03  4.40e+01  4.84e+03
    14  19  5.78e+01  4.11e-03  5.88e+01  1.43e+04
    14  20  7.66e+01  1.79e-03  7.76e+01  4.33e+04
    15  0   1.11e-16  1.00e+00  1.00e+00  1.00e+00
    15  1   4.56e-04  1.00e+00  1.00e+00  1.00e+00
    15  2   1.30e-03  9.99e-01  1.00e+00  1.00e+00
    15  3   3.68e-03  9.98e-01  1.00e+00  1.01e+00
    15  4   1.01e-02  9.93e-01  1.01e+00  1.02e+00
    15  5   2.68e-02  9.80e-01  1.03e+00  1.05e+00
    15  6   6.21e-02  9.57e-01  1.06e+00  1.11e+00
    15  7   1.27e-01  9.20e-01  1.13e+00  1.23e+00
    15  8   2.44e-01  8.70e-01  1.24e+00  1.43e+00
    15  9   4.48e-01  8.09e-01  1.45e+00  1.79e+00
    15  10  7.93e-01  7.37e-01  1.79e+00  2.43e+00
    15  11  1.35e+00  6.59e-01  2.35e+00  3.56e+00
    15  12  2.21e+00  5.83e-01  3.21e+00  5.50e+00
    15  13  3.47e+00  5.09e-01  4.47e+00  8.77e+00
    15  14  5.25e+00  4.06e-01  6.25e+00  1.54e+01
    15  15  7.70e+00  3.00e-01  8.70e+00  2.90e+01
    15  16  1.10e+01  2.09e-01  1.20e+01  5.76e+01
    15  17  1.54e+01  1.33e-01  1.64e+01  1.23e+02
    15  18  2.12e+01  7.77e-02  2.22e+01  2.85e+02
    15  19  2.86e+01  4.18e-02  2.96e+01  7.07e+02
    15  20  3.80e+01  2.12e-02  3.90e+01  1.84e+03
    16  0   1.11e-16  1.00e+00  1.00e+00  1.00e+00
    16  1   2.24e-04  1.00e+00  1.00e+00  1.00e+00
    16  2   5.33e-04  1.00e+00  1.00e+00  1.00e+00
    16  3   1.40e-03  9.99e-01  1.00e+00  1.00e+00
    16  4   4.47e-03  9.97e-01  1.00e+00  1.01e+00
    16  5   1.28e-02  9.92e-01  1.01e+00  1.02e+00
    16  6   3.16e-02  9.81e-01  1.03e+00  1.05e+00
    16  7   6.78e-02  9.59e-01  1.07e+00  1.11e+00
    16  8   1.31e-01  9.23e-01  1.13e+00  1.23e+00
    16  9   2.35e-01  8.71e-01  1.24e+00  1.42e+00
    16  10  4.00e-01  8.04e-01  1.40e+00  1.74e+00
    16  11  6.55e-01  7.27e-01  1.66e+00  2.28e+00
    16  12  1.04e+00  6.43e-01  2.04e+00  3.17e+00
    16  13  1.61e+00  5.54e-01  2.61e+00  4.70e+00
    16  14  2.42e+00  4.65e-01  3.42e+00  7.36e+00
    16  15  3.58e+00  3.77e-01  4.58e+00  1.22e+01
    16  16  5.19e+00  2.93e-01  6.19e+00  2.11e+01
    16  17  7.36e+00  2.17e-01  8.36e+00  3.85e+01
    16  18  1.02e+01  1.54e-01  1.12e+01  7.29e+01
    16  19  1.40e+01  1.05e-01  1.50e+01  1.43e+02
    16  20  1.87e+01  6.43e-02  1.97e+01  3.07e+02
    17  0   1.11e-16  1.00e+00  1.00e+00  1.00e+00
    17  1   1.30e-04  1.00e+00  1.00e+00  1.00e+00
    17  2   2.78e-04  1.00e+00  1.00e+00  1.00e+00
    17  3   8.84e-04  9.99e-01  1.00e+00  1.00e+00
    17  4   2.51e-03  9.98e-01  1.00e+00  1.00e+00
    17  5   6.19e-03  9.96e-01  1.01e+00  1.01e+00
    17  6   1.41e-02  9.91e-01  1.01e+00  1.02e+00
    17  7   2.98e-02  9.82e-01  1.03e+00  1.05e+00
    17  8   5.80e-02  9.67e-01  1.06e+00  1.09e+00
    17  9   1.03e-01  9.45e-01  1.10e+00  1.17e+00
    17  10  1.71e-01  9.14e-01  1.17e+00  1.28e+00
    17  11  2.79e-01  8.72e-01  1.28e+00  1.47e+00
    17  12  4.45e-01  8.18e-01  1.44e+00  1.76e+00
    17  13  6.96e-01  7.52e-01  1.70e+00  2.25e+00
    17  14  1.07e+00  6.73e-01  2.07e+00  3.07e+00
    17  15  1.61e+00  5.84e-01  2.61e+00  4.47e+00
    17  16  2.37e+00  4.90e-01  3.37e+00  6.87e+00
    17  17  3.42e+00  3.98e-01  4.42e+00  1.11e+01
    17  18  4.82e+00  3.14e-01  5.82e+00  1.85e+01
    17  19  6.66e+00  2.41e-01  7.66e+00  3.18e+01
    17  20  9.02e+00  1.81e-01  1.00e+01  5.53e+01
    18  0   1.11e-16  1.00e+00  1.00e+00  1.00e+00
    18  1   6.70e-05  1.00e+00  1.00e+00  1.00e+00
    18  2   1.50e-04  1.00e+00  1.00e+00  1.00e+00
    18  3   4.31e-04  1.00e+00  1.00e+00  1.00e+00
    18  4   1.10e-03  9.99e-01  1.00e+00  1.00e+00
    18  5   2.50e-03  9.98e-01  1.00e+00  1.00e+00
    18  6   6.10e-03  9.96e-01  1.01e+00  1.01e+00
    18  7   1.35e-02  9.91e-01  1.01e+00  1.02e+00
    18  8   2.72e-02  9.84e-01  1.03e+00  1.04e+00
    18  9   5.00e-02  9.74e-01  1.05e+00  1.08e+00
    18  10  8.53e-02  9.58e-01  1.09e+00  1.13e+00
    18  11  1.39e-01  9.37e-01  1.14e+00  1.22e+00
    18  12  2.17e-01  9.09e-01  1.22e+00  1.34e+00
    18  13  3.31e-01  8.74e-01  1.33e+00  1.52e+00
    18  14  4.97e-01  8.17e-01  1.50e+00  1.83e+00
    18  15  7.39e-01  7.45e-01  1.74e+00  2.33e+00
    18  16  1.08e+00  6.61e-01  2.08e+00  3.15e+00
    18  17  1.57e+00  5.73e-01  2.57e+00  4.49e+00
    18  18  2.23e+00  4.84e-01  3.23e+00  6.67e+00
    18  19  3.11e+00  4.00e-01  4.11e+00  1.03e+01
    18  20  4.25e+00  3.22e-01  5.25e+00  1.63e+01
    19  0   1.11e-16  1.00e+00  1.00e+00  1.00e+00
    19  1   3.61e-05  1.00e+00  1.00e+00  1.00e+00
    19  2   8.99e-05  1.00e+00  1.00e+00  1.00e+00
    19  3   2.21e-04  1.00e+00  1.00e+00  1.00e+00
    19  4   6.39e-04  9.99e-01  1.00e+00  1.00e+00
    19  5   1.66e-03  9.98e-01  1.00e+00  1.00e+00
    19  6   3.59e-03  9.96e-01  1.00e+00  1.01e+00
    19  7   7.66e-03  9.93e-01  1.01e+00  1.01e+00
    19  8   1.52e-02  9.87e-01  1.02e+00  1.03e+00
    19  9   2.77e-02  9.79e-01  1.03e+00  1.05e+00
    19  10  4.73e-02  9.67e-01  1.05e+00  1.08e+00
    19  11  7.71e-02  9.50e-01  1.08e+00  1.13e+00
    19  12  1.21e-01  9.28e-01  1.12e+00  1.21e+00
    19  13  1.86e-01  8.98e-01  1.19e+00  1.32e+00
    19  14  2.81e-01  8.62e-01  1.28e+00  1.49e+00
    19  15  4.14e-01  8.19e-01  1.41e+00  1.73e+00
    19  16  6.00e-01  7.68e-01  1.60e+00  2.08e+00
    19  17  8.52e-01  7.09e-01  1.85e+00  2.61e+00
    19  18  1.19e+00  6.43e-01  2.19e+00  3.40e+00
    19  19  1.62e+00  5.73e-01  2.62e+00  4.57e+00
    19  20  2.18e+00  5.02e-01  3.18e+00  6.34e+00
    20  0   1.11e-16  1.00e+00  1.00e+00  1.00e+00
    20  1   1.91e-05  1.00e+00  1.00e+00  1.00e+00
    20  2   4.49e-05  1.00e+00  1.00e+00  1.00e+00
    20  3   1.08e-04  1.00e+00  1.00e+00  1.00e+00
    20  4   2.89e-04  1.00e+00  1.00e+00  1.00e+00
    20  5   7.57e-04  9.99e-01  1.00e+00  1.00e+00
    20  6   1.80e-03  9.99e-01  1.00e+00  1.00e+00
    20  7   3.74e-03  9.98e-01  1.00e+00  1.01e+00
    20  8   7.01e-03  9.96e-01  1.01e+00  1.01e+00
    20  9   1.23e-02  9.93e-01  1.01e+00  1.02e+00
    20  10  2.05e-02  9.88e-01  1.02e+00  1.03e+00
    20  11  3.30e-02  9.81e-01  1.03e+00  1.05e+00
    20  12  5.14e-02  9.71e-01  1.05e+00  1.08e+00
    20  13  7.77e-02  9.58e-01  1.08e+00  1.12e+00
    20  14  1.15e-01  9.41e-01  1.11e+00  1.18e+00
    20  15  1.66e-01  9.21e-01  1.17e+00  1.27e+00
    20  16  2.38e-01  8.95e-01  1.24e+00  1.38e+00
    20  17  3.37e-01  8.65e-01  1.34e+00  1.55e+00
    20  18  4.73e-01  8.28e-01  1.47e+00  1.78e+00
    20  19  6.58e-01  7.85e-01  1.66e+00  2.11e+00
    20  20  9.04e-01  7.36e-01  1.90e+00  2.59e+00
    ];