function G=compute_GRAM(V,w)

%--------------------------------------------------------------------------
% INPUT:
%--------------------------------------------------------------------------
% V : Vandermonde matrix w.r.t an orthonormal basis in the domain,
%     evaluated at the cubature nodes;
% w : cubature weights.
%--------------------------------------------------------------------------
% OUTPUT:
%--------------------------------------------------------------------------
% G: discrete Gram matrix, whose scalar product is defined by a rule
%    satisfying Marcinkiewicz-Zygmund property.
%--------------------------------------------------------------------------

dimP=size(V,1);

G=zeros(dimP,dimP);

% Evaluate numerically "I(phi_i*phi_j)" when "i >= j", by the rule.

for i=1:dimP
    for j=1:i
        G(i,j)=(V(i,:).*V(j,:))*w;
    end
end

GL=tril(G,-1);
G=G+GL';