function [ETA,G,E,A,B]=compute_MZ_constant(V,w)

%--------------------------------------------------------------------------
% INPUT:
%--------------------------------------------------------------------------
% V : Vandermonde matrix w.r.t an orthonormal basis in the domain,
%     evaluated at the cubature nodes;
% w : cubature weights.
%--------------------------------------------------------------------------
% OUTPUT:
%--------------------------------------------------------------------------
% ETA: Marcinkiewicz-Zygmund constants of the quadrature rule at
%     degree "n".
%--------------------------------------------------------------------------

G=compute_GRAM(V,w);

E=eye(size(G))-G;
ETA=norm(E);

if nargout > 3
    if sum(isnan(G)) == 0
        lambda=eig(G);
        A=min(lambda);
        B=max(lambda);
    else
        A=eps;
        B=1/eps;
    end
    A=abs(A); % there are negative A with A is close to machine precision.
end


