
function MZ_extrema=compute_MZ_extrema(V,w)

%--------------------------------------------------------------------------
% INPUT:
%--------------------------------------------------------------------------
% V : Vandermonde matrix w.r.t an orthonormal basis in the domain,
%     evaluated at the cubature nodes;
% w : cubature weights.
%--------------------------------------------------------------------------
% OUTPUT:
%--------------------------------------------------------------------------
% MZ_constant: Marcinkiewicz-Zygmund constants of the quadrature rule at
%     degree "n".
%--------------------------------------------------------------------------

dimP=size(V,1);

S=zeros(dimP,dimP);

% Evaluate numerically "I(phi_i*phi_j)" when "i >= j", by the rule.

for i=1:dimP
    for j=1:i
        S(i,j)=(V(i,:).*V(j,:))*w;
    end
end

SL=tril(S,-1);
S=S+SL';

if sum(isnan(S)) == 0
    lambda=eig(S);
    MZ_extrema=[min(lambda) max(lambda)];
else
    MZ_extrema=[NaN NaN];
end

