
function rule=cub_cube_QMC(card,dbox,dim)

%--------------------------------------------------------------------------
% OBJECT:
%--------------------------------------------------------------------------
% QMC rule on the cube [a,b] x [c,d] x [e,f], with cardinality "card".
% The variable "dbox" is a 2 x 3 matrix of the form "[a c e; b d f]".
%
% The QMC rule is based on "haltonset" and the pertinent Matlab toolbox
% must be available.
%
% The code is immediatly at hand for hyperrectangles, changing the variable 
% "dim" (see input variable).
%--------------------------------------------------------------------------
% Related paper:
%--------------------------------------------------------------------------
% ""
% A. Sommariva and M. Vianello
%--------------------------------------------------------------------------
% Tests.
%--------------------------------------------------------------------------
% Tested on Matlab R2024B, on a PC running Intel(R) N150 (800 MHz) with 16
% GB of RAM.
%--------------------------------------------------------------------------
% License:
%--------------------------------------------------------------------------
% Copyright (C) 2025 Alvise Sommariva, Marco Vianello.
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
%
% Authors:
%
% Alvise Sommariva <alvise@math.unipd.it>
% Marco Vianello   <marcov@math.unipd.it>
%
% Date: December 16, 2025
%--------------------------------------------------------------------------

if nargin < 1, card=100000; end
if nargin < 3, dim=3; end
if nargin < 2, dbox=[zeros(1,dim); ones(1,dim)]; end

P=haltonset(dim);

rule=ones(card,dim+1);
rule(:,1:end-1)=P(1:card,:);

for k=1:dim
    a=dbox(1,k); b=dbox(2,k); t=rule(:,k);
    rule(:,k)=a+t*(b-a);
end

jc=prod(dbox(2,:)-dbox(1,:));
rule(:,dim+1)=jc*rule(:,dim+1)/card;