
function [XYW,XYW_bar]=cub_triangle_lowcard(deg)

% ..................................................
% OBJECT:
% ..................................................
% Algebraic rules on the simplex X>=0,Y>=0,X+Y<=1.
% The rules have the lowest known cardinality
% for a fixed degree algebraic degree of precision
% ..................................................
% INPUT:
% ..................................................
% deg: algebraic degree of precision of the rule.
% ..................................................
% OUTPUT:
% ..................................................
% XYW: MATRIX OF NODES XYW(:,1:2) AND WEIGHTS XYW(:,3).
%      REMARK: The sum of the weights makes 1/2.
% XYW_bar: MATRIX OF BARYCENTRIC NODES XYW(:,1:3) AND WEIGHTS XYW(:,4).
%      REMARK: The sum of the weights makes 1.
% ..................................................

% ..................................................
% deg | card  | ptsout| neg w |  momerr   |
% ..................................................
%   1 |     1 |     0 |     0 |  1.92e-16 |
%   2 |     3 |     0 |     0 |  1.18e-16 |
%   3 |     4 |     0 |     0 |  2.22e-16 |
%   4 |     6 |     0 |     0 |  1.39e-16 |
%   5 |     7 |     0 |     0 |  1.53e-16 |
%   6 |    11 |     0 |     0 |  1.08e-15 |
%   7 |    12 |     0 |     0 |  4.86e-16 |
%   8 |    16 |     0 |     0 |  7.29e-16 |
%   9 |    19 |     0 |     0 |  3.33e-16 |
%  10 |    24 |     0 |     0 |  7.22e-16 |
%  11 |    27 |     0 |     0 |  3.62e-15 |
%  12 |    32 |     0 |     0 |  1.61e-15 |
%  13 |    36 |     0 |     0 |  3.05e-16 |
%  14 |    42 |     0 |     0 |  4.68e-16 |
%  15 |    46 |     0 |     0 |  5.07e-16 |
%  16 |    52 |     0 |     0 |  5.69e-16 |
%  17 |    57 |     0 |     0 |  5.83e-16 |
%  18 |    66 |     0 |     0 |  5.90e-16 |
%  19 |    70 |     0 |     0 |  4.44e-16 |
%  20 |    78 |     0 |     0 |  4.93e-16 |
%  21 |    85 |     0 |     0 |  4.54e-16 |
%  22 |    93 |     0 |     0 |  7.29e-16 |
%  23 |   100 |     0 |     0 |  6.43e-16 |
%  24 |   109 |     0 |     0 |  7.91e-16 |
%  25 |   117 |     0 |     0 |  5.41e-16 |
%  26 |   130 |     0 |     0 |  1.97e-15 |
%  27 |   139 |     0 |     0 |  2.00e-13 |
%  28 |   148 |     0 |     0 |  7.27e-16 |
%  29 |   158 |     0 |     0 |  8.12e-16 |
%  30 |   168 |     0 |     0 |  1.88e-15 |
%  31 |   178 |     0 |     0 |  6.73e-16 |
%  32 |   189 |     0 |     0 |  7.42e-16 |
%  33 |   200 |     0 |     0 |  2.60e-15 |
%  34 |   214 |     0 |     0 |  1.86e-15 |
%  35 |   224 |     0 |     0 |  7.56e-16 |
%  36 |   237 |     0 |     0 |  1.03e-15 |
%  37 |   250 |     0 |     0 |  1.05e-13 |
%  38 |   263 |     0 |     0 |  8.33e-16 |
%  39 |   276 |     0 |     0 |  9.12e-16 |
%  40 |   289 |     0 |     0 |  9.06e-16 |
%  41 |   303 |     0 |     0 |  9.97e-15 |
%  42 |   319 |     0 |     0 |  8.92e-16 |
%  43 |   334 |     0 |     0 |  1.28e-15 |
%  44 |   349 |     0 |     0 |  8.51e-16 |
%  45 |   363 |     0 |     0 |  9.09e-16 |
%  46 |   380 |     0 |     0 |  9.40e-16 |
%  47 |   394 |     0 |     0 |  8.99e-16 |
%  48 |   414 |     0 |     0 |  1.15e-15 |
%  49 |   428 |     0 |     0 |  3.03e-15 |
%  50 |   447 |     0 |     0 |  8.33e-16 |
% ..................................................



switch deg

    case  {0,1}

        % SET: OTHER RULES
        % CARDINALITY RULE  :      1
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 1.923e-16

        XYW=[
    	 	 3.3333333333333331e-01 3.3333333333333331e-01 5.0000000000000000e-01
     	 	 ];


    case  2

        % SET: OTHER RULES
        % CARDINALITY RULE  :      3
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 1.180e-16

        XYW=[
    	 	 6.6666666666666663e-01 1.6666666666666669e-01 1.6666666666666666e-01
     	 	 1.6666666666666669e-01 6.6666666666666663e-01 1.6666666666666666e-01
     	 	 1.6666666666666669e-01 1.6666666666666669e-01 1.6666666666666666e-01
     	 	 ];


    case  3

        % SET: OTHER RULES
        % CARDINALITY RULE  :      4
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 2.220e-16

        XYW=[
    	 	 6.4494897427831777e-01 2.8001991549907412e-01 9.0979309128011387e-02
     	 	 1.5505102572168217e-01 6.6639024601470143e-01 1.5902069087198858e-01
     	 	 6.4494897427831777e-01 7.5031110222608111e-02 9.0979309128011387e-02
     	 	 1.5505102572168217e-01 1.7855872826361641e-01 1.5902069087198858e-01
     	 	 ];


    case  4

        % SET: OTHER RULES
        % CARDINALITY RULE  :      6
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 1.388e-16

        XYW=[
    	 	 4.4594849091596489e-01 4.4594849091596489e-01 1.1169079483900574e-01
     	 	 4.4594849091596489e-01 1.0810301816807022e-01 1.1169079483900574e-01
     	 	 1.0810301816807022e-01 4.4594849091596489e-01 1.1169079483900574e-01
     	 	 9.1576213509770743e-02 9.1576213509770743e-02 5.4975871827660935e-02
     	 	 9.1576213509770743e-02 8.1684757298045851e-01 5.4975871827660935e-02
     	 	 8.1684757298045851e-01 9.1576213509770743e-02 5.4975871827660935e-02
     	 	 ];


    case  5

        % SET: OTHER RULES
        % CARDINALITY RULE  :      7
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 1.527e-16

        XYW=[
    	 	 3.3333333333333331e-01 3.3333333333333331e-01 1.1250000000000000e-01
     	 	 7.9742698535308731e-01 1.0128650732345634e-01 6.2969590272413584e-02
     	 	 1.0128650732345634e-01 7.9742698535308731e-01 6.2969590272413584e-02
     	 	 1.0128650732345634e-01 1.0128650732345634e-01 6.2969590272413584e-02
     	 	 5.9715871789769781e-02 4.7014206410511511e-01 6.6197076394253082e-02
     	 	 4.7014206410511511e-01 5.9715871789769781e-02 6.6197076394253082e-02
     	 	 4.7014206410511511e-01 4.7014206410511511e-01 6.6197076394253082e-02
     	 	 ];


    case  6

        % SET: OTHER RULES
        % CARDINALITY RULE  :     11
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 1.082e-15

        XYW=[
    	 	 5.7254986677476860e-02 8.9549814678987949e-01 1.9034035926477798e-02
     	 	 8.9536264002457910e-01 6.1828221250321953e-02 1.9189677653876410e-02
     	 	 6.8447574845651404e-01 2.3343738497682731e-02 2.3100228372280918e-02
     	 	 6.8746255915029530e-02 6.0030275747263002e-02 2.6733794722099500e-02
     	 	 6.1567620557583957e-01 3.3346180834137717e-01 4.1877913482872842e-02
     	 	 6.2794614119778946e-01 1.5918918599215148e-01 5.0822416512758532e-02
     	 	 6.2909138341863569e-02 6.5529509370545247e-01 5.0930762230683477e-02
     	 	 6.8378211920509913e-02 3.0911768542826723e-01 5.5710915830000853e-02
     	 	 2.8752945837439225e-01 6.3642650917962018e-01 5.6004725131473032e-02
     	 	 3.2878355641313461e-01 7.7024005642463422e-02 6.2393785718779161e-02
     	 	 3.1229040501364480e-01 3.5234478644589950e-01 9.4201744418697414e-02
     	 	 ];


    case  7

        % SET: OTHER RULES
        % CARDINALITY RULE  :     12
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 4.857e-16

        XYW=[
    	 	 6.2382265094402145e-02 6.7517867073916063e-02 2.6517028157436263e-02
     	 	 6.7517867073916105e-02 8.7009986783168181e-01 2.6517028157436253e-02
     	 	 8.7009986783168169e-01 6.2382265094402138e-02 2.6517028157436267e-02
     	 	 5.5225456656926630e-02 3.2150249385198182e-01 4.3881408714446068e-02
     	 	 3.2150249385198176e-01 6.2327204949109161e-01 4.3881408714446062e-02
     	 	 6.2327204949109161e-01 5.5225456656926561e-02 4.3881408714446055e-02
     	 	 3.4324302945097168e-02 6.6094919618673564e-01 2.8775042784981605e-02
     	 	 6.6094919618673564e-01 3.0472650086816722e-01 2.8775042784981584e-02
     	 	 3.0472650086816716e-01 3.4324302945097120e-02 2.8775042784981567e-02
     	 	 5.1584233435359184e-01 2.7771616697639179e-01 6.7493187009802766e-02
     	 	 2.7771616697639179e-01 2.0644149867001638e-01 6.7493187009802766e-02
     	 	 2.0644149867001649e-01 5.1584233435359172e-01 6.7493187009802780e-02
     	 	 ];


    case  8

        % SET: OTHER RULES
        % CARDINALITY RULE  :     16
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 7.286e-16

        XYW=[
    	 	 3.3333333333333331e-01 3.3333333333333331e-01 7.2157803838893586e-02
     	 	 4.5929258829272313e-01 4.5929258829272313e-01 4.7545817133642310e-02
     	 	 4.5929258829272313e-01 8.1414823414553750e-02 4.7545817133642310e-02
     	 	 8.1414823414553750e-02 4.5929258829272313e-01 4.7545817133642310e-02
     	 	 1.7056930775176021e-01 1.7056930775176021e-01 5.1608685267359122e-02
     	 	 1.7056930775176021e-01 6.5886138449647957e-01 5.1608685267359122e-02
     	 	 6.5886138449647957e-01 1.7056930775176021e-01 5.1608685267359122e-02
     	 	 5.0547228317030957e-02 5.0547228317030957e-02 1.6229248811599040e-02
     	 	 5.0547228317030957e-02 8.9890554336593809e-01 1.6229248811599040e-02
     	 	 8.9890554336593809e-01 5.0547228317030957e-02 1.6229248811599040e-02
     	 	 8.3947774099575878e-03 2.6311282963463811e-01 1.3615157087217496e-02
     	 	 8.3947774099575878e-03 7.2849239295540436e-01 1.3615157087217496e-02
     	 	 2.6311282963463811e-01 8.3947774099575878e-03 1.3615157087217496e-02
     	 	 2.6311282963463811e-01 7.2849239295540436e-01 1.3615157087217496e-02
     	 	 7.2849239295540436e-01 8.3947774099575878e-03 1.3615157087217496e-02
     	 	 7.2849239295540436e-01 2.6311282963463811e-01 1.3615157087217496e-02
     	 	 ];


    case  9

        % SET: OTHER RULES
        % CARDINALITY RULE  :     19
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 3.331e-16

        XYW=[
    	 	 3.3333333333333331e-01 3.3333333333333331e-01 4.8567898141399432e-02
     	 	 4.3708959149293664e-01 4.3708959149293664e-01 3.8913770502387146e-02
     	 	 4.3708959149293664e-01 1.2582081701412673e-01 3.8913770502387146e-02
     	 	 1.2582081701412673e-01 4.3708959149293664e-01 3.8913770502387146e-02
     	 	 1.8820353561903275e-01 1.8820353561903275e-01 3.9823869463605131e-02
     	 	 1.8820353561903275e-01 6.2359292876193451e-01 3.9823869463605131e-02
     	 	 6.2359292876193451e-01 1.8820353561903275e-01 3.9823869463605131e-02
     	 	 4.8968251919873762e-01 4.8968251919873762e-01 1.5667350113569539e-02
     	 	 4.8968251919873762e-01 2.0634961602524760e-02 1.5667350113569539e-02
     	 	 2.0634961602524760e-02 4.8968251919873762e-01 1.5667350113569539e-02
     	 	 4.4729513394452691e-02 4.4729513394452691e-02 1.2788837829349019e-02
     	 	 4.4729513394452691e-02 9.1054097321109462e-01 1.2788837829349019e-02
     	 	 9.1054097321109462e-01 4.4729513394452691e-02 1.2788837829349019e-02
     	 	 3.6838412054736258e-02 2.2196298916076568e-01 2.1641769688644692e-02
     	 	 3.6838412054736258e-02 7.4119859878449801e-01 2.1641769688644692e-02
     	 	 2.2196298916076568e-01 3.6838412054736258e-02 2.1641769688644692e-02
     	 	 2.2196298916076568e-01 7.4119859878449801e-01 2.1641769688644692e-02
     	 	 7.4119859878449801e-01 3.6838412054736258e-02 2.1641769688644692e-02
     	 	 7.4119859878449801e-01 2.2196298916076568e-01 2.1641769688644692e-02
     	 	 ];


    case 10

        % SET: OTHER RULES
        % CARDINALITY RULE  :     24
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 7.216e-16

        XYW=[
    	 	 5.0550507373529086e-01 2.0776116575484826e-01 4.3362019313832358e-02
     	 	 2.7542385024412980e-01 4.8123289062464247e-01 4.7633278635674958e-02
     	 	 2.6481531651496770e-01 2.7586334089315967e-01 4.2207221279855038e-02
     	 	 7.5329402776254240e-01 1.0954959855585467e-01 2.6365190704419512e-02
     	 	 5.2433682558924433e-01 3.6419744430339263e-01 3.7039823668389919e-02
     	 	 2.9530445535851102e-01 6.4203365318662664e-01 2.7457802196927179e-02
     	 	 1.0614642990289996e-01 7.6777680170023954e-01 2.6268329551205831e-02
     	 	 6.3491832379200652e-01 3.6036266787907723e-02 2.1481164696039667e-02
     	 	 3.8729657913960353e-01 8.4198522115543739e-02 3.1343962650456809e-02
     	 	 1.6929927488966462e-01 1.0999439055630450e-01 2.8987070299349615e-02
     	 	 8.0491894656105567e-02 5.7966325105486349e-01 3.3093067237629940e-02
     	 	 9.5379208487721689e-02 3.3947290311800554e-01 3.0871122933097701e-02
     	 	 9.2899486985787905e-01 4.7768381772022417e-02 7.3041646115608446e-03
     	 	 7.4726591728868819e-01 2.2376358774275851e-01 1.6151301011728649e-02
     	 	 5.0365825075943971e-01 4.8798437805397499e-01 9.7797061087609525e-03
     	 	 1.6134650499890957e-01 8.3865349500109043e-01 5.5334733911235447e-03
     	 	 2.9553592846822851e-02 9.3049846900263089e-01 7.6015470130063531e-03
     	 	 8.6854386943076545e-01 3.8102570854643414e-03 5.3333456379562952e-03
     	 	 3.9366774470722010e-01 0.0000000000000000e+00 5.9501524071178015e-03
     	 	 1.7690730625559031e-01 1.0939142057119933e-02 7.4233118233402468e-03
     	 	 3.5319656252586096e-02 3.9099745550423282e-02 8.8279222964810968e-03
     	 	 0.0000000000000000e+00 7.7757518429429107e-01 6.6995403929284046e-03
     	 	 0.0000000000000000e+00 4.6374383867430541e-01 7.5781309587828393e-03
     	 	 3.0573404093099332e-02 1.9305903224251936e-01 1.5707351180334422e-02
     	 	 ];


    case 11

        % SET: OTHER RULES
        % CARDINALITY RULE  :     27
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 3.622e-15

        XYW=[
    	 	 4.6494564773693992e-01 2.9133859436942361e-01 3.4120689978745511e-02
     	 	 3.2081957909482994e-01 5.3634228112084714e-01 3.1096575055627428e-02
     	 	 5.1353143433447235e-01 1.2454405910544103e-01 2.8322942561349741e-02
     	 	 2.8790310224819649e-01 2.2789955884347501e-01 3.3071222942480626e-02
     	 	 2.6677168071577745e-01 4.1132499178904658e-01 2.9305884203704835e-02
     	 	 1.1698976413323442e-01 3.1909737814681871e-01 2.7495506358711192e-02
     	 	 8.1626233715968810e-01 2.7719522918618567e-02 1.1821029782882344e-02
     	 	 5.6938486195327997e-01 3.4992914334288650e-01 2.7485999004421856e-02
     	 	 3.7272769861629096e-01 5.9895439629934211e-01 1.6298436572453993e-02
     	 	 2.6807150626772580e-02 8.1562969693268217e-01 1.1556190176810534e-02
     	 	 7.0099267949645228e-01 1.4118119730952799e-01 2.6030267669060487e-02
     	 	 3.2719878157552895e-01 8.1721404855381763e-02 2.1298852449057631e-02
     	 	 1.3667083534390506e-01 1.3035453031942690e-01 2.2769129560075110e-02
     	 	 1.3828000204292318e-01 7.1027868107761583e-01 2.4595497454187269e-02
     	 	 2.2592651051306589e-02 3.8913981113319357e-01 1.3361393587366308e-02
     	 	 9.3614893514675623e-01 3.2899822292186298e-02 6.5529674260441182e-03
     	 	 8.0454974747615537e-01 1.6429286715713465e-01 1.3797950075089955e-02
     	 	 6.1948431533135195e-01 3.7802163891336921e-01 5.6375356078551594e-03
     	 	 1.6655614492060572e-01 8.0364834053903877e-01 1.3378318081626579e-02
     	 	 3.3268560622678411e-02 9.3551434285897095e-01 6.6871546432313647e-03
     	 	 6.1924873232110123e-01 2.6297199713764152e-02 1.4717279053216762e-02
     	 	 3.9659731669586495e-01 1.4354532010930898e-02 9.1794421950681711e-03
     	 	 1.6892970982290229e-01 2.2120535196161750e-02 1.0688904048956841e-02
     	 	 3.2916403878999745e-02 3.4222771841359190e-02 7.2740543402810397e-03
     	 	 2.5660186833052434e-02 6.1758873171277151e-01 1.4360888683763545e-02
     	 	 1.2417148586801485e-01 5.3141960154079959e-01 2.7060738237627398e-02
     	 	 2.5252704638304480e-02 1.7400571673032256e-01 1.2035150250304116e-02
     	 	 ];


    case 12

        % SET: OTHER RULES
        % CARDINALITY RULE  :     32
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 1.610e-15

        XYW=[
    	 	 3.7986021093401956e-01 2.1078525939140391e-01 2.9718916975567708e-02
     	 	 3.0141709320909305e-01 4.0978657777002531e-01 3.7611031301662212e-02
     	 	 5.5802528953120256e-01 2.1377743253005960e-01 3.1582273211328345e-02
     	 	 1.2512299505810387e-01 6.1938125736255578e-01 2.5482462438393812e-02
     	 	 2.1117939909804934e-01 2.4498296509349016e-01 2.3749787662653579e-02
     	 	 8.5431474947580432e-01 7.1871496101589105e-02 1.1245373099579112e-02
     	 	 7.1788185898052326e-01 2.0376848107772977e-01 1.9786802896485964e-02
     	 	 4.6631787462323071e-01 4.0896380449124475e-01 2.9994853663553086e-02
     	 	 2.5015500335339214e-01 6.2768261568031403e-01 2.6676041524410464e-02
     	 	 7.9955384841381316e-02 8.2600331401756000e-01 1.5264586206036199e-02
     	 	 7.1008125956836521e-01 6.4413220382260550e-02 2.0640943697731312e-02
     	 	 4.9732063377796598e-01 7.0566724344036824e-02 2.4074402518453667e-02
     	 	 2.6077068256562896e-01 9.5428585810584610e-02 2.2968921082895860e-02
     	 	 8.9602705800587434e-02 1.1638649906727733e-01 1.5287638802019478e-02
     	 	 2.3088148766115757e-02 7.4918973979067949e-01 1.0842542708505752e-02
     	 	 1.2953296900433620e-01 4.2260565743346001e-01 2.7073436306583785e-02
     	 	 9.3448087604440955e-02 2.4345813394879973e-01 1.3971867159939928e-02
     	 	 9.5526919357006035e-01 2.3551733249578710e-02 3.3379500136836780e-03
     	 	 8.4593539837314391e-01 1.5406460162685609e-01 3.8572461868124175e-03
     	 	 6.1600929617267497e-01 3.6118159118967208e-01 1.2549586713842556e-02
     	 	 3.9316510319604808e-01 5.8168921474014745e-01 1.4072779302606666e-02
     	 	 1.8920633061715936e-01 7.8860171922313160e-01 1.0310002059841058e-02
     	 	 4.3010560106405471e-02 9.4547507322097091e-01 3.5598757180403625e-03
     	 	 8.5815888421533082e-01 0.0000000000000000e+00 3.4227673271718453e-03
     	 	 6.2731531923241179e-01 0.0000000000000000e+00 4.8273543712181724e-03
     	 	 3.6384660446077510e-01 1.4566514788346974e-02 9.2727402108032653e-03
     	 	 1.5557066896897953e-01 2.1152223383121949e-02 9.2418429056153866e-03
     	 	 2.9754117496841759e-02 2.7110971356255786e-02 5.2546633678012579e-03
     	 	 0.0000000000000000e+00 9.2734897448394982e-01 2.4440249073300192e-03
     	 	 2.5716283623693881e-02 5.4444667627192522e-01 1.4084827229864981e-02
     	 	 2.4506286636990005e-02 3.3212908394764507e-01 1.2452036600753851e-02
     	 	 9.2296909059649268e-03 1.4604496167217568e-01 5.3404218288141464e-03
     	 	 ];


    case 13

        % SET: OTHER RULES
        % CARDINALITY RULE  :     36
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 3.053e-16

        XYW=[
    	 	 2.6016788997567916e-02 2.4022226884120611e-02 4.0399896418070336e-03
     	 	 2.4022226605627587e-02 9.4996098429958054e-01 4.0399896065220573e-03
     	 	 9.4996098382882732e-01 2.6016789189575014e-02 4.0399896872785352e-03
     	 	 1.8883630668694282e-02 1.2208086732512516e-01 6.4460144544000045e-03
     	 	 1.2208086561509698e-01 8.5903550370366299e-01 6.4460143637491496e-03
     	 	 8.5903550249287430e-01 1.8883629732181006e-02 6.4460141907784086e-03
     	 	 1.3163921675513870e-01 2.2874709056511601e-02 8.2801218370202549e-03
     	 	 2.2874709316314600e-02 8.4548607378036200e-01 8.2801219267354710e-03
     	 	 8.4548607332416614e-01 1.3163921777032453e-01 8.2801218541343653e-03
     	 	 2.0731531453874751e-02 2.8073780789776198e-01 9.5115667320960964e-03
     	 	 2.8073780447786523e-01 6.9853066476743897e-01 9.5115663324443142e-03
     	 	 6.9853066002828812e-01 2.0731531572896086e-02 9.5115667839750870e-03
     	 	 4.7664285405348261e-01 5.0484950003502527e-01 9.6798254982826716e-03
     	 	 5.0484949546347413e-01 1.8507646297268868e-02 9.6798256445210524e-03
     	 	 1.8507645858560330e-02 4.7664285783561194e-01 9.6798254276562311e-03
     	 	 3.0238701480112606e-01 1.9975751509091672e-02 9.7918985385882385e-03
     	 	 1.9975751174691608e-02 6.7763723357046479e-01 9.7918984004491359e-03
     	 	 6.7763723125163411e-01 3.0238701759712494e-01 9.7918984646146491e-03
     	 	 1.0153977741550164e-01 1.1902823839427271e-01 1.5140748101228309e-02
     	 	 1.1902823951168766e-01 7.7943198317841378e-01 1.5140748276015085e-02
     	 	 7.7943198727947505e-01 1.0153977438386529e-01 1.5140747908420909e-02
     	 	 2.4961441943417667e-01 1.0358996900295508e-01 1.9082032132036703e-02
     	 	 1.0358996781285237e-01 6.4679561128105623e-01 1.9082032020071856e-02
     	 	 6.4679561689227738e-01 2.4961441559063616e-01 1.9082031741447781e-02
     	 	 1.0202924589972601e-01 2.7688828961648571e-01 1.9099669161416925e-02
     	 	 2.7688829422886335e-01 6.2108246384621701e-01 1.9099668693700163e-02
     	 	 6.2108246400120559e-01 1.0202924636815618e-01 1.9099669240405209e-02
     	 	 2.2678927602203702e-01 2.3372837421755474e-01 2.0423575649242649e-02
     	 	 2.3372837185989132e-01 5.3948236068253108e-01 2.0423574925768677e-02
     	 	 5.3948235531846578e-01 2.2678927602203702e-01 2.0423575027017221e-02
     	 	 4.3740949813103780e-01 9.5992085884561679e-02 2.0542846050483839e-02
     	 	 9.5992083695017993e-02 4.6659841615902548e-01 2.0542845620859829e-02
     	 	 4.6659842118977918e-01 4.3740949468212509e-01 2.0542845791992861e-02
     	 	 3.8075857788108330e-01 2.2785535520199698e-01 2.4628380057601956e-02
     	 	 2.2785535120125722e-01 3.9138607729987041e-01 2.4628380363336585e-02
     	 	 3.9138606989995428e-01 3.8075857895500476e-01 2.4628379853900633e-02
     	 	 ];


    case 14

        % SET: OTHER RULES
        % CARDINALITY RULE  :     42
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 4.684e-16

        XYW=[
    	 	 1.7720553241254344e-01 1.7720553241254344e-01 2.1081294368496512e-02
     	 	 1.7720553241254344e-01 6.4558893517491311e-01 2.1081294368496512e-02
     	 	 6.4558893517491311e-01 1.7720553241254344e-01 2.1081294368496512e-02
     	 	 4.1764471934045394e-01 4.1764471934045394e-01 1.6394176772062678e-02
     	 	 4.1764471934045394e-01 1.6471056131909212e-01 1.6394176772062678e-02
     	 	 1.6471056131909212e-01 4.1764471934045394e-01 1.6394176772062678e-02
     	 	 6.1799883090872587e-02 6.1799883090872587e-02 7.2168498348883356e-03
     	 	 6.1799883090872587e-02 8.7640023381825483e-01 7.2168498348883356e-03
     	 	 8.7640023381825483e-01 6.1799883090872587e-02 7.2168498348883356e-03
     	 	 4.8896391036217862e-01 4.8896391036217862e-01 1.0941790684714446e-02
     	 	 4.8896391036217862e-01 2.2072179275642756e-02 1.0941790684714446e-02
     	 	 2.2072179275642756e-02 4.8896391036217862e-01 1.0941790684714446e-02
     	 	 2.7347752830883865e-01 2.7347752830883865e-01 2.5887052253645799e-02
     	 	 2.7347752830883865e-01 4.5304494338232271e-01 2.5887052253645799e-02
     	 	 4.5304494338232271e-01 2.7347752830883865e-01 2.5887052253645799e-02
     	 	 1.9390961248701044e-02 1.9390961248701044e-02 2.4617018012000414e-03
     	 	 1.9390961248701044e-02 9.6121807750259791e-01 2.4617018012000414e-03
     	 	 9.6121807750259791e-01 1.9390961248701044e-02 2.4617018012000414e-03
     	 	 2.9837288213625779e-01 6.8698016780808779e-01 7.2181540567669220e-03
     	 	 2.9837288213625779e-01 1.4646950055654417e-02 7.2181540567669220e-03
     	 	 6.8698016780808779e-01 2.9837288213625779e-01 7.2181540567669220e-03
     	 	 6.8698016780808779e-01 1.4646950055654417e-02 7.2181540567669220e-03
     	 	 1.4646950055654417e-02 2.9837288213625779e-01 7.2181540567669220e-03
     	 	 1.4646950055654417e-02 6.8698016780808779e-01 7.2181540567669220e-03
     	 	 5.7124757403647919e-02 1.7226668782135557e-01 1.2332876606281840e-02
     	 	 5.7124757403647919e-02 7.7060855477499646e-01 1.2332876606281840e-02
     	 	 1.7226668782135557e-01 5.7124757403647919e-02 1.2332876606281840e-02
     	 	 1.7226668782135557e-01 7.7060855477499646e-01 1.2332876606281840e-02
     	 	 7.7060855477499646e-01 5.7124757403647919e-02 1.2332876606281840e-02
     	 	 7.7060855477499646e-01 1.7226668782135557e-01 1.2332876606281840e-02
     	 	 3.3686145979634496e-01 5.7022229084668319e-01 1.9285755393530345e-02
     	 	 3.3686145979634496e-01 9.2916249356971847e-02 1.9285755393530345e-02
     	 	 5.7022229084668319e-01 3.3686145979634496e-01 1.9285755393530345e-02
     	 	 5.7022229084668319e-01 9.2916249356971847e-02 1.9285755393530345e-02
     	 	 9.2916249356971847e-02 3.3686145979634496e-01 1.9285755393530345e-02
     	 	 9.2916249356971847e-02 5.7022229084668319e-01 1.9285755393530345e-02
     	 	 1.2683309328720416e-03 1.1897449769695684e-01 2.5051144192503364e-03
     	 	 1.2683309328720416e-03 8.7975717137017106e-01 2.5051144192503364e-03
     	 	 1.1897449769695684e-01 1.2683309328720416e-03 2.5051144192503364e-03
     	 	 1.1897449769695684e-01 8.7975717137017106e-01 2.5051144192503364e-03
     	 	 8.7975717137017106e-01 1.2683309328720416e-03 2.5051144192503364e-03
     	 	 8.7975717137017106e-01 1.1897449769695684e-01 2.5051144192503364e-03
     	 	 ];


    case 15

        % SET: OTHER RULES
        % CARDINALITY RULE  :     46
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 5.065e-16

        XYW=[
    	 	 3.3333329226171188e-01 3.3333336922587242e-01 2.3374815587575835e-02
     	 	 1.8434834053485061e-02 2.1020611606485981e-02 2.5139358950722686e-03
     	 	 2.1020619858791386e-02 9.6054455392570726e-01 2.5139356963752840e-03
     	 	 9.6054457987254704e-01 1.8434815403186190e-02 2.5139323945284520e-03
     	 	 9.4469494871460086e-02 1.4008479173567751e-02 3.7993383681731796e-03
     	 	 1.4008449561943208e-02 8.9152211111073787e-01 3.7993289967283225e-03
     	 	 8.9152207785391335e-01 9.4469378400658027e-02 3.7993473730624418e-03
     	 	 2.2105962333556495e-01 1.4600180511535499e-02 5.3660662432566206e-03
     	 	 1.4600162740124831e-02 7.6434036019922491e-01 5.3660557256365732e-03
     	 	 7.6434067141417827e-01 2.2105933930011765e-01 5.3659883923687594e-03
     	 	 1.8316134980082239e-02 1.0683154044569193e-01 5.4154306117403933e-03
     	 	 1.0683157264900270e-01 8.7485228959181838e-01 5.4154329205213809e-03
     	 	 8.7485236387342946e-01 1.8316144510145183e-02 5.4154307626108622e-03
     	 	 3.8411188003675595e-01 1.3506555908128118e-02 6.1243594455763183e-03
     	 	 1.3506550559231808e-02 6.0238175776096570e-01 6.1243570395023627e-03
     	 	 6.0238190756137033e-01 3.8411155138298919e-01 6.1243546356413835e-03
     	 	 1.7609578493398354e-02 2.4686956403797747e-01 7.1989201799024065e-03
     	 	 2.4686963589198979e-01 7.3552078511545826e-01 7.1989222450450849e-03
     	 	 7.3552095839723763e-01 1.7609584738097189e-02 7.1989201317916402e-03
     	 	 1.6211095448871830e-02 4.2002744931556302e-01 7.4919002079899023e-03
     	 	 4.2002755726649177e-01 5.6376134188028260e-01 7.4919039388493440e-03
     	 	 5.6376160888468663e-01 1.6211104648384749e-02 7.4919023212170390e-03
     	 	 9.4583554095872852e-02 7.8193742333583338e-02 9.6163369362114500e-03
     	 	 7.8193645831044045e-02 8.2722278270406324e-01 9.6163349511959144e-03
     	 	 8.2722250756353266e-01 9.4583585587111843e-02 9.6163471982819784e-03
     	 	 2.2302050366957440e-01 6.9024708216096978e-02 1.0417333977873233e-02
     	 	 6.9024590188698845e-02 7.0795480660051791e-01 1.0417320084082637e-02
     	 	 7.0795549188156548e-01 2.2302065754739078e-01 1.0417255721889174e-02
     	 	 9.1368656394297254e-02 1.9744154180672169e-01 1.4288484973080285e-02
     	 	 1.9744143242612364e-01 7.1118990712628116e-01 1.4288484686989506e-02
     	 	 7.1118956938939859e-01 9.1368684008222664e-02 1.4288489044840166e-02
     	 	 3.8453085561710848e-01 7.3097727448545646e-02 1.4515833589325474e-02
     	 	 7.3097710649978609e-02 5.4237130075267792e-01 1.4515833669194279e-02
     	 	 5.4237124893384692e-01 3.8453103570395503e-01 1.4515842330252316e-02
     	 	 2.1503881238983161e-01 1.5589306185405327e-01 1.5120138042124465e-02
     	 	 1.5589284315896187e-01 6.2906836338596483e-01 1.5120129490666573e-02
     	 	 6.2906888742065659e-01 2.1503895747972521e-01 1.5120211213143164e-02
     	 	 8.5318950896480145e-02 3.5900749944105220e-01 1.6255761920006905e-02
     	 	 3.5900738682724287e-01 5.5567363262428382e-01 1.6255768356984373e-02
     	 	 5.5567335728960698e-01 8.5318972494617784e-02 1.6255759723645159e-02
     	 	 2.0423040277311624e-01 2.8615718680220359e-01 2.0093565047807710e-02
     	 	 2.8615697055232431e-01 5.0961256748415262e-01 2.0093572550896749e-02
     	 	 5.0961271758577864e-01 2.0423050168351431e-01 2.0093626230187678e-02
     	 	 3.6389103583501731e-01 1.8108597998835274e-01 2.0657675325257172e-02
     	 	 1.8108589630787308e-01 4.5502314128362154e-01 2.0657652654018879e-02
     	 	 4.5502297057578239e-01 3.6389108559829164e-01 2.0657663168878789e-02
     	 	 ];


    case 16

        % SET: OTHER RULES
        % CARDINALITY RULE  :     52
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 5.690e-16

        XYW=[
    	 	 3.3333325882505754e-01 3.3333341679349809e-01 1.8316135669004252e-02
     	 	 1.5961002222668268e-02 1.6883133661795089e-02 1.7721500296810683e-03
     	 	 1.6883138683115889e-02 9.6715584824269385e-01 1.7721517227843242e-03
     	 	 9.6715587480157361e-01 1.5961001750531226e-02 1.7721489352996657e-03
     	 	 3.8217526453720903e-03 9.9349798885249668e-02 2.0087677997024582e-03
     	 	 9.9349805946200742e-02 8.9682844348206725e-01 2.0087676310019697e-03
     	 	 8.9682851417759379e-01 3.8216600929357638e-03 2.0087542844573611e-03
     	 	 9.2621638406881923e-02 4.7176761538212696e-03 2.0953464358334137e-03
     	 	 4.7177178216007039e-03 9.0266061853433310e-01 2.0953530961686914e-03
     	 	 9.0266063550900444e-01 9.2621625598950055e-02 2.0953557154931028e-03
     	 	 9.8097828700547656e-03 2.4673927601712975e-01 4.2813714130285818e-03
     	 	 2.4673929149878562e-01 7.4345092920029809e-01 4.2813704345187860e-03
     	 	 7.4345087575836843e-01 9.8097655839704673e-03 4.2813653616645434e-03
     	 	 2.3445346553976157e-01 1.2521206522119908e-02 4.9894956417298880e-03
     	 	 1.2521215962457937e-02 7.5302532753901052e-01 4.9894993165940467e-03
     	 	 7.5302538490562632e-01 2.3445339243426830e-01 4.9895024976932233e-03
     	 	 5.1657112974377209e-02 5.7775750119375677e-02 5.1062726005764924e-03
     	 	 5.7775819366716420e-02 8.9056706412543707e-01 5.1062752475900097e-03
     	 	 8.9056719491775038e-01 5.1656949685232621e-02 5.1062698395007520e-03
     	 	 1.5979112506190052e-02 4.1344324768355917e-01 7.0407338226842909e-03
     	 	 4.1344326130972797e-01 5.7057762547207846e-01 7.0407343497074452e-03
     	 	 5.7057759770688654e-01 1.5979116105793466e-02 7.0407337238328517e-03
     	 	 3.9685624973183076e-01 1.6762648247774282e-02 7.3149600359915887e-03
     	 	 1.6762650225796177e-02 5.8638109124448856e-01 7.3149618252974918e-03
     	 	 5.8638112389119446e-01 3.9685622816305044e-01 7.3149620444611565e-03
     	 	 1.4036857829882579e-01 5.0399889980289776e-02 8.0282371773992434e-03
     	 	 5.0399962289145110e-02 8.0923142942080439e-01 8.0282416719667689e-03
     	 	 8.0923154544800913e-01 1.4036845666795905e-01 8.0282473874250734e-03
     	 	 4.8645802147072648e-02 1.5360243523548675e-01 8.5121727268778324e-03
     	 	 1.5360250148640572e-01 7.9775170004007634e-01 8.5121717230987690e-03
     	 	 7.9775182163801339e-01 4.8645704254425937e-02 8.5121683854629190e-03
     	 	 6.7545529600334511e-02 2.9356276326769659e-01 1.2477872580773553e-02
     	 	 2.9356281536171214e-01 6.3889164470447757e-01 1.2477876642040538e-02
     	 	 6.3889171565727221e-01 6.7545510682957527e-02 1.2477872833662279e-02
     	 	 1.6047592419512688e-01 2.7611972660288958e-01 1.4099575787101495e-02
     	 	 2.7611991981412248e-01 5.6340408092537198e-01 1.4099594524735156e-02
     	 	 5.6340408092537198e-01 1.6047594307897289e-01 1.4099588335917018e-02
     	 	 2.8046249412358287e-01 7.7279816912928484e-02 1.4135293879458817e-02
     	 	 7.7279847608036814e-02 6.4225762918207985e-01 1.4135298391321218e-02
     	 	 6.4225773164928712e-01 2.8046242526974469e-01 1.4135299057647334e-02
     	 	 1.4735665607513534e-01 1.4801228209502745e-01 1.4613064132682129e-02
     	 	 1.4801238889602028e-01 7.0463094677224380e-01 1.4613072264173474e-02
     	 	 7.0463099577855459e-01 1.4735657499351967e-01 1.4613073256787118e-02
     	 	 4.2474042621429003e-01 2.0895386876708902e-01 1.7003482855881862e-02
     	 	 2.0895373177594934e-01 3.6630558474469394e-01 1.7003487686414152e-02
     	 	 3.6630580779304339e-01 4.2474041349729763e-01 1.7003475643666183e-02
     	 	 4.5172422255660405e-01 8.7033369844956715e-02 1.7117829478258344e-02
     	 	 8.7033362530208533e-02 4.6124236966638288e-01 1.7117827400843607e-02
     	 	 4.6124246073338221e-01 4.5172418121818148e-01 1.7117828373121587e-02
     	 	 2.8831849966071421e-01 1.9022911241262480e-01 1.9964633973873460e-02
     	 	 1.9022915660365911e-01 5.2145230485262561e-01 1.9964640930829676e-02
     	 	 5.2145242653751633e-01 2.8831843195126500e-01 1.9964633424282920e-02
     	 	 ];


    case 17

        % SET: OTHER RULES
        % CARDINALITY RULE  :     57
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 5.829e-16

        XYW=[
    	 	 1.4720966195626592e-02 1.7639984855506732e-02 1.6885180040497648e-03
     	 	 1.7639984855506732e-02 9.6763904894886665e-01 1.6885180040497648e-03
     	 	 9.6763904894886665e-01 1.4720966195626592e-02 1.6885180040497648e-03
     	 	 7.5827872337699789e-02 7.6974758437722557e-03 1.9099628350969652e-03
     	 	 7.6974758437722557e-03 9.1647465181852794e-01 1.9099628350969652e-03
     	 	 9.1647465181852794e-01 7.5827872337699789e-02 1.9099628350969652e-03
     	 	 3.1058551655846400e-01 8.3200919510460474e-03 3.3120130407206746e-03
     	 	 8.3200919510460474e-03 6.8109439149049000e-01 3.3120130407206746e-03
     	 	 6.8109439149049000e-01 3.1058551655846400e-01 3.3120130407206746e-03
     	 	 1.4488314624940400e-02 9.0164039580071326e-02 3.6424503674367405e-03
     	 	 9.0164039580071326e-02 8.9534764579498827e-01 3.6424503674367405e-03
     	 	 8.9534764579498827e-01 1.4488314624940400e-02 3.6424503674367405e-03
     	 	 1.7814385225301996e-01 1.6423858046515614e-02 4.9825012367027037e-03
     	 	 1.6423858046515614e-02 8.0543228970046443e-01 4.9825012367027037e-03
     	 	 8.0543228970046443e-01 1.7814385225301996e-01 4.9825012367027037e-03
     	 	 4.6613355079593471e-01 1.2335581768737785e-02 5.1381725492979750e-03
     	 	 1.2335581768737785e-02 5.2153086743532739e-01 5.1381725492979750e-03
     	 	 5.2153086743532739e-01 4.6613355079593471e-01 5.1381725492979750e-03
     	 	 1.4736566166282276e-02 2.0932517115745763e-01 5.1547456518885905e-03
     	 	 2.0932517115745763e-01 7.7593826267626009e-01 5.1547456518885905e-03
     	 	 7.7593826267626009e-01 1.4736566166282276e-02 5.1547456518885905e-03
     	 	 1.4332535547880318e-02 3.5860231579542368e-01 5.8011145684001113e-03
     	 	 3.5860231579542368e-01 6.2706514865669605e-01 5.8011145684001113e-03
     	 	 6.2706514865669605e-01 1.4332535547880318e-02 5.8011145684001113e-03
     	 	 7.5303349390642163e-02 5.5968132994742077e-02 6.2348718937410459e-03
     	 	 5.5968132994742077e-02 8.6872851761461567e-01 6.2348718937410459e-03
     	 	 8.6872851761461567e-01 7.5303349390642163e-02 6.2348718937410459e-03
     	 	 3.1733939350172785e-01 5.1694878418799495e-02 9.8162397577659759e-03
     	 	 5.1694878418799495e-02 6.3096572807947260e-01 9.8162397577659759e-03
     	 	 6.3096572807947260e-01 3.1733939350172785e-01 9.8162397577659759e-03
     	 	 7.5354265490354566e-02 1.5459821166573010e-01 1.0050753537572595e-02
     	 	 1.5459821166573010e-01 7.7004752284391542e-01 1.0050753537572595e-02
     	 	 7.7004752284391542e-01 7.5354265490354566e-02 1.0050753537572595e-02
     	 	 1.8257077444087677e-01 2.6653005963514675e-01 1.0453022784282569e-02
     	 	 2.6653005963514675e-01 5.5089916592397647e-01 1.0453022784282569e-02
     	 	 5.5089916592397647e-01 1.8257077444087677e-01 1.0453022784282569e-02
     	 	 1.7971003272207475e-01 8.1586227754905885e-02 1.0666123835801861e-02
     	 	 8.1586227754905885e-02 7.3870373952301938e-01 1.0666123835801861e-02
     	 	 7.3870373952301938e-01 1.7971003272207475e-01 1.0666123835801861e-02
     	 	 1.7580794171567718e-01 1.8035364052078595e-01 1.1874688594592340e-02
     	 	 1.8035364052078595e-01 6.4383841776353690e-01 1.1874688594592340e-02
     	 	 6.4383841776353690e-01 1.7580794171567718e-01 1.1874688594592340e-02
     	 	 4.5873149968878352e-01 4.7412600771932673e-01 1.2388512004066014e-02
     	 	 4.7412600771932673e-01 6.7142492591889813e-02 1.2388512004066014e-02
     	 	 6.7142492591889813e-02 4.5873149968878352e-01 1.2388512004066014e-02
     	 	 7.5319692074374348e-02 2.9375410536296775e-01 1.2792785121136312e-02
     	 	 2.9375410536296775e-01 6.3092620256265786e-01 1.2792785121136312e-02
     	 	 6.3092620256265786e-01 7.5319692074374348e-02 1.2792785121136312e-02
     	 	 1.6330517792538479e-01 3.8425118776594169e-01 1.5655429401650579e-02
     	 	 3.8425118776594169e-01 4.5244363430867351e-01 1.5655429401650579e-02
     	 	 4.5244363430867351e-01 1.6330517792538479e-01 1.5655429401650579e-02
     	 	 3.1181356869961463e-01 1.3950152599660817e-01 1.5795181274718760e-02
     	 	 1.3950152599660817e-01 5.4868490530377723e-01 1.5795181274718760e-02
     	 	 5.4868490530377723e-01 3.1181356869961463e-01 1.5795181274718760e-02
     	 	 3.0604825911202793e-01 2.6772065354596208e-01 1.9309580207745123e-02
     	 	 2.6772065354596208e-01 4.2623108734200998e-01 1.9309580207745123e-02
     	 	 4.2623108734200998e-01 3.0604825911202793e-01 1.9309580207745123e-02
     	 	 ];


    case 18

        % SET: OTHER RULES
        % CARDINALITY RULE  :     66
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 5.898e-16

        XYW=[
    	 	 3.6978096405509784e-03 7.4357923508124160e-02 1.3188955634412635e-03
     	 	 7.4357923508124160e-02 9.2194426685132480e-01 1.3188955634412635e-03
     	 	 9.2194426685132480e-01 3.6978096405509784e-03 1.3188955634412635e-03
     	 	 1.4914399227998885e-02 1.3690913073362648e-02 1.3374533254983756e-03
     	 	 1.3690913073362648e-02 9.7139468769863846e-01 1.3374533254983756e-03
     	 	 9.7139468769863846e-01 1.4914399227998885e-02 1.3374533254983756e-03
     	 	 1.6973999621930291e-03 2.0891369061546108e-01 1.5965191368817605e-03
     	 	 2.0891369061546108e-01 7.8938890942234596e-01 1.5965191368817605e-03
     	 	 7.8938890942234596e-01 1.6973999621930291e-03 1.5965191368817605e-03
     	 	 8.0662083946625274e-02 8.2435326902914278e-03 2.0853492188051340e-03
     	 	 8.2435326902914278e-03 9.1109438336308335e-01 2.0853492188051340e-03
     	 	 9.1109438336308335e-01 8.0662083946625274e-02 2.0853492188051340e-03
     	 	 1.9874790140231080e-01 6.9765950961831660e-03 2.6296016188394554e-03
     	 	 6.9765950961831660e-03 7.9427550350150600e-01 2.6296016188394554e-03
     	 	 7.9427550350150600e-01 1.9874790140231080e-01 2.6296016188394554e-03
     	 	 3.4670271914727641e-01 9.0597713534798507e-03 3.5942225039936929e-03
     	 	 9.0597713534798507e-03 6.4423750949924363e-01 3.5942225039936929e-03
     	 	 6.4423750949924363e-01 3.4670271914727641e-01 3.5942225039936929e-03
     	 	 4.8634633387104276e-02 5.5791052971746698e-02 4.4793913460327000e-03
     	 	 5.5791052971746698e-02 8.9557431364114903e-01 4.4793913460327000e-03
     	 	 8.9557431364114903e-01 4.8634633387104276e-02 4.4793913460327000e-03
     	 	 1.2831862984944630e-02 3.4469254847797043e-01 4.6243626935627974e-03
     	 	 3.4469254847797043e-01 6.4247558853708497e-01 4.6243626935627974e-03
     	 	 6.4247558853708497e-01 1.2831862984944630e-02 4.6243626935627974e-03
     	 	 2.9359538994220516e-02 1.3996411031839173e-01 5.0371231242457050e-03
     	 	 1.3996411031839173e-01 8.3067635068738777e-01 5.0371231242457050e-03
     	 	 8.3067635068738777e-01 2.9359538994220516e-02 5.0371231242457050e-03
     	 	 4.9078839469375929e-01 4.9582251778966463e-01 5.1150374432246846e-03
     	 	 4.9582251778966463e-01 1.3389087516576137e-02 5.1150374432246846e-03
     	 	 1.3389087516576137e-02 4.9078839469375929e-01 5.1150374432246846e-03
     	 	 1.3861878405978878e-01 4.4707679385501874e-02 6.3686080936826680e-03
     	 	 4.4707679385501874e-02 8.1667353655470931e-01 6.3686080936826680e-03
     	 	 8.1667353655470931e-01 1.3861878405978878e-01 6.3686080936826680e-03
     	 	 2.6389760635220100e-01 4.3672095251755069e-02 7.0634907757205897e-03
     	 	 4.3672095251755069e-02 6.9243029839604398e-01 7.0634907757205897e-03
     	 	 6.9243029839604398e-01 2.6389760635220100e-01 7.0634907757205897e-03
     	 	 4.5591174493061090e-02 2.4521857350619572e-01 7.6663872077767431e-03
     	 	 2.4521857350619572e-01 7.0919025200074326e-01 7.6663872077767431e-03
     	 	 7.0919025200074326e-01 4.5591174493061090e-02 7.6663872077767431e-03
     	 	 3.9401035853706806e-01 5.9276933781644683e-02 9.5754941522341909e-03
     	 	 5.9276933781644683e-02 5.4671270768128732e-01 9.5754941522341909e-03
     	 	 5.4671270768128732e-01 3.9401035853706806e-01 9.5754941522341909e-03
     	 	 1.0686720694096476e-01 1.2832552694798030e-01 9.7906879255536886e-03
     	 	 1.2832552694798030e-01 7.6480726611105498e-01 9.7906879255536886e-03
     	 	 7.6480726611105498e-01 1.0686720694096476e-01 9.7906879255536886e-03
     	 	 2.2057527942548341e-01 1.1327582130168469e-01 1.1259607436394163e-02
     	 	 1.1327582130168469e-01 6.6614889927283194e-01 1.1259607436394163e-02
     	 	 6.6614889927283194e-01 2.2057527942548341e-01 1.1259607436394163e-02
     	 	 1.2365383504129873e-01 2.4272043721609243e-01 1.1872044026809360e-02
     	 	 2.4272043721609243e-01 6.3362572774260872e-01 1.1872044026809360e-02
     	 	 6.3362572774260872e-01 1.2365383504129873e-01 1.1872044026809360e-02
     	 	 7.1334879410097959e-02 3.8790847894248653e-01 1.2256290117375515e-02
     	 	 3.8790847894248653e-01 5.4075664164741544e-01 1.2256290117375515e-02
     	 	 5.4075664164741544e-01 7.1334879410097959e-02 1.2256290117375515e-02
     	 	 2.2412691032497162e-01 2.1328980000961897e-01 1.2340736801134396e-02
     	 	 2.1328980000961897e-01 5.6258328966540938e-01 1.2340736801134396e-02
     	 	 5.6258328966540938e-01 2.2412691032497162e-01 1.2340736801134396e-02
     	 	 3.5161904995564269e-01 1.3793750997645651e-01 1.3483831459976342e-02
     	 	 1.3793750997645651e-01 5.1044344006790088e-01 1.3483831459976342e-02
     	 	 5.1044344006790088e-01 3.5161904995564269e-01 1.3483831459976342e-02
     	 	 3.6076234056773243e-01 4.6512581996476732e-01 1.6173105436895732e-02
     	 	 4.6512581996476732e-01 1.7411183946750020e-01 1.6173105436895732e-02
     	 	 1.7411183946750020e-01 3.6076234056773243e-01 1.6173105436895732e-02
     	 	 3.1130012898251941e-01 2.7007362938867141e-01 1.6998427258587748e-02
     	 	 2.7007362938867141e-01 4.1862624162880913e-01 1.6998427258587748e-02
     	 	 4.1862624162880913e-01 3.1130012898251941e-01 1.6998427258587748e-02
     	 	 ];


    case 19

        % SET: OTHER RULES
        % CARDINALITY RULE  :     70
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 4.441e-16

        XYW=[
    	 	 3.3333333333333331e-01 3.3333333333333331e-01 1.5231480880073709e-02
     	 	 1.0376656545701754e-02 1.4481047265899900e-02 9.7509097903284944e-04
     	 	 1.4481047265899900e-02 9.7514229618839832e-01 9.7509097903284944e-04
     	 	 9.7514229618839832e-01 1.0376656545701754e-02 9.7509097903284944e-04
     	 	 5.2895640212959193e-02 8.9271173425645341e-03 1.3809723085865875e-03
     	 	 8.9271173425645341e-03 9.3817724244447620e-01 1.3809723085865875e-03
     	 	 9.3817724244447620e-01 5.2895640212959193e-02 1.3809723085865875e-03
     	 	 1.3094057146527935e-01 6.3960635617080460e-03 1.7665897158664712e-03
     	 	 6.3960635617080460e-03 8.6266336497301255e-01 1.7665897158664712e-03
     	 	 8.6266336497301255e-01 1.3094057146527935e-01 1.7665897158664712e-03
     	 	 1.2668186551090302e-02 7.2908235059904125e-02 2.5760145388450694e-03
     	 	 7.2908235059904125e-02 9.1442357838900556e-01 2.5760145388450694e-03
     	 	 9.1442357838900556e-01 1.2668186551090302e-02 2.5760145388450694e-03
     	 	 2.4661396010476735e-01 1.1321028448271661e-02 3.6558550831352721e-03
     	 	 1.1321028448271661e-02 7.4206501144696102e-01 3.6558550831352721e-03
     	 	 7.4206501144696102e-01 2.4661396010476735e-01 3.6558550831352721e-03
     	 	 1.2433000096283946e-02 1.7150720385727522e-01 3.6947365258809708e-03
     	 	 1.7150720385727522e-01 8.1605979604644086e-01 3.6947365258809708e-03
     	 	 8.1605979604644086e-01 1.2433000096283946e-02 3.6947365258809708e-03
     	 	 9.4587086792603855e-03 4.5455308365694880e-01 3.7738930263380688e-03
     	 	 4.5455308365694880e-01 5.3598820766379085e-01 3.7738930263380688e-03
     	 	 5.3598820766379085e-01 9.4587086792603855e-03 3.7738930263380688e-03
     	 	 3.8267712743290072e-01 1.0304127159604519e-02 3.8077342033380106e-03
     	 	 1.0304127159604519e-02 6.0701874540749479e-01 3.8077342033380106e-03
     	 	 6.0701874540749479e-01 3.8267712743290072e-01 3.8077342033380106e-03
     	 	 1.0722190231133364e-02 3.0281941897786346e-01 3.9503790665645520e-03
     	 	 3.0281941897786346e-01 6.8645839079100313e-01 3.9503790665645520e-03
     	 	 6.8645839079100313e-01 1.0722190231133364e-02 3.9503790665645520e-03
     	 	 6.3458887217335530e-02 4.7982682558826824e-02 4.1052197664620087e-03
     	 	 4.7982682558826824e-02 8.8855843022383763e-01 4.1052197664620087e-03
     	 	 8.8855843022383763e-01 6.3458887217335530e-02 4.1052197664620087e-03
     	 	 1.4958534166780135e-01 4.1535364284310518e-02 5.3158332904020720e-03
     	 	 4.1535364284310518e-02 8.0887929404788816e-01 5.3158332904020720e-03
     	 	 8.0887929404788816e-01 1.4958534166780135e-01 5.3158332904020720e-03
     	 	 6.5938374993168375e-02 1.2709830130649977e-01 7.2590315610260511e-03
     	 	 1.2709830130649977e-01 8.0696332370033186e-01 7.2590315610260511e-03
     	 	 8.0696332370033186e-01 6.5938374993168375e-02 7.2590315610260511e-03
     	 	 4.1936034447469361e-01 4.8413394484357990e-02 7.3470568659559738e-03
     	 	 4.8413394484357990e-02 5.3222626104094839e-01 7.3470568659559738e-03
     	 	 5.3222626104094839e-01 4.1936034447469361e-01 7.3470568659559738e-03
     	 	 5.1285971562743754e-02 3.8545151944759559e-01 8.4349555966782737e-03
     	 	 3.8545151944759559e-01 5.6326250898966068e-01 8.4349555966782737e-03
     	 	 5.6326250898966068e-01 5.1285971562743754e-02 8.4349555966782737e-03
     	 	 5.9216171712594003e-02 2.4426337874091408e-01 8.6095847623188695e-03
     	 	 2.4426337874091408e-01 6.9652044954649195e-01 8.6095847623188695e-03
     	 	 6.9652044954649195e-01 5.9216171712594003e-02 8.6095847623188695e-03
     	 	 1.5774435365253489e-01 1.0703910299909378e-01 8.7458370727353969e-03
     	 	 1.0703910299909378e-01 7.3521654334837128e-01 8.7458370727353969e-03
     	 	 7.3521654334837128e-01 1.5774435365253489e-01 8.7458370727353969e-03
     	 	 2.7635637145129316e-01 5.9395829650746024e-02 9.1457389001491137e-03
     	 	 5.9395829650746024e-02 6.6424779889796093e-01 9.1457389001491137e-03
     	 	 6.6424779889796093e-01 2.7635637145129316e-01 9.1457389001491137e-03
     	 	 4.0292543250410290e-01 1.1125969746384887e-01 1.0544677751228573e-02
     	 	 1.1125969746384887e-01 4.8581487003204815e-01 1.0544677751228573e-02
     	 	 4.8581487003204815e-01 4.0292543250410290e-01 1.0544677751228573e-02
     	 	 1.4474120951067007e-01 2.0733708666187714e-01 1.1514585665531379e-02
     	 	 2.0733708666187714e-01 6.4792170382745284e-01 1.1514585665531379e-02
     	 	 6.4792170382745284e-01 1.4474120951067007e-01 1.1514585665531379e-02
     	 	 1.2800219617071518e-01 3.3880397181433680e-01 1.2467094225662436e-02
     	 	 3.3880397181433680e-01 5.3319383201494808e-01 1.2467094225662436e-02
     	 	 5.3319383201494808e-01 1.2800219617071518e-01 1.2467094225662436e-02
     	 	 2.6733402095713005e-01 1.4787228580357800e-01 1.2978067474551694e-02
     	 	 1.4787228580357800e-01 5.8479369323929198e-01 1.2978067474551694e-02
     	 	 5.8479369323929198e-01 2.6733402095713005e-01 1.2978067474551694e-02
     	 	 3.8064039133743355e-01 2.0742134128256490e-01 1.4457758153114666e-02
     	 	 2.0742134128256490e-01 4.1193826738000155e-01 1.4457758153114666e-02
     	 	 4.1193826738000155e-01 3.8064039133743355e-01 1.4457758153114666e-02
     	 	 2.4101907410276571e-01 2.6708311799129086e-01 1.5082799839904367e-02
     	 	 2.6708311799129086e-01 4.9189780790594345e-01 1.5082799839904367e-02
     	 	 4.9189780790594345e-01 2.4101907410276571e-01 1.5082799839904367e-02
     	 	 ];


    case 20

        % SET: OTHER RULES
        % CARDINALITY RULE  :     78
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 4.927e-16

        XYW=[
    	 	 7.9036813416234631e-03 1.0892617666329891e-02 5.6949530744875194e-04
     	 	 1.0892617666329891e-02 9.8120370099204668e-01 5.6949530744875194e-04
     	 	 9.8120370099204668e-01 7.9036813416234631e-03 5.6949530744875194e-04
     	 	 3.7026142140495718e-03 5.6835913941912758e-02 7.6788354372912468e-04
     	 	 5.6835913941912758e-02 9.3946147184403761e-01 7.6788354372912468e-04
     	 	 9.3946147184403761e-01 3.7026142140495718e-03 7.6788354372912468e-04
     	 	 1.0933739015022848e-01 3.0385925733436734e-03 9.6234279589326810e-04
     	 	 3.0385925733436734e-03 8.8762401727642781e-01 9.6234279589326810e-04
     	 	 8.8762401727642781e-01 1.0933739015022848e-01 9.6234279589326810e-04
     	 	 4.2881075376943294e-02 9.8050570254988034e-03 1.2502186561779570e-03
     	 	 9.8050570254988034e-03 9.4731386759755787e-01 1.2502186561779570e-03
     	 	 9.4731386759755787e-01 4.2881075376943294e-02 1.2502186561779570e-03
     	 	 1.7747325730732661e-03 2.3669301898277445e-01 1.3153756180938308e-03
     	 	 2.3669301898277445e-01 7.6153224844415224e-01 1.3153756180938308e-03
     	 	 7.6153224844415224e-01 1.7747325730732661e-03 1.3153756180938308e-03
     	 	 3.1181457060113710e-01 2.5455197956388257e-03 1.5978128070140761e-03
     	 	 2.5455197956388257e-03 6.8563990960322418e-01 1.5978128070140761e-03
     	 	 6.8563990960322418e-01 3.1181457060113710e-01 1.5978128070140761e-03
     	 	 2.9900066046955765e-03 4.6311944115593690e-01 1.8258844970394229e-03
     	 	 4.6311944115593690e-01 5.3389055223936754e-01 1.8258844970394229e-03
     	 	 5.3389055223936754e-01 2.9900066046955765e-03 1.8258844970394229e-03
     	 	 3.2214232134941442e-02 5.2485418254685598e-02 2.6622689456084524e-03
     	 	 5.2485418254685598e-02 9.1530034961037299e-01 2.6622689456084524e-03
     	 	 9.1530034961037299e-01 3.2214232134941442e-02 2.6622689456084524e-03
     	 	 1.2779960332488103e-02 1.3137953817800016e-01 2.9222280141944701e-03
     	 	 1.3137953817800016e-01 8.5584050148951174e-01 2.9222280141944701e-03
     	 	 8.5584050148951174e-01 1.2779960332488103e-02 2.9222280141944701e-03
     	 	 1.9543072338191531e-01 1.4095340079167391e-02 3.6540029900709982e-03
     	 	 1.4095340079167391e-02 7.9047393653891740e-01 3.6540029900709982e-03
     	 	 7.9047393653891740e-01 1.9543072338191531e-01 3.6540029900709982e-03
     	 	 9.7766916990501648e-02 3.5000751662894826e-02 3.9531676766459637e-03
     	 	 3.5000751662894826e-02 8.6723233134660349e-01 3.9531676766459637e-03
     	 	 8.6723233134660349e-01 9.7766916990501648e-02 3.9531676766459637e-03
     	 	 1.6600662844177817e-02 3.3867675226583793e-01 4.8279789354445622e-03
     	 	 3.3867675226583793e-01 6.4472258488998424e-01 4.8279789354445622e-03
     	 	 6.4472258488998424e-01 1.6600662844177817e-02 4.8279789354445622e-03
     	 	 4.1339508218074000e-01 1.8202587826948211e-02 5.1572945019298108e-03
     	 	 1.8202587826948211e-02 5.6840232999231188e-01 5.1572945019298108e-03
     	 	 5.6840232999231188e-01 4.1339508218074000e-01 5.1572945019298108e-03
     	 	 6.8329374634159043e-02 1.0867508995456668e-01 6.1049192721312744e-03
     	 	 1.0867508995456668e-01 8.2299553541127435e-01 6.1049192721312744e-03
     	 	 8.2299553541127435e-01 6.8329374634159043e-02 6.1049192721312744e-03
     	 	 3.9215307843232454e-02 2.1433843005455050e-01 6.4193411610496201e-03
     	 	 2.1433843005455050e-01 7.4644626210221698e-01 6.4193411610496201e-03
     	 	 7.4644626210221698e-01 3.9215307843232454e-02 6.4193411610496201e-03
     	 	 2.8285140438768569e-01 4.3250599724609151e-02 7.3333988488618754e-03
     	 	 4.3250599724609151e-02 6.7389799588770516e-01 7.3333988488618754e-03
     	 	 6.7389799588770516e-01 2.8285140438768569e-01 7.3333988488618754e-03
     	 	 1.6314907835570533e-01 7.4632420343531666e-02 7.7025269311828378e-03
     	 	 7.4632420343531666e-02 7.6221850130076296e-01 7.7025269311828378e-03
     	 	 7.6221850130076296e-01 1.6314907835570533e-01 7.7025269311828378e-03
     	 	 4.3629058390662195e-01 5.1653707778068925e-01 8.2877969374391472e-03
     	 	 5.1653707778068925e-01 4.7172338312688744e-02 8.2877969374391472e-03
     	 	 4.7172338312688744e-02 4.3629058390662195e-01 8.2877969374391472e-03
     	 	 1.2306908733084597e-01 1.7394646430224309e-01 9.9946101905975960e-03
     	 	 1.7394646430224309e-01 7.0298444836691099e-01 9.9946101905975960e-03
     	 	 7.0298444836691099e-01 1.2306908733084597e-01 9.9946101905975960e-03
     	 	 8.3257905081074293e-02 2.9918522779730361e-01 1.0148708738753714e-02
     	 	 2.9918522779730361e-01 6.1755686712162206e-01 1.0148708738753714e-02
     	 	 6.1755686712162206e-01 8.3257905081074293e-02 1.0148708738753714e-02
     	 	 3.7602894358398858e-01 8.6437944469363939e-02 1.0818345252890245e-02
     	 	 8.6437944469363939e-02 5.3753311194664755e-01 1.0818345252890245e-02
     	 	 5.3753311194664755e-01 3.7602894358398858e-01 1.0818345252890245e-02
     	 	 2.3986629094495532e-01 1.3011561089713888e-01 1.1512738681475888e-02
     	 	 1.3011561089713888e-01 6.3001809815790577e-01 1.1512738681475888e-02
     	 	 6.3001809815790577e-01 2.3986629094495532e-01 1.1512738681475888e-02
     	 	 1.3722114882399380e-01 3.9101320130295769e-01 1.3161746873886273e-02
     	 	 3.9101320130295769e-01 4.7176564987304848e-01 1.3161746873886273e-02
     	 	 4.7176564987304848e-01 1.3722114882399380e-01 1.3161746873886273e-02
     	 	 1.8993213060838091e-01 2.5032134600889316e-01 1.3524048813517497e-02
     	 	 2.5032134600889316e-01 5.5974652338272590e-01 1.3524048813517497e-02
     	 	 5.5974652338272590e-01 1.8993213060838091e-01 1.3524048813517497e-02
     	 	 3.2415825639563883e-01 1.9472448888111191e-01 1.4497169864803256e-02
     	 	 1.9472448888111191e-01 4.8111725472324918e-01 1.4497169864803256e-02
     	 	 4.8111725472324918e-01 3.2415825639563883e-01 1.4497169864803256e-02
     	 	 3.3086291214705171e-01 4.0744532437685332e-01 1.5695360810786717e-02
     	 	 4.0744532437685332e-01 2.6169176347609502e-01 1.5695360810786717e-02
     	 	 2.6169176347609502e-01 3.3086291214705171e-01 1.5695360810786717e-02
     	 	 ];


    case 21

        % SET: OTHER RULES
        % CARDINALITY RULE  :     85
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 4.545e-16

        XYW=[
    	 	 3.3333333333333331e-01 3.3333333333333331e-01 7.9636219608526446e-03
     	 	 1.0883381125829185e-02 1.0843736020090887e-02 7.7001240520689954e-04
     	 	 1.0843736020090887e-02 9.7827288285407987e-01 7.7001240520689954e-04
     	 	 9.7827288285407987e-01 1.0883381125829185e-02 7.7001240520689954e-04
     	 	 1.3448308201330128e-01 5.8940179144611419e-03 1.4820191056177214e-03
     	 	 5.8940179144611419e-03 8.5962290007223763e-01 1.4820191056177214e-03
     	 	 8.5962290007223763e-01 1.3448308201330128e-01 1.4820191056177214e-03
     	 	 5.6069791445608280e-02 9.3407202951554924e-01 1.5712852396898855e-03
     	 	 9.3407202951554924e-01 9.8581790388424517e-03 1.5712852396898855e-03
     	 	 9.8581790388424517e-03 5.6069791445608280e-02 1.5712852396898855e-03
     	 	 5.6230797163851619e-02 1.0411168900746122e-02 1.6612788647555913e-03
     	 	 1.0411168900746122e-02 9.3335803393540229e-01 1.6612788647555913e-03
     	 	 9.3335803393540229e-01 5.6230797163851619e-02 1.6612788647555913e-03
     	 	 4.9549225054526058e-01 5.3013935392908201e-03 2.0354710638375985e-03
     	 	 5.3013935392908201e-03 4.9920635591544860e-01 2.0354710638375985e-03
     	 	 4.9920635591544860e-01 4.9549225054526058e-01 2.0354710638375985e-03
     	 	 1.3341354422143650e-01 8.5650220211325812e-01 2.3532901945706678e-03
     	 	 8.5650220211325812e-01 1.0084253665305409e-02 2.3532901945706678e-03
     	 	 1.0084253665305409e-02 1.3341354422143650e-01 2.3532901945706678e-03
     	 	 2.3778885327379537e-01 7.5355383003485144e-01 2.5929401198136076e-03
     	 	 7.5355383003485144e-01 8.6573166913531674e-03 2.5929401198136076e-03
     	 	 8.6573166913531674e-03 2.3778885327379537e-01 2.5929401198136076e-03
     	 	 2.3667582268756976e-01 1.0431599868322363e-02 3.0265861364731843e-03
     	 	 1.0431599868322363e-02 7.5289257744410787e-01 3.0265861364731843e-03
     	 	 7.5289257744410787e-01 2.3667582268756976e-01 3.0265861364731843e-03
     	 	 3.5923743154358795e-01 9.7744131190851992e-03 3.2486865773903020e-03
     	 	 9.7744131190851992e-03 6.3098815533732677e-01 3.2486865773903020e-03
     	 	 6.3098815533732677e-01 3.5923743154358795e-01 3.2486865773903020e-03
     	 	 3.6212379554213159e-01 6.2748273139455280e-01 3.4866620827171684e-03
     	 	 6.2748273139455280e-01 1.0393473063315617e-02 3.4866620827171684e-03
     	 	 1.0393473063315617e-02 3.6212379554213159e-01 3.4866620827171684e-03
     	 	 5.4706462526630792e-02 8.9337625860348302e-01 3.6029377946731867e-03
     	 	 8.9337625860348302e-01 5.1917278869886174e-02 3.6029377946731867e-03
     	 	 5.1917278869886174e-02 5.4706462526630792e-02 3.6029377946731867e-03
     	 	 1.2849784556464677e-01 3.6812842147870548e-02 4.1825064144353661e-03
     	 	 3.6812842147870548e-02 8.3468931228748267e-01 4.1825064144353661e-03
     	 	 8.3468931228748267e-01 1.2849784556464677e-01 4.1825064144353661e-03
     	 	 1.3204562148598842e-01 8.1675054229140631e-01 5.1132981684188904e-03
     	 	 8.1675054229140631e-01 5.1203836222605270e-02 5.1132981684188904e-03
     	 	 5.1203836222605270e-02 1.3204562148598842e-01 5.1132981684188904e-03
     	 	 4.8000288746551578e-01 3.4623316765578373e-02 5.8704643682985416e-03
     	 	 3.4623316765578373e-02 4.8537379576890582e-01 5.8704643682985416e-03
     	 	 4.8537379576890582e-01 4.8000288746551578e-01 5.8704643682985416e-03
     	 	 2.3569865248618388e-01 7.1763978029460807e-01 6.0916247220667843e-03
     	 	 7.1763978029460807e-01 4.6661567219208000e-02 6.0916247220667843e-03
     	 	 4.6661567219208000e-02 2.3569865248618388e-01 6.0916247220667843e-03
     	 	 1.2123545350512091e-01 9.8717289213207965e-02 6.4327447374377062e-03
     	 	 9.8717289213207965e-02 7.8004725728167112e-01 6.4327447374377062e-03
     	 	 7.8004725728167112e-01 1.2123545350512091e-01 6.4327447374377062e-03
     	 	 2.2692131253456985e-01 5.3382695673250657e-02 6.5476491310084133e-03
     	 	 5.3382695673250657e-02 7.1969599179217947e-01 6.5476491310084133e-03
     	 	 7.1969599179217947e-01 2.2692131253456985e-01 6.5476491310084133e-03
     	 	 3.5272595600222983e-01 5.9395602013861637e-01 7.0433595266711224e-03
     	 	 5.9395602013861637e-01 5.3318023859153851e-02 7.0433595266711224e-03
     	 	 5.3318023859153851e-02 3.5272595600222983e-01 7.0433595266711224e-03
     	 	 3.4639476098063526e-01 5.1134367191086910e-02 7.0920153597872114e-03
     	 	 5.1134367191086910e-02 6.0247087182827785e-01 7.0920153597872114e-03
     	 	 6.0247087182827785e-01 3.4639476098063526e-01 7.0920153597872114e-03
     	 	 2.0854537617999444e-01 1.2666187408877325e-01 8.6104157838011661e-03
     	 	 1.2666187408877325e-01 6.6479274973123226e-01 8.6104157838011661e-03
     	 	 6.6479274973123226e-01 2.0854537617999444e-01 8.6104157838011661e-03
     	 	 1.1664118178749894e-01 1.9358351370774260e-01 8.7068119796780627e-03
     	 	 1.9358351370774260e-01 6.8977530450475844e-01 8.7068119796780627e-03
     	 	 6.8977530450475844e-01 1.1664118178749894e-01 8.7068119796780627e-03
     	 	 3.0168173165951112e-01 5.7948556128572692e-01 9.0418377718242352e-03
     	 	 5.7948556128572692e-01 1.1883270705476201e-01 9.0418377718242352e-03
     	 	 1.1883270705476201e-01 3.0168173165951112e-01 9.0418377718242352e-03
     	 	 3.5976650509436425e-01 4.6544957877641646e-01 9.5745693833366140e-03
     	 	 4.6544957877641646e-01 1.7478391612921929e-01 9.5745693833366140e-03
     	 	 1.7478391612921929e-01 3.5976650509436425e-01 9.5745693833366140e-03
     	 	 3.1772789477972085e-01 1.2192276586456074e-01 9.6139096353062524e-03
     	 	 1.2192276586456074e-01 5.6034933935571840e-01 9.6139096353062524e-03
     	 	 5.6034933935571840e-01 3.1772789477972085e-01 9.6139096353062524e-03
     	 	 4.5059923770816623e-01 9.8026080230645227e-02 1.0015838380710766e-02
     	 	 9.8026080230645227e-02 4.5137468206118853e-01 1.0015838380710766e-02
     	 	 4.5137468206118853e-01 4.5059923770816623e-01 1.0015838380710766e-02
     	 	 2.6678020887821458e-01 3.0930467163940578e-01 1.0382561430746567e-02
     	 	 3.0930467163940578e-01 4.2391511948237970e-01 1.0382561430746567e-02
     	 	 4.2391511948237970e-01 2.6678020887821458e-01 1.0382561430746567e-02
     	 	 2.1491332208551214e-01 2.2361527123160835e-01 1.1907526353194569e-02
     	 	 2.2361527123160835e-01 5.6147140668287943e-01 1.1907526353194569e-02
     	 	 5.6147140668287943e-01 2.1491332208551214e-01 1.1907526353194569e-02
     	 	 3.4182082891498583e-01 2.0305957510273218e-01 1.1953823281581078e-02
     	 	 2.0305957510273218e-01 4.5511959598228202e-01 1.1953823281581078e-02
     	 	 4.5511959598228202e-01 3.4182082891498583e-01 1.1953823281581078e-02
     	 	 ];


    case 22

        % SET: OTHER RULES
        % CARDINALITY RULE  :     93
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 7.286e-16

        XYW=[
    	 	 1.1703384837887284e-03 4.7853691880759081e-02 4.8770602046986866e-04
     	 	 4.7853691880759081e-02 9.5097596963545217e-01 4.8770602046986866e-04
     	 	 9.5097596963545217e-01 1.1703384837887284e-03 4.8770602046986866e-04
     	 	 1.0994365574026065e-02 9.1086717537202100e-03 6.5522261057489512e-04
     	 	 9.1086717537202100e-03 9.7989696267225368e-01 6.5522261057489512e-04
     	 	 9.7989696267225368e-01 1.0994365574026065e-02 6.5522261057489512e-04
     	 	 1.0681692522528875e-03 2.0270906338792563e-01 9.0969204232460067e-04
     	 	 2.0270906338792563e-01 7.9622276735982156e-01 9.0969204232460067e-04
     	 	 7.9622276735982156e-01 1.0681692522528875e-03 9.0969204232460067e-04
     	 	 2.2122835059211034e-03 4.2176907067146541e-01 1.2426948589491708e-03
     	 	 4.2176907067146541e-01 5.7601864582261353e-01 1.2426948589491708e-03
     	 	 5.7601864582261353e-01 2.2122835059211034e-03 1.2426948589491708e-03
     	 	 5.7202598716253460e-02 8.5608709992095848e-03 1.3971528812135882e-03
     	 	 8.5608709992095848e-03 9.3423653028453701e-01 1.3971528812135882e-03
     	 	 9.3423653028453701e-01 5.7202598716253460e-02 1.3971528812135882e-03
     	 	 3.5302421161527681e-01 6.0942412505558905e-03 1.7740742860057499e-03
     	 	 6.0942412505558905e-03 6.4088154713416723e-01 1.7740742860057499e-03
     	 	 6.4088154713416723e-01 3.5302421161527681e-01 1.7740742860057499e-03
     	 	 1.3678895783915382e-01 7.8499806284800869e-03 1.8893133281591876e-03
     	 	 7.8499806284800869e-03 8.5536106153236613e-01 1.8893133281591876e-03
     	 	 8.5536106153236613e-01 1.3678895783915382e-01 1.8893133281591876e-03
     	 	 2.4120956376003772e-01 7.0272635517203280e-03 2.0191331425198720e-03
     	 	 7.0272635517203280e-03 7.5176317268824189e-01 2.0191331425198720e-03
     	 	 7.5176317268824189e-01 2.4120956376003772e-01 2.0191331425198720e-03
     	 	 1.1673747786687883e-02 1.1264121642953522e-01 2.3166067965116840e-03
     	 	 1.1264121642953522e-01 8.7568503578377699e-01 2.3166067965116840e-03
     	 	 8.7568503578377699e-01 1.1673747786687883e-02 2.3166067965116840e-03
     	 	 3.0114899634799297e-02 4.6055896520382444e-02 2.4653631701510724e-03
     	 	 4.6055896520382444e-02 9.2382920384481826e-01 2.4653631701510724e-03
     	 	 9.2382920384481826e-01 3.0114899634799297e-02 2.4653631701510724e-03
     	 	 4.5650015438745406e-01 1.1437907707031122e-02 3.2078519953887340e-03
     	 	 1.1437907707031122e-02 5.3206193790551481e-01 3.2078519953887340e-03
     	 	 5.3206193790551481e-01 4.5650015438745406e-01 3.2078519953887340e-03
     	 	 1.1807594618901865e-02 3.0499692169056031e-01 3.3242125220734639e-03
     	 	 3.0499692169056031e-01 6.8319548369053784e-01 3.3242125220734639e-03
     	 	 6.8319548369053784e-01 1.1807594618901865e-02 3.3242125220734639e-03
     	 	 9.6150558730147037e-02 4.2635231869026166e-02 3.9686772278441683e-03
     	 	 4.2635231869026166e-02 8.6121420940082682e-01 3.9686772278441683e-03
     	 	 8.6121420940082682e-01 9.6150558730147037e-02 3.9686772278441683e-03
     	 	 3.0637657499207941e-02 1.9699058002570907e-01 4.6959128356016061e-03
     	 	 1.9699058002570907e-01 7.7237176247508299e-01 4.6959128356016061e-03
     	 	 7.7237176247508299e-01 3.0637657499207941e-02 4.6959128356016061e-03
     	 	 1.9481524443080608e-01 3.8664167437872397e-02 4.8832923118954756e-03
     	 	 3.8664167437872397e-02 7.6652058813132151e-01 4.8832923118954756e-03
     	 	 7.6652058813132151e-01 1.9481524443080608e-01 4.8832923118954756e-03
     	 	 6.0365503070241099e-02 1.0661022068914792e-01 4.9696561182096290e-03
     	 	 1.0661022068914792e-01 8.3302427624061093e-01 4.9696561182096290e-03
     	 	 8.3302427624061093e-01 6.0365503070241099e-02 4.9696561182096290e-03
     	 	 3.1509089948205937e-01 3.6089820174339142e-02 5.3928589751705367e-03
     	 	 3.6089820174339142e-02 6.4881928034360148e-01 5.3928589751705367e-03
     	 	 6.4881928034360148e-01 3.1509089948205937e-01 5.3928589751705367e-03
     	 	 4.1135836721581720e-01 5.5639035396185565e-01 5.5993569085600152e-03
     	 	 5.5639035396185565e-01 3.2251278822327145e-02 5.5993569085600152e-03
     	 	 3.2251278822327145e-02 4.1135836721581720e-01 5.5993569085600152e-03
     	 	 1.4402035063048924e-01 9.7715590184512757e-02 6.7962246253369203e-03
     	 	 9.7715590184512757e-02 7.5826405918499806e-01 6.7962246253369203e-03
     	 	 7.5826405918499806e-01 1.4402035063048924e-01 6.7962246253369203e-03
     	 	 4.2075770910212190e-01 5.5528837489452670e-02 7.0536436565812504e-03
     	 	 5.5528837489452670e-02 5.2371345340842534e-01 7.0536436565812504e-03
     	 	 5.2371345340842534e-01 4.2075770910212190e-01 7.0536436565812504e-03
     	 	 6.0949899580789661e-02 2.9205601614107290e-01 7.1727494929599749e-03
     	 	 2.9205601614107290e-01 6.4699408427813743e-01 7.1727494929599749e-03
     	 	 6.4699408427813743e-01 6.0949899580789661e-02 7.1727494929599749e-03
     	 	 9.6935106445587491e-02 1.8422415689190805e-01 7.5165723405571632e-03
     	 	 1.8422415689190805e-01 7.1884073666250448e-01 7.5165723405571632e-03
     	 	 7.1884073666250448e-01 9.6935106445587491e-02 7.5165723405571632e-03
     	 	 2.5378346562064696e-01 9.2228684901440233e-02 7.9188389019028138e-03
     	 	 9.2228684901440233e-02 6.5398784947791277e-01 7.9188389019028138e-03
     	 	 6.5398784947791277e-01 2.5378346562064696e-01 7.9188389019028138e-03
     	 	 3.4886710140216276e-01 1.1623555207070974e-01 8.5572527741333768e-03
     	 	 1.1623555207070974e-01 5.3489734652712762e-01 8.5572527741333768e-03
     	 	 5.3489734652712762e-01 3.4886710140216276e-01 8.5572527741333768e-03
     	 	 1.9058155865307422e-01 1.7214824666674494e-01 8.9856455503194207e-03
     	 	 1.7214824666674494e-01 6.3727019468018087e-01 8.9856455503194207e-03
     	 	 6.3727019468018087e-01 1.9058155865307422e-01 8.9856455503194207e-03
     	 	 9.6988114334812803e-02 3.9655213150862650e-01 9.2725165984512345e-03
     	 	 3.9655213150862650e-01 5.0645975415656075e-01 9.2725165984512345e-03
     	 	 5.0645975415656075e-01 9.6988114334812803e-02 9.2725165984512345e-03
     	 	 1.4126633463063171e-01 2.7537965024518302e-01 9.6990556231790308e-03
     	 	 2.7537965024518302e-01 5.8335401512418517e-01 9.6990556231790308e-03
     	 	 5.8335401512418517e-01 1.4126633463063171e-01 9.6990556231790308e-03
     	 	 4.1201810197995220e-01 1.6857388429008832e-01 9.7618352932007536e-03
     	 	 1.6857388429008832e-01 4.1940801372995939e-01 9.7618352932007536e-03
     	 	 4.1940801372995939e-01 4.1201810197995220e-01 9.7618352932007536e-03
     	 	 2.7620933906532141e-01 1.9919935637318403e-01 1.0312765984818520e-02
     	 	 1.9919935637318403e-01 5.2459130456149450e-01 1.0312765984818520e-02
     	 	 5.2459130456149450e-01 2.7620933906532141e-01 1.0312765984818520e-02
     	 	 2.1861061467249740e-01 3.0568565104773043e-01 1.0656911210091427e-02
     	 	 3.0568565104773043e-01 4.7570373427977214e-01 1.0656911210091427e-02
     	 	 4.7570373427977214e-01 2.1861061467249740e-01 1.0656911210091427e-02
     	 	 3.3679904631184637e-01 2.6981434578199104e-01 1.1763876583511461e-02
     	 	 2.6981434578199104e-01 3.9338660790616253e-01 1.1763876583511461e-02
     	 	 3.9338660790616253e-01 3.3679904631184637e-01 1.1763876583511461e-02
     	 	 ];


    case 23

        % SET: OTHER RULES
        % CARDINALITY RULE  :    100
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 6.434e-16

        XYW=[
    	 	 3.3333333333333331e-01 3.3333333333333331e-01 1.2569435730146848e-02
     	 	 9.4139490330046090e-03 8.6464444518944781e-03 5.3305884125301386e-04
     	 	 8.6464444518944781e-03 9.8193960651510093e-01 5.3305884125301386e-04
     	 	 9.8193960651510093e-01 9.4139490330046090e-03 5.3305884125301386e-04
     	 	 4.8241021890889081e-04 1.0882142058056087e-01 5.5493657527744570e-04
     	 	 1.0882142058056087e-01 8.9069616920053019e-01 5.5493657527744570e-04
     	 	 8.9069616920053019e-01 4.8241021890889081e-04 5.5493657527744570e-04
     	 	 4.9633556562943609e-01 5.0329473593098173e-01 8.1481197782281439e-04
     	 	 5.0329473593098173e-01 3.6969843958212234e-04 8.1481197782281439e-04
     	 	 3.6969843958212234e-04 4.9633556562943609e-01 8.1481197782281439e-04
     	 	 8.6145275902432504e-03 4.4964858940933154e-02 1.1026458465688874e-03
     	 	 4.4964858940933154e-02 9.4642061346882356e-01 1.1026458465688874e-03
     	 	 9.4642061346882356e-01 8.6145275902432504e-03 1.1026458465688874e-03
     	 	 4.9100663468775806e-02 8.2424970824296982e-03 1.1587771598983196e-03
     	 	 8.2424970824296982e-03 9.4265683944879441e-01 1.1587771598983196e-03
     	 	 9.4265683944879441e-01 4.9100663468775806e-02 1.1587771598983196e-03
     	 	 2.6604160773538743e-03 2.9470448202172089e-01 1.1608193508077010e-03
     	 	 2.9470448202172089e-01 7.0263510190092515e-01 1.1608193508077010e-03
     	 	 7.0263510190092515e-01 2.6604160773538743e-03 1.1608193508077010e-03
     	 	 3.3098446926941211e-01 3.8206684917989277e-03 1.5018307556977830e-03
     	 	 3.8206684917989277e-03 6.6519486223878888e-01 1.5018307556977830e-03
     	 	 6.6519486223878888e-01 3.3098446926941211e-01 1.5018307556977830e-03
     	 	 1.1815450592101939e-01 8.4131574146606557e-03 1.7738109617687326e-03
     	 	 8.4131574146606557e-03 8.7343233666431996e-01 1.7738109617687326e-03
     	 	 8.7343233666431996e-01 1.1815450592101939e-01 1.7738109617687326e-03
     	 	 2.1407309787902890e-01 7.2053975765022519e-03 1.9013258182735125e-03
     	 	 7.2053975765022519e-03 7.7872150454446887e-01 1.9013258182735125e-03
     	 	 7.7872150454446887e-01 2.1407309787902890e-01 1.9013258182735125e-03
     	 	 4.4577412877333654e-02 4.3026357023085333e-02 2.3671623513284719e-03
     	 	 4.3026357023085333e-02 9.1239623009958104e-01 2.3671623513284719e-03
     	 	 9.1239623009958104e-01 4.4577412877333654e-02 2.3671623513284719e-03
     	 	 1.9143139515349089e-01 3.1169269889860296e-02 2.3910227647242414e-03
     	 	 3.1169269889860296e-02 7.7739933495664881e-01 2.3910227647242414e-03
     	 	 7.7739933495664881e-01 1.9143139515349089e-01 2.3910227647242414e-03
     	 	 1.0585098456769080e-02 1.9186490304827739e-01 2.5274600836500353e-03
     	 	 1.9186490304827739e-01 7.9754999849495356e-01 2.5274600836500353e-03
     	 	 7.9754999849495356e-01 1.0585098456769080e-02 2.5274600836500353e-03
     	 	 2.5420226429005641e-02 1.0540760648009682e-01 3.0226030672419585e-03
     	 	 1.0540760648009682e-01 8.6917216709089751e-01 3.0226030672419585e-03
     	 	 8.6917216709089751e-01 2.5420226429005641e-02 3.0226030672419585e-03
     	 	 5.9129291976109599e-01 1.2107289245252150e-02 3.1563512228449152e-03
     	 	 1.2107289245252150e-02 3.9659979099365184e-01 3.1563512228449152e-03
     	 	 3.9659979099365184e-01 5.9129291976109599e-01 3.1563512228449152e-03
     	 	 1.0490365652094102e-01 4.3370975391949562e-02 3.3882027435690001e-03
     	 	 4.3370975391949562e-02 8.5172536808710941e-01 3.3882027435690001e-03
     	 	 8.5172536808710941e-01 1.0490365652094102e-01 3.3882027435690001e-03
     	 	 4.2721744601873479e-01 1.6697078855470619e-02 3.9423962138162762e-03
     	 	 1.6697078855470619e-02 5.5608547512579454e-01 3.9423962138162762e-03
     	 	 5.5608547512579454e-01 4.2721744601873479e-01 3.9423962138162762e-03
     	 	 1.7789929675087990e-01 6.4511068023700172e-02 4.3684538203737399e-03
     	 	 6.4511068023700172e-02 7.5758963522541989e-01 4.3684538203737399e-03
     	 	 7.5758963522541989e-01 1.7789929675087990e-01 4.3684538203737399e-03
     	 	 8.0548215582571539e-02 1.0197699396951582e-01 4.7172029269966697e-03
     	 	 1.0197699396951582e-01 8.1747479044791271e-01 4.7172029269966697e-03
     	 	 8.1747479044791271e-01 8.0548215582571539e-02 4.7172029269966697e-03
     	 	 3.1317311279855049e-02 2.8534297804565589e-01 4.7454397139096403e-03
     	 	 2.8534297804565589e-01 6.8333971067448906e-01 4.7454397139096403e-03
     	 	 6.8333971067448906e-01 3.1317311279855049e-02 4.7454397139096403e-03
     	 	 2.9544675874255427e-01 3.2881012535433060e-02 5.1054813281088754e-03
     	 	 3.2881012535433060e-02 6.7167222872201271e-01 5.1054813281088754e-03
     	 	 6.7167222872201271e-01 2.9544675874255427e-01 5.1054813281088754e-03
     	 	 5.4113217353947932e-02 1.8385958270294381e-01 5.2596266677425218e-03
     	 	 1.8385958270294381e-01 7.6202719994310830e-01 5.2596266677425218e-03
     	 	 7.6202719994310830e-01 5.4113217353947932e-02 5.2596266677425218e-03
     	 	 4.2740065428049014e-02 4.4355898660390503e-01 5.8445601876387591e-03
     	 	 4.4355898660390503e-01 5.1370094796804600e-01 5.8445601876387591e-03
     	 	 5.1370094796804600e-01 4.2740065428049014e-02 5.8445601876387591e-03
     	 	 1.4518767597337787e-01 1.2979545045100729e-01 6.8502001397007231e-03
     	 	 1.2979545045100729e-01 7.2501687357561484e-01 6.8502001397007231e-03
     	 	 7.2501687357561484e-01 1.4518767597337787e-01 6.8502001397007231e-03
     	 	 7.4713978478763848e-02 3.2991396142531471e-01 7.2302256495413780e-03
     	 	 3.2991396142531471e-01 5.9537206009592147e-01 7.2302256495413780e-03
     	 	 5.9537206009592147e-01 7.4713978478763848e-02 7.2302256495413780e-03
     	 	 3.8196804313044813e-01 6.7362527515130416e-02 7.6156978917944615e-03
     	 	 6.7362527515130416e-02 5.5066942935442142e-01 7.6156978917944615e-03
     	 	 5.5066942935442142e-01 3.8196804313044813e-01 7.6156978917944615e-03
     	 	 2.2178354982181475e-01 6.6898098435814957e-01 7.7429366597229184e-03
     	 	 6.6898098435814957e-01 1.0923546582003563e-01 7.7429366597229184e-03
     	 	 1.0923546582003563e-01 2.2178354982181475e-01 7.7429366597229184e-03
     	 	 2.5687081151314684e-01 9.6049121135374796e-02 7.9944787182772495e-03
     	 	 9.6049121135374796e-02 6.4708006735147838e-01 7.9944787182772495e-03
     	 	 6.4708006735147838e-01 2.5687081151314684e-01 7.9944787182772495e-03
     	 	 1.1275130342695996e-01 4.2367418202458157e-01 9.4645179529458234e-03
     	 	 4.2367418202458157e-01 4.6357451454845849e-01 9.4645179529458234e-03
     	 	 4.6357451454845849e-01 1.1275130342695996e-01 9.4645179529458234e-03
     	 	 2.1032305744103352e-01 1.8700110967233269e-01 9.8740406783670298e-03
     	 	 1.8700110967233269e-01 6.0267583288663373e-01 9.8740406783670298e-03
     	 	 6.0267583288663373e-01 2.1032305744103352e-01 9.8740406783670298e-03
     	 	 1.6157520917947663e-01 2.9901294845569942e-01 1.0333890779832980e-02
     	 	 2.9901294845569942e-01 5.3941184236482398e-01 1.0333890779832980e-02
     	 	 5.3941184236482398e-01 1.6157520917947663e-01 1.0333890779832980e-02
     	 	 3.3165622135557482e-01 1.5061623551001871e-01 1.0399171332397553e-02
     	 	 1.5061623551001871e-01 5.1772754313440650e-01 1.0399171332397553e-02
     	 	 5.1772754313440650e-01 3.3165622135557482e-01 1.0399171332397553e-02
     	 	 2.1229476331689121e-01 3.8427148525251237e-01 1.1787787420372068e-02
     	 	 3.8427148525251237e-01 4.0343375143059640e-01 1.1787787420372068e-02
     	 	 4.0343375143059640e-01 2.1229476331689121e-01 1.1787787420372068e-02
     	 	 2.7411374218935070e-01 2.5872672300217803e-01 1.1845927154352254e-02
     	 	 2.5872672300217803e-01 4.6715953480847128e-01 1.1845927154352254e-02
     	 	 4.6715953480847128e-01 2.7411374218935070e-01 1.1845927154352254e-02
     	 	 ];


    case 24

        % SET: OTHER RULES
        % CARDINALITY RULE  :    109
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 7.910e-16

        XYW=[
    	 	 3.3333333333333331e-01 3.3333333333333331e-01 5.3408884666934055e-03
     	 	 7.2774421822864241e-03 1.8717806316108168e-03 1.7153606921701994e-04
     	 	 1.8717806316108168e-03 9.9085077718610270e-01 1.7153606921701994e-04
     	 	 9.9085077718610270e-01 7.2774421822864241e-03 1.7153606921701994e-04
     	 	 9.3762141740159580e-02 2.2258417763076133e-03 6.1149985101870336e-04
     	 	 2.2258417763076133e-03 9.0401201648353280e-01 6.1149985101870336e-04
     	 	 9.0401201648353280e-01 9.3762141740159580e-02 6.1149985101870336e-04
     	 	 2.7549956725481502e-02 9.6482583162780022e-01 8.1908013682459660e-04
     	 	 9.6482583162780022e-01 7.6242116467182264e-03 8.1908013682459660e-04
     	 	 7.6242116467182264e-03 2.7549956725481502e-02 8.1908013682459660e-04
     	 	 3.8849156576576081e-02 9.9922146846804730e-03 1.1186129729350617e-03
     	 	 9.9922146846804730e-03 9.5115862873874346e-01 1.1186129729350617e-03
     	 	 9.5115862873874346e-01 3.8849156576576081e-02 1.1186129729350617e-03
     	 	 8.4582464342299463e-02 9.0758335037465498e-01 1.4287509341391360e-03
     	 	 9.0758335037465498e-01 7.8341852830455805e-03 1.4287509341391360e-03
     	 	 7.8341852830455805e-03 8.4582464342299463e-02 1.4287509341391360e-03
     	 	 1.6971197426176723e-01 8.5509476949102940e-03 1.8429148081637228e-03
     	 	 8.5509476949102940e-03 8.2173707804332252e-01 1.8429148081637228e-03
     	 	 8.2173707804332252e-01 1.6971197426176723e-01 1.8429148081637228e-03
     	 	 2.6111425988892939e-01 7.3552353111519539e-03 1.8473977210262157e-03
     	 	 7.3552353111519539e-03 7.3153050479991866e-01 1.8473977210262157e-03
     	 	 7.3153050479991866e-01 2.6111425988892939e-01 1.8473977210262157e-03
     	 	 1.6791970513108379e-01 8.2400508353903845e-01 1.9510160031039770e-03
     	 	 8.2400508353903845e-01 8.0752113298777628e-03 1.9510160031039770e-03
     	 	 8.0752113298777628e-03 1.6791970513108379e-01 1.9510160031039770e-03
     	 	 3.6656244587496484e-01 7.0056601694997800e-03 2.0140345484655009e-03
     	 	 7.0056601694997800e-03 6.2643189395553545e-01 2.0140345484655009e-03
     	 	 6.2643189395553545e-01 3.6656244587496484e-01 2.0140345484655009e-03
     	 	 2.7143135940818341e-01 7.2062829774608572e-01 2.2624403600808385e-03
     	 	 7.2062829774608572e-01 7.9403428457308634e-03 2.2624403600808385e-03
     	 	 7.9403428457308634e-03 2.7143135940818341e-01 2.2624403600808385e-03
     	 	 4.8341512229719208e-01 7.3611935668400760e-03 2.2698014631337038e-03
     	 	 7.3611935668400760e-03 5.0922368413596786e-01 2.2698014631337038e-03
     	 	 5.0922368413596786e-01 4.8341512229719208e-01 2.2698014631337038e-03
     	 	 3.8795737424569154e-01 6.0432990841865120e-01 2.3728477236559151e-03
     	 	 6.0432990841865120e-01 7.7127173356572598e-03 2.3728477236559151e-03
     	 	 7.7127173356572598e-03 3.8795737424569154e-01 2.3728477236559151e-03
     	 	 5.2053611601207826e-02 9.0767212361002281e-01 2.5902682866872292e-03
     	 	 9.0767212361002281e-01 4.0274264788769387e-02 2.5902682866872292e-03
     	 	 4.0274264788769387e-02 5.2053611601207826e-02 2.5902682866872292e-03
     	 	 2.2901890921372595e-01 8.9345256498108053e-02 2.6559616163616124e-03
     	 	 8.9345256498108053e-02 6.8163583428816599e-01 2.6559616163616124e-03
     	 	 6.8163583428816599e-01 2.2901890921372595e-01 2.6559616163616124e-03
     	 	 9.4914195571636092e-02 2.6796719091792362e-02 2.6820975214833969e-03
     	 	 2.6796719091792362e-02 8.7828908533657157e-01 2.6820975214833969e-03
     	 	 8.7828908533657157e-01 9.4914195571636092e-02 2.6820975214833969e-03
     	 	 1.2322801473641305e-01 8.3518445285919996e-01 3.9204829725944870e-03
     	 	 8.3518445285919996e-01 4.1587532404386951e-02 3.9204829725944870e-03
     	 	 4.1587532404386951e-02 1.2322801473641305e-01 3.9204829725944870e-03
     	 	 1.7412650727485976e-01 4.4130628886304042e-02 4.3497011331066681e-03
     	 	 4.4130628886304042e-02 7.8174286383883618e-01 4.3497011331066681e-03
     	 	 7.8174286383883618e-01 1.7412650727485976e-01 4.3497011331066681e-03
     	 	 2.7218074600568665e-01 3.7468721939442978e-02 4.4201018166839367e-03
     	 	 3.7468721939442978e-02 6.9035053205487040e-01 4.4201018166839367e-03
     	 	 6.9035053205487040e-01 2.7218074600568665e-01 4.4201018166839367e-03
     	 	 9.9006351507515397e-02 8.1968796781302034e-02 4.8145661099449795e-03
     	 	 8.1968796781302034e-02 8.1902485171118267e-01 4.8145661099449795e-03
     	 	 8.1902485171118267e-01 9.9006351507515397e-02 4.8145661099449795e-03
     	 	 2.1893278755063750e-01 7.3931441242151419e-01 4.9016263049419901e-03
     	 	 7.3931441242151419e-01 4.1752800027848314e-02 4.9016263049419901e-03
     	 	 4.1752800027848314e-02 2.1893278755063750e-01 4.9016263049419901e-03
     	 	 3.8545785619529427e-01 3.7011409874506268e-02 4.9714086879144312e-03
     	 	 3.7011409874506268e-02 5.7753073393019949e-01 4.9714086879144312e-03
     	 	 5.7753073393019949e-01 3.8545785619529427e-01 4.9714086879144312e-03
     	 	 4.5393153297369843e-01 5.0712412056704248e-01 5.3741203683500072e-03
     	 	 5.0712412056704248e-01 3.8944346459259149e-02 5.3741203683500072e-03
     	 	 3.8944346459259149e-02 4.5393153297369843e-01 5.3741203683500072e-03
     	 	 3.3141406799249240e-01 6.2787210031926588e-01 5.3876363318022310e-03
     	 	 6.2787210031926588e-01 4.0713831688241719e-02 5.3876363318022310e-03
     	 	 4.0713831688241719e-02 3.3141406799249240e-01 5.3876363318022310e-03
     	 	 1.7541847870022081e-01 1.0978899948538104e-01 5.8915488764125952e-03
     	 	 1.0978899948538104e-01 7.1479252181439812e-01 5.8915488764125952e-03
     	 	 7.1479252181439812e-01 1.7541847870022081e-01 5.8915488764125952e-03
     	 	 2.9942460625822742e-01 8.9517741605650569e-02 6.0783838270523837e-03
     	 	 8.9517741605650569e-02 6.1105765213612195e-01 6.0783838270523837e-03
     	 	 6.1105765213612195e-01 2.9942460625822742e-01 6.0783838270523837e-03
     	 	 1.6443828421427001e-01 7.3572041312406400e-01 6.4728526180664117e-03
     	 	 7.3572041312406400e-01 9.9841302661666020e-02 6.4728526180664117e-03
     	 	 9.9841302661666020e-02 1.6443828421427001e-01 6.4728526180664117e-03
     	 	 3.6972475893928680e-01 4.6312780745367282e-01 6.7774498737395543e-03
     	 	 4.6312780745367282e-01 1.6714743360704037e-01 6.7774498737395543e-03
     	 	 1.6714743360704037e-01 3.6972475893928680e-01 6.7774498737395543e-03
     	 	 4.0636906177728344e-01 9.0716786111306250e-02 7.3379162465347751e-03
     	 	 9.0716786111306250e-02 5.0291415211141022e-01 7.3379162465347751e-03
     	 	 5.0291415211141022e-01 4.0636906177728344e-01 7.3379162465347751e-03
     	 	 2.6742066429926759e-01 6.3290272516985024e-01 7.7102272291999490e-03
     	 	 6.3290272516985024e-01 9.9676610530882170e-02 7.7102272291999490e-03
     	 	 9.9676610530882170e-02 2.6742066429926759e-01 7.7102272291999490e-03
     	 	 3.8320410790975118e-01 5.2162372005069046e-01 7.7579988970775974e-03
     	 	 5.2162372005069046e-01 9.5172172039558300e-02 7.7579988970775974e-03
     	 	 9.5172172039558300e-02 3.8320410790975118e-01 7.7579988970775974e-03
     	 	 1.7872449232024495e-01 1.9203113575777414e-01 7.8312946530049547e-03
     	 	 1.9203113575777414e-01 6.2924437192198091e-01 7.8312946530049547e-03
     	 	 6.2924437192198091e-01 1.7872449232024495e-01 7.8312946530049547e-03
     	 	 2.8282912859335518e-01 5.3764243749031349e-01 7.9637687554239001e-03
     	 	 5.3764243749031349e-01 1.7952843391633133e-01 7.9637687554239001e-03
     	 	 1.7952843391633133e-01 2.8282912859335518e-01 7.9637687554239001e-03
     	 	 2.7060647925422926e-01 1.6133995005265445e-01 8.0517665150398217e-03
     	 	 1.6133995005265445e-01 5.6805357069311624e-01 8.0517665150398217e-03
     	 	 5.6805357069311624e-01 2.7060647925422926e-01 8.0517665150398217e-03
     	 	 3.7087434674492326e-01 1.6454857353822244e-01 8.3290402128656290e-03
     	 	 1.6454857353822244e-01 4.6457707971685430e-01 8.3290402128656290e-03
     	 	 4.6457707971685430e-01 3.7087434674492326e-01 8.3290402128656290e-03
     	 	 3.6384081188928319e-01 3.8336719177004763e-01 9.6765397461814652e-03
     	 	 3.8336719177004763e-01 2.5279199634066918e-01 9.6765397461814652e-03
     	 	 2.5279199634066918e-01 3.6384081188928319e-01 9.6765397461814652e-03
     	 	 2.7573532186277133e-01 2.5276044951208954e-01 1.0229679318867726e-02
     	 	 2.5276044951208954e-01 4.7150422862513908e-01 1.0229679318867726e-02
     	 	 4.7150422862513908e-01 2.7573532186277133e-01 1.0229679318867726e-02
     	 	 ];


    case 25

        % SET: OTHER RULES
        % CARDINALITY RULE  :    117
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 5.412e-16

        XYW=[
    	 	 1.3188177147405115e-02 3.0795638401191457e-03 2.6347390548552040e-04
     	 	 3.0795638401191457e-03 9.8373225901247574e-01 2.6347390548552040e-04
     	 	 9.8373225901247574e-01 1.3188177147405115e-02 2.6347390548552040e-04
     	 	 2.7259621361305189e-03 1.7104304759574109e-02 2.6918928562449701e-04
     	 	 1.7104304759574109e-02 9.8016973310429534e-01 2.6918928562449701e-04
     	 	 9.8016973310429534e-01 2.7259621361305189e-03 2.6918928562449701e-04
     	 	 6.2984002092478536e-02 9.3137198416881051e-01 8.5627864694100882e-04
     	 	 9.3137198416881051e-01 5.6440137387109290e-03 8.5627864694100882e-04
     	 	 5.6440137387109290e-03 6.2984002092478536e-02 8.5627864694100882e-04
     	 	 5.2023800673153514e-02 7.4379149608617993e-03 9.5616643348529198e-04
     	 	 7.4379149608617993e-03 9.4053828436598474e-01 9.5616643348529198e-04
     	 	 9.4053828436598474e-01 5.2023800673153514e-02 9.5616643348529198e-04
     	 	 2.2020020614167110e-01 7.7641433442449037e-01 9.9487225700335344e-04
     	 	 7.7641433442449037e-01 3.3854594338385002e-03 9.9487225700335344e-04
     	 	 3.3854594338385002e-03 2.2020020614167110e-01 9.9487225700335344e-04
     	 	 3.0439556156815283e-02 9.4485645152778941e-01 1.3515008758062297e-03
     	 	 9.4485645152778941e-01 2.4703992315395329e-02 1.3515008758062297e-03
     	 	 2.4703992315395329e-02 3.0439556156815283e-02 1.3515008758062297e-03
     	 	 1.1399317437752610e-01 7.4710293157794422e-03 1.4118810710324176e-03
     	 	 7.4710293157794422e-03 8.7853579630669443e-01 1.4118810710324176e-03
     	 	 8.7853579630669443e-01 1.1399317437752610e-01 1.4118810710324176e-03
     	 	 3.4229521018802234e-01 6.5261356339758947e-01 1.4575745862365765e-03
     	 	 6.5261356339758947e-01 5.0912264143881947e-03 1.4575745862365765e-03
     	 	 5.0912264143881947e-03 3.4229521018802234e-01 1.4575745862365765e-03
     	 	 1.3047399195055950e-01 8.6152496607629980e-01 1.5731143911500646e-03
     	 	 8.6152496607629980e-01 8.0010419731406657e-03 1.5731143911500646e-03
     	 	 8.0010419731406657e-03 1.3047399195055950e-01 1.5731143911500646e-03
     	 	 2.0017930834386713e-01 6.5078186830295317e-03 1.6271988744337611e-03
     	 	 6.5078186830295317e-03 7.9331287297310338e-01 1.6271988744337611e-03
     	 	 7.9331287297310338e-01 2.0017930834386713e-01 1.6271988744337611e-03
     	 	 3.0737236321543387e-01 6.3524070945921943e-03 1.8615328907489249e-03
     	 	 6.3524070945921943e-03 6.8627522968997390e-01 1.8615328907489249e-03
     	 	 6.8627522968997390e-01 3.0737236321543387e-01 1.8615328907489249e-03
     	 	 2.7621732662271042e-01 7.0637055778341040e-01 2.1531573696407648e-03
     	 	 7.0637055778341040e-01 1.7412115593879229e-02 2.1531573696407648e-03
     	 	 1.7412115593879229e-02 2.7621732662271042e-01 2.1531573696407648e-03
     	 	 4.2293548307742690e-01 7.5627546953375892e-03 2.2625670794811565e-03
     	 	 7.5627546953375892e-03 5.6950176222723548e-01 2.2625670794811565e-03
     	 	 5.6950176222723548e-01 4.2293548307742690e-01 2.2625670794811565e-03
     	 	 4.5322700336667143e-01 5.3899804588538403e-01 2.2812496106589040e-03
     	 	 5.3899804588538403e-01 7.7749507479445423e-03 2.2812496106589040e-03
     	 	 7.7749507479445423e-03 4.5322700336667143e-01 2.2812496106589040e-03
     	 	 1.9019520269362408e-01 7.8403651191039858e-01 2.3401383103049270e-03
     	 	 7.8403651191039858e-01 2.5768285395977308e-02 2.3401383103049270e-03
     	 	 2.5768285395977308e-02 1.9019520269362408e-01 2.3401383103049270e-03
     	 	 3.6171829980612503e-02 8.4456400529242914e-02 2.8202779907719215e-03
     	 	 8.4456400529242914e-02 8.7937176949014462e-01 2.8202779907719215e-03
     	 	 8.7937176949014462e-01 3.6171829980612503e-02 2.8202779907719215e-03
     	 	 7.6079438865903654e-02 4.0507632612955521e-02 2.8892115253874038e-03
     	 	 4.0507632612955521e-02 8.8341292852114084e-01 2.8892115253874038e-03
     	 	 8.8341292852114084e-01 7.6079438865903654e-02 2.8892115253874038e-03
     	 	 1.4994597748785785e-01 3.5835058933034056e-02 3.2895706753576235e-03
     	 	 3.5835058933034056e-02 8.1421896357910806e-01 3.2895706753576235e-03
     	 	 8.1421896357910806e-01 1.4994597748785785e-01 3.2895706753576235e-03
     	 	 1.5095534117900294e-01 7.9691370268293504e-01 3.3648265829213809e-03
     	 	 7.9691370268293504e-01 5.2130956138061957e-02 3.3648265829213809e-03
     	 	 5.2130956138061957e-02 1.5095534117900294e-01 3.3648265829213809e-03
     	 	 2.4478331097657494e-01 3.2689779930828645e-02 3.7877712179341851e-03
     	 	 3.2689779930828645e-02 7.2252690909259643e-01 3.7877712179341851e-03
     	 	 7.2252690909259643e-01 2.4478331097657494e-01 3.7877712179341851e-03
     	 	 1.7067443366794324e-01 7.8755869338188678e-02 4.0729175231668142e-03
     	 	 7.8755869338188678e-02 7.5056969699386811e-01 4.0729175231668142e-03
     	 	 7.5056969699386811e-01 1.7067443366794324e-01 4.0729175231668142e-03
     	 	 3.7194261169194315e-01 5.9342856949177003e-01 4.5409176198132816e-03
     	 	 5.9342856949177003e-01 3.4628818816286877e-02 4.5409176198132816e-03
     	 	 3.4628818816286877e-02 3.7194261169194315e-01 4.5409176198132816e-03
     	 	 3.5179201043222375e-01 3.6352873144138077e-02 4.7004476521541804e-03
     	 	 3.6352873144138077e-02 6.1185511642363821e-01 4.7004476521541804e-03
     	 	 6.1185511642363821e-01 3.5179201043222375e-01 4.7004476521541804e-03
     	 	 9.8440061147214972e-02 9.6959138605557882e-02 4.7620022720353764e-03
     	 	 9.6959138605557882e-02 8.0460080024722713e-01 4.7620022720353764e-03
     	 	 8.0460080024722713e-01 9.8440061147214972e-02 4.7620022720353764e-03
     	 	 2.6086502629810787e-01 6.8408965318422899e-01 5.0536040726336089e-03
     	 	 6.8408965318422899e-01 5.5045320517663199e-02 5.0536040726336089e-03
     	 	 5.5045320517663199e-02 2.6086502629810787e-01 5.0536040726336089e-03
     	 	 3.6658214432706732e-01 5.5078190255175696e-01 5.4295634038574207e-03
     	 	 5.5078190255175696e-01 8.2635953121175665e-02 5.4295634038574207e-03
     	 	 8.2635953121175665e-02 3.6658214432706732e-01 5.4295634038574207e-03
     	 	 4.6873598774383901e-01 4.1136822171029049e-02 5.5844920931438441e-03
     	 	 4.1136822171029049e-02 4.9012719008513189e-01 5.5844920931438441e-03
     	 	 4.9012719008513189e-01 4.6873598774383901e-01 5.5844920931438441e-03
     	 	 2.5761793161354124e-01 8.2486517285323274e-02 5.8861484326160757e-03
     	 	 8.2486517285323274e-02 6.5989555110113551e-01 5.8861484326160757e-03
     	 	 6.5989555110113551e-01 2.5761793161354124e-01 5.8861484326160757e-03
     	 	 1.8451795241283384e-01 7.1257592580373208e-01 6.0712020042385769e-03
     	 	 7.1257592580373208e-01 1.0290612178343406e-01 6.0712020042385769e-03
     	 	 1.0290612178343406e-01 1.8451795241283384e-01 6.0712020042385769e-03
     	 	 2.8120911865122772e-01 6.0525730819752110e-01 6.2763494633498434e-03
     	 	 6.0525730819752110e-01 1.1353357315125112e-01 6.2763494633498434e-03
     	 	 1.1353357315125112e-01 2.8120911865122772e-01 6.2763494633498434e-03
     	 	 1.7359149167563334e-01 1.4220931869919087e-01 6.3907206380491941e-03
     	 	 1.4220931869919087e-01 6.8419918962517579e-01 6.3907206380491941e-03
     	 	 6.8419918962517579e-01 1.7359149167563334e-01 6.3907206380491941e-03
     	 	 4.4236202799582158e-01 4.5498832765797559e-01 6.6234206938123258e-03
     	 	 4.5498832765797559e-01 1.0264964434620283e-01 6.6234206938123258e-03
     	 	 1.0264964434620283e-01 4.4236202799582158e-01 6.6234206938123258e-03
     	 	 3.5936822655579759e-01 9.0795315699793919e-02 6.9141207817560758e-03
     	 	 9.0795315699793919e-02 5.4983645774440848e-01 6.9141207817560758e-03
     	 	 5.4983645774440848e-01 3.5936822655579759e-01 6.9141207817560758e-03
     	 	 1.8213426892674237e-01 2.2866704214072983e-01 7.9641060810751573e-03
     	 	 2.2866704214072983e-01 5.8919868893252780e-01 7.9641060810751573e-03
     	 	 5.8919868893252780e-01 1.8213426892674237e-01 7.9641060810751573e-03
     	 	 2.6734304273628207e-01 1.5618441381865139e-01 8.3729785692519248e-03
     	 	 1.5618441381865139e-01 5.7647254344506660e-01 8.3729785692519248e-03
     	 	 5.7647254344506660e-01 2.6734304273628207e-01 8.3729785692519248e-03
     	 	 3.6529032090656272e-01 1.7379280231853739e-01 9.3873052768966153e-03
     	 	 1.7379280231853739e-01 4.6091687677489984e-01 9.3873052768966153e-03
     	 	 4.6091687677489984e-01 3.6529032090656272e-01 9.3873052768966153e-03
     	 	 3.4506482660138488e-01 4.8229912538917341e-01 9.8690025400934873e-03
     	 	 4.8229912538917341e-01 1.7263604800944166e-01 9.8690025400934873e-03
     	 	 1.7263604800944166e-01 3.4506482660138488e-01 9.8690025400934873e-03
     	 	 2.6556222786287531e-01 2.5680262970384421e-01 1.0143142179343140e-02
     	 	 2.5680262970384421e-01 4.7763514243328048e-01 1.0143142179343140e-02
     	 	 4.7763514243328048e-01 2.6556222786287531e-01 1.0143142179343140e-02
     	 	 3.6295638550177745e-01 3.7155094737369060e-01 1.0812671788973811e-02
     	 	 3.7155094737369060e-01 2.6549266712453196e-01 1.0812671788973811e-02
     	 	 2.6549266712453196e-01 3.6295638550177745e-01 1.0812671788973811e-02
     	 	 ];


    case 26

        % SET: OTHER RULES
        % CARDINALITY RULE  :    130
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 1.971e-15

        XYW=[
    	 	 3.3333333333333331e-01 3.3333333333333331e-01 1.0243331294611614e-02
     	 	 6.6737122576466065e-02 6.6737122576466065e-02 2.4569126514830076e-03
     	 	 6.6737122576466065e-02 8.6652575484706784e-01 2.4569126514830076e-03
     	 	 8.6652575484706784e-01 6.6737122576466065e-02 2.4569126514830076e-03
     	 	 6.3401164920766830e-03 6.3401164920766830e-03 2.6347655834093578e-04
     	 	 6.3401164920766830e-03 9.8731976701584667e-01 2.6347655834093578e-04
     	 	 9.8731976701584667e-01 6.3401164920766830e-03 2.6347655834093578e-04
     	 	 4.9375303289638478e-01 4.9375303289638478e-01 2.6510795909336715e-03
     	 	 4.9375303289638478e-01 1.2493934207230439e-02 2.6510795909336715e-03
     	 	 1.2493934207230439e-02 4.9375303289638478e-01 2.6510795909336715e-03
     	 	 3.8878749710759397e-01 3.8878749710759397e-01 9.7340339185914334e-03
     	 	 3.8878749710759397e-01 2.2242500578481206e-01 9.7340339185914334e-03
     	 	 2.2242500578481206e-01 3.8878749710759397e-01 9.7340339185914334e-03
     	 	 2.7314710092907868e-01 2.7314710092907868e-01 9.7678234616237654e-03
     	 	 2.7314710092907868e-01 4.5370579814184264e-01 9.7678234616237654e-03
     	 	 4.5370579814184264e-01 2.7314710092907868e-01 9.7678234616237654e-03
     	 	 4.7182856332116602e-01 4.7182856332116602e-01 5.7642518173284434e-03
     	 	 4.7182856332116602e-01 5.6342873357667966e-02 5.7642518173284434e-03
     	 	 5.6342873357667966e-02 4.7182856332116602e-01 5.7642518173284434e-03
     	 	 1.5420143036454417e-01 1.5420143036454417e-01 6.6276297242726309e-03
     	 	 1.5420143036454417e-01 6.9159713927091171e-01 6.6276297242726309e-03
     	 	 6.9159713927091171e-01 1.5420143036454417e-01 6.6276297242726309e-03
     	 	 2.1204316330220552e-01 2.1204316330220552e-01 8.4721725392640414e-03
     	 	 2.1204316330220552e-01 5.7591367339558897e-01 8.4721725392640414e-03
     	 	 5.7591367339558897e-01 2.1204316330220552e-01 8.4721725392640414e-03
     	 	 4.3598541938438318e-01 4.3598541938438318e-01 8.2062003012939467e-03
     	 	 4.3598541938438318e-01 1.2802916123123365e-01 8.2062003012939467e-03
     	 	 1.2802916123123365e-01 4.3598541938438318e-01 8.2062003012939467e-03
     	 	 8.0071654940316539e-02 4.7946609754366785e-03 6.9926322408013562e-04
     	 	 8.0071654940316539e-02 9.1513368408424678e-01 6.9926322408013562e-04
     	 	 4.7946609754366785e-03 8.0071654940316539e-02 6.9926322408013562e-04
     	 	 4.7946609754366785e-03 9.1513368408424678e-01 6.9926322408013562e-04
     	 	 9.1513368408424678e-01 8.0071654940316539e-02 6.9926322408013562e-04
     	 	 9.1513368408424678e-01 4.7946609754366785e-03 6.9926322408013562e-04
     	 	 3.1643611571530769e-02 2.9155196206835845e-02 6.0278238685844236e-04
     	 	 3.1643611571530769e-02 9.3920119222163345e-01 6.0278238685844236e-04
     	 	 2.9155196206835845e-02 3.1643611571530769e-02 6.0278238685844236e-04
     	 	 2.9155196206835845e-02 9.3920119222163345e-01 6.0278238685844236e-04
     	 	 9.3920119222163345e-01 3.1643611571530769e-02 6.0278238685844236e-04
     	 	 9.3920119222163345e-01 2.9155196206835845e-02 6.0278238685844236e-04
     	 	 7.5380047515398660e-02 2.6209364022498662e-02 1.6527723564838340e-03
     	 	 7.5380047515398660e-02 8.9841058846210275e-01 1.6527723564838340e-03
     	 	 2.6209364022498662e-02 7.5380047515398660e-02 1.6527723564838340e-03
     	 	 2.6209364022498662e-02 8.9841058846210275e-01 1.6527723564838340e-03
     	 	 8.9841058846210275e-01 7.5380047515398660e-02 1.6527723564838340e-03
     	 	 8.9841058846210275e-01 2.6209364022498662e-02 1.6527723564838340e-03
     	 	 3.3100034336032272e-02 5.6981179168752180e-03 5.4285367149837702e-04
     	 	 3.3100034336032272e-02 9.6120184774709250e-01 5.4285367149837702e-04
     	 	 5.6981179168752180e-03 3.3100034336032272e-02 5.4285367149837702e-04
     	 	 5.6981179168752180e-03 9.6120184774709250e-01 5.4285367149837702e-04
     	 	 9.6120184774709250e-01 3.3100034336032272e-02 5.4285367149837702e-04
     	 	 9.6120184774709250e-01 5.6981179168752180e-03 5.4285367149837702e-04
     	 	 1.3248618961456729e-01 4.1724722742120947e-02 3.2017989498564071e-03
     	 	 1.3248618961456729e-01 8.2578908764331183e-01 3.2017989498564071e-03
     	 	 4.1724722742120947e-02 1.3248618961456729e-01 3.2017989498564071e-03
     	 	 4.1724722742120947e-02 8.2578908764331183e-01 3.2017989498564071e-03
     	 	 8.2578908764331183e-01 1.3248618961456729e-01 3.2017989498564071e-03
     	 	 8.2578908764331183e-01 4.1724722742120947e-02 3.2017989498564071e-03
     	 	 1.0868713291440210e-01 1.0004565910652756e-01 2.3071055381891576e-03
     	 	 1.0868713291440210e-01 7.9126720797907035e-01 2.3071055381891576e-03
     	 	 1.0004565910652756e-01 1.0868713291440210e-01 2.3071055381891576e-03
     	 	 1.0004565910652756e-01 7.9126720797907035e-01 2.3071055381891576e-03
     	 	 7.9126720797907035e-01 1.0868713291440210e-01 2.3071055381891576e-03
     	 	 7.9126720797907035e-01 1.0004565910652756e-01 2.3071055381891576e-03
     	 	 2.5027231329052646e-01 1.2061440220524904e-01 7.1897366137993659e-03
     	 	 2.5027231329052646e-01 6.2911328450422455e-01 7.1897366137993659e-03
     	 	 1.2061440220524904e-01 2.5027231329052646e-01 7.1897366137993659e-03
     	 	 1.2061440220524904e-01 6.2911328450422455e-01 7.1897366137993659e-03
     	 	 6.2911328450422455e-01 2.5027231329052646e-01 7.1897366137993659e-03
     	 	 6.2911328450422455e-01 1.2061440220524904e-01 7.1897366137993659e-03
     	 	 3.8902206204276174e-01 2.9537942516907837e-02 4.1298836085434170e-03
     	 	 3.8902206204276174e-01 5.8143999544033032e-01 4.1298836085434170e-03
     	 	 2.9537942516907837e-02 3.8902206204276174e-01 4.1298836085434170e-03
     	 	 2.9537942516907837e-02 5.8143999544033032e-01 4.1298836085434170e-03
     	 	 5.8143999544033032e-01 3.8902206204276174e-01 4.1298836085434170e-03
     	 	 5.8143999544033032e-01 2.9537942516907837e-02 4.1298836085434170e-03
     	 	 3.5850929642766155e-01 8.7378465163844524e-02 6.8639791080428465e-03
     	 	 3.5850929642766155e-01 5.5411223840849400e-01 6.8639791080428465e-03
     	 	 8.7378465163844524e-02 3.5850929642766155e-01 6.8639791080428465e-03
     	 	 8.7378465163844524e-02 5.5411223840849400e-01 6.8639791080428465e-03
     	 	 5.5411223840849400e-01 3.5850929642766155e-01 6.8639791080428465e-03
     	 	 5.5411223840849400e-01 8.7378465163844524e-02 6.8639791080428465e-03
     	 	 1.8686917947622156e-01 7.6311901512959412e-02 5.1988227640871586e-03
     	 	 1.8686917947622156e-01 7.3681891901081897e-01 5.1988227640871586e-03
     	 	 7.6311901512959412e-02 1.8686917947622156e-01 5.1988227640871586e-03
     	 	 7.6311901512959412e-02 7.3681891901081897e-01 5.1988227640871586e-03
     	 	 7.3681891901081897e-01 1.8686917947622156e-01 5.1988227640871586e-03
     	 	 7.3681891901081897e-01 7.6311901512959412e-02 5.1988227640871586e-03
     	 	 4.1470590959030629e-01 2.0575309653708658e-03 9.2857373549904137e-04
     	 	 4.1470590959030629e-01 5.8323655944432284e-01 9.2857373549904137e-04
     	 	 2.0575309653708658e-03 4.1470590959030629e-01 9.2857373549904137e-04
     	 	 2.0575309653708658e-03 5.8323655944432284e-01 9.2857373549904137e-04
     	 	 5.8323655944432284e-01 4.1470590959030629e-01 9.2857373549904137e-04
     	 	 5.8323655944432284e-01 2.0575309653708658e-03 9.2857373549904137e-04
     	 	 3.1941530538343871e-01 1.7047872849724896e-01 8.7995835903475986e-03
     	 	 3.1941530538343871e-01 5.1010596611931225e-01 8.7995835903475986e-03
     	 	 1.7047872849724896e-01 3.1941530538343871e-01 8.7995835903475986e-03
     	 	 1.7047872849724896e-01 5.1010596611931225e-01 8.7995835903475986e-03
     	 	 5.1010596611931225e-01 3.1941530538343871e-01 8.7995835903475986e-03
     	 	 5.1010596611931225e-01 1.7047872849724896e-01 8.7995835903475986e-03
     	 	 1.4373762619976402e-01 7.9996080914843028e-03 1.4833808313282518e-03
     	 	 1.4373762619976402e-01 8.4826276570875170e-01 1.4833808313282518e-03
     	 	 7.9996080914843028e-03 1.4373762619976402e-01 1.4833808313282518e-03
     	 	 7.9996080914843028e-03 8.4826276570875170e-01 1.4833808313282518e-03
     	 	 8.4826276570875170e-01 1.4373762619976402e-01 1.4833808313282518e-03
     	 	 8.4826276570875170e-01 7.9996080914843028e-03 1.4833808313282518e-03
     	 	 2.8378813885947041e-01 5.1165873685137787e-02 5.0535622160443397e-03
     	 	 2.8378813885947041e-01 6.6504598745539178e-01 5.0535622160443397e-03
     	 	 5.1165873685137787e-02 2.8378813885947041e-01 5.0535622160443397e-03
     	 	 5.1165873685137787e-02 6.6504598745539178e-01 5.0535622160443397e-03
     	 	 6.6504598745539178e-01 2.8378813885947041e-01 5.0535622160443397e-03
     	 	 6.6504598745539178e-01 5.1165873685137787e-02 5.0535622160443397e-03
     	 	 2.1654666647347712e-01 2.2784599250895671e-02 3.1346689230402824e-03
     	 	 2.1654666647347712e-01 7.6066873427562720e-01 3.1346689230402824e-03
     	 	 2.2784599250895671e-02 2.1654666647347712e-01 3.1346689230402824e-03
     	 	 2.2784599250895671e-02 7.6066873427562720e-01 3.1346689230402824e-03
     	 	 7.6066873427562720e-01 2.1654666647347712e-01 3.1346689230402824e-03
     	 	 7.6066873427562720e-01 2.2784599250895671e-02 3.1346689230402824e-03
     	 	 3.1289850307487999e-01 9.4732979122135619e-03 2.2957791936993174e-03
     	 	 3.1289850307487999e-01 6.7762819901290650e-01 2.2957791936993174e-03
     	 	 9.4732979122135619e-03 3.1289850307487999e-01 2.2957791936993174e-03
     	 	 9.4732979122135619e-03 6.7762819901290650e-01 2.2957791936993174e-03
     	 	 6.7762819901290650e-01 3.1289850307487999e-01 2.2957791936993174e-03
     	 	 6.7762819901290650e-01 9.4732979122135619e-03 2.2957791936993174e-03
     	 	 2.2643479740771752e-01 4.6400773217565279e-04 5.6977445793410632e-04
     	 	 2.2643479740771752e-01 7.7310119486010676e-01 5.6977445793410632e-04
     	 	 4.6400773217565279e-04 2.2643479740771752e-01 5.6977445793410632e-04
     	 	 4.6400773217565279e-04 7.7310119486010676e-01 5.6977445793410632e-04
     	 	 7.7310119486010676e-01 2.2643479740771752e-01 5.6977445793410632e-04
     	 	 7.7310119486010676e-01 4.6400773217565279e-04 5.6977445793410632e-04
     	 	 ];


    case 27

        % SET: SLOBODKINS TAUSCH
        % CARDINALITY RULE  :    139
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 2.000e-13

        XYW=[
    	 	 9.8611320217822496e-01 6.7062758689002194e-03 3.1522043372512890e-04
     	 	 9.5962131570551612e-01 3.4885676369868897e-02 5.5188902753249827e-04
     	 	 9.5609435993477998e-01 6.5125210215328860e-03 6.9787908092239670e-04
     	 	 9.3604188691821710e-01 3.4348185113935920e-02 1.3213251580279524e-03
     	 	 8.4421654143544644e-01 7.9754207959595619e-02 3.0340332066669902e-03
     	 	 9.1026995162014790e-01 8.3627183357806029e-02 9.0626163011588059e-04
     	 	 9.0361502950669303e-01 6.2775713223666690e-03 1.0147316189826165e-03
     	 	 8.9316234596567134e-01 3.3066467009001475e-02 1.9951280756814785e-03
     	 	 7.4320159555597687e-01 1.3534635664545133e-01 3.8487253684859270e-03
     	 	 8.8517805997430776e-01 8.3275953579102488e-02 2.0707456928725923e-03
     	 	 8.4452447074924408e-01 1.5009219075986133e-01 1.0276710137996272e-03
     	 	 8.3126371170597868e-01 6.1008265269267368e-03 1.2683085706457679e-03
     	 	 8.3159003951873733e-01 3.1929481125968842e-02 2.5219960649497338e-03
     	 	 7.8465748021762605e-01 7.5725839378545420e-02 3.7531009403929420e-03
     	 	 7.8530810819371655e-01 1.4642569774515934e-01 3.5106114955243983e-03
     	 	 8.2005110206344412e-01 1.5159233447915149e-01 2.4524418413089900e-03
     	 	 7.6249085957352114e-01 2.3129815002403112e-01 1.3882385607030914e-03
     	 	 7.4246699490897095e-01 5.7203557275007071e-03 1.4139231206774525e-03
     	 	 7.5383179253528654e-01 3.0640189793025362e-02 2.9467029816406701e-03
     	 	 7.0664995020051369e-01 7.3645126746540640e-02 4.4890491090329833e-03
     	 	 6.7911213524294944e-01 1.3270038807404139e-01 4.7444423814591045e-03
     	 	 6.6101305279574496e-01 2.0144981165550782e-01 4.8478740081724890e-03
     	 	 6.9799984690074135e-01 2.2401517581042085e-01 4.5632566018253716e-03
     	 	 7.3138790758963479e-01 2.3604828922611509e-01 3.3488412195309936e-03
     	 	 6.7057557412471636e-01 3.2308158553361782e-01 1.5447044451418752e-03
     	 	 6.4046503682949618e-01 5.6089607833695616e-03 1.5316689857583028e-03
     	 	 6.6387745363869577e-01 2.9239551125771032e-02 3.1626615814794468e-03
     	 	 6.1612814519305803e-01 7.0755587482537241e-02 4.9644092575300948e-03
     	 	 6.0017774254818546e-01 1.3109020192764875e-01 5.7396501483795610e-03
     	 	 5.8383314619184257e-01 2.0169415783331313e-01 6.0528940210301954e-03
     	 	 5.7737001111709407e-01 2.7575650679203373e-01 6.0931390532537972e-03
     	 	 6.0708224851152948e-01 3.1241082151743449e-01 5.3380396025377481e-03
     	 	 6.3340233178317829e-01 3.3340679798217981e-01 3.7985838717066243e-03
     	 	 6.0074693472216434e-01 3.9128177223762745e-01 2.7354672957216852e-04
     	 	 5.3115471164820205e-01 5.8097114185947487e-03 1.6464988244021877e-03
     	 	 5.6256640892108312e-01 2.9728702577535418e-02 3.4818828456855389e-03
     	 	 5.1203282119010174e-01 7.1027382308329473e-02 5.1155584274788432e-03
     	 	 5.1680445339996317e-01 1.2343744525088057e-01 5.2613823664038059e-03
     	 	 4.9001287109937053e-01 1.8922768674659374e-01 6.6400499998308096e-03
     	 	 5.0521989120350175e-01 2.4178060993154238e-01 4.3531561657545919e-03
     	 	 4.7655763640180393e-01 3.1169825785908112e-01 7.1717019478195762e-03
     	 	 4.9666193442461648e-01 3.7081729816007275e-01 6.3754008554281665e-03
     	 	 5.1412326020663068e-01 4.1521454889925125e-01 5.1826241658107413e-03
     	 	 5.3050295989902863e-01 4.4077753706248651e-01 3.4799994600976493e-03
     	 	 5.6551876016327007e-01 4.2913667600419036e-01 1.3172597306140730e-03
     	 	 4.2040545352184633e-01 5.8762814160752356e-03 1.6490139363089160e-03
     	 	 4.5431552977780965e-01 3.0480846355513132e-02 3.6982087156541880e-03
     	 	 4.0571112543981558e-01 7.4879191771977688e-02 5.5377049219985349e-03
     	 	 4.2051546128098283e-01 1.3364906934541756e-01 6.4253914530952253e-03
     	 	 3.8807117620275078e-01 2.0581187026183084e-01 7.1038048261110754e-03
     	 	 4.0574431939926148e-01 2.7633869766885788e-01 7.5538364183235151e-03
     	 	 3.6943600020570766e-01 3.6014554719576441e-01 6.4561163276975388e-03
     	 	 3.9293631762014591e-01 4.1455176457464343e-01 7.1026431376772139e-03
     	 	 4.0842652763533882e-01 4.6977219723106101e-01 5.6001840829719290e-03
     	 	 4.1329714398818562e-01 5.1793888312392777e-01 4.6696632707506867e-03
     	 	 4.2299846014492437e-01 5.4784238657725737e-01 3.4520740325301165e-03
     	 	 4.6088605462259447e-01 5.3357736623301111e-01 1.5287495412445939e-03
     	 	 3.1423382690164392e-01 6.1210249024063468e-03 1.5957409337705472e-03
     	 	 3.4748622694985387e-01 3.1492328712547556e-02 3.6909650478892607e-03
     	 	 3.0322024462410169e-01 7.6474176646696812e-02 5.2850790919037813e-03
     	 	 3.2167715123257545e-01 1.3792579980754244e-01 6.7312751544707158e-03
     	 	 2.9207655586184178e-01 2.1123998261959687e-01 6.2535330393544480e-03
     	 	 3.1213288185015753e-01 2.4908700378796597e-01 2.3817650376880125e-03
     	 	 3.0205080727511213e-01 3.1012426358633050e-01 8.0505881286357037e-03
     	 	 2.8553901698091322e-01 4.0549283402004949e-01 7.2141133539957132e-03
     	 	 2.9259678737397787e-01 4.8674235752373413e-01 7.5962881811624068e-03
     	 	 3.1587661131721123e-01 5.4156912118635414e-01 6.2986098700177741e-03
     	 	 3.1499655908561031e-01 6.0617859111171335e-01 5.2823663800941039e-03
     	 	 3.1708277869585000e-01 6.5050627431691577e-01 3.7135904239946021e-03
     	 	 3.5354025247544030e-01 6.4040899636328741e-01 1.6228072728713802e-03
     	 	 2.1806535200297938e-01 6.1230682378974628e-03 1.4062974580499664e-03
     	 	 2.4656922532638470e-01 3.2043023498974393e-02 3.4245089517118605e-03
     	 	 2.1056047846913606e-01 7.6766296871516954e-02 4.5437310761233156e-03
     	 	 2.2754366398590886e-01 1.3756368267468425e-01 6.0977208225515096e-03
     	 	 2.1126663683138225e-01 2.1200903474036348e-01 6.2178500492513049e-03
     	 	 2.1568854666192594e-01 2.9737007953958666e-01 7.5005824977747966e-03
     	 	 2.0926392607396094e-01 3.9156549849482797e-01 7.6586392728846178e-03
     	 	 2.0563353997151346e-01 4.9004559877062681e-01 7.1740323440498775e-03
     	 	 2.0695796583404458e-01 5.7644197807529118e-01 6.6843644095081730e-03
     	 	 2.3032650132121602e-01 6.2891211119674773e-01 5.8227776456467881e-03
     	 	 2.2343374220040779e-01 6.9879506652469670e-01 4.7618991537868261e-03
     	 	 2.2125054152788615e-01 7.4631095061510599e-01 3.2103137247448885e-03
     	 	 2.5314977451731513e-01 7.4056457786490060e-01 1.5347485834970281e-03
     	 	 1.3626431710832743e-01 5.8707241001042477e-03 1.1032129056893667e-03
     	 	 1.5781202961668672e-01 3.1282352412551132e-02 2.8578149035751745e-03
     	 	 1.3480770325261515e-01 7.6249895336236842e-02 3.7014554310642695e-03
     	 	 1.4410662631231086e-01 1.4048174321548096e-01 5.4833411010513670e-03
     	 	 1.3882460796102281e-01 2.2090593806763292e-01 5.7312239881695736e-03
     	 	 1.3880817489768160e-01 3.0914124409149152e-01 6.3487792786097487e-03
     	 	 1.3484530823004226e-01 4.0042517492587570e-01 6.1169362832562951e-03
     	 	 1.3476960899251533e-01 4.8932539771263006e-01 5.9264871405652897e-03
     	 	 1.3296544115469633e-01 5.7599916300791099e-01 5.3748693217146358e-03
     	 	 1.3188669339087178e-01 6.5565473093019533e-01 5.2773327521366360e-03
     	 	 1.5203774722074714e-01 7.0903794222623151e-01 5.0558392056344621e-03
     	 	 1.4202740971757755e-01 7.8051614218914589e-01 4.0040700503871131e-03
     	 	 1.4021766262519253e-01 8.2775481018706598e-01 2.6254845652436271e-03
     	 	 1.6399997659277088e-01 8.2986486135574566e-01 1.2893512623595703e-03
     	 	 7.2959497429291198e-02 6.0582726926740535e-03 8.1952243719870437e-04
     	 	 8.6654486164372102e-02 3.0751222057033401e-02 2.0957510115072919e-03
     	 	 7.5358203353428355e-02 7.2466268804378536e-02 2.5564732988998117e-03
     	 	 7.7864003604224297e-02 1.3106030356146056e-01 3.7560924434702253e-03
     	 	 7.8456569583067792e-02 2.0579373211522403e-01 4.5376570095068064e-03
     	 	 7.6709674540074158e-02 2.9762562316106350e-01 5.2569339666591955e-03
     	 	 7.4880933158541496e-02 3.9846145358164131e-01 5.4445439636259252e-03
     	 	 7.4136871964021744e-02 5.0347542867078343e-01 5.4813198309203231e-03
     	 	 7.4792861455491910e-02 6.0474056865278303e-01 5.0772646838272983e-03
     	 	 7.0932909617103079e-02 7.0256569628856813e-01 4.6740489262349005e-03
     	 	 8.4462207775902520e-02 7.7250567760695299e-01 4.2897056823890589e-03
     	 	 7.7471473862688156e-02 8.4337141708425445e-01 3.0767733147474938e-03
     	 	 7.5956097759800167e-02 8.9120198090373659e-01 2.0245428429476347e-03
     	 	 9.0680401806259137e-02 9.0309019300705240e-01 1.0184549322051152e-03
     	 	 2.9858811409751662e-02 6.2101758983438803e-03 5.3390337875285781e-04
     	 	 3.5117045360160803e-02 3.2615506118935003e-02 1.4852007304202203e-03
     	 	 3.1884275619581293e-02 8.1664179292961700e-02 2.0953639604768316e-03
     	 	 3.1856174369935708e-02 1.5040392755045390e-01 2.8033152409381720e-03
     	 	 3.2821608506267141e-02 2.3553567109465848e-01 3.3622202378799527e-03
     	 	 3.1298221854722308e-02 3.3362574704722087e-01 3.6024176140175904e-03
     	 	 3.1036364895405844e-02 4.3777937085636359e-01 3.6372614157062933e-03
     	 	 3.0436289142749540e-02 5.4252497250560527e-01 3.5448140155105398e-03
     	 	 3.1587770135567350e-02 6.4221507497536479e-01 3.3870868830354487e-03
     	 	 2.8013522531887158e-02 7.3792408851720415e-01 2.8903681203788891e-03
     	 	 3.5213638871615105e-02 8.1413681869230337e-01 2.9634765458381555e-03
     	 	 3.1946910311900889e-02 8.8442030082717638e-01 2.1101878417141597e-03
     	 	 3.0727565399139345e-02 9.3464451363622225e-01 1.3647161886971536e-03
     	 	 3.7500274655102306e-02 9.5592556138309959e-01 7.0784798619509212e-04
     	 	 5.7799289988995639e-03 7.2643797853384779e-03 2.7354756214033527e-04
     	 	 6.7044326141401100e-03 3.7344416594025293e-02 7.1257872940163236e-04
     	 	 6.1229739813311035e-03 8.9478484001502101e-02 9.7067765987661253e-04
     	 	 6.0577568429821538e-03 1.6001969509818503e-01 1.2196967029895305e-03
     	 	 6.3469767916209952e-03 2.4512964303133428e-01 1.4812101168577656e-03
     	 	 5.9431405685229644e-03 3.4155336080745363e-01 1.5353292291077675e-03
     	 	 5.9854964711631986e-03 4.4526904747369289e-01 1.6238855821582871e-03
     	 	 5.7835632119574987e-03 5.5235443022147879e-01 1.5883057614110611e-03
     	 	 6.1179725060703793e-03 6.5724530432030337e-01 1.5962269314194063e-03
     	 	 5.1816106279619634e-03 7.5545052380899635e-01 1.2350154934563462e-03
     	 	 6.7499164892822483e-03 8.3931999829140969e-01 1.3403994183034385e-03
     	 	 6.1063186195866592e-03 9.0883723783112813e-01 9.3535453483508822e-04
     	 	 5.7826908136020538e-03 9.5894231395004004e-01 5.8687745007951963e-04
     	 	 7.1885966065162732e-03 9.8604625267100865e-01 3.1864387661913451e-04
     	 	 ];


        %
        %         % ALG. DEG.:   27
        %         % PTS CARD.:  141
        %         % NEG. W.  :    0
        %         % OUT PTS. :    0
        %         % M.E.INF. : 7.8e-16
        %
        %         xyw=[
        %             3.80714021181187134423851148312679e-01 3.80714021181187134423851148312679e-01 4.78004248372990679649685574759133e-03
        %             3.80714021181187134423851148312679e-01 2.38571957637625731152297703374643e-01 4.78004248372997531807415683147156e-03
        %             2.38571957637625731152297703374643e-01 3.80714021181187134423851148312679e-01 4.78004248372997011390372890105027e-03
        %             4.46667803703864552122837494607666e-01 4.46667803703864774167442419638974e-01 4.70507990472707714191269445791477e-03
        %             4.46667803703864552122837494607666e-01 1.06664392592270895754325010784669e-01 4.70507990472709882595614416800345e-03
        %             1.06664392592270895754325010784669e-01 4.46667803703864552122837494607666e-01 4.70507990472715433710737542583047e-03
        %             4.16141378805413242325528244691668e-01 4.16141378805411299435235150667722e-01 6.02511351207514912059481915207471e-03
        %             4.16141378805412576191713469597744e-01 1.67717242389175152927904832722561e-01 6.02511351207520636646952638670882e-03
        %             1.67717242389176068861900148476707e-01 4.16141378805410411256815450542490e-01 6.02511351207521504008690627074429e-03
        %             8.03046477884383352874309025537514e-02 8.03046477884382658984918634814676e-02 2.60631093640092612040426445219055e-03
        %             8.03046477884410553338412341872754e-02 8.39390704423123579225318735552719e-01 2.60631093640086540508260526394224e-03
        %             8.39390704423123246158411348005757e-01 8.03046477884383075318552869248379e-02 2.60631093640093869714946528404198e-03
        %             2.33400406669872106935059719035053e-01 2.33400406669869830977859237464145e-01 6.73565769902463064300324191435720e-03
        %             2.33400406669872523268693953468755e-01 5.33199186660256008174485486961203e-01 6.73565769902485008552295298045465e-03
        %             5.33199186660257451464417499664705e-01 2.33400406669870968956459478249599e-01 6.73565769902468094998404524176294e-03
        %             3.01165465166508772298925578070339e-01 3.01165465166509827010798971969052e-01 7.87398289068132195556160013438785e-03
        %             3.01165465166508494743169421781204e-01 3.97669069666983177047114850211074e-01 7.87398289068136705837197553137230e-03
        %             3.97669069666981012112216831155820e-01 3.01165465166509882521950203226879e-01 7.87398289068132542500855208800203e-03
        %             1.74779966354899923830501506927249e-01 1.74779966354900007097228353813989e-01 5.64122127234913985083242238260937e-03
        %             1.74779966354901311609282288372924e-01 6.50440067290198764560216204699827e-01 5.64122127234928643496614242280884e-03
        %             6.50440067290199874783240829856368e-01 1.74779966354900617719891897650086e-01 5.64122127234918929045148772161156e-03
        %             4.85565054185162214839266425769893e-01 4.85565054185163602618047207215568e-01 3.55861870643729661864429480999661e-03
        %             4.85565054185162603417325044574682e-01 2.88698916296747827570090549897941e-02 3.55861870643735603292334701563959e-03
        %             2.88698916296740264175735291019009e-02 4.85565054185165267952584144950379e-01 3.55861870643732003741122049689238e-03
        %             3.25715201801815776305737415441399e-02 3.25715201801815984472554532658251e-02 1.38866976447709288521037418462356e-03
        %             3.25715201801813555859688165128318e-02 9.34856959639637219439123327902053e-01 1.38866976447708226002908382668011e-03
        %             9.34856959639636775349913477839436e-01 3.25715201801817164084518196887075e-02 1.38866976447709483677428465853154e-03
        %             1.27570901904677180827007987318211e-01 1.27570901904678513094637537506060e-01 4.87162246140886070339126590056367e-03
        %             1.27570901904677569405066606123000e-01 7.44858196190645083234471712785307e-01 4.87162246140887544854081170342397e-03
        %             7.44858196190644861189866787753999e-01 1.27570901904677874716398378041049e-01 4.87162246140886764228516980779204e-03
        %             6.63921918095874714210724576446410e-03 6.63921918095869856984991841386545e-03 2.87721202835248982074972667888346e-04
        %             6.63921918095874454002203179925345e-03 9.86721561638082556022766311798478e-01 2.87721202835251258899534887447658e-04
        %             9.86721561638082667045068774314132e-01 6.63921918095871418236120220512930e-03 2.87721202835249795226602032016672e-04
        %             2.87042196593496612422313774004579e-01 3.07306047272726499952621992406421e-02 2.76589741688335749580929245894367e-03
        %             2.87042196593496612422313774004579e-01 6.82227198679230650846250227914425e-01 2.76589741688331282667978605616099e-03
        %             3.07306047272729344899122594370056e-02 2.87042196593496612422313774004579e-01 2.76589741688342298162051058341149e-03
        %             3.07306047272735693987044669484021e-02 6.82227198679237978318212753947591e-01 2.76589741688350017681519155132719e-03
        %             6.82227198679230539823947765398771e-01 2.87042196593496501400011311488925e-01 2.76589741688339782813010891970862e-03
        %             6.82227198679230539823947765398771e-01 3.07306047272726812202847668231698e-02 2.76589741688335272531973352272416e-03
        %             3.45087841715567555933574794835295e-01 1.29152640063450174778836299083196e-01 6.27871810201830089781527277636997e-03
        %             3.45087841715569942913077738921857e-01 5.25759518220981325598017974698450e-01 6.27871810201817946717195439987336e-03
        %             1.29152640063449231089265367700136e-01 3.45087841715568111045087107413565e-01 6.27871810201825406028142140257842e-03
        %             1.29152640063449064555811673926655e-01 5.25759518220981436620320437214104e-01 6.27871810201825319291968341417487e-03
        %             5.25759518220981769687227824761067e-01 3.45087841715568888201204345023143e-01 6.27871810201821763108842588962943e-03
        %             5.25759518220982435821042599854991e-01 1.29152640063450147023260683454282e-01 6.27871810201830003045353478796642e-03
        %             3.75930157048661783836251970569720e-01 2.80334860952500333763914852625021e-02 3.19757634972721912353099682491120e-03
        %             3.75930157048661062191285964217968e-01 5.96036356856089133415821379458066e-01 3.19757634972717749016757338154093e-03
        %             2.80334860952498494957030317209501e-02 3.75930157048663338148486445788876e-01 3.19757634972721652144578285970056e-03
        %             2.80334860952496933705901938083116e-02 5.96036356856093019196407567505958e-01 3.19757634972729241559785684501094e-03
        %             5.96036356856087579103586904238909e-01 3.75930157048662505481217976921471e-01 3.19757634972720914887100995827041e-03
        %             5.96036356856088134215099216817180e-01 2.80334860952501097042244282420143e-02 3.19757634972721912353099682491120e-03
        %             3.16945588933132571529682763866731e-01 2.09130921137669179010742936952738e-01 6.85769661527540173862060868259505e-03
        %             3.16945588933134181353068470343715e-01 4.73923489929198582526481686727493e-01 6.85769661527534015593721150594320e-03
        %             2.09130921137668818188259933776862e-01 3.16945588933130517617087207327131e-01 6.85769661527545898449531591722916e-03
        %             2.09130921137667263876025458557706e-01 4.73923489929199581727203849368379e-01 6.85769661527539046291801483334893e-03
        %             4.73923489929199137637993999305763e-01 3.16945588933131960907019220030634e-01 6.85769661527542862683448632310501e-03
        %             4.73923489929198471504179224211839e-01 2.09130921137669234521894168210565e-01 6.85769661527541561640841649705180e-03
        %             4.07228393042719349903535430712509e-01 6.60389128497390898164809414083720e-02 4.93113505949480026430142842741589e-03
        %             4.07228393042719960526198974548606e-01 5.26732694107541865591315399797168e-01 4.93113505949475863093800498404562e-03
        %             6.60389128497382571492124725409667e-02 4.07228393042721403816130987252109e-01 4.93113505949478465179014463615204e-03
        %             6.60389128497380351046075475096586e-02 5.26732694107542753769735099922400e-01 4.93113505949479419276926250859105e-03
        %             5.26732694107540644345988312124973e-01 4.07228393042720793193467443416012e-01 4.93113505949477684553450274052011e-03
        %             5.26732694107541532524408012250206e-01 6.60389128497391314498443648517423e-02 4.93113505949480026430142842741589e-03
        %             2.13553598457823901046737091746763e-01 4.10305768191819505985584726204252e-02 3.22768645246485769151334466187109e-03
        %             2.13553598457824983514186101274390e-01 7.45415824722993392015268909744918e-01 3.22768645246482343072469411993097e-03
        %             4.10305768191816105927571811662347e-02 2.13553598457823234912922316652839e-01 3.22768645246482516544817009673807e-03
        %             4.10305768191830053104318665191386e-02 7.45415824722999609264206810621545e-01 3.22768645246473235774220533755852e-03
        %             7.45415824722994613260595997417113e-01 2.13553598457823651246556551086542e-01 3.22768645246482169600121814312388e-03
        %             7.45415824722993947126781222323189e-01 4.10305768191819297818767608987400e-02 3.22768645246486853353506951691543e-03
        %             3.28852878068892851004534350067843e-01 5.29964037179900433749413224404634e-03 1.46391318089954844232358777134095e-03
        %             3.28852878068891962826114649942610e-01 6.65847481559309062326690309419064e-01 1.46391318089954193711055285831435e-03
        %             5.29964037179904423613407971060951e-03 3.28852878068892295893022037489573e-01 1.46391318089956427167530605970569e-03
        %             5.29964037179900693957934620925698e-03 6.65847481559309506415900159481680e-01 1.46391318089955538121749167856933e-03
        %             6.65847481559308063125968146778177e-01 3.28852878068892851004534350067843e-01 1.46391318089956492219660955100835e-03
        %             6.65847481559308063125968146778177e-01 5.29964037179901908264367804690664e-03 1.46391318089955061072793274234982e-03
        %             1.39295306142148439532135739682417e-01 6.30739954149516918180395919080183e-02 3.56531765524351800314417637594033e-03
        %             1.39295306142150382422428833706363e-01 7.97630698442899022104768391727703e-01 3.56531765524344904788600629785833e-03
        %             6.30739954149508869063467386695265e-02 1.39295306142148717087891895971552e-01 3.56531765524351540105896241072969e-03
        %             6.30739954149510811953760480719211e-02 7.97630698442904129130681667447789e-01 3.56531765524351106425027246871196e-03
        %             7.97630698442900243350095479399897e-01 1.39295306142148994643648052260687e-01 3.56531765524351843682504537014211e-03
        %             7.97630698442900465394700404431205e-01 6.30739954149509424174979699273536e-02 3.56531765524351496737809341652792e-03
        %             2.55246254696977592502094012161251e-01 1.48962850938239937947926705419377e-01 6.17383156543062534826749043759264e-03
        %             2.55246254696979923970445724989986e-01 5.95790894364780276859505647735205e-01 6.17383156543068866567436359105159e-03
        %             1.48962850938240493059439017997647e-01 2.55246254696977592502094012161251e-01 6.17383156543070080873869542870125e-03
        %             1.48962850938240187748107246079599e-01 5.95790894364781498104832735407399e-01 6.17383156543076412614556858216019e-03
        %             5.95790894364780942993320422829129e-01 2.55246254696978758236269868575619e-01 6.17383156543069820665348146349061e-03
        %             5.95790894364782275260949973016977e-01 1.48962850938240409792712171110907e-01 6.17383156543066784899265186936645e-03
        %             2.08376015600373692970848082950397e-01 9.46970824331308386190286796590954e-02 5.34685029480811303131959633105907e-03
        %             2.08376015600374386860238473673235e-01 6.96926901966494760642945038853213e-01 5.34685029480813645008652201795485e-03
        %             9.46970824331302557519407514519116e-02 2.08376015600375219527506942540640e-01 5.34685029480814599106563989039387e-03
        %             9.46970824331309912746945656181197e-02 6.96926901966496092910574589041062e-01 5.34685029480815986885344770485062e-03
        %             6.96926901966494649620642576337559e-01 2.08376015600374914216175170622591e-01 5.34685029480815379732128178602579e-03
        %             6.96926901966495426776759813947137e-01 9.46970824331310467858457968759467e-02 5.34685029480812777646914213391938e-03
        %             4.40010551946215577867604906714405e-01 5.58071701526011588329057033774916e-03 1.62123379881968284615956221728084e-03
        %             4.40010551946214800711487669104827e-01 5.54408731038525171008757297386182e-01 1.62123379881966094527567801009127e-03
        %             5.58071701525999532000898994965610e-03 4.40010551946215411334151212940924e-01 1.62123379881965639162655357097265e-03
        %             5.58071701526001006515853575251640e-03 5.54408731038525171008757297386182e-01 1.62123379881965964423307102748595e-03
        %             5.54408731038524282830337597260950e-01 4.40010551946215799912209831745713e-01 1.62123379881965942739263653038506e-03
        %             5.54408731038524393852640059776604e-01 5.58071701526013149580185412901301e-03 1.62123379881968588192564517669325e-03
        %             3.02220941227820782959412326817983e-01 7.50769024331961326579332194341987e-02 5.46530554645664572166463557323368e-03
        %             3.02220941227821282559773408138426e-01 6.22702156338982737437959258386400e-01 5.46530554645662924179161379356628e-03
        %             7.50769024331959938800551412896311e-02 3.02220941227822226249344339521485e-01 5.46530554645663444596204172398757e-03
        %             7.50769024331963685803259522799635e-02 6.22702156338983514594076495995978e-01 5.46530554645665613000549143407625e-03
        %             6.22702156338981849259539558261167e-01 3.02220941227821948693588183232350e-01 5.46530554645663965013246965440885e-03
        %             6.22702156338983181527169108449016e-01 7.50769024331962714358112975787662e-02 5.46530554645665439528201545726915e-03
        %             8.19468025835337066098418290494010e-02 6.98252932445894529400742811731106e-03 1.00756156364484881007848038336761e-03
        %             8.19468025835336649764784056060307e-02 9.11070668092007429628154113743221e-01 1.00756156364483384808850008340642e-03
        %             6.98252932445898606000911357227778e-03 8.19468025835330959871782852133038e-02 1.00756156364485097848282535437647e-03
        %             6.98252932445910922537590792558149e-03 9.11070668092007540650456576258875e-01 1.00756156364486962676019210505274e-03
        %             9.11070668092007651672759038774529e-01 8.19468025835333874207222493168956e-02 1.00756156364485444792977730799066e-03
        %             9.11070668092007318605851651227567e-01 6.98252932445894442664569012890752e-03 1.00756156364484924375934937756938e-03
        %             3.43649699121420029723772415763960e-02 6.09356940376482372756505867528176e-03 5.98386804236582508370601019009882e-04
        %             3.43649699121420584835284728342231e-02 9.59541460684093183708398555609165e-01 5.98386804236578822083214568294807e-04
        %             6.09356940376478382892511120871859e-03 3.43649699121417254166210852872609e-02 5.98386804236574702114959123377957e-04
        %             6.09356940376473178722083190450576e-03 9.59541460684093294730701018124819e-01 5.98386804236573509492569389323080e-04
        %             9.59541460684093405753003480640473e-01 3.43649699121418225611357399884582e-02 5.98386804236577846301259331340816e-04
        %             9.59541460684093072686096093093511e-01 6.09356940376485148314067430419527e-03 5.98386804236585435716466729871854e-04
        %             8.01120738471011728520920769369695e-02 3.50344225276972565108479784612427e-02 2.16357901768035251754973558035999e-03
        %             8.01120738471009091741237284622912e-02 8.84853503625202431059904029098107e-01 2.16357901768029960848371828774361e-03
        %             3.50344225276974022276199605130387e-02 8.01120738471011867298798847514263e-02 2.16357901768034818074104563834226e-03
        %             3.50344225276981377503737746792467e-02 8.84853503625201098792274478910258e-01 2.16357901768039892140271795994977e-03
        %             8.84853503625201209814576941425912e-01 8.01120738471013948966970019682776e-02 2.16357901768035251754973558035999e-03
        %             8.84853503625201542881484328972874e-01 3.50344225276972634497418823684711e-02 2.16357901768035251754973558035999e-03
        %             1.47213431898922580964850226337148e-01 1.93520013180395883400919387895556e-02 2.31119355589056319627561109086855e-03
        %             1.47213431898922331164669685676927e-01 8.33434566783038399684357955266023e-01 2.31119355589056016050952813145614e-03
        %             1.93520013180388666951259324378043e-02 1.47213431898922081364489145016705e-01 2.31119355589054541535998232859583e-03
        %             1.93520013180379160666610971475166e-02 8.33434566783040176041197355516488e-01 2.31119355589054498167911333439406e-03
        %             8.33434566783038732751265342812985e-01 1.47213431898922497698123379450408e-01 2.31119355589054931848780327641180e-03
        %             8.33434566783038399684357955266023e-01 1.93520013180390089424509625359860e-02 2.31119355589056189523300410826323e-03
        %             2.29719653257843187121878258949437e-01 7.33247254904042990858448192170727e-03 1.69712686940351551584393874350098e-03
        %             2.29719653257842743032668408886821e-01 7.62947874193116826191385371203069e-01 1.69712686940351096219481430438236e-03
        %             7.33247254904039608147670037396892e-03 2.29719653257842659765941562000080e-01 1.69712686940350944431177282467615e-03
        %             7.33247254904046026624531151583142e-03 7.62947874193117381302897683781339e-01 1.69712686940351421480133176089566e-03
        %             7.62947874193116382102175521140452e-01 2.29719653257843242633029490207264e-01 1.69712686940351074535437980728148e-03
        %             7.62947874193116382102175521140452e-01 7.33247254904043511275490985212855e-03 1.69712686940351573268437324060187e-03
        %             1.47655521119869653778877705008199e-01 4.90328443463460125414932200271778e-04 4.23303067881970697308030571193171e-04
        %             1.47655521119869542756575242492545e-01 8.51854150436667345580588062148308e-01 4.23303067881939960176440607142467e-04
        %             4.90328443462847009086391647514347e-04 1.47655521119868987645062929914275e-01 4.23303067881921745579942850667976e-04
        %             4.90328443461913619436098876747110e-04 8.51854150436668899892822537367465e-01 4.23303067881843845653849767174393e-04
        %             8.51854150436667678647495449695271e-01 1.47655521119869515000999626863631e-01 4.23303067881917408771252908650240e-04
        %             8.51854150436667345580588062148308e-01 4.90328443462949249351257030582474e-04 4.23303067881928576053629509345910e-04
        %             ];



    case 28

        % SET: SLOBODKINS TAUSCH
        % CARDINALITY RULE  :    148
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 7.268e-16

        XYW=[
    	 	 9.8811630042834653e-01 5.8784755640592552e-03 2.3309650293058113e-04
     	 	 9.6239922826209789e-01 5.6940531376022657e-03 5.2909863768214481e-04
     	 	 9.4908706117673847e-01 2.9879574568687669e-02 8.8776083945873345e-04
     	 	 9.6537346155039194e-01 3.1115611710522146e-02 3.3011585089672235e-04
     	 	 9.1613014773284929e-01 5.7659852638235675e-03 8.2263334183122546e-04
     	 	 9.1261208094301771e-01 2.9854016326389839e-02 1.5597857788843931e-03
     	 	 8.5440425409901821e-01 7.2903699596864574e-02 2.7147208894696259e-03
     	 	 8.9862639188888149e-01 7.1830793886964880e-02 1.6980596087726287e-03
     	 	 9.1923182507989720e-01 7.5096296223556208e-02 7.7163656812303453e-04
     	 	 8.5179231776654862e-01 5.9089669059367500e-03 1.0924026950612966e-03
     	 	 8.5561791516557517e-01 3.0653377052178691e-02 2.2536176055180830e-03
     	 	 7.9140332795655333e-01 7.4164127931704973e-02 3.6394609438450821e-03
     	 	 7.9204058488774642e-01 1.3186433489333263e-01 3.4690739957467104e-03
     	 	 8.3743420876791619e-01 1.3097856582378345e-01 2.3831928133944504e-03
     	 	 8.5747067992230364e-01 1.3648332063017229e-01 1.0732165238304017e-03
     	 	 7.7266316454941375e-01 5.6975151803119670e-03 1.2538916707543848e-03
     	 	 7.8166295485720372e-01 3.0390979251661596e-02 2.7917942231907508e-03
     	 	 7.1788447681512202e-01 7.2340054560546707e-02 4.0127486552347918e-03
     	 	 7.2935951521272269e-01 1.3460354768166283e-01 4.5712275162131267e-03
     	 	 7.2647853108214133e-01 2.0258100949471647e-01 3.7544738103465558e-03
     	 	 7.6445570559158016e-01 2.0599842230594945e-01 2.6984999812145641e-03
     	 	 7.8162197586922488e-01 2.1272097484310407e-01 1.1934991044745672e-03
     	 	 6.8181135082342970e-01 5.3477110881310465e-03 1.3048307880094998e-03
     	 	 6.9525553161532017e-01 2.8400687339583276e-02 2.9746055191071717e-03
     	 	 6.4170677313921409e-01 6.6914823710807633e-02 3.8868089993298735e-03
     	 	 6.6025503702772514e-01 1.2930017254015833e-01 5.1483017192798883e-03
     	 	 6.0769572963820950e-01 1.9958307789733559e-01 4.8425124162628490e-03
     	 	 6.6305606407676287e-01 2.0980009166723176e-01 5.0762123134605701e-03
     	 	 6.4530449733072204e-01 2.8282551898435698e-01 4.2423953646972485e-03
     	 	 6.7696404021232714e-01 2.9329657847413104e-01 3.0777348335250978e-03
     	 	 6.9415280754744635e-01 3.0014369582188122e-01 1.3428130660462273e-03
     	 	 5.8469266860335800e-01 5.2178037528088092e-03 1.3085234460654550e-03
     	 	 5.9797779912678561e-01 2.7237782141194780e-02 3.1006532808342214e-03
     	 	 5.5525345728603770e-01 6.6231463147820899e-02 4.2193184440199004e-03
     	 	 5.8149848096540335e-01 1.1975138736843420e-01 5.5480741758647195e-03
     	 	 5.4827700742303409e-01 1.8715541267211655e-01 5.0791426141897989e-03
     	 	 5.2966663210366449e-01 2.6611232788251388e-01 5.4642972425238880e-03
     	 	 5.7241742147245378e-01 2.9660263115318192e-01 6.1529352531981526e-03
     	 	 5.5900065240763941e-01 3.6916210487383816e-01 4.4961668698798160e-03
     	 	 5.8097133137898593e-01 3.8932695537025436e-01 3.2909973601109302e-03
     	 	 5.9874681062907675e-01 3.9556369401592767e-01 1.4321005416875938e-03
     	 	 4.8749531495280407e-01 5.4362266009064034e-03 1.3386535578052332e-03
     	 	 4.9446429917659285e-01 2.8181321890731324e-02 3.2887220797985072e-03
     	 	 4.6416722200292104e-01 6.8856345387775825e-02 4.3159200547133727e-03
     	 	 4.8461019453052367e-01 1.2257329228518857e-01 6.1043303068052729e-03
     	 	 4.7604266867364342e-01 1.8879281991512675e-01 5.5058668358379395e-03
     	 	 4.5124230317988456e-01 2.6635060301316910e-01 6.9422618448521300e-03
     	 	 4.5744088663344162e-01 3.4461161160183096e-01 6.3164031298032983e-03
     	 	 4.7845313457907057e-01 3.9451263356349253e-01 6.2552596296308223e-03
     	 	 4.6900405808691048e-01 4.6258191179064867e-01 4.5473940082200867e-03
     	 	 4.8180828371944528e-01 4.9003394427567998e-01 3.1644649228934848e-03
     	 	 4.9898485345205645e-01 4.9559073462978320e-01 1.4014356231022832e-03
     	 	 3.9216541204090127e-01 5.7538662549497417e-03 1.3898493688908658e-03
     	 	 3.9124476695502219e-01 2.9906739362701693e-02 3.3631060031916920e-03
     	 	 3.7662893335937375e-01 7.2299721695586960e-02 4.3119707295739959e-03
     	 	 3.8413629430330443e-01 1.2923570108606111e-01 6.3336389411780105e-03
     	 	 3.9089106565189025e-01 1.9812496849498148e-01 6.6849391665838127e-03
     	 	 3.6128677271480869e-01 2.7890124221137275e-01 7.0947185650772600e-03
     	 	 3.6893505302333351e-01 3.5913810268023499e-01 7.4914751341278937e-03
     	 	 3.7244653248205351e-01 4.3773743510573954e-01 6.7814364473204351e-03
     	 	 3.8397535038624087e-01 4.9610103218430540e-01 5.9561471710006522e-03
     	 	 3.7629262851030210e-01 5.5908792031330334e-01 4.3004972930775496e-03
     	 	 3.8355489624994532e-01 5.9007036420469039e-01 2.9011258950153353e-03
     	 	 3.9838903919307178e-01 5.9660088987543713e-01 1.2872364663115488e-03
     	 	 2.9919090891540001e-01 5.8754219285892632e-03 1.3683281840985945e-03
     	 	 2.9452735376789729e-01 3.0681554549478338e-02 3.1561908852601396e-03
     	 	 2.9129078023594068e-01 7.3980245071970444e-02 4.4172280740907687e-03
     	 	 2.8861943858130867e-01 1.3359677483089899e-01 6.0389076410993746e-03
     	 	 2.9921748342598231e-01 2.0490419145008973e-01 6.9998232633466254e-03
     	 	 2.7712895093739875e-01 2.8747507944721346e-01 6.7787978461252710e-03
     	 	 2.7889322553190188e-01 3.7277175109378802e-01 7.4046455912789213e-03
     	 	 2.8274859016688003e-01 4.5584344674941918e-01 7.1041070682837902e-03
     	 	 2.8547023986893760e-01 5.3075132375453293e-01 6.0348722241667053e-03
     	 	 2.9168736302262510e-01 5.8852462516220583e-01 5.1706597760741548e-03
     	 	 2.8701470132497664e-01 6.4428769133810326e-01 3.9300228988316819e-03
     	 	 2.8890114266816436e-01 6.8193539040962026e-01 2.9087471538893133e-03
     	 	 3.0033972215792482e-01 6.9409930103002893e-01 1.3461100386010637e-03
     	 	 2.1178969089629252e-01 5.8087032284440884e-03 1.2361076598445581e-03
     	 	 2.0865169814974438e-01 3.0409066217027127e-02 2.7270498584137481e-03
     	 	 2.0787685758748209e-01 7.4194080180685407e-02 4.2579162718716351e-03
     	 	 2.0383132643885660e-01 1.3556868462550098e-01 5.4634588054675798e-03
     	 	 2.1124663690911694e-01 2.1154752428248122e-01 6.8223921136411772e-03
     	 	 1.9969089566247444e-01 3.0034403114314445e-01 6.7633119803639785e-03
     	 	 1.9754893564058740e-01 3.9399443967154868e-01 7.1954842336554069e-03
     	 	 1.9965184999587382e-01 4.8720056989546251e-01 7.2261768295598531e-03
     	 	 2.0270853422325030e-01 5.7523164454911779e-01 6.6846095385127494e-03
     	 	 2.0523277730659650e-01 6.5311154326794774e-01 5.7789617064174280e-03
     	 	 2.0505802194054612e-01 7.1687033567285741e-01 4.3360716339246848e-03
     	 	 2.0420594158610372e-01 7.6355858842406277e-01 2.8357393701239461e-03
     	 	 2.1062651215365225e-01 7.8321501090076384e-01 1.3236527611992460e-03
     	 	 1.3478684951848352e-01 6.3634675765200134e-03 1.1424501873330164e-03
     	 	 1.3582212226048718e-01 3.3192161624494003e-02 2.4363880636647278e-03
     	 	 1.3251489110193604e-01 7.9159463089421581e-02 3.7624917411761675e-03
     	 	 1.3158267700353987e-01 1.4154876204354977e-01 4.5194824779336224e-03
     	 	 1.3535159206661207e-01 2.1602643136220287e-01 5.5436329576956144e-03
     	 	 1.3053937344300248e-01 3.0129453657171329e-01 5.7782070447950501e-03
     	 	 1.2750600275970569e-01 3.9529578558599798e-01 6.1769762662458420e-03
     	 	 1.2742030990050768e-01 4.9332227212962421e-01 6.3715561901124054e-03
     	 	 1.2959189994347620e-01 5.8838485161737208e-01 6.1073075619380874e-03
     	 	 1.3160422276608652e-01 6.7498569020552135e-01 5.4298957162759185e-03
     	 	 1.3157134812666893e-01 7.4919712861439292e-01 4.4148064613933023e-03
     	 	 1.3193962468003018e-01 8.0601288103084079e-01 3.2160002011785219e-03
     	 	 1.3254285467738158e-01 8.4412349928108288e-01 1.8762708897692604e-03
     	 	 1.3364776862940608e-01 8.6218381266343946e-01 7.6332775100266365e-04
     	 	 7.2727342867523470e-02 5.7032609785028845e-03 7.8287225963888244e-04
     	 	 7.6765872503423149e-02 3.0465206982990552e-02 1.8077619585799560e-03
     	 	 7.1990299553079118e-02 7.4891677955975386e-02 2.8376901680336650e-03
     	 	 7.3169084178418831e-02 1.3896966357689305e-01 3.7269423335170803e-03
     	 	 7.4130290445986402e-02 2.1959317928222505e-01 4.5906379741100720e-03
     	 	 7.2473533198749163e-02 3.1210158005688554e-01 4.9027456178706644e-03
     	 	 7.0619453225506224e-02 4.1134963575139677e-01 4.9515561363519421e-03
     	 	 6.9974490126607614e-02 5.1160628980667333e-01 4.9396937532384605e-03
     	 	 7.1163667995399527e-02 6.0937606807976608e-01 4.8426322898905217e-03
     	 	 7.2475955526205227e-02 7.0102718216730708e-01 4.4772790124068367e-03
     	 	 7.2540946062821021e-02 7.8211307548644238e-01 3.7841761563940407e-03
     	 	 7.2271653335721053e-02 8.4800787660355703e-01 2.9123777665096004e-03
     	 	 7.3983835665472064e-02 8.9321255970278501e-01 1.8882608879078446e-03
     	 	 7.2154291664442316e-02 9.2162828035209277e-01 8.3848303989769409e-04
     	 	 2.9034790833818436e-02 5.5553971093121801e-03 4.7741923017461421e-04
     	 	 3.2776568435270104e-02 2.8622422801037044e-02 1.1284803293963833e-03
     	 	 2.9132576668281729e-02 6.7591947794439999e-02 1.5716334371814755e-03
     	 	 3.0274505176151600e-02 1.2368127796281470e-01 2.1971838208958792e-03
     	 	 3.0651756834880861e-02 1.9705884031735094e-01 2.7930606221594776e-03
     	 	 3.0225837536893896e-02 2.8516232702095329e-01 3.1962132741690571e-03
     	 	 2.9641719604359018e-02 3.8386448753626989e-01 3.3769107950811709e-03
     	 	 2.8911931102452160e-02 4.8777236575333438e-01 3.3884690418941573e-03
     	 	 2.9103878596667854e-02 5.9095764025330244e-01 3.3045265389193825e-03
     	 	 2.9773901923607515e-02 6.8760632179720937e-01 3.0740948818015422e-03
     	 	 3.0039086848698382e-02 7.7305179658889467e-01 2.6479435093901423e-03
     	 	 2.9934424136767390e-02 8.4400249106075820e-01 2.1134765352452635e-03
     	 	 2.9728586397707146e-02 8.9943811799673001e-01 1.5990003662884110e-03
     	 	 3.1145017347164683e-02 9.3845696297703374e-01 1.1391083841439157e-03
     	 	 2.9072360598940028e-02 9.6497756478279884e-01 5.0565339046569353e-04
     	 	 5.3316045416260671e-03 4.8096976888459125e-03 1.7354100883669191e-04
     	 	 6.3391071105957097e-03 2.6663455558995762e-02 5.0786499004560649e-04
     	 	 5.5197013565473352e-03 6.7617053200577801e-02 7.1446246365193034e-04
     	 	 5.8135860411248075e-03 1.2649198141816514e-01 9.9402271005769732e-04
     	 	 5.8778822847544987e-03 2.0006790066904026e-01 1.2012804976071212e-03
     	 	 5.7759272414045215e-03 2.8521598006490612e-01 1.3324420668243994e-03
     	 	 5.7155188084795361e-03 3.7932854960549250e-01 1.4296660406600274e-03
     	 	 5.5473061234175836e-03 4.7988783448785521e-01 1.4591096714854882e-03
     	 	 5.5465926274309574e-03 5.8331637580900220e-01 1.4670757390719828e-03
     	 	 5.6775232986150392e-03 6.8434590725859634e-01 1.4246668879167403e-03
     	 	 5.7513943117255550e-03 7.7737928404598611e-01 1.2873562269889326e-03
     	 	 5.7348832402605021e-03 8.5768950775261643e-01 1.0652770830304136e-03
     	 	 5.6802706639484946e-03 9.2132922805183737e-01 7.8826747340372057e-04
     	 	 6.0040074450272707e-03 9.6501913945051954e-01 5.1801772848686757e-04
     	 	 5.4306756075850338e-03 9.8924881472914550e-01 1.9321400194384879e-04
     	 	 ];


    case 29

        % SET: SLOBODKINS TAUSCH
        % CARDINALITY RULE  :    158
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 8.119e-16

        XYW=[
    	 	 9.8754527517587021e-01 6.0021242329987637e-03 2.5390022525957346e-04
     	 	 9.6378977261752841e-01 3.1358533065157734e-02 4.4178662551897164e-04
     	 	 9.6054319198413896e-01 5.7603801566015892e-03 5.5784450216455055e-04
     	 	 9.4301744951476274e-01 3.0465269277615465e-02 1.0638859237962308e-03
     	 	 9.1875795482718026e-01 7.5549483996046024e-02 7.6953866599474292e-04
     	 	 9.1310703948768757e-01 5.3626976339878722e-03 7.9062411125771493e-04
     	 	 9.0398867950360984e-01 2.8679563281478679e-02 1.6308047242328870e-03
     	 	 8.6177316103118007e-01 6.9624248181871629e-02 2.3124047417117355e-03
     	 	 8.9722305580728723e-01 7.3625615346042991e-02 1.6659244392256284e-03
     	 	 8.5867633176831659e-01 1.3664260667987951e-01 8.2984436884041626e-04
     	 	 8.4706301263023231e-01 4.9477961642458304e-03 9.4164766629696009e-04
     	 	 8.4689156343093586e-01 2.5929708786260830e-02 1.9565332534642425e-03
     	 	 8.1594889687616545e-01 6.1452424399543577e-02 2.5648185948837438e-03
     	 	 7.7122693442720403e-01 1.1169472723730209e-01 3.4282960046837958e-03
     	 	 8.0842013160267012e-01 1.2824118333671886e-01 3.0313406655858217e-03
     	 	 8.4011333190369442e-01 1.3454116154168091e-01 2.0129969704184730e-03
     	 	 7.8307741065270009e-01 2.1146938928840439e-01 1.1248642005401402e-03
     	 	 7.6645703399327381e-01 4.9613353218584521e-03 1.0986892034409038e-03
     	 	 7.7105100764707069e-01 2.6166143896524507e-02 2.4751328438209885e-03
     	 	 7.4670563251537991e-01 6.4928423571361929e-02 3.4042743394130715e-03
     	 	 6.9789563322041248e-01 1.1885138954779730e-01 4.4147390680608686e-03
     	 	 7.0569824992286900e-01 1.7481238271387917e-01 4.2316533154558847e-03
     	 	 7.3463571149198270e-01 1.9849318411734729e-01 3.5098312720874907e-03
     	 	 7.6205949940398821e-01 2.0978598741698684e-01 2.5624557500871698e-03
     	 	 6.9773786778191915e-01 2.9703131530561916e-01 1.2041355178393984e-03
     	 	 6.7587999192711945e-01 4.8623323612276420e-03 1.1693780533809071e-03
     	 	 6.8204741319986373e-01 2.5315094810303577e-02 2.6592914266382870e-03
     	 	 6.7212777328407713e-01 6.0505852175116261e-02 3.5174809553964151e-03
     	 	 6.2843936178765170e-01 1.0773944315173263e-01 4.3037949086643778e-03
     	 	 6.0768887053393983e-01 1.5230216113201356e-01 2.0708083265097415e-03
     	 	 6.2450160670513066e-01 1.9041288702147488e-01 5.4027062760677869e-03
     	 	 6.2814231851460245e-01 2.5132326058711069e-01 4.8159397814847979e-03
     	 	 6.5362265863849500e-01 2.7939088793250683e-01 4.0360837797690265e-03
     	 	 6.7478356153462937e-01 2.9780646995749682e-01 2.8774884133072262e-03
     	 	 5.7987290941980474e-01 5.0005569536317497e-03 1.2479192022206488e-03
     	 	 5.8463608245261811e-01 2.5972424627248105e-02 2.8962314841998716e-03
     	 	 5.8147064987363417e-01 6.2616994206396825e-02 4.1533080491705926e-03
     	 	 5.3641906360501346e-01 1.1605116342328751e-01 5.4230964293009122e-03
     	 	 5.4081269814263111e-01 1.7972314580941223e-01 5.6277581267201657e-03
     	 	 5.2469298274629339e-01 2.5094986576248873e-01 5.1796847799230657e-03
     	 	 5.4845612403016886e-01 2.8210173359530860e-01 4.3704487232070800e-03
     	 	 5.4427757246369568e-01 3.4435807315815875e-01 5.1443466765577674e-03
     	 	 5.6844547954093616e-01 3.7027513353991115e-01 3.9035596874283760e-03
     	 	 5.7906212538248103e-01 3.9540502962193463e-01 2.8168992474864318e-03
     	 	 6.0492736908893441e-01 3.9006962643745391e-01 1.2243490157402802e-03
     	 	 4.8177361751247549e-01 5.3610427766578378e-03 1.3466507646737159e-03
     	 	 4.8410702789110815e-01 2.7775520872868539e-02 3.1066923238530909e-03
     	 	 4.8445250340353252e-01 6.6430497848456477e-02 4.5221121422012534e-03
     	 	 4.4287380032938639e-01 1.2017733970414825e-01 5.3575455227600341e-03
     	 	 4.5122579833926912e-01 1.8302829582991406e-01 6.3763471172216049e-03
     	 	 4.4833944586656416e-01 2.5425444996861113e-01 6.0242153159719780e-03
     	 	 4.6376434600897332e-01 3.6068838423669547e-01 5.8568620517563614e-03
     	 	 4.5140171078366753e-01 4.3556492467161306e-01 5.3421296210743362e-03
     	 	 4.7575785138703008e-01 4.6241366390811817e-01 4.1548920758147315e-03
     	 	 4.7884204011680287e-01 4.9613264204420165e-01 2.9024409626710332e-03
     	 	 5.0674901270388761e-01 4.8857183809419202e-01 1.2100468574773472e-03
     	 	 3.8444184584211594e-01 5.2977282364209347e-03 1.3017932932580206e-03
     	 	 3.8495705345528997e-01 2.7792184166759416e-02 3.0357055334285644e-03
     	 	 3.8617047444602537e-01 6.7401381867769450e-02 4.6323122129499740e-03
     	 	 3.5562693384368282e-01 1.2311636999013359e-01 5.2307732968219752e-03
     	 	 3.5678867706376893e-01 1.9056656101284997e-01 6.6276460108154831e-03
     	 	 3.6273404921691976e-01 2.6348306920069292e-01 6.6353225695475991e-03
     	 	 3.4157038277440588e-01 3.4263654711271913e-01 6.1788557685477268e-03
     	 	 4.2353164481287642e-01 3.3108446179141132e-01 6.0386074459495686e-03
     	 	 3.3936743634584154e-01 4.1768390251424459e-01 6.0637071192307501e-03
     	 	 3.7702632589799023e-01 4.4883878712218495e-01 5.6860164041783413e-03
     	 	 3.5945436350079130e-01 5.2998199219934683e-01 5.1460755113190947e-03
     	 	 3.8317322914759266e-01 5.5558087092322861e-01 3.9089942821330780e-03
     	 	 3.7758832932490582e-01 5.9623296420117733e-01 2.8214283930874623e-03
     	 	 4.0569945416436759e-01 5.8926403147296869e-01 1.2907134748002605e-03
     	 	 2.9133091613490247e-01 5.4901830795338049e-03 1.2612931623624279e-03
     	 	 2.9119685507375181e-01 2.8598054779027042e-02 2.8800193072583942e-03
     	 	 2.9154917178479356e-01 6.9102397674270524e-02 4.4463470348104243e-03
     	 	 2.7385630093258184e-01 1.2627592691453873e-01 5.0822491887026382e-03
     	 	 2.6830156881598843e-01 1.9705452869788273e-01 6.4736983043889185e-03
     	 	 2.7423571476374398e-01 2.7807482541838130e-01 7.3172577885566494e-03
     	 	 2.6168482203343646e-01 3.6856982779777486e-01 6.8078278725323491e-03
     	 	 2.5690150485904173e-01 4.5584411920720441e-01 6.5190454425810536e-03
     	 	 2.6217523051609637e-01 5.2735763525308255e-01 5.2110080773805825e-03
     	 	 3.0383797035957949e-01 5.2861948015282800e-01 3.6285058759509144e-03
     	 	 2.6438568536090579e-01 6.1200758188629800e-01 5.1754239931802925e-03
     	 	 2.8965722458489240e-01 6.4279954761006264e-01 4.3038689031085174e-03
     	 	 2.8381484433578930e-01 6.8825646809704399e-01 2.8168909284737387e-03
     	 	 3.0741009960864474e-01 6.8735940972665310e-01 1.2766895053729721e-03
     	 	 2.0611162141881545e-01 5.7511701891205394e-03 1.1785491560368122e-03
     	 	 2.0597411886159411e-01 2.9942092056208819e-02 2.6714148487610970e-03
     	 	 2.0528287932064371e-01 7.1792372483910669e-02 4.0196316447134025e-03
     	 	 1.9749068262468761e-01 1.2866803788007936e-01 4.5868399319078839e-03
     	 	 1.8853793858327039e-01 1.9689757930840326e-01 5.4687615884894394e-03
     	 	 1.9324758525913788e-01 2.7575483896548075e-01 6.2972032064544181e-03
     	 	 1.8949365841382382e-01 3.6179458683513643e-01 6.4351997549970041e-03
     	 	 1.8320374492636149e-01 4.5607894782697883e-01 6.4773398494150916e-03
     	 	 1.8142509958659447e-01 5.4632667448532302e-01 6.1451200742903009e-03
     	 	 1.9533843618065660e-01 6.1532547290296757e-01 5.4618382685602089e-03
     	 	 1.8696195659014858e-01 6.8858470098124247e-01 4.2549983838928006e-03
     	 	 2.0382312549789816e-01 7.2635752496689110e-01 3.8969331421673417e-03
     	 	 1.9971812710292514e-01 7.7088736086740606e-01 2.5332125427812587e-03
     	 	 2.1704233279350726e-01 7.7732198245780615e-01 1.2215021780059318e-03
     	 	 1.3230496514658707e-01 4.7174222961414653e-03 8.2040671222770713e-04
     	 	 1.3227639157582605e-01 2.5738719058972660e-02 2.0201712559024939e-03
     	 	 1.3141862606656995e-01 6.5190937925402079e-02 3.2601711736999954e-03
     	 	 1.2929292897227951e-01 1.2212777838741273e-01 4.1728488422216733e-03
     	 	 1.2095514745153246e-01 1.9410116763114155e-01 4.7769496012584345e-03
     	 	 1.2377964484861825e-01 2.7489049693886342e-01 5.1650257639764214e-03
     	 	 1.2152130017204943e-01 3.5577949980819623e-01 4.8409218289349352e-03
     	 	 1.2223531229758666e-01 4.2982014248127931e-01 4.4576429042009098e-03
     	 	 1.1610060820268142e-01 5.1141243515977419e-01 4.8526434205753968e-03
     	 	 1.1626359580308110e-01 5.9190270269340983e-01 4.7884381920469858e-03
     	 	 1.2438551404604570e-01 6.6853057029947804e-01 5.1670615851833884e-03
     	 	 1.2237886878428061e-01 7.4481431723434866e-01 4.0664863395297969e-03
     	 	 1.2867883438272576e-01 7.9957203843258262e-01 3.4784731008035367e-03
     	 	 1.2888780784617793e-01 8.4174490079196074e-01 2.1234139018331153e-03
     	 	 1.3898620100890569e-01 8.5538824308769268e-01 1.0210799767873921e-03
     	 	 7.2894966888303214e-02 6.1467937380642991e-03 8.0657627019292656e-04
     	 	 7.2726774486043588e-02 3.1641459477880940e-02 1.7935748733661334e-03
     	 	 7.2018567524237409e-02 7.4578997622669702e-02 2.5596089765437956e-03
     	 	 7.1550265451232109e-02 1.3066572318073455e-01 3.0923863916689368e-03
     	 	 6.6099843179827755e-02 1.9805179905685333e-01 3.4117291907259442e-03
     	 	 6.8380236419283813e-02 2.7678845434453686e-01 4.1132503297150605e-03
     	 	 6.6464406443383028e-02 3.6826939581768597e-01 4.5312482204707127e-03
     	 	 6.7782933031844461e-02 4.6485150609447523e-01 4.6216511090502272e-03
     	 	 6.2372858692044453e-02 5.6738804676961963e-01 4.5196710313538347e-03
     	 	 6.6513564486170185e-02 6.6098589328252511e-01 4.1726418319194226e-03
     	 	 6.7855685757494011e-02 7.4404825408726960e-01 3.8409094106799080e-03
     	 	 6.9442077115678402e-02 8.1487351661181284e-01 3.0017683559866401e-03
     	 	 6.9826337847297526e-02 8.6788353265935947e-01 2.2847141604453438e-03
     	 	 7.2254327502409232e-02 9.0248858604240234e-01 1.4276364028755371e-03
     	 	 7.6422086472001882e-02 9.1872145667259308e-01 6.7468297967466335e-04
     	 	 3.0159675235309824e-02 5.0295135098252968e-03 4.4065924744594620e-04
     	 	 3.0015173224500757e-02 2.7380881871801432e-02 1.0779269230962857e-03
     	 	 2.9789967479012969e-02 6.9135166795967637e-02 1.7190731373310194e-03
     	 	 2.9542322374988217e-02 1.2976285236200205e-01 2.3010641400598750e-03
     	 	 2.7392220388609889e-02 2.0708189316207085e-01 2.5744139666515494e-03
     	 	 2.8296950359452788e-02 2.9542606528492776e-01 2.9367093298636971e-03
     	 	 2.7080503107678400e-02 3.9130995858288686e-01 2.9841798982360775e-03
     	 	 2.8607803859207581e-02 4.8766674103366497e-01 3.0482521474349683e-03
     	 	 2.4798497241302453e-02 5.8429666515246426e-01 2.6786686414828455e-03
     	 	 2.7856933431914643e-02 6.7420643257266422e-01 2.7634222364692120e-03
     	 	 2.7407169556374122e-02 7.6073356382206703e-01 2.5586017529707753e-03
     	 	 2.9214792750551721e-02 8.3523389568467321e-01 2.2379990394949213e-03
     	 	 2.8256673002458821e-02 8.9762442694394140e-01 1.7126725430069885e-03
     	 	 2.9942660888036099e-02 9.3994472259932194e-01 1.1445938668077969e-03
     	 	 3.1347251011257349e-02 9.6298344926871771e-01 5.1460665793852649e-04
     	 	 5.7769466976115291e-03 6.3695898680371545e-03 2.4094465473187355e-04
     	 	 5.7285645878766278e-03 3.3059760640872106e-02 5.3998476942301887e-04
     	 	 5.7008846172966754e-03 7.9077886709253739e-02 7.9862227907783411e-04
     	 	 5.6277621566049874e-03 1.4132463351736951e-01 9.9811270960647536e-04
     	 	 5.2024956072973527e-03 2.1657449130686754e-01 1.0741096026056010e-03
     	 	 5.4585022683306672e-03 3.0165359068718972e-01 1.2511683591205592e-03
     	 	 5.1235587924745030e-03 3.9535656681761588e-01 1.2792961206046418e-03
     	 	 5.5091360537210532e-03 4.9474125180951067e-01 1.4223025718173672e-03
     	 	 4.6556324138400385e-03 5.9588616476053569e-01 1.1948440803512649e-03
     	 	 5.3841278586799213e-03 6.9210286068139804e-01 1.2797053716022070e-03
     	 	 5.1717232889847420e-03 7.8033552242300064e-01 1.0974091932813928e-03
     	 	 5.6726720597701785e-03 8.5596014597495684e-01 1.0020389125614941e-03
     	 	 5.3255300850376663e-03 9.1784042085380835e-01 7.3362904055964263e-04
     	 	 5.7518629420983958e-03 9.6224874401621030e-01 5.2470330142356596e-04
     	 	 5.9807669474056802e-03 9.8786146824259291e-01 2.4140500715994593e-04
     	 	 ];


    case 30

        % SET: SLOBODKINS TAUSCH
        % CARDINALITY RULE  :    168
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 1.881e-15

        XYW=[
    	 	 9.9008657601569960e-01 4.6955725085486653e-03 1.6342407606739450e-04
     	 	 9.6656349350198523e-01 5.7234068220526442e-03 4.6119397287120096e-04
     	 	 9.4216801811157191e-01 2.9555831307249657e-02 1.0141525457253459e-03
     	 	 9.6896136587246406e-01 2.5564447646490188e-02 4.1666090315812133e-04
     	 	 9.2725422268265834e-01 4.5365585894210749e-03 5.7786266665291945e-04
     	 	 9.0829436980909151e-01 2.4476776296074112e-02 1.3275432066239341e-03
     	 	 8.6985962438551712e-01 6.2124131558867556e-02 2.2522548064636641e-03
     	 	 9.0332159039642490e-01 6.8983735581869182e-02 1.4385244388003214e-03
     	 	 9.3024338953745533e-01 6.4479578257827963e-02 6.4961871936520578e-04
     	 	 8.6926816170444876e-01 5.1908795091242192e-03 8.6407949227797567e-04
     	 	 8.5249998766252288e-01 2.6897811729484335e-02 1.8051962666057247e-03
     	 	 8.1144466000784155e-01 6.4403617838219615e-02 2.8016823359800348e-03
     	 	 8.2529374845803050e-01 1.1674712927558574e-01 2.6416586220957086e-03
     	 	 8.5709885104365391e-01 1.2040855601249280e-01 1.4725630315513523e-03
     	 	 8.7458580667693187e-01 1.2109696623608673e-01 7.1887664348006071e-04
     	 	 7.9737542007470452e-01 5.1058742015193722e-03 1.0243717918250220e-03
     	 	 7.8557737398120286e-01 2.6749598426822015e-02 2.2051551760426595e-03
     	 	 7.4365584765901493e-01 6.4767029257020242e-02 3.2739735562156017e-03
     	 	 7.7573366947692279e-01 1.1572339592712579e-01 3.4687762606932663e-03
     	 	 7.4745485415712687e-01 1.8400419541682686e-01 3.5353573775756832e-03
     	 	 7.9041452322416250e-01 1.8118040181696907e-01 2.1643292289342374e-03
     	 	 8.0162693211084113e-01 1.9298625293888377e-01 1.0856267496633099e-03
     	 	 7.1391953668249408e-01 5.0834727706290774e-03 1.1463149237483708e-03
     	 	 7.0687954755293014e-01 2.6538969413097618e-02 2.4954507646727745e-03
     	 	 6.6963686284337376e-01 6.4041246944406147e-02 3.4844520465656535e-03
     	 	 7.0713217009184026e-01 1.1701805517443931e-01 4.3589891460742193e-03
     	 	 6.2285167888231352e-01 1.7905440702232081e-01 5.0703454789264258e-03
     	 	 6.9456720482837120e-01 1.8033753148535331e-01 4.5652571423109179e-03
     	 	 6.7554537271821458e-01 2.5984161443896392e-01 3.4761379976970515e-03
     	 	 7.1676124517490991e-01 2.5625449928646143e-01 2.4720955011702096e-03
     	 	 7.1778959127349262e-01 2.7708479432387284e-01 1.1641964149981931e-03
     	 	 6.2245528951904205e-01 5.0319299777752862e-03 1.2160989071882855e-03
     	 	 6.1917737446344079e-01 2.6349626489431708e-02 2.6949125857911225e-03
     	 	 5.8980373092271388e-01 6.3863871739380226e-02 3.7436650739040038e-03
     	 	 6.2684268290279865e-01 1.1616924409386277e-01 5.0494934485741938e-03
     	 	 5.8053394539488257e-01 2.4219780176996597e-01 4.1246152460928517e-03
     	 	 6.2594452104714393e-01 2.5838752516138896e-01 4.7150576306889923e-03
     	 	 6.0040752855866897e-01 3.3778939381437700e-01 3.3997780333738328e-03
     	 	 6.3017564133060067e-01 3.4418518584649244e-01 2.6577052733914490e-03
     	 	 6.2619799906664042e-01 3.6894356183679594e-01 1.1696494187787504e-03
     	 	 5.2656720854007999e-01 5.0027551218918545e-03 1.2409229578490266e-03
     	 	 5.2631354850865919e-01 2.6167817481830131e-02 2.7729617403061489e-03
     	 	 5.0442592480412851e-01 6.3480305773649534e-02 3.9628181559254513e-03
     	 	 5.3722185914440324e-01 1.1605999688932293e-01 5.4722649061658907e-03
     	 	 5.3940750056905695e-01 1.8116282415819238e-01 6.0802627478968533e-03
     	 	 4.9975497924882284e-01 2.5576251280960866e-01 5.7726810996716208e-03
     	 	 5.1505317926597027e-01 3.1106803982931291e-01 4.8841466891293072e-03
     	 	 5.4295361524490260e-01 3.4592703992793927e-01 5.0541207355852226e-03
     	 	 5.2074208013365897e-01 4.1917884727695365e-01 3.6092128456446291e-03
     	 	 5.3541614928640002e-01 4.4001218537172226e-01 2.7028929407109390e-03
     	 	 5.3189721020839031e-01 4.6344292453740060e-01 1.1240408400721245e-03
     	 	 4.3015304790604247e-01 5.0485093799188313e-03 1.2322275463638121e-03
     	 	 4.3170286510634848e-01 2.6336989198806011e-02 2.7848855242283890e-03
     	 	 4.1548034150723789e-01 6.3714088871031124e-02 3.9789906906207411e-03
     	 	 4.4353776159098202e-01 1.1554397861449318e-01 5.5694142619488870e-03
     	 	 4.5102618777628767e-01 1.8081229258849610e-01 6.3525036811276983e-03
     	 	 4.2173779335583284e-01 2.5617603274697776e-01 6.4261670807586532e-03
     	 	 4.1520244953239338e-01 3.3757622881806432e-01 6.5436288018890457e-03
     	 	 4.3928351932624032e-01 3.8659039431642545e-01 5.4234602103410048e-03
     	 	 4.5274514932556242e-01 4.3632764764932563e-01 5.2284715373869172e-03
     	 	 4.3457995982452857e-01 5.0375608879703804e-01 3.7583130676407334e-03
     	 	 4.3774780444834382e-01 5.3654009522845525e-01 2.7707829825559327e-03
     	 	 4.3925306161141464e-01 5.5575500208147788e-01 1.1608938787072063e-03
     	 	 3.3720637824047872e-01 5.0434554048304769e-03 1.1627565795323282e-03
     	 	 3.3865016538028703e-01 2.6408212338372084e-02 2.7048924838555160e-03
     	 	 3.2933196073068915e-01 6.4054946608277250e-02 3.7570463714640080e-03
     	 	 3.4957144861464895e-01 1.1608249938535790e-01 5.4036562637057800e-03
     	 	 3.6161137230289908e-01 1.8033893256293546e-01 6.2473967351664968e-03
     	 	 3.3990257555639725e-01 2.5558331661056888e-01 6.5303823063139685e-03
     	 	 3.3408595057689505e-01 3.3857842586409176e-01 6.9516980555248027e-03
     	 	 3.3025381765719830e-01 4.2377562808096231e-01 6.5789489641657770e-03
     	 	 3.5891840609803805e-01 4.6796191621551175e-01 5.5412679587706348e-03
     	 	 3.6008732029668056e-01 5.2810130508235897e-01 5.1084527207676395e-03
     	 	 3.4658796321579355e-01 5.9172078920113969e-01 3.8386430406573916e-03
     	 	 3.4292500327095854e-01 6.3177221944541329e-01 2.6367594132536876e-03
     	 	 3.4981268084581507e-01 6.4542120481622256e-01 1.0767960132242898e-03
     	 	 2.5127397895870662e-01 5.2225089680759326e-03 1.0886922018949572e-03
     	 	 2.5078882088300691e-01 2.7142265936722851e-02 2.5435695955967632e-03
     	 	 2.5041220533253772e-01 6.5578704083629105e-02 3.4538590789992573e-03
     	 	 2.6125519418678234e-01 1.1821580149523168e-01 5.0111834461172983e-03
     	 	 2.7389304427213024e-01 1.8312112209261414e-01 6.0005323618707931e-03
     	 	 2.5368676453322681e-01 3.3821508394905458e-01 6.5650095184824489e-03
     	 	 2.5300732970279050e-01 4.2333460659631400e-01 6.4145541084241441e-03
     	 	 2.4661610007109691e-01 5.0531765351056457e-01 5.7048644960448810e-03
     	 	 2.7513616881437042e-01 5.4735994464159565e-01 5.5721030416519502e-03
     	 	 2.7232900781135050e-01 6.1311805714339596e-01 4.8643393132561793e-03
     	 	 2.6115149898133549e-01 6.7533812995177644e-01 3.6761351844048409e-03
     	 	 2.5552093175252066e-01 7.1779662178015646e-01 2.4120708020064488e-03
     	 	 2.6403757658494798e-01 7.3080100157178884e-01 1.0939673987862158e-03
     	 	 1.7487648293490232e-01 4.8915957021566838e-03 8.9362116399435351e-04
     	 	 1.7234695517225895e-01 2.5862602295538648e-02 2.1249768830554718e-03
     	 	 1.7863483746639408e-01 6.3445617501166743e-02 3.1107301831412052e-03
     	 	 1.8211847523298497e-01 1.1682306398890968e-01 4.3894014996870342e-03
     	 	 1.9233735375517091e-01 1.8310048136658938e-01 5.4855779943159674e-03
     	 	 2.5981887738915099e-01 2.5775881806191653e-01 5.9490124993591235e-03
     	 	 1.8734624151307444e-01 2.5887035268624303e-01 5.4630581881858495e-03
     	 	 1.7776961772263722e-01 3.4046565211494884e-01 5.8275762015990639e-03
     	 	 1.7544771667358106e-01 5.0141820741003906e-01 5.3323049851802572e-03
     	 	 1.7534468230877143e-01 5.7726022447536995e-01 5.0022183689383435e-03
     	 	 1.9540964613326794e-01 6.2982110462901153e-01 5.2150286657905460e-03
     	 	 1.9246523715583819e-01 6.9572043888897317e-01 4.2126645589307208e-03
     	 	 1.8121731047750278e-01 7.5760878118423103e-01 3.3085634595342614e-03
     	 	 1.8080105948517500e-01 7.9475880091892304e-01 1.9181738649910018e-03
     	 	 1.8502250529268116e-01 8.1035129226209024e-01 8.8865562136955371e-04
     	 	 1.0966559676964993e-01 5.1970775146353947e-03 7.8217307399053066e-04
     	 	 1.0729524051271200e-01 2.7004010670784589e-02 1.7169710334159339e-03
     	 	 1.1512137883636642e-01 6.4369360374261386e-02 2.6381794124114835e-03
     	 	 1.1620376412834854e-01 1.1651730944982794e-01 3.4908286776165424e-03
     	 	 1.2192310166673914e-01 1.8265200571745227e-01 4.6070280135115955e-03
     	 	 1.2243868971675731e-01 2.6053921211582459e-01 4.9903367456222989e-03
     	 	 1.1307781287253271e-01 3.4877441737895887e-01 5.3237621933772544e-03
     	 	 1.1676205344518131e-01 4.4100896431368458e-01 5.5347345272182946e-03
     	 	 1.8146699853304726e-01 4.2082687551248971e-01 5.5020399076297364e-03
     	 	 1.1235261280471376e-01 5.3566408329575088e-01 5.1807055845943242e-03
     	 	 1.1221387947086991e-01 6.2276305313401770e-01 4.7668598807089693e-03
     	 	 1.2393533279708091e-01 6.9124116153658111e-01 4.5800350978230644e-03
     	 	 1.2545444494987601e-01 7.5538351080413257e-01 3.6857657585471736e-03
     	 	 1.1309738028717409e-01 8.1981940968081535e-01 2.8423742633613509e-03
     	 	 1.1885801986806110e-01 8.5297940776151315e-01 1.7481972415400707e-03
     	 	 1.1613509040577752e-01 8.7848850558003644e-01 8.5710661014778110e-04
     	 	 5.8071085338451511e-02 5.5063168054474889e-03 6.1963762791172601e-04
     	 	 5.8322507106963628e-02 2.9014903185392040e-02 1.3482155121634690e-03
     	 	 6.2865697399977716e-02 6.9960235431401591e-02 2.2567777051765671e-03
     	 	 6.4820195886743481e-02 1.2721974102182312e-01 2.8542054707621813e-03
     	 	 6.6311553658509159e-02 1.9526714805157463e-01 3.4899550879955404e-03
     	 	 6.8720486207388909e-02 2.7105599964610483e-01 3.6854100716793505e-03
     	 	 6.0578697716007657e-02 3.4928443848118473e-01 3.4563654645457928e-03
     	 	 6.4424579893362033e-02 4.2858675718316586e-01 3.6921135198622855e-03
     	 	 6.3319091764057034e-02 5.1126721848471957e-01 3.7337179622386526e-03
     	 	 6.1010001506082490e-02 5.9647397492590615e-01 3.5828007296126877e-03
     	 	 6.2237164842240289e-02 6.7426975638342090e-01 3.3001622904203030e-03
     	 	 6.8255224684774629e-02 7.4237811716865598e-01 3.4578626290817723e-03
     	 	 6.9220419453990822e-02 8.0914886553505816e-01 3.0518332626722146e-03
     	 	 5.9625005150162669e-02 8.7442983014356890e-01 2.1574550400285794e-03
     	 	 6.8410097980963203e-02 9.0454670356554234e-01 1.3797909207185612e-03
     	 	 6.1521851828810425e-02 9.3334084523001482e-01 6.1190095655502407e-04
     	 	 2.2525791721784261e-02 4.6423502166764771e-03 3.2163410417147093e-04
     	 	 2.4196375754243937e-02 2.4720159258556411e-02 7.6176549101113016e-04
     	 	 2.4980761100049431e-02 6.2133051952997183e-02 1.3204808951311534e-03
     	 	 2.7154385289442695e-02 1.1573761356752571e-01 1.8394909377444839e-03
     	 	 2.6793112885868942e-02 1.8429690552063691e-01 2.2959007782865797e-03
     	 	 2.8560183879495549e-02 2.6472100238622109e-01 2.7019800034704796e-03
     	 	 2.5018689399851746e-02 3.5318995804816983e-01 2.5802274762640551e-03
     	 	 2.6492369327828946e-02 4.4624258454802490e-01 2.8099034697499758e-03
     	 	 2.6140281931648079e-02 5.4031434270106748e-01 2.7213924494895385e-03
     	 	 2.4934481671009978e-02 6.3234167917136486e-01 2.5117239142984247e-03
     	 	 2.6204267000284331e-02 7.1729569421465789e-01 2.3976476681171533e-03
     	 	 2.8399621893509641e-02 7.9184239834451497e-01 2.2631616620549283e-03
     	 	 2.8509455616618329e-02 8.5641274010193125e-01 1.8588670377488253e-03
     	 	 2.2647470650769774e-02 9.1382569070756292e-01 1.2151245285398769e-03
     	 	 2.9519756626018134e-02 9.4365739409968397e-01 9.5675652334276443e-04
     	 	 2.3951635476175848e-02 9.7088520783760468e-01 3.7681335354742000e-04
     	 	 4.0324155916380278e-03 5.2202414931811769e-03 1.4086077504490418e-04
     	 	 4.7574597762021220e-03 2.7071677880079411e-02 3.6535707183126914e-04
     	 	 4.6484178407492083e-03 6.5185650555311364e-02 5.4996019171403186e-04
     	 	 5.3025730729859832e-03 1.1813739200725469e-01 8.1114060839750145e-04
     	 	 5.0271912147226150e-03 1.8471226210669534e-01 9.4271999986369603e-04
     	 	 5.5197322701608931e-03 2.6312405412448781e-01 1.1791948872179987e-03
     	 	 4.7708909883725781e-03 3.5094136797665881e-01 1.1216509275512980e-03
     	 	 5.0430445353349951e-03 4.4530232171845541e-01 1.2448159485539227e-03
     	 	 5.0359982684257121e-03 5.4206606047547590e-01 1.2445037605785295e-03
     	 	 4.7578622591888386e-03 6.3735012515465250e-01 1.1369594119455112e-03
     	 	 4.9858312381293457e-03 7.2725602225732833e-01 1.1011870124770407e-03
     	 	 5.4049042027682903e-03 8.0803472791823638e-01 1.0451067037927440e-03
     	 	 5.4754196176339809e-03 8.7685804488680308e-01 8.6821498925373532e-04
     	 	 4.0472507321791529e-03 9.3260472995005017e-01 4.9189919229974488e-04
     	 	 5.7157700361175623e-03 9.6882882315516572e-01 4.2827977483627598e-04
     	 	 4.2455495905286966e-03 9.9105233038326768e-01 1.3567276157892884e-04
     	 	 ];


    case 31

        % SET: SLOBODKINS TAUSCH
        % CARDINALITY RULE  :    178
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 6.731e-16

        XYW=[
    	 	 9.8920860447498904e-01 5.2229366977731995e-03 1.9052717936496753e-04
     	 	 9.6800858180293903e-01 2.7207754848200250e-02 3.7430208039067667e-04
     	 	 9.6580515389533583e-01 5.1686017161699611e-03 4.3106224925889555e-04
     	 	 9.4736180877689280e-01 2.7269426110585731e-02 8.9281427818352539e-04
     	 	 9.2953073214339221e-01 6.5675848895519168e-02 5.6709333619521811e-04
     	 	 9.2496885590704592e-01 4.8436399005008391e-03 6.1230125926135760e-04
     	 	 9.1173785783791605e-01 2.5392144194829061e-02 1.2955590603501088e-03
     	 	 8.7912984009341988e-01 6.1273936044326273e-02 1.8065571648123290e-03
     	 	 9.0855415893605418e-01 6.6637856264878406e-02 1.3113643277923857e-03
     	 	 8.7589660747545406e-01 1.1940442579135339e-01 7.3505541379679140e-04
     	 	 8.6826011544273995e-01 4.8225519688512826e-03 7.8812858412013380e-04
     	 	 8.5863455468809413e-01 2.5339946834380393e-02 1.7331684062416534e-03
     	 	 8.2972497260850364e-01 6.1939268140275623e-02 2.4570179564481947e-03
     	 	 8.2783932156030371e-01 1.1156981375604193e-01 2.4803049099522724e-03
     	 	 8.5358743017375605e-01 1.2159192949332571e-01 1.7460704490491561e-03
     	 	 8.0819841661918734e-01 1.8687263743059745e-01 9.2891170751308505e-04
     	 	 7.9843106623672555e-01 4.5117661390351839e-03 8.7814600973343964e-04
     	 	 7.9230561280477507e-01 2.3863980384987327e-02 1.9770561010227696e-03
     	 	 7.7079206446572091e-01 5.8195002471547165e-02 2.8451363121515883e-03
     	 	 7.2141354235478539e-01 1.0548891920344920e-01 3.6015545766618722e-03
     	 	 7.7604119489875800e-01 1.1281304362924506e-01 3.2707558673353561e-03
     	 	 7.1220433181430476e-01 1.7569780125618956e-01 3.8597227246597392e-03
     	 	 7.6338242997937389e-01 1.7486166215746918e-01 3.0236079503410808e-03
     	 	 7.8443908727656364e-01 1.8984958713186761e-01 2.1263939113836164e-03
     	 	 7.2933068899153985e-01 2.6578293278131832e-01 1.0484034081827899e-03
     	 	 7.1779341220104931e-01 4.6281169551766269e-03 1.0032466227914789e-03
     	 	 7.1455803563118581e-01 2.3873618906241015e-02 2.1793042310806212e-03
     	 	 6.9601928262141188e-01 5.7845478105449218e-02 3.3241254349838530e-03
     	 	 6.4939360122955492e-01 1.0636837174652389e-01 4.1243668007703077e-03
     	 	 6.5907639760253178e-01 1.6563157075961962e-01 4.5927533053234408e-03
     	 	 6.3926871428594034e-01 2.4670418686833184e-01 4.3143501238395963e-03
     	 	 6.8741501588083609e-01 2.5016250959749420e-01 3.5775056882283171e-03
     	 	 7.0590662229564338e-01 2.6853125882385659e-01 2.3889837480469689e-03
     	 	 6.4191947997178067e-01 3.5336763386864078e-01 1.0967781501913766e-03
     	 	 6.2942467508330457e-01 4.9736656011232349e-03 1.1648009647516875e-03
     	 	 6.2884617025752576e-01 2.6024824602953554e-02 2.5493786524987852e-03
     	 	 6.0812648064339614e-01 6.2507898965057512e-02 3.8379005719189900e-03
     	 	 5.6654391253359826e-01 1.1266079339401329e-01 4.3287327429294706e-03
     	 	 5.8419046482971648e-01 1.6641453783865057e-01 4.9201670154608917e-03
     	 	 5.2288640776923034e-01 2.2492258215368013e-01 4.2327812658041640e-03
     	 	 5.8523633067033698e-01 2.3737192114471928e-01 5.2877843857475574e-03
     	 	 5.6846701747443618e-01 3.2449293711539851e-01 4.2717499760805246e-03
     	 	 6.0537359381465983e-01 3.3523976469292710e-01 3.6548490395983822e-03
     	 	 6.2047550190228962e-01 3.5505780922296304e-01 2.4337066827442794e-03
     	 	 5.3560202047022376e-01 4.1811103383618004e-03 1.0398030145056367e-03
     	 	 5.4055258841738052e-01 2.2962573644757678e-02 2.3885289610599621e-03
     	 	 5.2147169676142946e-01 5.6570880367735089e-02 3.7607347198946664e-03
     	 	 4.9353232960660764e-01 1.0392134488113128e-01 4.4289791406307184e-03
     	 	 4.9322649747810321e-01 1.7054993723244863e-01 5.7215511606359664e-03
     	 	 4.4361624134318889e-01 2.4208934694191056e-01 4.6938832275387858e-03
     	 	 4.7766833920139085e-01 2.8786988513510825e-01 4.6780154983254814e-03
     	 	 5.1401986768798880e-01 3.2054416259841939e-01 5.3191312756668422e-03
     	 	 4.8696259582306634e-01 4.0817845517049195e-01 4.6221323199859658e-03
     	 	 5.1731845462968740e-01 4.2538368400559262e-01 3.6970447609839543e-03
     	 	 5.3077897918615990e-01 4.4568651140718563e-01 2.4189888172812548e-03
     	 	 5.4879066423095879e-01 4.4671310702678424e-01 1.0958252185810302e-03
     	 	 4.3881410182642788e-01 3.9370478775896389e-03 9.6817585814675780e-04
     	 	 4.5127383767062557e-01 2.0552490286002510e-02 2.1065572835542866e-03
     	 	 4.3161347626003554e-01 5.0892268380572099e-02 3.4834954094423113e-03
     	 	 4.1301672599541639e-01 9.5459205918304244e-02 4.4082611159398351e-03
     	 	 4.1514836196269678e-01 1.5640315226850562e-01 5.5601260196230986e-03
     	 	 3.8513756159442336e-01 2.2645631317198101e-01 5.3625042580224469e-03
     	 	 3.7946211463958879e-01 3.0886594402508111e-01 5.6214606792990510e-03
     	 	 4.0816163113748893e-01 3.5697551393849819e-01 5.5060649109544219e-03
     	 	 4.3142457898515929e-01 4.0366147074710645e-01 5.3794232724203601e-03
     	 	 3.5225647757136280e-01 4.8229192904533086e-01 4.8034677757985821e-03
     	 	 4.0042635396431747e-01 4.9370390856807189e-01 4.6071088646562550e-03
     	 	 4.2613164757803845e-01 5.1573263195391417e-01 3.7301652885460982e-03
     	 	 4.3929950088417480e-01 5.3669693780292271e-01 2.4452327711191116e-03
     	 	 4.5312757716152352e-01 5.4229055643931945e-01 1.1202332871536108e-03
     	 	 3.4534199904790885e-01 4.3760784517805889e-03 1.0112592886186908e-03
     	 	 3.6063269088997774e-01 2.2236940766160271e-02 2.2279150673930694e-03
     	 	 3.3802086539938003e-01 5.4063304917680029e-02 3.3788458291450028e-03
     	 	 3.3018294771700318e-01 9.5619903432276263e-02 3.6802844656110383e-03
     	 	 3.3242323762724113e-01 1.4898058038286036e-01 5.1299720019263662e-03
     	 	 3.1543381407694460e-01 2.1592239865788987e-01 5.4069755808719786e-03
     	 	 3.0611372617070776e-01 2.9745136664913202e-01 6.5013734241924038e-03
     	 	 3.0736868302439413e-01 3.7955530748508742e-01 5.8114743932278484e-03
     	 	 3.3074844353843491e-01 4.3420061896748824e-01 5.8640506412219731e-03
     	 	 2.8362083461545717e-01 5.5200364344010566e-01 4.2644480841803178e-03
     	 	 3.1764265230945088e-01 5.7759591953428779e-01 4.3567736679857626e-03
     	 	 3.3702713041293386e-01 6.0570626401972172e-01 3.5868949672705980e-03
     	 	 3.5030141259547587e-01 6.2625108420224929e-01 2.3124830707410161e-03
     	 	 3.5924406581243951e-01 6.3627669025592448e-01 1.0546324340422128e-03
     	 	 2.5885520337146617e-01 4.7062984508965478e-03 9.9120128562999528e-04
     	 	 2.7215870446750534e-01 2.4406211509196946e-02 2.3384506300044030e-03
     	 	 2.4990526156749182e-01 6.0705040555295908e-02 3.6170342517297897e-03
     	 	 2.5352266192419803e-01 1.1211939221329155e-01 4.3867174906729988e-03
     	 	 2.4665812161612455e-01 1.7566904583359108e-01 5.4170404496467778e-03
     	 	 2.4001133580523359e-01 2.5165418312297638e-01 5.4450250695426928e-03
     	 	 2.2669802248134563e-01 3.2653161626138255e-01 5.0300462128185248e-03
     	 	 2.3418794319868097e-01 3.9314789295453045e-01 5.3895768933074758e-03
     	 	 2.3912401356486657e-01 4.6476972036342928e-01 4.8896885067892405e-03
     	 	 2.5396169689714176e-01 5.1549684919972449e-01 4.9814142063065239e-03
     	 	 2.1126009342302743e-01 6.1133447574967592e-01 4.4849957575985163e-03
     	 	 2.3779581347283263e-01 6.4832045901586743e-01 4.1465435465580531e-03
     	 	 2.5074291000130866e-01 6.8646901198432231e-01 3.5669476050441311e-03
     	 	 2.6468110193036432e-01 7.0943887386555704e-01 2.3731092107918124e-03
     	 	 2.7045770314190254e-01 7.2460473779070933e-01 1.0730400949808226e-03
     	 	 1.8179919596363625e-01 4.9971109153978286e-03 9.1491126517684990e-04
     	 	 1.9175512895795388e-01 2.5807124957902126e-02 2.1680488719423600e-03
     	 	 1.7271000038731865e-01 6.1513481066373547e-02 2.9594225732742507e-03
     	 	 1.8057732837580098e-01 1.0933754716319009e-01 3.7912609762752632e-03
     	 	 1.7407087537823529e-01 1.6926778585314781e-01 4.4578496168987411e-03
     	 	 1.7280972719016652e-01 2.4096836485822115e-01 5.1452820271514974e-03
     	 	 1.6161728095124528e-01 3.2431789123780652e-01 5.3821172531606691e-03
     	 	 1.6102594482916466e-01 4.1151479704313454e-01 5.5765485475729399e-03
     	 	 1.7143530558949105e-01 4.8883442220094370e-01 5.3955999116988050e-03
     	 	 1.7429894652943534e-01 5.7125867116504592e-01 5.6633788374675226e-03
     	 	 1.4848453669882822e-01 6.7204801710905726e-01 4.2408232208651850e-03
     	 	 1.6894700101339388e-01 7.1700161779063587e-01 3.8077635747868800e-03
     	 	 1.7539954048311701e-01 7.6200777518867013e-01 3.0929077068443901e-03
     	 	 1.8724488978743903e-01 7.8685511888437698e-01 2.1134790462189611e-03
     	 	 1.9050945800957020e-01 8.0452067548975692e-01 9.4931811284156638e-04
     	 	 1.1624646636809954e-01 4.7385210121070314e-03 7.2049965607649303e-04
     	 	 1.2191675697060633e-01 2.5263454181041582e-02 1.8130351241871362e-03
     	 	 1.1017343766273657e-01 6.2221973271026208e-02 2.5268267942433814e-03
     	 	 1.1475244788621786e-01 1.1495970177198044e-01 3.5801168104501340e-03
     	 	 1.1189257384587892e-01 1.8129994661784002e-01 3.9481671239947284e-03
     	 	 1.1075837944914801e-01 2.5310400381465337e-01 4.0390337367342414e-03
     	 	 1.0438497732558172e-01 3.2131515648104214e-01 3.4028140736608870e-03
     	 	 1.0239478872211127e-01 3.9298942245736684e-01 4.1345017724543813e-03
     	 	 1.0346871683889347e-01 4.7436597993314761e-01 4.4291143517892380e-03
     	 	 1.1303844756267123e-01 5.4988718121667002e-01 4.6543505327202982e-03
     	 	 1.0985548944910695e-01 6.3486845094071997e-01 4.5887207642026995e-03
     	 	 9.3610808903639264e-02 7.2599883662205766e-01 3.4368111471646430e-03
     	 	 1.0838620730011050e-01 7.7615214944184008e-01 3.2663882772224809e-03
     	 	 1.1168902497420508e-01 8.2522242103868204e-01 2.5841512037684334e-03
     	 	 1.1990640704070465e-01 8.5432394946056223e-01 1.7876406578944241e-03
     	 	 1.2202898317502897e-01 8.7307912860114778e-01 7.7830440795240814e-04
     	 	 6.4154004854375501e-02 4.9366116367978293e-03 5.6488482778186593e-04
     	 	 6.6627387082783596e-02 2.5175511804840650e-02 1.3160188546467698e-03
     	 	 6.0787436688093832e-02 5.9061586608004486e-02 1.7107682445965974e-03
     	 	 6.2185140790910642e-02 1.0635324988063251e-01 2.4202877120317544e-03
     	 	 6.2497889440256693e-02 1.6722274478387375e-01 2.9854299327594321e-03
     	 	 6.0770139225887920e-02 2.4293307245584250e-01 3.5286219293866666e-03
     	 	 5.8215112408715908e-02 3.2922907825824299e-01 3.6761727733717808e-03
     	 	 5.5615289437524029e-02 4.2294929726540226e-01 3.7437292069021902e-03
     	 	 5.7313496109903106e-02 5.1447776723586214e-01 3.6751941790134461e-03
     	 	 6.2785167352666371e-02 5.9922470953765672e-01 3.8414747484949901e-03
     	 	 5.9079347392116732e-02 6.8656634966170471e-01 3.4397510982209487e-03
     	 	 5.1231401969678902e-02 7.7008315331048860e-01 2.5128728482791160e-03
     	 	 5.9344752267735612e-02 8.2549637573841750e-01 2.4481094614859072e-03
     	 	 6.1290351232676676e-02 8.7459798815184409e-01 1.9182128975680213e-03
     	 	 6.5599947276063109e-02 9.0761053861512109e-01 1.3917512229188963e-03
     	 	 6.7178275875912408e-02 9.2765244575382322e-01 6.2601894132864654e-04
     	 	 2.6705840874833298e-02 4.6087480186813865e-03 3.5422097810620441e-04
     	 	 2.7100332010038142e-02 2.4870742283301862e-02 8.8690174784958971e-04
     	 	 2.5425327579150725e-02 6.2639681881770673e-02 1.3108871091152350e-03
     	 	 2.5427021015560602e-02 1.1694614956428119e-01 1.7836172439263949e-03
     	 	 2.5942735591612975e-02 1.8568130524281312e-01 2.1786838880919284e-03
     	 	 2.4672244373610708e-02 2.6664015669566088e-01 2.3836800154181850e-03
     	 	 2.4026710118842054e-02 3.5538438169225739e-01 2.4380207020409726e-03
     	 	 2.2606943779779787e-02 4.4812029063809244e-01 2.3832929358167405e-03
     	 	 2.3852619948939835e-02 5.4046972358172163e-01 2.4859416755261426e-03
     	 	 2.5920264636543400e-02 6.3101054382336219e-01 2.6199490067380046e-03
     	 	 2.4098321175936910e-02 7.1892093946976277e-01 2.2387973562551745e-03
     	 	 2.1553281784580824e-02 7.9868109259907949e-01 1.7256364888643971e-03
     	 	 2.4165692789290483e-02 8.6312850701022681e-01 1.6612255192761834e-03
     	 	 2.5618127114598210e-02 9.1430993366355073e-01 1.2691377917744644e-03
     	 	 2.7039389783462542e-02 9.4893016923081119e-01 8.4591466206792470e-04
     	 	 2.7822374863807786e-02 9.6770641200624541e-01 3.5969894474734880e-04
     	 	 5.1483019257422269e-03 5.6595306095627226e-03 1.9052660467833724e-04
     	 	 5.1245947413699477e-03 2.9385798736885672e-02 4.3116092860205250e-04
     	 	 4.8697464646278998e-03 7.0647270184572772e-02 6.1276396288073988e-04
     	 	 4.8397098555654772e-03 1.2669319828590356e-01 7.7496518639466421e-04
     	 	 4.9975406324804794e-03 1.9449440089239320e-01 9.3126570979988881e-04
     	 	 4.6661386498154656e-03 2.7173345513985353e-01 9.7187520518597983e-04
     	 	 4.6513253880476890e-03 3.5610063807638859e-01 1.0379732851970216e-03
     	 	 4.2984568139066148e-03 4.4581300192641465e-01 1.0108090579831776e-03
     	 	 4.4905829362752447e-03 5.3835033120943021e-01 1.0692114810597285e-03
     	 	 4.9377743392174933e-03 6.2959899432039479e-01 1.1308903851553699e-03
     	 	 4.7201326867956084e-03 7.1621533415092331e-01 1.0073499095317542e-03
     	 	 4.2161417887426333e-03 7.9642317694156495e-01 8.2101624714678377e-04
     	 	 4.4540145057012648e-03 8.6746162716247710e-01 7.4248170073845405e-04
     	 	 4.8690613651276582e-03 9.2453334117172048e-01 6.2051861535689177e-04
     	 	 5.1110126947817580e-03 9.6573154549111373e-01 4.2893847813971664e-04
     	 	 5.3232235140929784e-03 9.8909781254099816e-01 1.9477065644543458e-04
     	 	 ];


    case 32

        % SET: SLOBODKINS TAUSCH
        % CARDINALITY RULE  :    189
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 7.425e-16

        XYW=[
    	 	 9.9121548668563286e-01 4.5702935936851588e-03 1.2759615839579182e-04
     	 	 9.7153174789246199e-01 2.4111987129080165e-02 3.0433053400779725e-04
     	 	 9.7278805044637273e-01 4.6123110912306715e-03 3.0736875374083231e-04
     	 	 9.5342409780524195e-01 2.3997927426156508e-02 6.7476082454572732e-04
     	 	 9.3600773424741546e-01 5.9095399691681927e-02 5.3398603038360391e-04
     	 	 9.3897465467923602e-01 4.5968015560684120e-03 4.8972688101262462e-04
     	 	 9.2144666925328134e-01 2.4064203857921983e-02 1.0428681439215589e-03
     	 	 8.7890695888311976e-01 5.8680262032772566e-02 1.8591986665115988e-03
     	 	 9.1658778659055129e-01 5.7749522749996597e-02 1.1700318383405311e-03
     	 	 8.8644187721926626e-01 1.0892951300489717e-01 6.7493821332167861e-04
     	 	 8.8990071367534629e-01 4.6271266254197122e-03 6.6765480695812798e-04
     	 	 8.7633937268721707e-01 2.4244995015167022e-02 1.4006945947796544e-03
     	 	 8.2693312856849788e-01 5.8799593142111375e-02 2.4599973801801567e-03
     	 	 8.3428572430993286e-01 1.0696588193654871e-01 2.2554190278792031e-03
     	 	 8.7103602540438585e-01 1.0461046377667434e-01 1.4508665066335971e-03
     	 	 8.2335335704517010e-01 1.7235731621254607e-01 7.6326653140251495e-04
     	 	 8.2699780725424565e-01 4.5653549169362628e-03 8.0954229712223362e-04
     	 	 8.1890525369808087e-01 2.3931868500137714e-02 1.7222787333707331e-03
     	 	 7.6322775545397226e-01 5.7398468045256605e-02 2.8620958320272230e-03
     	 	 7.8582835257679440e-01 1.0759092562004774e-01 3.0122824136226915e-03
     	 	 7.7872474424996518e-01 1.6678238509358370e-01 2.5142662489823064e-03
     	 	 8.1388414961601108e-01 1.6357205022067706e-01 1.6347240313174683e-03
     	 	 7.3148848716834014e-01 1.6938811224782757e-01 3.4077883898486231e-03
     	 	 7.5251484384220624e-01 4.4651804956141261e-03 9.0809896450681641e-04
     	 	 7.4921639424009556e-01 2.3414975070661204e-02 1.9928435229038836e-03
     	 	 6.8862868383312548e-01 5.6569799211150074e-02 3.1975360328676721e-03
     	 	 7.2802286846459452e-01 1.0448715950912878e-01 3.5153158509408818e-03
     	 	 6.8155270783627020e-01 1.6316008649117578e-01 3.8548742176220826e-03
     	 	 7.0833486265822554e-01 2.3688162505963242e-01 2.9156409021324345e-03
     	 	 7.4420766215761658e-01 2.3333810814829822e-01 1.8896062412417178e-03
     	 	 7.4890334834478567e-01 2.4679305862849216e-01 8.7022363348213832e-04
     	 	 6.6942104073071951e-01 4.4536935094154958e-03 9.8487541338043195e-04
     	 	 6.6896122236130973e-01 2.3290431302010806e-02 2.2105032056334390e-03
     	 	 6.0543443218243731e-01 5.6735814720030510e-02 3.4645473319067010e-03
     	 	 6.5825211470784550e-01 1.0318840935274887e-01 3.9469432867005544e-03
     	 	 6.1725358735240932e-01 1.6141745090271692e-01 4.4738788497190735e-03
     	 	 6.1221597816113371e-01 2.2969944117034374e-01 4.4404375732650962e-03
     	 	 6.5808598855454892e-01 2.4125265485455019e-01 3.9635304445182120e-03
     	 	 6.2922074111865867e-01 3.1439983852697845e-01 3.2090552903977225e-03
     	 	 6.6448308231469899e-01 3.1237774891709602e-01 2.1656090920981232e-03
     	 	 6.6643919652868699e-01 3.2912559542123410e-01 9.6953443739890917e-04
     	 	 5.8088650893487603e-01 4.4970932920161853e-03 1.0396511784580230e-03
     	 	 5.8156354705747870e-01 2.3499920206986973e-02 2.3644353778815687e-03
     	 	 5.1739382160737279e-01 5.7329562750209291e-02 3.6027661845818896e-03
     	 	 5.8031739470363375e-01 1.0343407487962154e-01 4.2512253873840996e-03
     	 	 5.4191680748607318e-01 1.6210934432416024e-01 5.0318320253059873e-03
     	 	 5.4393197425294293e-01 2.2954127406030214e-01 5.3033199565619459e-03
     	 	 5.3567063442476337e-01 3.0267754122781332e-01 4.8759993557597860e-03
     	 	 5.7629909169026006e-01 3.2039509642607200e-01 4.3510529709212048e-03
     	 	 5.4786641917031831e-01 3.9508422291509904e-01 3.2781799711107521e-03
     	 	 5.7793225732949272e-01 3.9856416551553298e-01 2.3469731188933501e-03
     	 	 5.7920690765424776e-01 4.1629704164621806e-01 1.0197043795910946e-03
     	 	 4.8987538245367501e-01 4.5267521533152687e-03 1.0586649474137047e-03
     	 	 4.9092214938376200e-01 2.3679535117414011e-02 2.4223744640708409e-03
     	 	 4.3032274234098278e-01 5.7347020136716914e-02 3.3905180830025466e-03
     	 	 4.9767983060275700e-01 1.0446376578486341e-01 4.4581305906582595e-03
     	 	 4.6006754476404133e-01 1.6347420024239362e-01 5.3092608820624054e-03
     	 	 4.6529115317969749e-01 2.3148700939559053e-01 5.8734194807331377e-03
     	 	 4.6330447724273216e-01 3.0606748017162150e-01 5.8374342285273245e-03
     	 	 4.5599098732171595e-01 3.8111914007269804e-01 5.1626992794845446e-03
     	 	 4.9196799905088195e-01 4.0399492567074868e-01 4.5115626753097224e-03
     	 	 4.6743009778132349e-01 4.7547863157874459e-01 3.2258792423384523e-03
     	 	 4.8763288767179946e-01 4.8884736950252500e-01 2.4091684443114480e-03
     	 	 4.9039929600305265e-01 5.0510777486926217e-01 1.0201401921602479e-03
     	 	 3.9930289760866156e-01 4.4886990101150534e-03 1.0280219107051409e-03
     	 	 4.0057510181641443e-01 2.3514290386610587e-02 2.3583173707513497e-03
     	 	 3.6058273413212949e-01 5.6808648868442800e-02 2.0225797947130263e-03
     	 	 4.1323094321746523e-01 1.0447810943287188e-01 4.5325577484953391e-03
     	 	 3.7742158278843052e-01 1.6335890282142343e-01 5.2601548843359590e-03
     	 	 3.8248793221859989e-01 2.3239029053611140e-01 6.0502048645889603e-03
     	 	 3.8446866171430905e-01 3.0828874201912343e-01 6.2881248993198581e-03
     	 	 3.8062250809075926e-01 3.8769545386262161e-01 6.0183009976944105e-03
     	 	 3.7532215110658684e-01 4.6170974779317264e-01 5.1091363866808490e-03
     	 	 4.0684169364653344e-01 4.8894504553407192e-01 4.5221294450386662e-03
     	 	 3.8854240908306947e-01 5.5424767761728833e-01 3.1739217771492825e-03
     	 	 3.9693166613383402e-01 5.7948730735272691e-01 2.3742698570220102e-03
     	 	 4.0278415707604864e-01 5.9270420409804647e-01 9.9713916297188400e-04
     	 	 3.1212909197448824e-01 4.4585084465586658e-03 9.6540123172871310e-04
     	 	 3.1374360231981058e-01 2.3340029854803979e-02 2.2052386752789543e-03
     	 	 3.1430735773328689e-01 5.6803588928580076e-02 2.3345086600997395e-03
     	 	 3.2903664999250570e-01 1.0365329048718247e-01 4.4328551182233715e-03
     	 	 2.9827691574387183e-01 1.6220429909039796e-01 4.9005522562081587e-03
     	 	 3.0099529962741900e-01 2.3124572093710213e-01 5.8211352196191101e-03
     	 	 3.0452271182407775e-01 3.0798764893284281e-01 6.2579009192209835e-03
     	 	 3.0421161881533287e-01 3.8908032105421053e-01 6.2497324564773603e-03
     	 	 2.9921438272850320e-01 4.7047238561045451e-01 5.7768884045161315e-03
     	 	 2.9818328448447817e-01 5.4010400107113721e-01 4.7461683047375827e-03
     	 	 3.2305292627754600e-01 5.7340059059320025e-01 4.3563976422405651e-03
     	 	 3.1065606585783268e-01 6.3290228053004294e-01 3.1148885041667176e-03
     	 	 3.0967650479571984e-01 6.6713199137077583e-01 2.2038199741520135e-03
     	 	 3.1843690056855911e-01 6.7713212642769438e-01 9.3320999621864756e-04
     	 	 2.3123018128607631e-01 4.5329535424096113e-03 8.9197142847395616e-04
     	 	 2.3366402135905251e-01 2.3651434693709030e-02 2.0072591001184577e-03
     	 	 2.4517563471185466e-01 5.6984128583741411e-02 2.9524138917661259e-03
     	 	 2.4775051761279743e-01 1.0382327460287094e-01 4.1625523821472001e-03
     	 	 2.2527912751034873e-01 1.6325942151790598e-01 4.4466327348174255e-03
     	 	 2.2496297821054900e-01 2.3146404982163482e-01 5.2181140922803668e-03
     	 	 2.2842976413880900e-01 3.0717458508660866e-01 5.7425036190274685e-03
     	 	 2.2985848696648492e-01 3.8811712468918108e-01 5.9225680025696836e-03
     	 	 2.2773060064774076e-01 4.7082674350722492e-01 5.7283445666435869e-03
     	 	 2.2329991715176667e-01 5.5076200476807258e-01 5.1535983897641859e-03
     	 	 2.2714922832682938e-01 6.1421838424547981e-01 4.2835041376589411e-03
     	 	 2.4410585379255967e-01 6.5433552330952405e-01 3.9389847134916282e-03
     	 	 2.3478787467004525e-01 7.0951040705149881e-01 2.8964318931864802e-03
     	 	 2.2935230608292567e-01 7.4763731139946410e-01 1.9534841550217603e-03
     	 	 2.3907804057500415e-01 7.5651720500544106e-01 8.5933141690422335e-04
     	 	 1.5938020198344705e-01 4.7878760881131920e-03 8.1486964806681004e-04
     	 	 1.6322152922820243e-01 2.4957169674915999e-02 1.8229040006722738e-03
     	 	 1.7441521090568990e-01 5.9844611245085028e-02 2.8402066842555160e-03
     	 	 1.7357970635581699e-01 1.0832621639717165e-01 3.7630362359741161e-03
     	 	 1.5889699633555388e-01 1.7026511190024932e-01 4.1115125422311440e-03
     	 	 1.5755755775743641e-01 2.4067626464215472e-01 4.6161626527069597e-03
     	 	 1.6015259587459418e-01 3.1628274651259930e-01 4.9475968248013967e-03
     	 	 1.6188323143012395e-01 3.9479307096521155e-01 5.0461279110251521e-03
     	 	 1.5883255373291705e-01 5.5007504023536269e-01 4.5179485160535904e-03
     	 	 1.5618660613420354e-01 6.2081836989684380e-01 4.0417248030851288e-03
     	 	 1.6139967338941053e-01 6.7875711801534688e-01 3.7958955639846650e-03
     	 	 1.7242520975965714e-01 7.2490164657321765e-01 3.4628666109244271e-03
     	 	 1.6516763956353797e-01 7.7788633415849529e-01 2.6185252750799133e-03
     	 	 1.5921855982550692e-01 8.1716605105591456e-01 1.7039964379191677e-03
     	 	 1.6698275914984251e-01 8.2852698538039393e-01 7.7626402903472550e-04
     	 	 9.9078786236107885e-02 4.6359544388389151e-03 6.3961264601593878e-04
     	 	 1.0353878885090639e-01 2.4499580055095345e-02 1.4919044180190903e-03
     	 	 1.1158241989788065e-01 6.0277645441157761e-02 2.4705472859617222e-03
     	 	 1.1099318141946202e-01 1.1030496499819605e-01 3.1753028653592561e-03
     	 	 1.0217947339677402e-01 1.7163205026365411e-01 3.4056168337768225e-03
     	 	 1.0021927881018566e-01 2.4284434634576288e-01 3.9183602731009291e-03
     	 	 1.0190583213388404e-01 3.2227854031734360e-01 4.3346370332692247e-03
     	 	 1.0343685417983861e-01 4.0656148297779826e-01 4.5464292995010085e-03
     	 	 1.6118990668460353e-01 4.7376893165068856e-01 4.8947560980130249e-03
     	 	 1.0320364440634822e-01 4.9301534731052737e-01 4.5352436648207727e-03
     	 	 1.0156154918074956e-01 5.7877987772271178e-01 4.3190310149853204e-03
     	 	 9.9839140266508086e-02 6.5999709849406651e-01 3.8991552759221506e-03
     	 	 1.0255064272861714e-01 7.2928502003052564e-01 3.4849565817278174e-03
     	 	 1.1088715202063715e-01 7.8139448962242231e-01 3.0201285660897237e-03
     	 	 1.0508383250770581e-01 8.3519401768453339e-01 2.2921015538804406e-03
     	 	 1.0131131053186360e-01 8.7380608163583295e-01 1.4293671858507685e-03
     	 	 1.0523038345059621e-01 8.9000503542376941e-01 6.7719429648466646e-04
     	 	 5.2309041052093108e-02 3.8178003605855715e-03 3.8786466743936780e-04
     	 	 5.5772675676148631e-02 2.0735477493606113e-02 9.7064635852639025e-04
     	 	 6.0646587695728393e-02 5.2449851410375684e-02 1.6674608431409585e-03
     	 	 6.1541122726155417e-02 9.7487579298428356e-02 2.2177261937041419e-03
     	 	 5.7792968534917555e-02 1.5321238307561660e-01 2.4698460889891489e-03
     	 	 5.4876461752380590e-02 2.1933981289971410e-01 2.7455434705416257e-03
     	 	 5.5236592791036321e-02 2.9263529695805102e-01 2.9814135403295407e-03
     	 	 5.6272681683926518e-02 3.7019878955690438e-01 3.1890454871023577e-03
     	 	 5.6858779628875089e-02 4.5189403610025947e-01 3.3837046874910007e-03
     	 	 5.6474307318699735e-02 5.3736564772025663e-01 3.4415010623810634e-03
     	 	 5.5452727313637151e-02 6.2304035224607590e-01 3.2887433962701437e-03
     	 	 5.4789249426611897e-02 7.0399904707241756e-01 2.9849618295839601e-03
     	 	 5.6357011263711287e-02 7.7502750781748642e-01 2.7110695361671632e-03
     	 	 6.1200538823235506e-02 8.3252893347161794e-01 2.4255388334267322e-03
     	 	 5.6541348877259257e-02 8.8689062308104993e-01 1.7427810601952261e-03
     	 	 5.6266396936894503e-02 9.2141542152636635e-01 1.0077565809823625e-03
     	 	 5.6631096817837512e-02 9.3919063503907674e-01 4.4674893501645918e-04
     	 	 2.0745991168289013e-02 4.6610538748301424e-03 2.8686679227551607e-04
     	 	 2.3119530332633254e-02 2.3684142340853240e-02 6.7184828243573448e-04
     	 	 2.5164343683003576e-02 5.5793593833497426e-02 1.0879043462354954e-03
     	 	 2.5241057893316210e-02 1.0107288971630680e-01 1.4828291732545220e-03
     	 	 2.3802196661349084e-02 1.6016194326873226e-01 1.7497498633043916e-03
     	 	 2.2531067455691001e-02 2.3161162069734462e-01 1.9401390422262564e-03
     	 	 2.2799437338844486e-02 3.1240815943436662e-01 2.1771161715211911e-03
     	 	 2.3261391994272684e-02 4.0026511527252756e-01 2.3675200511997637e-03
     	 	 2.3443906196251696e-02 4.9201598121976925e-01 2.4361496375611782e-03
     	 	 2.3138789046729058e-02 5.8409051150386948e-01 2.3587810324823761e-03
     	 	 2.2704559419155945e-02 6.7241430416286552e-01 2.1635240582191738e-03
     	 	 2.2657167031341574e-02 7.5246772065417156e-01 1.8975201644246421e-03
     	 	 2.3438907186080438e-02 8.1965575947483682e-01 1.6081974741919440e-03
     	 	 2.5697341967741760e-02 8.7168522478248567e-01 1.3846817407304692e-03
     	 	 2.2580741366783563e-02 9.1807045075967630e-01 1.0077194494414468e-03
     	 	 2.3742409947091314e-02 9.5058113246936982e-01 7.3234754730949910e-04
     	 	 2.2760648982982024e-02 9.7224819147384767e-01 3.3367063827633835e-04
     	 	 3.8132717064233157e-03 4.5336244569218120e-03 1.1546063043856086e-04
     	 	 4.4216990288818980e-03 2.4158825793701849e-02 3.1248323261184424e-04
     	 	 4.8287339064939649e-03 5.9480428957263604e-02 5.3062182369881467e-04
     	 	 4.7934977702475123e-03 1.0947129557327116e-01 6.9749490994493115e-04
     	 	 4.5088474696282077e-03 1.7227271642413122e-01 7.8827335557763291e-04
     	 	 4.2896126233589182e-03 2.4478183378777402e-01 8.3551435859591228e-04
     	 	 4.3657371994026972e-03 3.2310497539699978e-01 8.9834834769893593e-04
     	 	 4.4402421891182042e-03 4.0492017911829037e-01 9.4759501899547118e-04
     	 	 4.4852359407030473e-03 4.8958421005418329e-01 9.8845667037146079e-04
     	 	 4.4374593838091281e-03 5.7659478610380255e-01 9.9583265341696625e-04
     	 	 4.3548438801145339e-03 6.6382517511951400e-01 9.6151336837693258e-04
     	 	 4.3227486839582108e-03 7.4765533838116394e-01 8.9405137212008104e-04
     	 	 4.4264501499456932e-03 8.2379704540450394e-01 8.0596621655279997e-04
     	 	 4.8503177034912026e-03 8.8804722122671897e-01 7.1790344457019315e-04
     	 	 4.2891518766544623e-03 9.3890492340525278e-01 4.6896219468943218e-04
     	 	 4.5996093383753323e-03 9.7300738314024016e-01 3.0859226861752769e-04
     	 	 4.2271602594093904e-03 9.9170237608438994e-01 1.1564893698037550e-04
     	 	 ];


    case 33

        % SET: SLOBODKINS TAUSCH
        % CARDINALITY RULE  :    200
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 2.597e-15

        XYW=[
    	 	 9.9024328884547108e-01 4.7918799199411716e-03 1.5603278294766255e-04
     	 	 9.7066954203296496e-01 2.5016357159646174e-02 3.1057663080034210e-04
     	 	 9.6945946179791209e-01 4.5714332396952122e-03 3.4246858813932616e-04
     	 	 9.5287771834513313e-01 2.4248423109643508e-02 7.1655715559935690e-04
     	 	 9.3542498175696065e-01 6.0416901292977131e-02 4.5312441085482163e-04
     	 	 9.3283605715681261e-01 4.0657754561078579e-03 4.6597189198376032e-04
     	 	 9.2167566049759075e-01 2.1574442921340153e-02 1.0029260769381773e-03
     	 	 8.9395395626801544e-01 5.2899227802959969e-02 1.4500466813242162e-03
     	 	 9.1883028425468116e-01 5.9456539087368726e-02 1.0403241566071530e-03
     	 	 8.8611339562836966e-01 1.0974480883673918e-01 5.9277136529923343e-04
     	 	 8.8141733080077356e-01 4.0432754341119754e-03 5.9894956036607840e-04
     	 	 8.7410788627195768e-01 2.1101491825025357e-02 1.3001669199005572e-03
     	 	 8.5067554233883136e-01 5.1382838007975995e-02 1.8665912467299409e-03
     	 	 8.1252914735793713e-01 9.3931967084033494e-02 2.2840533400628540e-03
     	 	 8.5063935613515063e-01 9.7554279057684559e-02 1.8419322876355427e-03
     	 	 8.6940630091847027e-01 1.0898273442560552e-01 1.3522805678050126e-03
     	 	 8.2400774127908205e-01 1.7168268305468773e-01 7.4791094456721043e-04
     	 	 8.1785631076310650e-01 4.2503107150036572e-03 7.4681489738529655e-04
     	 	 8.1253260678596517e-01 2.2051933237618993e-02 1.6464245912009943e-03
     	 	 7.9280608629585658e-01 5.3101610359741674e-02 2.3135338953791675e-03
     	 	 7.5703514179736209e-01 9.6565080494328895e-02 2.8813600148528168e-03
     	 	 7.9141100257217334e-01 1.5392429543460051e-01 2.4389646499062270e-03
     	 	 8.0704652481388417e-01 1.7031674963382451e-01 1.7023107697518357e-03
     	 	 7.5121406292587012e-01 2.4432378034177632e-01 8.8256601731196240e-04
     	 	 7.4468463784463690e-01 4.3921365132563190e-03 8.6808777369583692e-04
     	 	 7.4015053313836554e-01 2.2951737766904221e-02 1.9727946748046873e-03
     	 	 7.2416144965457352e-01 5.5598992976796761e-02 2.8238047817282347e-03
     	 	 6.9094610417235514e-01 1.0121685438799150e-01 3.3686911559301976e-03
     	 	 6.8879085443048116e-01 1.5355861448967600e-01 3.9166076551858560e-03
     	 	 7.5303085482714360e-01 1.4710026418801739e-01 2.9829388533657692e-03
     	 	 6.8913898702875276e-01 2.0878695701331532e-01 3.3981933075367949e-03
     	 	 7.2195666944701131e-01 2.2179538979005958e-01 2.9140606900915599e-03
     	 	 7.3532468694346353e-01 2.4139820306355309e-01 1.9633789730161581e-03
     	 	 6.6434321813082209e-01 4.3348584318891829e-03 9.2429018060591014e-04
     	 	 6.5997791206769341e-01 2.2767446063634858e-02 2.1415812022648785e-03
     	 	 6.4810252860428996e-01 5.5471576048278376e-02 3.1645381415001906e-03
     	 	 5.5340526987575100e-01 9.2847390288287632e-02 3.8051736515399260e-03
     	 	 6.2306487882035655e-01 1.0122231779415208e-01 3.6183358341783066e-03
     	 	 6.1290292957265602e-01 1.5692268210244392e-01 4.1450814850442089e-03
     	 	 6.1175890946597344e-01 1.8592002777331296e-01 1.2266369654762397e-03
     	 	 6.1995069880689635e-01 2.2365308593810576e-01 4.2867479377236631e-03
     	 	 6.2082888861438779e-01 2.8016477389729649e-01 3.7703289985262186e-03
     	 	 6.4539898309200416e-01 3.0030134091118005e-01 3.1436919280634626e-03
     	 	 6.5744743635951786e-01 3.2043826104145351e-01 2.0371127667337609e-03
     	 	 6.7037262716222390e-01 3.2540758951783844e-01 9.1272197351024075e-04
     	 	 5.7937914961639159e-01 3.6640916173586082e-03 8.2103928336625404e-04
     	 	 5.7533397096721539e-01 1.9763940954811206e-02 1.9930344091908655e-03
     	 	 5.6680997906872177e-01 4.9641654683202779e-02 3.1673902493266183e-03
     	 	 5.3823877513371587e-01 1.4999869023806034e-01 4.8107385565236442e-03
     	 	 4.8352722021821515e-01 2.1691668819466059e-01 3.4024179898467081e-03
     	 	 5.3370066998550825e-01 2.0806710333858711e-01 2.6740550189834496e-03
     	 	 5.4353634844779875e-01 2.4298216443357248e-01 4.1223828872620294e-03
     	 	 5.4653767001315479e-01 3.0339002134195525e-01 4.7708836205871529e-03
     	 	 5.4477547573530716e-01 3.6293493303080865e-01 4.1619087195683543e-03
     	 	 5.6474665708030281e-01 3.8635824966248122e-01 3.0870428164980778e-03
     	 	 5.7515274527224802e-01 4.0538808686554512e-01 1.9091928239864729e-03
     	 	 5.8384634647356126e-01 4.1249427758899293e-01 8.3736690288960713e-04
     	 	 4.9164600763281774e-01 4.4340036287544345e-03 9.9571084441857317e-04
     	 	 4.8704433466051189e-01 2.2856812041036276e-02 2.2045195275683539e-03
     	 	 4.7806543080060437e-01 5.4026050433862743e-02 3.2497917239095804e-03
     	 	 4.7573786601807344e-01 9.5808108843556075e-02 3.6407594350412039e-03
     	 	 4.6013327444686791e-01 1.4725748260405158e-01 4.6137610763958446e-03
     	 	 4.2926160310217631e-01 2.0868296362202113e-01 4.5158619547098783e-03
     	 	 4.3324975815634770e-01 2.8123468729344592e-01 5.0889147760000732e-03
     	 	 4.7316856099959181e-01 3.1176724558769198e-01 5.0535292029004015e-03
     	 	 4.6897455551472522e-01 3.8378032677603402e-01 4.7917849828320444e-03
     	 	 4.5851257142968727e-01 4.4502520019651887e-01 3.9138047469733242e-03
     	 	 4.7705233392481816e-01 4.6848982818726248e-01 3.2053316878118752e-03
     	 	 4.8819730857105825e-01 4.8891547210638764e-01 2.1932808075573840e-03
     	 	 4.9359727721673397e-01 5.0203725364798324e-01 1.0113726643179149e-03
     	 	 4.0432885499930993e-01 3.8205000202396209e-03 8.5360276842823333e-04
     	 	 4.0095490722302263e-01 2.0604371298917141e-02 2.0411105147304996e-03
     	 	 3.9073385243359049e-01 5.1609381560464462e-02 3.3188759466766895e-03
     	 	 3.9568686978944945e-01 9.6276479357391143e-02 4.0482813841565424e-03
     	 	 3.7692382036846928e-01 1.5170700856378458e-01 4.8952897172407197e-03
     	 	 3.5706737339489314e-01 2.1641262008684603e-01 4.6940793730456095e-03
     	 	 3.5857125319256999e-01 2.8387567180181500e-01 5.6532670844470197e-03
     	 	 3.6352015130977389e-01 3.5845997353359227e-01 5.7302116685146306e-03
     	 	 4.0524463515558173e-01 3.8836460450634869e-01 4.7575301425147754e-03
     	 	 3.8227776523570733e-01 4.7083867907176097e-01 4.9213234049869858e-03
     	 	 3.7706034673069222e-01 5.3078078706080978e-01 4.0111537327931395e-03
     	 	 3.9302725525473714e-01 5.5768570670600359e-01 3.1169036342270509e-03
     	 	 4.0361933708482123e-01 5.7674578716889935e-01 1.9205387898419157e-03
     	 	 4.0379929981148921e-01 5.9252744210002850e-01 8.4059613113384400e-04
     	 	 3.1990636299870323e-01 4.3773819381879150e-03 9.1143314604333846e-04
     	 	 3.1669217494656909e-01 2.2413837922526700e-02 2.0155573905286956e-03
     	 	 3.0455195508466626e-01 5.3020916288316060e-02 3.0051290031856302e-03
     	 	 3.1673108437072883e-01 9.4632652560058012e-02 3.7638646342527341e-03
     	 	 2.9783407347002966e-01 1.4788676817401844e-01 4.5774154090590753e-03
     	 	 2.8942836361422442e-01 2.1069655863790149e-01 4.6163995986227896e-03
     	 	 2.7944410018378785e-01 2.8341805220851612e-01 5.6395931007162401e-03
     	 	 2.8788686541760855e-01 3.5725708233337722e-01 5.6746689370654477e-03
     	 	 2.8591589389885408e-01 4.3261468831081862e-01 5.2849435598555840e-03
     	 	 3.3192512737633562e-01 4.5631007186025757e-01 4.6186082094493795e-03
     	 	 2.6832234071989447e-01 5.2121760181914956e-01 3.9786320771521087e-03
     	 	 3.0115467325812639e-01 5.5057614810936117e-01 4.6203774102592850e-03
     	 	 2.9753670017628997e-01 6.0654677577245086e-01 3.6093574410920553e-03
     	 	 3.0771378299662622e-01 6.3926824059481024e-01 3.0532882535570815e-03
     	 	 3.2017005656376862e-01 6.5791631234391967e-01 1.9837622502990346e-03
     	 	 3.1735870283860301e-01 6.7839827309871581e-01 9.0712075836397402e-04
     	 	 2.4175231922220985e-01 3.9309838087329615e-03 7.5650659914886160e-04
     	 	 2.3769450783357149e-01 2.1221430233989532e-02 1.8666914791824372e-03
     	 	 2.2670488903929586e-01 5.2933306321993355e-02 2.8474562137558493e-03
     	 	 2.3839167746882062e-01 9.7597638087933022e-02 3.8035921994349986e-03
     	 	 2.2168233260575854e-01 1.5454714607919773e-01 4.3878954026122900e-03
     	 	 2.2177001763670234e-01 2.1946228754819294e-01 4.5049044286912913e-03
     	 	 2.0663511800510714e-01 2.9097571352741058e-01 4.9760530295501534e-03
     	 	 2.1503419556185277e-01 3.6440814247657444e-01 5.2197611844367860e-03
     	 	 2.1561497977956079e-01 4.3865891090009268e-01 4.9828059067435542e-03
     	 	 2.1675122344660935e-01 5.0846848192590788e-01 4.4531730397474661e-03
     	 	 2.0866002894969204e-01 5.7813360879164910e-01 3.4008605159706910e-03
     	 	 2.2339343143670087e-01 6.2297908794728352e-01 4.1845820152559077e-03
     	 	 2.2545093529152760e-01 6.7447048190730585e-01 3.4164277461852890e-03
     	 	 2.2881293417721971e-01 7.1575447434881290e-01 2.8937547401181622e-03
     	 	 2.4144959568402957e-01 7.3565605842912229e-01 1.9377915537614114e-03
     	 	 2.3728092983457372e-01 7.5833768734496176e-01 8.5413930671301443e-04
     	 	 1.7150702586553290e-01 4.5473071910319823e-03 7.6080614523489902e-04
     	 	 1.6511656427979726e-01 2.3474603356455390e-02 1.7494959762385659e-03
     	 	 1.5801916864358156e-01 5.6182486219055722e-02 2.4138493721150003e-03
     	 	 1.6771481869840199e-01 9.9920119031674456e-02 3.3399996066235285e-03
     	 	 1.5489988566300128e-01 1.5579192807224518e-01 3.7442528944066061e-03
     	 	 1.5750149430032545e-01 2.2154330989518431e-01 4.3182540816384040e-03
     	 	 1.4377551991719695e-01 2.9671667150448328e-01 4.4826305082846327e-03
     	 	 1.4989155453245206e-01 3.7565578986460235e-01 4.9125675978406317e-03
     	 	 1.5126628357569105e-01 4.5755060738580861e-01 4.9431910160577094e-03
     	 	 1.5290504633846169e-01 5.3837452334493585e-01 4.8129158959478342e-03
     	 	 1.5224323361760195e-01 6.1623338350830281e-01 4.2307918354998874e-03
     	 	 1.5472263174380518e-01 6.8454908481416188e-01 4.0266513993290828e-03
     	 	 1.5972204788034039e-01 7.3843782751908282e-01 3.2871228142611979e-03
     	 	 1.5970837442573349e-01 7.8491232646542664e-01 2.5332932316685162e-03
     	 	 1.7004122397802579e-01 8.0722335263584633e-01 1.7159877652549236e-03
     	 	 1.6599690741031548e-01 8.2967414549676266e-01 7.3351385630940856e-04
     	 	 1.1107336058275108e-01 4.2970354201231804e-03 6.0986691029797505e-04
     	 	 1.0395403249325086e-01 2.2693878999683965e-02 1.4226903011965554e-03
     	 	 1.0174088915054924e-01 5.5877716111436507e-02 2.0546192882339213e-03
     	 	 1.0564090101165158e-01 1.0311595349521199e-01 2.9644532982311084e-03
     	 	 9.9163745588884189e-02 1.6201427255884768e-01 3.1159591318983501e-03
     	 	 1.0078104911064334e-01 2.2716692436364752e-01 3.5227134803097839e-03
     	 	 9.0980479566148964e-02 2.9662847321817504e-01 3.2832651623977533e-03
     	 	 9.4432823558886381e-02 3.6916798311482329e-01 3.6947458669723712e-03
     	 	 9.6071984622389972e-02 4.4593540793813025e-01 3.9173271106212699e-03
     	 	 9.7003070505664701e-02 5.2627891728724696e-01 4.0336853154644579e-03
     	 	 9.8111510083836007e-02 6.0510177898915118e-01 3.8733412014413183e-03
     	 	 9.8596876540588907e-02 6.7983456010453358e-01 3.5556562401923113e-03
     	 	 9.8471689583730204e-02 7.4628462415575414e-01 3.1049011787452605e-03
     	 	 1.0243266560252884e-01 7.9827479074292573e-01 2.6494817444057128e-03
     	 	 1.0160810099001549e-01 8.4388894300762907e-01 2.0121545499314011e-03
     	 	 1.0849644686963444e-01 8.6900515895020247e-01 1.4110530856003725e-03
     	 	 1.0574022583137355e-01 8.8996142406055123e-01 5.9661142808539345e-04
     	 	 6.1694416042549882e-02 4.3836804767786635e-03 4.8338776498273346e-04
     	 	 5.5676716344809640e-02 2.2826707136673785e-02 1.0410552535581516e-03
     	 	 5.6737460225988912e-02 5.4615927605130517e-02 1.4931755254366241e-03
     	 	 5.7209290853135641e-02 9.9422346460813313e-02 2.1165825731081782e-03
     	 	 5.5522193230457595e-02 1.5648982496237518e-01 2.4453121522913504e-03
     	 	 5.4466547394118270e-02 2.2668506874386765e-01 2.9687523973288706e-03
     	 	 5.0486024397261242e-02 3.0693967730860300e-01 2.9373643357826790e-03
     	 	 5.1463653295173661e-02 3.9219101299667597e-01 3.2287988740902066e-03
     	 	 5.2858812880851369e-02 4.7960344488461265e-01 3.2917270843232939e-03
     	 	 5.3108400063332839e-02 5.6640402000939738e-01 3.2328010094001187e-03
     	 	 5.4194741121249890e-02 6.4829802807287529e-01 3.0306245246875673e-03
     	 	 5.4152471274082625e-02 7.2371672183723146e-01 2.7387026693812444e-03
     	 	 5.3942794170667607e-02 7.9061939050737340e-01 2.3699053847284256e-03
     	 	 5.6076798337904576e-02 8.4503900837229295e-01 2.0313743674391467e-03
     	 	 5.5822756007709806e-02 8.8993588465286921e-01 1.5113641224666582e-03
     	 	 5.9229363279875713e-02 9.1837322995613024e-01 1.0647336401202198e-03
     	 	 5.8055820490569565e-02 9.3765257365497401e-01 4.5077305696993334e-04
     	 	 2.5612851154520277e-02 4.5261565023389325e-03 3.3284216323052412e-04
     	 	 2.2316741360123404e-02 2.3979047366169730e-02 6.9923851878771291e-04
     	 	 2.3906224041213342e-02 5.8713066381695503e-02 1.1150929631459131e-03
     	 	 2.3117749999755133e-02 1.0799130193995722e-01 1.4800837556380676e-03
     	 	 2.3197747230108035e-02 1.7031092658072211e-01 1.7434844228585891e-03
     	 	 2.1944730459389050e-02 2.4251707697465580e-01 1.9017893750598832e-03
     	 	 2.0982131685695182e-02 3.2196941261629902e-01 1.8983530139559280e-03
     	 	 2.1012733007743756e-02 4.0485872516594235e-01 2.0167015443258874e-03
     	 	 2.1842567483603581e-02 4.9042940428985576e-01 2.1212225678394823e-03
     	 	 2.1765308162606800e-02 5.7713310638681370e-01 2.1213885302251677e-03
     	 	 2.2370071123214874e-02 6.6187523692480743e-01 2.0842550603106802e-03
     	 	 2.2332092501342604e-02 7.4167872752424990e-01 1.9082714922043535e-03
     	 	 2.2203649208786591e-02 8.1320388794112064e-01 1.6592668330887919e-03
     	 	 2.2944412102994027e-02 8.7325063036361028e-01 1.4090700697412901e-03
     	 	 2.3125528950686425e-02 9.2064599391698376e-01 1.0515009732793611e-03
     	 	 2.4220136263629399e-02 9.5295161184631894e-01 7.1053983679700782e-04
     	 	 2.4019288078413914e-02 9.7165520741662215e-01 2.9865376969630942e-04
     	 	 4.9156864302702941e-03 4.6967718189812402e-03 1.5122825250012305e-04
     	 	 4.1569039261933893e-03 2.4475593959158527e-02 2.9328250328972350e-04
     	 	 4.6432495826985720e-03 5.8929592884165258e-02 4.9010536059915721e-04
     	 	 4.3507344055333519e-03 1.0671365857317157e-01 6.0435471810802452e-04
     	 	 4.4982556515597016e-03 1.6649799597919454e-01 7.5076398659900854e-04
     	 	 4.1722261655702253e-03 2.3693263728638486e-01 8.0670638233864395e-04
     	 	 4.0670710478939442e-03 3.1639051559851689e-01 8.6474207823982949e-04
     	 	 3.9702574131277313e-03 4.0234393975066446e-01 8.9743499063163880e-04
     	 	 4.1794557217630368e-03 4.9109539476000935e-01 9.5295550802373778e-04
     	 	 4.1445849761612141e-03 5.7952658654582179e-01 9.2926950171050911e-04
     	 	 4.2718963060068837e-03 6.6516197258052034e-01 9.1405864519730556e-04
     	 	 4.2760899752373183e-03 7.4572227189361706e-01 8.4599312348314056e-04
     	 	 4.2359895673654835e-03 8.1889807690620586e-01 7.4550924979347117e-04
     	 	 4.3556407888316606e-03 8.8215409554992708e-01 6.4275998186479912e-04
     	 	 4.4213578877581039e-03 9.3309159643332895e-01 4.9985554113249006e-04
     	 	 4.5948789550217528e-03 9.6961983970415144e-01 3.4111851634144368e-04
     	 	 4.6084808054778215e-03 9.9045304818280444e-01 1.4917682724485874e-04
     	 	 ];


    case 34

        % SET: OTHER RULES
        % CARDINALITY RULE  :    214
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 1.860e-15

        XYW=[
    	 	 3.3333333333333331e-01 3.3333333333333331e-01 6.0504824650855589e-03
     	 	 4.5982595154127150e-02 4.5982595154127150e-02 1.1494832844045535e-03
     	 	 4.5982595154127150e-02 9.0803480969174566e-01 1.1494832844045535e-03
     	 	 9.0803480969174566e-01 4.5982595154127150e-02 1.1494832844045535e-03
     	 	 2.0838747514968406e-02 2.0838747514968406e-02 5.4984028323159856e-04
     	 	 2.0838747514968406e-02 9.5832250497006322e-01 5.4984028323159856e-04
     	 	 9.5832250497006322e-01 2.0838747514968406e-02 5.4984028323159856e-04
     	 	 7.5762174186790779e-02 7.5762174186790779e-02 1.9986867268246711e-03
     	 	 7.5762174186790779e-02 8.4847565162641847e-01 1.9986867268246711e-03
     	 	 8.4847565162641847e-01 7.5762174186790779e-02 1.9986867268246711e-03
     	 	 3.7660198051754568e-01 3.7660198051754568e-01 5.8700032956287883e-03
     	 	 3.7660198051754568e-01 2.4679603896490865e-01 5.8700032956287883e-03
     	 	 2.4679603896490865e-01 3.7660198051754568e-01 5.8700032956287883e-03
     	 	 2.8735583982216489e-01 2.8735583982216489e-01 5.8806038197068118e-03
     	 	 2.8735583982216489e-01 4.2528832035567021e-01 5.8806038197068118e-03
     	 	 4.2528832035567021e-01 2.8735583982216489e-01 5.8806038197068118e-03
     	 	 4.7441249890284559e-01 4.7441249890284559e-01 3.2421126069192589e-03
     	 	 4.7441249890284559e-01 5.1175002194308816e-02 3.2421126069192589e-03
     	 	 5.1175002194308816e-02 4.7441249890284559e-01 3.2421126069192589e-03
     	 	 1.1117270128584561e-01 1.1117270128584561e-01 2.9167168397771113e-03
     	 	 1.1117270128584561e-01 7.7765459742830878e-01 2.9167168397771113e-03
     	 	 7.7765459742830878e-01 1.1117270128584561e-01 2.9167168397771113e-03
     	 	 4.9186496195768969e-01 4.9186496195768969e-01 1.8646854717090859e-03
     	 	 4.9186496195768969e-01 1.6270076084620611e-02 1.8646854717090859e-03
     	 	 1.6270076084620611e-02 4.9186496195768969e-01 1.8646854717090859e-03
     	 	 1.5088772276287291e-01 1.5088772276287291e-01 3.8436553429818396e-03
     	 	 1.5088772276287291e-01 6.9822455447425424e-01 3.8436553429818396e-03
     	 	 6.9822455447425424e-01 1.5088772276287291e-01 3.8436553429818396e-03
     	 	 4.1579573923189251e-03 4.1579573923189251e-03 1.1348067838547165e-04
     	 	 4.1579573923189251e-03 9.9168408521536211e-01 1.1348067838547165e-04
     	 	 9.9168408521536211e-01 4.1579573923189251e-03 1.1348067838547165e-04
     	 	 2.4043491041381676e-01 2.4043491041381676e-01 5.4068496581348114e-03
     	 	 2.4043491041381676e-01 5.1913017917236648e-01 5.4068496581348114e-03
     	 	 5.1913017917236648e-01 2.4043491041381676e-01 5.4068496581348114e-03
     	 	 4.1551159674483717e-01 4.1551159674483717e-01 5.3237224212444650e-03
     	 	 4.1551159674483717e-01 1.6897680651032565e-01 5.3237224212444650e-03
     	 	 1.6897680651032565e-01 4.1551159674483717e-01 5.3237224212444650e-03
     	 	 4.9954218266151179e-01 4.9954218266151179e-01 3.8046308310905040e-04
     	 	 4.9954218266151179e-01 9.1563467697641787e-04 3.8046308310905040e-04
     	 	 9.1563467697641787e-04 4.9954218266151179e-01 3.8046308310905040e-04
     	 	 4.4856426587870823e-01 4.4856426587870823e-01 4.4304696500765180e-03
     	 	 4.4856426587870823e-01 1.0287146824258353e-01 4.4304696500765180e-03
     	 	 1.0287146824258353e-01 4.4856426587870823e-01 4.4304696500765180e-03
     	 	 1.9438654357896612e-01 1.9438654357896612e-01 4.7000705185991764e-03
     	 	 1.9438654357896612e-01 6.1122691284206776e-01 4.7000705185991764e-03
     	 	 6.1122691284206776e-01 1.9438654357896612e-01 4.7000705185991764e-03
     	 	 3.8512625183828098e-01 2.1096760270101936e-02 5.0842986183565649e-05
     	 	 3.8512625183828098e-01 5.9377698789161704e-01 5.0842986183565649e-05
     	 	 2.1096760270101936e-02 3.8512625183828098e-01 5.0842986183565649e-05
     	 	 2.1096760270101936e-02 5.9377698789161704e-01 5.0842986183565649e-05
     	 	 5.9377698789161704e-01 3.8512625183828098e-01 5.0842986183565649e-05
     	 	 5.9377698789161704e-01 2.1096760270101936e-02 5.0842986183565649e-05
     	 	 5.2820067345498760e-02 3.3881121503900485e-03 3.2702398329375329e-04
     	 	 5.2820067345498760e-02 9.4379182050411126e-01 3.2702398329375329e-04
     	 	 3.3881121503900485e-03 5.2820067345498760e-02 3.2702398329375329e-04
     	 	 3.3881121503900485e-03 9.4379182050411126e-01 3.2702398329375329e-04
     	 	 9.4379182050411126e-01 5.2820067345498760e-02 3.2702398329375329e-04
     	 	 9.4379182050411126e-01 3.3881121503900485e-03 3.2702398329375329e-04
     	 	 5.0898765283131607e-02 1.8208328799472390e-02 7.5990582913081875e-04
     	 	 5.0898765283131607e-02 9.3089290591739593e-01 7.5990582913081875e-04
     	 	 1.8208328799472390e-02 5.0898765283131607e-02 7.5990582913081875e-04
     	 	 1.8208328799472390e-02 9.3089290591739593e-01 7.5990582913081875e-04
     	 	 9.3089290591739593e-01 5.0898765283131607e-02 7.5990582913081875e-04
     	 	 9.3089290591739593e-01 1.8208328799472390e-02 7.5990582913081875e-04
     	 	 1.2912437207260852e-01 6.0510770643312256e-02 2.3348188419729603e-03
     	 	 1.2912437207260852e-01 8.1036485728407925e-01 2.3348188419729603e-03
     	 	 6.0510770643312256e-02 1.2912437207260852e-01 2.3348188419729603e-03
     	 	 6.0510770643312256e-02 8.1036485728407925e-01 2.3348188419729603e-03
     	 	 8.1036485728407925e-01 1.2912437207260852e-01 2.3348188419729603e-03
     	 	 8.1036485728407925e-01 6.0510770643312256e-02 2.3348188419729603e-03
     	 	 8.7817902777524479e-02 3.5919891363577788e-02 1.4760578152810885e-03
     	 	 8.7817902777524479e-02 8.7626220585889780e-01 1.4760578152810885e-03
     	 	 3.5919891363577788e-02 8.7817902777524479e-02 1.4760578152810885e-03
     	 	 3.5919891363577788e-02 8.7626220585889780e-01 1.4760578152810885e-03
     	 	 8.7626220585889780e-01 8.7817902777524479e-02 1.4760578152810885e-03
     	 	 8.7626220585889780e-01 3.5919891363577788e-02 1.4760578152810885e-03
     	 	 2.7355373802481919e-01 1.6406102867021266e-01 4.9304651564523582e-03
     	 	 2.7355373802481919e-01 5.6238523330496815e-01 4.9304651564523582e-03
     	 	 1.6406102867021266e-01 2.7355373802481919e-01 4.9304651564523582e-03
     	 	 1.6406102867021266e-01 5.6238523330496815e-01 4.9304651564523582e-03
     	 	 5.6238523330496815e-01 2.7355373802481919e-01 4.9304651564523582e-03
     	 	 5.6238523330496815e-01 1.6406102867021266e-01 4.9304651564523582e-03
     	 	 9.4477065632374166e-02 1.0683263523588423e-02 8.6313662942084869e-04
     	 	 9.4477065632374166e-02 8.9483967084403748e-01 8.6313662942084869e-04
     	 	 1.0683263523588423e-02 9.4477065632374166e-02 8.6313662942084869e-04
     	 	 1.0683263523588423e-02 8.9483967084403748e-01 8.6313662942084869e-04
     	 	 8.9483967084403748e-01 9.4477065632374166e-02 8.6313662942084869e-04
     	 	 8.9483967084403748e-01 1.0683263523588423e-02 8.6313662942084869e-04
     	 	 4.1115223330360051e-01 3.1132680306373711e-02 2.5180912506669673e-03
     	 	 4.1115223330360051e-01 5.5771508639002576e-01 2.5180912506669673e-03
     	 	 3.1132680306373711e-02 4.1115223330360051e-01 2.5180912506669673e-03
     	 	 3.1132680306373711e-02 5.5771508639002576e-01 2.5180912506669673e-03
     	 	 5.5771508639002576e-01 4.1115223330360051e-01 2.5180912506669673e-03
     	 	 5.5771508639002576e-01 3.1132680306373711e-02 2.5180912506669673e-03
     	 	 3.5944756949825529e-01 1.3319262322170583e-01 4.8289401147233986e-03
     	 	 3.5944756949825529e-01 5.0735980728003893e-01 4.8289401147233986e-03
     	 	 1.3319262322170583e-01 3.5944756949825529e-01 4.8289401147233986e-03
     	 	 1.3319262322170583e-01 5.0735980728003893e-01 4.8289401147233986e-03
     	 	 5.0735980728003893e-01 3.5944756949825529e-01 4.8289401147233986e-03
     	 	 5.0735980728003893e-01 1.3319262322170583e-01 4.8289401147233986e-03
     	 	 3.8841008533043708e-01 7.4297319237294213e-02 3.8059575104429353e-03
     	 	 3.8841008533043708e-01 5.3729259543226870e-01 3.8059575104429353e-03
     	 	 7.4297319237294213e-02 3.8841008533043708e-01 3.8059575104429353e-03
     	 	 7.4297319237294213e-02 5.3729259543226870e-01 3.8059575104429353e-03
     	 	 5.3729259543226870e-01 3.8841008533043708e-01 3.8059575104429353e-03
     	 	 5.3729259543226870e-01 7.4297319237294213e-02 3.8059575104429353e-03
     	 	 3.2535504334205773e-01 2.0516649781476196e-01 5.5329319437995590e-03
     	 	 3.2535504334205773e-01 4.6947845884318029e-01 5.5329319437995590e-03
     	 	 2.0516649781476196e-01 3.2535504334205773e-01 5.5329319437995590e-03
     	 	 2.0516649781476196e-01 4.6947845884318029e-01 5.5329319437995590e-03
     	 	 4.6947845884318029e-01 3.2535504334205773e-01 5.5329319437995590e-03
     	 	 4.6947845884318029e-01 2.0516649781476196e-01 5.5329319437995590e-03
     	 	 1.7478047948106840e-01 9.0219606125175517e-02 3.2519198563248702e-03
     	 	 1.7478047948106840e-01 7.3499991439375612e-01 3.2519198563248702e-03
     	 	 9.0219606125175517e-02 1.7478047948106840e-01 3.2519198563248702e-03
     	 	 9.0219606125175517e-02 7.3499991439375612e-01 3.2519198563248702e-03
     	 	 7.3499991439375612e-01 1.7478047948106840e-01 3.2519198563248702e-03
     	 	 7.3499991439375612e-01 9.0219606125175517e-02 3.2519198563248702e-03
     	 	 1.9416461814956329e-01 4.3915872904511433e-02 2.4163436267425433e-03
     	 	 1.9416461814956329e-01 7.6191950894592519e-01 2.4163436267425433e-03
     	 	 4.3915872904511433e-02 1.9416461814956329e-01 2.4163436267425433e-03
     	 	 4.3915872904511433e-02 7.6191950894592519e-01 2.4163436267425433e-03
     	 	 7.6191950894592519e-01 1.9416461814956329e-01 2.4163436267425433e-03
     	 	 7.6191950894592519e-01 4.3915872904511433e-02 2.4163436267425433e-03
     	 	 2.4832787340457896e-01 6.8963829964601694e-02 3.2967572338747186e-03
     	 	 2.4832787340457896e-01 6.8270829663081933e-01 3.2967572338747186e-03
     	 	 6.8963829964601694e-02 2.4832787340457896e-01 3.2967572338747186e-03
     	 	 6.8963829964601694e-02 6.8270829663081933e-01 3.2967572338747186e-03
     	 	 6.8270829663081933e-01 2.4832787340457896e-01 3.2967572338747186e-03
     	 	 6.8270829663081933e-01 6.8963829964601694e-02 3.2967572338747186e-03
     	 	 2.2299204126120087e-01 1.2518179814288666e-01 4.1426332565503267e-03
     	 	 2.2299204126120087e-01 6.5182616059591247e-01 4.1426332565503267e-03
     	 	 1.2518179814288666e-01 2.2299204126120087e-01 4.1426332565503267e-03
     	 	 1.2518179814288666e-01 6.5182616059591247e-01 4.1426332565503267e-03
     	 	 6.5182616059591247e-01 2.2299204126120087e-01 4.1426332565503267e-03
     	 	 6.5182616059591247e-01 1.2518179814288666e-01 4.1426332565503267e-03
     	 	 1.4960442354895109e-01 4.6702985612832940e-03 6.9971469270154320e-04
     	 	 1.4960442354895109e-01 8.4572527788976559e-01 6.9971469270154320e-04
     	 	 4.6702985612832940e-03 1.4960442354895109e-01 6.9971469270154320e-04
     	 	 4.6702985612832940e-03 8.4572527788976559e-01 6.9971469270154320e-04
     	 	 8.4572527788976559e-01 1.4960442354895109e-01 6.9971469270154320e-04
     	 	 8.4572527788976559e-01 4.6702985612832940e-03 6.9971469270154320e-04
     	 	 3.2839141369212660e-01 4.8925922503864412e-02 3.0476320162441694e-03
     	 	 3.2839141369212660e-01 6.2268266380400894e-01 3.0476320162441694e-03
     	 	 4.8925922503864412e-02 3.2839141369212660e-01 3.0476320162441694e-03
     	 	 4.8925922503864412e-02 6.2268266380400894e-01 3.0476320162441694e-03
     	 	 6.2268266380400894e-01 3.2839141369212660e-01 3.0476320162441694e-03
     	 	 6.2268266380400894e-01 4.8925922503864412e-02 3.0476320162441694e-03
     	 	 1.4238550032454281e-01 2.4658249778207346e-02 1.5716030740796439e-03
     	 	 1.4238550032454281e-01 8.3295624989724992e-01 1.5716030740796439e-03
     	 	 2.4658249778207346e-02 1.4238550032454281e-01 1.5716030740796439e-03
     	 	 2.4658249778207346e-02 8.3295624989724992e-01 1.5716030740796439e-03
     	 	 8.3295624989724992e-01 1.4238550032454281e-01 1.5716030740796439e-03
     	 	 8.3295624989724992e-01 2.4658249778207346e-02 1.5716030740796439e-03
     	 	 4.2384029972036885e-01 5.9599432497442753e-03 1.1156658966766499e-03
     	 	 4.2384029972036885e-01 5.7019975702988690e-01 1.1156658966766499e-03
     	 	 5.9599432497442753e-03 4.2384029972036885e-01 1.1156658966766499e-03
     	 	 5.9599432497442753e-03 5.7019975702988690e-01 1.1156658966766499e-03
     	 	 5.7019975702988690e-01 4.2384029972036885e-01 1.1156658966766499e-03
     	 	 5.7019975702988690e-01 5.9599432497442753e-03 1.1156658966766499e-03
     	 	 2.6769041934430560e-01 2.8518722842285394e-02 2.2178654867209767e-03
     	 	 2.6769041934430560e-01 7.0379085781340900e-01 2.2178654867209767e-03
     	 	 2.8518722842285394e-02 2.6769041934430560e-01 2.2178654867209767e-03
     	 	 2.8518722842285394e-02 7.0379085781340900e-01 2.2178654867209767e-03
     	 	 7.0379085781340900e-01 2.6769041934430560e-01 2.2178654867209767e-03
     	 	 7.0379085781340900e-01 2.8518722842285394e-02 2.2178654867209767e-03
     	 	 3.4541137895290114e-01 1.5562643301015495e-02 1.7441636728719135e-03
     	 	 3.4541137895290114e-01 6.3902597774608327e-01 1.7441636728719135e-03
     	 	 1.5562643301015495e-02 3.4541137895290114e-01 1.7441636728719135e-03
     	 	 1.5562643301015495e-02 6.3902597774608327e-01 1.7441636728719135e-03
     	 	 6.3902597774608327e-01 3.4541137895290114e-01 1.7441636728719135e-03
     	 	 6.3902597774608327e-01 1.5562643301015495e-02 1.7441636728719135e-03
     	 	 3.5344951965766375e-01 9.2571823393383483e-04 3.6592293683505557e-04
     	 	 3.5344951965766375e-01 6.4562476210840247e-01 3.6592293683505557e-04
     	 	 9.2571823393383483e-04 3.5344951965766375e-01 3.6592293683505557e-04
     	 	 9.2571823393383483e-04 6.4562476210840247e-01 3.6592293683505557e-04
     	 	 6.4562476210840247e-01 3.5344951965766375e-01 3.6592293683505557e-04
     	 	 6.4562476210840247e-01 9.2571823393383483e-04 3.6592293683505557e-04
     	 	 3.0333563947178915e-01 9.9286211618585432e-02 4.1253987153764731e-03
     	 	 3.0333563947178915e-01 5.9737814890962537e-01 4.1253987153764731e-03
     	 	 9.9286211618585432e-02 3.0333563947178915e-01 4.1253987153764731e-03
     	 	 9.9286211618585432e-02 5.9737814890962537e-01 4.1253987153764731e-03
     	 	 5.9737814890962537e-01 3.0333563947178915e-01 4.1253987153764731e-03
     	 	 5.9737814890962537e-01 9.9286211618585432e-02 4.1253987153764731e-03
     	 	 2.1755560320183935e-02 3.9745058725184773e-03 2.4898378659855884e-04
     	 	 2.1755560320183935e-02 9.7426993380729765e-01 2.4898378659855884e-04
     	 	 3.9745058725184773e-03 2.1755560320183935e-02 2.4898378659855884e-04
     	 	 3.9745058725184773e-03 9.7426993380729765e-01 2.4898378659855884e-04
     	 	 9.7426993380729765e-01 2.1755560320183935e-02 2.4898378659855884e-04
     	 	 9.7426993380729765e-01 3.9745058725184773e-03 2.4898378659855884e-04
     	 	 2.0754686827352045e-01 1.3779639405368808e-02 1.4029090686568627e-03
     	 	 2.0754686827352045e-01 7.7867349232111072e-01 1.4029090686568627e-03
     	 	 1.3779639405368808e-02 2.0754686827352045e-01 1.4029090686568627e-03
     	 	 1.3779639405368808e-02 7.7867349232111072e-01 1.4029090686568627e-03
     	 	 7.7867349232111072e-01 2.0754686827352045e-01 1.4029090686568627e-03
     	 	 7.7867349232111072e-01 1.3779639405368808e-02 1.4029090686568627e-03
     	 	 2.1356023951794784e-01 7.7213912032704350e-04 2.8882528711737912e-04
     	 	 2.1356023951794784e-01 7.8566762136172508e-01 2.8882528711737912e-04
     	 	 7.7213912032704350e-04 2.1356023951794784e-01 2.8882528711737912e-04
     	 	 7.7213912032704350e-04 7.8566762136172508e-01 2.8882528711737912e-04
     	 	 7.8566762136172508e-01 2.1356023951794784e-01 2.8882528711737912e-04
     	 	 7.8566762136172508e-01 7.7213912032704350e-04 2.8882528711737912e-04
     	 	 2.7938643178222372e-01 5.4617908942934485e-03 9.8131440274166798e-04
     	 	 2.7938643178222372e-01 7.1515177732348290e-01 9.8131440274166798e-04
     	 	 5.4617908942934485e-03 2.7938643178222372e-01 9.8131440274166798e-04
     	 	 5.4617908942934485e-03 7.1515177732348290e-01 9.8131440274166798e-04
     	 	 7.1515177732348290e-01 2.7938643178222372e-01 9.8131440274166798e-04
     	 	 7.1515177732348290e-01 5.4617908942934485e-03 9.8131440274166798e-04
     	 	 9.6866922575547174e-02 4.7096910185453920e-06 1.4367267730406699e-04
     	 	 9.6866922575547174e-02 9.0312836773343430e-01 1.4367267730406699e-04
     	 	 4.7096910185453920e-06 9.6866922575547174e-02 1.4367267730406699e-04
     	 	 4.7096910185453920e-06 9.0312836773343430e-01 1.4367267730406699e-04
     	 	 9.0312836773343430e-01 9.6866922575547174e-02 1.4367267730406699e-04
     	 	 9.0312836773343430e-01 4.7096910185453920e-06 1.4367267730406699e-04
     	 	 ];


    case 35

        % SET: SLOBODKINS TAUSCH
        % CARDINALITY RULE  :    224
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 7.563e-16

        XYW=[
    	 	 9.9139050446827770e-01 4.3794281105275796e-03 1.2160923119980710e-04
     	 	 9.7298428132881465e-01 2.2886184485964672e-02 2.7177475129841548e-04
     	 	 9.7377045679492769e-01 4.0568104909285271e-03 2.6008871906384184e-04
     	 	 9.5694367850258566e-01 2.1408441513933636e-02 5.9105873742371117e-04
     	 	 9.2689999884890717e-01 5.2664486826770968e-02 8.8023648501630832e-04
     	 	 9.4284436916053860e-01 3.1012894022538961e-03 3.0951737237104349e-04
     	 	 9.3030603732774342e-01 1.6843971099575583e-02 7.3853904480948476e-04
     	 	 9.0621199863970114e-01 4.3105608560367478e-02 1.1905873395758816e-03
     	 	 9.4069190981799611e-01 5.5439096046011507e-02 3.8901108253438279e-04
     	 	 8.9710748395848949e-01 4.0588423868984100e-03 5.3083632477753887e-04
     	 	 8.8338130288882077e-01 2.1221844940811370e-02 1.1535131485193896e-03
     	 	 8.5647557545993591e-01 5.1109443213912066e-02 1.7285492380384947e-03
     	 	 8.2136088026629439e-01 9.2084505995599281e-02 2.0010720870373947e-03
     	 	 8.6955195895237769e-01 8.2141805621160940e-02 1.5544663190521781e-03
     	 	 8.8304974018664928e-01 9.7226643929641990e-02 1.1228781225393648e-03
     	 	 8.9547498271605097e-01 1.0074461379114513e-01 4.9507693114707308e-04
     	 	 8.4049390990923190e-01 3.8252291258782174e-03 6.1088738547926977e-04
     	 	 8.3056521474250022e-01 2.0156832140334383e-02 1.3383280426957154e-03
     	 	 8.0404601187741320e-01 4.9392929678139380e-02 2.1155539784185229e-03
     	 	 7.7310006297580913e-01 9.1494215685477540e-02 2.5789368665593698e-03
     	 	 7.7337470301783418e-01 1.4218463569705633e-01 2.3851639468499362e-03
     	 	 8.1978190828602937e-01 1.3395887054880973e-01 1.8847720260259616e-03
     	 	 8.2721326584516786e-01 1.5392724404386068e-01 1.3178728977903287e-03
     	 	 8.3909762767915896e-01 1.5731954845427853e-01 5.6712661531832889e-04
     	 	 7.7349358336762408e-01 3.8485858630140711e-03 7.0333465910700911e-04
     	 	 7.6750163656792947e-01 2.0087698760528371e-02 1.5199932898937345e-03
     	 	 7.4056628470800800e-01 4.8496613054929888e-02 2.3368185241799820e-03
     	 	 7.1760516528035789e-01 8.8126420190042173e-02 2.8115236621083215e-03
     	 	 6.7462669106239292e-01 1.3696421694634750e-01 3.0787613683963665e-03
     	 	 7.2223320007191605e-01 1.4517389019168184e-01 3.0866463002801382e-03
     	 	 7.1301547996958181e-01 2.0183492350056467e-01 2.8273829865044643e-03
     	 	 7.5780441086712824e-01 1.9585974238537043e-01 2.2002361844749058e-03
     	 	 7.6087683195111300e-01 2.1992479736899279e-01 1.5087803155494487e-03
     	 	 7.7267246990031657e-01 2.2365685167930180e-01 6.6533090960744850e-04
     	 	 6.9854851237810789e-01 3.7684227809914109e-03 7.5537594498052544e-04
     	 	 6.9607142502396857e-01 1.9810431317123442e-02 1.6830009339895082e-03
     	 	 6.6930277330688281e-01 4.8191826141118603e-02 2.5491361717166513e-03
     	 	 6.5038615860434845e-01 8.8070105937295057e-02 3.2141345838825066e-03
     	 	 6.1367150805892945e-01 1.3791774290599149e-01 3.3255388447993779e-03
     	 	 6.1668725361964416e-01 1.9273548737671112e-01 3.5470908399313529e-03
     	 	 6.5741105476949624e-01 2.0839373450036014e-01 3.5918431929236778e-03
     	 	 6.4323816766615360e-01 2.6977771834737735e-01 3.1716248066765607e-03
     	 	 6.8613865895770176e-01 2.6626511779490486e-01 2.5110948176881053e-03
     	 	 6.8743067422576409e-01 2.9285373679077992e-01 1.6833823362218058e-03
     	 	 6.9813345205126565e-01 2.9809898939318613e-01 7.5088226070443842e-04
     	 	 6.1815626350812414e-01 3.7642885886192204e-03 7.9216596911564261e-04
     	 	 6.1776349353953530e-01 1.9672282200746162e-02 1.7932987385133560e-03
     	 	 5.9345099274873703e-01 4.7753743492983058e-02 2.6336448787546230e-03
     	 	 5.7633361094487134e-01 8.7396203548873591e-02 3.4751842404334692e-03
     	 	 5.5115511556162677e-01 1.3736818315900212e-01 3.5536128748982353e-03
     	 	 5.4893648061628819e-01 1.9617791783551564e-01 4.1797432554281496e-03
     	 	 5.5195226837655031e-01 2.5372394828500816e-01 3.9690283055744836e-03
     	 	 5.8415594655542447e-01 2.7912265111330953e-01 4.0116130160602380e-03
     	 	 5.6970612763957462e-01 3.4309852187547529e-01 3.3622297290042801e-03
     	 	 6.0857686959797008e-01 3.4360298284063401e-01 2.7141132791391985e-03
     	 	 6.0910603763529703e-01 3.7130907166554977e-01 1.7757588869496753e-03
     	 	 6.1789486421353246e-01 3.7836646649841077e-01 7.8863513553342475e-04
     	 	 5.3505926985419516e-01 3.7557689482656119e-03 8.0602060139330501e-04
     	 	 5.3470310767191598e-01 1.9735383851752001e-02 1.8790722352114058e-03
     	 	 5.1513597065353223e-01 4.8133778483311802e-02 2.6907365409318883e-03
     	 	 4.9733361788829966e-01 8.7902624373125460e-02 3.6098368027461789e-03
     	 	 4.8322361497647759e-01 1.3808214118660644e-01 3.8615715483116203e-03
     	 	 4.7951435810831688e-01 1.9677421524981770e-01 4.4763173283435187e-03
     	 	 4.7701032888229644e-01 2.6318020044711599e-01 4.8710441170299740e-03
     	 	 4.8421148997384067e-01 3.2135322024240898e-01 4.3499718222013714e-03
     	 	 5.0808440978307345e-01 3.5585381845590081e-01 4.2137564362274265e-03
     	 	 4.9412164593428209e-01 4.2047538615010122e-01 3.4513795176681376e-03
     	 	 5.2803615159337480e-01 4.2516826545897923e-01 2.7409527021157198e-03
     	 	 5.2745837580191668e-01 4.5336513315567034e-01 1.7863547380745945e-03
     	 	 5.3436727858539035e-01 4.6197586274459834e-01 7.9170856287889867e-04
     	 	 4.5152289181203875e-01 3.7072332605283713e-03 7.8824143905648211e-04
     	 	 4.5019937090104956e-01 1.9341273907054691e-02 1.8289532150068855e-03
     	 	 4.3755661226321974e-01 4.6627542912934479e-02 2.5738654355227410e-03
     	 	 4.1807541386916036e-01 8.4925755844841286e-02 3.4973865278829452e-03
     	 	 4.1119894137998825e-01 1.3389069263558312e-01 3.9989772809554749e-03
     	 	 4.0657063171760133e-01 1.9209342920658137e-01 4.5470369140873075e-03
     	 	 4.0736079635327727e-01 2.5434718857349364e-01 4.3763580201482688e-03
     	 	 3.9674900116637291e-01 3.0579580165100501e-01 2.6693408797359430e-03
     	 	 4.0623261161804380e-01 3.4506097076775977e-01 4.3243494479163697e-03
     	 	 4.1444703414316475e-01 3.9760312953095289e-01 4.2379761920869011e-03
     	 	 4.3163744141618265e-01 4.3589291777380806e-01 4.0561087574669677e-03
     	 	 4.1436772994100213e-01 5.0039408406838570e-01 3.4499860071492768e-03
     	 	 4.4548223079034366e-01 5.0765236195925001e-01 2.7409214195028286e-03
     	 	 4.4491653855762481e-01 5.3566428297915147e-01 1.7814657553883440e-03
     	 	 4.4976879540271497e-01 5.4651176826222581e-01 8.0293417404931234e-04
     	 	 3.6960719260742514e-01 3.5123830000821699e-03 7.2808139700225583e-04
     	 	 3.6703109831873260e-01 1.8681376042563425e-02 1.7431793551788194e-03
     	 	 3.5950594116444823e-01 4.6230585218402259e-02 2.6191207322685856e-03
     	 	 3.3952388863462946e-01 8.5936939670875359e-02 3.4496103284763113e-03
     	 	 3.3679272013915584e-01 1.3585925224910989e-01 4.0334948119860933e-03
     	 	 3.3322722763086132e-01 1.9480405350311039e-01 4.5613827675810405e-03
     	 	 3.3413313641499409e-01 2.6156768309669909e-01 5.1041099835448670e-03
     	 	 3.2860877416508361e-01 3.3598370122178794e-01 5.1542027960435385e-03
     	 	 3.3050292578498597e-01 4.0678630871283900e-01 5.0450323489598034e-03
     	 	 3.4269418022462217e-01 4.6039011698025695e-01 4.3406781673538458e-03
     	 	 3.5205925955853601e-01 5.1105913876853659e-01 4.3400242303897468e-03
     	 	 3.3683800279052700e-01 5.7589335652710116e-01 3.4269353799384465e-03
     	 	 3.6284641543634388e-01 5.9022345227387141e-01 2.7624970984136952e-03
     	 	 3.6437931069326124e-01 6.1655065222869687e-01 1.7106796974172961e-03
     	 	 3.6658527751397041e-01 6.2979728358006215e-01 7.5856738980541248e-04
     	 	 2.9098979481298592e-01 3.9293664952109921e-03 7.6467964439459757e-04
     	 	 2.8763804514093316e-01 2.0311507214374608e-02 1.7126397686499483e-03
     	 	 2.8285068857745799e-01 4.8368661039911783e-02 2.4724992593966448e-03
     	 	 2.6539557784015677e-01 8.6453645522985706e-02 2.9939050275343869e-03
     	 	 2.6436057780655708e-01 1.3371233994019302e-01 3.6918913801023269e-03
     	 	 2.6276482569015358e-01 1.9038530774193943e-01 4.1869894422233720e-03
     	 	 2.6306288205737260e-01 2.5578249733810809e-01 4.7565996797601703e-03
     	 	 2.6230354515104326e-01 3.2747756004904433e-01 4.9943551150497152e-03
     	 	 2.6152039388784876e-01 4.0824679514489104e-01 4.7302433739207948e-03
     	 	 2.5890076232062686e-01 4.8056598745746060e-01 4.7297311744307607e-03
     	 	 2.7588999181221230e-01 5.2881800173581495e-01 4.0809369361730291e-03
     	 	 2.7450967046976193e-01 5.8723845654095230e-01 4.0324983639179520e-03
     	 	 2.6386151843720373e-01 6.4669812795253678e-01 3.0652906134802718e-03
     	 	 2.8342411503344944e-01 6.6716213791373324e-01 2.6296151093680347e-03
     	 	 2.8742819975327327e-01 6.9195828272893378e-01 1.7097692539466659e-03
     	 	 2.8724855806997851e-01 7.0878807279527345e-01 7.7608009382375233e-04
     	 	 2.1798346809308278e-01 3.5911558564220309e-03 6.4324929348852345e-04
     	 	 2.1532127535122247e-01 1.9113981929844665e-02 1.5034186632112445e-03
     	 	 2.1141656086239569e-01 4.7416187776216145e-02 2.3642353247013167e-03
     	 	 1.9920354821152852e-01 8.8240145332762893e-02 2.8967062238277985e-03
     	 	 1.9602812209176512e-01 1.3903195921393594e-01 3.5048875169868075e-03
     	 	 1.9727362246562108e-01 1.9498315728263635e-01 3.5980296853626820e-03
     	 	 1.9719878596639728e-01 2.5447685675887216e-01 3.8781290160236426e-03
     	 	 1.9686766503235376e-01 3.2024574037905440e-01 4.3476266570047356e-03
     	 	 1.8959955662143790e-01 3.9103027443252464e-01 3.7598478394278208e-03
     	 	 2.2562058661355411e-01 3.9375129904490253e-01 1.6374956833162904e-03
     	 	 1.9729660678340621e-01 4.7988127833220140e-01 3.2481106595210331e-03
     	 	 1.9184420232254551e-01 5.4380494440098359e-01 3.8939943552081854e-03
     	 	 2.0928810537331255e-01 5.9040852420176260e-01 4.0444016546446306e-03
     	 	 2.0263485574190576e-01 6.5566698435043014e-01 3.7656856507175163e-03
     	 	 1.9967037209567295e-01 7.1013740286756488e-01 2.8398829130329719e-03
     	 	 2.1080260360967373e-01 7.4013969207812680e-01 2.4242832126355317e-03
     	 	 2.1594039820708932e-01 7.6405171709437814e-01 1.5493312883792174e-03
     	 	 2.1423134303240965e-01 7.8197966868357738e-01 6.7261442037874731e-04
     	 	 1.5257636156720744e-01 4.1275225402738211e-03 6.4156917656655287e-04
     	 	 1.5071423714960741e-01 2.1516689019316547e-02 1.4348756413168264e-03
     	 	 1.4685500231757220e-01 5.1790664709663752e-02 2.1492751841659771e-03
     	 	 1.3990853827199634e-01 9.4126371265209993e-02 2.5758958490110766e-03
     	 	 1.3579949842268102e-01 1.4642481886316303e-01 3.1813536181251436e-03
     	 	 1.3842042436613833e-01 2.0869677094244943e-01 3.7174809028174224e-03
     	 	 1.3868745560017959e-01 2.8031173918272251e-01 4.0624523346715000e-03
     	 	 1.3649556083150927e-01 3.5695954928746393e-01 4.2696428070347677e-03
     	 	 1.3396020600408209e-01 4.3735614117480487e-01 4.1395548047640255e-03
     	 	 1.8269022121114953e-01 4.5609829038903027e-01 2.1991519656680688e-03
     	 	 1.3305400899086561e-01 5.1819368296571577e-01 4.1533570866623334e-03
     	 	 1.3602006997882909e-01 5.8943710819204131e-01 3.7817838079320294e-03
     	 	 1.4606651648051427e-01 6.5082897616234003e-01 3.9100111543172835e-03
     	 	 1.4027746836449895e-01 7.1866842964558630e-01 3.2728595701217106e-03
     	 	 1.4218014335302076e-01 7.6862890732260436e-01 2.5066602835794238e-03
     	 	 1.4671791555617963e-01 8.0448414507778709e-01 2.0517910322323256e-03
     	 	 1.5163399723864734e-01 8.2824251264645743e-01 1.3546980913624212e-03
     	 	 1.4968476289239141e-01 8.4645197906674585e-01 5.9013091431734895e-04
     	 	 9.7104976405315235e-02 3.7393465232391518e-03 4.8011353394871879e-04
     	 	 9.6273969859805630e-02 1.9739576509044076e-02 1.1050374469687191e-03
     	 	 9.3317391112942905e-02 4.8429226711711203e-02 1.6870560171343655e-03
     	 	 9.0690909818038401e-02 8.8851563210867832e-02 2.0926542586503106e-03
     	 	 8.5605118393968338e-02 1.3995810738903780e-01 2.5110012689356243e-03
     	 	 8.7349404289421506e-02 1.9988770848111212e-01 2.8868738480831756e-03
     	 	 8.9147046962401166e-02 2.6639517299525806e-01 3.1635879282769733e-03
     	 	 8.7129775078224059e-02 3.3974664357217421e-01 3.4139112593850802e-03
     	 	 8.6235820552779230e-02 4.1749334034556601e-01 3.4922847582886068e-03
     	 	 8.6022297987956908e-02 4.9679726392185009e-01 3.4084596862641917e-03
     	 	 8.3401014428017284e-02 5.7575326464156129e-01 3.3569997525424340e-03
     	 	 8.9320323892431386e-02 6.4313231179480668e-01 3.0158051251293508e-03
     	 	 9.2723599288931480e-02 7.0507959283519317e-01 3.0154632773906885e-03
     	 	 8.8438380401519301e-02 7.6833518100658138e-01 2.5529792022173699e-03
     	 	 9.1592338958079167e-02 8.1653203791665763e-01 2.1682245148484315e-03
     	 	 9.2857093189016471e-02 8.5684969377178222e-01 1.7238433409820530e-03
     	 	 9.6492852577759636e-02 8.8289789137290065e-01 1.1582647933083656e-03
     	 	 9.5305240950110837e-02 9.0077048680153993e-01 4.9210993801824827e-04
     	 	 5.3106259200343175e-02 3.9560791686824599e-03 3.8267296479316124e-04
     	 	 5.2709371864883114e-02 2.0627331169845612e-02 8.6619586056642503e-04
     	 	 5.0744221019909608e-02 4.9986589313674619e-02 1.2870277594497555e-03
     	 	 4.9977988099326520e-02 9.1323345811896120e-02 1.6644718770348259e-03
     	 	 4.6302725638311726e-02 1.4449112806467077e-01 1.9455083993025863e-03
     	 	 4.7708250739746605e-02 2.0703056394135133e-01 2.2867608818891152e-03
     	 	 4.8971808529383098e-02 2.7796972337580006e-01 2.5938387401238253e-03
     	 	 4.7442198230284949e-02 3.5585739956847701e-01 2.6983082963802935e-03
     	 	 4.7173402285564325e-02 4.3667173379694241e-01 2.7397001314555529e-03
     	 	 4.7610171327887807e-02 5.1797707677190885e-01 2.7080337422359523e-03
     	 	 4.4602416124167377e-02 5.9997583300406232e-01 2.6000000484687237e-03
     	 	 4.9495462535815049e-02 6.7374845370060987e-01 2.5832796109047738e-03
     	 	 5.0313675004709735e-02 7.4376147809683824e-01 2.4099347922351762e-03
     	 	 4.8322322438033583e-02 8.0790871309560608e-01 1.9801984424229454e-03
     	 	 5.0377415513416235e-02 8.5829589226432867e-01 1.6779326431585057e-03
     	 	 5.0770503036760894e-02 8.9907372594552981e-01 1.2753579498855667e-03
     	 	 5.2647779441576392e-02 9.2657770766264835e-01 8.7539730386127694e-04
     	 	 5.2263892809380375e-02 9.4374729751665010e-01 3.7790873992683610e-04
     	 	 2.1849540320217020e-02 4.0280902844352859e-03 2.5407508880564506e-04
     	 	 2.1669900152670452e-02 2.1210990286329830e-02 5.8603466224807282e-04
     	 	 2.0794224760030122e-02 5.1991459755178583e-02 8.7607062092068331e-04
     	 	 2.0591135057222654e-02 9.5583250250860050e-02 1.1480582147727827e-03
     	 	 1.8807133431186562e-02 1.5111746100433909e-01 1.2913503423582877e-03
     	 	 1.9675226666627355e-02 2.1561930593662595e-01 1.5191746194021800e-03
     	 	 2.0181902915774153e-02 2.8773029083897589e-01 1.7124989415069575e-03
     	 	 1.9461802319345023e-02 3.6601249624466664e-01 1.7608605876867126e-03
     	 	 1.9365263375052844e-02 4.4791519350344366e-01 1.8148927328784353e-03
     	 	 1.9783963780413028e-02 5.3119900421190613e-01 1.8420474351410333e-03
     	 	 1.7900390410312772e-02 6.1465874351063010e-01 1.6715049037822735e-03
     	 	 2.0436229342576606e-02 6.9228736564821969e-01 1.7552432897699716e-03
     	 	 2.0635837050489547e-02 7.6526507937509713e-01 1.6130766112264592e-03
     	 	 1.9916633751954294e-02 8.3078513557494882e-01 1.3515360984088672e-03
     	 	 2.0669172519725998e-02 8.8527188945480717e-01 1.1527107005586559e-03
     	 	 2.0949407916927454e-02 9.2823054964507978e-01 8.6612278009555758e-04
     	 	 2.1554953971677282e-02 9.5782848732908388e-01 5.7158098935475342e-04
     	 	 2.1576957040839839e-02 9.7452698535859272e-01 2.4228812968739706e-04
     	 	 4.1733927965154072e-03 4.3098834488196078e-03 1.1803635234559634e-04
     	 	 4.1306592932691677e-03 2.2515617498648000e-02 2.6751876131306203e-04
     	 	 3.9574590163764523e-03 5.4546690818961012e-02 3.9142317233399588e-04
     	 	 3.9354189139358953e-03 9.9225206956505788e-02 5.0968747564686119e-04
     	 	 3.5519156878099922e-03 1.5527523609454996e-01 5.5781376855466500e-04
     	 	 3.7704969382666986e-03 2.2089189560219291e-01 6.7533632567258505e-04
     	 	 3.8518155207628579e-03 2.9443696353546894e-01 7.5843675845120942e-04
     	 	 3.7110632483626782e-03 3.7376916502569790e-01 7.7328267485913572e-04
     	 	 3.6888529310418194e-03 4.5624347331028881e-01 7.8737109043980499e-04
     	 	 3.8075784721476325e-03 5.3942652889146325e-01 8.0735288230904462e-04
     	 	 3.3409990732443662e-03 6.2154557751412021e-01 6.9413813176346696e-04
     	 	 3.8993147005667028e-03 6.9986040199169630e-01 7.6167827803989027e-04
     	 	 3.9433531872243854e-03 7.7297211607588434e-01 7.0446019279196670e-04
     	 	 3.8070120330251367e-03 8.3874179920923164e-01 5.9886306511706012e-04
     	 	 3.9268958012633748e-03 8.9513707731648851e-01 5.1571826022091629e-04
     	 	 4.0015125590789902e-03 9.4042291599876604e-01 4.0216449840272653e-04
     	 	 4.0940164512197619e-03 9.7294839071461714e-01 2.7044885749110222e-04
     	 	 4.1318741081761701e-03 9.9147145624988897e-01 1.1912721245417188e-04
     	 	 ];


    case 36

        % SET: SLOBODKINS TAUSCH
        % CARDINALITY RULE  :    237
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 1.032e-15

        XYW=[
    	 	 9.7660351585373084e-01 3.5685708895224237e-03 2.0547800484385515e-04
     	 	 9.9231795633082731e-01 3.9280451666010713e-03 9.7158951951969937e-05
     	 	 9.4781981846581265e-01 3.6456097345215284e-03 3.2561392048406759e-04
     	 	 9.6277168774627808e-01 1.8699062462728872e-02 4.3792189900174146e-04
     	 	 9.7577351394552114e-01 2.0685555710593492e-02 2.1191602451766346e-04
     	 	 9.0696658606091640e-01 3.8323755636022602e-03 4.5563443879880736e-04
     	 	 9.3582949776131419e-01 1.9072787341292446e-02 6.9518867790029722e-04
     	 	 9.0627624743438340e-01 4.6847607985699154e-02 1.1258993699803782e-03
     	 	 9.3533546007652912e-01 4.5383832856168843e-02 7.0091436849931338e-04
     	 	 9.4588966197954494e-01 5.0398023599972079e-02 3.4183507281101348e-04
     	 	 8.1814740583967460e-01 4.8185666761632232e-02 1.7789332212296610e-03
     	 	 8.9718676404787800e-01 2.0005191844804301e-02 9.7250729978433435e-04
     	 	 8.6564055223758152e-01 4.8696843471550746e-02 1.5162744312323386e-03
     	 	 8.6549518099035150e-01 8.6311279703093505e-02 1.5427757249108912e-03
     	 	 8.9681176496864989e-01 8.3435920260573129e-02 9.7463563911410762e-04
     	 	 9.0393523068905823e-01 9.2316047428290152e-02 4.5910876684702654e-04
     	 	 8.5521412514934014e-01 3.7785746992413465e-03 5.5181515769436341e-04
     	 	 8.4877019027230904e-01 1.9885743154287296e-02 1.2008485750923475e-03
     	 	 8.2247978039864000e-01 8.9083581765160763e-02 2.1103709397571556e-03
     	 	 8.1831384656614925e-01 1.3566942726085129e-01 1.7489970983870606e-03
     	 	 8.4834452038197783e-01 1.3255923679286435e-01 1.1635783846033253e-03
     	 	 8.5085561446061930e-01 1.4550792211094649e-01 5.4267238820380559e-04
     	 	 7.9372915605520433e-01 3.6579349050210883e-03 6.1748266584242463e-04
     	 	 7.9092919586103128e-01 1.9253421312336139e-02 1.3646728709523250e-03
     	 	 7.6339983945659573e-01 4.6886241734908997e-02 2.0079899987328078e-03
     	 	 7.7242498922189295e-01 8.7539039626793547e-02 2.5471371171937596e-03
     	 	 7.7697320265927061e-01 1.4004571092611798e-01 2.3275527352382684e-03
     	 	 7.5929456419903718e-01 1.9430872790500356e-01 2.0757115010594787e-03
     	 	 7.8918153543829428e-01 1.9177158466845437e-01 1.3688904130120317e-03
     	 	 7.8833264791388036e-01 2.0800939608044944e-01 6.2162470053330919e-04
     	 	 7.2437515558235854e-01 3.6590821529525483e-03 6.7999642800196328e-04
     	 	 7.2423544194827638e-01 1.9147801951140617e-02 1.5197648573715989e-03
     	 	 7.0017330337732653e-01 4.6578500290454065e-02 2.2106504655251022e-03
     	 	 7.1276496183724236e-01 8.5664689348282419e-02 2.9185038682669356e-03
     	 	 6.8101322610406179e-01 1.3538551567229118e-01 3.1561702729951580e-03
     	 	 7.3322828784298477e-01 1.3770625884682419e-01 2.7342709459415812e-03
     	 	 6.6944610781464808e-01 1.9519546211776184e-01 3.3269986220136809e-03
     	 	 7.1404110474492222e-01 2.0027357710674865e-01 2.8915547157920057e-03
     	 	 6.9294495988099236e-01 2.5951961241000315e-01 2.2838710824997512e-03
     	 	 7.2056352188716377e-01 2.5997192540448982e-01 1.5893265786850826e-03
     	 	 7.1888136269038605e-01 2.7741671121877859e-01 6.8551787235506185e-04
     	 	 6.4938997896000883e-01 3.6127042361663326e-03 7.1435245255913667e-04
     	 	 6.5055120040978709e-01 1.9011177944520195e-02 1.6421132280201509e-03
     	 	 6.3166787863643648e-01 4.6203382134840092e-02 2.3198309246997739e-03
     	 	 6.4362202443631744e-01 8.5049358778999801e-02 3.2033020796618647e-03
     	 	 6.2041661719864716e-01 1.3401604385290503e-01 3.5076870376287259e-03
     	 	 6.1226870493130647e-01 1.9353595430357620e-01 3.9571051771565505e-03
     	 	 6.0682142469801015e-01 2.5869149474548653e-01 3.4417072182034818e-03
     	 	 6.4479892526727278e-01 2.6897510798523877e-01 3.1521368517761759e-03
     	 	 6.2694326130949896e-01 3.2878370818264430e-01 2.1973446899816547e-03
     	 	 6.4564608761858278e-01 3.3592770140511341e-01 1.6182180202336501e-03
     	 	 6.4460884714585465e-01 3.5190943780536127e-01 6.7960022939014440e-04
     	 	 5.7107386925782389e-01 3.4655311067999443e-03 7.0298178591459305e-04
     	 	 5.7205885744839957e-01 1.8235951401737699e-02 1.6583494004441238e-03
     	 	 5.6046035179812392e-01 4.4450426801042768e-02 2.3385380383778459e-03
     	 	 5.6910786593730256e-01 8.2889295413618835e-02 3.3133029690384725e-03
     	 	 5.5298133172061670e-01 1.3071144654622174e-01 3.7898592053353568e-03
     	 	 5.4789839454773859e-01 1.8907379274271821e-01 4.2938044156398255e-03
     	 	 5.5043647563742171e-01 2.5597429360809226e-01 3.3109284799470733e-03
     	 	 5.4526095423756926e-01 2.8693875182514161e-01 1.3611066562689319e-03
     	 	 5.4427007895329105e-01 3.3418691449629967e-01 3.6793981106747146e-03
     	 	 5.7954214572700291e-01 3.4293810440914524e-01 2.8690414106907211e-03
     	 	 5.5391659784450553e-01 4.0465127120380118e-01 2.3410103817849458e-03
     	 	 5.6665664727920750e-01 4.1655055795874985e-01 1.5453880933209974e-03
     	 	 5.6764003351506354e-01 4.2919361305749576e-01 6.3208630648898081e-04
     	 	 4.9210987093459724e-01 3.2813819865357718e-03 6.6240714443281895e-04
     	 	 4.9052960559818759e-01 1.7377378748576533e-02 1.6264373866682171e-03
     	 	 4.8697329694593661e-01 4.2547748898021903e-02 2.2646583589801404e-03
     	 	 4.9261013951747934e-01 7.8989912698947576e-02 3.2475788619486237e-03
     	 	 4.7977076881863245e-01 1.2572254201984628e-01 3.9310662452222075e-03
     	 	 4.7839243598395131e-01 1.8215173179565561e-01 4.3650381335701106e-03
     	 	 4.5246573355161146e-01 2.4371520054235235e-01 3.9070568524053858e-03
     	 	 5.0174420763254235e-01 2.5254321846617489e-01 3.3187104769756243e-03
     	 	 4.4807389067830161e-01 3.1490001405936463e-01 4.0589820703556389e-03
     	 	 4.8406742546467385e-01 3.3936401846785269e-01 4.1635642451916593e-03
     	 	 4.6477205839403213e-01 4.1045967909085573e-01 4.0232111271309981e-03
     	 	 5.0432302502665527e-01 4.1774003289620404e-01 3.1972859514008351e-03
     	 	 4.7433971236824091e-01 4.8164560520379462e-01 2.4476729135789270e-03
     	 	 4.8493015174387355e-01 4.9694447546951709e-01 1.6553254983681827e-03
     	 	 4.8947726128316882e-01 5.0704629849333804e-01 6.9858398202163926e-04
     	 	 4.1423919654747798e-01 3.6822568614835959e-03 7.2414936562074743e-04
     	 	 4.0794883900041445e-01 1.9146011950993514e-02 1.7428802730176179e-03
     	 	 4.1450039102770719e-01 4.5696977458025673e-02 2.2732866740516220e-03
     	 	 4.1398697471763168e-01 8.1802394784359869e-02 3.2256715753126840e-03
     	 	 4.0343965870736365e-01 1.2746028197044465e-01 3.7203539375498750e-03
     	 	 4.0480840021665765e-01 1.8088571587631017e-01 4.3297769080226488e-03
     	 	 3.8747948723742565e-01 2.4273387610909583e-01 4.3787928322573571e-03
     	 	 3.8656120912511838e-01 3.0847531040152604e-01 4.5839752115428411e-03
     	 	 3.8133914857257090e-01 3.7639639207096715e-01 4.0516198113609873e-03
     	 	 4.0686815862182357e-01 4.1183348104524697e-01 4.4179104574973045e-03
     	 	 3.8248902609125623e-01 4.8703179868052354e-01 4.0231805392874050e-03
     	 	 4.2232048307344638e-01 4.9518615856841774e-01 3.4072379749813231e-03
     	 	 3.9624860641565152e-01 5.5755417053532852e-01 2.4953925261774475e-03
     	 	 4.0401508754292947e-01 5.7694041002580887e-01 1.7000796595034058e-03
     	 	 4.1086195674336612e-01 5.8550487134565699e-01 7.2926221795367794e-04
     	 	 3.3853505371317827e-01 3.6966338236756715e-03 7.0526249813952866e-04
     	 	 3.2789850500756823e-01 1.9460065115655307e-02 1.7152705066234518e-03
     	 	 3.4214682102117644e-01 4.7285092161913865e-02 2.4426378047209233e-03
     	 	 3.3546695850384756e-01 8.6465342992967986e-02 3.3626745410084116e-03
     	 	 3.2994252756162590e-01 1.3481197097983733e-01 3.6681446091935627e-03
     	 	 3.2964632853734410e-01 1.8852746005595047e-01 4.1644726292050030e-03
     	 	 3.1869438692103969e-01 2.4785020134611896e-01 4.0881770648079976e-03
     	 	 3.1687124721037874e-01 3.1014483388438496e-01 4.4347928797742603e-03
     	 	 3.1656484601451840e-01 3.7346977691266686e-01 4.2440250321209823e-03
     	 	 3.1603367421885886e-01 4.3475222933670488e-01 3.8798449077691588e-03
     	 	 3.2807850989595644e-01 4.8300713970619691e-01 4.4346104041763958e-03
     	 	 3.0556754857166335e-01 5.5953126753739058e-01 3.8784785148384556e-03
     	 	 3.4124812783962333e-01 5.7351317968915239e-01 3.4406489484568609e-03
     	 	 3.2144375120285018e-01 6.3179454383954514e-01 2.4250472618491102e-03
     	 	 3.2658064009061782e-01 6.5422245595303441e-01 1.6237314960950856e-03
     	 	 3.3351243369316907e-01 6.6282211094571963e-01 7.1368905124020814e-04
     	 	 2.6588670612716414e-01 3.7677052334202936e-03 6.8163353837331724e-04
     	 	 2.5265650615962587e-01 1.9776300453829731e-02 1.5994030773684980e-03
     	 	 2.7036330855623625e-01 4.7949328819184414e-02 2.4141352100293919e-03
     	 	 2.6195882103050261e-01 8.8009771317235974e-02 3.2134017122770549e-03
     	 	 2.6033861490584731e-01 1.3915382576825946e-01 3.8159944141930554e-03
     	 	 2.5717740924966193e-01 2.0001800504435671e-01 4.4584611740771888e-03
     	 	 2.5124088570002490e-01 2.6908707933239195e-01 4.6082309717114479e-03
     	 	 2.4848993757368787e-01 3.4133418939771221e-01 4.7578084650980144e-03
     	 	 2.4994799681735158e-01 4.1300857895103071e-01 4.7223203884974255e-03
     	 	 2.5104278620465592e-01 4.8462042574889858e-01 4.5637947264821187e-03
     	 	 2.5402817301037317e-01 5.4952108106606068e-01 4.4795572447117833e-03
     	 	 2.3734176449591282e-01 6.2537139274605791e-01 3.5281658391383263e-03
     	 	 2.6508405648836386e-01 6.4843291445150297e-01 3.2794969310197971e-03
     	 	 2.5187600178494907e-01 7.0075736556480339e-01 2.2272588527432048e-03
     	 	 2.5423966357433969e-01 7.2631060601857111e-01 1.5199528981194909e-03
     	 	 2.5966709218621598e-01 7.3663565345320181e-01 6.7601199396367191e-04
     	 	 1.9804943228145044e-01 3.8245103146054174e-03 6.3313235105970226e-04
     	 	 1.8481480516663851e-01 1.9968342601707410e-02 1.4158381581037781e-03
     	 	 2.0211992787653765e-01 4.8156534893862998e-02 2.2183961617317067e-03
     	 	 1.9539774683461053e-01 8.7069436780984694e-02 2.7384606979784770e-03
     	 	 1.9514069874086670e-01 1.3543098250620242e-01 3.3026950673244806e-03
     	 	 1.9252422753071174e-01 1.9275419913734446e-01 3.8055515189786898e-03
     	 	 1.8946011418068542e-01 2.5874222469233388e-01 4.2143859224702922e-03
     	 	 1.8625083608871296e-01 3.3230644372398693e-01 4.4921388496311603e-03
     	 	 1.8595530312192154e-01 4.0857454536971782e-01 4.5435542101621715e-03
     	 	 1.8868515796975049e-01 4.8178925434808273e-01 4.3598511307265534e-03
     	 	 1.8799375507503491e-01 5.5373176184025175e-01 4.1382832823303609e-03
     	 	 1.8799909561078598e-01 6.1762536498917064e-01 3.7082985382105131e-03
     	 	 1.7733065579831353e-01 6.8438724107929372e-01 2.8681505198493184e-03
     	 	 1.9545601460687556e-01 7.1545279366890924e-01 2.9393977633987477e-03
     	 	 1.9001116801593665e-01 7.6035233548334347e-01 2.0159232500328830e-03
     	 	 1.8843653237989533e-01 7.9097345618364379e-01 1.4249657659715868e-03
     	 	 1.9173080538178544e-01 8.0432586438106513e-01 6.4720501304390459e-04
     	 	 1.3739523053015290e-01 3.7286675130116481e-03 5.3922450593786933e-04
     	 	 1.2697762406705437e-01 1.9571916396818965e-02 1.1684925500962888e-03
     	 	 1.4019004643476107e-01 4.8580634296714616e-02 2.0295470767379546e-03
     	 	 1.3716834556310109e-01 9.0333446268742193e-02 2.5685656153538062e-03
     	 	 1.3618167715155349e-01 1.4358008402015848e-01 3.2022127963250886e-03
     	 	 1.3439096307564680e-01 2.0709202946152100e-01 3.6169239967214651e-03
     	 	 1.3233794546174293e-01 2.7809157328020251e-01 3.8565261071495703e-03
     	 	 1.3021710961726884e-01 3.5297913431835859e-01 3.9010790907787834e-03
     	 	 1.3015004782250783e-01 4.2841000658242062e-01 3.9027072147959818e-03
     	 	 1.3129611876110425e-01 5.0019881440288183e-01 3.4032395309911575e-03
     	 	 1.3492199264273319e-01 5.4352640789837259e-01 1.7967571928710431e-03
     	 	 1.3032912934755192e-01 5.9702844867638361e-01 3.4420952186424020e-03
     	 	 1.3092748065298743e-01 6.6349940351114622e-01 3.4875696193384493e-03
     	 	 1.2779165319177110e-01 7.2887427351418399e-01 2.7447649910213334e-03
     	 	 1.3393908147425748e-01 7.7658434949623179e-01 2.6592539840287533e-03
     	 	 1.3518685709229084e-01 8.1674585009096512e-01 1.8073104214552825e-03
     	 	 1.3086748558057260e-01 8.4987366775773909e-01 1.1738885545562970e-03
     	 	 1.3211040135369423e-01 8.6425306163770721e-01 5.1344545377067345e-04
     	 	 8.6087636412799928e-02 3.6562851886596708e-03 4.2900997704717645e-04
     	 	 7.9807940518060172e-02 1.8605685717774482e-02 8.4412688806923008e-04
     	 	 8.7874963668276185e-02 4.4733665281639225e-02 1.4454277667386543e-03
     	 	 8.8301681328665005e-02 8.0575545924932282e-02 1.8454604356197544e-03
     	 	 8.6635865172545068e-02 1.2811463806083798e-01 2.4018457584145500e-03
     	 	 8.5889378549785511e-02 1.8739099268478210e-01 2.8646573083537645e-03
     	 	 8.4779741653768559e-02 2.5692526593175391e-01 3.2073255446561787e-03
     	 	 8.3268804000548924e-02 3.3392806918609519e-01 3.4109201408972153e-03
     	 	 8.2639691905105006e-02 4.1530164000318115e-01 3.5057333595784829e-03
     	 	 8.3318939050768481e-02 4.9761480991792117e-01 3.5314650333783367e-03
     	 	 8.4643451181176999e-02 5.7819276721482848e-01 3.4851960032866846e-03
     	 	 8.2368394849560711e-02 6.5810353609012961e-01 3.2144754690306694e-03
     	 	 8.3228465807704488e-02 7.2727518694392901e-01 2.7798361710885526e-03
     	 	 8.3860472714822998e-02 7.8743235850325055e-01 2.2499552361728648e-03
     	 	 8.3769491897730086e-02 8.3467133606037192e-01 1.8580291185387007e-03
     	 	 8.8057774774570885e-02 8.6645071674851093e-01 1.3517177477464142e-03
     	 	 8.2369444304718376e-02 8.9837628156782601e-01 9.1522138964517791e-04
     	 	 8.2394507691132435e-02 9.1385961106328395e-01 4.2319326195769608e-04
     	 	 4.5920344648349709e-02 2.9072957970458697e-03 2.6141688928917642e-04
     	 	 4.4361011025902619e-02 1.6416945437838351e-02 6.1097150905288532e-04
     	 	 4.7130753319043928e-02 4.3571968143883526e-02 1.1569979181563746e-03
     	 	 4.8638544867688704e-02 8.3460607187735875e-02 1.5746709213073538e-03
     	 	 4.7165890833410384e-02 1.3463607061384816e-01 1.8757983427213393e-03
     	 	 4.6936410571012721e-02 1.9328423208417234e-01 2.0409412416214226e-03
     	 	 4.6464694348594238e-02 2.5607377689853356e-01 2.1309457490544495e-03
     	 	 4.5673242645012935e-02 3.2332873796142275e-01 2.2905360167008466e-03
     	 	 4.5211003306192876e-02 3.9742604952900490e-01 2.4874316729914473e-03
     	 	 4.5342443043873470e-02 4.7622911007601337e-01 2.5668805191342253e-03
     	 	 4.5858642394259963e-02 5.5460980168964547e-01 2.5140281888352484e-03
     	 	 4.6408837937244374e-02 6.2817980436766518e-01 2.3321796118133515e-03
     	 	 4.4187689756792992e-02 6.9762313733700565e-01 2.0590105066034046e-03
     	 	 4.5953098262673131e-02 7.5749698152982836e-01 1.9319232358829131e-03
     	 	 4.6562807034370657e-02 8.1519506817457932e-01 1.8268397253519361e-03
     	 	 4.4899786138573261e-02 8.6870333013210199e-01 1.5440842060947110e-03
     	 	 4.8642125992515162e-02 9.0589893344248940e-01 1.1696505425085769e-03
     	 	 4.4609396434804216e-02 9.3761965432738703e-01 6.7315262728901738e-04
     	 	 4.3895832733643947e-02 9.5287377846475252e-01 2.7330258327337855e-04
     	 	 1.8204326697274231e-02 4.3015086431263203e-03 2.3293813591206470e-04
     	 	 1.8944133170822663e-02 2.2532574703168450e-02 5.1439213565979906e-04
     	 	 1.9190401311211081e-02 5.1863662913638205e-02 7.2867829147161742e-04
     	 	 2.0344213784159737e-02 8.7136475047367712e-02 8.4384649348615535e-04
     	 	 1.9276318964750683e-02 1.2861946074689001e-01 1.0353863313292580e-03
     	 	 1.9329327662450102e-02 1.8341627746347480e-01 1.3409759240106112e-03
     	 	 1.9144320849010410e-02 2.5044487518228731e-01 1.5436328417241184e-03
     	 	 1.8796864610627573e-02 3.2546748787633351e-01 1.6443055344790617e-03
     	 	 1.8568463820963887e-02 4.0495420856710246e-01 1.6885716493343071e-03
     	 	 1.8666739999456006e-02 4.8629289999662106e-01 1.7177276608964123e-03
     	 	 1.8827617881084335e-02 5.6800468288352013e-01 1.7262762185815269e-03
     	 	 1.9088821383574150e-02 6.4788163286880018e-01 1.6811426713383183e-03
     	 	 1.8020734086934054e-02 7.2472587871203953e-01 1.4940817005530335e-03
     	 	 1.9147427152693908e-02 7.9264762806436750e-01 1.3777470655482347e-03
     	 	 1.9251959163032462e-02 8.5120378979974154e-01 1.1342938798955318e-03
     	 	 1.7798974064564654e-02 8.9881073693245217e-01 8.2307398000701305e-04
     	 	 2.0473703004114996e-02 9.3147941060232287e-01 7.1443183418447179e-04
     	 	 1.8422130386706814e-02 9.6060501643791951e-01 4.6903856243812300e-04
     	 	 1.7541970173386767e-02 9.7833360086700882e-01 2.1285243009754184e-04
     	 	 3.3331138743830646e-03 2.9686353055211711e-03 6.8086809969676628e-05
     	 	 3.6724218532867559e-03 1.7224707243607976e-02 1.9669958273556702e-04
     	 	 3.6176399100590340e-03 4.5274273295925989e-02 3.2589622098649787e-04
     	 	 3.8463162414206220e-03 8.7007134592063592e-02 4.7438711439084315e-04
     	 	 3.6773418706173011e-03 1.4102867322225021e-01 5.6119152149128012e-04
     	 	 3.6848032364327210e-03 2.0531000823865864e-01 6.4837687174337626e-04
     	 	 3.6336558615842618e-03 2.7754686003310952e-01 7.0189451563599375e-04
     	 	 3.5674604955475697e-03 3.5519478238420649e-01 7.2639305545452442e-04
     	 	 3.5419010436192888e-03 4.3553909435559335e-01 7.3323020056448437e-04
     	 	 3.5790145791528838e-03 5.1579289954222818e-01 7.2739057172536840e-04
     	 	 3.5897792450874100e-03 5.9328276954092252e-01 6.9244541072615651e-04
     	 	 3.6710432136541904e-03 6.6561313534566857e-01 6.5410167026525175e-04
     	 	 3.3816606443696218e-03 7.3335523072182518e-01 5.7303097043575832e-04
     	 	 3.6522503333357159e-03 7.9765987570047703e-01 5.8698769556328337e-04
     	 	 3.7018860759799876e-03 8.5747980078415320e-01 5.3418904128897855e-04
     	 	 3.3903670209854964e-03 9.0957763118499491e-01 4.0818842808101001e-04
     	 	 3.8602860364779223e-03 9.5012738795549534e-01 3.4416021985385440e-04
     	 	 3.4830660033672300e-03 9.7865121324345294e-01 1.9060003946629183e-04
     	 	 3.2481828689258085e-03 9.9357563087604062e-01 6.9921948088979866e-05
     	 	 ];


    case 37

        % SET: SLOBODKINS TAUSCH
        % CARDINALITY RULE  :    250
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 1.052e-13

        XYW=[
    	 	 9.9210370217478627e-01 3.7932566415215347e-03 1.0201548856894137e-04
     	 	 9.7690835311252766e-01 1.9770663191549961e-02 1.8967449013606384e-04
     	 	 9.7485304001488693e-01 3.7193157825099626e-03 2.2974942351478570e-04
     	 	 9.6237541957035755e-01 1.9733714676744819e-02 4.6471927210034475e-04
     	 	 9.4899221116043386e-01 4.7718726827576829e-02 2.8230143833238893e-04
     	 	 9.4456195468873638e-01 3.3950674726678652e-03 3.2130095550837409e-04
     	 	 9.3668428830484107e-01 1.8094546231914879e-02 6.8691540497004466e-04
     	 	 9.1434378027481789e-01 4.4438136657298781e-02 9.5219266030686261e-04
     	 	 9.3452838551283102e-01 4.8529255341745015e-02 6.5806382945238489e-04
     	 	 9.0989578781202629e-01 8.6888787654535268e-02 3.6841098766008100e-04
     	 	 9.0208416337410757e-01 3.2505426056095906e-03 3.9881132307708928e-04
     	 	 8.9809230127169237e-01 1.6972853262194505e-02 8.6336339821575770e-04
     	 	 8.8116419779988231e-01 4.1444967620633766e-02 1.2382290760363118e-03
     	 	 8.5310094811190063e-01 7.6010230994575059e-02 1.3572210241742757e-03
     	 	 8.7770115114644309e-01 8.2018715093236771e-02 1.1606512163842102e-03
     	 	 8.9385003642413285e-01 8.9180348629285117e-02 8.7997772139695519e-04
     	 	 8.5982966720896237e-01 1.3659540367997425e-01 4.9868776811908271e-04
     	 	 8.4936548403338163e-01 3.6597138804375538e-03 5.3352108714055759e-04
     	 	 8.4685308361595890e-01 1.8840382652031827e-02 1.1577170296815157e-03
     	 	 8.3158717041044672e-01 4.5264536852744286e-02 1.6450982281157021e-03
     	 	 8.1087384991586875e-01 8.1185830691092739e-02 1.6929723892004300e-03
     	 	 7.9909106101084160e-01 1.2085802144965270e-01 1.9210855166501928e-03
     	 	 8.2745297592591283e-01 1.2775185369438766e-01 1.6211038369394080e-03
     	 	 8.4084985390950617e-01 1.4041734828123800e-01 1.1818207888142924e-03
     	 	 8.0110845548331078e-01 1.9538118888553965e-01 5.6596422833661184e-04
     	 	 7.8811226149417257e-01 3.5008249287481006e-03 5.8925129158291596e-04
     	 	 7.8724341293280564e-01 1.8691262948310843e-02 1.3448444624817295e-03
     	 	 7.7446100819226527e-01 4.5541140997515384e-02 2.0096780912140242e-03
     	 	 7.6172287060730159e-01 8.3603703394301815e-02 2.3086706883320984e-03
     	 	 7.4308241549920195e-01 1.3061045927040030e-01 2.7716287499979586e-03
     	 	 7.4581780776224504e-01 1.7238045503690522e-01 2.3066433745670260e-03
     	 	 7.6980836375089146e-01 1.8543877131070377e-01 2.0043185076844524e-03
     	 	 7.8063173368359640e-01 2.0116029290104326e-01 1.3247465874426437e-03
     	 	 7.3448999418083516e-01 2.6229392369821131e-01 5.8273131884003019e-04
     	 	 7.1909865025851161e-01 3.2262627145735164e-03 5.9763422801092697e-04
     	 	 7.2178751877355563e-01 1.6990954898376744e-02 1.3236030289586376e-03
     	 	 7.0902605259006779e-01 4.2085712648667117e-02 2.1985921524273425e-03
     	 	 7.0472888995334126e-01 7.8444417085206761e-02 2.5918969911442177e-03
     	 	 6.8789594969950674e-01 1.2313282392179932e-01 2.9484223533165288e-03
     	 	 6.7024279192626557e-01 1.6944393741718006e-01 2.3941166890541418e-03
     	 	 6.8396843098607263e-01 1.9659129827913138e-01 2.7360668340336365e-03
     	 	 6.8860855824404554e-01 2.3629788813173166e-01 2.5914440601359778e-03
     	 	 7.0553391212521088e-01 2.5374307001480900e-01 2.0474430176570654e-03
     	 	 7.1411692084580070e-01 2.6928148802395280e-01 1.3098099205198037e-03
     	 	 6.4447741964546368e-01 3.4570217141649683e-03 6.8000465937696015e-04
     	 	 6.5094051203230197e-01 1.7949039352384059e-02 1.4616923512697996e-03
     	 	 6.3366454597462152e-01 4.3374965070937362e-02 2.3542108416835126e-03
     	 	 6.3816214826291895e-01 7.8495910990995676e-02 2.8762546972085331e-03
     	 	 6.2223194164770901e-01 1.2449323351143257e-01 3.3948187796409230e-03
     	 	 6.0806016066928570e-01 1.7774918332717937e-01 3.4607206827595542e-03
     	 	 6.0289225123667711e-01 2.2776544220650283e-01 3.3337575267205679e-03
     	 	 6.1994005182949730e-01 2.6175723726818301e-01 3.2768767986572317e-03
     	 	 6.1968522121363390e-01 3.0481460454422715e-01 2.7512618357149327e-03
     	 	 6.3275597512070270e-01 3.2612519064459861e-01 2.2287535486957186e-03
     	 	 6.4239370124494011e-01 3.4088467950851126e-01 1.3966165638398559e-03
     	 	 6.6022414561630138e-01 3.3665995135767324e-01 6.2070379174745927e-04
     	 	 5.6578491418751042e-01 3.3537050047869488e-03 6.8957118407806707e-04
     	 	 5.7631083427736851e-01 1.7718727156556011e-02 1.5221868975390789e-03
     	 	 5.5536375245490155e-01 4.2989029172659343e-02 2.4460686742655883e-03
     	 	 5.6319088834784692e-01 7.8868050476995424e-02 3.0758276353630371e-03
     	 	 5.5547592321445372e-01 1.2173001812534995e-01 3.2424320880122953e-03
     	 	 4.9773743768210821e-01 1.4167023161794878e-01 1.6297953034909525e-03
     	 	 5.4308014093074863e-01 1.7623239655236300e-01 3.8677152092493438e-03
     	 	 5.2845546948825373e-01 2.3553311832561391e-01 4.1793593180151981e-03
     	 	 5.3615958644305917e-01 2.8456430994746168e-01 3.6559886349957281e-03
     	 	 5.4627825815999853e-01 3.2673216548060574e-01 3.6076739232549344e-03
     	 	 5.4764506142630864e-01 3.6944105024667179e-01 2.9334874278065049e-03
     	 	 5.5340753303967694e-01 4.0073935231989688e-01 2.5552950284173800e-03
     	 	 5.6698028954853918e-01 4.1394744728047300e-01 1.5908605059483292e-03
     	 	 5.8076019797497747e-01 4.1562102677932650e-01 7.4396573555372413e-04
     	 	 4.8529080933811208e-01 3.3344257096814445e-03 6.8599154143191574e-04
     	 	 4.9895689425573264e-01 1.7454997552040746e-02 1.5472517716102103e-03
     	 	 4.7457999973703313e-01 4.2433221656549204e-02 2.4597370773647388e-03
     	 	 4.8721085285819365e-01 7.7383199514953330e-02 3.0056493437895515e-03
     	 	 4.7437696666002094e-01 1.1884605387016002e-01 3.1916477846129034e-03
     	 	 4.7248687248865406e-01 1.8441696986312792e-01 3.3612245159884025e-03
     	 	 4.5622109593377802e-01 2.4001373710408019e-01 4.3980287852281490e-03
     	 	 4.5563328780197276e-01 3.0156414480655663e-01 4.4267193981550367e-03
     	 	 4.6750415042676396e-01 3.4955878153829517e-01 3.9779639699215998e-03
     	 	 4.7039663864745662e-01 4.0029733437276332e-01 3.8399436100299681e-03
     	 	 4.7501499405079706e-01 4.4326882802709600e-01 3.1892755630622271e-03
     	 	 4.7357331238743305e-01 4.8241425872424132e-01 2.5872352251198839e-03
     	 	 4.9300454324088472e-01 4.8905197290433750e-01 1.5259884324960189e-03
     	 	 5.0025534570949870e-01 4.9631052316831437e-01 7.1016178236876705e-04
     	 	 4.0624592311029839e-01 3.3138921868798997e-03 6.5661348178086478e-04
     	 	 4.1946366233592935e-01 1.7428191054113237e-02 1.5671081428786000e-03
     	 	 3.9406980534994618e-01 4.2528508664677306e-02 2.4149079677468028e-03
     	 	 4.0946067352669191e-01 7.8365749430767323e-02 3.2162799693433207e-03
     	 	 3.9819313255415778e-01 1.2530427711867556e-01 3.8218689816676894e-03
     	 	 4.1642623197676809e-01 1.7425255184632918e-01 3.6215282422197973e-03
     	 	 3.8246236433399483e-01 2.3824821955202852e-01 4.8250037359462298e-03
     	 	 3.8331465352246508e-01 3.0396301032951234e-01 4.8102078975438755e-03
     	 	 3.8383558936203788e-01 3.6944576526510048e-01 4.5659045846495475e-03
     	 	 3.9663128017746141e-01 4.1860870058261584e-01 4.1800792427920874e-03
     	 	 3.9737644338335520e-01 4.7600815987307349e-01 3.7822626327487716e-03
     	 	 3.9995558550666688e-01 5.2053169168701674e-01 3.1707678650432915e-03
     	 	 3.9297307665410619e-01 5.6383185765910515e-01 2.4370766275599249e-03
     	 	 4.1698613716672228e-01 5.6511370248623238e-01 1.5446103538819854e-03
     	 	 4.2029931085774841e-01 5.7630253271052778e-01 6.8653622716095082e-04
     	 	 3.3194830289567867e-01 3.3718843194036623e-03 6.1046840241690684e-04
     	 	 3.4071127670594303e-01 1.7441293513493723e-02 1.5092508696807378e-03
     	 	 3.1629575418379097e-01 4.1394267915221626e-02 2.1597170487299825e-03
     	 	 3.3202515759048079e-01 7.4867215569184103e-02 2.8030687775228635e-03
     	 	 3.2934496367604071e-01 1.1443053146585634e-01 3.0186658564263446e-03
     	 	 3.1114529251886447e-01 1.5746942027394292e-01 2.9562820671731006e-03
     	 	 3.4960681256281623e-01 1.8409811782848987e-01 3.5425820490344899e-03
     	 	 3.0629985313029051e-01 2.3978735537834883e-01 4.3272784110209564e-03
     	 	 3.1129037103693880e-01 3.0209707662358848e-01 4.7213032676846640e-03
     	 	 3.1282627045062805e-01 3.6807018516406476e-01 4.4370915927313603e-03
     	 	 3.1432698143954307e-01 4.2311944554392722e-01 3.0735711118524637e-03
     	 	 3.1458582246983446e-01 4.6452739297627016e-01 3.3145121728636036e-03
     	 	 3.3886562302152190e-01 4.9023091649484313e-01 2.7566856137007469e-03
     	 	 3.2551270521843689e-01 5.5649487722542124e-01 3.4419304015159261e-03
     	 	 3.2400576735233333e-01 6.0104361332824241e-01 2.8762909308048144e-03
     	 	 3.1634600201399043e-01 6.4311398114032670e-01 2.1431080718324214e-03
     	 	 3.4089381394978713e-01 6.4201873220212702e-01 1.4464888043878505e-03
     	 	 3.4384914479932083e-01 6.5284819356904744e-01 6.2212668887724732e-04
     	 	 2.6496868547800978e-01 2.9522687512866718e-03 4.8544401036375431e-04
     	 	 2.6465563448360729e-01 1.6290575935270571e-02 1.3929247185161201e-03
     	 	 2.4636421158795341e-01 4.0676371124358013e-02 1.9983588345402026e-03
     	 	 2.5918150343105961e-01 7.6084349108218458e-02 2.8026735963725931e-03
     	 	 2.5728860632824957e-01 1.2037518378606274e-01 3.2969569044329948e-03
     	 	 2.3690932711247437e-01 1.6784150329926692e-01 2.7222261088804657e-03
     	 	 2.6345996233175484e-01 1.9947842583055972e-01 3.0644185370353929e-03
     	 	 2.3662317133118338e-01 2.5334855305917586e-01 3.5155395163146874e-03
     	 	 2.4119923887050443e-01 3.1218246631028396e-01 4.3611441978603860e-03
     	 	 2.4553543627727559e-01 3.7874683236158774e-01 4.5787698331287950e-03
     	 	 2.4677193953836618e-01 4.5013689332527723e-01 4.6547703061362560e-03
     	 	 2.4569035089044267e-01 5.1979254714533241e-01 4.3410214274176920e-03
     	 	 2.9065175076056560e-01 5.4141452062838291e-01 2.6705911079717964e-03
     	 	 2.3903414677681667e-01 5.8552916302779467e-01 3.1130550199871074e-03
     	 	 2.5330927919028234e-01 6.2779699588392490e-01 3.4763339237928112e-03
     	 	 2.5308870288795571e-01 6.7312886041677245e-01 2.7188652546472894e-03
     	 	 2.4638660144130820e-01 7.1478925987204456e-01 1.9563640308262620e-03
     	 	 2.6656556015741040e-01 7.1803438878779224e-01 1.3194745743695105e-03
     	 	 2.7349676441269011e-01 7.2369914851026207e-01 4.9137553610343395e-04
     	 	 2.0406543945940658e-01 3.4907471277812762e-03 5.2378555327105476e-04
     	 	 1.9371671790734002e-01 1.7735732758342910e-02 1.2966867882002655e-03
     	 	 1.8297954795032967e-01 4.2016320630044790e-02 1.6287892353633190e-03
     	 	 1.9349609990427119e-01 7.3868831044720515e-02 2.2920127093537176e-03
     	 	 1.9098300113567290e-01 1.1590611156251418e-01 2.9702235840986658e-03
     	 	 1.8228061932573703e-01 1.6760315054063010e-01 3.0448512460683141e-03
     	 	 1.8717572097451762e-01 2.2616539930643931e-01 3.8030054029077791e-03
     	 	 1.7612495553232976e-01 2.9781960818512926e-01 3.9952242641550758e-03
     	 	 1.7971887790654506e-01 3.6572151943643338e-01 4.1368850470761016e-03
     	 	 1.8612723528973008e-01 4.2633183782600598e-01 3.0957835527412303e-03
     	 	 1.8309035621079961e-01 4.7290123788171318e-01 2.7477874141631957e-03
     	 	 1.8445734425443649e-01 5.2894340826614872e-01 3.7801908335818807e-03
     	 	 1.8045399738004486e-01 5.9612925703014819e-01 3.8001499133097825e-03
     	 	 1.8744088407700110e-01 6.5133697789921186e-01 3.0429312745604417e-03
     	 	 1.8733256850347990e-01 7.0097294861100246e-01 2.8672670818258288e-03
     	 	 1.8901955013969773e-01 7.4059397872422572e-01 2.1953023963079171e-03
     	 	 1.8278406726634067e-01 7.7785787038426957e-01 1.5551756861705902e-03
     	 	 1.9568226258553834e-01 7.8787204234250485e-01 1.2230723660446665e-03
     	 	 2.0831814043081853e-01 7.8853581114440352e-01 5.0510166767449565e-04
     	 	 1.4676607546235343e-01 3.3121343790550369e-03 4.7149167392147141e-04
     	 	 1.3207748083229076e-01 1.7647345692941661e-02 1.1475936112121498e-03
     	 	 1.3074581696862952e-01 4.4156791253536720e-02 1.5783709849790219e-03
     	 	 1.3463685526696156e-01 8.1832733863429458e-02 2.3563419036104704e-03
     	 	 1.3153005605723456e-01 1.2987387059215172e-01 2.7974009297325715e-03
     	 	 1.2944814640135083e-01 1.8699517479934741e-01 2.9744441964988369e-03
     	 	 1.3076477947022991e-01 2.4708425703327344e-01 3.2510267803471530e-03
     	 	 1.2367037337058240e-01 3.0962687219541141e-01 2.8704673890160362e-03
     	 	 1.2240115179748523e-01 3.7399773306099965e-01 3.5268841136141429e-03
     	 	 1.2979224344541740e-01 4.4103391214985360e-01 3.6292475627120813e-03
     	 	 1.2888679170926176e-01 5.1131639167730325e-01 3.4933463103787852e-03
     	 	 1.2838093791558602e-01 5.7819548298935175e-01 3.3198279303647237e-03
     	 	 1.2394579097533720e-01 6.4222981824740999e-01 2.9474602427574516e-03
     	 	 1.3390528334571850e-01 6.8954967947822354e-01 2.8019938258662599e-03
     	 	 1.2948680041718719e-01 7.4501414947170841e-01 2.5691126423003233e-03
     	 	 1.3128846561293661e-01 7.8874359283431117e-01 2.2173360332853440e-03
     	 	 1.3071211074969946e-01 8.2541381711509854e-01 1.4993217293396766e-03
     	 	 1.3301011976142307e-01 8.4925613641211928e-01 1.1481802963761174e-03
     	 	 1.4809854732592931e-01 8.4856000485425820e-01 4.8819905129022958e-04
     	 	 9.4824113329011084e-02 3.3982505386636339e-03 4.1638267534631709e-04
     	 	 8.0782430770198088e-02 1.7721327063932566e-02 8.8724462418864330e-04
     	 	 8.5765694231793921e-02 4.1925173579975140e-02 1.2100016456813320e-03
     	 	 8.4992204358111723e-02 7.6919295787318348e-02 1.7823690658959465e-03
     	 	 8.3577593950549645e-02 1.2179560388683358e-01 2.1673602022234521e-03
     	 	 8.3361516519566137e-02 1.7694515870337760e-01 2.5473079329064192e-03
     	 	 8.2502475143455878e-02 2.4159546973233134e-01 2.9143668932001005e-03
     	 	 8.0936336508528939e-02 3.1157493185264645e-01 2.9100669871369670e-03
     	 	 7.5682726457252492e-02 3.8698673062721539e-01 3.0488614880634177e-03
     	 	 8.2363024041977373e-02 4.5822239664635356e-01 3.1343372575704026e-03
     	 	 8.2601550081247699e-02 5.3109398768899096e-01 3.0332540642307032e-03
     	 	 8.1081739124217123e-02 6.0370380397892753e-01 3.0022895722125304e-03
     	 	 7.8571097441403892e-02 6.7424604022551515e-01 2.7118702693724695e-03
     	 	 8.4938814390537520e-02 7.3269448466783615e-01 2.6340491745875465e-03
     	 	 8.2458382295436450e-02 7.9049878899947412e-01 2.1415434469752486e-03
     	 	 8.2017314702783062e-02 8.3731360890903228e-01 1.8463903834352530e-03
     	 	 8.6738712434670240e-02 8.6947612842730815e-01 1.2737533713895321e-03
     	 	 8.1605239507894556e-02 9.0020204657054004e-01 9.2814921362866279e-04
     	 	 9.5245924703450613e-02 9.0131000735506661e-01 4.2633915295011684e-04
     	 	 5.2095735095648243e-02 3.5214094118596485e-03 3.3417742418595671e-04
     	 	 4.2025602118919370e-02 1.8937557402950514e-02 6.9893556486003063e-04
     	 	 4.8447767961046773e-02 4.6131445689982252e-02 1.1037610419271406e-03
     	 	 4.5653536687088048e-02 8.5311246291927212e-02 1.4856286138909833e-03
     	 	 4.5666458893090400e-02 1.3502577477636124e-01 1.7597215233174359e-03
     	 	 4.5781968206811241e-02 1.9305210917375681e-01 1.9957783865575639e-03
     	 	 4.4720546779205783e-02 2.5749457611108123e-01 2.1448343357694717e-03
     	 	 4.4650177600309315e-02 3.2687706967907110e-01 2.2602736258410783e-03
     	 	 4.0292947883455610e-02 4.0223629681055240e-01 2.2369565282352511e-03
     	 	 4.4871647193263975e-02 4.7653613241369158e-01 2.4818637479619172e-03
     	 	 4.5555091536934045e-02 5.5319661367125195e-01 2.4484170581623851e-03
     	 	 4.3811473514269506e-02 6.2940014058272953e-01 2.3312050885578852e-03
     	 	 4.2979806628527517e-02 7.0087638730803548e-01 2.0712983057011277e-03
     	 	 4.6134687985822320e-02 7.6324821806760879e-01 2.0373954856094116e-03
     	 	 4.5722304847708561e-02 8.2088719681916744e-01 1.6925775031653610e-03
     	 	 4.3461307972321506e-02 8.7159247478777779e-01 1.4274824578659417e-03
     	 	 4.9172346178151027e-02 9.0476349628882136e-01 1.1055305121480024e-03
     	 	 4.2454564763431901e-02 9.3851102398380926e-01 7.0281164960452644e-04
     	 	 5.2354421584835609e-02 9.4406078827412909e-01 3.4081125642870114e-04
     	 	 2.1477205185169268e-02 3.7398817510820230e-03 2.3099773084908496e-04
     	 	 1.6033537254185992e-02 1.9646267741580882e-02 4.2644045707946140e-04
     	 	 2.0375515048811965e-02 4.7271375779025654e-02 7.5682080859384862e-04
     	 	 1.8453496459491792e-02 8.6259039407251381e-02 9.3018947565634124e-04
     	 	 1.8843868661711949e-02 1.3537101440200902e-01 1.1431297406930730e-03
     	 	 1.8836234969466181e-02 1.9419476498671312e-01 1.3430973262270084e-03
     	 	 1.8364578893813155e-02 2.6142321513196620e-01 1.4617958885625108e-03
     	 	 1.8386715707126133e-02 3.3487941956218076e-01 1.5698104755327636e-03
     	 	 1.6285997054874324e-02 4.1326009885850867e-01 1.4617856230111914e-03
     	 	 1.8356227933469249e-02 4.9123655260199683e-01 1.6397652181710572e-03
     	 	 1.8899583769497852e-02 5.6938996568056865e-01 1.6409765613849328e-03
     	 	 1.7763897214957747e-02 6.4649730560759144e-01 1.5142204491586635e-03
     	 	 1.7805697179897328e-02 7.1906313987534054e-01 1.3934266655478628e-03
     	 	 1.8781687122696233e-02 7.8516163354226121e-01 1.3494566313856915e-03
     	 	 1.9091887316538214e-02 8.4408391635955138e-01 1.1633618480131635e-03
     	 	 1.7188018170740338e-02 8.9574766688439456e-01 8.9984412164194458e-04
     	 	 2.0664689776920153e-02 9.3191652743394182e-01 7.7561334902334536e-04
     	 	 1.6303275266215889e-02 9.6411694666981851e-01 4.3161911101216816e-04
     	 	 2.1594472827401234e-02 9.7468752789013402e-01 2.3110323211939139e-04
     	 	 4.1087868023784724e-03 3.7823954595701060e-03 1.0207041485574534e-04
     	 	 2.8370698678181760e-03 1.9874552883955562e-02 1.6709384626936065e-04
     	 	 3.9151221304514205e-03 4.8475514488367177e-02 3.4791669949121108e-04
     	 	 3.4771813370769733e-03 8.9080884959208004e-02 4.1295605230684985e-04
     	 	 3.6167238478617136e-03 1.4034017459392198e-01 5.1947598170539117e-04
     	 	 3.5846320016877931e-03 2.0074768233531629e-01 5.9197313717205343e-04
     	 	 3.5033691338154371e-03 2.6853955920054062e-01 6.3587972070269175e-04
     	 	 3.5094188101023605e-03 3.4186817253274532e-01 6.8000513763501321e-04
     	 	 3.0706214737112880e-03 4.1941724533609520e-01 6.2213609966705089e-04
     	 	 3.4898150909762338e-03 4.9886995967379816e-01 7.1752728711696131e-04
     	 	 3.6274186925387975e-03 5.7867450994627656e-01 7.3568918415338165e-04
     	 	 3.3528698924574218e-03 6.5672042937467967e-01 6.5607955708718677e-04
     	 	 3.4257580622173434e-03 7.3033826692251191e-01 6.2118095265767512e-04
     	 	 3.5594714183411202e-03 7.9778677527636066e-01 5.8445803644042451e-04
     	 	 3.6815195118289346e-03 8.5750047834575682e-01 5.2177497911233388e-04
     	 	 3.1701039347467042e-03 9.0855328715541284e-01 3.7359126905113391e-04
     	 	 3.9814857089229827e-03 9.4783226990477254e-01 3.4989661459983580e-04
     	 	 2.8963411902740432e-03 9.7728853490983358e-01 1.6942800005595752e-04
     	 	 4.1301503305231080e-03 9.9209269214234508e-01 1.0242665635771744e-04
     	 	 ];





        %         % ALG. DEG.:   37
        %         % PTS CARD.:  252
        %         % NEG. W.  :    0
        %         % OUT PTS. :    0
        %         % M.E.INF. : 1.0e-15
        %
        %         xyw=[
        %             1.02303932157760305021731994656875e-01 1.02303932157760305021731994656875e-01 7.56994885929007654823408302036114e-04
        %             1.02303932157760305021731994656875e-01 7.95392135684479417712111626315163e-01 7.56994885929007654823408302036114e-04
        %             7.95392135684479417712111626315163e-01 1.02303932157760305021731994656875e-01 7.56994885929007654823408302036114e-04
        %             3.50202358754684098252063506606646e-02 3.50202358754684098252063506606646e-02 5.52341834522307299250309942095782e-04
        %             3.50202358754684098252063506606646e-02 9.29959528249063138716223875235301e-01 5.52341834522307299250309942095782e-04
        %             9.29959528249063138716223875235301e-01 3.50202358754684098252063506606646e-02 5.52341834522307299250309942095782e-04
        %             2.59243490456549541267605718530831e-01 2.59243490456549541267605718530831e-01 3.79254617818526248984589699375647e-03
        %             2.59243490456549541267605718530831e-01 4.81513019086900917464788562938338e-01 3.79254617818526248984589699375647e-03
        %             4.81513019086900917464788562938338e-01 2.59243490456549541267605718530831e-01 3.79254617818526248984589699375647e-03
        %             1.39441235872292679243145130385528e-01 1.39441235872292679243145130385528e-01 2.62503007716438857901963821461777e-03
        %             1.39441235872292679243145130385528e-01 7.21117528255414641513709739228943e-01 2.62503007716438857901963821461777e-03
        %             7.21117528255414641513709739228943e-01 1.39441235872292679243145130385528e-01 2.62503007716438857901963821461777e-03
        %             4.61168458890810040173846573452465e-01 4.61168458890810040173846573452465e-01 2.94041733963891450606698008130024e-03
        %             4.61168458890810040173846573452465e-01 7.76630822183799196523068530950695e-02 2.94041733963891450606698008130024e-03
        %             7.76630822183799196523068530950695e-02 4.61168458890810040173846573452465e-01 2.94041733963891450606698008130024e-03
        %             3.79153717955037827813669082388515e-01 3.79153717955037827813669082388515e-01 4.32227828704266625603480633799336e-03
        %             3.79153717955037827813669082388515e-01 2.41692564089924344372661835222971e-01 4.32227828704266625603480633799336e-03
        %             2.41692564089924344372661835222971e-01 3.79153717955037827813669082388515e-01 4.32227828704266625603480633799336e-03
        %             1.73411753639024328321749379711036e-02 1.73411753639024328321749379711036e-02 4.38793626075407376500858713797015e-04
        %             1.73411753639024328321749379711036e-02 9.65317649272195099641180604521651e-01 4.38793626075407376500858713797015e-04
        %             9.65317649272195099641180604521651e-01 1.73411753639024328321749379711036e-02 4.38793626075407376500858713797015e-04
        %             7.79889301806426238350411495048320e-02 7.79889301806426238350411495048320e-02 1.79311680137484233399369770722842e-03
        %             7.79889301806426238350411495048320e-02 8.44022139638714752329917700990336e-01 1.79311680137484233399369770722842e-03
        %             8.44022139638714752329917700990336e-01 7.79889301806426238350411495048320e-02 1.79311680137484233399369770722842e-03
        %             4.79244935556920326202856585950940e-01 4.79244935556920326202856585950940e-01 2.49962141423790921296310685306707e-03
        %             4.79244935556920326202856585950940e-01 4.15101288861593475942868280981202e-02 2.49962141423790921296310685306707e-03
        %             4.15101288861593475942868280981202e-02 4.79244935556920326202856585950940e-01 2.49962141423790921296310685306707e-03
        %             4.12061405479689502051598992693471e-01 4.12061405479689502051598992693471e-01 4.53942125276982424986194075700041e-03
        %             4.12061405479689502051598992693471e-01 1.75877189040620995896802014613058e-01 4.53942125276982424986194075700041e-03
        %             1.75877189040620995896802014613058e-01 4.12061405479689502051598992693471e-01 4.53942125276982424986194075700041e-03
        %             4.98410574413956974915151931782020e-01 4.98410574413956974915151931782020e-01 7.07839054597255682051148983902067e-04
        %             4.98410574413956974915151931782020e-01 3.17885117208605016969613643595949e-03 7.07839054597255682051148983902067e-04
        %             3.17885117208605016969613643595949e-03 4.98410574413956974915151931782020e-01 7.07839054597255682051148983902067e-04
        %             3.09125948685350482314504461101023e-01 3.09125948685350482314504461101023e-01 5.10331832458679572617210595808501e-03
        %             3.09125948685350482314504461101023e-01 3.81748102629299035370991077797953e-01 5.10331832458679572617210595808501e-03
        %             3.81748102629299035370991077797953e-01 3.09125948685350482314504461101023e-01 5.10331832458679572617210595808501e-03
        %             3.67156682198311505940790944180208e-03 3.67156682198311505940790944180208e-03 8.66476678904295929527917818901983e-05
        %             3.67156682198311505940790944180208e-03 9.92656866356033784626333726919256e-01 8.66476678904295929527917818901983e-05
        %             9.92656866356033784626333726919256e-01 3.67156682198311505940790944180208e-03 8.66476678904295929527917818901983e-05
        %             1.89364261200196171142096090989071e-01 1.89364261200196171142096090989071e-01 4.14530662852686040964478308978869e-03
        %             1.89364261200196171142096090989071e-01 6.21271477599607657715807818021858e-01 4.14530662852686040964478308978869e-03
        %             6.21271477599607657715807818021858e-01 1.89364261200196171142096090989071e-01 4.14530662852686040964478308978869e-03
        %             3.16024096496639927966754157750984e-01 3.38290906827213161411904707165377e-02 1.04959604867473662963284208871073e-03
        %             3.16024096496639927966754157750984e-01 6.50146812820638797525418794975849e-01 1.04959604867473662963284208871073e-03
        %             3.38290906827213161411904707165377e-02 3.16024096496639927966754157750984e-01 1.04959604867473662963284208871073e-03
        %             3.38290906827213161411904707165377e-02 6.50146812820638797525418794975849e-01 1.04959604867473662963284208871073e-03
        %             6.50146812820638797525418794975849e-01 3.16024096496639927966754157750984e-01 1.04959604867473662963284208871073e-03
        %             6.50146812820638797525418794975849e-01 3.38290906827213161411904707165377e-02 1.04959604867473662963284208871073e-03
        %             1.05359411960281923459348263349966e-01 3.31459895561884293480048313540465e-02 9.61312586091038847636858211131994e-04
        %             1.05359411960281923459348263349966e-01 8.61494598483529716581585944368271e-01 9.61312586091038847636858211131994e-04
        %             3.31459895561884293480048313540465e-02 1.05359411960281923459348263349966e-01 9.61312586091038847636858211131994e-04
        %             3.31459895561884293480048313540465e-02 8.61494598483529716581585944368271e-01 9.61312586091038847636858211131994e-04
        %             8.61494598483529716581585944368271e-01 1.05359411960281923459348263349966e-01 9.61312586091038847636858211131994e-04
        %             8.61494598483529716581585944368271e-01 3.31459895561884293480048313540465e-02 9.61312586091038847636858211131994e-04
        %             7.49810217841138243466403423553857e-02 2.03347607611732879295818321452316e-03 2.40221505000938354099787597206728e-04
        %             7.49810217841138243466403423553857e-02 9.22985502139768820839549334777985e-01 2.40221505000938354099787597206728e-04
        %             2.03347607611732879295818321452316e-03 7.49810217841138243466403423553857e-02 2.40221505000938354099787597206728e-04
        %             2.03347607611732879295818321452316e-03 9.22985502139768820839549334777985e-01 2.40221505000938354099787597206728e-04
        %             9.22985502139768820839549334777985e-01 7.49810217841138243466403423553857e-02 2.40221505000938354099787597206728e-04
        %             9.22985502139768820839549334777985e-01 2.03347607611732879295818321452316e-03 2.40221505000938354099787597206728e-04
        %             1.19486593380355193838582295029482e-01 5.55104031624588586946167367841554e-02 1.51627373004474563268628717338515e-03
        %             1.19486593380355193838582295029482e-01 8.25003003457186023794633911165874e-01 1.51627373004474563268628717338515e-03
        %             5.55104031624588586946167367841554e-02 1.19486593380355193838582295029482e-01 1.51627373004474563268628717338515e-03
        %             5.55104031624588586946167367841554e-02 8.25003003457186023794633911165874e-01 1.51627373004474563268628717338515e-03
        %             8.25003003457186023794633911165874e-01 1.19486593380355193838582295029482e-01 1.51627373004474563268628717338515e-03
        %             8.25003003457186023794633911165874e-01 5.55104031624588586946167367841554e-02 1.51627373004474563268628717338515e-03
        %             3.19235165045989144338989262905670e-01 2.38060847117024854124878174843616e-01 3.65945316462084864819748197817262e-03
        %             3.19235165045989144338989262905670e-01 4.42703987836986001536132562250714e-01 3.65945316462084864819748197817262e-03
        %             2.38060847117024854124878174843616e-01 3.19235165045989144338989262905670e-01 3.65945316462084864819748197817262e-03
        %             2.38060847117024854124878174843616e-01 4.42703987836986001536132562250714e-01 3.65945316462084864819748197817262e-03
        %             4.42703987836986001536132562250714e-01 3.19235165045989144338989262905670e-01 3.65945316462084864819748197817262e-03
        %             4.42703987836986001536132562250714e-01 2.38060847117024854124878174843616e-01 3.65945316462084864819748197817262e-03
        %             3.91788257723670096943635599018307e-01 7.52705489375098402149433240992948e-02 2.69415942149049117068648762085559e-03
        %             3.91788257723670096943635599018307e-01 5.32941193338820062841421076882398e-01 2.69415942149049117068648762085559e-03
        %             7.52705489375098402149433240992948e-02 3.91788257723670096943635599018307e-01 2.69415942149049117068648762085559e-03
        %             7.52705489375098402149433240992948e-02 5.32941193338820062841421076882398e-01 2.69415942149049117068648762085559e-03
        %             5.32941193338820062841421076882398e-01 3.91788257723670096943635599018307e-01 2.69415942149049117068648762085559e-03
        %             5.32941193338820062841421076882398e-01 7.52705489375098402149433240992948e-02 2.69415942149049117068648762085559e-03
        %             3.17543407214198269983285172202159e-01 5.36208316291131165121086610270140e-02 2.28460795949074089647434782079927e-03
        %             3.17543407214198269983285172202159e-01 6.28835761156688599626818358956371e-01 2.28460795949074089647434782079927e-03
        %             5.36208316291131165121086610270140e-02 3.17543407214198269983285172202159e-01 2.28460795949074089647434782079927e-03
        %             5.36208316291131165121086610270140e-02 6.28835761156688599626818358956371e-01 2.28460795949074089647434782079927e-03
        %             6.28835761156688599626818358956371e-01 3.17543407214198269983285172202159e-01 2.28460795949074089647434782079927e-03
        %             6.28835761156688599626818358956371e-01 5.36208316291131165121086610270140e-02 2.28460795949074089647434782079927e-03
        %             3.26764524592731753216412471374497e-01 9.12947670950428336045234800621984e-02 2.86017995322923818460325584567272e-03
        %             3.26764524592731753216412471374497e-01 5.81940708312225440934639664192218e-01 2.86017995322923818460325584567272e-03
        %             9.12947670950428336045234800621984e-02 3.26764524592731753216412471374497e-01 2.86017995322923818460325584567272e-03
        %             9.12947670950428336045234800621984e-02 5.81940708312225440934639664192218e-01 2.86017995322923818460325584567272e-03
        %             5.81940708312225440934639664192218e-01 3.26764524592731753216412471374497e-01 2.86017995322923818460325584567272e-03
        %             5.81940708312225440934639664192218e-01 9.12947670950428336045234800621984e-02 2.86017995322923818460325584567272e-03
        %             3.18749666827180144768050240600132e-01 1.35115749070284674182573780854000e-01 3.35600242454283520521229888800008e-03
        %             3.18749666827180144768050240600132e-01 5.46134584102535236560527209803695e-01 3.35600242454283520521229888800008e-03
        %             1.35115749070284674182573780854000e-01 3.18749666827180144768050240600132e-01 3.35600242454283520521229888800008e-03
        %             1.35115749070284674182573780854000e-01 5.46134584102535236560527209803695e-01 3.35600242454283520521229888800008e-03
        %             5.46134584102535236560527209803695e-01 3.18749666827180144768050240600132e-01 3.35600242454283520521229888800008e-03
        %             5.46134584102535236560527209803695e-01 1.35115749070284674182573780854000e-01 3.35600242454283520521229888800008e-03
        %             6.74578790813868262032926281790424e-02 4.07701237566786764410231569399912e-02 1.15853875465657374897732179164223e-03
        %             6.74578790813868262032926281790424e-02 8.91771997161934559805729350046022e-01 1.15853875465657374897732179164223e-03
        %             4.07701237566786764410231569399912e-02 6.74578790813868262032926281790424e-02 1.15853875465657374897732179164223e-03
        %             4.07701237566786764410231569399912e-02 8.91771997161934559805729350046022e-01 1.15853875465657374897732179164223e-03
        %             8.91771997161934559805729350046022e-01 6.74578790813868262032926281790424e-02 1.15853875465657374897732179164223e-03
        %             8.91771997161934559805729350046022e-01 4.07701237566786764410231569399912e-02 1.15853875465657374897732179164223e-03
        %             1.83794409210811804378238321078243e-02 2.99027787656391775758524254058557e-03 1.54334630985266210191630964487786e-04
        %             1.83794409210811804378238321078243e-02 9.78630281202354956882061287615215e-01 1.54334630985266210191630964487786e-04
        %             2.99027787656391775758524254058557e-03 1.83794409210811804378238321078243e-02 1.54334630985266210191630964487786e-04
        %             2.99027787656391775758524254058557e-03 9.78630281202354956882061287615215e-01 1.54334630985266210191630964487786e-04
        %             9.78630281202354956882061287615215e-01 1.83794409210811804378238321078243e-02 1.54334630985266210191630964487786e-04
        %             9.78630281202354956882061287615215e-01 2.99027787656391775758524254058557e-03 1.54334630985266210191630964487786e-04
        %             4.76569358622159489069503024438745e-02 1.72509604538075254909212929987916e-02 6.02351384720529949186318408038687e-04
        %             4.76569358622159489069503024438745e-02 9.35092103683976549888257068232633e-01 6.02351384720529949186318408038687e-04
        %             1.72509604538075254909212929987916e-02 4.76569358622159489069503024438745e-02 6.02351384720529949186318408038687e-04
        %             1.72509604538075254909212929987916e-02 9.35092103683976549888257068232633e-01 6.02351384720529949186318408038687e-04
        %             9.35092103683976549888257068232633e-01 4.76569358622159489069503024438745e-02 6.02351384720529949186318408038687e-04
        %             9.35092103683976549888257068232633e-01 1.72509604538075254909212929987916e-02 6.02351384720529949186318408038687e-04
        %             3.35722787038010062055093385424698e-01 1.81116409195531985476534941881255e-01 4.08187312607179424855941007876936e-03
        %             3.35722787038010062055093385424698e-01 4.83160803766457980223947288322961e-01 4.08187312607179424855941007876936e-03
        %             1.81116409195531985476534941881255e-01 3.35722787038010062055093385424698e-01 4.08187312607179424855941007876936e-03
        %             1.81116409195531985476534941881255e-01 4.83160803766457980223947288322961e-01 4.08187312607179424855941007876936e-03
        %             4.83160803766457980223947288322961e-01 3.35722787038010062055093385424698e-01 4.08187312607179424855941007876936e-03
        %             4.83160803766457980223947288322961e-01 1.81116409195531985476534941881255e-01 4.08187312607179424855941007876936e-03
        %             1.35671607916117625824981018922699e-01 9.01302718482900888652409321366576e-02 2.18226201409495428745755063459910e-03
        %             1.35671607916117625824981018922699e-01 7.74198120235592313065353664569557e-01 2.18226201409495428745755063459910e-03
        %             9.01302718482900888652409321366576e-02 1.35671607916117625824981018922699e-01 2.18226201409495428745755063459910e-03
        %             9.01302718482900888652409321366576e-02 7.74198120235592313065353664569557e-01 2.18226201409495428745755063459910e-03
        %             7.74198120235592313065353664569557e-01 1.35671607916117625824981018922699e-01 2.18226201409495428745755063459910e-03
        %             7.74198120235592313065353664569557e-01 9.01302718482900888652409321366576e-02 2.18226201409495428745755063459910e-03
        %             4.17693614359697928950510004142416e-02 4.01709708723125332591186165132058e-03 2.74898275323659198928621938406991e-04
        %             4.17693614359697928950510004142416e-02 9.54213541476798932094993688224349e-01 2.74898275323659198928621938406991e-04
        %             4.01709708723125332591186165132058e-03 4.17693614359697928950510004142416e-02 2.74898275323659198928621938406991e-04
        %             4.01709708723125332591186165132058e-03 9.54213541476798932094993688224349e-01 2.74898275323659198928621938406991e-04
        %             9.54213541476798932094993688224349e-01 4.17693614359697928950510004142416e-02 2.74898275323659198928621938406991e-04
        %             9.54213541476798932094993688224349e-01 4.01709708723125332591186165132058e-03 2.74898275323659198928621938406991e-04
        %             1.91263737438076231178740727045806e-01 8.09653202292540813411747535610630e-02 2.62321907934608654355823631476596e-03
        %             1.91263737438076231178740727045806e-01 7.27770942332669701357872327207588e-01 2.62321907934608654355823631476596e-03
        %             8.09653202292540813411747535610630e-02 1.91263737438076231178740727045806e-01 2.62321907934608654355823631476596e-03
        %             8.09653202292540813411747535610630e-02 7.27770942332669701357872327207588e-01 2.62321907934608654355823631476596e-03
        %             7.27770942332669701357872327207588e-01 1.91263737438076231178740727045806e-01 2.62321907934608654355823631476596e-03
        %             7.27770942332669701357872327207588e-01 8.09653202292540813411747535610630e-02 2.62321907934608654355823631476596e-03
        %             4.48920329956642827351487312625977e-01 1.68814585101307729209096919475996e-02 1.62924472819564610491516187806837e-03
        %             4.48920329956642827351487312625977e-01 5.34198211533226330338663956354139e-01 1.62924472819564610491516187806837e-03
        %             1.68814585101307729209096919475996e-02 4.48920329956642827351487312625977e-01 1.62924472819564610491516187806837e-03
        %             1.68814585101307729209096919475996e-02 5.34198211533226330338663956354139e-01 1.62924472819564610491516187806837e-03
        %             5.34198211533226330338663956354139e-01 4.48920329956642827351487312625977e-01 1.62924472819564610491516187806837e-03
        %             5.34198211533226330338663956354139e-01 1.68814585101307729209096919475996e-02 1.62924472819564610491516187806837e-03
        %             3.97083379134988478931234112678794e-01 4.14766785336368876135892946876993e-02 2.39061749419019640636174806047620e-03
        %             3.97083379134988478931234112678794e-01 5.61439942331374619577388784819050e-01 2.39061749419019640636174806047620e-03
        %             4.14766785336368876135892946876993e-02 3.97083379134988478931234112678794e-01 2.39061749419019640636174806047620e-03
        %             4.14766785336368876135892946876993e-02 5.61439942331374619577388784819050e-01 2.39061749419019640636174806047620e-03
        %             5.61439942331374619577388784819050e-01 3.97083379134988478931234112678794e-01 2.39061749419019640636174806047620e-03
        %             5.61439942331374619577388784819050e-01 4.14766785336368876135892946876993e-02 2.39061749419019640636174806047620e-03
        %             8.62263440628871780102571165116387e-02 1.37345861622121794692885643485170e-02 8.04385951443430027157921458069723e-04
        %             8.62263440628871780102571165116387e-02 9.00039069774900668541306458791951e-01 8.04385951443430027157921458069723e-04
        %             1.37345861622121794692885643485170e-02 8.62263440628871780102571165116387e-02 8.04385951443430027157921458069723e-04
        %             1.37345861622121794692885643485170e-02 9.00039069774900668541306458791951e-01 8.04385951443430027157921458069723e-04
        %             9.00039069774900668541306458791951e-01 8.62263440628871780102571165116387e-02 8.04385951443430027157921458069723e-04
        %             9.00039069774900668541306458791951e-01 1.37345861622121794692885643485170e-02 8.04385951443430027157921458069723e-04
        %             2.81487959942281984471179612228298e-01 1.79186043302918159014769372561204e-02 1.49128325264966544311251439580701e-03
        %             2.81487959942281984471179612228298e-01 7.00593435727426272485729441541480e-01 1.49128325264966544311251439580701e-03
        %             1.79186043302918159014769372561204e-02 2.81487959942281984471179612228298e-01 1.49128325264966544311251439580701e-03
        %             1.79186043302918159014769372561204e-02 7.00593435727426272485729441541480e-01 1.49128325264966544311251439580701e-03
        %             7.00593435727426272485729441541480e-01 2.81487959942281984471179612228298e-01 1.49128325264966544311251439580701e-03
        %             7.00593435727426272485729441541480e-01 1.79186043302918159014769372561204e-02 1.49128325264966544311251439580701e-03
        %             1.92376834744259289644574550948164e-01 1.28471390056792922340633822386735e-01 3.04697442177643109187390457748279e-03
        %             1.92376834744259289644574550948164e-01 6.79151775198947760259216011036187e-01 3.04697442177643109187390457748279e-03
        %             1.28471390056792922340633822386735e-01 1.92376834744259289644574550948164e-01 3.04697442177643109187390457748279e-03
        %             1.28471390056792922340633822386735e-01 6.79151775198947760259216011036187e-01 3.04697442177643109187390457748279e-03
        %             6.79151775198947760259216011036187e-01 1.92376834744259289644574550948164e-01 3.04697442177643109187390457748279e-03
        %             6.79151775198947760259216011036187e-01 1.28471390056792922340633822386735e-01 3.04697442177643109187390457748279e-03
        %             2.51794247517433122940389012001106e-01 1.37321159731595615616228656108433e-01 3.54367037302832183984224734274449e-03
        %             2.51794247517433122940389012001106e-01 6.10884592750971289198957947519375e-01 3.54367037302832183984224734274449e-03
        %             1.37321159731595615616228656108433e-01 2.51794247517433122940389012001106e-01 3.54367037302832183984224734274449e-03
        %             1.37321159731595615616228656108433e-01 6.10884592750971289198957947519375e-01 3.54367037302832183984224734274449e-03
        %             6.10884592750971289198957947519375e-01 2.51794247517433122940389012001106e-01 3.54367037302832183984224734274449e-03
        %             6.10884592750971289198957947519375e-01 1.37321159731595615616228656108433e-01 3.54367037302832183984224734274449e-03
        %             3.65034794936327955383603693917394e-01 1.74418264943838295655265113737187e-02 1.57487631404059475435930348652391e-03
        %             3.65034794936327955383603693917394e-01 6.17523378569288183825847227126360e-01 1.57487631404059475435930348652391e-03
        %             1.74418264943838295655265113737187e-02 3.65034794936327955383603693917394e-01 1.57487631404059475435930348652391e-03
        %             1.74418264943838295655265113737187e-02 6.17523378569288183825847227126360e-01 1.57487631404059475435930348652391e-03
        %             6.17523378569288183825847227126360e-01 3.65034794936327955383603693917394e-01 1.57487631404059475435930348652391e-03
        %             6.17523378569288183825847227126360e-01 1.74418264943838295655265113737187e-02 1.57487631404059475435930348652391e-03
        %             2.57156635550253476196758128935471e-01 8.61981702781003389368663647474023e-02 3.12593497656047953486835311309733e-03
        %             2.57156635550253476196758128935471e-01 6.56645194171646240377526737574954e-01 3.12593497656047953486835311309733e-03
        %             8.61981702781003389368663647474023e-02 2.57156635550253476196758128935471e-01 3.12593497656047953486835311309733e-03
        %             8.61981702781003389368663647474023e-02 6.56645194171646240377526737574954e-01 3.12593497656047953486835311309733e-03
        %             6.56645194171646240377526737574954e-01 2.57156635550253476196758128935471e-01 3.12593497656047953486835311309733e-03
        %             6.56645194171646240377526737574954e-01 8.61981702781003389368663647474023e-02 3.12593497656047953486835311309733e-03
        %             1.24181611934111021944282526874304e-01 3.41126780083469841389764987127364e-03 4.74652661273614420202326957820560e-04
        %             1.24181611934111021944282526874304e-01 8.72407120265054292218565024086274e-01 4.74652661273614420202326957820560e-04
        %             3.41126780083469841389764987127364e-03 1.24181611934111021944282526874304e-01 4.74652661273614420202326957820560e-04
        %             3.41126780083469841389764987127364e-03 8.72407120265054292218565024086274e-01 4.74652661273614420202326957820560e-04
        %             8.72407120265054292218565024086274e-01 1.24181611934111021944282526874304e-01 4.74652661273614420202326957820560e-04
        %             8.72407120265054292218565024086274e-01 3.41126780083469841389764987127364e-03 4.74652661273614420202326957820560e-04
        %             1.71650727809369157972341213280743e-01 4.45555167117895126183135801056778e-02 2.01562604214640178276751747432627e-03
        %             1.71650727809369157972341213280743e-01 7.83793755478841336348239110520808e-01 2.01562604214640178276751747432627e-03
        %             4.45555167117895126183135801056778e-02 1.71650727809369157972341213280743e-01 2.01562604214640178276751747432627e-03
        %             4.45555167117895126183135801056778e-02 7.83793755478841336348239110520808e-01 2.01562604214640178276751747432627e-03
        %             7.83793755478841336348239110520808e-01 1.71650727809369157972341213280743e-01 2.01562604214640178276751747432627e-03
        %             7.83793755478841336348239110520808e-01 4.45555167117895126183135801056778e-02 2.01562604214640178276751747432627e-03
        %             3.97723109198285573739894971367903e-01 1.22097548884562687177002260341396e-01 4.08610877411519878010803807910634e-03
        %             3.97723109198285573739894971367903e-01 4.80179341917151725205314960476244e-01 4.08610877411519878010803807910634e-03
        %             1.22097548884562687177002260341396e-01 3.97723109198285573739894971367903e-01 4.08610877411519878010803807910634e-03
        %             1.22097548884562687177002260341396e-01 4.80179341917151725205314960476244e-01 4.08610877411519878010803807910634e-03
        %             4.80179341917151725205314960476244e-01 3.97723109198285573739894971367903e-01 4.08610877411519878010803807910634e-03
        %             4.80179341917151725205314960476244e-01 1.22097548884562687177002260341396e-01 4.08610877411519878010803807910634e-03
        %             2.57896645669856483529258639464388e-01 1.95710371236428148922215086713550e-01 4.47932951436091821711960037077915e-03
        %             2.57896645669856483529258639464388e-01 5.46392983093715312037375042564236e-01 4.47932951436091821711960037077915e-03
        %             1.95710371236428148922215086713550e-01 2.57896645669856483529258639464388e-01 4.47932951436091821711960037077915e-03
        %             1.95710371236428148922215086713550e-01 5.46392983093715312037375042564236e-01 4.47932951436091821711960037077915e-03
        %             5.46392983093715312037375042564236e-01 2.57896645669856483529258639464388e-01 4.47932951436091821711960037077915e-03
        %             5.46392983093715312037375042564236e-01 1.95710371236428148922215086713550e-01 4.47932951436091821711960037077915e-03
        %             1.44150074481193601894091216308880e-01 1.83113919798339880307125326908135e-02 1.23104937074616088699130500572210e-03
        %             1.44150074481193601894091216308880e-01 8.37538533538972340686257211928023e-01 1.23104937074616088699130500572210e-03
        %             1.83113919798339880307125326908135e-02 1.44150074481193601894091216308880e-01 1.23104937074616088699130500572210e-03
        %             1.83113919798339880307125326908135e-02 8.37538533538972340686257211928023e-01 1.23104937074616088699130500572210e-03
        %             8.37538533538972340686257211928023e-01 1.44150074481193601894091216308880e-01 1.23104937074616088699130500572210e-03
        %             8.37538533538972340686257211928023e-01 1.83113919798339880307125326908135e-02 1.23104937074616088699130500572210e-03
        %             4.12259561001791008383321468500071e-01 3.26225803520382127975718589141252e-03 7.10646460660964017670704340190468e-04
        %             4.12259561001791008383321468500071e-01 5.84478180963005189418879581353394e-01 7.10646460660964017670704340190468e-04
        %             3.26225803520382127975718589141252e-03 4.12259561001791008383321468500071e-01 7.10646460660964017670704340190468e-04
        %             3.26225803520382127975718589141252e-03 5.84478180963005189418879581353394e-01 7.10646460660964017670704340190468e-04
        %             5.84478180963005189418879581353394e-01 4.12259561001791008383321468500071e-01 7.10646460660964017670704340190468e-04
        %             5.84478180963005189418879581353394e-01 3.26225803520382127975718589141252e-03 7.10646460660964017670704340190468e-04
        %             2.52428464791436324432538640394341e-01 3.47544150731571212936676928961788e-03 6.52578247959340355596746796607022e-04
        %             2.52428464791436324432538640394341e-01 7.44096093701247962570732852327637e-01 6.52578247959340355596746796607022e-04
        %             3.47544150731571212936676928961788e-03 2.52428464791436324432538640394341e-01 6.52578247959340355596746796607022e-04
        %             3.47544150731571212936676928961788e-03 7.44096093701247962570732852327637e-01 6.52578247959340355596746796607022e-04
        %             7.44096093701247962570732852327637e-01 2.52428464791436324432538640394341e-01 6.52578247959340355596746796607022e-04
        %             7.44096093701247962570732852327637e-01 3.47544150731571212936676928961788e-03 6.52578247959340355596746796607022e-04
        %             3.29366927485774507733395921604824e-01 3.53879008258183198887270037857888e-03 7.22954763894363607729109943988988e-04
        %             3.29366927485774507733395921604824e-01 6.67094282431643703645818277436774e-01 7.22954763894363607729109943988988e-04
        %             3.53879008258183198887270037857888e-03 3.29366927485774507733395921604824e-01 7.22954763894363607729109943988988e-04
        %             3.53879008258183198887270037857888e-03 6.67094282431643703645818277436774e-01 7.22954763894363607729109943988988e-04
        %             6.67094282431643703645818277436774e-01 3.29366927485774507733395921604824e-01 7.22954763894363607729109943988988e-04
        %             6.67094282431643703645818277436774e-01 3.53879008258183198887270037857888e-03 7.22954763894363607729109943988988e-04
        %             2.09581481700515409594132165693736e-01 1.88449390557523001332729251089404e-02 1.46729752903976013583831061737328e-03
        %             2.09581481700515409594132165693736e-01 7.71573579243732265986466245522024e-01 1.46729752903976013583831061737328e-03
        %             1.88449390557523001332729251089404e-02 2.09581481700515409594132165693736e-01 1.46729752903976013583831061737328e-03
        %             1.88449390557523001332729251089404e-02 7.71573579243732265986466245522024e-01 1.46729752903976013583831061737328e-03
        %             7.71573579243732265986466245522024e-01 2.09581481700515409594132165693736e-01 1.46729752903976013583831061737328e-03
        %             7.71573579243732265986466245522024e-01 1.88449390557523001332729251089404e-02 1.46729752903976013583831061737328e-03
        %             1.83640169446232209837788218464993e-01 3.63810210869633648272936099488106e-03 5.98229502634915494968526061825287e-04
        %             1.83640169446232209837788218464993e-01 8.12721728445071511792718865763163e-01 5.98229502634915494968526061825287e-04
        %             3.63810210869633648272936099488106e-03 1.83640169446232209837788218464993e-01 5.98229502634915494968526061825287e-04
        %             3.63810210869633648272936099488106e-03 8.12721728445071511792718865763163e-01 5.98229502634915494968526061825287e-04
        %             8.12721728445071511792718865763163e-01 1.83640169446232209837788218464993e-01 5.98229502634915494968526061825287e-04
        %             8.12721728445071511792718865763163e-01 3.63810210869633648272936099488106e-03 5.98229502634915494968526061825287e-04
        %             2.41696232469337524140229334079777e-01 4.57532869613174186795845344022382e-02 2.43675220996146524310432823767769e-03
        %             2.41696232469337524140229334079777e-01 7.12550480569345112691337362775812e-01 2.43675220996146524310432823767769e-03
        %             4.57532869613174186795845344022382e-02 2.41696232469337524140229334079777e-01 2.43675220996146524310432823767769e-03
        %             4.57532869613174186795845344022382e-02 7.12550480569345112691337362775812e-01 2.43675220996146524310432823767769e-03
        %             7.12550480569345112691337362775812e-01 2.41696232469337524140229334079777e-01 2.43675220996146524310432823767769e-03
        %             7.12550480569345112691337362775812e-01 4.57532869613174186795845344022382e-02 2.43675220996146524310432823767769e-03
        %             ];





    case 38

        % SET: SLOBODKINS TAUSCH
        % CARDINALITY RULE  :    263
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 8.327e-16

        XYW=[
    	 	 9.9322962396506143e-01 3.5692820939283907e-03 7.5310708686893304e-05
     	 	 9.7796349731136545e-01 1.8689850935364256e-02 1.7999487037262857e-04
     	 	 9.8014898637106473e-01 2.8752319425381090e-03 1.4363409553715706e-04
     	 	 9.6735057628116572e-01 1.5324440895139098e-02 3.4254302218536851e-04
     	 	 9.5119750240163303e-01 4.5400197703617459e-02 2.8168263843868615e-04
     	 	 9.5459679547014742e-01 3.3290141482963634e-03 2.6267358505841084e-04
     	 	 9.4043705027376534e-01 1.7571459949117726e-02 5.9198289364455323e-04
     	 	 9.1322339208939096e-01 4.3208307763766274e-02 9.6762604876062701e-04
     	 	 9.4365871974344417e-01 3.8513689740283304e-02 5.7806346308121831e-04
     	 	 9.1370482611863035e-01 8.2925204523954743e-02 3.6733354525199179e-04
     	 	 9.1822183341700825e-01 3.5043547213242554e-03 3.7296017606202838e-04
     	 	 9.0525264086965262e-01 1.8277237538290150e-02 8.0291071386495163e-04
     	 	 8.7578616126412323e-01 4.4212696751315145e-02 1.2956497837154177e-03
     	 	 8.7784291311165141e-01 7.9054091852012037e-02 1.2413912580450143e-03
     	 	 9.0936349641507974e-01 7.2886550648314813e-02 7.9985520690919912e-04
     	 	 8.6688578298087082e-01 1.2978776880179690e-01 4.3293021039081061e-04
     	 	 8.7169322544581296e-01 3.3508866246003397e-03 4.4367699786425000e-04
     	 	 8.6188192835559430e-01 1.7715611976306944e-02 9.7289103008184308e-04
     	 	 8.3137668561676337e-01 4.3014830185522261e-02 1.5197835387068112e-03
     	 	 7.0610419354140985e-01 1.1826912397379402e-01 2.7866415176359054e-03
     	 	 8.4034797955219864e-01 8.0800740824459233e-02 1.7059864825591734e-03
     	 	 8.3411509142745000e-01 1.2352393118631888e-01 1.4628582785730442e-03
     	 	 8.6432625781424410e-01 1.1823904777459164e-01 9.9144289543387281e-04
     	 	 8.1289394282179561e-01 1.8374417912462754e-01 4.9041832494012034e-04
     	 	 8.1581159354907573e-01 3.2291612882861241e-03 4.9626788322377666e-04
     	 	 8.0965526107552366e-01 1.6868732762544383e-02 1.0858442323974308e-03
     	 	 7.8082321705387747e-01 4.0703437007771723e-02 1.6203823794630765e-03
     	 	 7.9673469957928256e-01 7.8535375782876213e-02 2.0256154201905101e-03
     	 	 7.5546634206546348e-01 1.2245559691599978e-01 2.2958386794724511e-03
     	 	 7.9479307010393130e-01 1.2757506989776743e-01 2.0685084531872093e-03
     	 	 7.8125403825223039e-01 1.7561876990616693e-01 1.7182029859704484e-03
     	 	 8.0888481591198447e-01 1.7350600532409763e-01 1.1881066141643064e-03
     	 	 7.5236923152880775e-01 3.2650746820134398e-03 5.5737756634347219e-04
     	 	 7.4796304611134512e-01 1.7118710681714323e-02 1.2606963270037355e-03
     	 	 7.2023489131045115e-01 4.2152121800227538e-02 1.8815037466170083e-03
     	 	 7.4581728321974583e-01 7.4570833447292928e-02 2.2768723368788938e-03
     	 	 7.0291262913398667e-01 1.7114238985150976e-01 2.6134708458330296e-03
     	 	 7.3670960266583851e-01 1.8357906423030240e-01 2.5201919898547305e-03
     	 	 7.2234929195336550e-01 2.3392133576454510e-01 1.9022613200381704e-03
     	 	 7.4498690646106458e-01 2.3700581717332384e-01 1.3577245068126954e-03
     	 	 7.5324268252351201e-01 2.4331059716096692e-01 5.5007616844485305e-04
     	 	 6.8306847700636653e-01 3.3437493303508856e-03 6.1474289419843062e-04
     	 	 6.7963304725287710e-01 1.7513620516142196e-02 1.3922108015046685e-03
     	 	 6.5655848641038317e-01 4.2397494185795324e-02 1.9469635374280618e-03
     	 	 6.8010764503828169e-01 7.8122265313278275e-02 2.6967426305294535e-03
     	 	 6.4115222192998567e-01 1.2324551902604687e-01 3.0931627264865090e-03
     	 	 5.7627109525050102e-01 1.8942164504900483e-01 2.3936349322007840e-03
     	 	 6.4785133800343631e-01 1.7185329052206988e-01 3.3944691789446020e-03
     	 	 6.4922306347581726e-01 2.2627230387724034e-01 2.9077995948005087e-03
     	 	 6.7221611010014914e-01 2.4853751681706546e-01 2.7683904301702483e-03
     	 	 6.5862844583186919e-01 2.9882070855862092e-01 2.0699135517341281e-03
     	 	 6.7559066400263124e-01 3.0696349605909012e-01 1.4200550442518595e-03
     	 	 6.8824413427085562e-01 3.0843353722706990e-01 5.7847600545670916e-04
     	 	 6.0935087073009786e-01 3.1441042673075402e-03 6.0956985275468925e-04
     	 	 6.0753562083837287e-01 1.6581623093678170e-02 1.3852810738549397e-03
     	 	 5.9062058878373525e-01 4.0277907733407961e-02 2.0216844199459419e-03
     	 	 6.1313570762110126e-01 7.5948719188720232e-02 2.7035463034127661e-03
     	 	 5.7894484911871436e-01 1.1785168269022520e-01 3.1711678122722095e-03
     	 	 5.8090473201129778e-01 1.6606669785950345e-01 2.0976873391753380e-03
     	 	 5.2232529456072707e-01 2.4475979568590583e-01 3.5300478670992892e-03
     	 	 5.8868493467560190e-01 2.3501989599105333e-01 3.6686185453446512e-03
     	 	 5.8727780293150877e-01 2.9028771097607720e-01 3.2885069257069304e-03
     	 	 6.0301174130078672e-01 3.1984389263683266e-01 2.9309493678980449e-03
     	 	 5.8834636633728921e-01 3.7010548412216887e-01 2.1764408284896627e-03
     	 	 6.0217903865173916e-01 3.8075893385164317e-01 1.4373269969853390e-03
     	 	 6.1772500240583728e-01 3.7900927400378392e-01 6.1127370006253253e-04
     	 	 5.3267959603419346e-01 3.1080899343166055e-03 6.1718982810781938e-04
     	 	 5.3294076610357044e-01 1.6281735449636035e-02 1.3830797096977471e-03
     	 	 5.1784135783977803e-01 3.9863981523776230e-02 2.1483083689953376e-03
     	 	 5.4308573185268272e-01 7.3215806389110696e-02 2.8127852223234447e-03
     	 	 5.0855924906308003e-01 1.1584428199570564e-01 3.4517395744256335e-03
     	 	 5.1752247514808358e-01 1.6634585298981996e-01 3.6671578235006295e-03
     	 	 4.8761136343410372e-01 2.2125363514025606e-01 3.3882937848330134e-03
     	 	 4.6384310730471234e-01 3.0452360682360613e-01 3.5453363459154782e-03
     	 	 5.2175879946073789e-01 3.0468130771683688e-01 3.9617359837232444e-03
     	 	 5.1979452578429508e-01 3.6118668536159759e-01 3.4533845215657475e-03
     	 	 5.2916967175297813e-01 3.9571850545700049e-01 2.9631299426758624e-03
     	 	 5.1401531356186370e-01 4.4543744573341021e-01 2.1960765720377660e-03
     	 	 5.2707415566792548e-01 4.5628011832789844e-01 1.4186996380508611e-03
     	 	 5.4281534010921606e-01 4.5400333732579001e-01 6.2398213480294705e-04
     	 	 4.5507357505624568e-01 3.2329959829240393e-03 6.4072405524126790e-04
     	 	 4.5733584303306918e-01 1.6879629028055548e-02 1.4317478441882097e-03
     	 	 4.4177087466549048e-01 4.1113962781107682e-02 2.2007967227642132e-03
     	 	 4.6709655352817980e-01 7.4087467421482395e-02 2.9641333248991582e-03
     	 	 4.3413022664608980e-01 1.1733523954286142e-01 3.4377534108261856e-03
     	 	 4.4563972465378032e-01 1.6736972846920153e-01 3.9990362077315204e-03
     	 	 4.2667566673664392e-01 2.2500795973537288e-01 3.5407293037826889e-03
     	 	 4.2254920704652055e-01 2.8397557299785253e-01 4.0867016756879499e-03
     	 	 4.1219813698221630e-01 3.6363625725039661e-01 3.4493040597368138e-03
     	 	 4.5398119734020370e-01 3.7798560952470522e-01 3.9017670337996553e-03
     	 	 4.4733500091743517e-01 4.3644187737185458e-01 3.4941402138664707e-03
     	 	 4.5359117772160185e-01 4.7291351919381630e-01 2.8921592603147785e-03
     	 	 4.3857251063097247e-01 5.2149523200188397e-01 2.1432680139675296e-03
     	 	 4.5176854982505177e-01 5.3185095340889976e-01 1.3870946535467568e-03
     	 	 4.6560165132529474e-01 5.3127258308106040e-01 6.2156640736122303e-04
     	 	 3.7866680811207420e-01 3.2953661445523467e-03 6.3388569352033062e-04
     	 	 3.8215500128186042e-01 1.7239013024295011e-02 1.4452279189317893e-03
     	 	 3.6769620438459782e-01 4.2002212626442804e-02 2.1453965095652272e-03
     	 	 3.8856470287216582e-01 7.6168335540434826e-02 3.0319019029287288e-03
     	 	 3.6333288941832431e-01 1.1992522983746944e-01 3.1131572574497500e-03
     	 	 3.7098745271289568e-01 1.6992493459922139e-01 4.0124022748991234e-03
     	 	 3.6598792655784895e-01 2.2717350480412946e-01 3.7711904297953679e-03
     	 	 3.5320116948993663e-01 2.9081500335778426e-01 4.3222710276794914e-03
     	 	 3.6047855052516375e-01 3.5256634204431886e-01 4.4077475307179185e-03
     	 	 3.5200487958477800e-01 4.2378475241279773e-01 3.7668429877925720e-03
     	 	 3.8293216730189195e-01 4.5077609241120875e-01 3.8751431254104448e-03
     	 	 3.7322718332013138e-01 5.1057266856474592e-01 3.4058015937138467e-03
     	 	 3.7876805031731942e-01 5.4738017967282560e-01 2.8076980100179378e-03
     	 	 3.6508076855443339e-01 5.9415559819527097e-01 2.0585110172109998e-03
     	 	 3.7719752367074055e-01 6.0609442109218870e-01 1.3835336295546848e-03
     	 	 3.8845489121282306e-01 6.0836976716191593e-01 6.2103050233475946e-04
     	 	 3.0563859637412871e-01 3.3266705462196150e-03 6.0273382317487737e-04
     	 	 3.0881548030141237e-01 1.7435267333177438e-02 1.4097325232046095e-03
     	 	 2.9910111224615787e-01 4.2438964517245152e-02 1.9589284602440781e-03
     	 	 3.1211581664743293e-01 7.7452283277654840e-02 2.9611702334035356e-03
     	 	 3.0207620477861541e-01 1.2163422737135370e-01 2.7545907720097321e-03
     	 	 2.9738459741918699e-01 1.7248639658266526e-01 3.7965915984642068e-03
     	 	 3.0210303440988795e-01 2.2640200309919736e-01 3.5738463502464949e-03
     	 	 2.9310202205742708e-01 2.7802886057005843e-01 2.7467467337635443e-03
     	 	 2.8169941834126200e-01 3.1105499671265041e-01 2.0553150399514634e-03
     	 	 2.9129047798309260e-01 3.5895133031593535e-01 4.1142204201348662e-03
     	 	 2.9347594096699658e-01 4.2026520521538174e-01 4.1072503349519236e-03
     	 	 2.8928993824031823e-01 4.8460036765235603e-01 3.5761507926817811e-03
     	 	 3.1168887758951147e-01 5.1900692066603726e-01 3.7399868381677841e-03
     	 	 3.0185486566291797e-01 5.7801830510810159e-01 3.2096092240588162e-03
     	 	 3.0572043955632333e-01 6.1744844291658962e-01 2.8009658299411968e-03
     	 	 2.9680566077928050e-01 6.6077627288619178e-01 1.9578204622586245e-03
     	 	 3.0522410789799626e-01 6.7737020591878694e-01 1.3656259354030513e-03
     	 	 3.1369691357637242e-01 6.8298893504889202e-01 6.1829766915850754e-04
     	 	 2.3780612802252699e-01 3.1399724603201149e-03 5.2212306170489964e-04
     	 	 2.3928665827723516e-01 1.6627774512027134e-02 1.2615390862742713e-03
     	 	 2.3811821823535106e-01 4.0619991534306781e-02 1.7074937223553906e-03
     	 	 2.4028688624234118e-01 7.5979808330581905e-02 2.7504031015717972e-03
     	 	 2.4445643590259192e-01 1.2058268983222015e-01 2.8959553323668792e-03
     	 	 2.2996014353411487e-01 1.7446559281679652e-01 3.6895852606115397e-03
     	 	 2.3637505027241090e-01 2.3466360093069769e-01 4.0045601411051786e-03
     	 	 2.2729916603667832e-01 2.9907476858031795e-01 3.7617821183494379e-03
     	 	 2.2572826828433645e-01 3.6350681306680355e-01 3.7095593590676340e-03
     	 	 2.2793540779181709e-01 4.2278829280501107e-01 3.6734261594641190e-03
     	 	 2.2992690998665877e-01 4.7947773902575314e-01 3.5249539496945005e-03
     	 	 2.2916119334773111e-01 5.3764878892397616e-01 3.3626835075145933e-03
     	 	 2.4253445964538145e-01 5.8257473526319625e-01 3.6293255579680039e-03
     	 	 2.3639586121692757e-01 6.4020026059285573e-01 3.0406688255454465e-03
     	 	 2.3640277220161865e-01 6.8486414194362222e-01 2.6883619256348962e-03
     	 	 2.3483052921847269e-01 7.2212241496159479e-01 1.8070976834296737e-03
     	 	 2.3814128987807048e-01 7.4413619283631449e-01 1.2798116901768341e-03
     	 	 2.4346174015312427e-01 7.5315684491992818e-01 5.8359148559421637e-04
     	 	 1.7653952490150504e-01 3.5072136953935621e-03 5.1756962601687522e-04
     	 	 1.7599739898030664e-01 1.8179652971833167e-02 1.2059529811895831e-03
     	 	 1.8246816507305219e-01 4.3783795177509327e-02 1.6617025546111271e-03
     	 	 1.7546161922209502e-01 7.8703446538223254e-02 2.3806664133687494e-03
     	 	 1.8597587937952431e-01 1.2203968684432157e-01 2.7727510246653114e-03
     	 	 1.6936667890938928e-01 1.7380935637365186e-01 3.1471663182587786e-03
     	 	 1.7527625530923885e-01 2.3396481238535352e-01 3.6927574302447475e-03
     	 	 1.7138187315017028e-01 3.0105162854781142e-01 3.7770389119615709e-03
     	 	 1.6912481669305013e-01 3.7340137965899162e-01 3.9426888296640282e-03
     	 	 1.6866522396753036e-01 4.4686577325043014e-01 4.0213896631943287e-03
     	 	 1.7107352500773632e-01 5.1663843152267352e-01 3.8804601236068210e-03
     	 	 1.7290474633586395e-01 5.8287444121379650e-01 3.5145911258862555e-03
     	 	 1.7974383078867417e-01 6.3864146795477028e-01 3.4276521248886487e-03
     	 	 1.7696854960818831e-01 6.9583166089367088e-01 2.8691054771908782e-03
     	 	 1.7349324322652815e-01 7.4562123927826507e-01 2.4611277636511003e-03
     	 	 1.7839159650340852e-01 7.7738843403179669e-01 1.7009122240984290e-03
     	 	 1.7715976754857221e-01 8.0470711811239215e-01 1.1760262304729740e-03
     	 	 1.7960022655881780e-01 8.1694508312290071e-01 5.3195932142621532e-04
     	 	 1.2268653870774426e-01 3.2675991153354798e-03 4.1886212137481660e-04
     	 	 1.2093615635845967e-01 1.7312226147522418e-02 9.9295634322423714e-04
     	 	 1.2952445712412952e-01 4.2811884843502276e-02 1.5569172048334264e-03
     	 	 1.2010184912601896e-01 7.8561388268261340e-02 2.0442559149145777e-03
     	 	 1.3012543542681354e-01 1.2303242429625059e-01 2.5103794771868682e-03
     	 	 1.1697127084617742e-01 1.7199285187181712e-01 2.3366957099864231e-03
     	 	 1.2152644927415190e-01 2.2317161435407282e-01 2.6607471181302805e-03
     	 	 1.2064038283070977e-01 2.8130461906603810e-01 3.0659979551846900e-03
     	 	 1.1951014015021111e-01 3.4954672905022011e-01 3.3907632011524508e-03
     	 	 1.1785480291543404e-01 4.2381959116195822e-01 3.5133420610445306e-03
     	 	 1.1736804669899503e-01 4.9794527204660338e-01 3.4529473288589935e-03
     	 	 1.1976024051122414e-01 5.6698169280731292e-01 3.3120852041273194e-03
     	 	 1.2205634294049394e-01 6.3266133674074010e-01 3.1356920912522794e-03
     	 	 1.2514398688400485e-01 6.9228424393771415e-01 3.0043688952883984e-03
     	 	 1.2365354771767056e-01 7.4967212751572698e-01 2.5594883342172354e-03
     	 	 1.1896545840628803e-01 8.0128778208170748e-01 2.0832943620142470e-03
     	 	 1.2713194685163465e-01 8.2943166299996718e-01 1.5093567166862855e-03
     	 	 1.2346255554999341e-01 8.5878220152760165e-01 9.9591532210250959e-04
     	 	 1.2385088838694847e-01 8.7276448028983056e-01 4.4452346397294996e-04
     	 	 7.7210641564932847e-02 3.3450786193712900e-03 3.4937855641881143e-04
     	 	 7.5752629005042094e-02 1.7367366353022325e-02 7.7096468709757140e-04
     	 	 8.2876877288560080e-02 4.1949613585565031e-02 1.2702431650898328e-03
     	 	 7.5113591724726092e-02 7.6523687998115902e-02 1.5845156124874615e-03
     	 	 8.1570212996487146e-02 1.2203075802137811e-01 2.1634734477716769e-03
     	 	 7.5353087350045644e-02 1.7767442166304959e-01 2.2696292436355536e-03
     	 	 7.6475321411259789e-02 2.4142980699730443e-01 2.7337547346288509e-03
     	 	 7.6504033755500744e-02 3.1300885607673534e-01 2.9315439390947221e-03
     	 	 7.5839985776125829e-02 3.8938045017499689e-01 3.0246983845600298e-03
     	 	 7.4510999425221436e-02 4.6811314846339797e-01 3.0075394010955561e-03
     	 	 7.4387979593526943e-02 5.4499668779311894e-01 2.9218506779502313e-03
     	 	 7.6704444136184269e-02 6.1675017210003324e-01 2.8141471267937443e-03
     	 	 7.8170510655606540e-02 6.8439908506525193e-01 2.6404298638083657e-03
     	 	 7.9378296168273077e-02 7.4514463066381309e-01 2.3835810447112313e-03
     	 	 7.8297115274564066e-02 7.9979561201536875e-01 1.9845315381129894e-03
     	 	 7.3810460448177073e-02 8.4869698978236707e-01 1.5781170661574695e-03
     	 	 8.2217042893769743e-02 8.7494968097286974e-01 1.2474382340813472e-03
     	 	 7.8224175622558567e-02 9.0408804039442725e-01 8.0506150323107989e-04
     	 	 7.7535739852136798e-02 9.1908052954552377e-01 3.5740077518528718e-04
     	 	 4.1449429793184556e-02 3.1565198956460300e-03 2.4753886312052059e-04
     	 	 4.1317322973011494e-02 1.6788603034490028e-02 5.6130646719082012e-04
     	 	 4.4924574014180818e-02 4.1617235930820701e-02 9.8118009085768000e-04
     	 	 4.0719738648475001e-02 7.6844387012875548e-02 1.1548067287990762e-03
     	 	 4.4340687343512264e-02 1.2013360392067703e-01 1.4885393741160640e-03
     	 	 4.2069841463271862e-02 1.6917760864192424e-01 1.5319644625033310e-03
     	 	 4.1209052070346974e-02 2.2606447336544402e-01 1.8124754179174329e-03
     	 	 4.1814519438910680e-02 2.9059171042674969e-01 2.0373124719899934e-03
     	 	 4.1681509137032058e-02 3.6192914595631986e-01 2.1893365744803119e-03
     	 	 4.1232876301054877e-02 4.3704354299738646e-01 2.2216992463067707e-03
     	 	 4.0377382231328807e-02 5.1316320087853828e-01 2.1658681774635469e-03
     	 	 4.0696144607704432e-02 5.8552243092511347e-01 2.0391532432974743e-03
     	 	 4.2178120542843645e-02 6.5241245369896261e-01 1.9900848938471370e-03
     	 	 4.2749830810673295e-02 7.1680859365560923e-01 1.9233402973036467e-03
     	 	 4.3248314741717975e-02 7.7732804631000441e-01 1.8054468666334918e-03
     	 	 4.2840431155135139e-02 8.3259189226407204e-01 1.5563492729118917e-03
     	 	 3.9539683987161123e-02 8.8242799284866724e-01 1.2141718997747079e-03
     	 	 4.5225244485938676e-02 9.1314373937527105e-01 9.8135265575800650e-04
     	 	 4.2593103517679420e-02 9.4073429497758709e-01 5.8292778959319477e-04
     	 	 4.1643122362882590e-02 9.5523257178946375e-01 2.4473010895500471e-04
     	 	 1.6613173707260009e-02 3.4930317435595704e-03 1.7078844133287040e-04
     	 	 1.7236009128704488e-02 1.8007912996387845e-02 3.7903600399691957e-04
     	 	 1.8319725311087942e-02 4.2605998810315300e-02 6.1160496231998874e-04
     	 	 1.6770197337038439e-02 7.6692326838116678e-02 7.2796995729998350e-04
     	 	 1.7995546740121049e-02 1.2048213226940606e-01 9.9996356846417957e-04
     	 	 1.7494726703878971e-02 1.7448163529938798e-01 1.1467117059978061e-03
     	 	 1.6794514165983099e-02 2.3730293522339102e-01 1.2600664043126337e-03
     	 	 1.7223147499744185e-02 3.0605831186448113e-01 1.3822968493312248e-03
     	 	 1.7083940337143222e-02 3.7948478973367872e-01 1.4454608632853332e-03
     	 	 1.6966384326027373e-02 4.5549477917204784e-01 1.4605939091463277e-03
     	 	 1.6483425669181484e-02 5.3262204716795591e-01 1.4339341602252198e-03
     	 	 1.6778665321280695e-02 6.0882679850799859e-01 1.4263833605441081e-03
     	 	 1.7391124990323248e-02 6.8219016715841285e-01 1.4047942036276061e-03
     	 	 1.7628086823265887e-02 7.5067978585267636e-01 1.2927210994169815e-03
     	 	 1.7720246216182511e-02 8.1158190927204543e-01 1.1313895027598422e-03
     	 	 1.7604270044790482e-02 8.6335424811692207e-01 9.2193172965119858e-04
     	 	 1.5583086948504188e-02 9.0720723919475499e-01 6.7724094372043845e-04
     	 	 1.8775918492070054e-02 9.3754066022956206e-01 6.2322361673012726e-04
     	 	 1.7594239296867098e-02 9.6385093554201962e-01 4.0355168104836759e-04
     	 	 1.6840139483125793e-02 9.7955639930068250e-01 1.7693140255764866e-04
     	 	 3.0905357219509488e-03 3.1569340144588856e-03 6.5064932025377909e-05
     	 	 3.3298385378954798e-03 1.6995478537334813e-02 1.6698400904919009e-04
     	 	 3.4474333138685420e-03 4.2524881240277021e-02 2.7802512313932583e-04
     	 	 3.2412982548370994e-03 7.9526913785153364e-02 3.5092750839873550e-04
     	 	 3.4167770699760069e-03 1.2667674964893191e-01 4.5411862756470663e-04
     	 	 3.3454252302029808e-03 1.8253365438069685e-01 5.1001671559044049e-04
     	 	 3.1794403245278824e-03 2.4520099240274215e-01 5.3368363439565772e-04
     	 	 3.3002457217707892e-03 3.1277405078806236e-01 5.8892729406006508e-04
     	 	 3.2491469005946350e-03 3.8412923272042543e-01 6.0626241931563993e-04
     	 	 3.2534098929842825e-03 4.5774681775970116e-01 6.1846715673102566e-04
     	 	 3.1365795187824341e-03 5.3223491112520205e-01 5.9949695415653648e-04
     	 	 3.1855521737224057e-03 6.0646809259992041e-01 6.0270588249582992e-04
     	 	 3.2984936721675018e-03 6.7922035882576626e-01 6.0476739452074732e-04
     	 	 3.3638782216057761e-03 7.4874087307277515e-01 5.8010084327067037e-04
     	 	 3.3704291250681306e-03 8.1308963627032771e-01 5.2754862909681780e-04
     	 	 3.3771071029411459e-03 8.7007065313508336e-01 4.5515806693824054e-04
     	 	 2.9579623190312265e-03 9.1816043844241624e-01 3.2407668892959915e-04
     	 	 3.5624400591190986e-03 9.5456120558234259e-01 2.8512550758489280e-04
     	 	 3.3455641702828665e-03 9.8007894006188701e-01 1.6579259870845383e-04
     	 	 3.1634453444664423e-03 9.9379176161196681e-01 6.4251611633122898e-05
     	 	 ];


    case 39

        % SET: SLOBODKINS TAUSCH
        % CARDINALITY RULE  :    276
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 9.116e-16

        XYW=[
    	 	 9.9300188846274351e-01 3.3860378975488488e-03 8.0047377983163487e-05
     	 	 9.7928072952475453e-01 1.7507346951128357e-02 1.6013161139295142e-04
     	 	 9.7775552655468212e-01 3.3491431439304246e-03 1.8339272031821970e-04
     	 	 9.6515111374573825e-01 1.7908196118022288e-02 3.9540486512036524e-04
     	 	 9.5495611318289764e-01 4.1897882553040937e-02 2.3616705582133382e-04
     	 	 9.5098582093619011e-01 2.8251349065536802e-03 2.3837292246638663e-04
     	 	 9.4307770555566561e-01 1.4844087717169283e-02 5.0552546276821724e-04
     	 	 9.2342030097364758e-01 3.6146211704138287e-02 7.6239626225443598e-04
     	 	 9.3900234076055478e-01 4.4504519576580831e-02 6.0597540980433871e-04
     	 	 9.2072977222765018e-01 7.6090900698582653e-02 3.1877238962575239e-04
     	 	 9.1281231465832202e-01 2.8351177592045107e-03 3.1586228818787469e-04
     	 	 9.0733604705072024e-01 1.5105291734279009e-02 7.0553221641892177e-04
     	 	 8.8788084328304662e-01 3.7527080946322490e-02 1.0675492760135884e-03
     	 	 8.9223447080969942e-01 6.7743818313940843e-02 1.0496903067171795e-03
     	 	 9.0045269162435704e-01 8.2917697041643992e-02 8.2067289126146442e-04
     	 	 8.7657626800490229e-01 1.2024891669160161e-01 4.0018961499680182e-04
     	 	 8.6482407472569867e-01 2.9746646828824452e-03 3.9592573765993031e-04
     	 	 8.6169849159809264e-01 1.5234963146949521e-02 8.4958225626753224e-04
     	 	 8.4493274714923150e-01 3.6678007175019331e-02 1.2548875135715354e-03
     	 	 8.1817083393857304e-01 6.7883545184759059e-02 1.6743360495975286e-03
     	 	 8.5883409377779518e-01 6.8737428245706209e-02 1.2678677493256193e-03
     	 	 8.1899408714222099e-01 1.0552406896925012e-01 1.5609932074681957e-03
     	 	 8.4841630153322622e-01 1.1074705633155742e-01 1.4283582374761167e-03
     	 	 8.5136289596036652e-01 1.3193574118515469e-01 1.0190839921497225e-03
     	 	 8.2265479231496652e-01 1.7416143080191809e-01 4.7733914465588115e-04
     	 	 8.0875676050439571e-01 3.2101329884229113e-03 4.9071936289065169e-04
     	 	 8.0602395275885685e-01 1.6812968295539899e-02 1.1179795990672720e-03
     	 	 7.8976298602528072e-01 4.1046473578293864e-02 1.6129122372390619e-03
     	 	 7.6250016851694524e-01 7.4398135061483295e-02 1.9856456517622152e-03
     	 	 7.7042483809859286e-01 1.1047770844083971e-01 2.2986890494413391e-03
     	 	 7.7634811313569407e-01 1.4935472261612592e-01 1.8798742553619097e-03
     	 	 7.9490793644778845e-01 1.6453970629486331e-01 1.6908307401921150e-03
     	 	 7.9297643010567487e-01 1.9038732171453640e-01 1.1687381841864694e-03
     	 	 7.6014304249175824e-01 2.3670183291901623e-01 5.3438077093773714e-04
     	 	 7.4601881798689262e-01 3.1198409085086394e-03 5.2440168257741199e-04
     	 	 7.4353519202552820e-01 1.6370781551282430e-02 1.2169995043136385e-03
     	 	 7.3226666231171755e-01 3.9698632584851012e-02 1.7368985483137088e-03
     	 	 7.0599743306643092e-01 7.2394182264275297e-02 2.2799315328136329e-03
     	 	 7.1331049823970571e-01 1.0939522497369403e-01 1.7355932256953996e-03
     	 	 6.9794359105836290e-01 1.3594869450915442e-01 1.9019453215008619e-03
     	 	 7.2040246126353824e-01 1.6305730590034748e-01 2.6486075039098096e-03
     	 	 7.2192527267584761e-01 2.0405310077344802e-01 2.2863049003955865e-03
     	 	 7.3253773713920611e-01 2.2706828913819704e-01 1.9065017893765679e-03
     	 	 7.2748236838319924e-01 2.5595638472942867e-01 1.2756203349930616e-03
     	 	 7.0659789998038458e-01 2.8992721916991271e-01 7.7722645742927241e-05
     	 	 6.7824656990760912e-01 3.1533994779813683e-03 5.6320046187765497e-04
     	 	 6.7460512838143383e-01 1.6493040676272358e-02 1.3266087484572722e-03
     	 	 6.6743923207778755e-01 4.0153522549526324e-02 1.9198768828990196e-03
     	 	 6.4066819610413794e-01 7.3303894244385021e-02 2.5236606631252002e-03
     	 	 6.5095040192274878e-01 1.1390260250885849e-01 2.8649047983369163e-03
     	 	 6.1836567040426793e-01 1.6098547644410854e-01 2.9256481654912746e-03
     	 	 6.4965850183740925e-01 1.8409904045710387e-01 2.9694407381680690e-03
     	 	 5.8928172771385801e-01 2.4445033707080718e-01 3.4318650166160554e-03
     	 	 6.5924688321305236e-01 2.2448791118259040e-01 3.0300388124483899e-03
     	 	 6.5803644655818294e-01 2.6840271410219962e-01 2.5906310036929513e-03
     	 	 6.6358924650836992e-01 2.9638375162254660e-01 2.0533476053181112e-03
     	 	 6.5710873735519504e-01 3.2653302428777020e-01 1.3301546566905935e-03
     	 	 6.8761399215653651e-01 3.0929785683149796e-01 5.2182801208469306e-04
     	 	 6.0705724582449450e-01 3.0320381489321005e-03 5.6495027458278559e-04
     	 	 6.0129496497107515e-01 1.5998547125103704e-02 1.3618832147728967e-03
     	 	 5.9853581412486490e-01 3.9253214599250012e-02 2.0104458122264467e-03
     	 	 5.7248017793601491e-01 7.2147584868946693e-02 2.6695434330501161e-03
     	 	 5.8283865346559272e-01 1.1520163210821556e-01 3.2089856035368240e-03
     	 	 5.5445682332982371e-01 1.6510603578783720e-01 3.3797409060828255e-03
     	 	 5.6053699033345539e-01 2.1625056200888595e-01 3.5271972591867065e-03
     	 	 5.2674536192953414e-01 3.1020932434337800e-01 3.3026567813491769e-03
     	 	 5.9176695978653937e-01 2.9295728585409742e-01 3.2820115286200644e-03
     	 	 5.8759270772434613e-01 3.3977199743950731e-01 2.7678098847425960e-03
     	 	 5.9029846366771466e-01 3.7023282139985236e-01 2.1156475034475176e-03
     	 	 5.8459790023233604e-01 3.9926317200655725e-01 1.3207717232521445e-03
     	 	 6.1416963382768430e-01 3.8272551677738148e-01 6.0758747299275535e-04
     	 	 5.3344429209084598e-01 3.0965650836621635e-03 5.9006719437313087e-04
     	 	 5.2528828105919190e-01 1.6152667222213438e-02 1.3828120356923523e-03
     	 	 5.2606220195161146e-01 3.9107814234492153e-02 2.0503062132672034e-03
     	 	 5.0013321248425369e-01 7.1340591988542978e-02 2.7009579656300385e-03
     	 	 5.1434413265768275e-01 1.1246910384746305e-01 3.1567773381013021e-03
     	 	 4.9006766654847556e-01 1.5945414972635788e-01 3.3292062561734500e-03
     	 	 4.8670537837487593e-01 2.0152399313240665e-01 1.8287381204801730e-03
     	 	 4.9179897833617026e-01 2.3099409598462298e-01 3.2035673601620617e-03
     	 	 4.9987819841210313e-01 2.8180398338016704e-01 3.8164291856319153e-03
     	 	 4.7080116172683006e-01 3.6850831165339443e-01 2.6308760493873361e-03
     	 	 5.2011834678085811e-01 3.6724263648594091e-01 3.3693206347374456e-03
     	 	 5.1296524133273658e-01 4.1634832785320358e-01 2.8244738656180769e-03
     	 	 5.1523166174945900e-01 4.4644542596249109e-01 2.0686225089160035e-03
     	 	 5.1270310567507571e-01 4.7170100197410908e-01 1.2595843077710584e-03
     	 	 5.3665785592058846e-01 4.6034538658813462e-01 6.0248023008657291e-04
     	 	 4.5854524964456156e-01 3.0621788405852954e-03 5.9040631262649015e-04
     	 	 4.4931855175173119e-01 1.6089209776716303e-02 1.3675030191444332e-03
     	 	 4.5118175313899467e-01 3.9224926517778154e-02 2.1051893117292621e-03
     	 	 4.2618251997679801e-01 7.1804874690945750e-02 2.6989872622940549e-03
     	 	 4.4306407297880590e-01 1.1199206912181715e-01 3.1864932583328632e-03
     	 	 4.2092016961981460e-01 1.5900282586701003e-01 3.3902024937493107e-03
     	 	 4.2127270164544683e-01 2.0604410901811876e-01 2.8356959180373888e-03
     	 	 4.1962900041509477e-01 2.4380538501511589e-01 2.8535669731371803e-03
     	 	 4.3091619920849800e-01 2.9320238072984495e-01 3.8639086273795594e-03
     	 	 4.3272662489209901e-01 3.5157207482760461e-01 4.0580747407963401e-03
     	 	 4.2257200186737875e-01 4.1833052049039332e-01 2.7550858434336129e-03
     	 	 4.4646579374455175e-01 4.4301202283935559e-01 3.3454747021480075e-03
     	 	 4.3629313390516034e-01 4.9403103675193427e-01 2.7918210142560407e-03
     	 	 4.4138576908060656e-01 5.2079228439660652e-01 1.9751260772707265e-03
     	 	 4.4184361580370413e-01 5.4264853608552710e-01 1.2340713975064472e-03
     	 	 4.5812517406806130e-01 5.3893734114529657e-01 5.9020884519304841e-04
     	 	 3.8367269290142758e-01 3.0897936746078218e-03 5.8753858314222534e-04
     	 	 3.7543361675709574e-01 1.6172824251490903e-02 1.3112144935802828e-03
     	 	 3.7622239953588521e-01 3.9322306240566353e-02 2.0857509332699825e-03
     	 	 3.5441589533660611e-01 7.2234417207182336e-02 2.6256254270125810e-03
     	 	 3.6995861217465698e-01 1.1372054422918369e-01 3.2932654201133661e-03
     	 	 3.5228060299188313e-01 1.6347918646735202e-01 3.4999909300154662e-03
     	 	 3.5299284865783098e-01 2.1785575609866120e-01 3.8562301774461411e-03
     	 	 3.4547214671261028e-01 2.7408179980480923e-01 3.2644685155072649e-03
     	 	 3.7300549263310878e-01 2.9878705671871192e-01 2.5677721514605566e-03
     	 	 3.6569412199861950e-01 3.6155243502195067e-01 3.9789918790531578e-03
     	 	 3.0339595119413432e-01 4.2418169428572011e-01 3.5892158833809337e-03
     	 	 3.6354848477322477e-01 4.2406933952218279e-01 4.0270784616683736e-03
     	 	 3.6447326500725341e-01 4.7764254020887009e-01 3.1321764565355845e-03
     	 	 3.7252695860788254e-01 5.1671890666848319e-01 3.2057994331143730e-03
     	 	 3.6050834239316376e-01 5.6793546521602012e-01 2.6429703161060321e-03
     	 	 3.6934093193726092e-01 5.9106359426655752e-01 1.9630145189579902e-03
     	 	 3.7169152873215361e-01 6.1182944347873480e-01 1.2727428624686357e-03
     	 	 3.8083904762170084e-01 6.1601906627277792e-01 6.0905876773459085e-04
     	 	 3.1080587241309787e-01 3.0500820371779759e-03 5.5732901652114997e-04
     	 	 3.0560898472107223e-01 1.6076069733317877e-02 1.2320589217791359e-03
     	 	 3.0319889665679589e-01 3.9501376489153785e-02 2.0290925246571065e-03
     	 	 2.8692710583340530e-01 7.2995455267878678e-02 2.4629293723923292e-03
     	 	 2.9915445349901004e-01 1.1522639628069452e-01 3.2215898623913445e-03
     	 	 2.8742853385276512e-01 1.6625262310487848e-01 3.4294196292584457e-03
     	 	 2.8520142718683028e-01 2.2399789447974772e-01 3.9817920066693904e-03
     	 	 2.8394210963792843e-01 2.8695582606331643e-01 3.9779628657318133e-03
     	 	 2.6811489627091378e-01 3.5042186410276871e-01 3.0904181359450527e-03
     	 	 3.1723210634322130e-01 3.4644040417702443e-01 3.3980971006694833e-03
     	 	 2.6477623293061125e-01 4.1184558985952374e-01 2.9556429940084008e-03
     	 	 2.4627314191725880e-01 4.8500198378606774e-01 2.2933317517647113e-03
     	 	 2.9388368026944178e-01 4.8983290097481486e-01 3.7299414398923171e-03
     	 	 3.0207021303394166e-01 5.3475587655705159e-01 3.1675543791508166e-03
     	 	 2.9955141342103975e-01 5.8551562843686689e-01 3.2431229817160095e-03
     	 	 2.8996062739548767e-01 6.3700054864779898e-01 2.6049359482625358e-03
     	 	 2.9966358424635586e-01 6.6112818290529396e-01 1.9583046409625288e-03
     	 	 3.0403790903118411e-01 6.8018943628525452e-01 1.1981080935280183e-03
     	 	 3.0722674709919218e-01 6.8977766704691912e-01 5.4932874945671356e-04
     	 	 2.4199990695494022e-01 3.3110906503792843e-03 5.5921199769847082e-04
     	 	 2.4029906882720387e-01 1.7283283612032539e-02 1.2075758394475792e-03
     	 	 2.3412124489136721e-01 4.1500296085006598e-02 1.9082619700942134e-03
     	 	 2.2494458448323462e-01 7.5097435184898850e-02 2.1787959610643759e-03
     	 	 2.3284032288028422e-01 1.1569835153692101e-01 2.8436213441169695e-03
     	 	 2.2693693433232054e-01 1.6368135807795242e-01 3.0339427753756617e-03
     	 	 2.2239497824449073e-01 2.1949025474663875e-01 3.5849125028924846e-03
     	 	 2.2291593075841565e-01 2.8287134453040852e-01 3.9361732930511383e-03
     	 	 2.1558174350585568e-01 3.5099248906603936e-01 3.7954169676606467e-03
     	 	 2.1300240380267954e-01 4.2053457282604212e-01 3.6412382830736450e-03
     	 	 2.1296315225162787e-01 4.8578183693161242e-01 2.9871798586535206e-03
     	 	 2.2596202331977400e-01 5.4909970949018894e-01 3.4977002789305287e-03
     	 	 2.3945552498221501e-01 5.9167274710541717e-01 3.3290012052824025e-03
     	 	 2.3165332740043088e-01 6.4962052430091000e-01 3.0291562435949509e-03
     	 	 2.2497936256735718e-01 6.9810894403702894e-01 2.3381918832593171e-03
     	 	 2.3295109858853169e-01 7.2447211480132634e-01 1.8845790165294529e-03
     	 	 2.3902926535045621e-01 7.4326659442378773e-01 1.2412289835316674e-03
     	 	 2.3850779271741762e-01 7.5810826568452772e-01 5.6912300474226620e-04
     	 	 1.7940176461006963e-01 3.1178325581492816e-03 4.7275404168230532e-04
     	 	 1.8050776107420630e-01 1.6544812948214575e-02 1.0773013923392762e-03
     	 	 1.7224730050445003e-01 4.0903360033083695e-02 1.7374671533278495e-03
     	 	 1.6989101924174932e-01 7.6321439944119412e-02 2.1454975747267507e-03
     	 	 1.7192860582502456e-01 1.2170946703073898e-01 2.8447454964853304e-03
     	 	 1.7000590100579560e-01 1.7598017486543072e-01 3.0734362686261926e-03
     	 	 1.5792992778752146e-01 2.2647431821334657e-01 1.6085363101646820e-03
     	 	 1.6918153568546856e-01 2.4862177633693688e-01 2.3601860500039092e-03
     	 	 1.6440685603367033e-01 3.0846160698862612e-01 3.5149616477127567e-03
     	 	 1.6124840020590980e-01 3.7565531214934739e-01 3.4009790676049374e-03
     	 	 1.6153564690360622e-01 5.0495029625400178e-01 3.2257946036821430e-03
     	 	 1.6896532656078445e-01 5.6223866264605860e-01 3.2244163357398989e-03
     	 	 1.7036488927015236e-01 6.1546542615674182e-01 2.6829627321755395e-03
     	 	 1.7979281894217136e-01 6.5451965561086434e-01 2.8156669046424509e-03
     	 	 1.6876942319757071e-01 7.1304532143025479e-01 2.7034030402730710e-03
     	 	 1.6802795653198366e-01 7.5712071795039693e-01 2.0997350235324552e-03
     	 	 1.7333775287764419e-01 7.8604216496543333e-01 1.6587219152645371e-03
     	 	 1.7902862020620891e-01 8.0440157249906630e-01 1.0772684284171136e-03
     	 	 1.7632952263399437e-01 8.2054262689649871e-01 4.6937871297540864e-04
     	 	 1.2459191763834576e-01 3.2231178530440240e-03 4.1501984323406653e-04
     	 	 1.2686071770191687e-01 1.6626883711055758e-02 9.2325325335852499e-04
     	 	 1.1836505892262994e-01 3.9429205990552177e-02 1.3377390082023554e-03
     	 	 1.1990552879481997e-01 7.0960500877096641e-02 1.7078603108542359e-03
     	 	 1.1940720997874765e-01 1.1257859416136132e-01 2.2438824222552087e-03
     	 	 1.1935333514653335e-01 1.6401839552441233e-01 2.6863931928042448e-03
     	 	 1.1408967148825389e-01 2.2458546228409568e-01 2.9069687813371419e-03
     	 	 1.1533409219815016e-01 2.9213589163306597e-01 3.2838524302457196e-03
     	 	 1.1341596385030717e-01 3.6500172236337175e-01 3.3463480661975607e-03
     	 	 1.1216456516829221e-01 4.3977329645836516e-01 3.3351817212705676e-03
     	 	 1.6041452017615498e-01 4.4103622382045804e-01 3.2967775340765519e-03
     	 	 1.1314673378876894e-01 5.1291673360722068e-01 3.2735650194178042e-03
     	 	 1.1647221708988065e-01 5.8347817948515734e-01 3.3074556383437667e-03
     	 	 1.1955316619941303e-01 6.4829150158428328e-01 3.0628304634456802e-03
     	 	 1.2409877843744432e-01 7.0612090737121069e-01 2.9072958088772775e-03
     	 	 1.1572785803006791e-01 7.6765048468236496e-01 2.3463780817764095e-03
     	 	 1.1803709741594381e-01 8.0876557537177651e-01 1.7815980874100396e-03
     	 	 1.2060728349627958e-01 8.3959459302071482e-01 1.3876551959079676e-03
     	 	 1.2527485524622717e-01 8.5837846880439261e-01 9.2023986968337859e-04
     	 	 1.2220768467804155e-01 8.7465942423364063e-01 3.9812095739691393e-04
     	 	 7.8872194907674387e-02 3.0236069828739331e-03 3.1854863610220589e-04
     	 	 8.0583572490033339e-02 1.6203182281144753e-02 7.7826243023020904e-04
     	 	 7.4319104919963519e-02 4.0593316528806628e-02 1.1750032470987017e-03
     	 	 7.6544186801697944e-02 7.5771070176902447e-02 1.5792426861359638e-03
     	 	 7.5718742669244277e-02 1.2000441830362214e-01 1.8600014503028764e-03
     	 	 7.5667345761593841e-02 1.6991146993394798e-01 2.0360120552062617e-03
     	 	 7.2527595617397966e-02 2.2322885235674370e-01 2.0495353316735783e-03
     	 	 7.3037958193784558e-02 2.8198658826708772e-01 2.3853414526079251e-03
     	 	 7.2492138102041359e-02 3.4863559204732197e-01 2.6274555025916739e-03
     	 	 7.1491644726338510e-02 4.2176363657294175e-01 2.7590420620759743e-03
     	 	 7.1281448672198544e-02 4.9714190325939411e-01 2.7765649454731529e-03
     	 	 7.3230106853305110e-02 5.6995091349743565e-01 2.6921498054625565e-03
     	 	 7.4015219731895732e-02 6.3894294588886535e-01 2.5949680480398265e-03
     	 	 7.7158735340040030e-02 6.9973512056852594e-01 2.3379700069485572e-03
     	 	 7.8541689370752787e-02 7.5434589589792722e-01 2.1556678618504430e-03
     	 	 7.1821631457228086e-02 8.1021744085270786e-01 1.7766581057668096e-03
     	 	 7.5410359920938252e-02 8.4914929743944445e-01 1.4911830270513695e-03
     	 	 7.6293828110260531e-02 8.8248921830080285e-01 1.1645858212826822e-03
     	 	 7.9419507451633176e-02 9.0373803775738071e-01 7.8568388381167924e-04
     	 	 7.7314066633172751e-02 9.1947919882865958e-01 3.2977698639346636e-04
     	 	 4.3095201547478035e-02 3.3309860036489576e-03 2.6045587822089253e-04
     	 	 4.3956676018907959e-02 1.7106206513621613e-02 5.9439673712072824e-04
     	 	 3.9993261520820389e-02 4.0676177068323542e-02 8.0812288260267832e-04
     	 	 4.1841536260812773e-02 7.3042090167923554e-02 1.1086117514852855e-03
     	 	 4.1526758629105931e-02 1.1529590695737529e-01 1.3999025475298734e-03
     	 	 4.1072376094340113e-02 1.6796857179855806e-01 1.6971096803275747e-03
     	 	 3.9868069141271834e-02 2.2977405693177946e-01 1.8509214825967728e-03
     	 	 3.9676348406585626e-02 2.9828169154821993e-01 2.0225565380020110e-03
     	 	 3.9527143209921012e-02 3.7114878704117144e-01 2.0902948251527906e-03
     	 	 3.8948496486311490e-02 4.4610304895116659e-01 2.0788055219451663e-03
     	 	 3.8899972528924187e-02 5.2008027759049380e-01 2.0307727618431247e-03
     	 	 4.0266520045103449e-02 5.9138009711466510e-01 2.0283094015000739e-03
     	 	 4.0009127137380140e-02 6.6137972160542813e-01 1.9719265497025471e-03
     	 	 4.2280831176215283e-02 7.2575527705523291e-01 1.9054743021727112e-03
     	 	 4.2693480029708963e-02 7.8554688419026486e-01 1.7269538310193020e-03
     	 	 3.8670117415433469e-02 8.4172617022623908e-01 1.3608426285131976e-03
     	 	 4.1216181848881428e-02 8.8323864837843757e-01 1.1536148289820667e-03
     	 	 4.1741723813057519e-02 9.1690508751342092e-01 8.6576626144918437e-04
     	 	 4.3187400530287134e-02 9.3971871699419929e-01 5.9427058918561939e-04
     	 	 4.2202397158862870e-02 9.5451908989958956e-01 2.5223572692922039e-04
     	 	 1.7750359683552763e-02 3.2239651627788820e-03 1.6550985429659098e-04
     	 	 1.7936252974908196e-02 1.7179816087432288e-02 4.0004002406130796e-04
     	 	 1.6404480432136048e-02 4.2850200829018206e-02 5.8202464395443198e-04
     	 	 1.7187896809805592e-02 7.9733468173122601e-02 8.2124639993611480e-04
     	 	 1.7065154630704349e-02 1.2724707188208373e-01 1.0030138602127165e-03
     	 	 1.6701130582758017e-02 1.8363430528719996e-01 1.1357108506492644e-03
     	 	 1.6384130807422626e-02 2.4687177254345885e-01 1.2085140415336476e-03
     	 	 1.6225843189390909e-02 3.1429599733753000e-01 1.2644140867414996e-03
     	 	 1.6252432771450387e-02 3.8451258483192136e-01 1.3054474028131187e-03
     	 	 1.5970528018840802e-02 4.5709663650831139e-01 1.3236200883858431e-03
     	 	 1.5960745006794230e-02 5.3129758773950220e-01 1.3425597433929758e-03
     	 	 1.6593489382383475e-02 6.0508869876214322e-01 1.3649270510823137e-03
     	 	 1.6321144882437633e-02 6.7682489743039131e-01 1.2880447790630709e-03
     	 	 1.7364816263610749e-02 7.4348911565776499e-01 1.2670822337777982e-03
     	 	 1.7557208575710748e-02 8.0485983227942648e-01 1.1455365216272958e-03
     	 	 1.5762652583569681e-02 8.6039387834561221e-01 8.9621236631125679e-04
     	 	 1.6819731366746415e-02 9.0530240006271290e-01 7.8165490985404042e-04
     	 	 1.7245484526852040e-02 9.4072234773241281e-01 5.8940941982397489e-04
     	 	 1.7632641040876140e-02 9.6531231712197374e-01 3.8729035706366920e-04
     	 	 1.7371204588545242e-02 9.7940321370466188e-01 1.6175511419312436e-04
     	 	 3.3960175089209343e-03 3.5475554669595192e-03 7.8947143447402775e-05
     	 	 3.4060211732674928e-03 1.8451980373765761e-02 1.8007406970557826e-04
     	 	 3.1131382878997194e-03 4.4434928086106475e-02 2.4831101522862817e-04
     	 	 3.2820754441218458e-03 8.0243424958392567e-02 3.4010211914967776e-04
     	 	 3.2639932193756493e-03 1.2510454827874831e-01 4.1168936159120633e-04
     	 	 3.1837079555954162e-03 1.7861102996488643e-01 4.7129344809251818e-04
     	 	 3.1416056637879608e-03 2.4028061033939146e-01 5.2641104027915323e-04
     	 	 3.0880305244673778e-03 3.0889782765349072e-01 5.6587338835952547e-04
     	 	 3.1037546295762386e-03 3.8236857202775909e-01 5.9726335437224152e-04
     	 	 3.0500674346538581e-03 4.5833777573092477e-01 5.9797086079912910e-04
     	 	 3.0367635312193997e-03 5.3476845577184084e-01 5.9251048375335148e-04
     	 	 3.1717801396279333e-03 6.0990562369646717e-01 6.0174842800121990e-04
     	 	 3.1010066324592689e-03 6.8238462730959326e-01 5.6174680923197289e-04
     	 	 3.2985155112329467e-03 7.5050811223696934e-01 5.5463073802335333e-04
     	 	 3.3654850012501125e-03 8.1278210899218184e-01 5.0720476771947559e-04
     	 	 3.0016799530806493e-03 8.6802304134383390e-01 3.9283315874835705e-04
     	 	 3.1789300217608396e-03 9.1457220751401092e-01 3.4347469052322527e-04
     	 	 3.2979422568931716e-03 9.5157034870872859e-01 2.6998512798339882e-04
     	 	 3.3488759483621955e-03 9.7803248765706730e-01 1.7956468200476072e-04
     	 	 3.3235597713743292e-03 9.9311114052533345e-01 7.7722645882497644e-05
     	 	 ];


    case 40

        % SET: SLOBODKINS TAUSCH
        % CARDINALITY RULE  :    289
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 9.055e-16

        XYW=[
    	 	 9.9442764581518339e-01 2.6675613090118987e-03 5.1725700494075787e-05
     	 	 9.8236025695992046e-01 1.4420153749210934e-02 1.3739287288522134e-04
     	 	 9.8144886748139315e-01 2.9378609891982043e-03 1.3545545846064167e-04
     	 	 9.6797724218563752e-01 1.5417552452119712e-02 3.1708078731005203e-04
     	 	 9.6092141333583958e-01 3.6226179251696196e-02 1.9817140474258664e-04
     	 	 9.5782844121952304e-01 3.2291052933354279e-03 2.3683528615020948e-04
     	 	 9.4360699724477637e-01 1.7031597541196514e-02 5.1996980330532103e-04
     	 	 9.2097874627675325e-01 4.1084272584872551e-02 8.1294456866561244e-04
     	 	 9.4748930838756529e-01 3.7304211963756613e-02 4.6654373942957235e-04
     	 	 9.2862228696098614e-01 6.8302240527823924e-02 2.9184601951881919e-04
     	 	 9.2463985899408896e-01 2.6882405784487036e-03 2.6738653095825533e-04
     	 	 9.1489562424993132e-01 1.4295603744641580e-02 5.8913394753899707e-04
     	 	 8.9292213622882488e-01 3.6056858471292211e-02 1.0056920651986523e-03
     	 	 8.6249424341059833e-01 6.7389505730416077e-02 1.3026000422655174e-03
     	 	 8.8616160063125937e-01 7.5015517931505377e-02 1.0375825601667095e-03
     	 	 9.1525876270007211e-01 6.8694684121116234e-02 6.4361092979600373e-04
     	 	 8.8677754245578555e-01 1.1015357541592236e-01 3.6608297919570374e-04
     	 	 8.8125670288621782e-01 3.0502031645401125e-03 3.6945153573231639e-04
     	 	 8.7344332614030673e-01 1.5860962292362269e-02 7.9046950950170539e-04
     	 	 8.4846647338970782e-01 3.8508566635507939e-02 1.2572976597649706e-03
     	 	 8.1915295647572384e-01 7.0314655991892988e-02 1.6306875595922608e-03
     	 	 8.1847950746126286e-01 1.0846509311549539e-01 1.7458377156094463e-03
     	 	 8.4374800350080159e-01 1.1655390326075307e-01 1.2965037216395147e-03
     	 	 8.7512492475596249e-01 1.0874424212903877e-01 8.0444878018275307e-04
     	 	 8.3589113114922886e-01 1.6098186644234702e-01 4.4069403895017543e-04
     	 	 8.3013669833134207e-01 3.0678071698109592e-03 4.2989558057666841e-04
     	 	 8.2428537037066163e-01 1.6122781203820664e-02 9.6818948535158482e-04
     	 	 7.9823541601926973e-01 3.9401779966303507e-02 1.4819274654400321e-03
     	 	 7.6804589221679520e-01 7.2257940341622903e-02 1.9933830960979517e-03
     	 	 7.7270063413835244e-01 1.1113420379970608e-01 2.1088424825840110e-03
     	 	 7.6906022071112146e-01 1.5821196632129880e-01 2.0079263988414427e-03
     	 	 7.9500813140847104e-01 1.6525053404699411e-01 1.4597715026149305e-03
     	 	 8.2714648444565730e-01 1.5645923437384937e-01 9.4700447780356406e-04
     	 	 7.7250774258495714e-01 3.0948290359391686e-03 4.7847984145385578e-04
     	 	 7.6725908957657463e-01 1.6195036090490552e-02 1.1044691264709477e-03
     	 	 7.4280102605890930e-01 3.9474789633231484e-02 1.6413164857776101e-03
     	 	 7.1095616607520684e-01 7.2637456766145803e-02 2.2720102075685046e-03
     	 	 7.1794380098373800e-01 1.1447725064022747e-01 2.5558618675882729e-03
     	 	 7.2732843921376045e-01 1.5871038916619021e-01 2.2891350708380115e-03
     	 	 7.1390388056796716e-01 2.1539833781817688e-01 2.1902832090841319e-03
     	 	 7.4192890869017836e-01 2.1951796586450176e-01 1.5585000138880162e-03
     	 	 7.7272249635415879e-01 2.1133886102347652e-01 1.0465926064641340e-03
     	 	 7.7725214119225094e-01 2.1971942054492527e-01 4.8282596616146603e-04
     	 	 7.0984140390936790e-01 3.1041706975029303e-03 5.1607904472467006e-04
     	 	 7.0357202252129247e-01 1.6311841895607165e-02 1.2208131079975988e-03
     	 	 6.8194911407804537e-01 3.9772638255217256e-02 1.7862732835444695e-03
     	 	 6.4876965945185083e-01 7.2530067566028755e-02 2.3692854704315306e-03
     	 	 6.5956056238124272e-01 1.1488101992931522e-01 2.8157183599050858e-03
     	 	 6.1848811462488640e-01 1.6516417371028749e-01 3.0924947487807252e-03
     	 	 6.7338563734391133e-01 1.6482813204588218e-01 2.7946836984681974e-03
     	 	 6.7538368755636502e-01 2.1318513692487481e-01 2.5977873286764652e-03
     	 	 6.5259315663867712e-01 2.7746895274613004e-01 2.3259148643508748e-03
     	 	 6.8313294446329520e-01 2.7883856461695411e-01 1.6884805853587179e-03
     	 	 7.1153875701780267e-01 2.7289400478862924e-01 1.1331514407368786e-03
     	 	 7.1227344567937623e-01 2.8476259858366920e-01 5.1314463346236047e-04
     	 	 6.4327241733246054e-01 2.9561270694336310e-03 5.1740693520886162e-04
     	 	 6.3578772738911282e-01 1.5480658523344270e-02 1.2197929458761462e-03
     	 	 6.1858763666050653e-01 3.7503558972847240e-02 1.7997785824139330e-03
     	 	 5.8878940742064190e-01 6.8205407837326773e-02 2.2250392930666849e-03
     	 	 5.9887301524316339e-01 1.1255222868276833e-01 2.8158232442215885e-03
     	 	 5.6266503318828132e-01 1.6002715208659585e-01 3.1556377309774368e-03
     	 	 5.6332863070232397e-01 2.2116518229748128e-01 3.3856559902588237e-03
     	 	 6.1732552246284422e-01 2.2280310549024177e-01 3.2169979611299461e-03
     	 	 6.1485310474861787e-01 2.7446240997513577e-01 2.8817013208787372e-03
     	 	 5.8714234237754603e-01 3.4243819873401571e-01 2.3990337860876430e-03
     	 	 6.1864488036637355e-01 3.4295274005682752e-01 1.8108618425438797e-03
     	 	 6.4442439228385962e-01 3.3983401331254798e-01 1.2294308666784691e-03
     	 	 6.4289695124654256e-01 3.5409357221090471e-01 5.4685616975319747e-04
     	 	 5.7375535304003755e-01 2.7842273352020959e-03 5.0632765269037494e-04
     	 	 5.6504753425941368e-01 1.4714571684504905e-02 1.2070975982674727e-03
     	 	 5.4979521656883379e-01 3.6207471825409510e-02 1.8689852215047255e-03
     	 	 5.2856812463944003e-01 6.6692850252885683e-02 2.0199385120614958e-03
     	 	 5.4068751175572627e-01 1.0594829025077040e-01 2.7673879695209241e-03
     	 	 5.0243483801576994e-01 1.5363026696246118e-01 3.4439142374955664e-03
     	 	 5.1221268393642760e-01 2.1155002620013119e-01 3.3420497747783558e-03
     	 	 5.0717540726540600e-01 2.7950426434989822e-01 3.2716904622576881e-03
     	 	 5.5374826237186603e-01 2.8726286309760507e-01 3.4659351634721068e-03
     	 	 5.4804950729808899e-01 3.4114339969754226e-01 3.0396363108328786e-03
     	 	 5.2158156051453608e-01 4.0864517106444914e-01 2.3655190394834100e-03
     	 	 5.5169994787325494e-01 4.1006383987899203e-01 1.8466837250081067e-03
     	 	 5.7325409943488770e-01 4.1100454815506726e-01 1.2897032864207483e-03
     	 	 5.7101057997947047e-01 4.2599522197448964e-01 5.5718668103467742e-04
     	 	 5.0200269071711112e-01 3.0175681606605278e-03 5.5763524104343284e-04
     	 	 4.9158590039790850e-01 1.5823541561312594e-02 1.2991749790242340e-03
     	 	 4.7643698115495337e-01 3.8505038141553524e-02 1.9773378184186744e-03
     	 	 4.7277920080326652e-01 7.0400453328223908e-02 1.9638835750230418e-03
     	 	 4.7375722356913041e-01 1.0873817784804173e-01 2.9394384393071943e-03
     	 	 4.3214147178544171e-01 1.5682450441062715e-01 3.4774235031860283e-03
     	 	 4.5286659022076559e-01 2.0810159932808647e-01 3.6582737787616043e-03
     	 	 4.5865544745441544e-01 2.6851738078639625e-01 3.6575680699514773e-03
     	 	 4.5166343730894265e-01 3.3581068187472585e-01 3.1723654703450124e-03
     	 	 4.8509477865466155e-01 3.5672460707083670e-01 3.6167144756492618e-03
     	 	 4.7925254825889108e-01 4.1124362072547183e-01 3.0971760072700397e-03
     	 	 4.5772016520603465e-01 4.7383173218994423e-01 2.2630143749998617e-03
     	 	 4.8399326286201838e-01 4.7873419189954247e-01 1.8383221070415801e-03
     	 	 4.9982781191614833e-01 4.8488889228352894e-01 1.2820255234137535e-03
     	 	 4.9843976698215009e-01 4.9865857007761422e-01 5.3788215848467422e-04
     	 	 4.2996569242194105e-01 2.9758496818604518e-03 5.4756615944942251e-04
     	 	 4.1912705864095201e-01 1.5581636455172281e-02 1.2662890680956115e-03
     	 	 4.0505196651100317e-01 3.7969986352308464e-02 1.9261363846905673e-03
     	 	 4.1265203968694320e-01 7.0050461652827384e-02 2.3711516821981263e-03
     	 	 4.0436478294342015e-01 1.1095464366326045e-01 3.0273400535925426e-03
     	 	 3.6502598544312048e-01 1.5931335377833084e-01 3.2007127802068129e-03
     	 	 3.8648004884986042e-01 2.1192679435303427e-01 3.6163680349856528e-03
     	 	 3.9782677479963890e-01 3.3104924377785805e-01 3.9130567543753884e-03
     	 	 3.9595085394553609e-01 2.6884808851589148e-01 3.9996324969243874e-03
     	 	 3.9562678306940502e-01 3.9416218663000174e-01 3.3943913491429069e-03
     	 	 4.1541576740532826e-01 4.2868251524118189e-01 3.6165487136284526e-03
     	 	 4.1027258569465164e-01 4.8213991613917612e-01 3.0173670478533454e-03
     	 	 3.9632300099912299e-01 5.3581438156257055e-01 2.0968173740783256e-03
     	 	 4.1533959750656935e-01 5.4750658969630261e-01 1.8065043382042270e-03
     	 	 4.2558737729076535e-01 5.5915349948924942e-01 1.2701718394905746e-03
     	 	 4.2707498138100874e-01 5.7000502153120547e-01 5.2576988957768922e-04
     	 	 3.5891741621422191e-01 2.9551947129307149e-03 5.3128747930404727e-04
     	 	 3.4796590358659585e-01 1.5539551554861425e-02 1.2282165852168234e-03
     	 	 3.3587817733902059e-01 3.7941949529920402e-02 1.8201476615091936e-03
     	 	 3.4632370739028462e-01 6.9480093434916332e-02 2.4149329003730819e-03
     	 	 3.3802491322168515e-01 1.0977420135880085e-01 2.9243015724734118e-03
     	 	 3.1017813129093763e-01 1.5758669912746073e-01 2.5642525649708604e-03
     	 	 3.2439602627479336e-01 2.1396173426416684e-01 3.3667808377319643e-03
     	 	 3.2897497745968485e-01 2.7287780820094720e-01 3.9746123058355121e-03
     	 	 3.3380072628732538e-01 3.3416288172456793e-01 4.1263091982915116e-03
     	 	 3.3502956440369891e-01 3.9783224957554042e-01 3.9801869884078913e-03
     	 	 3.3549958300511928e-01 4.5801581326766139e-01 3.5490595866195926e-03
     	 	 3.4641214700296619e-01 5.0091117644652183e-01 3.4696409955461216e-03
     	 	 3.4306383534820717e-01 5.5118735586826428e-01 2.7913093437333253e-03
     	 	 3.3687549933788141e-01 5.9662075738400400e-01 2.1178015964981194e-03
     	 	 3.4855680920231935e-01 6.1538116959744305e-01 1.7070179749320295e-03
     	 	 3.5266292720892223e-01 6.3257179506166084e-01 1.2002681108776365e-03
     	 	 3.5804892696433344e-01 6.3915562149117755e-01 4.8679183998403229e-04
     	 	 2.9022559471798393e-01 3.0377287593663653e-03 5.2128181989530254e-04
     	 	 2.7962641464615856e-01 1.5959487679933739e-02 1.1853979225886582e-03
     	 	 2.7138161268179861e-01 3.8889078015878861e-02 1.6989827624564902e-03
     	 	 2.7999332268681154e-01 7.0672943397081897e-02 2.3638867803147594e-03
     	 	 2.7348670547560627e-01 1.1116488902874516e-01 2.7585314491661793e-03
     	 	 2.6191973200673502e-01 1.5963538006951908e-01 2.5028121202519825e-03
     	 	 2.6863337127372366e-01 2.1272342753357074e-01 3.1738175276626911e-03
     	 	 2.6567549323772022e-01 2.7372696581655720e-01 3.7929088114596336e-03
     	 	 2.6888462253952494e-01 3.3708553193737012e-01 4.0261843828113498e-03
     	 	 2.7221031809078844e-01 4.0082316445438798e-01 4.0106827847421053e-03
     	 	 2.7279226270380652e-01 4.6423448002620521e-01 3.7515070086982399e-03
     	 	 2.7400548042094242e-01 5.2098689233384499e-01 3.3256565478656376e-03
     	 	 2.7908119878337312e-01 5.6781299789985007e-01 3.2130283814755332e-03
     	 	 2.8118834440983975e-01 6.1140167473581830e-01 2.5076099001410728e-03
     	 	 2.7471882646712831e-01 6.5585007513444837e-01 2.1896461467648658e-03
     	 	 2.8422019503578300e-01 6.7782374553850933e-01 1.6713429929694926e-03
     	 	 2.8251416581039690e-01 7.0178672949887022e-01 1.1939309801021402e-03
     	 	 2.9145328697620265e-01 7.0555803462300348e-01 4.9851119757738792e-04
     	 	 2.2549173493985053e-01 3.0880476647260195e-03 4.9276967210230382e-04
     	 	 2.1659847524700482e-01 1.6246123773201983e-02 1.0956578118041071e-03
     	 	 2.1274968360603985e-01 3.9726754718548980e-02 1.5950224237430558e-03
     	 	 2.1680972673721854e-01 7.2942448029111109e-02 2.2960022271779567e-03
     	 	 2.1376840922623030e-01 1.1539065103302167e-01 2.6328685168569847e-03
     	 	 2.1017939210668390e-01 1.6569417607664869e-01 2.8572147217979476e-03
     	 	 2.1317294353955218e-01 2.2174731675684628e-01 3.2014964600182248e-03
     	 	 2.0772355059382341e-01 2.8204440179616075e-01 3.3849340713122968e-03
     	 	 2.0892570306093217e-01 3.4475661602350299e-01 3.6678751834913251e-03
     	 	 2.1142346633153952e-01 4.0881971771336967e-01 3.7182411286805985e-03
     	 	 2.1356635998416984e-01 4.7051859773085158e-01 3.4536873882914333e-03
     	 	 2.1322754717711134e-01 5.2699365409657417e-01 2.9673975088118534e-03
     	 	 2.1487357978645016e-01 5.7553206509060806e-01 2.8488067647384051e-03
     	 	 2.1557492385997723e-01 6.2452791416534892e-01 2.9422974762625272e-03
     	 	 2.2238098391780881e-01 6.6504985481008483e-01 2.5619454567535056e-03
     	 	 2.1374776643787918e-01 7.1431262935131679e-01 2.1863415851612229e-03
     	 	 2.2364684393657697e-01 7.3715020626521421e-01 1.6425242376441420e-03
     	 	 2.1770116173839205e-01 7.6617869903191760e-01 1.1188623417739550e-03
     	 	 2.2818886074879097e-01 7.6874390153308547e-01 4.8081285551821660e-04
     	 	 1.6632863342038839e-01 3.1130492268540287e-03 4.4515878434155039e-04
     	 	 1.6067789903299345e-01 1.6263730003142903e-02 9.4813958163624879e-04
     	 	 1.5927341970636000e-01 3.9378371424134154e-02 1.4212721065770249e-03
     	 	 1.5967558806883031e-01 7.1977833700044735e-02 1.9817702314665043e-03
     	 	 1.5997416676780607e-01 1.1329250620013752e-01 2.3335374570453114e-03
     	 	 1.5767406678801843e-01 1.6294229075007899e-01 2.7242484285546773e-03
     	 	 1.6018222748979261e-01 2.2025672197509050e-01 3.0638078975887442e-03
     	 	 1.5549450379594876e-01 2.8341547184138577e-01 3.2567500610919220e-03
     	 	 1.5492678644455526e-01 3.5059916361416665e-01 3.4483341441584000e-03
     	 	 1.5651119929053492e-01 4.1924648382698443e-01 3.5852879020864159e-03
     	 	 1.5846981341804522e-01 4.8822953591586005e-01 3.5864358228556892e-03
     	 	 1.5922528939110558e-01 5.5563862133059694e-01 3.4022295666174263e-03
     	 	 1.5935293165450792e-01 6.1982032335967074e-01 3.2021645320536268e-03
     	 	 1.5971322750513461e-01 6.7668172988710951e-01 2.7847748064440373e-03
     	 	 1.6616559420222587e-01 7.2022192221402481e-01 2.4756437792622628e-03
     	 	 1.5794677611701502e-01 7.7022624853310961e-01 1.9470101935981973e-03
     	 	 1.6701650039925164e-01 7.9373295660211296e-01 1.5196671390343215e-03
     	 	 1.5991139850708358e-01 8.2399898826043316e-01 9.7338045932444592e-04
     	 	 1.6969229361468730e-01 8.2723074375900818e-01 4.3817018827981615e-04
     	 	 1.1437575572097747e-01 2.9981639383264559e-03 3.6834678605408638e-04
     	 	 1.1283675294373330e-01 1.5793803990288124e-02 7.8821206307288312e-04
     	 	 1.1128248930948048e-01 3.9022211370134265e-02 1.2716286005064169e-03
     	 	 1.1038547897941309e-01 7.2233735937247440e-02 1.7099165720672472e-03
     	 	 1.1178819179125865e-01 1.1460314770284497e-01 2.0857605436826053e-03
     	 	 1.0998897109141403e-01 1.6476750790313477e-01 2.3565041243438015e-03
     	 	 1.1251119648718322e-01 2.2081140177956046e-01 2.6263595110626722e-03
     	 	 1.0886761157419744e-01 2.8224810112091664e-01 2.7574028496282080e-03
     	 	 1.0806127200983828e-01 3.4779149077773686e-01 2.9124993091097216e-03
     	 	 1.0833760633507372e-01 4.1628556424893454e-01 3.0400134644182077e-03
     	 	 1.0979991297587854e-01 4.8504920750691793e-01 3.0580881596158197e-03
     	 	 1.1066308943230729e-01 5.5244720866024655e-01 2.9649756729215873e-03
     	 	 1.1158520559568419e-01 6.1618406025372030e-01 2.7492292480588210e-03
     	 	 1.1002896069112933e-01 6.7685633044167293e-01 2.5698221148885534e-03
     	 	 1.1218539304073671e-01 7.2857994382244451e-01 2.2324713859927024e-03
     	 	 1.1553667926358857e-01 7.7286470941951679e-01 2.1066231214641592e-03
     	 	 1.0975234429413205e-01 8.1979133957782269e-01 1.6123694173520366e-03
     	 	 1.1590431834215609e-01 8.4565810870640234e-01 1.3139326189565508e-03
     	 	 1.1078037381365635e-01 8.7357692291713074e-01 7.8638533053521683e-04
     	 	 1.1763611128864560e-01 8.7937057279472353e-01 3.7066544847227478e-04
     	 	 7.1113927167095525e-02 3.2247850354257313e-03 3.1765715706234728e-04
     	 	 7.2898417789608816e-02 1.6835497742495372e-02 6.7845267636998591e-04
     	 	 7.0057078388231386e-02 4.0573113322657672e-02 1.0561580576379929e-03
     	 	 6.9805313312651496e-02 7.3585639171798722e-02 1.3503107884814539e-03
     	 	 7.0860062376507771e-02 1.1527805095999295e-01 1.6960460943122497e-03
     	 	 6.9826582642415591e-02 1.6565723285201736e-01 1.9690385812359654e-03
     	 	 7.1528309393169676e-02 2.2394588553647940e-01 2.2813774249123126e-03
     	 	 6.9167386013229026e-02 2.8901904026589698e-01 2.4097447316560076e-03
     	 	 6.8585905662074231e-02 3.5869074208355506e-01 2.5262097564403663e-03
     	 	 6.8613999173434803e-02 4.3091609666071512e-01 2.5987638360098187e-03
     	 	 6.9465551686952010e-02 5.0394028933662849e-01 2.6500458980578457e-03
     	 	 7.0102565693048513e-02 5.7621074859214716e-01 2.6026572832510940e-03
     	 	 7.0997653669624405e-02 6.4565275138431011e-01 2.4923104620202916e-03
     	 	 6.9184292305512929e-02 7.1278197199423021e-01 2.2830331723319797e-03
     	 	 7.1897889839212636e-02 7.6932181923477838e-01 2.0086556227039750e-03
     	 	 7.2600219713961134e-02 8.1908606935627137e-01 1.7588184590774964e-03
     	 	 7.0195491524390419e-02 8.6286620221075261e-01 1.2749727934081132e-03
     	 	 7.2553290459214992e-02 8.9138298270559335e-01 1.0237240261033319e-03
     	 	 7.1045083435193446e-02 9.1449572184821437e-01 5.8125249286649641e-04
     	 	 7.3691018575591127e-02 9.2354997569994168e-01 2.7907317963835092e-04
     	 	 3.7710666406194360e-02 3.0725596299451289e-03 2.2259678460094856e-04
     	 	 4.0733380117592533e-02 1.6321198536040027e-02 5.2154981223522402e-04
     	 	 3.7731759745386229e-02 4.0024855930291071e-02 7.9774268830970713e-04
     	 	 3.8165636166763495e-02 7.4119304237786052e-02 1.0563777855589469e-03
     	 	 3.8564606391645162e-02 1.1725287460092187e-01 1.2979461372045584e-03
     	 	 3.8050358955162733e-02 1.6732286708683250e-01 1.4367433623401747e-03
     	 	 3.9187470895651555e-02 2.2234524261907643e-01 1.5905643570612714e-03
     	 	 3.7923413272599293e-02 2.8142329937580662e-01 1.6628178416598627e-03
     	 	 3.7494692127195361e-02 3.4604720145789319e-01 1.8033646142465044e-03
     	 	 3.7345964819732735e-02 4.1579641874553924e-01 1.9136236700867033e-03
     	 	 3.7659915957081402e-02 4.8838314763302104e-01 1.9677052084987961e-03
     	 	 3.7988016302301530e-02 5.6085827701411650e-01 1.9550912745738861e-03
     	 	 3.8521701329088498e-02 6.3022271899082194e-01 1.8279204119905476e-03
     	 	 3.8850888919669369e-02 6.9156605808699811e-01 1.5478517968837752e-03
     	 	 3.6659435237432536e-02 7.4399063890037864e-01 1.2631642249252529e-03
     	 	 3.9648952595317644e-02 7.8910706499478123e-01 1.3863743274079791e-03
     	 	 3.9268996214165464e-02 8.3884234109780897e-01 1.3448916259292106e-03
     	 	 3.9202183045581540e-02 8.8263281606970956e-01 1.1013964339696548e-03
     	 	 3.8474413633069360e-02 9.1930675306737042e-01 8.6356770506002066e-04
     	 	 3.9920468046828028e-02 9.4262222999223633e-01 5.3542891691795325e-04
     	 	 3.9311826632133950e-02 9.5740579195880504e-01 2.4500331036949154e-04
     	 	 1.4887745447945688e-02 2.9700124241341221e-03 1.3234620939449134e-04
     	 	 1.7120030535842101e-02 1.5551036850558100e-02 3.3008103336601104e-04
     	 	 1.5265875464853584e-02 3.7446007648472099e-02 4.6380787161549538e-04
     	 	 1.5661313789224418e-02 6.8963047312470993e-02 6.4189418679058208e-04
     	 	 1.5824282045676541e-02 1.1021071119047889e-01 8.1970836054769927e-04
     	 	 1.5607077658919666e-02 1.6068935425048131e-01 9.6778198805019171e-04
     	 	 1.6063488486734223e-02 2.1950361378626077e-01 1.1237921938869252e-03
     	 	 1.5608057099003592e-02 2.8419287375524349e-01 1.1759588972084158e-03
     	 	 1.5392707038724751e-02 3.5260571945463920e-01 1.2025508711061097e-03
     	 	 1.5312075712960227e-02 4.2220647937658140e-01 1.2019933418038499e-03
     	 	 1.5465317944704737e-02 4.9162299111048635e-01 1.2087149167814828e-03
     	 	 1.5504464970037879e-02 5.6117556091226783e-01 1.2226071318277880e-03
     	 	 1.5807710660904473e-02 6.3067990851850009e-01 1.2326381532305477e-03
     	 	 1.5903973932016813e-02 6.9889923289312783e-01 1.2000544477934322e-03
     	 	 1.5141143036267013e-02 7.6420950532988696e-01 1.0607838318732721e-03
     	 	 1.6382929168727967e-02 8.2142364599070450e-01 1.0065467506831453e-03
     	 	 1.5927351816887980e-02 8.7265048434325698e-01 8.4037023638700546e-04
     	 	 1.6382019351819155e-02 9.1383436732616974e-01 6.7036812783990703e-04
     	 	 1.5290603178942153e-02 9.4695224991631632e-01 4.7952752899188008e-04
     	 	 1.6995512258019430e-02 9.6738169259137863e-01 3.2621791913060318e-04
     	 	 1.5667597409059320e-02 9.8134818598446971e-01 1.3870877860060017e-04
     	 	 2.7245372174302673e-03 2.7606138992381517e-03 5.0343667330220525e-05
     	 	 3.2973206642298303e-03 1.4800868293501846e-02 1.4326497592092406e-04
     	 	 2.8887624590063776e-03 3.6747808719045504e-02 1.9963184263831676e-04
     	 	 2.9844233142737320e-03 6.8366839615632641e-02 2.7672296957361998e-04
     	 	 3.0247113394433756e-03 1.0874928083537813e-01 3.4448683465250279e-04
     	 	 2.9627721695386633e-03 1.5708388641699603e-01 3.9675203118552150e-04
     	 	 3.0695813736580924e-03 2.1302698613998253e-01 4.6846727610744358e-04
     	 	 2.9891568553416237e-03 2.7598391336586353e-01 5.0745519035525031e-04
     	 	 2.9415590701450389e-03 3.4506956821224594e-01 5.3997316366794781e-04
     	 	 2.9180568816077335e-03 4.1857206891006626e-01 5.6119843413170829e-04
     	 	 2.9492706309809380e-03 4.9431998890937212e-01 5.7537925200967593e-04
     	 	 2.9524589200833340e-03 5.7006050679781806e-01 5.6803415160803952e-04
     	 	 3.0231717790614177e-03 6.4364324563755271e-01 5.5729585944806390e-04
     	 	 3.0256263705795705e-03 7.1337813041601683e-01 5.2211424543435584e-04
     	 	 2.8730793241201757e-03 7.7791273661995075e-01 4.5157458690662898e-04
     	 	 3.1456569974079862e-03 8.3538688586943644e-01 4.3600724390939992e-04
     	 	 3.0097189857861695e-03 8.8576488534802922e-01 3.5702255218571173e-04
     	 	 3.1618840097800138e-03 9.2737883588636638e-01 3.0075057172218188e-04
     	 	 2.8422775443561754e-03 9.6007864425834777e-01 2.0109158214290474e-04
     	 	 3.3053166647487586e-03 9.8186290609797877e-01 1.4443379402155200e-04
     	 	 2.8987689602196776e-03 9.9434751302129087e-01 5.3319438886164291e-05
     	 	 ];


    case 41

        % SET: SLOBODKINS TAUSCH
        % CARDINALITY RULE  :    303
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 9.973e-15

        XYW=[
    	 	 9.9355620179572934e-01 3.1397404726941757e-03 6.8034245247138210e-05
     	 	 9.8069890758047218e-01 1.6359902181798860e-02 1.3823854794361659e-04
     	 	 9.7961233971897066e-01 3.0902602631833463e-03 1.5465321109077852e-04
     	 	 9.6804415214844375e-01 1.6415923599613764e-02 3.3087918152279513e-04
     	 	 9.4476477391568625e-01 4.0534244245432845e-02 4.8893611274637629e-04
     	 	 9.5769773312263695e-01 3.9499828500944696e-02 2.0036020729243624e-04
     	 	 9.5511228647829360e-01 2.6868670996308755e-03 2.0745256888504723e-04
     	 	 9.4711217474829823e-01 1.4257183992885451e-02 4.5266219727366030e-04
     	 	 9.2864319352499114e-01 3.5053131488872111e-02 6.6769911006108980e-04
     	 	 9.1018396911334110e-01 7.5084007843437092e-02 6.4815510672166317e-04
     	 	 9.2515402419256909e-01 7.2020365211399373e-02 2.6844394755159035e-04
     	 	 9.2020340332998707e-01 2.7743361954925710e-03 2.8035142704896046e-04
     	 	 9.1421335615061750e-01 1.4457940353421472e-02 6.1098881095094813e-04
     	 	 8.9734344656753939e-01 3.5318272699375854e-02 9.0489085909409100e-04
     	 	 8.7150560514076458e-01 6.4920509134424695e-02 1.0859940907195025e-03
     	 	 8.9971225800120092e-01 6.5040465503571898e-02 8.5125483618334183e-04
     	 	 8.8356093805931746e-01 1.1359587540328064e-01 3.3489943451012704e-04
     	 	 8.7637089921760081e-01 2.9745341307627054e-03 3.6392299141232325e-04
     	 	 8.7146597558657479e-01 1.5467478057044645e-02 8.0415139469351866e-04
     	 	 8.5583127546429383e-01 3.7335650628284353e-02 1.1561091520726928e-03
     	 	 8.3278474394567259e-01 6.7766946468987774e-02 1.3915577682134931e-03
     	 	 8.3018648789715233e-01 1.0255447022690146e-01 1.4327612332231069e-03
     	 	 8.5911070613583107e-01 1.0434645998302698e-01 1.1591630965641635e-03
     	 	 8.6620658024847486e-01 1.1880256511401324e-01 8.1518911185471268e-04
     	 	 8.3362186372550195e-01 1.6352430373872925e-01 3.9333155351996979e-04
     	 	 8.2487932694178334e-01 2.9705177615925835e-03 4.1934310706049358e-04
     	 	 8.2075253533086567e-01 1.5690580013472521e-02 9.6923833823000767e-04
     	 	 8.0716492404060214e-01 3.8496970834989014e-02 1.4326400742868334e-03
     	 	 7.8650440522042064e-01 7.0879726055184042e-02 1.7523806590099050e-03
     	 	 7.8478062151525974e-01 1.0856083702920113e-01 1.9566389232053777e-03
     	 	 7.8668613475312998e-01 1.4658695003140051e-01 1.6369902578902587e-03
     	 	 8.1040800538921165e-01 1.5319393268393980e-01 1.3827107483068647e-03
     	 	 8.1429986724183256e-01 1.7083332422320038e-01 9.3029619214663752e-04
     	 	 7.7632060885221166e-01 2.2094262310040502e-01 4.2734231186510323e-04
     	 	 7.6701249815635308e-01 2.6041271570291548e-03 4.0675101617671769e-04
     	 	 7.6360020254451455e-01 1.3849936132964237e-02 9.6710419890147059e-04
     	 	 7.5424330939539175e-01 3.4156135868207961e-02 1.4615133100200405e-03
     	 	 7.3899461758494933e-01 6.3157711905722863e-02 1.8276236019509112e-03
     	 	 7.2802736804432833e-01 9.4465237716843772e-02 1.1779584843572321e-03
     	 	 7.3249172649446281e-01 1.1675034764684077e-01 1.9855396176688719e-03
     	 	 7.3786653654136558e-01 1.5861479109113358e-01 2.1982010757289560e-03
     	 	 7.3636641975207184e-01 1.9913473392630243e-01 1.8961404372962859e-03
     	 	 7.5451697026201847e-01 2.1037530703375920e-01 1.5043962886894817e-03
     	 	 7.5607102321406505e-01 2.2966992480581189e-01 9.9060417213457739e-04
     	 	 7.1226695071290314e-01 2.8505288353637398e-01 4.6084824636724651e-04
     	 	 7.0391539897247957e-01 2.9798883813360998e-03 4.9596433553482648e-04
     	 	 6.9906944756293754e-01 1.5475452131593632e-02 1.1482334719886546e-03
     	 	 6.9122347378657600e-01 3.7383673664631703e-02 1.6886998076210025e-03
     	 	 6.7801741300924090e-01 6.7986779224626384e-02 2.1275738842680973e-03
     	 	 6.7551741970281842e-01 1.0597523237170260e-01 2.3910006258916257e-03
     	 	 6.5428647036200693e-01 1.5013518013248364e-01 2.5991722014878328e-03
     	 	 6.9061269497914279e-01 1.6262015947636643e-01 2.2154780754309578e-03
     	 	 6.4163204630927273e-01 2.1239842192964858e-01 2.5250692368723520e-03
     	 	 6.8286124006581439e-01 2.1604575898538622e-01 2.4736814830382532e-03
     	 	 6.7625079570375290e-01 2.6009020746102379e-01 2.1403831031686902e-03
     	 	 6.9286941477875408e-01 2.7265083881467345e-01 1.5914074298320202e-03
     	 	 6.9241860225969654e-01 2.9345160950970123e-01 1.0488506091634144e-03
     	 	 6.3713523566084529e-01 2.8196820051008932e-03 4.9594540765604859e-04
     	 	 6.3093576064031409e-01 1.4915279389435356e-02 1.1863168759718261e-03
     	 	 6.2527277079808119e-01 3.6648065272293202e-02 1.8016727108228926e-03
     	 	 6.1453779227222882e-01 6.7564629591144135e-02 2.3181093399952855e-03
     	 	 6.1382564177872512e-01 1.0701598642798441e-01 2.7684310992534301e-03
     	 	 5.9468191941560677e-01 1.5389201237532135e-01 3.0091135197586379e-03
     	 	 5.9791735514895650e-01 2.0398913693529111e-01 3.1596018622022876e-03
     	 	 5.8683813520949313e-01 2.6624083560110284e-01 2.7257069288343524e-03
     	 	 6.1954206068049522e-01 2.7873758452029079e-01 2.7211155486965501e-03
     	 	 6.0943346931218323e-01 3.2573879522901539e-01 2.2760438763713242e-03
     	 	 6.2631152249334732e-01 3.3832793432813540e-01 1.7178783374800970e-03
     	 	 6.2511106378371806e-01 3.6029313972125693e-01 1.1208695618614224e-03
     	 	 6.4295445337662649e-01 3.5427761368221516e-01 5.0441766359881799e-04
     	 	 5.6745037597225356e-01 2.8330474295572838e-03 5.1283476106875282e-04
     	 	 5.5992388941381332e-01 1.4774077455640135e-02 1.1919141633505491e-03
     	 	 5.5580151827481883e-01 3.6011369822071836e-02 1.8312837129911838e-03
     	 	 5.4769319606239975e-01 6.6333211911228790e-02 2.3799063955481778e-03
     	 	 5.4828456182335339e-01 1.0573244397319974e-01 2.9085643645596388e-03
     	 	 5.3334650095051672e-01 1.5250879232128348e-01 3.2159057170581288e-03
     	 	 5.3591381422367779e-01 2.0764531093578048e-01 3.4245797584755919e-03
     	 	 5.3803150607151040e-01 2.6377837832891032e-01 3.3523348518544080e-03
     	 	 5.2832557494441879e-01 3.2485807416414869e-01 2.9072465871722666e-03
     	 	 5.5129455068074373e-01 3.4606021228351752e-01 2.8370197876769242e-03
     	 	 5.4040648760089027e-01 3.9437583021881190e-01 2.3379630148559222e-03
     	 	 5.5648111641993059e-01 4.0782813746247309e-01 1.7996091563657135e-03
     	 	 5.5620053140234904e-01 4.2916019827134677e-01 1.1440713907228818e-03
     	 	 5.7070450111245852e-01 4.2649070497459951e-01 5.2542022396644659e-04
     	 	 4.9617825970514384e-01 2.6463838684775043e-03 4.8829836777883480e-04
     	 	 4.8828000522227222e-01 1.3947005247823762e-02 1.1387394242825389e-03
     	 	 4.8455078974328381e-01 3.4338621211795553e-02 1.7856043791780549e-03
     	 	 4.7889768083891660e-01 6.3534688487994956e-02 2.3577399150982951e-03
     	 	 4.8114439425211430e-01 1.0204302510527952e-01 2.8764566082313597e-03
     	 	 4.6897799326670808e-01 1.4795910783855140e-01 3.3276372610745717e-03
     	 	 4.7947374201411463e-01 2.0284078109909184e-01 3.1447566042988330e-03
     	 	 4.3365414952007775e-01 2.5755419682098007e-01 3.2342909356902257e-03
     	 	 4.8128867022308930e-01 2.6639572200087258e-01 3.2729578019223531e-03
     	 	 4.7483245287706854e-01 3.2911867727153943e-01 3.4645343627091670e-03
     	 	 4.6416115511953182e-01 3.9011053432621146e-01 3.1811355761090618e-03
     	 	 4.8210549175236728e-01 4.1631815912166847e-01 2.8328288060004534e-03
     	 	 4.7060022441548555e-01 4.6572376307011693e-01 2.3712902995274153e-03
     	 	 4.8585660994466462e-01 4.7954971660895540e-01 1.7651138240207854e-03
     	 	 4.8662773715673957e-01 4.9929924911422646e-01 1.1163742649083026e-03
     	 	 4.9721975691555620e-01 5.0009821637209184e-01 5.0756920513002270e-04
     	 	 4.2427886080738964e-01 2.6603398808571471e-03 4.8837313271456271e-04
     	 	 4.1693920094700465e-01 1.3948333195371327e-02 1.1067231915189686e-03
     	 	 4.1320225795403631e-01 3.3922469384343845e-02 1.7172550662638967e-03
     	 	 4.0851076643137629e-01 6.2355402124444737e-02 2.2841676036686291e-03
     	 	 4.1453230266494168e-01 9.8699588583034223e-02 2.6837072806979879e-03
     	 	 4.0230206049041950e-01 1.4314014018675458e-01 3.2991728277036387e-03
     	 	 4.2753458376365938e-01 1.9832509688491962e-01 2.7616490191173762e-03
     	 	 3.7900301004030290e-01 1.9394467205933297e-01 2.8469798203826641e-03
     	 	 3.7747752565336812e-01 2.5307502103768131e-01 3.5388383601930111e-03
     	 	 3.7498664106181279e-01 3.1449111112918526e-01 3.6362394349389506e-03
     	 	 4.2414620626906141e-01 3.2541581680733117e-01 3.3282733723185940e-03
     	 	 3.6561527895792434e-01 3.8136292623541485e-01 3.2357647256772803e-03
     	 	 4.0762297411737269e-01 3.9624915447532960e-01 3.6052129805052616e-03
     	 	 3.9595829703143504e-01 4.5860734969842526e-01 3.3167885824095023e-03
     	 	 4.1410876158490162e-01 4.8541167532591317e-01 2.7920758271914410e-03
     	 	 3.9942669704280442e-01 5.3710907572242872e-01 2.3528470808251187e-03
     	 	 4.1555632965715195e-01 5.5003483305021683e-01 1.7241118390891434e-03
     	 	 4.1673324662051592e-01 5.6913056894942382e-01 1.1063015808360278e-03
     	 	 4.2377393707637578e-01 5.7353627516130712e-01 5.0196942797638079e-04
     	 	 3.5345880066800184e-01 2.8097767815523588e-03 5.0134400153665668e-04
     	 	 3.4737823926538713e-01 1.4804020215642286e-02 1.1358561968936593e-03
     	 	 3.4302758379333487e-01 3.6094544663631802e-02 1.7613315939354343e-03
     	 	 3.3927786757733103e-01 6.5885136810282491e-02 2.2637495840825178e-03
     	 	 3.4858778476169594e-01 1.0208045778683664e-01 2.6321364927401414e-03
     	 	 3.3319903098964099e-01 1.4618061443517358e-01 3.1466026432558241e-03
     	 	 3.2361428577571927e-01 1.9562193412137979e-01 2.9358671185087826e-03
     	 	 3.1979379617535364e-01 2.4943596631240850e-01 3.3656735785128579e-03
     	 	 3.1522032803518008e-01 3.1194868089528288e-01 3.7604801501794562e-03
     	 	 3.1325437137496004e-01 3.7409075684295279e-01 3.6428549480773571e-03
     	 	 3.1286769521995250e-01 4.3462593632476554e-01 2.8991992483222472e-03
     	 	 3.4125919313349951e-01 4.6093114688208825e-01 3.3555839415958196e-03
     	 	 3.1454125494405116e-01 5.0654322009916908e-01 7.6765803143169367e-04
     	 	 3.2899139761481122e-01 5.2641518662823927e-01 2.9575820530779629e-03
     	 	 3.4655108083423747e-01 5.5197003605140382e-01 2.6965302889640111e-03
     	 	 3.2892847737375153e-01 6.0534799455787203e-01 2.2850296314448080e-03
     	 	 3.4599583828630243e-01 6.1816177657737159e-01 1.7360530196170027e-03
     	 	 3.4804330007404038e-01 6.3718316284968191e-01 1.1217515088977380e-03
     	 	 3.5224118926304648e-01 6.4494056797907484e-01 5.0502030510251347e-04
     	 	 2.8567408500283509e-01 2.9033514396967506e-03 4.8859670408971155e-04
     	 	 2.8114882976891797e-01 1.5164184221903923e-02 1.0921594961571675e-03
     	 	 2.7638390471198115e-01 3.6782949201345609e-02 1.6811415273948259e-03
     	 	 2.7353761069747218e-01 6.7280447844023275e-02 2.2170390242022913e-03
     	 	 2.8315129123949934e-01 1.0562647393143434e-01 2.6847901554732036e-03
     	 	 2.6717428257803333e-01 1.5141500234530339e-01 3.0171995321159190e-03
     	 	 2.6549500943263760e-01 2.0126412414041769e-01 3.0072646509370685e-03
     	 	 2.5919160929756602e-01 2.5391301450027354e-01 3.0504987010835866e-03
     	 	 2.5381869418032887e-01 3.1305766804187701e-01 3.1499910566703182e-03
     	 	 2.5378458868053477e-01 3.7200837238633888e-01 3.6064552955726624e-03
     	 	 2.5570161786123058e-01 4.3115896603845716e-01 3.2949666753827505e-03
     	 	 2.6310381318408227e-01 4.8092011386529288e-01 2.7786344566005220e-03
     	 	 2.7017074247586315e-01 5.2678998628359019e-01 3.2663926561594309e-03
     	 	 2.6374664383561885e-01 5.8430192940589365e-01 2.9676920896960684e-03
     	 	 2.7881625362756612e-01 6.1570712615390633e-01 2.7784766321809046e-03
     	 	 2.6339754005108496e-01 6.6935710380033431e-01 2.1906379554185490e-03
     	 	 2.7937059167177103e-01 6.8409492842793951e-01 1.6850014721420444e-03
     	 	 2.8196713835277298e-01 7.0304778337850460e-01 1.0870085112421432e-03
     	 	 2.8436305390528527e-01 7.1277922810604399e-01 4.8061354957330197e-04
     	 	 2.2250493315420761e-01 2.7602334474983816e-03 4.2892692251471495e-04
     	 	 2.1941955544858971e-01 1.4601864829904058e-02 9.8710752961149993e-04
     	 	 2.1493262578925731e-01 3.6009257480756104e-02 1.5344255780864206e-03
     	 	 2.1199629277392795e-01 6.6765851211661759e-02 2.0789235212890136e-03
     	 	 2.2131728521968874e-01 1.0626680112081158e-01 2.5758076795373715e-03
     	 	 2.0758724621225222e-01 1.5380217064188315e-01 2.9005800957290105e-03
     	 	 2.0718546278125971e-01 2.0858198842829173e-01 3.2720616056556170e-03
     	 	 2.8005209630760952e-01 2.8529309948740150e-01 5.5265316078780544e-04
     	 	 2.0332222271983547e-01 2.7021160666823130e-01 3.3981206019138344e-03
     	 	 1.9886099678704061e-01 3.3546456285860998e-01 3.4723999487424858e-03
     	 	 1.9652916259937836e-01 4.0125554963628407e-01 3.5089677958764017e-03
     	 	 2.0063704999484744e-01 4.6311340060702183e-01 3.4482804414818148e-03
     	 	 2.0843758246380728e-01 5.2259250680241909e-01 3.4393415128660849e-03
     	 	 2.0937741960141998e-01 5.8209653349623058e-01 3.3320142919083663e-03
     	 	 2.0663964956510361e-01 6.3871325727245287e-01 2.7503940825475207e-03
     	 	 2.1552957879113044e-01 6.7728580642392278e-01 2.6274253183126007e-03
     	 	 2.0370451534368750e-01 7.2865452092861394e-01 1.9988189691489571e-03
     	 	 2.1734931014441961e-01 7.4595414653342340e-01 1.5656540389946878e-03
     	 	 2.1984537284520167e-01 7.6515961589008497e-01 1.0113294782241463e-03
     	 	 2.2141309455537583e-01 7.7573654258530689e-01 4.3953144718268943e-04
     	 	 1.6514136815429958e-01 3.0183161004030293e-03 4.1685177028994878e-04
     	 	 1.6279032780981573e-01 1.5747001344040622e-02 9.3737413913054101e-04
     	 	 1.5923263228588269e-01 3.7985672774355203e-02 1.3845460045486912e-03
     	 	 1.5602459538384972e-01 6.8513975549573086e-02 1.7968948685641085e-03
     	 	 1.6543872252086511e-01 1.0617477615154282e-01 2.2053474599207003e-03
     	 	 1.5416951770884157e-01 1.5019321360807639e-01 2.3696256754380993e-03
     	 	 1.5376699806115535e-01 2.0052263188834810e-01 2.6954922439798223e-03
     	 	 1.5287315008681190e-01 2.5676969793520837e-01 2.9188734620441371e-03
     	 	 1.4968128417436743e-01 3.1905370279228323e-01 3.0757777406856634e-03
     	 	 1.4625894927168559e-01 3.8455744497979766e-01 3.1031808284136091e-03
     	 	 1.4567216187538845e-01 4.4637542763816856e-01 2.7063406482430419e-03
     	 	 1.4878576709253899e-01 4.9443662209995815e-01 2.2729201421700950e-03
     	 	 1.5576835191451888e-01 5.3902223105386238e-01 2.5516391440633789e-03
     	 	 1.5507422351010780e-01 5.9334489109652910e-01 2.8077206329013209e-03
     	 	 1.5453593537983923e-01 6.4747421361496538e-01 2.6410279297591939e-03
     	 	 1.5540008805031513e-01 6.9624342726007327e-01 2.2739004148513058e-03
     	 	 1.5891598115656191e-01 7.3583272971076652e-01 2.1609236809759652e-03
     	 	 1.5014665713195352e-01 7.8199728604938135e-01 1.6893874109851436e-03
     	 	 1.6098118411845064e-01 8.0150965810824570e-01 1.3968196095814928e-03
     	 	 1.6316580789188728e-01 8.2128889473801758e-01 9.2885832065387928e-04
     	 	 1.6449553375157244e-01 8.3252322470661233e-01 4.0857662712272838e-04
     	 	 1.1495911708303663e-01 2.7268451523984861e-03 3.2476331381912980e-04
     	 	 1.1341837664418453e-01 1.4434328499772787e-02 7.5287725094606286e-04
     	 	 1.1110152763531189e-01 3.5697937304874409e-02 1.1675219514869775e-03
     	 	 1.0766953824627645e-01 6.6664345798487928e-02 1.5873225718141064e-03
     	 	 1.1478353308729317e-01 1.0670172061834909e-01 2.0365786552823187e-03
     	 	 1.0729433732297333e-01 1.5512059787217011e-01 2.2423689998221086e-03
     	 	 1.0675136221841586e-01 2.1008292769383519e-01 2.4992010036419387e-03
     	 	 1.0650338677818549e-01 2.7015603099894764e-01 2.6484284614889790e-03
     	 	 1.0443888805645751e-01 3.3337930531339360e-01 2.6340562327656857e-03
     	 	 1.0153914134536468e-01 3.9686478276298437e-01 2.5603337775045982e-03
     	 	 1.0119357274633733e-01 4.5867950472287727e-01 2.5024081859871127e-03
     	 	 1.0230668925126141e-01 5.1697263437471042e-01 2.3452350696901696e-03
     	 	 1.0952525813414249e-01 5.6663714265972331e-01 2.3754894559763827e-03
     	 	 1.0739504238731523e-01 6.2488151845399686e-01 2.5352642125127602e-03
     	 	 1.0743744865134719e-01 6.8204634695184663e-01 2.4316820649240736e-03
     	 	 1.0893511243792942e-01 7.3480357188454193e-01 2.2340580903120692e-03
     	 	 1.0933686689719002e-01 7.8281769188048422e-01 2.0106874350193219e-03
     	 	 1.0493540072704710e-01 8.2742019750476048e-01 1.4937998201921107e-03
     	 	 1.1174244758715868e-01 8.5179360256268499e-01 1.2041819964998851e-03
     	 	 1.1350836203084425e-01 8.7169579143956966e-01 7.7226922663744418e-04
     	 	 1.1466829611439266e-01 8.8253302837687075e-01 3.3072993757915677e-04
     	 	 7.2795168778066799e-02 2.9441925753127727e-03 2.8519302612402237e-04
     	 	 7.1757234065905617e-02 1.5457381379042991e-02 6.4883499948292897e-04
     	 	 7.0273220645837409e-02 3.7655181710139651e-02 9.7879541444629279e-04
     	 	 6.7419310187448733e-02 6.8869163040471290e-02 1.2553578460698846e-03
     	 	 7.3100153775053300e-02 1.0758273036289646e-01 1.6153831922429221e-03
     	 	 6.8004402947422271e-02 1.5413594655725524e-01 1.7589969625651806e-03
     	 	 6.7495580516504838e-02 2.0720876504578256e-01 1.9721631878051220e-03
     	 	 6.7585958406176316e-02 2.6607125382204472e-01 2.1487049859347652e-03
     	 	 6.6696729703188407e-02 3.2965387099527488e-01 2.2512077825315620e-03
     	 	 6.4580779789691123e-02 3.9715737500551473e-01 2.2867625162991366e-03
     	 	 6.3738468005695492e-02 4.6664337927682181e-01 2.3245007489663939e-03
     	 	 6.4773802936494373e-02 5.3554727333719787e-01 2.3178233882632806e-03
     	 	 6.9392469732630024e-02 6.0023411274544236e-01 2.3771610267177817e-03
     	 	 6.7598074813789766e-02 6.6632403185242761e-01 2.2184971006294395e-03
     	 	 6.8277293642956982e-02 7.2572888748384579e-01 2.0118188319139837e-03
     	 	 6.9463814457359607e-02 7.7813250178679716e-01 1.7834528656871795e-03
     	 	 6.8512053856402688e-02 8.2528725525153313e-01 1.5402650555972125e-03
     	 	 6.6930818902726896e-02 8.6545530143734395e-01 1.1792032074956283e-03
     	 	 7.0478238110594171e-02 8.9242919504574425e-01 9.6776428177156981e-04
     	 	 7.1769464903004621e-02 9.1292546465995250e-01 6.4174720561265344e-04
     	 	 7.2798654477703617e-02 9.2427309354282139e-01 2.8178174939503007e-04
     	 	 3.9659109510052470e-02 3.0367644740145828e-03 2.2061498442029121e-04
     	 	 3.9107435898587006e-02 1.5867581481656182e-02 4.9753314922784285e-04
     	 	 3.8237093366439323e-02 3.8478695901065972e-02 7.4812116813744920e-04
     	 	 3.6488075342860582e-02 7.0354920739470694e-02 9.5172865062671135e-04
     	 	 3.9802362983619055e-02 1.1042082307546332e-01 1.2622208245264483e-03
     	 	 3.6945814718238323e-02 1.5902860188667134e-01 1.3787298854809954e-03
     	 	 3.6753353964816937e-02 2.1427811429146529e-01 1.5337271245419526e-03
     	 	 3.6840623259836836e-02 2.7545697246218820e-01 1.6829977728543835e-03
     	 	 3.6325800342827841e-02 3.4187001055014610e-01 1.7757025527894053e-03
     	 	 3.5144958276041360e-02 4.1222400760773892e-01 1.7850191740741139e-03
     	 	 3.4573755566070896e-02 4.8390497999456039e-01 1.7790796175714129e-03
     	 	 3.5328729377946178e-02 5.5456335196647499e-01 1.7784972950113432e-03
     	 	 3.7890093567545247e-02 6.2221488912592915e-01 1.8353613743433131e-03
     	 	 3.6727050089622182e-02 6.8887895821572342e-01 1.6770511135380324e-03
     	 	 3.7174678069825440e-02 7.4981849948760060e-01 1.5625106919205742e-03
     	 	 3.8013853901874395e-02 8.0463105202188523e-01 1.4066805530148451e-03
     	 	 3.7021047417737374e-02 8.5382092773210283e-01 1.1907454214945047e-03
     	 	 3.6844200249559367e-02 8.9436554935694279e-01 9.3944320991497915e-04
     	 	 3.8265653829064661e-02 9.2449618480461071e-01 7.3677610286174242e-04
     	 	 3.9044412620324986e-02 9.4574599664056425e-01 4.8157130930897625e-04
     	 	 3.9789372059425232e-02 9.5731841548077423e-01 2.1019359961864937e-04
     	 	 1.6264458170248131e-02 2.9613326785512283e-03 1.3951809220154085e-04
     	 	 1.6058831911567761e-02 1.5646346333603001e-02 3.2184363985154630e-04
     	 	 1.5660388697443350e-02 3.8544248716311333e-02 4.9479830932717798e-04
     	 	 1.4934566076778788e-02 7.1510710128666694e-02 6.3718165800941379e-04
     	 	 1.6299632266736919e-02 1.1367801818133649e-01 8.5816752156560696e-04
     	 	 1.5085856121226593e-02 1.6471842139129489e-01 9.3436577438855669e-04
     	 	 1.5086370727777743e-02 2.2285644536831356e-01 1.0415388876443340e-03
     	 	 1.5103577784152833e-02 2.8671256199057471e-01 1.1271992196465656e-03
     	 	 1.4873471755896039e-02 3.5466356317580239e-01 1.1615173144486212e-03
     	 	 1.4390389618016530e-02 4.2494571260580627e-01 1.1464239283733892e-03
     	 	 1.4124198798977528e-02 4.9589672399323970e-01 1.1319726911421816e-03
     	 	 1.4485095466489128e-02 5.6628830459375801e-01 1.1461277828344254e-03
     	 	 1.5537036021438189e-02 6.3495357732896318e-01 1.1927367327116652e-03
     	 	 1.5080684802722288e-02 7.0161027549356281e-01 1.0967671060215676e-03
     	 	 1.5179955376717680e-02 7.6390945197027693e-01 1.0281299334679171e-03
     	 	 1.5663693655801558e-02 8.2035684710034407e-01 9.4163638839526444e-04
     	 	 1.5105306079041925e-02 8.7065372835507682e-01 7.8802868544166835e-04
     	 	 1.5191232779397823e-02 9.1248953500790009e-01 6.4157911272876803e-04
     	 	 1.5641901768901900e-02 9.4503717135552201e-01 4.9767632589038299e-04
     	 	 1.5962258246960070e-02 9.6794489622788660e-01 3.2794455194659237e-04
     	 	 1.6359949943484442e-02 9.8057897238231362e-01 1.4454690803300264e-04
     	 	 3.0993026289993786e-03 3.1980336486029225e-03 6.5095298693608475e-05
     	 	 3.0600915298758524e-03 1.6720524028598402e-02 1.4728490968621790e-04
     	 	 2.9743986197282579e-03 4.0532518343624938e-02 2.1897783863540280e-04
     	 	 2.8395724575646097e-03 7.3813391648143337e-02 2.7415963351317042e-04
     	 	 3.1197646885700037e-03 1.1544879453424076e-01 3.6429581202658854e-04
     	 	 2.8669455091622220e-03 1.6467673133153796e-01 3.8771826447390784e-04
     	 	 2.8773771484884580e-03 2.2069021871593986e-01 4.3671594428997126e-04
     	 	 2.8796284292609275e-03 2.8282643397095586e-01 4.7902191841927899e-04
     	 	 2.8449564161243668e-03 3.5004894176569396e-01 5.0549647512255450e-04
     	 	 2.7556758217278654e-03 4.2100641193965976e-01 5.1059908461533040e-04
     	 	 2.6864680949398867e-03 4.9411724834476156e-01 5.0697234356128647e-04
     	 	 2.7491636422146692e-03 5.6747612892223864e-01 5.1380925512631412e-04
     	 	 2.9543247653449622e-03 6.3911940587132421e-01 5.3264135420858275e-04
     	 	 2.8836127325964078e-03 7.0757388047361225e-01 4.9012101146688760e-04
     	 	 2.8819962797965726e-03 7.7140998903342017e-01 4.5189018881883132e-04
     	 	 2.9952062358061804e-03 8.2927440303449951e-01 4.1884887746041296e-04
     	 	 2.8692971927943844e-03 8.8023822678965269e-01 3.4582079048182631e-04
     	 	 2.9033183643408789e-03 9.2293942854847499e-01 2.8516662044019591e-04
     	 	 2.9793172823897596e-03 9.5653504151388680e-01 2.2051363853992800e-04
     	 	 3.0350215721740570e-03 9.8033083721888437e-01 1.4583446178961261e-04
     	 	 3.1236273476112908e-03 9.9370225674505930e-01 6.5118866678403085e-05
     	 	 ];


    case 42

        % SET: SLOBODKINS TAUSCH
        % CARDINALITY RULE  :    319
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 8.916e-16

        XYW=[
    	 	 9.9472717862608806e-01 2.7198174807020357e-03 4.5992063486748671e-05
     	 	 9.8280037545297783e-01 1.4403296869668483e-02 1.1740606658936555e-04
     	 	 9.8354940972872418e-01 2.8013855708342843e-03 1.1255086868105374e-04
     	 	 9.7075385184397478e-01 1.4633812811826789e-02 2.6908753031436078e-04
     	 	 9.6158265034393064e-01 3.5507498618803708e-02 1.9242248891137515e-04
     	 	 9.6322906051070145e-01 2.7504030598214449e-03 1.7677796882129622e-04
     	 	 9.5017140112812737e-01 1.4427609361052383e-02 4.0942898649723143e-04
     	 	 9.2749878166300226e-01 3.5205168978722813e-02 6.7089430592475439e-04
     	 	 9.4924244104023436e-01 3.5465784617328903e-02 4.3468629773801338e-04
     	 	 9.3147314211377419e-01 6.5880370615032435e-02 2.3667407973929831e-04
     	 	 9.3351624994577920e-01 2.7722716321404981e-03 2.4335167082603342e-04
     	 	 9.2061833395468307e-01 1.4572000064580391e-02 5.5288935966845624e-04
     	 	 8.9604812755856222e-01 3.5663612349000784e-02 9.0120933901781310e-04
     	 	 8.7128136720488081e-01 6.5523244913485698e-02 1.1411266414064654e-03
     	 	 9.0130368222498458e-01 6.4508177878294548e-02 8.2255613527019609e-04
     	 	 9.2115805333070799e-01 6.4913097604049050e-02 5.2999794854947620e-04
     	 	 8.9227490549765254e-01 1.0495047817079782e-01 3.0692046990160517e-04
     	 	 8.9494100459503023e-01 2.8159102895837979e-03 3.0821211660397402e-04
     	 	 8.8278752240017422e-01 1.4774128855045573e-02 6.9313540795723808e-04
     	 	 8.5659330807928924e-01 3.6070530704799875e-02 1.1012779235170559e-03
     	 	 8.3311659369821600e-01 6.6205068642657031e-02 1.4325918384543136e-03
     	 	 8.3061658342499500e-01 1.0408690515650394e-01 1.4581762956613533e-03
     	 	 8.6300993999117892e-01 1.0160097727852131e-01 1.0327410842802052e-03
     	 	 8.8303123378493364e-01 1.0244909724025379e-01 6.7861905752102623e-04
     	 	 8.4529601727996639e-01 1.5185162023526352e-01 3.6926682450774207e-04
     	 	 8.4840807654386474e-01 2.8214333421598186e-03 3.6291517568038626e-04
     	 	 8.3735323047946997e-01 1.4797003679074425e-02 8.1953682338451318e-04
     	 	 8.1096344620496252e-01 3.5996318934940714e-02 1.2426592857268689e-03
     	 	 7.8777645655904327e-01 6.6004440786844087e-02 1.6825049161716741e-03
     	 	 7.9179240057337508e-01 1.0462346639553956e-01 1.7837868447158685e-03
     	 	 7.8164319027945894e-01 1.5074875984806432e-01 1.7847794158830197e-03
     	 	 8.1776693732768602e-01 1.4562083692748484e-01 1.2414891226322634e-03
     	 	 8.3735248600757584e-01 1.4767456853784969e-01 8.2818649792634953e-04
     	 	 7.9504664989250640e-01 2.7588562011943438e-03 3.9936272523556616e-04
     	 	 7.8495929232513384e-01 1.4496037498889820e-02 9.1816595653935139e-04
     	 	 7.6122179981255134e-01 3.5358748702669654e-02 1.3231364718381323e-03
     	 	 7.4659709719576783e-01 1.0384489580104596e-01 2.0590569631864439e-03
     	 	 6.9674320445776949e-01 1.4809372732127449e-01 2.4099918279704884e-03
     	 	 7.4250763120515584e-01 1.5018518096174782e-01 2.1431640376627977e-03
     	 	 7.2867945168400849e-01 2.0450757552513099e-01 1.9445585323397158e-03
     	 	 7.6768318268284763e-01 1.9563617995311347e-01 1.3827220028702564e-03
     	 	 7.8486916152503494e-01 2.0007611022881633e-01 9.4534351183216765e-04
     	 	 7.9162264908462532e-01 2.0550707119735123e-01 4.1669365186808034e-04
     	 	 7.3591362917725422e-01 2.8615294132091056e-03 4.5052350750697772e-04
     	 	 7.2543113940647563e-01 1.4962880926418922e-02 1.0414451145682087e-03
     	 	 7.0649668089399720e-01 3.6496102676105355e-02 1.4325428969265348e-03
     	 	 7.3571976753518098e-01 6.5196900487473439e-02 1.9086976497851753e-03
     	 	 6.9439801819428126e-01 1.0296417320095928e-01 2.3369775812077101e-03
     	 	 6.5708971567627672e-01 1.9480401554295929e-01 1.9805565497345314e-03
     	 	 6.9307974190361288e-01 2.0235226236089696e-01 2.2596373474902246e-03
     	 	 6.7150928367751028e-01 2.6373183657638788e-01 2.0229028715938180e-03
     	 	 7.1278071958545086e-01 2.5143161052448243e-01 1.4900328873591350e-03
     	 	 7.2650050988837478e-01 2.5880501162822311e-01 1.0148805439091236e-03
     	 	 7.3246512074399006e-01 2.6473624761848852e-01 4.4179408021600145e-04
     	 	 6.7255084306336488e-01 2.6873794855494480e-03 4.5099802336877445e-04
     	 	 6.6194506098127315e-01 1.4133500442748191e-02 1.0574956738008180e-03
     	 	 6.5066644490486736e-01 3.4618136259438055e-02 1.4950697059364522e-03
     	 	 6.7543303233459140e-01 6.6255308378512429e-02 2.0980773613449846e-03
     	 	 6.3395929428251019e-01 1.0380409579924212e-01 2.5566481218739544e-03
     	 	 6.4234314628404743e-01 1.4747490038771568e-01 2.7710647265832148e-03
     	 	 6.1063823569887132e-01 1.9747507287916827e-01 2.2618424054135114e-03
     	 	 6.1831640213394812e-01 2.3619660449237725e-01 1.8343464848901794e-03
     	 	 6.3753866329589948e-01 2.6087317363156226e-01 2.4665293164901408e-03
     	 	 6.1520386899213508e-01 3.2234349486530844e-01 1.4382598259439375e-03
     	 	 6.5241839665961732e-01 3.1310848737499297e-01 1.5861849730326877e-03
     	 	 6.6349454936836649e-01 3.2244719210051320e-01 1.0378225334941420e-03
     	 	 6.6898356897346489e-01 3.2834673956541827e-01 4.4766695301076806e-04
     	 	 6.0554090244761327e-01 2.6877461788134775e-03 4.7137466701984050e-04
     	 	 5.9456467159730098e-01 1.4079079241431992e-02 1.0829578515763197e-03
     	 	 5.8796981742192878e-01 3.4288074373644159e-02 1.6096021886430130e-03
     	 	 6.1413730043596648e-01 6.3468862510821539e-02 2.1861651380645449e-03
     	 	 5.7359415769981914e-01 1.0007749535741753e-01 2.6766061616850432e-03
     	 	 5.8021649665777475e-01 1.4800302405513535e-01 3.0345678047271805e-03
     	 	 5.6714055819540377e-01 1.9658475867149686e-01 2.3041637752401721e-03
     	 	 5.5411537566235380e-01 2.4963946313885171e-01 2.8665985584704259e-03
     	 	 5.7224140980926275e-01 2.8134776385141591e-01 2.5593759920323447e-03
     	 	 5.7539773444651876e-01 3.2300144442961942e-01 2.6316230538758981e-03
     	 	 5.9300351114459515e-01 3.4019232951463135e-01 9.5805598865816204e-04
     	 	 5.8604728430434261e-01 3.7878743690756428e-01 1.6915697055645046e-03
     	 	 5.9684457529850565e-01 3.8864856047193586e-01 1.0987121419408930e-03
     	 	 6.0214726720124268e-01 3.9507884844066199e-01 4.8348780636006553e-04
     	 	 5.3610092130435838e-01 2.6802020059418221e-03 4.8255304331318321e-04
     	 	 5.2601016171515602e-01 1.4076748235423852e-02 1.0895058105634525e-03
     	 	 5.2004506280767138e-01 3.4332633166301273e-02 1.7088167150066216e-03
     	 	 5.4662789643312182e-01 6.2827061643127402e-02 2.2691506538772117e-03
     	 	 5.0657528097129445e-01 9.8951258812730244e-02 2.7427504996113709e-03
     	 	 5.2076333714472645e-01 1.4280165001291953e-01 3.0185088209259800e-03
     	 	 4.8584999594762945e-01 1.8972454914715517e-01 2.4382805124760604e-03
     	 	 5.1956540577483690e-01 2.0179720802346110e-01 2.3826890059972109e-03
     	 	 4.9601088366429480e-01 2.5495432055647888e-01 3.1678338221966217e-03
     	 	 4.9682204635488270e-01 3.0743499355497877e-01 3.1391839945132910e-03
     	 	 5.1386500691250636e-01 3.4111903055545156e-01 2.9892958762669998e-03
     	 	 5.0985107817531738e-01 3.8962461127407588e-01 2.7150234925907763e-03
     	 	 5.3760524689444433e-01 3.9883375552792033e-01 2.2276646417620062e-03
     	 	 5.1728614929045158e-01 4.4844330781387959e-01 1.7361114536181921e-03
     	 	 5.2908063389735904e-01 4.5693683552930825e-01 1.0836743933124611e-03
     	 	 5.3334156525993770e-01 4.6400362364158193e-01 4.7294455369633281e-04
     	 	 4.6569459610286246e-01 2.7137819445532327e-03 4.8843428542558740e-04
     	 	 4.5766564774496510e-01 1.4210155652271208e-02 1.0851642682964951e-03
     	 	 4.4953424276993892e-01 3.4532495396682426e-02 1.7414905970127063e-03
     	 	 4.7545454993397473e-01 6.3081321898148565e-02 2.3449635611242619e-03
     	 	 4.3630692794057169e-01 9.9550375658168488e-02 2.7841346061409280e-03
     	 	 4.5514492875034396e-01 1.4132747720182751e-01 3.0269673202280726e-03
     	 	 4.3139137671014693e-01 1.8760952476612952e-01 2.6476803787416786e-03
     	 	 4.3217403897613560e-01 2.2897420477098274e-01 1.9315768022146590e-03
     	 	 4.4073261817423415e-01 2.5761635101613989e-01 2.8560416495260607e-03
     	 	 4.3318618662258312e-01 3.1639595618344413e-01 3.6192735721910863e-03
     	 	 4.3726908489513638e-01 3.6871580369085433e-01 3.2547076269831376e-03
     	 	 4.4967130799232569e-01 4.0651716357767997e-01 3.0984132322399100e-03
     	 	 4.4362794161880847e-01 4.5684034683163888e-01 2.6735961223208478e-03
     	 	 4.6908204785499208e-01 4.6790690435680909e-01 2.2931248524911477e-03
     	 	 4.4645517948379909e-01 5.1910328108034065e-01 1.7357941912215622e-03
     	 	 4.6037803973751856e-01 5.2547219342717089e-01 1.0950054567252703e-03
     	 	 4.6392678648298991e-01 5.3336987035243222e-01 4.7845553481153433e-04
     	 	 3.9627133857410435e-01 2.6677861483785799e-03 4.6778316800120799e-04
     	 	 3.9025683291481561e-01 1.4033378543521869e-02 1.0661673873260053e-03
     	 	 3.7935849261709109e-01 3.4405695513360736e-02 1.7153978854119803e-03
     	 	 4.0327176591613656e-01 6.3357592821920508e-02 2.3612656663083067e-03
     	 	 3.6761399561109542e-01 1.0063455979518074e-01 2.7350041323966068e-03
     	 	 3.8595805228304281e-01 1.4435773959123327e-01 3.2494460221897349e-03
     	 	 3.7483584054161190e-01 1.9579257483026494e-01 2.8651990269872763e-03
     	 	 3.7011413028436568e-01 2.5011295752736412e-01 3.5924321884007247e-03
     	 	 3.7644649314514445e-01 3.0475064976623145e-01 3.6055968419844938e-03
     	 	 3.6683115105665753e-01 3.5682303936505516e-01 2.1382988914777183e-03
     	 	 3.7294856128347320e-01 3.8918602833531690e-01 2.8348338106678863e-03
     	 	 3.7613024700195075e-01 4.3455368158579083e-01 3.0095993143491582e-03
     	 	 3.8455977087762716e-01 4.7343317165011217e-01 2.9642571567584952e-03
     	 	 3.7833590417714646e-01 5.2197148089829881e-01 2.5024394624304663e-03
     	 	 3.9855842877149283e-01 5.3808330249505043e-01 2.3008182810503393e-03
     	 	 3.7661325689725744e-01 5.8861291252569481e-01 1.6953680809971535e-03
     	 	 3.9162319472113916e-01 5.9412241028554047e-01 1.1008819573311876e-03
     	 	 3.9575256043824281e-01 6.0153082121893142e-01 4.6669371136421760e-04
     	 	 3.2953059967086629e-01 2.7226399384191764e-03 4.5295942077350860e-04
     	 	 3.2356301773628471e-01 1.4294160925518022e-02 1.0612772922191389e-03
     	 	 3.1206888276687461e-01 3.4866980438793882e-02 1.6054062322799674e-03
     	 	 3.3289503276243981e-01 6.3682290305828032e-02 2.2945244105501104e-03
     	 	 3.0340233002557149e-01 1.0092134999675746e-01 2.4918421233293088e-03
     	 	 3.1820811652469982e-01 1.4545874112220455e-01 3.1598603034897264e-03
     	 	 3.2303998466008843e-01 1.9522215942830887e-01 2.6935679144014200e-03
     	 	 3.0677641712422510e-01 2.5231327720129526e-01 3.6313183095876113e-03
     	 	 3.1153799367760082e-01 3.1216636993050872e-01 3.8474779463494942e-03
     	 	 3.1075539322845991e-01 3.7389504644943056e-01 3.7043051192276358e-03
     	 	 3.0823490133330567e-01 4.3715715709374509e-01 3.6002980032204001e-03
     	 	 3.1536250306907421e-01 4.8579857913311791e-01 3.1630861947572137e-03
     	 	 3.1894976919263440e-01 5.3403380623691665e-01 3.1147043382623012e-03
     	 	 3.1778307866453415e-01 5.7979040513386582e-01 2.4078667884825742e-03
     	 	 3.2850772279752172e-01 6.0722248064142648e-01 2.3097308858027062e-03
     	 	 3.1089833734621797e-01 6.5421666525378386e-01 1.5741360616202532e-03
     	 	 3.2383021270051437e-01 6.6190734641225324e-01 1.0767555399596881e-03
     	 	 3.3030634768890488e-01 6.6697910709017838e-01 4.4401159905326876e-04
     	 	 2.6667909273792378e-01 2.7790845649052834e-03 4.3247536742926245e-04
     	 	 2.5895789502481747e-01 1.4565357859404144e-02 1.0296141863426846e-03
     	 	 2.5115247375639993e-01 3.5448877661445041e-02 1.4288754840027890e-03
     	 	 2.6544259186398012e-01 6.4390980337170098e-02 2.1540951007191392e-03
     	 	 2.4706457157942030e-01 1.0114417838473470e-01 2.0381100596038471e-03
     	 	 2.5462293531379732e-01 1.4462605818646804e-01 2.8727577265744782e-03
     	 	 2.4556581103386266e-01 1.9219810466137599e-01 2.0805492245259440e-03
     	 	 2.7767717990540530e-01 1.9834037008794933e-01 1.9308563136713590e-03
     	 	 2.4651651929242635e-01 2.5120220191239390e-01 3.3338143739085088e-03
     	 	 2.5041132365026675e-01 3.1117597434346256e-01 3.6371209667390675e-03
     	 	 2.5120845273649961e-01 3.7380610365774269e-01 3.6966839089843380e-03
     	 	 2.5175172294731951e-01 4.3698336369759272e-01 3.6001189264397979e-03
     	 	 2.4801052178407390e-01 5.0144464508766429e-01 3.4413339015447377e-03
     	 	 2.5887846714281393e-01 5.4660454194041663e-01 2.9624131874113457e-03
     	 	 2.5568686921628303e-01 6.0000567612439515e-01 2.9282169861712779e-03
     	 	 2.6234205569379687e-01 6.3785000149853199e-01 2.1908278648955478e-03
     	 	 2.6199518386415577e-01 6.7424807420105370e-01 2.1007674296742882e-03
     	 	 2.5190438266523740e-01 7.1314185671966368e-01 1.3532795312145305e-03
     	 	 2.5852542231836606e-01 7.2706171745196380e-01 1.0272816481018152e-03
     	 	 2.6824785143676033e-01 7.2900557277571720e-01 4.2455718749669178e-04
     	 	 2.0812665137040054e-01 2.7849640406345240e-03 4.0234728957405750e-04
     	 	 1.9864255401661746e-01 1.4663330626498740e-02 9.5371747254187171e-04
     	 	 1.9838136610629398e-01 3.5979087860797038e-02 1.2866765080514154e-03
     	 	 2.0291850838070136e-01 6.6214320948800753e-02 2.0491026792321403e-03
     	 	 1.9968183798898442e-01 1.0607918251482894e-01 1.9839810040434727e-03
     	 	 1.9512243039198729e-01 1.5174154098345202e-01 2.7639382165902107e-03
     	 	 1.9790969033060013e-01 2.0463016843672069e-01 2.8041538779109516e-03
     	 	 1.9241668499040265e-01 2.5992318154928618e-01 2.8679250203794858e-03
     	 	 1.9413717114637985e-01 3.1716062917369847e-01 3.1649049775477351e-03
     	 	 1.9486181268998093e-01 3.7734586922777452e-01 3.2940770127459313e-03
     	 	 1.9620035399030000e-01 4.3837640841445941e-01 3.2485963961030114e-03
     	 	 1.9593856761686301e-01 4.9819679897474778e-01 3.0883320777049636e-03
     	 	 1.9104584072492869e-01 5.5853637013417490e-01 2.9045937057466270e-03
     	 	 2.0447195571914978e-01 5.9830022843981312e-01 2.7448466559704529e-03
     	 	 1.9620271209266160e-01 6.5510093440966066e-01 2.6448336417188019e-03
     	 	 2.0795638654684157e-01 6.8818657042675746e-01 2.2299465426773649e-03
     	 	 2.0074425445444599e-01 7.3322133735066641e-01 1.9874361397242122e-03
     	 	 2.0081601910392688e-01 7.6307344751684192e-01 1.2624796357640392e-03
     	 	 1.9766128068458577e-01 7.8758904445456734e-01 9.6449220087294930e-04
     	 	 2.0977709768355968e-01 7.8742188336933494e-01 4.0535035476232251e-04
     	 	 1.5433781868569407e-01 2.7997245238626711e-03 3.6618721025605315e-04
     	 	 1.4470819201643992e-01 1.4621972004470825e-02 8.2035318558618738e-04
     	 	 1.5051880645884486e-01 3.5422502566306226e-02 1.1695686528260000e-03
     	 	 1.4770797464914420e-01 6.4893731212983294e-02 1.7139638458683892e-03
     	 	 1.5352199164353897e-01 1.0229198153602788e-01 1.9529936866610825e-03
     	 	 1.4318286600668295e-01 1.4778620538034945e-01 2.3958487909924169e-03
     	 	 1.4733739307681759e-01 2.0138802773485073e-01 2.7595352524261820e-03
     	 	 1.4409910157650851e-01 2.6119927732512627e-01 2.8675590321992879e-03
     	 	 1.4356020435621208e-01 3.2526396586390038e-01 3.0686182441750742e-03
     	 	 1.4406466806653750e-01 3.9057780611829812e-01 3.1486727926495353e-03
     	 	 1.4564548849711534e-01 4.5641178472653809e-01 3.1672185111518585e-03
     	 	 1.4556843599380764e-01 5.2238364794675496e-01 3.0726845573324666e-03
     	 	 1.4300912686602973e-01 5.8448450002102681e-01 2.4534101248109004e-03
     	 	 1.3500834742743462e-01 6.2238328068145277e-01 1.0100765072423488e-03
     	 	 1.5206198769746926e-01 6.4589465092754461e-01 2.6574269940374483e-03
     	 	 1.4414340551920712e-01 7.0527748274409618e-01 2.3871314490181692e-03
     	 	 1.5540587367741343e-01 7.4018329877721234e-01 2.1391069945452829e-03
     	 	 1.4619270728980049e-01 7.8781086423879221e-01 1.7409633858291923e-03
     	 	 1.5277445931657174e-01 8.1136184379276077e-01 1.2134000329370633e-03
     	 	 1.4339735645112650e-01 8.4186475142924755e-01 8.3550044853202856e-04
     	 	 1.5578488352233688e-01 8.4140122171356291e-01 3.7015880492371892e-04
     	 	 1.0650712430699882e-01 2.7764199651658388e-03 3.1563941028620062e-04
     	 	 9.9257856059748573e-02 1.4607718035053383e-02 6.7503198407091122e-04
     	 	 1.0564671239387979e-01 3.5777076292531462e-02 1.0956729506939669e-03
     	 	 1.0118719047970315e-01 6.5702216888426118e-02 1.4197641542129614e-03
     	 	 1.0775419548983323e-01 1.0314067295751865e-01 1.7857156111974926e-03
     	 	 9.8638068126299827e-02 1.4657513434881259e-01 1.8283709543859830e-03
     	 	 1.0207522451211748e-01 1.9493471263794693e-01 2.1457155721366829e-03
     	 	 1.0117388428883090e-01 2.4928751285592804e-01 2.3429174906989601e-03
     	 	 1.0017220656440007e-01 3.1094368134434514e-01 2.5843491722755177e-03
     	 	 9.9456004680192667e-02 3.7710397226259423e-01 2.7232026490698409e-03
     	 	 1.0067888629333910e-01 4.4399708112033243e-01 2.7435323693273924e-03
     	 	 1.0163583653106412e-01 5.1043144518748063e-01 2.7170456148735414e-03
     	 	 1.0054141920705462e-01 5.7690827732087224e-01 2.6495475271763507e-03
     	 	 9.7210980168729533e-02 6.4226682068196994e-01 2.3627293786769596e-03
     	 	 1.0451207248748140e-01 6.9382595471180986e-01 2.3359410741066030e-03
     	 	 9.9905470612400848e-02 7.4998853699009593e-01 1.9514801299288492e-03
     	 	 1.0791245387261872e-01 7.8741522630760785e-01 1.8637999078694441e-03
     	 	 9.9952673674442605e-02 8.3365123742603653e-01 1.4339917489765810e-03
     	 	 1.0717362137943254e-01 8.5667761427269218e-01 1.1195310197353210e-03
     	 	 9.7482416008818351e-02 8.8769839076435875e-01 6.9216550891788495e-04
     	 	 1.0769088586667275e-01 8.8949487836468188e-01 3.2153857622620202e-04
     	 	 6.6275217680046961e-02 2.7688669315359946e-03 2.5478068369349930e-04
     	 	 6.3163537001873493e-02 1.4466234002401284e-02 5.1219623747150343e-04
     	 	 6.6316069549408718e-02 3.5296171500708302e-02 8.9827349153040437e-04
     	 	 6.4134307243842059e-02 6.4878951549081659e-02 1.1090448065071976e-03
     	 	 6.7374558526358208e-02 1.0343322171800606e-01 1.5433055140078986e-03
     	 	 6.3131183674621116e-02 1.5111717054203350e-01 1.6370401814804706e-03
     	 	 6.4057134992658193e-02 2.0583331714360567e-01 1.9834861354904483e-03
     	 	 6.4283148957110514e-02 2.6747175218271468e-01 2.1186146601247032e-03
     	 	 6.3303633400083159e-02 3.3355786982020813e-01 2.2150651900009859e-03
     	 	 6.2787775076572960e-02 4.0193336065900914e-01 2.2502521072017847e-03
     	 	 6.3839020932082047e-02 4.7037102125601760e-01 2.2992386927042346e-03
     	 	 6.4440662269721671e-02 5.3944336701372486e-01 2.3028627680271572e-03
     	 	 6.3264012716215401e-02 6.0803190794302941e-01 2.1955684467828496e-03
     	 	 6.1809817197565398e-02 6.7339432669684218e-01 1.9642477468831561e-03
     	 	 6.5775413718810793e-02 7.2915344562492013e-01 1.9625025557135026e-03
     	 	 6.3796386374475933e-02 7.8463882492315717e-01 1.6259281381693991e-03
     	 	 6.7544880694796250e-02 8.2755760505158582e-01 1.5341333448343378e-03
     	 	 6.2966372632493717e-02 8.7067173441118617e-01 1.1155483362718078e-03
     	 	 6.7397403416872947e-02 8.9639657304862130e-01 9.2683157638707775e-04
     	 	 6.0928119026856797e-02 9.2416747564938095e-01 5.3141767453545252e-04
     	 	 6.7263554425022076e-02 9.2988903458429217e-01 2.6316370036133323e-04
     	 	 3.5080794415843219e-02 2.9079110203389458e-03 1.9633587582102175e-04
     	 	 3.5664926144106102e-02 1.5392501928432559e-02 4.1612759799382440e-04
     	 	 3.5240835973986973e-02 3.7427206986088001e-02 7.0669373312077534e-04
     	 	 3.5703247078255673e-02 6.9127207742432348e-02 8.8190868688389540e-04
     	 	 3.6177025638675642e-02 1.0819379590026304e-01 1.1281551134109005e-03
     	 	 3.5023368777292174e-02 1.5359616278612906e-01 1.1463479976650164e-03
     	 	 3.4310072385868473e-02 2.0279105878305934e-01 1.2922886430020214e-03
     	 	 3.5301372606952208e-02 2.5671486975963193e-01 1.4188036824263747e-03
     	 	 3.4694665671692437e-02 3.1638118987689684e-01 1.5494620214282111e-03
     	 	 3.4226880674520732e-02 3.8118151531970912e-01 1.6284617179426256e-03
     	 	 3.4291232151787865e-02 4.4849114158736181e-01 1.6632548311901554e-03
     	 	 3.5106734154699559e-02 5.1492013985173313e-01 1.6552460900033825e-03
     	 	 3.4951411655343434e-02 5.8045415716366888e-01 1.6190314949456549e-03
     	 	 3.4126112672349662e-02 6.4444422908606713e-01 1.5164588113259344e-03
     	 	 3.3968432466407350e-02 7.0434723263378873e-01 1.3835448724725673e-03
     	 	 3.5616816685896557e-02 7.5865974953388082e-01 1.4005598951006496e-03
     	 	 3.5245454900755813e-02 8.1124299630426044e-01 1.2263760077993696e-03
     	 	 3.6259078949062218e-02 8.5700073723041426e-01 1.1468741839989461e-03
     	 	 3.4824685670137190e-02 8.9770457016767269e-01 8.5422832299838082e-04
     	 	 3.5990647407181720e-02 9.2756955776708949e-01 7.0120705759531287e-04
     	 	 3.3688927403614399e-02 9.5149160276746014e-01 3.8897567083478335e-04
     	 	 3.5898510306099696e-02 9.6128855307485006e-01 1.9158563381229456e-04
     	 	 1.3816279907036266e-02 2.7668001451536940e-03 1.1468669300630140e-04
     	 	 1.5299149941110479e-02 1.4457091798484190e-02 2.6970341457649666e-04
     	 	 1.3923219844018453e-02 3.4920920290687392e-02 4.0283852596338031e-04
     	 	 1.4994750454054739e-02 6.4089844450106695e-02 5.5557069215668583e-04
     	 	 1.4577236525467940e-02 1.0196297181994034e-01 7.0182484561160004e-04
     	 	 1.4732655557483820e-02 1.4798663432643325e-01 8.1811111147802890e-04
     	 	 1.3886392183312002e-02 2.0169442187455333e-01 9.0302730821057266e-04
     	 	 1.4531158087264240e-02 2.6133851623529497e-01 1.0149549431062114e-03
     	 	 1.4198058922548218e-02 3.2559442549289513e-01 1.0575472049266961e-03
     	 	 1.4038106228000280e-02 3.9288973266750343e-01 1.0804380204610478e-03
     	 	 1.4036409265500205e-02 4.6197088854513202e-01 1.1067012773520696e-03
     	 	 1.4442635600498188e-02 5.3184301001840728e-01 1.1410855873471538e-03
     	 	 1.4273380307198491e-02 6.0167048569657933e-01 1.1121754008284490e-03
     	 	 1.3930630763612672e-02 6.6972208783497789e-01 1.0438602009413028e-03
     	 	 1.4120962513947566e-02 7.3397870195403281e-01 9.8373801619024452e-04
     	 	 1.4554402850712078e-02 7.9265831618149962e-01 9.2714203274545158e-04
     	 	 1.4707376604910283e-02 8.4547923424419191e-01 8.0492235419611495e-04
     	 	 1.4589398169189360e-02 8.9019773140066349e-01 6.7587191396766423e-04
     	 	 1.4609705635241332e-02 9.2663062851501032e-01 5.1251487697907404e-04
     	 	 1.4355353729440856e-02 9.5384012545061703e-01 3.7689533194417872e-04
     	 	 1.4306639843150060e-02 9.7265624717730059e-01 2.2748833124850034e-04
     	 	 1.4347787737041928e-02 9.8312397463740786e-01 1.0697329207119406e-04
     	 	 2.5244339537429106e-03 2.6209980028042510e-03 4.4267809912530076e-05
     	 	 2.9887928643963502e-03 1.4007539093917320e-02 1.2238540452919649e-04
     	 	 2.5768588769252698e-03 3.4794692789923989e-02 1.6998653205323899e-04
     	 	 2.9031126617371505e-03 6.4875075394415768e-02 2.5614762110146521e-04
     	 	 2.7402149616477800e-03 1.0362715737735582e-01 3.0164280664137221e-04
     	 	 2.8436658129017411e-03 1.5009116925397650e-01 3.6339730389042373e-04
     	 	 2.6125723436769555e-03 2.0330519522802293e-01 3.7776239328869753e-04
     	 	 2.7829638593569461e-03 2.6221309957626293e-01 4.3824779386610096e-04
     	 	 2.7031557808047113e-03 3.2592262918894971e-01 4.5549626041221046e-04
     	 	 2.6812008858708714e-03 3.9315327999224126e-01 4.7063394624155183e-04
     	 	 2.6657663805960130e-03 4.6240394456011868e-01 4.7693003830114592e-04
     	 	 2.7520226822711491e-03 5.3206308516633050e-01 4.8941549194684360e-04
     	 	 2.7288286049197419e-03 6.0071205715964060e-01 4.7389413622146666e-04
     	 	 2.6563206953489349e-03 6.6737013574237558e-01 4.4545516928269250e-04
     	 	 2.6882138044921344e-03 7.3118928758440527e-01 4.2731769262418926e-04
     	 	 2.7415590037546123e-03 7.9088493097782964e-01 4.0231683088632063e-04
     	 	 2.8328915881208339e-03 8.4491280552705306e-01 3.6864712104536931e-04
     	 	 2.7496108566731348e-03 8.9230046762296189e-01 3.0806367108686649e-04
     	 	 2.8328726827769879e-03 9.3163349575301935e-01 2.5372608297056099e-04
     	 	 2.6875013793814517e-03 9.6225107956261602e-01 1.7867953326962499e-04
     	 	 2.8035935764634257e-03 9.8312259585397654e-01 1.1545252900354560e-04
     	 	 2.6697559547281813e-03 9.9469708735768270e-01 4.6763113335235171e-05
     	 	 ];


    case 43

        % SET: SLOBODKINS TAUSCH
        % CARDINALITY RULE  :    334
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 1.277e-15

        XYW=[
    	 	 9.9404510698714166e-01 3.0124386443823128e-03 5.8224173646591643e-05
     	 	 9.8150887088672345e-01 1.5776912210727686e-02 1.2355037062093902e-04
     	 	 9.8182847294150222e-01 2.7222830068912630e-03 1.2204480124830897e-04
     	 	 9.7110460587978875e-01 1.4538380655757801e-02 2.7053073218619991e-04
     	 	 9.3449500699206389e-01 3.0906912899837890e-02 5.6776998060335088e-04
     	 	 9.5905556563025829e-01 3.8258597924235589e-02 1.8662163953983856e-04
     	 	 9.5991548059635134e-01 2.3613004961220889e-03 1.6311880071849527e-04
     	 	 9.5213830388641763e-01 1.2495200024647084e-02 3.6152250045011356e-04
     	 	 8.8188691080113224e-01 5.6912974945702688e-02 9.0586851664059586e-04
     	 	 9.4997376440536241e-01 3.5940320278265901e-02 4.1598145917592705e-04
     	 	 9.2758087966983982e-01 6.9765367802433087e-02 2.4336647822246129e-04
     	 	 9.2857501655778207e-01 2.4528407796455170e-03 2.2331099106764809e-04
     	 	 9.2206432056260401e-01 1.2838856252791304e-02 4.9352526790966849e-04
     	 	 9.0469606925650525e-01 3.1284360060970753e-02 7.5006609340792817e-04
     	 	 9.0813836117955937e-01 5.8150450478502758e-02 7.5423087556197768e-04
     	 	 9.1931412374464105e-01 6.6781654560461576e-02 5.5168082682680768e-04
     	 	 8.8771859030072697e-01 1.0959314981430635e-01 3.0181842170339353e-04
     	 	 8.8904626752778770e-01 2.5184927486958577e-03 2.7929406741784797e-04
     	 	 8.8356353957208644e-01 1.3171314472515447e-02 6.2638804815648300e-04
     	 	 8.6623448652894719e-01 3.2127215517205952e-02 9.5803352865992048e-04
     	 	 8.4469180638427077e-01 5.9086727596090523e-02 1.2049058074429563e-03
     	 	 8.4734561879250569e-01 8.9232419928920531e-02 1.1862783063798341e-03
     	 	 8.7153193614898061e-01 9.4086555461319360e-02 9.9804506016503585e-04
     	 	 8.7982041974848446e-01 1.0606498167825683e-01 6.8909097385871638e-04
     	 	 8.4020341259065090e-01 1.5707411768420179e-01 3.5635293805643818e-04
     	 	 8.4227749513278982e-01 2.5762839052400205e-03 3.3038987972499478e-04
     	 	 8.3731818470033592e-01 1.3518658172772081e-02 7.5713131188878398e-04
     	 	 8.2018041243642903e-01 3.3077956038624172e-02 1.1567084501361491e-03
     	 	 8.0094798141613321e-01 6.0732706585761936e-02 1.4512312490952619e-03
     	 	 8.0371365748096979e-01 9.4960069911304054e-02 1.6799281009262487e-03
     	 	 8.0812839210821208e-01 1.2819125759066491e-01 1.4107344501182876e-03
     	 	 8.2666925605044139e-01 1.3858861013073484e-01 1.2056654688069007e-03
     	 	 8.3295486451594036e-01 1.5277884431494132e-01 8.0466746795075216e-04
     	 	 7.8586736963503523e-01 2.1146895901002410e-01 3.9295697051190887e-04
     	 	 7.8932384856575588e-01 2.6328925226133575e-03 3.7543023835047353e-04
     	 	 7.8429072845445280e-01 1.3778544674100137e-02 8.6754958600514004e-04
     	 	 7.6803282244824034e-01 3.3515702117500074e-02 1.3057269220774510e-03
     	 	 7.5083148162690316e-01 6.1357759554935123e-02 1.6862074454203576e-03
     	 	 7.5632344656188399e-01 9.6052658986529690e-02 1.9154956937948097e-03
     	 	 7.2260120941814177e-01 1.3677628788870433e-01 1.8834544126217841e-03
     	 	 7.6152839618714019e-01 1.3897851749083931e-01 1.8588178706479440e-03
     	 	 7.6150562539401379e-01 1.7557910370992422e-01 1.6706990899436934e-03
     	 	 7.7479463386800118e-01 1.9093936334953704e-01 1.3579187712556022e-03
     	 	 7.8011217099941721e-01 2.0589052779024697e-01 8.8066617637062557e-04
     	 	 7.2556120569933769e-01 2.7182716837656656e-01 4.2165055469467038e-04
     	 	 7.3132879671097351e-01 2.5986274719034816e-03 4.0136645204937895e-04
     	 	 7.2564988714456258e-01 1.3683302472851324e-02 9.4794522353109268e-04
     	 	 7.1089037580383052e-01 3.3492979603742673e-02 1.4339925197166330e-03
     	 	 6.9438824895315232e-01 6.1726679722638296e-02 1.9026498944005085e-03
     	 	 7.0199954819234844e-01 9.7283873934594908e-02 2.2341444291175340e-03
     	 	 6.7401557707353721e-01 1.4033709211247711e-01 2.2068940605206541e-03
     	 	 6.7458723386976871e-01 1.8359202451056553e-01 2.2981572907352769e-03
     	 	 7.1142199260953431e-01 1.8984333736083353e-01 2.1332150519752318e-03
     	 	 7.0696410732957404e-01 2.3092153372368424e-01 1.8952238377036475e-03
     	 	 7.1716900901545810e-01 2.4920241198454118e-01 1.4598591081457100e-03
     	 	 7.2225461781731015e-01 2.6401469151577089e-01 9.3284606501804843e-04
     	 	 6.6925199507437472e-01 2.7142443833639224e-03 4.4240330528900671e-04
     	 	 6.6203640160993449e-01 1.4155423258308923e-02 1.0352705134310913e-03
     	 	 6.4880748908185304e-01 3.4341686671113279e-02 1.5406208577789387e-03
     	 	 6.3285299007676610e-01 6.2435278520714822e-02 2.0051513876771119e-03
     	 	 6.4208680518130135e-01 9.8011274397722808e-02 2.4550701679255191e-03
     	 	 6.2475542346405422e-01 1.4065625820008415e-01 2.3381492088574646e-03
     	 	 5.6903861212306994e-01 1.8008119066551984e-01 2.2819740397998791e-03
     	 	 6.1693065448998952e-01 1.9142369055850358e-01 2.9186313083558002e-03
     	 	 6.2302930532054501e-01 2.3612201919286738e-01 2.5552749639859680e-03
     	 	 6.5631103505596577e-01 2.4591291134460194e-01 2.2822415923432768e-03
     	 	 6.4690848061926642e-01 2.9247516363912440e-01 2.0077853915114385e-03
     	 	 6.5532312191951592e-01 3.1186202379990685e-01 1.5059493523017725e-03
     	 	 6.6036816567638779e-01 3.2625568876942013e-01 9.6682531043663000e-04
     	 	 6.6043939551578212e-01 3.3702389621797862e-01 4.3682582808535490e-04
     	 	 6.0448976286821543e-01 2.3916809113045728e-03 4.0704506618417189e-04
     	 	 5.9643147213848735e-01 1.2697033453243370e-02 9.8095714858055386e-04
     	 	 5.8569812669039956e-01 3.1422339891046411e-02 1.5226501656517867e-03
     	 	 5.6981456636151662e-01 5.8748261295579654e-02 2.1036138581157298e-03
     	 	 5.7781701040193156e-01 9.5635308322264231e-02 2.5168161096110202e-03
     	 	 5.7186442908409263e-01 1.3589308313427320e-01 2.4180596011273330e-03
     	 	 5.1436873972842467e-01 1.8391837929306643e-01 2.4156164403200489e-03
     	 	 5.4162541652773977e-01 2.2124391034085780e-01 2.2884940996979707e-03
     	 	 5.6262362512025310e-01 2.5137469267222040e-01 2.9790297993469717e-03
     	 	 5.6839082608051239e-01 2.9654396227633095e-01 2.7542047406092156e-03
     	 	 6.0201892086525588e-01 3.0373289749369559e-01 2.1043125033836352e-03
     	 	 5.8262076093058357e-01 3.5919744752072924e-01 2.0505193447958475e-03
     	 	 5.9120573388750475e-01 3.7728129900791801e-01 1.4727112339530818e-03
     	 	 5.9501729378607338e-01 3.9206043104548199e-01 9.7452614304889475e-04
     	 	 5.9190792434354211e-01 4.0562672687644580e-01 4.4003786709446383e-04
     	 	 5.3727466908858590e-01 2.5567665089624072e-03 4.4429057650372910e-04
     	 	 5.2761767341159338e-01 1.3418701652733855e-02 1.0379096255181772e-03
     	 	 5.1807303027029372e-01 3.2537682054639139e-02 1.5591949794238036e-03
     	 	 5.0178434632836766e-01 5.9038353711601134e-02 2.0410511701713405e-03
     	 	 5.1537178039046494e-01 9.2592215604540340e-02 2.4342844815348919e-03
     	 	 4.8517473549867263e-01 1.2884506593394857e-01 1.7759232221360034e-03
     	 	 5.1683745543551829e-01 1.3990830090851847e-01 2.1644452188964314e-03
     	 	 4.6830087351341088e-01 1.9158170059679930e-01 1.9568370103786544e-03
     	 	 4.7660494229180150e-01 2.3666686082903252e-01 2.7912282415967376e-03
     	 	 4.9497546591736197e-01 2.6910057393816500e-01 2.4355881563831922e-03
     	 	 4.6159883056902740e-01 3.1159380128246444e-01 1.9862149484278953e-03
     	 	 5.0695582378891924e-01 3.1340300032192497e-01 3.0112088384118421e-03
     	 	 5.0573451030115657e-01 3.6175103851828377e-01 2.8671507521163273e-03
     	 	 5.4851825106977192e-01 3.5946117699959018e-01 2.1034105562163191e-03
     	 	 4.8993606089239050e-01 4.1713590679577767e-01 2.1935179425217857e-03
     	 	 5.1407896100309136e-01 4.2694317387912145e-01 2.0857098525752650e-03
     	 	 5.2571237616666866e-01 4.4199194837394851e-01 1.5071815123799959e-03
     	 	 5.2691481849504895e-01 4.5985493481245765e-01 1.0322785545487088e-03
     	 	 5.2179382749092096e-01 4.7568402609836191e-01 4.5502482875085033e-04
     	 	 4.6930282417858882e-01 2.5429737645862632e-03 4.4218778014704356e-04
     	 	 4.5913708346528170e-01 1.3211548577441475e-02 1.0089219093487394e-03
     	 	 4.4995980801924007e-01 3.2009704242982412e-02 1.5629643796511812e-03
     	 	 4.3418711264463050e-01 5.8514315728601808e-02 2.0245769661538758e-03
     	 	 4.4830205127218825e-01 9.1780829081179724e-02 2.4279277638645548e-03
     	 	 4.2788969605518345e-01 1.3109299562249549e-01 2.5648553719549829e-03
     	 	 4.4007232659291740e-01 1.7057727984926443e-01 2.4650105616891961e-03
     	 	 4.0769128942354671e-01 2.1986004245058735e-01 2.4823414791118781e-03
     	 	 4.2069632434412030e-01 2.5197038515916959e-01 2.4515738425336690e-03
     	 	 4.1776022063270724e-01 3.0079095059374017e-01 3.2675507349953824e-03
     	 	 4.1407492587951111e-01 3.5656717325069009e-01 2.7375396262018250e-03
     	 	 4.4457918088451542e-01 3.7745939229307274e-01 3.0816876093912936e-03
     	 	 4.3814150443372724e-01 4.2862710991998798e-01 2.8973114021081771e-03
     	 	 4.3069185846739066e-01 4.7702176856500556e-01 2.2684110319703445e-03
     	 	 4.4564027346609669e-01 4.9618157658453299e-01 2.1011439662688334e-03
     	 	 4.6034970435861322e-01 5.0814313402230393e-01 1.4888847130421063e-03
     	 	 4.5718454508347683e-01 5.2991434476287602e-01 1.0171579920824918e-03
     	 	 4.5165057608131087e-01 5.4589804065692726e-01 4.3767982877888516e-04
     	 	 4.0187213750376793e-01 2.3982230966098170e-03 4.1269094658071876e-04
     	 	 3.9193202356382040e-01 1.2755451763561257e-02 9.7416704918283777e-04
     	 	 3.8156322987097357e-01 3.1621874092992927e-02 1.5716105632239885e-03
     	 	 3.6866221583911862e-01 5.8868732705949368e-02 1.9927919924201667e-03
     	 	 3.8117024511011544e-01 9.3364237799427277e-02 2.5347699531813248e-03
     	 	 3.6460797820649027e-01 1.3559455977679188e-01 2.8037287647913870e-03
     	 	 3.7606456757848361e-01 1.8074850054806380e-01 3.0539988946483932e-03
     	 	 3.5012011050436220e-01 2.4075498245469276e-01 2.9872956647348601e-03
     	 	 3.5738911812108698e-01 2.9274589590389094e-01 3.5855495765690945e-03
     	 	 3.5526959735130204e-01 3.5131153075176830e-01 3.4317617068410650e-03
     	 	 3.5946625081797789e-01 4.0167864944766080e-01 2.9226063034972290e-03
     	 	 3.7782598866680905e-01 4.3851802819575014e-01 3.3480858519510082e-03
     	 	 3.7274019114755530e-01 4.9145456191604764e-01 2.8903139658229462e-03
     	 	 3.7010610981001801e-01 5.3511956229462909e-01 2.3036202910124851e-03
     	 	 3.7657230426971500e-01 5.6359216726645389e-01 2.1130008672591788e-03
     	 	 3.9429669589648553e-01 5.7331332491670617e-01 1.5287568076402900e-03
     	 	 3.8814708105439732e-01 5.9852989754656916e-01 1.0229695946125036e-03
     	 	 3.8309986577989574e-01 6.1434693015768493e-01 4.4080335512972150e-04
     	 	 3.3598152109752233e-01 2.6345313811315949e-03 4.3418911821304084e-04
     	 	 3.2526899819523769e-01 1.3899529341202909e-02 1.0178211442493324e-03
     	 	 3.1376835841060891e-01 3.3880822719812714e-02 1.5716364811935014e-03
     	 	 3.0664296737102614e-01 6.1804917421185962e-02 1.8464276062713806e-03
     	 	 3.1608690946163487e-01 9.5713739399151926e-02 2.4302162234460249e-03
     	 	 3.0296664931084394e-01 1.3718999715572341e-01 2.6449806866237348e-03
     	 	 3.0992062689740596e-01 1.8344403520400632e-01 2.9984712972934836e-03
     	 	 3.3553788453275080e-01 2.1067556876850610e-01 8.0308089356137037e-04
     	 	 2.9139180465581838e-01 2.3911128634494436e-01 2.9660049314849694e-03
     	 	 2.9449439636271157e-01 2.9508798951988069e-01 3.4414152077638298e-03
     	 	 2.9613479649644048e-01 3.5278198395359545e-01 3.5416040527257910e-03
     	 	 2.9591255510933956e-01 4.1266341151379038e-01 3.3816914909238082e-03
     	 	 3.0799731059323232e-01 4.6003476440907259e-01 3.0154835651484174e-03
     	 	 3.1364779610478999e-01 5.0518517218608250e-01 3.0677288974643412e-03
     	 	 3.0878688274753174e-01 5.5610982981816914e-01 2.7036525630180558e-03
     	 	 3.0983774670798325e-01 5.9587113312948237e-01 2.2605683366193167e-03
     	 	 3.1043554470447132e-01 6.2933619583004685e-01 1.9689939860057883e-03
     	 	 3.2887248559265825e-01 6.3812728316086931e-01 1.5147462299757877e-03
     	 	 3.2132221966573549e-01 6.6504714964203959e-01 9.9821724594315172e-04
     	 	 3.1714452127388160e-01 6.8025195657467241e-01 4.2946444214463970e-04
     	 	 2.7358664318326487e-01 2.6702670632579796e-03 4.1328309099420769e-04
     	 	 2.6193939065319338e-01 1.3946733416156518e-02 9.6581957877233705e-04
     	 	 2.5077168542708095e-01 3.3978123897844763e-02 1.4739907753542835e-03
     	 	 2.4972644792529031e-01 6.2594308628618367e-02 1.8118952462592916e-03
     	 	 2.5299157243131487e-01 9.8991510494957413e-02 2.4090153423128287e-03
     	 	 2.4500483129540884e-01 1.4222087432485783e-01 2.5220946807284210e-03
     	 	 2.5004604761974591e-01 1.8920428608298701e-01 2.9028078028983592e-03
     	 	 2.3896038852470247e-01 2.4080174564723644e-01 2.7305987912384249e-03
     	 	 2.3716278804709257e-01 2.9616867537093750e-01 3.1064811534654551e-03
     	 	 2.3716313004100309e-01 3.5401156795022515e-01 3.2939888346763127e-03
     	 	 2.3930771008834528e-01 4.1176194744820638e-01 3.2497348326291863e-03
     	 	 2.3017206175099814e-01 4.7256842830576873e-01 2.3944020214975549e-03
     	 	 2.5611317472001316e-01 4.6144794957408131e-01 1.0143318039552492e-03
     	 	 2.5084874426424697e-01 5.1024300045992110e-01 2.8947274330653043e-03
     	 	 2.5215374963293768e-01 5.6035901540930777e-01 2.9622780596096272e-03
     	 	 2.4945611053821615e-01 6.1029788335354251e-01 2.5789277531320797e-03
     	 	 2.5012523065345404e-01 6.5222595414519868e-01 2.3175570760285221e-03
     	 	 2.4895288174853658e-01 6.8949321498666505e-01 1.9026683092198463e-03
     	 	 2.6519410333924709e-01 7.0160693597940038e-01 1.4807066372787658e-03
     	 	 2.5835506595978652e-01 7.2810522443337000e-01 9.2809995083148011e-04
     	 	 2.5472772510078978e-01 7.4269998618089628e-01 3.9776387573822112e-04
     	 	 2.1530513360068748e-01 2.6060199502029742e-03 3.7541341538212784e-04
     	 	 2.0274826919011735e-01 1.3704777294576845e-02 8.8245510972291346e-04
     	 	 1.9329560104190791e-01 3.3504327471263425e-02 1.3088786994561964e-03
     	 	 1.9588525911602706e-01 6.1748906446936765e-02 1.6844981350285250e-03
     	 	 1.9560793714187230e-01 9.8133924080290744e-02 2.1918854804979190e-03
     	 	 1.9192178656012993e-01 1.4204110919106905e-01 2.4419252945953669e-03
     	 	 1.9316621490624364e-01 1.9303932593044890e-01 2.8870168609848187e-03
     	 	 1.8801721520418824e-01 2.4967103382531397e-01 2.8766545537954697e-03
     	 	 1.8474294962116600e-01 3.0904212661621905e-01 2.9695192531769580e-03
     	 	 1.8346442470771629e-01 3.6875585232162228e-01 3.0039521196983869e-03
     	 	 1.8552476515727845e-01 4.2663346990992695e-01 2.8643778077723074e-03
     	 	 1.8299853356740048e-01 4.7880512333721831e-01 2.3167764476700330e-03
     	 	 1.8420037541949530e-01 5.2515876643822845e-01 2.2825745403267268e-03
     	 	 1.9704836758121425e-01 5.6268892465748388e-01 2.7828025012918006e-03
     	 	 1.9486917043616514e-01 6.1702742221710105e-01 2.7742619891098358e-03
     	 	 1.9473492390067337e-01 6.6609750215609365e-01 2.4186947415409080e-03
     	 	 1.9354986705490174e-01 7.1004054376315640e-01 2.1242971783063994e-03
     	 	 1.9318628863202014e-01 7.4571142049396444e-01 1.6500889460168244e-03
     	 	 2.0586798283963792e-01 7.6060215638696727e-01 1.3531387552265430e-03
     	 	 2.0064488747316334e-01 7.8552709103277563e-01 8.5237238706127659e-04
     	 	 1.9698601723703524e-01 8.0036765454628400e-01 3.7330029833376949e-04
     	 	 1.6156491124239258e-01 2.6486140556067684e-03 3.4692558687434902e-04
     	 	 1.4854247690629385e-01 1.3947329362397091e-02 8.0133756184366193e-04
     	 	 1.4253542580593448e-01 3.4018075270963469e-02 1.1348900476497398e-03
     	 	 1.4604635420281753e-01 6.2114521233266724e-02 1.5204111140150773e-03
     	 	 1.4435455614865100e-01 9.7799538386382001e-02 1.8791508292800132e-03
     	 	 1.4296419757881673e-01 1.4027812939862397e-01 2.1185382455329014e-03
     	 	 1.4297612490372402e-01 1.8919131680496920e-01 2.4512521678054363e-03
     	 	 1.4082126002264805e-01 2.4408390758243134e-01 2.6336815336317752e-03
     	 	 1.3799636200837584e-01 3.0459313319229298e-01 2.7827977636521424e-03
     	 	 1.3571919359119611e-01 3.6880514140406540e-01 2.9044237131722462e-03
     	 	 1.8098526307097407e-01 3.9893643921365118e-01 4.5085942598093633e-05
     	 	 1.3646812854000789e-01 4.3413621918989354e-01 2.9802012256706372e-03
     	 	 1.3632386991213585e-01 4.9905805263485048e-01 2.8706973454818269e-03
     	 	 1.3808389189999015e-01 5.6126924484785190e-01 2.7342584495770000e-03
     	 	 1.4582142185147406e-01 6.1386803808143764e-01 2.7425233484120876e-03
     	 	 1.4402474664663445e-01 6.7012541740092613e-01 2.4480495707277753e-03
     	 	 1.4490334654977799e-01 7.1749720448016308e-01 2.1195256991494169e-03
     	 	 1.4214123454074390e-01 7.6203359087160394e-01 1.8583096301709480e-03
     	 	 1.4409017146176628e-01 7.9534919641242652e-01 1.4598736773757145e-03
     	 	 1.5199366072280773e-01 8.1511084420109658e-01 1.1979454591853238e-03
     	 	 1.4874886072318172e-01 8.3786053104188396e-01 7.3824724760136653e-04
     	 	 1.4492675783577547e-01 8.5254042359731308e-01 3.1738519371871294e-04
     	 	 1.1351657944694837e-01 2.6912763021637136e-03 3.0893924080810348e-04
     	 	 1.0126613611157731e-01 1.4185990058871542e-02 6.9397373119449912e-04
     	 	 9.9692487164483312e-02 3.4699895633197253e-02 9.7141196952555168e-04
     	 	 1.0137294371482319e-01 6.3844839003687162e-02 1.3838907653974939e-03
     	 	 9.9976977887721530e-02 1.0129002606574883e-01 1.6732528698899316e-03
     	 	 9.9628923691832294e-02 1.4615752380270183e-01 1.9329016164768265e-03
     	 	 9.9080109887917822e-02 1.9724658139568058e-01 2.1653883253159910e-03
     	 	 9.7957564191541779e-02 2.5337028271924461e-01 2.2804611898250781e-03
     	 	 9.6219450154647168e-02 3.1253430609135530e-01 2.3127434015272818e-03
     	 	 9.4325329025225835e-02 3.7342258171518805e-01 2.3347753211820275e-03
     	 	 9.4384671877240867e-02 4.3549135592652194e-01 2.4068733331638484e-03
     	 	 9.4387220539612571e-02 4.9751909898987384e-01 2.3635212045276894e-03
     	 	 9.5555779053618561e-02 5.5675903126182258e-01 2.2148412398032666e-03
     	 	 9.7190299158991800e-02 6.1040047590282409e-01 2.0244291128525215e-03
     	 	 1.0159612726316780e-01 6.5758498765695605e-01 2.1204856727465261e-03
     	 	 9.9861279576382911e-02 7.1037655700616620e-01 2.0370630841856328e-03
     	 	 1.0088548718296642e-01 7.5803292938614053e-01 1.8893638278479436e-03
     	 	 9.7903317518766464e-02 8.0407966236746398e-01 1.6116164405628542e-03
     	 	 1.0070724459084035e-01 8.3753248090157528e-01 1.2998916251655915e-03
     	 	 1.0511451716773046e-01 8.6142673328939179e-01 1.0299060002063555e-03
     	 	 1.0372711907209808e-01 8.8250450727633989e-01 6.4238992507296196e-04
     	 	 9.9832632111339636e-02 8.9751842458811437e-01 2.7987755363311211e-04
     	 	 7.2480080627506771e-02 2.7244298749000114e-03 2.5902578264489011e-04
     	 	 6.2283436985860585e-02 1.4310230432797172e-02 5.5521692079198799e-04
     	 	 6.4309317894990503e-02 3.4754173068842327e-02 7.8888278620816397e-04
     	 	 6.3669877132962904e-02 6.3594565892441252e-02 1.1047410852632173e-03
     	 	 6.3369046560860731e-02 9.9964170133911512e-02 1.3072895646526381e-03
     	 	 6.3101144620846927e-02 1.4337048540845909e-01 1.5330493689568057e-03
     	 	 6.2656895534386692e-02 1.9318311329292773e-01 1.7213427009674432e-03
     	 	 6.2196847473260375e-02 2.4871502456879374e-01 1.8744112979429503e-03
     	 	 6.1151692731738594e-02 3.0927909713770285e-01 1.9825783729919473e-03
     	 	 5.9908043338172012e-02 3.7342625298399262e-01 2.0191623404863315e-03
     	 	 5.9508789755842839e-02 4.3949282886830038e-01 2.0665526989636931e-03
     	 	 5.9480417889297255e-02 5.0601692473954996e-01 2.0666178105427807e-03
     	 	 6.0446590876155337e-02 5.7139455334291200e-01 2.0412128450310813e-03
     	 	 6.1667589207247020e-02 6.3440600521426094e-01 1.9849467698860486e-03
     	 	 6.3906312659838593e-02 6.9249224771190154e-01 1.9180607286906329e-03
     	 	 6.3381766110945925e-02 7.4729513039979889e-01 1.6730941650225958e-03
     	 	 6.3679387413159594e-02 7.9513960656104865e-01 1.5058615172510602e-03
     	 	 6.1464243821847231e-02 8.3936588645624255e-01 1.2565409901030098e-03
     	 	 6.3922266700536245e-02 8.7262109709092073e-01 1.0674630815577177e-03
     	 	 6.6268732684790277e-02 8.9893958282160435e-01 8.5455073119627772e-04
     	 	 6.5835802606917126e-02 9.1986765683504823e-01 5.5053432006549015e-04
     	 	 6.2607073279087877e-02 9.3467355653803152e-01 2.3097380610871568e-04
     	 	 3.9732895236479160e-02 2.7466989317843468e-03 1.9871365678564718e-04
     	 	 3.2592303979505077e-02 1.4463642468129135e-02 4.0594314415242700e-04
     	 	 3.5868965934783059e-02 3.5329156702602588e-02 6.3091697512094669e-04
     	 	 3.4243285163133574e-02 6.5144052678718131e-02 8.5219775225665515e-04
     	 	 3.4667215704710319e-02 1.0339300807395564e-01 1.0401268587587765e-03
     	 	 3.4286990672440787e-02 1.4938980395777227e-01 1.2193943154821898e-03
     	 	 3.4074738187865883e-02 2.0218238549340464e-01 1.3608724035126737e-03
     	 	 3.3849419522272162e-02 2.6058771819362292e-01 1.4700549574699444e-03
     	 	 3.3189182821955376e-02 3.2342705363359503e-01 1.5325804588869184e-03
     	 	 3.2645748119010554e-02 3.8929516186619523e-01 1.5535350481272329e-03
     	 	 3.2295003589630555e-02 4.5663667259389151e-01 1.5675920532315806e-03
     	 	 3.2313938078029403e-02 5.2409549981570991e-01 1.5568958006755445e-03
     	 	 3.2980553857752781e-02 5.9001410145002031e-01 1.5398208281953143e-03
     	 	 3.3610267153805329e-02 6.5368398658693727e-01 1.5062077257479178e-03
     	 	 3.4631095855457872e-02 7.1396699527450014e-01 1.4729094869986897e-03
     	 	 3.4702214046186786e-02 7.7069493447999426e-01 1.3403103454624535e-03
     	 	 3.4462855822275484e-02 8.2236988985518567e-01 1.2011457584491178e-03
     	 	 3.3426766134176389e-02 8.6817258362186633e-01 9.8234788119105345e-04
     	 	 3.4966454765635424e-02 9.0352954535545105e-01 8.1566261291149010e-04
     	 	 3.6112486698486990e-02 9.3067290051235829e-01 6.1951678503298206e-04
     	 	 3.5801401080277406e-02 9.5066740870870658e-01 3.9357980654475971e-04
     	 	 3.3766569476243569e-02 9.6367329759025799e-01 1.6065758944044614e-04
     	 	 1.6363933264682440e-02 2.7699829821906498e-03 1.3069362640164204e-04
     	 	 1.2676833530760545e-02 1.4560908098807437e-02 2.4677013245990627e-04
     	 	 1.4998409542718250e-02 3.5510202247648760e-02 4.2424814137339325e-04
     	 	 1.3842537274080025e-02 6.5253710415855370e-02 5.3633607758793683e-04
     	 	 1.4293256797193510e-02 1.0320253169798901e-01 6.7153828775654164e-04
     	 	 1.4034822034005190e-02 1.4869170153484176e-01 7.7705619820211014e-04
     	 	 1.3969077669843455e-02 2.0099344035041572e-01 8.7381794144993888e-04
     	 	 1.3900961201235851e-02 2.5925940564231514e-01 9.5365343547815836e-04
     	 	 1.3620093469415284e-02 3.2238854355901370e-01 1.0013688023728417e-03
     	 	 1.3425537193206050e-02 3.8927084559585279e-01 1.0325314599982491e-03
     	 	 1.3221948474362200e-02 4.5854915570509763e-01 1.0438563282570436e-03
     	 	 1.3211683721485290e-02 5.2870465613677819e-01 1.0475654202887102e-03
     	 	 1.3508212190424640e-02 5.9824073130165689e-01 1.0491935649076746e-03
     	 	 1.3789894554078419e-02 6.6548906761600579e-01 1.0216912867799181e-03
     	 	 1.4143550366676361e-02 7.2887081432570977e-01 9.8043969629461078e-04
     	 	 1.4280034965662325e-02 7.8731193234061481e-01 8.9296723178404870e-04
     	 	 1.4083891773245316e-02 8.3969735142718538e-01 7.7549436838235701e-04
     	 	 1.3702847281871100e-02 8.8507655439190436e-01 6.4003921987042885e-04
     	 	 1.4285516202009352e-02 9.2218453179919113e-01 5.4298361314173902e-04
     	 	 1.4808190390941722e-02 9.5096469072753975e-01 4.1455181412031298e-04
     	 	 1.4682782588322452e-02 9.7139058447026605e-01 2.6121337142209430e-04
     	 	 1.3772724666476055e-02 9.8357079297081240e-01 1.0607016823764172e-04
     	 	 3.1265406647231764e-03 2.7865523616469059e-03 5.7220712855699984e-05
     	 	 2.2921670213845724e-03 1.4611965670235432e-02 9.8292167882232123e-05
     	 	 2.8910548265880243e-03 3.5583891764474233e-02 1.8784712643904152e-04
     	 	 2.6090878726423572e-03 6.5242283846531204e-02 2.2673587585924420e-04
     	 	 2.7346880514319549e-03 1.0293210167474100e-01 2.9028988410379039e-04
     	 	 2.6725938675045136e-03 1.4782375212805673e-01 3.3023079131522677e-04
     	 	 2.6612679633685188e-03 1.9897264152220412e-01 3.6816694238547013e-04
     	 	 2.6546812845574808e-03 2.5541003029514336e-01 3.9984753925433535e-04
     	 	 2.6004110217647813e-03 3.1622535030961602e-01 4.1833374566806485e-04
     	 	 2.5676057643221339e-03 3.8064171322084300e-01 4.3390200722927437e-04
     	 	 2.5261198272149565e-03 4.4780906805098147e-01 4.4196183959078328e-04
     	 	 2.5078079196445557e-03 5.1680368506968100e-01 4.4723505495585550e-04
     	 	 2.5577795227237354e-03 5.8631448641187589e-01 4.5402822786681459e-04
     	 	 2.6154260046435951e-03 6.5464560687983397e-01 4.5084487019357236e-04
     	 	 2.6733226199142646e-03 7.2021284396270702e-01 4.3661598646411916e-04
     	 	 2.7233562529451749e-03 7.8140233220190558e-01 4.0877202383267624e-04
     	 	 2.6999195111624408e-03 8.3691264798252363e-01 3.6165066195291190e-04
     	 	 2.6150087481420226e-03 8.8568658332227312e-01 3.0204030498737590e-04
     	 	 2.6916227250084468e-03 9.2662656951113098e-01 2.5360136968000720e-04
     	 	 2.8142703473360564e-03 9.5867794393099626e-01 1.9846456667064682e-04
     	 	 2.8085615673786313e-03 9.8137117461564360e-01 1.2815378230725364e-04
     	 	 2.6267920812367285e-03 9.9434629855711210e-01 5.2220004281378425e-05
     	 	 ];


    case 44

        % SET: SLOBODKINS TAUSCH
        % CARDINALITY RULE  :    349
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 8.509e-16

        XYW=[
    	 	 9.9542580398690539e-01 2.3898031004414046e-03 3.5300187492792292e-05
     	 	 9.8436940888717817e-01 1.3023779801742122e-02 1.0073449867860109e-04
     	 	 9.8512562385028113e-01 2.7452880534646657e-03 1.0051628203888443e-04
     	 	 9.7250034679139497e-01 1.4163236926732841e-02 2.2257293116098348e-04
     	 	 9.6493575690389488e-01 3.2856680355619575e-02 1.3998276492781377e-04
     	 	 9.6674917458357013e-01 2.1763649058895080e-03 1.3303545979564504e-04
     	 	 9.5756389411613363e-01 1.1727822316478858e-02 2.8574068160696779e-04
     	 	 9.3848218259830696e-01 3.0888045983994892e-02 5.4562391018749738e-04
     	 	 9.5537950919507630e-01 3.2789653285252594e-02 3.0277027734745203e-04
     	 	 9.3539990915703330e-01 6.1900466155107352e-02 2.3199386957647419e-04
     	 	 9.3820860492816882e-01 2.6903715396784903e-03 2.2347109544150587e-04
     	 	 9.3175756060507420e-01 1.4008817645740046e-02 4.2801721230104723e-04
     	 	 9.0801191631224609e-01 3.3494681269061070e-02 7.4814450802500830e-04
     	 	 9.0744603008161107e-01 5.8688952408539018e-02 7.5846636675066766e-04
     	 	 9.2855597205132268e-01 5.7281452903760570e-02 4.4503971464826845e-04
     	 	 8.9767774257725419e-01 9.9759079548403240e-02 2.7591545503368858e-04
     	 	 9.0166259191966991e-01 2.5350812934014848e-03 2.6532663437002312e-04
     	 	 9.0003888715730329e-01 1.3549690604786398e-02 5.6560367967237114e-04
     	 	 8.7304884609978162e-01 3.3119977737219558e-02 9.2287955244270761e-04
     	 	 8.7733174224668675e-01 6.0935735503827901e-02 9.7934981401461962e-04
     	 	 8.4320514160316584e-01 9.5586430399031169e-02 1.2272032693849467e-03
     	 	 8.7260932510672551e-01 9.4094672805581731e-02 9.2817441302196302e-04
     	 	 8.9659797682773201e-01 8.9806274497689437e-02 5.6856754733516034e-04
     	 	 8.5216134374830244e-01 1.4524870961732256e-01 3.2373376058098566e-04
     	 	 8.5746969967440145e-01 2.5266682569568709e-03 3.0589083255493500e-04
     	 	 8.5937676986521272e-01 1.3156605360806782e-02 6.7080787453233028e-04
     	 	 8.3293077392389636e-01 3.1882514233609098e-02 1.0037336296690536e-03
     	 	 8.0201348996381827e-01 5.8462593327725992e-02 1.4060163632348968e-03
     	 	 8.4207975063920282e-01 6.0974190369376811e-02 1.2427221222037856e-03
     	 	 8.0660465405363047e-01 9.6534083032689247e-02 1.5196937079332514e-03
     	 	 8.0126644949255121e-01 1.3792725533142802e-01 1.4726776993810673e-03
     	 	 8.3138798492693478e-01 1.3566360854166301e-01 1.0436932586205452e-03
     	 	 8.5547858732875315e-01 1.3101854717775885e-01 6.9273102958139769e-04
     	 	 8.0055948890546524e-01 1.9684491672238083e-01 3.6092608851754585e-04
     	 	 8.0770407317756954e-01 2.5725006645176481e-03 3.4282488448365665e-04
     	 	 8.0971779276238531e-01 1.3467175904697060e-02 8.0607287049087038e-04
     	 	 7.8482637765821339e-01 3.3151206491173382e-02 1.1668167269659902e-03
     	 	 7.4898020283314115e-01 6.1529093613820106e-02 1.7330115824187018e-03
     	 	 7.6827918783914950e-01 9.2606869352325399e-02 1.7174257446684648e-03
     	 	 7.2559377427693228e-01 1.3488952546961427e-01 2.1531730761869716e-03
     	 	 7.6576792518090064e-01 1.3772654501182807e-01 1.7071514446899668e-03
     	 	 7.5128689422352979e-01 1.8782590250910719e-01 1.6600509856711828e-03
     	 	 7.8476749924636868e-01 1.8181361062094664e-01 1.1449436072723661e-03
     	 	 8.0580331095345414e-01 1.8051750386298274e-01 8.2226321150837185e-04
     	 	 7.5388667329447401e-01 2.5777992353152946e-03 3.6700547267345528e-04
     	 	 7.5366695806363648e-01 1.3554312756969163e-02 8.9787135768183994e-04
     	 	 7.3499066696017923e-01 3.2865263955447983e-02 1.2082040751518796e-03
     	 	 6.9537776055466982e-01 5.8457319228059343e-02 1.7317282368614533e-03
     	 	 7.1612967184836740e-01 9.7711879037119295e-02 1.9446156694400529e-03
     	 	 6.6948626947203049e-01 1.3674760077512904e-01 2.1586034246327641e-03
     	 	 6.7967583714837265e-01 1.8625770765644012e-01 2.1933399736267802e-03
     	 	 7.2194951455161993e-01 1.8264343185068052e-01 1.7532433560774553e-03
     	 	 6.9836188333000448e-01 2.4353552191250907e-01 1.7309083158725206e-03
     	 	 7.3578719754384692e-01 2.3212350162441170e-01 1.2124527541233232e-03
     	 	 7.4978053826014324e-01 2.3701264633926578e-01 8.8075848623607423e-04
     	 	 7.4427409820474777e-01 2.5323756919668128e-01 3.7098730768520498e-04
     	 	 6.9691285599226016e-01 2.3468921016601570e-03 3.5341231655323176e-04
     	 	 6.9332343271565899e-01 1.2483090147778925e-02 8.9054388537130778e-04
     	 	 6.8139894074445229e-01 3.0643625810244837e-02 1.3091728847244644e-03
     	 	 6.3773249960919465e-01 5.6300127690296346e-02 1.8241534664843622e-03
     	 	 6.6907048075823705e-01 9.1679327298872931e-02 2.0482768798189993e-03
     	 	 6.6231004353793343e-01 1.6512676021318207e-01 1.1225131772475525e-03
     	 	 6.2498680325365519e-01 2.4123370941427383e-01 2.5830113112491541e-03
     	 	 6.7383565704332848e-01 2.3381999181328528e-01 2.0460589718310149e-03
     	 	 6.4077516745758989e-01 3.0153930059176154e-01 1.7630923366362345e-03
     	 	 6.7986145343494020e-01 2.8905749126285207e-01 1.3490126798489986e-03
     	 	 6.8877116106753300e-01 2.9862725831694925e-01 9.0631948317328257e-04
     	 	 6.8521198298767039e-01 3.1241028454804803e-01 3.6459826690533919e-04
     	 	 6.3669293630818857e-01 2.4277096405093262e-03 3.8483800132295469e-04
     	 	 6.2920359741687681e-01 1.2672678246061940e-02 9.2829696188647000e-04
     	 	 6.1928976164639948e-01 3.0879057777095927e-02 1.4174304685810868e-03
     	 	 6.1112073460109706e-01 8.9794922733810900e-02 2.2913468719794657e-03
     	 	 6.1987631347707950e-01 1.3027116467037930e-01 2.4922227196793861e-03
     	 	 5.9481848760624811e-01 1.7640854929933505e-01 2.5142789306708537e-03
     	 	 6.1815137274386367e-01 2.0056060620846550e-01 2.3155271128950747e-03
     	 	 5.6775825381654788e-01 2.5128578896366993e-01 2.6551237433265480e-03
     	 	 5.6964347947985328e-01 2.9986823763759302e-01 2.3808130204753778e-03
     	 	 6.1792110613109252e-01 2.9043937866222264e-01 2.1990382230274532e-03
     	 	 5.8782026999097114e-01 3.5579194271620684e-01 1.3352698664130572e-03
     	 	 6.1801785565355138e-01 3.5065721559970547e-01 1.4053993120856261e-03
     	 	 6.2390478641763902e-01 3.6312137091208790e-01 9.5862110028851447e-04
     	 	 6.2528404555539674e-01 3.7220684000101245e-01 3.8601058908290252e-04
     	 	 5.7303359639042539e-01 2.4710476808234988e-03 4.1339808842504565e-04
     	 	 5.6311132238264427e-01 1.3056770034428327e-02 9.8171967920166435e-04
     	 	 5.5348698952974362e-01 3.1918211148595631e-02 1.5138075648801143e-03
     	 	 5.7304148240527819e-01 5.7728965912099368e-02 1.9812083432985675e-03
     	 	 5.4703338209441499e-01 9.1471251727367101e-02 2.3557985092758625e-03
     	 	 5.5953575152618318e-01 1.3065528938588097e-01 2.6953702335559527e-03
     	 	 5.4062968188881411e-01 1.7661986621133163e-01 2.7538803194248358e-03
     	 	 5.3697184490301830e-01 2.2857285108574066e-01 3.0940844424914796e-03
     	 	 5.2412141180556338e-01 3.0533266012813187e-01 2.2891815866024844e-03
     	 	 5.2785948393884241e-01 3.5014756671888958e-01 1.3748675150487787e-03
     	 	 5.5939404682335492e-01 3.5270747104307926e-01 2.1887094742211602e-03
     	 	 5.4384006502389082e-01 3.9984675733724323e-01 1.3598912586884257e-03
     	 	 5.5308154721340930e-01 4.1637915948551618e-01 1.4608860155681358e-03
     	 	 5.5709180192387941e-01 4.3048721648599692e-01 9.5543519823169248e-04
     	 	 5.6449487646199015e-01 4.3317097007655564e-01 3.7099869858278091e-04
     	 	 5.0681662103402758e-01 2.5584960715565809e-03 4.3815762401752634e-04
     	 	 4.9644734152691528e-01 1.3353862156224933e-02 9.9365457314265927e-04
     	 	 4.8642875397926166e-01 3.2392513056087667e-02 1.5490202091078501e-03
     	 	 5.0496018021222633e-01 5.9118349949951188e-02 2.0863735813491813e-03
     	 	 4.8243582500580862e-01 9.3191717947649966e-02 2.3553429107508674e-03
     	 	 4.9550650085877246e-01 1.3222050312503872e-01 2.7134800073061005e-03
     	 	 4.8118694137095630e-01 1.7687457152374964e-01 2.8619112325263432e-03
     	 	 4.8166005560094882e-01 2.2425816903566034e-01 2.7753438962442685e-03
     	 	 4.5906853521228386e-01 2.6889761020831782e-01 2.2138772754276719e-03
     	 	 4.8800668708937367e-01 2.9096438242031719e-01 3.0916306922517561e-03
     	 	 4.6971241913136719e-01 3.5466165220290907e-01 2.6157238461589002e-03
     	 	 4.8884489991454394e-01 3.7843270035980486e-01 2.0689218869887217e-03
     	 	 4.9286473408217357e-01 4.1666959657376701e-01 2.4406949683045075e-03
     	 	 4.9064709794925565e-01 4.5205794577483516e-01 1.7510626920179179e-03
     	 	 4.8624715776966931e-01 4.8240937361605218e-01 1.4929094901327824e-03
     	 	 4.8914606671029037e-01 4.9794111785100398e-01 9.8203249460378683e-04
     	 	 5.0145143948426552e-01 4.9608752470405004e-01 4.0421793162402457e-04
     	 	 4.3976908393062930e-01 2.4615230628217094e-03 4.2408776701846401e-04
     	 	 4.3084308549950479e-01 1.2973374579541144e-02 9.6175703722622063e-04
     	 	 4.1954926055002484e-01 3.1885392746372782e-02 1.5365819461564626e-03
     	 	 4.3639283103073268e-01 5.9164919456179174e-02 2.1062159260475939e-03
     	 	 4.1977083819283045e-01 9.3684161333247903e-02 2.3641768304372649e-03
     	 	 4.3046389295028153e-01 1.3472954667296685e-01 2.8209284536910334e-03
     	 	 4.1851081268057311e-01 1.8098061006089325e-01 2.9693126323937979e-03
     	 	 4.2039713402702106e-01 2.2930811058945302e-01 3.1078625721955447e-03
     	 	 3.9896950405145915e-01 2.8051106746841142e-01 2.5440005500436905e-03
     	 	 4.1345922798797174e-01 3.1308377253814929e-01 2.3101714650431092e-03
     	 	 4.2330729364738628e-01 3.5160437504564473e-01 3.1469371514820728e-03
     	 	 4.0895437003304680e-01 4.1326244514287008e-01 2.9936350365786495e-03
     	 	 4.3330540821047825e-01 4.3588287963342959e-01 2.6402140964854378e-03
     	 	 4.2666865688252043e-01 4.8131782401693540e-01 2.3811051008563989e-03
     	 	 4.2886252042881734e-01 5.1244621180654304e-01 1.9100746365787998e-03
     	 	 4.1955838905908560e-01 5.4810831868996757e-01 1.5178461224976346e-03
     	 	 4.2188156214464678e-01 5.6484324149746501e-01 9.9571802325051895e-04
     	 	 4.3651833754213587e-01 5.6096438313695407e-01 4.2232749132911559e-04
     	 	 3.7316729182156039e-01 2.5018556537470802e-03 4.2145398067346482e-04
     	 	 3.6622985065122493e-01 1.3076923645816292e-02 9.3297956390794965e-04
     	 	 3.5405291094161073e-01 3.1645676642285694e-02 1.4403443298951137e-03
     	 	 3.6934293361802417e-01 5.8360628978386439e-02 2.0276232078445238e-03
     	 	 3.5827034804552615e-01 9.2602771055854349e-02 2.3266572055374644e-03
     	 	 3.6678357675694584e-01 1.3448457141713149e-01 2.8142593863060704e-03
     	 	 3.5717713167090825e-01 1.8207178267889271e-01 3.0392055269618749e-03
     	 	 3.5679272551161745e-01 2.3397557300302677e-01 3.3133784287244952e-03
     	 	 3.4682772432340037e-01 2.8706356722347498e-01 2.6947499095570076e-03
     	 	 3.3806085827607824e-01 3.3324553245519350e-01 2.1916326055472493e-03
     	 	 3.5933668956349807e-01 3.5823561325432796e-01 2.7884919822575445e-03
     	 	 3.5813233549308543e-01 4.0980537946042539e-01 3.3108406841498711e-03
     	 	 3.4694970220736576e-01 4.6972776671635119e-01 2.8777296978633291e-03
     	 	 3.6894146099949476e-01 4.9513637540111788e-01 2.8141522194956399e-03
     	 	 3.6270321522202853e-01 5.4197426718778474e-01 2.3857117336931900e-03
     	 	 3.6447769133435104e-01 5.7519008870776334e-01 2.0242754927440746e-03
     	 	 3.5462473757504664e-01 6.1257227998553099e-01 1.5014493383847401e-03
     	 	 3.5656404083107118e-01 6.3000096439989706e-01 9.6698420546744151e-04
     	 	 3.7121186440322140e-01 6.2622663738748774e-01 4.2586740121374156e-04
     	 	 3.0873971629983554e-01 2.3698655184710513e-03 3.8336332855753167e-04
     	 	 3.0417337080984475e-01 1.2495161415620492e-02 8.6505162015507663e-04
     	 	 2.9238505635637757e-01 3.0693786486879326e-02 1.3306165557396129e-03
     	 	 3.0450476064095799e-01 5.7132395834273486e-02 1.8823545390396076e-03
     	 	 2.9822342802222090e-01 9.0399469497189966e-02 2.2011182828873123e-03
     	 	 3.0549966367351100e-01 1.3195647393992804e-01 2.6716414527547302e-03
     	 	 2.9801453376313169e-01 1.7956462246243701e-01 2.9704036105965711e-03
     	 	 2.9577999481672435e-01 2.3362369621820536e-01 3.3512169085679988e-03
     	 	 2.9108271268312658e-01 2.9199562581943050e-01 3.4100890232014415e-03
     	 	 2.8468136755436158e-01 3.5563116685148505e-01 3.3492726596783149e-03
     	 	 2.9920767500039902e-01 4.0816171479519825e-01 3.3215987439510456e-03
     	 	 2.3793545581830866e-01 4.7516590578503981e-01 2.8982026408978087e-03
     	 	 2.9496712225233968e-01 4.6648832650363803e-01 3.2835002714437429e-03
     	 	 2.9035459293703070e-01 5.2364677768692458e-01 2.7732581989888911e-03
     	 	 3.0514134819094751e-01 5.5731402152273868e-01 2.8355158710341262e-03
     	 	 3.0175969351056664e-01 6.0336964886931765e-01 2.3243114393553268e-03
     	 	 3.0095462323456779e-01 6.3934470749580097e-01 1.9453033019021942e-03
     	 	 2.9238767084063177e-01 6.7528674347416895e-01 1.4010990846662630e-03
     	 	 2.9470888993911759e-01 6.9206490892458739e-01 8.9509231880119877e-04
     	 	 3.0734815543157301e-01 6.9012687916615278e-01 4.0576805834270077e-04
     	 	 2.4757539801222317e-01 2.4685872106627446e-03 3.7320770234505139e-04
     	 	 2.4489906902954373e-01 1.2860483185348603e-02 8.1907768970592050e-04
     	 	 2.3483349173592893e-01 3.0978296536747447e-02 1.1793203830845688e-03
     	 	 2.4421446880844599e-01 5.5931860048183846e-02 1.6671590467713154e-03
     	 	 2.3954184262146438e-01 8.8005890287264854e-02 2.0140191752402877e-03
     	 	 2.4894069676334007e-01 1.2617058578279935e-01 2.2032775707797260e-03
     	 	 2.4195303295111736e-01 1.7071368393778313e-01 2.6694369939066513e-03
     	 	 2.3918855816051909e-01 2.2282065316871133e-01 3.0480579042790742e-03
     	 	 2.3541585032550383e-01 2.8074835090865569e-01 3.3099433708994892e-03
     	 	 2.3455043430807732e-01 3.4144841685725041e-01 3.2031495187194209e-03
     	 	 2.4868571022739405e-01 4.2276620844093593e-01 2.0155479254904502e-03
     	 	 1.9668602016208514e-01 4.6690528697395195e-01 1.8516954369413485e-03
     	 	 2.3723838240830342e-01 5.2892351875019539e-01 2.9415732615796141e-03
     	 	 2.3725625343640744e-01 5.8184656340381213e-01 2.6623449573528785e-03
     	 	 2.4561731173846213e-01 6.2022649238850269e-01 2.5493254520590996e-03
     	 	 2.4386089686469004e-01 6.6296115349963891e-01 2.0904179584901291e-03
     	 	 2.4062306009886336e-01 7.0023857143617074e-01 1.7788117790999084e-03
     	 	 2.3460663347540978e-01 7.3302582635502900e-01 1.2662513265333485e-03
     	 	 2.3687167050340374e-01 7.4981635761875531e-01 8.3327908825202063e-04
     	 	 2.4638570867577470e-01 7.5108301991694393e-01 3.8267687966611337e-04
     	 	 1.9092842863316295e-01 2.3694120900763691e-03 3.2964913171305062e-04
     	 	 1.9053064037990064e-01 1.2605331854497663e-02 7.4607589964531518e-04
     	 	 1.8360079377445027e-01 3.1553819387011774e-02 1.1410153684970610e-03
     	 	 1.8796382423986924e-01 5.8931001140575812e-02 1.6834633091180940e-03
     	 	 1.8554534396082889e-01 9.4667689715347503e-02 1.9922028516813420e-03
     	 	 2.0294340066372396e-01 1.3165090327274673e-01 1.4234357572223315e-03
     	 	 1.7903115542447456e-01 1.4170297335695481e-01 1.4591877622069369e-03
     	 	 1.8829919999399281e-01 1.8650907394683638e-01 2.6559767817079345e-03
     	 	 1.8534696094709135e-01 2.4060890428282392e-01 2.7713460465944579e-03
     	 	 1.8167765418651305e-01 2.9567675638904301e-01 2.7495047764839837e-03
     	 	 1.8353025136452239e-01 3.5028065330893449e-01 2.8229856121450136e-03
     	 	 2.2432642030245753e-01 4.0206309162209064e-01 2.6202134970872313e-03
     	 	 1.6955790068899934e-01 4.7458742419532579e-01 2.0345969877227149e-03
     	 	 1.8338930620172567e-01 5.2972708196684648e-01 2.9018934306813040e-03
     	 	 1.8562171828775975e-01 5.8299415191174997e-01 2.6188387590277639e-03
     	 	 1.8519227821720052e-01 6.3318253115953327e-01 2.3887089189942026e-03
     	 	 1.8996267228342589e-01 6.7430038759942634e-01 2.2999580696066758e-03
     	 	 1.9086728137543163e-01 7.1391179777794900e-01 1.9066725991599830e-03
     	 	 1.8488890857723772e-01 7.5431623209233534e-01 1.6618513946286145e-03
     	 	 1.8251547528400636e-01 7.8420242934726903e-01 1.1696028661512751e-03
     	 	 1.8381618495116159e-01 8.0253156589575836e-01 7.7301527545039518e-04
     	 	 1.8990720918320847e-01 8.0749093068151379e-01 3.5834272801296539e-04
     	 	 1.3987025218572580e-01 2.6399066040291488e-03 3.2279654958068422e-04
     	 	 1.4221225798564974e-01 1.3602381631115101e-02 6.7613832989473627e-04
     	 	 1.3651960838097832e-01 3.2146538108193470e-02 9.6093200996335746e-04
     	 	 1.3806423887446129e-01 5.6571349029681188e-02 1.2687455762348105e-03
     	 	 1.3782540358610651e-01 8.7046524703929332e-02 1.5489027231624551e-03
     	 	 1.3868266104759197e-01 1.2557089994864196e-01 1.9139428769257714e-03
     	 	 1.3809574727001761e-01 1.7169085410109985e-01 2.0944269165884153e-03
     	 	 1.3947119301296262e-01 2.1762360541571588e-01 2.0822789960136590e-03
     	 	 1.3590069339595234e-01 2.6244747006895014e-01 1.9850265666086853e-03
     	 	 1.3438538216114615e-01 3.1113047706101088e-01 2.3940734573223129e-03
     	 	 1.3567107975660686e-01 3.6922033926218706e-01 2.7684800209866836e-03
     	 	 1.7700175854028766e-01 4.1091641843814630e-01 2.8640622213379446e-03
     	 	 1.3042147440538743e-01 4.9629911066058591e-01 2.5225057382848529e-03
     	 	 1.3573341220057378e-01 5.5442076984808086e-01 2.7620299133044629e-03
     	 	 1.3762510332806710e-01 6.1410863225627654e-01 2.6701980627917474e-03
     	 	 1.3766369344796758e-01 6.7057254684786860e-01 2.4154201617107422e-03
     	 	 1.3969571147014881e-01 7.1963846709697810e-01 2.2199561649741788e-03
     	 	 1.4247880460088558e-01 7.6079594428615749e-01 1.8422288861323060e-03
     	 	 1.3484152982427566e-01 8.0478545254273737e-01 1.5096432170676503e-03
     	 	 1.3611410159492998e-01 8.3156065084257180e-01 1.0283005980895560e-03
     	 	 1.3663792932010244e-01 8.5026820487891763e-01 6.5858905623827056e-04
     	 	 1.3926868256341829e-01 8.5824292746480024e-01 3.0310803840768704e-04
     	 	 9.5511044738356476e-02 2.5597036592773666e-03 2.6773171496813120e-04
     	 	 1.0015017423848838e-01 1.3611276011329197e-02 6.0326126814230546e-04
     	 	 9.4973557320402358e-02 3.3762781784869300e-02 9.5730767895422164e-04
     	 	 9.5185457724474842e-02 6.3030259394805985e-02 1.3201353507550041e-03
     	 	 9.6084480950515805e-02 1.0107183236895974e-01 1.6315379539899475e-03
     	 	 9.6659101711013440e-02 1.4634487357750192e-01 1.8873500050547534e-03
     	 	 9.6437333899729638e-02 1.9670636702333980e-01 1.9924223814641985e-03
     	 	 9.5902098390859836e-02 2.4799738282412975e-01 2.0058109652778245e-03
     	 	 9.2903482446588526e-02 3.0099074557405908e-01 2.0344894189552377e-03
     	 	 9.3967913636027633e-02 3.5660736309361463e-01 2.2245886347109305e-03
     	 	 9.3259846098701082e-02 4.1718787551573283e-01 2.3633070323650974e-03
     	 	 1.3162526786400330e-01 4.3356334009196290e-01 2.6659236896437498e-03
     	 	 9.1165614307938458e-02 4.8327120794457329e-01 2.4152112382949784e-03
     	 	 9.2202688467367122e-02 5.4839191568764534e-01 2.4131712859252860e-03
     	 	 9.5294163151565692e-02 6.0884149115544595e-01 2.3466604050264976e-03
     	 	 9.5567850656367637e-02 6.6780497265910110e-01 2.2086702333198468e-03
     	 	 9.6057076697414145e-02 7.2146450870818668e-01 1.9632855895632862e-03
     	 	 9.6708421182672311e-02 7.6790506550811843e-01 1.7275048248683960e-03
     	 	 9.9886959728008096e-02 8.0502432597135065e-01 1.4738757532500100e-03
     	 	 9.1306613659677849e-02 8.4724380608956007e-01 1.2050573701599600e-03
     	 	 9.5480659429428294e-02 8.7026703555976415e-01 8.9705851844149682e-04
     	 	 9.5509980146300633e-02 8.9024865379293261e-01 6.0420868300092021e-04
     	 	 9.5344932822165496e-02 9.0194203337918533e-01 2.7933257639325715e-04
     	 	 5.8866901036978225e-02 2.5735232571943004e-03 2.1356427276199497e-04
     	 	 6.4672055638634429e-02 1.3396477589420596e-02 4.8329729984547114e-04
     	 	 5.9790163274414998e-02 3.2083025331181347e-02 7.1159382284840340e-04
     	 	 5.9882581188317574e-02 5.8596026414300444e-02 9.5824394550265719e-04
     	 	 6.0631246879059630e-02 9.3563647937347866e-02 1.2432762480925833e-03
     	 	 6.1064687636791293e-02 1.3714115075000322e-01 1.5166605754031602e-03
     	 	 6.1242699361966468e-02 1.8856727425247977e-01 1.7442757764139429e-03
     	 	 6.0535891080762183e-02 2.4667373450967461e-01 1.9156684081461800e-03
     	 	 5.8922371369858340e-02 3.0947544715880482e-01 1.9674383443470424e-03
     	 	 5.9163059244797034e-02 3.7527792351474876e-01 2.0808568907192122e-03
     	 	 5.9013422741988952e-02 4.4312256636219577e-01 2.0812147253149440e-03
     	 	 5.7775604685179394e-02 5.1148119622705568e-01 1.9801505048966401e-03
     	 	 5.8299471211199494e-02 5.7521544863383289e-01 1.9063775221309478e-03
     	 	 6.0350403556652443e-02 6.3536838138412244e-01 1.8910008618766012e-03
     	 	 6.0411073661543191e-02 6.9376107865151315e-01 1.7755010790729286e-03
     	 	 6.0816765845483456e-02 7.4801058844074708e-01 1.6603949029690662e-03
     	 	 6.0839877145471122e-02 7.9806996928736318e-01 1.5062589730527891e-03
     	 	 6.3194259802070052e-02 8.3972050220060934e-01 1.3209762142169172e-03
     	 	 5.6468874721351758e-02 8.8309142066714941e-01 1.0053795380120362e-03
     	 	 6.1040456831505052e-02 9.0670061722759876e-01 7.4414195026833020e-04
     	 	 6.0944837805795293e-02 9.2614093213080106e-01 4.6115611673003617e-04
     	 	 5.9155293234261164e-02 9.3841926336991310e-01 1.9991216002043007e-04
     	 	 3.0841400541371633e-02 2.4435402748287762e-03 1.4785664159389986e-04
     	 	 3.5733939743038068e-02 1.3112185532996616e-02 3.7596895991942711e-04
     	 	 3.2242889186309687e-02 3.2512005874237949e-02 5.5919868117068237e-04
     	 	 3.2594404021918488e-02 6.0550389777241365e-02 7.4468817198238978e-04
     	 	 3.2979250034195107e-02 9.5780417899770681e-02 9.0457997701548715e-04
     	 	 3.3198102726145207e-02 1.3656505544760336e-01 1.0298049508418157e-03
     	 	 3.3398520909586837e-02 1.8245273164772932e-01 1.1618574019663071e-03
     	 	 3.3127554222354139e-02 2.3417428330768789e-01 1.2982288886451815e-03
     	 	 3.2285606923999843e-02 2.9209738008732444e-01 1.4091799746544173e-03
     	 	 3.2070680055762635e-02 3.5534864058619819e-01 1.4860172588398867e-03
     	 	 3.2134601245874972e-02 4.2054913162603508e-01 1.5121251371193868e-03
     	 	 3.2144347926304051e-02 4.8526898244974531e-01 1.4494982906347739e-03
     	 	 3.1159758764075285e-02 5.4822909098249417e-01 1.3748009740478305e-03
     	 	 3.2083084421630104e-02 6.0726785478185996e-01 1.3431966944735378e-03
     	 	 3.2862004994543059e-02 6.6552842464679240e-01 1.3921468116167249e-03
     	 	 3.2937851465699275e-02 7.2388172593864830e-01 1.3459848988831304e-03
     	 	 3.3104402836020452e-02 7.7883400077702614e-01 1.2499149414791494e-03
     	 	 3.3058419820848006e-02 8.2847533309200150e-01 1.0959537278386108e-03
     	 	 3.4577792009288455e-02 8.6950703290415421e-01 9.6074654223701522e-04
     	 	 2.9644016137216678e-02 9.0963847087252714e-01 7.0041263836118539e-04
     	 	 3.3406235103981330e-02 9.3338856984296092e-01 5.5980486775540747e-04
     	 	 3.3594372100846037e-02 9.5268142662429889e-01 3.6326424892129961e-04
     	 	 3.1507729049742639e-02 9.6584650695927454e-01 1.5760631509697319e-04
     	 	 1.1988574547814324e-02 2.4899027067847245e-03 9.0148403317269059e-05
     	 	 1.4951254764836386e-02 1.2737098850406910e-02 2.3265047235658201e-04
     	 	 1.3047434486590070e-02 2.9956415494526607e-02 3.0778460312366328e-04
     	 	 1.3335200968154437e-02 5.4547523247272724e-02 4.3177194421623738e-04
     	 	 1.3477019702548443e-02 8.7605885641603876e-02 5.6779322936689205e-04
     	 	 1.3573738794556922e-02 1.2888120101927011e-01 6.9035529766577422e-04
     	 	 1.3695029092780420e-02 1.7725438234471041e-01 7.9530839853159281e-04
     	 	 1.3607969688842148e-02 2.3153064696786463e-01 8.7243974095019500e-04
     	 	 1.3229908166870308e-02 2.9063931353171835e-01 9.1318985115479488e-04
     	 	 1.3174489603053896e-02 3.5365386341259575e-01 9.6320547659181827e-04
     	 	 1.3099449354146975e-02 4.2036509023296725e-01 1.0115048675003403e-03
     	 	 1.3276835933156317e-02 4.8922436313213463e-01 1.0334531449035743e-03
     	 	 1.2718164073282412e-02 5.5894022926259823e-01 9.9951197983931626e-04
     	 	 1.3221290871270774e-02 6.2716224827220035e-01 1.0016724960325077e-03
     	 	 1.3472984660874987e-02 6.9225975863208278e-01 9.5951813946230306e-04
     	 	 1.3530112718950327e-02 7.5249492294981790e-01 8.7177737715801165e-04
     	 	 1.3550855729912548e-02 8.0612331713441698e-01 7.6555082887421724e-04
     	 	 1.3559293436943731e-02 8.5244807133025502e-01 6.5345672651353321e-04
     	 	 1.4220989410623774e-02 8.9135078328213124e-01 5.8801496944526862e-04
     	 	 1.1616515392248061e-02 9.2769710274494166e-01 4.1665975353981301e-04
     	 	 1.3747804779040362e-02 9.5273787911692465e-01 3.6510466693090904e-04
     	 	 1.3893163465354408e-02 9.7227713738855936e-01 2.4264387832992243e-04
     	 	 1.2604820455754284e-02 9.8476668980978266e-01 9.7987773348552387e-05
     	 	 2.1595598288225437e-03 2.2953213858686638e-03 3.3542298244502525e-05
     	 	 2.8346672514237836e-03 1.2533238914913309e-02 1.0621707847166992e-04
     	 	 2.4734045084136014e-03 3.1707123458083200e-02 1.5064043301523137e-04
     	 	 2.5507818532641835e-03 5.9801526427267486e-02 2.1162125758562609e-04
     	 	 2.5695287199918315e-03 9.6165887128542474e-02 2.6488116737423314e-04
     	 	 2.5906783015751111e-03 1.3984352357322444e-01 3.1210119430999351e-04
     	 	 2.6138745133755803e-03 1.8980132518230711e-01 3.5376853776058662e-04
     	 	 2.5790104175391626e-03 2.4518317040943399e-01 3.8232053919785207e-04
     	 	 2.5090236796537768e-03 3.0502332219057099e-01 3.9594618171369893e-04
     	 	 2.5181937957522438e-03 3.6758114937234088e-01 4.0831652660799363e-04
     	 	 2.4773996262438258e-03 4.3100736598733819e-01 4.0245748775495329e-04
     	 	 2.5607525749371529e-03 4.9383234189668818e-01 4.0998854478419943e-04
     	 	 2.4017373161040467e-03 5.5675238620046785e-01 3.9148800636901030e-04
     	 	 2.5067584359792505e-03 6.2081508312519385e-01 4.1425712029135122e-04
     	 	 2.5577080661510765e-03 6.8489358476044793e-01 4.1571805385816091e-04
     	 	 2.5796734926660791e-03 7.4680824012816038e-01 3.9776434348522138e-04
     	 	 2.5791624581836814e-03 8.0456759412293344e-01 3.6430345870739847e-04
     	 	 2.5835630197916792e-03 8.5646296828765833e-01 3.2129603543819990e-04
     	 	 2.6868729071993780e-03 9.0110976115925467e-01 2.8123425907486502e-04
     	 	 2.1676282616925890e-03 9.3825210131961878e-01 1.8065373241044134e-04
     	 	 2.6414153287451780e-03 9.6557194036396632e-01 1.5828522160134473e-04
     	 	 2.6492275822749267e-03 9.8457983008528127e-01 9.9499007545076574e-05
     	 	 2.3434850088193127e-03 9.9526906733192466e-01 3.7216941034190802e-05
     	 	 ];


    case 45

        % SET: SLOBODKINS TAUSCH
        % CARDINALITY RULE  :    363
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 9.090e-16

        XYW=[
    	 	 9.9450653952820833e-01 2.6333979658365015e-03 4.9501374028384544e-05
     	 	 9.8404999623832690e-01 1.3818500321996051e-02 8.6089468535017352e-05
     	 	 9.8241099477341420e-01 2.5703155868912844e-03 1.1183341861642679e-04
     	 	 9.7473264923035052e-01 1.3603598232458804e-02 2.1085476748915785e-04
     	 	 9.6392499557304234e-01 3.3638363171887356e-02 1.4975148469586414e-04
     	 	 9.6081912018965143e-01 2.4834654374477076e-03 1.6756242863817653e-04
     	 	 9.5706744111263820e-01 1.3149557041380013e-02 3.3491403483331197e-04
     	 	 9.3751444703126197e-01 3.2030765425540161e-02 4.9142767397941265e-04
     	 	 9.5411192877315965e-01 3.3227751636740938e-02 3.3706405537367980e-04
     	 	 9.3579843127869344e-01 6.1722172073126899e-02 2.0381611571501277e-04
     	 	 9.3013191413402696e-01 2.4153113728486823e-03 2.1720821974648851e-04
     	 	 9.3037855457482233e-01 1.2780853868000762e-02 4.5445718218392020e-04
     	 	 9.1330528852949411e-01 3.1267964075657982e-02 6.3905088328236365e-04
     	 	 8.5275150914313569e-01 5.5957946379521346e-02 1.0669634472764715e-03
     	 	 9.0946287141160287e-01 5.8846207699802304e-02 6.9518941166187855e-04
     	 	 9.2584221073619077e-01 6.1141136852646168e-02 4.6853277108434499e-04
     	 	 8.9995543771620479e-01 9.7560951083995637e-02 2.5177801595143595e-04
     	 	 8.9109094317836812e-01 2.3833957498340511e-03 2.6195854351450284e-04
     	 	 8.9488258205209048e-01 1.2524561183824147e-02 5.6286358800561255e-04
     	 	 8.8196774262704936e-01 3.0548853341087694e-02 7.7736238386210484e-04
     	 	 8.8470232234694779e-01 5.7314465392257055e-02 8.8918885088439914e-04
     	 	 8.5027259838890534e-01 9.0406973558886702e-02 1.1437881830895873e-03
     	 	 8.7459103103339653e-01 9.3357687819914506e-02 8.8561019276744036e-04
     	 	 8.9011780517942951e-01 9.6818375730616774e-02 5.8164770214681240e-04
     	 	 8.5704857325352712e-01 1.4054623098552493e-01 2.8549531166600646e-04
     	 	 8.4482826622426788e-01 2.3931273019255853e-03 3.0322567254670627e-04
     	 	 8.5116166617547551e-01 1.2529090042325931e-02 6.7024189736992720e-04
     	 	 8.4278437655261929e-01 3.0530431256646534e-02 9.3439142677618147e-04
     	 	 8.1237593144785947e-01 5.6068987230015674e-02 1.2666872904186178e-03
     	 	 8.1735299883806356e-01 8.8136450340292133e-02 1.3709520618548250e-03
     	 	 7.8492923284919525e-01 1.2608797634131824e-01 1.4325164584437218e-03
     	 	 8.1307818243025132e-01 1.3064772151999482e-01 1.2627354178090676e-03
     	 	 8.3396470568704828e-01 1.3536052755038327e-01 9.8920713934979969e-04
     	 	 8.4778795350592329e-01 1.3962211888373027e-01 6.5171464385090734e-04
     	 	 8.0767833357444219e-01 1.8996945250309921e-01 3.1601132101729309e-04
     	 	 7.9267034406512327e-01 2.4053010399144262e-03 3.3697733522511554e-04
     	 	 8.0030214229465124e-01 1.2607379966416855e-02 7.6700578118073226e-04
     	 	 7.9626347959949506e-01 3.0704294042279697e-02 1.0963268906722756e-03
     	 	 7.6558713348103480e-01 5.6479971208883130e-02 1.4405552498998003e-03
     	 	 7.7478951122089634e-01 8.8600391199999684e-02 1.6120066430376260e-03
     	 	 7.4509706321088010e-01 1.2697466407275068e-01 1.7475230414312965e-03
     	 	 7.4411150876076271e-01 1.6735254808501324e-01 1.5353787980690386e-03
     	 	 7.6706905506266909e-01 1.7706799817150048e-01 1.4424937605330022e-03
     	 	 7.8606863935129867e-01 1.8363063301548682e-01 1.1133046872309903e-03
     	 	 7.9903416838479879e-01 1.8858868876940574e-01 7.2446222217796129e-04
     	 	 7.5262987107872736e-01 2.4494014595722785e-01 3.5787375333030724e-04
     	 	 7.3600412774352075e-01 2.4075776518989252e-03 3.6102486686193498e-04
     	 	 7.4365252180507757e-01 1.2652520599752892e-02 8.4431463740560809e-04
     	 	 7.4286377273305426e-01 3.0917578593779447e-02 1.2516857358371993e-03
     	 	 7.1434014318550410e-01 5.7000480036419832e-02 1.5562201987180913e-03
     	 	 7.2609354781884428e-01 8.9643298867288598e-02 1.8331076339715689e-03
     	 	 6.9738390533471573e-01 1.2923132086798134e-01 2.0973006510589089e-03
     	 	 7.0029311690405238e-01 1.7119917707968640e-01 2.0273918585978963e-03
     	 	 6.9906313208507653e-01 2.1061762751064689e-01 1.6639867012080058e-03
     	 	 7.1414255183257613e-01 2.2860671343855837e-01 1.6215915741344959e-03
     	 	 7.3187645549212998e-01 2.3697773072763770e-01 1.2486211755785787e-03
     	 	 7.4451092266345520e-01 2.4272732195461458e-01 8.1498123641712806e-04
     	 	 6.9307107477105812e-01 3.0444642308000308e-01 3.9079750193158751e-04
     	 	 6.7612437346531395e-01 2.3870772797839365e-03 3.7431607850375116e-04
     	 	 6.8265519503278882e-01 1.2571014555387696e-02 8.9090038941681870e-04
     	 	 6.8383041510821418e-01 3.0791365978960861e-02 1.3618499677247873e-03
     	 	 6.6184825684851434e-01 5.6543288504313255e-02 1.5777262334372394e-03
     	 	 6.1884231477406715e-01 8.8186947946789815e-02 2.0243019317121064e-03
     	 	 6.7297516216387687e-01 9.0528852652556835e-02 2.0124950150994143e-03
     	 	 6.4440384961201858e-01 1.3074842856493116e-01 2.3576948342067493e-03
     	 	 5.9942792865019445e-01 1.7692245290821157e-01 2.4209696295869293e-03
     	 	 6.5002511416323416e-01 1.7565508584355269e-01 2.3802589551457694e-03
     	 	 6.4773356372916946e-01 2.2145764065167001e-01 2.2963505550808818e-03
     	 	 6.5008894959832531e-01 2.5865964329763597e-01 1.8983888628232074e-03
     	 	 6.5714342525059932e-01 2.8496828316647743e-01 1.7528605631646588e-03
     	 	 6.7359161954201763e-01 2.9477833080273913e-01 1.3468921116233455e-03
     	 	 6.8572207497224502e-01 3.0127408145207701e-01 8.8555446666638597e-04
     	 	 6.1395074396678839e-01 2.2934486441535213e-03 3.7165679964539904e-04
     	 	 6.1880729477720631e-01 1.2143194884397092e-02 8.9108854082336423e-04
     	 	 6.2061853975110337e-01 2.9847329904978865e-02 1.3981192286994463e-03
     	 	 6.0750607182841709e-01 5.4773432814844328e-02 1.6475326122439786e-03
     	 	 5.8038955534376135e-01 1.1020717006053538e-01 1.4756008575663186e-04
     	 	 5.9066532723128751e-01 1.2740146221012610e-01 2.3901339272449913e-03
     	 	 5.5543631215592137e-01 1.7053279934857157e-01 2.2734318333849884e-03
     	 	 5.9500223336904423e-01 2.2827084633705833e-01 2.6612822996897410e-03
     	 	 5.9152232186428133e-01 2.7751993445703504e-01 2.5076350715134408e-03
     	 	 5.9562045431904154e-01 3.1372787735182084e-01 2.1156187564110897e-03
     	 	 5.9743455262506817e-01 3.4583988605065136e-01 1.8559322962904022e-03
     	 	 6.1299906497524770e-01 3.5638632535194792e-01 1.3861512364224430e-03
     	 	 6.2401269351537736e-01 3.6353757980706569e-01 8.9666742702387955e-04
     	 	 6.3018724021950034e-01 3.6745252436840226e-01 3.8967276587676916e-04
     	 	 5.5006910319677149e-01 2.2255004243180595e-03 3.6842729260248261e-04
     	 	 5.5379887889424517e-01 1.1714308610497050e-02 8.6510199314374320e-04
     	 	 5.5471135367984992e-01 2.8844542889553706e-02 1.3976625885599035e-03
     	 	 5.4729943303297113e-01 5.3500523407951445e-02 1.7880914688086164e-03
     	 	 5.6157874814461173e-01 8.5382986888647400e-02 2.0881767922596075e-03
     	 	 5.3132156441598277e-01 1.2388271604434560e-01 2.5462422692153607e-03
     	 	 5.0698320648647677e-01 1.6764032603535717e-01 2.4004868399897820e-03
     	 	 5.0141709751429675e-01 2.1703362118876923e-01 2.7513936328943450e-03
     	 	 5.4659761113794814e-01 2.2583332045485979e-01 2.6482286588558751e-03
     	 	 4.9676938863643816e-01 2.7684402170199418e-01 2.6896207721890746e-03
     	 	 5.3887473292142296e-01 2.8476755862184649e-01 2.7608881739092858e-03
     	 	 5.3214699805383514e-01 3.3798990080908969e-01 2.6459588943337966e-03
     	 	 5.3774637211654996e-01 3.7290774201018179e-01 2.1864186657598655e-03
     	 	 5.3463558829457303e-01 4.0904445863896255e-01 1.8476933171149539e-03
     	 	 5.4945260624559822e-01 4.1964668905570585e-01 1.4018692446692393e-03
     	 	 5.5938243682807776e-01 4.2785927784509609e-01 9.3406294566382691e-04
     	 	 5.6488135351040070e-01 4.3267613312218928e-01 4.1291618162547647e-04
     	 	 4.8518469151837462e-01 2.4115909416818119e-03 4.0200941672750406e-04
     	 	 4.8885279494054079e-01 1.2515161519160937e-02 9.0785775133772422e-04
     	 	 4.8765929346997905e-01 3.0173834283896347e-02 1.4212460526180650e-03
     	 	 4.8250377498632568e-01 5.5041849340209649e-02 1.8498255930306418e-03
     	 	 4.9991492157115514e-01 8.6073158849216208e-02 2.2315616903662190e-03
     	 	 4.6816790924422358e-01 1.2483146970888757e-01 2.6347749474491221e-03
     	 	 4.5355096757834146e-01 1.6937729085611825e-01 2.5390393632815983e-03
     	 	 4.4502055643024963e-01 2.1793621401071919e-01 2.9529547660550070e-03
     	 	 4.4986447235465610e-01 2.6990258417857171e-01 3.0499396886364332e-03
     	 	 4.4407418072708449e-01 3.3053155950143337e-01 2.9499043733195152e-03
     	 	 4.8301297541181654e-01 3.4212272479716316e-01 2.6605652136026062e-03
     	 	 4.7190128681820498e-01 4.0156278356875252e-01 2.6323782869281582e-03
     	 	 4.7798402714889676e-01 4.3463608023019590e-01 2.1393243666718710e-03
     	 	 4.7151221335448168e-01 4.7414739819735713e-01 1.8563782637653879e-03
     	 	 4.8584045956074473e-01 4.8494489628387039e-01 1.3827828730059236e-03
     	 	 4.9415795957147068e-01 4.9405382661314151e-01 8.8916869932499935e-04
     	 	 4.9861138511303871e-01 4.9917062763990333e-01 3.7978103813282344e-04
     	 	 4.2017207651752608e-01 2.3655676875306998e-03 3.9263095719952899e-04
     	 	 4.2398958101083772e-01 1.2525283936205348e-02 9.1809002280545152e-04
     	 	 4.2161591981440394e-01 3.0674038520899817e-02 1.4277332083183184e-03
     	 	 4.1663291948371661e-01 5.6173113537778575e-02 1.8992195937605507e-03
     	 	 4.3461878895016404e-01 8.7689984117720804e-02 2.2955186742309591e-03
     	 	 4.0468765036663013e-01 1.2563537091277160e-01 2.4937774647644326e-03
     	 	 3.9838449792322461e-01 1.6820490803010077e-01 2.6049009433844377e-03
     	 	 3.8601810098136713e-01 2.1724169975811633e-01 3.0445421904181200e-03
     	 	 3.9078511128694693e-01 2.7007624931414975e-01 3.2014404511951774e-03
     	 	 3.9407263339756826e-01 3.2309519771191542e-01 3.0441983152017047e-03
     	 	 3.8349937468275386e-01 3.7281464421421245e-01 1.7780689031848789e-03
     	 	 3.9512770353696347e-01 3.9809583941593368e-01 2.4077369762091315e-03
     	 	 4.3739246396255638e-01 3.9284339099875631e-01 1.9332126308645812e-03
     	 	 4.0169434414533067e-01 4.3893658977052513e-01 1.6556593734973486e-03
     	 	 4.0996749779048181e-01 4.6834109374012728e-01 2.4430277161264411e-03
     	 	 4.2114121500828705e-01 4.9377403512134815e-01 1.8718754528925425e-03
     	 	 4.0658083155159130e-01 5.3834804938182068e-01 1.7581445622121491e-03
     	 	 4.2060964421896174e-01 5.4880162758797180e-01 1.3683513289650508e-03
     	 	 4.2799531982883265e-01 5.5924858868473926e-01 9.2837188094686796e-04
     	 	 4.3218000777625443e-01 5.6536478335237617e-01 4.1391029411520623e-04
     	 	 3.5652712646101303e-01 2.2791209975435789e-03 3.6450085354468260e-04
     	 	 3.5994057058438855e-01 1.1992519831751012e-02 8.6098169821391174e-04
     	 	 3.5819458392848447e-01 2.9535823392820508e-02 1.3405408012132282e-03
     	 	 3.5166162410652424e-01 5.5199639865657769e-02 1.9119443277681428e-03
     	 	 3.6807483647563055e-01 8.8717967533853914e-02 2.3846093957872530e-03
     	 	 3.4422311534086825e-01 1.2950375368984060e-01 2.4960532362311391e-03
     	 	 3.3881674153595609e-01 1.7531795074143502e-01 2.8338871020048614e-03
     	 	 3.2658258675303498e-01 2.2511862600933505e-01 2.8208594342356173e-03
     	 	 3.3248720033884271e-01 2.7460293416962495e-01 3.0763291755063356e-03
     	 	 3.3506361106302374e-01 3.3101886523170759e-01 3.3565211704394632e-03
     	 	 3.3365933279702054e-01 3.8873290211516420e-01 3.1081391174030549e-03
     	 	 3.3233941141981305e-01 4.4501729140683594e-01 3.0631613522756483e-03
     	 	 3.5540405057328883e-01 4.7235094104107189e-01 2.3885908737717671e-03
     	 	 3.4645914065298411e-01 5.2621071060568425e-01 2.6090451583594149e-03
     	 	 3.6551711468094772e-01 5.4684127149865325e-01 1.9245685932851862e-03
     	 	 3.1332222483752514e-01 5.9782318012214664e-01 1.8698542892997276e-03
     	 	 3.4451832984533459e-01 6.0046478823439997e-01 1.8247442882568102e-03
     	 	 3.5750094353201856e-01 6.1329053309336046e-01 1.3614339302626959e-03
     	 	 3.6384312790840123e-01 6.2449475836378066e-01 8.5588503375013498e-04
     	 	 3.6717200957127649e-01 6.3065172610862963e-01 3.5983900526783384e-04
     	 	 2.9584385640071365e-01 2.5259330819200243e-03 3.8157695267115676e-04
     	 	 2.9783467178290179e-01 1.3116962439175817e-02 8.9174423599096167e-04
     	 	 2.9731174996963305e-01 3.1646401667414018e-02 1.3061794364460258e-03
     	 	 2.8746153784878781e-01 5.7032873059202127e-02 1.7584227368703871e-03
     	 	 3.0546939924692196e-01 8.7897733088543567e-02 2.1575811267970581e-03
     	 	 2.9110531633465886e-01 1.2498090955274833e-01 2.1177450654642194e-03
     	 	 2.8099402204552615e-01 1.7044711219223238e-01 2.7822723136465910e-03
     	 	 2.7332290777338408e-01 2.2065557641265920e-01 2.7860391733185888e-03
     	 	 2.7173327299282468e-01 2.7518618094354474e-01 3.0527498222341063e-03
     	 	 2.8743118822613789e-01 3.1558382442178462e-01 1.3447749763097641e-03
     	 	 2.7107315130585385e-01 3.3986180418840761e-01 2.2891903874392278e-03
     	 	 2.7902223181206165e-01 3.8867154599189924e-01 3.1375906743010334e-03
     	 	 2.7752643119383213e-01 4.4669802694859545e-01 3.0959159842301118e-03
     	 	 2.7514031210616741e-01 5.0211138859842031e-01 2.8282500248761697e-03
     	 	 3.0408799599031089e-01 5.2266253471416202e-01 2.4089573625909822e-03
     	 	 2.8600398090918489e-01 5.8484279731251376e-01 2.4793279763203309e-03
     	 	 2.6209986394109708e-01 6.4585677427908905e-01 1.7650537905086212e-03
     	 	 2.8313686005273342e-01 6.5865172852318088e-01 1.7344319539247736e-03
     	 	 2.9508049169607120e-01 6.7302288015939526e-01 1.3501527708077543e-03
     	 	 3.0107688296416935e-01 6.8574894652255114e-01 8.9766320089314255e-04
     	 	 3.0432228036998465e-01 6.9315596383621947e-01 3.9505742877248619e-04
     	 	 2.3865140589756673e-01 2.2726988750470384e-03 3.2346544694489184e-04
     	 	 2.3886293672071945e-01 1.2185143522245940e-02 7.9386902272388289e-04
     	 	 2.4010085337263554e-01 3.0294111215802465e-02 1.2372582786441388e-03
     	 	 2.2906742152509363e-01 5.6598282475443143e-02 1.7036429389837183e-03
     	 	 2.4345804788860981e-01 9.0484743061708270e-02 2.1996033580890056e-03
     	 	 2.3990265499230790e-01 1.3123692355323607e-01 2.1200665689582450e-03
     	 	 2.2305207865963061e-01 1.7633084316349387e-01 2.5595942031008075e-03
     	 	 2.2187306627790193e-01 2.2387871104443094e-01 2.4476196882107903e-03
     	 	 2.1832271488946586e-01 2.7482684873599417e-01 2.7124636403964113e-03
     	 	 2.2175127678886974e-01 3.2878215459914062e-01 2.8707019573691321e-03
     	 	 2.2152751452703057e-01 3.8403064564339462e-01 2.7569854792733003e-03
     	 	 2.2574966100369753e-01 4.3492771449522455e-01 2.7984042975612829e-03
     	 	 2.2283230922148989e-01 4.9025000635726418e-01 2.7780823273795513e-03
     	 	 2.2224023189674791e-01 5.4262837790270768e-01 2.6044391023551734e-03
     	 	 2.5573893877605314e-01 5.6963877186834078e-01 2.0732379822019009e-03
     	 	 2.0743032913843862e-01 6.2706508703795638e-01 7.2713112185706329e-04
     	 	 2.2836889409559524e-01 6.3830392024472837e-01 2.3078986343969569e-03
     	 	 2.1549759244611710e-01 6.9098756986990606e-01 1.7240397251468938e-03
     	 	 2.2700053823656441e-01 7.1408104889489254e-01 1.6586935974318678e-03
     	 	 2.3714703636624213e-01 7.3091219422105314e-01 1.2846015984115261e-03
     	 	 2.4224090329553849e-01 7.4471828345778746e-01 8.3844343892495912e-04
     	 	 2.4508153273133371e-01 7.5243924485198743e-01 3.6361391349756149e-04
     	 	 1.8567374705952921e-01 2.5165724896419476e-03 3.2556242363771865e-04
     	 	 1.8482054497009814e-01 1.3030940805499817e-02 7.4295218901956049e-04
     	 	 1.8643100771961241e-01 3.1297117779443155e-02 1.1345160327697419e-03
     	 	 1.7506787886426634e-01 5.7034991413296474e-02 1.4781615963732689e-03
     	 	 1.8720529659533003e-01 8.9779920911167571e-02 1.9572025716303584e-03
     	 	 1.9118986593422682e-01 1.2983697125176258e-01 2.1114746252541162e-03
     	 	 1.7136184774670837e-01 1.7679530135147209e-01 2.4841562602337199e-03
     	 	 1.7238328562272343e-01 2.3055057656549688e-01 2.6781755823849212e-03
     	 	 1.6960652485813321e-01 2.8888748161918504e-01 2.7053597942883669e-03
     	 	 1.7256499437162431e-01 3.4661736296451173e-01 2.7757874786766574e-03
     	 	 1.7299113476977523e-01 4.0896044525758474e-01 2.8956869672950498e-03
     	 	 1.7491144067088027e-01 4.7026947426634064e-01 2.9997482534435123e-03
     	 	 1.7271318692079607e-01 5.3283329698116011e-01 2.8366278740376556e-03
     	 	 1.7226344430010998e-01 5.9070630290927506e-01 2.6364518440314187e-03
     	 	 2.1715634346980550e-01 5.9247840585397604e-01 1.7041879305148553e-03
     	 	 1.7213999533130220e-01 6.4469728198157239e-01 2.2262057050218514e-03
     	 	 1.7517218666505396e-01 6.9124807989224124e-01 2.1965471840382123e-03
     	 	 1.7069133358126631e-01 7.3738221800168346e-01 1.6738987347539721e-03
     	 	 1.7594612914488250e-01 7.6599885959121106e-01 1.4721007057487193e-03
     	 	 1.8377460470926132e-01 7.8461674261610059e-01 1.1529839184699988e-03
     	 	 1.8784026304082535e-01 7.9920876813045072e-01 7.5777717482348279e-04
     	 	 1.9031641464935589e-01 8.0721666724096663e-01 3.3026050162191477e-04
     	 	 1.3769681813878043e-01 2.3705469402819090e-03 2.7568400017153320e-04
     	 	 1.3664241473745231e-01 1.2606434255100588e-02 6.4936380340959636e-04
     	 	 1.3741356732398258e-01 3.1175088320250358e-02 1.0412688166033029e-03
     	 	 1.2854766068150691e-01 5.7685022752376552e-02 1.2893008717762141e-03
     	 	 1.3665136732993355e-01 9.0888096247808234e-02 1.7224439036169097e-03
     	 	 1.4423908020603415e-01 1.3006497273933601e-01 1.9129178723265568e-03
     	 	 1.2478286066175448e-01 1.7264387631753422e-01 1.9553752621595689e-03
     	 	 1.2730458731053773e-01 2.2129130994933513e-01 2.2155097580490706e-03
     	 	 1.2668070350748473e-01 2.7653466307005942e-01 2.4039610030239930e-03
     	 	 1.2590687792179978e-01 3.3764917129657557e-01 2.5942318137268769e-03
     	 	 1.4476532002794529e-01 3.8227274103501951e-01 5.7565895169201073e-04
     	 	 1.2414050106410768e-01 4.0221989341407810e-01 2.3581688607348080e-03
     	 	 1.2937884873009431e-01 4.6124685396353504e-01 2.6488274473350343e-03
     	 	 1.2887786533724654e-01 5.2382741524013188e-01 2.6419614712840799e-03
     	 	 1.2721054300018197e-01 5.8623168467055164e-01 2.5292620188858482e-03
     	 	 1.2814586004958028e-01 6.4314379164580671e-01 2.3003857111564218e-03
     	 	 1.2970508387856761e-01 6.9401202441915100e-01 2.0383824748928894e-03
     	 	 1.2945197852934809e-01 7.3973416508319323e-01 1.8195552632814486e-03
     	 	 1.2764632437347978e-01 7.8106011570506229e-01 1.5031409027499013e-03
     	 	 1.3007717390371409e-01 8.1197609772983992e-01 1.2879482966862328e-03
     	 	 1.3568490278401935e-01 8.3271245926327542e-01 1.0171934165516163e-03
     	 	 1.3888412090779756e-01 8.4813426103423784e-01 6.7110692216498129e-04
     	 	 1.4096756736420935e-01 8.5655455655339663e-01 2.9424961202735388e-04
     	 	 9.5636410258244098e-02 2.5395738023863781e-03 2.5146973156457079e-04
     	 	 9.4860215190790242e-02 1.3165519831248210e-02 5.6149165887079495e-04
     	 	 9.4833302790004570e-02 3.1557812922657601e-02 8.6358547134968112e-04
     	 	 8.9299507675161371e-02 5.7158144483334256e-02 1.0406549364353904e-03
     	 	 9.2874854702627241e-02 9.0050332297780547e-02 1.4302278305393578e-03
     	 	 1.0055310158077824e-01 1.2874142598451549e-01 1.6703995912602573e-03
     	 	 8.5477549839280798e-02 1.6917640687242233e-01 1.3421249642560447e-03
     	 	 8.7008842089226546e-02 2.0494781558938871e-01 1.3545674081243179e-03
     	 	 8.8224919615872421e-02 2.4933239570304547e-01 1.8600972408482942e-03
     	 	 8.8130645364759119e-02 3.0596075943555806e-01 2.1170347704474730e-03
     	 	 8.7038614359327138e-02 3.6738559789229736e-01 2.2016778591534892e-03
     	 	 8.7236422678149683e-02 4.2942520444687637e-01 2.1833721556212739e-03
     	 	 8.9940623635997419e-02 4.9070599442047796e-01 2.3142913022204440e-03
     	 	 8.9281354348530129e-02 5.5427151520298590e-01 2.2535982502684760e-03
     	 	 8.8044762278246647e-02 6.1534068700642996e-01 2.0978588464375210e-03
     	 	 8.9160649265196290e-02 6.7139515756862789e-01 1.9928646015856407e-03
     	 	 9.0381614985005632e-02 7.2402163012413923e-01 1.8780806019869129e-03
     	 	 8.9833766294915796e-02 7.7332192401444400e-01 1.6698401498237828e-03
     	 	 8.9025020416820921e-02 8.1645698827219926e-01 1.3961785325282215e-03
     	 	 9.0184240655293513e-02 8.5047816235383344e-01 1.1420346953028490e-03
     	 	 9.3826413456464697e-02 8.7411305528633632e-01 8.8795410777578194e-04
     	 	 9.6271691488072575e-02 8.9066144382062851e-01 5.7984707420217379e-04
     	 	 9.7919981896774311e-02 8.9959943868690451e-01 2.5225757980706708e-04
     	 	 6.0495886972566693e-02 2.2652346699766949e-03 1.8395861567865770e-04
     	 	 6.0088698446663091e-02 1.2184906840130072e-02 4.3980929041764646e-04
     	 	 5.9505272229126938e-02 3.0582375783663723e-02 7.1121167342256002e-04
     	 	 5.7091752288035535e-02 5.7279680793171688e-02 8.8859329374173560e-04
     	 	 5.7755490933924070e-02 9.1167998713224188e-02 1.1430894069407846e-03
     	 	 6.3173156335080471e-02 1.3057632424681331e-01 1.4034386570511090e-03
     	 	 5.3472731099325044e-02 1.7766994256032045e-01 1.3995818378937249e-03
     	 	 5.5020666050106359e-02 2.2864363860341355e-01 1.5505199335039885e-03
     	 	 5.6105994749360510e-02 2.8422141404592682e-01 1.6806832305659937e-03
     	 	 5.5359643913090339e-02 3.4433531593849276e-01 1.7811907777944374e-03
     	 	 5.4757402982626102e-02 4.0751983927945423e-01 1.8272196335620944e-03
     	 	 5.5927484164923436e-02 4.7074822437770830e-01 1.8375782495748338e-03
     	 	 5.6989633261343875e-02 5.3294484362307426e-01 1.8566895179978368e-03
     	 	 5.5933553941107772e-02 5.9595181406394782e-01 1.8057560396876678e-03
     	 	 5.5707008430637028e-02 6.5642893951229353e-01 1.6981671508181511e-03
     	 	 5.6745051238369482e-02 7.1202219049054827e-01 1.5970656058004488e-03
     	 	 5.7212454938585178e-02 7.6349031510302345e-01 1.4700918444809795e-03
     	 	 5.6663328054837536e-02 8.1063011496220583e-01 1.2881817697445934e-03
     	 	 5.6331031528036979e-02 8.5130218346181241e-01 1.0840135731649337e-03
     	 	 5.7140456948342022e-02 8.8401267916632931e-01 8.9075498193835572e-04
     	 	 5.9125357720211102e-02 9.0858310176720158e-01 7.0844463816689359e-04
     	 	 6.0748824133449064e-02 9.2594387141065537e-01 4.7424175508320557e-04
     	 	 6.1952194118176318e-02 9.3550385337233077e-01 2.0973779866783045e-04
     	 	 3.2938404439532332e-02 2.7302209564325198e-03 1.6449158402681251e-04
     	 	 3.2676176587542627e-02 1.4189237691149530e-02 3.7007766248932855e-04
     	 	 3.2084263424329906e-02 3.4001642096789325e-02 5.4681411649531986e-04
     	 	 3.1259097892440635e-02 6.1217755719640402e-02 6.7665299147877552e-04
     	 	 3.1150839591619239e-02 9.4903522302551988e-02 8.3397646446852023e-04
     	 	 3.4342351487600453e-02 1.3481874721067999e-01 1.0783939971627328e-03
     	 	 2.8482940175005522e-02 1.8315285613005503e-01 1.0646264708466609e-03
     	 	 2.9918270692232740e-02 2.3593154011521789e-01 1.1936307885517708e-03
     	 	 3.0601505185544164e-02 2.9395925391146388e-01 1.3235792267972122e-03
     	 	 3.0057610905534049e-02 3.5648444363592785e-01 1.3769984508409025e-03
     	 	 2.9749134832709356e-02 4.2140488407841920e-01 1.3990064401619448e-03
     	 	 3.0514396945374611e-02 4.8701103263028217e-01 1.4483696409219177e-03
     	 	 3.0984600849784161e-02 5.5303706159602606e-01 1.4638898178627009e-03
     	 	 3.0324913662863828e-02 6.1850060198455348e-01 1.3906543605737879e-03
     	 	 3.0360302392348215e-02 6.8070162131344958e-01 1.3135218329355478e-03
     	 	 3.0951610287610398e-02 7.3857601132437301e-01 1.2419984741136891e-03
     	 	 3.1127926002440742e-02 7.9185374052594382e-01 1.1287155947933608e-03
     	 	 3.0791723336051291e-02 8.3970425077226962e-01 9.7718727239729593e-04
     	 	 3.0648424470446578e-02 8.8071694896124697e-01 8.2103219966793482e-04
     	 	 3.1284127934796624e-02 9.1366214509109434e-01 6.6228965237756727e-04
     	 	 3.2215485717644543e-02 9.3833229702921161e-01 4.9904231879960260e-04
     	 	 3.3092537353351270e-02 9.5500401815195213e-01 3.2202885315282955e-04
     	 	 3.3772160790060290e-02 9.6397796677216641e-01 1.3956213429256963e-04
     	 	 1.3522981384566313e-02 2.1914553934314477e-03 8.6658799983836468e-05
     	 	 1.3407314208650822e-02 1.1991523224325722e-02 2.1328158342740104e-04
     	 	 1.3154065179927343e-02 3.0579974694819989e-02 3.4366714680849817e-04
     	 	 1.2902514900270723e-02 5.8188309778333044e-02 4.6532181603704955e-04
     	 	 1.2691936529295234e-02 9.4459148612610427e-02 5.7826629625479535e-04
     	 	 1.3976639695205573e-02 1.3805978400401372e-01 7.4412686429840510e-04
     	 	 1.1407311846070911e-02 1.8921748816764880e-01 7.0442559914102656e-04
     	 	 1.2330829079079342e-02 2.4495860652859991e-01 8.0782845209869227e-04
     	 	 1.2542691145062457e-02 3.0500035763921485e-01 8.7419583958788199e-04
     	 	 1.2281842785013208e-02 3.6807472622347159e-01 8.8692946475477184e-04
     	 	 1.2185256762785923e-02 4.3265365356949070e-01 8.9364514687321930e-04
     	 	 1.2512037814974231e-02 4.9753650327840798e-01 9.1713492190954328e-04
     	 	 1.2705587860732503e-02 5.6194059005122088e-01 9.1540680638465773e-04
     	 	 1.2421961646946422e-02 6.2518193306961001e-01 8.7382198825361251e-04
     	 	 1.2421178883102235e-02 6.8653558810604420e-01 8.4419495994598266e-04
     	 	 1.2657110314979292e-02 7.4493531035652094e-01 8.0878378229708604e-04
     	 	 1.2759252666154297e-02 7.9914423304576654e-01 7.4534533689766733e-04
     	 	 1.2656500530318859e-02 8.4814409462491591e-01 6.5540949667137463e-04
     	 	 1.2528278240352630e-02 8.9097697397437392e-01 5.5753031358742012e-04
     	 	 1.2780855266685043e-02 9.2648958081474675e-01 4.6010726248953935e-04
     	 	 1.3124356441835738e-02 9.5403240147609492e-01 3.5182507595329763e-04
     	 	 1.3507186268665095e-02 9.7312223060811509e-01 2.3145295945957783e-04
     	 	 1.3843849084359094e-02 9.8362197092358417e-01 1.0155741927472298e-04
     	 	 2.5785802176229167e-03 2.8213270253203797e-03 4.7763403774932743e-05
     	 	 2.5442623102219786e-03 1.4747322140998933e-02 1.0804518352263158e-04
     	 	 2.4937870896053482e-03 3.5720478949872118e-02 1.6138223112640242e-04
     	 	 2.4542555504329933e-03 6.4838412734288947e-02 2.0617013186042786e-04
     	 	 2.4117564248988810e-03 1.0078414283605684e-01 2.4035205072480008e-04
     	 	 2.7039317776993421e-03 1.4209486143627828e-01 3.0415367575859815e-04
     	 	 2.0972314635331335e-03 1.8870141429990020e-01 2.6692990924970759e-04
     	 	 2.3434057427229593e-03 2.4071285757030703e-01 3.2917851696773317e-04
     	 	 2.3916553826361930e-03 2.9800625031622829e-01 3.6554533178931987e-04
     	 	 2.3503023275917023e-03 3.5961633677304294e-01 3.8229901751784992e-04
     	 	 2.3165902056269116e-03 4.2455052458521586e-01 3.9309092594604165e-04
     	 	 2.3703956039192731e-03 4.9136194380377396e-01 4.0838684842423820e-04
     	 	 2.4229471040223549e-03 5.5832280881506413e-01 4.1341963718472924e-04
     	 	 2.3716518792930019e-03 6.2409192879083875e-01 3.9387487912232919e-04
     	 	 2.3621182510151773e-03 6.8752720421076885e-01 3.7492336802190981e-04
     	 	 2.4091633946302649e-03 7.4750063911676068e-01 3.5794154060710701e-04
     	 	 2.4296558504429688e-03 8.0306758417729152e-01 3.3051935305789562e-04
     	 	 2.4165245806442304e-03 8.5326700143590950e-01 2.9220320778122343e-04
     	 	 2.3836583335412609e-03 8.9717057207239614e-01 2.4729747099925154e-04
     	 	 2.4322582539225701e-03 9.3389634291955026e-01 2.0553720762610174e-04
     	 	 2.4940287716301857e-03 9.6276816303331791e-01 1.5858788435148833e-04
     	 	 2.5667411514429528e-03 9.8317066975601508e-01 1.0579542033772067e-04
     	 	 2.6381773812680365e-03 9.9464157581010926e-01 4.7159830681350942e-05
     	 	 ];


    case 46

        % SET: SLOBODKINS TAUSCH
        % CARDINALITY RULE  :    380
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 9.402e-16

        XYW=[
    	 	 9.9565355064754768e-01 2.3287620213290946e-03 3.1410810876761840e-05
     	 	 9.8531253925541473e-01 1.2345222154039029e-02 8.3935208372900791e-05
     	 	 9.8646271796489604e-01 2.4356969079642257e-03 8.1619101386582187e-05
     	 	 9.7524377915690663e-01 1.2761958124674953e-02 1.8780329874423248e-04
     	 	 9.6722201707115885e-01 3.0472866653114813e-02 1.3159782232460157e-04
     	 	 9.6933976196864435e-01 2.3095903571225037e-03 1.2690162483148612e-04
     	 	 9.5974614518448165e-01 1.2070229182877690e-02 2.6306687471602255e-04
     	 	 9.4003666428500565e-01 2.9464905248253861e-02 4.7236863418060958e-04
     	 	 9.5684493064671172e-01 3.0871727253208102e-02 3.0828020989859240e-04
     	 	 9.4092793111941608e-01 5.6632447472328290e-02 1.8793945100445281e-04
     	 	 9.4381939960030303e-01 2.3285035192830857e-03 1.7584380092698163e-04
     	 	 9.3671411564122886e-01 1.2257304793477506e-02 3.6846117894423573e-04
     	 	 9.1283094319238745e-01 3.0123380733078606e-02 6.6443250494305022e-04
     	 	 8.8807742621065944e-01 5.5739853105622565e-02 8.5203374671869109e-04
     	 	 9.1517441935983679e-01 5.4035929998757101e-02 6.1187132378275641e-04
     	 	 9.3091370115019778e-01 5.6354505478599756e-02 4.1335949486867428e-04
     	 	 9.0710499738192252e-01 9.0528346187005393e-02 2.2841669278552806e-04
     	 	 9.1080448672601211e-01 2.3471769447867439e-03 2.1867302459282307e-04
     	 	 9.0607268346130099e-01 1.2308112417097379e-02 4.8257525667844950e-04
     	 	 8.7876800576870751e-01 2.9964485442091290e-02 8.0615182627012455e-04
     	 	 8.5623198699556580e-01 5.4979430552870891e-02 1.0333616932888649e-03
     	 	 8.5516472872946037e-01 8.8740626781213694e-02 1.0642881412402489e-03
     	 	 8.8398041783664716e-01 8.5484316686166462e-02 7.6001289824593522e-04
     	 	 8.9883486950434244e-01 8.8702673223208517e-02 5.0222960054592633e-04
     	 	 8.6598186132625232e-01 1.3165294685052031e-01 2.6992405527122298e-04
     	 	 8.7163597687747307e-01 2.3345973484954377e-03 2.4988686525532675e-04
     	 	 8.6723482316421951e-01 1.2263326257645202e-02 5.9266914980062708e-04
     	 	 8.3825510232458289e-01 2.9915245349379151e-02 9.2558077394782592e-04
     	 	 8.1644482286307507e-01 5.5017778237868541e-02 1.2391538612653847e-03
     	 	 8.2464842468696742e-01 8.6898771492344998e-02 1.2475963307893860e-03
     	 	 8.1548096060063080e-01 1.2859788834471780e-01 1.2669447291250170e-03
     	 	 8.4644082663117304e-01 1.2323812951961521e-01 8.8869508348604523e-04
     	 	 8.6020107390512490e-01 1.2739011169438388e-01 5.8379298936677977e-04
     	 	 8.1833682877766245e-01 1.7929371612716474e-01 3.0762567883625680e-04
     	 	 8.2779475997342955e-01 2.3249763717498825e-03 2.7322908284914426e-04
     	 	 8.2085520497997932e-01 1.2212023222481013e-02 6.8733985518254991e-04
     	 	 7.9338513917449682e-01 2.9792400911119898e-02 9.9154835075107193e-04
     	 	 7.7014099066319830e-01 5.4795896717883992e-02 1.4186831297062262e-03
     	 	 7.4540863904615540e-01 1.2521589991050283e-01 1.7896183982987301e-03
     	 	 7.8630575464061458e-01 8.7044365084224987e-02 1.4414025039234204e-03
     	 	 7.8567205557181141e-01 1.2528144978908831e-01 1.5248485318524914e-03
     	 	 7.6961001505621884e-01 1.7472203246263224e-01 1.4075280187517561e-03
     	 	 8.0275203519008786e-01 1.6688066977014096e-01 1.0089020573382308e-03
     	 	 8.1560777544891039e-01 1.7194717199711543e-01 6.6565963553869402e-04
     	 	 6.6280393068360899e-01 1.6926510689169910e-01 2.1030994037623020e-03
     	 	 7.7995529723105794e-01 2.3224296443039548e-03 2.9769357833527677e-04
     	 	 7.6801154497947177e-01 1.2175925724520583e-02 7.6456433594310810e-04
     	 	 7.4616673432957126e-01 2.9688016185717019e-02 1.0233732853874623e-03
     	 	 7.1794257949155926e-01 5.4457123146400971e-02 1.5613076832518219e-03
     	 	 7.4308203603545153e-01 8.6773839208075118e-02 1.6242752433030558e-03
     	 	 6.9867588026329108e-01 1.2502419843777510e-01 2.0658852909539566e-03
     	 	 7.0620907847261460e-01 1.6830086067995528e-01 1.8085656545497675e-03
     	 	 7.4253298736433226e-01 1.6973496244004266e-01 1.6608888455484925e-03
     	 	 7.1889150104633648e-01 2.2593007232245088e-01 1.5312407221354163e-03
     	 	 7.5397682791366216e-01 2.1589444301813240e-01 1.1091015163592949e-03
     	 	 7.6559220799889161e-01 2.2207208535217218e-01 7.3387419603294782e-04
     	 	 7.6504743524483088e-01 2.3260701060955616e-01 3.3564558747432296e-04
     	 	 7.2748738262737755e-01 2.2932051622650603e-03 3.2400930697166547e-04
     	 	 7.1014426288922550e-01 1.2014202494042052e-02 8.1529260877503756e-04
     	 	 6.9676761375668794e-01 2.9323431251380153e-02 1.0897481071125252e-03
     	 	 6.6126911559328927e-01 5.3718846760100705e-02 1.6576056403902711e-03
     	 	 6.9492171896391730e-01 8.6182084827694627e-02 1.7942188078125725e-03
     	 	 6.4722673582437085e-01 1.2361133361765189e-01 2.2339520258052217e-03
     	 	 6.6070300786966618e-01 2.1425687123935167e-01 1.8297876757830554e-03
     	 	 6.9283703633990545e-01 2.1986136169487966e-01 1.8597623254003799e-03
     	 	 6.6497336174415300e-01 2.8114802958236479e-01 1.5688326870195949e-03
     	 	 7.0084475299976445e-01 2.6953887084328959e-01 1.1776677088464068e-03
     	 	 7.1062327221872779e-01 2.7724727696992885e-01 7.8519338253726218e-04
     	 	 7.0712438995348470e-01 2.9057333460378865e-01 3.5363823102733531e-04
     	 	 6.6982137056270807e-01 2.2669066238696816e-03 3.4954468563113571e-04
     	 	 6.4848214778649360e-01 1.1867528744135403e-02 8.4587081024621211e-04
     	 	 6.4228938772796140e-01 2.9003746973075475e-02 1.1966809520380392e-03
     	 	 6.0105549186038343e-01 5.3106335569053843e-02 1.7111265991837667e-03
     	 	 6.4171106121908961e-01 8.5122241996825956e-02 1.9554442175290974e-03
     	 	 5.9142877492506529e-01 1.2207509936955914e-01 2.3623062387257850e-03
     	 	 6.1727936177004472e-01 1.6691959198059814e-01 2.2804644133263561e-03
     	 	 6.0547945495008670e-01 2.1623061312277861e-01 2.0811867278874882e-03
     	 	 6.2413428686061123e-01 2.2331930919242959e-01 8.7642915356293848e-04
     	 	 6.1498055508692906e-01 2.6447592240041290e-01 1.9209011335980023e-03
     	 	 6.3999350517768350e-01 2.7533829490019512e-01 1.9185193970275550e-03
     	 	 6.0818954575906425e-01 3.3895087928497114e-01 1.6104786047306300e-03
     	 	 6.4383191916277860e-01 3.2722888103916803e-01 1.2263673754423702e-03
     	 	 6.5152063183559772e-01 3.3662610474514504e-01 8.1526963520312597e-04
     	 	 6.4570015076809395e-01 3.5204934130948196e-01 3.6226761683274086e-04
     	 	 6.0766471126765287e-01 2.2455866086760717e-03 3.6820850907055911e-04
     	 	 5.8453356205883678e-01 1.1772995000876673e-02 8.5834500669296578e-04
     	 	 5.8250301110502778e-01 2.8757382379846565e-02 1.2775392299157764e-03
     	 	 5.3869581906549846e-01 5.2772495865730004e-02 1.7347755386453799e-03
     	 	 5.8373662887593003e-01 8.4095541607661362e-02 2.0712470884476954e-03
     	 	 5.6623313992977509e-01 1.6506338646134758e-01 2.4708601374899344e-03
     	 	 5.5937062479331423e-01 2.1339326383141197e-01 2.5660973082274352e-03
     	 	 5.3366045324795708e-01 2.6348954468886165e-01 2.2195945403550919e-03
     	 	 5.6675720576467414e-01 2.7310307788960053e-01 2.2819936566097010e-03
     	 	 5.6257406865140480e-01 3.1721234253802849e-01 2.1237821176932526e-03
     	 	 5.8214040040833970e-01 3.3433889356299190e-01 2.0338430545952767e-03
     	 	 5.4881489629597380e-01 3.9847044942411297e-01 1.6572071607427580e-03
     	 	 5.8336623301788548e-01 3.8800676844969079e-01 1.2705542953695354e-03
     	 	 5.8935840494413094e-01 3.9892491963683024e-01 8.3769164425653180e-04
     	 	 5.8206393882477292e-01 4.1570548196651552e-01 3.6772101214161697e-04
     	 	 5.4250365591680894e-01 2.2427354514767475e-03 3.8003326785395142e-04
     	 	 5.1988091917919954e-01 1.1784441068629994e-02 8.5660336062078372e-04
     	 	 5.1917832639192052e-01 2.8737910265143499e-02 1.3246322197590292e-03
     	 	 4.7526394476629796e-01 5.3025993495517336e-02 1.7445559139846220e-03
     	 	 5.2196753520254169e-01 8.3513472567253777e-02 2.1451492042211611e-03
     	 	 5.3246867924040964e-01 1.2063895293905590e-01 2.4211090808856609e-03
     	 	 5.1107533511707448e-01 1.6309678203330463e-01 2.5953808539926648e-03
     	 	 5.0634754751281674e-01 2.1090939843524717e-01 2.7485032731860500e-03
     	 	 4.8695029052702066e-01 2.6120605977960065e-01 2.5643541114547660e-03
     	 	 4.8001924541106933e-01 3.0993674752223332e-01 2.2824167760911764e-03
     	 	 5.0787381117909836e-01 3.2909998951235414e-01 2.6240739892542941e-03
     	 	 5.0712529678093143e-01 3.7210089034328769e-01 2.2574258509133493e-03
     	 	 5.2097844101655233e-01 3.9538022110297516e-01 2.1116130405834962e-03
     	 	 4.8846941399619792e-01 4.5861208821035465e-01 1.6558860584891812e-03
     	 	 5.2070081864185080e-01 4.5058406988571376e-01 1.3018313442010945e-03
     	 	 5.2531133211259617e-01 4.6293053589989747e-01 8.5709034940883663e-04
     	 	 5.1756111723118781e-01 4.8019712480044779e-01 3.7083027962418795e-04
     	 	 4.7604818922761771e-01 2.2595791539089926e-03 3.8544846214333758e-04
     	 	 4.5609017766860849e-01 1.1895924717194133e-02 8.4425060239189228e-04
     	 	 4.5428984054742949e-01 2.9018688176745688e-02 1.3499303542606066e-03
     	 	 4.2393619924096115e-01 5.4277539233969885e-02 3.5698496238401224e-04
     	 	 4.5799247710295410e-01 8.3981860203634073e-02 2.1786836350860391e-03
     	 	 4.7098057536396121e-01 1.2053175572113103e-01 2.4698909014792825e-03
     	 	 4.5281705413233631e-01 1.6277246214686980e-01 2.6183095774454379e-03
     	 	 4.4992463585207909e-01 2.0952187827232732e-01 2.8382434583932156e-03
     	 	 4.3513698301820736e-01 2.6023808135423149e-01 2.7677202627484016e-03
     	 	 4.2604207703394259e-01 3.1215166211972251e-01 2.7800914535561754e-03
     	 	 4.3208772226613223e-01 3.5671243070307190e-01 2.4309450052103659e-03
     	 	 4.4821746708250909e-01 3.8804613419890949e-01 2.7122605522198542e-03
     	 	 4.4968565479933498e-01 4.2933555086043595e-01 2.3288988498576814e-03
     	 	 4.5871405363144113e-01 4.5742376819261227e-01 2.1219653813183644e-03
     	 	 4.2959967861110671e-01 5.1744867928403937e-01 1.5814808623410834e-03
     	 	 4.5728591864222135e-01 5.1390429876873611e-01 1.3085938011319744e-03
     	 	 4.6058942985340090e-01 5.2760794426850921e-01 8.6094037398695776e-04
     	 	 4.5342158660113763e-01 5.4432975663820160e-01 3.6654287477325966e-04
     	 	 4.0995917834911255e-01 2.2828014006828750e-03 3.8278273655388095e-04
     	 	 3.9431626456184798e-01 1.1997823298034824e-02 8.1977895822936582e-04
     	 	 3.8966900712282027e-01 2.9283881593585567e-02 1.3397273900989141e-03
     	 	 4.0724653989442350e-01 5.3474290983514298e-02 1.4967476772504605e-03
     	 	 3.9396224578196160e-01 8.5008935005120301e-02 2.1713487286543652e-03
     	 	 4.0789355992205356e-01 1.2172475499714713e-01 2.5106886541055051e-03
     	 	 3.9419987368462150e-01 1.6417763693337381e-01 2.5670919242148384e-03
     	 	 3.9099372068982496e-01 2.1046062352260292e-01 2.8537321199289716e-03
     	 	 3.8170316028004414e-01 2.6014897366403100e-01 2.7556898849917457e-03
     	 	 3.7051283113973976e-01 3.1325018699039675e-01 3.0024724425713909e-03
     	 	 3.7219168591799656e-01 3.6533622074478234e-01 2.8452634751567540e-03
     	 	 3.8045195007252508e-01 4.0862704294017826e-01 2.6827630343136551e-03
     	 	 3.8839740095741904e-01 4.4832083385774713e-01 2.7002884006874649e-03
     	 	 3.9126649325769280e-01 4.8807454066528250e-01 2.3338068962565519e-03
     	 	 3.9692185417137726e-01 5.1940645670989682e-01 2.0815046698332302e-03
     	 	 3.7434011261115219e-01 5.7291549925586649e-01 1.4604747261767377e-03
     	 	 3.9428651545213111e-01 5.7695587625697708e-01 1.2850718981990807e-03
     	 	 3.9644521804066268e-01 5.9176537386330619e-01 8.4375499721473597e-04
     	 	 3.9077611383497612e-01 6.0697707030174863e-01 3.5455078549154477e-04
     	 	 3.4566911519191734e-01 2.3056358871168378e-03 3.7224949450410607e-04
     	 	 3.3480173535281865e-01 1.2145962445802955e-02 8.0246481408807106e-04
     	 	 3.2705212061074906e-01 2.9723705862790890e-02 1.2991032888254336e-03
     	 	 3.4581714702456223e-01 5.4378170763034271e-02 1.7673684393563383e-03
     	 	 3.3225964431497523e-01 8.6253850041282873e-02 2.1008607219065133e-03
     	 	 3.4484490545908053e-01 1.2396775348011281e-01 2.5459447649905415e-03
     	 	 3.3699848154422041e-01 1.6794008607500197e-01 2.5807544328242289e-03
     	 	 3.3128813098194554e-01 2.1614206848227754e-01 2.9264542080520784e-03
     	 	 3.2676937336325185e-01 2.6763635258009283e-01 2.8286309351712893e-03
     	 	 3.1383887081243289e-01 3.2108803443205058e-01 2.8928935788900358e-03
     	 	 3.1605071171605381e-01 3.7318707734373718e-01 2.9516040880263879e-03
     	 	 3.1925126230489176e-01 4.2434546752769475e-01 2.8251828190367550e-03
     	 	 3.2627421503125853e-01 4.6771909916030679e-01 2.6701497491943638e-03
     	 	 3.2955703352127563e-01 5.1045866195468581e-01 2.5534337011449389e-03
     	 	 3.3341515904261965e-01 5.4790273647244991e-01 2.2205185233024598e-03
     	 	 3.3668543070867574e-01 5.8059485825462298e-01 1.9679883052286578e-03
     	 	 3.2233334663520685e-01 6.2536886699923255e-01 1.3885562931180667e-03
     	 	 3.3287194894835181e-01 6.3853965553940595e-01 1.2298491157690813e-03
     	 	 3.3406423649058270e-01 6.5420416209405996e-01 8.0863323276062350e-04
     	 	 3.3058948717111758e-01 6.6717646744140779e-01 3.3631705607994406e-04
     	 	 2.8445204494315024e-01 2.3589495437918262e-03 3.5841893537993767e-04
     	 	 2.7731533268181796e-01 1.2385001337914843e-02 7.8521990706540117e-04
     	 	 2.6833180882065644e-01 3.0198631708004030e-02 1.2072944259465975e-03
     	 	 2.8441175933540741e-01 5.5147157295197230e-02 1.7173855426909725e-03
     	 	 2.7422310774292591e-01 8.7196845198404219e-02 1.9542416675949409e-03
     	 	 2.8396971353109346e-01 1.2500391809692674e-01 2.4145756627832150e-03
     	 	 2.8215625325912208e-01 1.6821671285731099e-01 2.4803012034831083e-03
     	 	 2.7394932120849225e-01 2.1672300297454616e-01 2.8283838653018183e-03
     	 	 2.7292693803567913e-01 2.6898447427801758e-01 2.8680560444905583e-03
     	 	 2.6087404461755648e-01 3.2395699888781004e-01 2.8280275094693381e-03
     	 	 2.6046508046405326e-01 3.7844221549364732e-01 2.8614487894039905e-03
     	 	 2.6380643500788903e-01 4.2955608800322115e-01 2.7263436568187877e-03
     	 	 2.6599347299647613e-01 4.7817531560511589e-01 2.5847187911742864e-03
     	 	 2.7134694393379455e-01 5.2114588430274622e-01 2.5502339619940476e-03
     	 	 2.7241689218426701e-01 5.6579465983252564e-01 2.4519510615028744e-03
     	 	 2.7690145703053826e-01 6.0356104484490902e-01 2.2108185816176172e-03
     	 	 2.7890192380596979e-01 6.3873638043669501e-01 1.9179358767375896e-03
     	 	 2.7106412246577516e-01 6.7762057676677245e-01 1.4213529565672838e-03
     	 	 2.7422778153695337e-01 6.9826744976497523e-01 1.1493037313727392e-03
     	 	 2.7457068299470078e-01 7.1433719409344942e-01 7.3133556033618224e-04
     	 	 2.7351683082867340e-01 7.2440313460894079e-01 2.9618481052744676e-04
     	 	 2.2741492333236701e-01 2.3571723973379029e-03 3.3054234882373690e-04
     	 	 2.2254092963848848e-01 1.2376999047531567e-02 7.4283998135058176e-04
     	 	 2.1562063832404699e-01 3.0272182248601731e-02 1.0730147549738154e-03
     	 	 2.2616136307367185e-01 5.5766609910832411e-02 1.6302494353453263e-03
     	 	 2.2123210752571454e-01 8.8407199705530903e-02 1.8118872821941774e-03
     	 	 2.2677817612491424e-01 1.2715443644350105e-01 2.2983903856930803e-03
     	 	 2.2869351404356253e-01 1.7150282718126980e-01 2.4350598832934135e-03
     	 	 2.1949288290059277e-01 2.2002703322617204e-01 2.5657276247718817e-03
     	 	 2.2091744029216698e-01 2.6968793928199791e-01 2.5544463540824488e-03
     	 	 2.1176226505551621e-01 3.1885349273616420e-01 2.3118178509077955e-03
     	 	 2.0909543785742668e-01 3.6670376335368043e-01 2.3236682222080567e-03
     	 	 2.0976997601493319e-01 4.1483533095490083e-01 2.4800676286082734e-03
     	 	 2.1260342460937953e-01 4.6578097696708048e-01 2.7100855061404396e-03
     	 	 2.1449780805781005e-01 5.1926037928844249e-01 2.7182591430327538e-03
     	 	 2.1818577858606447e-01 5.6921465973829655e-01 2.6289750315073280e-03
     	 	 2.1893104642417327e-01 6.1729110015324340e-01 2.3792033832111159e-03
     	 	 2.2290398822954116e-01 6.5677195456606874e-01 2.1062497223211297e-03
     	 	 2.2491584196790360e-01 6.9175139939019314e-01 1.7433388231705531e-03
     	 	 2.1992719498055990e-01 7.2655355266522403e-01 1.3533876346181069e-03
     	 	 2.1928593366872839e-01 7.5113199068169234e-01 1.0902246921851515e-03
     	 	 2.1909984708061847e-01 7.6860566148553933e-01 7.2924329388006663e-04
     	 	 2.2004365714524121e-01 7.7758906829428731e-01 3.1233250115823456e-04
     	 	 1.7532079385480259e-01 2.3420480958438361e-03 2.9671011445069035e-04
     	 	 1.7156005594883317e-01 1.2291988944547439e-02 6.7398189690100945e-04
     	 	 1.6972006657449501e-01 2.9922919951896373e-02 9.1645148068259538e-04
     	 	 1.7289689103646377e-01 5.5159305179830871e-02 1.4497559919938517e-03
     	 	 1.7299326226375744e-01 8.7293783812990758e-02 1.6432916113256675e-03
     	 	 1.7428975459236651e-01 1.2633779209713811e-01 2.0793299690631821e-03
     	 	 1.7809090400473959e-01 1.7099690736095158e-01 2.3040660455690017e-03
     	 	 1.7059902020703477e-01 2.2082903540365009e-01 2.4274370171022660e-03
     	 	 1.7071903972653124e-01 2.7519424072024556e-01 2.6716758016000911e-03
     	 	 1.6439443735554882e-01 3.3414149333833637e-01 2.6565453109163796e-03
     	 	 1.6188807511479564e-01 3.9463930208879061e-01 2.6967185913781186e-03
     	 	 1.6318700340389003e-01 4.5404077625761974e-01 2.6783335060729854e-03
     	 	 1.6532869276291862e-01 5.1083567065206881e-01 2.5746754019965539e-03
     	 	 1.6683508740603881e-01 5.6383131013623178e-01 2.3559384814352876e-03
     	 	 1.6907490602225561e-01 6.1125549841637816e-01 2.2270592133679353e-03
     	 	 1.6940050261606476e-01 6.5723563806031293e-01 2.1190308911857134e-03
     	 	 1.7218015591371005e-01 6.9848408423104213e-01 1.9981042975948256e-03
     	 	 1.7482423372369260e-01 7.3516248335357737e-01 1.7374329674765140e-03
     	 	 1.7157213032099916e-01 7.7137447248590818e-01 1.3978599218855167e-03
     	 	 1.6927013457523155e-01 7.9981744616895578e-01 1.0608657540771651e-03
     	 	 1.6860452757139199e-01 8.1882676327717629e-01 6.8120055482033960e-04
     	 	 1.7053247463556465e-01 8.2709244736274390e-01 2.8863140518737245e-04
     	 	 1.2879934914085922e-01 2.3863709623868903e-03 2.6624388395996132e-04
     	 	 1.2577187752331742e-01 1.2557629455294582e-02 6.0614012772933527e-04
     	 	 1.2902139670393564e-01 3.0725544109819029e-02 8.6249940680356216e-04
     	 	 1.2574991218050113e-01 5.6460829700313235e-02 1.2890641324552244e-03
     	 	 1.2910262224216629e-01 8.9358956688223329e-02 1.5097067079970167e-03
     	 	 1.2805725752567687e-01 1.2851650709714310e-01 1.8059629726178840e-03
     	 	 1.3191785849122828e-01 1.7277647642874303e-01 2.0177020237677865e-03
     	 	 1.2617715770316595e-01 2.1698004267627308e-01 1.5611626176475746e-03
     	 	 1.2711737656796673e-01 2.4657350323476981e-01 1.2572818849566239e-03
     	 	 1.2547184459727312e-01 2.8966796977932668e-01 2.1988951753468553e-03
     	 	 1.2169572288906894e-01 3.4642287467627592e-01 2.3157527995140859e-03
     	 	 1.1967347702028996e-01 4.0607172494032434e-01 2.3864446237606639e-03
     	 	 1.2040298199402200e-01 4.6708748255392335e-01 2.4737045970613597e-03
     	 	 1.2193140919948653e-01 5.2826119255785065e-01 2.4883494007639745e-03
     	 	 1.2338782706525275e-01 5.8793271947811621e-01 2.4150341372947883e-03
     	 	 1.2466102581107397e-01 6.4458012125988873e-01 2.2942620806313632e-03
     	 	 1.2526277993123780e-01 6.9672685328573436e-01 2.0631203202191081e-03
     	 	 1.2725529966026861e-01 7.4154550207987668e-01 1.8310934543633044e-03
     	 	 1.2945451994197166e-01 7.7974885944274552e-01 1.5834228568694152e-03
     	 	 1.2699283886367485e-01 8.1581711777793353e-01 1.2526169296048801e-03
     	 	 1.2457384332875177e-01 8.4422854235763467e-01 9.2687131702703799e-04
     	 	 1.2401531527233145e-01 8.6308662445512307e-01 5.9700826783118464e-04
     	 	 1.2573202435305220e-01 8.7179507630838105e-01 2.6661209073510758e-04
     	 	 8.8556167329568392e-02 2.3945343438544816e-03 2.2634268499357327e-04
     	 	 8.6487980213945326e-02 1.2539690267722611e-02 5.0486722098020895e-04
     	 	 9.1463295060025263e-02 3.0562243831940148e-02 7.8062361295886155e-04
     	 	 8.5566957351650097e-02 5.6055843028012274e-02 1.0607068504494106e-03
     	 	 8.9911934833749818e-02 8.8711454644624183e-02 1.3095136095526150e-03
     	 	 8.8513936778723989e-02 1.2774096184792413e-01 1.5152887744429948e-03
     	 	 9.1056521062690354e-02 1.7248328175851035e-01 1.7692198429986716e-03
     	 	 8.8271995970754857e-02 2.2221338511834859e-01 1.8315161073836769e-03
     	 	 8.7423639014362453e-02 2.7622104431348132e-01 1.9981615351272008e-03
     	 	 8.5399359092581451e-02 3.3424483252497217e-01 2.0572069555428786e-03
     	 	 8.3257948087468669e-02 3.9572230583068663e-01 2.1060667168029635e-03
     	 	 8.3114645923787811e-02 4.5886753377145301e-01 2.1509401841717673e-03
     	 	 8.3994335309372392e-02 5.2196916012983063e-01 2.1630071421459016e-03
     	 	 8.5068278647939199e-02 5.8365527637957038e-01 2.1164734049435928e-03
     	 	 8.6038993298677924e-02 6.4249458638892298e-01 2.0117050707212391e-03
     	 	 8.6436399214885773e-02 6.9739460959424671e-01 1.8612523153718743e-03
     	 	 8.7127334032523485e-02 7.4674990689031628e-01 1.6651432921056554e-03
     	 	 8.8726180593036053e-02 7.8908462551881431e-01 1.4669175059346688e-03
     	 	 8.9808589006184936e-02 8.2572411050124328e-01 1.2676647728527468e-03
     	 	 8.7631810349696471e-02 8.5955811913028191e-01 1.0096234864733864e-03
     	 	 8.5667076698774935e-02 8.8615771683194045e-01 7.4189891746361978e-04
     	 	 8.6116194968422932e-02 9.0267053835221034e-01 4.4893528907469980e-04
     	 	 8.6630479348361877e-02 9.1126984915619880e-01 1.9485227921633356e-04
     	 	 5.5259913010136774e-02 2.3599872739791662e-03 1.7914987788183285e-04
     	 	 5.4398462723925789e-02 1.2394933546972919e-02 3.9786680143340968e-04
     	 	 5.8332560461171745e-02 3.0334223864902109e-02 6.5528082184624541e-04
     	 	 5.3123899500999272e-02 5.5692032786903239e-02 8.2667715569664487e-04
     	 	 5.6695107363568420e-02 8.8269876383896995e-02 1.0715300343683014e-03
     	 	 5.5991194021519641e-02 1.2749984387362145e-01 1.2296649785646005e-03
     	 	 5.7228015735122706e-02 1.7288638627270900e-01 1.4531517958295687e-03
     	 	 5.6121330477571618e-02 2.2365287545138526e-01 1.5327473462520753e-03
     	 	 5.5106965970365129e-02 2.7848855233563735e-01 1.6204584677824859e-03
     	 	 5.4117017343188079e-02 3.3540497126919661e-01 1.6004561936313641e-03
     	 	 5.2796890337766578e-02 3.9171328343129452e-01 1.5158055520997822e-03
     	 	 5.2404139209392242e-02 4.4639343442246932e-01 1.4780158921416961e-03
     	 	 5.2658587477419583e-02 5.0024528861470696e-01 1.4863390338256293e-03
     	 	 5.3162267661771567e-02 5.5469274850933092e-01 1.5395404140115020e-03
     	 	 5.3798892990670200e-02 6.1042274506470462e-01 1.5872268910925992e-03
     	 	 5.4359623809701274e-02 6.6656986680030028e-01 1.5901470012191841e-03
     	 	 5.4493736710036655e-02 7.2142510563870599e-01 1.5215280717999823e-03
     	 	 5.4960655221860333e-02 7.7233207037850704e-01 1.4045364978925482e-03
     	 	 5.5977346526644989e-02 8.1755168454410609e-01 1.2556739323610756e-03
     	 	 5.6717551594856808e-02 8.5634916157514041e-01 1.0596710399106118e-03
     	 	 5.5573740108678327e-02 8.8944108186071358e-01 8.1296011274146183e-04
     	 	 5.3554844539731694e-02 9.1616790088774225e-01 6.0979336377854415e-04
     	 	 5.4783446174092809e-02 9.3268621650759342e-01 3.9211564155842488e-04
     	 	 5.4072366746425238e-02 9.4352678741732043e-01 1.7800093945112002e-04
     	 	 2.9555422257299013e-02 2.2935996107485380e-03 1.2799469649366532e-04
     	 	 2.9651632323340560e-02 1.2102047606573435e-02 2.8990238024397105e-04
     	 	 3.1748746034518271e-02 2.9858361681563649e-02 4.9415768772562998e-04
     	 	 2.8619502057115720e-02 5.5349696996487840e-02 6.0713129164461136e-04
     	 	 3.0636089467502958e-02 8.8378206223308414e-02 8.0963537397354089e-04
     	 	 3.0604369418161026e-02 1.2798432511386262e-01 9.2474249810835815e-04
     	 	 3.0953578025607720e-02 1.7302765106354373e-01 1.0598403331461841e-03
     	 	 3.0720225455595385e-02 2.2241969792867305e-01 1.1196083202425807e-03
     	 	 2.9973823666317734e-02 2.7539307920952089e-01 1.1773121046547692e-03
     	 	 2.9513974506059637e-02 3.3201686460080992e-01 1.2345571345809437e-03
     	 	 2.8803935357635368e-02 3.9206091666351534e-01 1.2637961279420311e-03
     	 	 2.8489622371129730e-02 4.5435004039043941e-01 1.2827978226728168e-03
     	 	 2.8645343084604091e-02 5.1723892159942542e-01 1.2925474177391929e-03
     	 	 2.8950017862492294e-02 5.7951785258180166e-01 1.2820738169652297e-03
     	 	 2.9343406424830354e-02 6.3980796526645833e-01 1.2428563808191820e-03
     	 	 2.9588690676749851e-02 6.9687533356953058e-01 1.1708809522291955e-03
     	 	 2.9606898711236118e-02 7.4969701060950866e-01 1.0697388228527193e-03
     	 	 2.9899463911688295e-02 7.9726544317602233e-01 9.7477492461177839e-04
     	 	 3.0437612216788756e-02 8.4015091154762556e-01 9.0110071566017267e-04
     	 	 3.0804263301965618e-02 8.7884477426513485e-01 8.0681711333728231e-04
     	 	 3.0385014577809732e-02 9.1261300114469501e-01 6.5061749750493583e-04
     	 	 2.8732348798601648e-02 9.4054708096755490e-01 4.7068670202066328e-04
     	 	 3.0183629781548205e-02 9.5736243313778902e-01 3.0020744229267973e-04
     	 	 2.8917418830822106e-02 9.6872744394314381e-01 1.2870009244038853e-04
     	 	 1.1874603209552581e-02 2.3958676561563531e-03 8.3547142158252094e-05
     	 	 1.2255629462833317e-02 1.2456666097257220e-02 1.9037264372504347e-04
     	 	 1.3015023174005158e-02 2.9880665621021020e-02 3.0686348999794710e-04
     	 	 1.1642864991020629e-02 5.3909268188793380e-02 3.5982637007455118e-04
     	 	 1.2414338197722530e-02 8.4804354639004292e-02 4.8485960469163653e-04
     	 	 1.2608224754105279e-02 1.2270151487081285e-01 5.8800886380846063e-04
     	 	 1.2609938155917155e-02 1.6774283653740790e-01 6.9093555927824855e-04
     	 	 1.2640959212226743e-02 2.1910860652974190e-01 7.7141328321491006e-04
     	 	 1.2283542332742869e-02 2.7577767981157214e-01 8.1669950689315012e-04
     	 	 1.2074878090677532e-02 3.3650441478805604e-01 8.4877290474280999e-04
     	 	 1.1794984835225564e-02 3.9992210579497067e-01 8.5461700719420477e-04
     	 	 1.1668444219784302e-02 4.6464845247832715e-01 8.5536295463250111e-04
     	 	 1.1734247892157823e-02 5.2944596316734238e-01 8.5462779578977593e-04
     	 	 1.1862474262983813e-02 5.9317504558219059e-01 8.4258007608016420e-04
     	 	 1.2027571091017819e-02 6.5481974006309207e-01 8.2054415689219139e-04
     	 	 1.2121064035644946e-02 7.1360496597864842e-01 7.8138361411606060e-04
     	 	 1.2119595252946036e-02 7.6873030899967887e-01 7.2549119196750123e-04
     	 	 1.2270184294865594e-02 8.1917281404972075e-01 6.6427794811943996e-04
     	 	 1.2511121201150388e-02 8.6388147120589509e-01 5.8881754168727636e-04
     	 	 1.2600168960843705e-02 9.0205648684060824e-01 4.9462707626548154e-04
     	 	 1.2450020593590239e-02 9.3341231537531666e-01 3.8809710775758628e-04
     	 	 1.1522006691930931e-02 9.5860512596624103e-01 2.7521815720991808e-04
     	 	 1.2570637839338317e-02 9.7492707437210724e-01 1.9459440566864267e-04
     	 	 1.1612529100152535e-02 9.8597580209363267e-01 8.2238156861703552e-05
     	 	 2.2215425587553961e-03 2.1059804711209174e-03 3.1158276172287705e-05
     	 	 2.3431229229649020e-03 1.1370536943399524e-02 7.9108847100907854e-05
     	 	 2.4652643549240016e-03 2.8609525675722232e-02 1.3460215785210728e-04
     	 	 2.2340746601245964e-03 5.3834840655161073e-02 1.6662472639242441e-04
     	 	 2.3514432448337175e-03 8.6606936914476421e-02 2.1894561686502638e-04
     	 	 2.4137698091030169e-03 1.2596404150441187e-01 2.6127949067046628e-04
     	 	 2.3929657683192662e-03 1.7071282199528814e-01 2.8884623364955147e-04
     	 	 2.4155599557575957e-03 2.1972091791134851e-01 3.1504971608942867e-04
     	 	 2.3414924225130251e-03 2.7246740709259742e-01 3.2802223956282278e-04
     	 	 2.3068381384026004e-03 3.2906237260211951e-01 3.4630472349999898e-04
     	 	 2.2571848392956007e-03 3.8944245510334580e-01 3.5924562151625833e-04
     	 	 2.2247734104682282e-03 4.5287027556940007e-01 3.6809059637630517e-04
     	 	 2.2296024154359051e-03 5.1798253213985124e-01 3.7409210942307235e-04
     	 	 2.2526990411855241e-03 5.8320959246692039e-01 3.7438212319473261e-04
     	 	 2.2835425794648367e-03 6.4712087515428574e-01 3.6786290776045567e-04
     	 	 2.3078093186373883e-03 7.0840642624865924e-01 3.5266833209621353e-04
     	 	 2.3068144899388576e-03 7.6599388115981637e-01 3.2793500120460755e-04
     	 	 2.3282355632201490e-03 8.1897345237445507e-01 3.0092989780183002e-04
     	 	 2.3780589031836552e-03 8.6642062064310410e-01 2.7089967823933146e-04
     	 	 2.3982918862620606e-03 9.0750117517922047e-01 2.3151830795755998e-04
     	 	 2.3800260073350010e-03 9.4146431484959536e-01 1.8386680205642077e-04
     	 	 2.1765073970492210e-03 9.6782954450136194e-01 1.2375855946194898e-04
     	 	 2.4102984982459219e-03 9.8556596322638312e-01 8.5356899674395828e-05
     	 	 2.1705443637016764e-03 9.9558627375025688e-01 3.2367116301793822e-05
     	 	 ];


    case 47

        % SET: SLOBODKINS TAUSCH
        % CARDINALITY RULE  :    394
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 8.995e-16

        XYW=[
    	 	 9.9496299842941827e-01 2.5127749593064149e-03 4.1693010542942755e-05
     	 	 9.8448971986231681e-01 1.3235782285924372e-02 8.7783174054068734e-05
     	 	 9.8450719832804945e-01 2.2672562570784116e-03 8.6485838275856834e-05
     	 	 9.7580857957978828e-01 1.1982849041614903e-02 1.8985346831317575e-04
     	 	 9.5992627382955831e-01 2.9479996566167711e-02 2.5324920271956156e-04
     	 	 9.6546322494160108e-01 3.2518696618186502e-02 1.2095521512742883e-04
     	 	 9.6571661248027096e-01 2.1911830357655322e-03 1.2811251493819267e-04
     	 	 9.5816653032549448e-01 1.1560502175553700e-02 2.8932080197513466e-04
     	 	 9.4524758475859161e-01 2.8543815205082281e-02 4.0086822662881784e-04
     	 	 9.3430388983011259e-01 5.3861294732977384e-02 3.7652479770553839e-04
     	 	 9.3805298606228149e-01 5.9663507508140111e-02 1.8147655233823659e-04
     	 	 9.3909408122731641e-01 2.2732859339567816e-03 1.7633077418187544e-04
     	 	 9.3213994342811091e-01 1.1871976392116660e-02 3.9110962758516862e-04
     	 	 9.2200594502381905e-01 2.8709243918619117e-02 5.5417862111731340e-04
     	 	 8.9330036151805481e-01 5.2602395199914859e-02 7.7633220964515315e-04
     	 	 9.1776641224591293e-01 5.3102898482887163e-02 5.9978744146175936e-04
     	 	 9.0203267964327272e-01 8.5496544575190042e-02 4.9463224128794292e-04
     	 	 9.0326980109882571e-01 9.4340926745892534e-02 2.3459513333534370e-04
     	 	 9.0516391423905995e-01 2.2945887838900243e-03 2.2051136953023793e-04
     	 	 8.9946179041306251e-01 1.2034792975748044e-02 4.8240588915582063e-04
     	 	 8.9026116788566390e-01 2.9270560126905994e-02 7.3571748267833110e-04
     	 	 8.5987573859272759e-01 5.4055009606566687e-02 9.8960220310901205e-04
     	 	 8.6195083632382952e-01 8.2916868076626238e-02 9.5438765542956697e-04
     	 	 8.8489390700428661e-01 8.4866606591436258e-02 7.5235352118028956e-04
     	 	 8.6332078398963330e-01 1.2435395608366107e-01 5.9064977230488893e-04
     	 	 8.6154111662108213e-01 1.3615081735766019e-01 2.6781049648426987e-04
     	 	 8.6425968117160346e-01 2.2926626607616437e-03 2.6043835338099877e-04
     	 	 8.6121049956031881e-01 1.2096189971666034e-02 5.5850692121423354e-04
     	 	 8.5113432696545399e-01 2.9644672175022216e-02 9.0168152881513284e-04
     	 	 8.2196098833991760e-01 5.4496730484873010e-02 1.1205865496334692e-03
     	 	 8.2709497384730724e-01 8.5699586021042523e-02 1.2358045395308625e-03
     	 	 8.2402069188824267e-01 1.1982296469926182e-01 1.1919005164538819e-03
     	 	 8.4669064700923502e-01 1.2301653543588965e-01 9.0255919847851676e-04
     	 	 8.1858833506793349e-01 1.6980999468786181e-01 6.2993202239666995e-04
     	 	 8.1329997053955627e-01 1.8450194832979894e-01 2.8828187898425288e-04
     	 	 8.1680597536675037e-01 2.1856537191186757e-03 2.8365907092411583e-04
     	 	 8.1837122175984089e-01 1.1524397520140003e-02 5.9162850198883155e-04
     	 	 8.0695496077181716e-01 2.8183877378253598e-02 9.7424423439635853e-04
     	 	 7.8341340549215532e-01 5.1376977237206058e-02 1.1812918632964436e-03
     	 	 7.8766939944703940e-01 8.5699528714641204e-02 1.4809021481483281e-03
     	 	 7.8792712980762392e-01 1.2237598260903552e-01 1.3807785675679742e-03
     	 	 7.6040186203203786e-01 1.5858857933536299e-01 1.1663618571824430e-03
     	 	 7.8481303388566392e-01 1.6355626160788045e-01 1.2392834342369510e-03
     	 	 8.0461984283829824e-01 1.6724099635997869e-01 9.3378768057227014e-04
     	 	 7.6756812098306015e-01 2.2100780301867073e-01 6.9839589252644011e-04
     	 	 7.6348586693597431e-01 2.2120558562896465e-03 3.1666236346988255e-04
     	 	 7.7063830529594179e-01 1.1551984545079797e-02 6.5437768310559123e-04
     	 	 7.5594808739993180e-01 2.8171525164407293e-02 1.0782794887408906e-03
     	 	 7.3483184359742937e-01 5.1901297374590198e-02 1.3836833973401199e-03
     	 	 7.4690326076094071e-01 8.0660383908755615e-02 1.5797800579818643e-03
     	 	 7.1379944338576728e-01 1.1517643105654568e-01 1.6556101203163531e-03
     	 	 7.4840964931080189e-01 1.2355452375451376e-01 1.6653259300151658e-03
     	 	 7.1512217205036965e-01 1.6690709387207300e-01 1.8848120074961686e-03
     	 	 7.2312327522228337e-01 1.9458108884301667e-01 1.2948809461048563e-03
     	 	 7.3586559841008325e-01 2.1249292606932071e-01 1.3870078277708738e-03
     	 	 7.5576352418688586e-01 2.1616573280052970e-01 1.0326619813260636e-03
     	 	 7.1137926332196744e-01 2.7741618549482316e-01 7.3664494160898420e-04
     	 	 7.5975996077355457e-01 2.3807938784978400e-01 3.0935188240818637e-04
     	 	 7.0537708179696468e-01 2.2083496961264491e-03 3.4110564888269684e-04
     	 	 7.1754614152525198e-01 1.1636764843355282e-02 7.3192060386229627e-04
     	 	 7.0038550550014600e-01 2.8448272774250764e-02 1.1644381209975256e-03
     	 	 6.8110926006157735e-01 5.2316067636684831e-02 1.5220671341409965e-03
     	 	 6.9251223439610543e-01 8.2851195678206035e-02 1.8847470253782052e-03
     	 	 6.6476415271589828e-01 1.2042296951052488e-01 1.8406526985559916e-03
     	 	 6.7809614120231554e-01 1.5697061567505796e-01 2.0790549976136400e-03
     	 	 6.5179625228894089e-01 2.0038359014393764e-01 1.6026993657567924e-03
     	 	 6.6608480765110090e-01 2.2028803554703141e-01 1.8579508996362721e-03
     	 	 6.8181015966118586e-01 2.3892750696404524e-01 1.4877336649763784e-03
     	 	 6.8304820221586771e-01 2.6712654594037455e-01 1.4619943066144542e-03
     	 	 7.0349430501538113e-01 2.6929461376676583e-01 1.0626875616748478e-03
     	 	 7.0216977761394961e-01 2.9569243008319224e-01 3.2387147902571996e-04
     	 	 6.4345819114519509e-01 2.1924746901891877e-03 3.5644036229255102e-04
     	 	 6.5973017363157682e-01 1.1531697871802112e-02 7.8014379687771373e-04
     	 	 6.4227110015024191e-01 2.8119205657859060e-02 1.2015588313862334e-03
     	 	 6.2341509762235070e-01 5.1747618514881043e-02 1.6248295741030172e-03
     	 	 6.3532732082469290e-01 8.2399801986484819e-02 1.9683109280068940e-03
     	 	 6.1808982519296018e-01 1.1846287437740778e-01 2.0021696372754189e-03
     	 	 6.2347637350926965e-01 1.6221530099040019e-01 2.3006333178586329e-03
     	 	 6.0849959557832189e-01 2.0597649466640691e-01 2.0460541346700935e-03
     	 	 5.9787279662695680e-01 2.5011052927011640e-01 2.1006458285757024e-03
     	 	 6.1224940802545769e-01 2.7432790850287281e-01 2.0561043529786051e-03
     	 	 6.3259980223011669e-01 2.8851952176536155e-01 1.6737162682462707e-03
     	 	 6.2426653339590876e-01 3.2521269045705858e-01 1.5647457445813575e-03
     	 	 6.4646981153876648e-01 3.2609780722638126e-01 1.1565984944697703e-03
     	 	 6.5120040168955218e-01 3.3756968276661486e-01 7.8209777207948774e-04
     	 	 6.4199764563018480e-01 3.5586333684543603e-01 3.3478066198562123e-04
     	 	 5.7901425561966269e-01 2.1832125159618851e-03 3.6547574459591203e-04
     	 	 5.9815646050096127e-01 1.1480597527153368e-02 8.1695181721563772e-04
     	 	 5.8164691577303473e-01 2.8060310176367079e-02 1.2411116837988396e-03
     	 	 5.6216788603030077e-01 5.1638545952394657e-02 1.6787237496574280e-03
     	 	 5.7540685903773792e-01 8.1979552589377211e-02 2.0663609723850871e-03
     	 	 5.6321928495768248e-01 1.1883442286601954e-01 2.2586536031424572e-03
     	 	 5.1142393558703425e-01 1.6082853513992074e-01 2.6771339264141918e-03
     	 	 5.7100279115073471e-01 1.6014725862945431e-01 2.5133424091291164e-03
     	 	 5.5810269434664406e-01 2.0832834825429669e-01 2.4410256313319063e-03
     	 	 5.4691335872945523e-01 2.5427273360695091e-01 2.3504722226336486e-03
     	 	 5.4222715263799071e-01 2.9949295503365597e-01 2.3307619089453580e-03
     	 	 5.5384582197977350e-01 3.2869298210358200e-01 2.2280057962617739e-03
     	 	 5.7555727240832089e-01 3.4332802504268328e-01 1.9345088583654134e-03
     	 	 5.6369403494270731e-01 3.8504707495470897e-01 1.6393370675195087e-03
     	 	 5.8592304920347915e-01 3.8637252299077690e-01 1.2317680020303887e-03
     	 	 5.8850525715945667e-01 4.0015342704561702e-01 8.1268462712689386e-04
     	 	 5.8054408661894752e-01 4.1728885319998082e-01 3.4270262786041477e-04
     	 	 5.1336881021236180e-01 2.1869822139619797e-03 3.6885475948477379e-04
     	 	 5.3424554294181625e-01 1.1469301013786671e-02 8.3693648164757668e-04
     	 	 5.1938852904781352e-01 2.7993265120004673e-02 1.2607746138085696e-03
     	 	 4.9960396859917600e-01 5.1446624401727613e-02 1.6819656946589928e-03
     	 	 5.1312891872008315e-01 8.1581044165547317e-02 2.0835122645344877e-03
     	 	 5.0550469347441462e-01 1.1760695230515772e-01 2.3241113684663514e-03
     	 	 4.5517333571067164e-01 1.5642092152471149e-01 2.3627456737896502e-03
     	 	 4.6151559240637186e-01 2.1341650450340385e-01 2.0923492766181822e-03
     	 	 5.1081542961784321e-01 2.0505392282742263e-01 2.3046346799517688e-03
     	 	 4.8842059369567192e-01 2.5595317449952953e-01 2.7945048249314237e-03
     	 	 4.9874924109867735e-01 2.8708025981945584e-01 1.2917040950169629e-03
     	 	 4.7874751498973467e-01 3.2001913425470668e-01 2.1085064121512420e-03
     	 	 4.8755419007445222e-01 3.5363618192397606e-01 2.3486771391008957e-03
     	 	 4.9586518024451398e-01 3.8685569221599347e-01 2.2884615665429314e-03
     	 	 5.1633478033313129e-01 4.0225076475610028e-01 1.9695850623506826e-03
     	 	 5.0230200168564776e-01 4.4608653698206241e-01 1.6314976241593156e-03
     	 	 5.2299894737422448e-01 4.4885886812035969e-01 1.2769040970329341e-03
     	 	 5.2455269300090879e-01 4.6389143820827150e-01 8.3586641533839995e-04
     	 	 5.1891317775791479e-01 4.7888079545145845e-01 3.4757414015750107e-04
     	 	 4.4790911158381530e-01 2.1836445673325405e-03 3.6329017262827897e-04
     	 	 4.6922916772672763e-01 1.1475335000301314e-02 8.4343474522676897e-04
     	 	 4.5630617425541542e-01 2.7989562984142909e-02 1.2639364205679806e-03
     	 	 4.3733368362524927e-01 5.1383145175721769e-02 1.6401873445074733e-03
     	 	 3.8831713853781735e-01 8.1298723585719865e-02 2.0326044499738151e-03
     	 	 4.5043962604795118e-01 8.1178589297931258e-02 2.0513452490876329e-03
     	 	 4.4464734648100412e-01 1.1664947555140817e-01 2.3356259740714559e-03
     	 	 3.9717672479119537e-01 1.5708086940045227e-01 2.3837810867957114e-03
     	 	 4.3617909788927367e-01 1.9567899391913637e-01 1.9218470422859102e-03
     	 	 4.2909174326432442e-01 2.6240115680276188e-01 2.9367091155380089e-03
     	 	 4.3004545807304539e-01 3.1252311756434525e-01 2.9488942107045394e-03
     	 	 4.2787557232295370e-01 3.5446781073254330e-01 1.2780646774261067e-03
     	 	 4.3479889535180138e-01 4.0733645920831862e-01 2.2552530767144933e-03
     	 	 4.3574232099321331e-01 4.4676414627055178e-01 2.3326917892348108e-03
     	 	 4.5650472110008800e-01 4.6190441920314090e-01 1.9688852508556167e-03
     	 	 4.4195466484325707e-01 5.0654176127222494e-01 1.6121370076625438e-03
     	 	 4.5911179388909040e-01 5.1292013954249749e-01 1.2884964873595152e-03
     	 	 4.6050280646282704e-01 5.2806802179358248e-01 8.2322935498776442e-04
     	 	 4.5783148003553198e-01 5.3999895758907868e-01 3.3716354802045158e-04
     	 	 3.8421423046143188e-01 2.1594786428684796e-03 3.4415072730209891e-04
     	 	 4.0435032216502698e-01 1.1406030281023712e-02 8.3027261768377095e-04
     	 	 3.9369122588350214e-01 2.7840578473174258e-02 1.2390451839256902e-03
     	 	 3.7738849134663555e-01 5.1211698662466359e-02 1.5645751713178439e-03
     	 	 3.8328474899106013e-01 1.1715709213586226e-01 2.3369466127695737e-03
     	 	 3.4118742718851569e-01 1.5920473817650230e-01 2.3608265356891943e-03
     	 	 3.8184326568696914e-01 1.9842817209522215e-01 2.0229888163695938e-03
     	 	 3.4369888275222049e-01 2.1096036400320542e-01 1.3905996554669257e-03
     	 	 3.9011031539557783e-01 2.3580503185565899e-01 2.2868385112824598e-03
     	 	 3.6635240535990454e-01 2.7690330251876250e-01 2.2310108069470910e-03
     	 	 3.7192783842690358e-01 3.2006651562907412e-01 2.9698618181476198e-03
     	 	 3.6955475947006389e-01 3.7386134521257480e-01 3.0832275139688649e-03
     	 	 3.6001004794267810e-01 4.3209336451169822e-01 2.8289102740599137e-03
     	 	 4.1772170739847203e-01 3.8222543879801352e-01 2.0638414339041785e-03
     	 	 3.8006279420291300e-01 4.5972621913796835e-01 2.4373780886392028e-03
     	 	 3.7481004545470165e-01 5.0653361745392822e-01 2.3917265161065094e-03
     	 	 3.9724054461040059e-01 5.2088653875826985e-01 1.9685277402639117e-03
     	 	 3.8264868298157917e-01 5.6548892728913169e-01 1.5797399167733703e-03
     	 	 3.9525282314161492e-01 5.7659467759172078e-01 1.2763112791873460e-03
     	 	 3.9751912774430598e-01 5.9093538213626651e-01 8.0882806781721358e-04
     	 	 3.9798765092766375e-01 5.9980614035832103e-01 3.3381880231622116e-04
     	 	 3.2470548687990231e-01 2.0838381606734782e-03 3.0031512583699442e-04
     	 	 3.4078434218798359e-01 1.1137360322782302e-02 7.8891944119875745e-04
     	 	 3.3298541593085562e-01 2.7221566051586328e-02 1.1695997894324271e-03
     	 	 3.2122909079290962e-01 5.0071505020224942e-02 1.4381237798768282e-03
     	 	 3.2790511307479631e-01 8.0448712265936265e-02 1.9781200158841793e-03
     	 	 3.2367347645099898e-01 1.1691936273335242e-01 2.3075020893982751e-03
     	 	 2.9441381956200630e-01 1.5727205538215777e-01 1.7184713884855322e-03
     	 	 3.1147204492237934e-01 2.0387609374369259e-01 2.1945023153081751e-03
     	 	 3.2190446688324403e-01 2.5790606456972975e-01 3.0136019493179679e-03
     	 	 3.1286871235756264e-01 3.1720820269203426e-01 2.9968836050534371e-03
     	 	 3.1421148514921482e-01 3.7167801977646003e-01 3.1307225074518378e-03
     	 	 3.1000795834098693e-01 4.2887144839991709e-01 3.0269777670273450e-03
     	 	 3.0330803788070726e-01 4.8639684494234642e-01 2.6976736938135737e-03
     	 	 3.2413978511950847e-01 5.1325772091327027e-01 2.5299509494829259e-03
     	 	 3.1450217803029012e-01 5.6498231697316603e-01 2.3593984414367357e-03
     	 	 3.3842852977253257e-01 5.7850399684146581e-01 1.9675405829290673e-03
     	 	 3.2526759653101178e-01 6.2208357161419059e-01 1.5448003122590051e-03
     	 	 3.3294608290660643e-01 6.3850827584873726e-01 1.2507980530920106e-03
     	 	 3.3631451626993591e-01 6.5202539191428122e-01 7.9315627320754431e-04
     	 	 3.3986320551343818e-01 6.5792600084658703e-01 3.2406047896774598e-04
     	 	 2.7373757918189134e-01 1.8025189266994632e-03 2.1092338197917890e-04
     	 	 2.7995002954226456e-01 1.0030593000896959e-02 6.7607953710288235e-04
     	 	 2.7545308584356676e-01 2.4574072910219423e-02 1.0134506351257570e-03
     	 	 2.6936378559307361e-01 4.5407074307173792e-02 1.2535151835697731e-03
     	 	 2.7089797851862651e-01 7.4489914593483225e-02 1.7594554640525471e-03
     	 	 2.6737759269920036e-01 1.0937468862255316e-01 2.1171508753178563e-03
     	 	 2.5819422524386748e-01 1.4850802760815657e-01 1.8432918016712740e-03
     	 	 2.6132453460088811e-01 1.9815049906172325e-01 2.4623420491653790e-03
     	 	 2.6734206243657399e-01 2.4581198005893659e-01 2.2516729300165348e-03
     	 	 2.6467287112082982e-01 3.0629065923233861e-01 2.8112062883164316e-03
     	 	 2.5994469527498087e-01 3.6848477741088981e-01 2.9351342018181670e-03
     	 	 2.5762653250566325e-01 4.2567145610359219e-01 3.0175517313320382e-03
     	 	 2.5437436352822629e-01 4.8327649317557181e-01 2.8379583235746131e-03
     	 	 2.5113544046386738e-01 5.3783014396322948e-01 2.4480885426395051e-03
     	 	 2.6791176321488808e-01 5.6844713017450299e-01 2.5004739060065792e-03
     	 	 2.5674296878650149e-01 6.2208490844880049e-01 2.2248573480279708e-03
     	 	 2.8120521203938698e-01 6.3465173213273751e-01 1.9064883352455768e-03
     	 	 2.7020431362781205e-01 6.7643804161688714e-01 1.4878625046420846e-03
     	 	 2.7364112839132582e-01 6.9725517944382320e-01 1.1896067402485193e-03
     	 	 2.7746984921627649e-01 7.1056937832210598e-01 7.7081441721869458e-04
     	 	 2.8396527924633996e-01 7.1374839878174490e-01 3.1937139276877236e-04
     	 	 2.3113237213739424e-01 2.4291252250447063e-03 2.6713670402316454e-04
     	 	 2.2206514884324102e-01 1.2285750099662811e-02 7.6103553809165594e-04
     	 	 2.1954397276218374e-01 3.0115192328196705e-02 1.1409840601185823e-03
     	 	 2.2070594179512903e-01 5.6503691004940411e-02 1.4137425281252548e-03
     	 	 2.1568943802237783e-01 8.8773857567520376e-02 1.8507849984515520e-03
     	 	 2.1153260743847846e-01 1.2742943325935285e-01 2.1027435367689190e-03
     	 	 2.1328106598465568e-01 1.7259906166031561e-01 2.2406269673960347e-03
     	 	 2.1210668741642391e-01 2.1848177048171655e-01 2.1406706812268543e-03
     	 	 2.1601218389153509e-01 2.6085168078207799e-01 2.2341605998583499e-03
     	 	 2.6650908596956935e-01 2.6647211165352414e-01 8.4286709677015381e-04
     	 	 2.1149279945041577e-01 3.0865617374590970e-01 2.5226441149929263e-03
     	 	 2.2422842833023937e-01 3.5340569105095138e-01 1.5950899468419552e-03
     	 	 2.0691129572883638e-01 4.2030737967235643e-01 2.8890917156005847e-03
     	 	 2.0535336523075209e-01 4.7852504066311091e-01 2.7782187001228979e-03
     	 	 2.0336322181685873e-01 5.3490616952326031e-01 2.5601022068982345e-03
     	 	 2.0402555960183955e-01 5.8552109745984937e-01 2.2330004116800709e-03
     	 	 2.1390941302794453e-01 6.2277769282306317e-01 2.3515755189740268e-03
     	 	 2.0342257812497577e-01 6.7620961060247253e-01 2.0323421692103457e-03
     	 	 2.2662917165617025e-01 6.8963450886110078e-01 1.8044137733010770e-03
     	 	 2.1765786550828581e-01 7.2985628789774071e-01 1.4146138737363833e-03
     	 	 2.1869556594937389e-01 7.5291578006002602e-01 1.0783235046806605e-03
     	 	 2.2215499989540866e-01 7.6626007819733455e-01 7.0053510177874858e-04
     	 	 2.3100108304201306e-01 7.6678695930975704e-01 2.9173562575104337e-04
     	 	 1.8581335584555758e-01 2.1833460417618232e-03 2.6366585559606367e-04
     	 	 1.6994593476659314e-01 1.1423504985329080e-02 6.3960568386716159e-04
     	 	 1.6937419397690023e-01 2.7955427874218661e-02 9.6440383543147429e-04
     	 	 1.7507517601222866e-01 5.1875701213963753e-02 1.2271187279139437e-03
     	 	 1.6684814756086275e-01 8.2811338333110038e-02 1.6349153534534631e-03
     	 	 1.6375359520102573e-01 1.2086706340697459e-01 1.8870639368626834e-03
     	 	 1.6572027956563606e-01 1.6577573099273943e-01 2.2005666992755608e-03
     	 	 1.6574572734343385e-01 2.1622494704355644e-01 2.3636616636373590e-03
     	 	 1.6645046571982547e-01 2.7036191251578945e-01 2.5427600926520764e-03
     	 	 1.6400825763025750e-01 3.2481897250138586e-01 2.3546295092771036e-03
     	 	 1.5890974572396022e-01 3.7330979515814983e-01 1.7435176123430133e-03
     	 	 1.9605319052834236e-01 3.6991428188998399e-01 1.8367607640343367e-03
     	 	 1.5863542592412416e-01 4.2116602748966053e-01 2.1048295922822778e-03
     	 	 1.5911954078393686e-01 4.7151806573351357e-01 2.4055867356458762e-03
     	 	 1.5803552923120945e-01 5.2655456397159428e-01 2.4139753614731674e-03
     	 	 1.5777991326708163e-01 5.8054059316353990e-01 2.2722304535432699e-03
     	 	 1.6008491113279422e-01 6.2990553367390512e-01 2.1442007532391566e-03
     	 	 1.6427759140543974e-01 6.7375137536193508e-01 2.1475571717283759e-03
     	 	 1.5577297713795857e-01 7.2584590873716315e-01 1.7986917121287883e-03
     	 	 1.7610847195822288e-01 7.4178976688297427e-01 1.6411341892933345e-03
     	 	 1.6837169920106787e-01 7.8031222931104960e-01 1.2758006486114899e-03
     	 	 1.6883284314038838e-01 8.0338682765199343e-01 9.4095086062733401e-04
     	 	 1.7101330921252778e-01 8.1762496869207002e-01 6.2613261309910886e-04
     	 	 1.8128468608396431e-01 8.1655137151443580e-01 2.6605269739787780e-04
     	 	 1.3939295608455526e-01 2.1987281664884537e-03 2.5272831993534831e-04
     	 	 1.2334703005451508e-01 1.1669705630334161e-02 5.7265393916759895e-04
     	 	 1.2453235035636934e-01 2.8477709263728564e-02 8.5092770364464583e-04
     	 	 1.3199648019659438e-01 5.2078074808872304e-02 1.1244658468243362e-03
     	 	 1.2203944174413839e-01 8.2570266297165712e-02 1.4052334672718105e-03
     	 	 1.2144201550606815e-01 1.1871218572181307e-01 1.5327746391185144e-03
     	 	 1.2191769405237474e-01 1.6113960210431691e-01 1.8739983857171041e-03
     	 	 1.2309883624364115e-01 2.0958735770637529e-01 2.0642771405596791e-03
     	 	 1.2309989860476445e-01 2.6367578981525791e-01 2.2899726342855507e-03
     	 	 1.2153565327254801e-01 3.2187886840460245e-01 2.4082345526558599e-03
     	 	 1.1870076224464421e-01 3.8309027752932795e-01 2.3335110816515210e-03
     	 	 1.3828439855728492e-01 3.9695145840728369e-01 1.6871919944573110e-04
     	 	 1.1704129881956205e-01 4.4653361724416207e-01 2.3718901097174979e-03
     	 	 1.1662406187521834e-01 5.0755766338641284e-01 2.3830443979849839e-03
     	 	 1.1649833621505223e-01 5.6709466518433127e-01 2.2588047011858196e-03
     	 	 1.1742786858562171e-01 6.2340130257517645e-01 2.1074249863084846e-03
     	 	 1.1909710348029423e-01 6.7478374461007984e-01 1.9808425099047985e-03
     	 	 1.2058971767018434e-01 7.2097573629865808e-01 1.8222394411416360e-03
     	 	 1.1378003246296164e-01 7.7009067952845045e-01 1.5087895913924734e-03
     	 	 1.3040078620303241e-01 7.8879627639453198e-01 1.4231834979338393e-03
     	 	 1.2389285882000467e-01 8.2506260096427697e-01 1.1010028851469197e-03
     	 	 1.2473215504573287e-01 8.4744835524432693e-01 8.1799158101392264e-04
     	 	 1.2500230124017098e-01 8.6359177728147796e-01 5.5343945365611438e-04
     	 	 1.3547500596602990e-01 8.6235326819197133e-01 2.4205504647693672e-04
     	 	 9.7287747136439173e-02 2.2581972020642728e-03 2.2626746591377923e-04
     	 	 8.3391217227529846e-02 1.1928333888301182e-02 4.8834594008126267e-04
     	 	 8.6015357470120235e-02 2.9054004769620622e-02 7.3381256583956837e-04
     	 	 9.2612119976746454e-02 5.3232774778590078e-02 1.0200842151795780e-03
     	 	 8.2934916535278513e-02 8.4871772311841009e-02 1.2367429860701876e-03
     	 	 8.5385632080717699e-02 1.2234529983308641e-01 1.3380564177853072e-03
     	 	 8.3659937531174622e-02 1.6499874757332580e-01 1.5629161113613107e-03
     	 	 8.5844639195188033e-02 2.1097732564336244e-01 1.6436738323471803e-03
     	 	 8.5447781909831599e-02 2.6080380504762440e-01 1.7992819741769186e-03
     	 	 8.4359626594689874e-02 3.1479839475538102e-01 1.9272561760148321e-03
     	 	 8.3211755634516438e-02 3.7272141638063477e-01 2.0000815536109981e-03
     	 	 8.2157313716177072e-02 4.3388311834272431e-01 2.0457712482074212e-03
     	 	 8.0500811788875137e-02 4.9683685704506142e-01 2.0462866667178680e-03
     	 	 8.0203274250854828e-02 5.5811134757352421e-01 2.0026186582692632e-03
     	 	 8.1259839433919345e-02 6.1618879368628521e-01 1.8562757457265308e-03
     	 	 8.2033315342520785e-02 6.6984960423700690e-01 1.7075472794539075e-03
     	 	 8.2542600332959792e-02 7.1818873280141682e-01 1.5668281905306589e-03
     	 	 8.3448608866994678e-02 7.6120551868663466e-01 1.4081833484347818e-03
     	 	 7.7762748704258255e-02 8.0607409702694610e-01 1.2225204046283286e-03
     	 	 9.0021638725259590e-02 8.2930651913863063e-01 1.2112659041091534e-03
     	 	 8.5615812929455970e-02 8.6327331885600889e-01 9.2823543296559168e-04
     	 	 8.6623898588124248e-02 8.8557072492858779e-01 6.9789750387537193e-04
     	 	 8.5344120181804595e-02 9.0325780095521369e-01 4.6498853527811984e-04
     	 	 9.4727597889769144e-02 9.0310003578155151e-01 2.1079234311131324e-04
     	 	 6.1666262510405079e-02 2.2957893992395194e-03 1.8830201959309093e-04
     	 	 5.0946807252523651e-02 1.2120397346672182e-02 3.9034918278971182e-04
     	 	 5.4149083365393813e-02 2.9573707515983153e-02 6.0237850353548814e-04
     	 	 5.8986381701796375e-02 5.4255955191301615e-02 8.5884234117534065e-04
     	 	 5.0903383334805818e-02 8.6206683630285580e-02 9.8644782779967505e-04
     	 	 5.4912826845854190e-02 1.2402835999009330e-01 1.1364635082307276e-03
     	 	 5.2141515974600816e-02 1.6843443491057361e-01 1.3179366356874318e-03
     	 	 5.4587079773348979e-02 2.1777254073731905e-01 1.4626404418175618e-03
     	 	 5.3813541727988801e-02 2.7214385870344310e-01 1.5838828372844044e-03
     	 	 5.3058617359981741e-02 3.3007234058284468e-01 1.6390170784323064e-03
     	 	 5.2558335773048248e-02 3.9005017940728182e-01 1.6492227390728167e-03
     	 	 5.1971507458912658e-02 4.5054929770929097e-01 1.6223826720602632e-03
     	 	 5.0753979909974989e-02 5.1075845490116012e-01 1.5704502024999031e-03
     	 	 5.0126302957944069e-02 5.7025395811832247e-01 1.5744920675271046e-03
     	 	 5.1409374413935449e-02 6.2810242531864147e-01 1.5416036625983227e-03
     	 	 5.1921482930700869e-02 6.8430255682981089e-01 1.4785670678066319e-03
     	 	 5.1800967653626739e-02 7.3744694345887551e-01 1.3939323951756711e-03
     	 	 5.2816738513142170e-02 7.8513292498978060e-01 1.2479466356102988e-03
     	 	 4.8724607606381198e-02 8.3129813572371736e-01 1.0380603503692637e-03
     	 	 5.6339446674969595e-02 8.6156043097289536e-01 1.0000399216192446e-03
     	 	 5.4128425662576030e-02 8.9394511777532215e-01 7.6053770412717317e-04
     	 	 5.4838643771849993e-02 9.1695325163615693e-01 5.7511318650227145e-04
     	 	 5.2880726827852276e-02 9.3555414710033691e-01 3.7468601316580514e-04
     	 	 6.0134409454531634e-02 9.3767701073809351e-01 1.7485399107870257e-04
     	 	 3.3597697542473215e-02 2.3280406140222267e-03 1.4351581131373604e-04
     	 	 2.6495595659780768e-02 1.2273522006906136e-02 2.8187860565004823e-04
     	 	 2.9376261226294109e-02 2.9918135489822403e-02 4.5276992301403001e-04
     	 	 3.2208279248742699e-02 5.4996391747118595e-02 6.6132206642427103e-04
     	 	 2.6699669691404249e-02 8.7598235573293312e-02 7.2487358517890361e-04
     	 	 3.0350303942370149e-02 1.2629671386094785e-01 8.9488010779769039e-04
     	 	 2.7840986916575328e-02 1.7129763938421233e-01 9.7054331511492258e-04
     	 	 2.9892978556167571e-02 2.2067647645241109e-01 1.1002515944460085e-03
     	 	 2.9209933903211027e-02 2.7454189922270755e-01 1.1679429674966537e-03
     	 	 2.8838491002505240e-02 3.3184749302877464e-01 1.2166863994718417e-03
     	 	 2.8621050506384971e-02 3.9204877743524769e-01 1.2579620489424504e-03
     	 	 2.8327614003612500e-02 4.5436897369672091e-01 1.2756533943056681e-03
     	 	 2.7671134507030182e-02 5.1771364017498167e-01 1.2480694304477116e-03
     	 	 2.6977686574810145e-02 5.8061570689645259e-01 1.2115881301546290e-03
     	 	 2.7975185493492316e-02 6.4074756578810210e-01 1.1901778943299763e-03
     	 	 2.8362882502615538e-02 6.9832061014701441e-01 1.1329121459723456e-03
     	 	 2.7943993460260330e-02 7.5282554614842145e-01 1.0586606301918912e-03
     	 	 2.8882333527803561e-02 8.0207111330462511e-01 9.7180973936566257e-04
     	 	 2.6204655232504148e-02 8.4867136453017478e-01 8.0187580583336495e-04
     	 	 3.0414606731214433e-02 8.8398871684760649e-01 7.7257716398308654e-04
     	 	 2.9508381464695588e-02 9.1654368371473727e-01 5.9770399078286861e-04
     	 	 2.9947463145967079e-02 9.4082529816373339e-01 4.4739552145134994e-04
     	 	 2.8107122614992708e-02 9.5988921823324613e-01 2.8229328285396343e-04
     	 	 3.2756590749260406e-02 9.6497864614509177e-01 1.3626597008765785e-04
     	 	 1.3770466441649143e-02 2.3606507036895569e-03 9.4066772244457566e-05
     	 	 1.0248830098561812e-02 1.2443205013736428e-02 1.7150361143268998e-04
     	 	 1.2035085230957754e-02 3.0357688095941308e-02 2.9566406931632341e-04
     	 	 1.3225142387686795e-02 5.5808466523830341e-02 4.3423826954276526e-04
     	 	 1.0447305113297389e-02 8.8607835460587744e-02 4.4325644096353343e-04
     	 	 1.2576812241872903e-02 1.2771871076107472e-01 5.9685012941634321e-04
     	 	 1.1201760573053443e-02 1.7321695935554768e-01 6.1907321582241651e-04
     	 	 1.2304055462147523e-02 2.2389328087174126e-01 7.3711667717503340e-04
     	 	 1.1929512567342648e-02 2.7941133057881001e-01 7.7511704409655862e-04
     	 	 1.1801629301230299e-02 3.3851839004197709e-01 8.0599487978574099e-04
     	 	 1.1723361557244849e-02 4.0003515257918310e-01 8.2412653447873916e-04
     	 	 1.1599085771399786e-02 4.6282088681422884e-01 8.2510186046350369e-04
     	 	 1.1346966665448210e-02 5.2592646010605093e-01 8.0348264786106525e-04
     	 	 1.0957671148902559e-02 5.8849891907081409e-01 7.6985345727652093e-04
     	 	 1.1442718239845662e-02 6.4933415405072636e-01 7.7707661407034733e-04
     	 	 1.1680867076272805e-02 7.0783956298682948e-01 7.4838289694214276e-04
     	 	 1.1346449970318306e-02 7.6317030939601382e-01 6.8495030436312089e-04
     	 	 1.1903031897328442e-02 8.1357100034520535e-01 6.4544902271702160e-04
     	 	 1.0568908123743337e-02 8.6007680388296848e-01 5.1720354427456209e-04
     	 	 1.2420368780732716e-02 8.9831420844343490e-01 5.1060140343426664e-04
     	 	 1.2081984882010399e-02 9.3156630953168584e-01 4.0240103024010771e-04
     	 	 1.2343923369530496e-02 9.5708779380965725e-01 3.0435566061154487e-04
     	 	 1.1239245271803200e-02 9.7622387175942116e-01 1.8343921761514010e-04
     	 	 1.3414608278229601e-02 9.8421552525305711e-01 9.2074495387480711e-05
     	 	 2.6238209577481575e-03 2.3876411438322302e-03 4.1183470308740007e-05
     	 	 1.8430411548012726e-03 1.2540768999532215e-02 6.8050180072986633e-05
     	 	 2.2946901540565889e-03 3.0601468161636523e-02 1.2904480237625822e-04
     	 	 2.5210033454036163e-03 5.6285554753914495e-02 1.8986542127172632e-04
     	 	 1.9091753292130864e-03 8.9231793878311774e-02 1.8009890300079104e-04
     	 	 2.4116430811762513e-03 1.2874760617132275e-01 2.6336885060511216e-04
     	 	 2.1019196969727094e-03 1.7428783048339652e-01 2.6091454365626373e-04
     	 	 2.3521263101143886e-03 2.2490075227131850e-01 3.1895997767410065e-04
     	 	 2.2697965156830424e-03 2.7986014633514789e-01 3.3096240480549524e-04
     	 	 2.2481363296118495e-03 3.3836294691647528e-01 3.4604197958407635e-04
     	 	 2.2345889822089626e-03 3.9964526932338168e-01 3.5738647928512267e-04
     	 	 2.2109168053774386e-03 4.6279296792249436e-01 3.6125284930950586e-04
     	 	 2.1678335524304426e-03 5.2672975931481691e-01 3.5520257023088957e-04
     	 	 2.0784259101210845e-03 5.9032891751491268e-01 3.3629620660173836e-04
     	 	 2.1712554846379239e-03 6.5242355757240322e-01 3.4003309126593698e-04
     	 	 2.2353427127214109e-03 7.1197026835497623e-01 3.3194690402524427e-04
     	 	 2.1477929264959172e-03 7.6811309265997085e-01 2.9822494844090425e-04
     	 	 2.2747760463408540e-03 8.1974310080533042e-01 2.8670546405184876e-04
     	 	 1.9895881904048451e-03 8.6635191471336026e-01 2.2261888718026461e-04
     	 	 2.3649938126057979e-03 9.0638547798383640e-01 2.2462141922054843e-04
     	 	 2.2967412509509177e-03 9.4001708303244136e-01 1.7686772260762425e-04
     	 	 2.3636509222418889e-03 9.6623602463503766e-01 1.3598854322716093e-04
     	 	 2.1000622535671809e-03 9.8501268182543200e-01 7.8654225972850562e-05
     	 	 2.5543079486226583e-03 9.9499241923507109e-01 4.1196413812374697e-05
     	 	 ];


    case 48

        % SET: SLOBODKINS TAUSCH
        % CARDINALITY RULE  :    414
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 1.154e-15

        XYW=[
    	 	 9.8620956777378121e-01 1.1724002086978609e-02 6.9939624203265677e-05
     	 	 9.9549473828766610e-01 2.2388177010838201e-03 3.3351627227701208e-05
     	 	 9.8593874295530293e-01 2.1406595045377823e-03 7.4148848016229377e-05
     	 	 9.7771236144661977e-01 1.1364565891346268e-02 1.6073151978174253e-04
     	 	 9.6933827348055612e-01 2.8461463487690457e-02 1.1403941448142039e-04
     	 	 9.6872204751182656e-01 2.1223101011884522e-03 1.1359081469389980e-04
     	 	 9.6209181666613774e-01 1.1028733888558495e-02 2.4021577084051179e-04
     	 	 9.4569754771003223e-01 2.6546852473719722e-02 3.6770125805987263e-04
     	 	 9.6049837384974313e-01 2.8032502549647394e-02 2.6252867325758102e-04
     	 	 9.4575120850496663e-01 5.2109689272873731e-02 1.4842973266044392e-04
     	 	 9.4421548410135647e-01 2.1526154374797305e-03 1.5464816867115399e-04
     	 	 9.3877207982810296e-01 1.1321578632471054e-02 3.4003432912399999e-04
     	 	 9.2133190392912767e-01 2.7936095456907097e-02 5.3204467158208754e-04
     	 	 9.2364588001579628e-01 4.8450239134503331e-02 5.0777098153367351e-04
     	 	 9.3653234853579359e-01 5.2141965271911277e-02 3.5727722395058993e-04
     	 	 9.1537930992544769e-01 8.2408201847383164e-02 1.9017448452221715e-04
     	 	 9.1278558452820147e-01 2.2116566404644902e-03 1.9680503029477934e-04
     	 	 9.0882647483665169e-01 1.1577759700512348e-02 4.2953296609845307e-04
     	 	 8.9174728968772476e-01 2.8206362560756031e-02 6.5277888126584970e-04
     	 	 8.9628174267591953e-01 5.1920916597181926e-02 7.5690759400835468e-04
     	 	 8.6603435865224609e-01 8.2957966616661397e-02 8.9970978188504190e-04
     	 	 8.9527753130820720e-01 7.6762985397392791e-02 6.3206505644684493e-04
     	 	 9.0517955899058844e-01 8.3275302140324914e-02 4.4536217134069801e-04
     	 	 8.7864102643826747e-01 1.1920843670066290e-01 2.2087244326023469e-04
     	 	 8.7486060243325836e-01 2.1719768465436363e-03 2.2905034196414617e-04
     	 	 8.7295079707140211e-01 1.1452406574612313e-02 5.0285206508352053e-04
     	 	 8.5658902763234623e-01 2.7876577562973199e-02 7.6677683396742836e-04
     	 	 8.2941115948652933e-01 5.1002559418491383e-02 1.0439796220336637e-03
     	 	 8.6568016696042860e-01 5.1665837986134673e-02 9.1137597475758831e-04
     	 	 8.3812265161973931e-01 8.1572919711709935e-02 1.0674655343259464e-03
     	 	 8.2820827366284944e-01 1.2009989070546229e-01 1.0870254347570645e-03
     	 	 8.5978762112871487e-01 1.1229644734127686e-01 7.8430056096558424e-04
     	 	 8.6807390513945637e-01 1.2058792528651133e-01 5.1535456428405729e-04
     	 	 8.3550608417063410e-01 1.6232115660247615e-01 2.5683921399863416e-04
     	 	 8.3082556826029552e-01 2.0971007104664940e-03 2.5257033863450615e-04
     	 	 8.3154168022968955e-01 1.1096872107743131e-02 5.5797874458431889e-04
     	 	 8.1572572615474570e-01 2.7189589319359608e-02 8.7092005583524058e-04
     	 	 7.8890637552316090e-01 5.0080786737759876e-02 1.1311506311600147e-03
     	 	 8.0348761891203035e-01 8.0569116482491890e-02 1.2608120380509812e-03
     	 	 8.0026328532027569e-01 1.1735170477290151e-01 1.3188942194443719e-03
     	 	 7.8801114547900408e-01 1.6169987344817957e-01 1.1022708175338369e-03
     	 	 8.1805065761057161e-01 1.5428018657612022e-01 8.9138444165120145e-04
     	 	 8.2568646852816363e-01 1.6293567406486081e-01 5.6781630359314212e-04
     	 	 7.8138833449517842e-01 2.0848683166058723e-03 2.7660338739885127e-04
     	 	 7.8476382285454060e-01 1.0915017435523752e-02 6.0803757019907065e-04
     	 	 7.6925517890691231e-01 2.6565534520718810e-02 9.3796137317607973e-04
     	 	 7.4633675802433919e-01 4.8545645300374897e-02 1.1263319186932469e-03
     	 	 7.6228555250200780e-01 7.9602416665365536e-02 1.4744808636838992e-03
     	 	 7.2435092024744396e-01 1.1524407626164686e-01 1.6477264517755579e-03
     	 	 7.6534094707777389e-01 1.1538090236975530e-01 1.4657972562530544e-03
     	 	 7.3111773815817838e-01 1.5460793321925523e-01 1.5439563974052517e-03
     	 	 7.6117639570362317e-01 1.5956260836245678e-01 1.4386212615024817e-03
     	 	 7.4552349249205607e-01 2.0452450389471163e-01 1.1286026152484163e-03
     	 	 7.7021677824820944e-01 2.0275528295928585e-01 9.9686540181192595e-04
     	 	 7.7996906926782472e-01 2.0905865171077748e-01 5.9228274014762729e-04
     	 	 7.8665377352291610e-01 2.1125788433621664e-01 2.7635562176352212e-04
     	 	 7.2764548448729383e-01 2.0906193738361250e-03 2.9768122128878401e-04
     	 	 7.3278721393934854e-01 1.0973487023168804e-02 6.7215447427832679e-04
     	 	 7.1762608489368429e-01 2.6763946501341156e-02 1.0161432771727381e-03
     	 	 6.9965354742674568e-01 4.9131027211071834e-02 1.2057735412864088e-03
     	 	 7.1743874430184940e-01 7.6406191558184497e-02 1.5334704868480622e-03
     	 	 6.8740231507583183e-01 1.0833875644326804e-01 1.5131172497028038e-03
     	 	 6.8853880038069737e-01 1.5638203496644529e-01 1.9205933852931754e-03
     	 	 6.8847568657385605e-01 1.9664498287858972e-01 1.6519468244426045e-03
     	 	 7.1332340009819539e-01 2.0709402275902189e-01 1.6373953422568598e-03
     	 	 7.0198128516962810e-01 2.4762271253911680e-01 1.1566443270634890e-03
     	 	 7.1666742037967057e-01 2.5587722468805163e-01 1.0808051703036902e-03
     	 	 7.3047314554687293e-01 2.5821336967547903e-01 6.5115358320697167e-04
     	 	 7.3270571702884912e-01 2.6513907180513219e-01 3.0967491791629009e-04
     	 	 6.7076054092285964e-01 2.0820532828114682e-03 3.0960648928192420e-04
     	 	 6.7642146366925426e-01 1.0934685447631654e-02 7.1943263487352755e-04
     	 	 6.6337553102680402e-01 2.6683800697449019e-02 1.0595239564978013e-03
     	 	 6.5087196713411455e-01 4.9063676521939464e-02 1.2861325734017431e-03
     	 	 6.6334775162800297e-01 7.7550962662529505e-02 1.7211715994850595e-03
     	 	 6.3910904433331661e-01 1.1144491022497499e-01 1.6970422605299767e-03
     	 	 6.5225647633925621e-01 1.4456514600474629e-01 1.8293425877969622e-03
     	 	 6.2248836342730141e-01 1.8205394557678800e-01 1.6304018387187627e-03
     	 	 6.4188175207590237e-01 2.0406984316231397e-01 2.0447861483681279e-03
     	 	 6.4334414060831602e-01 2.4297128004060869e-01 1.8059594740174815e-03
     	 	 6.6088860591861742e-01 2.6006245260605021e-01 1.7459959275554148e-03
     	 	 6.5497049269656138e-01 2.9542413035458082e-01 1.3196215310054297e-03
     	 	 6.6030790985392551e-01 3.1280437915776244e-01 1.1207114190852423e-03
     	 	 6.7729482098077198e-01 3.1168959558708820e-01 6.9271374971726740e-04
     	 	 6.7492674632782657e-01 3.2298413368179429e-01 3.1793204576007270e-04
     	 	 6.1214872871985404e-01 2.0875761439718139e-03 3.1593691593249077e-04
     	 	 6.1656215539473402e-01 1.0954986082307879e-02 7.5720050057079594e-04
     	 	 6.0699449585375687e-01 2.6783935453052372e-02 1.0994324254124850e-03
     	 	 5.9955158409178200e-01 4.9274202023380960e-02 1.3322224953901134e-03
     	 	 6.0652927373223386e-01 7.7882105898599660e-02 1.8433139939766784e-03
     	 	 5.9013658952800119e-01 1.1235989800504871e-01 1.8667427184386380e-03
     	 	 5.9567905337810301e-01 1.5075000306857744e-01 2.1964350297716366e-03
     	 	 5.7563759673353188e-01 1.9237823757041295e-01 1.6933367907255286e-03
     	 	 5.7793528187630760e-01 2.2766142500064443e-01 2.0222406262294140e-03
     	 	 5.9151903146611651e-01 2.5651706485772774e-01 2.2035380591916925e-03
     	 	 5.9283866498344262e-01 2.9475935449133805e-01 1.9737674333919967e-03
     	 	 6.0522105978130658e-01 3.1691990422067873e-01 1.8335639786150497e-03
     	 	 6.0155248598396371e-01 3.4951100329077006e-01 1.4316487555387240e-03
     	 	 6.0175110069642235e-01 3.7171860452397143e-01 1.1260776823432380e-03
     	 	 6.1962242356860497e-01 3.6949655375401796e-01 7.3372883456507341e-04
     	 	 6.1464329458944644e-01 3.8328459183193420e-01 3.2402692710267094e-04
     	 	 5.5302150008087203e-01 2.1138250419982952e-03 3.2052277815424298e-04
     	 	 5.5441539273699814e-01 1.1078748633378646e-02 7.8467781315192818e-04
     	 	 5.4894540157272531e-01 2.7035044965458391e-02 1.1377610303765879e-03
     	 	 5.4745429830394265e-01 4.9721931333045040e-02 1.3515587662545623e-03
     	 	 5.4698800819929194e-01 7.8581816157183584e-02 1.9223648251376489e-03
     	 	 5.3764850263987363e-01 1.1327901949300150e-01 2.0138126152390860e-03
     	 	 5.3934179768545498e-01 1.5279521837923105e-01 2.3847285947197860e-03
     	 	 5.2986399086093083e-01 1.9628082326665020e-01 2.1889583949408690e-03
     	 	 5.2091736134020372e-01 2.4075733474740899e-01 2.2668445044574628e-03
     	 	 5.2823450104500824e-01 2.7766165839983548e-01 2.3032876901273340e-03
     	 	 5.3670533479473304e-01 3.1224349293580078e-01 2.3438350781390797e-03
     	 	 5.3843459901926893e-01 3.5004227633308821e-01 2.0714009002385848e-03
     	 	 5.4657236788919517e-01 3.7624954907164143e-01 1.8870958672779260e-03
     	 	 5.4459748875957503e-01 4.0676508942163198e-01 1.4676437069736830e-03
     	 	 5.4281560249677807e-01 4.3075225742559076e-01 1.1101640946914678e-03
     	 	 5.5833814028010043e-01 4.3083850200076845e-01 7.6470509372035815e-04
     	 	 5.5344126308741393e-01 4.4450104884623076e-01 3.2299096447848557e-04
     	 	 4.9388851399982314e-01 2.0590720129234248e-03 3.1262503418175294e-04
     	 	 4.9143661197615163e-01 1.0859226224226847e-02 7.7463404400167097e-04
     	 	 4.8940140076679717e-01 2.6602507247898786e-02 1.1580969936276502e-03
     	 	 4.9477992433018314e-01 4.9149365429536969e-02 1.3800660224112650e-03
     	 	 4.8627921067860769e-01 7.8149951158500541e-02 1.9570132484459692e-03
     	 	 4.8237918649912370e-01 1.1302772464518085e-01 2.1226123153677283e-03
     	 	 4.8140348425760726e-01 1.5319463332726821e-01 2.4796992878025888e-03
     	 	 4.7740423694403700e-01 1.9759057545918265e-01 2.5252402699567022e-03
     	 	 4.6797854933532612e-01 2.4507117631450023e-01 2.5364109511920156e-03
     	 	 4.6710801752471420e-01 2.9159627498675994e-01 2.5546601228918645e-03
     	 	 4.7450006757252794e-01 3.3074757240222785e-01 2.4987660777366244e-03
     	 	 4.7945394473901992e-01 3.6977818667005519e-01 2.4378108063925555e-03
     	 	 4.8189330360588356e-01 4.0691914318133604e-01 2.1138561303339224e-03
     	 	 4.8609615277829632e-01 4.3699615120587876e-01 1.9171386428254570e-03
     	 	 4.8686215284114687e-01 4.6465457585999315e-01 1.4556332128843061e-03
     	 	 4.8487974051603044e-01 4.8886491777600949e-01 1.0870050329170643e-03
     	 	 4.9519230040209417e-01 4.9405713232666243e-01 7.7113650719860328e-04
     	 	 4.9261317580591735e-01 5.0533969023295433e-01 3.1675893403771679e-04
     	 	 4.3465380578616586e-01 2.1178196519145306e-03 3.2166546033107827e-04
     	 	 4.2885224383287046e-01 1.1103638346588528e-02 7.7369756927096311e-04
     	 	 4.2862892047479884e-01 2.7027781760722503e-02 1.1744259249543748e-03
     	 	 4.4017267329718901e-01 4.9433637485614988e-02 1.4428370942712722e-03
     	 	 4.2507066491711121e-01 7.8431947805700175e-02 1.9501641293654369e-03
     	 	 4.2556759075839978e-01 1.1320616594453510e-01 2.1414913575184074e-03
     	 	 4.2281496184355638e-01 1.5338728075891331e-01 2.5007880947043692e-03
     	 	 4.2145042070098160e-01 1.9828195810350943e-01 2.6564853308065233e-03
     	 	 4.1428723091405606e-01 2.4687553558015657e-01 2.7072767493187488e-03
     	 	 4.1081961002417222e-01 2.9746578297609350e-01 2.7791782301969407e-03
     	 	 4.1220129573617859e-01 3.4552253735173055e-01 2.7077950567974867e-03
     	 	 4.1920058499485369e-01 3.8652729712132250e-01 2.5848612972932555e-03
     	 	 4.2103316300686222e-01 4.2894213832195860e-01 2.4656290748277421e-03
     	 	 4.2487576951148609e-01 4.6461371140322916e-01 2.0968462339870865e-03
     	 	 4.2489818541180002e-01 4.9871807957406972e-01 1.9229732178596953e-03
     	 	 4.3066361755923988e-01 5.2134685136594339e-01 1.3887160704879652e-03
     	 	 4.2733922093448362e-01 5.4656096722377745e-01 1.0789209998856410e-03
     	 	 4.3185353411033112e-01 5.5746703932453656e-01 7.5969792309170804e-04
     	 	 4.3281252467097941e-01 5.6515856460872627e-01 3.0867898988887535e-04
     	 	 3.7551593161587304e-01 2.1349921794493161e-03 3.2222534472358148e-04
     	 	 3.6801733048107199e-01 1.1225232916524023e-02 7.5550011101524245e-04
     	 	 3.6808279207906303e-01 2.7400441461363979e-02 1.1765606399073581e-03
     	 	 3.8277310122037056e-01 5.0134771586254609e-02 1.5152011959799082e-03
     	 	 3.6443527610406878e-01 7.9483029403625186e-02 1.9127652178887631e-03
     	 	 3.6866318049910773e-01 1.1409659200809186e-01 2.1218776960136728e-03
     	 	 3.6462153373758677e-01 1.5408203072702523e-01 2.4319473752088868e-03
     	 	 3.6471403701929017e-01 1.9862859459221310e-01 2.6468390685041028e-03
     	 	 3.5980162940374771e-01 2.4731292804231203e-01 2.7453950161240022e-03
     	 	 3.5621551963495879e-01 2.9900612011219058e-01 2.8543008006468740e-03
     	 	 3.5472213026267407e-01 3.5174617605448444e-01 2.8671400725714430e-03
     	 	 3.5753155525668223e-01 3.9994364789651893e-01 2.6884834505443399e-03
     	 	 3.6337450816849459e-01 4.4186580785745388e-01 2.5460353418562715e-03
     	 	 3.6238429428059715e-01 4.8625518230162584e-01 2.4007192327278248e-03
     	 	 3.6853775674229339e-01 5.1928873022221356e-01 2.0420890982299818e-03
     	 	 3.6358188056909180e-01 5.5791563170975011e-01 1.8994752583502989e-03
     	 	 3.7575025375258475e-01 5.7460668429899542e-01 1.4033971348398307e-03
     	 	 3.6979311035661211e-01 6.0294701375497328e-01 1.1122201499637549e-03
     	 	 3.6974734820819866e-01 6.1904969438209867e-01 7.6764771158650575e-04
     	 	 3.7390601329663198e-01 6.2395666743711542e-01 3.2013190543519788e-04
     	 	 3.1733171034564900e-01 2.1526623163611587e-03 3.1628033528578926e-04
     	 	 3.0992001531675850e-01 1.1308996555191393e-02 7.2065595038901678e-04
     	 	 3.0913569063240487e-01 2.7626067368565637e-02 1.1439747341408595e-03
     	 	 3.2443419423719555e-01 5.0738944074605982e-02 1.5336107415113548e-03
     	 	 3.0622030193956784e-01 8.0610047256716888e-02 1.8505455572128157e-03
     	 	 3.1215640203013761e-01 1.1593422251860619e-01 2.1270407369385156e-03
     	 	 3.0833919522471087e-01 1.5633082183147601e-01 2.3243122406332323e-03
     	 	 3.0858624704963544e-01 2.0055425790018649e-01 2.5475416898029686e-03
     	 	 3.0568274210552759e-01 2.4836200740140416e-01 2.6393535596086529e-03
     	 	 3.0261994127072744e-01 2.9923328789064318e-01 2.7592037086390827e-03
     	 	 3.0080469632727580e-01 3.5244803521731738e-01 2.8423634462335368e-03
     	 	 3.0045267859067770e-01 4.0535263732631643e-01 2.7078698738518111e-03
     	 	 3.0403975366610880e-01 4.5096556851129149e-01 2.4863469375877782e-03
     	 	 3.0779156517298534e-01 4.9365830900136848e-01 2.4711481437077365e-03
     	 	 3.0539785447262280e-01 5.3908150387615195e-01 2.3043514893339020e-03
     	 	 3.1252858733651312e-01 5.7210477975321128e-01 2.0925831263823680e-03
     	 	 3.0440114389444872e-01 6.1507087221936196e-01 1.8764778303150705e-03
     	 	 3.2056588177772283e-01 6.2875463895747785e-01 1.4538125006897217e-03
     	 	 3.1288156425850955e-01 6.5953685153525043e-01 1.1140335407973114e-03
     	 	 3.1047520477345558e-01 6.7823581626297325e-01 7.3373663355354548e-04
     	 	 3.1608845021569099e-01 6.8176451775488056e-01 3.1411570330933510e-04
     	 	 2.6133688433221047e-01 2.1607771433265637e-03 3.0193129561913683e-04
     	 	 2.5529730740701662e-01 1.1358264690991458e-02 6.7667965543337697e-04
     	 	 2.5311401038025538e-01 2.7765416373841043e-02 1.0788151085569940e-03
     	 	 2.6751296263645963e-01 5.1076421814945143e-02 1.4863131638619791e-03
     	 	 2.5188948019571533e-01 8.1119362458750413e-02 1.7277903304504330e-03
     	 	 2.5716903397957158e-01 1.1731285596718119e-01 2.0996622117785361e-03
     	 	 2.5508479816701379e-01 1.5911232155434246e-01 2.2790021048756841e-03
     	 	 2.5451422388650946e-01 2.0513500971730633e-01 2.4967824697604180e-03
     	 	 2.5294348364067443e-01 2.5388594741805204e-01 2.5400581641042380e-03
     	 	 2.5074646391356614e-01 3.0332041709458674e-01 2.4712864012684586e-03
     	 	 2.4929256445175663e-01 3.5215632474344616e-01 2.4559049364252707e-03
     	 	 2.4619370364338278e-01 4.0023354872924194e-01 2.1534522811474562e-03
     	 	 2.5984468425800167e-01 4.1087877522673871e-01 4.9787358427462762e-04
     	 	 2.4639476066453792e-01 4.5099978033748844e-01 2.3554668477041292e-03
     	 	 2.5285144570991991e-01 4.9327645416573596e-01 2.4416935543580534e-03
     	 	 2.5347282657020120e-01 5.4126259785359121e-01 2.5144443568614135e-03
     	 	 2.5219117778811861e-01 5.8837385536195685e-01 2.2578995020245615e-03
     	 	 2.5753589792726483e-01 6.2490401304135912e-01 2.1017992124529911e-03
     	 	 2.4886154759703971e-01 6.6975785904202301e-01 1.7796053142919786e-03
     	 	 2.6602054883698822e-01 6.8279686300779918e-01 1.4400023438703123e-03
     	 	 2.5784032726789263e-01 7.1433152143097567e-01 1.0696116853632367e-03
     	 	 2.5497341347581137e-01 7.3363041225465386e-01 6.8651323222244129e-04
     	 	 2.6019335559028489e-01 7.3763868777430686e-01 3.0314465886191873e-04
     	 	 2.0874938112482899e-01 2.1746133243236462e-03 2.8159325684510032e-04
     	 	 2.0456389801257469e-01 1.1409164398275681e-02 6.2585763842789525e-04
     	 	 2.0128231285116804e-01 2.7823335802935084e-02 9.8326152703788168e-04
     	 	 2.1362203826566850e-01 5.1159880097511656e-02 1.3854661288122889e-03
     	 	 2.0236263738550730e-01 8.0927369467170024e-02 1.5422923397108855e-03
     	 	 2.0533271977153877e-01 1.1684799396869032e-01 1.9336817440001759e-03
     	 	 2.0514348776884861e-01 1.5853983328362531e-01 2.1517373815412568e-03
     	 	 2.0412884373590845e-01 2.0586371892619154e-01 2.4031405562296559e-03
     	 	 2.0288596448270602e-01 2.5780860740152045e-01 2.6020031514908028e-03
     	 	 2.0181901274881653e-01 3.1329679186437975e-01 2.6667451791675756e-03
     	 	 1.9968933833560654e-01 3.7106231767759223e-01 2.7477486700288717e-03
     	 	 1.9869664705042556e-01 4.2974862797467894e-01 2.7095755708279891e-03
     	 	 1.9832041244014964e-01 4.8700806720436085e-01 2.6426594359573942e-03
     	 	 2.0397464938469378e-01 5.3815968067514197e-01 2.5125983142990078e-03
     	 	 2.0260297522293269e-01 5.9074700235256683e-01 2.4065362105014205e-03
     	 	 2.0288719290872692e-01 6.3773547803450081e-01 2.1220331445787246e-03
     	 	 2.0559454888384765e-01 6.7684914244963423e-01 1.9522021379314932e-03
     	 	 1.9782187297357090e-01 7.2078301646981269e-01 1.5990952021479276e-03
     	 	 2.1352172096716793e-01 7.3502757486491388e-01 1.3658625389952493e-03
     	 	 2.0625191118803521e-01 7.6573669431534885e-01 9.9081281184278287e-04
     	 	 2.0393248569576250e-01 7.8457918926745474e-01 6.3057910975939703e-04
     	 	 2.0746368995345166e-01 7.9034705096293079e-01 2.8468352286012031e-04
     	 	 1.6062622330627774e-01 2.1585670450130273e-03 2.5245289715866736e-04
     	 	 1.5817359314674662e-01 1.1329697423200804e-02 5.6361144509739416e-04
     	 	 1.5465208815940246e-01 2.7640591208155693e-02 8.6647778447061720e-04
     	 	 1.6404515885825377e-01 5.0826750406329772e-02 1.2373554613064231e-03
     	 	 1.5804841960224036e-01 7.9844845155818342e-02 1.3304432627390056e-03
     	 	 1.5792470509769108e-01 1.1378743930495144e-01 1.6000368459289475e-03
     	 	 1.5866533882118594e-01 1.5085717422176190e-01 1.6965090458765163e-03
     	 	 1.5873162692381471e-01 1.9027099987496240e-01 1.7854921038184886e-03
     	 	 1.5729696923426739e-01 2.3298364316770911e-01 1.9086140608419054e-03
     	 	 1.5646320604564046e-01 2.7609265681325657e-01 1.8752443245714746e-03
     	 	 1.5688814798144557e-01 3.2078633349157082e-01 2.0555588320127030e-03
     	 	 1.5455344082152522e-01 3.7243274751017441e-01 2.3317924100907843e-03
     	 	 1.5433289537028438e-01 4.2845068939613706e-01 2.4320781730026962e-03
     	 	 1.5336150236361723e-01 4.8661849226624060e-01 2.4659040274503234e-03
     	 	 1.5345919836480770e-01 5.4263023005569189e-01 2.2300082222261553e-03
     	 	 1.7073191922132813e-01 5.5436054194934703e-01 4.2009847883329581e-04
     	 	 1.5642770320266675e-01 5.9615611613562869e-01 2.1523454603018994e-03
     	 	 1.5678641465874210e-01 6.4396977338331685e-01 2.0036073815418456e-03
     	 	 1.5728156344766142e-01 6.8732181591810615e-01 1.8189398485006475e-03
     	 	 1.5797505229199116e-01 7.2615608271042353e-01 1.6878514010272485e-03
     	 	 1.5236961536700955e-01 7.6690210885650356e-01 1.3716029767006342e-03
     	 	 1.6458335968732540e-01 7.8409964471186289e-01 1.2431592856083805e-03
     	 	 1.5932912983063363e-01 8.1275205293626018e-01 8.8561813931996910e-04
     	 	 1.5768536168683756e-01 8.3088757241818012e-01 5.6516890201248164e-04
     	 	 1.5912270607236401e-01 8.3870025904890533e-01 2.5566208814623047e-04
     	 	 1.1777909457616176e-01 2.1393672349957113e-03 2.1922529717558053e-04
     	 	 1.1666275259608327e-01 1.1214351775167273e-02 4.9095331847019957e-04
     	 	 1.1387062475268794e-01 2.7325975391507388e-02 7.3970462589600613e-04
     	 	 1.1992779166372669e-01 5.0372565124532559e-02 1.0804116291845589e-03
     	 	 1.1810506866890069e-01 8.0037045480430502e-02 1.2482879519086292e-03
     	 	 1.1615003872371032e-01 1.1605759117730605e-01 1.5124952993476552e-03
     	 	 1.1682352968398058e-01 1.5757897075310626e-01 1.7259411517922482e-03
     	 	 1.1764506122791440e-01 2.0300962852672536e-01 1.7786300955163485e-03
     	 	 1.1517403973496709e-01 2.4917039699011970e-01 1.7401441731374158e-03
     	 	 1.1588985774463023e-01 2.9257928842162223e-01 1.6734670890334047e-03
     	 	 1.1563439769452721e-01 3.4008169228735430e-01 1.9782568326997766e-03
     	 	 1.1379570479835144e-01 3.9482897383781934e-01 2.1114376786057314e-03
     	 	 1.1456364985596212e-01 4.5047219033992597e-01 2.0849886567095911e-03
     	 	 1.1298311042528553e-01 5.0836930385022772e-01 2.1519865257498914e-03
     	 	 1.1387776295680019e-01 5.6505954649253964e-01 2.1320450256849788e-03
     	 	 1.1561113126256606e-01 6.1987098228553605e-01 2.1275502148683624e-03
     	 	 1.1579633401808620e-01 6.7346808276884962e-01 1.9812433088982049e-03
     	 	 1.1595289912631845e-01 7.2263217295145887e-01 1.8066642613570648e-03
     	 	 1.1579257778392582e-01 7.6644571146982576e-01 1.5881632541372940e-03
     	 	 1.1335942694637080e-01 8.0611771727359993e-01 1.2318285787491850e-03
     	 	 1.2048457323928263e-01 8.2929433748538706e-01 1.1049663434444463e-03
     	 	 1.1783008918096960e-01 8.5531171684360918e-01 7.5718936491562324e-04
     	 	 1.1638697441129242e-01 8.7275913871039601e-01 4.7834805303490911e-04
     	 	 1.1616451029931452e-01 8.8178156994768975e-01 2.1098185214021495e-04
     	 	 8.0874441304583100e-02 2.0910498491049094e-03 1.8118076723982129e-04
     	 	 8.0734020331177825e-02 1.1040229305180472e-02 4.1300007269425850e-04
     	 	 7.9065094096024358e-02 2.7187981567368475e-02 6.2884127873998974e-04
     	 	 8.2302818501035269e-02 5.0302156504885905e-02 9.0520804932903577e-04
     	 	 8.2482731588056080e-02 7.9928839620303685e-02 1.0836377517529968e-03
     	 	 8.0465579287418709e-02 1.1541912943286542e-01 1.2458980070886765e-03
     	 	 8.0311839234042837e-02 1.5645909803406233e-01 1.4636328760243890e-03
     	 	 8.2007379844761807e-02 2.0276315650775892e-01 1.6033372058171058e-03
     	 	 7.9447185939278575e-02 2.5437453731919718e-01 1.7713103060893868e-03
     	 	 8.0438973613360720e-02 3.1033061620532665e-01 1.8853611086311912e-03
     	 	 7.9609168854058554e-02 3.6952596149753225e-01 1.9587988466729799e-03
     	 	 7.8522528764245259e-02 4.3079130747091510e-01 1.9465746003347584e-03
     	 	 8.6940176943195890e-02 4.7600536748462186e-01 5.2511903711224329e-04
     	 	 7.6228767856283852e-02 4.9696486601067491e-01 1.6319418971120665e-03
     	 	 7.8729425458535895e-02 5.5417678513337387e-01 1.9157650628879109e-03
     	 	 7.9269026663651543e-02 6.1342286553894088e-01 1.8941891927624515e-03
     	 	 8.0240558146848606e-02 6.6910700267379530e-01 1.7821403825969662e-03
     	 	 8.0281732001065476e-02 7.2132582407582280e-01 1.6178635581756350e-03
     	 	 7.9969402251830468e-02 7.6804969353844454e-01 1.4271403378673146e-03
     	 	 7.9705630380786485e-02 8.0836457666429240e-01 1.2096111276089577e-03
     	 	 7.9534343984006162e-02 8.4243945876523385e-01 9.6060399792374047e-04
     	 	 8.2680564020707115e-02 8.6723271628880416e-01 8.7827905543933112e-04
     	 	 8.2290651445966256e-02 8.9003321451141515e-01 6.3421497350189815e-04
     	 	 8.0580127820939373e-02 9.0791241737136619e-01 4.2343158411591410e-04
     	 	 7.9388221610290244e-02 9.1840321065495201e-01 1.8932616755407285e-04
     	 	 5.0478485699688380e-02 2.2052893245771404e-03 1.5232701842022501e-04
     	 	 5.1016760067594813e-02 1.1508526755944680e-02 3.4143140284837955e-04
     	 	 5.0049466514931140e-02 2.7910004688207441e-02 5.1480278570071344e-04
     	 	 5.1650124657574681e-02 5.0934328353750946e-02 7.1605076051237972e-04
     	 	 5.2151487919912753e-02 8.0589246527353345e-02 8.9808064391115865e-04
     	 	 5.1032128489574835e-02 1.1678119923630254e-01 1.0301908032662442e-03
     	 	 5.0135277804465694e-02 1.5870467578455014e-01 1.1884668297145646e-03
     	 	 5.2290758860234710e-02 2.0484125239577589e-01 1.2827471636562878e-03
     	 	 4.9655542482523018e-02 2.5396156956031973e-01 1.3196356799045144e-03
     	 	 5.0915348187596687e-02 3.0477681013196184e-01 1.3687147587008496e-03
     	 	 5.0346512151458911e-02 3.5787568315198032e-01 1.4355170387646233e-03
     	 	 4.9870828978324955e-02 4.1388787247954828e-01 1.4880130556028772e-03
     	 	 4.9595964180947250e-02 4.7215943249862552e-01 1.5124148072976774e-03
     	 	 4.8582792887744142e-02 5.3090254499292311e-01 1.4486300313637983e-03
     	 	 5.0104939081241140e-02 5.8505385974240021e-01 1.3910947612016571e-03
     	 	 4.9768501688018274e-02 6.3772154497031375e-01 1.3454241801061362e-03
     	 	 5.0657355255456560e-02 6.8774880673782501e-01 1.3284840850766981e-03
     	 	 5.0758038759655677e-02 7.3745217231498916e-01 1.2941943226101162e-03
     	 	 5.0300336741355478e-02 7.8536143220126275e-01 1.2095259709919155e-03
     	 	 5.0103033247810735e-02 8.2881665535622306e-01 1.0702185376745728e-03
     	 	 5.0819290970915754e-02 8.6573453980999848e-01 8.9446972075819461e-04
     	 	 5.1411161510489745e-02 8.9633622425688875e-01 7.5632191070994031e-04
     	 	 5.2469503946747653e-02 9.1921344698116558e-01 5.4853419660608291e-04
     	 	 5.0773338777170718e-02 9.3768190098917148e-01 3.4809575474788207e-04
     	 	 4.9340130992531650e-02 9.4846960065594188e-01 1.4924522748363387e-04
     	 	 2.7051083903670947e-02 2.1854130335353795e-03 1.1126573694562451e-04
     	 	 2.7876641294093951e-02 1.1546081428035909e-02 2.5949386765181651e-04
     	 	 2.7216438646109897e-02 2.8384483414927459e-02 4.0200450118592335e-04
     	 	 2.8021875046674749e-02 5.2470579832533656e-02 5.5341085509428862e-04
     	 	 2.8284367333524463e-02 8.3044769431443052e-02 6.8290464924296768e-04
     	 	 2.7954540479587786e-02 1.1915504001307473e-01 7.6065242322441537e-04
     	 	 2.6820422694307400e-02 1.5984628331114606e-01 8.4526869387519779e-04
     	 	 2.8661209001250465e-02 2.0518814864699592e-01 9.7399984964801776e-04
     	 	 2.6784909295498038e-02 2.5552076859472472e-01 1.0202912945533377e-03
     	 	 2.7736665709206965e-02 3.0985346497613792e-01 1.1136711274655751e-03
     	 	 2.7269103640040648e-02 3.6751829259825375e-01 1.1519209169924404e-03
     	 	 2.7135218229021207e-02 4.2673923008943360e-01 1.1533788340534624e-03
     	 	 2.6954270475916586e-02 4.8607273358514613e-01 1.1412320013591624e-03
     	 	 2.6361761427676766e-02 5.4508121777566765e-01 1.1069724980515723e-03
     	 	 2.7294633492764730e-02 6.0251539073935001e-01 1.1237549130148836e-03
     	 	 2.6976374223079636e-02 6.5958554132479408e-01 1.0859699829802816e-03
     	 	 2.7606224078059793e-02 7.1360037038034396e-01 1.0497734258902503e-03
     	 	 2.7576008271005148e-02 7.6506675795656365e-01 9.7990483996922544e-04
     	 	 2.7170591698745916e-02 8.1274707400450696e-01 8.7972065701448661e-04
     	 	 2.7184813347744696e-02 8.5481486608900248e-01 7.6652137964887499e-04
     	 	 2.7956512622107965e-02 8.9035841487239709e-01 6.6008806289685534e-04
     	 	 2.7629504481772704e-02 9.2093058171585429e-01 5.4426366393807955e-04
     	 	 2.8755297302938243e-02 9.4342682122618349e-01 4.1067094144962450e-04
     	 	 2.7517556317706138e-02 9.6115453928645722e-01 2.5403404771580314e-04
     	 	 2.6371178816372964e-02 9.7147694708980226e-01 1.0686304186486055e-04
     	 	 1.0894491631877834e-02 2.1622154244819100e-03 6.9076698343275054e-05
     	 	 1.1514844677592673e-02 1.1292507104917441e-02 1.6329587672006754e-04
     	 	 1.1098135079559368e-02 2.7341311435096154e-02 2.4470834386490178e-04
     	 	 1.1456677396222026e-02 5.0242252394811011e-02 3.4007656855427926e-04
     	 	 1.1531323212451428e-02 7.9967878928348848e-02 4.3268043208240117e-04
     	 	 1.1569945923080471e-02 1.1634253102082319e-01 5.1297548303114171e-04
     	 	 1.0851958833170694e-02 1.5883100780966067e-01 5.6086943350323632e-04
     	 	 1.1766959671690391e-02 2.0647902632265294e-01 6.5975539294451876e-04
     	 	 1.0882243902771815e-02 2.5819597230702668e-01 6.5827807460211191e-04
     	 	 1.1397884243996015e-02 3.1275233771160255e-01 7.1842926198278023e-04
     	 	 1.1132733985726895e-02 3.7002172513529114e-01 7.3586852965982900e-04
     	 	 1.1134390004777450e-02 4.2953259278545525e-01 7.5990464994043713e-04
     	 	 1.1033476233743622e-02 4.9089853254308430e-01 7.7166335771672822e-04
     	 	 1.0788122129525846e-02 5.5305991930649345e-01 7.5491650386595765e-04
     	 	 1.1185255825033158e-02 6.1416399975071134e-01 7.6402347247264864e-04
     	 	 1.1020742744182299e-02 6.7372344285350982e-01 7.2458965951699222e-04
     	 	 1.1323200829452151e-02 7.2989881655555688e-01 6.9681822875465192e-04
     	 	 1.1285815213522232e-02 7.8229746869073868e-01 6.3727509986814834e-04
     	 	 1.1070001623716741e-02 8.2994115047045558e-01 5.6136670833411195e-04
     	 	 1.1131711096129537e-02 8.7180820617397359e-01 4.9021202062742638e-04
     	 	 1.1537540866105034e-02 9.0734448464385120e-01 4.2536517457518821e-04
     	 	 1.1180820787009549e-02 9.3733458315585538e-01 3.3671246413094616e-04
     	 	 1.1850263371896763e-02 9.5989773667614608e-01 2.6594663391839784e-04
     	 	 1.1270207682285704e-02 9.7703668611756489e-01 1.6661188517109077e-04
     	 	 1.0632168690257626e-02 9.8712445759746870e-01 6.9816666732176478e-05
     	 	 2.0442955255501882e-03 2.0405953553596762e-03 2.7650021208827559e-05
     	 	 2.2047794767117157e-03 1.0870411317616995e-02 7.0243214486982860e-05
     	 	 2.1086358178806774e-03 2.6958735419430335e-02 1.0677220346129030e-04
     	 	 2.1838532847775483e-03 5.0246632076011835e-02 1.4986319559816941e-04
     	 	 2.1885799311811560e-03 8.0337590541776721e-02 1.8719630754239589e-04
     	 	 2.2168579494578067e-03 1.1672652476595685e-01 2.2349451275708459e-04
     	 	 2.0438936615448933e-03 1.5894452144817270e-01 2.3646298793841559e-04
     	 	 2.2477557897628841e-03 2.0656479417419407e-01 2.8899627424049362e-04
     	 	 2.0651876440456185e-03 2.5910818520309808e-01 2.9032235364801775e-04
     	 	 2.1722010290875504e-03 3.1577110561723948e-01 3.2527342407662088e-04
     	 	 2.1156002190959589e-03 3.7553792343285053e-01 3.3033057377274090e-04
     	 	 2.1233821527903984e-03 4.3706552541783200e-01 3.3741210061800811e-04
     	 	 2.0968130325098588e-03 4.9913200603717123e-01 3.3305513700956479e-04
     	 	 2.0519359345400057e-03 5.6060291743351642e-01 3.2000434428482741e-04
     	 	 2.1359556003824887e-03 6.2049021585869679e-01 3.2308729714212780e-04
     	 	 2.0922924370637697e-03 6.7845929975895380e-01 3.0485079658652006e-04
     	 	 2.1555216386642817e-03 7.3384177769335002e-01 2.9810935546803333e-04
     	 	 2.1533340490724751e-03 7.8602737529983435e-01 2.7769470447232925e-04
     	 	 2.1053694471785400e-03 8.3422817702604524e-01 2.4789600084790546e-04
     	 	 2.1152940023081435e-03 8.7754834318990715e-01 2.2030886817628567e-04
     	 	 2.2018382818346227e-03 9.1504832937031200e-01 1.9415588666168724e-04
     	 	 2.1204458478470967e-03 9.4615831280038709e-01 1.5008686561191799e-04
     	 	 2.2609437858152059e-03 9.6997319010814043e-01 1.1757118979107903e-04
     	 	 2.1401143050603366e-03 9.8665538418954801e-01 7.0348603187366616e-05
     	 	 1.9986749637534995e-03 9.9589581449423381e-01 2.7866506036357302e-05
     	 	 ];


    case 49

        % SET: SLOBODKINS TAUSCH
        % CARDINALITY RULE  :    428
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 3.031e-15

        XYW=[
    	 	 9.9531767666086668e-01 2.2740485016308301e-03 3.5990358051363257e-05
     	 	 9.8611637531099172e-01 1.1927966364765813e-02 6.7765095114941326e-05
     	 	 9.8516526611066069e-01 2.1855427126932117e-03 8.0166807166872381e-05
     	 	 9.7786724950903514e-01 1.1611157533993634e-02 1.6031261486028919e-04
     	 	 9.6891510802701630e-01 2.9004943249587058e-02 1.1000069812873747e-04
     	 	 9.6701319565861077e-01 2.0572730457008937e-03 1.1710902790101945e-04
     	 	 9.6261578277178494e-01 1.0932480355067605e-02 2.4311479365633114e-04
     	 	 9.4707370292883553e-01 2.6740838523117691e-02 3.5941887031987598e-04
     	 	 9.6071007221641802e-01 2.8475284197467084e-02 2.4859701307407771e-04
     	 	 9.4477934013309461e-01 5.3151244670307109e-02 1.4630162037421600e-04
     	 	 9.4114907321604913e-01 1.9911226815218638e-03 1.5070107082240490e-04
     	 	 9.3967406636371953e-01 1.0472617254405068e-02 3.1914389185244468e-04
     	 	 9.2619943403412752e-01 2.5565666837181134e-02 4.6421999786449566e-04
     	 	 9.0481479900579509e-01 4.6918831554608978e-02 6.0279712785816294e-04
     	 	 9.2411932130393926e-01 4.9353732420091036e-02 4.8920142266353967e-04
     	 	 9.3648920592538831e-01 5.2608993423562130e-02 3.4094215113203468e-04
     	 	 9.1396072700448694e-01 8.3918732233887863e-02 1.8425731839121301e-04
     	 	 9.0829851271199913e-01 2.0489926227520148e-03 1.8892567459943678e-04
     	 	 9.0905320115081445e-01 1.0655863909776492e-02 4.0756158366390114e-04
     	 	 8.9722914473435134e-01 2.5989315158389557e-02 5.9102211535307569e-04
     	 	 8.4307398315753890e-01 7.5311467778232444e-02 9.9742600283717390e-04
     	 	 8.7612151277172345e-01 4.7857799243371447e-02 7.6890741356599763e-04
     	 	 8.7517426401539955e-01 7.4306190935124361e-02 8.2217447942925200e-04
     	 	 8.4456597744978112e-01 1.0879175325447013e-01 8.7920248335955761e-04
     	 	 8.9430772171159312e-01 7.8466910300545159e-02 6.4000826242745635e-04
     	 	 9.0526559238893833e-01 8.3623391304665659e-02 4.3067962166487393e-04
     	 	 8.7719999193932785e-01 1.2079474030988895e-01 2.0445644994173897e-04
     	 	 8.6932824052405877e-01 2.1123010578096009e-03 2.2621143997894003e-04
     	 	 8.7155440953664509e-01 1.1028945771259601e-02 5.0205179297645728e-04
     	 	 8.6193314600233462e-01 2.6775531195484526e-02 7.1503231194141334e-04
     	 	 8.4105746143405113e-01 4.8915954617573379e-02 9.3043638861668720e-04
     	 	 8.2558081440068110e-01 1.0266843669566757e-01 7.3609606932390056e-04
     	 	 8.5971250858845494e-01 1.1466783366670349e-01 7.0651975599756789e-04
     	 	 8.6827518112591306e-01 1.2123150970872948e-01 4.7901911568476734e-04
     	 	 8.3461990981624457e-01 1.6339129639682395e-01 2.3123886932178276e-04
     	 	 8.2492025816689418e-01 2.0877417175908675e-03 2.5114534217211723e-04
     	 	 8.2810461062978769e-01 1.1009163094894530e-02 5.7532781093368808e-04
     	 	 8.2135448452949933e-01 2.6885811351865522e-02 8.3446212201253572e-04
     	 	 8.0080355297551997e-01 4.9400796179043506e-02 1.0917876232131121e-03
     	 	 8.0379158905274528e-01 7.7257174323191527e-02 1.2521060685755732e-03
     	 	 7.8797195730352798e-01 1.0903544373084292e-01 1.1978828621501199e-03
     	 	 7.9489584903733979e-01 1.3115010862266369e-01 9.6001620254197392e-04
     	 	 8.0372839175725908e-01 1.4928482625596273e-01 1.0736770849991432e-03
     	 	 8.1846689230690950e-01 1.5603540060169763e-01 8.0245477158372277e-04
     	 	 8.2506942363541103e-01 1.6447049814358827e-01 5.4105520158197217e-04
     	 	 7.8668728863624238e-01 2.1126174494797151e-01 2.6463328926922913e-04
     	 	 7.7595653313608892e-01 2.0587972761687908e-03 2.6865428707674265e-04
     	 	 7.7938180261938172e-01 1.0851825007112867e-02 6.2986389070718123e-04
     	 	 7.7551329161983051e-01 2.6662424278603023e-02 9.3169981505116981e-04
     	 	 7.5602195035194875e-01 4.9149575155089699e-02 1.2228276259960585e-03
     	 	 7.5929908219854192e-01 7.8277477670076978e-02 1.4773950286765070e-03
     	 	 7.4633370911821006e-01 1.1226115043778165e-01 1.5581853095209034e-03
     	 	 7.4382041145250299e-01 1.4685197694177157e-01 1.5067769013003506e-03
     	 	 7.5589919166985564e-01 1.6805304035363022e-01 1.3343953209042729e-03
     	 	 7.5649178142231954e-01 1.9504899845642912e-01 1.2298375420861814e-03
     	 	 7.7167742530977379e-01 2.0198757037438680e-01 9.1835800989445340e-04
     	 	 7.7674416551026171e-01 2.1245040573469715e-01 6.1308855883726923e-04
     	 	 7.3419517195021289e-01 2.6371550855534626e-01 2.9192611220176358e-04
     	 	 7.2358349621805473e-01 2.0365982285208617e-03 2.8054418421227334e-04
     	 	 7.2599310000878292e-01 1.0702403003170194e-02 6.6980169294596995e-04
     	 	 7.2521860950228123e-01 2.6164262458624903e-02 9.8926307514554711e-04
     	 	 7.0674349064254427e-01 4.8173237185876627e-02 1.3240567687456102e-03
     	 	 7.1115576433470018e-01 7.7225669446704073e-02 1.6003694640686760e-03
     	 	 7.0031748822003936e-01 1.1069900384805592e-01 1.6101201015359615e-03
     	 	 6.9586864031250595e-01 1.3112063017286857e-01 5.5995055476462446e-04
     	 	 6.9633677672195660e-01 1.5529833580823846e-01 1.7573115655875628e-03
     	 	 6.9871927816976420e-01 1.9061633584857043e-01 1.6976350378205393e-03
     	 	 7.0804776372309552e-01 2.1466935829559847e-01 1.5670900859397279e-03
     	 	 7.0526718438919356e-01 2.4570551261243243e-01 1.3473356715167453e-03
     	 	 7.2063149918350800e-01 2.5266981565646984e-01 1.0103917981477419e-03
     	 	 7.2462701446837330e-01 2.6441866521105051e-01 6.6231440581315543e-04
     	 	 6.7789406651167305e-01 3.2004149316092079e-01 3.0712317170397219e-04
     	 	 6.6878431688996476e-01 2.0486318259618263e-03 2.9311736528145343e-04
     	 	 6.6897117437358633e-01 1.0747516742362477e-02 7.0873461883735553e-04
     	 	 6.7059592331833739e-01 2.6226375483771384e-02 1.0616630488091349e-03
     	 	 6.5235077495785410e-01 4.8219421743858397e-02 1.3986176785644618e-03
     	 	 6.5935930914791507e-01 7.6159565505063961e-02 1.6994030146681403e-03
     	 	 6.0045423480076310e-01 1.0741397895616100e-01 1.6347111548615895e-03
     	 	 6.5011045231539533e-01 1.1094056015237390e-01 1.9351481811463395e-03
     	 	 6.4140505836765349e-01 1.4784437517738469e-01 1.4668312939631893e-03
     	 	 6.4977379541978664e-01 1.6293616368858882e-01 1.1996303973163939e-03
     	 	 6.4916505033154404e-01 2.0200203848018547e-01 1.9320028646427120e-03
     	 	 6.4811611448094508e-01 2.4032641427522086e-01 1.9089386523266948e-03
     	 	 6.5538763863158866e-01 2.6710859578863727e-01 1.7142843856736254e-03
     	 	 6.5074994535696451e-01 3.0041173742152233e-01 1.4344024642701150e-03
     	 	 6.6601364517927353e-01 3.0744242356658669e-01 1.0735456142451239e-03
     	 	 6.6977409049356318e-01 3.1938357078772001e-01 6.8667386528532609e-04
     	 	 6.1205269431553466e-01 2.0389742651961834e-03 3.0139729258043190e-04
     	 	 6.0951655229424007e-01 1.0713026130657735e-02 7.2907974501964970e-04
     	 	 6.1244351936348929e-01 2.6193873140448614e-02 1.1213926480786599e-03
     	 	 5.9594215365741632e-01 4.8165750874854273e-02 1.4290032989528669e-03
     	 	 6.0240503636663512e-01 7.6203405178442180e-02 1.7752387527535582e-03
     	 	 5.7741860626011776e-01 1.2573542351759226e-01 7.9288851275514808e-04
     	 	 5.9264131636313366e-01 1.5123206961904465e-01 2.1569334610911047e-03
     	 	 5.7662320842202597e-01 1.9400766876658240e-01 2.0193233920095797e-03
     	 	 6.0940555712266575e-01 2.0199997051153751e-01 1.7386904588200672e-03
     	 	 5.9584186575156450e-01 2.5322499305928875e-01 2.2163760299051560e-03
     	 	 5.9402330141727222e-01 2.9439431380655845e-01 2.0644389904817604e-03
     	 	 5.9960759506101136e-01 3.2331665779782970e-01 1.8088833181465818e-03
     	 	 5.9346731089995486e-01 3.5817765751367803e-01 1.4899799764925121e-03
     	 	 6.0854285480164017e-01 3.6524086912148690e-01 1.1101264267363868e-03
     	 	 6.1303695939587488e-01 3.7625318280194781e-01 6.9505693193914651e-04
     	 	 6.1850227035905614e-01 3.7945887743851664e-01 3.1712935662544720e-04
     	 	 5.5357986561991179e-01 2.0140328882676337e-03 3.0624288978593631e-04
     	 	 5.4897272844755096e-01 1.0587577600466476e-02 7.2701370367865559e-04
     	 	 5.5168484670486029e-01 2.5971625595017537e-02 1.1545986770793919e-03
     	 	 5.3906759454592201e-01 4.7859542470706784e-02 1.4329189783871389e-03
     	 	 5.4421598550257011e-01 7.6170057450929946e-02 1.8165304680604741e-03
     	 	 5.3982932788077698e-01 1.0979724295630774e-01 2.1344446166241026e-03
     	 	 5.3359641256951340e-01 1.5365803484696144e-01 2.3040012976115291e-03
     	 	 5.2964391711314107e-01 1.9489293294072096e-01 2.1586886475217682e-03
     	 	 5.1543507853724857e-01 2.4186002493848166e-01 2.4992614006856227e-03
     	 	 5.5818804473979078e-01 2.4672636170736156e-01 2.1987728922187016e-03
     	 	 5.0896822627685845e-01 2.9600412111809471e-01 2.3424120538687791e-03
     	 	 5.4133044372156647e-01 3.0763929228319986e-01 2.3307327215402011e-03
     	 	 5.3748034143984236e-01 3.5152272036126286e-01 2.1489173962029279e-03
     	 	 5.4168269325380114e-01 3.8177554819097087e-01 1.8505528835645361e-03
     	 	 5.3417136921703667e-01 4.1765106016696740e-01 1.5057286886465333e-03
     	 	 5.4880487510928089e-01 4.2500957303432313e-01 1.1362911845638922e-03
     	 	 5.5517220708529202e-01 4.3410397133768952e-01 7.0547319897806165e-04
     	 	 5.5695829725726620e-01 4.4100045366922341e-01 3.2584979787796033e-04
     	 	 4.9370554019249402e-01 1.9967887672490909e-03 3.0872639702463620e-04
     	 	 4.8856893839880411e-01 1.0451184733713195e-02 7.0581705159239883e-04
     	 	 4.8965233715151368e-01 2.5478274032786234e-02 1.1364841944189481e-03
     	 	 4.8191709545568218e-01 4.6751521961853795e-02 1.4128055801802698e-03
     	 	 4.8664127944224222e-01 7.4536292070483151e-02 1.7376769250403710e-03
     	 	 4.7976606840249314e-01 1.0768118846640791e-01 2.1632179116148793e-03
     	 	 4.8592455645832078e-01 1.4431038851473274e-01 2.0965280742454135e-03
     	 	 4.5670398519751798e-01 1.8093530249730147e-01 1.8589555163894768e-03
     	 	 4.8040327852400322e-01 2.0041204684247949e-01 2.0195171817888641e-03
     	 	 4.6046219705949898e-01 2.4675519784697841e-01 2.6420998790191758e-03
     	 	 4.6258702379334760e-01 2.9486769084240527e-01 2.6827081802350233e-03
     	 	 4.5666858365475971e-01 3.4907720432209988e-01 2.5243381576277838e-03
     	 	 4.8596914388794210e-01 3.6398685652096091e-01 2.3603134196718257e-03
     	 	 4.3032971246058149e-01 4.2052525174518840e-01 2.3276063230065949e-03
     	 	 4.7929958898612945e-01 4.1052865441414255e-01 2.1701997832755042e-03
     	 	 4.8245433660999415e-01 4.4132313836521075e-01 1.8467886104881869e-03
     	 	 4.7431037334742576e-01 4.7762816219720133e-01 1.5041225806733897e-03
     	 	 4.8796100001069087e-01 4.8594765145653562e-01 1.1448646362644012e-03
     	 	 4.9651647335849336e-01 4.9281214166488668e-01 7.1221445126848598e-04
     	 	 4.9440871265281294e-01 5.0355920355054595e-01 3.2641205355988476e-04
     	 	 4.3331561420645381e-01 1.9496776865261622e-03 3.0162349831300262e-04
     	 	 4.2925591679847164e-01 1.0286399239235239e-02 6.8628586627698235e-04
     	 	 4.2749159791374980e-01 2.5290059069998188e-02 1.1278807996648529e-03
     	 	 4.2360335230848845e-01 4.6701916068071385e-02 1.4297062623038746e-03
     	 	 4.3110088271979141e-01 7.3732647694282116e-02 1.6487896340533820e-03
     	 	 4.1912484023261676e-01 1.0679383051507377e-01 2.1797487401008196e-03
     	 	 4.2705936350051110e-01 1.4552041265705451e-01 2.3921250360638730e-03
     	 	 4.0108228382987299e-01 1.9008856387991055e-01 2.4093292883123891e-03
     	 	 4.1492642969101057e-01 2.2803091709013559e-01 2.3568354999849821e-03
     	 	 4.0015297909632719e-01 2.6582266798031584e-01 1.6440371330814121e-03
     	 	 4.0797538673556588e-01 3.0086985830713847e-01 2.5801614383825023e-03
     	 	 4.0710410392776697e-01 3.5116387401233018e-01 2.8051471077660756e-03
     	 	 4.0201278935187557e-01 4.0534529686614046e-01 2.5712810030257614e-03
     	 	 4.1995630717887533e-01 4.6967519421959586e-01 2.1620056059485221e-03
     	 	 4.2334643580386178e-01 5.0017076710477693e-01 1.8301415246328640e-03
     	 	 4.1474964855575003e-01 5.3689868893543624e-01 1.4886131817654121e-03
     	 	 4.2702451550457199e-01 5.4672074350752364e-01 1.1378413194347058e-03
     	 	 4.3705492132532342e-01 5.5220203872940776e-01 7.2444704749469505e-04
     	 	 4.3212783137173383e-01 5.6582463418947204e-01 3.2396174953364934e-04
     	 	 3.7365427689596820e-01 2.0792078696578739e-03 3.1301611385559444e-04
     	 	 3.7086219334726311e-01 1.0895988463835082e-02 7.0652444590995581e-04
     	 	 3.6647266507305454e-01 2.6441403377720756e-02 1.1218734953723671e-03
     	 	 3.6529686030538500e-01 4.8335915037894923e-02 1.4436460749197898e-03
     	 	 3.7592445100846228e-01 7.5803634502863509e-02 1.6891930503529920e-03
     	 	 3.5699805248974059e-01 1.0879726621278740e-01 2.0967950822664313e-03
     	 	 3.7089421992111848e-01 1.4266461831280228e-01 1.9561392592851545e-03
     	 	 3.5707978524422623e-01 1.7320928360162391e-01 1.5624743403322441e-03
     	 	 3.4356832416912297e-01 2.0675082528220895e-01 1.8308042527999714e-03
     	 	 3.5357085759837659e-01 2.4395689176548521e-01 2.6970878095292144e-03
     	 	 3.5279834211998673e-01 2.9362073198830202e-01 2.4064480611304690e-03
     	 	 3.2249567147593816e-01 3.2641993899004207e-01 1.1807608972375283e-03
     	 	 3.5463092086531012e-01 3.4669868806154203e-01 2.6314314615284288e-03
     	 	 3.4510818133604126e-01 3.8758590542612614e-01 1.2403341504945164e-03
     	 	 3.5373930677534249e-01 4.1038416561797797e-01 2.2577657889467080e-03
     	 	 3.4465352448429976e-01 4.6250566202589566e-01 2.4959921829721060e-03
     	 	 3.7349733010950936e-01 4.7661341987345135e-01 2.3488734359974638e-03
     	 	 3.6137494884445731e-01 5.2785307809201509e-01 2.1234082244224383e-03
     	 	 3.6496816506057317e-01 5.5834077973176910e-01 1.8090685037533559e-03
     	 	 3.5648586698209361e-01 5.9528423607214753e-01 1.4518948323580111e-03
     	 	 3.6763785702871876e-01 6.0613164013364962e-01 1.0946504722173162e-03
     	 	 3.7730157210400683e-01 6.1195468893290028e-01 7.2300394775777206e-04
     	 	 3.7141475200214058e-01 6.2654294016948553e-01 3.1176796243168823e-04
     	 	 3.1617611692145153e-01 2.0204460965435114e-03 2.9072817702684113e-04
     	 	 3.1397403183678096e-01 1.0622266737815963e-02 6.7491333655421188e-04
     	 	 3.0841931388522792e-01 2.6015781401447374e-02 1.0578788583519808e-03
     	 	 3.0773656258984583e-01 4.8027667050329105e-02 1.4302661228002959e-03
     	 	 3.1991159844200234e-01 7.6174175360725585e-02 1.7199150168191952e-03
     	 	 2.9860672174057845e-01 1.0996025144249043e-01 2.0594234635596563e-03
     	 	 3.1097298862276945e-01 1.4815481309495318e-01 2.3452821233838311e-03
     	 	 2.9979225010053656e-01 1.9208930713768962e-01 2.2738939257766007e-03
     	 	 2.9244288748385439e-01 2.4223175408325295e-01 2.6451748395849360e-03
     	 	 3.0070809383959463e-01 2.8734326726264470e-01 2.5648742300252488e-03
     	 	 2.9569616336797655e-01 3.6450751257055974e-01 2.1806093917579620e-03
     	 	 2.9679361528987636e-01 4.1054140734977268e-01 2.6420512565155318e-03
     	 	 2.9713835959609813e-01 4.6176852019014009e-01 2.7237727032238747e-03
     	 	 2.9041360035052977e-01 5.1678710719313403e-01 2.4528214039675296e-03
     	 	 3.1725961804096248e-01 5.3368238738001683e-01 2.3006231940922136e-03
     	 	 2.6431489411941633e-01 5.8829836647659617e-01 2.1371769721238248e-03
     	 	 3.0456803997039050e-01 5.8630971829150691e-01 2.0583406853692341e-03
     	 	 3.0841389525838081e-01 6.1632163322055245e-01 1.7135480690897069e-03
     	 	 3.0000484975554709e-01 6.5292613224782492e-01 1.3744692256478193e-03
     	 	 3.1119035360823133e-01 6.6318205093045934e-01 1.0130286868441003e-03
     	 	 3.1839059096796074e-01 6.7109714473510473e-01 6.8980927136417440e-04
     	 	 3.1347201155212845e-01 6.8453451453739489e-01 2.8730150306588572e-04
     	 	 2.6170284652348752e-01 2.0238689060589764e-03 2.7393357564413492e-04
     	 	 2.5893392410698368e-01 1.0643348115493547e-02 6.4599526088839521e-04
     	 	 2.5394224096313267e-01 2.6039869476157777e-02 9.8170598109117947e-04
     	 	 2.5229422683941605e-01 4.8006493192768805e-02 1.3562528225617423e-03
     	 	 2.6501516041014062e-01 7.6268910426890810e-02 1.6864945085154491e-03
     	 	 2.4361676949090549e-01 1.1027744773739903e-01 1.9326253721026507e-03
     	 	 2.5483805742543442e-01 1.4860839652865013e-01 2.1599142545449079e-03
     	 	 2.5250968222653369e-01 1.8712682278591927e-01 1.7388797469462772e-03
     	 	 2.4744017135834717e-01 2.2067798540248632e-01 1.5130849617727945e-03
     	 	 2.3865371294172344e-01 2.5461686391360855e-01 1.9297063720806651e-03
     	 	 2.4492104254883840e-01 2.9879886763511448e-01 2.6760658038424054e-03
     	 	 2.7824273785162879e-01 3.3405278723259602e-01 1.7283073700382660e-03
     	 	 2.3733841781293352e-01 3.5656455754793293e-01 2.4026648414950933e-03
     	 	 2.4453984757355096e-01 4.0749382532171396e-01 2.7983760427096344e-03
     	 	 2.4590616313648939e-01 4.6242553623273802e-01 2.7052498870609211e-03
     	 	 2.4423849244928075e-01 5.1612810802459574e-01 2.5744451057438905e-03
     	 	 2.3944445627083932e-01 5.6997424057542212e-01 2.2972744733564922e-03
     	 	 2.1701964884811420e-01 6.3677643554064811e-01 1.6632642658858628e-03
     	 	 2.4990228647911350e-01 6.4220796426795734e-01 1.9424318681736850e-03
     	 	 2.5486462582744840e-01 6.7094247494641301e-01 1.6023156918795990e-03
     	 	 2.4612659776864554e-01 7.0752352169355637e-01 1.2875432768896969e-03
     	 	 2.5765267075607068e-01 7.1740289420197179e-01 9.5011808312738064e-04
     	 	 2.6170844311616681e-01 7.2816522262490502e-01 6.3468669976207129e-04
     	 	 2.5933245419159945e-01 7.3875587948538279e-01 2.5543850422715285e-04
     	 	 2.1077318537450496e-01 2.0467752167330658e-03 2.5718902930375691e-04
     	 	 2.0700967340166176e-01 1.0736269961127897e-02 6.0423390804582020e-04
     	 	 2.0357928294465544e-01 2.6195294590271968e-02 9.0456313983395121e-04
     	 	 2.0044680027158923e-01 4.8140067597446323e-02 1.2424890425411241e-03
     	 	 2.1246696520454822e-01 7.6234930652728961e-02 1.5857271364401952e-03
     	 	 1.9335163374172781e-01 1.1022539727190465e-01 1.7574669397946909e-03
     	 	 2.0241975777677479e-01 1.4989180963802901e-01 2.1210051609846813e-03
     	 	 2.0454268052101021e-01 1.9448292610164061e-01 2.1801269808265637e-03
     	 	 1.9444382865634702e-01 2.4284070209176351e-01 2.2682645543150365e-03
     	 	 1.9269346386921349e-01 2.9516499003726621e-01 2.4421599813781031e-03
     	 	 1.9961486793162075e-01 3.3974082566820013e-01 1.4720937204138677e-03
     	 	 1.9452533962709884e-01 4.0833621673310622e-01 2.5750671039551751e-03
     	 	 1.9541280737270661e-01 4.6337303422520426e-01 2.4734568070860752e-03
     	 	 2.1438310937104277e-01 4.5999082799528385e-01 2.3619691876873038e-04
     	 	 1.9633206124828406e-01 5.1829137052476892e-01 2.5251375847072438e-03
     	 	 1.9562772552307184e-01 5.7087899585418378e-01 2.3019383001722880e-03
     	 	 1.9127257531147934e-01 6.2295146415941260e-01 2.0917425011316481e-03
     	 	 1.9192223674382036e-01 6.7187531856689675e-01 8.6394116789455559e-04
     	 	 1.9929764934012828e-01 6.9618180256842110e-01 1.6453496947856769e-03
     	 	 2.0480439219446134e-01 7.2204949609341573e-01 1.4029160269342924e-03
     	 	 1.9533450488789261e-01 7.5750553982834867e-01 1.1389335869435979e-03
     	 	 2.0662287086815490e-01 7.6740748397477754e-01 8.9605094338731056e-04
     	 	 2.0858781151188943e-01 7.8065522506398610e-01 6.1121695711009933e-04
     	 	 2.0940883330679028e-01 7.8851568882005152e-01 2.5439824384062968e-04
     	 	 1.6382509636048825e-01 2.0311142421265893e-03 2.3335063487272799e-04
     	 	 1.5949721791101934e-01 1.0670426373578217e-02 5.4266062543393114e-04
     	 	 1.5752897907385222e-01 2.6091712380750871e-02 8.2206724283005381e-04
     	 	 1.5360182483523399e-01 4.8079702012466571e-02 1.1079986799609404e-03
     	 	 1.6357521059541946e-01 7.6280385442444060e-02 1.4476332439563181e-03
     	 	 1.4860345558627652e-01 1.0999664230577172e-01 1.5067400704899749e-03
     	 	 1.5470754943659670e-01 1.4887096399043057e-01 1.8670548876718992e-03
     	 	 1.5903126425106817e-01 1.9312071377264564e-01 2.0490396416802292e-03
     	 	 1.5186873132670331e-01 2.4160302660521149e-01 2.0378586500549253e-03
     	 	 1.4883338565329685e-01 2.9332802048688089e-01 2.2197885884371023e-03
     	 	 1.4903429946322511e-01 3.4775995223675726e-01 2.3415575846737697e-03
     	 	 1.8740243012394853e-01 3.5992837704044472e-01 1.3663472453652745e-03
     	 	 1.5017242579391965e-01 4.0462801088336575e-01 2.3239669382923082e-03
     	 	 1.5089222555966264e-01 4.6089923093040752e-01 2.3657664498964981e-03
     	 	 1.5175771895343371e-01 5.1574896708912432e-01 2.2978877326772056e-03
     	 	 1.5154701493039191e-01 5.6811945917491002e-01 2.1091087415606885e-03
     	 	 1.5195616636732723e-01 6.1503168022189425e-01 1.8535705806757658e-03
     	 	 1.4639599576105000e-01 6.6224632029760677e-01 1.7459204373488529e-03
     	 	 1.5881452162826137e-01 6.9164895944833293e-01 1.6892259926126847e-03
     	 	 1.5238301265103871e-01 7.3711552174312722e-01 1.5860206590589657e-03
     	 	 1.5742912550946941e-01 7.6644653796199513e-01 1.4151927233589379e-03
     	 	 1.5100394436073195e-01 8.0120003711233367e-01 1.0551393729664449e-03
     	 	 1.5958514713320360e-01 8.1477744402928609e-01 8.3897601186539122e-04
     	 	 1.6034843145300959e-01 8.2927139971858788e-01 5.3985096351695505e-04
     	 	 1.6342456763210877e-01 8.3462220120928232e-01 2.2131050079870470e-04
     	 	 1.2141707505784416e-01 2.0369249546454801e-03 2.0831397465351345e-04
     	 	 1.1725075997895429e-01 1.0700248926219338e-02 4.7553541984278968e-04
     	 	 1.1612490964634503e-01 2.6121251343575572e-02 7.2674033462889677e-04
     	 	 1.1257895264736550e-01 4.7984287251965761e-02 9.4640943336527438e-04
     	 	 1.1981256322062628e-01 7.5957249085318479e-02 1.2575122224736952e-03
     	 	 1.1055029971525765e-01 1.0895717613392347e-01 1.2350487008405604e-03
     	 	 1.1207528494455632e-01 1.4632767516927522e-01 1.5252291569319617e-03
     	 	 1.1746536534764007e-01 1.8574066273692846e-01 1.5352101726967434e-03
     	 	 1.1512616279003041e-01 2.2450552729825266e-01 1.4838634713433027e-03
     	 	 1.1100578743859602e-01 2.6791856855822915e-01 1.6843805219990463e-03
     	 	 1.0919492205630543e-01 3.1589559574424886e-01 1.8001813831891723e-03
     	 	 1.0984802637339408e-01 3.6566005271237184e-01 1.8764224997123273e-03
     	 	 1.1136238004908872e-01 4.1777590322709418e-01 2.0021691439075675e-03
     	 	 1.1137652228656514e-01 4.7353749390410554e-01 2.0802281828448343e-03
     	 	 1.1158224976766784e-01 5.3018378969745106e-01 2.1227310107319966e-03
     	 	 1.1193664234232759e-01 5.8583943967808094e-01 2.0460484031756118e-03
     	 	 1.1225211434994409e-01 6.4000649659508635e-01 1.9757066598718809e-03
     	 	 1.0793439055602061e-01 6.9446487436003568e-01 1.7651474273330135e-03
     	 	 1.1742565914052150e-01 7.3195300886585724e-01 1.6841253316945747e-03
     	 	 1.1262836873270499e-01 7.7660240093101318e-01 1.3615066804623321e-03
     	 	 1.1492846107620036e-01 8.0852981559817394e-01 1.2471699538727328e-03
     	 	 1.1250387120548744e-01 8.3917524833957990e-01 8.8559259420156896e-04
     	 	 1.1715166010288725e-01 8.5652557683898067e-01 7.4590798095277905e-04
     	 	 1.1759712958685475e-01 8.7157108422736773e-01 4.8350367951558934e-04
     	 	 1.2149682031214704e-01 8.7643998599840700e-01 2.0933070874594540e-04
     	 	 8.4340051991292242e-02 2.0372162030954984e-03 1.7829882465446800e-04
     	 	 8.0932614149546667e-02 1.0669894729166490e-02 3.9910963711042798e-04
     	 	 8.0114904863576863e-02 2.5996509423733889e-02 6.1443702450689642e-04
     	 	 7.7826532024056649e-02 4.7702534609989224e-02 7.8310091157757775e-04
     	 	 8.2132307607978516e-02 7.5425494190053011e-02 1.0471034999109262e-03
     	 	 7.8139993103622185e-02 1.0866178897126540e-01 1.0866831310344907e-03
     	 	 7.6399804433650909e-02 1.4707267840639027e-01 1.3087719872442577e-03
     	 	 8.1101052403593443e-02 1.8915978206368836e-01 1.4748242267204690e-03
     	 	 7.9693199172423568e-02 2.3592523286640607e-01 1.5705793123934944e-03
     	 	 7.6145086183736499e-02 2.8751607121266692e-01 1.6448805203396284e-03
     	 	 7.5322599727610018e-02 3.4130311692803966e-01 1.6859370616975589e-03
     	 	 7.6360382904265167e-02 3.9634403688898634e-01 1.7575386290730128e-03
     	 	 7.7340825865401142e-02 4.5289589521138873e-01 1.8178149504742083e-03
     	 	 7.7229716761572087e-02 5.1111931447643577e-01 1.8205733449286928e-03
     	 	 7.6860799553882919e-02 5.6880243975114331e-01 1.8026443914539894e-03
     	 	 7.8000172896740105e-02 6.2309688775693017e-01 1.6699616230507297e-03
     	 	 7.7332015293154144e-02 6.7514076755886254e-01 1.5908150987196394e-03
     	 	 7.4174215760974604e-02 7.2578594434110355e-01 1.3957343752441500e-03
     	 	 8.1119848660475391e-02 7.6344172636924867e-01 1.4158969571020901e-03
     	 	 7.9069282865172896e-02 8.0523820546652514e-01 1.1695440010198654e-03
     	 	 7.8025935482999187e-02 8.4179043740964832e-01 1.0957578527178535e-03
     	 	 7.9919574397820048e-02 8.6938604761508786e-01 7.9881432343489422e-04
     	 	 8.0308219924612789e-02 8.9228768855907736e-01 6.6458833430569437e-04
     	 	 8.1046927219258214e-02 9.0776531213271938e-01 4.2191719401132567e-04
     	 	 8.4548117682801460e-02 9.1332925740702842e-01 1.8582467869007272e-04
     	 	 5.3346690571419608e-02 2.0131865711976791e-03 1.4331564410666504e-04
     	 	 5.0966493342245234e-02 1.0596906165439722e-02 3.2039898581651046e-04
     	 	 5.0242252835659751e-02 2.5979247728653624e-02 4.9782313637725313e-04
     	 	 4.9329310654153358e-02 4.8030218265701329e-02 6.4320069622016683e-04
     	 	 5.1377578355049414e-02 7.6298095554468218e-02 8.5352858938576902e-04
     	 	 4.9993128659836628e-02 1.1084089655282507e-01 9.5890654628987622e-04
     	 	 4.7665442472012653e-02 1.5137655582694834e-01 1.0875699689630212e-03
     	 	 5.1187601734692167e-02 1.9575545745760137e-01 1.2640011087498232e-03
     	 	 5.0239197068004837e-02 2.4565576257314756e-01 1.3584415763629202e-03
     	 	 4.7667684766922847e-02 3.0009780882840398e-01 1.3927831034648548e-03
     	 	 4.7506740355891197e-02 3.5664872759608857e-01 1.4270425921984757e-03
     	 	 4.8168827476170017e-02 4.1456103369129993e-01 1.4822439769867034e-03
     	 	 4.8858647396709420e-02 4.7301428460873413e-01 1.4953414731309475e-03
     	 	 4.8836904830800054e-02 5.3124578686578339e-01 1.4628580890321569e-03
     	 	 4.8081303370004047e-02 5.8875004921629426e-01 1.4385136928930045e-03
     	 	 4.9595726131131279e-02 6.4318126016528487e-01 1.3931783727018829e-03
     	 	 4.8430504016216624e-02 6.9763153802300581e-01 1.3440070348541739e-03
     	 	 4.7051465409537085e-02 7.4937307791031049e-01 1.1784128229694296e-03
     	 	 5.0654323964243186e-02 7.9255471008748113e-01 1.1882277217366019e-03
     	 	 5.0833876121428645e-02 8.3381625623968347e-01 9.8503167742804089e-04
     	 	 4.7908849818828814e-02 8.7228361726506243e-01 8.6670981014895347e-04
     	 	 5.2038751502648695e-02 8.9770301504648442e-01 6.7430513957672956e-04
     	 	 5.0005891244522593e-02 9.2262382326444403e-01 5.2584059953223979e-04
     	 	 5.1018169784852963e-02 9.3775945374511627e-01 3.3785968312482047e-04
     	 	 5.3527381828301746e-02 9.4433273724216749e-01 1.5251331678438365e-04
     	 	 2.9026436370545139e-02 2.0872304405183521e-03 1.1136929531464673e-04
     	 	 2.7607918012147126e-02 1.1024332009792607e-02 2.4840238106184587e-04
     	 	 2.7129490980304261e-02 2.7027329945177873e-02 3.8157368125145592e-04
     	 	 2.6984481495051948e-02 4.9922176705644375e-02 5.0370839398202708e-04
     	 	 2.7783492038025215e-02 7.9289361504796124e-02 6.5434201667155056e-04
     	 	 2.7284803024446802e-02 1.1513646285146859e-01 7.5613338192646407e-04
     	 	 2.5655688170276858e-02 1.5710235406946582e-01 8.2346070200581712e-04
     	 	 2.7898299279356942e-02 2.0286542436822741e-01 9.6941901892076633e-04
     	 	 2.7238598789806501e-02 2.5383501316678148e-01 1.0327714151654730e-03
     	 	 2.5730526797491882e-02 3.0861614945757071e-01 1.0347346202974797e-03
     	 	 2.5831474313220304e-02 3.6531202245457145e-01 1.0696334421607398e-03
     	 	 2.6109416476004288e-02 4.2385257817123889e-01 1.1158805011725194e-03
     	 	 2.6556350496449332e-02 4.8351820397264694e-01 1.1474970007401553e-03
     	 	 2.6599759684214130e-02 5.4387347387711249e-01 1.1480125344139548e-03
     	 	 2.5923230642687978e-02 6.0418025399103359e-01 1.1116035610799812e-03
     	 	 2.7144493261477165e-02 6.6120584661767701e-01 1.0920354393495566e-03
     	 	 2.6037555571544635e-02 7.1717767974247315e-01 1.0115478850475953e-03
     	 	 2.5844350762012969e-02 7.6864362472653869e-01 8.9461948525816246e-04
     	 	 2.7216017045390339e-02 8.1414832362015610e-01 8.7990905674824240e-04
     	 	 2.8188520216870905e-02 8.5492039444009316e-01 7.6683647641003600e-04
     	 	 2.5076177256207033e-02 8.9388648974911977e-01 6.3209331592751204e-04
     	 	 2.8901660585959332e-02 9.2020824715660632e-01 5.4014688736943740e-04
     	 	 2.6767468919081105e-02 9.4560045271787418e-01 3.8980195047580820e-04
     	 	 2.7701366165261088e-02 9.6101533838726971e-01 2.5378179146604306e-04
     	 	 2.9148718354316872e-02 9.6870682109176787e-01 1.1476867747671023e-04
     	 	 1.1891930311616394e-02 2.2177371232111349e-03 7.6295605199389681e-05
     	 	 1.1251071898500276e-02 1.1667257636752816e-02 1.6792094886838705e-04
     	 	 1.1066840917028142e-02 2.8511013176744527e-02 2.5594247168750557e-04
     	 	 1.1105430115501025e-02 5.2439565548070825e-02 3.4177491103814248e-04
     	 	 1.1344130814114783e-02 8.2992916794103144e-02 4.3326392902635230e-04
     	 	 1.1174872974333394e-02 1.1979521149961214e-01 5.0026371879180183e-04
     	 	 1.0415828445754505e-02 1.6243124780019916e-01 5.3260100034488011e-04
     	 	 1.1472688547842669e-02 2.0936388596304889e-01 6.4029687385811331e-04
     	 	 1.1093042858919877e-02 2.6123983647745019e-01 6.7570150767804632e-04
     	 	 1.0478794313124595e-02 3.1703321246275501e-01 6.7759759169587974e-04
     	 	 1.0592107294554287e-02 3.7531050656742759e-01 7.1028086085188726e-04
     	 	 1.0679713077986874e-02 4.3549276502745893e-01 7.3409521660300922e-04
     	 	 1.0889501000786339e-02 4.9637103802329913e-01 7.4995348785424553e-04
     	 	 1.0895243547227040e-02 5.5714686924663359e-01 7.4197306277551454e-04
     	 	 1.0529619291658743e-02 6.1702651851695123e-01 7.0178061114804118e-04
     	 	 1.1195734684830039e-02 6.7405444925087310e-01 7.0891947300545655e-04
     	 	 1.0540922067608816e-02 7.2954166495019201e-01 6.4136208865186290e-04
     	 	 1.0712530552382860e-02 7.8094868103595982e-01 5.9390630469716198e-04
     	 	 1.0995131197577890e-02 8.2810313456935503e-01 5.6454821255226919e-04
     	 	 1.1717909898250278e-02 8.6978810264627937e-01 5.1775632467159611e-04
     	 	 9.7956718622610461e-03 9.0816603325485368e-01 3.8757341111558114e-04
     	 	 1.1987043697846644e-02 9.3641838663302190e-01 3.6235876858197033e-04
     	 	 1.0807728304890518e-02 9.6114505758838498e-01 2.4834319918235761e-04
     	 	 1.1330578118649348e-02 9.7719940406925143e-01 1.6586380081443216e-04
     	 	 1.1947360820817265e-02 9.8587075728392792e-01 7.5418532925384895e-05
     	 	 2.2669021365628872e-03 2.2498995112378859e-03 3.3526663432358485e-05
     	 	 2.1370092098348392e-03 1.1815052502670008e-02 7.3150748314290473e-05
     	 	 2.1050521303875858e-03 2.8868566237605756e-02 1.1189283916678935e-04
     	 	 2.1194303711655760e-03 5.3162510837995912e-02 1.5105604237475247e-04
     	 	 2.1564751925733372e-03 8.4337556829581481e-02 1.9068498601185961e-04
     	 	 2.1296583681811310e-03 1.2192354210657452e-01 2.2166620960439659e-04
     	 	 1.9746042443407053e-03 1.6538252961436328e-01 2.3376743650501067e-04
     	 	 2.1901720704726735e-03 2.1383257422324059e-01 2.8528741505074340e-04
     	 	 2.1017641041958246e-03 2.6672418184662444e-01 2.9523205058380769e-04
     	 	 1.9893497608980404e-03 3.2305156589843470e-01 2.9416272277056317e-04
     	 	 2.0200481733024800e-03 3.8171044954069810e-01 3.0859376680660933e-04
     	 	 2.0318612139932357e-03 4.4193939370601304e-01 3.1658688139318049e-04
     	 	 2.0761037655290249e-03 5.0289653006180435e-01 3.2518261864150372e-04
     	 	 2.0749052890294273e-03 5.6383252207410939e-01 3.2258851243760310e-04
     	 	 1.9968051233902884e-03 6.2391941373833404e-01 3.0378926551664323e-04
     	 	 2.1394356278311433e-03 6.8198893744326927e-01 3.1218642713037983e-04
     	 	 1.9894122265493586e-03 7.3752952633040447e-01 2.7460465081669683e-04
     	 	 2.0599644046672694e-03 7.8917800017646733e-01 2.6138120280264001e-04
     	 	 2.0745193258541184e-03 8.3644341674530276e-01 2.3922631751141030e-04
     	 	 2.2518811696579100e-03 8.7852616122733329e-01 2.2781535751886876e-04
     	 	 1.7818795807901244e-03 9.1559495142676928e-01 1.5582814462569339e-04
     	 	 2.2974413078743483e-03 9.4557896566507516e-01 1.6002341663640471e-04
     	 	 2.0392821675810913e-03 9.6962057242074240e-01 1.0652384585755881e-04
     	 	 2.1561023734223417e-03 9.8624051802936008e-01 7.2432378539753769e-05
     	 	 2.2767160633992978e-03 9.9551350220601820e-01 3.3074869738124100e-05
     	 	 ];


    case 50

        % SET: SLOBODKINS TAUSCH
        % CARDINALITY RULE  :    447
        % EXTERNAL POINTS   :      0
        % NEGATIVE WEIGHTS  :      0
        % MOM.ERR. INF NORM : 8.327e-16

        XYW=[
    	 	 9.9573264367794601e-01 2.1641818292401313e-03 2.9948520377276553e-05
     	 	 9.8663603629284091e-01 1.1375432292824995e-02 6.5525832309771675e-05
     	 	 9.8698388638843770e-01 1.9417342160197920e-03 6.2495344073498741e-05
     	 	 9.7920374567180801e-01 1.0296039330163285e-02 1.3933839688345091e-04
     	 	 9.7031902944369830e-01 2.7765460553148838e-02 9.7545726249577758e-05
     	 	 9.7101586086469249e-01 1.8818635012163006e-03 9.3996179461664441e-05
     	 	 9.6437071050560852e-01 9.8869136117109499e-03 2.0724101094969684e-04
     	 	 9.5110756677228070e-01 2.4255879281400008e-02 3.1004125749777988e-04
     	 	 9.6448957334868091e-01 2.5434006968100321e-02 2.1052180020710888e-04
     	 	 9.4713543202042194e-01 5.0920343256089469e-02 1.3147044801254786e-04
     	 	 9.4810266348389716e-01 1.9865542946996867e-03 1.3296799471989933e-04
     	 	 9.4222578665075751e-01 1.0377030607975313e-02 2.9026300394208881e-04
     	 	 9.2949598794392319e-01 2.5225526933174664e-02 4.2696422467983621e-04
     	 	 9.0746883292810199e-01 4.6496509764143698e-02 5.9330825362954767e-04
     	 	 9.3017897898052126e-01 4.4971002157428420e-02 4.2732786248746152e-04
     	 	 9.4261192097988500e-01 4.7213021917522073e-02 2.8771369487850921e-04
     	 	 9.1766554729325123e-01 8.0307648258527528e-02 1.6809478909956939e-04
     	 	 9.1874527640735970e-01 2.0565083904545739e-03 1.7095373764761750e-04
     	 	 9.1397757153112702e-01 1.0785106499465688e-02 3.7637596219814373e-04
     	 	 9.0190130749523012e-01 2.6314285098877944e-02 5.5593110903455326e-04
     	 	 8.7780923640404018e-01 4.8543857951098952e-02 7.7824120385275644e-04
     	 	 8.7815522502730603e-01 7.3890614261822932e-02 7.6379619707948583e-04
     	 	 9.0221932350246581e-01 7.1916605090826563e-02 5.6022238401176225e-04
     	 	 9.1407200453650939e-01 7.5330173043189300e-02 3.7421508073766466e-04
     	 	 8.8252541186166722e-01 1.1539928379068358e-01 2.0096843271109234e-04
     	 	 8.8336436117485584e-01 2.0358591523129649e-03 1.9994049400565289e-04
     	 	 8.8017254963073766e-01 1.0723525972991810e-02 4.4496472434043421e-04
     	 	 8.6971560770991230e-01 2.6247958502546308e-02 6.5937489587351177e-04
     	 	 8.4485929747866995e-01 4.8141893191588424e-02 9.0178494104085861e-04
     	 	 8.4609011527097167e-01 7.7202916877347136e-02 1.0066896184656312e-03
     	 	 8.4459297433217317e-01 1.0644586632563467e-01 8.8624817307789247e-04
     	 	 8.6847780203014846e-01 1.0493553796557882e-01 6.8762279927609598e-04
     	 	 8.7959105886823707e-01 1.0951922785269225e-01 4.5673397404267114e-04
     	 	 8.4233572060107154e-01 1.5563736165512213e-01 2.2130236806276621e-04
     	 	 8.4241846962617184e-01 1.9747181715581296e-03 2.2078396351924771e-04
     	 	 8.4098469892126304e-01 1.0420564873536122e-02 4.9520434174923651e-04
     	 	 8.3259210324905730e-01 2.5574122833081286e-02 7.4220260682924556e-04
     	 	 8.0741801174838690e-01 4.6958702872510985e-02 1.0108298635654494e-03
     	 	 8.1286955323939902e-01 7.5805910415360125e-02 1.1449559880081345e-03
     	 	 7.7988501549038280e-01 1.0877211778308180e-01 1.2846375648271598e-03
     	 	 8.1066826326893260e-01 1.1194425000398409e-01 1.1781848430107717e-03
     	 	 8.0901270564428351e-01 1.4298623892466059e-01 9.5641559242899959e-04
     	 	 8.2992509752083565e-01 1.4389864063881375e-01 7.8212391442021882e-04
     	 	 8.3983921984884302e-01 1.4946744785772437e-01 5.1378382619023566e-04
     	 	 7.9650506264864462e-01 1.9442255064509191e-03 2.4015812143567789e-04
     	 	 7.9680059489937494e-01 1.0222684306612646e-02 5.3747446444275479e-04
     	 	 7.9015692425741035e-01 2.5047351400088652e-02 8.1758068350659121e-04
     	 	 7.6455521947899208e-01 4.6181165575137538e-02 1.1180482984970411e-03
     	 	 7.7391895217189499e-01 7.4377588487768043e-02 1.3223464938502511e-03
     	 	 7.4251089713587826e-01 1.0808606551981677e-01 1.4453475569028396e-03
     	 	 7.4465732421587383e-01 1.4669491194469747e-01 1.4382671888844090e-03
     	 	 7.7253158342742345e-01 1.5233053104803196e-01 1.3054152736885205e-03
     	 	 7.6966426212121475e-01 1.8387393117985878e-01 1.0539879239716892e-03
     	 	 7.8647899621463713e-01 1.8838519584642174e-01 8.4707000176880386e-04
     	 	 7.9530298703025593e-01 1.9446172006388066e-01 5.4532147655886689e-04
     	 	 7.9774721442090923e-01 2.0031208646165236e-01 2.3200889031492272e-04
     	 	 7.4634538144959617e-01 1.9636544227857830e-03 2.6195324818028637e-04
     	 	 7.4834351780219666e-01 1.0293329712571629e-02 5.8360224800849266e-04
     	 	 7.4253102800482851e-01 2.5105231673400112e-02 8.9567620123480300e-04
     	 	 7.1602450465370571e-01 4.6187333893353957e-02 1.2191515631464972e-03
     	 	 7.2922903882174639e-01 7.3176808378302732e-02 1.4434758259732204e-03
     	 	 7.0421484366230047e-01 1.0567389376577770e-01 1.4501074205233323e-03
     	 	 7.0579926328014797e-01 1.4714341104258608e-01 1.7103041089942836e-03
     	 	 7.0528923231930007e-01 1.8854332451094724e-01 1.5107982562879369e-03
     	 	 7.2889685879392996e-01 1.9771580251300225e-01 1.4329138424846954e-03
     	 	 7.2470385210780908e-01 2.2926983281364749e-01 1.1340897913937418e-03
     	 	 7.3776637813556345e-01 2.3717396733116636e-01 9.0958859015821615e-04
     	 	 7.4630224559547598e-01 2.4341423312307381e-01 5.8935417441205527e-04
     	 	 7.4941804674731272e-01 2.4861900048009203e-01 2.5143069163689345e-04
     	 	 6.9266333484912046e-01 1.9576721622975627e-03 2.7710891144546622e-04
     	 	 6.9644445346803918e-01 1.0291705340339801e-02 6.2052438611584699e-04
     	 	 6.9069175592439913e-01 2.5142488584224860e-02 9.6852707303361860e-04
     	 	 6.6373207533871348e-01 4.6257425348939972e-02 1.2929539299915019e-03
     	 	 6.7863819180628104e-01 7.3188303425566328e-02 1.5657247637856932e-03
     	 	 6.6145288514097722e-01 1.0556755524682500e-01 1.5615379615304835e-03
     	 	 6.6605828651341725e-01 1.4288052876755986e-01 1.8253682108318268e-03
     	 	 6.3760504333943457e-01 1.8483296623346493e-01 1.4664204775481696e-03
     	 	 6.6654258327279270e-01 1.9193910059663702e-01 1.7056609485030815e-03
     	 	 6.6234335147580625e-01 2.3444870434775864e-01 1.5908001689097957e-03
     	 	 6.7987756227504303e-01 2.4822146089945418e-01 1.5023375005380449e-03
     	 	 6.7587091374728558e-01 2.7901000451873909e-01 1.2020546487678384e-03
     	 	 6.8558859465119282e-01 2.8986723042767987e-01 9.5035761363252184e-04
     	 	 6.9390575266565702e-01 2.9603835247213739e-01 6.1349710765286802e-04
     	 	 6.9796807543748740e-01 3.0011874531062904e-01 2.5947588694578218e-04
     	 	 6.3627910683474809e-01 1.9553740444131777e-03 2.8789153434438333e-04
     	 	 6.4183107919016757e-01 1.0268105928626906e-02 6.4671863621229661e-04
     	 	 6.3537288412998549e-01 2.5098774027401814e-02 1.0242853457527162e-03
     	 	 6.0966116515407243e-01 4.6202477633510639e-02 1.3082163693848355e-03
     	 	 6.2435200244586819e-01 7.3318059016581255e-02 1.6615752025190200e-03
     	 	 6.1421203127909652e-01 1.0580319092503795e-01 1.7349947605538587e-03
     	 	 6.1737419109648983e-01 1.4297465623398686e-01 2.0125670511569127e-03
     	 	 6.0337377060885289e-01 1.8420647214490185e-01 1.6653752266392208e-03
     	 	 5.9399706641109618e-01 2.2971324907129378e-01 1.8603746280718507e-03
     	 	 6.2147452704119022e-01 2.4098764317001972e-01 1.8526978251979750e-03
     	 	 6.1291715142467162e-01 2.8543419855534063e-01 1.7763628213656134e-03
     	 	 6.2758549569741462e-01 3.0208359398714235e-01 1.5555060910074062e-03
     	 	 6.2357707585194566e-01 3.3235815677375197e-01 1.2552363026248100e-03
     	 	 6.3059970422006029e-01 3.4559273854219574e-01 9.7235910742709283e-04
     	 	 6.3882483565219195e-01 3.5146808592147394e-01 6.2002272046603212e-04
     	 	 6.4390973439558552e-01 3.5424504171486459e-01 2.6146839198246444e-04
     	 	 5.7815280097614563e-01 1.9472385616888974e-03 2.9306166309567831e-04
     	 	 5.8510759173846016e-01 1.0247028626125103e-02 6.6668900940001781e-04
     	 	 5.7743491588722540e-01 2.5033383448096726e-02 1.0591037673605931e-03
     	 	 5.5732552462670026e-01 4.6057304336595585e-02 1.1870822325191178e-03
     	 	 5.6780302437499075e-01 7.3173509079009075e-02 1.7177014401658999e-03
     	 	 5.6257048368940366e-01 1.0578598438293946e-01 1.8754599230032362e-03
     	 	 5.6435197429485573e-01 1.4320544879674579e-01 2.1588721594035520e-03
     	 	 5.5893559302561457e-01 1.8467760073508110e-01 2.1108965221765526e-03
     	 	 5.5142997283353179e-01 2.2892710267677624e-01 2.1289357809730711e-03
     	 	 5.4523828470218683e-01 2.7585833661495163e-01 2.0396190164917727e-03
     	 	 5.6930214503913468e-01 2.9248425045288073e-01 2.0650179394293127e-03
     	 	 5.5823749460113714e-01 3.3923154217478441e-01 1.9102466835318008e-03
     	 	 5.7269513659016014e-01 3.5660308444257494e-01 1.6150908846030208e-03
     	 	 5.6875873830200740e-01 3.8639779159092663e-01 1.2850773424068402e-03
     	 	 5.7296701464149180e-01 4.0259861559355242e-01 1.0167887667824865e-03
     	 	 5.8130577501915615e-01 4.0871202125949035e-01 6.5678521158475331e-04
     	 	 5.8764840528723583e-01 4.1045672904396407e-01 2.7777143806316583e-04
     	 	 5.1930771654542462e-01 1.9258618032887849e-03 2.9033428790873543e-04
     	 	 5.2691503162997222e-01 1.0128519970657111e-02 6.7225225738220759e-04
     	 	 5.1794212881169432e-01 2.4750934133663919e-02 1.0693514419168632e-03
     	 	 5.1314771735132081e-01 4.5515043763525553e-02 9.7038693096746680e-04
     	 	 5.0998550076902160e-01 7.2501311157982515e-02 1.7322624544355940e-03
     	 	 5.0832713454239475e-01 1.0492685295459585e-01 1.9250023948080563e-03
     	 	 5.0852537780385454e-01 1.4226103929160608e-01 2.2209896024652865e-03
     	 	 5.0833316287718611e-01 1.8025034922208508e-01 1.6435553160471018e-03
     	 	 5.0502544646472547e-01 1.9580268074081553e-01 9.0092015973286684e-04
     	 	 5.0140729557045560e-01 2.3139719720467730e-01 2.3005948075053031e-03
     	 	 4.9849788972332665e-01 2.7688419294260946e-01 2.3304299104788071e-03
     	 	 4.9489737923060417e-01 3.2320698226429834e-01 2.1341709346606079e-03
     	 	 5.1340232265817998e-01 3.4594827231741004e-01 2.1906848188506930e-03
     	 	 5.0110293986964083e-01 3.9380714423074037e-01 1.9465907874722382e-03
     	 	 5.1544719787476345e-01 4.1162857558885779e-01 1.6875150930995403e-03
     	 	 5.1302803070165259e-01 4.4051448444388852e-01 1.3404831845938733e-03
     	 	 5.1429502964499185e-01 4.6033536214051157e-01 1.0609113782842259e-03
     	 	 5.2239466684607394e-01 4.6720811002580159e-01 6.9203649629977074e-04
     	 	 5.2978539681770731e-01 4.6823475852955165e-01 2.9618699771359776e-04
     	 	 4.6107454045596019e-01 1.9388985973542419e-03 2.8575392878359195e-04
     	 	 4.6781543543590676e-01 1.0168016501382939e-02 6.8194480985946408e-04
     	 	 4.5756221661005270e-01 2.4921765501611386e-02 1.0815564638730758e-03
     	 	 4.6940120627319681e-01 4.5863709318956600e-02 1.1750126166076682e-03
     	 	 4.5150775702093782e-01 7.2864803039339190e-02 1.7454402833955995e-03
     	 	 4.5339410290268989e-01 1.0534005545782629e-01 1.9207761135820061e-03
     	 	 4.5142346881486173e-01 1.4294440031805952e-01 2.2976394016668410e-03
     	 	 4.5296535355948886e-01 1.8508930680597413e-01 2.4414904691126321e-03
     	 	 4.4804941672335974e-01 2.3097778009130068e-01 2.5360698235866526e-03
     	 	 4.4603238332359729e-01 2.7832934586407798e-01 2.5597563455577307e-03
     	 	 4.4471216724559615e-01 3.2565416304672101e-01 2.4560127107958805e-03
     	 	 4.4357334402385884e-01 3.7096074428626963e-01 2.2165617647014876e-03
     	 	 4.5544827903983998e-01 4.0079571652288620e-01 2.2757546246258511e-03
     	 	 4.4473055563065111e-01 4.4842025992237805e-01 1.9489680170580643e-03
     	 	 4.5714995161111072e-01 4.6881508732502020e-01 1.7589684846718687e-03
     	 	 4.5681719430658307e-01 4.9659695161518502e-01 1.3797255044471510e-03
     	 	 4.5596460813347950e-01 5.1884316141636111e-01 1.0548071922797148e-03
     	 	 4.6343178918443495e-01 5.2625982169586694e-01 6.8545060175930731e-04
     	 	 4.7117653647769187e-01 5.2685766231165809e-01 2.9615624522296379e-04
     	 	 4.0467844885748361e-01 1.9809617926355334e-03 2.8056917398325900e-04
     	 	 4.0848678993317578e-01 1.0369003361868795e-02 6.9076592477122106e-04
     	 	 3.9761419205136495e-01 2.5342653079962689e-02 1.0715512932420908e-03
     	 	 4.1618066075322369e-01 4.6264507175165906e-02 1.3521773468998684e-03
     	 	 3.9287668100844975e-01 7.3632309212547459e-02 1.7450687791948155e-03
     	 	 3.9914842714629484e-01 1.0599416406181320e-01 1.8890690558846809e-03
     	 	 3.9402126586071939e-01 1.4360406483925828e-01 2.2756623481186853e-03
     	 	 3.9753022094091628e-01 1.8556080308731973e-01 2.4446135996611792e-03
     	 	 3.9390542343016899e-01 2.3159328322788958e-01 2.5908407066924824e-03
     	 	 3.9172834363315423e-01 2.8060128320276051e-01 2.6865911182290488e-03
     	 	 3.9118973996491746e-01 3.2987698717398611e-01 2.6435060523389178e-03
     	 	 3.9085681743720424e-01 3.7824647946348150e-01 2.5229582200188821e-03
     	 	 3.9171173762579914e-01 4.2326827320226285e-01 2.2927334257317948e-03
     	 	 3.9796179062875137e-01 4.5836748614098066e-01 2.2529108283941323e-03
     	 	 3.9030966184033700e-01 5.0478478865453114e-01 1.9388208496711275e-03
     	 	 3.9950117413308184e-01 5.2814509522839059e-01 1.7217395400717804e-03
     	 	 4.0085487866796632e-01 5.5384093985320682e-01 1.3289024168461039e-03
     	 	 3.9843094464305129e-01 5.7713212030356853e-01 1.0068168757358976e-03
     	 	 4.0511068576162246e-01 5.8490435580349376e-01 6.5455578012980561e-04
     	 	 4.1259055486082996e-01 5.8550754904709290e-01 2.8472146736555098e-04
     	 	 3.5050142394771655e-01 1.9963300579496990e-03 2.7238967439310597e-04
     	 	 3.4998889475167683e-01 1.0495325942180823e-02 6.8356934348030201e-04
     	 	 3.3964204600453318e-01 2.5695247821370400e-02 1.0453134937671537e-03
     	 	 3.5912830010431496e-01 4.7048001537412586e-02 1.4000478861282159e-03
     	 	 3.3514420619330232e-01 7.4907220375568129e-02 1.7221123152090646e-03
     	 	 3.4537605388024639e-01 1.0753419414033309e-01 1.9000563453705794e-03
     	 	 3.3768038852409188e-01 1.4550544616287137e-01 2.2059565858207212e-03
     	 	 3.4249017195513476e-01 1.8718982239236615e-01 2.3902706609747809e-03
     	 	 3.3988534324725916e-01 2.3292707321506365e-01 2.5329684453868498e-03
     	 	 3.3815685245028138e-01 2.8188308958704905e-01 2.6751811173690411e-03
     	 	 3.3702983320443425e-01 3.3316962730105948e-01 2.7308186439959688e-03
     	 	 3.3842913587441203e-01 3.8212937600824465e-01 2.4706103306243671e-03
     	 	 3.3638504152330206e-01 4.2925661979475843e-01 2.2317917375880782e-03
     	 	 3.4571304174766515e-01 4.4870492792851585e-01 7.2357326303532869e-04
     	 	 3.3605616641591096e-01 4.8285553627351352e-01 2.2001436699894210e-03
     	 	 3.4431288219139133e-01 5.1521177770489901e-01 2.0655099839861275e-03
     	 	 3.3592616089116767e-01 5.6055188674862855e-01 1.8568770011957211e-03
     	 	 3.4271331121462523e-01 5.8563053356965367e-01 1.6408343979477781e-03
     	 	 3.4647254835251118e-01 6.0823258001880398e-01 1.2518755002063617e-03
     	 	 3.4217583126763951e-01 6.3300475809132317e-01 9.7547086916284747e-04
     	 	 3.4777631113853091e-01 6.4206068444222519e-01 6.4674744081208880e-04
     	 	 3.5473661967513170e-01 6.4333353405172944e-01 2.8282659775668786e-04
     	 	 2.9806858537914227e-01 2.0158923165819491e-03 2.6736552670017711e-04
     	 	 2.9358762817585582e-01 1.0582681945232864e-02 6.5652120883427244e-04
     	 	 2.8443838432357571e-01 2.5871777273617488e-02 9.9585217258757702e-04
     	 	 3.0270678938259654e-01 4.7573902451394860e-02 1.3779905663050824e-03
     	 	 2.7999910783035975e-01 7.5655151369145773e-02 1.6545335234013437e-03
     	 	 2.9185105527981881e-01 1.0914674263473501e-01 1.9154461248067675e-03
     	 	 2.8395655473454662e-01 1.4794405464069280e-01 2.1233477875971236e-03
     	 	 2.8877030470128340e-01 1.9035229568585044e-01 2.3388253461576374e-03
     	 	 2.8728267616174619e-01 2.3627534375228654e-01 2.4278753249115130e-03
     	 	 2.8571889275275342e-01 2.8461872329290699e-01 2.5400455654182811e-03
     	 	 2.8521220058194841e-01 3.3506657783974381e-01 2.6152820694417666e-03
     	 	 2.8317000221027777e-01 3.8651288763202468e-01 2.5072761979386560e-03
     	 	 3.0052393975358560e-01 4.0577062786024221e-01 6.0752793071292596e-04
     	 	 2.8192512018361260e-01 4.4206882488949528e-01 2.3523349723219328e-03
     	 	 2.8770458281300249e-01 4.8445139400045023e-01 2.3286120374263054e-03
     	 	 2.8242367357440024e-01 5.3319582980590308e-01 2.2561501910840125e-03
     	 	 2.9266943060879835e-01 5.6450269038070988e-01 1.9650975093240502e-03
     	 	 2.8333505176667551e-01 6.0926861303611002e-01 1.7513340296501081e-03
     	 	 2.8684080922827038e-01 6.3844144111401113e-01 1.6401561154485093e-03
     	 	 2.9383680016333258e-01 6.5901617935934254e-01 1.2665157655662191e-03
     	 	 2.8837595859505716e-01 6.8587242205981147e-01 9.6587047253491633e-04
     	 	 2.9258064146198126e-01 6.9688700287835781e-01 6.3781139097488708e-04
     	 	 2.9860417121698135e-01 6.9939376063999137e-01 2.8188932431430741e-04
     	 	 2.4711229043650262e-01 2.0129394151611781e-03 2.5846049055670020e-04
     	 	 2.4042074753867637e-01 1.0583292716393876e-02 6.1302629009321260e-04
     	 	 2.3262832322263516e-01 2.5878294432465834e-02 9.2812670278349051e-04
     	 	 2.4872813309016950e-01 4.7702188239452485e-02 1.3090034641801149e-03
     	 	 2.2847032369208509e-01 7.5663526538405176e-02 1.5316746934099994e-03
     	 	 2.4012633677608330e-01 1.0957053348578616e-01 1.8411609995112083e-03
     	 	 2.3375242382229400e-01 1.4873401053002164e-01 2.0164266888346820e-03
     	 	 2.3740914354752662e-01 1.9241162919039850e-01 2.2579029226727811e-03
     	 	 2.3716595702172760e-01 2.3876465683855597e-01 2.2715537087511463e-03
     	 	 2.3539690109726630e-01 2.8100700660324424e-01 1.5741239234911795e-03
     	 	 2.3587118098297866e-01 3.0608216633117474e-01 1.4388799447617407e-03
     	 	 2.3520750335737517e-01 3.4758774043833790e-01 2.3132845357339508e-03
     	 	 2.3399639041849818e-01 3.9663822408528193e-01 2.3555942303744547e-03
     	 	 2.3468264351647261e-01 4.4475320568532356e-01 2.3004074674601955e-03
     	 	 2.3356588627701602e-01 4.9075208315862068e-01 2.0026101364194401e-03
     	 	 2.3807220674687324e-01 5.2844569552001430e-01 2.0727878499421089e-03
     	 	 2.3048381087450653e-01 5.7765724155675391e-01 2.1413344480414966e-03
     	 	 2.4203096905672539e-01 6.0929913867224084e-01 1.9989293552330058e-03
     	 	 2.3442493632556805e-01 6.5536854904403052e-01 1.7473249515126664e-03
     	 	 2.3413346238877464e-01 6.8962263961779524e-01 1.5803184313306204e-03
     	 	 2.4318086139992534e-01 7.0882168506634480e-01 1.2393550144762320e-03
     	 	 2.3755994844796380e-01 7.3637061111369151e-01 9.2081538010314499e-04
     	 	 2.4064874332139696e-01 7.4869141849219545e-01 6.0366169688476400e-04
     	 	 2.4519653061494062e-01 7.5277607582300599e-01 2.6909818182269015e-04
     	 	 1.9833983752594297e-01 2.0188634976773395e-03 2.4460548252669531e-04
     	 	 1.9135579862722329e-01 1.0587855932040504e-02 5.5822296202518936e-04
     	 	 1.8485653529451973e-01 2.5828793036969021e-02 8.4211914538097354e-04
     	 	 1.9815678871490350e-01 4.7575750108580409e-02 1.2085803812526010e-03
     	 	 1.8141358259509033e-01 7.5303902750069512e-02 1.3663837391774769e-03
     	 	 1.9166668231747785e-01 1.0898066528993001e-01 1.6905485974752763e-03
     	 	 1.8716620020630437e-01 1.4784213759738513e-01 1.8558707018816439e-03
     	 	 1.8972327222498597e-01 1.9196337640232858e-01 2.1190869791180406e-03
     	 	 1.8986539313254835e-01 2.4065953835237508e-01 2.3071581257329732e-03
     	 	 1.8875852360374645e-01 2.9320285533549534e-01 2.4215299555268239e-03
     	 	 1.8863397735582543e-01 3.4806364410176749e-01 2.5054754085185767e-03
     	 	 1.8769118816541541e-01 4.0444651914326346e-01 2.5087982620815501e-03
     	 	 1.8767567697919496e-01 4.6045361708705967e-01 2.5006345667141733e-03
     	 	 1.8813937594655172e-01 5.1509117296298479e-01 2.4004146698467844e-03
     	 	 1.8935710232601277e-01 5.6759981318475505e-01 2.3823358459424265e-03
     	 	 1.8384187654059825e-01 6.2221573251840090e-01 2.0961803459003518e-03
     	 	 1.9486677652988305e-01 6.5559724216692583e-01 1.8916643313439004e-03
     	 	 1.8785022251276440e-01 7.0214333573995680e-01 1.6610557185246185e-03
     	 	 1.8566615849543489e-01 7.3826734355663237e-01 1.4321005857201757e-03
     	 	 1.9536216415696561e-01 7.5660391452997866e-01 1.1586806152209816e-03
     	 	 1.9028009514401978e-01 7.8361400031466955e-01 8.4656769005347552e-04
     	 	 1.9249059469381213e-01 7.9681001728830825e-01 5.5648775278230257e-04
     	 	 1.9539597531610553e-01 8.0256453882666945e-01 2.4941765912888937e-04
     	 	 1.5302046691224391e-01 1.9926534074355541e-03 2.2083308504801551e-04
     	 	 1.4717464955743076e-01 1.0461359857009368e-02 4.9246243093828076e-04
     	 	 1.4191604815211822e-01 2.5598859247121207e-02 7.4426575256858170e-04
     	 	 1.5175976462334284e-01 4.7339137647244581e-02 1.0907096751180871e-03
     	 	 1.3995736176184903e-01 7.5099029452520602e-02 1.1778609647360302e-03
     	 	 1.4731082292671471e-01 1.0853046894883570e-01 1.5153682170573706e-03
     	 	 1.4457340112572470e-01 1.4680117436332085e-01 1.6297873128793797e-03
     	 	 1.4634038263638482e-01 1.8922608083187012e-01 1.8215776279300623e-03
     	 	 1.4660523482451293e-01 2.3560572875781202e-01 1.9850151681643133e-03
     	 	 1.4598833024666902e-01 2.8604970087694176e-01 2.1453741768376888e-03
     	 	 1.4572661295820266e-01 3.4046736932750687e-01 2.2654222412940251e-03
     	 	 1.4549400550852110e-01 3.9669202693576194e-01 2.2937083168744943e-03
     	 	 1.4481606418971560e-01 4.5426003153012123e-01 2.3234082610555005e-03
     	 	 1.4513146189210269e-01 5.1075065599256653e-01 2.2610245911774103e-03
     	 	 1.4611910361648939e-01 5.6469071958445094e-01 2.1463797603329944e-03
     	 	 1.4526953621158023e-01 6.1624955061908904e-01 2.0239387271669554e-03
     	 	 1.4121822645193494e-01 6.6763842976354071e-01 1.8074530176955639e-03
     	 	 1.5195123299294799e-01 6.9938065079553680e-01 1.6911281821373270e-03
     	 	 1.4443500000794118e-01 7.4591664574098715e-01 1.5094354115352130e-03
     	 	 1.4215630486728437e-01 7.8203705796832979e-01 1.2690713639874906e-03
     	 	 1.5100294001473547e-01 8.0126470232162805e-01 1.0608695779056045e-03
     	 	 1.4728043189092110e-01 8.2691317412116583e-01 7.5763697571221882e-04
     	 	 1.4859124516258571e-01 8.4088418602564141e-01 4.9645809699679739e-04
     	 	 1.5005678670932354e-01 8.4794322549318990e-01 2.2000096252837196e-04
     	 	 1.1227574381470917e-01 1.9774927649365234e-03 1.9342539713214268e-04
     	 	 1.0824690575751683e-01 1.0401625685087360e-02 4.2570295265134862e-04
     	 	 1.0437099540982475e-01 2.5452671615476867e-02 6.3590089745549263e-04
     	 	 1.1055601909692658e-01 4.7058957035360297e-02 9.5185689580294924e-04
     	 	 1.0476023440822724e-01 7.5025121061362762e-02 1.0067008781962116e-03
     	 	 1.0768847016123095e-01 1.0912819717587238e-01 1.3696028142594031e-03
     	 	 1.0676102360975914e-01 1.4918088999096249e-01 1.5100300713722290e-03
     	 	 1.0780858952202144e-01 1.9415452493619445e-01 1.7012263351102719e-03
     	 	 1.0806462172154740e-01 2.4268930607561945e-01 1.7704543417737663e-03
     	 	 1.0727147064785003e-01 2.8952960549960655e-01 1.4964805022966308e-03
     	 	 1.0803039915194146e-01 3.2407709048625472e-01 1.1826871529446914e-03
     	 	 1.0701981479383160e-01 3.6592704234671192e-01 1.7686510735644802e-03
     	 	 1.0780856209760348e-01 4.1777064107635442e-01 1.8932934336620283e-03
     	 	 1.0662971619468076e-01 4.7339208804279248e-01 1.9608597932229566e-03
     	 	 1.0699873297253160e-01 5.2796657985563422e-01 1.9346426769387686e-03
     	 	 1.0778282454960864e-01 5.8078010592432250e-01 1.8442083377229286e-03
     	 	 1.0718031586637111e-01 6.2867469238030982e-01 1.5307250430372759e-03
     	 	 1.0631015240371167e-01 6.6797478077475558e-01 1.3046619390881921e-03
     	 	 1.0334607151134179e-01 7.0936389509443842e-01 1.4098589079329026e-03
     	 	 1.1284851565931087e-01 7.4012614405582378e-01 1.4925582218366525e-03
     	 	 1.0532176378308955e-01 7.8631873782792738e-01 1.3178629281426005e-03
     	 	 1.0417423323062192e-01 8.2084764475901162e-01 1.0697121806697261e-03
     	 	 1.1117957023831881e-01 8.4133948266342751e-01 9.2131374515513128e-04
     	 	 1.0908151653777010e-01 8.6503574177712816e-01 6.5900984692214115e-04
     	 	 1.0938466013597647e-01 8.7998223886409566e-01 4.3861489898966633e-04
     	 	 1.0987276162053528e-01 8.8809827575780165e-01 1.9444892752873462e-04
     	 	 7.7042579154582569e-02 2.0136719234152833e-03 1.6608352812778687e-04
     	 	 7.4884990032079823e-02 1.0524514943583146e-02 3.5919834181265308e-04
     	 	 7.2462702607200558e-02 2.5417707846921475e-02 5.1937793018076370e-04
     	 	 7.5263350823217112e-02 4.6107719683747841e-02 7.4942593347006369e-04
     	 	 7.4828931009077948e-02 7.1491673211160942e-02 7.8215811555546952e-04
     	 	 7.3739789922167676e-02 1.0252869518643887e-01 1.0370376019420236e-03
     	 	 7.3952899957928642e-02 1.3902910159268350e-01 1.2041079962985140e-03
     	 	 7.4303043409865599e-02 1.8232385010825286e-01 1.4059394512373428e-03
     	 	 7.4748657908440985e-02 2.3100815741784614e-01 1.5630947905557865e-03
     	 	 7.4321168796519510e-02 2.8427069769453522e-01 1.6780787444867502e-03
     	 	 7.4399798539215301e-02 3.4099156427650107e-01 1.7682136141664118e-03
     	 	 7.3938406712151017e-02 3.9993455275295442e-01 1.7862802563628924e-03
     	 	 8.3028425825127594e-02 4.4299748885826007e-01 3.2415366644016747e-04
     	 	 7.2600892033311881e-02 4.6225114864016636e-01 1.6022577184807596e-03
     	 	 7.3870729589295192e-02 5.1975314829310204e-01 1.7870837231315283e-03
     	 	 7.4415749696851829e-02 5.7827174995612263e-01 1.7580041342913362e-03
     	 	 7.4318727414090735e-02 6.3477676854574439e-01 1.6751920552835827e-03
     	 	 7.3534874146471862e-02 6.8875619966454604e-01 1.5478211318117466e-03
     	 	 7.1488063367272314e-02 7.3951944408853687e-01 1.3608296918657039e-03
     	 	 7.8195400342783272e-02 7.7643431743165359e-01 1.2953276673350069e-03
     	 	 7.1643632738691565e-02 8.2130654391820890e-01 1.0881027460152484e-03
     	 	 7.2087275023389297e-02 8.5380863807446972e-01 8.8586863898491169e-04
     	 	 7.6621546930801143e-02 8.7663663340169251e-01 7.7661477167660121e-04
     	 	 7.5956446475113126e-02 8.9877487780055276e-01 5.5710027534282194e-04
     	 	 7.5514483992557557e-02 9.1419499231582801e-01 3.6187885320232259e-04
     	 	 7.5433838875727521e-02 9.2261293641939590e-01 1.5749352374572377e-04
     	 	 4.8074816029964329e-02 1.8505204959747225e-03 1.2221389832988956e-04
     	 	 4.7444486336340796e-02 9.7923824206387206e-03 2.7512711946049863e-04
     	 	 4.6236354658415579e-02 2.4336583762633431e-02 4.2441683781473929e-04
     	 	 4.6428064469852037e-02 4.5814392431921959e-02 6.2838990528205692e-04
     	 	 4.8522327503319862e-02 7.3900740864576861e-02 7.5894013411546162e-04
     	 	 4.5926534942222319e-02 1.0866135425255899e-01 9.2726380773218268e-04
     	 	 4.6804706742138213e-02 1.4872289692460322e-01 1.0255011851763975e-03
     	 	 4.6818137007656468e-02 1.9204665940576132e-01 1.0797491144268162e-03
     	 	 4.7137162992653137e-02 2.3590892595873417e-01 1.0774183494200191e-03
     	 	 4.6816575073106215e-02 2.8029091860316963e-01 1.1275543248556660e-03
     	 	 4.6872279322776378e-02 3.2948830878928781e-01 1.2865510414570931e-03
     	 	 4.6741782213682082e-02 3.8439219501273897e-01 1.3931433199841049e-03
     	 	 4.6643854048003863e-02 4.4275868975301685e-01 1.4415152160342335e-03
     	 	 4.6058475668806498e-02 5.0286109599910067e-01 1.4395573061145959e-03
     	 	 4.6884598132782118e-02 5.6097396689218582e-01 1.4060029087308852e-03
     	 	 4.6851009950727884e-02 6.1732180630440192e-01 1.3486180942706113e-03
     	 	 4.6773697679106219e-02 6.7040485144462081e-01 1.2483589502331287e-03
     	 	 4.6154751573867836e-02 7.1995833868283021e-01 1.1403178758864411e-03
     	 	 4.4852960006134257e-02 7.6662693861096631e-01 1.0381989255948947e-03
     	 	 4.9474236614684530e-02 8.0457667671469590e-01 1.0490892467169661e-03
     	 	 4.4393956272730462e-02 8.4792100365912493e-01 8.6621819101774934e-04
     	 	 4.5526516546404827e-02 8.8026214973095462e-01 7.2618082660897527e-04
     	 	 4.8107013766565787e-02 9.0519357433303815e-01 6.1738927004760741e-04
     	 	 4.8219987589099178e-02 9.2634447037695611e-01 4.5246170741894436e-04
     	 	 4.7521692273848837e-02 9.4202716083706817e-01 2.9310598482287288e-04
     	 	 4.7163545855663069e-02 9.5084171054466038e-01 1.2816980505764826e-04
     	 	 2.5781004199951441e-02 2.0338866565706971e-03 9.8290417110208958e-05
     	 	 2.5883360598980998e-02 1.0699821410052797e-02 2.2279895620022600e-04
     	 	 2.5338155685800556e-02 2.6181104320240383e-02 3.3656382028915394e-04
     	 	 2.4642959429477029e-02 4.7902769826277065e-02 4.4984626544199662e-04
     	 	 2.7052572296508370e-02 7.5088694309882603e-02 5.6605830701500362e-04
     	 	 2.4494170965499107e-02 1.0759842433347175e-01 6.3279253265454316e-04
     	 	 2.5469709306804256e-02 1.4560170857844440e-01 7.4604837570348972e-04
     	 	 2.5424610891422783e-02 1.8941832676806683e-01 8.5076717691628413e-04
     	 	 2.5533575972741640e-02 2.3854208209332817e-01 9.4537432542281296e-04
     	 	 2.5446246971049358e-02 2.9190229401298901e-01 1.0032189871661205e-03
     	 	 2.5403239469511729e-02 3.4801124272829415e-01 1.0416957182566159e-03
     	 	 2.5375909599768431e-02 4.0536198699481985e-01 1.0446351226006331e-03
     	 	 2.5362086960278085e-02 4.6217444072843339e-01 1.0185812073156208e-03
     	 	 2.4901549812741730e-02 5.1764436920453727e-01 9.8083050933516326e-04
     	 	 2.5537988075922113e-02 5.7187035339891501e-01 1.0007380050575602e-03
     	 	 2.5395320127938992e-02 6.2680778331658815e-01 1.0012764349893904e-03
     	 	 2.5413471572113822e-02 6.8113363571116536e-01 9.7828460196628872e-04
     	 	 2.5096105816474035e-02 7.3373062845302683e-01 9.1578356457689336e-04
     	 	 2.4280490238063446e-02 7.8335528026416190e-01 8.2251710546987723e-04
     	 	 2.6823908867870561e-02 8.2553338434046530e-01 8.0273270285281275e-04
     	 	 2.3768639489715748e-02 8.6733035614895571e-01 6.3126229374370986e-04
     	 	 2.4694669146772319e-02 9.0020953169223772e-01 5.5194730793824381e-04
     	 	 2.6053259777298110e-02 9.2696305092942333e-01 4.6842889393638819e-04
     	 	 2.6300392118258631e-02 9.4844731428079909e-01 3.4608732642472804e-04
     	 	 2.5786179619139316e-02 9.6398712821397492e-01 2.1542926024796876e-04
     	 	 2.5380375662315546e-02 9.7268559157212908e-01 9.1679206216731924e-05
     	 	 1.0420840557456845e-02 2.0585601287417894e-03 6.2672645903813425e-05
     	 	 1.0666111648132137e-02 1.0749578634941375e-02 1.4436215062702890e-04
     	 	 1.0453544803433523e-02 2.6018502873818319e-02 2.1642020616571559e-04
     	 	 9.8456835292402012e-03 4.7567578142185013e-02 2.7977991497953595e-04
     	 	 1.1167162590225765e-02 7.5281526477641456e-02 3.8438347286747778e-04
     	 	 9.8860369879353316e-03 1.0875825661357928e-01 4.0701389606126595e-04
     	 	 1.0449995599126516e-02 1.4713210762552892e-01 4.7941727802776861e-04
     	 	 1.0402642915941618e-02 1.8991982018667933e-01 5.2632191144041897e-04
     	 	 1.0434648088262111e-02 2.3672853105219502e-01 5.7643853818374786e-04
     	 	 1.0425179177653288e-02 2.8770747219110948e-01 6.2463260067977065e-04
     	 	 1.0384824917390678e-02 3.4274008186627342e-01 6.6695036818103788e-04
     	 	 1.0384514234348496e-02 4.0100619704734952e-01 6.9823156386735440e-04
     	 	 1.0393351669508277e-02 4.6137158832119946e-01 7.1499119206134502e-04
     	 	 1.0190580129451066e-02 5.2254442772352461e-01 7.0318953228182593e-04
     	 	 1.0448145239373541e-02 5.8290214723188183e-01 7.0403203514395529e-04
     	 	 1.0386539554333662e-02 6.4140899537084506e-01 6.6984807362117753e-04
     	 	 1.0390269976121358e-02 6.9682557619817997e-01 6.2971887342289860e-04
     	 	 1.0268339150616645e-02 7.4855113837051634e-01 5.7383879849529920e-04
     	 	 9.8564849076990813e-03 7.9629297591285464e-01 5.0739691568586851e-04
     	 	 1.1017548423675971e-02 8.3855890430971936e-01 5.1070006598951160e-04
     	 	 9.6603551931002674e-03 8.7839466345486306e-01 3.9829342254884675e-04
     	 	 1.0018908339293309e-02 9.1191345549885894e-01 3.5433559777738949e-04
     	 	 1.0618456799507459e-02 9.3968446874552025e-01 3.0517030186174297e-04
     	 	 1.0789021712487856e-02 9.6192461413724673e-01 2.3485967853116980e-04
     	 	 1.0589476083335936e-02 9.7812730996553876e-01 1.5095323702299496e-04
     	 	 1.0303301209128590e-02 9.8753512272768218e-01 6.4850107599469012e-05
     	 	 1.9637698836747486e-03 1.8914709664672755e-03 2.4597852108363784e-05
     	 	 2.0381977579495558e-03 1.0090447921375109e-02 6.0432277565798877e-05
     	 	 2.0047851490608837e-03 2.5089860106993270e-02 9.4625775744868837e-05
     	 	 1.8445256035173330e-03 4.6909678837845650e-02 1.1965962322389006e-04
     	 	 2.1285010598414145e-03 7.5335523462522327e-02 1.7223411571361922e-04
     	 	 1.8698265312876439e-03 1.0994540017799227e-01 1.8034054927111896e-04
     	 	 1.9926969859669352e-03 1.5024333200988269e-01 2.1976735152857708e-04
     	 	 1.9802939811868203e-03 1.9578407105934048e-01 2.4341273488379637e-04
     	 	 1.9859811974526353e-03 2.4582350424167210e-01 2.6487305459794958e-04
     	 	 1.9842704185676352e-03 2.9943772327496565e-01 2.7997828505374884e-04
     	 	 1.9747256812587821e-03 3.5542903147827104e-01 2.8722355903775220e-04
     	 	 1.9779237786423653e-03 4.1238877366034898e-01 2.8922674013191145e-04
     	 	 1.9802136419584393e-03 4.6924269436947114e-01 2.8767927458600540e-04
     	 	 1.9337257438711841e-03 5.2584952613354441e-01 2.8093297830105314e-04
     	 	 1.9903054765141315e-03 5.8263513994203109e-01 2.9074906833715796e-04
     	 	 1.9782445591470799e-03 6.3956011758642617e-01 2.8762913483218466e-04
     	 	 1.9767634554211932e-03 6.9560096664698057e-01 2.7957433576431960e-04
     	 	 1.9629916556416216e-03 7.4939892807426312e-01 2.6288249544886215e-04
     	 	 1.8731859996666822e-03 7.9984227150168885e-01 2.3265129471825876e-04
     	 	 2.0816447562176377e-03 8.4576917237894578e-01 2.3291587291580376e-04
     	 	 1.8366128361659850e-03 8.8690605428548663e-01 1.7957225074151893e-04
     	 	 1.9093623708361651e-03 9.2191424479499784e-01 1.5660157991394797e-04
     	 	 2.0300614334518574e-03 9.5051704515729274e-01 1.3244153249744505e-04
     	 	 2.0531362215945315e-03 9.7256927765996692e-01 9.8241275891762232e-05
     	 	 2.0140398829137096e-03 9.8779350503828656e-01 6.0443844910403215e-05
     	 	 1.9470045188982876e-03 9.9614504456205089e-01 2.4590391140648980e-05
     	 	 ];

    otherwise
        
        XYW=set_stroud_pre(deg);
        
end


if isempty(XYW) == 0
    X=XYW(:,1); Y=XYW(:,2); Z=1-X-Y; W=XYW(:,3);
    XYW_bar=[X Y Z W./sum(W)];
end













function [xyw,xyw_bar]=set_stroud_pre(ade)

% INPUT:
% ade: degree of precision.
%
% OUTPUT:
% xyw determines the cubature points and weights, in BARYCENTRIC coordinates.
% nodes: xyw(:,1:3)
% weights: xyw(:,4)

xyw=stroud_conical_rules_ref(ade);
xx=xyw(:,1); yy=xyw(:,2); ww=xyw(:,3);

L2=yy;
L3=xx-L2;
L1=1-L2-L3;

ww_bar=2*ww;

xyw_bar=[L1 L2 L3 ww_bar];

xyw=xyw_bar(:,[1 3 4]);
xyw(:,3)=xyw(:,3)/2;
xyw_bar=[xyw(:,1:2) 1-xyw(:,1)-xyw(:,2) xyw(:,3)*2];







function xyw=stroud_conical_rules_ref(ade)

% SEE LYNESS, COOLS, "A survey on numerical cubature over triangles", p.4.

N=ceil((ade+1)/2);

[t,T]=gauss_jacobi(N,0,0);
t=(t+1)/2; T=T/2;

[x,w]=gauss_jacobi(N,0,1);
x=(x+1)/2; X=w/4;

[wx,wy]=meshgrid(T,X);
ww=wx.*wy;

[~,xx]=meshgrid(x,x);

[yt,yx]=meshgrid(t,x);
yy=yt.*yx;

xyw=[xx(:) yy(:) ww(:)];






function [x,w]=gauss_jacobi(N,a,b,gl)

% GAUSS-JACOBI (LOBATTO) RULE ON (-1,1).
% N IS ...
% a,b ARE THE GAUSS-JACOBI EXPONENTS.
% gl: 0: GAUSS POINTS. 1: GAUSS-LOBATTO POINTS.
% x, w ARE COLUMN VECTORS OF NODES AND WEIGHTS.
%      THE LENGTH OF x AND w IS "N" IF gl=0, "N+2" IF "gl=1".

if nargin < 2
    a=0; b=0;
end

if nargin < 4
    gl = 0;
end

if gl == 0
    ab=r_jacobi(N,a,b);
    xw=gauss(N,ab);
else
    xw=lobatto_jacobi(N,a,b);
end

x=xw(:,1);
w=xw(:,2);




%--------------------------------------------------------------------------
% ADDITIONAL FUNCTIONS BY D.LAURIE AND W.GAUTSCHI.
%--------------------------------------------------------------------------

function ab=r_jacobi(N,a,b)

nu=(b-a)/(a+b+2);
mu=2^(a+b+1)*gamma(a+1)*gamma(b+1)/gamma(a+b+2);
if N==1
    ab=[nu mu]; return
end

N=N-1;
n=1:N;
nab=2*n+a+b;
nuadd=(b^2-a^2)*ones(1,N)./(nab.*(nab+2));
A=[nu nuadd];
n=2:N;
nab=nab(n);
B1=4*(a+1)*(b+1)/((a+b+2)^2*(a+b+3));
B=4*(n+a).*(n+b).*n.*(n+a+b)./((nab.^2).*(nab+1).*(nab-1));
abadd=[mu; B1; B'];
ab=[A' abadd];


function xw=gauss(N,ab)
N0=size(ab,1); 
if N0<N
    error('input array ab too short')
end
J=zeros(N);
for n=1:N, J(n,n)=ab(n,1); end
for n=2:N
    J(n,n-1)=sqrt(ab(n,2));
    J(n-1,n)=J(n,n-1);
end
[V,D]=eig(J);
[D,I]=sort(diag(D));
V=V(:,I);
xw=[D ab(1,2)*V(1,:)'.^2];


function xw=lobatto_jacobi(N,a,b)

if nargin<2, a=0; end
if nargin<3, b=a; end
ab=r_jacobi(N+2,a,b);
ab(N+2,1)=(a-b)/(2*N+a+b+2);
ab(N+2,2)=4*(N+a+1)*(N+b+1)*(N+a+b+1)/((2*N+a+b+1)*(2*N+a+b+2)^2);
xw=gauss(N+2,ab);


% function [xx,ww]=rules_convert(xw)
% 
% % CONVERTING RULES FROM A REFERENCE SIMPLEX TO ANOTHER.
% 
% x=xw(:,1); y=xw(:,2); ww=xw(:,3);
% pts_bar=[x y 1-x-y];
% delta=0;
% vertices=[-1+delta -1+delta; 1-2*delta -1+delta; -1+delta 1-2*delta];
% xx=pts_bar*vertices;
% ww=4*ww;

