
function demo_FTEST_batch

%--------------------------------------------------------------------------
% This demo performs numerical tests on interval, square, cube, as
% presented in the paper
%
% "On the role of weak Marcinkiewicz-Zygmund constants in polynomial 
% approximation by orthogonal bases".
%
% The approximation via hyperinterpolation and Least-Squares of some 
% functions is considered.
%--------------------------------------------------------------------------
% Reference paper:
%--------------------------------------------------------------------------
% "On the role of weak Marcinkiewicz-Zygmund constants in polynomial 
% approximation by orthogonal bases"
% C. An, A. Sommariva and M. Vianello
%--------------------------------------------------------------------------
% License:
%--------------------------------------------------------------------------
% Copyright (C) 2025 Alvise Sommariva, Marco Vianello.
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
%
% Authors:
%
% Alvise Sommariva <alvise@math.unipd.it>
% Marco Vianello <marcov@math.unipd.it>
% Date: December 27, 2025
%--------------------------------------------------------------------------

warning off

str=replace(replace(replace(string(datetime),' ','_'),':','_'),'-','_');
diary(strcat('_test_',str,'.txt'));


fprintf('\n \t ....................... INTERVAL .........................')
fprintf('\n \n');
demo_FTEST_interval;

fprintf('\n \t ........................ SQUARE ..........................')
fprintf('\n \n');
demo_FTEST_square;

fprintf('\n \t ....................... CUBE ...........................')
fprintf('\n \n');
demo_FTEST_cube;

diary off;

pause(5);

fprintf('\n \n');