
function demo_GRAM_QMC_cube

%--------------------------------------------------------------------------
% Object
%--------------------------------------------------------------------------
% Computation of Marcinkiewicz-Zygmund constants on the unit-cube [-1,1]^3
% for QMC rules based on Halton sets.
% 
% Setting the dimension "dim=2" the code works on the unit square [-1,1]^2.
%
% It performs all the tests and provide results.
%--------------------------------------------------------------------------
% Reference paper:
%--------------------------------------------------------------------------
% "On the role of weak Marcinkiewicz-Zygmund constants in polynomial 
% approximation by orthogonal bases"
% C. An, A. Sommariva and M. Vianello
%--------------------------------------------------------------------------
% License:
%--------------------------------------------------------------------------
% Copyright (C) 2025 Alvise Sommariva, Marco Vianello.
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
%
% Authors:
%
% Alvise Sommariva <alvise@math.unipd.it>
% Marco Vianello <marcov@math.unipd.it>
% Date: December 27, 2025
%--------------------------------------------------------------------------

mV=1:20;
nV=1:20;

dim=2;       % dimension cube





% ........................ main code below ................................

% bounding box
switch dim
    case 2
        dbox=[-1 -1; 1 1]; % unit-square [-1,1]^2
    case 3
        dbox=[-1 -1 -1; 1 1 1]; % unit-cube [-1,1]^3
end

% storage 

eta_mat=zeros(length(mV),length(nV));
cond_mat=zeros(length(mV),length(nV));
A_mat=zeros(length(mV),length(nV));
B_mat=zeros(length(mV),length(nV));

% numerical tests

for i=1:length(mV)
    m=mV(i);
    card=2.^m;
    rule=cub_cube_QMC(card,dbox,dim);
    for j=1:length(nV)
        n=nV(j);

        [eta_mat(i,j),G,~,A_mat(i,j),B_mat(i,j)]=...
            compute_MZ_constant_lowmemory(n,rule,dbox);

        cond_mat(i,j)=cond(G);

        fprintf('\n \t m: %-2.0f n: %-2.0f eta: %1.2e A: %1.2e B: %1.2e cond: %1.2e',...
            m,n,eta_mat(i,j),A_mat(i,j),B_mat(i,j),cond_mat(i,j));

    end
end


fprintf('\n \n');


