
function demo_MZ_QMC

%--------------------------------------------------------------------------
% Object
%--------------------------------------------------------------------------
% Computation of Marcinkiewicz-Zygmund constants on the unit-square.
% It performs all the tests and provide results.
%--------------------------------------------------------------------------
% Reference paper:
%--------------------------------------------------------------------------
% "On the role of weak Marcinkiewicz-Zygmund constants in polynomial 
% approximation by orthogonal bases"
% C. An, A. Sommariva and M. Vianello
%--------------------------------------------------------------------------
% License:
%--------------------------------------------------------------------------
% Copyright (C) 2025 Alvise Sommariva, Marco Vianello.
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
%
% Authors:
%
% Alvise Sommariva <alvise@math.unipd.it>
% Marco Vianello <marcov@math.unipd.it>
%
% Date: December 27, 2025
%--------------------------------------------------------------------------

clc;

save_fig=0;
save_tab=1;
show_stats=1;

domain_type=2; % 1: square, 2: cube.

diary diaryQMC.txt

switch domain_type

    case 1
        mV=1:20;
        nV=0:20;
        pset_typeV=5;
        demo_MZ_square(mV,nV,pset_typeV,show_stats,save_fig,save_tab);

    case 2
        mV=20;
        nV=1:18;
        pset_typeV=4;
        demo_MZ_cube(mV,nV,pset_typeV,show_stats,save_fig,save_tab);
end

diary off

fprintf('\n \t ...................................................... \t');