
function demo_MZ_batch
%--------------------------------------------------------------------------
% Object:
%--------------------------------------------------------------------------
% This demo performs numerical tests on interval, square, disk, simplex, 
% sphere as presented in the paper
%
% "On the role of weak Marcinkiewicz-Zygmund constants in polynomial 
% approximation by orthogonal bases".
%
% The approximation of MZ constants of some rules is considered.
%--------------------------------------------------------------------------
% Reference paper:
%--------------------------------------------------------------------------
% "On the role of weak Marcinkiewicz-Zygmund constants in polynomial 
% approximation by orthogonal bases"
% C. An, A. Sommariva and M. Vianello
%--------------------------------------------------------------------------
% License:
%--------------------------------------------------------------------------
% Copyright (C) 2025 Alvise Sommariva, Marco Vianello.
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
%
% Authors:
%
% Alvise Sommariva <alvise@math.unipd.it>
% Marco Vianello <marcov@math.unipd.it>
% Date: December 27, 2025
%--------------------------------------------------------------------------

warning off

mV=1:20; 
nV=0:30; 
show_stats=1;
save_fig=1;
save_tab=1;

str=replace(replace(replace(string(datetime),' ','_'),':','_'),'-','_');
diary(strcat('_test_',str,'.txt'));


fprintf('\n \t ....................... INTERVAL .........................')
fprintf('\n \n');
pts_typeV=1:2;
demo_MZ_interval(mV,nV,pts_typeV,show_stats,save_fig,save_tab);

fprintf('\n \t ........................ SQUARE ..........................')
fprintf('\n \n');
pts_typeV=1:4;
demo_MZ_square(mV,nV,pts_typeV,show_stats,save_fig,save_tab);

fprintf('\n \t ........................ DISK ............................')
fprintf('\n \n');
pts_typeV=1:2;
demo_MZ_disk(mV,nV,pts_typeV,show_stats,save_fig,save_tab);

fprintf('\n \t ....................... SIMPLEX ..........................')
fprintf('\n \n');
pts_typeV=1:2;
demo_MZ_simplex(mV,nV,pts_typeV,show_stats,save_fig,save_tab);

fprintf('\n \t ....................... SPHERE ...........................')
fprintf('\n \n');
pts_typeV=1:3;
demo_MZ_sphere(mV,nV,pts_typeV,show_stats,save_fig,save_tab);

diary off;

pause(5);