

function Torthn=legpolys_orthn(deg,x)

%--------------------------------------------------------------------------
% Object:
%--------------------------------------------------------------------------
% This routine computes the Legendre-Vandermonde matrix on the real line
% by recurrence.
% The polynomial is orthonormal w.r.t. Legendre measure.
%--------------------------------------------------------------------------
% Input:
%--------------------------------------------------------------------------
% deg: maximum polynomial degree
% x: 1-column array of abscissas
%--------------------------------------------------------------------------
% Output:
%--------------------------------------------------------------------------
% Torthn: orthonormal Legendre-Vandermonde matrix at "x". The dimension is
%               number of points x dimension polynomial space
%--------------------------------------------------------------------------
% Authors:
% Alvise Sommariva and Marco Vianello
% University of Padova, December 05, 2025
%--------------------------------------------------------------------------

% Determining classical Legendre polynomials.

T=ones(length(x),deg+1); % Initialize matrix. 

% degree 1
T(:,2)=x; 

% higher degrees
for k=2:deg
    n=k-1;
    T(:,k+1)=((2*n+1)/(n+1)).*x.*T(:,k)-(n/(n+1))*T(:,k-1);
end

% Determining orthonormal Legendre polynomials.
Torthn=zeros(length(x),deg+1);
for k=1:deg+1
    n=k-1;
    term=sqrt(2/(2*n+1));
    Torthn(:,k)=T(:,k)/term;
end



