
function plot_MZ_figures(mV,nV,MZ_mat,A_mat,B_mat,cond_mat,domain,...
    pset_type,save_fig)

%--------------------------------------------------------------------------
% Copyright (C) 2025 Alvise Sommariva, Marco Vianello.
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
%
% Authors:
%
% Alvise Sommariva <alvise@math.unipd.it>
% Marco Vianello <marcov@math.unipd.it>
%
% Date: December 23, 2025
%--------------------------------------------------------------------------

if nargin < 9, save_fig=1; end



figureV=[2 3];

for k=1:length(figureV)

    fig_k=figureV(k);

    h=figure(k);
    f1=ishandle(h)&&strcmp(get(h,'type'),'figure'); if f1,clf(k);end

    switch fig_k

        % ................ MZ constants plot ........................

        case 1

            [mV_mat,nV_mat]=meshgrid(mV,nV);
            surf(mV_mat,nV_mat,MZ_mat');
            hold on;
            xlabel('m'); ylabel('n'); zlabel('\eta_n');
            view(45, 30)
            hold off;

            if save_fig == 1
                filename=['figure_',domain,'_',num2str(pset_type)];
                file_fig=[filename '.fig'];
                savefig(file_fig);
                % file_eps=[filename '.eps'];
                % saveas(gca,file_eps,'epsc');

                foldername='FIGURES';

                if ~exist(foldername,'dir')
                    mkdir(foldername);
                end
                movefile(file_fig,foldername);
                % movefile(file_eps,foldername);

            end









            % ................ MZ constants contour ........................

        case 2

            [mV_mat,nV_mat]=meshgrid(mV,nV);


            switch pset_type

                case 1
                    switch domain
                        case 'interval'
                            title('Gauss-Legendre');
                            values=10.^[-12 0 1];
                        case 'disk'
                            title('Product rule');
                            values=10.^[-12 0 1];
                        case 'simplex'
                            title('Stroud conic rule');
                            values=10.^[-12 0 1];
                        case 'square'
                            title('Product rule');
                            values=10.^[-12 1];
                        case 'sphere'
                            title('Longitude-Latitude rule');
                            values=10.^[-12 0 1];
                        case 'cube'
                            title('Product rule');
                            values=10.^[-12 0 1];
                    end

                case 2
                    switch domain
                        case 'interval'
                            title('Clenshaw-Curtis');
                            values=10.^[-12 -1 0 1];
                        case 'disk'
                            title('Near minimal rule');
                            values=10.^[-12 0 1];
                        case 'simplex'
                            title('Near minimal rule');
                            values=10.^[-12 0 1];
                        case 'square'
                            title('Padua points');
                            values=10.^[-12 -1 0 1];
                        case 'sphere'
                            title('Spherical-Design');
                            values=10.^[-12 0 1];
                        case 'cube'
                            title('Morrow-Patterson Extended');
                            values=10.^[-12 0 1];
                    end

                case 3
                    switch domain
                        case 'interval'
                            title('Gauss-Legendre');
                            values=10.^[-12 0 1];
                        case 'disk'
                            title('Product rule');
                            values=10.^[-12 0 1];
                        case 'simplex'
                            title('Stroud conic rule');
                            values=10.^[-12 0 1];
                        case 'square'
                            title('Near minimal rule');
                            values=10.^[-12 0 1];
                        case 'sphere'
                            title('Symm.Spherical-Design');
                            values=10.^[-12 0 1];
                        case 'cube'
                            title('CC Product rule');
                            values=10.^[-12 0 1];
                    end

                case 4
                    switch domain
                        case 'interval'
                            title('Gauss-Legendre');
                            values=10.^[-12 0 1];
                        case 'disk'
                            title('Product rule');
                            values=10.^[-12 0 1];
                        case 'simplex'
                            title('Stroud conic rule');
                            values=10.^[-12 0 1];
                        case 'square'
                            title('MPX rule');
                            values=10.^[-12 0 1];
                        case 'sphere'
                            title('Longitude-Latitude rule');
                            values=10.^[-12 0 1];
                        case 'cube'
                            title('QMC rule');
                            values=10.^[-12 0 1];
                    end

                case 5
                    switch domain
                        case 'interval'
                            title('Gauss-Legendre');
                            values=10.^[-12 0 1];
                        case 'disk'
                            title('Product rule');
                            values=10.^[-12 0 1];
                        case 'simplex'
                            title('Stroud conic rule');
                            values=10.^[-12 0 1];
                        case 'square'
                            title('QMC rule');
                            values=10.^[-4 -3 -2 -1 log10(0.5) ...
                                log10(0.75) 0 1];
                        case 'sphere'
                            title('Longitude-Latitude rule');
                            values=10.^[-12 0 1];
                        case 'cube'
                            title('Product rule');
                            values=10.^[-12 0 1];
                    end
            end
            hold on;


            [C, h] = contour(mV_mat,nV_mat,MZ_mat',values, 'LineWidth', 0.5);
            h.LevelList = values;
            clabel(C, h, 'FontSize', 8, 'FontName', 'Arial');
            colormap(jet)
            xticks(mV)
            yticks(nV(1):2:nV(end))
            ax = get(gca,'XTickLabel');
            set(gca,'XTickLabel',ax,'FontName','Helvetica','fontsize',8)

            xlabel('m'); ylabel('n'); zlabel('\eta_n');
            grid on;

            hold off;

            if save_fig == 1
                filename=['figure_',domain,'_contour_',...
                    num2str(pset_type),'_',num2str(max(mV)),...
                    '_',num2str(max(nV))];

                file_fig=[filename '.fig'];
                savefig(file_fig);
                % file_eps=[filename '.eps'];
                % saveas(gca,file_eps,'epsc');

                foldername='FIGURES';

                if ~exist(foldername,'dir')
                    mkdir(foldername);
                end
                movefile(file_fig,foldername);
                % movefile(file_eps,foldername);
            end









            % ................ conditioning ........................

        case 3


            [mV_mat,nV_mat]=meshgrid(mV,nV);


            switch pset_type

                case 1
                    switch domain
                        case 'interval'
                            title({'Cond. Gauss-Legendre';'';' '});
                            values=[5 1000];
                        case 'disk'
                            title({'Cond. Product rule';'';' '});
                            values=[5 1000];
                        case 'simplex'
                            title({'Cond. Stroud conic rule';'';' '});
                            values=[5 1000];
                        case 'square'
                            title({'Cond. Product rule';'';' '});
                            values=[5 1000];
                        case 'sphere'
                            title({'Cond. Longitude-Latitude rule';'';' '});
                            values=[5 1000];
                        case 'cube'
                            title({'Cond. Product rule';'';' '});
                            values=[5 1000];
                    end

                case 2
                    switch domain
                        case 'interval'
                            title({'Cond. Clenshaw-Curtis';'';' '});
                            values=[1+10^(-11) 7 1000];
                        case 'disk'
                            title({'Cond. Near minimal rule';'';' '});
                            values=[5 1000];
                        case 'simplex'
                            title({'Cond. Near minimal rule';'';' '});
                            values=[5 1000];
                        case 'square'
                            title({'Cond. Padua points';'';' '});
                            values=[1+10^(-11) 5 1000];
                        case 'sphere'
                            title({'Cond. Spherical-Design';'';' '});
                            values=[5 1000];
                        case 'cube'
                    end

                case 3
                    switch domain
                        case 'interval'
                            title({'Cond. Gauss-Legendre';'';' '});
                            values=[5 1000];
                        case 'disk'
                            title({'Cond. Product rule';'';' '});
                            values=[5 1000];
                        case 'simplex'
                            title({'Cond. Stroud conic rule';'';' '});
                            values=[5 1000];
                        case 'square'
                            title({'Cond. Near minimal rule';'';' '});
                            values=[5 1000];
                        case 'sphere'
                            title({'Cond. Symm.Spherical-Design';'';' '});
                            values=[5 1000];
                        case 'cube'
                            title({'Cond. Product rule';'';' '});
                            values=[5 1000];
                    end

                case 4
                    switch domain
                        case 'interval'
                            title({'Cond. Gauss-Legendre';'';' '});
                            values=[5 1000];
                        case 'disk'
                            title({'Cond. Product rule';'';' '});
                            values=[5 1000];
                        case 'simplex'
                            title({'Cond. Stroud conic rule';'';' '});
                            values=[5 1000];
                        case 'square'
                            title({'Cond. MPX rule';'';' '});
                            values=[5 1000];
                        case 'sphere'
                            title({'Cond. Longitude-Latitude rule';'';' '});
                            values=[5 1000];
                        case 'cube'
                            title({'Cond. QMC rule cube';'';' '});
                            values=[5 1000];
                    end


                case 5
                    switch domain
                        case 'interval'
                            title({'Cond. Gauss-Legendre';'';' '});
                            values=[5 1000];
                        case 'disk'
                             title({'Cond. Product rule';'';' '});
                            values=[5 1000];
                        case 'simplex'
                             title({'Cond. Stroud conic rule';'';' '});
                            values=[5 1000];
                        case 'square'
                             title({'Cond. QMC rule square';'';' '});
                            values=[1 1.25 1.5 2 5 10 100 1000];
                        case 'sphere'
                             title({'Cond. Longitude-Latitude rule';'';' '});
                            values=[5 1000];
                        case 'cube'
                             title({'Cond. Product rule';'';' '});
                            values=[5 1000];
                    end

            end

            plot_method=5;

            switch plot_method
                case 1
                    hold on;
                    [C, h] = contour(mV_mat,nV_mat,cond_mat',values,...
                        'LineWidth', 0.5);
                    h.LevelList = values;
                    clabel(C, h, 'FontSize', 7, 'FontName', 'Helvetica');
                    colormap(jet)
                    xticks(mV)
                    yticks(nV(1):2:nV(end))
                    ax = get(gca,'XTickLabel');
                    set(gca,'XTickLabel',ax,'FontName',...
                        'Helvetica','fontsize',7)
                    xlabel('m'); ylabel('n'); zlabel('log(cond_2(G))')

                    grid on;

                case 2
                    hold on;
                    xticks(mV(1):mV(end))
                    yticks(nV(1):2:nV(end))
                    zticks([0 1 10 20])
                    zlim([0 20])

                    ax = gca;

                    ang=0;

                    ax.XTickLabelRotation = ang;
                    ax.YTickLabelRotation = ang;
                    ax.ZTickLabelRotation = ang;
                    grid on
                    plot3(mV_mat,nV_mat,min(log10(cond_mat'),20))
                    xlabel('m'); ylabel('n'); zlabel('log_{10}(cond_2(G))')

                    ax = get(gca,'XTickLabel');
                    set(gca,'XTickLabel',ax,'FontName','Helvetica','fontsize',8)
                    xlabel('m'); ylabel('n'); zlabel('log(cond_2(G))')

                    view(30, 45)

                    hold off;

                case 3
                    hold on;
                    grid on;

                    xticks(mV)
                    yticks(nV(1):2:nV(end))
                    set(gca,'XTickLabel',ax,'FontName','Helvetica','fontsize',7)
                    ax = gca;

                    ang=0;

                    ax.XTickLabelRotation = ang;
                    ax.YTickLabelRotation = ang;
                    ax.ZTickLabelRotation = ang;

                    xlabel('m'); ylabel('n');



                    imagesc(cond_mat',[0 192]); colormap sky; axis equal;axis tight

                case 4

                    hold on;
                    grid on;
                    xticks(mV)
                    yticks(nV(1):2:nV(end))
                    colormap sky
                    [mV_mat,nV_mat]=meshgrid(mV,nV);
                    surf(mV_mat,nV_mat,log(cond_mat'));
                    hold on;
                    xlabel('m'); ylabel('n'); zlabel('cond(G)');
                    view(2)
                    hold off;

                case 5

                    hold on;
                    grid on;

                    % plot
                    val_mat=cond_mat;
                    markerval=4;

                    for i=1:length(mV)
                        m=mV(i);
                        for j=1:length(nV)
                            n=nV(j);

                            % number from 0 to 18
                            val=min(log10(val_mat(i,j)),18);
                            % val_red=ceil(255*(val/18));
                            % val_green=255-val_red;
                            % color_dot=[val_red val_green 0]/255;

                            color_dot='k';

                            if val < 1
                                color_dot='g';
                            end

                            if val >= 1 && val < 2
                                color_dot='y';
                            end

                            if val >= 2 && val < 4
                                color_dot=[255,140,0]/255;
                            end

                            if val >= 4 && val < 7
                                color_dot='m';
                            end
                            


                            plot(m,n,'o','MarkerSize',markerval,...
                                'MarkerEdgeColor',color_dot,...
                                'MarkerFaceColor',color_dot);

                            hold on;

                        end
                    end

                    % ticks
                    xticks(mV); yticks(nV(1):2:nV(end));

                    ax = gca;
                    set(gca,'FontName','Helvetica','fontsize',7)

                    ang=0;

                    ax.XTickLabelRotation = ang;
                    ax.YTickLabelRotation = ang;
                    ax.ZTickLabelRotation = ang;


                    xlabel('m'); ylabel('n');
                    view(2)
                    hold off;

                case 6


                    % hold on;

                    %
                    % plot
                    val_mat=cond_mat;

                    for i=1:length(mV)
                        m=mV(i);
                        for j=1:length(nV)
                            n=nV(j);
                            plot(m,n,'w.')
                            hold on;
                            % text(m,n,num2str(val));
                        end
                    end

                    for i=1:length(mV)
                        m=mV(i);
                        for j=1:length(nV)
                            n=nV(j);
                            val=floor(log10(val_mat(i,j)));


                            t=text(m,n,num2str(val,'%2.0f'));
                            t.FontSize = 7;

                            hold on;
                        end
                    end

                    % ticks

                    %ax = gca;
                     set(gca,'FontName','Helvetica','fontsize',7)
                    %
                    % % number angles
                    % ang=0;
                    % ax.XTickLabelRotation = ang;
                    % ax.YTickLabelRotation = ang;
                    % ax.ZTickLabelRotation = ang;

                    % grid on;

                    xlabel('m'); ylabel('n');

                    xticks(mV); yticks(nV);
                    xlim([min(mV)-1,max(mV)+1]);
                    ylim([min(nV)-1,max(nV)+1]);

                    hold off;


            end


            if save_fig == 1

                filename=['figure_',domain,'_cond_',...
                    num2str(pset_type),'_',num2str(max(mV)),...
                    '_',num2str(max(nV)),'_',num2str(plot_method)];
                file_fig=[filename '.fig'];
                savefig(file_fig);
                % file_eps=[filename '.eps'];
                % saveas(gca,file_eps,'epsc');

                foldername='FIGURES';

                if ~exist(foldername,'dir')
                    mkdir(foldername);
                end
                movefile(file_fig,foldername);
                % movefile(file_eps,foldername);

            end









        case 4

            % ................ MZ constants contour ........................


            [mV_mat,nV_mat]=meshgrid(mV,nV);


            switch pset_type

                case 1
                    switch domain
                        case 'interval'
                            title_str='Gauss-Legendre';
                        case 'disk'
                            title_str='Product rule';
                        case 'simplex'
                            title_str='Stroud conic rule';
                        case 'square'
                            title_str='Product rule';
                        case 'sphere'
                            title_str='Longitude-Latitude rule';
                        case 'cube'
                            title_str='Product rule';
                    end

                case 2
                    switch domain
                        case 'interval'
                            title_str='Clenshaw-Curtis';
                        case 'disk'
                            title_str='Near minimal rule';
                        case 'simplex'
                            title_str='Near minimal rule';
                        case 'square'
                            title_str='Padua points';
                        case 'sphere'
                            title_str='Spherical-Design';
                        case 'cube'
                    end

                case 3
                    switch domain
                        case 'interval'
                            title_str='Gauss-Legendre';
                        case 'disk'
                            title_str='Product rule';
                        case 'simplex'
                            title_str='Stroud conic rule';
                        case 'square'
                            title_str='Near minimal rule';
                        case 'sphere'
                            title_str='Symm.Spherical-Design';
                        case 'cube'
                            title_str='Product rule';
                    end

                case 4
                    switch domain
                        case 'interval'
                            title_str='Gauss-Legendre';
                        case 'disk'
                            title_str='Product rule';
                        case 'simplex'
                            title_str='Stroud conic rule';
                        case 'square'
                            title_str='MPX rule';
                        case 'sphere'
                            title_str='Longitude-Latitude rule';
                        case 'cube'
                            title_str='Product rule';
                    end

            end



            MZ_mat=MZ_mat';
            legend_arg=[];
            s=1;
            for kk=2:2:length(mV)
                mL=mV_mat(1,kk);
                NL=nV_mat(:,kk);
                MZL=MZ_mat(:,kk);
                semilogy(NL,MZL,'-');
                hold on;
                legend_arg{s}=num2str(mL);
                s=s+1;
            end
            xticks(nV(1):2:nV(end))
            grid on;
            colororder("gem12")
            legend(legend_arg)
            legend('Location','southeast')
            ylim([10^(-16) 10]);
            title(title_str)
            xlabel('n'); ylabel('\eta_n');
            hold off;

            if save_fig == 1
                filename=['figure_',domain,'_dual_',...
                    num2str(pset_type),'_',num2str(max(mV)),...
                    '_',num2str(max(nV))];
                file_fig=[filename '.fig'];
                savefig(file_fig);
                % file_eps=[filename '.eps'];
                % saveas(gca,file_eps,'epsc');

                foldername='FIGURES';

                if ~exist(foldername,'dir')
                    mkdir(foldername);
                end
                movefile(file_fig,foldername);
                % movefile(file_eps,foldername);
            end

    end

end
