
function table_data=print_MZ_statistics(mV,nV,MZ_mat,show_stats)

%--------------------------------------------------------------------------
% Object
%--------------------------------------------------------------------------
% This routine, given the algebraic degree of exactness "mV", the
% polynomial degrees "nV" and a matrix "MZ_mat" such that "MZ_mat(i,j)" is
% the "eta constant" for "mV(i)" and "nV(i)", show some stats useful for
% LaTex sources.
%--------------------------------------------------------------------------
% License:
%--------------------------------------------------------------------------
% Copyright (C) 2025 Alvise Sommariva, Marco Vianello.
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
%
% Authors:
%
% Alvise Sommariva <alvise@math.unipd.it>
% Marco Vianello <marcov@math.unipd.it>
%
% Date: December 23, 2025
%--------------------------------------------------------------------------

tol(1)=10^(-12); tol(2)=10^(-2); tol(3)=1-10^(-12); tol(4)=10;

table_data=zeros(length(mV),5);

for i=1:length(mV)
    m=mV(i);
    MZm=MZ_mat(i,:);

    % max index for which the MZ costant is inferior than tol(j)
    nmax=zeros(1,length(tol));
    for k=1:length(tol)
        iok=(MZm < tol(k));
        if sum(iok) > 0
            nmax(1,k)=max(nV(iok));
        else
            nmax(1,k)=0;
        end
    end

    table_data(i,:)=[m nmax];

end

if show_stats
    fprintf('\n \t |  m  | e-12 | e-2 | e+0  | e+1 |');
    fprintf('\n \t ..................................');
    for i=1:length(mV)
        fprintf('\n \t    %-2.0f &  %-2.0f &  %-2.0f  &  %-2.0f  &  %-2.0f &&',...
            table_data(i,1),table_data(i,2),table_data(i,3),...
            table_data(i,4),table_data(i,5));
    end

    fprintf('\n');
end