(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   5638579,     102811]*)
(*NotebookOutlinePosition[   5640724,     102877]*)
(*  CellTagsIndexPosition[   5640614,     102870]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Time-frequency analysis: Gabor frame theory", "Title",
  TextAlignment->Center],

Cell[TextData[{
  "This ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4. notebook has been realized by Massimo Fornasier (email: \
mfornasi@math.unipd.it), working at NuHAG (Numerical Harmonic Analysis \
Group), Department of Mathematics, University of Vienna, AUSTRIA.\n\nCreated \
essentially for didactical purposes (and not for research), it can be freely \
used and modified for teaching activity.\nPrerequisites for working with this \
notebook are some knowledge of\n\n- Fourier analysis on ",
  Cell[BoxData[
      \(TraditionalForm\`R\^d\)]],
  "and ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(Z\_n\)\(,\)\(\ \)\(FFT\)\(,\)\(convolutions\)\(\ \
\)\)\)]],
  "\n- frame theory, SVD, pseudo inverse, CG and PCG algorithms for numerical \
inversion of matrices\n\nA prior knowledge of basic discrete Gabor frames and \
circulant matrices can be helpful.\n\nA PC with at least 128 Mb RAM and 1GHz \
clock frequency is expected for quick executions.\n\n\t\t\t\t\t\t\t\t\t\t\t\t\
\t\t\tCo. mfornasi@NuHAG\n\nWien, 18th January 2003"
}], "Subsubtitle"],

Cell["\<\
The Gaussian is the best example of Gabor atom which generates \
Gabor frames of the type Exp[2 Pi I b m)]g[t-a n] for any a,b>0 such that a b \
<1. \
\>", "Subsubsection"],

Cell[BoxData[
    \(g[x_] := Exp[\(-\ Pi\)\ x^2]\)], "Input",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[g[x], {x, \(-2\), 2}, PlotRange \[Rule] All];\)\)], "Input",
  InitializationCell->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.014713 0.588616 [
[.02381 .00221 -6 -9 ]
[.02381 .00221 6 0 ]
[.2619 .00221 -6 -9 ]
[.2619 .00221 6 0 ]
[.7381 .00221 -3 -9 ]
[.7381 .00221 3 0 ]
[.97619 .00221 -3 -9 ]
[.97619 .00221 3 0 ]
[.4875 .13244 -18 -4.5 ]
[.4875 .13244 0 4.5 ]
[.4875 .25016 -18 -4.5 ]
[.4875 .25016 0 4.5 ]
[.4875 .36788 -18 -4.5 ]
[.4875 .36788 0 4.5 ]
[.4875 .48561 -18 -4.5 ]
[.4875 .48561 0 4.5 ]
[.4875 .60333 -6 -4.5 ]
[.4875 .60333 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .01471 m
.02381 .02096 L
s
[(-2)] .02381 .00221 0 1 Mshowa
.2619 .01471 m
.2619 .02096 L
s
[(-1)] .2619 .00221 0 1 Mshowa
.7381 .01471 m
.7381 .02096 L
s
[(1)] .7381 .00221 0 1 Mshowa
.97619 .01471 m
.97619 .02096 L
s
[(2)] .97619 .00221 0 1 Mshowa
.125 Mabswid
.07143 .01471 m
.07143 .01846 L
s
.11905 .01471 m
.11905 .01846 L
s
.16667 .01471 m
.16667 .01846 L
s
.21429 .01471 m
.21429 .01846 L
s
.30952 .01471 m
.30952 .01846 L
s
.35714 .01471 m
.35714 .01846 L
s
.40476 .01471 m
.40476 .01846 L
s
.45238 .01471 m
.45238 .01846 L
s
.54762 .01471 m
.54762 .01846 L
s
.59524 .01471 m
.59524 .01846 L
s
.64286 .01471 m
.64286 .01846 L
s
.69048 .01471 m
.69048 .01846 L
s
.78571 .01471 m
.78571 .01846 L
s
.83333 .01471 m
.83333 .01846 L
s
.88095 .01471 m
.88095 .01846 L
s
.92857 .01471 m
.92857 .01846 L
s
.25 Mabswid
0 .01471 m
1 .01471 L
s
.5 .13244 m
.50625 .13244 L
s
[(0.2)] .4875 .13244 1 0 Mshowa
.5 .25016 m
.50625 .25016 L
s
[(0.4)] .4875 .25016 1 0 Mshowa
.5 .36788 m
.50625 .36788 L
s
[(0.6)] .4875 .36788 1 0 Mshowa
.5 .48561 m
.50625 .48561 L
s
[(0.8)] .4875 .48561 1 0 Mshowa
.5 .60333 m
.50625 .60333 L
s
[(1)] .4875 .60333 1 0 Mshowa
.125 Mabswid
.5 .04414 m
.50375 .04414 L
s
.5 .07357 m
.50375 .07357 L
s
.5 .10301 m
.50375 .10301 L
s
.5 .16187 m
.50375 .16187 L
s
.5 .1913 m
.50375 .1913 L
s
.5 .22073 m
.50375 .22073 L
s
.5 .27959 m
.50375 .27959 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33845 m
.50375 .33845 L
s
.5 .39731 m
.50375 .39731 L
s
.5 .42674 m
.50375 .42674 L
s
.5 .45618 m
.50375 .45618 L
s
.5 .51504 m
.50375 .51504 L
s
.5 .54447 m
.50375 .54447 L
s
.5 .5739 m
.50375 .5739 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
.5 Mabswid
.02381 .01472 m
.02846 .01472 L
.03279 .01472 L
.03754 .01472 L
.04262 .01472 L
.04795 .01472 L
.053 .01472 L
.06244 .01473 L
.06754 .01473 L
.07295 .01474 L
.08265 .01475 L
.08804 .01476 L
.09308 .01477 L
.09862 .01479 L
.10458 .01481 L
.11468 .01487 L
.1204 .01491 L
.12571 .01496 L
.13544 .01509 L
.14087 .01518 L
.1458 .01528 L
.15583 .01554 L
.16505 .01589 L
.17517 .01641 L
.18587 .0172 L
.19535 .01815 L
.20551 .01953 L
.2151 .02126 L
.22384 .02331 L
.23376 .02629 L
.24293 .02982 L
.25299 .03473 L
.26369 .04137 L
.27306 .04862 L
.28316 .05818 L
.30144 .08092 L
.32148 .11536 L
.34258 .16379 L
.38069 .28215 L
.42125 .43213 L
.43998 .49682 L
.46029 .55408 L
.4714 .57724 L
.47627 .58525 L
.48164 .59243 L
.48408 .59512 L
.4867 .59758 L
.48896 .59937 L
.49143 .60094 L
.49287 .60167 L
Mistroke
.49421 .60223 L
.49548 .60266 L
.49614 .60284 L
.49684 .603 L
.49754 .60313 L
.49818 .60322 L
.49944 .60332 L
.50058 .60332 L
.50179 .60322 L
.50302 .60303 L
.50371 .60288 L
.50435 .60271 L
.50676 .60184 L
.50896 .60071 L
.51129 .59918 L
.51613 .5949 L
.52147 .58849 L
.53094 .57292 L
.53981 .55383 L
.56004 .49675 L
.57855 .43285 L
.61823 .28598 L
.65639 .16648 L
.67604 .12039 L
.697 .08322 L
.70727 .06914 L
.71839 .05659 L
.728 .04773 L
.73855 .03984 L
.74816 .03411 L
.75847 .02923 L
.76935 .02527 L
.77953 .02246 L
.78968 .02034 L
.80074 .01863 L
.81118 .01746 L
.82085 .01667 L
.83046 .0161 L
.8395 .0157 L
.8494 .01539 L
.85497 .01526 L
.86009 .01516 L
.86482 .01508 L
.86988 .01501 L
.87899 .01492 L
.88456 .01488 L
.88983 .01484 L
.89452 .01482 L
.89968 .0148 L
.90939 .01477 L
Mistroke
.9147 .01476 L
.91967 .01475 L
.92856 .01474 L
.93355 .01473 L
.93811 .01473 L
.94269 .01472 L
.94756 .01472 L
.95632 .01472 L
.96169 .01472 L
.96675 .01472 L
.97128 .01472 L
.97619 .01472 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  InitializationCell->True,
  ImageSize->{288, 177.938},
  ImageMargins->{{281, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40n007h00Ooooo8Ooo003ooolQ
ool000ooo`@003coo`@007_oo`@003coo`@000koo`003ooo00<00?ooool0?ooo00<00?ooool0O?oo
00<00?ooool0>ooo00<00?ooool03ooo000@ool00`00ooooo`0nool00`00ooooo`1lool00`00oooo
o`0lool00`00ooooo`0>ool000Woo`@000Coo`03003ooooo03Goo`@000Coo`03003ooooo07coo`03
003ooooo03goo`03003ooooo00goo`004_oo00<00?ooool0??oo00<00?ooool0O?oo00<00?ooool0
?_oo00<00?ooool03?oo000?ool01000ooooo`00??oo0`00O?oo0`00?Ooo00@00?ooool000koo`00
4?oo0P00?ooo00<00?ooool0>ooo00<00?ooool0?_oo00<00?ooool0??oo0P003ooo002?ool00`00
ooooo`2>ool008ooo`03003ooooo08koo`00Sooo00<00?ooool0S_oo0007oooo000B0008ool000ko
o`03003ooooo00Woo`03003ooooo00[oo`03003ooooo00[oo`03003ooooo00;oo`T000coo`03003o
oooo00[oo`03003ooooo00[oo`03003ooooo00[oo`03003ooooo00[oo`03003ooooo00[oo`03003o
oooo00[oo`03003ooooo00[oo`03003ooooo00[oo`03003ooooo00[oo`03003ooooo00[oo`03003o
oooo00[oo`P000Goo`03003ooooo00[oo`03003ooooo00[oo`03003ooooo00Woo`03003ooooo00go
o`003_oo00<00?ooool0<?oo1@002?oo00<00?ooool0?_oo00<00?ooool0?_oo00<00?ooool01ooo
0`00<ooo00<00?ooool03Ooo0016ool20017ool00`00ooooo`15ool30016ool004Soo`<004Coo`03
003ooooo04;oo`<004Woo`00Booo0P00@_oo00<00?ooool0@?oo0P00C?oo001=ool20010ool00`00
ooooo`0oool00`00ooooo`1<ool004ooo`03003ooooo03goo`03003ooooo03koo`03003ooooo04go
o`00D?oo00<00?ooool0??oo0P00?Ooo0P00D?oo001Aool00`00ooooo`0kool00`00ooooo`0kool0
0`00ooooo`1@ool005;oo`03003ooooo03[oo`03003ooooo03Woo`8005?oo`00Dooo00<00?ooool0
>Ooo00<00?ooool0>?oo00<00?ooool0Dooo001Dool00`00ooooo`0hool00`00ooooo`0gool00`00
ooooo`1Dool005Goo`03003ooooo03Ooo`03003ooooo03Ooo`03003ooooo05Coo`00E_oo00<00?oo
ool0=_oo00<00?ooool0=_oo00<00?ooool0EOoo001Fool00`00ooooo`0fool00`00ooooo`0eool0
0`00ooooo`1Fool005Ooo`03003ooooo03Goo`8003Koo`03003ooooo05Koo`00F?oo00<00?ooool0
=?oo00<00?ooool0=?oo00<00?ooool0Eooo001Iool00`00ooooo`0cool00`00ooooo`0dool00`00
ooooo`1Gool005[oo`03003ooooo03;oo`03003ooooo03?oo`03003ooooo05Soo`00F_oo00<00?oo
ool0<_oo00<00?ooool0<_oo00<00?ooool0FOoo001Kool00`00ooooo`0aool00`00ooooo`0bool0
0`00ooooo`1Iool005_oo`03003ooooo037oo`03003ooooo037oo`03003ooooo05[oo`00G?oo00<0
0?ooool0<?oo00<00?ooool0<Ooo00<00?ooool0F_oo001Lool00`00ooooo`0`ool2000aool00`00
ooooo`1Kool005goo`03003ooooo02ooo`03003ooooo02ooo`03003ooooo05coo`00GOoo00<00?oo
ool0;ooo00<00?ooool0;ooo00<00?ooool0G?oo001Nool00`00ooooo`0^ool00`00ooooo`0^ool0
0`00ooooo`1Mool005koo`03003ooooo02koo`03003ooooo02koo`03003ooooo05goo`00Gooo00<0
0?ooool0;Ooo00<00?ooool0;Ooo00<00?ooool0G_oo001Oool00`00ooooo`0Jool20004ool00`00
ooooo`02ool40004ool00`00ooooo`0]ool00`00ooooo`1Nool0063oo`03003ooooo01Soo`04003o
oooo0008ool00`00ooooo`05ool00`00ooooo`0/ool00`00ooooo`1Oool0063oo`03003ooooo01So
o`04003ooooo0009ool00`00ooooo`04ool3000/ool00`00ooooo`1Oool0067oo`03003ooooo01Oo
o`04003ooooo000:ool00`00ooooo`03ool00`00ooooo`0[ool00`00ooooo`1Pool0067oo`03003o
oooo01Ooo`04003ooooo000;ool00`00ooooo`02ool00`00ooooo`0[ool00`00ooooo`1Pool006;o
o`03003ooooo01Koo`04003ooooo0008ool01000ooooo`001?oo00<00?ooool0:ooo00<00?ooool0
H?oo001Rool00`00ooooo`0Gool2000:ool20005ool00`00ooooo`0Zool00`00ooooo`1Qool006?o
o`03003ooooo02Woo`03003ooooo02[oo`03003ooooo067oo`00Hooo00<00?ooool0:Ooo00<00?oo
ool0:Ooo00<00?ooool0H_oo001Tool00`00ooooo`0Xool00`00ooooo`0Yool00`00ooooo`1Rool0
06Coo`03003ooooo02Soo`8002Woo`03003ooooo06?oo`00I?oo00<00?ooool0:?oo00<00?ooool0
:?oo00<00?ooool0Hooo001Uool00`00ooooo`0Wool00`00ooooo`0Xool00`00ooooo`1Sool006Go
o`03003ooooo02Ooo`03003ooooo02Ooo`03003ooooo06Coo`00IOoo00<00?ooool09ooo00<00?oo
ool09ooo00<00?ooool0I?oo001Vool00`00ooooo`0Vool00`00ooooo`0Wool00`00ooooo`1Tool0
06Koo`03003ooooo02Koo`03003ooooo02Koo`03003ooooo06Goo`00I_oo00<00?ooool09_oo00<0
0?ooool09_oo00<00?ooool0IOoo001Wool00`00ooooo`0Uool2000Wool00`00ooooo`1Uool006Oo
o`03003ooooo02Goo`03003ooooo02Goo`03003ooooo06Koo`00Iooo00<00?ooool09Ooo00<00?oo
ool09Ooo00<00?ooool0I_oo001Xool00`00ooooo`0Tool00`00ooooo`0Uool00`00ooooo`1Vool0
06Soo`03003ooooo02Coo`03003ooooo02Coo`03003ooooo06Ooo`00J?oo00<00?ooool09?oo00<0
0?ooool09?oo00<00?ooool0Iooo001Yool00`00ooooo`0Sool00`00ooooo`0Tool00`00ooooo`1W
ool006Woo`03003ooooo02?oo`03003ooooo02?oo`03003ooooo06Soo`00JOoo00<00?ooool08ooo
0P009?oo00<00?ooool0J?oo001Zool00`00ooooo`0Rool00`00ooooo`0Sool00`00ooooo`1Xool0
06[oo`03003ooooo02;oo`03003ooooo02;oo`03003ooooo06Woo`00J_oo00<00?ooool08_oo00<0
0?ooool08_oo00<00?ooool0JOoo001[ool00`00ooooo`0Qool00`00ooooo`0Rool00`00ooooo`1Y
ool006_oo`03003ooooo027oo`03003ooooo027oo`03003ooooo06[oo`00Jooo00<00?ooool03_oo
0P001?oo00<00?ooool01?oo00<00?ooool00ooo00<00?ooool08Ooo00<00?ooool0J_oo001/ool0
0`00ooooo`0<ool01000ooooo`002_oo00<00?ooool00ooo00<00?ooool08Ooo00<00?ooool0J_oo
001/ool00`00ooooo`0<ool01000ooooo`001ooo1@001?oo0`008?oo00<00?ooool0Jooo001/ool0
0`00ooooo`0<ool01000ooooo`001ooo00@00?ooool000Goo`03003ooooo023oo`03003ooooo06_o
o`00KOoo00<00?ooool02ooo00@00?ooool000Soo`03003oo`0000Goo`03003ooooo023oo`03003o
oooo06_oo`00KOoo00<00?ooool02ooo00@00?ooool000Woo`8000Goo`03003ooooo01ooo`03003o
oooo06coo`00KOoo00<00?ooool03?oo0P002ooo00<00?ooool00ooo00<00?ooool07ooo00<00?oo
ool0K?oo001^ool00`00ooooo`0Nool00`00ooooo`0Oool00`00ooooo`1/ool006koo`03003ooooo
01koo`03003ooooo01koo`03003ooooo06goo`00K_oo00<00?ooool07_oo00<00?ooool07_oo00<0
0?ooool0KOoo001_ool00`00ooooo`0Mool2000Oool00`00ooooo`1]ool006ooo`03003ooooo01go
o`03003ooooo01goo`03003ooooo06koo`00Kooo00<00?ooool07Ooo00<00?ooool07Ooo00<00?oo
ool0K_oo001`ool00`00ooooo`0Lool00`00ooooo`0Mool00`00ooooo`1^ool0073oo`03003ooooo
01coo`03003ooooo01coo`03003ooooo06ooo`00L?oo00<00?ooool07?oo00<00?ooool07?oo00<0
0?ooool0Kooo001`ool00`00ooooo`0Lool00`00ooooo`0Lool00`00ooooo`1_ool0077oo`03003o
oooo01_oo`03003ooooo01coo`03003ooooo06ooo`00LOoo00<00?ooool06ooo0P007?oo00<00?oo
ool0L?oo001aool00`00ooooo`0Kool00`00ooooo`0Kool00`00ooooo`1`ool0077oo`03003ooooo
01_oo`03003ooooo01_oo`03003ooooo073oo`00L_oo00<00?ooool06_oo00<00?ooool06ooo00<0
0?ooool0L?oo001bool00`00ooooo`0Jool00`00ooooo`0Jool00`00ooooo`1aool007;oo`03003o
oooo01[oo`03003ooooo01[oo`03003ooooo077oo`00Looo00<00?ooool06Ooo00<00?ooool06_oo
00<00?ooool0LOoo001cool00`00ooooo`0Iool00`00ooooo`0Iool00`00ooooo`1bool007?oo`03
003ooooo01Woo`8001[oo`03003ooooo07;oo`00Looo00<00?ooool06Ooo00<00?ooool06Ooo00<0
0?ooool0L_oo001dool00`00ooooo`0Hool00`00ooooo`0Iool00`00ooooo`1bool007Coo`03003o
oooo01Soo`03003ooooo01Soo`03003ooooo07?oo`00M?oo00<00?ooool06?oo00<00?ooool06?oo
00<00?ooool0Looo001dool00`00ooooo`0Hool00`00ooooo`0Hool00`00ooooo`1cool007Goo`03
003ooooo00Coo`8000Coo`03003ooooo00?oo`8000Goo`03003ooooo01Soo`03003ooooo07?oo`00
MOoo00<00?ooool00ooo00@00?ooool000Soo`04003ooooo0004ool00`00ooooo`0Gool00`00oooo
o`1dool007Goo`03003ooooo00?oo`04003ooooo0008ool01000ooooo`001?oo0`005ooo00<00?oo
ool0M?oo001fool00`00ooooo`02ool01000ooooo`002?oo0`001Ooo00<00?ooool05ooo00<00?oo
ool0M?oo001fool00`00ooooo`02ool01000ooooo`002?oo00<00?ooool01Ooo00<00?ooool05_oo
00<00?ooool0MOoo001fool00`00ooooo`02ool01000ooooo`002?oo00<00?ooool01Ooo00<00?oo
ool05_oo00<00?ooool0MOoo001fool00`00ooooo`03ool2000:ool30004ool00`00ooooo`0Fool0
0`00ooooo`1eool007Ooo`03003ooooo01Goo`03003ooooo01Koo`03003ooooo07Goo`00Mooo00<0
0?ooool05Ooo00<00?ooool05Ooo00<00?ooool0M_oo001gool00`00ooooo`0Eool00`00ooooo`0E
ool00`00ooooo`1fool007Soo`03003ooooo01Coo`8001Koo`03003ooooo07Koo`00N?oo00<00?oo
ool05?oo00<00?ooool05?oo00<00?ooool0Mooo001hool00`00ooooo`0Dool00`00ooooo`0Dool0
0`00ooooo`1gool007Soo`03003ooooo01Coo`03003ooooo01Coo`03003ooooo07Ooo`00NOoo00<0
0?ooool04ooo00<00?ooool05?oo00<00?ooool0Mooo001iool00`00ooooo`0Cool00`00ooooo`0C
ool00`00ooooo`1hool007Woo`03003ooooo01?oo`03003ooooo01?oo`03003ooooo07Soo`00NOoo
00<00?ooool04ooo00<00?ooool04ooo00<00?ooool0N?oo001jool00`00ooooo`0Bool2000Dool0
0`00ooooo`1hool007[oo`03003ooooo01;oo`03003ooooo01;oo`03003ooooo07Woo`00N_oo00<0
0?ooool04_oo00<00?ooool04_oo00<00?ooool0NOoo001kool00`00ooooo`0Aool00`00ooooo`0B
ool00`00ooooo`1iool007_oo`03003ooooo017oo`03003ooooo017oo`03003ooooo07[oo`00Nooo
00<00?ooool04Ooo00<00?ooool04Ooo00<00?ooool0N_oo001kool00`00ooooo`0Aool00`00oooo
o`0Aool00`00ooooo`1jool007coo`03003ooooo013oo`03003ooooo017oo`03003ooooo07[oo`00
O?oo00<00?ooool04?oo0P004Ooo00<00?ooool0Nooo001lool00`00ooooo`0@ool00`00ooooo`0@
ool00`00ooooo`1kool007coo`03003ooooo013oo`03003ooooo013oo`03003ooooo07_oo`00OOoo
00<00?ooool03ooo00<00?ooool03ooo00<00?ooool0O?oo001mool00`00ooooo`0?ool00`00oooo
o`0?ool00`00ooooo`1lool007goo`03003ooooo00ooo`03003ooooo00ooo`03003ooooo07coo`00
O?oo0`000ooo00<00?ooool00ooo0P001Ooo00<00?ooool03_oo00<00?ooool0OOoo001kool01000
ooooo`002?oo00@00?ooool000Coo`03003ooooo00koo`03003ooooo07goo`00Nooo00@00?ooool0
00Soo`04003ooooo0004ool3000>ool00`00ooooo`1mool007_oo`04003ooooo0009ool20005ool0
0`00ooooo`0>ool00`00ooooo`1mool007_oo`03003ooooo008000Ooo`04003ooooo0004ool00`00
ooooo`0=ool00`00ooooo`1nool007_oo`03003ooooo008000Ooo`04003ooooo0004ool00`00oooo
o`0=ool00`00ooooo`1nool007coo`800003ool00?oo00Ooo`8000Goo`03003ooooo00goo`03003o
oooo07koo`00P?oo00<00?ooool03?oo00<00?ooool03?oo00<00?ooool0Oooo0020ool00`00oooo
o`0<ool00`00ooooo`0<ool00`00ooooo`1oool0083oo`03003ooooo00coo`03003ooooo00coo`03
003ooooo07ooo`00POoo00<00?ooool02ooo0P003?oo00<00?ooool0P?oo0021ool00`00ooooo`0;
ool00`00ooooo`0;ool00`00ooooo`20ool0087oo`03003ooooo00_oo`03003ooooo00_oo`03003o
oooo083oo`00POoo00<00?ooool02ooo00<00?ooool02ooo00<00?ooool0P?oo0022ool00`00oooo
o`0:ool00`00ooooo`0:ool00`00ooooo`21ool008;oo`03003ooooo00[oo`03003ooooo00[oo`03
003ooooo087oo`00P_oo00<00?ooool02_oo00<00?ooool02_oo00<00?ooool0POoo0023ool00`00
ooooo`09ool00`00ooooo`09ool00`00ooooo`22ool008?oo`03003ooooo00Woo`8000[oo`03003o
oooo08;oo`00Pooo00<00?ooool02Ooo00<00?ooool02Ooo00<00?ooool0P_oo0024ool00`00oooo
o`08ool00`00ooooo`08ool00`00ooooo`23ool008Coo`03003ooooo00Soo`03003ooooo00Soo`03
003ooooo08?oo`00Q?oo00<00?ooool02?oo00<00?ooool01ooo00<00?ooool0Q?oo0025ool00`00
ooooo`07ool00`00ooooo`07ool00`00ooooo`24ool008Goo`03003ooooo00Ooo`03003ooooo00Ko
o`03003ooooo08Goo`00Q_oo00<00?ooool01_oo00<00?ooool01_oo00<00?ooool0QOoo0026ool0
0`00ooooo`06ool20006ool00`00ooooo`26ool008Ooo`03003ooooo00Goo`03003ooooo00Goo`03
003ooooo08Koo`00R?oo00<00?ooool01?oo00<00?ooool01?oo00<00?ooool0Qooo0029ool00`00
ooooo`03ool00`00ooooo`04ool00`00ooooo`27ool008Woo`03003ooooo00?oo`03003ooooo00?o
o`03003ooooo08Soo`00R_oo00<00?ooool00_oo00<00?ooool00_oo00<00?ooool0ROoo0027ool5
0003ool01@00oooooooo0000S?oo0029ool00`00ooooo`0200000ooo003oo`02002=ool008Woo`04
003oooooool5002>ool008Woo`03003ooooo00?oo`03003ooooo08koo`00ROoo00<00?ooool00ooo
00<00?ooool0S_oo0027ool30005ool00`00ooooo`2>ool008Woo`03003ooooo00?oo`03003ooooo
08koo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-2.21674, -0.0774837, \
0.0154477, 0.00624859}}]
}, Open  ]],

Cell[BoxData[
    \(Unset[M]\)], "Input",
  InitializationCell->True],

Cell["Operators of Modulation and Translation", "Subsubsection"],

Cell[BoxData[
    \(M[w_, x_] := Exp[2\ Pi\ I\ w\ x]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(T[f_, b_, x_] := f[x - b]\)], "Input",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[{Re[M[1, x] T[g, 1, x]], Im[M[2, x] T[g, 1, x]]}, {x, \(-2\), 
          2}, PlotRange \[Rule] All];\)\)], "Input",
  InitializationCell->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.302049 0.30131 [
[.02381 .28955 -6 -9 ]
[.02381 .28955 6 0 ]
[.2619 .28955 -6 -9 ]
[.2619 .28955 6 0 ]
[.7381 .28955 -3 -9 ]
[.7381 .28955 3 0 ]
[.97619 .28955 -3 -9 ]
[.97619 .28955 3 0 ]
[.4875 .00074 -12 -4.5 ]
[.4875 .00074 0 4.5 ]
[.4875 .15139 -24 -4.5 ]
[.4875 .15139 0 4.5 ]
[.4875 .4527 -18 -4.5 ]
[.4875 .4527 0 4.5 ]
[.4875 .60336 -6 -4.5 ]
[.4875 .60336 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30205 m
.02381 .3083 L
s
[(-2)] .02381 .28955 0 1 Mshowa
.2619 .30205 m
.2619 .3083 L
s
[(-1)] .2619 .28955 0 1 Mshowa
.7381 .30205 m
.7381 .3083 L
s
[(1)] .7381 .28955 0 1 Mshowa
.97619 .30205 m
.97619 .3083 L
s
[(2)] .97619 .28955 0 1 Mshowa
.125 Mabswid
.07143 .30205 m
.07143 .3058 L
s
.11905 .30205 m
.11905 .3058 L
s
.16667 .30205 m
.16667 .3058 L
s
.21429 .30205 m
.21429 .3058 L
s
.30952 .30205 m
.30952 .3058 L
s
.35714 .30205 m
.35714 .3058 L
s
.40476 .30205 m
.40476 .3058 L
s
.45238 .30205 m
.45238 .3058 L
s
.54762 .30205 m
.54762 .3058 L
s
.59524 .30205 m
.59524 .3058 L
s
.64286 .30205 m
.64286 .3058 L
s
.69048 .30205 m
.69048 .3058 L
s
.78571 .30205 m
.78571 .3058 L
s
.83333 .30205 m
.83333 .3058 L
s
.88095 .30205 m
.88095 .3058 L
s
.92857 .30205 m
.92857 .3058 L
s
.25 Mabswid
0 .30205 m
1 .30205 L
s
.5 .00074 m
.50625 .00074 L
s
[(-1)] .4875 .00074 1 0 Mshowa
.5 .15139 m
.50625 .15139 L
s
[(-0.5)] .4875 .15139 1 0 Mshowa
.5 .4527 m
.50625 .4527 L
s
[(0.5)] .4875 .4527 1 0 Mshowa
.5 .60336 m
.50625 .60336 L
s
[(1)] .4875 .60336 1 0 Mshowa
.125 Mabswid
.5 .03087 m
.50375 .03087 L
s
.5 .061 m
.50375 .061 L
s
.5 .09113 m
.50375 .09113 L
s
.5 .12126 m
.50375 .12126 L
s
.5 .18153 m
.50375 .18153 L
s
.5 .21166 m
.50375 .21166 L
s
.5 .24179 m
.50375 .24179 L
s
.5 .27192 m
.50375 .27192 L
s
.5 .33218 m
.50375 .33218 L
s
.5 .36231 m
.50375 .36231 L
s
.5 .39244 m
.50375 .39244 L
s
.5 .42257 m
.50375 .42257 L
s
.5 .48284 m
.50375 .48284 L
s
.5 .51297 m
.50375 .51297 L
s
.5 .5431 m
.50375 .5431 L
s
.5 .57323 m
.50375 .57323 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
.5 Mabswid
.02381 .30205 m
.02846 .30205 L
.03279 .30205 L
.03754 .30205 L
.04262 .30205 L
.053 .30205 L
.06244 .30205 L
.06507 .30205 L
.0665 .30205 L
.0672 .30205 L
.06785 .30205 L
.06899 .30205 L
.07022 .30205 L
.07086 .30205 L
.07156 .30205 L
.07283 .30205 L
.07359 .30205 L
.07431 .30205 L
.07566 .30205 L
.07642 .30205 L
.07711 .30205 L
.07868 .30205 L
.07994 .30205 L
.08132 .30205 L
.08275 .30205 L
.0841 .30205 L
.08678 .30205 L
.08922 .30205 L
.09184 .30205 L
.09469 .30205 L
.09718 .30205 L
.09983 .30205 L
.10209 .30205 L
.10458 .30205 L
.1095 .30205 L
.11197 .30205 L
.11467 .30205 L
.11947 .30205 L
.12393 .30205 L
.12921 .30205 L
.13401 .30205 L
.13955 .30205 L
.14478 .30205 L
.14941 .30205 L
.1545 .30205 L
.1648 .30205 L
.17426 .30205 L
.17893 .30205 L
.18119 .30205 L
.18325 .30205 L
Mistroke
.18446 .30205 L
.1856 .30205 L
.18681 .30205 L
.18811 .30205 L
.18875 .30205 L
.18946 .30205 L
.19019 .30205 L
.19087 .30205 L
.1921 .30205 L
.19341 .30205 L
.19461 .30205 L
.19591 .30205 L
.19827 .30205 L
.20057 .30205 L
.2027 .30205 L
.20519 .30205 L
.20752 .30205 L
.21008 .30205 L
.21283 .30205 L
.21557 .30205 L
.21845 .30205 L
.22109 .30205 L
.22359 .30205 L
.22861 .30205 L
.23316 .30205 L
.23806 .30205 L
.24337 .30205 L
.24802 .30205 L
.25294 .30205 L
.26175 .30205 L
.27121 .30205 L
.28136 .30205 L
.28597 .30205 L
.29088 .30205 L
.29506 .30205 L
.29621 .30205 L
.29745 .30205 L
.29861 .30205 L
.29969 .30205 L
.30092 .30205 L
.30157 .30205 L
.30227 .30205 L
.303 .30205 L
.30369 .30205 L
.30499 .30205 L
.3062 .30205 L
.30732 .30205 L
.30855 .30205 L
.30985 .30205 L
.31116 .30205 L
Mistroke
.31256 .30205 L
.31511 .30205 L
.31814 .30205 L
.3209 .30205 L
.32346 .30205 L
.32584 .30205 L
.32866 .30204 L
.33122 .30204 L
.33596 .30203 L
.34102 .30203 L
.3459 .30201 L
.35105 .302 L
.36028 .30195 L
.36542 .30192 L
.37021 .30189 L
.3811 .30179 L
.39976 .30158 L
.40486 .30153 L
.40766 .30151 L
.41029 .30149 L
.41138 .30148 L
.41252 .30148 L
.41377 .30148 L
.41492 .30147 L
.41619 .30147 L
.41736 .30147 L
.41865 .30147 L
.41938 .30148 L
.42003 .30148 L
.42136 .30149 L
.42276 .3015 L
.42396 .30151 L
.42528 .30153 L
.42822 .30158 L
.43097 .30165 L
.43357 .30173 L
.43595 .30182 L
.44129 .3021 L
.44623 .30246 L
.45162 .30297 L
.4567 .3036 L
.46141 .30432 L
.47202 .30646 L
.48199 .30912 L
.50062 .31528 L
.51041 .31845 L
.51576 .31986 L
.51837 .32041 L
.52075 .32082 L
.5218 .32096 L
Mistroke
.52294 .3211 L
.52392 .32119 L
.52501 .32127 L
.52616 .32133 L
.52738 .32135 L
.52851 .32133 L
.52957 .32129 L
.53082 .32119 L
.532 .32106 L
.53307 .3209 L
.53423 .32069 L
.53683 .32005 L
.53924 .31923 L
.54188 .31807 L
.54431 .31674 L
.5498 .31277 L
.55464 .30805 L
.55975 .30174 L
.56862 .28747 L
.57836 .26712 L
.59949 .21167 L
.6095 .18534 L
.61877 .16518 L
.6234 .15765 L
.62575 .15468 L
.6271 .15325 L
.62833 .15212 L
.62957 .15119 L
.63091 .15039 L
.63162 .15006 L
.63227 .14982 L
.63296 .14963 L
.6337 .1495 L
.63435 .14945 L
.63506 .14946 L
.63634 .14967 L
.63759 .1501 L
.63874 .15071 L
.63983 .15148 L
.641 .15251 L
.64312 .15492 L
.64563 .15874 L
.64793 .16316 L
.65292 .1758 L
.65766 .1917 L
.66727 .235 L
.6775 .2951 L
.6959 .42256 L
.7062 .49179 L
.71162 .52398 L
Mistroke
.71734 .55321 L
.72235 .57398 L
.72501 .5829 L
.72785 .59074 L
.73047 .59633 L
.73286 .60003 L
.734 .60133 L
.73525 .60238 L
.73643 .60302 L
.73752 .60332 L
.7387 .60331 L
.73994 .60294 L
.741 .60233 L
.74216 .60135 L
.74342 .59992 L
.74476 .59799 L
.74717 .59344 L
.74961 .58746 L
.75191 .5806 L
.75621 .56475 L
.76611 .51524 L
.77683 .44668 L
.79634 .31048 L
.80668 .24705 L
.81238 .21777 L
.81778 .19452 L
.82289 .17694 L
.82558 .16942 L
.82844 .16277 L
.83084 .15826 L
.83349 .15439 L
.83465 .15305 L
.8359 .15185 L
.837 .15101 L
.83817 .15031 L
.83937 .14981 L
.84048 .14954 L
.84116 .14946 L
.8418 .14945 L
.84301 .14958 L
.84428 .14995 L
.84545 .15048 L
.84674 .15127 L
.84811 .15233 L
.85035 .15457 L
.85245 .15719 L
.85723 .16482 L
.86761 .18763 L
.87748 .21382 L
.89601 .26281 L
Mistroke
.9056 .28372 L
.91086 .29325 L
.91582 .30088 L
.92045 .30681 L
.92546 .31196 L
.93002 .31555 L
.93421 .31802 L
.93667 .31911 L
.93891 .31991 L
.94015 .32026 L
.9415 .32059 L
.94266 .32082 L
.94395 .32103 L
.94513 .32117 L
.94624 .32126 L
.94741 .32132 L
.94867 .32135 L
.94978 .32133 L
.95095 .32129 L
.95195 .32122 L
.95304 .32112 L
.95443 .32096 L
.95575 .32077 L
.95821 .32033 L
.96374 .31902 L
.9737 .31592 L
.97619 .31507 L
Mfstroke
.02381 .30205 m
.02605 .30205 L
.02846 .30205 L
.03072 .30205 L
.03279 .30205 L
.03521 .30205 L
.03784 .30205 L
.04262 .30205 L
.045 .30205 L
.04762 .30205 L
.05293 .30205 L
.06244 .30205 L
.06525 .30205 L
.06663 .30205 L
.06792 .30205 L
.06908 .30205 L
.07031 .30205 L
.07102 .30205 L
.07168 .30205 L
.07293 .30205 L
.07358 .30205 L
.0743 .30205 L
.07505 .30205 L
.07575 .30205 L
.077 .30205 L
.07834 .30205 L
.07991 .30205 L
.08141 .30205 L
.08273 .30205 L
.0842 .30205 L
.08666 .30205 L
.08927 .30205 L
.09169 .30205 L
.09396 .30205 L
.09907 .30205 L
.10194 .30205 L
.10458 .30205 L
.11438 .30205 L
.11907 .30205 L
.1235 .30205 L
.12602 .30205 L
.12671 .30205 L
.12744 .30205 L
.12875 .30205 L
.12992 .30205 L
.13102 .30205 L
.13222 .30205 L
.13351 .30205 L
.13422 .30205 L
.13488 .30205 L
Mistroke
.13638 .30205 L
.1377 .30205 L
.1391 .30205 L
.14048 .30205 L
.14178 .30205 L
.1442 .30205 L
.14662 .30205 L
.14887 .30205 L
.15135 .30205 L
.15399 .30205 L
.1594 .30205 L
.16432 .30205 L
.17329 .30205 L
.1782 .30205 L
.18281 .30205 L
.18508 .30205 L
.18636 .30205 L
.18753 .30205 L
.18875 .30205 L
.18944 .30205 L
.19008 .30205 L
.19137 .30205 L
.19209 .30205 L
.19275 .30205 L
.19393 .30205 L
.19502 .30205 L
.19621 .30205 L
.19747 .30205 L
.1996 .30205 L
.20193 .30205 L
.20464 .30205 L
.20711 .30205 L
.20996 .30205 L
.21267 .30205 L
.21747 .30205 L
.2227 .30205 L
.23289 .30205 L
.23788 .30205 L
.24006 .30205 L
.2413 .30205 L
.24245 .30205 L
.24368 .30205 L
.24479 .30205 L
.24598 .30205 L
.24725 .30205 L
.24853 .30205 L
.24925 .30205 L
.24992 .30205 L
.25114 .30205 L
.25243 .30205 L
Mistroke
.25374 .30205 L
.25514 .30205 L
.25768 .30205 L
.25923 .30205 L
.2607 .30205 L
.26345 .30205 L
.26605 .30205 L
.26849 .30205 L
.27305 .30205 L
.27796 .30205 L
.28327 .30205 L
.29279 .30205 L
.29743 .30206 L
.29946 .30206 L
.30167 .30206 L
.30289 .30206 L
.30403 .30206 L
.30511 .30206 L
.30626 .30206 L
.30747 .30206 L
.3086 .30206 L
.30984 .30206 L
.31054 .30206 L
.31118 .30206 L
.31361 .30205 L
.31499 .30205 L
.31627 .30205 L
.31886 .30205 L
.32162 .30205 L
.32435 .30205 L
.3273 .30204 L
.33266 .30203 L
.34269 .302 L
.34765 .30199 L
.35297 .30197 L
.35555 .30196 L
.35799 .30196 L
.35906 .30195 L
.36019 .30195 L
.36143 .30195 L
.36258 .30195 L
.36389 .30195 L
.36462 .30195 L
.36529 .30195 L
.36653 .30195 L
.36784 .30195 L
.36902 .30196 L
.37012 .30196 L
.37261 .30197 L
.37404 .30198 L
Mistroke
.37539 .30199 L
.37793 .30201 L
.38066 .30205 L
.38363 .30209 L
.3885 .30218 L
.39306 .30229 L
.40346 .30261 L
.40865 .30278 L
.41358 .30292 L
.41631 .30298 L
.41785 .303 L
.41858 .30301 L
.41928 .30302 L
.4206 .30303 L
.4218 .30303 L
.42309 .30303 L
.42381 .30302 L
.42448 .30302 L
.42574 .303 L
.42694 .30297 L
.42801 .30294 L
.42918 .3029 L
.43179 .30279 L
.43421 .30264 L
.43862 .30225 L
.4433 .30169 L
.44836 .30089 L
.45312 .29998 L
.46396 .29762 L
.46905 .2966 L
.47153 .29619 L
.47378 .29588 L
.47493 .29576 L
.47617 .29565 L
.47749 .29557 L
.47872 .29552 L
.47938 .29551 L
.48009 .29551 L
.48084 .29553 L
.48154 .29555 L
.48279 .29564 L
.48349 .2957 L
.48413 .29577 L
.48527 .29593 L
.48649 .29615 L
.48867 .29665 L
.49127 .29747 L
.49362 .29842 L
.49826 .30091 L
.50263 .30398 L
Mistroke
.52104 .32188 L
.52608 .32654 L
.52886 .32865 L
.53022 .32952 L
.53148 .33022 L
.53265 .33076 L
.53393 .33124 L
.53521 .33157 L
.53592 .33169 L
.53658 .33176 L
.53775 .33178 L
.53882 .33167 L
.53999 .33142 L
.54122 .33098 L
.54248 .33035 L
.54362 .32962 L
.54617 .3274 L
.54853 .32459 L
.55077 .32127 L
.55577 .31144 L
.56119 .29737 L
.57123 .26473 L
.57656 .24652 L
.58227 .22892 L
.58503 .22187 L
.58765 .21642 L
.59 .21275 L
.59133 .21126 L
.59256 .21027 L
.5937 .20973 L
.59477 .20955 L
.59595 .20973 L
.59722 .2104 L
.59847 .21155 L
.59911 .21232 L
.5998 .21332 L
.60217 .2179 L
.60359 .22153 L
.60493 .22558 L
.60744 .23477 L
.61307 .26275 L
.62323 .33377 L
.63293 .4112 L
.63823 .44911 L
.64083 .46483 L
.64321 .47704 L
.64523 .48555 L
.64743 .49262 L
.64864 .49543 L
.64977 .49734 L
Mistroke
.65084 .49851 L
.65198 .49903 L
.65324 .49872 L
.65394 .49813 L
.65459 .49732 L
.65579 .49516 L
.65705 .49193 L
.65924 .48398 L
.66165 .47185 L
.66416 .45548 L
.66689 .43359 L
.67186 .38404 L
.68116 .26772 L
.69111 .13826 L
.69639 .08104 L
.69916 .05686 L
.70208 .03678 L
.70331 .03013 L
.70462 .02429 L
.70538 .02154 L
.70606 .01944 L
.70676 .01768 L
.7074 .01641 L
.70861 .01494 L
.70991 .01472 L
.71106 .0157 L
.71228 .01795 L
.71342 .02117 L
.71464 .02582 L
.71684 .03733 L
.71946 .05604 L
.72186 .07762 L
.72702 .13687 L
.73264 .2166 L
.74287 .37707 L
.7482 .45439 L
.75322 .51509 L
.75772 .55579 L
.75896 .56431 L
.76026 .57199 L
.76145 .57785 L
.76259 .5823 L
.7639 .58612 L
.76509 .58835 L
.76637 .58942 L
.7671 .5894 L
.76777 .58901 L
.76888 .58752 L
.77011 .5847 L
.7714 .58047 L
Mistroke
.7726 .57533 L
.77536 .55946 L
.77789 .54029 L
.78357 .48347 L
.79353 .35649 L
.79899 .28425 L
.80415 .22214 L
.80896 .17353 L
.81149 .15262 L
.81417 .13446 L
.81642 .12246 L
.81762 .11737 L
.8189 .11289 L
.82008 .10967 L
.82115 .10747 L
.82223 .10598 L
.82326 .10522 L
.82439 .1051 L
.82544 .10566 L
.82661 .10702 L
.82786 .10932 L
.8291 .11242 L
.83041 .11655 L
.83275 .12596 L
.83694 .14858 L
.84153 .17986 L
.85195 .26232 L
.86143 .33112 L
.86626 .35816 L
.8688 .36954 L
.8715 .37929 L
.87386 .38582 L
.8752 .38871 L
.87645 .39088 L
.8776 .39242 L
.87865 .39345 L
.87987 .39422 L
.88102 .39454 L
.88234 .39442 L
.88354 .39389 L
.8842 .39342 L
.88492 .39279 L
.88622 .39132 L
.88873 .38734 L
.89104 .38252 L
.89635 .3681 L
.90196 .34971 L
.91145 .31753 L
.91668 .30202 L
.92162 .29 L
Mistroke
.92622 .28157 L
.92882 .27804 L
.93122 .27555 L
.93324 .27403 L
.93438 .27339 L
.93546 .27292 L
.93659 .27258 L
.93763 .27239 L
.93877 .27231 L
.93996 .27237 L
.94114 .27256 L
.94241 .27291 L
.94361 .27337 L
.94472 .27388 L
.94904 .2767 L
.95375 .28085 L
.95874 .28589 L
.97619 .30205 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  InitializationCell->True,
  ImageSize->{288, 177.938},
  ImageMargins->{{281, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40n007h00Oooll8Oll003ooc`Q
oc`008Oo?0@009Go?000ROll00<00?lloc`0U?ll0029oc`00`00occo?003oc`3002>oc`0087o?0@0
00Co?003003o??ll00?o?003003o??ll08ko?000ROll00<00?lloc`00oll00<00?lloc`0S_ll0027
oc`30005oc`00`00occo?02>oc`008Wo?003003o??ll00?o?003003o??ll03Oo?08005Go?000Soll
00<00?lloc`0=_ll0`00EOll002?oc`00`00occo?00foc`00`00oc`0001Eoc`008oo?003003o??ll
03Ko?004003o??ll001Doc`008oo?08003Oo?004003o??ll001Doc`008oo?003003o??ll03Ko?004
003o??ll001Doc`008oo?003003o??ll03Go?005003o??lloc`0001Doc`008oo?003003o??ll03Go
?005003o??lloc`0001Doc`008oo?003003o??ll03Go?005003o??lloc`0001Doc`008oo?003003o
??ll03Go?003003o??ll00;o?003003o??ll057o?000Soll00<00?lloc`0=Oll00<00?lloc`00_ll
00<00?lloc`0DOll002?oc`00`00occo?00eoc`00`00occo?002oc`00`00occo?01Aoc`008oo?003
003o??ll03Go?003003o??ll00;o?003003o??ll057o?000Soll0P00=_ll00<00?lloc`00_ll00<0
0?lloc`0DOll002?oc`00`00occo?00eoc`00`00occo?002oc`00`00occo?01Aoc`008oo?003003o
??ll03Go?003003o??ll00?o?003003o??ll053o?000Soll00<00?lloc`0=?ll00<00?lloc`01?ll
00<00?lloc`0D?ll002?oc`00`00occo?00doc`00`00occo?004oc`00`00occo?01@oc`008oo?003
003o??ll03Co?003003o??ll00Co?003003o??ll053o?000Soll00<00?lloc`0=?ll00<00?lloc`0
1?ll00<00?lloc`0D?ll002?oc`00`00occo?00doc`00`00occo?004oc`00`00occo?01@oc`008oo
?08003Go?003003o??ll00Co?003003o??ll053o?000Soll00<00?lloc`0=?ll00<00?lloc`01?ll
00<00?lloc`0D?ll002?oc`00`00occo?00coc`00`00occo?005oc`00`00occo?01@oc`008oo?003
003o??ll03?o?003003o??ll00Go?003003o??ll053o?000Soll00<00?lloc`0<oll00<00?lloc`0
1Oll00<00?lloc`06Oll0P00=Oll002?oc`00`00occo?00coc`00`00occo?006oc`00`00occo?00G
oc`00`00oc`0000eoc`008oo?003003o??ll03?o?003003o??ll00Ko?003003o??ll01Oo?004003o
??ll000doc`008oo?003003o??ll03?o?003003o??ll00Ko?003003o??ll01Oo?004003o??ll000d
oc`008oo?003003o??ll03?o?003003o??ll00Ko?003003o??ll01Oo?004003o??ll000doc`008oo
?08003Co?003003o??ll00Ko?003003o??ll01Ko?003003o??ll00;o?003003o??ll037o?000Soll
00<00?lloc`0<_ll00<00?lloc`01oll00<00?lloc`05_ll00<00?lloc`00_ll00<00?lloc`0<Oll
002?oc`00`00occo?00boc`00`00occo?007oc`00`00occo?00Foc`00`00occo?002oc`00`00occo
?00aoc`008oo?003003o??ll03;o?003003o??ll00Oo?003003o??ll01Ko?003003o??ll00;o?003
003o??ll037o?000Soll00<00?lloc`0<_ll00<00?lloc`01oll00<00?lloc`05_ll00<00?lloc`0
0_ll00<00?lloc`0<Oll002?oc`00`00occo?00boc`00`00occo?007oc`00`00occo?00Foc`00`00
occo?003oc`00`00occo?00`oc`007co?08000Co?003003o??ll00;o?0<000Go?003003o??ll03;o
?003003o??ll00Oo?003003o??ll01Go?003003o??ll00Co?003003o??ll033o?000Noll00@00?ll
oc`000_o?003003o??ll00;o?003003o??ll03;o?003003o??ll00Oo?003003o??ll01Go?003003o
??ll00Co?003003o??ll033o?000Noll00@00?lloc`000_o?003003o??ll00;o?0<0027o?0@000go
?003003o??ll00Oo?003003o??ll01Go?003003o??ll00Co?0@002oo?000MOll10000_ll00@00?ll
oc`000So?0<000Go?003003o??ll023o?003003o??ll00;o?003003o??ll00[o?003003o??ll00Oo
?003003o??ll01Go?003003o??ll00?o?08000?o?003003o??ll02co?000Noll00@00?lloc`000So
?003003o??ll00Go?003003o??ll01oo?003003o??ll00Co?003003o??ll00Wo?003003o??ll00So
?003003o??ll01Co?003003o??ll00;o?003003o?00000?o?003003o??ll02co?000Noll00@00?ll
oc`000So?003003o??ll00Go?003003o??ll01oo?003003o??ll00Co?003003o??ll00So?003003o
??ll00Wo?003003o??ll01Co?003003o??ll00;o?003003o?00000Co?003003o??ll02_o?000O?ll
0P002Oll10001?ll00<00?lloc`07_ll00<00?lloc`01Oll00<00?lloc`02?ll00<00?lloc`02Oll
00<00?lloc`04oll00<00?lloc`00oll00@00?lloc`000Co?003003o??ll02[o?000Soll00<00?ll
oc`07_ll00<00?lloc`01_ll00<00?lloc`01oll00<00?lloc`02Oll00<00?lloc`04oll00<00?ll
oc`00_ll00D00?llocco?00000Co?003003o??ll02[o?000Soll00<00?lloc`07Oll00<00?lloc`0
1oll00<00?lloc`01oll00<00?lloc`02Oll00<00?lloc`04oll00<00?lloc`00_ll00D00?llocco
?00000Go?003003o??ll02Wo?000Soll00<00?lloc`07Oll00<00?lloc`02?ll00<00?lloc`01_ll
00<00?lloc`02Oll00<00?lloc`04oll00D00?llocco?00000Co?003003o??ll00?o?003003o??ll
02Wo?000Soll0P007_ll00<00?lloc`02?ll00<00?lloc`01_ll00<00?lloc`02Oll00<00?lloc`0
4oll00D00?llocco?00000Co?003003o??ll00?o?003003o??ll02Wo?000Soll00<00?lloc`07?ll
00<00?lloc`02Oll00<00?lloc`01_ll00<00?lloc`02Oll00<00?lloc`04oll00D00?llocco?000
00Co?003003o??ll00Co?003003o??ll02So?000Soll00<00?lloc`07?ll00<00?lloc`02_ll00<0
0?lloc`01Oll00<00?lloc`02Oll00<00?lloc`04oll00@00?lloc`000Go?003003o??ll00Co?003
003o??ll02So?000Soll00<00?lloc`07?ll00<00?lloc`02_ll00<00?lloc`01Oll00<00?lloc`0
2Oll00<00?lloc`04oll00@00?lloc`000Go?003003o??ll00Co?003003o??ll02So?000Soll00<0
0?lloc`06oll00<00?lloc`02oll00<00?lloc`01Oll00<00?lloc`02Oll00<00?lloc`04oll00@0
0?lloc`000Ko?003003o??ll00Co?003003o??ll02Oo?000Soll00<00?lloc`06oll00<00?lloc`0
2oll00<00?lloc`01Oll00<00?lloc`02_ll00<00?lloc`04_ll00@00?lloc`000Ko?003003o??ll
00Co?003003o??ll02Oo?000Soll00<00?lloc`06_ll00<00?lloc`03Oll00<00?lloc`01?ll00<0
0?lloc`02_ll00<00?lloc`04Oll00@00?lloc`000Oo?003003o??ll00Go?003003o??ll02Ko?000
Soll00<00?lloc`06_ll00<00?lloc`03Oll00<00?lloc`00oll00<00?lloc`02oll00<00?lloc`0
4Oll00@00?lloc`000Oo?003003o??ll00Go?003003o??ll02Ko?000Soll00<00?lloc`05oll0`00
4?ll00<00?lloc`00oll00<00?lloc`02oll00<00?lloc`04Oll00@00?lloc`000Oo?003003o??ll
00Ko?003003o??ll02Go?000Soll0P005oll00@00?ll0000013o?003003o??ll00?o?003003o??ll
00_o?003003o??ll017o?004003o??ll0007oc`00`00occo?006oc`00`00occo?00Uoc`008oo?003
003o??ll01Go?005003o??lloc`0000Aoc`00`00occo?002oc`00`00occo?00;oc`00`00occo?00A
oc`00`00oc`00008oc`00`00occo?006oc`00`00occo?00Uoc`008oo?003003o??ll01Go?003003o
??ll0080017o?003003o??ll00;o?003003o??ll00_o?003003o??ll017o?003003o?00000So?003
003o??ll00Oo?003003o??ll02Co?000Soll00<00?lloc`05Oll00H00?lloc`00?ll000@oc`00`00
occo?002oc`00`00occo?00;oc`00`00occo?00Aoc`00`00oc`00009oc`00`00occo?006oc`00`00
occo?00Toc`008oo?003003o??ll01Go?003003o?00000;o?003003o??ll00ko?003003o??ll00;o
?003003o??ll00_o?003003o??ll017o?003003o?00000Wo?003003o??ll00Ko?003003o??ll02Co
?000Soll00<00?lloc`05?ll00@00?lloc`000;o?003003o??ll00oo?005003o??lloc`0000=oc`0
0`00occo?00Aoc`2000:oc`00`00occo?007oc`00`00occo?00Soc`008oo?003003o??ll01Co?004
003o??ll0003oc`00`00occo?00>oc`01@00occo??ll00003Oll00<00?lloc`04Oll0P002_ll00<0
0?lloc`01oll00<00?lloc`08oll002?oc`00`00occo?00Coc`01000occo?0001?ll00<00?lloc`0
3_ll00D00?llocco?00000go?003003o??ll017o?08000[o?003003o??ll00Oo?003003o??ll02?o
?000Soll0P005?ll00@00?lloc`000Co?003003o??ll00ko?005003o??lloc`0000=oc`00`00occo
?00@oc`00`00oc`0000:oc`00`00occo?008oc`00`00occo?00Roc`008oo?003003o??ll01;o?004
003o??ll0006oc`00`00occo?00=oc`01@00occo??ll00003_ll00<00?lloc`03oll0P002oll00<0
0?lloc`02?ll00<00?lloc`08_ll002?oc`00`00occo?00Boc`01000occo?0001_ll00<00?lloc`0
3Oll00@00?lloc`000oo?003003o??ll00oo?08000_o?003003o??ll00Wo?003003o??ll027o?000
Soll00<00?lloc`04_ll00@00?lloc`000Ko?003003o??ll00ko?003003o?00000oo?003003o??ll
00oo?08000co?003003o??ll00So?003003o??ll027o?000Soll00<00?lloc`04_ll00<00?ll0000
1oll00<00?lloc`03_ll00<00?ll00003oll00<00?lloc`03oll0P003?ll00<00?lloc`02?ll00<0
0?lloc`08Oll002?oc`00`00occo?00Aoc`01000occo?0002?ll00<00?lloc`03Oll00<00?ll0000
3oll00<00?lloc`03oll0P003?ll00<00?lloc`02Oll00<00?lloc`08?ll002?oc`00`00occo?00A
oc`00`00oc`00009oc`00`00occo?00=oc`00`00oc`0000?oc`00`00occo?00?oc`2000<oc`00`00
occo?009oc`00`00occo?00Poc`000_o?0@003oo?0@003go?003003o??ll017o?003003o?00000Wo
?003003o??ll00go?003003o?00000go?0@0013o?003003o??ll00_o?003003o??ll00Wo?003003o
??ll01;o?0@000[o?0002oll00<00?lloc`0@_ll00<00?lloc`0??ll00<00?lloc`04Oll00<00?ll
00002Oll00<00?lloc`03Oll00<00?ll00003oll00<00?lloc`03_ll0P003Oll00<00?lloc`02_ll
00<00?lloc`04Oll00<00?lloc`02oll000<oc`00`00occo?011oc`00`00occo?00loc`2000Aoc`0
0`00oc`0000:oc`00`00occo?00=oc`00`00oc`0000?oc`00`00occo?00>oc`2000=oc`00`00occo
?00:oc`00`00occo?007oc`40007oc`00`00occo?00:oc`000Go?0@000Co?003003o??ll03So?0@0
00Co?003003o??ll03co?003003o??ll013o?003003o?00000[o?003003o??ll00go?003003o?000
00oo?003003o??ll00ko?08000ko?003003o??ll00[o?003003o??ll00Go?003003o??ll00;o?003
003o??ll00Go?003003o??ll00Wo?0003_ll00<00?lloc`0?oll00<00?lloc`0??ll00<00?lloc`0
4?ll0P002oll00<00?lloc`03_ll0P003oll00<00?lloc`03_ll0P003_ll00<00?lloc`02_ll00<0
0?lloc`01?ll00<00?lloc`01?ll00<00?lloc`01Oll00<00?lloc`02?ll000;oc`01000occo?000
?oll0`00?_ll00<00?lloc`03oll00<00?ll00003?ll00<00?lloc`03Oll0P003Oll0`004?ll0P00
3_ll00<00?lloc`02oll00<00?lloc`00_ll00<00?lloc`01_ll00D00?llocco?00000;o?003003o
??ll00So?0003?ll0P00@_ll00<00?lloc`0??ll00<00?lloc`03oll0P003Oll00<00?lloc`03Oll
0P003oll00<00?lloc`03_ll0P003_ll00<00?lloc`02oll00<00?lloc`00_ll00<00?lloc`01oll
00@00?llocco?08000_o?000Soll00<00?lloc`03oll0P003Oll00<00?lloc`03Oll0P003oll00<0
0?lloc`03_ll0P003_ll00<00?lloc`03?ll00@00?lloc`000_o?003003o??ll00go?000Qoll1@00
0oll00<00?lloc`03_ll0P003_ll00<00?lloc`03Oll0P003oll00<00?lloc`03_ll00<00?lloc`0
3Oll00<00?lloc`03?ll00@00?lloc`000co?08000go?000P_ll1@001Oll0P0000?o?000oc`03oll
0P003_ll00<00?lloc`03Oll00<00?lloc`03oll00<00?lloc`03Oll00<00?lloc`03_ll00<00?ll
oc`03?ll0P003oll00<00?lloc`02_ll0004occo000H0005oc`000[o?003003o??ll00_o?003003o
??ll00[o?003003o??ll00[o?003003o??ll00[o?003003o??ll00_o?003003o??ll00[o?003003o
??ll00[o?003003o??ll00[o?003003o??ll00_o?003003o?00000@000Ko?08000_o?003003o??ll
008000Wo?003003o??ll00?o?003003o??ll00Co?003003o??ll00Ko?005003o??lloc`0000<oc`2
000<oc`01000occo?0002Oll00<00?lloc`01?ll00<00?lloc`00oll00<00?lloc`01oll0P0000?o
?000oc`03?ll00<00?lloc`02Oll000:oc`00`00occo?010oc`00`00occo?00ioc`30003oc`00`00
oc`0000<oc`2000@oc`00`00occo?00=oc`2000?oc`2000?oc`00`00occo?00>oc`00`00occo?00=
oc`00`00oc`0000>oc`00`00occo?009oc`008co?0800005oc`00?lloc`00009oc`200000oll003o
?00?oc`00`00occo?00=oc`2000@oc`00`00occo?00=oc`00`00occo?00>oc`00`00occo?00<oc`0
1@00occo??ll00006Oll002>oc`30002oc`00`00occo?005oc`01000occo?0004Oll00<00?lloc`0
3Oll0P004?ll00<00?lloc`03Oll00<00?lloc`03_ll00<00?lloc`03?ll00<00?lloc`00_ll0P00
2Oll0`002oll002?oc`00`00oc`000090002oc`00`00occo?00Aoc`00`00occo?00<oc`2000@oc`0
0`00occo?00=oc`00`00occo?00?oc`00`00occo?00;oc`00`00occo?004oc`9000>oc`008oo?003
003o??ll00?o?003003o??ll00Go?003003o??ll017o?003003o??ll00co?080013o?003003o??ll
00co?003003o??ll013o?003003o??ll00[o?003003o??ll01co?000Soll00<00?lloc`01?ll0P00
1?ll00<00?lloc`04_ll00<00?lloc`03?ll0P004?ll00<00?lloc`03?ll00<00?lloc`04?ll00<0
0?lloc`02_ll00<00?lloc`07?ll002?oc`20006oc`5000Eoc`00`00occo?00<oc`00`00oc`0000?
oc`00`00occo?00<oc`00`00occo?00@oc`00`00occo?00:oc`00`00occo?00Loc`008oo?003003o
??ll01oo?003003o??ll00co?003003o?00000oo?003003o??ll00co?003003o??ll013o?003003o
??ll00Wo?003003o??ll01go?000Soll00<00?lloc`07oll00<00?lloc`03?ll00<00?ll00003oll
00<00?lloc`03?ll00<00?lloc`04?ll00<00?lloc`02Oll00<00?lloc`07Oll002?oc`00`00occo
?00Ooc`00`00occo?00<oc`00`00oc`0000?oc`00`00occo?00<oc`00`00occo?00@oc`00`00occo
?009oc`00`00occo?00Moc`008oo?003003o??ll01oo?003003o??ll00co?003003o?00000oo?003
003o??ll00_o?08001;o?003003o??ll00So?003003o??ll01ko?000Soll00<00?lloc`08?ll00<0
0?lloc`02oll00<00?ll00003oll00<00?lloc`02oll0P004oll00<00?lloc`01oll00<00?lloc`0
7_ll002?oc`00`00occo?00Poc`00`00occo?00;oc`01000occo?0003oll00<00?lloc`02_ll0P00
4oll00<00?lloc`01oll00<00?lloc`07_ll002?oc`00`00occo?00Poc`00`00occo?00:oc`01@00
occo??ll00003oll00<00?lloc`02_ll0P004oll00<00?lloc`01_ll00<00?lloc`07oll002?oc`0
0`00occo?00Poc`00`00occo?00:oc`01@00occo??ll00003oll00<00?lloc`02_ll0P004oll00<0
0?lloc`01_ll00<00?lloc`07oll002?oc`2000Qoc`00`00occo?00:oc`01@00occo??ll00003oll
00<00?lloc`02_ll0P004oll00<00?lloc`01Oll00<00?lloc`08?ll002?oc`00`00occo?00Poc`0
0`00occo?00:oc`01@00occo??ll00003oll00<00?lloc`02Oll00<00?ll00005?ll00<00?lloc`0
1?ll00<00?lloc`08?ll002?oc`00`00occo?00Poc`00`00occo?00:oc`01@00occo??ll00003oll
00<00?lloc`02Oll00<00?ll00005?ll00<00?lloc`01?ll00<00?lloc`08?ll002?oc`00`00occo
?00Qoc`00`00occo?009oc`00`00occo?002oc`00`00occo?00<oc`00`00occo?009oc`00`00oc`0
000Doc`00`00occo?004oc`00`00occo?00Poc`008oo?003003o??ll027o?003003o??ll00Wo?003
003o??ll00;o?003003o??ll00co?003003o??ll00Wo?003003o?00001Go?003003o??ll00;o?003
003o??ll027o?000Soll00<00?lloc`08Oll00<00?lloc`02Oll00<00?lloc`00_ll00<00?lloc`0
3?ll00<00?lloc`02Oll0P005_ll00<00?lloc`00_ll00<00?lloc`08Oll002?oc`00`00occo?00Q
oc`00`00occo?009oc`00`00occo?002oc`00`00occo?00<oc`00`00occo?009oc`2000Foc`00`00
occo?002oc`00`00occo?00Qoc`008oo?003003o??ll027o?003003o??ll00Wo?003003o??ll00;o
?003003o??ll00co?003003o??ll00Wo?08001Oo?004003o??ll000Toc`008oo?08002;o?003003o
??ll00Wo?003003o??ll00;o?003003o??ll00co?003003o??ll00So?003003o?00001Oo?004003o
?000000Toc`008oo?003003o??ll027o?003003o??ll00Wo?003003o??ll00?o?003003o??ll00_o
?003003o??ll00So?003003o?00001So?08002Go?000Soll00<00?lloc`08_ll00<00?lloc`02?ll
00<00?lloc`00oll00<00?lloc`02oll00<00?lloc`02?ll00<00?ll0000?oll002?oc`00`00occo
?00Roc`00`00occo?008oc`00`00occo?003oc`00`00occo?00;oc`00`00occo?008oc`00`00oc`0
000ooc`008oo?003003o??ll02;o?003003o??ll00So?003003o??ll00?o?003003o??ll00_o?003
003o??ll00So?003003o?00003oo?000Soll00<00?lloc`08_ll00<00?lloc`02?ll00<00?lloc`0
0oll00<00?lloc`02oll00<00?lloc`02?ll00<00?ll0000?oll002?oc`00`00occo?00Roc`00`00
occo?007oc`00`00occo?004oc`00`00occo?00;oc`00`00occo?007oc`01000occo?000?oll002?
oc`00`00occo?00Roc`00`00occo?007oc`00`00occo?005oc`00`00occo?00;oc`00`00occo?006
oc`01000occo?000?oll002?oc`00`00occo?00Soc`00`00occo?006oc`00`00occo?005oc`00`00
occo?00;oc`00`00occo?006oc`01000occo?000?oll002?oc`2000Toc`00`00occo?006oc`00`00
occo?005oc`00`00occo?00;oc`00`00occo?006oc`00`00oc`00010oc`008oo?003003o??ll02?o
?003003o??ll00Ko?003003o??ll00Go?003003o??ll00_o?003003o??ll00Ko?003003o?000043o
?000Soll00<00?lloc`08oll00<00?lloc`01_ll00<00?lloc`01Oll00<00?lloc`02oll00<00?ll
oc`01_ll00<00?ll0000@?ll002?oc`00`00occo?00Soc`00`00occo?006oc`00`00occo?005oc`0
0`00occo?00;oc`00`00occo?005oc`01000occo?000@?ll002?oc`00`00occo?00Soc`00`00occo
?006oc`00`00occo?005oc`00`00occo?00;oc`00`00occo?005oc`01000occo?000@?ll002?oc`0
0`00occo?00Toc`00`00occo?005oc`00`00occo?006oc`00`00occo?00:oc`00`00occo?005oc`0
1000occo?000@?ll001loc`20004oc`00`00occo?002oc`30005oc`00`00occo?00Toc`00`00occo
?005oc`00`00occo?006oc`00`00occo?00:oc`00`00occo?005oc`01000occo?000@?ll001koc`0
1000occo?0002oll00<00?lloc`00_ll00<00?lloc`09?ll00<00?lloc`01?ll00<00?lloc`01oll
00<00?lloc`02_ll00<00?lloc`01Oll00@00?lloc`0043o?000Noll00@00?lloc`000_o?003003o
??ll00;o?0<002Co?003003o??ll00Co?003003o??ll00Oo?003003o??ll00[o?003003o??ll00Go
?004003o??ll0010oc`007_o?004003o??ll0008oc`30005oc`00`00occo?00Toc`00`00occo?004
oc`00`00occo?007oc`00`00occo?00:oc`00`00occo?005oc`01000occo?000@?ll001koc`01000
occo?0002?ll00<00?lloc`01Oll00<00?lloc`09?ll00<00?lloc`01?ll00<00?lloc`01oll00<0
0?lloc`02_ll00<00?lloc`01?ll00D00?llocco?000043o?000Noll00@00?lloc`000So?003003o
??ll00Go?003003o??ll02Co?003003o??ll00Co?003003o??ll00Oo?003003o??ll00[o?003003o
??ll00Co?005003o??lloc`00010oc`007co?08000Wo?0@000Co?003003o??ll02Co?003003o??ll
00?o?003003o??ll00So?003003o??ll00[o?003003o??ll00Co?004003o??ll0011oc`008oo?003
003o??ll02Co?003003o??ll00?o?003003o??ll00So?003003o??ll00_o?003003o??ll00?o?004
003o??ll0011oc`008oo?003003o??ll02Go?003003o??ll00;o?003003o??ll00So?003003o??ll
00_o?003003o??ll00?o?004003o??ll0011oc`008oo?003003o??ll02Go?003003o??ll00;o?003
003o??ll00Wo?003003o??ll00[o?003003o??ll00?o?004003o??ll0011oc`008oo?08002Ko?005
003o??lloc`0000<oc`00`00occo?00:oc`00`00occo?002oc`01@00occo??ll0000@Oll002?oc`0
0`00occo?00Uoc`01@00occo??ll00003?ll00<00?lloc`02_ll00<00?lloc`00_ll00D00?llocco
?000047o?000Soll00<00?lloc`09Oll00D00?llocco?00000co?003003o??ll00[o?003003o??ll
00;o?005003o??lloc`00011oc`008oo?003003o??ll02Ko?004003o??ll000<oc`00`00occo?00:
oc`00`00occo?002oc`01@00occo??ll0000@Oll002?oc`00`00occo?00Voc`3000=oc`00`00occo
?00:oc`00`00occo?002oc`01@00occo??ll0000@Oll002?oc`00`00occo?00Woc`2000=oc`00`00
occo?00;oc`01@00occo??ll00000_ll00<00?lloc`0@?ll002?oc`00`00occo?00goc`00`00occo
?00:oc`01000occo?0000oll00<00?lloc`0@?ll002?oc`00`00occo?00goc`00`00occo?00:oc`0
1000occo?0000oll00<00?lloc`0@?ll002?oc`00`00occo?00goc`00`00occo?00:oc`01000occo
?0000oll00<00?lloc`0@?ll002?oc`2000hoc`00`00occo?00:oc`01000occo?0000oll00<00?ll
oc`0@?ll002?oc`00`00occo?00hoc`00`00occo?009oc`01000occo?0000oll00<00?lloc`0@?ll
002?oc`00`00occo?00hoc`00`00occo?009oc`01000occo?0000oll00<00?lloc`0@?ll002?oc`0
0`00occo?00hoc`00`00occo?009oc`00`00oc`00004oc`00`00occo?010oc`008oo?003003o??ll
03So?003003o??ll00Wo?003003o?00000?o?003003o??ll047o?000Soll00<00?lloc`0>?ll00<0
0?lloc`02Oll00<00?ll00000oll00<00?lloc`0@Oll002?oc`00`00occo?00ioc`00`00occo?008
oc`00`00oc`00003oc`00`00occo?011oc`008oo?003003o??ll03Wo?003003o??ll00Wo?08000?o
?003003o??ll047o?000Soll0P00>_ll00<00?lloc`02Oll00<00?lloc`00_ll00<00?lloc`0@Oll
002?oc`00`00occo?00ioc`00`00occo?009oc`00`00occo?002oc`00`00occo?011oc`008oo?003
003o??ll03[o?003003o??ll00So?003003o??ll00;o?003003o??ll047o?000Soll00<00?lloc`0
>_ll00<00?lloc`02?ll00<00?lloc`00_ll00<00?lloc`0@Oll002?oc`00`00occo?00joc`00`00
occo?007oc`20004oc`00`00occo?011oc`008oo?003003o??ll03[o?003003o??ll00Oo?08000Co
?003003o??ll047o?000Soll00<00?lloc`0>_ll00<00?lloc`01oll0P001?ll00<00?lloc`0@Oll
002?oc`00`00occo?00koc`00`00occo?006oc`20004oc`00`00occo?011oc`008oo?003003o??ll
03_o?003003o??ll00Ko?003003o?00000;o?003003o??ll04;o?000Soll0P00??ll00<00?lloc`0
1Oll00@00?lloc`000;o?003003o??ll04;o?000Soll00<00?lloc`0>oll00<00?lloc`01Oll00@0
0?lloc`000;o?003003o??ll04;o?000Soll00<00?lloc`0??ll00<00?lloc`01?ll00@00?lloc`0
00;o?003003o??ll04;o?000Soll00<00?lloc`0??ll00<00?lloc`01?ll00@00?llocco?08004Go
?000Soll00<00?lloc`0??ll00<00?lloc`01?ll00@00?llocco?08004Go?000Soll00<00?lloc`0
??ll00<00?lloc`00oll00<00?lloc`0BOll0027oc`40004oc`00`00occo?00moc`00`00occo?002
oc`00`00occo?019oc`008Wo?003003o??ll00?o?003003o??ll03ko?004003o?000001<oc`008Wo
?003003o??ll00?o?0<003oo?08004go?000ROll00<00?lloc`00oll00<00?lloc`0S_ll0029oc`0
0`00occo?003oc`00`00occo?02>oc`008Oo?0<000Go?003003o??ll08ko?000ROll00<00?lloc`0
0oll00<00?lloc`0S_ll0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-2.16273, -1.0536, \
0.0150713, 0.0119093}}]
}, Open  ]],

Cell[BoxData[
    \(Off[NIntegrate::mccnv]; Off[General::stop]; 
    Off[CompiledFunction::cfse]; Off[CompiledFunction::cfex]\)], "Input",
  InitializationCell->True],

Cell["\<\
The definition of the STFT[f,w,b] = Integrate[ f[x] Exp[2 Pi I w x] \
g(x -b), {x,-Infinity,Infinity}] Short Time Fourier Transform\
\>", \
"Subsubsection"],

Cell[BoxData[
    \(STFT[f_, g_, w_, b_] := 
      Chop[NIntegrate[
          f[x] Conjugate[M[w, x] T[g, b, x]], {x, \(-Infinity\), Infinity}, 
          MaxPoints \[Rule] 200]]\)], "Input",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Chop[STFT[g, g, 1, 0]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(0.1469972256868406`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(Spectrogram[f_, g_, w_, b_] := Abs[STFT[f, g, w, b]]^2\)], "Input",
  InitializationCell->True],

Cell["Let us consider a sample signal", "Subsubsection"],

Cell[BoxData[
    \(\(\(f[
        x_]\)\(:=\)\((Which[x > 0, Sin[2  Pi\ x^\((1 + 0.4)\)], True, 0] + 
          Which[x <= 0, Sin[2  Pi\ x], True, 0])\)\( (*Which[Abs[x] < 10, 
          Exp[\(-1\)/\((1 - Abs[0.1  x]^2)\)], True, 0]*) \)\)\)], "Input",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[f[x], {x, \(-13\), 13}];\)\)], "Input",
  InitializationCell->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.03663 0.309017 0.294302 [
[.1337 .29652 -9 -9 ]
[.1337 .29652 9 0 ]
[.31685 .29652 -6 -9 ]
[.31685 .29652 6 0 ]
[.68315 .29652 -3 -9 ]
[.68315 .29652 3 0 ]
[.8663 .29652 -6 -9 ]
[.8663 .29652 6 0 ]
[.4875 .01472 -12 -4.5 ]
[.4875 .01472 0 4.5 ]
[.4875 .16187 -24 -4.5 ]
[.4875 .16187 0 4.5 ]
[.4875 .45617 -18 -4.5 ]
[.4875 .45617 0 4.5 ]
[.4875 .60332 -6 -4.5 ]
[.4875 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.1337 .30902 m
.1337 .31527 L
s
[(-10)] .1337 .29652 0 1 Mshowa
.31685 .30902 m
.31685 .31527 L
s
[(-5)] .31685 .29652 0 1 Mshowa
.68315 .30902 m
.68315 .31527 L
s
[(5)] .68315 .29652 0 1 Mshowa
.8663 .30902 m
.8663 .31527 L
s
[(10)] .8663 .29652 0 1 Mshowa
.125 Mabswid
.17033 .30902 m
.17033 .31277 L
s
.20696 .30902 m
.20696 .31277 L
s
.24359 .30902 m
.24359 .31277 L
s
.28022 .30902 m
.28022 .31277 L
s
.35348 .30902 m
.35348 .31277 L
s
.39011 .30902 m
.39011 .31277 L
s
.42674 .30902 m
.42674 .31277 L
s
.46337 .30902 m
.46337 .31277 L
s
.53663 .30902 m
.53663 .31277 L
s
.57326 .30902 m
.57326 .31277 L
s
.60989 .30902 m
.60989 .31277 L
s
.64652 .30902 m
.64652 .31277 L
s
.71978 .30902 m
.71978 .31277 L
s
.75641 .30902 m
.75641 .31277 L
s
.79304 .30902 m
.79304 .31277 L
s
.82967 .30902 m
.82967 .31277 L
s
.09707 .30902 m
.09707 .31277 L
s
.06044 .30902 m
.06044 .31277 L
s
.02381 .30902 m
.02381 .31277 L
s
.90293 .30902 m
.90293 .31277 L
s
.93956 .30902 m
.93956 .31277 L
s
.97619 .30902 m
.97619 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 .01472 m
.50625 .01472 L
s
[(-1)] .4875 .01472 1 0 Mshowa
.5 .16187 m
.50625 .16187 L
s
[(-0.5)] .4875 .16187 1 0 Mshowa
.5 .45617 m
.50625 .45617 L
s
[(0.5)] .4875 .45617 1 0 Mshowa
.5 .60332 m
.50625 .60332 L
s
[(1)] .4875 .60332 1 0 Mshowa
.125 Mabswid
.5 .04415 m
.50375 .04415 L
s
.5 .07358 m
.50375 .07358 L
s
.5 .10301 m
.50375 .10301 L
s
.5 .13244 m
.50375 .13244 L
s
.5 .1913 m
.50375 .1913 L
s
.5 .22073 m
.50375 .22073 L
s
.5 .25016 m
.50375 .25016 L
s
.5 .27959 m
.50375 .27959 L
s
.5 .33845 m
.50375 .33845 L
s
.5 .36788 m
.50375 .36788 L
s
.5 .39731 m
.50375 .39731 L
s
.5 .42674 m
.50375 .42674 L
s
.5 .4856 m
.50375 .4856 L
s
.5 .51503 m
.50375 .51503 L
s
.5 .54446 m
.50375 .54446 L
s
.5 .57389 m
.50375 .57389 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.02605 .41958 L
.02729 .47444 L
.02846 .51954 L
.02954 .55401 L
.03072 .58179 L
.0318 .5974 L
.03279 .60318 L
.03396 .59908 L
.03506 .58462 L
.03626 .55756 L
.03756 .51668 L
.0402 .40441 L
.04262 .28417 L
.04497 .17103 L
.04626 .11729 L
.04748 .0752 L
.04817 .05565 L
.04892 .03854 L
.05023 .01951 L
.05087 .01543 L
.05156 .01505 L
.05278 .0244 L
.05393 .0446 L
.05516 .0776 L
.05739 .16193 L
.06244 .40826 L
.06381 .46985 L
.06526 .52559 L
.0665 .56273 L
.0672 .57887 L
.06787 .59044 L
.06859 .59891 L
.06935 .60305 L
.06999 .60264 L
.0707 .59803 L
.07147 .58826 L
.07229 .57251 L
.07306 .55288 L
.07376 .53133 L
.07891 .3013 L
.08162 .17028 L
.0831 .10947 L
.08448 .06413 L
.08572 .03529 L
.08641 .0244 L
.08705 .01796 L
.08774 .01485 L
.08849 .01616 L
.0892 .0219 L
Mistroke
.08986 .03103 L
.09112 .05824 L
.09226 .09299 L
.09482 .19831 L
.09948 .4271 L
.10075 .4828 L
.10212 .53318 L
.10341 .56954 L
.10458 .59165 L
.10578 .60247 L
.10709 .60008 L
.10833 .58441 L
.10947 .55894 L
.11066 .52222 L
.11197 .47154 L
.11463 .347 L
.11698 .22948 L
.11945 .11999 L
.12047 .08359 L
.12156 .05238 L
.12275 .02844 L
.12386 .0167 L
.12454 .01472 L
.12526 .01696 L
.12658 .0325 L
.12786 .06115 L
.12904 .09814 L
.13175 .21253 L
.13462 .35515 L
.13693 .46408 L
.13821 .5147 L
.13942 .55367 L
.1401 .57111 L
.14085 .58601 L
.14215 .60115 L
.14279 .6033 L
.14347 .60168 L
.1447 .58876 L
.14583 .56582 L
.14707 .52964 L
.14958 .42854 L
.15405 .20821 L
.15658 .10145 L
.15731 .0771 L
.15799 .0574 L
.15928 .0301 L
.16049 .01671 L
.16161 .01556 L
.16284 .02671 L
.16415 .05216 L
Mistroke
.16528 .08466 L
.16631 .12178 L
.16864 .22475 L
.17284 .43197 L
.17519 .52693 L
.17583 .54739 L
.17652 .56599 L
.17775 .59038 L
.17901 .60234 L
.1802 .60113 L
.18126 .58974 L
.18242 .56693 L
.1874 .37139 L
.19014 .23425 L
.19149 .17096 L
.19274 .11891 L
.19389 .07864 L
.19515 .04458 L
.19643 .02287 L
.19712 .01671 L
.19778 .01472 L
.19893 .02022 L
.19999 .03517 L
.20115 .0619 L
.20237 .10054 L
.20758 .34009 L
.21011 .46057 L
.21122 .50542 L
.21242 .54601 L
.21373 .57894 L
.21496 .59758 L
.21565 .60238 L
.21638 .60302 L
.21768 .59277 L
.21837 .58169 L
.2191 .56563 L
.22043 .52656 L
.222 .46574 L
.22344 .40012 L
.22823 .16627 L
.22961 .10996 L
.2309 .06707 L
.23206 .03865 L
.23332 .02004 L
.23443 .01472 L
.23564 .02105 L
.23691 .04095 L
.23809 .07089 L
.2392 .10788 L
.24021 .14788 L
Mistroke
.24248 .25323 L
.24496 .37749 L
.24759 .49545 L
.24896 .54344 L
.24969 .56379 L
.25047 .58124 L
.25119 .59292 L
.25185 .59984 L
.25314 .60265 L
.25442 .59129 L
.25561 .56855 L
.25691 .53126 L
.25831 .47933 L
.26322 .24314 L
.26582 .12576 L
.26713 .07903 L
.26789 .0573 L
.26857 .04113 L
.2698 .02156 L
.27112 .01473 L
.27234 .02178 L
.2735 .04007 L
.27414 .05472 L
.27484 .07441 L
.27627 .12439 L
.27883 .23935 L
.28185 .39024 L
.28317 .45185 L
.28462 .51075 L
.28589 .55208 L
.28706 .58038 L
.2883 .59832 L
.289 .60269 L
.28963 .60305 L
.29032 .59948 L
.29096 .59256 L
.29166 .58105 L
.2924 .56458 L
.29365 .52774 L
.29502 .47576 L
.2997 .2508 L
.30216 .13745 L
.30352 .08703 L
.30479 .05042 L
.30547 .0358 L
.30621 .02419 L
.30749 .01489 L
.3088 .02001 L
.31 .03747 L
.31115 .06491 L
Mistroke
.31241 .1058 L
.31495 .21463 L
.31744 .33888 L
.3198 .45186 L
.32192 .53406 L
.32312 .56801 L
.32423 .58973 L
.32543 .60189 L
.32612 .60327 L
.32676 .60086 L
.32805 .58535 L
.32878 .57061 L
.32945 .55353 L
.33075 .51119 L
.33217 .45353 L
.33504 .31544 L
.33756 .19125 L
.33895 .13096 L
.34026 .08325 L
.34148 .04891 L
.34217 .03449 L
.34281 .02459 L
.34393 .01538 L
.34512 .01745 L
.34633 .03204 L
.34766 .06152 L
.3489 .10104 L
.35006 .14618 L
.35457 .36393 L
.35711 .48063 L
.35835 .52731 L
.35949 .56151 L
.36069 .587 L
.36198 .60143 L
.36261 .60332 L
.36331 .60134 L
.36404 .59481 L
.36472 .5847 L
.36587 .55934 L
.36711 .52102 L
.36936 .42845 L
.37358 .22049 L
.37597 .11594 L
.37717 .07444 L
.37787 .05501 L
.3785 .04037 L
.37963 .02224 L
.38085 .01476 L
.38197 .01922 L
.38305 .03348 L
Mistroke
.38429 .06164 L
.38564 .10468 L
.38808 .20838 L
.39264 .43255 L
.39397 .49013 L
.39522 .53534 L
.39653 .57143 L
.39722 .58534 L
.39796 .59594 L
.39928 .60332 L
.40052 .59654 L
.40164 .57928 L
.40286 .54928 L
.40742 .3594 L
.40982 .23931 L
.41234 .12581 L
.41342 .08676 L
.41456 .05336 L
.41582 .02809 L
.41699 .01625 L
.41814 .01604 L
.41922 .02623 L
.42019 .0437 L
.42125 .07093 L
.42238 .10879 L
.42362 .15904 L
.42614 .27871 L
.4285 .39631 L
.43065 .49189 L
.43189 .53635 L
.43323 .57313 L
.43397 .58743 L
.43466 .5967 L
.43531 .60184 L
.43601 .60326 L
.43666 .60079 L
.43737 .59402 L
.43864 .57129 L
.43988 .53712 L
.44103 .4966 L
.44632 .24578 L
.4489 .1287 L
.45003 .08738 L
.45125 .0519 L
.45253 .02692 L
.45374 .0157 L
.45441 .01488 L
.45512 .01826 L
.4564 .03512 L
.45706 .0492 L
Mistroke
.45778 .06814 L
.45908 .11143 L
.46204 .24224 L
.46455 .36815 L
.46692 .47731 L
.46823 .52693 L
.46892 .54876 L
.46965 .56819 L
.47094 .59248 L
.47213 .60263 L
.47281 .60298 L
.47354 .59893 L
.47485 .58025 L
.47565 .562 L
.47642 .54027 L
.47784 .48926 L
.48315 .2358 L
.48557 .12704 L
.48679 .08287 L
.4875 .06182 L
.48814 .04567 L
.48929 .02507 L
.49053 .01514 L
.49162 .01732 L
.49277 .03062 L
.49402 .05732 L
.49472 .07741 L
.49536 .09859 L
.49777 .19894 L
.50324 .37043 L
.50808 .51105 L
.50925 .54233 L
.51052 .57065 L
.51124 .58356 L
.51191 .59281 L
.5132 .6027 L
.51437 .60101 L
.51546 .58953 L
.51665 .56543 L
.51792 .5266 L
.51913 .47777 L
.52027 .42283 L
.5224 .30462 L
.52493 .16139 L
.52632 .09518 L
.52761 .04843 L
.52871 .02352 L
.52989 .01474 L
.5312 .02843 L
.53239 .06242 L
Mistroke
.53306 .08994 L
.53377 .12511 L
.53505 .20098 L
.53794 .40075 L
.53914 .478 L
.54044 .54548 L
.54118 .5738 L
.54186 .59185 L
.54251 .60137 L
.54319 .60279 L
.54443 .58244 L
.54513 .55829 L
.54577 .52857 L
.54695 .45786 L
.5482 .3666 L
.5504 .19541 L
.5516 .11328 L
.55275 .0545 L
.55406 .01844 L
.55526 .0194 L
.55639 .05048 L
.55761 .11458 L
.55896 .21279 L
.56039 .33377 L
.56172 .44463 L
.56295 .52901 L
.56412 .58252 L
.56535 .60331 L
.56658 .58382 L
.56728 .55527 L
.56793 .51841 L
.56911 .43086 L
.57018 .33628 L
.57144 .22208 L
.5726 .12745 L
.57364 .06209 L
.57475 .02199 L
.57586 .01732 L
.57709 .05477 L
.57814 .11923 L
.57928 .21344 L
.58133 .40818 L
.58263 .51523 L
.58386 .58186 L
.58454 .59974 L
.58528 .60209 L
.58657 .56359 L
.5878 .48163 L
.5891 .36231 L
.59032 .23997 L
Mistroke
.59143 .13783 L
.59274 .04996 L
.59347 .02333 L
.59415 .01472 L
.59537 .04076 L
.59669 .12398 L
.59943 .39509 L
.60018 .46691 L
.60099 .53162 L
.60176 .57566 L
.60246 .59839 L
.60364 .59458 L
.60492 .53142 L
.60557 .47971 L
.60627 .41373 L
.60752 .28046 L
.60821 .20692 L
.60897 .13474 L
.60963 .08205 L
.61033 .04124 L
.61097 .02006 L
.61167 .01544 L
.61289 .05536 L
.61513 .25258 L
.61636 .38865 L
.61751 .502 L
.61817 .5514 L
.61888 .58748 L
.62013 .60006 L
.62139 .54549 L
.62255 .44554 L
.62508 .16565 L
.62636 .05967 L
.62708 .02572 L
.62776 .01472 L
.62901 .04916 L
.63015 .13593 L
.63146 .27863 L
.63271 .42241 L
.63383 .52958 L
.63502 .5947 L
.63604 .59911 L
.63716 .54771 L
.63836 .43857 L
.63965 .28733 L
.64078 .15802 L
.64199 .05572 L
.64331 .01473 L
.64453 .05337 L
.64528 .1104 L
Mistroke
.64599 .18199 L
.64731 .34014 L
.64861 .48794 L
.64927 .54495 L
.64999 .58684 L
.65077 .60331 L
.6515 .58987 L
.65218 .55382 L
.6529 .49315 L
.65418 .34698 L
.65558 .1763 L
.6569 .05613 L
.65812 .01473 L
.65922 .04563 L
.66043 .14686 L
.66169 .29908 L
.66288 .44607 L
.66406 .55609 L
.66531 .60323 L
.66649 .56806 L
.66757 .47573 L
.66886 .31785 L
.66957 .2266 L
.67023 .14816 L
.67141 .04685 L
.6727 .01629 L
.67393 .07525 L
.67525 .21495 L
.67667 .39962 L
.67736 .48199 L
.67801 .5434 L
.67927 .60234 L
.67993 .59628 L
.68064 .56143 L
.6819 .43902 L
.68304 .29039 L
.6842 .14431 L
.68542 .0397 L
.68647 .01535 L
.68761 .06525 L
.68885 .19307 L
.69017 .37001 L
.69142 .51799 L
.69256 .59413 L
.69371 .59145 L
.69477 .51797 L
.69593 .37997 L
.69717 .21148 L
.69824 .08944 L
.69925 .02418 L
Mistroke
.70035 .02516 L
.70153 .11047 L
.70393 .42421 L
.70462 .50575 L
.70528 .56341 L
.7065 .60283 L
.70765 .55006 L
.70871 .43664 L
.70987 .27683 L
.71111 .11711 L
.71236 .02414 L
.71354 .02919 L
.71425 .07698 L
.71493 .14824 L
.7162 .3216 L
.71745 .4879 L
.71815 .55587 L
.71878 .59296 L
.71953 .60177 L
.72024 .574 L
.72088 .52031 L
.72159 .43837 L
.72282 .26377 L
.72414 .09625 L
.7249 .03643 L
.72559 .015 L
.72628 .02797 L
.72694 .07087 L
.72836 .24124 L
.72914 .35512 L
.72987 .45601 L
.73116 .57993 L
.73185 .60283 L
.73259 .58905 L
.73388 .47651 L
.73511 .30412 L
.73623 .14699 L
.73743 .03599 L
.73873 .02612 L
.73994 .12499 L
.74068 .22266 L
.74138 .32625 L
.74269 .5044 L
.74385 .59412 L
.74509 .58149 L
.74627 .47017 L
.74734 .31719 L
.74859 .13802 L
.7493 .06351 L
.74996 .02346 L
Mistroke
.75116 .03568 L
.75244 .16113 L
.75359 .32983 L
.7548 .49884 L
.75543 .56155 L
.75613 .59871 L
.75734 .57284 L
.75804 .50867 L
.75879 .41101 L
.76013 .20731 L
.76084 .11398 L
.76151 .05005 L
.76275 .01863 L
.76382 .08903 L
.76499 .24382 L
.76613 .4189 L
.76736 .5621 L
.76851 .60249 L
.76956 .54611 L
.77061 .41648 L
.77161 .26165 L
.77277 .10201 L
.774 .01723 L
.77516 .04977 L
.77621 .16489 L
.77745 .35517 L
.7781 .45265 L
.77879 .53624 L
.78006 .60332 L
.78122 .54717 L
.78245 .3899 L
.78378 .18233 L
.78503 .04292 L
.78619 .02014 L
.78724 .09639 L
.78839 .2573 L
.78952 .4361 L
.79072 .5717 L
.79204 .59358 L
.79324 .48636 L
.79454 .28803 L
.79529 .17224 L
.79597 .08643 L
.7972 .01484 L
.79852 .08435 L
.79974 .25351 L
.80089 .43742 L
.80195 .56335 L
.80311 .60104 L
.80433 .51281 L
Mistroke
.80547 .34625 L
.80652 .17841 L
.80751 .05871 L
.80865 .01589 L
.80969 .07967 L
.81084 .23753 L
.81206 .43574 L
.81311 .56215 L
.81426 .60127 L
.81549 .51024 L
.81618 .4123 L
.81682 .30793 L
.81798 .12818 L
.81923 .02022 L
.8205 .05553 L
.8217 .20813 L
.82277 .38579 L
.82395 .54684 L
.82523 .60175 L
.82593 .56658 L
.82658 .49614 L
.82775 .31349 L
.82901 .11702 L
.83017 .01978 L
.83145 .05833 L
.83265 .21583 L
.83377 .40327 L
.83487 .55154 L
.83587 .60327 L
.83703 .54237 L
.83812 .39025 L
.83942 .17274 L
.84063 .03547 L
.8419 .03415 L
.84257 .09563 L
.84329 .19761 L
.84457 .41384 L
.84578 .56829 L
.84687 .60007 L
.84806 .5038 L
.84945 .27884 L
.85076 .08231 L
.85142 .02797 L
.85213 .01682 L
.85292 .06403 L
.85364 .1541 L
.85494 .3737 L
.85616 .54746 L
.85742 .60088 L
.85809 .56313 L
Mistroke
.8588 .47872 L
.86014 .25452 L
.86139 .07195 L
.8627 .01799 L
.86339 .06052 L
.86413 .15316 L
.86545 .37761 L
.8667 .55496 L
.86782 .60195 L
.86905 .50628 L
.8698 .38971 L
.87051 .26436 L
.87116 .15681 L
.87184 .06851 L
.87258 .01858 L
.87327 .0241 L
.874 .08405 L
.87481 .20009 L
.87615 .43285 L
.87689 .53782 L
.87758 .59309 L
.87821 .60108 L
.8789 .56071 L
.88015 .3845 L
.88132 .17997 L
.88257 .03237 L
.88329 .01598 L
.88395 .05029 L
.88524 .22743 L
.88589 .34571 L
.8866 .46494 L
.88786 .59546 L
.88918 .55453 L
.88994 .455 L
.89063 .33675 L
.89179 .13666 L
.89302 .01962 L
.89366 .02154 L
.89437 .07547 L
.89561 .26651 L
.89678 .47132 L
.89804 .59724 L
.89922 .56196 L
.90031 .41219 L
.9014 .21432 L
.90258 .0511 L
.90388 .02886 L
.9051 .16949 L
.9064 .40161 L
.9071 .51275 L
Mistroke
.90776 .581 L
.90893 .58627 L
.9102 .43013 L
.9114 .21387 L
.91252 .05495 L
.91354 .01654 L
.91463 .1054 L
.91581 .30414 L
.91708 .51766 L
.91827 .60325 L
.91937 .53902 L
.92065 .33313 L
.92186 .12094 L
.92318 .01494 L
.92392 .0423 L
.92461 .12094 L
.92534 .24242 L
.92602 .37033 L
.9273 .56121 L
.92801 .60235 L
.92867 .58627 L
.9294 .51256 L
.93016 .38817 L
.93135 .17023 L
.93262 .02468 L
.93382 .05257 L
.93491 .20748 L
.93619 .44405 L
.93692 .5476 L
.93759 .59792 L
.93882 .55116 L
.94012 .34416 L
.9413 .13163 L
.9424 .0212 L
.94354 .05583 L
.9448 .24471 L
.94586 .4436 L
.94687 .57538 L
.94803 .58854 L
.94908 .46635 L
.95025 .24969 L
.95149 .05895 L
.95255 .01755 L
.95371 .12677 L
.95496 .35432 L
.95565 .47713 L
.95631 .5626 L
.95757 .58991 L
.95873 .45119 L
.95983 .24357 L
Mistroke
.96083 .08143 L
.96198 .01556 L
.96307 .10253 L
.96407 .27672 L
.965 .45107 L
.96602 .5809 L
.96709 .58849 L
.96817 .45764 L
.96934 .23777 L
.97043 .06532 L
.97143 .01545 L
.9726 .11563 L
.97388 .34837 L
.97508 .54645 L
.97619 .60149 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  InitializationCell->True,
  ImageSize->{288, 177.938},
  ImageMargins->{{281, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40n007h00OSoll00<00?lloc`0
S_ll002?oc`00`00occo?02>oc`008Ko?0@000Go?003003o??ll08ko?000R?ll00<00?lloc`01?ll
00<00?lloc`0S_ll000?oc`00`00occo?007oc`20009oc`00`00occo?007oc`00`00occo?008oc`0
0`00occo?007oc`00`00occo?008oc`00`00occo?007oc`00`00occo?007oc`00`00occo?008oc`0
0`00occo?007oc`20009oc`00`00occo?003oc`01@00occo??ll00000_ll0`001_ll00<00?lloc`0
3oll00<00?lloc`00_ll00D00?llocco?00000Co?005003o??lloc`00007oc`00`00occo?008oc`0
0`00occo?00Boc`01000occo?0005?ll00<00?lloc`02Oll00<00?lloc`02?ll00@00?lloc`000Wo
?0003oll00<00?lloc`01oll0P002Oll00<00?lloc`01oll00<00?lloc`02?ll00<00?lloc`01oll
00<00?lloc`02?ll00<00?lloc`01oll00<00?lloc`01oll0P002Oll00<00?lloc`01oll0P001oll
10001?ll00@00?llocco?0800003oc`00?ll00Oo?003003o??ll00?o?08000Go?003003o??ll00;o
?003003o??ll00;o?005003o??lloc`00004oc`01@00occo??ll00000oll00D00?llocco?00000[o
?003003o??ll00So?004003o??ll0006oc`01000occo?0002oll00@00?lloc`000;o?004003o??ll
0002oc`00`00occo?003oc`01000occo?0001oll00@00?lloc`000;o?003003o??ll00Oo?0003oll
00<00?lloc`01oll0P002Oll00<00?lloc`01oll0P002?ll0P002Oll0P002?ll0P002Oll00<00?ll
oc`01oll0P002Oll00<00?lloc`01oll0P002Oll00<00?lloc`00oll00@00?llocco?0800003oc`0
0?ll00Ko?08000Go?08000Co?08000Co?003003o??ll00;o?005003o??lloc`00004oc`01@00occo
??ll00000oll00D00?llocco?00000[o?003003o??ll00So?004003o??ll0003oc`01000occo?000
0_ll00@00?lloc`000;o?003003o??ll00?o?004003o??ll0002oc`01000occo?0000_ll00<00?ll
oc`00oll00@00?lloc`000Co?004003o??ll0002oc`01000occo?0002Oll000?oc`00`00occo?007
oc`20008oc`20009oc`20008oc`20009oc`20008oc`20009oc`00`00occo?007oc`20009oc`00`00
occo?007oc`20008oc`20003oc`30003oc`200000oll003o?006oc`20005oc`20004oc`20004oc`0
0`00occo?002oc`01@00occo??ll00001?ll00D00?llocco?00000?o?005003o??lloc`00003oc`0
1@00occo??ll00000_ll0P000_ll00@00?lloc`000?o?004003o??ll0003oc`01000occo?0000_ll
00@00?lloc`000;o?003003o??ll00?o?004003o??ll0002oc`200001Oll003o??ll00001Oll00H0
0?lloc`00?ll0002oc`01000occo?0000_ll00@00?lloc`000Wo?0003oll00<00?lloc`01oll0P00
2?ll0P002Oll0P002?ll0P002Oll0P002?ll0P002Oll00<00?lloc`01oll0P002Oll0P002?ll0P00
2?ll00<00?ll00001?ll00@00?llocco?0800003oc`00?ll00Ko?08000Go?08000Co?08000Co?003
003o??ll00;o?005003o??lloc`00004oc`01@00occo??ll00000oll00D00?llocco?00000?o?005
003o??lloc`00002oc`20002oc`01000occo?0000oll00@00?lloc`000?o?004003o??ll0002oc`0
1000occo?0000_ll00<00?lloc`00oll00@00?lloc`000;o?0800005oc`00?lloc`00002oc`01000
occo?0000_ll00<00?ll00000_ll00@00?lloc`000;o?004003o??ll0009oc`000ko?08000Wo?080
00So?08000Wo?08000So?08000Wo?08000So?08000So?003003o?00000So?08000So?003003o?000
00So?08000So?003003o?00000So?0800003oc`00?ll00Ko?08000Go?08000Co?08000Co?003003o
??ll00;o?005003o??lloc`00004oc`01@00occo??ll00000oll00D00?llocco?00000?o?005003o
??lloc`00002oc`20002oc`00`00occo?0020002oc`01000occo?0000oll00@00?lloc`000;o?004
003o??ll0002oc`00`00occo?003oc`01000occo?0000_ll0P0000Go?000occo?00000;o?004003o
??ll0002oc`00`00oc`00002oc`01000occo?0000_ll00@00?lloc`000Wo?0003_ll0P002Oll0P00
2?ll0P002Oll0P002?ll0P002Oll0P002?ll0P002?ll00<00?ll00002?ll0P002?ll00<00?ll0000
2?ll0P002?ll00<00?ll00002?ll0P0000?o?000oc`01_ll0P001Oll0P001?ll0P001?ll00@00?ll
occo?08000?o?08000?o?005003o??lloc`00003oc`01@00occo??ll00000oll00D00?llocco?000
00;o?08000;o?003003o??ll008000;o?003003o??ll00800003oc`0000000;o?004003o??ll0002
oc`01000occo?0000_ll0P0000Go?000occo?00000;o?0800005oc`00000oc`00002oc`01000occo
?0000_ll00<00?ll00000_ll00@00?lloc`000;o?004003o??ll0009oc`000ko?003003o?00000So
?08000So?08000Wo?08000So?08000Wo?08000So?08000So?003003o?00000So?08000So?003003o
?00000So?08000So?003003o?00000So?0800003oc`00?ll00Ko?08000Go?08000Co?08000?o?080
00?o?08000?o?08000?o?005003o??lloc`00003oc`01@00occo??ll00000oll00D00?llocco?000
00;o?08000;o?003003o??ll008000;o?003003o??ll00800003oc`0000000;o?004003o??ll0002
oc`01000occo?0000_ll0P0000Go?000occo?00000;o?0800005oc`00000oc`00002oc`01000occo
?0000_ll00<00?ll00000_ll00@00?lloc`000;o?004003o??ll0009oc`000ko?003003o?00000So
?08000So?08000Wo?08000So?08000Wo?08000So?08000So?003003o?00000So?08000So?003003o
?00000So?08000So?003003o?00000So?0800003oc`0000000Ko?08000Go?08000Co?08000?o?080
00?o?08000?o?08000?o?005003o??lloc`00003oc`01000occo??ll0P000_ll00D00?llocco?000
00;o?08000;o?003003o??ll008000;o?003003o??ll00800003oc`0000000;o?004003o??ll0002
oc`00`00occo?00200001?ll00000?ll0P0000Co?000003o?0800005oc`00000oc`00002oc`01000
occo?0000_ll00D00?ll00000?ll00800006oc`00?lloc`00?ll0P002Oll000>oc`00`00oc`00008
oc`20008oc`20008oc`00`00oc`00008oc`20009oc`20008oc`20008oc`00`00oc`00008oc`20008
oc`00`00oc`00008oc`20008oc`00`00oc`00008oc`200000oll003o?006oc`20005oc`20004oc`2
0003oc`20003oc`20003oc`20003oc`01@00occo??ll00000oll00@00?llocco?08000;o?005003o
??lloc`00002oc`20002oc`00`00occo?0020002oc`00`00occo?00200000oll00000002oc`01000
occo?0000_ll00<00?lloc`00P0000Co?000003o?0800004oc`00000oc`200001Oll00000?ll0000
0_ll00@00?lloc`000;o?005003o?000003o?00200001_ll003o??ll003o?08000Wo?0003_ll00<0
0?ll00002?ll0P002?ll00<00?ll00001oll00<00?ll00002?ll0P002Oll0P002?ll00<00?ll0000
1oll00<00?ll00002?ll00<00?ll00001oll00<00?ll00002?ll0P002?ll00<00?ll00002?ll0P00
00?o?000oc`01_ll0P001Oll0P001?ll0P000oll0P000oll0P000oll0P000oll00D00?llocco?000
00?o?08000;o?08000;o?005003o??lloc`00002oc`20002oc`00`00occo?0020002oc`00`00occo
?00200000oll00000002oc`01000occo?0000_ll00<00?lloc`00P0000Co?000003o?0800004oc`0
0000oc`200001?ll00000?ll0P0000Go?000occo?00000;o?005003o?000003o?00200000oll003o
?00200000oll00000009oc`000ko?003003o?00000Oo?003003o?00000So?003003o?00000Oo?003
003o?00000So?003003o?00000So?08000So?003003o?00000Oo?003003o?00000So?003003o?000
00Oo?003003o?00000So?08000So?003003o?00000So?0800003oc`00?ll00Ko?08000Go?08000Co
?08000?o?08000?o?08000?o?08000?o?005003o??lloc`00003oc`20002oc`20002oc`01@00occo
??ll00000_ll0P000_ll00<00?lloc`00P000_ll00<00?lloc`00P0000Co?000003o?08000;o?004
003o??ll0002oc`200001?ll00000?ll0P0000Co?000003o?0800004oc`00000oc`200001Oll003o
??ll00000_ll00D00?ll00000?ll00800003oc`00?ll00800003oc`0000000Wo?0003_ll00<00?ll
00001oll00<00?ll00002?ll00<00?ll00001oll00<00?ll00002?ll00<00?ll00001oll00<00?ll
00002?ll00<00?ll00001oll00<00?ll00002?ll00<00?ll00001oll00<00?ll00002?ll0P002?ll
00<00?ll00001oll00D00?ll003o?00000Oo?08000Go?08000Co?08000?o?08000?o?08000?o?080
00?o?005003o??lloc`00003oc`20002oc`20002oc`01@00occo??ll00000_ll0P000_ll00<00?ll
oc`00P000_ll00<00?lloc`00P0000Co?000003o?08000;o?004003o??ll0002oc`200001?ll0000
0?ll0P0000Co?000003o?0800004oc`00000oc`200001Oll003o??ll00000_ll00D00?ll00000?ll
00800003oc`00?ll00800003oc`0000000Wo?0003_ll00<00?ll00001oll00<00?ll00002?ll00<0
0?ll00001oll00<00?ll00002?ll00<00?ll00001oll00<00?ll00002?ll00<00?ll00001oll00<0
0?ll00002?ll00<00?ll00001oll00<00?ll00002?ll00<00?ll00001oll00<00?ll00001oll00D0
0?ll003o?00000Oo?08000Go?08000Co?08000?o?08000?o?08000?o?08000?o?005003o??lloc`0
0003oc`20002oc`20002oc`01@00occo??ll00000_ll0P000_ll00<00?lloc`00P000_ll00<00?ll
oc`00P0000Co?000003o?08000;o?004003o??ll0002oc`200001?ll00000?ll0P0000Co?000003o
?0800004oc`00000oc`200001Oll003o??ll00000_ll00D00?ll00000?ll00800003oc`00?ll0080
0003oc`0000000Wo?0003_ll00<00?ll00001oll00<00?ll00002?ll00<00?ll00001oll00<00?ll
00002?ll00<00?ll00001oll00<00?ll00002?ll00<00?ll00001oll00<00?ll00002?ll00<00?ll
00001oll00<00?ll00002?ll00<00?ll00001oll00<00?ll00001oll00D00?ll003o?00000Oo?080
00Go?08000Co?08000?o?08000?o?08000?o?08000?o?005003o??lloc`00003oc`20002oc`20002
oc`01@00occo??ll00000_ll0P000_ll00<00?lloc`00P000_ll00<00?lloc`00P0000Co?000003o
?08000;o?004003o??ll0002oc`200001?ll00000?ll0P0000Co?000003o?0800004oc`00000oc`2
00001Oll003o??ll00000_ll00D00?ll00000?ll00800003oc`00?ll00800003oc`0000000Wo?000
3_ll00<00?ll00001oll00<00?ll00002?ll00<00?ll00001oll00<00?ll00002?ll00<00?ll0000
1oll00<00?ll00002?ll00<00?ll00001oll00<00?ll00002?ll00<00?ll00001oll00<00?ll0000
2?ll00<00?ll00001oll00<00?ll00001oll00D00?ll003o?00000Oo?08000Go?08000Co?08000?o
?08000?o?08000?o?08000?o?005003o??lloc`00003oc`20002oc`20002oc`01@00occo??ll0000
0_ll0P000_ll00<00?lloc`00P000_ll00<00?lloc`00P0000Co?000003o?08000;o?004003o??ll
0002oc`200001?ll00000?ll0P0000Co?000003o?0800004oc`00000oc`200001Oll003o??ll0000
0_ll00D00?ll00000?ll00800003oc`00?ll00800003oc`0000000Wo?0003_ll00<00?ll00001oll
00<00?ll00002?ll00<00?ll00001oll00@00?lloc`000Oo?003003o?00000Oo?003003o?00000So
?003003o?00000Oo?003003o?00000Oo?004003o??ll0007oc`00`00oc`00008oc`00`00oc`00007
oc`00`00oc`00007oc`01@00oc`00?ll00001oll0P001Oll0P001?ll0P000oll0P000oll0P000oll
0P000oll00D00?llocco?00000?o?08000;o?08000;o?08000;o?003003o??ll008000;o?003003o
??ll008000;o?003003o??ll00800004oc`00000oc`20002oc`01000occo?0000_ll0P0000Co?000
003o?0800004oc`00000oc`200001?ll00000?ll0P0000Ko?000occo?000oc`200001?ll00000?ll
0P0000?o?000oc`00P0000?o?00000002Oll000>oc`00`00oc`00007oc`00`00oc`00008oc`00`00
oc`00007oc`01000occo?0001oll00<00?ll00001oll00<00?ll00002?ll00<00?ll00001oll00<0
0?ll00001oll00@00?lloc`000Oo?003003o?00000Oo?004003o??ll0007oc`00`00oc`00007oc`0
1000oc`00?ll0P001_ll0P001Oll0P001?ll0P000oll0P000oll0P000oll0P000oll00D00?llocco
?00000?o?08000;o?08000;o?0800003oc`0000000;o?08000;o?003003o??ll008000;o?003003o
??ll00800004oc`00000oc`20002oc`01000occo?0000_ll0P0000Co?000003o?0800004oc`00000
oc`200001?ll00000?ll0P0000Ko?000occo?000oc`200001?ll00000?ll0P0000?o?000oc`00P00
00?o?00000002Oll000>oc`00`00oc`00007oc`01000occo?0001oll00<00?ll00001oll00@00?ll
oc`000Oo?003003o?00000Oo?003003o?00000So?003003o?00000Oo?003003o?00000Oo?004003o
??ll0007oc`00`00oc`00007oc`01000occo?0001oll00<00?ll00001oll00D00?ll003o?00000Oo
?08000Go?08000Co?08000?o?08000?o?08000?o?08000?o?005003o??lloc`00003oc`20002oc`2
0002oc`200000oll00000002oc`20002oc`00`00occo?0020002oc`00`00occo?00200001?ll0000
0?ll0P000_ll00@00?lloc`000;o?0800004oc`00000oc`200001?ll00000?ll0P0000Co?000003o
?0800006oc`00?lloc`00?ll0P0000Co?000003o?0800003oc`00?ll00800003oc`0000000Wo?000
3_ll00<00?ll00001oll00@00?lloc`000Oo?003003o?00000Oo?004003o??ll0007oc`00`00oc`0
0007oc`00`00oc`00008oc`00`00oc`00007oc`00`00oc`00007oc`01000occo?0001oll00<00?ll
00001oll00@00?lloc`000Oo?003003o?00000Oo?005003o?000oc`00007oc`20005oc`20004oc`2
0003oc`20003oc`20003oc`20003oc`01@00occo??ll00000oll0P000_ll0P000_ll0P0000?o?000
00000_ll0P000_ll00<00?lloc`00P000_ll00<00?lloc`00P0000Co?000003o?08000;o?004003o
??ll0002oc`200001?ll00000?ll0P0000Co?000003o?0800004oc`00000oc`200001_ll003o??ll
003o?0800004oc`00000oc`200000oll003o?00200000oll00000009oc`000ko?003003o?00000Oo
?004003o??ll0007oc`00`00oc`00007oc`01000occo?0001oll00<00?ll00001oll00<00?ll0000
2?ll00<00?ll00001oll00<00?ll00001oll00@00?lloc`000Oo?003003o?00000Oo?004003o??ll
0007oc`00`00oc`00007oc`01@00oc`00?ll00001oll0P001Oll0P001?ll0P000oll00<00?ll0000
0_ll0P000oll0P000oll00D00?llocco?00000?o?08000;o?08000;o?0800003oc`0000000;o?080
00;o?003003o??ll00800003oc`0000000;o?0800004oc`00000oc`20002oc`01000occo?0000_ll
0P0000Co?000003o?0800004oc`00000oc`200001?ll00000?ll0P0000Ko?000occo?000oc`20000
1?ll00000?ll0P0000?o?000oc`00P0000?o?00000002Oll000>oc`00`00oc`00007oc`01000occo
?0001oll00<00?ll00001oll00@00?lloc`000Oo?003003o?00000Oo?003003o?00000So?003003o
?00000Oo?003003o?00000Oo?004003o??ll0007oc`00`00oc`00007oc`01000occo?0001oll00<0
0?ll00001oll00D00?ll003o?00000Oo?08000Go?08000Co?08000?o?003003o?00000;o?08000?o
?08000?o?005003o??lloc`00003oc`20002oc`20002oc`200000oll00000002oc`20002oc`00`00
occo?00200000oll00000002oc`200001?ll00000?ll0P000_ll00@00?lloc`000;o?0800004oc`0
0000oc`200001?ll00000?ll0P0000Co?000003o?0800006oc`00?lloc`00?ll0P0000Co?000003o
?0800003oc`00?ll00800003oc`0000000Wo?0003_ll00<00?ll00001oll00@00?lloc`000Oo?003
003o?00000Oo?004003o??ll0007oc`00`00oc`00007oc`01000occo?0001oll00<00?ll00001oll
00<00?ll00001oll00@00?lloc`000Oo?003003o?00000Oo?004003o??ll0007oc`00`00oc`00007
oc`00`00occo?0020007oc`20005oc`20004oc`20003oc`00`00oc`00002oc`20003oc`20003oc`0
1@00occo??ll00000oll0P000_ll0P000_ll0P0000?o?00000000_ll0P000_ll00<00?lloc`00P00
00?o?00000000_ll0P0000Co?000003o?08000;o?004003o??ll0002oc`200001?ll00000?ll0P00
00Co?000003o?0800004oc`00000oc`200001_ll003o??ll003o?0800004oc`00000oc`200000oll
003o?00200000oll00000009oc`000ko?003003o?00000Oo?004003o??ll0007oc`00`00oc`00007
oc`01000occo?0001oll00<00?ll00001oll00@00?lloc`000Oo?003003o?00000Oo?003003o?000
00Oo?004003o??ll0007oc`00`00oc`00007oc`01000occo?0001oll00<00?ll00001oll00<00?ll
oc`00P001oll0P001Oll0P001?ll0P000oll00<00?ll00000_ll0P000oll0P000oll00D00?llocco
?00000?o?08000;o?08000;o?0800003oc`0000000;o?0800003oc`0000000;o?0800003oc`00000
00;o?0800004oc`00000oc`20002oc`01000occo?0000_ll0P0000Co?000003o?0800004oc`00000
oc`200001?ll00000?ll0P0000Ko?000occo?000oc`200001?ll00000?ll0P0000?o?000oc`00P00
00?o?00000002Oll000>oc`00`00oc`00007oc`01000occo?0001oll00<00?ll00001oll00@00?ll
oc`000Oo?003003o?00000Oo?004003o??ll0007oc`00`00oc`00007oc`00`00oc`00007oc`01000
occo?0001oll00<00?ll00001oll00@00?lloc`000Oo?003003o?00000Oo?003003o??ll008000Oo
?08000Go?08000Co?08000?o?003003o?00000;o?08000?o?08000?o?004003o??lloc`20002oc`2
0002oc`20002oc`200000oll00000002oc`200000oll00000002oc`200000oll00000002oc`20000
1?ll00000?ll0P000_ll00@00?lloc`000;o?0800004oc`00000oc`200001?ll00000?ll0P0000Co
?000003o?0800006oc`00?lloc`00?ll0P0000Co?000003o?0800003oc`00?ll00800003oc`00000
00Wo?0003_ll00<00?ll00001oll00@00?lloc`000Oo?003003o?00000Oo?004003o??ll0006oc`0
1000occo?0001oll00@00?lloc`000Oo?003003o?00000Oo?003003o?00000Oo?004003o??ll0007
oc`00`00oc`00007oc`01000occo?0001oll00<00?ll00001oll00<00?lloc`00`001_ll0P001Oll
0P001?ll0P000oll00<00?ll00000_ll0P000oll0P000oll00@00?llocco?08000;o?08000;o?080
00;o?0800003oc`0000000;o?0800003oc`0000000;o?0800003oc`0000000;o?0800004oc`00000
oc`20002oc`01000occo?0000_ll0P0000Co?000003o?0800004oc`00000oc`200001?ll00000?ll
0P0000Ko?000003o?000oc`200001?ll00000?ll0P0000?o?000oc`00P0000?o?00000002Oll000>
oc`00`00oc`00007oc`01000occo?0001_ll00@00?lloc`000Oo?004003o??ll0006oc`01000occo
?0001oll00@00?lloc`000Ko?004003o??ll0007oc`00`00oc`00007oc`01000occo?0001oll00<0
0?ll00001oll00@00?lloc`000Oo?003003o?00000Oo?003003o??ll008000Oo?08000Go?08000Co
?08000?o?003003o?00000;o?08000?o?08000?o?004003o??lloc`20002oc`20002oc`20002oc`2
00000oll00000002oc`200000oll00000002oc`200000oll00000002oc`200001?ll00000?ll0P00
0_ll00@00?lloc`000;o?0800004oc`00000oc`200001?ll00000?ll0P0000Co?000003o?0800006
oc`00000oc`00?ll0P0000Co?000003o?0800003oc`00?ll00800003oc`0000000Wo?0003_ll00<0
0?ll00001oll00@00?lloc`000Ko?004003o??ll0007oc`01000occo?0001_ll00@00?lloc`000Oo
?004003o??ll0006oc`01000occo?0001oll00<00?ll00001oll00@00?lloc`000Oo?003003o?000
00Oo?004003o??ll0007oc`00`00oc`00007oc`00`00occo?0020007oc`20005oc`20004oc`20003
oc`00`00oc`00002oc`20003oc`20002oc`20003oc`20002oc`20002oc`20002oc`200000oll0000
0002oc`200000oll00000002oc`200000oll00000002oc`200001?ll00000?ll0P000_ll00@00?ll
oc`000;o?0800004oc`00000oc`200001?ll00000?ll0P0000Co?000003o?0800006oc`00000oc`0
0?ll0P0000Co?000003o?0800003oc`00?ll00800003oc`0000000Wo?0003_ll00<00?ll00001oll
00@00?lloc`000Ko?004003o??ll0007oc`01000occo?0001_ll00@00?lloc`000Oo?004003o??ll
0006oc`01000occo?0001oll00<00?ll00001oll00@00?lloc`000Oo?003003o?00000Oo?004003o
??ll0006oc`01000occo?0001oll00<00?lloc`00P001oll00<00?ll00001?ll0P001?ll0P000oll
00<00?ll00000_ll0P000oll0P000_ll0P000oll0P000_ll0P000_ll0P000_ll0P0000?o?0000000
0_ll0P0000?o?00000000_ll0P0000?o?00000000_ll0P0000Co?000003o?08000;o?004003o??ll
0002oc`200001?ll00000?ll0P0000Co?000003o?0800004oc`00000oc`200001_ll00000?ll003o
?0800004oc`00000oc`200000oll003o?00200000oll00000009oc`000ko?003003o?00000Oo?004
003o??ll0006oc`01000occo?0001oll00@00?lloc`000Ko?004003o??ll0007oc`01000occo?000
1_ll00@00?lloc`000Oo?003003o?00000Oo?004003o??ll0007oc`00`00oc`00007oc`01000occo
?0001_ll00@00?lloc`000Oo?003003o??ll008000Oo?003003o?00000Co?08000Co?08000?o?003
003o?00000;o?08000?o?08000;o?08000?o?08000;o?08000;o?08000;o?0800003oc`0000000;o
?0800003oc`0000000;o?0800003oc`0000000;o?0800004oc`00000oc`20002oc`01000occo?000
0_ll0P0000Co?000003o?0800004oc`00000oc`200001?ll00000?ll0P0000Ko?000003o?000oc`2
00001?ll00000?ll0P0000?o?000oc`00P0000?o?00000002Oll000>oc`00`00oc`00007oc`01000
occo?0001_ll00@00?lloc`000Oo?004003o??ll0006oc`01000occo?0001oll00@00?lloc`000Ko
?004003o??ll0007oc`00`00oc`00007oc`01000occo?0001oll00<00?ll00001oll00@00?lloc`0
00Ko?004003o??ll0007oc`00`00occo?0020007oc`00`00oc`00004oc`20004oc`20003oc`00`00
oc`00002oc`20003oc`20002oc`20002oc`00`00oc`00002oc`20002oc`20002oc`200000oll0000
0002oc`200000oll00000002oc`200000oll00000002oc`200001?ll00000?ll0P000_ll00@00?ll
oc`000;o?0800004oc`00000oc`200001?ll00000?ll0P0000Co?000003o?0800006oc`00000oc`0
0?ll0P0000Co?000003o?0800003oc`00?ll00800003oc`0000000Wo?0003_ll00@00?lloc`000Ko
?004003o??ll0006oc`01000occo?0001oll00@00?lloc`000Ko?004003o??ll0007oc`01000occo
?0001_ll00@00?lloc`000Oo?003003o?00000Oo?004003o??ll0007oc`00`00oc`00007oc`01000
occo?0001_ll00@00?lloc`000Oo?003003o??ll008000Oo?003003o?00000Co?08000Co?08000?o
?003003o?00000;o?08000?o?08000;o?08000;o?003003o?00000;o?08000;o?08000;o?0800003
oc`0000000;o?0800003oc`0000000;o?0800003oc`0000000;o?0800004oc`00000oc`200000oll
00000002oc`00`00occo?00200001?ll00000?ll0P0000Co?000003o?0800004oc`00000oc`20000
1_ll00000?ll003o?0800004oc`00000oc`200000oll003o?00200000oll00000009oc`000ko?004
003o??ll0006oc`01000occo?0001_ll00@00?lloc`000Oo?004003o??ll0006oc`01000occo?000
1oll00@00?lloc`000Ko?004003o??ll0007oc`00`00oc`00007oc`01000occo?0001oll00<00?ll
00001oll00@00?lloc`000Ko?004003o??ll0007oc`00`00occo?0020007oc`00`00oc`00004oc`2
0004oc`20003oc`00`00oc`00002oc`20003oc`20002oc`20002oc`00`00oc`00002oc`20002oc`2
0002oc`200000oll00000002oc`200000oll00000002oc`200000oll00000002oc`200001?ll0000
0?ll0P0000?o?00000000_ll00<00?lloc`00P0000Co?000003o?0800004oc`00000oc`200001?ll
00000?ll0P0000Ko?000003o?000oc`200001?ll00000?ll0P0000?o?000oc`00P0000?o?0000000
2Oll000>oc`01000occo?0001_ll00@00?lloc`000Ko?004003o??ll0007oc`01000occo?0001_ll
00@00?lloc`000Oo?004003o??ll0006oc`01000occo?0001oll00<00?ll00001oll00@00?lloc`0
00Oo?003003o?00000Oo?004003o??ll0006oc`01000occo?0001oll00<00?lloc`00P001_ll00@0
0?lloc`000Co?08000Co?08000?o?003003o?00000;o?08000?o?08000;o?08000;o?003003o?000
00;o?08000;o?08000;o?0800003oc`0000000;o?0800003oc`0000000;o?0800003oc`0000000;o
?0800004oc`00000oc`200000oll00000002oc`00`00occo?00200001?ll00000?ll0P0000Co?000
003o?0800004oc`00000oc`200001_ll00000?ll003o?0800004oc`00000oc`200000oll003o?002
00000oll00000009oc`000ko?004003o??ll0006oc`01000occo?0001_ll00@00?lloc`000Oo?004
003o??ll0006oc`01000occo?0001oll00@00?lloc`000Ko?004003o??ll0007oc`00`00oc`00007
oc`01000occo?0001oll00<00?ll00001oll00@00?lloc`000Ko?004003o??ll0007oc`00`00occo
?0030005oc`01000occo?0001?ll0P001?ll0P000oll00<00?ll00000_ll0P000oll0P000_ll0P00
0_ll00<00?ll00000_ll0P000_ll0P000_ll0P0000?o?00000000_ll0P0000?o?00000000_ll0P00
00?o?00000000_ll0P0000Co?000003o?0800003oc`0000000;o?0800004oc`00000oc`200001?ll
00000?ll0P0000Co?000003o?0800004oc`00000oc`200000oll003o?00200001?ll00000?ll0P00
00?o?000oc`00P0000?o?00000002Oll000>oc`01000occo?0001_ll00@00?lloc`000Ko?004003o
??ll0007oc`01000occo?0001_ll00@00?lloc`000Oo?004003o??ll0006oc`01000occo?0001oll
00<00?ll00001oll00@00?lloc`000Oo?003003o?00000Oo?004003o??ll0006oc`01000occo?000
1oll00<00?lloc`00P001_ll00@00?lloc`000Co?08000Co?08000?o?003003o?00000;o?08000?o
?08000;o?08000;o?003003o?00000;o?08000;o?08000;o?0800003oc`0000000;o?0800003oc`0
000000;o?0800003oc`0000000;o?0800004oc`00000oc`200000oll00000002oc`200001?ll0000
0?ll0P0000Co?000003o?0800004oc`00000oc`200001?ll00000?ll100000Co?000003o?0800006
oc`00000oc`00?ll0P0000?o?00000002Oll000>oc`01000occo?0001_ll00@00?lloc`000Ko?004
003o??ll0007oc`01000occo?0001_ll00@00?lloc`000Ko?005003o??lloc`00006oc`01000occo
?0001oll00<00?ll00001oll00@00?lloc`000Oo?003003o?00000Oo?004003o??ll0006oc`01000
occo?0001oll00<00?lloc`00P001_ll00@00?lloc`000Co?08000Co?08000?o?003003o?00000;o
?08000?o?08000;o?08000;o?003003o?00000;o?08000;o?08000;o?0800003oc`0000000;o?080
0003oc`0000000;o?0800003oc`0000000;o?0800004oc`00000oc`200000oll00000002oc`20000
1?ll00000?ll0P0000Co?000003o?0800004oc`00000oc`200001?ll00000?ll100000Co?000003o
?0800006oc`00000oc`00?ll0P0000?o?00000002Oll000>oc`01000occo?0001_ll00@00?lloc`0
00Ko?004003o??ll0007oc`01000occo?0001_ll00@00?lloc`000Ko?005003o??lloc`00006oc`0
1000occo?0001oll00<00?ll00001oll00@00?lloc`000Oo?003003o?00000Oo?004003o??ll0006
oc`01000occo?0001oll00<00?lloc`00P001_ll00@00?lloc`000Co?08000Co?08000?o?003003o
?00000;o?08000?o?08000;o?08000;o?003003o?00000;o?08000;o?08000;o?0800003oc`00000
00;o?0800003oc`0000000;o?0800003oc`0000000;o?0800004oc`00000oc`200000oll00000002
oc`200001?ll00000?ll0P0000Co?000003o?0800004oc`00000oc`200001?ll00000?ll100000Co
?000003o?0800006oc`00000oc`00?ll0P0000?o?00000002Oll000=oc`01@00occo??ll00001_ll
00@00?lloc`000Ko?004003o??ll0007oc`01000occo?0001_ll00@00?lloc`000Ko?005003o??ll
oc`00006oc`01000occo?0001oll00<00?ll00001oll00@00?lloc`000Oo?003003o?00000Oo?004
003o??ll0006oc`01000occo?0001oll00<00?lloc`00P001_ll00@00?lloc`000Co?08000Co?080
00?o?003003o?00000;o?08000?o?08000;o?007003o?000oc`00?ll00000_ll0P000_ll0P000_ll
0P0000?o?00000000_ll0P0000?o?00000000_ll0P0000?o?00000000_ll0P0000Co?000003o?080
0003oc`0000000;o?0800004oc`00000oc`200001?ll00000?ll0P0000Co?000003o?0800004oc`0
0000oc`400001?ll00000?ll0P0000Ko?000003o?000oc`200000oll00000009oc`000go?005003o
??lloc`00006oc`01000occo?0001_ll00@00?lloc`000Oo?004003o??ll0006oc`01000occo?000
1_ll00D00?llocco?00000Ko?004003o??ll0007oc`00`00oc`00007oc`01000occo?0001oll00<0
0?ll00001oll00@00?lloc`000Ko?004003o??ll0007oc`00`00occo?0020006oc`01000occo?000
1?ll0P001?ll0P000oll00<00?ll00000_ll0P000oll0P000_ll00L00?ll003o?000oc`00002oc`2
0002oc`200001Oll003o?000oc`00P000_ll0P0000?o?00000000_ll0P0000?o?00000000_ll0P00
00Co?000003o?0800003oc`0000000;o?0800004oc`00000oc`200001?ll00000?ll0P0000Co?000
003o?0800004oc`00000oc`400001?ll00000?ll0P0000Ko?000003o?000oc`200000oll00000009
oc`000go?005003o??lloc`00006oc`01000occo?0001_ll00@00?lloc`000Oo?004003o??ll0006
oc`01000occo?0001_ll00D00?llocco?00000Ko?004003o??ll0007oc`00`00oc`00007oc`01000
occo?0001oll00<00?ll00001oll00D00?lloc`00?ll008000?o?0800004oc`00?lloc`30002oc`0
0`00occo?0020006oc`01000occo?0001?ll0P001?ll0P000oll00<00?ll00000_ll0P000oll0P00
0_ll00L00?ll003o?000oc`00002oc`20002oc`200001Oll003o?000oc`00P000_ll0P0000?o?000
00000_ll0P0000?o?00000000_ll0P0000Co?000003o?0800003oc`0000000;o?0800004oc`00000
oc`200001?ll00000?ll0P0000Co?000003o?0800004oc`00000oc`400001?ll00000?ll0P0000Ko
?000003o?000oc`200000oll00000009oc`000go?005003o??lloc`00006oc`01000occo?0001_ll
00D00?llocco?00000Go?005003o??lloc`00006oc`01000occo?0001_ll00D00?llocco?00000Ko
?004003o??ll0007oc`00`00oc`00007oc`01000occo?0001oll00@00?lloc`000Ko?003003o??ll
008000;o?004003o??ll0002oc`00`00occo?003oc`00`00oc`00002oc`20006oc`01000occo?000
0oll00<00?ll00001?ll0P000oll00<00?ll00000_ll00<00?ll00000_ll0P000_ll00L00?ll003o
?000oc`00002oc`20002oc`200001Oll003o?000oc`00P000_ll0P0000?o?00000000_ll0P0000?o
?00000000_ll0P0000Co?000003o?0800003oc`0000000;o?0800004oc`00000oc`200001?ll0000
0?ll0P0000Co?000003o?0800004oc`00000oc`400001?ll00000?ll0P0000?o?00000000P0000Co
?000003o?08000Wo?0003Oll00D00?llocco?00000Ko?004003o??ll0006oc`01@00occo??ll0000
1Oll00D00?llocco?00000Ko?004003o??ll0006oc`01@00occo??ll00001_ll00@00?lloc`000Oo
?004003o??ll0006oc`01000occo?0001oll00@00?lloc`000Ko?003003o??ll008000;o?004003o
??ll0002oc`00`00occo?003oc`00`00oc`00002oc`40004oc`01000occo?0000oll00<00?ll0000
1?ll0P000oll00<00?ll00000_ll00<00?ll00000_ll0P000_ll00L00?ll003o?000oc`00002oc`2
0002oc`200001Oll003o?000oc`00P000_ll0P0000?o?00000000_ll0P0000?o?00000000_ll0P00
00Co?000003o?0800005oc`00?ll003o?00200001?ll00000?ll0P0000Co?000003o?0800004oc`0
0000oc`200001?ll00000?ll100000Co?000003o?0800003oc`0000000800004oc`00000oc`20009
oc`000go?005003o??lloc`00006oc`01000occo?0001_ll00D00?llocco?00000Go?005003o??ll
oc`00006oc`01@00occo??ll00001Oll00D00?llocco?00000Ko?004003o??ll0007oc`01000occo
?0001_ll00@00?lloc`000Oo?004003o??ll0004oc`400000oll00000002oc`01000occo?0000_ll
00<00?lloc`00`000_ll00<00?lloc`00P001_ll00@00?lloc`000?o?003003o?00000Co?08000?o
?003003o?00000;o?003003o?00000;o?08000;o?007003o?000oc`00?ll00000_ll0P000_ll0P00
00Go?000oc`00?ll008000;o?0800003oc`0000000;o?0800003oc`0000000;o?0800004oc`00000
oc`200001Oll003o?000oc`00P0000Co?000003o?0800004oc`00000oc`200001?ll00000?ll0P00
00Co?000003o?0@00004oc`00000oc`200000oll0000000200001?ll00000?ll0P002Oll000=oc`0
1@00occo??ll00001_ll00@00?lloc`000Ko?005003o??lloc`00005oc`01@00occo??ll00001_ll
00D00?llocco?00000Go?005003o??lloc`00006oc`01000occo?0001oll00@00?lloc`000Ko?004
003o??ll0007oc`01000occo?0001_ll00<00?lloc`00P000_ll00@00?lloc`000;o?004003o??ll
0004oc`00`00occo?0020006oc`01000occo?0000oll00@00?lloc`000?o?003003o?00000;o?003
003o?00000;o?003003o?00000;o?08000;o?007003o?000oc`00?ll00000_ll0P000_ll0P0000Go
?000oc`00?ll008000;o?0800003oc`0000000;o?0800005oc`00?ll003o?00200001?ll00000?ll
0P0000Go?000oc`00?ll00800004oc`00000oc`200001?ll00000?ll0P0000Co?000003o?0800004
oc`00000oc`400001?ll00000?ll0P0000?o?00000000P0000Co?000003o?08000Wo?0003Oll00D0
0?llocco?00000Ko?004003o??ll0006oc`01@00occo??ll00001Oll00D00?llocco?00000Ko?005
003o??lloc`00005oc`01@00occo??ll00001_ll00@00?lloc`000Oo?004003o??ll0006oc`01000
occo?0001_ll00D00?llocco?00000Ko?003003o??ll008000;o?004003o??ll0002oc`01000occo
?0001?ll00<00?lloc`00P001_ll00@00?lloc`000?o?004003o??ll0003oc`00`00oc`00002oc`0
0`00oc`00002oc`00`00oc`00002oc`20002oc`01`00oc`00?ll003o?00000;o?08000;o?0800005
oc`00?ll003o?0020002oc`200000oll00000002oc`200001Oll003o?000oc`00P0000Ko?000003o
?000oc`200000oll003o?00200001?ll00000?ll0P0000Co?000003o?0800004oc`00000oc`20000
1?ll00000?ll100000Co?000003o?0800003oc`0000000800004oc`00000oc`20009oc`000go?005
003o??lloc`00006oc`01000occo?0001_ll00D00?llocco?00000Go?005003o??lloc`00006oc`0
1@00occo??ll00001Oll00D00?llocco?00000Ko?004003o??ll0007oc`01000occo?0001_ll00@0
0?lloc`000Ko?005003o??lloc`00006oc`01@00occo?000oc`00P000oll00@00?lloc`000;o?0@0
0004oc`00?lloc`20006oc`01000occo?0000oll00@00?lloc`000;o?004003o??ll0002oc`00`00
oc`00002oc`00`00oc`00002oc`20002oc`01`00oc`00?ll003o?00000;o?08000;o?0800005oc`0
0?ll003o?0020002oc`200001Oll003o?000oc`00P0000Go?000oc`00?ll00800006oc`00000oc`0
0?ll0P0000?o?000oc`00P0000Co?000003o?0800004oc`00000oc`200001?ll00000?ll0P0000Co
?000003o?0@00004oc`00000oc`200000oll0000000200001?ll00000?ll0P002Oll000=oc`01@00
occo??ll00001_ll00@00?lloc`000Ko?005003o??lloc`00005oc`01@00occo??ll00001_ll00D0
0?llocco?00000Go?005003o??lloc`00006oc`01000occo?0001oll00@00?lloc`000Ko?004003o
??ll0006oc`01@00occo??ll00001_ll00@00?lloc`000Ko?005003o??lloc`00006oc`00`00occo
?0020006oc`01000occo?0000oll00@00?lloc`000;o?004003o??ll0002oc`00`00oc`00002oc`0
0`00oc`00002oc`20002oc`01`00oc`00?ll003o?00000;o?08000;o?0800005oc`00?ll003o?002
0002oc`200001Oll003o?000oc`00P0000Go?000oc`00?ll00800006oc`00000oc`00?ll0P0000?o
?000oc`00P0000Co?000003o?0800004oc`00000oc`200001?ll00000?ll0P0000Co?000003o?0@0
0004oc`00000oc`200000oll0000000200001?ll00000?ll0P002Oll000=oc`01@00occo??ll0000
1_ll00@00?lloc`000Ko?005003o??lloc`00005oc`01@00occo??ll00001_ll00D00?llocco?000
00Go?005003o??lloc`00006oc`01@00occo??ll00001_ll00@00?lloc`000Ko?004003o??ll0006
oc`01@00occo??ll00001_ll00@00?lloc`000Ko?005003o??lloc`00005oc`01000occo??ll0P00
1_ll00@00?lloc`000?o?004003o??ll0002oc`01000occo?0000_ll00<00?ll00000_ll00<00?ll
00000_ll0P000_ll00L00?ll003o?000oc`00002oc`20002oc`200001Oll003o?000oc`00P000_ll
0P0000Go?000oc`00?ll00800005oc`00?ll003o?00200001_ll00000?ll003o?0800003oc`00?ll
00800004oc`00000oc`200001?ll00000?ll0P0000Co?000003o?0800004oc`00000oc`400001?ll
00000?ll0P0000?o?00000000P0000Co?000003o?08000Wo?0003Oll00D00?llocco?00000Ko?004
003o??ll0006oc`01@00occo??ll00001Oll00D00?llocco?00000Ko?005003o??lloc`00005oc`0
1@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`01?ll00@00?lloc`000Ko?004003o??ll
0006oc`01@00occo??ll00001Oll00D00?llocco?00000Ko?005003o??lloc`00005oc`01000occo
??ll0P001_ll00@00?lloc`000?o?004003o??ll0002oc`01000occo?0000_ll00<00?ll00000_ll
00<00?ll00000_ll0P000_ll00L00?ll003o?000oc`00002oc`20002oc`200001Oll003o?000oc`0
0P000_ll0P0000Go?000oc`00?ll00800003oc`00?ll00800003oc`00?ll00800003oc`00?ll0080
0003oc`00?ll00800004oc`00000oc`200001?ll00000?ll0P0000Co?000003o?0800004oc`00000
oc`400001?ll00000?ll0P0000?o?00000000P0000Co?000003o?08000Wo?0003Oll00D00?llocco
?00000Ko?004003o??ll0006oc`01@00occo??ll00001Oll00D00?llocco?00000Ko?005003o??ll
oc`00005oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`01?ll00@00?lloc`000Ko
?004003o??ll0006oc`01@00occo??ll00001Oll00D00?llocco?00000Ko?005003o??lloc`00005
oc`01000occo??ll0`001Oll00@00?lloc`000?o?004003o??ll0002oc`01000occo?0000_ll00<0
0?ll00000_ll00<00?ll00000_ll0P000_ll00/00?ll003o?000oc`00?ll003o?00000;o?0800005
oc`00?ll003o?0020002oc`200001Oll003o?000oc`00P0000?o?000oc`00P0000?o?000oc`00P00
00?o?000oc`00P0000?o?000oc`00P0000Co?000003o?0800004oc`00000oc`200001?ll00000?ll
0P0000Co?000003o?0@00004oc`00000oc`200000oll0000000200001?ll00000?ll0P002Oll000=
oc`01@00occo??ll00001_ll00@00?lloc`000Ko?005003o??lloc`00005oc`01@00occo??ll0000
1_ll00D00?llocco?00000Go?005003o??lloc`00005oc`00`00occo?002oc`00`00occo?004oc`0
1000occo?0001_ll00@00?lloc`000Ko?005003o??lloc`00005oc`01@00occo??ll00001_ll00D0
0?llocco?00000Go?004003o??lloc`20006oc`01000occo?0000oll00@00?lloc`000;o?004003o
??ll0002oc`00`00oc`00002oc`00`00oc`00002oc`20002oc`02`00oc`00?ll003o?000oc`00?ll
00000_ll0P0000Go?000oc`00?ll008000;o?0800005oc`00?ll003o?00200000oll003o?0020000
0oll003o?00200000oll003o?00200000oll003o?00200001?ll00000?ll0P0000Co?000003o?080
0004oc`00000oc`200001?ll00000?ll100000Co?000003o?0800003oc`0000000800004oc`00000
oc`20009oc`000go?005003o??lloc`00006oc`01000occo?0001_ll00D00?llocco?00000Go?005
003o??lloc`00006oc`01@00occo??ll00001Oll00D00?llocco?00000Go?003003o??ll00;o?003
003o??ll00?o?005003o??lloc`00006oc`01000occo?0001_ll00D00?llocco?00000Go?005003o
??lloc`00006oc`01@00occo??ll00001Oll00@00?llocco?08000Ko?004003o??ll0003oc`01000
occo?0000_ll00@00?lloc`000;o?003003o?00000;o?003003o?00000;o?08000;o?00;003o?000
oc`00?ll003o?000oc`00002oc`200001Oll003o?000oc`00P000_ll0P0000Go?000oc`00?ll0080
0003oc`00?ll00800003oc`00?ll00800003oc`00?ll00800003oc`00?ll00800004oc`00000oc`2
00001?ll00000?ll0P0000Co?000003o?0800004oc`00000oc`400001?ll00000?ll0P0000?o?000
00000P0000Co?000003o?08000Wo?0003Oll00D00?llocco?00000Ko?004003o??ll0006oc`01@00
occo??ll00001Oll00D00?llocco?00000Ko?005003o??lloc`00005oc`01@00occo??ll00001Oll
00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Ko?004003o??ll0006oc`01@00occo
??ll00001Oll00D00?llocco?00000Ko?005003o??lloc`00005oc`01000occo??ll0P001_ll00@0
0?lloc`000?o?004003o??ll0002oc`01000occo?0000_ll00<00?ll00000_ll00<00?ll00000_ll
0P000_ll00/00?ll003o?000oc`00?ll003o?00000;o?0800005oc`00?ll003o?0020002oc`20000
1Oll003o?000oc`00P0000?o?000oc`00P0000?o?000oc`00P0000?o?000oc`00P0000?o?000oc`0
0P0000Co?000003o?0800004oc`00000oc`200001?ll00000?ll0P0000Co?000003o?0@00004oc`0
0000oc`200000oll0000000200001?ll00000?ll0P002Oll000=oc`01@00occo??ll00001_ll00@0
0?lloc`000Ko?005003o??lloc`00005oc`01@00occo??ll00001_ll00D00?llocco?00000Go?003
003o??ll00;o?003003o??ll00;o?003003o??ll00;o?003003o??ll00?o?005003o??lloc`00006
oc`01@00occo??ll00001Oll00D00?llocco?00000Go?005003o??lloc`00006oc`01@00occo??ll
00001Oll00@00?llocco?08000Ko?004003o??ll0003oc`01000occo?0000_ll00@00?lloc`000;o
?003003o?00000;o?003003o?00000;o?08000;o?00;003o?000oc`00?ll003o?000oc`00002oc`2
00001Oll003o?000oc`00P000_ll0P0000Go?000oc`00?ll00800003oc`00?ll00800003oc`00?ll
00800003oc`00?ll00800003oc`00?ll00800004oc`00000oc`200001?ll00000?ll0P0000Co?000
003o?0800004oc`00000oc`400001?ll00000?ll0P0000?o?00000000P0000Co?000003o?08000Wo
?0003Oll00D00?llocco?00000Ko?004003o??ll0006oc`01@00occo??ll00001Oll00D00?llocco
?00000Ko?005003o??lloc`00005oc`00`00occo?002oc`00`00occo?002oc`00`00occo?002oc`0
0`00occo?003oc`01@00occo??ll00001_ll00D00?llocco?00000Go?005003o??lloc`00005oc`0
1@00occo??ll00001_ll00D00?llocco?00000Go?004003o??lloc`20006oc`01000occo?0000oll
00@00?lloc`000;o?004003o??ll0002oc`00`00oc`00002oc`00`00oc`00002oc`20002oc`02`00
oc`00?ll003o?000oc`00?ll00000_ll0P0000Go?000oc`00?ll008000;o?0800005oc`00?ll003o
?00200000oll003o?00200000oll003o?00200000oll003o?00200000oll003o?00200001?ll0000
0?ll0P0000Co?000003o?0800004oc`00000oc`200001?ll00000?ll0`0000Go?00000000?ll0080
0003oc`0000000800004oc`00000oc`20009oc`000go?005003o??lloc`00006oc`01000occo?000
1_ll00D00?llocco?00000Go?005003o??lloc`00006oc`01@00occo??ll00001Oll00<00?lloc`0
0_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Ko?005003o
??lloc`00005oc`01@00occo??ll00001Oll00D00?llocco?00000Ko?005003o??lloc`00005oc`0
1000occo??ll0P001_ll00@00?lloc`000?o?004003o??ll0002oc`01000occo?0000_ll00<00?ll
00000_ll00<00?ll00000_ll00l00?ll003o?000oc`00?ll003o?000oc`00?ll00000_ll0P0000Go
?000oc`00?ll008000;o?0800005oc`00?ll003o?00200000oll003o?00200000oll003o?0020000
0oll003o?00200000oll003o?00200001?ll00000?ll0P0000Co?000003o?0800004oc`00000oc`2
00001?ll00000?ll0`0000Go?00000000?ll00800003oc`0000000800004oc`00000oc`20009oc`0
00go?005003o??lloc`00006oc`01000occo?0001_ll00D00?llocco?00000Go?005003o??lloc`0
0006oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<0
0?lloc`00oll00D00?llocco?00000Ko?005003o??lloc`00005oc`01@00occo??ll00001Oll00D0
0?llocco?00000Ko?005003o??lloc`00005oc`01000occo??ll0P001_ll00@00?lloc`000?o?004
003o??ll0002oc`01000occo?0000_ll00<00?ll00000_ll00<00?ll00000_ll00l00?ll003o?000
oc`00?ll003o?000oc`00?ll00000_ll0P0000Go?000oc`00?ll008000;o?0800005oc`00?ll003o
?00200000oll003o?00200000oll003o?00200000oll003o?00200000oll003o?00200001?ll0000
0?ll0P0000Co?000003o?0800004oc`00000oc`200001?ll00000?ll0`0000Go?00000000?ll0080
0003oc`0000000800004oc`00000oc`20009oc`000go?005003o??lloc`00006oc`01000occo?000
1_ll00D00?llocco?00000Go?005003o??lloc`00006oc`01@00occo??ll00001Oll00<00?lloc`0
0_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Ko?005003o
??lloc`00005oc`01@00occo??ll00001Oll00D00?llocco?00000Ko?005003o??lloc`00005oc`0
1000occo??ll0P001_ll00@00?lloc`000?o?004003o??ll0002oc`01000occo?0000_ll00<00?ll
00000_ll00<00?ll00000_ll00l00?ll003o?000oc`00?ll003o?000oc`00?ll00000_ll0P0000Go
?000oc`00?ll008000;o?0800005oc`00?ll003o?00200000oll003o?00200000oll003o?0020000
0oll003o?00200000oll003o?00200001?ll00000?ll0P0000Co?000003o?0800004oc`00000oc`2
00001?ll00000?ll0`0000Go?00000000?ll00800003oc`0000000800004oc`00000oc`20009oc`0
00go?005003o??lloc`00006oc`01000occo?0001_ll00D00?llocco?00000Go?005003o??lloc`0
0006oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<0
0?lloc`00oll00D00?llocco?00000Ko?005003o??lloc`00005oc`01@00occo??ll00001Oll00<0
0?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Go?004003o??lloc`30005oc`01000occo
?0000oll00@00?lloc`000;o?004003o??ll0002oc`00`00oc`00002oc`00`00oc`00002oc`06000
oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?08000;o?0800005oc`0
0?ll003o?00200000oll003o?00200000oll003o?00200000oll003o?00200001_ll00000?ll003o
?0800004oc`00000oc`200001?ll00000?ll0P0000Co?000003o?0800005oc`00000003o?0030000
1?ll00000?ll100000Co?000003o?08000Wo?0003Oll00D00?llocco?00000Ko?004003o??ll0006
oc`01@00occo??ll00001Oll00D00?llocco?00000Ko?005003o??lloc`00005oc`00`00occo?002
oc`00`00occo?002oc`00`00occo?002oc`00`00occo?003oc`01@00occo??ll00001_ll00D00?ll
occo?00000Go?005003o??lloc`00005oc`00`00occo?002oc`00`00occo?003oc`01@00occo??ll
00001Oll00@00?llocco?08000Ko?004003o??ll0003oc`01000occo?0000_ll00@00?lloc`000;o
?003003o?00000;o?003003o?00000;o?00H003o?000oc`00?ll003o?000oc`00?ll003o?000oc`0
0?ll003o?000oc`00?ll0P000_ll0P0000Go?000oc`00?ll00800003oc`00?ll00800003oc`00?ll
00800003oc`00?ll00800006oc`00000oc`00?ll0P0000Co?000003o?0800004oc`00000oc`20000
1?ll00000?ll0P0000Go?00000000?ll00<00004oc`00000oc`400001?ll00000?ll0P002Oll000=
oc`01@00occo??ll00001_ll00@00?lloc`000Ko?005003o??lloc`00005oc`01@00occo??ll0000
1_ll00D00?llocco?00000Go?003003o??ll00;o?003003o??ll00;o?003003o??ll00;o?003003o
??ll00?o?005003o??lloc`00006oc`01@00occo??ll00001Oll00D00?llocco?00000Go?003003o
??ll00;o?003003o??ll00?o?005003o??lloc`00005oc`01000occo??ll0P001_ll00@00?lloc`0
00?o?004003o??ll0002oc`01000occo?0000_ll00<00?ll00000_ll00<00?ll00000_ll01P00?ll
003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`20002oc`200001Oll003o
?000oc`00P0000?o?000oc`00P0000?o?000oc`00P0000?o?000oc`00P0000Ko?000003o?000oc`2
00001?ll00000?ll0P0000Co?000003o?0800004oc`00000oc`200001Oll00000000oc`00`0000Co
?000003o?0@00004oc`00000oc`20009oc`000go?005003o??lloc`00006oc`01000occo?0001_ll
00D00?llocco?00000Go?005003o??lloc`00006oc`01@00occo??ll00001Oll00<00?lloc`00_ll
00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Ko?005003o??ll
oc`00005oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?000
00Go?004003o??lloc`20006oc`01000occo?0000oll00@00?lloc`000;o?004003o??ll0002oc`0
0`00oc`00002oc`00`00oc`00002oc`06000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o
?000oc`00?ll003o?08000;o?0800005oc`00?ll003o?00200000oll003o?00200000oll003o?002
00000oll003o?00200001_ll00000?ll003o?0800004oc`00000oc`200001?ll00000?ll0P0000Co
?000003o?0800005oc`00000003o?00300001?ll00000?ll100000Co?000003o?08000Wo?0003Oll
00D00?llocco?00000Ko?004003o??ll0006oc`01@00occo??ll00001Oll00D00?llocco?00000Ko
?005003o??lloc`00005oc`00`00occo?002oc`00`00occo?002oc`00`00occo?002oc`00`00occo
?003oc`01@00occo??ll00001_ll00D00?llocco?00000Go?005003o??lloc`00005oc`00`00occo
?002oc`00`00occo?003oc`01@00occo??ll00001Oll00@00?llocco?08000Go?005003o??lloc`0
0003oc`01000occo?0000_ll00@00?lloc`000;o?003003o?00000;o?003003o?00000;o?00H003o
?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll0P000_ll0P0000Go?000
oc`00?ll00800003oc`00?ll00800003oc`00?ll00800003oc`00?ll00800006oc`00000oc`00?ll
0P0000Co?000003o?0800004oc`00000oc`200001?ll00000?ll0P0000Go?00000000?ll00<00004
oc`00000oc`400001?ll00000?ll0P002Oll000=oc`01@00occo??ll00001Oll00D00?llocco?000
00Ko?005003o??lloc`00005oc`01@00occo??ll00001_ll00D00?llocco?00000Go?003003o??ll
00;o?003003o??ll00;o?003003o??ll00;o?003003o??ll00?o?005003o??lloc`00006oc`01@00
occo??ll00001Oll00D00?llocco?00000Go?003003o??ll00;o?003003o??ll00?o?005003o??ll
oc`00005oc`01000occo??ll0P001Oll00D00?llocco?00000?o?004003o??ll0002oc`01000occo
?0000_ll00<00?ll00000_ll00<00?ll00000_ll01`00?ll003o?000oc`00?ll003o?000oc`00?ll
003o?000oc`00?ll003o?000oc`00?ll003o?0800005oc`00?ll003o?00200000oll003o?0020000
0oll003o?00200000oll003o?00200001_ll00000?ll003o?0800004oc`00000oc`200001?ll0000
0?ll0P0000Oo?00000000?ll003o?00300001Oll00000000oc`00P0000?o?00000000P0000Co?000
003o?08000Wo?0003Oll00D00?llocco?00000Go?005003o??lloc`00006oc`01@00occo??ll0000
1Oll00D00?llocco?00000Ko?005003o??lloc`00005oc`00`00occo?002oc`00`00occo?002oc`0
0`00occo?002oc`00`00occo?003oc`01@00occo??ll00001_ll00D00?llocco?00000Go?005003o
??lloc`00005oc`00`00occo?002oc`00`00occo?003oc`01@00occo??ll00001Oll00@00?llocco
?08000Go?005003o??lloc`00003oc`01000occo?0000_ll00@00?lloc`000;o?003003o?00000;o
?003003o?00000;o?00L003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`0
0?ll003o?000oc`200001Oll003o?000oc`00P0000?o?000oc`00P0000?o?000oc`00P0000?o?000
oc`00P0000Ko?000003o?000oc`200001?ll00000?ll0P0000Co?000003o?0800007oc`00000003o
?000oc`00`0000Go?00000000?ll00800005oc`00000003o?00300000oll00000009oc`000go?005
003o??lloc`00005oc`01@00occo??ll00001_ll00D00?llocco?00000Go?005003o??lloc`00006
oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?ll
oc`00oll00D00?llocco?00000Ko?005003o??lloc`00005oc`01@00occo??ll00001Oll00<00?ll
oc`00_ll00<00?lloc`00oll00D00?llocco?00000Go?003003o??ll00;o?003003o??ll00?o?005
003o??lloc`00003oc`01000occo?0000_ll00@00?lloc`000;o?003003o?00000;o?003003o?000
00;o?00L003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000
oc`200001Oll003o?000oc`00P0000?o?000oc`00P0000?o?000oc`00P0000?o?000oc`00P0000Ko
?000003o?000oc`200001?ll00000?ll0P0000Co?000003o?0800007oc`00000003o?000oc`00`00
00Go?00000000?ll00800005oc`00000003o?00300000oll00000009oc`000go?005003o??lloc`0
0005oc`01@00occo??ll00001_ll00D00?llocco?00000Go?005003o??lloc`00006oc`01@00occo
??ll00001Oll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00oll00D0
0?llocco?00000Ko?005003o??lloc`00005oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<0
0?lloc`00oll00D00?llocco?00000Go?003003o??ll00;o?08000Co?005003o??lloc`00003oc`0
1000occo?0000_ll00@00?lloc`000;o?003003o?00000;o?003003o?00000;o?00L003o?000oc`0
0?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`200001Oll003o?000
oc`00P0000?o?000oc`00P0000?o?000oc`00P0000?o?000oc`00P0000Ko?000003o?000oc`20000
1?ll00000?ll0P0000Co?000003o?0800007oc`00000003o?000oc`00`0000Go?00000000?ll0080
0005oc`00000003o?00300000oll00000009oc`000go?005003o??lloc`00005oc`01@00occo??ll
00001_ll00D00?llocco?00000Go?005003o??lloc`00006oc`01@00occo??ll00001Oll00<00?ll
oc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Ko?005
003o??lloc`00005oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00D00?ll
occo?00000Go?003003o??ll00;o?003003o??ll00?o?005003o??lloc`00003oc`01000occo?000
0_ll00@00?lloc`000;o?003003o?00000;o?003003o?00000;o?00L003o?000oc`00?ll003o?000
oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`200001Oll003o?000oc`00P0000?o
?000oc`00P0000?o?000oc`00P0000?o?000oc`00P0000Ko?000003o?000oc`200001?ll00000?ll
0P0000Co?000003o?0800007oc`00000003o?000oc`00`0000Go?00000000?ll00800005oc`00000
003o?00300000oll00000009oc`000go?005003o??lloc`00005oc`00`00occo?002oc`00`00occo
?003oc`01@00occo??ll00001Oll00D00?llocco?00000Ko?005003o??lloc`00005oc`00`00occo
?002oc`00`00occo?002oc`00`00occo?002oc`00`00occo?003oc`01@00occo??ll00001Oll00<0
0?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Go?003003o??ll00;o?003003o??ll00?o
?005003o??lloc`00005oc`00`00occo?002oc`00`00occo?003oc`01@00occo??ll00000oll00@0
0?lloc`000;o?004003o??ll0002oc`00`00oc`00002oc`00`00oc`00002oc`07000oc`00?ll003o
?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll0P0000Go?000oc`00?ll
00800003oc`00?ll00800003oc`00?ll00800003oc`00?ll00800006oc`00000oc`00?ll0P0000Co
?000003o?0800004oc`00000oc`200001oll00000000oc`00?ll00<00005oc`00000003o?0020000
1Oll00000000oc`00`0000?o?00000002Oll000=oc`01@00occo??ll00001Oll00<00?lloc`00_ll
00<00?lloc`00oll00D00?llocco?00000Go?005003o??lloc`00006oc`01@00occo??ll00001Oll
00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?000
00Go?003003o??ll00;o?003003o??ll00?o?005003o??lloc`00005oc`00`00occo?002oc`00`00
occo?003oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?000
00?o?004003o??ll0002oc`01000occo?0000_ll00<00?ll00000_ll00<00?ll00000_ll01`00?ll
003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?0800005oc`0
0?ll003o?00200000oll003o?00200000oll003o?00200000oll003o?00200001_ll00000?ll003o
?0800004oc`00000oc`200001?ll00000?ll0P0000Oo?00000000?ll003o?00300001Oll00000000
oc`00P0000Go?00000000?ll00<00003oc`0000000Wo?0003Oll00D00?llocco?00000Go?003003o
??ll00;o?003003o??ll00?o?005003o??lloc`00005oc`01@00occo??ll00001_ll00D00?llocco
?00000Go?003003o??ll00;o?003003o??ll00;o?003003o??ll00;o?003003o??ll00?o?005003o
??lloc`00005oc`00`00occo?002oc`00`00occo?003oc`01@00occo??ll00001Oll00<00?lloc`0
0_ll00<00?lloc`00oll00D00?llocco?00000Go?003003o??ll00;o?003003o??ll00?o?005003o
??lloc`00003oc`01000occo?0000_ll00@00?lloc`000;o?003003o?00000;o?003003o?00000;o
?00L003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`2
00001Oll003o?000oc`00P0000?o?000oc`00P0000?o?000oc`00P0000?o?000oc`00P0000Ko?000
003o?000oc`200001?ll00000?ll0P0000Co?000003o?0800007oc`00000003o?000oc`00`0000Go
?00000000?ll00800005oc`00000003o?00300000oll00000009oc`000go?005003o??lloc`00005
oc`00`00occo?002oc`00`00occo?003oc`01@00occo??ll00001Oll00D00?llocco?00000Ko?005
003o??lloc`00005oc`00`00occo?002oc`00`00occo?002oc`00`00occo?002oc`00`00occo?003
oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Go?003
003o??ll00;o?003003o??ll00?o?005003o??lloc`00005oc`00`00occo?002oc`00`00occo?003
oc`01@00occo??ll00000oll00@00?lloc`000;o?004003o??ll0002oc`00`00oc`00002oc`00`00
oc`00002oc`07000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000
oc`00?ll0P0000Go?000oc`00?ll00800003oc`00?ll00800003oc`00?ll00800003oc`00?ll0080
0006oc`00000oc`00?ll0P0000Co?000003o?0800004oc`00000oc`200001oll00000000oc`00?ll
00<00005oc`00000003o?00200001Oll00000000oc`00`0000?o?00000002Oll000=oc`01@00occo
??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00<00?ll00000`000oll0P000oll00<00?ll
oc`01?ll00D00?llocco?00000Go?003003o??ll00;o?003003o??ll00;o?003003o??ll00;o?003
003o??ll00?o?006003o??lloc`00?ll0`0000?o?000oc`00oll00<00?lloc`00oll00D00?llocco
?00000Go?003003o??ll00;o?003003o??ll00?o?005003o??lloc`00005oc`00`00occo?002oc`0
0`00occo?003oc`01@00occo??ll00000oll00@00?lloc`000;o?004003o??ll0002oc`00`00oc`0
0002oc`00`00oc`00002oc`03P00oc`00?ll003o?000oc`00?ll003o?000oc`300002oll003o?000
oc`00?ll003o?000oc`00P0000Go?000oc`00?ll00800003oc`00?ll00800003oc`00?ll00800003
oc`00?ll00800006oc`00000oc`00?ll0P0000Co?000003o?0D00003oc`0000000@00003oc`00?ll
00<00005oc`00000003o?00200001Oll00000000oc`00`0000?o?00000002Oll000=oc`01@00occo
??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000?o?004003o?0000002
oc`00`00occo?004oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00_ll00<00?ll
oc`00_ll00<00?lloc`00oll00D00?llocco?00000Co?08000Co?003003o??ll00?o?005003o??ll
oc`00005oc`00`00occo?002oc`00`00occo?003oc`01@00occo??ll00001Oll00<00?lloc`00_ll
00<00?lloc`00oll00D00?llocco?00000?o?004003o??ll0002oc`01000occo?0000_ll00<00?ll
00000_ll00<00?ll00000_ll01000?ll003o?000oc`00?ll003o?000oc`00?ll003o?0<00009oc`0
0?ll003o?000oc`00?ll00800005oc`00?ll003o?00200000oll003o?00200000oll003o?0020000
0oll003o?00200001_ll00000?ll003o?0800004oc`00000oc`500001?ll00000?ll0`0000?o?000
oc`00`0000Go?00000000?ll00800005oc`00000003o?00300000oll00000009oc`000go?005003o
??lloc`00005oc`00`00occo?002oc`00`00occo?003oc`01@00occo??ll00000oll00@00?ll0000
00?o?003003o??ll00?o?005003o??lloc`00005oc`00`00occo?002oc`00`00occo?002oc`00`00
occo?002oc`00`00occo?003oc`01@00occo??ll00001?ll0P001?ll00<00?lloc`00oll00D00?ll
occo?00000Go?003003o??ll00;o?003003o??ll00?o?005003o??lloc`00005oc`00`00occo?002
oc`00`00occo?003oc`01@00occo??ll00000oll00@00?lloc`000;o?004003o??ll0002oc`00`00
oc`00002oc`00`00oc`00002oc`04000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll0`0000Wo
?000oc`00?ll003o?000oc`00P0000Go?000oc`00?ll00800003oc`00?ll00800003oc`00?ll0080
0003oc`00?ll00800006oc`00000oc`00?ll0P0000Co?000003o?0D00004oc`00000oc`300000oll
003o?00300001Oll00000000oc`00P0000Go?00000000?ll00<00003oc`0000000Wo?0003Oll00D0
0?llocco?00000Go?003003o??ll00;o?003003o?00000@000?o?006003o??lloc`00?ll0P000oll
00<00?lloc`00oll00D00?llocco?00000Go?003003o??ll00;o?003003o??ll00;o?003003o??ll
00;o?003003o??ll00?o?0@00003oc`0000000800003oc`00?ll00?o?003003o??ll00?o?005003o
??lloc`00005oc`00`00occo?002oc`00`00occo?003oc`01@00occo??ll00001Oll00<00?lloc`0
0_ll0P001?ll00D00?llocco?00000?o?004003o??ll0002oc`01000occo?0000_ll00<00?ll0000
0_ll00<00?ll00000_ll00h00?ll003o?000oc`00?ll003o?000oc`00?ll0`0000_o?000oc`00?ll
003o?000oc`00?ll00800005oc`00?ll003o?00200000oll003o?00200000oll003o?00200000oll
003o?00200001_ll00000?ll003o?0800004oc`00000oc`500001?ll00000?ll0`0000?o?000oc`0
0`0000Go?00000000?ll00800005oc`00000003o?00300000oll00000009oc`000go?005003o??ll
oc`00005oc`00`00occo?002oc`00`00occo?003oc`01000occo??ll0P000_ll00@00?ll000000?o
?003003o??ll00?o?003003o??ll00;o?005003o??lloc`00005oc`00`00occo?002oc`00`00occo
?002oc`00`00occo?003oc`00`00occo?002oc`20003oc`00`00occo?002oc`00`00occo?003oc`0
1@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Go?003003o
??ll00;o?003003o??ll00?o?005003o??lloc`00003oc`01000occo?0000_ll00@00?lloc`000;o
?003003o?00000;o?003003o?00000;o?00L003o?000oc`00?ll003o?000oc`00?ll003o?000oc`0
0?ll003o?000oc`00?ll003o?000oc`200001Oll003o?000oc`00P0000?o?000oc`00P0000?o?000
oc`00P0000?o?000oc`00P0000Ko?000003o?000oc`300000oll003o?00500000oll000000040000
0oll003o?00300001Oll00000000oc`00P0000Go?00000000?ll00<00003oc`0000000Wo?0003Oll
00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00oll00<00?ll00000`00
0_ll00@00?ll000000?o?003003o??ll00?o?003003o??ll00;o?005003o??lloc`00005oc`00`00
occo?002oc`00`00occo?002oc`00`00occo?003oc`00`00occo?002oc`20003oc`00`00occo?002
oc`00`00occo?003oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00D00?ll
occo?00000Go?003003o??ll00;o?003003o??ll00?o?005003o??lloc`00003oc`01000occo?000
0_ll00@00?lloc`000;o?003003o?00000;o?003003o?00000;o?00L003o?000oc`00?ll003o?000
oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`200001Oll003o?000oc`00P0000?o
?000oc`00P0000?o?000oc`00P0000?o?000oc`00P0000Ko?000003o?000oc`300000oll003o?005
00000oll0000000400000oll003o?00300001Oll00000000oc`00P0000Go?00000000?ll00<00003
oc`0000000Wo?0003Oll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`0
0_ll00<00?lloc`00_ll0P000oll0P001?ll00<00?lloc`00oll00<00?lloc`00_ll00D00?llocco
?00000Go?003003o??ll00;o?003003o??ll00;o?003003o??ll00?o?003003o??ll00;o?0H000Co
?003003o??ll00?o?005003o??lloc`00005oc`00`00occo?002oc`00`00occo?003oc`01@00occo
??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000?o?004003o??ll0002
oc`01000occo?0000_ll00<00?ll00000_ll00<00?ll00000_ll00h00?ll003o?000oc`00?ll003o
?000oc`00?ll1@0000Wo?000oc`00?ll003o?000oc`00P0000Go?000oc`00?ll00800003oc`00?ll
00800003oc`00?ll00800003oc`00?ll00800006oc`00000oc`00?ll0`0000?o?000oc`01@0000Go
?00000000?ll00800003oc`00?ll00<00005oc`00000003o?00200001Oll00000000oc`00`0000?o
?00000002Oll000=oc`00`00occo?002oc`00`00occo?002oc`00`00occo?002oc`00`00occo?002
oc`00`00occo?003oc`00`00occo?002oc`00`00occo?002oc`00`00occo?003oc`00`00occo?002
oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00oll00<00?ll
oc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Go?003
003o??ll00;o?003003o??ll00?o?005003o??lloc`00005oc`00`00occo?002oc`00`00occo?003
oc`01@00occo??ll00000oll00@00?lloc`000;o?004003o??ll0002oc`00`00oc`00002oc`00`00
oc`00002oc`07000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000
oc`00?ll0P0000Go?000oc`00?ll00800003oc`00?ll00800003oc`00?ll00800003oc`00?ll0080
0006oc`00000oc`00?ll0`0000?o?000oc`00P0000Co?000003o?0<00006oc`00000oc`00?ll0`00
00Go?00000000?ll00800005oc`00000003o?00300000oll00000009oc`000go?003003o??ll00;o
?003003o??ll00;o?003003o??ll00;o?003003o??ll00;o?003003o??ll00?o?003003o??ll00;o
?003003o??ll00;o?003003o??ll00?o?003003o??ll00;o?005003o??lloc`00005oc`00`00occo
?002oc`00`00occo?002oc`00`00occo?003oc`00`00occo?002oc`00`00occo?002oc`00`00occo
?002oc`00`00occo?003oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00D0
0?llocco?00000Go?003003o??ll00;o?003003o??ll00?o?005003o??lloc`00003oc`01000occo
?0000_ll00@00?lloc`000;o?003003o?00000;o?003003o?00000;o?00L003o?000oc`00?ll003o
?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`200001Oll003o?000oc`00P00
00?o?000oc`00P0000?o?000oc`00P0000?o?000oc`00P0000Ko?000003o?000oc`300000oll003o
?00200001?ll00000?ll0`0000Ko?000003o?000oc`300001Oll00000000oc`00P0000Go?0000000
0?ll00<00003oc`0000000Wo?0003Oll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll
00<00?lloc`00_ll00<00?lloc`00oll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00oll
00<00?lloc`00_ll00D00?llocco?00000Go?003003o??ll00;o?003003o??ll00;o?003003o??ll
00?o?003003o??ll00;o?003003o??ll00;o?003003o??ll00;o?003003o??ll00?o?005003o??ll
oc`00005oc`00`00occo?002oc`00`00occo?003oc`01@00occo??ll00001Oll00<00?lloc`00_ll
00<00?lloc`00oll00<00?lloc`00_ll00@00?lloc`000;o?004003o??ll0002oc`00`00oc`00002
oc`01P00occo?000oc`000;o?00L003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o
?000oc`00?ll003o?000oc`200001Oll003o?000oc`00P0000?o?000oc`00P0000?o?000oc`00P00
00?o?000oc`00P0000Ko?000003o?000oc`300000oll003o?00200001?ll00000?ll0`0000Ko?000
003o?000oc`300001Oll00000000oc`00P0000Go?00000000?ll00<00003oc`0000000Wo?0003Oll
00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00oll
00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?000
00Go?003003o??ll00;o?003003o??ll00;o?003003o??ll00?o?003003o??ll00;o?003003o??ll
00;o?003003o??ll00;o?003003o??ll00?o?005003o??lloc`00005oc`00`00occo?002oc`00`00
occo?003oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00<00?lloc`00_ll
00@00?lloc`000;o?004003o??ll0002oc`00`00oc`00002oc`01P00occo?000oc`000;o?00L003o
?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`200001Oll
003o?000oc`00P0000?o?000oc`00P0000?o?000oc`00P0000?o?000oc`00P0000Ko?000003o?000
oc`300000oll003o?00200001?ll00000?ll0`0000Ko?000003o?000oc`300001Oll00000000oc`0
0P0000Go?00000000?ll00<00003oc`0000000Wo?000o`0080000Oll0007oc`00`00occo?003oc`0
0`00occo?002oc`00`00occo?002oc`00`00occo?002oc`00`00occo?002oc`00`00occo?002oc`2
0004oc`00`00occo?002oc`00`00occo?002oc`00`00occo?002oc`20003oc`00`00occo?003oc`0
0`00occo?002oc`00`00occo?002oc`00`00occo?003oc`00`00occo?002oc`00`00occo?002oc`0
0`00occo?002oc`20004oc`01000occo??ll0P001?ll00<00?lloc`00_ll00<00?lloc`00_ll00<0
0?lloc`00oll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00oll00@00?llocco?08000;o
?004003o??ll0002oc`200001?ll003o?0000_ll00P00?lloc`00?ll003o?0000_ll01P00?ll003o
?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`400001Oll003o?000oc`01000
00Ko?000003o?000oc`200000oll003o?00200001_ll00000?ll003o?0<00003oc`00?ll00800003
oc`0000000@00006oc`00000oc`00?ll0`0000Co?000003o?0L00005oc`00000003o?0030008oc`0
00Oo?003003o??ll00?o?003003o??ll00;o?003003o??ll00;o?003003o??ll00;o?003003o??ll
00;o?003003o??ll00;o?08000Co?003003o??ll00;o?003003o??ll00;o?003003o??ll00?o?005
003o??lloc`00005oc`00`00occo?002oc`00`00occo?003oc`00`00occo?002oc`00`00occo?002
oc`00`00occo?002oc`00`00occo?003oc`00`00occo?002oc`01@00occo??ll00001Oll00<00?ll
oc`00_ll00<00?lloc`00_ll00<00?lloc`00oll00<00?lloc`00_ll00<00?lloc`00_ll00<00?ll
oc`00oll00<00?lloc`00_ll00@00?lloc`000;o?004003o??ll0002oc`00`00oc`00002oc`02000
occo?000oc`00?ll0002oc`06P00oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`0
0?ll003o?000oc`200001Oll003o?000oc`00P0000?o?000oc`00P0000?o?000oc`00P0000?o?000
oc`00P0000Ko?000003o?000oc`300000oll003o?00200000oll0000000400001?ll00000?ll0P00
00Co?000003o?0800005oc`00000003o?00300001Oll00000000oc`00P002Oll0007oc`00`00occo
?003oc`00`00occo?002oc`00`00occo?002oc`00`00occo?002oc`00`00occo?002oc`00`00occo
?003oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Go
?003003o??ll00;o?003003o??ll00?o?003003o??ll00;o?003003o??ll00;o?003003o??ll00;o
?003003o??ll00?o?003003o??ll00;o?005003o??lloc`00005oc`00`00occo?002oc`00`00occo
?002oc`00`00occo?003oc`00`00occo?002oc`00`00occo?002oc`00`00occo?003oc`00`00occo
?002oc`01000occo?0000_ll00@00?lloc`000;o?003003o?00000;o?008003o??ll003o?000oc`0
00;o?00J003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?080
0005oc`00?ll003o?00200000oll003o?00200000oll003o?00200000oll003o?00200001_ll0000
0?ll003o?0<00003oc`00?ll00800004oc`00000oc`300001?ll00000?ll0P0000Co?000003o?080
0005oc`00000003o?00300001Oll00000000oc`00P002Oll0007oc`00`00occo?003oc`00`00occo
?002oc`00`00occo?002oc`00`00occo?002oc`00`00occo?002oc`00`00occo?003oc`01@00occo
??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Go?003003o??ll00;o
?003003o??ll00?o?003003o??ll00;o?003003o??ll00;o?003003o??ll00;o?003003o??ll00?o
?003003o??ll00;o?003003o??ll00;o?003003o??ll00;o?003003o??ll00;o?003003o??ll00;o
?003003o??ll00?o?003003o??ll00;o?003003o??ll00;o?003003o??ll00?o?003003o??ll00;o
?004003o??ll0002oc`01000occo?0000_ll00<00?ll00000_ll00P00?lloc`00?ll003o?0000_ll
01X00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll0P0000Go
?000oc`00?ll00800003oc`00?ll00800003oc`00?ll00800003oc`00?ll00800006oc`00000oc`0
0?ll0`0000?o?000oc`00P0000Co?000003o?0<00004oc`00000oc`200001?ll00000?ll0P0000Go
?00000000?ll00<00005oc`00000003o?0020009oc`000Oo?003003o??ll00?o?003003o??ll00;o
?003003o??ll00;o?003003o??ll00;o?003003o??ll00;o?003003o??ll00?o?005003o??lloc`0
0005oc`00`00occo?002oc`00`00occo?003oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<0
0?lloc`00oll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00oll00D0
0?llocco?00000Go?003003o??ll00;o?003003o??ll00;o?003003o??ll00;o?003003o??ll00?o
?003003o??ll00;o?003003o??ll00;o?003003o??ll00?o?003003o??ll00;o?004003o??ll0002
oc`01000occo?0000_ll00<00?ll00000_ll00P00?lloc`00?ll003o?0000_ll01X00?ll003o?000
oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll0P0000Go?000oc`00?ll0080
0003oc`00?ll00800003oc`00?ll00800003oc`00?ll00800006oc`00000oc`00?ll0`0000?o?000
oc`00P0000Co?000003o?0<00004oc`00000oc`200001?ll00000?ll0P0000Go?00000000?ll00<0
0005oc`00000003o?0020009oc`000Oo?003003o??ll00?o?003003o??ll00;o?003003o??ll00;o
?003003o??ll00;o?003003o??ll00;o?003003o??ll00?o?005003o??lloc`00005oc`00`00occo
?002oc`00`00occo?003oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00<0
0?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Go
?003003o??ll00;o?003003o??ll00;o?003003o??ll00;o?003003o??ll00?o?003003o??ll00;o
?003003o??ll00;o?08000Co?003003o??ll00;o?004003o??ll0002oc`01000occo?0000_ll00<0
0?ll00000_ll00P00?lloc`00?ll003o?0000_ll01X00?ll003o?000oc`00?ll003o?000oc`00?ll
003o?000oc`00?ll003o?000oc`00?ll0P0000Go?000oc`00?ll00800003oc`00?ll00800003oc`0
0?ll00800003oc`00?ll00800006oc`00000oc`00?ll0`0000?o?000oc`00P0000Co?000003o?0<0
0004oc`00000oc`200001?ll00000?ll0P0000Go?00000000?ll00<00005oc`00000003o?0020009
oc`000Oo?003003o??ll00?o?003003o??ll00;o?003003o??ll00;o?003003o??ll00;o?003003o
??ll00;o?003003o??ll00?o?005003o??lloc`00005oc`00`00occo?002oc`00`00occo?003oc`0
1@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00<00?lloc`00_ll00<00?lloc`0
0_ll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Go?003003o??ll00;o?003003o
??ll00;o?003003o??ll00;o?003003o??ll00?o?003003o??ll00;o?003003o??ll00;o?08000Co
?003003o??ll00;o?004003o??ll0002oc`01000occo?0000_ll00<00?ll00000_ll00P00?lloc`0
0?ll003o?0000_ll01X00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000
oc`00?ll0P0000Go?000oc`00?ll00800003oc`00?ll00800003oc`00?ll00800003oc`00?ll0080
0006oc`00000oc`00?ll0`0000?o?000oc`00P0000Co?000003o?0<00004oc`00000oc`200001?ll
00000?ll0P0000Go?00000000?ll00<00005oc`00000003o?0020009oc`000Oo?003003o??ll00?o
?003003o??ll00;o?003003o??ll00;o?003003o??ll00;o?003003o??ll00;o?003003o??ll00?o
?005003o??lloc`00005oc`00`00occo?002oc`00`00occo?003oc`01@00occo??ll00001Oll00<0
0?lloc`00_ll00<00?lloc`00oll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<0
0?lloc`00oll00D00?llocco?00000Go?003003o??ll00;o?003003o??ll00;o?003003o??ll00;o
?003003o??ll00?o?003003o??ll00;o?003003o??ll00;o?08000Co?003003o??ll00;o?004003o
??ll0002oc`01000occo?0000_ll00<00?ll00000_ll00P00?lloc`00?ll003o?0000_ll01X00?ll
003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll0P0000Go?000oc`0
0?ll00800003oc`00?ll00800003oc`00?ll00800003oc`00?ll00800006oc`00000oc`00?ll0`00
00?o?000oc`00P0000Co?000003o?0<00004oc`00000oc`200001?ll00000?ll0P0000Go?0000000
0?ll00<00005oc`00000003o?0020009oc`000Oo?003003o??ll00?o?003003o??ll00;o?003003o
??ll00;o?003003o??ll00;o?003003o??ll00;o?003003o??ll00?o?005003o??lloc`00005oc`0
0`00occo?002oc`00`00occo?003oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`0
0oll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco
?00000Go?003003o??ll00;o?003003o??ll00?o?005003o??lloc`00005oc`00`00occo?002oc`0
0`00occo?002oc`20004oc`00`00occo?002oc`01000occo?0000_ll00@00?lloc`000;o?003003o
?00000;o?008003o??ll003o?000oc`000;o?00J003o?000oc`00?ll003o?000oc`00?ll003o?000
oc`00?ll003o?000oc`00?ll003o?0800005oc`00?ll003o?00200000oll003o?00200000oll003o
?00200000oll003o?00200001_ll00000?ll003o?0<00003oc`00?ll00800004oc`00000oc`30000
1?ll00000?ll0P0000Co?000003o?0800005oc`00000003o?00300001Oll00000000oc`00P002Oll
0007oc`00`00occo?003oc`00`00occo?002oc`00`00occo?002oc`00`00occo?002oc`00`00occo
?002oc`00`00occo?003oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00D0
0?llocco?00000Go?003003o??ll00;o?003003o??ll00?o?003003o??ll00;o?003003o??ll00;o
?003003o??ll00;o?003003o??ll00?o?005003o??lloc`00005oc`00`00occo?002oc`00`00occo
?003oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00_ll0P001?ll00<00?lloc`0
0_ll00@00?lloc`000;o?004003o??ll0002oc`00`00oc`00002oc`02000occo?000oc`00?ll0002
oc`06P00oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`20000
1Oll003o?000oc`00P0000?o?000oc`00P0000?o?000oc`00P0000?o?000oc`00P0000Ko?000003o
?000oc`300000oll003o?00200001?ll00000?ll0`0000Co?000003o?0800004oc`00000oc`20000
1Oll00000000oc`00`0000Go?00000000?ll008000Wo?0001oll00<00?lloc`00_ll00<00?lloc`0
0oll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco
?00000Go?003003o??ll00;o?003003o??ll00?o?005003o??lloc`00005oc`00`00occo?002oc`0
0`00occo?003oc`00`00occo?002oc`00`00occo?002oc`00`00occo?002oc`00`00occo?003oc`0
1@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Go?003003o
??ll00;o?003003o??ll00;o?08000Co?003003o??ll00;o?004003o??ll0002oc`01000occo?000
0_ll00<00?ll00000_ll00P00?lloc`00?ll003o?0000_ll01X00?ll003o?000oc`00?ll003o?000
oc`00?ll003o?000oc`00?ll003o?000oc`00?ll0P0000Go?000oc`00?ll00800003oc`00?ll0080
0005oc`00?ll003o?00200001?ll00000?ll0P0000?o?000oc`00`0000?o?000oc`00P0000Co?000
003o?0<00004oc`00000oc`200001?ll00000?ll0P0000Go?00000000?ll00<00005oc`00000003o
?0020009oc`000Oo?003003o??ll00;o?003003o??ll00?o?003003o??ll00;o?003003o??ll00;o
?003003o??ll00;o?003003o??ll00?o?005003o??lloc`00005oc`00`00occo?002oc`00`00occo
?003oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00<00?lloc`00_ll00<0
0?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Go?003003o??ll00;o
?003003o??ll00?o?005003o??lloc`00005oc`00`00occo?002oc`00`00occo?002oc`20004oc`0
0`00occo?002oc`01000occo?0000_ll00@00?lloc`000;o?003003o?00000;o?003003o?00000;o
?003003o?00000;o?00J003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`0
0?ll003o?0800005oc`00?ll003o?00200000oll003o?00200001Oll003o?000oc`00P0000Co?000
003o?0800003oc`00?ll00<00003oc`00?ll00800004oc`00000oc`300001?ll00000?ll0P0000Co
?000003o?0800005oc`00000003o?00300001Oll00000000oc`00P002Oll0007oc`00`00occo?002
oc`00`00occo?003oc`00`00occo?002oc`00`00occo?002oc`00`00occo?002oc`00`00occo?003
oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Go?003
003o??ll00;o?003003o??ll00?o?003003o??ll00;o?003003o??ll00;o?003003o??ll00;o?003
003o??ll00?o?005003o??lloc`00005oc`00`00occo?002oc`00`00occo?003oc`01@00occo??ll
00001Oll00<00?lloc`00_ll00<00?lloc`00_ll0P001?ll00<00?lloc`00_ll00@00?lloc`000;o
?004003o??ll0002oc`00`00oc`00002oc`00`00oc`00002oc`00`00oc`00002oc`06000oc`00?ll
003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?0800007oc`00?ll003o?000oc`0
0P0000?o?000oc`00P0000Go?000oc`00?ll00800004oc`00000oc`200000oll003o?00300000oll
003o?00200001?ll00000?ll0`0000Co?000003o?0800004oc`00000oc`200001Oll00000000oc`0
0`0000Go?00000000?ll008000Wo?0001oll00<00?lloc`00_ll00<00?lloc`00oll00<00?lloc`0
0_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Go?003003o
??ll00;o?003003o??ll00?o?005003o??lloc`00005oc`00`00occo?002oc`00`00occo?003oc`0
0`00occo?002oc`00`00occo?002oc`00`00occo?002oc`00`00occo?003oc`01@00occo??ll0000
1Oll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Go?003003o??ll00;o?003003o
??ll00;o?08000Co?003003o??ll00;o?004003o??ll0002oc`01000occo?0000_ll00<00?ll0000
0_ll00<00?ll00000_ll00<00?ll00000_ll01P00?ll003o?000oc`00?ll003o?000oc`00?ll003o
?000oc`00?ll003o?000oc`200001oll003o?000oc`00?ll00800003oc`00?ll00800005oc`00?ll
003o?00200001?ll00000?ll0P0000?o?000oc`00`0000?o?000oc`00P0000Co?000003o?0<00004
oc`00000oc`200001?ll00000?ll0P0000Go?00000000?ll00<00005oc`00000003o?0020009oc`0
00Oo?003003o??ll00;o?003003o??ll00?o?005003o??lloc`00005oc`00`00occo?002oc`00`00
occo?003oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?000
00Go?003003o??ll00;o?003003o??ll00?o?003003o??ll00;o?003003o??ll00;o?003003o??ll
00;o?003003o??ll00?o?005003o??lloc`00005oc`00`00occo?002oc`00`00occo?003oc`01@00
occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00_ll0P001?ll00<00?lloc`00_ll00@00?ll
oc`000;o?004003o??ll0002oc`00`00oc`00002oc`00`00oc`00002oc`00`00oc`00002oc`06000
oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?0800007oc`00?ll003o
?000oc`00P0000?o?000oc`00P0000Go?000oc`00?ll00800004oc`00000oc`200000oll003o?003
00000oll003o?00200001?ll00000?ll0`0000Co?000003o?0800004oc`00000oc`200001Oll0000
0000oc`00`0000Go?00000000?ll008000Wo?0001oll00<00?lloc`00_ll00<00?lloc`00oll00D0
0?llocco?00000Go?003003o??ll00;o?003003o??ll00?o?005003o??lloc`00005oc`00`00occo
?002oc`00`00occo?003oc`01@00occo??ll00001Oll00D00?llocco?00000Ko?005003o??lloc`0
0005oc`00`00occo?002oc`00`00occo?003oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<0
0?lloc`00oll00D00?llocco?00000Go?005003o??lloc`00005oc`20004oc`00`00occo?002oc`0
1000occo?0000_ll00@00?lloc`000;o?003003o?00000;o?003003o?00000;o?003003o?00000;o
?08000;o?00D003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?0800007oc`00?ll
003o?000oc`00P0000?o?000oc`00P0000Go?000oc`00?ll00800004oc`00000oc`200000oll003o
?00300000oll003o?00200001?ll00000?ll0`0000Co?000003o?0800004oc`00000oc`200001Oll
00000000oc`00`0000Go?00000000?ll008000Wo?0002?ll00D00?llocco?00000Go?005003o??ll
oc`00005oc`00`00occo?002oc`00`00occo?003oc`01@00occo??ll00001Oll00<00?lloc`00_ll
00<00?lloc`00oll00D00?llocco?00000Go?005003o??lloc`00006oc`01@00occo??ll00001Oll
00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Go?003003o??ll00;o?003003o??ll
00?o?005003o??lloc`00005oc`01@00occo??ll00001Oll0P001?ll00<00?lloc`00_ll00@00?ll
oc`000;o?004003o??ll0002oc`00`00oc`00002oc`00`00oc`00002oc`00`00oc`00002oc`20002
oc`05000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`200001oll003o?000oc`0
0?ll00800003oc`00?ll00800005oc`00?ll003o?00200001?ll00000?ll0P0000?o?000oc`00`00
00?o?000oc`00`0000?o?000oc`00`0000Co?000003o?0800004oc`00000oc`200001Oll00000000
oc`00`0000Co?000003o?0<000Wo?0002?ll00D00?llocco?00000Go?005003o??lloc`00006oc`0
1@00occo??ll00001Oll00D00?llocco?00000Go?003003o??ll00;o?003003o??ll00?o?005003o
??lloc`00005oc`01@00occo??ll00001_ll00D00?llocco?00000Go?003003o??ll00;o?003003o
??ll00?o?005003o??lloc`00005oc`00`00occo?002oc`00`00occo?003oc`01@00occo??ll0000
1Oll00D00?llocco?00000Go?08000Co?003003o??ll00;o?004003o??ll0002oc`01000occo?000
0_ll00<00?ll00000_ll00<00?ll00000_ll00<00?ll00000_ll0P000_ll01@00?ll003o?000oc`0
0?ll003o?000oc`00?ll003o?000oc`00?ll0P0000Oo?000oc`00?ll003o?00200000oll003o?002
00001Oll003o?000oc`00P0000Co?000003o?0800003oc`00?ll00<00003oc`00?ll00<00003oc`0
0?ll00<00004oc`00000oc`200001?ll00000?ll0P0000Go?00000000?ll00<00004oc`00000oc`3
0009oc`000So?005003o??lloc`00005oc`01@00occo??ll00001_ll00D00?llocco?00000Go?005
003o??lloc`00005oc`00`00occo?002oc`00`00occo?003oc`01@00occo??ll00001Oll00D00?ll
occo?00000Ko?005003o??lloc`00005oc`00`00occo?002oc`00`00occo?003oc`01@00occo??ll
00001Oll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Go?005003o??lloc`00005
oc`20004oc`00`00occo?002oc`01000occo?0000_ll00@00?lloc`000;o?003003o?00000;o?003
003o?00000;o?003003o?00000;o?08000;o?00D003o?000oc`00?ll003o?000oc`00?ll003o?000
oc`00?ll003o?0800007oc`00?ll003o?000oc`00P0000?o?000oc`00P0000Go?000oc`00?ll0080
0004oc`00000oc`200000oll003o?00300000oll003o?00300000oll003o?00300001?ll00000?ll
0P0000Co?000003o?0800005oc`00000003o?00300001?ll00000?ll0`002Oll0008oc`01@00occo
??ll00001Oll00D00?llocco?00000Ko?005003o??lloc`00005oc`01@00occo??ll00001Oll00<0
0?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Go?005003o??lloc`00006oc`01@00occo
??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Go?003003o??ll00;o
?003003o??ll00?o?005003o??lloc`00005oc`01@00occo??ll00001Oll0P001?ll00<00?lloc`0
0_ll00@00?lloc`000;o?004003o??ll0002oc`00`00oc`00002oc`00`00oc`00002oc`00`00oc`0
0002oc`20002oc`05000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`200001oll
003o?000oc`00?ll00800003oc`00?ll00800005oc`00?ll003o?00200001?ll00000?ll0P0000?o
?000oc`00`0000?o?000oc`00`0000?o?000oc`00`0000Co?000003o?0800004oc`00000oc`20000
1Oll00000000oc`00`0000Co?000003o?0<000Wo?0002?ll00D00?llocco?00000Go?005003o??ll
oc`00006oc`01@00occo??ll00001Oll00D00?llocco?00000Ko?005003o??lloc`00005oc`01@00
occo??ll00001Oll00D00?llocco?00000Ko?005003o??lloc`00005oc`00`00occo?002oc`00`00
occo?003oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?000
00Go?005003o??lloc`00005oc`20004oc`00`00occo?002oc`01000occo?0000_ll00@00?lloc`0
00;o?003003o?00000;o?003003o?00000;o?003003o?00000;o?08000;o?00D003o?000oc`00?ll
003o?000oc`00?ll003o?000oc`00?ll003o?0800007oc`00?ll003o?000oc`00P0000?o?000oc`0
0P0000Go?000oc`00?ll00800004oc`00000oc`200000oll003o?00300000oll003o?00300000oll
003o?00300001?ll00000?ll0P0000Co?000003o?0800005oc`00000003o?00300001?ll00000?ll
0`002Oll0008oc`01@00occo??ll00001Oll00D00?llocco?00000Ko?005003o??lloc`00005oc`0
1@00occo??ll00001_ll00D00?llocco?00000Go?005003o??lloc`00005oc`01@00occo??ll0000
1_ll00D00?llocco?00000Go?005003o??lloc`00006oc`01@00occo??ll00001Oll00<00?lloc`0
0_ll00<00?lloc`00oll00D00?llocco?00000Go?005003o??lloc`00005oc`20004oc`00`00occo
?002oc`01000occo?0000_ll00@00?lloc`000;o?003003o?00000;o?003003o?00000;o?003003o
?00000;o?08000;o?00D003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?0800007
oc`00?ll003o?000oc`00P0000?o?000oc`00P0000Go?000oc`00?ll00800004oc`00000oc`20000
0oll003o?00300000oll003o?00300000oll003o?00300001?ll00000?ll0P0000Co?000003o?080
0005oc`00000003o?00300001?ll00000?ll0`002Oll0008oc`01@00occo??ll00001Oll00D00?ll
occo?00000Ko?005003o??lloc`00005oc`01@00occo??ll00001_ll00D00?llocco?00000Go?005
003o??lloc`00005oc`01@00occo??ll00001_ll00D00?llocco?00000Go?005003o??lloc`00006
oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Go?005
003o??lloc`00005oc`20004oc`00`00occo?002oc`01000occo?0000_ll00@00?lloc`000;o?003
003o?00000;o?003003o?00000;o?003003o?00000;o?08000;o?00D003o?000oc`00?ll003o?000
oc`00?ll003o?000oc`00?ll003o?0800007oc`00?ll003o?000oc`00P0000?o?000oc`00P0000Go
?000oc`00?ll00800004oc`00000oc`200000oll003o?00300000oll003o?00300000oll003o?003
00001?ll00000?ll0P0000Co?000003o?0800005oc`00000003o?00300001?ll00000?ll0`002Oll
0008oc`01@00occo??ll00001Oll00D00?llocco?00000Ko?005003o??lloc`00005oc`01@00occo
??ll00001_ll00D00?llocco?00000Go?005003o??lloc`00005oc`01@00occo??ll00001_ll00D0
0?llocco?00000Go?005003o??lloc`00006oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<0
0?lloc`00oll00D00?llocco?00000Go?005003o??lloc`00005oc`20004oc`00`00occo?002oc`0
1000occo?0000oll00<00?ll00000_ll00<00?ll00000_ll00<00?ll00000_ll00<00?ll00000_ll
0P000_ll01@00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll0P0000Oo?000oc`0
0?ll003o?00200000oll003o?00200001Oll003o?000oc`00P0000Co?000003o?0800003oc`00?ll
00<00004oc`00000oc`200000oll003o?00300001?ll00000?ll0P0000Co?000003o?0800005oc`0
0000003o?00300001?ll00000?ll0`002Oll0008oc`01@00occo??ll00001Oll00D00?llocco?000
00Ko?005003o??lloc`00005oc`01@00occo??ll00001_ll00D00?llocco?00000Go?005003o??ll
oc`00005oc`01@00occo??ll00001_ll00D00?llocco?00000Go?005003o??lloc`00006oc`01@00
occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Go?005003o??ll
oc`00005oc`20004oc`00`00occo?002oc`01000occo?0000oll00<00?ll00000_ll00<00?ll0000
0_ll00<00?ll00000_ll00<00?ll00000_ll0P000_ll01@00?ll003o?000oc`00?ll003o?000oc`0
0?ll003o?000oc`00?ll0P0000Go?000oc`00?ll00800005oc`00?ll003o?00200001Oll003o?000
oc`00P0000Co?000003o?0800003oc`00?ll00<00004oc`00000oc`200000oll003o?00300001?ll
00000?ll0P0000Co?000003o?0800005oc`00000003o?00300001?ll00000?ll0`002Oll0008oc`0
1@00occo??ll00001Oll00D00?llocco?00000Ko?005003o??lloc`00005oc`01@00occo??ll0000
1_ll00D00?llocco?00000Go?005003o??lloc`00005oc`01@00occo??ll00001_ll00D00?llocco
?00000Ko?004003o??ll0006oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll
00D00?llocco?00000Go?005003o??lloc`00005oc`20004oc`00`00occo?002oc`01000occo?000
0oll00<00?ll00000_ll00<00?ll00000_ll00<00?ll00000_ll00<00?ll00000_ll0P000_ll01@0
0?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll0P0000Go?000oc`00?ll00800005
oc`00?ll003o?00200001Oll003o?000oc`00P0000Co?000003o?0800003oc`00?ll00<00004oc`0
0000oc`200000oll003o?00300001?ll00000?ll0P0000Co?000003o?0800005oc`00000003o?003
00001?ll00000?ll0`002Oll0008oc`01@00occo??ll00001Oll00D00?llocco?00000Ko?005003o
??lloc`00005oc`01@00occo??ll00001_ll00D00?llocco?00000Go?005003o??lloc`00005oc`0
1@00occo??ll00001_ll00D00?llocco?00000Ko?004003o??ll0006oc`01@00occo??ll00001Oll
00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Go?005003o??lloc`00005oc`20004
oc`00`00occo?002oc`01000occo?0000oll00<00?ll00000_ll00<00?ll00000_ll00<00?ll0000
0_ll00<00?ll00000_ll0P000_ll01@00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`0
0?ll0P0000Go?000oc`00?ll00800005oc`00?ll003o?00200001Oll003o?000oc`00P0000Co?000
003o?0800003oc`00?ll00<00004oc`00000oc`200000oll003o?00300001?ll00000?ll0P0000Co
?000003o?0800005oc`00000003o?00300001?ll00000?ll0`002Oll0008oc`01@00occo??ll0000
1Oll00D00?llocco?00000Ko?005003o??lloc`00005oc`01@00occo??ll00001_ll00D00?llocco
?00000Go?005003o??lloc`00005oc`01@00occo??ll00001_ll00D00?llocco?00000Ko?004003o
??ll0006oc`01@00occo??ll00001Oll00D00?llocco?00000Ko?005003o??lloc`00005oc`01@00
occo??ll00001Oll0P001?ll00<00?lloc`00_ll00@00?lloc`000?o?003003o?00000;o?003003o
?00000;o?003003o?00000;o?003003o?00000;o?08000;o?00D003o?000oc`00?ll003o?000oc`0
0?ll003o?000oc`00?ll003o?08000;o?0800008oc`00000oc`00?ll003o?0800005oc`00?ll003o
?00200001?ll00000?ll0P0000Co?000003o?0800004oc`00000oc`200000oll003o?00300001?ll
00000?ll0P0000Co?000003o?0800005oc`00000003o?00300001?ll00000?ll0`002Oll0008oc`0
1@00occo??ll00001Oll00D00?llocco?00000Ko?004003o??ll0006oc`01@00occo??ll00001_ll
00D00?llocco?00000Go?005003o??lloc`00005oc`01@00occo??ll00001_ll00D00?llocco?000
00Ko?004003o??ll0006oc`01@00occo??ll00001Oll00D00?llocco?00000Ko?005003o??lloc`0
0005oc`01@00occo??ll00001Oll0P001?ll00<00?lloc`00_ll00@00?lloc`000?o?003003o?000
00;o?003003o?00000;o?003003o?00000;o?003003o?00000;o?08000;o?00D003o?000oc`00?ll
003o?000oc`00?ll003o?000oc`00?ll003o?08000;o?0800008oc`00000oc`00?ll003o?0800005
oc`00?ll003o?00200001?ll00000?ll0P0000Co?000003o?0800004oc`00000oc`200000oll003o
?00300001?ll00000?ll0P0000Co?000003o?0800005oc`00000003o?00300001?ll00000?ll0`00
2Oll0008oc`01@00occo??ll00001Oll00D00?llocco?00000Ko?004003o??ll0006oc`01@00occo
??ll00001_ll00D00?llocco?00000Go?005003o??lloc`00005oc`01@00occo??ll00001_ll00D0
0?llocco?00000Ko?004003o??ll0006oc`01@00occo??ll00001Oll00D00?llocco?00000Ko?005
003o??lloc`00005oc`01@00occo??ll00001Oll0P001?ll00<00?lloc`00_ll00<00?ll00001?ll
00<00?ll00000_ll00<00?ll00000_ll00<00?ll00000_ll00<00?ll00000_ll0P000_ll01@00?ll
003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll0P000_ll0P0000So?000003o?000oc`0
0?ll0P0000Go?000oc`00?ll00800004oc`00000oc`200001?ll00000?ll0P0000Co?000003o?080
0003oc`00?ll00<00004oc`00000oc`200001?ll00000?ll0P0000Go?00000000?ll00<00004oc`0
0000oc`30009oc`000So?005003o??lloc`00005oc`01@00occo??ll00001_ll00@00?lloc`000Ko
?005003o??lloc`00006oc`01@00occo??ll00001Oll00D00?llocco?00000Go?005003o??lloc`0
0006oc`01@00occo??ll00001_ll00@00?lloc`000Ko?005003o??lloc`00005oc`01@00occo??ll
00001_ll00D00?llocco?00000Go?005003o??lloc`00005oc`20004oc`00`00occo?002oc`00`00
oc`00004oc`00`00oc`00002oc`00`00oc`00002oc`00`00oc`00002oc`00`00oc`00002oc`20002
oc`05000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`20002oc`200000oll0000
0002oc`200002?ll00000?ll003o?000oc`200001?ll00000?ll0P0000Co?000003o?0800004oc`0
0000oc`200000oll003o?00300001?ll00000?ll0P0000Co?000003o?0800005oc`00000003o?003
00001?ll00000?ll0`002Oll0008oc`01@00occo??ll00001Oll00D00?llocco?00000Ko?004003o
??ll0006oc`01@00occo??ll00001_ll00D00?llocco?00000Go?005003o??lloc`00005oc`01@00
occo??ll00001_ll00D00?llocco?00000Ko?004003o??ll0006oc`01@00occo??ll00001Oll00D0
0?llocco?00000Ko?005003o??lloc`00005oc`01@00occo??ll00001Oll0P001?ll00<00?lloc`0
0_ll00<00?ll00001?ll00<00?ll00000_ll00<00?ll00000_ll00<00?ll00000_ll00<00?ll0000
0_ll0P000_ll01@00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll0P000_ll0P00
00?o?00000000_ll0P0000So?000003o?000oc`00?ll0P0000Co?000003o?0800004oc`00000oc`2
00001?ll00000?ll0P0000?o?000oc`00`0000Co?000003o?0800004oc`00000oc`200001Oll0000
0000oc`00`0000Co?000003o?0<000Wo?0002?ll00D00?llocco?00000Go?005003o??lloc`00006
oc`01000occo?0001_ll00D00?llocco?00000Ko?004003o??ll0006oc`01@00occo??ll00001Oll
00D00?llocco?00000Ko?005003o??lloc`00006oc`01000occo?0001_ll00D00?llocco?00000Go
?005003o??lloc`00006oc`01@00occo??ll00001_ll00@00?lloc`000Go?08000Co?003003o??ll
00;o?003003o?00000Co?003003o?00000;o?003003o?00000;o?003003o?00000;o?003003o?000
00;o?08000;o?00D003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?08000;o?080
0003oc`0000000;o?0800008oc`00000oc`00?ll003o?0800004oc`00000oc`200001?ll00000?ll
0P0000Co?000003o?0800003oc`00?ll00<00004oc`00000oc`200001?ll00000?ll0P0000Go?000
00000?ll00<00004oc`00000oc`30009oc`000So?005003o??lloc`00005oc`01@00occo??ll0000
1_ll00@00?lloc`000Ko?005003o??lloc`00006oc`01000occo?0001_ll00D00?llocco?00000Go
?005003o??lloc`00006oc`01@00occo??ll00001_ll00@00?lloc`000Ko?005003o??lloc`00005
oc`01@00occo??ll00001_ll00D00?llocco?00000Ko?004003o??ll0005oc`20004oc`00`00occo
?002oc`00`00oc`00004oc`00`00oc`00002oc`00`00oc`00002oc`00`00oc`00002oc`00`00oc`0
0002oc`20002oc`05000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`20002oc`2
00000oll00000002oc`200002?ll00000?ll003o?000oc`200001?ll00000?ll0P0000Co?000003o
?0800004oc`00000oc`200000oll003o?00300001?ll00000?ll0P0000Co?000003o?0800005oc`0
0000003o?00300001?ll00000?ll0`002Oll0008oc`01@00occo??ll00001Oll00D00?llocco?000
00Ko?004003o??ll0006oc`01@00occo??ll00001_ll00@00?lloc`000Ko?005003o??lloc`00005
oc`01@00occo??ll00001_ll00D00?llocco?00000Ko?004003o??ll0006oc`01@00occo??ll0000
1Oll00D00?llocco?00000Ko?005003o??lloc`00006oc`01000occo?0001Oll0P001?ll00<00?ll
oc`00_ll00<00?ll00001?ll00<00?ll00000_ll00<00?ll00000_ll00<00?ll00000_ll00<00?ll
00000_ll0P000_ll01@00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll0P000_ll
0P0000?o?00000000_ll0P0000So?000003o?000oc`00?ll0P0000Co?000003o?0800004oc`00000
oc`200001?ll00000?ll0P0000?o?000oc`00`0000Co?000003o?0800004oc`00000oc`200001Oll
00000000oc`00`0000Co?000003o?0<000Wo?0002?ll00D00?llocco?00000Go?005003o??lloc`0
0006oc`01000occo?0001_ll00D00?llocco?00000Ko?004003o??ll0006oc`01@00occo??ll0000
1Oll00D00?llocco?00000Ko?005003o??lloc`00006oc`01000occo?0001_ll00D00?llocco?000
00Go?005003o??lloc`00006oc`01@00occo??ll00001_ll00@00?lloc`000Go?08000Co?003003o
??ll00;o?003003o?00000Co?003003o?00000;o?003003o?00000?o?08000;o?003003o?00000;o
?08000;o?00D003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?08000;o?0800003
oc`0000000;o?0800008oc`00000oc`00?ll003o?0800004oc`00000oc`200001?ll00000?ll0P00
00Co?000003o?0800003oc`00?ll00<00004oc`00000oc`200001?ll00000?ll0P0000Go?0000000
0?ll00<00004oc`00000oc`30009oc`000So?005003o??lloc`00005oc`01@00occo??ll00001_ll
00@00?lloc`000Ko?005003o??lloc`00006oc`01000occo?0001_ll00D00?llocco?00000Ko?004
003o??ll0006oc`01@00occo??ll00001_ll00@00?lloc`000Ko?005003o??lloc`00005oc`01@00
occo??ll00001_ll00@00?lloc`000Oo?004003o??ll0005oc`20004oc`00`00occo?002oc`00`00
oc`00004oc`00`00oc`00002oc`00`00oc`00003oc`20002oc`00`00oc`00002oc`20002oc`05000
oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`20002oc`200000oll00000002oc`2
00002?ll00000?ll003o?000oc`200001?ll00000?ll0P0000Co?000003o?0800004oc`00000oc`2
00000oll003o?00300001?ll00000?ll0P0000Co?000003o?0800005oc`00000003o?00300001?ll
00000?ll0`002Oll0008oc`01@00occo??ll00001_ll00@00?lloc`000Ko?004003o??ll0006oc`0
1@00occo??ll00001_ll00@00?lloc`000Ko?005003o??lloc`00006oc`01000occo?0001_ll00D0
0?llocco?00000Ko?004003o??ll0006oc`01@00occo??ll00001Oll00D00?llocco?00000Ko?004
003o??ll0007oc`01000occo?0001Oll0P001?ll00<00?lloc`00_ll00<00?ll00001?ll00<00?ll
00000_ll00<00?ll00000oll0P000_ll00<00?ll00000_ll0P000_ll00L00?ll003o?000oc`00002
oc`200002Oll003o?000oc`00?ll003o?0020002oc`200000oll00000002oc`200002?ll00000?ll
003o?000oc`200001?ll00000?ll0P0000Co?000003o?0800004oc`00000oc`200000oll003o?003
00001?ll00000?ll0P0000Co?000003o?0800005oc`00000003o?00300001?ll00000?ll0`002Oll
0008oc`01@00occo??ll00001_ll00@00?lloc`000Ko?004003o??ll0006oc`01@00occo??ll0000
1_ll00@00?lloc`000Ko?005003o??lloc`00006oc`01000occo?0001_ll00D00?llocco?00000Ko
?004003o??ll0006oc`01@00occo??ll00001Oll00D00?llocco?00000Ko?004003o??ll0007oc`0
1000occo?0001Oll00<00?ll00000oll00<00?lloc`00_ll00<00?ll00001?ll00<00?ll00000_ll
00<00?ll00000oll0P000_ll00<00?ll00000_ll0P000_ll00L00?ll003o?000oc`00002oc`20002
oc`200001Oll003o?000oc`00P000_ll0P0000?o?00000000_ll0P0000So?000003o?000oc`00?ll
0P0000Co?000003o?0800004oc`00000oc`200001?ll00000?ll0P0000?o?000oc`00`0000Co?000
003o?0800004oc`00000oc`200001Oll00000000oc`00`0000Co?000003o?0<000Wo?0002?ll00D0
0?llocco?00000Ko?004003o??ll0006oc`01000occo?0001_ll00D00?llocco?00000Ko?004003o
??ll0006oc`01@00occo??ll00001_ll00@00?lloc`000Ko?005003o??lloc`00006oc`01000occo
?0001_ll00D00?llocco?00000Go?005003o??lloc`00006oc`200001Oll003o??ll00001?ll1000
1Oll00<00?ll00000oll00<00?lloc`00_ll00<00?ll00001?ll00<00?ll00000_ll00<00?ll0000
0oll0P000oll0P000_ll0P000_ll00L00?ll003o?000oc`00002oc`20002oc`200001Oll003o?000
oc`00P000_ll0P0000?o?00000000_ll0P0000So?000003o?000oc`00?ll0P0000Co?000003o?080
0004oc`00000oc`200001?ll00000?ll0P0000Co?000003o?0800004oc`00000oc`200001?ll0000
0?ll0P0000?o?00000000P0000Co?000003o?0800005oc`00000oc`00008oc`000So?005003o??ll
oc`00006oc`01000occo?0001_ll00@00?lloc`000Ko?005003o??lloc`00006oc`01000occo?000
1_ll00D00?llocco?00000Ko?004003o??ll0006oc`01@00occo??ll00001_ll00@00?lloc`000Ko
?005003o??lloc`00005oc`01@00occo??ll00001Oll0P0000?o?00000001oll00@00?lloc`000Go
?003003o?00000;o?003003o??ll00?o?003003o?00000Co?003003o?00000;o?003003o?00000?o
?08000?o?08000;o?08000;o?007003o?000oc`00?ll00000_ll0P000_ll0P0000Go?000oc`00?ll
008000;o?0800003oc`0000000;o?0800008oc`00000oc`00?ll003o?0800004oc`00000oc`20000
1?ll00000?ll0P0000Co?000003o?0800004oc`00000oc`200001?ll00000?ll0P0000Co?000003o
?0800003oc`0000000800004oc`00000oc`200001Oll00000?ll00002?ll0008oc`01@00occo??ll
00001_ll00@00?lloc`000Ko?004003o??ll0006oc`01@00occo??ll00001_ll00@00?lloc`000Ko
?005003o??lloc`00006oc`01000occo?0001_ll00D00?llocco?00000Ko?004003o??ll0006oc`0
1@00occo??ll00001Oll00D00?llocco?00000Go?0800003oc`0000000Oo?004003o??ll0005oc`3
0002oc`00`00occo?003oc`00`00oc`00004oc`00`00oc`00002oc`00`00oc`00003oc`20003oc`2
0002oc`20002oc`01`00oc`00?ll003o?00000;o?08000;o?0800005oc`00?ll003o?0020002oc`2
00000oll00000002oc`200002?ll00000?ll003o?000oc`200001?ll00000?ll0P0000Co?000003o
?0800004oc`00000oc`200001?ll00000?ll0P0000Co?000003o?0800004oc`00000oc`200000oll
0000000200001?ll00000?ll0P0000Go?000003o?00000So?0002?ll00D00?llocco?00000Ko?004
003o??ll0006oc`01000occo?0001_ll00D00?llocco?00000Ko?004003o??ll0006oc`01@00occo
??ll00001_ll00@00?lloc`000Ko?005003o??lloc`00006oc`01000occo?0001_ll00D00?llocco
?00000Go?005003o??lloc`00005oc`200000oll00000007oc`40005oc`00`00oc`00002oc`00`00
occo?003oc`00`00oc`00004oc`00`00oc`00002oc`00`00oc`00003oc`20003oc`20002oc`20002
oc`01`00oc`00?ll003o?00000;o?08000;o?0800005oc`00?ll003o?0020002oc`200000oll0000
0002oc`200002?ll00000?ll003o?000oc`200001?ll00000?ll0P0000Co?000003o?0800004oc`0
0000oc`200001?ll00000?ll0P0000Co?000003o?0800004oc`00000oc`200000oll000000020000
1?ll00000?ll0P0000Go?000003o?00000So?0002?ll00@00?lloc`000Oo?004003o??ll0006oc`0
1000occo?0001_ll00D00?llocco?00000Ko?004003o??ll0006oc`01@00occo??ll00001_ll00@0
0?lloc`000Ko?005003o??lloc`00006oc`01000occo?0001_ll00D00?llocco?00000Ko?004003o
??ll0005oc`200000oll00000007oc`01000occo?0001Oll00<00?ll00000_ll00<00?lloc`00oll
00<00?ll00001?ll00<00?ll00000oll0P000oll0P000oll0P000_ll0P000_ll00L00?ll003o?000
oc`00002oc`20002oc`200001Oll003o?000oc`00P000_ll0P0000?o?00000000_ll0P0000So?000
003o?000oc`00?ll0P0000Co?000003o?0800004oc`00000oc`200000oll00000002oc`01@00oc`0
0000oc`00P0000Co?000003o?0800004oc`00000oc`200000oll0000000200001?ll00000?ll0P00
00Go?000003o?00000So?0002?ll00@00?lloc`000Oo?004003o??ll0006oc`01000occo?0001_ll
00D00?llocco?00000Ko?004003o??ll0006oc`01@00occo??ll00001_ll00@00?lloc`000Ko?005
003o??lloc`00006oc`01000occo?0001_ll00D00?llocco?00000Ko?004003o??ll0005oc`20000
0oll00000007oc`01000occo?0001Oll00<00?ll00000_ll00<00?lloc`00oll00<00?ll00001?ll
00<00?ll00000oll0P000oll0P000oll0P000_ll0P000_ll00L00?ll003o?000oc`00002oc`20002
oc`200001Oll003o?000oc`00P000_ll0P0000?o?00000000_ll0P0000So?000003o?000oc`00?ll
0P0000Co?000003o?0800004oc`00000oc`200000oll00000002oc`01@00oc`00000oc`00P0000Co
?000003o?0800004oc`00000oc`200000oll0000000200001?ll00000?ll0P0000Go?000003o?000
00So?0002?ll00@00?lloc`000Oo?004003o??ll0006oc`01000occo?0001_ll00D00?llocco?000
00Ko?004003o??ll0006oc`01@00occo??ll00001_ll00@00?lloc`000Ko?005003o??lloc`00006
oc`01000occo?0001_ll00D00?llocco?00000Ko?004003o??ll0006oc`200000oll003o?006oc`4
0005oc`00`00oc`00002oc`00`00occo?003oc`00`00oc`00004oc`00`00oc`00003oc`20003oc`2
0003oc`20002oc`20002oc`01`00oc`00?ll003o?00000;o?08000;o?0800005oc`00?ll003o?002
0002oc`200000oll00000002oc`200001?ll00000?ll0P000_ll0P0000Co?000003o?0800004oc`0
0000oc`200000oll00000002oc`01@00occo?000oc`00P0000Co?000003o?0800004oc`00000oc`2
00000oll0000000200001?ll00000?ll0P0000Go?000003o?00000So?0002?ll00@00?lloc`000Oo
?003003o?00000Oo?004003o??ll0006oc`01@00occo??ll00001_ll00@00?lloc`000Ko?005003o
??lloc`00006oc`01000occo?0001_ll00D00?llocco?00000Ko?004003o??ll0006oc`01@00occo
??ll00001_ll00@00?lloc`000Ko?004003o??ll0007oc`01000occo?0001Oll00<00?ll00000_ll
00<00?lloc`00oll00<00?ll00001?ll00<00?ll00000oll0P000oll0P000oll0P000_ll0P000_ll
00L00?ll003o?000oc`00002oc`20002oc`200001Oll003o?000oc`00P000_ll0P0000?o?0000000
0_ll0P0000Co?000003o?08000;o?0800004oc`00000oc`200001?ll00000?ll0P0000?o?0000000
0_ll00D00?lloc`00?ll00800004oc`00000oc`200001?ll00000?ll0P0000?o?00000000P0000Co
?000003o?0800005oc`00000oc`00008oc`000So?004003o??ll0007oc`00`00oc`00007oc`01000
occo?0001_ll00D00?llocco?00000Ko?004003o??ll0006oc`01@00occo??ll00001_ll00@00?ll
oc`000Ko?005003o??lloc`00006oc`01000occo?0001_ll00@00?lloc`000Oo?004003o??ll0006
oc`01000occo?0001oll00@00?lloc`000Go?003003o?00000;o?003003o??ll00?o?003003o?000
00Co?08000Co?08000?o?08000?o?08000;o?08000;o?007003o?000oc`00?ll00000_ll0P000_ll
0P0000Go?000oc`00?ll008000;o?0800003oc`0000000;o?0800004oc`00000oc`20002oc`20000
1?ll00000?ll0P0000Co?000003o?0800003oc`0000000;o?005003o??ll003o?00200001?ll0000
0?ll0P0000Co?000003o?0800003oc`0000000800004oc`00000oc`200001Oll00000?ll00002?ll
0008oc`01000occo?0001oll00<00?ll00001oll00@00?lloc`000Ko?004003o??ll0007oc`01000
occo?0001_ll00D00?llocco?00000Ko?004003o??ll0006oc`01@00occo??ll00001_ll00@00?ll
oc`000Ko?004003o??ll0007oc`01000occo?0001_ll00@00?lloc`000Oo?004003o??ll0005oc`0
0`00oc`00002oc`00`00occo?003oc`00`00oc`00004oc`20004oc`20003oc`20003oc`20002oc`2
0002oc`01`00oc`00?ll003o?00000;o?08000;o?0800005oc`00?ll003o?0020002oc`200000oll
00000002oc`200001?ll00000?ll0P000_ll0P0000Co?000003o?0800003oc`0000000;o?004003o
?0000002oc`01@00occo?000oc`00P0000Co?000003o?0800004oc`00000oc`200000oll00000002
00001?ll00000?ll0P0000Go?000003o?00000So?0002?ll00@00?lloc`000Oo?003003o?00000Oo
?004003o??ll0006oc`01000occo?0001oll00@00?lloc`000Oo?004003o??ll0006oc`01000occo
?0001oll00@00?lloc`000Ko?004003o??ll0006oc`01000occo?0001oll00@00?lloc`000Ko?004
003o??ll0007oc`01000occo?0001Oll0`000_ll00<00?lloc`00oll00<00?ll00001?ll0P001?ll
0P000oll0P000oll0P000_ll0P000_ll00L00?ll003o?000oc`00002oc`20002oc`200001Oll003o
?000oc`00P000_ll0P0000?o?00000000_ll0P0000Co?000003o?08000;o?0800004oc`00000oc`2
00000oll00000002oc`01000oc`000000_ll00D00?lloc`00?ll00800004oc`00000oc`200001?ll
00000?ll0P0000?o?00000000P0000Co?000003o?0800005oc`00000oc`00008oc`000So?004003o
??ll0007oc`00`00oc`00007oc`01000occo?0001_ll00@00?lloc`000Oo?004003o??ll0007oc`0
1000occo?0001_ll00@00?lloc`000Oo?004003o??ll0006oc`01000occo?0001_ll00@00?lloc`0
00Oo?004003o??ll0006oc`01000occo?0001oll00@00?lloc`000Go?003003o?00000;o?003003o
??ll00?o?003003o?00000Co?08000Co?08000?o?08000?o?08000;o?08000;o?007003o?000oc`0
0?ll00000_ll0P000_ll0P0000Go?000oc`00?ll008000;o?0800003oc`0000000;o?0800004oc`0
0000oc`20002oc`200001?ll00000?ll0P0000?o?00000000_ll00@00?ll000000;o?004003o??ll
0002oc`01@00oc`00000oc`00P0000Co?000003o?0800003oc`0000000800004oc`00000oc`20000
1Oll00000?ll00002?ll0008oc`01000occo?0001oll00<00?ll00001oll00@00?lloc`000Oo?003
003o?00000Oo?004003o??ll0007oc`01000occo?0001_ll00@00?lloc`000Oo?004003o??ll0006
oc`01000occo?0001_ll00@00?lloc`000Oo?004003o??ll0006oc`01000occo?0001oll00@00?ll
oc`000Go?003003o?00000;o?003003o??ll00?o?003003o?00000Co?08000Co?08000?o?08000?o
?08000;o?08000;o?007003o?000oc`00?ll00000_ll0P000_ll0P0000Go?000oc`00?ll008000;o
?0800003oc`0000000;o?0800004oc`00000oc`20002oc`200001?ll00000?ll0P0000?o?0000000
0_ll00@00?ll000000;o?004003o??ll0002oc`01@00oc`00000oc`00P0000Co?000003o?0800003
oc`0000000800004oc`00000oc`200001Oll00000?ll00002?ll0008oc`01000occo?0001oll00<0
0?ll00001oll00@00?lloc`000Oo?003003o?00000Oo?004003o??ll0007oc`01000occo?0001_ll
00@00?lloc`000Oo?004003o??ll0006oc`01000occo?0001_ll00@00?lloc`000Oo?004003o??ll
0006oc`01000occo?0001oll00@00?lloc`000Go?003003o?00000;o?003003o??ll00?o?003003o
?00000Co?08000Co?08000?o?08000?o?08000;o?08000;o?007003o?000oc`00?ll00000_ll0P00
0_ll0P0000?o?00000000_ll0P000_ll0P0000?o?00000000_ll0P0000Co?000003o?08000;o?080
0004oc`00000oc`200000oll00000002oc`01000occo?0000_ll00@00?lloc`000;o?005003o?000
003o?00200001?ll00000?ll0P0000?o?00000000P0000Co?000003o?0800005oc`00000oc`00008
oc`000So?004003o??ll0007oc`00`00oc`00007oc`01000occo?0001oll00<00?ll00001oll00@0
0?lloc`000Oo?003003o?00000Oo?004003o??ll0007oc`01000occo?0001_ll00@00?lloc`000Ko
?004003o??ll0007oc`01000occo?0001_ll00@00?lloc`000Oo?004003o??ll0005oc`00`00oc`0
0002oc`00`00occo?003oc`00`00oc`00004oc`20004oc`20003oc`20003oc`20002oc`20002oc`0
1`00oc`00?ll003o?00000;o?08000;o?0800003oc`0000000;o?08000;o?0800003oc`0000000;o
?0800003oc`0000000;o?003003o??ll00800004oc`00000oc`200000oll00000002oc`01000occo
?0000_ll00@00?lloc`000;o?005003o?000003o?00200001?ll00000?ll0P0000Ko?000003o?000
oc`200001?ll00000?ll0P0000?o?000oc`01oll0008oc`01000occo?0001oll00<00?ll00001oll
00@00?lloc`000Oo?003003o?00000Oo?004003o??ll0007oc`00`00oc`00007oc`01000occo?000
1oll00@00?lloc`000Ko?004003o??ll0006oc`01000occo?0001oll00@00?lloc`000Ko?004003o
??ll0007oc`01000occo?0001Oll00<00?ll00000_ll00<00?lloc`00oll00<00?ll00001?ll0P00
1?ll0P000oll0P000oll0P000_ll0P000_ll00L00?ll003o?000oc`00002oc`20002oc`200000oll
00000002oc`20002oc`200000oll00000002oc`200000oll00000002oc`00`00occo?00200001?ll
00000?ll0P0000?o?00000000_ll00@00?lloc`000;o?004003o??ll0002oc`01@00oc`00000oc`0
0P0000Co?000003o?0800006oc`00000oc`00?ll0P0000Co?000003o?0800003oc`00?ll00Oo?000
2?ll00@00?lloc`000Oo?003003o?00000Oo?004003o??ll0007oc`00`00oc`00007oc`01000occo
?0001oll00<00?ll00001oll00@00?lloc`000Oo?003003o?00000Oo?004003o??ll0007oc`00`00
oc`00007oc`00`00oc`00007oc`01000occo?0001oll00@00?lloc`000Go?003003o?00000;o?003
003o??ll00?o?003003o?00000Co?08000Co?08000?o?08000?o?08000;o?08000;o?003003o?000
00;o?08000;o?08000;o?0800003oc`0000000;o?08000;o?0800003oc`0000000;o?0800003oc`0
000000;o?003003o??ll00800004oc`00000oc`200000oll00000002oc`01000occo?0000_ll00@0
0?lloc`000;o?005003o?000003o?00200001?ll00000?ll0P0000Ko?000003o?000oc`200001?ll
00000?ll0P0000?o?000oc`01oll0008oc`01000occo?0001oll00<00?ll00001oll00@00?lloc`0
00Oo?003003o?00000Oo?004003o??ll0007oc`00`00oc`00007oc`01000occo?0001oll00<00?ll
00001oll00@00?lloc`000Oo?003003o?00000Oo?003003o?00000Oo?004003o??ll0007oc`01000
occo?0001Oll00<00?ll00000_ll00<00?lloc`00oll00<00?ll00001?ll0P001?ll0P000oll0P00
0oll0P000_ll0P000_ll00<00?ll00000_ll0P000_ll0P000_ll0P0000?o?00000000_ll0P000_ll
0P0000?o?00000000_ll0P0000?o?00000000_ll00<00?lloc`00P0000Co?000003o?0800003oc`0
000000;o?004003o??ll0002oc`01000occo?0000_ll00D00?ll00000?ll00800004oc`00000oc`2
00001_ll00000?ll003o?0800004oc`00000oc`200000oll003o?007oc`000So?004003o??ll0007
oc`00`00oc`00007oc`01000occo?0001oll00<00?ll00001oll00@00?lloc`000Oo?003003o?000
00Oo?004003o??ll0007oc`00`00oc`00007oc`01000occo?0001oll00<00?ll00001oll00<00?ll
00001oll00@00?lloc`000Oo?004003o??ll0005oc`00`00oc`00002oc`00`00occo?004oc`20004
oc`20004oc`20003oc`20003oc`20002oc`20002oc`00`00oc`00002oc`20002oc`20002oc`20000
0oll00000002oc`20002oc`200000oll00000002oc`200000oll00000002oc`00`00occo?0020000
1?ll00000?ll0P0000?o?00000000_ll00@00?lloc`000;o?004003o??ll0002oc`01@00oc`00000
oc`00P0000Co?000003o?0800005oc`00000oc`00002oc`01@00oc`00000oc`00P0000?o?000oc`0
1oll0008oc`01000occo?0001oll00<00?ll00001oll00@00?lloc`000Oo?003003o?00000Oo?004
003o??ll0007oc`00`00oc`00007oc`01000occo?0001oll00<00?ll00001oll00@00?lloc`000Oo
?003003o?00000Oo?003003o?00000So?003003o?00000Oo?003003o?00000Ko?0<000;o?003003o
??ll00Co?08000Co?08000Co?08000?o?08000?o?08000;o?08000;o?003003o?00000;o?08000;o
?08000;o?0800003oc`0000000;o?08000;o?0800003oc`0000000;o?0800003oc`0000000;o?003
003o??ll00800004oc`00000oc`200000oll00000002oc`01000occo?0000_ll00@00?lloc`000;o
?005003o?000003o?00200001?ll00000?ll0P0000Go?000003o?00000;o?005003o?000003o?002
00000oll003o?007oc`000So?004003o??ll0007oc`00`00oc`00007oc`01000occo?0001oll00<0
0?ll00001oll00@00?lloc`000Oo?003003o?00000Oo?004003o??ll0007oc`00`00oc`00007oc`0
1000occo?0001oll00<00?ll00001oll00<00?ll00002?ll00<00?ll00001oll00<00?ll00001_ll
00<00?ll00000_ll00<00?lloc`01?ll0P001?ll0P001?ll0P000oll0P000oll0P000_ll0P000oll
0P000_ll0P000_ll0P000_ll0P0000?o?00000000_ll0P000_ll0P0000?o?00000000_ll0P0000?o
?00000000_ll00<00?lloc`00P0000Co?000003o?0800003oc`0000000;o?004003o??ll0002oc`0
1000occo?0000_ll00D00?ll00000?ll00800004oc`00000oc`200001Oll00000?ll00000_ll00D0
0?ll00000?ll00800003oc`00?ll00Oo?0002?ll00@00?lloc`000Oo?003003o?00000Oo?004003o
??ll0007oc`00`00oc`00007oc`00`00oc`00008oc`00`00oc`00007oc`01000occo?0001oll00<0
0?ll00001oll00@00?lloc`000Oo?003003o?00000Oo?003003o?00000So?003003o?00000Oo?003
003o?00000Ko?003003o?00000;o?003003o??ll00Co?08000Co?08000Co?08000?o?08000?o?080
00;o?08000?o?08000;o?08000;o?08000;o?0800003oc`0000000;o?08000;o?0800003oc`00000
00;o?0800003oc`0000000;o?003003o??ll00800004oc`00000oc`200000oll00000002oc`01000
occo?0000_ll00@00?lloc`000;o?005003o?000003o?00200001?ll00000?ll0P0000Go?000003o
?00000;o?005003o?000003o?00200000oll003o?007oc`000So?004003o??ll0007oc`00`00oc`0
0007oc`01000occo?0001oll00<00?ll00001oll00<00?ll00002?ll00<00?ll00001oll00@00?ll
oc`000Oo?003003o?00000Oo?004003o??ll0007oc`00`00oc`00007oc`00`00oc`00008oc`00`00
oc`00007oc`00`00oc`00006oc`00`00oc`00002oc`00`00occo?004oc`20004oc`20004oc`20003
oc`20003oc`20002oc`20003oc`01000occo??ll0P000_ll0P000_ll0P0000?o?00000000_ll0P00
0_ll0P0000?o?00000000_ll0P0000?o?00000000_ll00<00?lloc`00P0000Co?000003o?0800003
oc`0000000;o?004003o??ll0002oc`01000occo?0000_ll00D00?ll00000?ll00800004oc`00000
oc`200001Oll00000?ll00000_ll00H00?ll00000?ll0002oc`00`00occo?006oc`000So?004003o
??ll0007oc`00`00oc`00007oc`01000occo?0001oll00<00?ll00001oll00<00?ll00002?ll00<0
0?ll00001oll00@00?lloc`000Oo?003003o?00000Oo?004003o??ll0007oc`00`00oc`00007oc`0
0`00oc`00008oc`00`00oc`00007oc`00`00oc`00006oc`01P00occo?000oc`000Ko?08000Co?080
00Co?08000?o?08000?o?08000;o?08000?o?004003o??lloc`20002oc`20002oc`200000oll0000
0002oc`20002oc`200000oll00000002oc`200000oll00000002oc`00`00occo?00200001?ll0000
0?ll0P0000?o?00000000_ll00@00?lloc`000;o?004003o??ll0002oc`01@00oc`00000oc`00P00
00Co?000003o?0800005oc`00000oc`00002oc`01P00oc`00000oc`000;o?003003o??ll00Ko?000
2?ll00@00?lloc`000Oo?003003o?00000Oo?004003o??ll0007oc`00`00oc`00007oc`00`00oc`0
0008oc`00`00oc`00007oc`01000occo?0001oll00<00?ll00001oll00@00?lloc`000Oo?003003o
?00000Oo?003003o?00000So?003003o?00000Oo?003003o?00000Ko?006003o??ll003o?0001_ll
0P001?ll0P001?ll0P000oll0P000oll0P000_ll0P000oll00@00?llocco?08000;o?08000;o?080
0003oc`0000000;o?08000;o?0800003oc`0000000;o?0800003oc`0000000;o?003003o??ll0080
0004oc`00000oc`200000oll00000002oc`01000occo?0000_ll00@00?lloc`000;o?005003o??ll
003o?00200001?ll00000?ll0P0000Go?000003o?00000;o?006003o?000003o?0000_ll00<00?ll
oc`01_ll0008oc`01000occo?0001oll00<00?ll00001oll00@00?lloc`000Oo?003003o?00000Oo
?003003o?00000So?003003o?00000Oo?004003o??ll0007oc`00`00oc`00007oc`00`00oc`00008
oc`00`00oc`00007oc`00`00oc`00008oc`00`00oc`00007oc`00`00oc`00006oc`01P00occo?000
oc`000Ko?08000Co?08000Co?08000?o?08000?o?08000;o?08000?o?004003o??lloc`20002oc`2
0002oc`20002oc`00`00occo?0020002oc`00`00occo?0020002oc`200000oll00000002oc`00`00
occo?00200001?ll00000?ll0P0000?o?00000000_ll00@00?lloc`000;o?004003o??ll0002oc`0
1000occo?0000_ll00D00?ll00000?ll00800005oc`00000oc`00002oc`01P00oc`00000oc`000;o
?003003o??ll00Ko?0002Oll00<00?ll00001oll00<00?ll00001oll00@00?lloc`000Oo?003003o
?00000So?08000So?003003o?00000Oo?004003o??ll0007oc`00`00oc`00007oc`00`00oc`00008
oc`00`00oc`00007oc`00`00oc`00008oc`00`00oc`00007oc`00`00oc`00006oc`01P00occo?000
oc`000Ko?08000Co?08000Co?08000?o?08000?o?08000;o?08000?o?004003o??lloc`20002oc`2
0002oc`20002oc`00`00occo?0020002oc`00`00occo?0020002oc`200000oll00000002oc`00`00
occo?00200001?ll00000?ll0P0000?o?00000000_ll00@00?lloc`000;o?004003o??ll0002oc`0
1000occo?0000_ll00D00?ll00000?ll00800005oc`00000oc`00002oc`01P00oc`00000oc`000;o
?003003o??ll00Ko?0002Oll00<00?ll00001oll00<00?ll00001oll00@00?lloc`000Oo?003003o
?00000So?08000So?003003o?00000Oo?004003o??ll0007oc`00`00oc`00007oc`00`00oc`00008
oc`00`00oc`00007oc`00`00oc`00008oc`00`00oc`00007oc`00`00oc`00006oc`200001?ll003o
?0001_ll0P001?ll0P001?ll0P000oll0P000oll0P000_ll0P000oll00@00?llocco?08000;o?080
00;o?08000;o?003003o??ll008000;o?003003o??ll008000;o?003003o??ll008000;o?004003o
??ll0002oc`200001?ll00000?ll0P000_ll00@00?lloc`000;o?004003o??ll0002oc`01000occo
?0000_ll00D00?ll00000?ll00800005oc`00000oc`00002oc`01P00oc`00000oc`000;o?003003o
??ll00Ko?0002Oll00<00?ll00001oll00<00?ll00001oll00@00?lloc`000Oo?003003o?00000So
?08000So?003003o?00000Oo?004003o??ll0007oc`00`00oc`00007oc`00`00oc`00008oc`00`00
oc`00007oc`00`00oc`00008oc`00`00oc`00007oc`00`00oc`00006oc`01P00occo?000oc`000Ko
?08000Co?08000Co?08000?o?08000?o?08000;o?08000?o?004003o??lloc`20002oc`20002oc`2
0002oc`00`00occo?0020002oc`00`00occo?0020002oc`00`00occo?0020002oc`01000occo?000
0_ll0P0000Co?000003o?08000;o?004003o??ll0002oc`01000occo?0000_ll00@00?lloc`000;o
?005003o?000003o?00200001Oll00000?ll00000_ll00H00?ll00000?ll0002oc`00`00occo?006
oc`000Wo?003003o?00000Oo?003003o?00000Oo?004003o??ll0007oc`00`00oc`00008oc`20008
oc`00`00oc`00007oc`00`00oc`00008oc`00`00oc`00007oc`00`00oc`00008oc`00`00oc`00007
oc`00`00oc`00008oc`00`00oc`00007oc`00`00oc`00006oc`01P00occo?000oc`000Ko?08000Co
?08000Co?08000?o?08000?o?08000;o?08000?o?004003o??lloc`20002oc`20002oc`20002oc`0
0`00occo?0020002oc`01@00occo??ll00000_ll00<00?lloc`00P000_ll00@00?lloc`000;o?080
0004oc`00000oc`20002oc`01000occo?0000_ll00@00?lloc`000;o?004003o??ll0002oc`01@00
oc`00000oc`00P0000Go?000occo?00000;o?006003o?000003o?0000_ll00<00?lloc`01_ll0009
oc`00`00oc`00007oc`00`00oc`00008oc`00`00oc`00007oc`00`00oc`00008oc`20008oc`00`00
oc`00007oc`00`00oc`00008oc`00`00oc`00008oc`20008oc`00`00oc`00007oc`00`00oc`00008
oc`00`00oc`00007oc`00`00oc`00006oc`01P00occo?000oc`000Ko?08000Co?08000Co?08000?o
?08000?o?08000;o?08000?o?004003o??lloc`20002oc`20002oc`20002oc`00`00occo?0020002
oc`01@00occo??ll00000_ll00<00?lloc`00P000_ll00@00?lloc`000;o?0800004oc`00000oc`2
0002oc`01000occo?0000_ll00@00?lloc`000;o?004003o??ll0002oc`01@00oc`00000oc`00P00
00Go?000occo?00000;o?006003o?000003o?0000_ll00<00?lloc`01_ll0009oc`00`00oc`00007
oc`00`00oc`00008oc`00`00oc`00007oc`00`00oc`00008oc`20008oc`00`00oc`00008oc`20008
oc`00`00oc`00008oc`20008oc`00`00oc`00007oc`00`00oc`00008oc`20008oc`00`00oc`00006
oc`01P00occo?000oc`000Ko?08000Co?08000Co?08000?o?08000?o?08000;o?08000?o?004003o
??lloc`20002oc`20002oc`01@00occo??ll00000_ll0P000_ll00D00?llocco?00000;o?003003o
??ll008000;o?004003o??ll0002oc`00`00occo?00200000oll00000002oc`01000occo?0000_ll
00@00?lloc`000;o?004003o??ll0002oc`01@00oc`00000oc`00P0000Go?000occo?00000;o?006
003o?000003o?0000_ll00<00?lloc`01_ll0009oc`00`00oc`00007oc`00`00oc`00008oc`00`00
oc`00007oc`00`00oc`00008oc`20008oc`00`00oc`00008oc`20008oc`00`00oc`00008oc`20008
oc`00`00oc`00007oc`00`00oc`00008oc`20008oc`00`00oc`00006oc`01P00occo?000oc`000Ko
?08000Co?08000Co?08000?o?08000?o?08000;o?08000?o?004003o??lloc`20002oc`20002oc`0
1@00occo??ll00000_ll0P000_ll00D00?llocco?00000;o?003003o??ll008000;o?004003o??ll
0002oc`00`00occo?00200000oll00000002oc`01000occo?0000_ll00@00?lloc`000;o?004003o
??ll0002oc`01@00oc`00000oc`00P0000Go?000occo?00000;o?006003o?000003o?0000_ll00<0
0?lloc`01_ll0009oc`00`00oc`00007oc`00`00oc`00008oc`00`00oc`00007oc`00`00oc`00008
oc`20008oc`00`00oc`00008oc`20008oc`00`00oc`00008oc`20008oc`00`00oc`00007oc`00`00
oc`00008oc`20008oc`00`00oc`00006oc`01P00occo?000oc`000Ko?08000Co?08000Co?08000?o
?08000?o?08000?o?005003o??lloc`00003oc`20002oc`20002oc`01@00occo??ll00000_ll0P00
0_ll00D00?llocco?00000;o?003003o??ll008000;o?004003o??ll0002oc`00`00occo?0020000
0oll00000002oc`01000occo?0000_ll00@00?lloc`000;o?004003o??ll0002oc`01@00oc`00000
oc`00P0000Go?000occo?00000;o?006003o?000003o?0000_ll00<00?lloc`01_ll0009oc`00`00
oc`00007oc`00`00oc`00008oc`00`00oc`00007oc`00`00oc`00008oc`20008oc`00`00oc`00008
oc`20008oc`00`00oc`00008oc`20008oc`00`00oc`00007oc`00`00oc`00008oc`20008oc`00`00
oc`00006oc`01P00occo?000oc`000Ko?08000Co?08000Co?08000?o?08000?o?08000?o?005003o
??lloc`00003oc`20002oc`20002oc`01@00occo??ll00000_ll0P000_ll00D00?llocco?00000;o
?003003o??ll008000;o?004003o??ll0002oc`00`00occo?00200000oll00000002oc`01000occo
?0000_ll00@00?lloc`000;o?004003o??ll0002oc`01@00oc`00000oc`00P0000Go?000occo?000
00;o?006003o?000003o?0000_ll00<00?lloc`01_ll0009oc`00`00oc`00008oc`20008oc`00`00
oc`00007oc`00`00oc`00008oc`20008oc`00`00oc`00008oc`20008oc`00`00oc`00008oc`20008
oc`00`00oc`00007oc`00`00oc`00008oc`20008oc`00`00oc`00006oc`01P00occo?000oc`000Ko
?08000Co?08000Co?08000?o?08000?o?08000?o?005003o??lloc`00003oc`20002oc`20002oc`0
1@00occo??ll00000_ll0P000_ll00D00?llocco?00000;o?003003o??ll008000;o?004003o??ll
0002oc`00`00occo?00200000oll00000002oc`01000occo?0000_ll00@00?lloc`000;o?004003o
??ll0002oc`01@00oc`00000oc`00P0000Go?000occo?00000;o?006003o?000003o?0000_ll00<0
0?lloc`01_ll0009oc`20009oc`20008oc`20008oc`00`00oc`00008oc`20008oc`00`00oc`00008
oc`20008oc`00`00oc`00008oc`20008oc`20008oc`00`00oc`00008oc`20008oc`00`00oc`00006
oc`200001?ll003o?0001_ll0P001?ll0P001?ll0P000oll0P000oll00<00?lloc`00_ll00D00?ll
occo?00000?o?08000;o?08000;o?005003o??lloc`00002oc`20002oc`01@00occo??ll00000_ll
00<00?lloc`00P000_ll00@00?lloc`000;o?003003o??ll00800003oc`0000000;o?004003o??ll
0002oc`01000occo?0000_ll00@00?lloc`000;o?006003o?000003o?0000_ll00@00?lloc`000;o
?006003o?000003o?0000_ll00<00?lloc`01_ll0009oc`20009oc`20008oc`20008oc`00`00oc`0
0008oc`20008oc`00`00oc`00008oc`20008oc`00`00oc`00008oc`20008oc`20008oc`00`00oc`0
0008oc`20008oc`00`00oc`00006oc`00`00occo?0020007oc`20004oc`20004oc`20003oc`20003
oc`00`00occo?002oc`01@00occo??ll00000oll0P000_ll0P000_ll00D00?llocco?00000;o?080
00;o?005003o??lloc`00002oc`00`00occo?0020002oc`01000occo?0000_ll00<00?lloc`00P00
0_ll00@00?lloc`000;o?004003o??ll0002oc`01000occo?0000_ll00D00?lloc`00?ll00800005
oc`00?lloc`00002oc`01000occo?0000_ll00<00?ll00000_ll00<00?lloc`01_ll0009oc`20009
oc`20008oc`20009oc`20008oc`20008oc`00`00oc`00008oc`20008oc`00`00oc`00008oc`20008
oc`20009oc`20008oc`20009oc`20006oc`00`00occo?0020007oc`20004oc`20004oc`20003oc`2
0003oc`00`00occo?002oc`01@00occo??ll00000oll0P000_ll00D00?llocco?00000?o?003003o
??ll008000;o?005003o??lloc`00002oc`00`00occo?0020002oc`01000occo?0000_ll00D00?ll
occo?00000;o?004003o??ll0002oc`01000occo?0000_ll00@00?lloc`000;o?005003o??ll003o
?00200001Oll003o??ll00000_ll00@00?lloc`000;o?003003o?00000;o?003003o??ll00Ko?000
2Oll0P002Oll0P002?ll0P002Oll0P002?ll0P002?ll00<00?ll00002?ll0P002?ll00<00?ll0000
2?ll0P002?ll0P002Oll0P002?ll0P002Oll0P001_ll00<00?lloc`00P001oll0P001?ll0P001?ll
00<00?lloc`00_ll0P000oll00<00?lloc`00_ll00D00?llocco?00000?o?08000;o?005003o??ll
oc`00003oc`00`00occo?0020002oc`01@00occo??ll00000_ll00D00?llocco?00000;o?004003o
??ll0002oc`01@00occo??ll00000_ll00@00?lloc`000;o?004003o??ll0002oc`01000occo?000
0_ll00@00?lloc`000;o?003003o?00000;o?004003o??ll0002oc`01P00occo?000oc`000;o?003
003o??ll00Ko?0002Oll0P002Oll0P002?ll0P002Oll0P002?ll0P002Oll00<00?lloc`01oll0P00
2?ll0P002Oll0P002?ll0P002Oll0P002?ll0P002Oll0P001_ll00<00?lloc`00P001oll0P001?ll
0P001?ll00<00?lloc`00_ll0P000oll00<00?lloc`00_ll00D00?llocco?00000?o?005003o??ll
oc`00003oc`01@00occo??ll00000_ll0P000_ll00D00?llocco?00000;o?005003o??lloc`00002
oc`01000occo?0000_ll00D00?llocco?00000;o?004003o??ll0002oc`01000occo?0000_ll00@0
0?lloc`000;o?004003o??ll0004oc`01000occo?0000_ll00@00?lloc`000;o?003003o?00000;o
?003003o??ll00Ko?0002Oll0P002Oll0P002?ll0P002Oll0P002?ll0P002Oll00<00?lloc`01oll
0P002Oll00<00?lloc`01oll0P002?ll0P002Oll0P002?ll0P002Oll00<00?lloc`01Oll00<00?ll
oc`00P001oll0P001?ll0P001?ll00<00?lloc`00_ll0P000oll00<00?lloc`00_ll00D00?llocco
?00000?o?005003o??lloc`00003oc`01@00occo??ll00000_ll0P000_ll00D00?llocco?00000;o
?005003o??lloc`00002oc`01000occo?0000_ll00D00?llocco?00000;o?004003o??ll0002oc`0
1000occo?0000_ll00@00?lloc`000;o?004003o??ll0004oc`01000occo?0000_ll00<00?lloc`0
2?ll00<00?lloc`01_ll0009oc`20009oc`20008oc`20009oc`20008oc`20009oc`00`00occo?007
oc`20009oc`00`00occo?007oc`20009oc`00`00occo?007oc`20008oc`20008oc`40005oc`00`00
occo?0020007oc`00`00occo?004oc`00`00occo?002oc`00`00occo?002oc`20003oc`00`00occo
?002oc`01@00occo??ll00000oll00D00?llocco?00000Oo?003003o??ll008000;o?003003o??ll
00Co?005003o??lloc`00002oc`00`00occo?003oc`01@00occo??ll00000_ll00@00?lloc`000;o
?004003o??ll0002oc`01000occo?0000_ll00@00?lloc`000Co?004003o??ll0002oc`00`00occo
?008oc`00`00occo?006oc`000Wo?08000Wo?08000Wo?003003o??ll00Oo?003003o??ll00Oo?080
00Wo?003003o??ll00Oo?08000Wo?003003o??ll00Oo?08000Wo?003003o??ll00Oo?08000So?080
00Wo?08000Ko?005003o??lloc`00007oc`00`00occo?004oc`00`00occo?002oc`00`00occo?002
oc`00`00occo?002oc`00`00occo?002oc`01@00occo??ll00000oll00D00?llocco?00000Oo?005
003o??lloc`00002oc`00`00occo?004oc`01@00occo??ll00000_ll00<00?lloc`00oll00D00?ll
occo?00000;o?004003o??ll0002oc`01000occo?0000_ll00@00?lloc`000[o?004003o??ll000=
oc`00`00occo?006oc`000[o?003003o??ll00Oo?003003o??ll00So?003003o??ll00Oo?003003o
??ll00Oo?003003o??ll00So?003003o??ll00So?003003o??ll00Oo?003003o??ll00Oo?003003o
??ll00So?003003o??ll00Oo?003003o??ll00So?003003o??ll00Oo?08000Ko?0<00003oc`00?ll
00Ko?003003o??ll00Co?003003o??ll00;o?003003o??ll013o?005003o??lloc`00003oc`00`00
occo?005oc`01@00occo??ll00000_ll00<00?lloc`02?ll00@00?lloc`000co?004003o??ll0008
oc`00`00occo?00;oc`01000occo?0005_ll0028oc`00`00occo?004oc`00`00occo?02>oc`008So
?003003o??ll00Co?003003o??ll08ko?000Q_ll0`001_ll00<00?lloc`0S_ll0028oc`00`00occo
?004oc`00`00occo?02>oc`00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-13.7307, -1.05358, \
0.0956841, 0.0119092}}]
}, Open  ]],

Cell[BoxData[
    \(Off[General::unfl]\)], "Input",
  InitializationCell->True],

Cell["We can calculate its SFTF and visualize it", "Subsubsection"],

Cell[BoxData[
    \(shift[f_, g_, b_, t_] := 
      Table[f[x] Conjugate[g[x - b]], {x, \(-10\), 10, t}]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(stft[f_, g_, t_] := 
      Take[Transpose[
          RotateLeft[
            Table[Fourier[shift[f, g, b, t]], {b, \(-10\), 10, 
                t}], {0, \(-10\)/t}]], \(-10\)/t, 2\ 10/t]\)], "Input",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListDensityPlot[Abs[stft[f, g, 0.1]], Mesh \[Rule] False, 
          PlotRange \[Rule] All, AspectRatio \[Rule] Automatic];\) // 
      Timing\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00480769 0.00961538 0.00480769 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -6 -9 ]
[.25962 -0.0125 6 0 ]
[.5 -0.0125 -9 -9 ]
[.5 -0.0125 9 0 ]
[.74038 -0.0125 -9 -9 ]
[.74038 -0.0125 9 0 ]
[.98077 -0.0125 -9 -9 ]
[.98077 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .00962 -6 -4.5 ]
[-0.0125 .00962 0 4.5 ]
[-0.0125 .10577 -12 -4.5 ]
[-0.0125 .10577 0 4.5 ]
[-0.0125 .20192 -12 -4.5 ]
[-0.0125 .20192 0 4.5 ]
[-0.0125 .29808 -12 -4.5 ]
[-0.0125 .29808 0 4.5 ]
[-0.0125 .39423 -12 -4.5 ]
[-0.0125 .39423 0 4.5 ]
[-0.0125 .49038 -18 -4.5 ]
[-0.0125 .49038 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .5 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(50)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(100)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(150)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(200)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.06731 0 m
.06731 .00375 L
s
.11538 0 m
.11538 .00375 L
s
.16346 0 m
.16346 .00375 L
s
.21154 0 m
.21154 .00375 L
s
.30769 0 m
.30769 .00375 L
s
.35577 0 m
.35577 .00375 L
s
.40385 0 m
.40385 .00375 L
s
.45192 0 m
.45192 .00375 L
s
.54808 0 m
.54808 .00375 L
s
.59615 0 m
.59615 .00375 L
s
.64423 0 m
.64423 .00375 L
s
.69231 0 m
.69231 .00375 L
s
.78846 0 m
.78846 .00375 L
s
.83654 0 m
.83654 .00375 L
s
.88462 0 m
.88462 .00375 L
s
.93269 0 m
.93269 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .00962 m
.00625 .00962 L
s
[(0)] -0.0125 .00962 1 0 Mshowa
0 .10577 m
.00625 .10577 L
s
[(20)] -0.0125 .10577 1 0 Mshowa
0 .20192 m
.00625 .20192 L
s
[(40)] -0.0125 .20192 1 0 Mshowa
0 .29808 m
.00625 .29808 L
s
[(60)] -0.0125 .29808 1 0 Mshowa
0 .39423 m
.00625 .39423 L
s
[(80)] -0.0125 .39423 1 0 Mshowa
0 .49038 m
.00625 .49038 L
s
[(100)] -0.0125 .49038 1 0 Mshowa
.125 Mabswid
0 .03365 m
.00375 .03365 L
s
0 .05769 m
.00375 .05769 L
s
0 .08173 m
.00375 .08173 L
s
0 .12981 m
.00375 .12981 L
s
0 .15385 m
.00375 .15385 L
s
0 .17788 m
.00375 .17788 L
s
0 .22596 m
.00375 .22596 L
s
0 .25 m
.00375 .25 L
s
0 .27404 m
.00375 .27404 L
s
0 .32212 m
.00375 .32212 L
s
0 .34615 m
.00375 .34615 L
s
0 .37019 m
.00375 .37019 L
s
0 .41827 m
.00375 .41827 L
s
0 .44231 m
.00375 .44231 L
s
0 .46635 m
.00375 .46635 L
s
.25 Mabswid
0 0 m
0 .5 L
s
.01923 .49375 m
.01923 .5 L
s
.25962 .49375 m
.25962 .5 L
s
.5 .49375 m
.5 .5 L
s
.74038 .49375 m
.74038 .5 L
s
.98077 .49375 m
.98077 .5 L
s
.125 Mabswid
.06731 .49625 m
.06731 .5 L
s
.11538 .49625 m
.11538 .5 L
s
.16346 .49625 m
.16346 .5 L
s
.21154 .49625 m
.21154 .5 L
s
.30769 .49625 m
.30769 .5 L
s
.35577 .49625 m
.35577 .5 L
s
.40385 .49625 m
.40385 .5 L
s
.45192 .49625 m
.45192 .5 L
s
.54808 .49625 m
.54808 .5 L
s
.59615 .49625 m
.59615 .5 L
s
.64423 .49625 m
.64423 .5 L
s
.69231 .49625 m
.69231 .5 L
s
.78846 .49625 m
.78846 .5 L
s
.83654 .49625 m
.83654 .5 L
s
.88462 .49625 m
.88462 .5 L
s
.93269 .49625 m
.93269 .5 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.99375 .00962 m
1 .00962 L
s
.99375 .10577 m
1 .10577 L
s
.99375 .20192 m
1 .20192 L
s
.99375 .29808 m
1 .29808 L
s
.99375 .39423 m
1 .39423 L
s
.99375 .49038 m
1 .49038 L
s
.125 Mabswid
.99625 .03365 m
1 .03365 L
s
.99625 .05769 m
1 .05769 L
s
.99625 .08173 m
1 .08173 L
s
.99625 .12981 m
1 .12981 L
s
.99625 .15385 m
1 .15385 L
s
.99625 .17788 m
1 .17788 L
s
.99625 .22596 m
1 .22596 L
s
.99625 .25 m
1 .25 L
s
.99625 .27404 m
1 .27404 L
s
.99625 .32212 m
1 .32212 L
s
.99625 .34615 m
1 .34615 L
s
.99625 .37019 m
1 .37019 L
s
.99625 .41827 m
1 .41827 L
s
.99625 .44231 m
1 .44231 L
s
.99625 .46635 m
1 .46635 L
s
.25 Mabswid
1 0 m
1 .5 L
s
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
% Start of gray image
p
.01923 .00962 translate
.96154 .48076 scale
200 string
200 100 8 [200 0 0 100 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
63665F4E371D0A0C100B060F16160E060E16160E060E16160E060E16160E060E16160E06
0E16160E060E16160E060E16160E060E16160E060E16160E060E16160E060E16160E060E
16160E060E16160E060E16160E060E16160E060D14130B09151C1B100E23374548403221
120701010100000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000010203040506
646761513B23131213100D131919130E131818130E131818130E131818130E131818130E
131818130E131818130E131818130E131818130E131818130E131818130E131818130E13
1818130E131818130E131818130E131818130D121716111019201F1818293B474A423423
140903020100000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000010203040506
65696456412C1E1A191614191D1D1916191D1D1916191D1D1916191D1D1916191D1D1916
191D1D1916191D1D1916191D1D1916191D1D1916191D1D1916191D1D1916191D1D191619
1D1D1916191D1D1916191D1D1916191D1D1915181C1C18191F2525222432424C4D453726
160B05030201000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000010203040506
676C695C4A372923211E1D202424211F212424211F212424211F212424211F212424211F
212424211F212424211F212424211F212424211F212424211F212424211F212424211F21
2424211F212424211F212424211F212424211E2023232122282D2E2D313C4A52534A3B2A
1A0F08050301010000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000010203040506
69706E645443362F2B28282A2C2C2A292A2D2D2A292A2D2D2A292A2D2D2A292A2D2D2A29
2A2D2D2A292A2D2D2A292A2D2D2A292A2D2D2A292A2D2D2A292A2D2D2A292A2D2D2A292A
2D2D2A292A2D2D2A292A2D2D2A292A2D2C2A292A2C2C2C2D3237393A3F48545A5950402F
1F120B070402010100000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000010203040506
6C74746C5F50433C37343435373736353637373635363737363536373736353637373635
363737363536373736353637373635363737363536373736353637373635363737363536
37373635363737363536373736353637373534353737383A3E4346484D565F6461574735
24170E090604020101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000010203040506
6F787B756B5E524A45424142434343424344444342434444434243444443424344444342
434444434243444443424344444342434444434243444443424344444342434444434243
4444434243444443424344444342434443424242444546484C5154585D646B6E6A5F4F3C
2B1D130C0805030201010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000010203040507
727D827F776C625A55525151525251515152525151515252515151525251515152525151
515252515151525251515152525151515252515151525251515152525151515252515151
5252515151525251515152525151515252515151525455585C6064686D74797A74685744
322318100B07050302010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000010203040507
75828989847C736C66636261626262616262626261626262626162626262616262626261
626262626162626262616262626261626262626162626262616262626261626262626162
6262626162626262616262626261626262626162636466696D71757A7F8487868073624E
3B2B1E150F0A070503020101000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000010203040507
78879094918B847E79767473737373737373737373737373737373737373737373737373
737373737373737373737373737373737373737373737373737373737373737373737373
73737373737373737373737373737373737373747576797B7F83878C909496948C7F6D58
4534261B130E0A0705030202010100000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000010203040607
7A8C989D9E9A95908C898786868686868686868686868686868686868686868686868686
868686868686868686868686868686868686868686868686868686868686868686868686
868686868686868686868686868686868686868788898C8E92969A9DA1A4A5A2998B7964
503D2E2219120D0A07050302020101000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000010203040607
7D909EA7AAA9A6A29F9C9A9A999999999999999999999999999999999999999999999999
999999999999999999999999999999999999999999999999999999999999999999999999
9999999999999999999999999999999999999A9A9B9D9FA1A5A8ACAFB2B4B4AFA6988571
5C48382A2018120D0A070504030201010000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000010203040607
7F94A4B0B5B7B6B4B1AFAEADADADADACACADADACACACADADACACACADADACACACADADACAC
ACADADACACACADADACACACADADACACACADADACACACADADACACACADADACACACADADACACAC
ADADACACACADADACACACADADACACACADADADADAEAFB0B2B4B7BABDC0C2C3C2BDB3A5937E
68544334281E17110D0A0705040302010101000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000010203040607
8197AAB7C0C4C5C4C3C1C0C0C0BFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBF
BFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBF
BFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFC0C0C1C2C4C6C8CACDCFD0D1CFC9C0B2A08C
76614F3F31261D17110D0A08060403020201010000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000010203040607
839AAEBEC9CFD2D3D3D2D2D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1
D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1
D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D2D2D3D4D6D7D9DADCDDDCDAD5CCBEAD99
846F5C4A3C2F251D17120E0A080605030302010101000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000010203050607
839CB2C3D0D9DEE0E1E1E1E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0
E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0
E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E1E1E1E2E3E3E4E5E6E6E6E6E3DED6CABAA7
937E6A58483A2E251D17120E0B0807050403020201010000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000010203050607
849DB4C7D6E0E6EAECEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDED
EDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDED
EDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEEEEEEEEEEEEEEEDEDECEAE6DFD4C6B5
A18D79665546392E251E18130F0C09070604030202010101000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000010203050608
839DB5C9D9E5EDF2F4F6F6F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7
F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7
F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F6F5F4F3F2F1F0EFEDEAE5DCD0C1
AF9C8875635345392E261E1914100D0A0806050403020201010100000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000001010203050608
839DB5CADBE7F0F6F9FBFCFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFD
FDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFD
FDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFCFCFBF9F7F5F3F1EFEEEDECE9E3D9CC
BCAA978472615245392F27201A15110E0B09070504030302010101000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000001010204050708
819BB4C9DAE7F1F7FBFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFBF9F6F3F0EDEBEAEAEAE9E6E0D6
C8B8A79482716052453A3028211B16120F0C0A0806050403020201010100000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000001010204050708
7F99B1C6D8E5EEF5F9FBFDFDFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFDFDFCFBF8F6F2EDE9E5E3E2E3E5E7E7E4DD
D3C5B5A49281706153463B322A231D1814100D0B09070604040302020101010000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000001010204050708
7C95ADC2D3E0E9F0F4F6F7F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8
F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8
F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F7F6F5F2EEEAE4DFDAD7D7D9DDE2E5E6E2
DBD0C3B3A29180706154483D342C251F1A15120E0C0A0806050403030202010101000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000001010204050709
7991A8BCCCD9E2E7EBEDEEEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEF
EFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEF
EFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEEEDEBE8E4DFD8D2CCC8C8CBD2DAE0E5E5
E2DACFC1B2A191817163564A40362E27211C1713100D0B09070605040303020201010100
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000001010304060709
758CA2B5C4CFD7DDE0E1E2E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3
E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3
E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E2E2E1DFDCD7D1CAC2BBB7B6BBC4CFD9E1E6
E6E2D9CEC0B1A292827365584D4239312A231E1915120F0C0A0907060504030202020101
010000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000001020304060809
71879BADBAC4CBCFD2D3D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4
D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4
D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D3D2D0CDC8C2BAB1A8A3A3A9B4C1CFDBE4
E7E7E2D9CEC1B2A2938476685C50463C342D26211C1814110E0C0A080706050403020202
010101000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000001020304060809
6C8194A3AFB8BDC1C2C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3
C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3
C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C2C1C0BDB8B1A89E958E8E95A2B3C4D3DF
E7E9E8E2DACEC1B3A49587796B5F544940383029241F1A1613100E0B0A08070605040303
020201010101000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000102030406080A
677A8B99A3AAAEB0B1B1B1B1B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0
B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0
B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0AEACA7A0978C817978808FA3B7C9D8
E3EAEBE9E3DACFC3B5A6988A7C6F63584D443B342D27221D1915120F0D0B090807060504
030302020101010100000000000000000000000000000000000000000000000000000000
000000000000000000000000000102030506080A
6273838F979C9F9F9F9E9E9E9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D
9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D
9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9C9A968F867A6D64626A7C92A9BED0
DEE7ECEDEAE4DBD1C4B7A99B8E8074685C52484038312B25201C1815120F0D0B09080706
050403030202010101010000000000000000000000000000000000000000000000000000
000000000000000000000000000102030507090A
5C6C7A848A8D8E8E8D8C8B8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A
8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A
8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A88857F75695B4F4C566A829BB2C6
D6E2EAEEEFEBE5DDD3C7BAAD9F9285786D61574D453D352F29241F1B1714110F0D0B0908
070605040303020201010101010000000000000000000000000000000000000000000000
000000000000000000000000000102030507090B
576570787D7F7E7C7B797877777777777777777777777777777777777777777777777777
777777777777777777777777777777777777777777777777777777777777777777777777
7777777777777777777777777777777777777878787877756F66594A3D384359738DA5BB
CDDCE6EDF0F0EDE7DFD5CABDB1A4978A7E72675C534A423A332D28231E1A1714110F0D0B
090807060504030302020201010101000000000000000000000000000000000000000000
000000000000000000000000000102030507090B
525E676D70706E6B69676666656565656565656565656565656565656565656565656565
656565656565656565656565656565656565656565656565656565656565656565656565
65656565656565656565656565656565656566666767676561594C3C2C26324A658099AF
C2D3DFE9EFF2F1EEE9E1D8CDC1B5A89C9083786D62584F473F38322C27221E1A1714110F
0D0B0A080706050404030302020101010101000000000000000000000000000000000000
0000000000000000000000000001020305070A0B
4C575F6364625F5B59575555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555657585857544D41311F15253E59738CA2
B6C8D6E2EBF0F3F3F0EAE3DAD0C5BAAEA1958A7E73695F554D453E37312B26221E1A1714
110F0D0B0A09070605050403030202020101010100000000000000000000000000000000
0000000000000000000000000001020405080A0C
475056585855504C49474646464646464646464646464646464646464646464646464646
464646464646464646464646464646464646464646464646464646464646464646464646
464646464646464646464646464646464646464748494B4B4943392A17071C364F688096
AABCCCD9E4ECF1F4F4F1ECE6DED4CABFB3A79C90857A6F655C534B433C36302B26221E1A
171412100E0C0A0908070605040403030202010101010100000000000000000000000000
0000000000000000000000000001020406080A0C
42494E4F4D48433F3B393938383838383838383838383838383838383838383838383838
383838383838383838383838383838383838383838383838383838383838383838383838
38383838383838383838383838383838383939393B3C3E3F3F3A322514041830485F7489
9CAEBFCEDBE5EDF2F5F5F3EEE8E1D8CEC4B9AEA2978C81766C635A524A423C36302B2622
1E1B181512100E0C0B090807060505040303020202010101010100000000000000000000
0000000000000000000000000001020406080B0D
3D434646423D37322F2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D
2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D
2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2E2F31333536332D22150D1A2D4256697C
8FA0B1C1CFDBE5EDF2F5F6F4F1EBE4DCD3C9BFB4A99E93887E746A61595149423C36302B
27221F1B181513110F0D0B0A090807060504040303020202010101010100000000000000
0000000000000000000000000001020406090B0D
383D3F3D39332D2825232323232323232323232323232323232323232323232323232323
232323232323232323232323232323232323232323232323232323232323232323232323
232323232323232323232323232323232323232425272A2C2E2D292118141D2C3D4E5F70
8192A2B3C2D0DBE5EDF2F6F7F6F3EEE8E0D8CFC5BBB0A59B90867C726960585049423C36
312C27231F1C191614110F0E0C0A09080706050504030303020202010101010100000000
0000000000000000000000000101030406090C0E
34383836312A231E1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B
1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B
1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1C1E2125272826211B191F2B38465463
738393A3B3C2CFDBE5ECF2F6F7F7F4F1EBE5DDD4CBC1B7ADA2988E847A71686058504942
3C37312D2824201D1A171512100E0D0B0A09080706050404030302020201010101010000
0000000000000000000000000102030407090C0F
3033322F29221B1614131414151515151515151515151515151515151515151515151515
151515151515151515151515151515151515151515151515151515151515151515151515
151515151515151515151515151515151514141415171A1E222323201D1D212A343F4B57
65748494A4B3C1CEDAE4ECF2F5F8F8F6F3EEE9E2DAD1C8BEB4AAA0968C83797068605851
4A433D38322E2925211E1B181613110F0E0C0B0908070606050404030302020201010101
01010000000000000000000001020305070A0D0F
2C2E2D29231C15100E0E0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F
0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F
0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F1114191D1F201F1E1E22282F38414C
5865748493A3B2C0CDD8E2EAF1F5F8F8F8F5F1ECE6DFD7CFC5BCB2A99F958C8279716860
59514B443E39342F2B27231F1C19171412100F0D0B0A0908070605050404030302020201
01010101010000000000000001020305070A0D10
292A28241E16100B090A0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B
0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B
0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0A0A0C0F14181C1E1E1E1F22262B313841
4B5765748393A2B0BECBD6E0E8EFF4F7F9F9F7F4F0EBE4DDD5CDC4BBB1A89E958C827A71
69615A534C46403A35312C2824211E1B18161311100E0C0B0A0908070605050404030302
02020101010101010000000101020305070B0E11
2626242019120B0706070808080808080808080808080808080808080808080808080808
080808080808080808080808080808080808080808080808080808080808080808080808
080808080808080808080808080808080808080707080B1015191C1D1E1F2023262A2F36
3F4A5765738291A0AEBCC8D4DEE6EDF3F6F9F9F9F6F3EFE9E3DBD4CBC3BAB1A79E958C83
7B726A635B544E48423C37322E2A26231F1C1A171513110F0E0C0B0A0908070605050404
03030202020101010101010102020305080B0F12
2323211C160F080403040506060606060606060606060606060606060606060606060606
060606060606060606060606060606060606060606060606060606060606060606060606
06060606060606060606060606060606060605050405080D1216191B1D1E1F202124272D
343E4A576472818F9EACB9C5D1DBE3EBF1F5F8FAFAF8F6F2EDE8E1DAD3CBC2B9B0A89F96
8D847C746C655D56504A443F3935302C2825211E1B19161412100F0D0C0B0A0808070605
05040403030202020101010202030305080B0F13
20201E19130C060201030404040404040404040404040404040404040404040404040404
040404040404040404040404040404040404040404040404040404040404040404040404
04040404040404040404040404040404040404030203060A0F14171A1B1C1C1D1D1D1F24
2B343E4A5663717F8D9BA8B5C2CDD7E0E8EEF3F7F9FAFAF8F5F1EDE7E1DAD2CAC2BAB1A8
A0978E867E766E676059524C46413C37332E2A2723201D1B18161412100F0D0C0B090808
07060505040403030202020203030305080C1014
1E1E1B17110B050101020303030303030303030303030303030303030303030303030303
030303030303030303030303030303030303030303030303030303030303030303030303
0303030303030303030303030303030303030302010104090D1215181A1A1A191817181C
222A333E4955616F7C8A97A4B1BDC9D3DCE5EBF1F5F8FAFAFAF8F5F1ECE7E0DAD2CBC3BA
B2AAA199908880787169625C554F49443F3A35312D2926221F1D1A18161412100E0D0C0B
09090807060505040403030303030304080D1216
1C1C19150F0A050201020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202
0202020202020202020202020202020202020201000104080C1014161818181614121215
1B222A333D48535F6C798693A0ADB9C4CFD8E1E8EEF3F7F9FBFBFAF8F5F1ECE7E1DAD3CB
C4BCB3ABA39B938B837B746C655F58524C47423D3834302C2825221F1C1A17151312100E
0D0C0B0A090807060605050504030204080E1318
1A1A17130E09050202020201010101010101010101010101010101010101010101010101
010101010101010101010101010101010101010101010101010101010101010101010101
0101010101010101010101010101010101010101010103070B0F121516161513100D0D0F
141B222A323C46515D6975828F9BA8B4BFC9D3DCE4EBF0F5F8FAFBFBFAF8F5F1ECE7E1DB
D4CDC5BDB5ADA59D958E867E777069625C56504A45403B37332F2B2824211F1C1A171513
12100F0D0C0B0A090807070605030003090F151A
191816120D09050302010101000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000010101010103060A0E1113151513100D09080B
0F151B2229313A444F5A65717D8A96A2AEB9C4CED7DFE6EDF2F6F9FAFBFBFAF8F5F1EDE8
E2DCD5CEC7BFB8B0A8A0999189827B736D666059544E49443F3A36322E2B2724211E1C1A
17151412100F0D0C0B0A0908070401040B11181C
171714110C08050302010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010101020306090D10121313110E0A060407
0C11161B21283038424C56616D7985919CA8B3BEC8D1DAE1E8EEF3F6F9FBFCFBFAF8F5F2
EDE9E3DDD7D0C9C2BAB3ABA49C948D867F77716A645E58524D48433E3A35322E2A272421
1F1C1A18161412110F0E0D0B090604070D141B20
161513100C08050302010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020306090C0F111212100D09040105
090D11151A20272E363F48535D68737F8B96A2ADB7C1CBD4DCE3EAEFF3F7FAFBFCFCFAF9
F6F2EEEAE5DFD9D2CCC5BDB6AFA7A098918A837C756F68625C56514C47423D3935312E2A
2724211F1C1A18161413110F0D0A080B11181F23
1514120F0B08050302010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020305080B0E1011100E0B08030004
070A0D11151A1F252C343C454F59636E7984909BA6B0BBC4CDD6DEE4EAF0F4F7FAFBFCFC
FBF9F7F3F0EBE6E1DBD5CEC8C1BAB2ABA49D968E87817A736D67615B56504B46423D3935
322E2B2825221F1D1B181614110F0E10161D2328
1413110E0B08050302010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000001020305080B0D0F100F0D0B07040204
06080A0D1014181E232A3139424B545E69737E89949FA9B3BDC6CFD7DFE5EBF0F4F7FAFB
FCFCFBFAF7F4F1EDE8E3DDD8D1CBC4BDB7B0A8A19A938C867F78726C66605B55504B4642
3E3936322E2B282522201D1A171514171C23292C
1312100E0A07050302010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000001020305080A0C0E0F0E0D0A07040304
0506080A0C0F13171C22282E363E464F59636D77828C97A1ACB5BFC8D0D8DFE5EBF0F4F7
FAFBFCFCFCFAF8F6F2EEEAE5E0DBD5CEC8C2BBB4ADA69F98928B847E77716B65605A5550
4B47423E3A36332F2C2925221F1D1D1F242A2F32
1211100D0A07050302010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000001020305070A0C0D0E0E0C0A07050304
04050607090C0F12161A20252C333A424B545D67717B858F99A4ADB7C0C9D1D8DFE5EBF0
F4F7FAFBFCFDFCFBF9F7F4F0ECE8E3DED8D2CCC6BFB9B2ABA59E97918A847D77716B6560
5B55504C47433F3B37332F2C292726292D323638
11110F0C0A07050301010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000102030507090B0D0D0D0B0907050403
0304040507090B0E1115191E23292F363E464E57606A737D87919BA5AEB8C0C9D1D8DFE5
EAEFF3F7F9FBFCFDFDFCFAF8F5F2EFEAE6E1DCD6D0CAC4BEB7B1AAA39D969089837D7771
6B66605B56514D48443F3B3734323234373C3F3F
11100E0C0907040301010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000102030507090B0C0D0C0B0907050403
030303040506080A0D1013171B20262C32394149515A636C767F89939CA6AFB8C0C9D0D7
DEE4EAEEF2F6F9FBFCFDFDFCFBF9F7F4F1EDE9E4DFDAD4CFC9C3BCB6B0A9A39C96908983
7D77726C67615C57524E4945413F3F4043464847
100F0E0C0906040301010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000102030506090A0C0C0C0B0907050403
02020202030406080A0C0F1215191E23282E353C434B535C656E77818A939DA6AFB7C0C8
CFD6DDE3E8EDF1F5F8FAFCFDFDFDFCFAF8F6F3F0ECE7E3DED9D3CEC8C2BCB6AFA9A39C96
908A847E78736D68625D5854504E4D4E4F51514F
0F0F0D0B0906040201010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000102030406080A0B0C0B0A0907050403
020101010203040507090B0D1014171B20252B31373E454D555E666F78818A939CA5AEB7
BFC7CED5DCE2E7ECF0F4F7F9FBFCFDFDFDFBFAF8F5F2EFEBE6E2DDD8D3CDC7C1BBB5AFA9
A39D97918B857F79746E6965615E5C5C5D5D5C57
0F0E0D0B0806040201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000102030406080A0B0B0B0A0807050302
01000001010203040506080A0C0F1215191D22272C323940474E565E677078818A939CA4
ADB5BDC5CCD3DAE0E5EAEFF2F6F8FAFCFDFDFDFCFBF9F7F4F1EEEAE6E1DCD7D2CDC7C1BC
B6B0AAA49E98928C86817B76726F6D6C6B6A6660
0E0E0C0A0806040201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000010103040608090A0B0B0A0806050302
010000000101020304050607090B0D1013171A1F23282E343A41484F575F677078818992
9BA3ABB4BBC3CAD1D8DEE3E8EDF1F4F7F9FBFDFDFDFDFCFBF9F7F4F1EDEAE5E1DCD7D2CD
C8C2BCB6B1ABA59F99948E8985817E7C7A777169
0E0D0C0A0806040201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000010103040607090A0B0A090806050302
01000000010101020203040507080A0C0F1114181C20252A2F353B424850575F676F7780
889199A1A9B1B9C1C8CFD5DBE1E6EBEFF2F6F8FAFCFDFDFDFDFCFBF9F6F4F1EDE9E5E1DD
D8D3CEC8C3BDB8B2ACA7A19C9894908D89847D72
0E0D0C0A0806040201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000010102040507090A0A0A090806040302
010000000000010102020304050607090B0D0F1215191D21252A30353B424950575E666E
767E868F979FA7AFB6BEC5CCD2D8DEE3E8ECF0F4F7F9FBFCFDFEFDFDFCFAF9F6F4F1EDEA
E6E1DDD8D3CEC9C4BFB9B4AFAAA6A29D9891877B
0D0D0B0A0705040201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000010102040507080A0A0A090706040302
01000000000000010101020203040506080A0C0E1013161A1D22262B30363C42484F565D
656D747C848C949CA4ACB3BBC2C8CFD5DBE0E5EAEEF2F5F7FAFBFDFDFEFEFDFCFAF9F6F4
F1EEEAE6E2DED9D5D0CBC6C1BCB8B3ADA69E9284
0D0C0B090705030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000001010204050708090A09090706040302
010000000000000000010102020304050607080A0C0E1114171A1E22262B30363B41484E
555C636B727A828A9199A1A8B0B7BEC5CBD2D7DDE2E7EBEFF2F5F8FAFCFDFDFEFEFDFCFB
F9F7F4F1EEEBE7E3DFDBD6D2CDC8C3BCB4A99C8C
0C0C0B090705030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000001010204050708090909080706040302
0100000000000000000001010102020304050607090B0D0F1114171A1E22262B30353B40
474D535A616970777F868E969DA5ACB3BAC1C7CED4D9DEE3E8ECF0F3F6F8FAFCFDFEFEFE
FDFCFBF9F7F5F2EFECE8E4E0DCD7D1CAC0B4A694
0C0C0B090705030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000001010203050608090909080705040301
01000000000000000000000101010202030304050608090B0D0F1214171A1E22262B2F34
3A3F454B52585F666D747C838A9299A1A8AFB6BDC3C9CFD5DAE0E4E9EDF0F3F6F8FAFCFD
FEFEFEFDFCFBFAF8F5F3F0ECE8E3DDD5CBBEAE9B
0C0B0A090705030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000001010203050608090909080705040301
0100000000000000000000000001010102020304040607080A0B0D0F1214171A1E22262A
2E33383E444950565C636A71787F878E959CA3AAB1B8BEC5CBD1D6DBE0E5E9EDF0F3F6F8
FAFCFDFEFEFEFDFDFBFAF8F5F2EDE7DFD4C6B5A1
0C0B0A080705030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000001010203050607080909080705040201
01000000000000000000000000000001010102020304050607080A0B0D0F1214171A1D21
25292D32373C42474D535A60676E747B828990979EA5ACB3B9C0C6CCD1D7DCE1E5E9EDF0
F3F6F8FAFCFDFEFEFEFDFCFBF8F4EEE6DBCDBBA6
0B0B0A080605030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010203050607080908080605040201
010000000000000000000000000000000101010202030304050607080A0B0D0F1114171A
1D2024282C31353A3F454B50575D636A70777E858C9399A0A7AEB4BAC1C6CCD2D7DCE1E5
E9EDF0F3F6F8FAFBFDFDFDFDFBF8F3EBE0D1BFA9
0B0B0A080605030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010203040607080808070605040201
0100000000000000000000000000000000000101010202030304050607080A0B0D0F1114
16191C1F23272B2F33383D42484D53595F666C737980878D949BA1A8AEB5BBC1C7CCD2D7
DCE0E5E8ECEFF2F5F7F9FAFBFAF8F4EDE2D4C2AC
0B0A09080604030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010203040607080808070605030201
01000000000000000000000000000000000000000101010202030304050607080A0B0D0F
111315181B1E2225292D31363B40454A50565B61686E747B81888F959CA2A8AFB5BBC1C7
CCD1D6DBE0E4E8EBEFF2F4F5F6F5F2ECE2D5C3AE
0B0A09080604030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010203040607080808070605030201
01000000000000000000000000000000000000000001010101020203030405060708090B
0C0E101215171A1D2024272B2F34383D42474C52575D63696F767C82898F969CA2A9AFB5
BBC0C6CBD1D5DADFE3E7EAEDEFEFEDE8E0D4C3AE
0A0A09080604030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010203040607070808070605030201
010000000000000000000000000000000000000000000001010101020203030405060708
090A0C0E10121416191C1F2225292D31353A3E43484E53595E646A70767D83898F969CA2
A8AEB4BAC0C5CACFD4D9DDE1E4E6E5E2DCD0C1AD
0A0A09070604030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010203040507070808070605030201
010000000000000000000000000000000000000000000000000101010102020303040506
0608090A0C0D0F111315181A1D2023272B2E32373B40454A4F545A5F656B71777D83898F
959BA1A7ADB3B9BEC4C9CED3D7DADBDAD5CBBDAB
0A0A09070604030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010203040506070807070604030201
010000000000000000000000000000000000000000000000000000010101010202030304
05050607080A0B0C0E10121416191C1E2125282C3034383C41464A50555A60656B71777C
82888E949AA0A6ACB2B8BDC3C8CCCFCFCCC5B9A7
0A0909070604030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010203040506070707070604030201
010000000000000000000000000000000000000000000000000000000001010101020203
03040405060708090A0C0D0F111315171A1D1F2226292D3134393D41464B50555A60656B
70767C82878D93999FA5ABB1B7BDC1C3C2BDB3A3
0A0908070504030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010203040506070707060504030201
010000000000000000000000000000000000000000000000000000000000000101010102
020203030405060607090A0B0D0E10121416181B1D2023262A2D3135393D42464B50555A
5F656A6F757B80868C92989FA5ACB1B6B7B4AB9E
090908070504030101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010203040506070707060504030201
010000000000000000000000000000000000000000000000000000000000000000010101
010202020303040505060708090A0C0D0F10121417191B1E2124272A2E3135393D42464B
4F54595E64696E74797F858C939AA1A7AAA9A398
090908070504030101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010203040506070707060504030201
010000000000000000000000000000000000000000000000000000000000000000000000
0101010102020303040405060607080A0B0C0E0F11131517191C1E2124272A2E3135393D
41464A4F54585D62686D7379808890989D9E9B92
090908070504020101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010203040506070707060504030201
000000000000000000000000000000000000000000000000000000000000000000000000
0000010101010202020303040505060708090A0B0D0E10111315171A1C1F2124272A2E31
35393D4145494E52575C62686F7780888F93928B
090908070504020101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010203040506070707060504030201
000000000000000000000000000000000000000000000000000000000000000000000000
0000000001010101010202030304040505060708090A0C0D0E10121315181A1C1F212427
2A2D3134383C4044484D51575E666F7982878884
090908070504020101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010203040506070707060504030201
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000001010101020202030304040506070708090B0C0D0F10121415181A1C1E
2124272A2D3034373B3F43484E565F6A747C7F7D
090908060504020101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010203040506060707060504030201
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000001010101010202020303040505060708090A0B0C0D0F1012141517
1A1C1E212326292C2F32363A3F47515C67717675
090808060504020101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010203040506060707060504030201
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000001010101020202030304040505060708090A0B0C0D0F1012
131517191B1E202325282B2E3339434F5B666D6E
090808060504020101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010202040506060706060504030201
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000101010101020202030304040505060708090A0B0C0D
0E1011131517191B1D1F2124272D3743505C6467
090807060504020101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010202040506060706060504030201
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000101010101020202030304040505060708090A
0B0C0D0E101113141618191B1E232C3846525C61
090807060503020101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010202030506060606060504030201
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000001010101010202020303040405050607
0808090A0B0D0E0F11121314161A222E3C4A555A
080807060503020101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010202030505060606060504030201
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000101010101020202020303040405
0506070708090A0B0C0D0E0E0F131A2634424E55
080807060503020101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010202030405060606060504030201
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000101010101020202020303
0404050506070708090A0A0A0A0C14202E3C4850
080807060503020101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010102030405060606060504030201
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000101010101020202
02030304040505060607070706080F1A2836434B
080807060503020101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010102030405060606060504030201
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000101010101
01020202030303040505050503040B1624323E47
080807060503020101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010102030405060606060504030201
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000101
01010101020202030304040402020913202E3A43
080807060503020101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010102030405060606060504030201
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000101010101010202030303020208121E2B3740
080807060503020101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010102030405060606050504030201
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000001010101020202020308111C28343E
080807060503020101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010102030405060606050504030201
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000001010202030409101B27323B
080807060503020101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010102030405060606050504030201
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000010102030509101A25313A
080807060503020101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010102030405060606050504030201
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000001020305091019242F38
080807060503020101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010102030405060606050504030201
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000010203060A1019242E37
080807060503020101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010102030405060606050504030201
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000010203060A1019232E36
080807060503020101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010102030405060606050504030201
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000203060A1019232D36
080807060503020101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010102030405060606050504030201
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000203060A1019232D36
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  InitializationCell->True,
  ImageSize->{288, 177.938},
  ImageMargins->{{281, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40n007h00Oooll8Oll003ooc`Q
oc`00?oo?27o?000ooll8Oll003ooc`Qoc`00?oo?27o?000ooll8Oll003ooc`Qoc`00?oo?27o?000
ooll8Oll003ooc`Qoc`00?oo?27o?000ooll8Oll003ooc`Qoc`00?oo?27o?000ooll8Oll003ooc`Q
oc`001Wo?08003Wo?0<000Co?08003?o?0@000?o?08000Co?080033o?0@000;o?0<000Co?080033o
?0@000?o?08000Co?08000?o?0006?ll00@00?lloc`003_o?004003o??ll0002oc`00`00occo?00b
oc`01@00occo??ll00000_ll00@00?lloc`000;o?003003o??ll02oo?003003o??ll00Co?004003o
??ll0002oc`00`00occo?00]oc`00`00occo?003oc`01000occo?0000_ll00@00?lloc`000;o?000
6?ll00@00?lloc`003_o?004003o??ll0002oc`00`00occo?00boc`01@00occo??ll00000_ll00@0
0?lloc`000;o?003003o??ll02oo?003003o??ll00Co?004003o??ll0002oc`00`00occo?00^oc`0
0`00occo?002oc`01000occo?0000_ll00@00?lloc`000;o?0006?ll00@00?lloc`003So?0<000?o
?004003o??ll000doc`01@00occo??ll00000_ll00@00?lloc`000;o?003003o??ll02oo?004003o
??lloc`30003oc`01000occo?000<Oll00D00?llocco?00000;o?004003o??ll0002oc`10001oc`1
oc`001So?004003o??ll000hoc`00`00occo?003oc`01000occo?000=?ll00D00?llocco?00000;o
?004003o??ll0002oc`00`00occo?00_oc`01@00occo??ll00001Oll00@00?lloc`003;o?004003o
??ll0002oc`01000occo?0000_ll0@000Oll0Oll000Hoc`01000occo?000>?ll00<00?lloc`00oll
00@00?lloc`003;o?0<000?o?004003o??ll0002oc`01000occo?000;oll0`000oll00<00?lloc`0
0oll00@00?lloc`002oo?004003o??ll0002oc`01000occo?0000_ll00@00?lloc`000;o?0006Oll
0P00>Oll10000oll0P00=Oll00<00?lloc`00_ll0P001?ll0P00<_ll00@00?llocco?0@000?o?080
037o?08000Co?08000Co?08000?o?000ooll8Oll003ooc`Qoc`00?oo?27o?000ooll8Oll000>oc`2
0005occo00080004oc`000go?004003o??ll0004oc`00`00occo?002oc`00`00occo?009oc`00`00
occo?00:oc`00`00occo?00:oc`00`00occo?009oc`00`00occo?00:oc`00`00occo?009oc`00`00
occo?00:oc`00`00occo?009oc`00`00occo?00:oc`00`00occo?00:oc`00`00occo?009oc`00`00
occo?00:oc`00`00occo?009oc`00`00occo?00:oc`00`00occo?00:oc`00`00occo?009oc`00`00
occo?00:oc`00`00occo?009oc`00`00occo?00:oc`00`00occo?00:oc`00`00occo?002oc`00`00
occo?002oc`000go?004003o??ll0004oc`2003ooc`3oc`30004oc`000go?004003o??ll0004oc`0
0`00occo?002oc`01f<<HbaJje[[BVTaYQSS0088@@03264@PPQ100808003264@XQ2R0088H@030208
HA2R008@XP04264080QQ26424:8010QQ020080QQ0Q2R0PQQ00<080QQ4:800Q2R00@8H@0P2648H@8@
XP042640800P26424:8226400`0P264@XP024:800`QQ0208H@034:8010QQ020080QQ0Q2R0PQQ00<0
80QQ4:800Q2R00<8H@0P26400a2R00@8H@0P2648H@8@XP88H@030208HA2R008@XP03264080QQ00<@
XP04264080QQ26424:801@QQ020080QQ4:800Q220PQ100H@XQSS6><H`a2226428@@00c6V@RQ:B@02
@PP00c668@@@PP02021^00030205oc`00`00occo?002oc`000go?004003o??ll0004oc`00`00occo
?002oc`01f<<HbaJje[[BVTaYQSS0088@@03264@PPQ100808003264@XQ2R0088H@030208HA2R008@
XP04264080QQ26424:8010QQ020080QQ0Q2R0PQQ00<080QQ4:800Q2R00@8H@0P2648H@8@XP042640
800P26424:8226400`0P264@XP024:800`QQ0208H@034:8010QQ020080QQ0Q2R0PQQ00<080QQ4:80
0Q2R00<8H@0P26400a2R00@8H@0P2648H@8@XP88H@030208HA2R008@XP03264080QQ00<@XP042640
80QQ26424:801@QQ020080QQ4:800Q220PQ100H@XQSS6><H`a2226428@@00c6V@RQ:B@02@PP00c66
8@@@PP02021^00030205oc`00`00occo?002oc`000go?004003o??ll0004oc`00`00occo?002oc`2
Hb`2H``00e::>LLQ1005488226400a226<<H``0248800`QQ488H``026<<01122264@PQ220QS300@@
PPQQ264@PP8H``8@PP03264@PQS3008H``044888HA2248826<<011222648HA220QS30Q2200<8HA22
6<<00QS300<@PPQQ48800aS300@@PPQQ264@PP8H``8@PP03264@PQS3008H``034888HA2200<H``04
4888HA2248826<<248800`QQ488H``026<<00a22264@PP036<<01122264@PQ220QS300@@PPQQ264@
PP<@XP8@PP046<<Q12446><26<<2:DD00cW7@RQ:B@02@PP00c6V8@@@XP02245^00030205oc`00`00
occo?002oc`000ko?08000Go?003003o??ll00;o?007Hba[CF</HbaBZT88:FD00QSS0QS30a2R00<H
`aSS6><00QS300<@XQS36><00QSS00@H`a2R6<<H``8Hh`046<<@XQ2R6<<26><26<<00a2R6<<Hh`02
6><011S34:8H`aS30QSS00@H`a2R4:8H``8Hh`8H``034:8H`aSS008Hh`036<<@XQS300<Hh`046<<@
XQ2R6<<26><26<<00a2R6<<Hh`026><00aS34:8H``036><011S34:8H`aS30QSS0QS300<@XQS36><0
0QSS00<H`a2R6<<00aSS00@H`a2R6<<H``8Hh`046<<@XQ2R6<<36><26<<01QSS8B@Q924T8@@Q908a
QP03@PQ:JDYY0092:003<JHQ912R0088@@030200000006/000<080Go?003003o??ll00;o?0005Oll
00<00?lloc`00_ll00MS;6]]Jde[CE[[BTTaYP02:DD28@@36><00b448B@Q90028@@00aSS8@@Q9002
8B@012446><Q12440R4T00@Q11SS6><Q108Q908Q10036><Q124T008Q90048@@Hhb448@@28B@01244
6><Hhb440R4T0R4400<Hhb448B@00R4T00<Q11SS8@@00b4T00@Q11SS6><Q108Q908Q10036><Q124T
008Q90038@@Hhb4400<Q90048@@Hhb448@@28B@28@@00aSS8@@Q90028B@00b446><Q10038B@01244
6><Q12440R4T00<Q11SS6><01R4400<YABUU:FD00RUU00@aQSWW>NM:B@9BRP9:B@03>LLYAAS30088
H@032440800006/000<080Go?003003o??ll00;o?0005Oll00<00?lloc`00_ll00M[CG>>Jfe[KF</
DZY22002<JH00bUU:DDYA@03:DD2:FD4:DD3:FD4:DD2:FD4:DD2:FD4:DD3:FD4:DD2:FD4:DD2:FD4
:DD3:FD3:DD3:FD4:DD2:FD4:DD3:FD3:DD3:FD4:DD2:FD4:DD3:FD3:DD3:FD4:DD2:FD4:DD5:FD0
0c66<JHaYP02>LL013WWBTU:BE:Z0U[;0U::00=222UU6><00Q2200@8@@0P020086X000<080Go?003
003o??ll00;o?0005Oll0P000oll00M[CG>>Jfe[KF</DZY22002<JH00bUU:DDYA@03:DD2:FD4:DD3
:FD4:DD2:FD4:DD2:FD4:DD3:FD4:DD2:FD4:DD2:FD4:DD3:FD3:DD3:FD4:DD2:FD4:DD3:FD3:DD3
:FD4:DD2:FD4:DD3:FD3:DD3:FD4:DD2:FD4:DD5:FD00c66<JHaYP02>LL013WWBTU:BE:Z0U[;0U::
00=222UU6><00Q2200@8@@0P020086X000<080Co?08000Co?0005Oll00<00?lloc`00_ll00M[KG>^
Ljic[V]]F^]BRP02@PP00cWW<JHaYP1[<JH2>LL01SWW@PQ2248XBTU:J@9BZP03F^]S;6<<009BZP03
@RPaYR4T008@XP032648@@0P008086T000<080Go?003003o??ll00;o?0005Oll00<00?lloc`00_ll
00M[KG_?Nlmkcg>^JdeJj`02DXX00dY9@RQ22009@PP3@RP4@PP2@RP4@PP2@RP4@PP3@RP4@PP2@RP4
@PP2@RP4@PP3@RP3@PP3@RP4@PP2@RP4@PP3@RP3@PP3@RP4@PP2@RP4@PP3@RP3@PP3@RP4@PP00d8X
@PQ22003@PP4@RP01dY9BVUBRU::DZYJbe[[009S;003Jde[KF]=009Jj`03BVTiibU5008Hh`054888
H@Q12440801Y00030205oc`00`00occo?002oc`001Go?003003o??ll00;o?007Lhikkh@@Q11kkg>^
Jfd00V<<00=Jbe:ZDXX0JE::0e:Z00MJbe[[H`aS36</Jde[K@02Ljh2Nll01W>^Jde[CE:Z@RPaQP8Q
10046<<@PPQ12442021X00030205oc`00`00occo?002oc`001Go?003003o??ll00;o?003Ljj448aA
00:<D@06Q31kkg>>Lhi[KF</JV<<0f</00M[CF]]LhicSW>^Nlmkk`04Q3001X@@LhicSV<<BVTia`8Y
A@056><@XPQQ2648@@02021W00030205oc`00`00occo?002oc`001Go?003003o??ll00;o?003Ljj4
48aA00:<D@06Q31kkg>>Lhi[KF</JV<<0f</00M[CF]]LhicSW>^Nlmkk`04Q3001X@@LhicSV<<BVTi
a`8YA@056><@XPQQ2648@@02021W00030205oc`00`00occo?002oc`001Go?08000?o?007Nln4<9BB
U9:D/YBBS5400X@`00=kkg_?Ljh00W>^IG>>17>^0W_?00Ikkh@@Q124<8aaU984U;801XaaNnmkkf]]
F/]2:08aYP068B@H`a224888H@Q10`0PI@000`0P1?ll0P001?ll000Eoc`00`00occo?002oc`017_?
S76LdicC0Ycc00JLdiBbU;:DTXaaS55XQ303S542S7401YBBU;:D/YcCW?>U50>U=007YABLdhaAS55k
cf</DXX00SWW00LYIB446<<H`a222648@@03021T00030205oc`00`00occo?002oc`001Go?003003o
??ll00;o?005NnnDTYccW?>U=002[ED2YC@00jDDW?>Ll`1YW=<3W?<01:DDYCB]EJeE0Zee00JeU[Ff
]KJe]ZeeYC@2W=<00h@`LhiJj`02BTT01cW7:DDQ12446<<@PPQQ0088@@<0868000<080Go?003003o
??ll00;o?0005Oll00<00?lloc`00_ll00EkkiBbYCBU=;FF00Fe]P03]IJ]MJee06R]M@>eUP:e]P:m
e`03_OO66<HH00?66007_ONeUZDdYCBDTW__Jdd00U:Z00M2236V:DDYAASS4:8@PP0226400`Q10200
8002021P00030205oc`00`00occo?002oc`001Go?003003o??ll00;o?005NnnD/ZDdYCBeUP05]KH0
0kFF[GF]M@1X[GD3]IH2]KH2_ML00kggaQS66003aQP01kgg]IJU=:DdU99kkf]=009BZP07@PPaYRU5
:DDHha2R48800PQQ00<8@@0P02000P0PH0000`0P1Oll00<00?lloc`00_ll000Eoc`00`00occo?002
oc`01X@@U;:]EJeE]KK660C6>0K6666mm`K660;6>0?>F@;>N@?FVP03cWW>FLHH00:eUP03YAB<LG>^
009S3007BVTiic66<HHQ91SS4:800Q2200<8H@Q124400`0PG`000`0P1Oll00<00?lloc`00_ll000E
oc`20003oc`01h@@W=>]MJee_OO>FLii073FVP?F^P?Nf`CNn`03g]_F^/ii00:mm`03[GFLdh@`009[
K@07F^]:BCWW>NLYIB4T6><00Q2R00<@PPQQ24400PQ10P0PGP000`0P1?ll0P001?ll000Eoc`00`00
occo?002oc`01h@@W?>eU[FFaQSFV]kK00;Nng3W70SW?003iacNnmJj00;>F@03_MNU=9BB009kk`07
JdeJbdY9BTTiabUU8B@00QSS00<@XQ2226400`Q1100PF`000`0P1Oll00<00?lloc`00_ll000Eoc`0
0`00occo?002oc`01h@`W?>e][FfaSSF^^LL00;W?003keg_ONmm07G_O@03kegW?=kk00;F^P03aSRe
]ZDD00:<L@07NlmS;5:ZDZY2:3W7:FD00R4T00<HhaS348800`QQ00<8@@0P02000P0PFP000P0P00<8
@Olloc`00oll00<00?lloc`00_ll000Eoc`00`00occo?002oc`01h@`W?>e][FfaSSF^^LL00;W?003
keg_ONmm07G_O@03kegW?=kk00;F^P03aSRe]ZDD00:<L@07NlmS;5:ZDZY2:3W7:FD00R4T00<HhaS3
48800`QQ00<8@@0P02000P0PFP000P0P00<8@Olloc`00oll00<00?lloc`00_ll0007oc`40003oc`2
0005oc`00`00occo?002oc`01h@@W?>e][FfcUWNfnLl00;_O@03mikg__Nn06kg_PGgWP?_O@07kegW
?=kkg__FV/HH[GD00Ycc00N<DG>^H`aS35::@RPia`02:FD00b4T6><H``024:800a222648@@022444
021G000202000`Q1occo?003oc`00`00occo?002oc`000Oo?003003o??ll00?o?004003o??ll0004
oc`00`00occo?002oc`01h@@W?>e][FfcUWNfnLl00;gWP03mkkogooO06_oo`;og`?g_P;gWPG_O@06
kegW7>LLg]_>NKgg0ZeE00ND/X@`LhicSV<<DXY2:002>LL00bUU8B@Q10026<<00a2R4888H@032444
021D000402000`Q1occo?003oc`00`00occo?002oc`000So?003003o??ll00;o?004003o??ll0004
oc`20003oc`01h@@W=>e][FfcUWNfnLl00;gWP03mkkogooo06_oo`;og`05mkkgW_NNmik_O@06ked2
ic`00nLLe[[>F@02_ML01jDdU;:448@@LhiS35::0092:003>LLaQRU5008Q10036<<@XQ2200<8H@<8
@@<0858000@08004247o??lloc`30004oc`000Wo?005003o??lloc`00002oc`00`00occo?002oc`0
0`00occo?002oc`01g__W=>eU[FFaSSNfnLl00;_O@03mkkogooO06Woo`?og`06mkkgW^mmkgg_GNLl
1>LL1NLl00KNnmJJaSS6>;FfYC@2U9800h@@LhiS3002DXX00d8X>LLaQP02:DD00b446><H``024:80
0a222648@@022445021?000402000`Q1occo?003oc`00`00occo?002oc`000[o?004003o??ll0002
oc`00`00occo?002oc`00`00occo?002oc`01g__W=>eU[FFaSSNfnLl00;_O@03mkkogooO06Woo`?o
g`06mkkgW^mmkgg_GNLl1>LL1NLl00KNnmJJaSS6>;FfYC@2U9800h@@LhiS3002DXX00d8X>LLaQP02
:DD00b446><H``024:800a222648@@022445021?000402000`Q1occo?003oc`00`00occo?002oc`0
00Oo?004003o??ll0002oc`01000occo?0001?ll00<00?lloc`00_ll00MkkiBb[GF]MLHHeY[W7002
ked00oNNmkkg_P02mkiUoml4mkh00oNNkgg_G@02ic`00mkkg]_F^P02e[X00mkKg__W7003ic`01^LL
g]_FV]JJaQReUP:U5003U9:447>>009S3003DZY:BCWW008aYP03:FDQ91SS008H``034:8@PPQQ0088
H@88@@@084h000@08003247o??ll00?o?003003o??ll00;o?0002?ll0P001?ll0P001Oll00<00?ll
oc`00_ll00MkciBB[EF]EKggcWWNf`02ia`00nLlkeg_O@1Ykgd3ked01^Llg__NfmkKeY[>N@C>F@04
eY[NfnLLia`2ic`01NLLg]_NfliiaQP00[FF00>U59BBQ1000W>>00=S35:ZBTT00T8800<aYRUU8B@0
0R4400<Hha2R48800Q2200@8H@Q12448@@D084/000@08003247o??ll00?o?003003o??ll00;o?000
5Oll00<00?lloc`00_ll00Mc[XaaYABU5;FfaSS>N@02e[X00mkkiacW701Yia`3g_/01]JjeY[>FLiI
aQRme`>e]P03_MO6><ii00;Nf`03iacW?>Ll00;W7007g]_>NLHHaQReUZDDU9800X@@00=cSV</F//0
0TYY00=223W7<HH00RU500HQ11SS6<<H`a2R4883264224450219000302022445oc`00`00occo?002
oc`001Go?003003o??ll00;o?007Lhj4<9cCW=>]MKgGaSP00/iI00?>NMJJeYX0ImJj1=JJ00?>NLiI
aQP00[gG00>eUZeEYA@00ZDD00>]EKFfaQP00/ii00?NfnLlic`00^Ll00OW7=kKcWW>NLHH]IJU5002
U9800h@`Lji[C@02F^/00e::@RPii`02<JH01bUU8B@Q12446><H`a2R008@PP88H@<8@@D084H000<0
8088@@Go?003003o??ll00;o?0005Oll0P000oll00McSX@`W=>Ldjee_MO6>002cUT00liieY[FVP1W
e[X4eYX00liicUW66002_ML00kFF[EFU5002YA@00jeE]KK66002cWT00mkKiccW?002ic`01nLLg]_>
NLiiaQReUZDD00:DTP03Q31c[V]=009Jj`03DXY2:3WW008aYP07:FDQ92448@@HhaS34:800Q220PQQ
0`Q11@0PAP000`0P0PQ11?ll0P001?ll000Eoc`00`00occo?002oc`01f]]Q12D/YBbYAB]MKgG00:m
mfk66003_ONmekFF00:]E@03W?>D/Xaa00:<L@03U;:U5;FF00;6>003eY[NnnLl00?_G@06iacNfmkK
cWW66;FF0ZDd00>D/X@`Nll00V]=00=Jje:ZBTT00T8800Liac66:DDYAB4T6><H``024:8248800`QQ
2448@@0224450214000302022445oc`00`00occo?002oc`001Go?003003o??ll00;o?007HbakchaA
S56LdjDD[ED00ZeeK;FF0jee00JU=:DDU;:D/XaaQ103Nll00h@@S76U5002]KH00liIg]_W7004ked2
ia`00mkKcWW66002]KH00jDdW=><D@02Nnl00f]]H`aJb`02BVT01d8X>LLaYS6V:FDQ9244008Hh`03
6<<@XQ2200<8H@@8@@D0844000<08088@@Go?003003o??ll00;o?0005Oll00<00?lloc`00_ll00IS
37>>Q12448aaU;9aW?<00icCU;:<L@02Q3000g_?JfeS;002H``00f]=NnnDTP02[ED00kggeY[Nn`02
ic`2kgd2ked00nLlg]_FVP02aSP00kFf[EFLd`02S7400h@@Lji[C@02F^/01e::BTU22488>LLaQRU5
008Q90038@@HhaS3008@XP034888H@QQ00@8@@D083l000<08088@@Go?003003o??ll00;o?0005Oll
00<00?lloc`00_ll00IJjf]]Nlmkch@`S546S75/S5401X@`Nnmc[W>^JdeJb`=:J@03DZY[CH@@00:L
d`03]IK6>=Jj00;W7007keg_ONmmkgg_GNLlg_/00]JJ00?6>;gG[GD00Ycc00>DTX@`Nll00V]]00MS
35:ZBVU:JD8X>NLaYP02:FD00bU58B@Hh`026<<24:8011222648H@QQ10Q11@0P?0000`0P0PQ11Oll
00<00?lloc`00_ll000Eoc`00`00occo?002oc`01U[[Jfekcg_?Q32<D@J<LFb<D@06Q31kkg>^Lji[
CE[;0dYY00=BZV]=Q1000YcC00>eU/Hhe[X00^LL00O_GNmmkgg_ONmMiccNn`02eYX00lHh_MN]M@02
W?<00iBBQ31kc`02Jfd01f<<DZY:JDYY@RPiic6V008YI@03:DDQ91SS008H``8@XP044888H@QQ2644
2445020l000302022445oc`00`00occo?002oc`001Go?08000?o?005DZYS;7>>Lhikc`05Nnl4NlmS
Ljh6Nll2Ljh01V]]HbaS;5[;BTTii`8ia`03@PQJbg>>00:<L@03YCBmelii00;Nn`03icc_OONN00;g
WP07kggW?=kkg__F^/iI_OL00[FF00>U=9BbS5400W__00McSV</F^]Jje::BTU22002>LL00c66:FDY
A@028@@00aSS6<<@XP024:800a222648H@042445020j000302022444oc`20004oc`001Go?003003o
??ll00;o?005DXYJjf</Hba[K@02Lhh2Jfd2Jde^Hb`01V<<F/]JbdYY>NLYI@8Q9003<HI:BF</00:4
4003W=>]MLHH00;FVP04g___GNmmkgd2mih01^mmkeg_GNLLg]_>N@;66003]KJ]EIcc00:DTP07Q11k
cf]]JfeS35[;BVT00T8X00<iicW7<HH00RUU00<Q92446><00QS30Q2R00@@PPQQ2648H@@8@@H083H0
00<08088@@Go?003003o??ll00;o?0005Oll00<00?lloc`00_ll00M:JE:ZF^]Jjf<<HbaS3002F^/2
F/]ZDZX3F//2DZX2BVT00d88<HHHh`024:800b4T>NMJb`02Lhh00haaYABe]P02cUT01=Jjiac_GNmM
1ONN00?_GNLLg]/00]JJ00?6>;gG[GD00ZDD00ND/XaANnmkkg>>JdeJj`02DZX00dYY@RPii`02<JH0
0c66:DDQ90028@@00aSS6<<@XP024:8011222648H@QQ0`Q11`0P<P000`0P0PQ100<8HOlloc`00oll
00<00?lloc`00_ll000Eoc`00`00occo?002oc`0148XDXYBZU:Z0U[;00EBZU::DXY:JDY906U2:0I:
B@922003>LLYAA2R008080036><aYTYY009[C@03Q12D/ZeE00:mm`06cWWNfnLlicc_OONN0oNn00?g
W^mmic`00]kk00?F^/iI_OL00[FF00NU=9ccU9:DTX@`Nlm[K@02Hb`00e[[DXY:B@02@PP00cWW<JHa
QP02:DD00b4T8@@Hh`026<<24:83488226442446020_0003020224400`QQocco?003oc`00`00occo
?002oc`001Go?003003o??ll00;o?004@RQBRU:ZDZX2F//01E:ZDXYBRTYYBTT0JD8X1TY90T8800<i
abU54:800P0P00<Hhc6VBVT00V]=00>449Bb[ED00[gg00K>NMkKiccW?>mmmih3mkh00oNNkggW?002
g_/00mJjcUVmm`02]IH01jDdW?>DTYBBQ31kcf]]009S;003F^]BRTY900922003>NLaYS66008YA@03
8B@Q11SS008H``8@XP<@PP88H@@8@@H082l000<08088@@03267o??ll00?o?003003o??ll00;o?000
5Oll00<00?lloc`00_ll00=224Y9BVT00dYY00A:BD88@PPiif/ia`Dii`8ia`03<HHQ912R00808003
6<<aQTY9009Jj`03Ljj<DIcc00:]M@07_OO>NMkKg]_W?>mmmih00oNn00OgW^mmkeg_GNLLg]_>N@02
aSP01kgG[GFU5:DDU;:<LH@@009c[P03JfeS35[;009BRP03BTU223WW008aYP03<HHYAB4T008Q1005
6><H`aS36<<@XP02488326442446020/0003020224400`QQocco?003oc`00`00occo?002oc`001Go
?08000?o?003>NM2248X0092:005@PPiic6V<JHaQP1[:FD3<HH2<JH2<HH00bUU8@@@XP0226400aS3
:FE22002DZX00f]=Nnn<L@02YA@01kFFaQS>NLiig]_W?>mm00;gWP?g_P;gWP03kegW?=kk00;FVP07
cUVmmkFf]KJ]EIccU9800XaA00=kkg>^Jdd00V<<00=Jbe::BTT00T8800<iic6V<HH00RU500@Q9244
6><Hh`8H``044:8@PQ22488226452447020X0003020224400`QQocco?002oc`20004oc`001Go?003
003o??ll00;o?003>LLiicWW008ii`06>LLaQRUU:FDYAB4TJ244124T00<YABUU:FD00RUU00<YAB44
6<<00Q2R00<HhbUU>NL00TYY00=Jjg>>Q1000YBB00NU5;FFaQS66=JJg]_W?002kgd00oNNmkkg_P02
mkh00oNNkgg_G@02ia`01mkKcWW6><Hh_MNeUZDd00:Ld`03U9:4<7__009cSP03JdeS35[;009BRP03
BTU223WW008aYP05<HHYIB4T8B@Q10026><26<<24:800a222648H@0226442446020V000302000`Q1
2648H@05oc`00`00occo?002oc`001Go?003003o??ll00;o?007<JHiacW7>LLaYS66:DD00R4400<H
haS36<<0J1S30aSS00<Q124T8B@00RU500<Q92446<<00QS300<HhbU5>LL00T8X00=BZV<<Lhh00X@@
00NDTZDD]IJeU/HHcWWNf`02ic`00nmmmikg_P04mkh01ONNkeg_GNLlg_/00]Jj00?>FLHH]KH00Zee
00>U59cCS7400X@`00=kcg>>Jdd00V<<00=Jbe::BTT00T8800Liic6V<HHaQRUU:DDQ90028@@00aSS
6<<@XP024:82488326452446020R000302000`Q12648H@05oc`00`00occo?002oc`001Go?003003o
??ll00;o?0@aQP03:FDYAB44008H``8@XP03488@XQ2R06T@XP036<<Hhb4400@Q10<Hh`038@@YAC6V
008ii`03BTUBZV</009c[P07Q32D/ZDdYCBeU/HHcWT00]kK00?W?>mmmih00_Nn0_oO00Gg__NNmik_
ONmM00;W7003g]_FV/iI00:mm`03]KJ]EJDD00:D/P03S76447_?009cSP03JdeS35[;009BRP07BTU2
23WW>NLiac66:FD00RU500<Q92446><00aS300@@XQ22488@PP<8H@@8@@P081h000<080032448H@QQ
00Go?003003o??ll00;o?0005Oll00<00?lloc`00_ll136600<YIBU58@@00QS30Q2R00<@PQ2R4:80
JA2R00<H`aSS8@@012440aSS00<Q12U5<JH00SWW00=:BE:ZHb`00W>^00N4<9BbYCBU=;FFaQS>N@02
g]/00nLlkgggWP02mkh2oml01ONnmikgW^mmked00^LL00?NfmJJcUT00[gg00>e]ZeEYA@00YBb00><
LH@@Nll00W>>00=[CF<<F//00U::00M:BD88>NLiicW7<HHYI@02:DD00b4T8@@Hh`036<<0112R488@
PQ220`QQ10Q1200P7P000`0P00<8@@QQ26401Oll00<00?lloc`00_ll0009oc`00`00occo?002oc`2
0005oc`00`00occo?002oc`4:FD00bU58@@Hh`024:800a222648H@1Y264248800a2R6<<Hh`026><0
0b446><Hh`026><00b44:DDYI@02>LL00d88BVUJb`02Hb`01g>^Q32DTYBBYABeU/HH00;>N@03g]_W
7>mM00;gWP03mkkogooO00;og`07mkkgW^mmkggW?=kke[X00/ii00?6>;gg]IH00ZeE00>LliBbS740
0X@@00=kcg>>Jdd00V<<00MJbe::BTU:BD8X>NLia`02<JH00bUU:DDQ90028@@26><011S34:8@XQ2R
0Q220`QQ1@Q1200P6P000`0P00<8@@QQ48801Oll00<00?lloc`00_ll0009oc`01@00occo??ll0000
0_ll00<00?lloc`00_ll00<00?lloc`00_ll12U500<Q91SS4:800Q22K0Q10`QQ00<@XQS36><01QSS
00<Q124T:DD00S6600<iad88BTT00U:Z00MS;7>^Q12449BBYABeUP02_OL00liIe[[W7002ked00nmm
mkkg_P03oml3mkh00oNNkegW?002g_/00mJjcWW6>002_ML00kFF[EFLl`02U;800haaQ11kc`02Lhh0
1f]=H`aJbe[;DXY:JD8X00922003>LLaYS66008YI@03:DDQ9244008Hh`8H``034:8@PQ22008@PP<8
H@D8@@L081L000<080032448HA2200Go?003003o??ll00;o?0001_ll1@000_ll00@00?lloc`000Co
?08000?o?0@Q90038@@H`a220088@@<086L8@@8080<8@@04488@XQS36<<56><28@@01R4T:DDYABUU
<JHii`9:B@07DZYS;7>>Lhj449BBYA@00Zee00>mmliIe[X00]kk00?W?>mmmih00_Nn1?oO00?g__NN
kgd00^mM00?W7=kKe[X00/iI00?66;gG]IH00ZDd00>LliBbS7400X@@00Mkcg>>Jde[CF<<F/]BZP02
BVT00dY9@PPii`02<JH00c66:FDYA@028B@00b446><Hh`026<<24:83488426452447020C00001P0P
2448@@Q1264@PP?o?0<000Co?0001_ll00@00?lloc`000?o?004003o??ll0004oc`00`00occo?002
oc`48@@00aSS4:88H@0224400`0P0000801[02000`Q1264@PP024:826<<46><28@@38B@01RUU<JHi
icWWBTUBZP9S;003Lhj448aa00:Ll`03[GFmelHh00;FVP03g]_W7>mM00;gWP03mkkogooO00?og`06
mkkgW_NNkgg_GNLL0]kK00?FV/iIaQP00[gG00>eUZeEW?<00YBb00N<LH@`Nnmkkg>^JfeS;002F^/0
0e:ZDXY:B@02@RP00cWW>LLaYP02<HH00bUU:DDQ90028@@011SS6<<H`aS30Q2R0a220`QQ1@Q1200P
3`0000H080Q12448@@QQ4885oc`00`00occo?002oc`000Oo?003003o?00000?o?004003o??ll0004
oc`00`00occo?002oc`48@@00aSS4:88H@0224400`0P0000801[02000`Q1264@PP024:826<<46><2
8@@38B@01RUU<JHiicWWBTUBZP9S;003Lhj448aa00:Ll`03[GFmelHh00;FVP03g]_W7>mM00;gWP03
mkkogooO00?og`06mkkgW_NNkgg_GNLL0]kK00?FV/iIaQP00[gG00>eUZeEW?<00YBb00N<LH@`Nnmk
kg>^JfeS;002F^/00e:ZDXY:B@02@RP00cWW>LLaYP02<HH00bUU:DDQ90028@@011SS6<<H`aS30Q2R
0a220`QQ1@Q1200P3`0000H080Q12448@@QQ4885oc`00`00occo?002oc`000So?08000?o?004003o
??ll0004oc`00`00occo?002oc`28@@26><00aS34888H@020203001W020400000`0P2448H@034:82
6<<86><01R4T:DDaYS6V>NM:B@9BZP03H`acSW__00:<L@03W=>]EKFf00;66003cWWF^^LL00;_G@04
kgggW_Nnmkh5oml00oNnmik_O@02ic`00nLLg]_FVP02cUT00lHH_MNeUP02[ED01jDDU;:<LHaaQ31k
kg>^009[K@03HbaS35[;009BRP03BVU2:488008ii`03<JHaQRUU008YA@058B@Q12448@@Hh`026<<3
4:82488426452448020;00001P0P2448@@QQ488@XPGo?003003o??ll00;o?0002Oll00<00?lloc`0
0_ll0P001Oll00<00?lloc`00_ll0QSS0QS300<@XQ2224400P0PKP0000<080Q126400Q2200<@XQS3
6<<01AS30Q2R00<H`aSS8@@00RU500LaQSWWBTU:BE:ZH`a[K@02Nnl00haAU;:U=002]IH00kggcUWF
VP02g_/01NLlkeggW_NNmkh01_oO00Kg__NNmik_ONLlia`2g]/00mJJcUW66002_ML01kFF[EFU5:DD
W=>DTXaA00:44003NlmcSV]=009S3003F^]BZTYY009:B@03@RPiicW7008aYP06<HHYIBU5:DDQ9244
0aSS0QS30a2R0Q2210QQ1@Q1200P1`0000H080Q12448HA224:85oc`00`00occo?002oc`001Go?003
003o??ll00;o?08Hh`8H``034:88H@Q1008086h000030208@@QQ008@PP8@XP@H``8@XP<@PP064:8H
`b448@@YAC660SWW00=:BE::F^/00V]]00=kch@`U9800ZDD00>]MKgGaSP00/ii00ONfnLLkeg_GNmm
mikg_P07oml00oNnmik_O@02ic`00nLLg]_FVP02cUT01lHh_ONeU[FF[EFU59cC00:DTP03S56447_?
009c[P03JfeS;5[[009Jb`03DXY:JD8X00922007>NLiac6V<JHaQRUU:DD00R4T00<Q11SS6><00QS3
0Q2R112210QQ1@Q12@0P0P0000H080Q12448HA226<<5oc`00`00occo?002oc`001Go?08000?o?08H
``8@XP034888H@Q1008086l000050208@@QQ264@PP054:82488426401A2R6<<H`b44:DD00S6600<i
id8XDXX00U[[00=[CG>^Q1000Xaa00>LdjeE]KH00[gg00O>FMJJg__NnnLlkeggWP02mkh7oml01_Nn
mikgW^mmiccW70;Nf`07e[[>NLHhaSRmmkFf[GD00ZDd00>LliBbS7400X@`00=kkg>^Lhh00V]=00=S
35[[DZX00U::00M:BD8X@PQ223W7<JHaQP02:FD2:DD00b4T8@@Q10026><011S34:8@XQ2R112210QQ
1@Q11@0P0`000PQ100<8HA2R6<<01?ll0P001?ll000Eoc`00`00occo?002oc`26<<24:800a222648
@@02021_00001@0P2448H@QQ48801A2R0Q2210QQ00D@XQS36<<Q12U5008aQP03>NM2:5::009Jj`03
Jdec[X@@00:<L@03W=>]EKFf00:mm`07cUWFV]kkg__W?>mMmih00_Nn1ooO00Kg__NNmik_ONLlia`2
g]/01mJjcWW6><Hh_ONe]Zee00:U=003W?>D/Xaa00:4<003Nnmc[W>>009[C@03H`aJje:Z009BRP07
BTU2:488@PPiac6V<HH00RUU0RU500<Q92448@@00QSS00@H`a2R4:8@XP@@PP@8H@D8@@D080<00088
@@03264@XQS300Go?003003o??ll00;o?0005Oll00<00?lloc`00_ll0QS30Q2R00<@PPQQ24400P0P
K`0000@080Q12648H@8@PP<@XP8@PP032648@@Q10088@@05264@XQ2R6<<Q1002:DD00c66>LM2:002
BVT00e[;HbacSP02Nnl00haAU;:U5002[GD01kgGaSS>NLiie[[NnnLl00;_O@03mikg__oO00Oog`03
mkkgW^mm00;_G@07iacNnmJje[[>NLHh_OL00[gG00>eUZeEYA@00YcC00>DTXaAQ1000W_?00=cSV]]
Hb`00V<<00MJbe:ZBVU:JDY9@RPii`02>LL00c6V<HHYI@02:DD28B@01B446><HhaSS6<<0112R0a22
0`QQ1@Q10`0P00L0000P2448@A226<<Hh`05oc`00`00occo?002oc`001Go?003003o??ll00;o?0@@
XP034888H@Q1008086l000040208@@QQ264648800`QQ2440800302001@QQ488@PQ2R6<<00R4400<Y
AC66>LL00T8800=:JE:ZH``00V]]00=kch@`U9800Ycc00N]EKFF_ONmmliIeY[Nf`02ia`00nmMkggg
WP02mkh2oml00oooomoog`02oml01ONnmikgW^mmked00^LL00?NnmJjeYX00/iI00?66;gG]IH00ZeE
00>U=9ccU;800Xaa00>4<7__Ljh00W>>00M[CF</F^]Jje[;DXY:J@02BTT00d88>NLia`02<JH00c66
:FDYA@038B@012446><HhaSS0QS30a2R0Q2210QQ0`Q10`0P0PQQ00<@XQS38@@01Oll00<00?lloc`0
0_ll000Eoc`00`00occo?002oc`24:83488010QQ2440800PK`0000<080Q126400PQQ1A2200L8H@Q1
020080000208@@0226401a224:8H`aS38@@Q92UU008aYP03>NM:BE::009Jj`03JdecSW__00:<D@07
U;:U5:ee[GFe]/HHcUT00]Jj00?NnnLLked00^mm00?gW_Nnoml00_oO0_oo0ooO00Og__NNkgg_ONmM
iccNn`02g]/00mJJcWW6>002_OL00kFf[GFU=002YA@00icCU9:<D@02Q1001g__Lji[KF]]JdeS35[[
009BZP03DXY:JD8X00922003>NLiac6V008aQP03:FDYAB4T008Q90048@@HhaSS6><26<<34:824883
2643244248800aS36><Q1005oc`00`00occo?002oc`001Go?003003o??ll00;o?08@XP8@PP032648
@@Q1008086l000050208@@Q12448H@0448800`QQ2448@@030002020224401`QQ488@XQ2R6<<Hhb4T
008YI@03<JHiid8X009:J@03F/]S36]]009kc`07Q32DTYcCW=>U=;FF_ML00/Hh00?>NMJjg_/00^Ll
00?_GONNmkh00_Nn0_oO0ooo0_oO0_Nn0_NN00K_GNLliccW7=kKe[X2cWT00liIaQRme`02]IH00jeE
YCBLl`02U;801haaQ32448@@NlmcSV]]009S;003H`aJbe:Z009BRP03BTU2:488008ii`03>LLaYS66
008YI@8YA@8Q90038@@HhaSS00<H``8@XP8@PP88H@06488@XQ2R6><Q12U51Oll00<00?lloc`00_ll
000Eoc`20003oc`24:8248800`QQ2448@@02021_00001@0P2448@@Q12640112200<8H@Q124400`00
0P0P0PQ100L8HA224:8@XQS36><Q9002:FD00c6V>NM2:002BVT00e[;H`a[K@02Nll01h@`U9:LdicC
YCBeU[gG00;6>003cWWF^]kk00;W?003keggW_Nn00;g_P;og`?oo`;og`;g_P;gWP06kegW?>LliacN
fmJj0/ii00?>FLHH_ML00[FF00>]EJDdW?<00YBb00N<LH@`Q12447_?Lhi[K@02Hb`00f<<F/]BZP02
DXX00dY9@RQ22002>NL00cW7<JHaQP02:FD2:DD28B@00b446><Hh`036<<24:82488226401Q224:8@
XQSS8@@YA@Co?08000Co?0005Oll00<00?lloc`00_ll00D@XQ22488@PPQQ0088@@8086l000040208
@@Q1244226401A222648H@QQ24400`0P00<0000P02000`Q100H8HA22488@XQS36><28@@00bU5<HHi
a`02@PP00dY9DZYJj`02Jdd01g>>Nnn<DHaAU;:LljeE00:eUP03_OO6><ii00;F^P03g__W?>mM00;g
WP;g_P?og`;oo`?og`;g_P;gWP03kgg_GNLL00;Nn`03g]_FV/iI00;6>003_ONe][FF00:]E@07YABL
diBBU9:<LH@`Nnl00W_?00=cSV]]Hb`00V<<00=Jbe:ZDXX00TY900=2:488>NL00SW700@aYS66:FDY
I@8YA@068B@Q12448@@HhaS31A2R0QSS00<Q12U5:FD01Oll00<00?lloc`00_ll000Eoc`00`00occo
?002oc`448800`QQ24408002021_0000100P2448@@Q11PQQ00D8@@0P0200800000@08088@@<8H@07
488@XQSS6><Q12U5:FD00S6V00<iid8XBVT00U[;00MS36]]Ljic[X@@S76D/P02YA@00jee]KJmm`02
cUT00mJJg]_Nn`02ic`00nmMmikg_P02mkh2oml4ool3oml00oNnmik_O@02ked00nLliacNf`02e[X0
0liicUW66002_ML01kFf[GFU=:DdW?>LdiBB00:<D@03Q31kkg>^009cSP03JdeS;6<<009Jb`03DZYB
RTY90092:006@PPiicW7>LLaYS660bUU00<YAB4T8@@01ASS0R4T00<YABUU<HH01Oll00<00?lloc`0
0_ll000Eoc`00`00occo?002oc`448800`QQ24408002021_00020202244626401@Q10200800P0000
1P0P0PQ10PQQ00H@PQ2R4:8H`b448B@2:FD00c66>LM22002BTT01e:ZF^]S;6</Lhikch@`00:<L@03
W=>U=:ee00:e]P03aQS>FMJJ00;Nf`03g__W?>mM00;gWP;g_P?og`Coo`;og`?g_P03mik_ONmM00;W
7003g__NfmJJ00;>N@07aSRmmkgG_MNeUZeEYC@00Ycc00>D/YBBS5400X@`00=kkg>^Lhh00V]=00=S
;6<<F//00U:Z00MBRTYY@RQ2:488>NLia`02<JH00c66:FDYI@02:DD28B@01RU5:FDYIC66<JHia`Go
?003003o??ll00;o?0005Oll00<00?lloc`00_ll0Q220`QQ00@8@@0P020086l0008080<8@@@8H@88
@@@0808000H08088@@06264@PQ224:8H`aSS0R4400<YABUU<JH00SWW00M2:4YYDZYBZV<<JdecSP02
Nnl00h@`U9:Ld`02YC@00jee_MO66002cUT00mJJg]_Nn`02ic`01NmMkgggW_NNmkh00_oO1Ooo0ooO
00Og__NNkgg_ONmMiccW7002g_/01mJjeY[>FLiIaSRmmkFf00:eUP03[EFU59cc00:D/P03U9:<DH@@
009kk`03LjicSV]=009S;007H`aJbe:ZDZYBRTYYBTT00T8X00<iicW7<JH00S6V0S660c6V0cWW1Oll
00<00?lloc`00_ll000Eoc`00`00occo?002oc`24883264010Q10200800PK`000P0P0`Q110QQ0PQ1
100P0P001P0P0PQ100H8HA22488@XQS36><28@@00bU5:FDaYP02>NL01d8XBVUBZU:ZH`a[CG>>009k
k`03Q32DTYcC00:U=003[GFmelHH00;>F@03eY[Nfmkk00;W?005keg_OONNmikg_P02oml5ool3oml0
1oNnmik_ONmmkegW?>LL00;Nn`07e[[FV/iIcUW6>;gg]KH00[FF00>]EJDDW?<00YBb00>DTXaAQ100
0W__00=c[W>>Jdd00V</00MS35[;DZYBZU::BVU:B@02@RP00cWW>LLaYP02<JH2<HH3<JH3>NL5oc`0
0`00occo?002oc`001Go?08000?o?08@PP<8H@042440800P021_0002020324442642244402050004
02022442264248801Q2R6<<H`b448B@YI@8aQP07>LM224Y9BTUBRU[;H``00V]]00=c[W__S5400YBB
00>LljDd[GD00[gG00?66<iIeYX00]Jj00ONnnLlkeg_GNmmmikg_P03oml5ool2oml3mkh01_NNkgg_
GNmMiccNn`;Nf`03e[[>NLiI00;66003_ONe][FF00:]E@03YABLliBb00:DTP03S56447__009c[P07
Lhi[KF</HbaS35[[DZX00U::00=:JDY9@RP00T880SWW0d8800=2:4Y9@RP01?ll0P001?ll000Eoc`0
0`00occo?002oc`00a222648H@02264010Q10200800PK`000P0P0`Q110QQ0PQ1100P20000P0P0`Q1
0PQQ00H@PQ2R4:8H`aSS8@@2:DD01bUU<JHiicWW@PQ:BE::009Jj`03Hba[KG>^00:44003S56DTYcc
00:U=003[GFe]/HH00;>F@07cWWF^]kkg__W7>mMkgd00_NN00?g__oOoml01ooo0_oO00Gg__NNmikg
W^mm00;W?003iacNnmkK00;FVP03cWW>FLHH00:mm`03]KJ]MJeE00:U5003W?>D/YBB00:<D@07Q31k
kg_?NlmcSV]]Jdd00V<<00=Jje[;DZX00U::1DYY0U::00=:JOlloc`00oll00<00?lloc`00_ll000E
oc`00`00occo?002oc`426422443021_0002020424400`QQ2448@@02244402090004020224400`QQ
488@PP024:801AS38@@Q124T:DD00S6600<aYSWW@RP00TYY00=BZU[[Hb`00V]]00=kch@@S5400YBB
00>LljDd[GD00[Ff00NmmlHhcWW>NMJjg__W7002ic`00nmmmikg_P02mkh2oml5ool4oml01_Nnmikg
W^mmkegW?0;W7003g__NfmJJ00;>N@03aSS66;gG00:e]P03[GF]EJDD00:Ll`07U;:DTXaAS564<7__
Nll00W>^00=[KF]=Hb`00V<<1e[[00=BZ_lloc`00oll00<00?lloc`00_ll000Eoc`00`00occo?002
oc`426422443021_000202092443020;00040202244326401Q224:8H`aS36><Q108Q9003:FDaQSW7
00922003@RQ:JE:Z009Jj`03HbacSW_?00:44003S56DTYcc00:U=007[GFe][gg_OO6><iieYX00]kK
00?W7>Llked00^mm00?gW_Nnoml00_oO1_oo0ooO0_Nn00KgW^mmkgg_GNLlia`2g_/00mJjeY[>N@02
aSP00lHH_ONe]P02]IH01jeEYCBLliccW=>DTXaa00:4<003Q11kcg>^009cSP=[K@=[C@03HbaS3?ll
00Co?003003o??ll00;o?0005Oll00<00?lloc`00_ll10QQ0PQ10`0PK`000P0P2@Q10`0P2`00100P
0PQ10`QQ00H@PQ2R6<<H`aSS8@@28B@00bUU<HHia`02@PP00d8XBVUBZP02F^/00f</Lhikc`02Q100
0haAU9:Ll`02YC@01jee]KJmmkggaSS>NMJJ00;Nf`03iacW?>mM00;_O@03mikg__oO00;og`Koo`?o
g`;g_P06mik_ONmmkegW?>LL0]kk00?F^]JJcWT00/Hh00?66;gg]KH00[FF00N]EJDdW?>LlicCU9:<
L@02Q3000h@@Nlmc[P02Lhh3Jfd3Jdd00f</H`co?004oc`00`00occo?002oc`000So?08000Co?080
00Go?003003o??ll00;o?0@8H@88@@<086l0008080T8@@<080`000D080<8@@06264@PQ22488@XQS3
0QSS00<Q12U5:FD00S6V00<iad88BTT00TYY00=BZU[[Hb`00W>>00=kch@@S5400YBB00NLdjDD[EF]
EKFf_MO66002cUT00mJJg]_Nn`02ia`00nmMkgggWP03mkh2oml7ool2oml3mkh01oNNkgg_GNmMiccW
7=kk00;F^P03eY[>NLiI00;66007_ONe][FF]IJ]EJDdW?<00YcC00>D/XaaS5400X@`00>447__Nnl0
0W_?00=c[W>>Jdd01Oll00<00?lloc`00_ll0007oc`01000occo?0000_ll00@00?lloc`000Co?003
003o??ll00;o?0@8H@88@@<086l000@080L8@@<080l000@08088@@<8H@07488@XQS36<<Hhb448B@0
0RU500<YIC6V>LL00T8800=:BE::DZX00U[[00=S;6]]Ljh00X@@00N<DIBBW=>LdjDD[EFeUP02_ML0
0lHHcUW>N@02e[X00mkKiacW?002ked00nmmmikg_P03oml8ool2oml3mkh00oNNkgg_G@02ic`00nLL
g__Nf`02eYX01liicUW66<HH_ONmekFF00:]M@03YCBU59cc00:Ld`03U;:DTXaa00:<D@03Q31kkg>>
00Go?003003o??ll00;o?0001oll00@00?lloc`000;o?004003o??ll0004oc`20003oc`426422443
021_000402072443020@000502032442264248800a2R6<<Hh`028@@00b4T:DDaQP02<JH00cW7@PQ:
B@02DXX00e:ZF^]S;002Jfd01g>^Nnn4<8@`S76D/Ycc00:U=003[GFe][gg00;6>003cWWFV]kK00;N
n`03iac_GNmm00;gWP;g_P?og`Ooo`?og`;g_P;gWP03kgg_GNLl00;W7007g__NfmJJeY[>NLiIaSP0
0[gg00>mekFf[GD00ZeE00>U=:DDW?<00YcC00>DTX@`Nll00oll0`001?ll0007oc`30003oc`01000
occo?0001?ll00<00?lloc`00_ll0PQQ0`Q1100PK`00100P1PQ1100P4`000`0P0`Q10`QQ0Q2200H@
XQS36<<Hhb448B@2:DD00c66<JHii`02@PP00dY9BVUBZP02F^/01f</Jfec[W>^Nnn4<8aa00:D/P03
W?>U=:ee00:eUP03_MO66<iI00;>N@03e[[NfnLL00;W?004keg_OONNmih2mkh3oml7ool3oml2mkh0
1ONNkgg_ONmMic`00^LL00?NnmkKe[X00]JJ00?>FLHhaQP00[gg00>mekFF[GD00ZDd00>LliBBQ300
1Oll00<00?lloc`00_ll0007oc`00`00occo?003oc`01000occo?0001?ll00<00?lloc`00_ll0PQQ
0`Q1100PK`00100P1PQ1100P4`000`0P0`Q10`QQ0Q2200H@XQS36<<Hhb448B@2:DD00c66<JHii`02
@PP00dY9BVUBZP02F^/01f</Jfec[W>^Nnn4<8aa00:D/P03W?>U=:ee00:eUP03_MO66<iI00;>N@03
e[[NfnLL00;W?004keg_OONNmih2mkh3oml7ool3oml2mkh01ONNkgg_ONmMic`00^LL00?NnmkKe[X0
0]JJ00?>FLHhaQP00[gg00>mekFF[GD00ZDd00>LliBBQ3001Oll00<00?lloc`00_ll0007oc`00`00
occo?003oc`01000occo?0001?ll00<00?lloc`00_ll0PQQ0`Q10P0PL@00100P1PQ1100P50001@0P
0`Q10PQQ00H@PQ2R4:8@XQS36><28@@00b4T:DDaQP02<JH00cW7@PQ:B@02BVT01e:ZF^]S36<<Jdec
SW_?00:44003S56DTYcC00:U5003[EFeU[Ff00:mm`03aSS>FMJJ00;F^P07g__W7>Llicc_GNmmmih0
0_Nn0_oO2Ooo0_oO0oNn00KgW^mmkgg_GNLlia`2g_/00mkKe[[FVP02cWT00liIaQRmm`02]KH00jeE
W?><L@05oc`00`00occo?002oc`000So?0<000?o?08000Go?003003o??ll00;o?088H@<8@@808740
00@080H8@@@081H000H08088@@<8H@03488@XQ2R008H``036><Q124T008YA@03<HHaYSW700922007
@RQ:JE::DXYJbf<<Jdd00W>>00=c[W__Q3000Xaa00>D/YccYC@00Zee00>eU[gGaQP00/Hh00O>NMJj
g]_Nfmkkiac_G@02kgd2mih01?NnomoogooO2Ooo0_oO0oNn00OgW^mmkgg_ONmMiccW7002g_/00mJj
eY[>F@02aQP00kFfYCBD/P05oc`00`00occo?002oc`001Go?003003o??ll00;o?088H@<8@@808780
00<080H8@@@081T000@080@8@@88H@06488@XQ2R4:8H`aSS0R4400<Q92U5:FD00S6V00LiacWW@RQ2
:4Y9DXYJb`02F^/00f</Jfec[P02Nnl00h@@S56DTP02W=<00jDD[EF]M@02]KH01kggaQS>FLiIcWWF
^]kK00;W7003icc_GNmm00?gWP04mkkogooOoml9ool3oml2mkh2mih01^mmkeg_GNLLg__F^P;>F@03
_ON]MIcC00Go?003003o??ll00;o?0005Oll0P000oll00<8H@Q124400PQ10P0PLP000`0P1PQ1100P
6P001@0P10Q10`QQ00<@PQ2R4:800QS300<Hhb448B@00RU500LYIC66>LLiacWW@RQ:B@02DXX00e:Z
F^]S3002Jdd00g>>Nlmkk`02Q3000haaU;:Ll`02YA@01jeE]IJmekgG_OO6><iI00;FVP03e[[NfnLL
00;W?003keg_OONN00;gWP03mkkogooO00Woo`Cog`06mkkgW_NNkggW?=kk0]Jj00?6>;FfYA@01?ll
0P001?ll000Eoc`00`00occo?002oc`00`QQ2448@@022442021b000302062444020J000502042443
26400a224:8@XP026<<00aSS8@@Q9002:DD01bUU<HHiacW7>NM2:4Y9009BRP03DZYJjf<<009[C@03
Lhikcg__00:4<003S76D/Ycc00:U5007[EFeU[gG_MNmmlHhcUT00]JJ00?F^]kKia`00^Ll00?_GNmm
mih00_NN00?g__oOoml02Ooo1?oO00Kg__NNmik_ONLlg_/2e[X00lHh]KJU5005oc`00`00occo?002
oc`001Go?003003o??ll00;o?0032648@@Q10088@@80878000@080D8@@@081d000D080@8@@88H@06
488@XQ2R4:8H`aSS0R4400LQ92U5:FDYIC66<JHii`02@PP00d8XBVUBRP02F//00f<<Hba[K@02Ljh0
0g_?Q12<D@02U9801iBbW?>U=:Dd[GFeU[gG00;66003aSS>NMJJ00;F^P03g__W7>Ll00;_G@03kggg
W_NN00;g_P;og`Woo`?og`03mkk_ONLl00;Nf`03cWVmejDd00Go?003003o??ll00;o?0005Oll00<0
0?lloc`00_ll1@Q10P0PLP00100P1@Q1100P7`001@0P10Q10`QQ00<@PQ2R4:800QS300LHhb448B@Q
92U5:FDaQP02<JH00cW7>NM2:002BTT00e::DZYJj`02H``00f]=Lhic[P02Nnl01h@`S76DTYBBW=>U
5:Dd00:]M@03]KJmelHH00;6>003cWWFV]Jj00;Nn`03iacW?>mM00;_O@;gWP;g_P?og`Goo`?og`07
mik_GNLLiacFV[gg[ED01Oll00<00?lloc`00_ll000Eoc`00`00occo?002oc`52442021b00040204
2445020R00050204244226401A224:8@XQ2R6<<00aSS00LQ124T:DDYABUU<HHia`02>NL00d88BTU:
J@02DXX00e[;F^]S;002Jfd01g>>Nln448@@Q32<LIBb00:Ld`03YAB]EJee00:e]P03_MO66<Hh00;>
N@03eY[F^]kk00;W7003icc_GNmm00;_O@04mikg__Nnmkh6oml01oNnkggW7>LLe[[66:ee00Go?003
003o??ll00;o?0005Oll00<00?lloc`00_ll1@Q10P0PLP00100P10Q10`0P9P001@0P10Q10`QQ0Q22
0Q2R0QS300HHhb448@@Q92U5:FD2<HH00c6V>LM22002@RP00dY9DXYBZP02F//01f<<Jde[KF]]Ljik
ch@@00:<D@03S76D/Ycc00:U5003[EF]MKFf00:me`03aQS6><ii00;FVP05e[[NfnLLiacW?002ked2
kgd00oNNmkkg_P03mkh01oNNkggW7>LLe[[66:ee00Go?003003o??ll00;o?0005Oll0P000oll1@Q1
0P0PLP00100P10Q10`0P9P001@0P10Q10`QQ0Q220Q2R0QS300HHhb448@@Q92U5:FD2<HH00c6V>LM2
2002@RP00dY9DXYBZP02F//01f<<Jde[KF]]Ljikch@@00:<D@03S76D/Ycc00:U5003[EF]MKFf00:m
e`03aQS6><ii00;FVP05e[[NfnLLiacW?002ked2kgd00oNNmkkg_P03mkh01oNNkggW7>LLe[[66:ee
00Co?08000Co?0005Oll00<00?lloc`00_ll1@Q10P0PLP00100P10Q10`0P:@001@0P10Q10PQQ0a22
0Q2R0QS300<Hhb448B@00R4T00<YABUU<JH00SW700<iid88@RP00TYY00MBRU:ZF^]Jjf<<Jde[K@02
Ljh00g__Q12<D@02S7400iBbW?>U5002[ED00jee]KJme`02aQP01lHhcUWFV]JJe[[Nfmkk00;W7003
icc_GNmm00C_O@06kegW7>LLe[[66:ee1Oll00<00?lloc`00_ll000Eoc`00`00occo?002oc`52442
021b000502032443020[000502042443264248834:801aS36><HhaSS8@@Q92U5008YI@03<HHaYSW7
008ii`07@PQ:BDYYBVUBRU[;F^/00V</00=[CG>>Ljh00W__00>448aAS7400YBb00>LljDD[ED00Zee
00Ne][gGaQS66<HhcUW>N@02e[X00mkKg__W7004ic`01^LLg__NnmJJaQR]M@Go?003003o??ll00;o
?0005Oll00<00?lloc`00_ll10Q10`0PLP001@0P0`Q10`0P;P001@0P10Q110QQ0Q2200D@XQS36<<H
`aSS00<Q10038B@YABUU008aQP07<JHiad88@PQ2:4Y9BVT00U:Z00=Jbe[[Hb`00V]=00=cSW>^Nnl0
0X@@00><DHaaU;800YcC00NU5:Dd[GF]MKFF_MNmm`02aSP00liIcWWFVP02e[X3g]/2e[X00liI_ON]
E@05oc`00`00occo?002oc`001Go?003003o??ll00;o?0@8@@<0878000D080032440800P00<08300
00L080@8@@88H@<@PP8@XP066<<HhaSS6><Q124T0RU500LYIC66<JHaYSW7>NM22002@RP00dY9DXYB
ZP02F//00f<<Hba[C@02Lhh00g>^Nnn44002S5401haaU;:LdicCYABU=:ee00:eUP03_MNmmlHH00;>
F@G>N@03aSRmejDd00Go?003003o??ll00;o?0005Oll00<00?lloc`00_ll10Q10`0PLP001@0P00<8
@@0P02000`0P<0001`0P10Q10PQQ0a220Q2R00HH`aSS6><Hhb448B@2:DD01bUU<HHaYS6V>LLiid88
0092:003BTUBRU:Z009Jb`03H`aS;6]=009cSP03Ljikkh@@00:<D@07S76D/YcCW=>U5:Dd[GD00[FF
00>mekggaQP00/iI1Lii00?6>;gGYC@01Oll00<00?lloc`00_ll000Eoc`00`00occo?002oc`42443
021b000;020c000602042444264248834:801QS36><HhaSS8@@Q908YA@03:FDaQS6V008ia`03>NM2
248X009:B@03DXYBZU[;009S3003Hba[CG>>009c[P07Nnn448@`Q32<LIBBW=<00Ycc00>U=:eE]IH0
0[Ff00>mmlHHaQP00/HH00>mmkFFYA@01Oll00<00?lloc`00_ll000Eoc`20003oc`42443021b000;
020g000602042442264348824:836<<01QSS8@@Q12448B@YA@8YI@03<HHaYSW7008ii`03@PQ2:4Y9
009BRP03DZYJbe[[009S;007Jde[KG>^Ljikch@@Q3000Xaa00>DTYcCW?<00ZDd00>]MKFF]KH00kFf
00>]EIccoc`00oll0P001?ll000Eoc`00`00occo?002oc`42443021b000;020i0007020324442643
48824:836<<00aSS8@@Q90028B@01bU5:FDaQS66<JHiacWW00922003@RQ:BDYY009BZP07F/]Jjf</
Hba[CF]]Ljh00W_?00=kkh@`S7400YBB00>LdjDDYC@00jeE00>U59cCoc`01?ll00<00?lloc`00_ll
000Eoc`00`00occo?002oc`42443021b000;020l000702042444264348824:801AS36><HhaSS8@@0
0b4T00<YABUU<HH00S6V00<iacWW@PP00T8X00M:BDYYDZYBZU[;F^]S3002Jdd00f]]Lhikc`02Q100
0haAU9:Ld`03W?<00icCU9;o?004oc`00`00occo?002oc`001Go?003003o??ll00;o?0@8@@<08780
00/083`000L080@8@@@8H@<@PP8@XP056<<HhaSS6><Q10038B@00bU5:FDaQP02<JH00cW7>NM22002
@RP01dY9BVUBZU:ZF/]Jjf<<009[C@03JfecSW_?00:44003S56DTYcC00>Ll`03W=>DT_ll00Co?003
003o??ll00;o?0002?ll0P001?ll0P001Oll00<00?lloc`00_ll10Q10`0PLP002`0P@0001P0P1@Q1
0`QQ0a220a2R00DH`aSS6><Hhb44008Q908YA@03:FDaQS6V008ia`07>NM2248X@RQ:BDYYDXX00U:Z
00=Jjf<<Jdd00V]]00=c[X@@S5400Xaa0YBB00><DOlloc`00oll00<00?lloc`00_ll0007oc`01000
occo?0000_ll00@00?lloc`000Co?003003o??ll00;o?0@8@@<0878000/0848000P080@8@@<8H@@@
PP044:8H`aS36<<26><28@@28B@01BU5:FDYIC66<JH00SW700<iid88@RP00TY900=:JE::DZX00U[[
00=S;6]]Nll00X@@00>4<8aAQ3001Oll00<00?lloc`00_ll0007oc`01000occo?0000_ll00@00?ll
oc`000Co?08000?o?0@8@@<0878000/084H000P080<8@@@8H@<@PP8@XP<H``8Hh`058@@Q924T8B@Y
A@02:FD00c66<JHaYP02>LL00cWW@PQ:B@02BVT00e:ZF^][C@02Ljh3Nnl3oc`30004oc`000So?080
00?o?004003o??ll0004oc`00`00occo?002oc`42443021b000;021:000602052444264248844:80
11S36><HhaSS0b4400<Q92U5:FD00RUU00<aQS6V>LL00SWW00=2:5::F^/00V</00=cSW>^Ljh01Oll
00<00?lloc`00_ll0007oc`01000occo?0000_ll00@00?lloc`000Co?003003o??ll00;o?0@8@@<0
878000/084X000H080D8@@@8H@8@PP@@XP046<<HhaSS6><38@@00b4T:DDYI@02:FD00c66<JHia`02
>NL00d8XDXYJj`02Hb`00g>>Ljic[P05oc`00`00occo?002oc`000Oo?004003o??ll0002oc`01000
occo?0001?ll00<00?lloc`00_ll10Q10`0PLP002`0PC000200P1@Q110QQ0a220a2R0aS300<Hhb44
8@@00R4T0RU500HYIC66<HHiad88BVT2F//00f</Jfe[K@05oc`00`00occo?002oc`000So?08000Co
?08000Go?003003o??ll00;o?0@8@@<0878000/0850000P080D8@@<8H@@@PP<@XP8H``<Hh`078@@Q
924T8B@YIC6V@PP00U::00=Jjf</Hb`01Oll00<00?lloc`00_ll000Eoc`00`00occo?002oc`22445
021b000;021D000702052444264448834:836<<26><00b44:FDia`02@RP00e::F^]S3005oc`00`00
occo?002oc`001Go?08000?o?088@@@087@000X085P000L080L8@@<8H@@@PP<@XP036<<Q12UU008i
i`03BTUBZU[;00Co?08000Co?0005Oll00<00?lloc`00_ll0PQ1100PM0002P0PF0001`0P1`Q10`QQ
11220a2R00<H`b44:FD00SWW00=:BE:ZF//01Oll00<00?lloc`00_ll000Eoc`00`00occo?002oc`2
2444021d000:021K00090205244726400a226<<Q9002<JH00d88BVUBZP05oc`00`00occo?002oc`0
01Go?003003o??ll00;o?088@@@087@000X085l000T080P8@@03264@XR44008YI@03>NM:BE::00Go
?003003o??ll00;o?0005Oll00<00?lloc`00_ll0PQ1100PM0002P0PH`003@0P00<8@@QQ6<<00RU5
00<aYT88BTT01Oll00<00?lloc`00_ll000Eoc`00`00occo?002oc`22444021d000:021X00060202
00000`0P244@XP028B@00c66>NM2:005oc`00`00occo?002oc`001Go?003003o??ll00;o?088@@@0
87@000X086P000H0808000030208@A2R008Q9003<HHiid8X00Go?003003o??ll00;o?0005Oll0P00
0oll0PQ1100PM0002P0PJ`000`0P0`0000L8@A228@@Q12UU>LM22004oc`20004oc`001Go?003003o
??ll00;o?088@@@087@000X087400007244@PQSS6><YAC6V@PP01Oll00<00?lloc`00_ll000Eoc`0
0`00occo?002oc`22444021d000:021a00001`Q1488HhaSS:DDaYSWW00Go?003003o??ll00;o?000
5Oll00<00?lloc`00_ll0PQ1100PM0002P0PL00000<080Q148800QS300<Q9366>LL01Oll00<00?ll
oc`00_ll000Eoc`00`00occo?002oc`22444021d000:021`00000`0P244@PP026<<00b4T<HHia`05
oc`00`00occo?002oc`001Go?003003o??ll00;o?088@@@087@000X0870000030208@A22008H``03
8B@aQSW700Go?003003o??ll00;o?0005Oll0P000oll0PQ1100PM0002P0PL00000<080Q148800QS3
00<Q92UU>LL01?ll0P001?ll000Eoc`00`00occo?002oc`22444021d000:021`00000`0P244@PP02
6<<00b4T:FDaYP05oc`00`00occo?002oc`001Go?003003o??ll00;o?088@@@087@000X087000003
0208@A22008H``038@@YIC6V00Go?003003o??ll00;o?0005Oll00<00?lloc`00_ll0PQ1100PM000
2P0PL00000<080Q148800QS300<Q12UU<JH01Oll00<00?lloc`00_ll00000oll000000020003oc`2
0004oc`20005oc`00`00occo?002oc`22444021d000:021`00000`0P244@PP026<<00b44:FDaYP05
oc`00`00occo?002oc`000?o?005003o??lloc`00002oc`01000occo?0000_ll00<00?lloc`00_ll
00<00?lloc`00_ll0PQ1100PM0002P0PL00000<080Q148800QS300<Q12UU<JH01Oll00<00?lloc`0
0_ll0003oc`01@00occo??ll00000_ll00@00?lloc`000;o?003003o??ll00;o?0800?oo?0?o?0<0
00Co?0000oll00D00?llocco?00000;o?004003o??ll0002oc`00`00occo?002oc`00`00occo?002
oc`00`00occo?00loc`00`00occo?00loc`00`00occo?00loc`00`00occo?00loc`00`00occo?002
oc`00`00occo?002oc`000?o?005003o??lloc`00002oc`01000occo?0000_ll00<00?lloc`00_ll
00<00?lloc`00_ll00<00?lloc`02Oll00<00?lloc`02_ll00<00?lloc`02_ll00<00?lloc`02Oll
00<00?lloc`02_ll00<00?lloc`02Oll00<00?lloc`02_ll00<00?lloc`02Oll00<00?lloc`02_ll
00<00?lloc`02_ll00<00?lloc`02Oll00<00?lloc`02_ll00<00?lloc`02Oll00<00?lloc`02_ll
00<00?lloc`02_ll00<00?lloc`02Oll00<00?lloc`02_ll00<00?lloc`02Oll00<00?lloc`02_ll
00<00?lloc`02_ll00<00?lloc`00_ll00<00?lloc`00_ll00001?ll000000000oll00@00?lloc`0
00;o?004003o??ll0004occo00080004oc`000?o?003003o??ll00;o?08000Co?0800?oo?17o?000
ooll8Oll003ooc`Qoc`00?oo?27o?000ooll8Oll003ooc`Qoc`00?oo?27o?000ooll8Oll003ooc`Q
oc`00?oo?27o?000ooll8Oll003ooc`Qoc`00?oo?27o?000ooll8Oll003ooc`Qoc`00?oo?27o?000
ooll8Oll0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-20.9043, -24.3878, \
0.794624, 0.794624}}],

Cell[BoxData[
    \({12.27`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["With different window and signal", "Section",
  InitializationCell->True,
  TextAlignment->Center],

Cell["\<\
One can use different dilated Gaussians in order to resolve \
different frequency bands of the signal\
\>", "Subsubsection"],

Cell[BoxData[
    \(g[x_] := Exp[\(-Pi\)/2\ x^2]\)], "Input",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListDensityPlot[Abs[stft[f, g, 0.1]], Mesh \[Rule] False, 
          PlotRange \[Rule] All, AspectRatio \[Rule] Automatic];\) // 
      Timing\)], "Input",
  InitializationCell->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00480769 0.00961538 0.00480769 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -6 -9 ]
[.25962 -0.0125 6 0 ]
[.5 -0.0125 -9 -9 ]
[.5 -0.0125 9 0 ]
[.74038 -0.0125 -9 -9 ]
[.74038 -0.0125 9 0 ]
[.98077 -0.0125 -9 -9 ]
[.98077 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .00962 -6 -4.5 ]
[-0.0125 .00962 0 4.5 ]
[-0.0125 .10577 -12 -4.5 ]
[-0.0125 .10577 0 4.5 ]
[-0.0125 .20192 -12 -4.5 ]
[-0.0125 .20192 0 4.5 ]
[-0.0125 .29808 -12 -4.5 ]
[-0.0125 .29808 0 4.5 ]
[-0.0125 .39423 -12 -4.5 ]
[-0.0125 .39423 0 4.5 ]
[-0.0125 .49038 -18 -4.5 ]
[-0.0125 .49038 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .5 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(50)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(100)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(150)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(200)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.06731 0 m
.06731 .00375 L
s
.11538 0 m
.11538 .00375 L
s
.16346 0 m
.16346 .00375 L
s
.21154 0 m
.21154 .00375 L
s
.30769 0 m
.30769 .00375 L
s
.35577 0 m
.35577 .00375 L
s
.40385 0 m
.40385 .00375 L
s
.45192 0 m
.45192 .00375 L
s
.54808 0 m
.54808 .00375 L
s
.59615 0 m
.59615 .00375 L
s
.64423 0 m
.64423 .00375 L
s
.69231 0 m
.69231 .00375 L
s
.78846 0 m
.78846 .00375 L
s
.83654 0 m
.83654 .00375 L
s
.88462 0 m
.88462 .00375 L
s
.93269 0 m
.93269 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .00962 m
.00625 .00962 L
s
[(0)] -0.0125 .00962 1 0 Mshowa
0 .10577 m
.00625 .10577 L
s
[(20)] -0.0125 .10577 1 0 Mshowa
0 .20192 m
.00625 .20192 L
s
[(40)] -0.0125 .20192 1 0 Mshowa
0 .29808 m
.00625 .29808 L
s
[(60)] -0.0125 .29808 1 0 Mshowa
0 .39423 m
.00625 .39423 L
s
[(80)] -0.0125 .39423 1 0 Mshowa
0 .49038 m
.00625 .49038 L
s
[(100)] -0.0125 .49038 1 0 Mshowa
.125 Mabswid
0 .03365 m
.00375 .03365 L
s
0 .05769 m
.00375 .05769 L
s
0 .08173 m
.00375 .08173 L
s
0 .12981 m
.00375 .12981 L
s
0 .15385 m
.00375 .15385 L
s
0 .17788 m
.00375 .17788 L
s
0 .22596 m
.00375 .22596 L
s
0 .25 m
.00375 .25 L
s
0 .27404 m
.00375 .27404 L
s
0 .32212 m
.00375 .32212 L
s
0 .34615 m
.00375 .34615 L
s
0 .37019 m
.00375 .37019 L
s
0 .41827 m
.00375 .41827 L
s
0 .44231 m
.00375 .44231 L
s
0 .46635 m
.00375 .46635 L
s
.25 Mabswid
0 0 m
0 .5 L
s
.01923 .49375 m
.01923 .5 L
s
.25962 .49375 m
.25962 .5 L
s
.5 .49375 m
.5 .5 L
s
.74038 .49375 m
.74038 .5 L
s
.98077 .49375 m
.98077 .5 L
s
.125 Mabswid
.06731 .49625 m
.06731 .5 L
s
.11538 .49625 m
.11538 .5 L
s
.16346 .49625 m
.16346 .5 L
s
.21154 .49625 m
.21154 .5 L
s
.30769 .49625 m
.30769 .5 L
s
.35577 .49625 m
.35577 .5 L
s
.40385 .49625 m
.40385 .5 L
s
.45192 .49625 m
.45192 .5 L
s
.54808 .49625 m
.54808 .5 L
s
.59615 .49625 m
.59615 .5 L
s
.64423 .49625 m
.64423 .5 L
s
.69231 .49625 m
.69231 .5 L
s
.78846 .49625 m
.78846 .5 L
s
.83654 .49625 m
.83654 .5 L
s
.88462 .49625 m
.88462 .5 L
s
.93269 .49625 m
.93269 .5 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.99375 .00962 m
1 .00962 L
s
.99375 .10577 m
1 .10577 L
s
.99375 .20192 m
1 .20192 L
s
.99375 .29808 m
1 .29808 L
s
.99375 .39423 m
1 .39423 L
s
.99375 .49038 m
1 .49038 L
s
.125 Mabswid
.99625 .03365 m
1 .03365 L
s
.99625 .05769 m
1 .05769 L
s
.99625 .08173 m
1 .08173 L
s
.99625 .12981 m
1 .12981 L
s
.99625 .15385 m
1 .15385 L
s
.99625 .17788 m
1 .17788 L
s
.99625 .22596 m
1 .22596 L
s
.99625 .25 m
1 .25 L
s
.99625 .27404 m
1 .27404 L
s
.99625 .32212 m
1 .32212 L
s
.99625 .34615 m
1 .34615 L
s
.99625 .37019 m
1 .37019 L
s
.99625 .41827 m
1 .41827 L
s
.99625 .44231 m
1 .44231 L
s
.99625 .46635 m
1 .46635 L
s
.25 Mabswid
1 0 m
1 .5 L
s
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
% Start of gray image
p
.01923 .00962 translate
.96154 .48076 scale
200 string
200 100 8 [200 0 0 100 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
3E3D3A342D251D16100C0806050302010000000000000101000000010100000001010000
000101000000010100000001010000000101000000010100000001010000000101000000
0101000000010100000001010000010101010100000000000204080C12171C202222201D
18140F0B0705030101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000101020203040405
3F3E3B352E261E16100B0806050403020101010101010101010101010101010101010101
010101010101010101010101010101010101010101010101010101010101010101010101
0101010101010101010101010101010202020100000000010305090E13191E212323211E
19140F0B0805030101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000101020203040405
40403D3730271E160F0A0605040404030302020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202
02020202020202020202020202020303030202010000010204070B11161C21242625231F
1A15100C0805030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000101020203040405
43423F3A322920170F090403040505050504040404040404040404040404040404040404
040404040404040404040404040404040404040404040404040404040404040404040404
040404040404040404040404040404040404030201010304070A0F151A20252829282521
1C17110D0906030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000010101020203040405
4546433E362D231A10090201040607070707070707070707070707070707070707070707
070707070707070707070707070707070707070707070707070707070707070707070707
0707070707070707070707070707070707060504040406080B0F141A20262A2D2E2C2924
1F19130E0A06040201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000010101020203040405
494A48433C33281E140C060507090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B
0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B
0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0A0A090908090B0D11161B21272D313333312D28
221B150F0B07040201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000010101020303040405
4D4F4E49433A30261C140E0C0D0F10111111111111111111111111111111111111111111
111111111111111111111111111111111111111111111111111111111111111111111111
1111111111111111111111111111111110100F0F0F1012151A1F252B3136393B3A38332D
261E18110C08050302010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000010101020303040405
525554514C443A30271F1A1716171819191A1A1A1A1A1A1A1A1A1A1A1A1A1A1A1A1A1A1A
1A1A1A1A1A1A1A1A1A1A1A1A1A1A1A1A1A1A1A1A1A1A1A1A1A1A1A1A1A1A1A1A1A1A1A1A
1A1A1A1A1A1A1A1A1A1A1A1A1A1A191919181818191A1D20252A31373C414444433F3A32
2B221B140E0A060402010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000010101020303040405
575B5C5B564F473E352D2825232324242525252525252525252525252525252525252525
252525252525252525252525252525252525252525252525252525252525252525252525
252525252525252525252525252525242424242425272A2E33393F454A4E50504D484139
30271F17110B070503010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000010101020303040405
5D626565625D564E463F3936343333333334343434343434343434343434343434343434
343434343434343434343434343434343434343434343434343434343434343434343434
343434343434343434343434343433333333333436383C40454B50565A5D5E5C59534B41
372D231B140E090603020100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000010101020303040505
636A6F71706C67615A534E4A484646464646464646464646464646464646464646464646
464646464646464646464646464646464646464646464646464646464646464646464646
46464646464646464646464646464646464647484A4D50555A5F64696C6E6E6B665E554A
3F34292017110B0704030101000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000010101020303040505
6972787C7E7D79756F6A65625F5D5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C
5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C
5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5D5E5F6164686C71767A7E80807F7B746B6155
483C30251C140E0906040201000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000010102020303040505
6E7982888C8D8C8986827E7B787776757574747474747474747474747474747474747474
747474747474747474747474747474747474747474747474747474747474747474747474
74747474747474747474747474747575757677797B7E81858A8E91949594918B847A6E60
5345382C2118110C08050302010000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000010102020303040505
74808B949A9D9F9E9D9A9895939291908F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F
8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F
8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F909091929496999CA0A3A6A8AAAAA8A39D94887B6D
5E4F4133281E160F0A070402010100000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000010102020304040505
7987939EA7ADB0B2B3B2B1AFAEADACABABABABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAABABABABACADAEB0B1B4B6B9BBBDBFBFBEBBB5AEA4988A7B
6B5A4B3C2F241B130D090604020101000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000010102020304040505
7C8C9BA7B2BAC0C4C6C7C8C7C7C6C6C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5
C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5
C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C6C6C7C8C9CBCCCED0D1D2D3D2D0CCC6BEB3A79888
78675647382C2118110C0805030201000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000010102020304040506
7F90A0AEBBC5CDD3D7DADBDCDDDDDDDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDC
DCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDC
DCDCDCDCDCDCDCDCDCDCDCDCDCDCDDDDDDDEDEDFE0E1E2E3E3E3E3E1DEDAD4CBC1B5A696
857463524235291F16100B08050302010000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000010102020304040506
8193A4B3C1CCD6DEE3E7EAECEDEEEEEEEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEF
EFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEF
EFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFF0F0F0F0F0F0F0EFEDEBE8E4DED6CCC1B3A4
9381705E4E3F32261D150F0B070503020101000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000010102020304050506
8194A5B5C4D1DBE4EBF0F4F6F8F9FAFAFAFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFB
FBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFB
FBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFAFAFAF9F9F8F7F5F4F2EFECE8E3DDD5CABEB0
A08F7D6B5A4A3C2F241B140F0A0705030201010000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000010102020304050506
8093A4B5C4D1DCE5EDF2F7FAFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFCFBFAF8F6F4F2EFEDEAE7E4DFD9D0C6BA
AC9C8B796857473A2D231B140E0A07050302010100000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000010102030304050506
7E90A1B2C1CED9E2E9EFF3F6F8FAFBFBFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFC
FCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFC
FCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFBFBFAF9F7F6F3F1EEEBE8E5E3E1E0DEDBD8D3CBC2
B6A8988776655445382C221A140E0A070503020101000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000010102030304050606
7A8C9CACBAC7D1DAE1E6EAECEEF0F0F1F1F1F1F2F2F2F2F2F2F2F2F2F2F2F2F2F2F2F2F2
F2F2F2F2F2F2F2F2F2F2F2F2F2F2F2F2F2F2F2F2F2F2F2F2F2F2F2F2F2F2F2F2F2F2F2F2
F2F2F2F2F2F2F2F2F2F2F1F1F1F1F1F0F0EFEDECE9E6E3DFDBD8D5D3D2D2D2D3D2D1CDC7
BEB2A4958473625344372C221A140F0B0805040302010100000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000010102030304050606
768696A4B1BCC6CDD3D7DBDDDEDFE0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0
E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0
E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0DFDEDDDCDAD7D4D0CBC7C2BFBDBDBEC1C5C8CBCBC8
C3BAAFA2928272615244372C221B140F0B08060403020101000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000010102030404050607
707F8D9AA6AFB7BDC2C5C7C8C9CACACACACACACACACACACACACACACACACACACACACACACA
CACACACACACACACACACACACACACACACACACACACACACACACACACACACACACACACACACACACA
CACACACACACACACACACACACACAC9C9C9C8C7C6C4C1BDB9B3AEA9A5A2A3A6ABB2BAC0C5C7
C6C1B9AEA0918171615244372D231C15100C090705030201010100000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000001010102030405050607
6977838F99A0A6ABAEB0B1B1B1B1B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0
B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0
B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0AFAEADABA9A5A09A948D8885868A929DA8B3BCC3
C6C5C0B8ADA0918171615245382E251D16110D0A07050403020101000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000001010202030405060607
626E79828A90949798989898979696959595959595959595959595959595959595959595
959595959595959595959595959595959595959595959595959595959595959595959595
9595959595959595959595959595959595949492908C87817A726B67676D778595A4B1BC
C3C6C6C1B9AEA09182726254463A2F261E18130E0B080604030202010100000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000001010202030405060607
5A656E757B7F818282817F7E7D7C7B7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A
7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A
7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7B7B7A7A7875706A6259504A49505D6E8194A5B4
BFC6C9C8C3BAAFA29383746456493C3228211A14100C0907050403020101000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000001010202030405060707
535B63686C6E6F6E6C6A6765646262616161616160606060616161616161616161616161
616161616161616161616161616161616161616161616161616161616161616161616161
6161616161616161616161616161616262636363625F5C564E4439302D3545596F8599AB
B9C3CACCCAC5BCB1A495867667594B3F352B231C16120E0B080605030202010100000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000001010202030405060708
4B52585C5E5E5D5A5754514F4D4C4B4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A
4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A
4A4A4A4A4A4A4A4A4A4A4A4A4A4B4B4B4C4D4E4E4E4D4A463E34281B141F334A61788EA2
B2BFC9CED0CDC8BFB4A69889796B5C4F43382E261F1914100C0A07060403020201010000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000001010203030405060708
44494D50504F4C4945413D3B393837373737373737373737373737373737373737373737
373737373737373737373737373737373737373737373737373737373737373737373737
37373737373737373737373737373838393A3B3D3E3E3C39332B1F1100142940576E8499
ABBAC6CED2D3D1CBC2B7AA9B8D7D6F6053473C3229221C16120E0B090705040302010101
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000001010203040506060708
3D41444544413D3934302D2A292827272828282828282828282828282828282828282828
282828282828282828282828282828282828282828282828282828282828282828282828
28282828282828282828282828282828292A2C2E303131302C261E151019293D52677C90
A3B3C1CBD2D6D7D4CEC5BAADA091827365584C40362D261F1914100D0A08060504030201
010100000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000001010203040506070808
373A3B3B3935312C27221F1C1B1B1B1B1B1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C
1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C
1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1E1F22242628282724201C1C222E3D4F627588
9AABB9C6CFD6D9DAD7D1C9BEB2A49687796B5E51463B322A231D17130F0C0A0806050403
020101010000000000000000000000000000000000000000000000000000000000000000
0000000000000000000001010203040506070809
31333332302B26211C171412111112121213131313131313131313131313131313131313
131313131313131313131313131313131313131313131313131313131313131313131313
13131313131313131313131313121212131415181B1E2022232322212329323E4D5D6E7F
90A1B0BEC9D2D9DCDCDAD4CCC2B7A99C8D7F7164574B41372F27201B16120F0C09070604
030302010101000000000000000000000000000000000000000000000000000000000000
0000000000000000000001010203040506070809
2C2D2D2B28231E19130F0C0A0A0B0B0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C
0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C
0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0B0B0C0E1013171A1D20212324272C343E4A586676
8695A5B3C0CBD4DBDEDFDDD8D0C7BCAFA29486786A5E52473D342C251F1A15110E0B0907
060403030201010100000000000000000000000000000000000000000000000000000000
0000000000000000000001020203040506080909
27282725221D18130D090605050607070808080808080808080808080808080808080808
080808080808080808080808080808080808080808080808080808080808080808080808
080808080808080808080808080707070607080A0E1115191C1F2225282D343C46515E6B
7A8897A6B4C1CCD5DCE0E1DFDBD4CCC1B5A89B8D7F7265594E433A322A231E1914110E0B
090706050403020201010000000000000000000000000000000000000000000000000000
000000000000000000010102020304050708090A
232423201D18130E0A050201020404050505050505050505050505050505050505050505
050505050505050505050505050505050505050505050505050505050505050505050505
05050505050505050505050505040404030304060A0D1115191D2024272C32384049545F
6C7A8897A6B4C1CCD6DDE1E3E2DED8D1C7BCAFA295877A6D61554B41383029221D181411
0E0B09070605040302020101010000000000000000000000000000000000000000000000
000000000000000000010102020305060708090A
20201F1C1915100C08040100020203030303030303030303030303030303030303030303
030303030303030303030303030303030303030303030303030303030303030303030303
0303030303030303030303030303020201000204070B0E12161A1E2125292E3339404953
5E6A788796A5B3C0CCD5DDE2E4E4E1DDD5CCC2B6AA9D908376695D52483F362F28221D18
14110E0B0908060504030202010101000000000000000000000000000000000000000000
0000000000000000000101020304050607080A0A
1D1D1C1916120E0B07040202020202020201010101010101010101010101010101010101
010101010101010101010101010101010101010101010101010101010101010101010101
010101010101010101010101010201010100010306090C1014171B1E2225292C31363D45
4F5A67768494A3B1BFCAD5DDE2E5E6E4E0DAD2C9BEB2A5998C7F72665B50473E352E2822
1D1814110E0C0A0806050403030201010101000000000000000000000000000000000000
0000000000000000000101020304050608090A0B
1A1A191714110D0A07050302020201010101000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000101010101010101020305080B0E1215181B1E212325282C3138
404B5764738291A0AFBCC9D3DCE2E6E8E7E4DFD8CFC5BAAEA295897C7064594F463D352E
28221D1915110F0C0A080705040403020201010100000000000000000000000000000000
0000000000000000000101020304050708090A0B
18181715120F0C0907050302020101000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000001010101020305070A0D101316181A1C1D1E2022252B
323C475361707F8E9DACBAC6D1DAE1E6E9E9E7E3DDD6CDC2B7AB9F93867A6E63594F453D
352E28221E1915120F0D0B09070605040302020101010100000000000000000000000000
00000000000000000001010203040507080A0B0C
17161513110E0B0907050302020101000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000001010102030507090C0E1113151718181818181A1F
262E3944515F6D7C8B9AA9B6C3CED8E0E5E9EAEAE7E2DCD4CAC0B5A99D9185796E63584F
463D362F29231E1A1613100D0B0908060504030302020101010000000000000000000000
00000000000000000001010203040607090A0C0D
15151412100D0B0806050302010100000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000010102030506080B0D0F11131414131210101115
1B232C37424F5C6A798796A4B2BFCBD5DDE4E9EBECEAE7E1DAD2C9BEB3A89C9084796E63
594F473E37302A24201B1714110E0C0A0807060504030302020101010000000000000000
00000000000000000001010203050608090B0C0D
141312110F0C0A0806040302010100000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000010102030406080A0C0E101111110F0D0B09090D
131A222C36414D59677583919FADBAC6D1DAE2E7EBEDECEAE6E1DAD1C8BDB3A79C908579
6E645A51484038322C26211D1915120F0D0B090806050404030202010101010000000000
000000000000000000010202030506080A0B0D0E
121211100E0C0A0806040302010100000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000001010203040607090B0D0E0F0F0E0D0A07030308
0D141B232B343F4A5662707E8C9AA8B5C1CCD6DFE5EAEDEEEDEAE6E0D9D1C7BDB2A79C91
857A70655C524A423A342D28231E1A1713110E0C0A090706050403030202010101010000
000000000000000000010203040507080A0C0D0F
1111100F0D0B090705040302010100000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000001010203040507090A0C0D0E0E0D0B0906030206
0B10151B222A323C46515E6B788694A1AFBBC7D1DAE2E8ECEEEFEEEBE6E0D9D1C7BEB3A8
9D92877C72675E554C443D36302A25201C181512100D0B0A080706050403030202010101
010000000000000000010203040507090B0C0E0F
10100F0E0C0B090705040302010000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000001010203040507080A0B0C0C0C0C0A0907050507
0A0D11161B21272F38424D5865727F8D9AA8B4C0CBD5DEE5EAEEEFF0EEEBE6E1D9D1C8BE
B4AA9F94897E746A61574F473F39322C27221E1A1714110F0D0B09080705050403030202
010101010000000000010203040607090B0D0F10
100F0F0D0C0A080705040202010000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000101020304050608090A0B0C0C0B0A0908070708
090B0E1114191E242C343E48535F6B788693A0ADB9C5CFD8E0E7ECEFF0F0EFECE7E1DAD2
CAC0B6ACA1968C81776D645B524A433C352F2A25211D191613100E0C0A09080605040403
0302020101010000010102030506080A0C0E1011
0F0F0E0D0B0A080605030202010000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001020203050607080A0B0B0B0B0A0908070708
08090B0C0F12161C22293039434D5965717E8B98A5B1BDC8D2DBE2E8EDF0F1F1EFECE8E2
DCD4CBC2B8AEA49A8F857B71685F564E463F39332D28231F1B181512100E0C0A09070605
0404030202010101010203040506080A0C0F1112
0E0E0D0C0B09080605030201010000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000102020304060708090A0A0B0A0A0908080707
070708090A0D1014191F252D353E48525E6A7683909CA9B5C0CBD4DDE4EAEEF1F2F2F0ED
E9E4DDD6CEC5BBB1A79D93897F756C635A524B433D36312B27221E1B1714120F0D0C0A09
0706050404030302030304040507080A0D0F1214
0E0D0D0C0A09070604030201010000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000101020304050608090A0A0A0A0A0908080706
0605050607090B0E12171C22293039424C57626E7A86939FACB7C2CDD6DEE5EAEFF1F3F3
F1EEEAE5DFD8D0C8BFB5ABA1978E847A71685F574F48413B352F2A26211D1A1714120F0D
0C0A090706050505040505050506080A0D101315
0D0D0C0B0A08070504030201010000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000010102030405060708090A0A0A090908070605
040303030406080A0D1115191F252C333C454F5A65717D8996A2AEB9C4CED7DFE5EBEFF2
F3F3F2F0ECE7E1DBD3CBC2B9B0A69C93897F766D645C544D463F39332E2925211D1A1714
110F0D0C0A090807070606050405070A0E121517
0C0C0C0B0908070504030201010000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001010203040506070809090909090808070604
0302010102030507090C0F12171B21272E363F48525D68747F8B97A3AFBAC4CED7DFE5EB
EFF2F4F4F3F1EEE9E4DED7CFC6BEB5ABA2988F857C736A625A524B443E38332D2924211D
1A171412100E0C0B0A0807050303070B0F13171A
0C0C0B0A0908060504030201010000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001010203040506070808090909090807060504
030100000102030506080A0D1014181D232A3139414B545F6A75818D99A4AFBAC5CED7DF
E5EBEFF2F4F5F4F2EFEBE7E1DAD3CBC2BAB1A79E958B827971686058514A433D37322D29
24211D1A171512100E0C09050202070D12161A1D
0B0B0B0A0907060504030201010000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001010203030405060708090909080807060504
0201010101020203040507090B0E12151A1F252B333A434C56606B76828D99A4AFBAC4CD
D6DEE4EAEFF2F4F5F5F4F1EEE9E4DED7CFC7BFB6ADA49B928980776F675F575049433D37
322D2925211E1A1714110D0906070B10161B1F21
0B0B0A090807060504030201010000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001010202030405060708080808080706050403
020201010101020203040506080A0C0F13171B20262D343C444D57616C77828D98A4AEB9
C3CCD5DDE3E9EEF2F4F5F6F5F3F0ECE7E2DBD4CDC5BCB4ABA29990877F766E665E575049
433D38332E2925211D1814110F0F12171C212427
0B0A0A090807060503020201010000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001010202030405060707080808080706050403
0302010101010101020203040507080B0D1014181C21272E353D454E57616C76818C97A2
ADB7C1CAD3DBE2E8EDF1F4F5F6F6F4F2EFEAE5E0D9D2CBC3BAB2A9A0988F867E756D665E
57504A433E38332D28241F1C1A1A1D2125292C2D
0A0A0A090807060403020201010000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001010202030405060707080808070706050403
03020101010000000101020203040607090B0E1114181D22282E353D454E57616B75808B
96A0ABB5BFC8D1D9E0E6EBF0F3F5F6F7F6F4F1EEE9E4DED8D0C9C1B9B1A89F978E867E75
6D665E57514A443E38322E2A28282A2D30333535
0A0A09090806050403020201010000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001010202030405060607070807070706050403
020201010000000000000101020303050607090C0E1115191D22282E353D454D56606A74
7E89939EA8B2BCC5CED6DDE4E9EEF2F5F6F7F7F6F4F1EDE8E3DDD6CFC8C0B8B0A89F978E
867E766E665F58514B45403C3A393A3C3E3F3F3E
0A0A09080706050403020101000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001010102030405050607070707070606050403
02020101000000000000000101020203040506080A0C0F1215191D22282E353C444C555E
68727C86909BA5AFB9C2CBD3DAE1E7ECF0F3F6F7F7F7F5F3F0ECE7E2DCD6CFC7C0B8B0A8
9F978F877F776F68615B56514F4D4C4D4D4C4B48
090909080706050403020101000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102030404050607070707070605050403
020201010000000000000000000101020203040506080A0C0F1215191D22282D343B434B
535C656F79838D97A1ABB5BEC7CFD7DEE4E9EEF2F5F7F8F8F7F5F3F0ECE7E2DCD6CFC8C0
B8B0A8A0989088817A736E696563615F5E5B5853
090909080706050403020101000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102030304050606070707060605050403
0202010100000000000000000000010101020203040506080A0C0F1215191D22272D333A
41495159626C757F89939DA7B0B9C2CBD3DAE0E6EBF0F3F6F7F8F8F7F5F3F0ECE7E2DCD6
CFC8C1B9B2AAA29B948D87827D7A76736F6B655F
090908080706050403020101000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102030304050606070707060605040403
02020101000000000000000000000000010101020203040507080A0C0E1115181C21262B
31383F464E565F68717B858E98A2ABB4BDC6CED5DCE3E8EDF1F4F6F8F8F8F7F6F3F0ECE7
E2DDD7D0C9C3BCB5AEA7A19B96918C87817B736A
090808070706050403020101000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102030304050506060606060605040403
020101010000000000000000000000000000010101020203040506080A0C0E1114171B20
252A30363C444B535C646D768089939CA6AFB8C0C9D0D8DEE4E9EEF2F5F7F8F9F9F8F6F3
F0ECE8E3DED8D2CCC6BFB9B3ADA7A19A928A8076
080808070605040403020101000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102020304050506060606060505040303
0201010100000000000000000000000000000000010101020203040506080A0B0E101317
1A1E23282E333A414850586069717B848D97A0A9B2BBC3CBD2D9E0E5EAEFF2F5F7F9F9F9
F8F6F4F1EDE9E5E0DAD5CFC9C3BCB4ACA3988D80
080808070605040303020101000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102020304050506060606060505040303
0201010000000000000000000000000000000000000001010102020304050608090B0D10
1216191D21262B31373D444C535B646C757E879099A2ABB4BCC5CCD4DAE0E6EBEFF3F5F7
F9F9F9F8F7F5F2EEEAE6E1DBD4CDC5BBB1A5988A
080807070605040303020101000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102020304040506060606060505040303
02010100000000000000000000000000000000000000000001010102020304050607090B
0D0F1214181B2024292E343A41484F565E676F78818A939CA4ADB6BEC6CDD4DBE1E6EBEF
F3F5F7F9F9F9F8F7F4F1EDE8E2DBD2C8BCB0A192
080807070605040302020101000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102020304040505060606060505040302
020101000000000000000000000000000000000000000000000001010102020304050607
080A0C0E1013161A1E22262B31363D434A51596169717A838B949DA6AEB6BEC6CED4DBE1
E6EBEFF2F5F7F8F8F8F6F4F0EAE3DBD1C5B7A898
080707070605040302020101000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102020304040505060606050504040302
020101000000000000000000000000000000000000000000000000000101010202030304
050608090B0D0F1215181C1F24282D33393F454C535B636B737C848D959EA6AFB7BFC6CD
D4DAE0E5EAEEF1F3F5F5F4F1EDE7E0D6CABDAD9D
070707060605040302020101000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102020303040505050606050504040302
020101000000000000000000000000000000000000000000000000000000010101010203
0304050607090A0C0E111316191D21252A2F353A41474E555C646C747C858D969EA6AEB6
BEC6CDD3D9DFE4E8EBEDEEEDEBE6E0D7CCBFB09F
070707060605040302020101000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102020303040505050605050504040302
020101000000000000000000000000000000000000000000000000000000000000010101
0202030404050708090B0D0F1214171B1E22272B30363C42484F565D656D757D858D959E
A6AEB6BDC4CBD2D7DCE0E3E4E3E0DBD4CABEAF9F
070707060505040302020101000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102020303040505050505050504040302
020101000000000000000000000000000000000000000000000000000000000000000001
01010202030304050607090A0C0E101315181C1F23282C31373C43494F565E656D747C84
8C959DA5ADB4BCC2C9CED2D5D6D6D2CDC4BAAD9D
070707060505040302020101000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010101020303040405050505050504030302
020101000000000000000000000000000000000000000000000000000000000000000000
00010101010202030404050608090B0D0F111316191D2024282D32373D434950565D656C
747C838B939BA3ABB2B9BFC3C6C8C6C3BCB3A89A
070706060504040302020101000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010101020303040405050505050504030302
020101000000000000000000000000000000000000000000000000000000000000000000
000000000101010202030304050607080A0B0D0F1114171A1D2125292D32373D43494F56
5D646B737A828A929AA2A9AFB4B7B8B6B2ABA195
070706060504040302010101000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010101020303040405050505050404030302
020101000000000000000000000000000000000000000000000000000000000000000000
000000000000010101010202030304050607080A0C0D0F1214171A1D2125292D32373D42
484E555C636A727A828A92999FA4A7A8A5A0988E
070706060504040302010101000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010101020303040405050505050404030302
020101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000010101020202030404050607090A0C0E101214171A1D2125292D32
373C41474D545B626A737B838A91959898958F86
070606060504030302010101000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010101020203040405050505050404030302
020101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000010101020203030405050608090A0C0E101214171A1D2024
282C31363B41474D555D656D767D83888A89857E
060606060504030302010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010101020203040404050505050404030302
020101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000001010101020203030405060708090A0C0E101214171A
1D2023272B30353B41495159626A72787B7C7A75
060606050504030302010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010101020203040404050505050404030302
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001010101020203030405060708090A0C0E0F12
1416191C1F23272B31373F47505961686D70706D
060606050504030302010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010101020203030404050505040404030302
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000001010101020203030405060708090A0C
0D0F111315181B1F23292F374049525A60646664
060606050504030302010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404050505040404030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000001010101020203030405050607
090A0B0D0E101215181D232A333C454D555A5C5C
060606050504030302010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404050505040404030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000001010101020203030405
05060708090A0B0D1013181F273039424A505354
060606050504030202010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040505040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000001010101020203
0304040506060708090C10171E27303941474B4D
060606050504030202010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040504040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000001010101
020203030304040405070B101720283139404547
060606050404030202010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000001
01010102020202020203070C131A222B33393F41
060605050404030202010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000101010101010002050A10161E262E34393D
060605050404030202010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000001010101010205090E141B2229303539
060605050404030202010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000010101020305080D12191F262D3235
060605050404030202010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000101020305080C11171D242A2F32
060605050404030202010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000101020305080C10161C22282C30
060605050404030202010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000101020405080C10151B20262A2E
060505050404030202010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000101020405080B10141A1F24292C
060505050404030202010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010100000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000101020405080B0F14191E23272B
060505050404030202010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030304040404040403030202
010100000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000101020405080B0F13181D22262A
060505050404030202010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030304040404040403030202
010100000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000101020305080B0F13181D212629
050505050404030202010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030304040404040403030202
010100000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000101020305080B0F13171C212528
050505050404030202010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030304040404040403030202
010100000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000101020305080B0E13171C202427
050505050403030202010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030304040404040403030202
010100000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000101020305080B0E12171C202427
050505050403030202010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030304040404040403030202
010100000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000101020305080B0E12171B202326
050505050403030202010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030304040404040403030202
010100000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000101020305080B0E12171B202326
050505050403030202010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030304040404040403030202
010100000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000101020305080A0E12171B1F2326
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  InitializationCell->True,
  ImageSize->{288, 177.938},
  ImageMargins->{{281, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40n007h00Oooll8Oll003ooc`Q
oc`00?oo?27o?000ooll8Oll003ooc`Qoc`00?oo?27o?000ooll8Oll003ooc`Qoc`00?oo?27o?000
ooll8Oll003ooc`Qoc`00?oo?27o?000ooll8Oll003ooc`Qoc`00?oo?27o?000ooll8Oll003ooc`Q
oc`001Wo?08003Wo?0<000Co?08003?o?0@000?o?08000Co?080033o?0@000;o?0<000Co?080033o
?0@000?o?08000Co?08000?o?0006?ll00@00?lloc`003_o?004003o??ll0002oc`00`00occo?00b
oc`01@00occo??ll00000_ll00@00?lloc`000;o?003003o??ll02oo?003003o??ll00Co?004003o
??ll0002oc`00`00occo?00]oc`00`00occo?003oc`01000occo?0000_ll00@00?lloc`000;o?000
6?ll00@00?lloc`003_o?004003o??ll0002oc`00`00occo?00boc`01@00occo??ll00000_ll00@0
0?lloc`000;o?003003o??ll02oo?003003o??ll00Co?004003o??ll0002oc`00`00occo?00^oc`0
0`00occo?002oc`01000occo?0000_ll00@00?lloc`000;o?0006?ll00@00?lloc`003So?0<000?o
?004003o??ll000doc`01@00occo??ll00000_ll00@00?lloc`000;o?003003o??ll02oo?004003o
??lloc`30003oc`01000occo?000<Oll00D00?llocco?00000;o?004003o??ll0002oc`10001oc`1
oc`001So?004003o??ll000hoc`00`00occo?003oc`01000occo?000=?ll00D00?llocco?00000;o
?004003o??ll0002oc`00`00occo?00_oc`01@00occo??ll00001Oll00@00?lloc`003;o?004003o
??ll0002oc`01000occo?0000_ll0@000Oll0Oll000Hoc`01000occo?000>?ll00<00?lloc`00oll
00@00?lloc`003;o?0<000?o?004003o??ll0002oc`01000occo?000;oll0`000oll00<00?lloc`0
0oll00@00?lloc`002oo?004003o??ll0002oc`01000occo?0000_ll00@00?lloc`000;o?0006Oll
0P00>Oll10000oll0P00=Oll00<00?lloc`00_ll0P001?ll0P00<_ll00@00?llocco?0@000?o?080
037o?08000Co?08000Co?08000?o?000ooll8Oll003ooc`Qoc`00?oo?27o?000ooll8Oll000>oc`2
0005occo00080004oc`000go?004003o??ll0004oc`00`00occo?002oc`00`00occo?009oc`00`00
occo?00:oc`00`00occo?00:oc`00`00occo?009oc`00`00occo?00:oc`00`00occo?009oc`00`00
occo?00:oc`00`00occo?009oc`00`00occo?00:oc`00`00occo?00:oc`00`00occo?009oc`00`00
occo?00:oc`00`00occo?009oc`00`00occo?00:oc`00`00occo?00:oc`00`00occo?009oc`00`00
occo?00:oc`00`00occo?009oc`00`00occo?00:oc`00`00occo?00:oc`00`00occo?002oc`00`00
occo?002oc`000go?004003o??ll0004oc`2003ooc`3oc`30004oc`000go?004003o??ll0004oc`0
0`00occo?002oc`2>NL2>LL00c6V:FDQ90026><00a2R4888H@022442021Z000202000`Q1264@PP02
4:800aSS8@@Q10038@@01QSS6<<@XQ2R2648@@<086T000<080Go?003003o??ll00;o?0003Oll00@0
0?lloc`000Co?003003o??ll00;o?08ii`8ia`03<JHYIB4T008Hh`034:8@PPQQ0088@@8086X00080
80032448HA22008@XP036><Q124400<Q10066><H`a2R4:88H@Q10`0PJ@000`0P1Oll00<00?lloc`0
0_ll000=oc`01000occo?0001?ll00<00?lloc`00_ll0SWW0SW700<aYRUU8B@00QSS00<@XQ222440
0PQ10`0PJ@000P0P00<8@@QQ48800QS300<Hhb448@@00b4400DHhaS34:8@XPQQ00<8@@0302000000
06L000<080Go?003003o??ll00;o?0003_ll0P001Oll00<00?lloc`00_ll0T880SWW00<aYS668B@0
0QSS00<@XPQQ24401`0PIP000`0P00<8@A224:800QSS00<Q124T8B@00R4T00<Q11SS6<<00Q2R00D@
PPQQ2448@@0P06T000<080Go?003003o??ll00;o?0005Oll00<00?lloc`00_ll0T880SWW00<iac66
:DD00R4400<@XPQQ24400P0P00<0000P0200H00P1`000P0P0PQ100<8HA2R6<<00R4400<Q92U5:DD0
0RU500<Q92446><00Q2R00D@PPQQ2448@@0P06T000<080Go?003003o??ll00;o?0005Oll00<00?ll
oc`00_ll0T8X0T8800<iic6V:FD00R4400<H`a2224400`00J@0P0PQ10PQQ00<@XQS38@@00R4T00<Y
ABUU:FD00RUU00<YAB4T6><00QS300@@PPQQ2448@@8086P000<080Go?003003o??ll00;o?0005Oll
0P000oll0T8X0T8800<iic6V:FD00R4400<H`a2224400`00J@0P0PQ10PQQ00<@XQS38@@00R4T00<Y
ABUU:FD00RUU00<YAB4T6><00QS300@@PPQQ2448@@8086P000<080Co?08000Co?0005Oll00<00?ll
oc`00_ll14Y900=223WW<HH00RU500<Hha2R2640100PJ0Q100L8HA224:8@XQS38@@Q9002:FD5<HH0
0bUU:DDQ10026<<0112R2648@@Q10P0PJ0000`0P1Oll00<00?lloc`00_ll000Eoc`00`00occo?002
oc`4BVT00dY9@PPia`02<HH00b4T6><@XP05265P4884264348801a2R6<<HhaSS8B@YAC66008aYPDi
a`03<HHYIB4T008Hh`066<<@PPQQ2648@@0PJ0000`0P1Oll00<00?lloc`00_ll000Eoc`00`00occo
?002oc`01e::DZYBZU:ZDXY:JD8X008ia`03<HHQ91SS008H``<@XVHH``036><Q124T008YA@03<HHa
YSWW00922092:006@PPiicWW>LLaQRU50R4400DH`a2R2648H@Q1008086L000<080Go?003003o??ll
00;o?0005Oll00<00?lloc`00_ll00MBZU[;F^]Jje[;DZY:J@02@RP00cWW<JHYI@02:DD00b4T8@@Q
101V8B@00bU5:FDaQP02>LL00cWW@RQ:B@02BVT2DXX01TYYBTU:BD88>LLaQP8Q90056><@XQ224888
@@02021W00030205oc`00`00occo?002oc`001Go?003003o??ll00;o?007DZYJbe[[F^]Jbe:ZBVT0
0T8X00<iic6V:FD00RU500<Q92448@@0IR4T00<YABUU<HH00SW700<iid8XBTT00TYY0U::00I:JDY9
BTU223W7<HH28B@01ASS4:8@PQ2224400P0PI`000`0P1Oll00<00?lloc`00_ll000Eoc`20003oc`0
0e[[H`aS;002Hb`01f<<F^]BZU:ZBVU2:3WW008ia`8aYPDaQULaYPLaQP8aYP8ia`03>NM2248X009:
B@03DXYBZU[;00AJj`06F/]BRU::BTU2236V0RUU00LQ11S34:8@XPQQ2440801W00030204oc`20004
oc`001Go?003003o??ll00;o?004H`a[CF]]Jfd2Lhh01V]]HbaS;6<<F/]BRP9:J@9:BF=2:09:B@9:
J@03DXYBZU[;009Jj`03Hba[CF]]00=[K@07JdeS;5[[F^]BZTY9>NL00S6V00HYAB444:8@XQ222443
021U00030205oc`00`00occo?002oc`001Go?003003o??ll00;o?004JdecSW_?Nll3Nnl2Nll00g>^
Jfe[C@02Hb`00f<<F^]Jj`1SF^/01V<<HbaS;6]=JfecSP9c[P03Nlmkkh@@00:44003Nnmkcg>^009[
C@03H`aBZTY9008ii`07<HHQ91SS6><@XPQQ24400`0PI0000`0P1Oll00<00?lloc`00_ll000Eoc`0
0`00occo?002oc`01F]]Nln448@@S54018aa00><DH@`Q1000W__0W_?Hg>^0W_?0W__00>448@`S540
0Xaa00>DTYBbU;800YBb00>DTXaAQ3000W_?00=[KF<<DXX00T8X00LiabUU8@@Q11S34888H@022440
0`0P0000001R00030205oc`00`00occo?002oc`001Go?003003o??ll00;o?005Jfekch@@Q12<D@04
S7400haAQ3244002Nnl2NlmSLjh2Nll2Nnl00h@@Q32<D@02S7400iBBU;:D/P02U;800iBBS564<002
Nll00f]]H`aBRP02@RP01cW7:FDQ12446<<@PPQQ0088@@0302000000068000<080Go?003003o??ll
00;o?0005Oll00<00?lloc`00_ll00Ic[X@@S56<DIBbW=<5W?<3W=<00iBbU9:DTP03U99JS745U982
U;82W=<00iccYABU5002YC@5[ED00jDDW?>D/P02S5400g_?JfeJj`02BVT01d88<HHYABU56><@XPQQ
0088@@80864000D080Go?003003o??ll00;o?0005Oll0P000oll00Mkch@`U9:DTYccYCB]M@07]IH5
[GEL[ED4[GD2]IH3]KH2_ML5_OL2_ML00kFf[GFU=002W=<00haANlm[C@02F//01dY9>NLYIBUU8B@H
`a220088H@032440800P060000D080Co?08000Co?0005Oll00<00?lloc`00_ll00MkkhaaW=>LdjDd
]IJme`02aQP3aSP2cUUSaSP4cUT3cWT7eYX2cWT00lHh_ONeUP02YC@00icCS55kc`02Hb`01e:Z@RPi
acW7:FDQ11S3008@PP032648@@0P060000D080Go?003003o??ll00;o?0005Oll00<00?lloc`00_ll
00MkkiBBYABU5:ee_MO6>002cWT00mJJe[[Nf`02g]]Vg_/:ia`01]kkg]_NfmJjcUW660:e]P03YCBD
/X@`009c[P07H`aBRT88@PPaYRU56><00Q2R00<@PPQ124400P0PGP001@0P1Oll00<00?lloc`00_ll
000Eoc`00`00occo?002oc`01g__U9:U5:DD[GFmelHh00;>N@03eY[F^]kK00;NffKNn`[W7006g__N
fmkKe[[>FLHH0[Ff00>U=9BbQ3000W>^00MS35::@PQ2236V:DDHh`024:800a222448@@02021N0005
0205oc`00`00occo?002oc`000Oo?0@000?o?08000Go?003003o??ll00;o?007Q12DTZDdYCBeU/HH
cWT00]Jj00?NnnLLic`00^mMHnmm2ONN0nmm0^mM0^Ll00?NnmJjcWT00/HH00>eUZDdU9800X@@00Mc
SU[[BVU:JCWW<HHQ90026><00a2R2648@@03021M00050205oc`00`00occo?002oc`000Oo?003003o
??ll00?o?004003o??ll0004oc`00`00occo?002oc`01h@@U;:U=:Dd]KK6>=JJ00;Nf`03icc_GONN
00?g_VWog`Cg_P03mik_ONmm00;_G@03iacNnmJj00;>F@03_ONeUZDD00:<L@07Nnm[CE[;F/]:BCWW
:FD00R4T00<H`a2R26400PQ10P0PG0001@0P1Oll00<00?lloc`00_ll0008oc`00`00occo?002oc`0
1000occo?0001?ll0P000oll00N449BBYCBU=;FfaSSFVP02g_/00nLlkgggWP02mkh00ooOooooo`1S
ool4oml2mkh2mih2kgd01^mMiccW?>Llg__Nf`;FVP03aSRmejee00:Ll`07S55kcf]=JdeBZT8X>LL0
0RUU00<Q11S34:800PQQ00<8@@0P0200F`001@0P0oll0`001?ll0009oc`01@00occo??ll00000_ll
00<00?lloc`00_ll00<00?lloc`00_ll00MkkiBBYABU5;FFaQS>N@02g]/00nLLkeg_O@02mih00oNn
omoog`03ommJool5oml2mkh3mih01Nmmkeg_GNmMic`01>LL00?NnmkKg]/00]JJ00?>FLHH]KH00ZeE
00NLdh@`Ljic[V</DZY2:002>LL00bUU8@@H``024:800`QQ24408002021I00050205oc`00`00occo
?002oc`000[o?004003o??ll0002oc`00`00occo?002oc`00`00occo?002oc`01g__U9:U5:DD]IK6
6<ii00;Nf`03iac_GNmm00;gWP03mkkogooO00?oge[oo`Gog`;g_P?gWP05kgg_GNmMkegW?004ia`0
0mkkg]_Nf`02eYX00liIaQRe]P02[ED01icCQ31c[W>^HbaBZT8X008ia`03:FDQ11S3008@XP032648
@@0P008085T000D080Go?003003o??ll00;o?0001oll00@00?lloc`000;o?004003o??ll0004oc`0
0`00occo?002oc`01g_?S76Llicc[GFmelHh00;FVP03g]_W7>Ll00;_G@;_OF3gWPC_O@05kegW?>Ll
iacNn`03g]/00mJjeY[FVP07eYX00liiaSRmm`02]IH01jDdU;:4<8@`LhiS35::0092:003<JHYIB44
008H``034:88H@Q10088@@8085L000D080Go?003003o??ll00;o?0002?ll0P001?ll0P001Oll00<0
0?lloc`00_ll00Mc[X@`U;:D/ZDd]IJmm`02aSP00liieY[F^P02g]/3g_]Mia`5g_/01mkKe[[F^]Jj
eY[>FLHh00;660Fmm`03aQS6><iI00C>F@05aQRmekgG[GFU5002U9800h@@LhiS3002DXX00d8X<JHY
I@028@@00aS34:88H@032443021D00060205oc`00`00occo?002oc`001Go?003003o??ll00;o?007
LhikkhaaS76LdjDd[GD00[Ff00>mmlHHaSP00/HhH/iI1<Hh00K66;gg_ONmekFF[GD2[ED00jDdYABU
5002YC@00jeE]IJme`02aQP3aSP2aQP01kgG[GFU5:DDU9:447>>009S3003DXY2:36V008YI@038@@H
ha2R008@PP032648@@0P008085<000H080Go?003003o??ll00;o?0005Oll00<00?lloc`00_ll00M[
CG>^Q12448aaW=>U5002YC@00jeE[GFeUP1S]IH4[GD2[ED2YC@00jDDW=>D/P02S7400haAQ324<002
S5400iBBW?>]E@02]IH00kggaQS6>002aSP01lHH_MN]MJeeYABDTX@@009cSP03H`aBRT8X008ia`03
:FDQ91SS008@XP044888H@Q12443021A00060205oc`00`00occo?002oc`001Go?08000?o?007Jdec
[X@@Q12<LIcCYA@00ZDd00>]EJee]IH0HkFF1:ee0ZeE0ZDd00>U59cCU;800Xaa00><DH@`Q3000XaA
00>DTYcc[ED00[FF00>mmlHHaSP00/Hh00O66;gG[GF]MJDDU9:44002Lhh00f<<DXY2:002>LL00bUU
8B@Hh`024:8011222648@@Q10`0PD@001P0P1?ll0P001?ll000Eoc`00`00occo?002oc`01f<<Jfek
cg_?Q12<DIBB00>D/PFLdfBD/P:DTP:<L@03Q32447_?009cSP03JdeS;6</009[K@03Ljj4<9Bb00:U
=003]IJmmlHH00?6>006aQRmekgG[GFU59BB0X@@00=cSV<<DZX00T8X00<iabUU8B@00QSS00@H`a22
2648H@88@@<084l000H080Go?003003o??ll00;o?0005Oll00<00?lloc`00_ll00MJbf</Jfe[KG>^
Nlmkk`05Q105NnmTNll2Ljh00g>>JdeS3002F//00e::BTU:B@02DXX00e[[Jff44002U;800jDd]KJm
m`02aSP2cUT2aQP00kgG[GFU5002U9800h@@LjiS;002DZX00dY9>NLaQP02:DD01b446<<@XQ2R4888
H@Q100@084d000H080Go?003003o??ll00;o?0005Oll00<00?lloc`00_ll00EBRU[;H`aS36]=00I[
K@03JdeS;6</009S;6ES30=Jj`07DZY:JD8X@RPiac66:FD00S6V00=2:5[;Jfd00X@`00>LdjeE_ML0
0/HH00O>FLiicUW>FLHh_ONeUP02YC@00iBbQ31c[P02Hb`00e[;BTTii`02<JH01bU58@@HhaSS4:8@
PPQQ00<8@@8084`000D08003247o??ll00?o?003003o??ll00;o?0005Oll00<00?lloc`00_ll00A:
BE::F/]Jb`EJj`03F/]BZU:Z009BRP=:JEi:B@Q:J@03BTU2:3WW008aYP03:DDH`a2R008Hh`03<HI:
BF<<009kc`03S76U5;FF00:mm`07cUW>NMJJeY[>NLiI_OL00[Ff00>U=9cCS5400W_?00=[CE[[BVT0
0T8800LiabUU8B@Q91SS6<<@XP0248800`QQ244080030219000502000`Q1occo?003oc`00`00occo
?002oc`001Go?003003o??ll00;o?004BTUBRU[;F//5F^/00e[;DZYBZP02DXX3BVUNBTT8BVT00dY9
@RPii`02<JH00bU56<<@XP026><00c66BTUS3002Nll00haaYABeUP02_OL01liIcWWFV]JJcWW>FKgg
00:e]P03YCBLdhaA009kc`03JdeJjdYY00922007>LLYIB4T8B@HhaS34:800Q2200<8H@Q102000`0P
B@001@0P00<8@Olloc`00oll00<00?lloc`00_ll000Eoc`20003oc`0148XBTU:JDYY0U::0dYY00=:
BD8X@PP00SWW0cW7Fc6V1cW71CWW00Liac66:DDYAASS488000024:800bU5@PQBZP02Jfd00h@`W=>]
E@02_ML00lHhcWWFVP03eYX01/iIaQS66;Ff[EFLd`:<L@03Nnm[KF<<009BRP07@RPiic66<HHYAB44
6><00Q2R00<@PPQQ24400PQ10`0PAP001P0P00<8@Olloc`00_ll0P001?ll000Eoc`00`00occo?002
oc`00cWW@PQ2:003@RP01T88>NLiicW7<JHaQP8YI@<YA@<Q95dYA@<YI@DaQP06:FDQ924T6><@XQ22
0QS300<YACWWDXX00V</00=kkiBBYA@00[FF00C66<iIeY[FVP?F^P;>N@03aSRmejee00:U5003U9:4
47>>009S;007F/]:JD88@PPaYRUU8B@00QSS00<H`a2R48800PQQ0PQ1100P@`001@0P0PQ11Oll00<0
0?lloc`00_ll000Eoc`00`00occo?002oc`00c6V>LLia`03>LL01S6V<HHaQRUU8B@Q10<Hh`HH`ehH
h`048@@Q924T8B@2:DD38B@00b446><Hh`028@@00bUU>NM:J@02H``00g>^S56Ld`02[ED01KgGaSS>
NLiie[X00]kK0]Jj00?FV/iI_OL00[FF00>U=9BbQ3000W_?00M[CE[[DXYBRT8X>LLaQP02:DD00b44
6><@XP024882264324430211000502022445oc`00`00occo?002oc`001Go?003003o??ll00;o?0Ha
QP05:DDQ924T8@@Hh`034:9R48834:826<<26><88@@2:DD00c66>NM:J@02F^/00f]]NnnDTP02YA@0
1[FF_OO>FLiIeY[Nf`?Nn`03g]_F^/ii00;66003]KJ]EIcc00:<L@07NnmcSV</HbaBZTY9@PP00S6V
00<YIB4T8@@00QS300<@XQ2226400PQQ00<8@@0P02000P0P?`001@0P0PQ11Oll00<00?lloc`00_ll
000Eoc`00`00occo?002oc`6<HH01BU58B@Q92446><00a2RHQ220a2R0QS30QSS22440RU500<aQSWW
BVT00U[[00=[KG__U9800ZDD00JeU[ggcUW>FMJJg]/3g_/00mkKe[[>N@02aQP00kFf[EFLl`02S740
1g__LhiS;6</DZY:BD88008aYP03:FDQ9244008H``034:8@PPQQ0088H@032440800P008083l000D0
8088@@Go?003003o??ll00;o?0005Oll00<00?lloc`00_ll12UU0RU500DQ11SS6><H`a2200<8H@D8
@E/8H@88@@<8H@8@PP8@XP036<<Hhb4400<Q108Q908YI@03<JHiidY9009Jb`03Hbac[X@`00:D/P07
YCBeU/HHaQS>FMJjg]/01=kk00KNfmJJeY[6>;gg[GD2YA@01iBbQ31kcg_?JdeJje::0092:003>NLa
YRUU008Q90036><H`a2R008@PP032648@@Q100@083d000@080<8@@Go?003003o??ll00;o?0005Oll
0P000oll00<Q92U58B@00R4T00LQ11SS6<<H`a222648@@08021G2446020324401@QQ488@PQ2R6<<0
0aSS00<Q124T:DD00RUU00<aYSWW@RP00U::00=Jjf]=Nll00XaA00ND/ZDd]KJe]/HHcWWF^P02g_/2
ia`01]kkg]_NfmJjcWW660:e]P07[EFLdhaaS75kkg>>Hb`00U[;00=:JD88>LL00S6600<YAB446><0
0QS300<@XQ2226400`Q11@0P>@00100P0`Q11?ll0P001?ll000Eoc`00`00occo?002oc`00b448B@Q
10028@@01aSS6<<@PQ222648@@0P00@005l0808000<080062448H@QQ488@XQS30QSS00<Q124T8B@0
0RUU00<aQSW7@PP00TY900=BZU[[Jfd00W_?00N<DIBbYCBU=;FfaQS>N@02e[X00mkkiacW7002ia`0
0mkkg]_FVP02aSP01kgg[GFU5:DDU;:4<7_?009[K@03H`aBZTY900922003>LLaQRU5008Q10036><H
`a2R008@PP042648@@Q12445020f000402032445oc`00`00occo?002oc`001Go?003003o??ll00;o
?08Q10<Hh`076<<@XQ224888H@Q10200I`000P0P0PQ100<8HA224:800QS300<Hhb448B@00RU500<Y
IC66>LL00T8800=:BE::F^/00V]=00Mkch@`U;:D/ZDd]IK66002cWT00mJjg__W7003ic`01^LLg__F
^]JjcWW660:e]P03[EFLliBB00:44003Lji[CE[[009BRP03BTTiic6V008YI@03:DDQ11SS008H``04
4:8@PPQQ26432444020c000502032445oc`00`00occo?002oc`001Go?003003o??ll00;o?0@Hh`03
6<<@XQ220088H@032440800P06P000050208@@Q1264@PP034:800aS36><Q10028B@00bU5:FDaQP02
<JH00cWW@RQ:J@02F//01f</Ljj4<8@`U;:U5;FF00:mm`03cUWF^]kk00;W70?W?0;W7007g]_FV/iI
cUVmmkFFYC@00YcC00><LG__Lhh00V</00=Jbe::@RP00SWW00<aYRUU:DD00R4400DHhaS34:8@XQ22
0088H@<8@@@0830000<080D8@@Go?003003o??ll00;o?0005Oll00<00?lloc`00_ll11SS00<H`a2R
48800PQQ00<8@@0P0200J00000D080Q12448HA2200<@XP036<<Hhb44008Q9003:DDYIC66008aYP03
>NM2:4YY009Jb`07Hbac[X@`Q32D/ZDD]IH00[gg00?>FMJjg_/00^LL0nLl0^LL00ONfmJJcUW>FKgg
]IJU=002W=<00haaNnmcSP02Hb`00e[;DXY2:002>NL00c6V:FDYA@028@@01ASS6<<@XQ2R48800PQQ
0`Q1100P<0000`0P1@Q11Oll00<00?lloc`00_ll0009oc`00`00occo?002oc`20005oc`00`00occo
?002oc`46<<24:8011222648H@Q10P0PJ00000H080Q12448@@QQ48824:826<<01QSS8@@Q12448B@Y
A@8YI@03<HHiad88009:B@07DZYS;7>>Lhj449BBYA@00Zee00>mmliIeYX00]kk00?W7>Llked00nLl
00KNnmkKg]_>NLHh_ML2[GD00jDDU;:<D@02Nnl00g>>HbaJb`02BVT00d8X>NLaYP02:FD01bU58@@H
haSS6<<@XQ2200<8H@88@@D082d000<080D8@@Go?003003o??ll00;o?0002Oll00D00?llocco?000
00;o?003003o??ll00;o?003003o??ll00;o?08H``<@XP054888H@QQ2648@@02021X000302000`Q1
264@PP0248800a2R6<<H``046><38@@00b4T:DDaQP02>NL01d8XDXYS36<<Lhikkhaa00:Ll`03[GFm
elHh00;FVP03g]_W7>Ll00?_G@06iccW7>LLg__F^/ii0/HH00>e]ZeEW?<00YBB00>4<7_?Jfd00V<<
00=JbdYY@RP00SWW00LaYRUU:DDYAB446><H``024:800a222648H@032445020Z0003020424400`QQ
occo?003oc`00`00occo?002oc`000Ko?0D000;o?004003o??ll0004oc`20003oc`44:82488010QQ
2448@@Q10P0PJ0000`0P00<8@@QQ26400a220Q2R21S300HHhb4T:FDYICW7@RP2DXX00e[[Jfekk`02
S5400icC[EFe]P02aQP00liig]_W7002ic`4ked00nLliacNn`02e[X00liIaQRe]P02[ED00iccU9:4
<002Nll00f]]H`aJb`02BVT01d8X>NLaYS6V:FDYAB44008Hh`036<<@XQ22008@PP032648@@Q10088
@@<082P000<080<8@@88H@?o?0<000Co?0001_ll00@00?lloc`000?o?004003o??ll0004oc`00`00
occo?002oc`44:82488010QQ2448@@Q10P0PJ0000`0P0PQ10`QQ0Q220a2R1Q2200H@XQS38@@Q12UU
<JH2@PP00dYYF^][C@02Nll00h@`U;:U=002]IH00kggcUWF^P02g_/01nLlkeg_GNmMkgg_GNLl00;W
7003g]_FV/iI00:mm`03]IJ]EIcc00:DTP03Q31kcf]]009S3007F/]:JD8X@RPiic6V<HH00RU500<Q
92446<<00a2R00@@PPQQ2648H@88@@D082@0008080@8@@88H@Go?003003o??ll00;o?0001oll00<0
0?ll00000oll00@00?lloc`000Co?003003o??ll00;o?0@@XP8@PP042648@@Q12442021X00030202
2443264248834:8648801Q2R6<<Q1244:FDaYP922003BVUJjf]=009kc`03Q32D/ZDd00:eUP03_OO>
FMJj00;Nn`07icc_GNmMkeg_ONmMic`00^LL00?NfmJJcUT00[gg00>eUZeEW?<00YBB00>4<7_?Jfd0
0V<<00MJbdYY@RQ2:3WW<JHaQP02:DD00b4T8@@H``034:8011222648H@QQ0PQ11@0P90000P0P10Q1
0PQQ1Oll00<00?lloc`00_ll0008oc`20003oc`01000occo?0001?ll00<00?lloc`00_ll00<@XQ22
48800Q220PQQ0`Q10P0PJ0000`0P0PQ10`QQ1A220PQQ10Q100H8HA226<<H`b44:FD2<JH00d88BVUJ
b`02Hb`00g>^Q12DTP02W?<00jee_MO6>002eYX01MkKiacW?>Llked00^mm0^mM00?W?>LLg]/00]JJ
00?>FKgg]IH00ZDd00>LliBBQ3000W_?00M[KF</F/]Jbe::BTU22002>LL00c66:FDQ90028@@00aSS
6<<@XP02488226442445020P0002020424422645oc`00`00occo?002oc`000Wo?003003o??ll00;o
?08000Go?003003o??ll00;o?0D@PP88H@<8@@8086P000@08088@@P8H@0324408000008000062448
HA2R4:8H`b440RU500<aYSWWBTT00U:Z00=S37>>Nnl00Xaa00>LdjeE]KH00/HH00K>NMJjg__NnnLl
ked4kgd01nmMiccW7>LLg]_FV/Hh00:mm`03]IJU=9cc00:DTP07Q31kcg>>LhiS;5[[DXX00TY900=2
23W7<JH00RUU00<YAB446><00QS300<@XQ2248800`QQ0`Q11@0P6`00100P0`Q10`QQ1Oll00<00?ll
oc`00_ll000Eoc`00`00occo?002oc`4488226432443021X000402022447264224401P0P00000000
0208@@8@PP074:8H`b448@@YAC66>NL00T8X00=BRU[[Jdd00W_?00>4<9BbYA@00Zee00NmelHheY[F
V]kKiac_G@05kgd2ked00nLliacNf`02eYX00lHh_ONeUP02[ED01iccU9:4<8@`NnmcSV</009Jj`03
DZY:JD8X008ii`03<JHaQRU5008Q90038@@HhaS3008@XP8@PP88H@<8@@D081P000@080<8@@<8H@Go
?003003o??ll00;o?0005Oll0P000oll0Q2210QQ0`Q10`0PJ000100P10Q11@QQ0PQ11@0P00D8@@QQ
264@PQ2R008H``038@@Q92UU008ia`03@PQ:JE[;009S;003Lhikkhaa00:Ld`07[EFe]/HHaQS>FMJj
g_/00^Ll00?_GNmmkgd00_NN00?_ONmMic`00^LL00?NfmJJcUT00[gg00Ne]ZeEW?>LliBbS55kk`02
Ljh00f]=H`aBZP02BVT00d8X>NLia`02<HH00bUU8B@Q10026><01AS34:8@XQ2R48800PQQ10Q11@0P
5000100P0`Q10PQQ00<@P_lloc`00_ll0P001?ll000Eoc`00`00occo?002oc`2488426432443021X
0004020424452642244502001@Q12648HA224:800QS300<Q124T:FD00SW700=224YYF//00V</00=c
SW__S7400YcC00N]EKFfaQS66<iIe[[Nn`02ic`00nmMkgg_O@02mih00nmmkegW?002ia`00mkKeY[>
F@02_OL01kFf[EFLliccU;:<DG__009c[P03JdeS35:Z009:J@03@RPiicW7008aQP03:FDQ9244008H
h`056<<@XQ2R4:8@PP0226442445020D00040203244226400a22occo?003oc`00`00occo?002oc`0
01Go?003003o??ll00;o?0034888H@QQ00<8H@<8@@<086P000@080D8@@88H@D8@@<080@8@@07264@
PQ2R4:8H`aSS8B@00RUU00<aYSWWBTT00U::00=Jjf]=Nll00X@`00NDTZDD[GF]MKgGaSS>N@02g]/0
0nLLicc_O@02kgd2mih3kgd00nLliacNf`02eYX01liIaQRe][Ff[GFU59Bb00:<L@03Q11c[V]]009S
;003F/]BRTY900922003>NLaYRUU008YA@068B@Q11SS6><H`a2R0a220PQQ10Q11@0P40000`0P0PQ1
0`QQ0Q221Oll00<00?lloc`00_ll000Eoc`00`00occo?002oc`526442442021Z0004020;24430205
244326400a224:8Hh`028@@00bU5<HHia`02@PP00dYYF/]S;002Lhh01g__S56LdicCYCBeU[gg00;>
F@03eY[NfnLL00;_G@03kgggW_NN00;gWP;_O@05kegW7>LLg__F^P02cUT00lHH_MN]M@02YC@00icC
S764<002Nll00g>>JdeJj`02DZX00dYY@RPii`02>LL01S66:FDYABU58@@Hh`<H``034:8@PQ2200<8
H@88@@L080/000@08088@@<8H@8@PPGo?003003o??ll00;o?0005Oll00<00?lloc`00_ll1@QQ10Q1
0P0PJP00100P3@Q11@0P10Q100<8HA224:800QS300<Hhb4T:FD00S6V00<iidY9DXX00U[[00M[CG>^
Q12449BBW?>]E@02]KH00lHHcUWF^P02g_/00nLlkeg_O@05mih2kgd01nmMiccNnmkke[[>NLHh00:m
e`03]IJU=9cc00:DTP03S55kkg>^009[K@03H`aJbe::009:B@07@PPiic6V<JHaQRU58B@00R4400<H
haS34:800Q2R00<@PPQQ26400PQQ0PQ11`0P1P001@0P0PQ10`QQ00<@PQ2Roc`01?ll00<00?lloc`0
0_ll000Eoc`00`00occo?002oc`526422444021Z0004020=2449020224401PQQ488@PQ2R6><Q108Y
A@03<HHiad88009:J@07DZYS36]]Jfekch@`U9800Ycc00>]MKFfaQP00/ii00?F^]kkic`00^mM00?_
OONNmih00oNN00K_ONmMkegW?=kkg]/2eYX00liI_ONe]P02[ED00jDDU;:<L@02Q3000g_?Lhi[C@02
F^/01e:ZBVU:BDY9@PPiac6V008YI@03:DDQ9244008Hh`036<<@XQ2R008@PP<8H@<8@@h08088@@88
H@8@PP034:;o??ll00?o?003003o??ll00;o?0005Oll0P000oll1@QQ0PQ1100PJP00100P3@Q12@0P
0PQ100H8HA22488@XQSS8@@2:DD00c66>LM22002BVT01e:ZH`a[KF]]Nln4<9BB00:Ll`03[GFe]/HH
00;>N@03e[[NnnLl00;_G@03kgggW_NN00?gWP06kgg_GNmMiccNnmkK0]JJ00?>FKgg]KH00ZeE00>U
59BbS7400X@`00=kcg>>Jdd00U[[00MBZTYYBTU:BD88>LLaYP02:FD00bU58B@Q10026><00aS34:8@
XP0248832643244>02022442264248800a2Rocco?002oc`20004oc`001Go?003003o??ll00;o?0@8
H@<8@@@086X000D080X8@@D080@000<08088@@88H@03488@XQS3008Hh`038B@YIC66008ii`07@RQ:
JE[;F/]S;7>>Nnl00XaA00>D/ZDD[GD00[gG00?6><iie[X00]kk00?W?>mMkgd01oNN00O_ONLliacW
7=kKeY[>F@02aQP00kgG]IJU=002W?<00iBBS55kk`02Ljh01f]]HbaJje[[DZY:JD8X008ii`03>LLa
QRUU008YA@038B@Q11SS008H``8@XP034888H@QQ0088H@@8@@X080042448H@QQ48824:85oc`00`00
occo?002oc`001Go?003003o??ll00;o?0@8H@<8@@@086X000D080X8@@@080P000808088@@88H@06
488@XQ2R6<<Q124T0RUU00LaYSWWBTU:BE::F^][C@02Ljh00g__S56D/P02YA@00jee_MO6>002cWT0
0mJjg__W?002ked00nmmmikg_P02mkh2mih2kgd00nmMiccNn`02e[X00liiaSRmm`02]KH00jeEYABL
d`02S7401h@`NnmcSW>>JdeS35[;009BRP03BTU2:3WW008ia`03<HHYIBU5008Q90038@@HhaS300<@
XP<@PP88H@@8@@8080<000070208@@QQ264@PQ2R6<<01Oll00<00?lloc`00_ll000Eoc`00`00occo
?002oc`226452444021Z00050209244502090003020224401PQQ488@PQ2R6<<Hh`8Q1007:DDaQSW7
>LM224Y9DZX00U[[00=[CG>^Q1000Xaa00>LdjDd[GD00[gG00?6><iie[X00]kk00GW?>mMkgg_OONN
00Cg_P03mik_ONmM00;W?003iacNfmJJ00;>F@03aQRmekFF00:U=007W?>D/XaAS56447_?Lhh00V]=
00=S35[;DXX00TY900=223WW<JH00S6600<YIBU58B@00R4400<HhaS34:800Q2R0Q220`QQ00<8@@0P
00000P0000L080QQ488@PQ2R6<<Hh`05oc`00`00occo?002oc`001Go?003003o??ll00;o?0H8@@D0
86`000D080L8@@D080X000@080<8@@03264@PQ2R008H``076><Q92U5:DDaQSW7@PP00TYY00=BZV<<
Jdd00W>^00>448aaW=<00ZDd00>]MKgGaSP00/ii00OF^]kkiccW?>mMkgggWP05mkh2mih00nmmkegW
?002g_/00mJjcWW6>002_OL01kFf[GFU=:DdW=>DTXaA00:44003Lji[KF</009Jj`03DZYBRTY90092
2003>NLaYS66008YI@06:DDQ92448@@HhaS30a2R00<@PPQQ24400`0P00L8@A224:8@XQS36><Q1005
oc`00`00occo?002oc`001Go?003003o??ll00;o?0H8@@D086`000D080L8@@D080X000@080<8@@03
264@PQ2R008H``076><Q92U5:DDaQSW7@PP00TYY00=BZV<<Jdd00W>^00>448aaW=<00ZDd00>]MKgG
aSP00/ii00OF^]kkiccW?>mMkgggWP05mkh2mih00nmmkegW?002g_/00mJjcWW6>002_OL01kFf[GFU
=:DdW=>DTXaA00:44003Lji[KF</009Jj`03DZYBRTY900922003>NLaYS66008YI@06:DDQ92448@@H
haS30a2R00<@PPQQ24400`0P00L8@A224:8@XQS36><Q1005oc`00`00occo?002oc`001Go?08000?o
?0H8@@D086`000D080H8@@D080d000<080<8@@88H@8@PP074:8H`b448@@Q92UU<JH00SWW00=2:4YY
DZX00V<<00=[KG>^Q1000Xaa00>LdjDd[GD00[gG00O66<iie[[F^]kkiac_G@02kgd00oNNmkkg_P03
mkh2mih2kgd00nLliacNf`02e[X01liiaSRmmkgg]KJ]EJDD00:Ld`03U9:4<7__009c[P03JfeS;5[[
009BZP03DXY:BD88008ii`07>LLaQRUU:FDYAB4T8@@00QSS00<H`a2R48800`QQ00D@PQ2R6><Hhb44
008Q90Co?08000Co?0005Oll00<00?lloc`00_ll1PQ1100PK@001P0P1@Q11@0P3`00100P0PQ10PQQ
00L@PQ2R6<<H`aSS8@@Q9002:FD00c6V>NM2:002BVT00e:ZH`a[K@02Ljh00h@@S76D/P02YA@01jee
]KK66<HHcUWFV]kK00;W7003keg_OONN00Og_P03mik_ONmM00;W?007iacNfmJJeY[>FLHH_ML00[FF
00>]EJDDW=<00Xaa00>4<7__Ljh00V]]00=S;5[[DZX00U::00M:BD88>NLiicW7<HHYI@02:DD00b4T
6><Hh`036<<01ASS8@@Q924T:DD00RUU1Oll00<00?lloc`00_ll000Eoc`00`00occo?002oc`62444
021]000602042446020B0003020324401PQQ488@PQ2R6<<Hh`8Q1003:DDYIC6V008ii`03@RQ:JE:Z
009S3003Jdec[X@@00:<D@07U;:U5:eE[EFe][ggcUT00]JJ00?NfnLLic`00^mM0_NN1_Nn0_NN00O_
ONmMiccW?=kkg]_FVP02cUT00lHH_MNeUP02[ED00iccU;:<L@02Q3000g__Lji[K@02Hb`01e[[DZYB
RU::BTU2:3WW008ia`03<HHYIBU500@YA@04:FDaQS66<HH2<JH5oc`00`00occo?002oc`001Go?003
003o??ll00;o?0H8@@@086d000L080032440800P00H081@000@080062448H@QQ264@PQ2R0QS300<H
hb44:DD00RUU00<aYSWW@RP00TYY00=BZV<<Jdd00W>^00MkkhaAU9:DTYcc[EFeUP02_OL00lHhcWWF
^P02g_/00nLlkeg_O@02mih7mkh2mih00nmmkegW7002g_/00mJjcWW>F@02aQP00kgG]IJ]E@02W?<0
0iBbS764<002Nnl01g>^JfeS;6</F^]Jbe::009:B@03@RQ223WW00@ia`Hii`Go?003003o??ll00;o
?0005Oll00<00?lloc`00_ll1PQ1100PK@001`0P00<8@@0P02001P0P5000100P00H8@@QQ2648HA22
4:826<<00aSS8@@YA@02:FD00c6V>NM2:002BVT00e:ZH`a[C@02Ljh01g__S56DTYBBW?>]EKFF00:m
m`03aSS>NMJj00;Nn`03icc_GNmm00;gWPOg_P;gWP03kgg_GNLL00;Nn`03e[[>NLiI00;66003_MNe
UZeE00:Ll`03U;:<LH@`009kk`07Lji[KF</HbaJje[;DXX00TY900=2:488>NL013W71SWW1Oll00<0
0?lloc`00_ll0008oc`20004oc`20005oc`00`00occo?002oc`52445021]000@020E000402032442
264248800a2R6<<Hh`028@@00bU5:FDaYP02>NL00d8XBVUBZP02F^/01f]=Lhikkg__Q32DTYcC00:U
=003[GFmelHH00;>F@03eY[NfnLL00;W?003kgggW_NN00Og_P;gWP;_O@03iccW7=kk00;F^P03cWW6
><HH00:me`03]IJ]EIcc00:D/P07S764<7__Nnmc[V]]Jdd00V<<00=Jbe:ZDXX024YY0TY91Oll00<0
0?lloc`00_ll0007oc`01000occo?0000_ll00@00?lloc`000Co?003003o??ll00;o?0D8@@D086d0
010081P000@08088@@<8H@07488@XQS36<<Hhb44:DD00RUU00<aYSW7@PP00TY900MBRU[[HbaS;6]]
Nln44002S7400iBbYAB]E@02]KH00kggaSS>N@02e[X00mkkicc_G@02kgd01?NNmkkg__Nn0_oO0oNn
0_NN00K_ONLliccW7=kke[X2cWT00liIaQRme`02]IH01jeEYABLdicCU9:<DH@@009kc`03Lhi[KF]=
009S;09S30=Jj`9Jb`03DX[o??ll00?o?003003o??ll00;o?0001oll00@00?lloc`000;o?004003o
??ll0004oc`20003oc`52445021^000?020K000302032442264248800a2R6<<Hh`028@@00b4T:FDa
QP02>LL01d88BTUBRU::F/]S36]]009c[P03Nnn<DIBB00:Ll`03YCBeU[gG00;66003cUWFV]kK00;W
7003icc_GONN00;gWP;g_P?og`;g_P?gWP07kggW?>LLiacNnmJjcWT00/iI00O66;gG]IJeUZeEYABL
d`02U;800haaQ3244002Nnl00g_?LjicSP02Jfd00f]=HbaJj`03oc`30004oc`000Oo?0<000?o?004
003o??ll0004oc`00`00occo?002oc`52445021^000?020M00040202244326401a224:8H`aS36><Q
124T008YA@07<HHiacWW>NM2:4YYDZX00U[[00=[CG>>Nll00X@`00><LIcCYA@00ZeE00>e][ggaSP0
0/ii00OF^]kkiacW7>mMkgggWP03mkh4oml2mkh3mih00nmmiccW7002g_/01mJjeY[>FLiIaQRmmkFf
00:]M@03YCBU59cC00:D/P03U9:<LH@`00:44003NlmcSV]=00Go?003003o??ll00;o?0001oll00<0
0?lloc`00oll00@00?lloc`000Co?003003o??ll00;o?0D8@@D086h000l081d000@08088@@<8H@07
488@XQS36<<Hhb448B@00RU500LaQSW7>NLiid8XBVUBZP02F^/00f]=Lhikc`02Q3000haaW=>U5002
[ED00kFf_OO6>002cWT01mJjg__W7>LLkeg_OONN00?g_PCog`;g_P?gWP03kggW?>LL00;Nn`07e[[F
V/iIcUW66;gg]KH00Zee00>U=:DDW=<00YBb00>DTXaaQ3000X@@00=kcg>>Jdd01Oll00<00?lloc`0
0_ll0007oc`00`00occo?003oc`01000occo?0001?ll00<00?lloc`00_ll10Q11P0PKP003`0P8000
0`0P0`Q10PQQ0Q220Q2R00DH`b448@@Q92U5008aQP03<JHiid8X009:B@03DXYJjf</009[K@03Ljj4
48aA00:DTP03W?>U=:ee00:me`07aQS>FMJJeY[Nfmkkic`00^mM00?_OONNmkh00_Nn1OoO00?g__NN
mih00^mm00O_GNLLg__NnmkKeY[>N@02aSP00kgg_MNeUP02[GD00jDdYABLd`02U9800haAQ11c[P05
oc`00`00occo?002oc`000So?0<000?o?08000Go?003003o??ll00;o?0@8@@H086h000h082<000@0
80@8@@03264@PQ22008@XP076<<Hhb448@@YABUU<HH00SW700=224Y9DXX00U[;00=S36]=Lhh00W_?
00>4<8aaU;800ZDD00N]EKFF_MNmelHHcUWFVP02g]/00nLLicc_G@02kgd00oNNmkkg_P05oml3mkh0
1_NNkgg_ONmMiccW70;Nf`03e[[>NLiI00;66003_ONe]Zee00:U5003W=><LH@@00Go?003003o??ll
00;o?0005Oll00<00?lloc`00_ll10Q11@0PK`003P0P9P000`0P10Q100D8HA22488@PQ2R008H``03
6><Q124T008YA@03<HHaYSWW0092:003BVUBRU[;009S;003Jfec[W__00:4<007U9:LdjDDYAB]EKFf
_OL00/Hh00?>NMJjg]/00^LL00?W?>mMkgd00_NN0_Nn1OoO0oNn00OgW^mmkeg_GNLliacNf`02e[X0
0liiaSRme`02]IH00jDdW=><D@05oc`00`00occo?002oc`001Go?08000?o?088@@L086l000h082P0
00D080<8@@88H@8@PP034:8H`aS3008Q10038B@YABUU008aYP03>LM224Y9009:J@03DZYJjf</009[
K@07Nln448aAS56DTYccYC@00Zee00>e][ggaSP00/ii00?F^]kKia`00^Ll00?_GNmmmih00oNn1OoO
0oNn00?gW^mmked00^LL00?NfmJJcUT00[gg00>eUZDDU9801?ll0P001?ll000Eoc`00`00occo?002
oc`22447021_000>020X000502032442264248800a2R6<<H``028@@00b4T:DDYI@02<JH00cW7@PQ:
B@02BVT00e:ZF^]S;002Jfd01g_?Q12<DHaAU9:LljDd00:]M@03]KJmmlHh00;>N@03e[[NfnLL00;W
?003keg_OONN00?g_PGog`?g_P03mik_ONmM00;W7003g]_FV/iI00:mm`03]IJU59BB00Go?003003o
??ll00;o?0005Oll00<00?lloc`00_ll0PQ11`0PK`003P0P:`001@0P0PQ10`QQ0Q220Q2R00<H`aSS
8@@00R4T00<YAC66<JH00SWW00=224Y9DXX00U[;00MS36]=LhicSW_?Q12<D@02U;800iccYCB]M@02
]KH00kggaSS>N@02e[X00mkKiacW?002ked00nmmmikg_P02mkh4oml2mkh01_NNkeg_GNLLg]_FVP;6
>003]KJ]EIcC00Go?003003o??ll00;o?0005Oll00<00?lloc`00_ll00<8@@0P02001P0PK`003P0P
;P00100P10Q10`QQ00<@PQ2R6<<00aSS00LQ92U5:FDYIC66>LLii`02@RP01dYYDXYJbe[;H`a[CG>>
009kk`03Q32<LIBb00:Ll`03YCB]MKFf00:mm`03aSS>NMJj00;Nf`05iacW?>mMkeg_O@02mih4mkh0
1_NNkgg_ONLliacF^P;>F@03_ON]MIcc00Go?003003o??ll00;o?0005Oll00<00?lloc`00_ll2@0P
L0003@0P<@001@0P0`Q10PQQ0a2200<@XQS36><00R4400<Q92U5:FD00S6V00Liad88@RQ2:4YYDZYJ
j`02Hb`00f]]Ljikk`02Q3000haaU;:Ll`02YC@00jee]KJmm`02aSP01/iieY[NfmkKg__W?0?_G@?_
O@;_G@03iccW7=Jj00;>N@03_ONeUYcc00Go?003003o??ll00;o?0005Oll00<00?lloc`00_ll2@0P
L0003@0P=0001@0P0`Q10`QQ00L@PQ2R4:8@XQS36><Q10028B@01bU5<HHaYS6V>NM224Y9009:J@03
DZYJjf</009[K@03Ljikkh@`00:<L@03U;:LljDd00:]M@07]KJmmlHhaSS>FMJJe[X00]kk0^LL00KW
?>LLiacW7=kKe[X2cUT00kgg[GFLl`05oc`00`00occo?002oc`001Go?08000?o?0T0870000d083@0
00D080<8@@<8H@07488@XQ2R4:8H`aSS8@@00R4T00LYAC66<JHaYSWW@PQ:B@02BVT00e:ZF^]S;002
Jfd00g>^Nnn4<002S7400iBbW?>U=002[GD01kFf_OO6><HhcUWFV]Jj00;Nn`;W7006iccW7>LLiacN
fmJj0/iI00>mmjeeW?<01?ll0P001?ll000Eoc`00`00occo?002oc`9021`000=020g000502032442
264348800a2R6<<Hh`026><01R44:DDYABUU<HHaYP8ii`03@PQ:BDYY009BZP03F^]S;6]]009c[P03
Nnn4<8aa00:D/P07W?>U=:ee[GFe][ggaQP00/iI00?>NMJJe[X00mJj00OFV/iiaSS6>;gG[GFLl`05
oc`00`00occo?002oc`001Go?003003o??ll00;o?0T0870000/083`000D080@8@@88H@<@PP074:8H
`aSS6><Q124T:DD00RUU00<aQS6V>NL00T8800=:BE::DZX00U[[00=S;6]]Ljh00W__00N448aAU9:D
TYcCYAB]E@02]IH00kgG_OO66002aSP00liIaSS66002_OL00kFF[EFLd`05oc`00`00occo?002oc`0
01Go?003003o??ll00;o?0T0870000/0840000D080<8@@<8H@06488@XQ2R4:8H`aSS0R4400<Q92U5
:FD00S6600<aYSWW@PP00TY900=:JE:ZF^/00V</00M[CG>>Nlmkch@@S56DTP02W=<00jDD[EF]M@03
]KH01kgG]KJeU[FF[EFU59Bb00Go?003003o??ll00;o?0005Oll00<00?lloc`00_ll2@0PL0002`0P
@`001@0P0`Q110QQ00L@PQ2R4:8@XQS36><Q10028B@00bU5:FDaQP02<JH00cWW@PQ:B@02BVT01e:Z
F^]S36<<JdecSW_?00:44003S56DTYcC00:Ll`:U=006[EFU=:DdYABLdhaa1Oll00<00?lloc`00_ll
000Eoc`00`00occo?002oc`9021`000;021300050203244426401a224:8@XQ2R6<<Hhb44008Q9003
:DDYIC66008aYP03>NM224Y9009:J@07DZYJjf<<H`a[CG>>Nll00X@@00><DIBBW=<00Ycc0ZDd00J]
EJDdYCBU59cCS745oc`00`00occo?002oc`001Go?003003o??ll00;o?0T0870000/084H000H080<8
@@88H@<@PP8@XP8H``036><Q124T008YA@03:FDaQS6V008ii`07@PQ2:4YYBVUBZU[;H``00V]=00=c
SW_?Q1000XaA00>DTYBbW=<00YcC00>D/XaaQ3001Oll00<00?lloc`00_ll000Eoc`20003oc`7021b
000;021:000502042442264348824:801QS36><Hhb448B@YA@8YI@07<HHaYSW7>LM2248XBVT00U:Z
00=Jjf</Jfd00W>^00=kkh@@S5400haA00>4<7__oc`00oll0P001?ll000Eoc`00`00occo?002oc`7
021b000;021>000502032443264248834:800aS36><Q10028@@01R4T:DDYAC66<JHia`922003BTUB
RU[;009S3003JdecSW_?009kc`03Nnmkcg>^00Go?003003o??ll00;o?0005Oll00<00?lloc`00_ll
1`0PLP002`0PD@001@0P10Q110QQ00D@PQ2R4:8@XQS300<Hh`038@@Q92U5008aQP03<JHiid8X009B
RP03F/]S36]=009[K@9cSP03Jfgo??ll00?o?003003o??ll00;o?0005Oll00<00?lloc`00_ll1`0P
LP002`0PD@001@0P10Q110QQ00D@PQ2R4:8@XQS300<Hh`038@@Q92U5008aQP03<JHiid8X009BRP03
F/]S36]=009[K@9cSP03Jfgo??ll00?o?003003o??ll00;o?0002?ll0P001?ll0P001Oll00<00?ll
oc`00_ll1`0PL`002P0PE@001@0P10Q110QQ0Q220Q2R0QS300HHhb448@@YABUU<JH2@PP00dY9DXYJ
b`02H``3Hb`5oc`00`00occo?002oc`000Oo?004003o??ll0002oc`01000occo?0001?ll00<00?ll
oc`00_ll1`0PL`002P0PF@001P0P10Q10`QQ0Q2200H@XQS36<<Hhb44:DD2<HH00cWW@RQ:J@02DZX0
0e[;F^]Jj`05oc`00`00occo?002oc`000Oo?004003o??ll0002oc`01000occo?0001?ll0P000oll
1`0PL`002P0PG@001P0P1@Q100H8HA22488@PQS36><28B@00c66>LM22002BTT2DXX015:Zocco??ll
0`001?ll0008oc`20003oc`01000occo?0001?ll00<00?lloc`00_ll1`0PL`002@0PH@00200P0`Q1
00<8HA224:800QSS00<Q9366>LL00T8800=2:4Y9BVT01Oll00<00?lloc`00_ll0007oc`01000occo
?0000_ll00@00?lloc`000Co?003003o??ll00;o?0L087<000T0864000P080<8@@03264@PQ2R008H
h`038B@aQSW700922003@RQ:BDYY00Go?003003o??ll00;o?0001oll00@00?lloc`000;o?004003o
??ll0004oc`00`00occo?002oc`7021c0009021W000602001`Q1488@XQ2R8@@YAC66008ia`03@PQ2
:48X00Go?003003o??ll00;o?0002?ll0P001?ll0P001Oll00<00?lloc`00_ll1`0PL`002@0PK@00
00L080QQ488@PQS38@@YA@02<HH00cW7>NM22005oc`00`00occo?002oc`001Go?003003o??ll00;o
?0L087<000T086d000070208@A22488@XQSS8B@00RUU00<aYSW7>NL01Oll00<00?lloc`00_ll000E
oc`20003oc`7021c0009021]00001`0P2448H@QQ4:8H`b44008YA@03<HHaYSW700Co?08000Co?000
5Oll00<00?lloc`00_ll1`0PL`002@0PK@0000L080Q12648HA2R6<<Q1002:DD00c66<JHia`05oc`0
0`00occo?002oc`001Go?003003o??ll00;o?0L087<000T086d000070208@@QQ264@PQS36><00R4T
00<YIC66<JH01Oll00<00?lloc`00_ll000Eoc`00`00occo?002oc`7021c0009021]00001`0P2448
H@QQ488@XQSS008Q9003:DDYIC6600Go?003003o??ll00;o?0005Oll00<00?lloc`00_ll1`0PL`00
2@0PK@0000L080Q12648HA224:8Hh`028@@00bU5:FDaQP05oc`00`00occo?002oc`001Go?003003o
??ll00;o?0L087<000T086`0008080062448H@QQ488@XQS30R4400<Q92U5:FD01Oll00<00?lloc`0
0_ll000Eoc`00`00occo?002oc`7021c0009021/000202001PQ12648HA224:8H``8Q10038B@YABUU
00Go?003003o??ll00;o?0005Oll0P000oll1`0PL`002@0PK0000P0P0`Q100<@PQ2R6<<00QSS00<Q
92U5:FD01?ll0P001?ll000Eoc`00`00occo?002oc`7021c0009021/0002020324400`QQ4:8H``02
6><00b448B@YA@05oc`00`00occo?002oc`001Go?003003o??ll00;o?0L087D000L086`0008080<8
@@03264@PQS3008Hh`038@@Q92U500Go?003003o??ll00;o?0005Oll00<00?lloc`00_ll1`0PM@00
1`0PK@0000L080Q12448@@QQ488H``026><00b448B@YA@05oc`00`00occo?002oc`001Go?003003o
??ll00;o?0L087D000L086d000070208@@Q12448HA226<<00QSS00<Q124T:DD01Oll00<00?lloc`0
0_ll000Eoc`00`00occo?002oc`7021e0007021]00001`0P2448@@Q1264@PQ2R008Hh`038@@Q92U5
00Go?003003o??ll00;o?0005Oll0P000oll1`0PM@001`0PK@0000L080Q12448@@QQ488@XP026><0
0b448B@Q9004oc`20004oc`001Go?003003o??ll00;o?0H087H000L086d000070208@@Q12448HA22
4:800QSS00<Q124T8B@01Oll00<00?lloc`00_ll000Eoc`00`00occo?002oc`6021f0007021]0000
1`0P2448@@Q1264@PQ2R008H``8Q10038BCo??ll00?o?003003o??ll00;o?0005Oll00<00?lloc`0
0_ll1P0PMP001`0PK@0000L080Q12448@@QQ488@XP026<<28@@00b4Tocco?003oc`00`00occo?002
oc`00003oc`00000008000?o?08000Co?08000Go?003003o??ll00;o?0H087H000L086d000070208
@@Q12448HA224:800QS30R4400<Q9?lloc`00oll00<00?lloc`00_ll0003oc`01@00occo??ll0000
0_ll00@00?lloc`000;o?003003o??ll00;o?003003o??ll00;o?0H087H000L086d000070208@@Q1
2448HA224:800QS300<Hhb448B@01Oll00<00?lloc`00_ll0003oc`01@00occo??ll00000_ll00@0
0?lloc`000;o?003003o??ll00;o?0800?oo?0?o?0<000Co?0000oll00D00?llocco?00000;o?004
003o??ll0002oc`00`00occo?002oc`00`00occo?002oc`00`00occo?00loc`00`00occo?00loc`0
0`00occo?00loc`00`00occo?00loc`00`00occo?002oc`00`00occo?002oc`000?o?005003o??ll
oc`00002oc`01000occo?0000_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`02Oll00<0
0?lloc`02_ll00<00?lloc`02_ll00<00?lloc`02Oll00<00?lloc`02_ll00<00?lloc`02Oll00<0
0?lloc`02_ll00<00?lloc`02Oll00<00?lloc`02_ll00<00?lloc`02_ll00<00?lloc`02Oll00<0
0?lloc`02_ll00<00?lloc`02Oll00<00?lloc`02_ll00<00?lloc`02_ll00<00?lloc`02Oll00<0
0?lloc`02_ll00<00?lloc`02Oll00<00?lloc`02_ll00<00?lloc`02_ll00<00?lloc`00_ll00<0
0?lloc`00_ll00001?ll000000000oll00@00?lloc`000;o?004003o??ll0004occo00080004oc`0
00?o?003003o??ll00;o?08000Co?0800?oo?17o?000ooll8Oll003ooc`Qoc`00?oo?27o?000ooll
8Oll003ooc`Qoc`00?oo?27o?000ooll8Oll003ooc`Qoc`00?oo?27o?000ooll8Oll003ooc`Qoc`0
0?oo?27o?000ooll8Oll003ooc`Qoc`00?oo?27o?000ooll8Oll0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-20.9043, -24.3878, \
0.794624, 0.794624}}],

Cell[BoxData[
    \({2.34`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(f[x_] := \((Which[x > 0, Sin[2  Pi\ x^\((1 + 0.4)\)], True, 0] + 
            Which[x \[LessEqual] 0, Sin[2  Pi\ x], True, 0])\) 
        Which[Abs[x] < 10, Exp[\(-1\)/\((1 - Abs[0.1  x]^2)\)], True, 
          0]\)], "Input",
  InitializationCell->True],

Cell["Let us take a modified signal", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[f[x], {x, \(-13\), 13}];\)\)], "Input",
  InitializationCell->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.03663 0.309146 0.800849 [
[.1337 .29665 -9 -9 ]
[.1337 .29665 9 0 ]
[.31685 .29665 -6 -9 ]
[.31685 .29665 6 0 ]
[.68315 .29665 -3 -9 ]
[.68315 .29665 3 0 ]
[.8663 .29665 -6 -9 ]
[.8663 .29665 6 0 ]
[.4875 .06889 -24 -4.5 ]
[.4875 .06889 0 4.5 ]
[.4875 .14898 -24 -4.5 ]
[.4875 .14898 0 4.5 ]
[.4875 .22906 -24 -4.5 ]
[.4875 .22906 0 4.5 ]
[.4875 .38923 -18 -4.5 ]
[.4875 .38923 0 4.5 ]
[.4875 .46932 -18 -4.5 ]
[.4875 .46932 0 4.5 ]
[.4875 .5494 -18 -4.5 ]
[.4875 .5494 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.1337 .30915 m
.1337 .3154 L
s
[(-10)] .1337 .29665 0 1 Mshowa
.31685 .30915 m
.31685 .3154 L
s
[(-5)] .31685 .29665 0 1 Mshowa
.68315 .30915 m
.68315 .3154 L
s
[(5)] .68315 .29665 0 1 Mshowa
.8663 .30915 m
.8663 .3154 L
s
[(10)] .8663 .29665 0 1 Mshowa
.125 Mabswid
.17033 .30915 m
.17033 .3129 L
s
.20696 .30915 m
.20696 .3129 L
s
.24359 .30915 m
.24359 .3129 L
s
.28022 .30915 m
.28022 .3129 L
s
.35348 .30915 m
.35348 .3129 L
s
.39011 .30915 m
.39011 .3129 L
s
.42674 .30915 m
.42674 .3129 L
s
.46337 .30915 m
.46337 .3129 L
s
.53663 .30915 m
.53663 .3129 L
s
.57326 .30915 m
.57326 .3129 L
s
.60989 .30915 m
.60989 .3129 L
s
.64652 .30915 m
.64652 .3129 L
s
.71978 .30915 m
.71978 .3129 L
s
.75641 .30915 m
.75641 .3129 L
s
.79304 .30915 m
.79304 .3129 L
s
.82967 .30915 m
.82967 .3129 L
s
.09707 .30915 m
.09707 .3129 L
s
.06044 .30915 m
.06044 .3129 L
s
.02381 .30915 m
.02381 .3129 L
s
.90293 .30915 m
.90293 .3129 L
s
.93956 .30915 m
.93956 .3129 L
s
.97619 .30915 m
.97619 .3129 L
s
.25 Mabswid
0 .30915 m
1 .30915 L
s
.5 .06889 m
.50625 .06889 L
s
[(-0.3)] .4875 .06889 1 0 Mshowa
.5 .14898 m
.50625 .14898 L
s
[(-0.2)] .4875 .14898 1 0 Mshowa
.5 .22906 m
.50625 .22906 L
s
[(-0.1)] .4875 .22906 1 0 Mshowa
.5 .38923 m
.50625 .38923 L
s
[(0.1)] .4875 .38923 1 0 Mshowa
.5 .46932 m
.50625 .46932 L
s
[(0.2)] .4875 .46932 1 0 Mshowa
.5 .5494 m
.50625 .5494 L
s
[(0.3)] .4875 .5494 1 0 Mshowa
.125 Mabswid
.5 .08491 m
.50375 .08491 L
s
.5 .10093 m
.50375 .10093 L
s
.5 .11694 m
.50375 .11694 L
s
.5 .13296 m
.50375 .13296 L
s
.5 .16499 m
.50375 .16499 L
s
.5 .18101 m
.50375 .18101 L
s
.5 .19703 m
.50375 .19703 L
s
.5 .21304 m
.50375 .21304 L
s
.5 .24508 m
.50375 .24508 L
s
.5 .26109 m
.50375 .26109 L
s
.5 .27711 m
.50375 .27711 L
s
.5 .29313 m
.50375 .29313 L
s
.5 .32516 m
.50375 .32516 L
s
.5 .34118 m
.50375 .34118 L
s
.5 .3572 m
.50375 .3572 L
s
.5 .37321 m
.50375 .37321 L
s
.5 .40525 m
.50375 .40525 L
s
.5 .42126 m
.50375 .42126 L
s
.5 .43728 m
.50375 .43728 L
s
.5 .4533 m
.50375 .4533 L
s
.5 .48533 m
.50375 .48533 L
s
.5 .50135 m
.50375 .50135 L
s
.5 .51737 m
.50375 .51737 L
s
.5 .53338 m
.50375 .53338 L
s
.5 .05287 m
.50375 .05287 L
s
.5 .03686 m
.50375 .03686 L
s
.5 .02084 m
.50375 .02084 L
s
.5 .00482 m
.50375 .00482 L
s
.5 .56542 m
.50375 .56542 L
s
.5 .58143 m
.50375 .58143 L
s
.5 .59745 m
.50375 .59745 L
s
.5 .61347 m
.50375 .61347 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30915 m
.06244 .30915 L
.08255 .30915 L
.10458 .30915 L
.11448 .30915 L
.11992 .30915 L
.12507 .30915 L
.12986 .30915 L
.13117 .30915 L
.13189 .30915 L
.13256 .30915 L
.13375 .30915 L
.13506 .30915 L
.13623 .30915 L
.13735 .30915 L
.13835 .30915 L
.13944 .30915 L
.14062 .30915 L
.14188 .30915 L
.14307 .30915 L
.14415 .30915 L
.14535 .30915 L
.14648 .30915 L
.14771 .30915 L
.14903 .30915 L
.14969 .30915 L
.15041 .30915 L
.15172 .30915 L
.153 .30914 L
.15418 .30912 L
.15527 .30908 L
.1563 .30902 L
.15743 .30893 L
.15865 .30878 L
.16113 .30837 L
.1634 .30794 L
.16461 .30778 L
.16591 .30771 L
.16713 .3078 L
.16824 .30807 L
.16955 .30865 L
.17029 .30912 L
.17097 .30964 L
.17354 .31239 L
.17622 .31615 L
.17873 .31956 L
.17999 .32083 L
.1807 .32133 L
.18134 .32161 L
.18205 .3217 L
Mistroke
.18282 .32153 L
.18354 .32107 L
.18422 .32037 L
.1855 .3183 L
.1867 .31548 L
.18794 .31165 L
.18931 .30656 L
.19218 .29397 L
.19353 .2879 L
.19481 .28261 L
.19602 .27839 L
.19733 .27501 L
.19853 .27333 L
.19963 .27316 L
.20082 .27463 L
.20213 .27832 L
.20279 .281 L
.2035 .28449 L
.20478 .29229 L
.20952 .33215 L
.2121 .35433 L
.21336 .36318 L
.2145 .36943 L
.21556 .37336 L
.21656 .3752 L
.21761 .375 L
.21875 .37217 L
.21993 .36639 L
.22117 .35721 L
.2234 .33385 L
.22826 .26673 L
.22942 .25134 L
.23065 .23683 L
.23179 .22577 L
.23286 .21796 L
.23407 .21267 L
.23471 .2115 L
.2354 .21157 L
.23611 .2131 L
.23685 .21631 L
.23748 .22034 L
.23817 .22608 L
.23938 .23932 L
.24068 .25749 L
.24301 .29812 L
.24538 .34413 L
.24795 .39065 L
.24913 .40818 L
.25037 .42281 L
.25144 .43149 L
Mistroke
.25261 .43647 L
.25375 .43641 L
.25478 .43204 L
.25598 .42191 L
.25712 .40752 L
.25914 .37201 L
.26134 .32278 L
.2639 .26068 L
.26524 .22971 L
.26666 .20079 L
.2679 .18009 L
.26856 .17128 L
.26927 .1637 L
.27051 .15544 L
.27167 .15394 L
.27287 .15894 L
.27418 .17188 L
.27542 .19084 L
.27656 .21358 L
.28103 .33248 L
.28336 .39729 L
.28458 .4272 L
.28586 .45358 L
.28655 .46503 L
.2873 .47518 L
.28862 .48645 L
.28927 .48875 L
.28996 .48876 L
.2912 .48237 L
.29193 .47486 L
.2926 .46557 L
.29411 .4368 L
.29545 .40367 L
.29686 .36259 L
.2995 .27744 L
.302 .19982 L
.30315 .16949 L
.30437 .14275 L
.30507 .13044 L
.3057 .12145 L
.30694 .11026 L
.30806 .10777 L
.30927 .1134 L
.31041 .12654 L
.31145 .14494 L
.31267 .17331 L
.31381 .20547 L
.31639 .29248 L
.31906 .38824 L
.32038 .43132 L
Mistroke
.32159 .46606 L
.32265 .49109 L
.32382 .51196 L
.32499 .52496 L
.32623 .52935 L
.32728 .52528 L
.3284 .51303 L
.32947 .49432 L
.33044 .47159 L
.33276 .39979 L
.3353 .30397 L
.3377 .21192 L
.33991 .13994 L
.34115 .10916 L
.34246 .0862 L
.34378 .07429 L
.34452 .07279 L
.34522 .0749 L
.34648 .08724 L
.34764 .10771 L
.34896 .14126 L
.35022 .18142 L
.35476 .36231 L
.35724 .45731 L
.35846 .49554 L
.35958 .52373 L
.36077 .54531 L
.36205 .55764 L
.36269 .55932 L
.36339 .55773 L
.36411 .55228 L
.36479 .54379 L
.36601 .52042 L
.36712 .49096 L
.36962 .40209 L
.37493 .17708 L
.37621 .13107 L
.3776 .09109 L
.3784 .07349 L
.37912 .06117 L
.37985 .05263 L
.38055 .04822 L
.38174 .04931 L
.38302 .06254 L
.38423 .08596 L
.38532 .11554 L
.388 .21497 L
.39052 .32795 L
.39267 .42327 L
.39494 .50773 L
Mistroke
.39613 .54095 L
.39743 .56644 L
.39862 .57862 L
.39972 .58001 L
.40101 .5693 L
.40175 .55752 L
.40242 .54313 L
.40366 .50862 L
.40498 .46202 L
.40976 .24636 L
.41222 .14101 L
.41352 .09627 L
.41488 .06033 L
.4156 .04652 L
.41639 .03605 L
.41712 .0309 L
.41779 .02992 L
.41911 .03876 L
.41984 .04981 L
.42051 .06347 L
.42534 .24213 L
.42985 .45349 L
.43102 .49932 L
.43212 .53592 L
.4334 .56805 L
.43456 .58672 L
.43584 .59457 L
.43703 .58952 L
.43834 .57055 L
.439 .55588 L
.43973 .53599 L
.44241 .43485 L
.44531 .29643 L
.44787 .17526 L
.44926 .1183 L
.45056 .07486 L
.45176 .04492 L
.45304 .02522 L
.45378 .02007 L
.45447 .01939 L
.45576 .02905 L
.45695 .05014 L
.45805 .07922 L
.45926 .12054 L
.46054 .17315 L
.46536 .40707 L
.46652 .45924 L
.46774 .50843 L
.46888 .54624 L
.46995 .57367 L
Mistroke
.47059 .58582 L
.47128 .59525 L
.47248 .60208 L
.47318 .60035 L
.47392 .59397 L
.47524 .57124 L
.47643 .53914 L
.47755 .50045 L
.48008 .38913 L
.48225 .28067 L
.48461 .16752 L
.4857 .12232 L
.48685 .08137 L
.48783 .05333 L
.48891 .0308 L
.49014 .01687 L
.49083 .01472 L
.49147 .01637 L
.49263 .02845 L
.49386 .0533 L
.49498 .08576 L
.49602 .12334 L
.49838 .22831 L
.49966 .2918 L
.5003 .31137 L
.50101 .32125 L
.50226 .34653 L
.50343 .37581 L
.50629 .45894 L
.50891 .53377 L
.51008 .56187 L
.51136 .58561 L
.51257 .59945 L
.5137 .60332 L
.51501 .5955 L
.51619 .57612 L
.51685 .56021 L
.51756 .53895 L
.51884 .49026 L
.52356 .23791 L
.5248 .16904 L
.52613 .10417 L
.52739 .05642 L
.52853 .02804 L
.52958 .0169 L
.53071 .0223 L
.53179 .04453 L
.53278 .07929 L
.53385 .13082 L
.53504 .20106 L
Mistroke
.53743 .36521 L
.53863 .44522 L
.53991 .51838 L
.54065 .55171 L
.54132 .57503 L
.54262 .59866 L
.54384 .5921 L
.54516 .55351 L
.54641 .4901 L
.54756 .41381 L
.54988 .23561 L
.55102 .15382 L
.55206 .09165 L
.55316 .04508 L
.55433 .02211 L
.55561 .03237 L
.55682 .07567 L
.56167 .43667 L
.56284 .51644 L
.56411 .57429 L
.56484 .59071 L
.56551 .59395 L
.56682 .56677 L
.56813 .49845 L
.56888 .44511 L
.56957 .38881 L
.57109 .25602 L
.57247 .14425 L
.57377 .06646 L
.57499 .03012 L
.57629 .03783 L
.57702 .06315 L
.5777 .09875 L
.58009 .29098 L
.58127 .39806 L
.58236 .48604 L
.58361 .55806 L
.58428 .57935 L
.58498 .58746 L
.58624 .56346 L
.58738 .50228 L
.58967 .30503 L
.59093 .18986 L
.5921 .10179 L
.5931 .05284 L
.59417 .03466 L
.59536 .05914 L
.59644 .11929 L
.5977 .22289 L
.59906 .35402 L
Mistroke
.60025 .46004 L
.60155 .54535 L
.60227 .57124 L
.60294 .57954 L
.60365 .57084 L
.60442 .54199 L
.60509 .5015 L
.6058 .44636 L
.60707 .32758 L
.60827 .21132 L
.60955 .10869 L
.61075 .05249 L
.61185 .04588 L
.61314 .09405 L
.61387 .1444 L
.61454 .20184 L
.61584 .32925 L
.61707 .44597 L
.61824 .52925 L
.61952 .56974 L
.62068 .55293 L
.62176 .4941 L
.62303 .38415 L
.62419 .26829 L
.62485 .20472 L
.62554 .14532 L
.62678 .07173 L
.62785 .05281 L
.62903 .08434 L
.63029 .17083 L
.63146 .28239 L
.63255 .39186 L
.63358 .48103 L
.63477 .54644 L
.63586 .55917 L
.63705 .51866 L
.63836 .4193 L
.63963 .293 L
.64034 .22317 L
.641 .16345 L
.64229 .08324 L
.64346 .06399 L
.64456 .09759 L
.64576 .18314 L
.64715 .31841 L
.64845 .44323 L
.64918 .49709 L
.64996 .53555 L
.65067 .5492 L
.65133 .54266 L
Mistroke
.65253 .48579 L
.65385 .37302 L
.65523 .23518 L
.6565 .12973 L
.65772 .07839 L
.65901 .09183 L
.66031 .17141 L
.66105 .23762 L
.66174 .30633 L
.66291 .41844 L
.66413 .50559 L
.66477 .53006 L
.66548 .53687 L
.66671 .49777 L
.66793 .406 L
.66904 .29856 L
.67023 .1872 L
.67153 .10586 L
.67273 .0893 L
.67383 .12877 L
.67489 .20688 L
.67601 .31311 L
.67728 .43011 L
.67849 .50496 L
.67916 .5224 L
.67988 .5194 L
.68116 .46134 L
.68236 .36034 L
.68365 .238 L
.68487 .14497 L
.68597 .10374 L
.68666 .10411 L
.68738 .12655 L
.68868 .21381 L
.6902 .35359 L
.69094 .41756 L
.69161 .4646 L
.69284 .50842 L
.69415 .48513 L
.69483 .44617 L
.69557 .38852 L
.69692 .26603 L
.69815 .16975 L
.69927 .1214 L
.70049 .12787 L
.70179 .19835 L
.70399 .3875 L
.70523 .46799 L
.70635 .49421 L
.70698 .48574 L
Mistroke
.70767 .45835 L
.70892 .37131 L
.71006 .27314 L
.71131 .18005 L
.71202 .14669 L
.71268 .13286 L
.71338 .13794 L
.71413 .16502 L
.71483 .20705 L
.71549 .2574 L
.71673 .36047 L
.71794 .44173 L
.71862 .46871 L
.71927 .47764 L
.72056 .44583 L
.72129 .40295 L
.72196 .35334 L
.72318 .256 L
.72431 .18308 L
.7255 .14973 L
.7268 .17483 L
.72748 .2111 L
.72822 .26253 L
.72957 .36498 L
.73088 .43959 L
.73209 .45948 L
.7334 .42072 L
.73414 .37645 L
.73484 .32696 L
.73625 .2286 L
.73704 .18928 L
.73775 .17025 L
.73839 .16863 L
.73908 .18322 L
.74033 .24543 L
.74147 .3232 L
.74272 .4002 L
.74343 .42856 L
.74409 .44066 L
.74479 .437 L
.74554 .4152 L
.74624 .38125 L
.7469 .34109 L
.74814 .26159 L
.74933 .20444 L
.7506 .18738 L
.75168 .213 L
.75287 .27358 L
.75415 .35017 L
.75482 .38429 L
Mistroke
.75552 .40973 L
.75682 .41925 L
.75801 .38505 L
.76023 .26738 L
.76147 .21835 L
.7626 .20714 L
.76365 .22834 L
.76479 .27726 L
.76586 .33196 L
.76686 .37528 L
.76803 .40068 L
.76931 .38882 L
.77056 .34392 L
.7719 .28245 L
.77314 .23916 L
.77432 .22708 L
.77539 .24355 L
.77654 .28351 L
.77779 .33452 L
.77911 .37323 L
.77979 .38097 L
.78055 .37798 L
.78124 .36557 L
.78188 .34742 L
.78312 .30321 L
.7843 .26594 L
.78495 .25287 L
.78566 .24705 L
.78689 .2586 L
.78802 .28756 L
.78926 .32579 L
.79055 .35492 L
.79176 .36078 L
.7929 .34637 L
.79393 .3219 L
.79515 .29075 L
.79626 .27121 L
.79755 .2674 L
.79826 .27427 L
.79893 .28524 L
.80013 .31035 L
.80141 .33358 L
.80208 .34071 L
.80281 .34314 L
.8041 .33413 L
.80483 .32359 L
.80561 .31055 L
.80634 .29892 L
.80702 .29033 L
.80834 .28334 L
Mistroke
.80903 .28536 L
.80977 .29117 L
.81101 .30578 L
.81172 .31444 L
.81237 .32106 L
.81358 .32744 L
.81489 .32457 L
.81604 .31596 L
.81725 .30552 L
.81849 .29831 L
.81918 .29688 L
.81982 .29735 L
.821 .30179 L
.82225 .30879 L
.82337 .31403 L
.82441 .31638 L
.82556 .31572 L
.82679 .31236 L
.8281 .30821 L
.82884 .30649 L
.82952 .30557 L
.83078 .30564 L
.83148 .30645 L
.83211 .30743 L
.83332 .30931 L
.83462 .31054 L
.83585 .31065 L
.83698 .31011 L
.83805 .30944 L
.83919 .3089 L
.84026 .3087 L
.84124 .30873 L
.84239 .30891 L
.84364 .30911 L
.84482 .30921 L
.84592 .30922 L
.84704 .30919 L
.84809 .30916 L
.84925 .30915 L
.85049 .30914 L
.85172 .30914 L
.85302 .30915 L
.85413 .30915 L
.85534 .30915 L
.85599 .30915 L
.85667 .30915 L
.85789 .30915 L
.8592 .30915 L
.85994 .30915 L
.86064 .30915 L
Mistroke
.8619 .30915 L
.86305 .30915 L
.86369 .30915 L
.86438 .30915 L
.86564 .30915 L
.86675 .30915 L
.86799 .30915 L
.87049 .30915 L
.87498 .30915 L
.89594 .30915 L
.93609 .30915 L
.97473 .30915 L
.97619 .30915 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  InitializationCell->True,
  ImageSize->{288, 177.938},
  ImageMargins->{{281, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40n007h00OSoll00<00?lloc`0
S_ll002?oc`2002?oc`008oo?003003o??ll08ko?000Soll00<00?lloc`0S_ll002<oc`200000oll
003o?006oc`00`00occo?026oc`008;o?003003o??ll00Oo?0800003oc`00?ll00Ko?003003o??ll
08Ko?000P_ll00<00?lloc`01oll0P0000?o?00000001_ll0P001_ll00<00?lloc`0O_ll0022oc`0
0`00occo?007oc`200000oll003o?006oc`20006oc`00`00occo?01noc`007Oo?003003o??ll00So
?003003o??ll00Oo?0800003oc`00?ll00Ko?08000Ko?003003o??ll00;o?003003o??ll07Wo?000
Moll00<00?lloc`02?ll00<00?lloc`01oll0P0000?o?000oc`01_ll0P001_ll00<00?lloc`00_ll
00<00?lloc`00oll00<00?lloc`0Loll001goc`20008oc`20009oc`200000oll00000006oc`20005
oc`20004oc`20004oc`00`00occo?01coc`007Oo?08000So?08000Wo?0800003oc`00?ll00Ko?080
00Go?08000Co?08000Co?003003o??ll07?o?000Moll0P002?ll00<00?ll00002?ll0P0000?o?000
oc`01_ll0P001Oll0P001?ll0P001?ll00<00?lloc`0Loll001]oc`00`00occo?007oc`20008oc`0
0`00oc`00008oc`200000oll003o?006oc`20005oc`20004oc`20004oc`00`00occo?002oc`00`00
occo?01^oc`006go?003003o??ll00Oo?08000So?003003o?00000So?0800003oc`00?ll00Ko?080
00Go?08000Co?08000Co?003003o??ll00;o?003003o??ll06ko?000KOll00<00?lloc`01oll0P00
2?ll00<00?ll00002?ll0P0000?o?00000001_ll0P001Oll0P001?ll0P001?ll00<00?lloc`00_ll
00<00?lloc`00_ll00<00?lloc`0JOll001]oc`20008oc`20008oc`00`00oc`00008oc`200000oll
003o?006oc`20005oc`20004oc`20004oc`00`00occo?002oc`00`00occo?002oc`00`00occo?01Y
oc`006co?003003o?00000So?08000;o?08000Co?003003o?00000?o?08000?o?0800003oc`00?ll
00Ko?08000Go?08000Co?08000Co?003003o??ll00;o?003003o??ll00;o?003003o??ll06Wo?000
K?ll00<00?ll00002?ll0P0000Go?000occo?00000?o?003003o?00000;o?004003o??ll0002oc`2
00000oll003o?006oc`20005oc`20004oc`20004oc`00`00occo?002oc`01000occo??ll0P000oll
00<00?lloc`0IOll001/oc`00`00oc`00008oc`200001Oll003o??ll00000oll00<00?ll00001Oll
00<00?lloc`00P0000Co?000000000Go?08000Go?08000Co?08000Co?003003o??ll00;o?004003o
??lloc`20003oc`00`00occo?01Uoc`006;o?003003o??ll00Oo?003003o?00000Go?0D00005oc`0
0?lloc`00003oc`00`00oc`00003oc`20002oc`00`00occo?0020007oc`20005oc`20004oc`20004
oc`00`00occo?002oc`01000occo??ll0P000oll00<00?lloc`0IOll001Roc`20008oc`00`00oc`0
0008oc`200001Oll003o??ll00000oll00<00?ll00001Oll00<00?ll00000_ll0P001oll0P001Oll
0P001?ll0P001?ll00<00?lloc`00_ll00@00?llocco?08000?o?003003o??ll06Go?000H_ll0P00
2?ll00<00?ll00002?ll0P0000Go?000occo?00000?o?003003o?00000;o?006003o??ll003o?000
0_ll0P001oll0P001Oll0P001?ll0P001?ll00<00?lloc`00_ll00@00?llocco?08000?o?005003o
??lloc`0001Soc`006;o?08000So?003003o?00000Oo?003003o?00000;o?08000Co?003003o?000
00?o?08000;o?003003o??ll008000Ko?003003o?00000Go?08000Co?08000?o?08000Co?004003o
??lloc`20003oc`01@00occo??ll0000Holl001Roc`20008oc`00`00oc`00007oc`00`00oc`00008
oc`00`00oc`00007oc`00`00occo?0030005oc`00`00oc`00005oc`20004oc`20003oc`20003oc`2
0003oc`20003oc`01@00occo??ll0000Holl001Roc`20008oc`00`00oc`00007oc`00`00oc`00008
oc`00`00oc`00007oc`00`00occo?0020006oc`00`00oc`00005oc`20004oc`20003oc`20003oc`2
0003oc`20003oc`01000occo??ll0P000_ll00<00?lloc`0GOll001Roc`20008oc`00`00oc`00007
oc`00`00oc`00008oc`00`00oc`00007oc`00`00occo?0020006oc`00`00oc`00005oc`20004oc`2
0003oc`00`00oc`00002oc`20003oc`20003oc`01000occo??ll0P000_ll00<00?lloc`0GOll001R
oc`20008oc`00`00oc`00007oc`00`00oc`00008oc`00`00oc`00007oc`00`00occo?0020006oc`0
0`00oc`00005oc`20004oc`20003oc`00`00oc`00002oc`20003oc`20003oc`01000occo??ll0P00
0_ll00<00?lloc`0GOll001Roc`20008oc`00`00oc`00007oc`00`00oc`00007oc`01000occo?000
1oll00<00?lloc`00`001Oll00<00?ll00001Oll0P001?ll0P000oll00<00?ll00000_ll0P000oll
0P000oll00@00?llocco?08000;o?003003o??ll05go?000H_ll0P002?ll00<00?ll00001oll00<0
0?ll00001oll00@00?lloc`000Oo?003003o??ll008000Ko?003003o?00000Go?08000Co?08000?o
?003003o?00000;o?08000?o?08000?o?004003o??lloc`20002oc`01@00occo??ll0000Foll001H
oc`00`00occo?007oc`20008oc`00`00oc`00007oc`00`00oc`00007oc`01000occo?0001oll00<0
0?lloc`00P001_ll00@00?lloc`000Co?08000Co?08000?o?003003o?00000;o?08000?o?08000?o
?004003o??lloc`20002oc`01@00occo??ll0000Foll001Hoc`00`00occo?007oc`20008oc`00`00
oc`00007oc`01000occo?0001_ll00@00?lloc`000Oo?003003o??ll008000Ko?004003o??ll0004
oc`20004oc`20003oc`00`00oc`00002oc`20003oc`20003oc`01000occo??ll0P000_ll0P000_ll
00<00?lloc`0FOll001Hoc`00`00occo?007oc`20008oc`00`00oc`00007oc`01000occo?0001_ll
00@00?lloc`000Oo?003003o??ll008000Ko?004003o??ll0004oc`20004oc`20003oc`00`00oc`0
0002oc`20003oc`20003oc`01000occo??ll0P000_ll0P000_ll00<00?lloc`0FOll001Goc`20009
oc`20008oc`00`00oc`00007oc`01000occo?0001_ll00@00?lloc`000Oo?003003o??ll00<000Go
?004003o??ll0004oc`20004oc`20003oc`00`00oc`00002oc`20003oc`20003oc`01000occo??ll
0P000_ll0P000_ll0P00F_ll001Goc`20009oc`20008oc`00`00oc`00007oc`01000occo?0001_ll
00@00?lloc`000Oo?003003o??ll008000Ko?004003o??ll0004oc`20004oc`20003oc`00`00oc`0
0002oc`00`00oc`00002oc`20003oc`01000occo??ll0P000_ll0P000_ll0P000_ll00<00?lloc`0
EOll001Goc`00`00oc`00008oc`20008oc`00`00oc`00007oc`01000occo?0001_ll00@00?lloc`0
00Oo?003003o??ll008000Ko?004003o??ll0004oc`20004oc`20003oc`00`00oc`00002oc`00`00
oc`00002oc`20002oc`20003oc`20002oc`20002oc`20002oc`00`00occo?01Eoc`005Oo?003003o
?00000Oo?004003o??ll0007oc`00`00oc`00007oc`01000occo?0001_ll00@00?lloc`000Oo?003
003o??ll008000Ko?004003o??ll0004oc`20004oc`20003oc`00`00oc`00002oc`00`00oc`00002
oc`20002oc`20003oc`20002oc`20002oc`20002oc`00`00occo?01Eoc`005Oo?003003o?00000Oo
?004003o??ll0007oc`00`00oc`00007oc`01000occo?0001_ll00@00?lloc`000Oo?003003o??ll
008000Ko?004003o??ll0004oc`20004oc`20003oc`00`00oc`00002oc`00`00oc`00002oc`20002
oc`20003oc`20002oc`20002oc`20002oc`00`00occo?01Eoc`005Oo?003003o?00000Oo?004003o
??ll0007oc`00`00oc`00007oc`01000occo?0001_ll00@00?lloc`000Oo?003003o??ll00<000Go
?004003o??ll0004oc`20004oc`20003oc`00`00oc`00002oc`00`00oc`00002oc`20002oc`20003
oc`20002oc`20002oc`20002oc`01@00occo??ll0000Doll001Goc`00`00oc`00007oc`01000occo
?0001oll00<00?ll00001oll00@00?lloc`000Ko?004003o??ll0007oc`00`00occo?0020006oc`0
1000occo?0001?ll0P001?ll0P000oll00<00?ll00000_ll00<00?ll00000_ll0P000_ll0P000oll
0P000_ll0P000_ll0P000_ll00D00?llocco?00005?o?000Eoll00<00?ll00001oll00@00?lloc`0
00Oo?003003o?00000Oo?005003o??ll003o?0020003oc`200001?ll003o??ll100000Co?000occo
?08000Ko?004003o??ll0004oc`20004oc`20003oc`00`00oc`00002oc`00`00oc`00002oc`20002
oc`20003oc`20002oc`20002oc`20002oc`01@00occo??ll0000Doll001Goc`00`00oc`00007oc`0
1000occo?0001oll00<00?ll00001oll00<00?lloc`00P000_ll00@00?lloc`000;o?004003o??ll
0004oc`00`00occo?0020006oc`01000occo?0001?ll0P001?ll0P000oll00<00?ll00000_ll00<0
0?ll00000_ll0P000_ll00<00?ll00000_ll0P000_ll0P000_ll0P000_ll00D00?llocco?00005?o
?000Eoll00<00?ll00001oll00@00?lloc`000Oo?003003o?00000Oo?003003o??ll008000;o?004
003o??ll0003oc`01000occo?0000oll00<00?lloc`010001?ll00@00?lloc`000Co?08000Co?080
00?o?003003o?00000;o?003003o?00000;o?08000;o?003003o?00000;o?08000;o?08000;o?080
00;o?005003o??lloc`00003oc`00`00occo?01=oc`005Oo?003003o?00000Oo?004003o??ll0007
oc`00`00oc`00005oc`400000oll00000002oc`01000occo?0000oll00D00?llocco?00000;o?003
003o??ll008000Ko?004003o??ll0004oc`20004oc`20003oc`00`00oc`00002oc`00`00oc`00002
oc`20002oc`00`00oc`00002oc`20002oc`20002oc`20002oc`01@00occo??ll00000oll00<00?ll
oc`0COll001=oc`20008oc`00`00oc`00007oc`01000occo?0001_ll00@00?lloc`000Oo?003003o
??ll008000;o?004003o??ll0003oc`00`00occo?002oc`00`00oc`00002oc`20006oc`01000occo
?0001?ll0P001?ll0P000oll00<00?ll00000_ll00<00?ll00000_ll0P000_ll00<00?ll00000_ll
0P000_ll0P000_ll0P000_ll00D00?llocco?00000?o?003003o??ll04go?000COll0P002?ll00<0
0?ll00001oll00@00?lloc`000Ko?004003o??ll0007oc`00`00occo?0020002oc`01000occo?000
0oll00<00?ll00000_ll00<00?ll00000_ll0P001_ll00@00?lloc`000Co?08000Co?08000?o?003
003o?00000;o?003003o?00000;o?08000;o?003003o?00000;o?08000;o?08000;o?08000;o?005
003o??lloc`00003oc`00`00occo?01=oc`004go?08000So?003003o?00000Oo?004003o??ll0006
oc`01000occo?0001oll00D00?lloc`00?ll008000?o?005003o??lloc`00002oc`20002oc`00`00
occo?0020006oc`01000occo?0001?ll0P001?ll0P000oll00<00?ll00000_ll00<00?ll00000_ll
0P000_ll00<00?ll00000_ll0P000_ll0P000_ll0P000_ll00D00?llocco?00000?o?003003o??ll
04go?000COll0P002?ll00<00?ll00001oll00@00?lloc`000Ko?004003o??ll0007oc`01000occo
?0001_ll00D00?llocco?00000Ko?003003o??ll00<000Go?004003o??ll0004oc`20004oc`20003
oc`00`00oc`00002oc`00`00oc`00002oc`20002oc`00`00oc`00002oc`20002oc`20002oc`20002
oc`200000oll00000003oc`00`00occo?01=oc`004go?08000So?003003o?00000Oo?004003o??ll
0006oc`01@00occo??ll00001_ll00@00?lloc`000Ko?005003o??lloc`00006oc`00`00occo?002
0006oc`01000occo?0001?ll00<00?ll00000oll0P000oll00<00?ll00000_ll00<00?ll00000_ll
0P000_ll00<00?ll00000_ll0P000_ll0P000_ll0P000_ll0P0000?o?00000000_ll0P000_ll00<0
0?lloc`0B_ll001=oc`20008oc`00`00oc`00007oc`01000occo?0001_ll00D00?llocco?00000Ko
?004003o??ll0006oc`01@00occo??ll00001_ll00<00?lloc`00P001_ll00@00?lloc`000Co?003
003o?00000?o?08000?o?003003o?00000;o?003003o?00000;o?08000;o?003003o?00000;o?080
00;o?08000;o?08000;o?0800003oc`0000000;o?08000;o?003003o??ll04[o?000COll0P002?ll
00<00?ll00001oll00@00?lloc`000Ko?005003o??lloc`00006oc`01000occo?0001_ll00D00?ll
occo?00000Ko?003003o??ll008000Ko?004003o??ll0004oc`00`00oc`00003oc`20003oc`00`00
oc`00002oc`00`00oc`00002oc`20002oc`00`00oc`00002oc`20002oc`20002oc`20002oc`20000
0oll00000002oc`20002oc`00`00occo?01:oc`004go?08000So?003003o?00000Oo?004003o??ll
0006oc`01@00occo??ll00001_ll00@00?lloc`000Ko?005003o??lloc`00006oc`01000occo??ll
0P001Oll00@00?lloc`000Co?003003o?00000?o?08000?o?003003o?00000;o?003003o?00000;o
?08000;o?003003o?00000;o?08000;o?08000;o?08000;o?0800003oc`0000000;o?08000;o?003
003o??ll04[o?000COll00<00?ll00001oll00<00?ll00001oll00@00?lloc`000Ko?005003o??ll
oc`00006oc`01000occo?0001_ll00D00?llocco?00000Ko?005003o??lloc`00006oc`01000occo
?0001?ll00<00?ll00000oll0P000oll00<00?ll00000_ll00<00?ll00000_ll0P000_ll00<00?ll
00000_ll0P000_ll0P000_ll0P000_ll0P0000?o?00000000_ll0P000_ll00<00?lloc`0B_ll001=
oc`00`00oc`00006oc`01000occo?0001oll00@00?lloc`000Ko?005003o??lloc`00006oc`01000
occo?0001_ll00D00?llocco?00000Ko?005003o??lloc`00006oc`01000occo?0001?ll00<00?ll
00000oll0P000oll00<00?ll00000_ll00<00?ll00000_ll0P000_ll00L00?ll003o?000oc`00002
oc`20002oc`20002oc`200000oll00000002oc`20002oc`01@00occo??ll0000B?ll001=oc`00`00
oc`00006oc`01@00occo??ll00001_ll00@00?lloc`000Ko?005003o??lloc`00006oc`01000occo
?0001_ll00D00?llocco?00000Ko?005003o??lloc`00006oc`01000occo?0001?ll00<00?ll0000
0oll0P000oll00<00?ll00000_ll00<00?ll00000_ll0P000_ll00L00?ll003o?000oc`00002oc`2
0002oc`20002oc`200001Oll003o?000oc`00P000_ll00D00?llocco?00004So?000C?ll00@00?ll
oc`000Ko?005003o??lloc`00006oc`01000occo?0001_ll00D00?llocco?00000Ko?004003o??ll
0006oc`01@00occo??ll00001_ll00D00?llocco?00000Ko?004003o??ll0004oc`00`00oc`00003
oc`20003oc`00`00oc`00002oc`00`00oc`00002oc`20002oc`01`00oc`00?ll003o?00000;o?080
00;o?08000;o?0800005oc`00?ll003o?0020002oc`01@00occo??ll0000B?ll001<oc`01000occo
?0001_ll00D00?llocco?00000Ko?004003o??ll0006oc`01@00occo??ll00001Oll00D00?llocco
?00000Ko?005003o??lloc`00006oc`01000occo??ll0P001Oll00@00?lloc`000?o?004003o??ll
0003oc`00`00oc`00002oc`00`00oc`00002oc`00`00oc`00002oc`20002oc`01`00oc`00?ll003o
?00000;o?08000;o?08000;o?0800005oc`00?ll003o?0020002oc`00`00occo?0020018oc`004co
?004003o??ll0006oc`01@00occo??ll00001_ll00@00?lloc`000Ko?005003o??lloc`00005oc`0
0`00occo?002oc`00`00occo?003oc`01@00occo??ll00001_ll00D00?llocco?00000Ko?004003o
??ll0003oc`01000occo?0000oll00<00?ll00000_ll00<00?ll00000_ll00<00?ll00000_ll0P00
0_ll00L00?ll003o?000oc`00002oc`20002oc`20002oc`200001Oll003o?000oc`00P000_ll00<0
0?lloc`00P00B?ll001<oc`01000occo?0001_ll00D00?llocco?00000Ko?004003o??ll0006oc`0
1@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Ko?005003o
??lloc`00006oc`01000occo?0000oll00@00?lloc`000;o?004003o??ll0002oc`00`00oc`00002
oc`00`00oc`00002oc`20002oc`01`00oc`00?ll003o?00000;o?08000;o?08000;o?0800005oc`0
0?ll003o?0020002oc`00`00occo?0020018oc`004co?004003o??ll0006oc`01@00occo??ll0000
1_ll00@00?lloc`000Ko?005003o??lloc`00005oc`00`00occo?002oc`00`00occo?003oc`01@00
occo??ll00001_ll00D00?llocco?00000Ko?004003o??ll0003oc`01000occo?0000_ll00@00?ll
oc`000;o?003003o?00000;o?003003o?00000;o?08000;o?007003o?000oc`00?ll00000_ll0P00
0_ll0P000_ll0P0000Go?000oc`00?ll008000;o?003003o??ll008000;o?003003o??ll04?o?000
@oll00<00?lloc`01_ll00@00?lloc`000Ko?005003o??lloc`00006oc`01000occo?0001_ll00D0
0?llocco?00000Go?003003o??ll00;o?003003o??ll00?o?005003o??lloc`00006oc`01@00occo
??ll00001_ll00@00?lloc`000?o?004003o??ll0002oc`01000occo?0000_ll00<00?ll00000_ll
00<00?ll00000_ll0P000_ll00L00?ll003o?000oc`00002oc`20002oc`20002oc`200001Oll003o
?000oc`00P000_ll00<00?lloc`00P000_ll00<00?lloc`0@oll0013oc`20007oc`01000occo?000
1_ll00D00?llocco?00000Ko?004003o??ll0006oc`01@00occo??ll00001Oll00<00?lloc`00_ll
00<00?lloc`00oll00D00?llocco?00000Ko?004003o??lloc`20005oc`01000occo?0000oll00@0
0?lloc`000;o?004003o??ll0002oc`00`00oc`00002oc`00`00oc`00002oc`20002oc`01`00oc`0
0?ll003o?00000;o?08000;o?08000;o?0800005oc`00?ll003o?0020002oc`00`00occo?0020002
oc`00`00occo?013oc`004?o?08000Oo?004003o??ll0006oc`01@00occo??ll00001_ll00@00?ll
oc`000Ko?005003o??lloc`00005oc`00`00occo?002oc`00`00occo?003oc`01@00occo??ll0000
1_ll00D00?llocco?00000Ko?004003o??ll0003oc`01000occo?0000_ll00@00?lloc`000;o?003
003o?00000;o?003003o?00000;o?08000;o?007003o?000oc`00?ll00000_ll0P000_ll0P000_ll
0P0000Go?000oc`00?ll008000;o?0800003oc`0000000;o?003003o??ll04?o?000@oll0P001oll
00@00?lloc`000Ko?005003o??lloc`00006oc`01000occo?0001_ll00D00?llocco?00000Go?003
003o??ll00;o?0<000?o?08000;o?003003o?00000<00003oc`00?ll00;o?003003o??ll00Co?004
003o??ll0003oc`01000occo?0000_ll00@00?lloc`000;o?003003o?00000;o?003003o?00000;o
?08000;o?007003o?000oc`00?ll00000_ll0P000_ll0P0000Wo?000oc`00?ll003o?000oc`00P00
0_ll0P0000?o?00000000_ll00<00?lloc`0@oll0012oc`00`00oc`00007oc`01000occo?0001_ll
00D00?llocco?00000Ko?004003o??ll0006oc`01@00occo??ll00001Oll00<00?lloc`00_ll00@0
0?lloc`000;o?005003o??lloc`00003oc`01000occo?0000oll00<00?lloc`01?ll00@00?lloc`0
00?o?004003o??ll0002oc`01000occo?0000_ll00<00?ll00000_ll00<00?ll00000_ll0P000_ll
00L00?ll003o?000oc`00002oc`20002oc`200002Oll003o?000oc`00?ll003o?0020002oc`20000
0oll00000002oc`00`00occo?013oc`004;o?003003o?00000Oo?004003o??ll0006oc`01@00occo
??ll00001_ll00@00?lloc`000Ko?005003o??lloc`00005oc`00`00occo?002oc`01000occo?000
0_ll00D00?llocco?00000?o?003003o?00000Co?0<000Co?004003o??ll0003oc`01000occo?000
0_ll00@00?lloc`000;o?003003o?00000;o?003003o?00000;o?00;003o?000oc`00?ll003o?000
oc`00002oc`20002oc`200002Oll003o?000oc`00?ll003o?0020002oc`200000oll00000002oc`0
1@00occo??ll0000@Oll0012oc`00`00oc`00007oc`01000occo?0001_ll00D00?llocco?00000Ko
?004003o??ll0006oc`01@00occo??ll00001?ll10000_ll00@00?lloc`000;o?005003o??lloc`0
0003oc`00`00oc`00004oc`00`00occo?004oc`01000occo?0000oll00@00?lloc`000;o?004003o
??ll0002oc`00`00oc`00002oc`00`00oc`00002oc`02`00oc`00?ll003o?000oc`00?ll00000_ll
0P000_ll0P0000Wo?000oc`00?ll003o?000oc`00P000_ll0P0000?o?00000000_ll00D00?llocco
?000047o?000@_ll00<00?ll00001oll00@00?lloc`000Ko?005003o??lloc`00006oc`01000occo
?0001_ll00D00?llocco?00000Go?003003o??ll00;o?004003o??ll0002oc`01@00occo??ll0000
0oll00<00?ll00001?ll00<00?lloc`01?ll00@00?lloc`000?o?004003o??ll0002oc`01000occo
?0000_ll00<00?ll00000_ll00<00?ll00000_ll00/00?ll003o?000oc`00?ll003o?00000;o?080
00;o?0800009oc`00?ll003o?000oc`00?ll008000;o?0800003oc`0000000;o?003003o??ll0080
047o?000@_ll00<00?ll00001oll00@00?lloc`000Ko?005003o??lloc`00006oc`01000occo?000
1_ll00D00?llocco?00000Go?003003o??ll00;o?006003o??ll003o?0001?ll00<00?ll00000P00
00?o?000oc`00oll00<00?lloc`01?ll00@00?lloc`000?o?004003o??ll0002oc`01000occo?000
0_ll00<00?ll00000_ll00<00?ll00000_ll00/00?ll003o?000oc`00?ll003o?00000;o?08000;o
?0800009oc`00?ll003o?000oc`00?ll008000;o?0800003oc`0000000;o?003003o??ll0080047o
?000@_ll00<00?ll00001oll00@00?lloc`000Ko?005003o??lloc`00006oc`01000occo?0001_ll
00D00?llocco?00000Go?003003o??ll00;o?0<000;o?003003o??ll00;o?007003o??lloc`00?ll
00001?ll00<00?lloc`01?ll00@00?lloc`000?o?004003o??ll0002oc`01000occo?0000_ll00<0
0?ll00000_ll00<00?ll00000_ll00/00?ll003o?000oc`00?ll003o?00000;o?08000;o?0800009
oc`00?ll003o?000oc`00?ll008000;o?0800003oc`0000000;o?003003o??ll0080047o?000@_ll
00<00?ll00001_ll00D00?llocco?00000Ko?005003o??lloc`00006oc`01000occo?0001_ll00D0
0?llocco?00000Go?003003o??ll00;o?003003o??ll00;o?003003o??ll00;o?003003o??ll00?o
?003003o??ll00;o?08000Go?004003o??ll0003oc`01000occo?0000_ll00@00?lloc`000;o?003
003o?00000;o?003003o?00000;o?00?003o?000oc`00?ll003o?000oc`00?ll003o?00000;o?080
0009oc`00?ll003o?000oc`00?ll008000;o?0800003oc`0000000;o?003003o??ll008000;o?003
003o??ll03co?000@_ll00@00?lloc`000Go?005003o??lloc`00006oc`01@00occo??ll00001_ll
00@00?lloc`000Ko?005003o??lloc`00005oc`00`00occo?002oc`00`00occo?002oc`00`00occo
?002oc`00`00occo?003oc`00`00occo?002oc`00`00occo?004oc`01000occo?0000oll00@00?ll
oc`000;o?004003o??ll0002oc`00`00oc`00002oc`00`00oc`00002oc`03`00oc`00?ll003o?000
oc`00?ll003o?000oc`00002oc`200002Oll003o?000oc`00?ll003o?0020002oc`200000oll0000
0002oc`00`00occo?0020002oc`00`00occo?00loc`004;o?004003o??ll0005oc`01@00occo??ll
00001_ll00D00?llocco?00000Ko?004003o??ll0006oc`01@00occo??ll00001Oll00<00?lloc`0
0_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00oll00<00?lloc`00_ll00<00?lloc`0
1?ll00@00?lloc`000?o?004003o??ll0002oc`01000occo?0000_ll00<00?ll00000_ll00<00?ll
00000_ll00l00?ll003o?000oc`00?ll003o?000oc`00?ll00000_ll0P0000Wo?000oc`00?ll003o
?000oc`00P000_ll0P0000?o?00000000_ll00<00?lloc`00P000_ll00<00?lloc`0??ll0012oc`0
1000occo?0001Oll00D00?llocco?00000Ko?005003o??lloc`00006oc`01000occo?0001_ll00D0
0?llocco?00000Go?003003o??ll00;o?003003o??ll00;o?003003o??ll00;o?003003o??ll00?o
?003003o??ll00;o?003003o??ll00Co?004003o??ll0003oc`01000occo?0000_ll00@00?lloc`0
00;o?003003o?00000;o?003003o?00000;o?00?003o?000oc`00?ll003o?000oc`00?ll003o?000
00;o?0800009oc`00?ll003o?000oc`00?ll008000;o?0800003oc`0000000;o?0800003oc`00000
00;o?003003o??ll03co?000@_ll00@00?lloc`000Go?005003o??lloc`00006oc`01@00occo??ll
00001Oll00D00?llocco?00000Ko?005003o??lloc`00005oc`00`00occo?002oc`00`00occo?002
oc`00`00occo?002oc`00`00occo?003oc`00`00occo?002oc`20005oc`01000occo?0000oll00@0
0?lloc`000;o?004003o??ll0002oc`00`00oc`00002oc`00`00oc`00002oc`03`00oc`00?ll003o
?000oc`00?ll003o?000oc`00002oc`200002Oll003o?000oc`00?ll003o?0020002oc`200000oll
00000002oc`200000oll00000002oc`00`00occo?00loc`0047o?005003o??lloc`00005oc`01@00
occo??ll00001_ll00D00?llocco?00000Go?005003o??lloc`00006oc`01@00occo??ll00001Oll
00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00oll00<00?lloc`00_ll
00<00?lloc`01?ll00@00?lloc`000?o?004003o??ll0002oc`01000occo?0000_ll00<00?ll0000
0_ll00<00?ll00000_ll00l00?ll003o?000oc`00?ll003o?000oc`00?ll00000_ll0P0000Wo?000
oc`00?ll003o?000oc`00P000_ll0P0000?o?00000000_ll0P0000Co?000003o?08003ko?000@Oll
00D00?llocco?00000Go?005003o??lloc`00006oc`01@00occo??ll00001Oll00D00?llocco?000
00Ko?005003o??lloc`00005oc`00`00occo?002oc`00`00occo?002oc`00`00occo?002oc`00`00
occo?003oc`00`00occo?002oc`00`00occo?004oc`01000occo?0000oll00@00?lloc`000;o?004
003o??ll0002oc`00`00oc`00002oc`00`00oc`00002oc`03`00oc`00?ll003o?000oc`00?ll003o
?000oc`00002oc`200002Oll003o?000oc`00?ll003o?0020002oc`200000oll00000002oc`20000
1?ll00000?ll0P000_ll00<00?lloc`0>Oll000Toc`40003oc`2000Doc`01@00occo??ll00001Oll
00D00?llocco?00000Ko?006003o??lloc`00?ll0`0000?o?000oc`00_ll00<00?lloc`01?ll00D0
0?llocco?00000Go?003003o??ll00;o?003003o??ll00;o?003003o??ll00;o?003003o??ll00?o
?003003o??ll00;o?003003o??ll00Co?004003o??ll0003oc`01000occo?0000_ll00@00?lloc`0
00;o?003003o?00000;o?003003o?00000;o?00>003o?000oc`00?ll003o?000oc`00?ll003o?0D0
0009oc`00?ll003o?000oc`00?ll008000;o?0800003oc`0000000;o?0800004oc`00000oc`20002
oc`00`00occo?00<oc`40003oc`2000Toc`002Ko?005003o??lloc`00002oc`00`00occo?008oc`2
0007oc`01@00occo??ll00001Oll00D00?llocco?00000Ko?005003o??lloc`00004oc`20004oc`0
0`00occo?003oc`00`00occo?002oc`00`00occo?002oc`00`00occo?002oc`00`00occo?002oc`0
0`00occo?002oc`00`00occo?003oc`00`00occo?002oc`00`00occo?004oc`01000occo?0000oll
00@00?lloc`000;o?004003o??ll0002oc`00`00oc`00002oc`00`00oc`00002oc`03`00oc`00?ll
003o?000oc`00?ll003o?000oc`00002oc`200002Oll003o?000oc`00?ll003o?0020002oc`20000
0oll00000002oc`200001?ll00000?ll0P000_ll00<00?lloc`03_ll00D00?llocco?00000;o?003
003o??ll027o?0009_ll00D00?llocco?00000;o?003003o??ll00So?003003o?00000Ko?005003o
??lloc`00005oc`00`00occo?002oc`00`00occo?003oc`01@00occo??ll00001?ll0P001?ll00<0
0?lloc`00oll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<0
0?lloc`00_ll00<00?lloc`00oll00<00?lloc`00_ll0P001Oll00@00?lloc`000?o?004003o??ll
0002oc`01000occo?0000_ll00<00?ll00000_ll00<00?ll00000_ll00l00?ll003o?000oc`00?ll
003o?000oc`00?ll00000_ll0P0000Wo?000oc`00?ll003o?000oc`00P000_ll0P0000?o?0000000
0_ll0P0000Co?000003o?08000;o?003003o??ll00ko?005003o??lloc`00002oc`00`00occo?00Q
oc`001ko?0@000Co?005003o??lloc`00002oc`00`00occo?008oc`00`00oc`00006oc`01@00occo
??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll1@0000Ko?00000000?ll0004oc`00`00occo
?003oc`00`00occo?002oc`00`00occo?002oc`00`00occo?002oc`00`00occo?002oc`00`00occo
?002oc`00`00occo?003oc`00`00occo?002oc`00`00occo?004oc`01000occo?0000oll00@00?ll
oc`000;o?004003o??ll0002oc`00`00oc`00002oc`00`00oc`00002oc`03P00oc`00?ll003o?000
oc`00?ll003o?000oc`500002Oll003o?000oc`00?ll003o?00200001Oll003o?000oc`00P000_ll
0P0000Co?000003o?08000;o?08000oo?005003o??lloc`00002oc`00`00occo?00Qoc`002Ko?005
003o??lloc`00002oc`00`00occo?008oc`00`00oc`00006oc`01@00occo??ll00001Oll00<00?ll
oc`00_ll00<00?lloc`00oll00L00?llocco?000oc`00003oc`00`00occo?002oc`00`00occo?003
oc`00`00occo?002oc`00`00occo?002oc`00`00occo?002oc`00`00occo?002oc`00`00occo?002
oc`00`00occo?003oc`00`00occo?002oc`00`00occo?004oc`01@00occo??ll00000_ll00@00?ll
oc`000;o?004003o??ll0002oc`00`00oc`00002oc`00`00oc`00002oc`03`00oc`00?ll003o?000
oc`00?ll003o?000oc`00002oc`200002Oll003o?000oc`00?ll003o?00200001Oll003o?000oc`0
0P000_ll0P0000Co?000003o?08000;o?0800003oc`00?ll00co?005003o??lloc`00002oc`00`00
occo?00Qoc`002Co?0<000?o?004003o??ll0009oc`01000occo?0001_ll00D00?llocco?00000Go
?003003o??ll00;o?003003o??ll00?o?007003o??lloc`00?ll00000oll00<00?lloc`00_ll00<0
0?lloc`00oll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<0
0?lloc`00_ll00<00?lloc`00oll00<00?lloc`00_ll00<00?lloc`01?ll00D00?llocco?00000;o
?004003o??ll0002oc`01000occo?0000_ll00<00?ll00000_ll00<00?ll00000_ll00l00?ll003o
?000oc`00?ll003o?000oc`00?ll00000_ll0P0000Wo?000oc`00?ll003o?000oc`00P0000Go?000
oc`00?ll008000;o?0800004oc`00000oc`20002oc`200000oll003o?00:oc`30003oc`01000occo
?0008oll000Voc`00`00occo?002oc`2000:oc`01000occo?0001_ll00D00?llocco?00000Go?003
003o??ll00;o?003003o??ll00?o?006003o??lloc`00?ll1@001?ll00<00?lloc`00_ll00<00?ll
oc`00oll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00oll00<00?ll
oc`00_ll00<00?lloc`00_ll0P001Oll00D00?llocco?00000;o?004003o??ll0002oc`01000occo
?0000_ll00<00?ll00000_ll00<00?ll00000_ll00h00?ll003o?000oc`00?ll003o?000oc`00?ll
1@0000Wo?000oc`00?ll003o?000oc`00P0000Go?000oc`00?ll008000;o?0800004oc`00000oc`2
0002oc`200000oll0000000<oc`00`00occo?002oc`2000Toc`003Oo?004003o??ll0006oc`01@00
occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Go?003003o??ll
00;o?003003o??ll00;o?003003o??ll00?o?003003o??ll00;o?003003o??ll00;o?003003o??ll
00;o?003003o??ll00?o?003003o??ll00;o?003003o??ll00;o?003003o??ll00Co?005003o??ll
oc`00002oc`01000occo?0000_ll00@00?lloc`000;o?003003o?00000;o?003003o?00000;o?00?
003o?000oc`00?ll003o?000oc`00?ll003o?00000;o?0800009oc`00?ll003o?000oc`00?ll0080
0005oc`00?ll003o?0020002oc`200001?ll00000?ll0P000_ll0P0000?o?0000000=oll000goc`0
1000occo?0001_ll00D00?llocco?00000Go?003003o??ll00;o?003003o??ll00?o?005003o??ll
oc`00005oc`00`00occo?002oc`00`00occo?002oc`00`00occo?003oc`00`00occo?002oc`00`00
occo?002oc`00`00occo?002oc`00`00occo?003oc`00`00occo?002oc`00`00occo?002oc`00`00
occo?004oc`01@00occo??ll00000_ll00@00?lloc`000;o?004003o??ll0002oc`00`00oc`00002
oc`00`00oc`00002oc`03`00oc`00?ll003o?000oc`00?ll003o?000oc`00002oc`200002Oll003o
?000oc`00?ll003o?00200001Oll003o?000oc`00P000_ll0P0000Co?000003o?08000;o?0800004
oc`00000oc`2000doc`003Ko?005003o??lloc`00005oc`00`00occo?002oc`00`00occo?003oc`0
0`00occo?002oc`00`00occo?003oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`0
0_ll00<00?lloc`00oll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`0
0oll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`01?ll00D00?llocco?00000;o?004003o
??ll0002oc`01000occo?0000_ll00<00?ll00000_ll00<00?ll00000_ll01`00?ll003o?000oc`0
0?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?0800005oc`00?ll003o?002
0002oc`200001?ll00000?ll0P000_ll0P0000Co?000003o?08003Co?000=_ll00<00?lloc`00_ll
00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00oll00<00?lloc`00_ll00<00?lloc`00oll
00D00?llocco?00000Go?003003o??ll00;o?003003o??ll00;o?003003o??ll00?o?003003o??ll
00;o?003003o??ll00;o?003003o??ll00;o?003003o??ll00?o?003003o??ll00;o?003003o??ll
00;o?003003o??ll00?o?003003o??ll00;o?004003o??ll0002oc`01000occo?0000_ll00H00?ll
oc`00?ll0002oc`00`00oc`00002oc`07000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o
?000oc`00?ll003o?000oc`00?ll0P0000Go?000oc`00?ll008000;o?0800004oc`00000oc`20002
oc`300000oll003o?00200000oll0000000aoc`00?l00200007o?0001oll00<00?lloc`01oll00<0
0?lloc`02?ll00<00?lloc`01oll00<00?lloc`02?ll0P000oll00<00?lloc`00_ll00<00?lloc`0
0_ll00<00?lloc`00_ll0P001?ll00<00?lloc`00_ll00<00?lloc`00oll00@00?llocco?08000Co
?003003o??ll00;o?003003o??ll00;o?003003o??ll00?o?003003o??ll00;o?003003o??ll00;o
?003003o??ll00;o?003003o??ll00?o?003003o??ll00;o?003003o??ll00;o?003003o??ll00?o
?004003o??lloc`20002oc`01000occo?0000_ll0P0000Oo?000occo?000oc`00002oc`00`00oc`0
0002oc`06P00oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`4
00001Oll003o?000oc`00`0000Ko?000003o?000oc`200001?ll00000?ll0P0000?o?00000000_ll
0P002_ll00<00?lloc`01oll00<00?lloc`02?ll00<00?lloc`01oll00<00?lloc`01_ll000Voc`0
0`00occo?009oc`01000occo?0001Oll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00oll
00<00?lloc`00_ll00<00?lloc`00oll00@00?llocco?08000Co?003003o??ll00;o?003003o??ll
00;o?003003o??ll00?o?003003o??ll00;o?003003o??ll00;o?003003o??ll00;o?003003o??ll
00?o?003003o??ll00;o?003003o??ll00;o?003003o??ll00?o?003003o??ll00;o?004003o??ll
0002oc`01000occo?0000_ll00H00?lloc`00?ll0002oc`00`00oc`00002oc`07P00oc`00?ll003o
?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?0800007oc`00?ll
003o?000oc`00`000_ll0P0000Co?000003o?0800003oc`0000000;o?003003o??ll00Wo?003003o
??ll02Go?000<oll0`001Oll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00oll00<00?ll
oc`00_ll00<00?lloc`00oll00D00?llocco?00000Go?003003o??ll00;o?003003o??ll00;o?003
003o??ll00?o?003003o??ll00;o?003003o??ll00;o?003003o??ll00;o?003003o??ll00?o?003
003o??ll00;o?003003o??ll00;o?003003o??ll00?o?003003o??ll00;o?004003o??ll0002oc`0
1000occo?0000_ll00H00?lloc`00?ll0002oc`00`00oc`00002oc`07P00oc`00?ll003o?000oc`0
0?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?0800007oc`00?ll003o?000
oc`00`000_ll0P0000Co?000003o?0800003oc`0000003Ko?000=?ll00<00?lloc`01?ll00<00?ll
oc`00_ll00<00?lloc`00oll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?ll
oc`00_ll00<00?lloc`00oll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00oll00<00?ll
oc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00oll00<00?lloc`00_ll00<00?ll
oc`00_ll00<00?lloc`00oll00<00?lloc`00_ll00@00?lloc`000;o?004003o??ll0002oc`01P00
occo?000oc`000;o?003003o?00000;o?00N003o?000oc`00?ll003o?000oc`00?ll003o?000oc`0
0?ll003o?000oc`00?ll003o?000oc`00?ll0P0000Oo?000oc`00?ll003o?0030002oc`200001?ll
00000?ll0P0000?o?0000000=_ll000loc`01@00occo??ll00001Oll00<00?lloc`00_ll00<00?ll
oc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00oll00<00?lloc`00_ll00<00?ll
oc`00_ll00<00?lloc`00oll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?ll
oc`00oll00<00?lloc`00_ll00<00?lloc`00_ll0P001?ll00<00?lloc`00_ll00@00?lloc`000;o
?004003o??ll0002oc`01P00occo?000oc`000;o?003003o?00000;o?00N003o?000oc`00?ll003o
?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll0P0000Oo?000oc`00?ll
003o?0030002oc`200001?ll00000?ll0P000_ll00<00?lloc`0=?ll000loc`01@00occo??ll0000
1Oll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`0
0oll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`00oll00<00?lloc`00_ll00<00?lloc`0
0_ll00<00?lloc`00_ll00<00?lloc`00oll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`0
0oll00<00?lloc`00_ll00@00?lloc`000;o?004003o??ll0002oc`01P00occo?000oc`000;o?005
003o?000oc`00002oc`07000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll
003o?000oc`00?ll0P0000Go?000oc`00?ll00800003oc`0000000;o?0800004oc`00000oc`2000i
oc`003co?005003o??lloc`00005oc`00`00occo?002oc`00`00occo?002oc`00`00occo?002oc`0
0`00occo?002oc`00`00occo?003oc`00`00occo?002oc`00`00occo?002oc`00`00occo?003oc`0
0`00occo?002oc`00`00occo?002oc`00`00occo?002oc`00`00occo?003oc`00`00occo?002oc`0
0`00occo?002oc`00`00occo?003oc`00`00occo?002oc`01000occo?0000_ll00@00?lloc`000;o
?006003o??ll003o?0000_ll00D00?ll003o?00000;o?00L003o?000oc`00?ll003o?000oc`00?ll
003o?000oc`00?ll003o?000oc`00?ll003o?000oc`200001Oll003o?000oc`00P0000?o?0000000
0_ll0P0000Co?000003o?08003Wo?000??ll00D00?llocco?00000Go?003003o??ll00;o?003003o
??ll00;o?003003o??ll00;o?003003o??ll00;o?003003o??ll00?o?003003o??ll00;o?003003o
??ll00;o?003003o??ll00?o?003003o??ll00;o?003003o??ll00;o?003003o??ll00;o?003003o
??ll00?o?005003o??lloc`00005oc`20004oc`00`00occo?002oc`01000occo?0000_ll00@00?ll
oc`000;o?006003o??ll003o?0000_ll00D00?ll003o?00000;o?00L003o?000oc`00?ll003o?000
oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`200001Oll003o?000oc`00P0000?o
?00000000_ll0P0000Co?000003o?08003Wo?000??ll00D00?llocco?00000Go?003003o??ll00;o
?003003o??ll00;o?003003o??ll00;o?003003o??ll00;o?003003o??ll00?o?003003o??ll00;o
?003003o??ll00;o?003003o??ll00?o?003003o??ll00;o?003003o??ll00;o?003003o??ll00;o
?003003o??ll00?o?005003o??lloc`00005oc`20004oc`00`00occo?002oc`01000occo?0000_ll
00@00?lloc`000;o?006003o??ll003o?0000_ll00D00?ll003o?00000;o?00L003o?000oc`00?ll
003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`200001Oll003o?000oc`0
0P0000?o?00000000_ll0P0000Co?000003o?08003Wo?000??ll00D00?llocco?00000Go?003003o
??ll00;o?003003o??ll00;o?003003o??ll00;o?003003o??ll00?o?003003o??ll00;o?003003o
??ll00;o?003003o??ll00;o?003003o??ll00?o?003003o??ll00;o?003003o??ll00;o?003003o
??ll00;o?003003o??ll00?o?005003o??lloc`00005oc`20004oc`00`00occo?002oc`01000occo
?0000_ll00@00?lloc`000;o?006003o??ll003o?0000_ll00D00?ll003o?00000;o?00L003o?000
oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`200001Oll003o
?000oc`00P0000?o?00000000_ll0P0000?o?00000000_ll00<00?lloc`0=oll000moc`00`00oc`0
0006oc`00`00occo?002oc`00`00occo?002oc`00`00occo?002oc`00`00occo?003oc`00`00occo
?002oc`00`00occo?002oc`00`00occo?002oc`00`00occo?003oc`00`00occo?002oc`00`00occo
?002oc`00`00occo?002oc`00`00occo?003oc`01@00occo??ll00001Oll0P001?ll00<00?lloc`0
0_ll00@00?lloc`000;o?004003o??ll0002oc`01P00occo?000oc`000;o?005003o?000oc`00002
oc`07000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll
0P0000Go?000oc`00?ll00800003oc`0000000;o?0800003oc`0000003co?000?Oll00<00?ll0000
1_ll00D00?llocco?00000Go?003003o??ll00;o?003003o??ll00?o?003003o??ll00;o?003003o
??ll00;o?003003o??ll00;o?003003o??ll00?o?003003o??ll00;o?003003o??ll00?o?005003o
??lloc`00005oc`01@00occo??ll00001Oll0P001?ll00<00?lloc`00_ll00@00?lloc`000?o?003
003o?00000;o?006003o??ll003o?0000_ll00D00?ll003o?00000;o?00L003o?000oc`00?ll003o
?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`200001Oll003o?000oc`00P00
00?o?00000000_ll0P0000?o?0000000??ll000moc`00`00oc`00006oc`01@00occo??ll00001Oll
00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Go?003003o??ll00;o?003003o??ll
00?o?003003o??ll00;o?003003o??ll00?o?005003o??lloc`00005oc`01@00occo??ll00001Oll
0P001?ll00<00?lloc`00_ll00@00?lloc`000?o?003003o?00000;o?006003o??ll003o?0000_ll
00D00?ll003o?00000;o?00L003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000
oc`00?ll003o?000oc`200001Oll003o?000oc`00P0000?o?00000000_ll0P0000?o?0000000??ll
000moc`00`00oc`00006oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00D0
0?llocco?00000Go?003003o??ll00;o?003003o??ll00?o?005003o??lloc`00006oc`01@00occo
??ll00001Oll00D00?llocco?00000Go?08000Co?003003o??ll00;o?004003o??ll0003oc`00`00
oc`00002oc`01P00occo?000oc`000;o?005003o?000oc`00002oc`07000oc`00?ll003o?000oc`0
0?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll0P0000Go?000oc`00?ll00800003
oc`0000000;o?0800003oc`0000003co?000?Oll00<00?ll00001_ll00D00?llocco?00000Go?003
003o??ll00;o?003003o??ll00?o?005003o??lloc`00005oc`00`00occo?002oc`00`00occo?003
oc`01@00occo??ll00001_ll00D00?llocco?00000Go?005003o??lloc`00005oc`20004oc`00`00
occo?002oc`01000occo?0000oll00<00?ll00000_ll00H00?lloc`00?ll0002oc`01@00oc`00?ll
00000_ll01`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll
003o?0800005oc`00?ll003o?00200000oll00000002oc`20002oc`00`00occo?00joc`003go?003
003o?00000Ko?005003o??lloc`00005oc`00`00occo?002oc`00`00occo?003oc`01@00occo??ll
00001Oll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Ko?005003o??lloc`00005
oc`01@00occo??ll00001Oll0P001?ll00<00?lloc`00_ll00@00?lloc`000?o?003003o?00000;o
?006003o??ll003o?0000_ll00D00?ll003o?00000;o?007003o?000oc`00?ll00000_ll0P00017o
?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll00800003oc`0000000;o?0800003oc`00000
00;o?08003oo?000?Oll00<00?ll00001oll00@00?lloc`000Ko?005003o??lloc`00005oc`01@00
occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Ko?005003o??ll
oc`00005oc`01@00occo??ll00001Oll0P001?ll00<00?lloc`00_ll00@00?lloc`000?o?003003o
?00000;o?006003o??ll003o?0000_ll00D00?ll003o?00000;o?007003o?000oc`00?ll00000_ll
0P00017o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll00800003oc`0000000;o?0800003
oc`0000000;o?08003oo?000?_ll00<00?lloc`01_ll00@00?lloc`000Ko?005003o??lloc`00005
oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Ko?005
003o??lloc`00005oc`01@00occo??ll00001Oll0P001?ll00<00?lloc`00_ll00@00?lloc`000?o
?003003o?00000;o?006003o??ll003o?0000_ll00D00?ll003o?00000;o?007003o?000oc`00?ll
00000_ll0P00017o?000oc`00?ll003o?000oc`00?ll003o?000oc`00?ll00800003oc`0000000;o
?0800003oc`0000000;o?08003oo?000?_ll00<00?lloc`01_ll00@00?lloc`000Ko?005003o??ll
oc`00005oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?000
00Ko?005003o??lloc`00005oc`01@00occo??ll00001Oll0P001?ll00<00?lloc`00_ll00@00?ll
oc`000?o?003003o?00000;o?006003o??ll003o?0000_ll00D00?ll003o?00000;o?007003o?000
oc`00?ll00000_ll0P000_ll0P0000go?000oc`00?ll003o?000oc`00?ll003o?00200000oll0000
0002oc`200000oll00000002oc`00`00occo?00noc`004Oo?004003o??ll0006oc`01@00occo??ll
00001Oll00D00?llocco?00000Go?003003o??ll00;o?003003o??ll00?o?005003o??lloc`00006
oc`01@00occo??ll00001Oll00D00?llocco?00000Go?08000Co?003003o??ll00;o?004003o??ll
0003oc`00`00oc`00002oc`01P00occo?000oc`000;o?005003o?000oc`00002oc`01`00oc`00?ll
003o?00000;o?08000;o?080000=oc`00?ll003o?000oc`00?ll003o?000oc`00P0000?o?0000000
0_ll0P0000?o?00000000_ll00<00?lloc`0?_ll0017oc`01000occo?0001_ll00D00?llocco?000
00Go?005003o??lloc`00005oc`00`00occo?002oc`00`00occo?003oc`01@00occo??ll00001_ll
0P000_ll00<00?ll00000oll1@001Oll0P001?ll00<00?lloc`00_ll00@00?lloc`000?o?003003o
?00000;o?006003o??ll003o?0000_ll00D00?ll003o?00000;o?003003o?00000;o?08000;o?080
00;o?0800009oc`00?ll003o?000oc`00?ll008000;o?0800003oc`0000000;o?0800003oc`00000
00;o?003003o??ll03ko?000Aoll00@00?lloc`000Ko?004003o??ll0006oc`01@00occo??ll0000
1Oll00<00?lloc`00_ll00<00?lloc`00oll00D00?llocco?00000Go?0800004oc`00?ll0005oc`0
0`00occo?0020005oc`20004oc`00`00occo?002oc`01000occo?0000oll00<00?ll00000_ll00H0
0?lloc`00?ll0002oc`01@00oc`00?ll00000_ll00<00?ll00000_ll0P000_ll0P000_ll0P0000Wo
?000oc`00?ll003o?000oc`00P000_ll0P0000?o?00000000_ll0P0000?o?0000000@oll0017oc`0
1000occo?0001_ll00@00?lloc`000Ko?005003o??lloc`00005oc`00`00occo?002oc`00`00occo
?003oc`01@00occo??ll00001Oll0P0000Co?000oc`000Go?003003o??ll008000Go?0<000?o?003
003o??ll00;o?004003o??ll0003oc`00`00oc`00002oc`02000occo?000oc`00?ll0003oc`20002
oc`00`00oc`00002oc`20002oc`20002oc`20002oc`200001Oll003o?000oc`00P000_ll0P0000?o
?00000000_ll0P000_ll00<00?lloc`0@Oll0017oc`00`00oc`00007oc`01000occo?0001_ll00D0
0?llocco?00000Go?003003o??ll00;o?003003o??ll00?o?005003o??lloc`00005oc`200001?ll
003o?0001Oll00<00?lloc`00P001Oll0P001?ll00<00?lloc`00_ll00@00?lloc`000?o?003003o
?00000;o?008003o??ll003o?000oc`000?o?08000;o?003003o?00000;o?08000;o?08000;o?080
00;o?0800005oc`00?ll003o?0020002oc`200000oll00000002oc`20002oc`00`00occo?011oc`0
04Oo?003003o?00000Oo?004003o??ll0006oc`01@00occo??ll00001Oll00<00?lloc`00_ll00<0
0?lloc`00oll00D00?llocco?00000Go?0800004oc`00?ll0005oc`00`00occo?0020005oc`20004
oc`00`00occo?002oc`01000occo?0000oll00<00?ll00000_ll00P00?lloc`00?ll003o?0000oll
0P000_ll00<00?ll00000_ll0P000_ll0P000_ll0P000_ll0P0000Go?000oc`00?ll008000;o?080
0003oc`0000000;o?08000;o?003003o??ll047o?000Aoll00<00?ll00001oll00@00?lloc`000Ko
?005003o??lloc`00005oc`00`00occo?002oc`00`00occo?003oc`01@00occo??ll00001Oll0P00
00Co?000oc`000Go?0D000Go?08000Co?003003o??ll00;o?004003o??ll0003oc`00`00oc`00002
oc`02000occo?000oc`00?ll0003oc`20002oc`00`00oc`00002oc`20002oc`20002oc`20002oc`2
00001Oll003o?000oc`00P000_ll0P0000?o?00000000_ll0P000_ll00<00?lloc`0@Oll0017oc`0
0`00oc`00007oc`01000occo?0001_ll00D00?llocco?00000Go?003003o??ll00;o?003003o??ll
00?o?005003o??lloc`00006oc`20002oc`00`00occo?003oc`00`00occo?0020005oc`20004oc`0
0`00occo?002oc`01000occo?0000oll00<00?ll00000_ll00P00?lloc`00?ll003o?0000oll0P00
0_ll00<00?ll00000_ll0P000_ll0P000_ll0P000_ll0P0000Go?000oc`00?ll008000;o?0800003
oc`0000000;o?08004Ko?000Aoll00<00?ll00001oll00@00?lloc`000Ko?005003o??lloc`00005
oc`00`00occo?002oc`00`00occo?003oc`01@00occo??ll00001_ll00D00?llocco?00000Go?005
003o??lloc`00005oc`20004oc`00`00occo?002oc`01000occo?0000oll00<00?ll00000_ll00<0
0?ll00000_ll00<00?ll00000oll0P000_ll00<00?ll00000_ll0P000_ll0P000_ll0P000_ll0P00
00Go?000oc`00?ll008000;o?0800003oc`0000000;o?08004Ko?000Aoll00<00?ll00001oll00@0
0?lloc`000Ko?005003o??lloc`00006oc`01@00occo??ll00001Oll00D00?llocco?00000Ko?005
003o??lloc`00005oc`01@00occo??ll00001Oll0P001?ll00<00?lloc`00_ll00@00?lloc`000?o
?003003o?00000;o?003003o?00000?o?08000?o?08000;o?003003o?00000;o?08000;o?08000;o
?08000;o?0800005oc`00?ll003o?0020002oc`200000oll00000002oc`20016oc`004Oo?003003o
?00000Oo?004003o??ll0007oc`01000occo?0001_ll00D00?llocco?00000Go?005003o??lloc`0
0006oc`01@00occo??ll00001Oll00D00?llocco?00000Go?08000Co?003003o??ll00;o?004003o
??ll0003oc`00`00oc`00002oc`00`00oc`00003oc`20003oc`20002oc`00`00oc`00002oc`20002
oc`20002oc`20002oc`200001Oll003o?000oc`00P000_ll0P0000?o?00000000_ll0P00A_ll0018
oc`20007oc`01000occo?0001oll00@00?lloc`000Ko?005003o??lloc`00005oc`01@00occo??ll
00001_ll00D00?llocco?00000Go?005003o??lloc`00005oc`20004oc`00`00occo?002oc`01000
occo?0000oll00<00?ll00000_ll00<00?ll00000oll0P000oll0P000_ll00<00?ll00000_ll0P00
0_ll0P000_ll0P000_ll0P0000?o?00000000_ll0P000_ll0P000_ll00D00?llocco?00004Ko?000
B?ll0P001oll00@00?lloc`000Oo?004003o??ll0006oc`01@00occo??ll00001Oll00D00?llocco
?00000Ko?005003o??lloc`00005oc`01@00occo??ll00001Oll0`000oll00<00?lloc`00_ll00@0
0?lloc`000?o?003003o?00000;o?003003o?00000?o?08000?o?08000;o?003003o?00000;o?080
00;o?08000;o?08000;o?0800003oc`0000000;o?08000;o?08000;o?005003o??lloc`00016oc`0
04So?08000Oo?004003o??ll0007oc`01000occo?0001_ll00D00?llocco?00000Go?005003o??ll
oc`00006oc`01@00occo??ll00001Oll00D00?llocco?00000Go?003003o?00000?o?003003o??ll
00;o?004003o??ll0003oc`00`00oc`00002oc`00`00oc`00003oc`20003oc`20002oc`00`00oc`0
0002oc`20002oc`20002oc`20002oc`200000oll00000002oc`20002oc`20002oc`00`00occo?018
oc`004So?08000Oo?004003o??ll0007oc`01000occo?0001_ll00D00?llocco?00000Go?005003o
??lloc`00006oc`01@00occo??ll00001Oll00D00?llocco?00000Go?003003o?00000?o?003003o
??ll00;o?004003o??ll0003oc`00`00oc`00002oc`00`00oc`00003oc`20003oc`20002oc`00`00
oc`00002oc`20002oc`20002oc`20002oc`200000oll00000002oc`20002oc`20002oc`00`00occo
?018oc`004So?08000Oo?004003o??ll0007oc`01000occo?0001_ll00D00?llocco?00000Go?005
003o??lloc`00006oc`01@00occo??ll00001Oll00D00?llocco?00000Go?003003o?00000;o?003
003o??ll00?o?004003o??ll0003oc`00`00oc`00002oc`00`00oc`00003oc`20003oc`20002oc`0
0`00oc`00002oc`20002oc`20002oc`20002oc`20002oc`00`00occo?0020002oc`20002oc`00`00
occo?018oc`004So?08000Oo?004003o??ll0007oc`01000occo?0001_ll00D00?llocco?00000Go
?005003o??lloc`00006oc`01@00occo??ll00001Oll00D00?llocco?00000Go?003003o?00000;o
?003003o??ll00?o?004003o??ll0003oc`00`00oc`00002oc`00`00oc`00003oc`20003oc`20002
oc`00`00oc`00002oc`20002oc`20002oc`20002oc`20002oc`00`00occo?0020002oc`20002oc`0
0`00occo?018oc`004So?08000Oo?004003o??ll0007oc`00`00oc`00007oc`01@00occo??ll0000
1Oll00D00?llocco?00000Ko?005003o??lloc`00005oc`01@00occo??ll00001Oll0`000_ll00<0
0?lloc`00oll00@00?lloc`000?o?003003o?00000;o?003003o?00000?o?08000?o?08000;o?003
003o?00000;o?08000;o?08000;o?08000;o?08000;o?003003o??ll008000;o?08000;o?003003o
??ll04So?000D_ll00<00?ll00001oll00<00?ll00001oll00D00?llocco?00000Go?005003o??ll
oc`00006oc`01@00occo??ll00001Oll00D00?llocco?00000Go?003003o?00000;o?003003o??ll
00?o?004003o??ll0003oc`00`00oc`00002oc`00`00oc`00003oc`20003oc`20002oc`00`00oc`0
0002oc`20002oc`20002oc`20002oc`20002oc`00`00occo?0020002oc`01@00occo??ll0000B_ll
001Boc`00`00oc`00007oc`00`00oc`00007oc`01@00occo??ll00001Oll00D00?llocco?00000Ko
?005003o??lloc`00005oc`01@00occo??ll00001Oll00<00?ll00000_ll00<00?lloc`00oll00@0
0?lloc`000?o?003003o?00000?o?08000?o?08000?o?08000;o?003003o?00000;o?08000;o?080
00;o?08000;o?08000;o?003003o??ll008000;o?003003o??ll04co?000D_ll00<00?ll00001oll
00<00?ll00001oll00@00?lloc`000Ko?005003o??lloc`00006oc`01@00occo??ll00001Oll00D0
0?llocco?00000Go?003003o?00000;o?003003o??ll00?o?004003o??ll0003oc`00`00oc`00003
oc`20003oc`20003oc`20002oc`00`00oc`00002oc`20002oc`20002oc`20002oc`20002oc`00`00
occo?0020002oc`00`00occo?01<oc`005;o?003003o?00000Oo?003003o?00000Oo?004003o??ll
0006oc`01@00occo??ll00001_ll00D00?llocco?00000Go?005003o??lloc`00005oc`30002oc`0
0`00occo?003oc`01000occo?0000oll00<00?ll00000oll0P000oll0P000oll0P000_ll00<00?ll
00000_ll0P000_ll0P000_ll0P000_ll0P000_ll00<00?lloc`00P000_ll00<00?lloc`0C?ll001B
oc`00`00oc`00007oc`00`00oc`00007oc`01000occo?0001_ll00D00?llocco?00000Ko?005003o
??lloc`00005oc`01@00occo??ll00001Oll00<00?ll00000_ll00<00?lloc`00oll00<00?ll0000
1?ll00<00?ll00000oll0P000oll0P000oll0P000_ll00<00?ll00000_ll0P000_ll0P000_ll0P00
0_ll0P000_ll00<00?lloc`00P000_ll00<00?lloc`0C?ll001Boc`00`00oc`00007oc`00`00oc`0
0007oc`01000occo?0001_ll00D00?llocco?00000Ko?005003o??lloc`00005oc`01@00occo??ll
00001Oll00<00?ll00000_ll00<00?lloc`00oll00<00?ll00001?ll00<00?ll00000oll0P000oll
0P000oll0P000_ll00<00?ll00000_ll0P000_ll0P000_ll0P000_ll0P000_ll00D00?llocco?000
00;o?003003o??ll04co?000D_ll00<00?ll00001oll00<00?ll00001oll00@00?lloc`000Ko?005
003o??lloc`00006oc`20002oc`00`00oc`00003oc`50005oc`00`00oc`00002oc`00`00occo?003
oc`00`00oc`00004oc`00`00oc`00003oc`20003oc`20003oc`20002oc`00`00oc`00002oc`20002
oc`20002oc`20002oc`20002oc`01@00occo??ll0000DOll001Boc`00`00oc`00007oc`00`00oc`0
0007oc`01000occo?0001_ll00D00?llocco?00000Go?0800004oc`00?ll0005oc`20002oc`00`00
occo?003oc`00`00oc`00002oc`00`00occo?003oc`00`00oc`00004oc`00`00oc`00003oc`20003
oc`20003oc`20002oc`00`00oc`00002oc`20002oc`20002oc`20002oc`20002oc`01@00occo??ll
0000DOll001Boc`00`00oc`00007oc`00`00oc`00007oc`01000occo?0001oll00@00?lloc`000Go
?0800004oc`00?ll0005oc`01@00oc`00?ll00001Oll0`000_ll00<00?lloc`00oll00<00?ll0000
1?ll00<00?ll00000oll0P000oll0P000oll0P000_ll00<00?ll00000_ll0P000_ll0P000_ll0P00
0_ll0P000_ll00D00?llocco?000057o?000D_ll0P002?ll00<00?ll00001oll00@00?lloc`000Oo
?004003o??ll0005oc`200001?ll003o?0001Oll00<00?lloc`00P001Oll00<00?ll00000_ll00<0
0?lloc`00oll00<00?ll00001?ll00<00?ll00000oll0P000oll0P000oll0P000_ll0P000oll0P00
0_ll0P000_ll0P000_ll0P000_ll00D00?llocco?000057o?000D_ll0P002?ll00<00?ll00001oll
00@00?lloc`000Oo?004003o??ll0005oc`200001?ll003o?0001Oll00D00?llocco?00000Go?003
003o?00000;o?003003o??ll00?o?003003o?00000Co?003003o?00000?o?08000?o?08000?o?080
00;o?08000?o?08000;o?08000;o?08000;o?08000;o?005003o??lloc`0001Aoc`005;o?08000So
?003003o?00000Oo?004003o??ll0007oc`01000occo?0001Oll0P0000Co?000oc`000Go?08000;o
?003003o??ll00?o?003003o?00000;o?003003o??ll00?o?003003o?00000Co?003003o?00000?o
?08000?o?08000?o?08000;o?08000?o?08000;o?08000;o?08000;o?08000;o?003003o??ll05?o
?000D_ll0P002?ll00<00?ll00001oll00@00?lloc`000Oo?004003o??ll0006oc`20002oc`00`00
occo?003oc`00`00oc`000020005oc`00`00oc`00002oc`00`00occo?003oc`00`00oc`00004oc`0
0`00oc`00003oc`20003oc`20003oc`20002oc`20003oc`20002oc`20002oc`20002oc`20002oc`0
0`00occo?01Coc`005;o?08000So?003003o?00000Oo?004003o??ll0007oc`00`00oc`00007oc`0
1000occo?0001oll00@00?lloc`000Go?0<000;o?003003o??ll00?o?003003o?00000Co?003003o
?00000?o?08000?o?08000?o?08000;o?08000?o?08000;o?08000;o?08000;o?08000;o?003003o
??ll05?o?000G?ll00<00?ll00001oll00@00?lloc`000Oo?003003o?00000Oo?004003o??ll0007
oc`01000occo?0001Oll00<00?ll00000_ll00<00?lloc`00oll00<00?ll00001?ll00<00?ll0000
0oll0P000oll0P000oll0P000_ll0P000oll0P000_ll0P000_ll0P000_ll0P000_ll00<00?lloc`0
Doll001Loc`00`00oc`00007oc`01000occo?0001oll00<00?ll00001oll00@00?lloc`000Oo?004
003o??ll0005oc`00`00oc`00002oc`00`00occo?003oc`00`00oc`00004oc`00`00oc`00003oc`2
0003oc`20003oc`20002oc`20003oc`20002oc`20002oc`01000occo??ll0P000_ll00<00?lloc`0
Doll001Loc`00`00oc`00007oc`01000occo?0001oll00<00?ll00001oll00@00?lloc`000Oo?004
003o??ll0005oc`01P00occo?000oc`000Go?003003o?00000Co?003003o?00000?o?08000?o?080
00?o?08000;o?08000?o?08000;o?08000;o?005003o??lloc`0001Ioc`005co?003003o?00000Oo
?004003o??ll0007oc`00`00oc`00007oc`01000occo?0001oll00@00?lloc`000Go?0800004oc`0
0?ll0005oc`00`00oc`00004oc`00`00oc`00003oc`20003oc`20003oc`20002oc`20003oc`20002
oc`20002oc`01@00occo??ll0000FOll001Moc`20007oc`01000occo?0001oll00<00?ll00001oll
00@00?lloc`000Oo?004003o??ll0005oc`01P00occo?000oc`000Go?003003o?00000Co?003003o
?00000?o?08000?o?08000?o?08000;o?08000?o?08000;o?08000;o?005003o??lloc`0001Ioc`0
05go?08000Oo?004003o??ll0007oc`00`00oc`00007oc`01000occo?0001oll00@00?lloc`000Go
?006003o??ll003o?0001Oll00<00?ll00001?ll00<00?ll00000oll0P000oll0P000oll0P000_ll
0P000oll0P000_ll0P000_ll00D00?llocco?00005Wo?000GOll0P002?ll00<00?ll00001oll00<0
0?ll00001oll00@00?lloc`000Oo?004003o??ll0005oc`01P00occo?000oc`000Go?003003o?000
00Co?003003o?00000?o?08000?o?08000?o?08000;o?08000?o?08000;o?08000;o?003003o??ll
05_o?000GOll0P002?ll00<00?ll00001oll00<00?ll00001oll00@00?lloc`000Oo?004003o??ll
0005oc`01P00occo?000oc`000Go?003003o?00000Co?003003o?00000?o?08000?o?08000?o?080
00?o?004003o??lloc`20002oc`20002oc`00`00occo?01Koc`005go?08000So?003003o?00000Oo
?003003o?00000Oo?004003o??ll0007oc`01000occo?0001Oll0P0000Co?000oc`000Go?003003o
?00000Co?003003o?00000?o?08000?o?08000?o?08000?o?005003o??lloc`00003oc`01@00occo
??ll0000GOll001Moc`20008oc`00`00oc`00007oc`00`00oc`00008oc`00`00oc`00007oc`00`00
oc`00006oc`01P00occo?000oc`000Go?003003o?00000Co?003003o?00000?o?08000?o?08000?o
?08000?o?005003o??lloc`00003oc`01@00occo??ll0000GOll001Moc`20008oc`00`00oc`00007
oc`00`00oc`00008oc`00`00oc`00007oc`00`00oc`00006oc`01P00occo?000oc`000Go?003003o
?00000Co?003003o?00000?o?08000?o?08000?o?08000?o?005003o??lloc`00003oc`00`00occo
?01Ooc`005go?003003o??ll00Oo?003003o?00000Oo?003003o?00000So?003003o?00000Oo?003
003o?00000Ko?006003o??ll003o?0001Oll00<00?ll00001?ll00<00?ll00000oll0P000oll0P00
0oll0P000oll00D00?llocco?00000?o?003003o??ll05oo?000Ioll00<00?ll00001oll00<00?ll
00002?ll00<00?ll00001oll00<00?ll00001_ll0P0000Co?000oc`000Go?003003o?00000Co?003
003o?00000?o?08000?o?08000?o?08000?o?005003o??lloc`00003oc`00`00occo?01Ooc`006Oo
?08000So?003003o?00000So?003003o?00000Oo?003003o?00000Ko?006003o??ll003o?0001Oll
00<00?ll00001?ll0P001?ll0P000oll0P000oll0P000oll00D00?llocco?00000?o?003003o??ll
05oo?000Ioll0P002?ll00<00?ll00002?ll00<00?ll00001oll00<00?ll00001_ll00H00?lloc`0
0?ll0006oc`20004oc`20004oc`20003oc`20003oc`20003oc`01@00occo??ll0000IOll001Woc`2
0008oc`00`00oc`00007oc`200001Oll003o??ll00001?ll0`001_ll00H00?lloc`00?ll0006oc`2
0004oc`20004oc`20003oc`20003oc`20003oc`01@00occo??ll0000IOll001Woc`20008oc`00`00
oc`00006oc`00`00oc`000020007oc`01000oc`000001Oll00H00?lloc`00?ll0006oc`20004oc`2
0004oc`20003oc`20003oc`20003oc`01@00occo??ll0000IOll001Woc`20008oc`00`00oc`00006
oc`00`00oc`000020007oc`01000oc`000001Oll100000?o?000oc`01Oll0P001?ll0P001?ll0P00
0oll0P000oll0P000oll00D00?llocco?00006Go?000J?ll00<00?lloc`01_ll00<00?ll00001_ll
00<00?ll00000P001oll0`001_ll00H00?lloc`00?ll0006oc`20004oc`20004oc`20003oc`20003
oc`20003oc`00`00occo?01Woc`006So?003003o??ll00Oo?08000Ko?003003o?000008000Oo?004
003o?0000005oc`01P00occo?000oc`000Ko?08000Co?08000Co?08000?o?08000?o?08000?o?003
003o??ll06Oo?000J?ll00<00?lloc`01oll0P001_ll00<00?ll00000P001oll00@00?ll000000Go
?006003o??ll003o?0001_ll0P001?ll0P001?ll0P000oll0P000oll0P000oll00<00?lloc`0Ioll
001boc`20007oc`200000oll003o?006oc`30006oc`200001?ll003o?0001_ll0P001?ll0P001?ll
0P000oll0P000oll00<00?lloc`0K?ll001boc`20008oc`20008oc`00`00oc`00006oc`01P00occo
?000oc`000Ko?08000Co?08000Co?08000?o?08000?o?003003o??ll06co?000L_ll0P002?ll0P00
2?ll00<00?ll00001_ll00H00?lloc`00?ll0006oc`20004oc`20004oc`20003oc`20003oc`00`00
occo?01/oc`007;o?08000So?08000So?003003o?00000Ko?006003o??ll003o?0001_ll0P001?ll
0P001?ll0P000oll0P00L_ll001boc`00`00occo?007oc`20008oc`00`00oc`00006oc`01P00occo
?000oc`000Ko?08000Co?08000Co?003003o??ll00;o?003003o??ll077o?000L_ll00<00?lloc`0
1oll0P002Oll0P001_ll0P0000Co?000oc`000Ko?08000Co?08000Co?003003o??ll07Ko?000O?ll
0P002Oll0P001_ll00H00?lloc`00?ll0006oc`20005oc`00`00occo?002oc`00`00occo?01foc`0
07co?08000Wo?08000Ko?003003o??ll008000Oo?08000Go?003003o??ll00;o?003003o??ll07Ko
?000O?ll0P002Oll0P001_ll00<00?lloc`00P001oll0P001Oll00<00?lloc`0Noll001moc`00`00
occo?007oc`20006oc`01@00occo??ll00001oll0P001Oll00<00?lloc`0Noll0027oc`00`00occo
?005oc`20002oc`00`00occo?005oc`00`00occo?022oc`008Oo?003003o??ll00Go?005003o??ll
oc`0002<oc`008oo?003003o??ll08ko?000Soll00<00?lloc`0S_ll002?oc`2002?oc`008oo?003
003o??ll08ko?000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-13.6839, -0.386027, \
0.095358, 0.00436158}}]
}, Open  ]],

Cell["And visualize its STFT", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListDensityPlot[Abs[stft[f, g, 0.1]], Mesh \[Rule] False, 
          PlotRange \[Rule] All, AspectRatio \[Rule] Automatic];\) // 
      Timing\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00480769 0.00961538 0.00480769 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -6 -9 ]
[.25962 -0.0125 6 0 ]
[.5 -0.0125 -9 -9 ]
[.5 -0.0125 9 0 ]
[.74038 -0.0125 -9 -9 ]
[.74038 -0.0125 9 0 ]
[.98077 -0.0125 -9 -9 ]
[.98077 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .00962 -6 -4.5 ]
[-0.0125 .00962 0 4.5 ]
[-0.0125 .10577 -12 -4.5 ]
[-0.0125 .10577 0 4.5 ]
[-0.0125 .20192 -12 -4.5 ]
[-0.0125 .20192 0 4.5 ]
[-0.0125 .29808 -12 -4.5 ]
[-0.0125 .29808 0 4.5 ]
[-0.0125 .39423 -12 -4.5 ]
[-0.0125 .39423 0 4.5 ]
[-0.0125 .49038 -18 -4.5 ]
[-0.0125 .49038 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .5 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(50)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(100)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(150)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(200)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.06731 0 m
.06731 .00375 L
s
.11538 0 m
.11538 .00375 L
s
.16346 0 m
.16346 .00375 L
s
.21154 0 m
.21154 .00375 L
s
.30769 0 m
.30769 .00375 L
s
.35577 0 m
.35577 .00375 L
s
.40385 0 m
.40385 .00375 L
s
.45192 0 m
.45192 .00375 L
s
.54808 0 m
.54808 .00375 L
s
.59615 0 m
.59615 .00375 L
s
.64423 0 m
.64423 .00375 L
s
.69231 0 m
.69231 .00375 L
s
.78846 0 m
.78846 .00375 L
s
.83654 0 m
.83654 .00375 L
s
.88462 0 m
.88462 .00375 L
s
.93269 0 m
.93269 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .00962 m
.00625 .00962 L
s
[(0)] -0.0125 .00962 1 0 Mshowa
0 .10577 m
.00625 .10577 L
s
[(20)] -0.0125 .10577 1 0 Mshowa
0 .20192 m
.00625 .20192 L
s
[(40)] -0.0125 .20192 1 0 Mshowa
0 .29808 m
.00625 .29808 L
s
[(60)] -0.0125 .29808 1 0 Mshowa
0 .39423 m
.00625 .39423 L
s
[(80)] -0.0125 .39423 1 0 Mshowa
0 .49038 m
.00625 .49038 L
s
[(100)] -0.0125 .49038 1 0 Mshowa
.125 Mabswid
0 .03365 m
.00375 .03365 L
s
0 .05769 m
.00375 .05769 L
s
0 .08173 m
.00375 .08173 L
s
0 .12981 m
.00375 .12981 L
s
0 .15385 m
.00375 .15385 L
s
0 .17788 m
.00375 .17788 L
s
0 .22596 m
.00375 .22596 L
s
0 .25 m
.00375 .25 L
s
0 .27404 m
.00375 .27404 L
s
0 .32212 m
.00375 .32212 L
s
0 .34615 m
.00375 .34615 L
s
0 .37019 m
.00375 .37019 L
s
0 .41827 m
.00375 .41827 L
s
0 .44231 m
.00375 .44231 L
s
0 .46635 m
.00375 .46635 L
s
.25 Mabswid
0 0 m
0 .5 L
s
.01923 .49375 m
.01923 .5 L
s
.25962 .49375 m
.25962 .5 L
s
.5 .49375 m
.5 .5 L
s
.74038 .49375 m
.74038 .5 L
s
.98077 .49375 m
.98077 .5 L
s
.125 Mabswid
.06731 .49625 m
.06731 .5 L
s
.11538 .49625 m
.11538 .5 L
s
.16346 .49625 m
.16346 .5 L
s
.21154 .49625 m
.21154 .5 L
s
.30769 .49625 m
.30769 .5 L
s
.35577 .49625 m
.35577 .5 L
s
.40385 .49625 m
.40385 .5 L
s
.45192 .49625 m
.45192 .5 L
s
.54808 .49625 m
.54808 .5 L
s
.59615 .49625 m
.59615 .5 L
s
.64423 .49625 m
.64423 .5 L
s
.69231 .49625 m
.69231 .5 L
s
.78846 .49625 m
.78846 .5 L
s
.83654 .49625 m
.83654 .5 L
s
.88462 .49625 m
.88462 .5 L
s
.93269 .49625 m
.93269 .5 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.99375 .00962 m
1 .00962 L
s
.99375 .10577 m
1 .10577 L
s
.99375 .20192 m
1 .20192 L
s
.99375 .29808 m
1 .29808 L
s
.99375 .39423 m
1 .39423 L
s
.99375 .49038 m
1 .49038 L
s
.125 Mabswid
.99625 .03365 m
1 .03365 L
s
.99625 .05769 m
1 .05769 L
s
.99625 .08173 m
1 .08173 L
s
.99625 .12981 m
1 .12981 L
s
.99625 .15385 m
1 .15385 L
s
.99625 .17788 m
1 .17788 L
s
.99625 .22596 m
1 .22596 L
s
.99625 .25 m
1 .25 L
s
.99625 .27404 m
1 .27404 L
s
.99625 .32212 m
1 .32212 L
s
.99625 .34615 m
1 .34615 L
s
.99625 .37019 m
1 .37019 L
s
.99625 .41827 m
1 .41827 L
s
.99625 .44231 m
1 .44231 L
s
.99625 .46635 m
1 .46635 L
s
.25 Mabswid
1 0 m
1 .5 L
s
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
% Start of gray image
p
.01923 .00962 translate
.96154 .48076 scale
200 string
200 100 8 [200 0 0 100 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010000000001000000000101000000
0101000000010100000001010000010101010100000000000204080D12181D212323211D
19140F0B0805030101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000101000000
010101010101010101010101010101010101010101010101010101010101010101010101
0101010101010101010101010101010202020100000000010305090E141A1F222424221E
1A15100B0805030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000010101010101010101010101010101010101010101010101
010101010101020201020202020202020202020202020202020202020202020202020202
02020202020202020202020202020303030202010000010204070C11171C212526262420
1B16110C0805030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000101010101010101010101020202020202020202020202020202
020203030303030303030303030303030303030303030304040404040404040404040404
040404040404040404040404040404040404030201020305070B0F151B2125292A292622
1D17120D0906030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000101010101010202020202020202030303030303030303030404040404
040404040405050505050505050505050606060606060606060606060606060606070707
0707070707070707070707070707070707060505040506080B10151B21262B2E2F2D2A25
1F19130E0A06040201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000010101010102020202030303030404040404040505050505060606060606
070707070707080808080808080809090909090909090A0A0A0A0A0A0A0A0A0A0A0A0B0B
0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0A090909090B0E12161C22282E323434322E29
231C16100B07040301000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000000000001010102020203030304040405050506060607070707080808090909090A
0A0A0B0B0B0B0C0C0C0C0C0D0D0D0D0D0E0E0E0E0E0F0F0F0F0F0F0F1010101010101010
111111111111111111111111111111111110100F101113161A20262C32373B3C3C39342E
271F18120D08050302010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000001010102020203030404050606070708080809090A0A0B0B0C0C0D0D0D0E0E
0F0F10101011111112121213131314141415151515161616161717171717181818181818
191919191919191A1A1A1A1A1A1A1A1919191919191B1E21262C32383E42454645413B34
2C231B140F0A060402010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000000000101020203030404050606070809090A0B0C0C0D0E0E0F1010111212131414
1516161717181819191A1A1B1B1C1C1D1D1E1E1E1F1F1F20202021212122222222232323
232424242424252525252525252525252525252526292C30353B41474C5052514F4A433B
31281F18110C080503010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000000010101020203040505060708090A0B0C0D0E0F101112131415161718191A1B1C
1D1E1E1F20212222232424252627272828292A2A2B2B2C2C2D2D2E2E2E2F2F3030303131
3132323232333333333434343434343434343435373A3D42474D52585C5F605F5B544C43
382E241C140E090603020100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
0000000001010202030405050708090A0B0D0E0F111214151618191B1C1D1F2021222425
2627292A2B2C2D2E2F3031323334353536373839393A3B3B3C3D3D3E3E3F404041414142
42434344444445454545464646464646474748494B4E52575C61676B6F70706D6860574C
41352A2018110C0705030101000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000001010102030304050608090B0C0E0F11131517191A1C1E2022242527292B2C2E30
3133343637393A3C3D3E4041424344454748494A4B4C4C4D4E4F50515152535454555556
5757585859595A5A5A5B5B5B5C5C5C5D5D5E5F6163666A6E73787D808383827D776E6357
4A3D31261C150E0A06040201000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000010102020304050607090B0C0E10121517191B1E202325272A2C2E31333537393B
3E4042444547494B4D4E505253555658595A5C5D5E5F6162636465666768696A6B6B6C6D
6E6E6F707071717272737374747575767677797B7D8084888C9194979897948F877C7063
5546392D2219120C08050302010000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
0000000101020203040507080A0C0E101315181B1D202326292C2F3235383A3D40434548
4B4D50525557595B5D6062646667696B6D6F707273757678797A7C7D7E7F808283848586
868788898A8A8B8C8C8D8D8E8F8F909191939496999C9FA3A6A9ACADADABA7A0978B7E70
60514235291E16100B070403010100000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
0000000101020304050608090B0D101215181B1E2225292C2F33373A3E4144484B4E5255
585B5E616467696C6F717476787B7D7F81838587898B8D8E909193959697999A9B9C9E9F
A0A1A2A3A4A5A5A6A7A8A8A9AAAAABACADAEB0B2B4B7B9BCBFC1C3C3C2BEB9B1A79B8D7D
6D5C4D3E30251B140E090604020101000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000001010203040506080A0C0F1114171B1E22262A2D31363A3E42464A4E52565A5D61
65686C6F7276797C7F8285888A8D90929597999C9EA0A2A4A6A8A9ABADAEB0B1B3B4B6B7
B8B9BBBCBDBEBFC0C0C1C2C3C4C4C5C6C7C8CACCCDCFD1D4D5D6D7D6D4D0CAC1B7AA9B8B
7A6958483A2D2219120C0805030201010000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000101010203040507090B0D101316191D2125292D32363B3F44494D52565B5F63686C
7074787C7F83878A8E9194979A9DA0A3A6A8ABAEB0B2B5B7B9BBBDBFC1C3C5C6C8C9CBCC
CECFD0D2D3D4D5D6D7D8D9DADBDBDCDDDEDFE0E2E3E4E6E7E7E8E7E5E3DED8CFC5B8AA99
8876655444362A1F17100C08050302010100000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000101020203040607090B0E1114171B1F23272C30353A3F44494E53585D61666B7074
797D81858A8E9195999DA0A4A7AAADB0B3B6B9BCBFC1C4C6C8CBCDCFD1D3D5D7D9DADCDD
DFE0E2E3E4E6E7E8E9EAEBECEDEEEEEFF0F1F2F2F3F4F4F4F4F3F2F0EDE8E2DAD0C4B6A7
968472604F4033271D16100B070503020101000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000101020203040607090C0E1114181C2024292D32373C42474C51565C61666B70757A
7E83888C9094999DA1A4A8ACAFB3B6B9BCBFC2C5C8CBCDD0D3D5D7D9DCDEE0E2E3E5E7E9
EAECEDEFF0F1F3F4F5F6F7F8F9FAFAFBFBFCFCFCFCFCFBFBFAF8F6F4F1EDE8E1D9CEC1B3
A3917F6D5C4C3D30251C150F0B0705030201010000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000101020203040608090C0E1115181C2025292E33383D43484D53585D62686D72777C
81858A8E93979B9FA3A7ABAFB2B6B9BDC0C3C6C9CCCFD1D4D6D9DBDDE0E2E4E6E8EAEBED
EFF0F2F3F5F6F7F8F9FAFBFCFDFEFFFFFFFFFFFFFEFDFCFAF8F6F4F1EFECE8E3DDD4CABD
AF9E8D7B6A59493B2E241B140F0A07050302010100000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000101020203040607090C0E1114181C2024292E33383D42474C52575C61676C71767A
7F84888D91959A9EA2A5A9ADB0B4B7BABEC1C4C7C9CCCFD1D4D6D9DBDDDFE1E3E5E7E8EA
ECEDEFF0F2F3F4F5F6F7F8F9FAFBFBFCFCFBFBFAF8F7F4F2EFECEAE7E6E4E2E0DCD6CFC5
B9AA9A8978665647392D231B140F0B080504020101000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000101020203040607090B0E1114171B1F23282C31363B40454A4F54595E63676C7175
7A7E83878B8F93979B9FA2A6A9ACB0B3B6B9BBBEC1C4C6C9CBCDCFD2D4D6D8D9DBDDDFE0
E2E3E5E6E7E9EAEBECEDEEEFEFF0F0F1F1F0EFEEECE9E6E3DFDCD9D7D6D6D6D7D6D4D0CA
C1B5A7978675645445382C231B140F0B0806040302010100000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000101010203040507090B0D1013161A1D21252A2E33373C40454A4E53585C6165696E
72767A7E8285898D9094979A9DA0A3A6A9ACAEB1B3B6B8BABCBFC1C3C5C6C8CACCCDCFD0
D2D3D4D6D7D8D9DADBDCDDDEDEDFDFDFDFDFDEDCDAD7D3CFCAC6C2C0C0C2C5C8CCCECECC
C6BDB2A4948473625344382C231B15100B08060403020101000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000001010203040507080A0C0F1215181B1F23262A2E33373B3F43474C5054585C5F63
676B6E7275797C7F8285888B8E919396989B9D9FA2A4A6A8AAACAEAFB1B3B4B6B7B9BABC
BDBEBFC0C1C2C3C4C5C6C7C8C8C9C9C9C9C9C8C6C3C0BCB7B1ACA8A6A6A9AEB6BDC4C8CA
C8C3BBB0A2938372625344382D241C15100C090705030202010100000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
0000000101020304050608090B0E101316191C1F23262A2D3134383C3F43464A4D515457
5B5E6164676A6D6F7275777A7C7E81838587898B8D8F9193949698999B9C9D9FA0A1A3A4
A5A6A7A8A9AAABABACADAEAEAFAFB0B0B0B0AFADABA7A39D96908B88888D959FABB6BFC5
C8C7C3BAAFA2928272625345392E251D17110D0A07050403020101000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
0000000101020203040607090A0C0F111316191B1E2124272A2D303337393C3F4245484B
4D505355585A5C5F61636567696B6D6F7173747678797B7C7E7F80828384858688898A8B
8B8C8D8E8F909091929293939495959696969594928E8A837C746D69696F7A8897A6B4BF
C6C9C8C3BBAFA29383736354473A30261F18130E0B080604030202010100000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000010102020304050608090B0D0F111315181A1C1F212426292B2E30323537393C3E
40424446484A4C4E5052535557585A5B5D5E6061626465666768696A6C6C6D6E6F707172
7273747575767677777878797A7A7B7B7C7C7C7B7A77726C645B524C4B515F708396A7B6
C1C8CBC9C4BCB0A39484746556493C3228201A14100C0907050403020101000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000001010102030304050708090B0D0E10121416181A1C1D1F21232527292B2D2E3032
343537383A3C3D3F40414344454748494A4B4C4D4E4F5051525354555656575858595A5A
5B5C5C5D5D5E5E5F5F5F6060616162626364646463615D584F453B312E36465B71879BAD
BBC5CCCECCC6BDB2A495867667594B3F342B231C16110E0A080604030202010100000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
0000000001010202030405060708090B0C0D0F101213151618191B1C1D1F202223242627
282A2B2C2D2E2F313233343536373838393A3B3C3D3D3E3F3F4041414243434444454546
464747474848494949494A4A4A4B4B4C4D4E4F50504F4C474036291C151F334B627A90A3
B4C1CAD0D1CEC8BFB4A69888796A5C4E42372E251E18130F0C0907050403020101010000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000101010203030405060708090A0B0C0D0E0F1011121314161718191A1B1C1D1E
1E1F2021222324242526272828292A2A2B2C2C2D2D2E2E2F2F3030313132323333333434
343535353636363637373737373838393A3B3C3E3F3F3E3A342C201100142A415870869A
ACBBC7CFD3D4D1CBC2B6A99B8C7C6E5F52463B3129211B16110E0B080605040302010101
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000001010202030304050506070808090A0B0C0C0D0E0F0F101112121314141516
1617181819191A1B1B1C1C1D1D1E1E1F1F20202021212222222323232424242525252526
262626272727272727282828282828292A2B2D2F313232312D271E151018293D53687E92
A4B4C2CCD3D7D7D3CDC4B9AC9E8F807264564A3F352C251E1814100C0A08060503030201
010100000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000000000101010202030304040505060607070809090A0A0B0B0C0C0D0D0E0E0E0F0F
101011111212121313141414151515161616161717171818181819191919191A1A1A1A1A
1B1B1B1B1B1B1B1C1C1C1C1C1C1C1C1C1D1E2022252729292825211C1C222E3E50637689
9BACBAC6D0D6D9D9D6D0C7BCB0A2948577695B4F44393028211B16120E0C090706040302
020101010000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000000000001010102020203030404040505050606060707070808080909090A0A0A0B
0B0B0B0C0C0C0D0D0D0D0E0E0E0E0E0F0F0F0F0F10101010101011111111111111121212
12121212121213131313131313131313131416181B1E2123242322222429323F4E5E6F80
91A2B1BEC9D2D8DBDBD8D2CAC0B4A6988A7C6E6154493E352C251F1915110E0B09070504
030202010101000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000010101010202020203030303040404040405050505050606060606070707
0707080808080808090909090909090A0A0A0A0A0A0A0A0B0B0B0B0B0B0B0B0B0B0B0C0C
0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0E1114171B1E20222325282D353F4B596777
8696A5B3C0CBD3D9DCDDDAD5CDC3B8AB9D908274675A4E443A3129231D1814100D0A0807
050403020201010100000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000101010101010202020202020303030303030303030404040404040404
050505050505050505050606060606060606060606060707070707070707070707070707
070707070708080808080808080707070707080B0E12161A1D202225292E353D47525F6C
7A8998A6B4C1CBD4DADDDEDCD7D0C7BCB0A395887A6D6054493F362E27211B17130F0C0A
080605040302020101010000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000010101010101010101020202020202020202020202020202020303
030303030303030303030303030304040404040404040404040404040404040404040404
04040404040405050505050505050404030304070A0E12161A1D2124282D3239414A5560
6D7A8997A6B3C0CBD3DADDDFDDD9D3CAC0B5A99B8E8174675B50463C342C251F1A16120F
0C0A08060504030202010101000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000001010101010101010101010101010101010101010101010101
010102020202020202020202020202020202020202020202020202020202020202020202
0202020202030303030303030303020201000204070B0F13171B1E22262A2E343A414A53
5E6B788795A4B2BEC9D2D9DDDFDEDBD5CEC5BAAEA295887B6E62574C423A322A241E1A15
120F0C0A0806050403020201010100000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000101010101010101
010101010101010101010101010101010101010101010101010101010101010101010101
010101010101010101010101010202010100010306090D1014181C1F2226292D32373E46
4F5B67758493A1AFBCC7D0D8DCDFDFDDD8D1C9BFB4A89C8F82766A5E534940373029231E
1915110E0C0A080605040303020101010100000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000010101010101010101020305080B0F1216191C1F212426292D3238
414B57647281909EACB9C4CED6DBDEDFDEDAD4CDC4BAAEA2968A7E71665B50473E362F28
221D1915110F0C0A08070504030302020101010000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000001010101020305070A0D101316191B1D1E1F2022262B
323C4753616F7E8C9BA9B6C1CBD3D9DDDFDEDBD7D0C8BFB4A99E92857A6E63584E453D35
2E28221D1915110F0C0A0807060404030202010101000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000001010102030507090C0F1114161718181818191B1F
262E3844515E6C7A8997A5B1BDC7D0D6DBDEDEDCD9D3CCC4BAB0A5998D82766B60564D44
3B342D27221D1915120F0C0A090706050403020201010101000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000010102030507090B0D1012131414141211101115
1B232C37424E5B69768492A0ACB8C3CCD3D8DCDDDCDAD6D0C8C0B6ACA1958A7F73695E54
4B433B342D27221D1915120F0D0B09070605040303020201010100000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000010102030506080A0C0E10111111100E0B09090D
131A222B35404C5865727F8D9AA7B3BDC7CFD5D9DBDCDAD7D2CCC4BCB2A89D92877C7167
5D534A423A332D27221D191612100D0B0908060504030302020101010100000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000001010203040608090B0D0E0F0F0F0D0B07040308
0D141B222B343E4854606D7A8794A0ACB7C1C9D0D5D8DADAD8D4CFC8C1B8AEA49A8F847A
6F655B524A423A332D27221E1A1613100E0B0A0807060504030202020101010000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000001010203040607090B0C0D0E0E0D0C0906030206
0B10151B2229313A454F5B6774808D9AA5B0BAC3CBD1D5D7D8D7D5D1CBC5BDB4ABA1978C
82786E645A5249413A332D28231E1A1613100E0C0A080706050403030202010101010000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000001010203040507080A0B0C0D0D0C0B0907050507
0A0D11151A20272E37404B56616D7A86929EA9B3BCC4CBD0D3D5D6D4D1CDC8C1B9B1A89E
948A80766C635A5149413A342E28231F1B1714110F0C0A09070605040403020201010101
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000101020304050608090A0B0C0C0B0A0908070707
090B0E1114191E242B333C45505B66727E8A96A1ABB5BDC4CACED1D3D3D1CEC9C4BDB6AD
A59B92887E746B62595149413A342E28241F1B1814120F0D0B0908070605040303020201
0101010000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000101020203050607090A0B0B0B0B0A0908080708
08090B0C0F12161B21272F37404A545F6B76828D98A2ACB5BDC3C8CCCFD0CFCDCAC6C0BA
B2AAA2998F867C736A61585048413A342E2924201C181512100D0B0A0807060504030302
0201010101010000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000102020304060708090A0B0B0B0A0909080707
070708090A0D1014181E242B333B444E58636E79848F99A3ACB4BBC1C6C9CBCCCBC9C6C1
BCB6AFA79E968D847B716960585048413A342E2924201C181512100E0C0A090706050404
0302020201010101010000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000101020304050708090A0A0A0A0A0908080706
0605050607090B0E12161B21272E363E47515B65707B859099A3ABB3B9BFC3C6C7C8C7C5
C1BDB8B2ABA39B938A817970675F574F48413A342E2925201C191613100E0C0A09070605
0504030302020201010101000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000010102030405060708090A0A0A0A0908070605
040303030405070A0D1014181D232A3138414A535D67717B858F98A1A9B0B6BBBFC1C3C3
C2C0BDB8B3ADA79F9890877F766E665E564E47403A342E2925201C191613100E0C0B0908
0706050403030202020101010100000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001010203040506070809090A0A090908070605
0302010102030507090B0E12161A1F252C333A434B555E68717B858E979FA6ADB2B7BABD
BEBEBDBBB8B3AEA9A29B948C847C746C645C544D463F39332E2924201C191613100E0C0B
0908070605040303020201010101000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001010203040506070809090909090807060504
030100000102030506080A0D1013171C21272D343C444C555E67717A838C949CA2A9AEB2
B5B7B8B8B7B5B2AEA9A49D97908881797169615A524B453E38322D2824201C181513100E
0C0A090806050504030302020101010000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001010203040506070708090909080807060504
0301010101020203040507090B0E1114181D22282E353C444C555E666F78818990989EA4
A8ACAFB1B2B2B1AFACA8A39E98928B847C756D665E575049433C36312C27231F1B181512
100D0B0A08070605040303020201010100000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001010203030405060708080908080707060504
03020101010102020303040607090C0E1115191E23292F353C444C545C656D757D858C93
999EA2A6A9AAABABAAA8A5A19D98928C867F787069625B544D46403A342F2A25211D1A16
13110E0C0B090706050403030201010100000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001010202030405060708080808080706050403
0302010101010101010203040506080A0C0F12161A1E23292F353C434B525A626A727980
878D93989C9FA2A3A4A4A2A09E9A96918C868079726B645D565049433D37312C27231F1B
1815120F0D0B0908060504030202010101000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001010202030405060707080808080706050403
03020101010100000101020203040507080A0D0F12161A1E23292E343B424950575F666E
757B81878C9195989A9B9C9B9A9896928E8A847F79726C655F58514B443E39332E292420
1C181512100D0B09080605040302020101000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001010202030405060607080808070706050403
030201010000000000000101020203040507090B0D1013161A1E23282D333940464D545B
62696F757B8185898D909293939392908D8A86817C77716B655F58524B453F39342E2925
201C1815120F0D0B090706040303020101000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001010202030405060607070707070606050403
0202010100000000000000010101020303040607090B0D1013161A1E22272C32373D444A
50575D646A6F75797E828587898A8A8A888684817D78746E69635D57514B453F39332E29
24201C1815110F0C0A0806050403020101010000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001010102030405050607070707070606050403
02020101000000000000000000010102020304050607090B0D0F1215191D21252A2F353B
40464C52585E63696D7276797C7E808080807F7D7A77736F6A65605A544F49433D37322D
28231F1B1713100E0B0907060403020201010000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102030404050606070707070605050403
020201010000000000000000000000010102020304050607090B0D0F1215181C2024282D
32373D42484D52585D62666A6D707375767676767472706C6965605B56514B45403A3530
2A26211D1915120F0C0A08060504030201010000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102030304050606070707060605050403
0202010100000000000000000000000001010102020304050607090A0C0F1114171A1E22
262B2F34393E43484D51565A5E626567696B6C6C6C6B696765615E5A55514C46413C3731
2C27231E1A1613100D0B08070504030201010000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102030304050606070707060605040403
02020101000000000000000000000000000001010102020304050607080A0C0E10131619
1C2024282C3035393E42474B4F5356595C5E6061626261605E5C5956534F4A46413C3732
2D28241F1B1714110E0B09070504030201010000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102030304050506060606060605040403
02010101000000000000000000000000000000000101010202030304050708090B0D0F12
14171A1E2125292C3035393D4044484B4E51535556575757565553514E4B47433F3B3632
2D2924201C1814110E0C09070604030201010100
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102020304050506060606060505040303
020101010000000000000000000000000000000000000101010202030304050607090A0C
0E101315181B1E2225292C3033373A3E414346484A4B4C4D4D4C4B4A484643403C383430
2C2824201C1814110E0C09070604030202010100
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102020304050506060606060505040303
020101000000000000000000000000000000000000000000010101010202030405060708
0A0B0D0F111416191C1F2225282B2E3134373A3C3E40414243434342413F3D3B3835312E
2A26221F1B1714110E0C09070604030202010100
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102020304040506060606060505040303
020101000000000000000000000000000000000000000000000000010101020203040405
0608090A0C0E10121416191B1E212426292C2E313335363839393A3A3938373533302E2B
2724211D1A1713110E0B09070604030202010100
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102020304040505060606060505040302
020101000000000000000000000000000000000000000000000000000001010102020303
0405060708090B0C0E10121416181B1D1F222426282A2C2E2F3031313130302F2D2B2927
24211E1B181512100D0B09070604030202010100
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102020304040505060606050504040302
020101000000000000000000000000000000000000000000000000000000000101010102
02030404050607080A0B0C0E1012131517191B1D1F212324262728292929292827262422
201E1B191614110F0C0A08070504030201010100
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102020304040505060606050504040302
020101000000000000000000000000000000000000000000000000000000000000000101
01020203030405050607080A0B0C0E0F1113141618191B1C1E1F20212122222221201F1E
1C1A18161412100E0C0A08060504030201010000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102020303040505050605050504040302
020101000000000000000000000000000000000000000000000000000000000000000000
01010101020203030405060607080A0B0C0D0F10111314161718191A1B1B1B1C1B1B1A19
1817151412100E0C0B0907060504030201010000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102020303040505050505050504040302
020101000000000000000000000000000000000000000000000000000000000000000000
0000000101010202020303040506060708090A0B0C0E0F10111213141515161616161615
14131211100E0C0B090807050403020201010000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102020303040405050505050504030302
020101000000000000000000000000000000000000000000000000000000000000000000
0000000000010101010202020303040505060708090A0A0B0C0D0E0F1010111112121111
11100F0E0D0C0B0A080706050403020201010000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010101020303040405050505050504030302
020101000000000000000000000000000000000000000000000000000000000000000000
00000000000000000101010102020203030404050606070809090A0B0C0C0D0D0E0E0E0E
0D0D0D0C0B0A0908070605040303020101010000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010101020303040405050505050404030302
020101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000001010101020202030304040505060707080809090A0A0A0B0B
0B0A0A0A09080807060504040302020101000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010101020303040405050505050404030302
020101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000001010101020202030303040405050606070707080808
0808080807070606050404030302010101000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010101020203040405050505050404030302
020101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001010101020202020303030404050505060606
0606060606050505040403030202010101000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010101020203040405050505050404030302
020101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000001010101010202020203030304040404
0405050504040404030303020201010100000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010101020203040404050505050404030302
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000001010101010102020202030303
0303030303030303030202020101010100000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010101020203040404050505050404030302
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000010101010101020202
0202020202020202020202010101010000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010101020203030404050505040404030302
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000010101010101
0101020202020202020101010101000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404050505040404030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000101
0101010101010101010101010100000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404050505040404030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000010101010101010101010000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040505040404030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040504040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  InitializationCell->True,
  ImageSize->{288, 177.938},
  ImageMargins->{{281, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40n007h00Oooll8Oll003ooc`Q
oc`00?oo?27o?000ooll8Oll003ooc`Qoc`00?oo?27o?000ooll8Oll003ooc`Qoc`00?oo?27o?000
ooll8Oll003ooc`Qoc`00?oo?27o?000ooll8Oll003ooc`Qoc`00?oo?27o?000ooll8Oll003ooc`Q
oc`001Wo?08003Wo?0<000Co?08003?o?0@000?o?08000Co?080033o?0@000;o?0<000Co?080033o
?0@000?o?08000Co?08000?o?0006?ll00@00?lloc`003_o?004003o??ll0002oc`00`00occo?00b
oc`01@00occo??ll00000_ll00@00?lloc`000;o?003003o??ll02oo?003003o??ll00Co?004003o
??ll0002oc`00`00occo?00]oc`00`00occo?003oc`01000occo?0000_ll00@00?lloc`000;o?000
6?ll00@00?lloc`003_o?004003o??ll0002oc`00`00occo?00boc`01@00occo??ll00000_ll00@0
0?lloc`000;o?003003o??ll02oo?003003o??ll00Co?004003o??ll0002oc`00`00occo?00^oc`0
0`00occo?002oc`01000occo?0000_ll00@00?lloc`000;o?0006?ll00@00?lloc`003So?0<000?o
?004003o??ll000doc`01@00occo??ll00000_ll00@00?lloc`000;o?003003o??ll02oo?004003o
??lloc`30003oc`01000occo?000<Oll00D00?llocco?00000;o?004003o??ll0002oc`10001oc`1
oc`001So?004003o??ll000hoc`00`00occo?003oc`01000occo?000=?ll00D00?llocco?00000;o
?004003o??ll0002oc`00`00occo?00_oc`01@00occo??ll00001Oll00@00?lloc`003;o?004003o
??ll0002oc`01000occo?0000_ll0@000Oll0Oll000Hoc`01000occo?000>?ll00<00?lloc`00oll
00@00?lloc`003;o?0<000?o?004003o??ll0002oc`01000occo?000;oll0`000oll00<00?lloc`0
0oll00@00?lloc`002oo?004003o??ll0002oc`01000occo?0000_ll00@00?lloc`000;o?0006Oll
0P00>Oll10000oll0P00=Oll00<00?lloc`00_ll0P001?ll0P00<_ll00@00?llocco?0@000?o?080
037o?08000Co?08000Co?08000?o?000ooll8Oll003ooc`Qoc`00?oo?27o?000ooll8Oll000>oc`2
0005occo00080004oc`000go?004003o??ll0004oc`00`00occo?002oc`00`00occo?009oc`00`00
occo?00:oc`00`00occo?00:oc`00`00occo?009oc`00`00occo?00:oc`00`00occo?009oc`00`00
occo?00:oc`00`00occo?009oc`00`00occo?00:oc`00`00occo?00:oc`00`00occo?009oc`00`00
occo?00:oc`00`00occo?009oc`00`00occo?00:oc`00`00occo?00:oc`00`00occo?009oc`00`00
occo?00:oc`00`00occo?009oc`00`00occo?00:oc`00`00occo?00:oc`00`00occo?002oc`00`00
occo?002oc`000go?004003o??ll0004oc`2003ooc`3oc`30004oc`000go?004003o??ll0004oc`0
0`00occo?002ocaj000202000`Q1264@PP026<<00aSS8@@Q10038@@01ASS6<<@XQ2R26400`Q100<0
80000000JP001Oll00<00?lloc`00_ll000=oc`01000occo?0001?ll00<00?lloc`00_llNP000P0P
00<8@@QQ48800QS300<Hhb448@@00b4400DHhaS34:8@XPQQ00<8@@030200000006X000Go?003003o
??ll00;o?0003Oll00@00?lloc`000Co?003003o??ll00;o?7X0008080032448HA2R008H``036><Q
124T008Q90038@@HhaS3008@XP054888@@Q12440801/0005oc`00`00occo?002oc`000ko?08000Go
?003003o??ll00;o?7T000<08003264@PQ2R008Hh`038@@Q924T00<Q90068@@H`a2R4:8@PPQQ0PQ1
00<080000000JP001Oll00<00?lloc`00_ll000Eoc`00`00occo?002oca:000W0207000202022440
0`QQ4:8H``028@@00b4T:DDYA@02:DD00b4T8@@Hh`024:801A222648@@Q10200K0001Oll00<00?ll
oc`00_ll000Eoc`00`00occo?002oc`W001A0202244248800a2R6<<Q10028B@00bU5:FDYI@02:FD0
0bU58B@Hh`026<<011222648@@Q10P0PJ`001Oll00<00?lloc`00_ll000Eoc`20003oc`W001A0202
244248800a2R6<<Q10028B@00bU5:FDYI@02:FD00bU58B@Hh`026<<011222648@@Q10P0PJ`001?ll
0P001?ll000Eoc`00`00occo?002oc`H000M021324401`QQ488@XQ2R6><Q12U5008YI@03<HHaYS6V
008aQP03:FDYAB44008Hh`044:8@PPQ12442021[0005oc`00`00occo?002oc`001Go?003003o??ll
00;o?1<001008188@A`8HB8@PP03264@PQ22008@PP074:8H`b448@@Q92UU<HH00S6V00<iacWW>NL0
0SW700<aYRUU8B@00QSS00HH`a222648H@Q1021[0005oc`00`00occo?002oc`001Go?003003o??ll
00;o?10000T080/8@@`8H@l@PQ@@XR@H``036><Q124T008YI@03<HHiacWW009220=2:0922003>LLa
YRUU008Q10056<<@XPQQ2648@@02021Z0005oc`00`00occo?002oc`001Go?003003o??ll00;o?0h0
00L080L8@@L8H@P@PPT@XPXH```Hha8Q11TQ908YA@03:FDaQS6V008ia`03@PQ2:4YY00ABRP06BVU:
BDY9@PPiac660RU500LHhaS3488@PPQQ2440801Z0005oc`00`00occo?002oc`001Go?003003o??ll
00;o?0h000L080L8@@L8H@P@PPT@XPXH```Hha8Q11TQ908YA@03:FDaQS6V008ia`03@PQ2:4YY00AB
RP06BVU:BDY9@PPiac660RU500LHhaS3488@PPQQ2440801Z0005oc`00`00occo?002oc`001Go?080
00?o?0`000L080D8@@D8H@D@PPD@XPDH``HHh`LQ10LQ90TYA@/YIA8aQPlaYP8ia`03>NM2248X009:
J@03DXYJbe[[009Jj`03H`aJje[;009BZP03BVU223W7008YI@078B@Hha2R4:88H@Q10200JP001?ll
0P001?ll000Eoc`00`00occo?002oc`;000502052444264348834:846<<46><48@@58B@4:DD5:FD5
<HH6<JH8>LL7>NL<@PPB@RP4BTT2BVT00e::DZYJj`02H``00f</Jde[K@03Lhh01f]]JdeS36<<DZY:
JD88008aYP06:DDQ11S36<<@PPQQ0`0PJ0001Oll00<00?lloc`00_ll000Eoc`00`00occo?002oc`;
000402042443264348834:826<<36><28@@48B@2:DD3:FD4<HH4<JH2>LL4>NL5@PP4@RP5BTT6BVT6
DXX9DZX=F//9F^/2H``2Hb`00f]=JfecSP02Nll00g__Q1244003Q1001g__Lji[KF]]H`aBZTY9008i
i`07<HHQ91SS6><@XPQQ24400`0PI`001Oll00<00?lloc`00_ll000Eoc`00`00occo?002oc`:0005
02022443264248834:836<<00aSS8@@Q10038B@012U5:FDYIBUU0S660c6V0SW70SWW0T88148X0TY9
0dYY15::0U:Z15[;1E[[16<<1F</1V]=1f]]2W>>27>^0g_?00Ikkh@@Q124<8aAS742U982U;801YcC
U;:D/YBbS764<09kk`03LhiS35:Z0092:007>LLYIB448@@H`a2226400PQ100<080000000I@001Oll
00<00?lloc`00_ll000Eoc`00`00occo?002oc`:000502022443264248834:836<<00aSS8@@Q1003
8B@012U5:FDYIBUU0S660c6V0SW70SWW0T88148X0TY90dYY15::0U:Z15[;1E[[16<<1F</1V]=1f]]
2W>>27>^0g_?00Ikkh@@Q124<8aAS742U982U;801YcCU;:D/YBbS764<09kk`03LhiS35:Z0092:007
>LLYIB448@@H`a2226400PQ100<080000000I@001Oll00<00?lloc`00_ll000Eoc`00`00occo?002
oc`:000402022443264248801A2R6<<H`aS36><00b4400<Q92U5:FD00RUU00<aQS6V>LL00SW700Di
id88@PQ2248X00=:B@03BVUBRU::00=BZP9Jb`9Jj`9S30AS;09[C@=[K@AcSP9c[PAkc`Ekk`B440J4
<0N<D@R<L@FDTP>D/P06W=>LliccW?>U5:Dd0ZeE0jee0ZeE00>U=:DDU;800XaA00=kkg>>H``00U::
00M2236V:DDYAASS4:8@PP022442021V0005oc`00`00occo?002oc`001Go?08000?o?0T000<080@8
@@05264@PQ22488@XP036<<01ASS8@@Q924T:DD00RUU0S6600<aYSW7>NL00T8800=2:4Y9BTT00TYY
00=BRU:ZF//00U[;00=Jjf<<Hb`00V</00E[CF]]Jfe[KG>>009c[P=kc`9kk`>440>4<0:<D@><L@>D
TPBD/PBLd`BLl`FU50JU=0R]E@>]M@>eUP>e]P03_MNmmkgg00G660:mm`03_MNeUZDd00:Ld`03S75k
kf]]009Jj`07BVTiic66<HHQ91S34:800PQQ00<8@@0P0200I@001?ll0P001?ll000Eoc`00`00occo
?002oc`9000302032442264248824:801AS36><Hhb448B@00RU500<YIC66<JH00SW700<iid88@RP0
0TY900=:JE::DZX00U[;00EJjf<<HbaS;6]=009[K@9cSP03Ljikcg__009kk`03Q124<8aA00:<D@03
S76DTYBB00>D/P04W=>LliccW?<2YA@3YC@4[ED2[GD4]IH4]KH4_ML5_OL6aQP6aSP3cUT4cWT00mJJ
e[[F^P05e[X2eYX00liIaQRe]P02[ED00icCS55kc`02Jdd01e[;BTTiacW7:FDQ11S3008@PP032648
@@0P06D000Go?003003o??ll00;o?0005Oll00<00?lloc`00_ll2@000`0P0`Q100L8HA22488@PQ2R
6<<Hh`028@@01b4T:DDYIBUU<HHaYSW7008ii`03@RQ:BDYY009BRP03DZYJbe[[009S3006Jde[KG>>
Lhic[W_?0g__00>448@`S5400Xaa00>DTYBbU;800YcC00>LljDDYA@00ZDd0ZeE0Zee0[FF0kFf0[gG
0kgg0/HH0lHh0liI1<ii1=JJ1MJj1]kK1Mkk1>LL1NLl0^mM0^Ll00KW7=kkg__NfliiaSP2_ML00jeE
W=><D@02Ljh01f</DZY2:48X<JHYAASS008@XP034888H@Q1008086<000Go?003003o??ll00;o?000
5Oll00<00?lloc`00_ll2@000`0P0`Q100L8HA22488@PQ2R6<<Hh`028@@01b4T:DDYIBUU<HHaYSW7
008ii`03@RQ:BDYY009BRP03DZYJbe[[009S3006Jde[KG>>Lhic[W_?0g__00>448@`S5400Xaa00>D
TYBbU;800YcC00>LljDDYA@00ZDd0ZeE0Zee0[FF0kFf0[gG0kgg0/HH0lHh0liI1<ii1=JJ1MJj1]kK
1Mkk1>LL1NLl0^mM0^Ll00KW7=kkg__NfliiaSP2_ML00jeEW=><D@02Ljh01f</DZY2:48X<JHYAASS
008@XP034888H@Q1008086<000Go?003003o??ll00;o?0001oll10000oll0P001Oll00<00?lloc`0
0_ll2@000`0P0`Q100<8HA224:800Q2R00HH`aSS8@@Q124T:FD2<HH00c6V>LLii`02@RP00dY9BVUB
RP02F//00e[[H`aS;002Jdd01g>>Ljikcg_?Nnn448@`00:<D@03S76DTYBb00:Ld`03W?>U5:Dd00:U
=003[EF]MKFF00:eUP03]KJmekgg00:mm`04aQS6><HhaSP2cUT3cWT2eYX3e[X2g]/4g_/4ia`4ic`5
ked6kgd6mih5mkh4mih01^mmkeg_GNLLg]_FVP;6>003]KJU=9Bb00:4<007LhiS34YYBVU223668B@0
0QSS00<@XQ2224400`0PHP001Oll00<00?lloc`00_ll0007oc`00`00occo?003oc`01000occo?000
1?ll00<00?lloc`00_ll2@000`0P0PQ10PQQ00H@PQ2R4:8H`aSS8@@28B@01bU5:FDaQS66<JHiid88
0092:003BVUBRU:Z009Jj`03H`aS;6]=009cSP07Ljikcg__Nnn448aAS7400YBB00>D/YcCW?<00ZDD
00>U=:eE[GD00Zee00>eU[Ff_ML00kgg00?66<HhaSP00/iI00C>NMJJeY[FVP;F^P;Nf`;Nn`CW70;W
?0?_G@C_O@CgWPGg_POog`Ooo`Gog`;g_P06mik_ONmmkegW7=kK0/ii00?66;FFYA@00YBB00Mkkf]]
F^]JjdYY>NLaQP028B@00aSS4:88H@022442021Q0005oc`00`00occo?002oc`000So?003003o??ll
00;o?004003o??ll0004oc`20003oc`900020203244226401Q224:8@XQS36><Q108Q9007:DDYIC66
<HHiacWW@PP00TY900=:JE::F//00U[[00=S36]=Jfd00W>>00Mc[W__Q12448@`S56<L@02U9800iBb
W=>Ll`02YA@00jDd[EF]M@02]IH00kFf_MNmm`03aQP00lHhcUW>F@02cWT01=JJe[[F^]Jj0]kK0]kk
0^LL0nLl0nmM0nmm1?NN1?Nn1OoO3ooo0_oO0oNn00OgW^mmkgg_ONmMiacNn`02e[X00liI_ON]M@02
W?<01haaNlm[CF]=F/]:BCW7008YI@038B@H`a2R0088H@032440800P060000?o?0<000Co?0002Oll
00D00?llocco?00000;o?003003o??ll00;o?003003o??ll00;o?0T000<08088@@88H@06488@XQ2R
6<<Hhb440R4T00LYABUU<HHaQSW7>NM22002@RP00dYYDXYBZP02F^/00f<<Hba[K@02Lhh01g>^Nlmk
kg__Q32<DHaa00:DTP03U;:Ldicc00:U5003YCB]EJee00:eUP:e]P04_MNmmkggaQP3aSP00liIcWW>
N@02eYX2e[X3g]/2g_/3ia`2ic`3ked4kgd3mih5mkh7oml2ool5oml3mkh01ONNkgg_ONmmked01>Ll
0^LL00KNnmJje[[>NLHh_ML2[ED01icCS55kcg_?HbaBZT8X008ia`03:FDQ11S3008@XP032648@@Q1
00<085d000Go?003003o??ll00;o?0002_ll00@00?lloc`000;o?003003o??ll00;o?003003o??ll
00;o?0T000<08088@@88H@06488@XQ2R6<<Hhb440R4T00LYABUU<HHaQSW7>NM22002@RP00dYYDXYB
ZP02F^/00f<<Hba[K@02Lhh01g>^Nlmkkg__Q32<DHaa00:DTP03U;:Ldicc00:U5003YCB]EJee00:e
UP:e]P04_MNmmkggaQP3aSP00liIcWW>N@02eYX2e[X3g]/2g_/3ia`2ic`3ked4kgd3mih5mkh7oml2
ool5oml3mkh01ONNkgg_ONmmked01>Ll0^LL00KNnmJje[[>NLHh_ML2[ED01icCS55kcg_?HbaBZT8X
008ia`03:FDQ11S3008@XP032648@@Q100<085d000Go?003003o??ll00;o?0001oll00@00?lloc`0
00;o?004003o??ll0004oc`00`00occo?002oc`90003020324400`QQ488@XP024:801QS36><Q1244
:DDYI@8aQP03<JHiad880092:003BTU:JE:Z009Jb`03F^]S36</009[K@07Lhic[W_?Nlmkkh@@Q300
0XaA00><LIBBU;800YcC00>LljDDYC@00ZeE00>]MKFF]IH00[Ff0[gG0[gg00?66<HhaSP00liI0/ii
0]JJ0]Jj1=kK0]kk1>LL1>Ll1>mM1^mm1_NN1>mm0^mM00?W?>LLg_/00]kk00?NfmJje[X01mJj00?F
V/iIaQP00[Ff00NU=9BbQ324<7>^HbaBZP02@RP00cW7:FDQ10026<<00a2R2648@@022442021L0005
oc`00`00occo?002oc`000So?08000Co?08000Go?003003o??ll00;o?0T000<080<8@@07264@PQ22
488@XQS36><00R4400LQ92U5:FDYIC66<JHii`02@PP00d8XBTU:J@02DXX00e[;F^]S3002Hb`01f]=
JfecSW>>Ljikcg__00:44003Q32<DHaa00:DTP:D/P03W=>Llicc00:U5003YCB]EJeE00:]M@>eUP04
]KJmekgG_ML2_OL3aQP2aSP3cUT3cWT4eYX4e[X5g]/>g_/01]kKe[[F^]JJcWW>F@;6>0G66003aSS>
FLii00C>N@05aSRmmkgg]IJU=002U;800h@`LhiS3002DXX00d8X>LLYI@028@@00aS34:8@PP032443
021J0005oc`00`00occo?002oc`001Go?003003o??ll00;o?0T000<080<8@@88H@8@PP034:8H`aS3
008Hh`078@@Q92U5:DDYIC66<JH00SW700<iid88@RP00TYY00=BRU:ZF//00e[[00IS36</Hba[CF]]
Lhh2Ljh00g_?Nnmkk`02Q1000h@`S56<D@02S742U98019BbW=>LdicC0icc00>U5:DdYC@00jeE1:ee
0[FF1;Ff0[gG1[gg1LHH1LHh2/iI00O6><HHaQS66;gg]KJeUP02[GD00jeEYCBU=002[ED00jee]KJm
m`02aSP3cUT2aQP01kgG]IJU5:DDU9:447>>009S3003DXY2:3W7008YI@038B@Hha2R008@PP032648
@@0P008085T000Go?003003o??ll00;o?0005Oll00<00?lloc`00_ll2@000`0P10Q100H8HA22488@
PQ2R6<<36><01R448B@Q92U5:FDaQP8aYP03>LLiicWW00922003@RQ:BDYY009BRP9BZP9Jb`03F^]S
36</009S;003Jde[KF]]009cSP9c[P04Nlmkkg__Nnl2Q103Q303S542S743U982U;84W=<4W?<3YA@6
YC@6[ED7[GD5]IH3[GD01ZeEYCBU=:DDW?>D/P:DTP><D@:<L@03U;:LljeE00:e]P03_OO6><iI00;6
>007aQRmejee[GFU59BBQ1000W>>00=S35::@RP00SW700<YIB4T6><00Q2R00@@PPQQ2448@@<085L0
00Go?003003o??ll00;o?0005Oll0P000oll2@000`0P10Q100H8HA22488@PQ2R6<<36><01R448B@Q
92U5:FDaQP8aYP03>LLiicWW00922003@RQ:BDYY009BRP9BZP9Jb`03F^]S36</009S;003Jde[KF]]
009cSP9c[P04Nlmkkg__Nnl2Q103Q303S542S743U982U;84W=<4W?<3YA@6YC@6[ED7[GD5]IH3[GD0
1ZeEYCBU=:DDW?>D/P:DTP><D@:<L@03U;:LljeE00:e]P03_OO6><iI00;6>007aQRmejee[GFU59BB
Q1000W>>00=S35::@RP00SW700<YIB4T6><00Q2R00@@PPQQ2448@@<085L000Co?08000Co?0005Oll
00<00?lloc`00_ll2P00100P0PQ10`QQ0Q2200D@XQS36<<H`aSS008Q108Q9003:DDYIBUU008aQP03
<JHiacW7008ii`03@PQ2:48X009:B@9:J@9BRP04DZYJbe[;F//2F^/3H``2Hb`3Jdd2Jfd3Lhh3Ljh3
Nll4Nnl4Q104Q306S545S749U98:U;801YBBS76<LHaAQ11kk`9c[P03Jfe[CF]=009[K@03Nln<DIBb
00:U=003]KJmmlHh00?>F@06aQRmekgG[GFU59BB0X@@00=cSV<<DZX00T8X00<iac668B@00QSS00@H
`a222648H@88@@<085D000Go?003003o??ll00;o?0005Oll00<00?lloc`00_ll2P00100P0`Q10`QQ
0Q220Q2R0QS30aSS00@Q124T8B@Q908YA@04:FDaQS66<HH2<JH2>LL2>NL3@PP2@RP3BTT2BVT4DXX3
DZX3F//3F^/4H``5Hb`4Jdd6Jfd6Lhh9Ljh9Nll4Nnl2Nll2Ljh00g>>JfeS;002F//00e::BVU:B@02
DXX00e[[Lhj44002U;800jDd]KK66004cUT2aSP00kgg]IJU5002U;800h@`LjiS;002DZX00dY9>NLa
QP02:DD01b446<<@XQ2R4888H@Q100@085<000Go?003003o??ll00;o?0005Oll00<00?lloc`00_ll
2`00100P10Q10PQQ0a220Q2R0aS311SS0R440b4T0RU50bUU0S66136V0cW70cWW1488148X1DY91DYY
1E::1U:Z25[;2e[[2F<<16</0f<<00=Jje[;BVT00T8X00<iac66:FD00S6V00=2:5[;Lhh00X@`00>L
djee_ML00/Hh1<ii00?6>;gg]IH00ZDd00>D/X@`Ljh00V</00=JbdY9>NL00S6V00LYAB446><Hha2R
4888H@032442021B0005oc`00`00occo?002oc`001Go?003003o??ll00;o?0/000D080@8@@@8H@@@
PP8@XP@H``@Hh`<Q10@Q90@YA@DYI@@aQPDaYPHia`Pii`M220a2:0i:B@E:J@9BRP=:J@07@RQ2236V
<JHYAASS4:800QSS00<aQTY9H``00W_?00>DTZDD]KH00/HH00O>FMJJeY[FV/iicUVmm`02]KH00jDd
W=><D@02Nll00f]=F^]:J@02@PP01c6V:FDQ924T6><H`a2200<8H@032440800P008084l000Go?003
003o??ll00;o?0005Oll00<00?lloc`00_ll2`001@0P10Q110QQ11220Q2R11S311SS0b44124T12U5
1BUU13661C6V1SW723WW1d88348X3TY91DYY0U::0dYY00M2:488<JHaYRU56><@XP026><00c66BTUS
3002Nll00iBBYABe]P02aQP01liIeY[FV]JJcWW>FKgg00:e]P03YCBLdhaA009kc`03JdeJjdYY0092
2007<JHYIB4T8B@HhaS348800`QQ00<8@@0P02000P0PC`001Oll00<00?lloc`00_ll000Eoc`20003
oc`<000502052446264548834:856<<76><58@@68B@8:DD::FD;<HHC<JH6>LL7>NL01cW7<JHYIBUU
8@@@PP00008@XP03:DE225[;009cSP03Q32Ldjee00:me`07aSS>NMJJeY[F^]JJcUT00/HH00>e]ZeE
W=<00Xaa00=kkf]]F^/00U::00M2:3W7<HHaQRU58@@H``024:800a222648@@022443021=0004oc`2
0004oc`001Go?003003o??ll00;o?0h000H080H8@@P8H@H@PPP@XPTH``XHh`hQ11DQ90/YA@<YI@Da
QP06:FDQ924T6><@XQ220QS300<YACWWDXX00V]=00=kkiBBYC@00[Ff00C66<iieY[FVP;F^P06eY[>
NLiiaSRmejee0Ycc00><LH@@Lhh00V</00MBZTY9>NLiic6V:FDQ90026><00aS34:8@PP0226422443
021;0005oc`00`00occo?002oc`001Go?003003o??ll00;o?0l000X080T8@@/8H@`@PQ0@XQ/H``dH
h`<Q10<Q90<YA@8Q90038@@HhaSS008Q1003:FDiie::009S3003Ljj<DIcC00:]M@05_MO6>=JJeY[F
^P02g]/2e[X00mJJaSRmm`02]IH00jDDU;:4<002Ljh01f]=F/]:JDYY@RPiac66008YA@038@@H`a2R
008@PP88H@032440800P008084T000Go?003003o??ll00;o?0005Oll00<00?lloc`00_ll4@00400P
40Q15PQQ:A220a2R0QS30QSS0R4400<Q92448@@00R4400HQ92U5:DDaQSWWBVT2F^/00f]]Q12DTP02
YA@01KFF_OO>FLiIeYX01MkK00OFV/iIaQS66;FfYCBLd`02S5401g__JfeS36<<DZY:BCWW008aYP03
:FDQ91SS008H``034:8@PPQQ00<8@@@084H000Go?003003o??ll00;o?0005Oll00<00?lloc`00_ll
4@00400P40Q15PQQ:A220a2R0QS30QSS0R4400<Q92448@@00R4400HQ92U5:DDaQSWWBVT2F^/00f]]
Q12DTP02YA@01KFF_OO>FLiIeYX01MkK00OFV/iIaQS66;FfYCBLd`02S5401g__JfeS36<<DZY:BCWW
008aYP03:FDQ91SS008H``034:8@PPQQ00<8@@@084H000Go?003003o??ll00;o?0005Oll00<00?ll
oc`00_ll5P006P0P:0Q16`QQ00H@PQ2R4:8@XQS36><48@@01b4T:DDYIBUU<JHiidY9009Jb`03Hbac
[X@`00:D/P07YCBeU/HHaQS>FMJJg]/00mkk00ONfmJjcWW>NLHH_MN]E@02W?<01iBBQ11c[W>^HbaJ
bdYY0092:003>LLaQRU5008Q10036><H`a2R008@PP032648@@Q100@084@000Go?003003o??ll00;o
?0005Oll0P000oll8`00?P0P2PQ11P0P0`Q100H8HA22488@XQS36><38@@01b4T:DDYIBUU<JHiid8X
009BRP03F^][KG_?00:<D@07W=>U=;Ff]KK66<iIe[X00]kK0mkk0]Jj00?FV/Hh_OL00[FF00NU59Bb
S56<DG_?JfeS3002DZX00dY9>NLaYP02:FD00b4T8@@H``024:800a222648H@03244402110004oc`2
0004oc`001Go?003003o??ll00;o?3l00300808000<080062448H@QQ488@XQS30QSS00<Q124T:DD0
0RUU00<aQSW7@PP00TY900=BZV<<Jfd00W_?00N<DIBbYCBU=;FFaQS>F@02eYX00mkKg__Nn`02g_/0
0mkKeY[>F@02aQP01kFf[EFLdicCS76447>^009S;003F/]BRT8X008ii`03<JHYIB4T008Hh`036<<@
XQ2200<8H@<8@@<083l000Go?003003o??ll00;o?0005Oll00<00?lloc`00_llL`000P0P0PQ100<8
HA224:800QS300<Hhb448B@00RU500<YIC6V>LL00T8800=:BE::F^/00V]=00Mkch@`U;:D/ZDd]IJm
m`02cUT00mJJg]_Nn`03g_/01]kKe[[>NLiiaSRme`:]M@03YABD/XaA009kc`03JfeS35:Z009:J@03
@PPiac66008YA@038B@HhaS3008@XP044888H@QQ26422444020l0005oc`00`00occo?002oc`001Go
?003003o??ll00;o?7@000060208@@Q1264@PQ2R0QS30QSS00HQ124T8B@YABUU<HH2<JH00cWW@RQ:
J@02F//01f</Ljj4<8@`U9:U5:ee00:mm`03aSSFV]kK00GNn`;Nf`07eY[>FKgg_ONe]ZeEW?<00Xaa
00>447>^Jdd00U[[00=BRTY9@PP00S6V00<aQRU58@@00QSS00@H`a2R488@PP88H@<8@@<083X000Go
?003003o??ll00;o?0005Oll00<00?lloc`00_llM00000H080Q12448HA224:826<<26><01R448B@Q
92U5:FDaQP8aYP03>NM2:4YY009Jb`07Hbac[X@`Q32DTZDD[GD00[gg00?6>=JJg]/01Mkk0]kK00OF
V/iI_ONmmkFf[EFLl`02S7400h@@Lji[C@02F^/00e::BTU22002<JH00c66:DDQ10026><011S34:8@
PQ220PQQ0`Q10`0P>P001Oll00<00?lloc`00_ll0009oc`00`00occo?002oc`20005oc`00`00occo
?002ocad00001P0P2448@@Q1264@PP8@XP036<<HhaSS008Q108Q9006:DDYIBUU<HHiad880TY900MB
ZV</LhicSX@@U9:Ll`02[GD00kgGaSS>N@02e[X00mkKg__Nn`02g_/01mkKe[[>NLiiaSRmejee00:U
5003U;:<DG__009cSP03HbaJbe::0092:003>NLaYRUU008YA@068@@HhaS36<<@XQ220`QQ0PQ1100P
=`001Oll00<00?lloc`00_ll0009oc`01@00occo??ll00000_ll00<00?lloc`00_ll00<00?lloc`0
0_llM0000`0P00<8@@QQ48800Q2200<@XQS36<<011SS0b4400<Q92U5<HH00SWW00M2:5::H`aS36]]
Nnn<L@02W=<00jeE]KK66002cUT00mJJg]_Nn`03g_/01]kKe[[F^]JJcUVmm`:e]P03[EFLliBB00:4
<003Nlm[KF<<009Jb`03BVU2:3WW008aYP07:FDYAB448@@HhaS34:800Q220PQQ0`Q11@0P<`001Oll
00<00?lloc`00_ll0006oc`50002oc`01000occo?0001?ll0P000ollM0000`0P00<8@@QQ26400Q22
0a2R21S300HHhb4T:FDYICW7@RP2DXX00e[[Jfekc`02S5400iBbYCBeUP02_OL00lHheY[F^P02g]/4
g_/00mkKeY[>N@02aSP00kgG]IJU=002W=<00haaQ11c[P02Jdd00f<<DZY:J@02@RP01cW7<JHYIBUU
8B@Q11SS008H``034:8@PPQQ0088H@88@@D0834000?o?0<000Co?0001_ll00@00?lloc`000?o?004
003o??ll0004oc`00`00occo?002ocad0003020224400`QQ488@PP0248844:8548801Q2R6<<Q1244
:FDaYP922003BVUJbf]=009c[P03Q32DTZDD00:]M@03_MO66<ii00;FVP03g]_Nnmkk00;Nn`07g]_F
^]JJeY[>FLHH]KH00Zee00>U59BbS5400W__00=cSV]=F^/00U:Z00M:BD88>LLiac6V:FDQ90028@@0
0aSS6<<@XP02488226432445020^0005oc`00`00occo?002oc`000Oo?003003o?00000?o?004003o
??ll0004oc`00`00occo?002ocad0003020224400`QQ488@PP0248844:8548801Q2R6<<Q1244:FDa
YP922003BVUJbf]=009c[P03Q32DTZDD00:]M@03_MO66<ii00;FVP03g]_Nnmkk00;Nn`07g]_F^]JJ
eY[>FLHH]KH00Zee00>U59BbS5400W__00=cSV]=F^/00U:Z00M:BD88>LLiac6V:FDQ90028@@00aSS
6<<@XP02488226432445020^0005oc`00`00occo?002oc`000So?08000?o?004003o??ll0004oc`0
0`00occo?002ocad000302022443264648800`QQ2448@@0224401PQQ488H`aS38@@YA@8aYP03@PQ:
JE[;009S;003Lhikkhaa00:Ld`03YCBeU[gg00;6>003cWWF^]kK00;Nf`07g__NfmJje[[FV/iiaSP0
0[gg00>eUZeEW?<00YBB00>4<7__Lhh00V</00MJje::BTU:BD88>LLaQP02:FD00b4T8@@Hh`026<<0
0a2R488@PP0226432444020/0005oc`00`00occo?002oc`000Wo?003003o??ll00;o?08000Go?003
003o??ll00;o?7@000<080<8@@P8H@072440800P020000Q126400Q2R00LH`b44:DDYAC6V>NM:B@02
DZX00f<<Jfekc`02Q3000iBbYAB]M@02]KH01LHHcUWFV]JJe[X01MkK00OF^/iicUW>FLHH_MN]M@02
YC@00icCS764<002Nll01f]]HbaJbe[;DXY:BD88008ia`03<HHYIB4T008Q10036><H`a2R00<@PP03
2648@@Q10088@@D082P000Go?003003o??ll00;o?0005Oll00<00?lloc`00_llM000100P0PQ120QQ
00<8@@0P00000P0000H080Q1488@PQ2R6<<28@@00bU5<HHia`02@RP00dYYF/]S;002Ljh00h@@S76L
d`02YC@01[FF_MO66<HHcUWFVP?F^P03g]_F^]Jj00;FVP03cUW6>;gg00:e]P03[EFU59Bb00:<L@07
Q11kcf]]JfeS;5[;DXX00TY900=223W7<HH00RUU00<YAB446><00QS300<@XQ2248800`QQ0`Q11@0P
9@001Oll00<00?lloc`00_ll000Eoc`20003ocad0004020424452642244502001@Q12648HA224:80
0QS300<Q124T:FD00S6V00=224Y9DZX00V<<00=[KG_?Q3000YBB00NLljeE]IJeU[ggaSS>F@03eYX4
e[X00mJJcWW>F@02aQP00kgG]IJ]E@02W?<01iBbS56448@@Lji[KF<<009Jb`03DXY:BD88008ia`03
<JHYIBU5008Q10036><H`a2R008@XP044888H@QQ26422446020R0004oc`20004oc`001Go?003003o
??ll00;o?7@000@080@8@@D8H@88@@D080052448H@QQ488@XP026<<00b448B@YI@02<JH00d88BTUB
ZP02H``00f]]Nln4<002U9801icc[EFeU[FF_OO6><iI00?FVPCF^P03eY[>NLiI00;66003_MNeUZeE
00:Ll`07U;:<DH@@Q11c[V]]H``00U[;00=BRTY9@PP00SW700<aYRUU:DD00R4400<HhaS34:800Q2R
00@@PPQQ2648H@88@@H0828000Go?003003o??ll00;o?0005Oll00<00?lloc`00_llM000100P1@Q1
0PQQ1@Q1100P0`Q100L8HA224:8@XQS36><Q9002:DD00c66>NM2:002DXX00e[;HbacSP02Nnl01haA
U;:U5:DD[EFe][gg00;6>003cUW>NMJJ00CFVP06cWW>FLiIaSRmmkFf0Zee00NU=9cCU9:DTXaANnmc
[P02Jdd00f<<F/]BRP02BTT00d88>LLaYP02:FD00bU58B@Hh`036<<00a2R488@PP0226442445020O
0005oc`00`00occo?002oc`001Go?003003o??ll00;o?7D000@080d8@@030208@@Q100<8@@<8H@03
488@XQS3008Q10038B@YIC6V00922003BTUBZU[[009[C@07Ljj448aaS76LdjDD[GD00[Ff00>mmlHH
cUT00lii00OFV/iicWW>NLiIaSS66002_ML01kFF[EFU5:DDW=><LH@`009kk`03Lhi[CF<<009Jb`03
DXY:BD88008ia`03<JHYIBU5008Q90058@@HhaS36<<@XP02488226432445020M0005oc`00`00occo
?002oc`001Go?003003o??ll00;o?7D000@080d8@@D080@8@@03264@PQ2R008H``036><Q92U5008a
QP03>LM2:4YY009Jb`07H`a[KG_?Nln4<8aaW=<00ZDD00>]MKFf_ML00/HH00?6><iIcUT00/ii0/iI
00G6><HHaQRmmkFf00:]M@03YCBLliBb00:<L@03Q31kcg>>009[C@03H`aJbe::009:B@03@PPiac6V
008YI@07:DDQ92448@@HhaS34:800a220PQQ0`Q11P0P6@001Oll00<00?lloc`00_ll000Eoc`00`00
occo?002ocae0004020=2449020224401PQQ488@PQ2R6<<Q108Q9003:FDaYSWW0092:007DXYJbf</
HbacSW_?Q3000YBB00>LdjDD[ED00[FF00>mekggaQP00lHh00K>FLHhaSS6><HH_OL2_ML00kFF[EFU
5002W=<00iBBS5644002Nll00g>>HbaJj`02DZX00dYYBTU22002>LL01c6V:FDYABU58B@Q11SS008H
``034:8@PQ2200<8H@88@@L081H000Go?003003o??ll00;o?0005Oll0P000ollM@00100P3@Q12@0P
0PQ100H8HA22488@XQS38@@28B@00bUU<JHii`02@RP01e::F/]S;6</Lhikch@`00:DTP03W=>U5:eE
00:eUP03_MNmmlHH00?6>006cUW6><HhaSS66;gg0[gG00>eUZeEYA@00YcC00>DTXaAQ1000W_?00=c
SV</F^/00U:Z00=:JDY9@PP00SW700LaYRUU:DDYAB4T8@@Hh`026<<00a2R488@PP0326422447020F
0004oc`20004oc`001Go?003003o??ll00;o?7D000D080X8@@D080@000@080062448H@QQ488@XQS3
0QSS00<Q12U5<HH00SW700M224Y9DXYBRU[[HbacSP02Nll00h@`S76Ld`02YA@00jeE]IJe]P02_ML0
0kggaQS66004aQP2_OL00kgG]IJ]M@02YC@00iccW=>DTP02Q3000g__Lji[K@02Hb`00e[[DZY:J@02
@RP01d88>LLaYS6V:FDYAB4T008Q10036><H`a2R00<@PP88H@@8@@D081@000Go?003003o??ll00;o
?0005Oll00<00?lloc`00_llM@001@0P2PQ1100P20000P0P0`Q100L8HA224:8@XQS36><Q9002:FD0
1c66>LM22488BTUBZU[[009[C@03Lhikch@`00:<L@03U;:LljDd00:]M@03]IJe][gG00Jmm`:me`06
]IJ]MJee[EFU59cC0YBb00><LH@`Nnl00W>^00=[KF</F^/00U:Z00M:JD8X>NLiicW7<HHYI@02:DD0
0b4T8@@Hh`026<<00a2R488@PP0326442445020A0005oc`00`00occo?002oc`001Go?003003o??ll
00;o?7D000D080T8@@D080T000<08088@@06264@PQ22488@XQSS0R4400LQ92UU<JHaYSWW@RQ:J@02
DZX00e[[HbacSP02Nll00h@@S76D/P02W?<00jDD[EF]M@02]IH2]KH3_ML2]KH2]IH00jee[EFU=002
W?<00iBbU9:<D@02Q1000g_?Lhi[C@02H``01e[;DXY:BDY9@RPiicW7008aQP03:FDYAB4T008Q1003
6><H`a2R00<@PP88H@@8@@D080l000Go?003003o??ll00;o?0005Oll00<00?lloc`00_llM@001`0P
1`Q11@0P2P00100P0`Q100<8HA224:800QS300LHhb44:DDYABUU<JHii`02@RP00dYYDZYJj`02Hb`0
0f]]Nln44002S5400iBBW=>Ll`02YC@01:eE[GF]MJee1KFF0Zee00J]EJDDYABLlicCU982S5400h@`
Nnmc[P02Jfd01f</F^]BZU:ZDXY:BD88008ii`03<JHaQRUU008Q90038@@HhaS3008H``034:8@PQ22
0088H@@8@@D080d000Go?003003o??ll00;o?0005Oll00<00?lloc`00_llM@001`0P1`Q11@0P2P00
100P0`Q100<8HA224:800QS300LHhb44:DDYABUU<JHii`02@RP00dYYDZYJj`02Hb`00f]]Nln44002
S5400iBBW=>Ll`02YC@01:eE[GF]MJee1KFF0Zee00J]EJDDYABLlicCU982S5400h@`Nnmc[P02Jfd0
1f</F^]BZU:ZDXY:BD88008ii`03<JHaQRUU008Q90038@@HhaS3008H``034:8@PQ220088H@@8@@D0
80d000Go?003003o??ll00;o?0005Oll0P000ollM`001@0P1PQ11P0P3@00100P00<8@@QQ26400Q22
00L@XQS36><Hhb44:DDYI@02<JH00cWW@RQ:J@02DZX00e[[Hba[K@02Ljh00g__Q32<L@02U9801IcC
W?>U5:DDYC@01jeE0ZDd00>U59ccW=<00YBB00><LH@`Nnl00W_?00McSV]=H`aS35[;DZY:J@02@RP0
0d88>LLaYP02:FD00bU58B@Q10026><00aS34:8@PP02488226432445020<0004oc`20004oc`001Go
?003003o??ll00;o?7L000D080H8@@D080l000@08088@@<8H@06488@XQ2R6<<Hhb440RU500<YIC6V
>NL00T8800=:BE::F//00V<<00=[CG>>Nll00X@@00F4<8aaU9:DTYcC00:Ll`>U50:U=0>U5007W?>L
diBbU;:DTXaaQ3000X@@00Mkcg>>Jde[CF</F^]BZP02DXX00dY9@PPii`02<JH00c66:FDQ90028@@0
0aSS6<<H``024:8011222648H@QQ0`Q1100P2`001Oll00<00?lloc`00_ll000Eoc`00`00occo?002
ocag000602052445020B00030203244326400a224:8H``026><00b44:DDYI@02<JH00cW7@PQ:B@02
DXX00e:ZF^]S;002Jfd01g>^Nln448@@Q32<LIBB00:D/P>Ld`:Ll`>Ld`:D/P03U9:<LHaA00:4<007
Nnmkcg>>Lhi[KF</F^/00U[;00=BRTY9@RP00SWW00<iac66:FD00RU500<Q92446><00QS300D@XQ22
488@PPQQ00@8@@<080X000Go?003003o??ll00;o?0005Oll00<00?lloc`00_llM`001P0P10Q11P0P
5000100P0`Q100<8HA2248800Q2R00<H`aSS8@@00RU500<YIC66>LL00T8800=2:4YYDZX00U[;00MS
36]=Jfe[KG>^Nln44002Q3000haAS76DTP08U9801XaaS564<8@`Q11kk`9c[P03Lhi[CF</009Jj`03
F/]BRTY90092:003>NLiac6V008YI@03:DDQ9244008Hh`046<<@XQ22488226432443020:0005oc`0
0`00occo?002oc`001Go?003003o??ll00;o?7L000H080@8@@H081@000@080<8@@03264@PQ22008@
XP036<<Hhb44008YA@03:FDaQSW700922003@RQ:JE:Z009Jb`07H`a[CF]]Jfec[W_?Q1000X@`00><
DHaaU98029BB00J<LHaAQ324<8@@Nnl2Ljh00g>>JdeS;002F^/00e[;DXY:B@02@RP00cWW>LLaYP02
:FD00bU58B@Q10026><011S34:8@PQ220PQQ0`Q10`0P2P001Oll00<00?lloc`00_ll0008oc`20004
oc`20005oc`00`00occo?002ocag000@020G0004020224401PQQ488@PQ224:8H``8Hh`038@@Q92UU
008aQP03<JHiid8X009:B@07DXYBZU[[F^]S;6]=Jfd00W>^00=kcg__Q1000h@`1XaA0h@`00N447__
Nlmkcg>^Jfe[C@02H``00e[[DZYBRP02BTT00d8X>NLia`02<HH00bUU:DDQ90028@@01ASS6<<@XQ2R
48800PQQ0`Q1100P20001Oll00<00?lloc`00_ll0007oc`01000occo?0000_ll00@00?lloc`000Co
?003003o??ll00;o?7L0010081P000D080<8@@88H@06488@XQ2R6<<Hhb440R4T00<YABUU<JH00SW7
00M2248XBVU:JE::F/]Jj`02H``00f]=JfecSP02Ljh00g_?Nnmkk`05Q103Nnl01W_?Ljic[W>>Jfe[
C@9S;003H`aJbe:Z009:J@03BTU223WW008aYP03<HHYIBU5008Q10046><H`a2R4:82488010QQ2448
@@Q1100P20001Oll00<00?lloc`00_ll0007oc`01000occo?0000_ll00@00?lloc`000Co?08000?o
?7L0010081/000D08088@@<8H@03488@XQS3008Hh`038@@Q92U5008YI@07<HHaYSWW>NM224Y9BVT0
0U::00=Jbe[[H``00V</00=[CF]]Lhh00W>>1g>^0g>>00M[KF]=HbaS;6<<F/]BZP02DXX00dY9@RQ2
2002>LL00c6V<HHYA@028B@01R446><H`aS34:8@PP<8H@88@@@080L000?o?0<000Co?0001oll0`00
0oll00@00?lloc`000Co?003003o??ll00;o?7P000l081d000D080<8@@88H@06488@XQ2R4:8H`aSS
0R4400LQ92U5:FDYIC6V>LLii`02@PP00dY9BVUBRP02DZX00e[;F^]S3003Hb`2Jdd4Jfd3Jdd2Hb`2
H``00e[[F/]BZP02DXX00dYY@RQ22002>NL00c6V<HHYI@028B@01B446><H`aS34:800Q220PQQ0PQ1
100P1`001Oll00<00?lloc`00_ll0007oc`00`00occo?003oc`01000occo?0001?ll00<00?lloc`0
0_llN0003`0P7@001@0P0`Q10PQQ00H@PQ2R4:8@XQS36><28@@01b4T:DDYIBUU<JHiacWW00922003
BTU:JE::009BZP03F/]Jjf<<00=S;09[C@A[K@=[C@9S;09S3003F^]Jbe:Z009BRP03BVU2:488008i
i`03<JHaQRUU008Q90058@@HhaS36<<@XP0248822642244402070005oc`00`00occo?002oc`000Oo
?003003o??ll00?o?004003o??ll0004oc`00`00occo?002ocah000?020P00050202244326424880
1A2R6<<H`aSS8@@00R4T00<YABUU<HH00S6V00<iacWW@PP00T8X00=:BDYYDXX00U:Z00=Jbe[[F^/0
26<<0e[[00=Jbe:ZDXX00TYY00=:BD8X@PP00SWW00<aYS66:FD00RU500@Q91SS6<<H``8@XP034888
H@QQ0088@@@080L000Go?003003o??ll00;o?0002?ll0`000oll0P001Oll00<00?lloc`00_llN000
3`0P8`00100P10Q10PQQ0Q220Q2R0QS300<Hhb448B@00RU500<YIC66<JH00SW700<iid88@RP00dY9
00A:JE::DXYBRPUBZP9BRP06BVU:BDY9@RQ223WW0SW700<aYS66:FD00RU500LQ92446><HhaS34:8@
PP0326400`Q10200800202070005oc`00`00occo?002oc`001Go?003003o??ll00;o?7P000h082L0
00D08088@@<8H@<@PP034:8H`aS3008Hh`038@@Q92U5008YI@8aQP04<JHiacW7>NL2@PP2@RP4BTT5
BVT3BTT2@RP2@PP01SWW>LLiac6V<HHYI@8YA@078B@Q11SS6><H`a2R48800`QQ00<8@@0P02000P0P
1`001Oll00<00?lloc`00_ll000Eoc`20003ocah000>020Y00050204244326401A224:8@XQ2R6<<0
0QSS0R4400<Q92U5:DD00RUU00<aQS6V<JH00SW70SWW2T880cWW0SW70S6V00<aQRUU:DD00R4T00@Q
11SS6<<H``8@XP054888H@QQ2648@@0402070004oc`20004oc`001Go?003003o??ll00;o?7P000h0
82T000D080@8@@<8H@05488@XQ2R4:8H``026><28@@00b4T:DDYA@02:FD00c66<JHaYP02>LL2>NL:
@PP3>NL2>LL2<JH00c66:FDYA@028B@012446><H`aS30Q2R00D@PPQQ2648H@Q100@080L000Go?003
003o??ll00;o?0005Oll00<00?lloc`00_llN0003P0P;0001@0P10Q10PQQ0a220Q2R0aS300<Hhb44
8B@00R4T00@YABUU:FDYI@8aQP<aYPTia`8aYP<aQP03:FDYAB4T008Q90058@@HhaS36<<@XP024882
2642244402070005oc`00`00occo?002oc`001Go?003003o??ll00;o?7P000h0830000D080@8@@88
H@<@PP8@XP<H``8Hh`048@@Q924T8B@3:DD3:FD8<HH2:FD3:DD28B@28@@01ASS6<<H`aS34:800Q22
0PQQ0PQ1100P1`001Oll00<00?lloc`00_ll000Eoc`00`00occo?002ocah000>020b000702032443
264448824:836<<26><38@@48B@7:DD48B@28@@26><26<<34:8011222648H@QQ0PQ1100P1`001Oll
00<00?lloc`00_ll000Eoc`00`00occo?002ocah000>020f000602042444264248834:846<<46><:
8@@36><36<<34:8248832642244402070005oc`00`00occo?002oc`001Go?08000?o?7P000h083H0
00H080@8@@@8H@8@PP<@XP@H``@Hh`XQ10<Hh`<H``<@XP8@PP<8H@88@@@080L000Co?08000Co?000
5Oll00<00?lloc`00_llN@003@0P>P001P0P10Q110QQ11220a2R21S300<HhaS36<<011S3112R0a22
0PQQ0`Q11@0P1`001Oll00<00?lloc`00_ll000Eoc`00`00occo?002ocai000=020n000602052444
2645488<4:8648822644244402080005oc`00`00occo?002oc`001Go?003003o??ll00;o?7T000/0
84<000L080H8@@D8H@d@PPD8H@@8@@D080P000Go?003003o??ll00;o?0005Oll00<00?lloc`00_ll
N@002`0PA`00200P1PQ13`QQ1@Q11@0P2P001Oll00<00?lloc`00_ll000Eoc`00`00occo?002ocai
000;021700080206244?26452445020:0005oc`00`00occo?002oc`001Go?003003o??ll00;o?7T0
00/084/000T081@8@@H080X000Go?003003o??ll00;o?0005Oll0P000ollN@002`0PD0002`0P2@Q1
2@0P2`001?ll0P001?ll000Eoc`00`00occo?002ocai000;021E000G020<0005oc`00`00occo?002
oc`001Go?003003o??ll00;o?7T000/085X000l080l000Go?003003o??ll00;o?0005Oll00<00?ll
oc`00_llN@002`0PFP003`0P3`001Oll00<00?lloc`00_ll0008oc`20004oc`20005oc`00`00occo
?002ocai000;021h0005oc`00`00occo?002oc`000Oo?004003o??ll0002oc`01000occo?0001?ll
00<00?lloc`00_llN@002`0PN0001Oll00<00?lloc`00_ll0007oc`01000occo?0000_ll00@00?ll
oc`000Co?08000?o?7X000X087P000?o?0<000Co?0002?ll0P000oll00@00?lloc`000Co?003003o
??ll00;o?7X000X087P000Go?003003o??ll00;o?0001oll00@00?lloc`000;o?004003o??ll0004
oc`00`00occo?002ocaj000:021h0005oc`00`00occo?002oc`000Oo?004003o??ll0002oc`01000
occo?0001?ll00<00?lloc`00_llNP002P0PN0001Oll00<00?lloc`00_ll0008oc`20004oc`20005
oc`00`00occo?002ocaj000:021h0005oc`00`00occo?002oc`001Go?003003o??ll00;o?7X000T0
87T000Go?003003o??ll00;o?0005Oll0P000ollNP002@0PN@001?ll0P001?ll000Eoc`00`00occo
?002ocaj0009021i0005oc`00`00occo?002oc`001Go?003003o??ll00;o?7X000T087T000Go?003
003o??ll00;o?0005Oll00<00?lloc`00_llNP002@0PN@001Oll00<00?lloc`00_ll000Eoc`00`00
occo?002ocaj0009021i0005oc`00`00occo?002oc`001Go?003003o??ll00;o?7X000T087T000Go
?003003o??ll00;o?0005Oll00<00?lloc`00_llNP002@0PN@001Oll00<00?lloc`00_ll000Eoc`2
0003ocaj0009021i0004oc`20004oc`001Go?003003o??ll00;o?7X000T087T000Go?003003o??ll
00;o?0005Oll00<00?lloc`00_llNP002@0PN@001Oll00<00?lloc`00_ll000Eoc`00`00occo?002
ocaj0009021i0005oc`00`00occo?002oc`001Go?003003o??ll00;o?7X000T087T000Go?003003o
??ll00;o?0005Oll00<00?lloc`00_llNP002@0PN@001Oll00<00?lloc`00_ll000Eoc`20003ocaj
0009021i0004oc`20004oc`001Go?003003o??ll00;o?7X000T087T000Go?003003o??ll00;o?000
5Oll00<00?lloc`00_llNP002@0PN@001Oll00<00?lloc`00_ll000Eoc`00`00occo?002ocaj0009
021i0005oc`00`00occo?002oc`00003oc`00000008000?o?08000Co?08000Go?003003o??ll00;o
?7X000T087T000Go?003003o??ll00;o?0000oll00D00?llocco?00000;o?004003o??ll0002oc`0
0`00occo?002oc`00`00occo?002ocaj0009021i0005oc`00`00occo?002oc`000?o?005003o??ll
oc`00002oc`01000occo?0000_ll00<00?lloc`00_ll0P00ooll0oll0`001?ll0003oc`01@00occo
??ll00000_ll00@00?lloc`000;o?003003o??ll00;o?003003o??ll00;o?003003o??ll03co?003
003o??ll03co?003003o??ll03co?003003o??ll03co?003003o??ll00;o?003003o??ll00;o?000
0oll00D00?llocco?00000;o?004003o??ll0002oc`00`00occo?002oc`00`00occo?002oc`00`00
occo?009oc`00`00occo?00:oc`00`00occo?00:oc`00`00occo?009oc`00`00occo?00:oc`00`00
occo?009oc`00`00occo?00:oc`00`00occo?009oc`00`00occo?00:oc`00`00occo?00:oc`00`00
occo?009oc`00`00occo?00:oc`00`00occo?009oc`00`00occo?00:oc`00`00occo?00:oc`00`00
occo?009oc`00`00occo?00:oc`00`00occo?009oc`00`00occo?00:oc`00`00occo?00:oc`00`00
occo?002oc`00`00occo?002oc`00004oc`000000003oc`01000occo?0000_ll00@00?lloc`000Co
??l000P000Co?0000oll00<00?lloc`00_ll0P001?ll0P00ooll4Oll003ooc`Qoc`00?oo?27o?000
ooll8Oll003ooc`Qoc`00?oo?27o?000ooll8Oll003ooc`Qoc`00?oo?27o?000ooll8Oll003ooc`Q
oc`00?oo?27o?000ooll8Oll003ooc`Qoc`00?oo?27o?000ooll8Oll003ooc`Qoc`00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-20.9043, -24.3878, \
0.794624, 0.794624}}],

Cell[BoxData[
    \({46.3`\ Second, Null}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Given a sampled signal: calculate the STFT", "Section",
  InitializationCell->True,
  TextAlignment->Center],

Cell["\<\
Let us consider now a sampled signal: we use only discrete \
operations and the calculation of the STFT is much faster \
\>", \
"Subsubsection"],

Cell["<< Miscellaneous`Audio`", "Input",
  InitializationCell->True,
  CellTags->"S5.51.1"],

Cell[BoxData[
    \(Nf[f_, t_] := Table[f[x], {x, \(-10\), 10, t}]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(Ng[t_] := 
      RotateRight[Table[g[x], {x, \(-10\), 10, t}], 
        Round[\(-10\)/t]]\)], "Input",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[Nf[f, 0.05], Frame \[Rule] True, PlotRange \[Rule] All, 
        PlotJoined \[Rule] True];\)\)], "Input",
  InitializationCell->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0214286 0.00238095 0.309757 0.80251 [
[.02143 -0.0125 -3 -9 ]
[.02143 -0.0125 3 0 ]
[.25952 -0.0125 -9 -9 ]
[.25952 -0.0125 9 0 ]
[.49762 -0.0125 -9 -9 ]
[.49762 -0.0125 9 0 ]
[.73571 -0.0125 -9 -9 ]
[.73571 -0.0125 9 0 ]
[.97381 -0.0125 -9 -9 ]
[.97381 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .069 -24 -4.5 ]
[-0.0125 .069 0 4.5 ]
[-0.0125 .14926 -24 -4.5 ]
[-0.0125 .14926 0 4.5 ]
[-0.0125 .22951 -24 -4.5 ]
[-0.0125 .22951 0 4.5 ]
[-0.0125 .30976 -6 -4.5 ]
[-0.0125 .30976 0 4.5 ]
[-0.0125 .39001 -18 -4.5 ]
[-0.0125 .39001 0 4.5 ]
[-0.0125 .47026 -18 -4.5 ]
[-0.0125 .47026 0 4.5 ]
[-0.0125 .55051 -18 -4.5 ]
[-0.0125 .55051 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02143 0 m
.02143 .00625 L
s
[(0)] .02143 -0.0125 0 1 Mshowa
.25952 0 m
.25952 .00625 L
s
[(100)] .25952 -0.0125 0 1 Mshowa
.49762 0 m
.49762 .00625 L
s
[(200)] .49762 -0.0125 0 1 Mshowa
.73571 0 m
.73571 .00625 L
s
[(300)] .73571 -0.0125 0 1 Mshowa
.97381 0 m
.97381 .00625 L
s
[(400)] .97381 -0.0125 0 1 Mshowa
.125 Mabswid
.06905 0 m
.06905 .00375 L
s
.11667 0 m
.11667 .00375 L
s
.16429 0 m
.16429 .00375 L
s
.2119 0 m
.2119 .00375 L
s
.30714 0 m
.30714 .00375 L
s
.35476 0 m
.35476 .00375 L
s
.40238 0 m
.40238 .00375 L
s
.45 0 m
.45 .00375 L
s
.54524 0 m
.54524 .00375 L
s
.59286 0 m
.59286 .00375 L
s
.64048 0 m
.64048 .00375 L
s
.6881 0 m
.6881 .00375 L
s
.78333 0 m
.78333 .00375 L
s
.83095 0 m
.83095 .00375 L
s
.87857 0 m
.87857 .00375 L
s
.92619 0 m
.92619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .069 m
.00625 .069 L
s
[(-0.3)] -0.0125 .069 1 0 Mshowa
0 .14926 m
.00625 .14926 L
s
[(-0.2)] -0.0125 .14926 1 0 Mshowa
0 .22951 m
.00625 .22951 L
s
[(-0.1)] -0.0125 .22951 1 0 Mshowa
0 .30976 m
.00625 .30976 L
s
[(0)] -0.0125 .30976 1 0 Mshowa
0 .39001 m
.00625 .39001 L
s
[(0.1)] -0.0125 .39001 1 0 Mshowa
0 .47026 m
.00625 .47026 L
s
[(0.2)] -0.0125 .47026 1 0 Mshowa
0 .55051 m
.00625 .55051 L
s
[(0.3)] -0.0125 .55051 1 0 Mshowa
.125 Mabswid
0 .08505 m
.00375 .08505 L
s
0 .1011 m
.00375 .1011 L
s
0 .11716 m
.00375 .11716 L
s
0 .13321 m
.00375 .13321 L
s
0 .16531 m
.00375 .16531 L
s
0 .18136 m
.00375 .18136 L
s
0 .19741 m
.00375 .19741 L
s
0 .21346 m
.00375 .21346 L
s
0 .24556 m
.00375 .24556 L
s
0 .26161 m
.00375 .26161 L
s
0 .27766 m
.00375 .27766 L
s
0 .29371 m
.00375 .29371 L
s
0 .32581 m
.00375 .32581 L
s
0 .34186 m
.00375 .34186 L
s
0 .35791 m
.00375 .35791 L
s
0 .37396 m
.00375 .37396 L
s
0 .40606 m
.00375 .40606 L
s
0 .42211 m
.00375 .42211 L
s
0 .43816 m
.00375 .43816 L
s
0 .45421 m
.00375 .45421 L
s
0 .48631 m
.00375 .48631 L
s
0 .50236 m
.00375 .50236 L
s
0 .51841 m
.00375 .51841 L
s
0 .53446 m
.00375 .53446 L
s
0 .05295 m
.00375 .05295 L
s
0 .0369 m
.00375 .0369 L
s
0 .02085 m
.00375 .02085 L
s
0 .0048 m
.00375 .0048 L
s
0 .56656 m
.00375 .56656 L
s
0 .58261 m
.00375 .58261 L
s
0 .59866 m
.00375 .59866 L
s
0 .61471 m
.00375 .61471 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.02143 .61178 m
.02143 .61803 L
s
.25952 .61178 m
.25952 .61803 L
s
.49762 .61178 m
.49762 .61803 L
s
.73571 .61178 m
.73571 .61803 L
s
.97381 .61178 m
.97381 .61803 L
s
.125 Mabswid
.06905 .61428 m
.06905 .61803 L
s
.11667 .61428 m
.11667 .61803 L
s
.16429 .61428 m
.16429 .61803 L
s
.2119 .61428 m
.2119 .61803 L
s
.30714 .61428 m
.30714 .61803 L
s
.35476 .61428 m
.35476 .61803 L
s
.40238 .61428 m
.40238 .61803 L
s
.45 .61428 m
.45 .61803 L
s
.54524 .61428 m
.54524 .61803 L
s
.59286 .61428 m
.59286 .61803 L
s
.64048 .61428 m
.64048 .61803 L
s
.6881 .61428 m
.6881 .61803 L
s
.78333 .61428 m
.78333 .61803 L
s
.83095 .61428 m
.83095 .61803 L
s
.87857 .61428 m
.87857 .61803 L
s
.92619 .61428 m
.92619 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .069 m
1 .069 L
s
.99375 .14926 m
1 .14926 L
s
.99375 .22951 m
1 .22951 L
s
.99375 .30976 m
1 .30976 L
s
.99375 .39001 m
1 .39001 L
s
.99375 .47026 m
1 .47026 L
s
.99375 .55051 m
1 .55051 L
s
.125 Mabswid
.99625 .08505 m
1 .08505 L
s
.99625 .1011 m
1 .1011 L
s
.99625 .11716 m
1 .11716 L
s
.99625 .13321 m
1 .13321 L
s
.99625 .16531 m
1 .16531 L
s
.99625 .18136 m
1 .18136 L
s
.99625 .19741 m
1 .19741 L
s
.99625 .21346 m
1 .21346 L
s
.99625 .24556 m
1 .24556 L
s
.99625 .26161 m
1 .26161 L
s
.99625 .27766 m
1 .27766 L
s
.99625 .29371 m
1 .29371 L
s
.99625 .32581 m
1 .32581 L
s
.99625 .34186 m
1 .34186 L
s
.99625 .35791 m
1 .35791 L
s
.99625 .37396 m
1 .37396 L
s
.99625 .40606 m
1 .40606 L
s
.99625 .42211 m
1 .42211 L
s
.99625 .43816 m
1 .43816 L
s
.99625 .45421 m
1 .45421 L
s
.99625 .48631 m
1 .48631 L
s
.99625 .50236 m
1 .50236 L
s
.99625 .51841 m
1 .51841 L
s
.99625 .53446 m
1 .53446 L
s
.99625 .05295 m
1 .05295 L
s
.99625 .0369 m
1 .0369 L
s
.99625 .02085 m
1 .02085 L
s
.99625 .0048 m
1 .0048 L
s
.99625 .56656 m
1 .56656 L
s
.99625 .58261 m
1 .58261 L
s
.99625 .59866 m
1 .59866 L
s
.99625 .61471 m
1 .61471 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 .30976 m
1 .30976 L
s
.5 Mabswid
.02381 .30976 m
.02619 .30976 L
.02857 .30976 L
.03095 .30976 L
.03333 .30976 L
.03571 .30976 L
.0381 .30976 L
.04048 .30976 L
.04286 .30976 L
.04524 .30976 L
.04762 .30976 L
.05 .30974 L
.05238 .30967 L
.05476 .30953 L
.05714 .30929 L
.05952 .30897 L
.0619 .30862 L
.06429 .30836 L
.06667 .30835 L
.06905 .30877 L
.07143 .30976 L
.07381 .31139 L
.07619 .3136 L
.07857 .3162 L
.08095 .31883 L
.08333 .32102 L
.08571 .32224 L
.0881 .32199 L
.09048 .31989 L
.09286 .31578 L
.09524 .30976 L
.09762 .30224 L
.1 .29396 L
.10238 .28588 L
.10476 .27909 L
.10714 .27471 L
.10952 .2737 L
.1119 .27672 L
.11429 .284 L
.11667 .29528 L
.11905 .30976 L
.12143 .32613 L
.12381 .34274 L
.12619 .35771 L
.12857 .36914 L
.13095 .37537 L
.13333 .3752 L
.13571 .36801 L
.1381 .35397 L
.14048 .33399 L
Mistroke
.14286 .30976 L
.14524 .28355 L
.14762 .25803 L
.15 .236 L
.15238 .22004 L
.15476 .21227 L
.15714 .21406 L
.15952 .22584 L
.1619 .24697 L
.16429 .2758 L
.16667 .30976 L
.16905 .3456 L
.17143 .37969 L
.17381 .40843 L
.17619 .42856 L
.17857 .4376 L
.18095 .4341 L
.18333 .41785 L
.18571 .38996 L
.1881 .35279 L
.19048 .30976 L
.19286 .26501 L
.19524 .22305 L
.19762 .18823 L
.2 .16436 L
.20238 .15425 L
.20476 .15938 L
.20714 .17976 L
.20952 .21382 L
.2119 .25854 L
.21429 .30976 L
.21667 .3625 L
.21905 .41149 L
.22143 .45172 L
.22381 .47888 L
.22619 .48991 L
.22857 .48328 L
.23095 .4592 L
.23333 .41965 L
.23571 .36821 L
.2381 .30976 L
.24048 .24997 L
.24286 .19478 L
.24524 .14982 L
.24762 .11977 L
.25 .10796 L
.25238 .11593 L
.25476 .14328 L
.25714 .18766 L
.25952 .24497 L
Mistroke
.2619 .30976 L
.26429 .3757 L
.26667 .43628 L
.26905 .48536 L
.27143 .51789 L
.27381 .53036 L
.27619 .52122 L
.27857 .49102 L
.28095 .44244 L
.28333 .38003 L
.28571 .30976 L
.2881 .23849 L
.29048 .17326 L
.29286 .12063 L
.29524 .08596 L
.29762 .07294 L
.3 .08311 L
.30238 .11578 L
.30476 .16798 L
.30714 .23478 L
.30952 .30976 L
.3119 .38559 L
.31429 .45479 L
.31667 .51045 L
.31905 .54693 L
.32143 .56042 L
.32381 .54935 L
.32619 .51457 L
.32857 .45928 L
.33095 .38874 L
.33333 .30976 L
.33571 .23006 L
.3381 .15749 L
.34048 .09928 L
.34286 .06128 L
.34524 .04742 L
.34762 .05925 L
.35 .09583 L
.35238 .15373 L
.35476 .22742 L
.35714 .30976 L
.35952 .39269 L
.3619 .46806 L
.36429 .52839 L
.36667 .56764 L
.36905 .58179 L
.37143 .5693 L
.37381 .53123 L
.37619 .47115 L
.37857 .39486 L
Mistroke
.38095 .30976 L
.38333 .22417 L
.38571 .14652 L
.3881 .08447 L
.39048 .04423 L
.39286 .02986 L
.39524 .0429 L
.39762 .08221 L
.4 .14405 L
.40238 .22244 L
.40476 .30976 L
.40714 .39745 L
.40952 .47691 L
.4119 .54029 L
.41429 .58129 L
.41667 .5958 L
.41905 .5823 L
.42143 .54201 L
.42381 .47879 L
.42619 .39877 L
.42857 .30976 L
.43095 .22047 L
.43333 .13966 L
.43571 .07531 L
.4381 .03377 L
.44048 .01918 L
.44286 .03305 L
.44524 .07409 L
.44762 .13834 L
.45 .21954 L
.45238 .30976 L
.45476 .40016 L
.45714 .48188 L
.45952 .54687 L
.4619 .58873 L
.46429 .60332 L
.46667 .58916 L
.46905 .54759 L
.47143 .48266 L
.47381 .40071 L
.47619 .30976 L
.47857 .21871 L
.48095 .13651 L
.48333 .07121 L
.48571 .02923 L
.4881 .01472 L
.49048 .02909 L
.49286 .07097 L
.49524 .13624 L
.49762 .21853 L
Mistroke
.5 .30976 L
.50238 .3377 L
.50476 .38283 L
.50714 .43582 L
.50952 .49072 L
.5119 .54127 L
.51429 .58071 L
.51667 .60229 L
.51905 .6002 L
.52143 .5706 L
.52381 .51279 L
.52619 .43 L
.52857 .32986 L
.53095 .224 L
.53333 .1269 L
.53571 .05387 L
.5381 .01837 L
.54048 .02909 L
.54286 .08752 L
.54524 .18637 L
.54762 .30976 L
.55 .43521 L
.55238 .53764 L
.55476 .59448 L
.55714 .5912 L
.55952 .52565 L
.5619 .41004 L
.56429 .26949 L
.56667 .13718 L
.56905 .04652 L
.57143 .02238 L
.57381 .07356 L
.57619 .18885 L
.57857 .33846 L
.58095 .48107 L
.58333 .57507 L
.58571 .59113 L
.5881 .52214 L
.59048 .38712 L
.59286 .22697 L
.59524 .09268 L
.59762 .02904 L
.6 .05903 L
.60238 .17458 L
.60476 .33744 L
.60714 .49102 L
.60952 .5799 L
.6119 .57027 L
.61429 .46383 L
.61667 .29903 L
Mistroke
.61905 .13809 L
.62143 .04384 L
.62381 .05467 L
.62619 .16791 L
.62857 .33897 L
.63095 .49796 L
.63333 .57806 L
.63571 .54413 L
.6381 .40932 L
.64048 .23121 L
.64286 .08807 L
.64524 .04442 L
.64762 .12115 L
.65 .2843 L
.65238 .45886 L
.65476 .56284 L
.65714 .54609 L
.65952 .41565 L
.6619 .23412 L
.66429 .09053 L
.66667 .05666 L
.66905 .1503 L
.67143 .32461 L
.67381 .49041 L
.67619 .56152 L
.67857 .50012 L
.68095 .33818 L
.68333 .16201 L
.68571 .06685 L
.6881 .10494 L
.69048 .25563 L
.69286 .43534 L
.69524 .54315 L
.69762 .51784 L
.7 .37374 L
.70238 .19396 L
.70476 .08319 L
.70714 .10649 L
.70952 .24996 L
.7119 .42772 L
.71429 .53259 L
.71667 .50101 L
.71905 .35267 L
.72143 .17952 L
.72381 .08945 L
.72619 .13865 L
.72857 .29539 L
.73095 .45925 L
.73333 .52497 L
.73571 .4506 L
Mistroke
.7381 .28553 L
.74048 .13877 L
.74286 .10728 L
.74524 .2111 L
.74762 .37942 L
.75 .49791 L
.75238 .48642 L
.75476 .35417 L
.75714 .19368 L
.75952 .11675 L
.7619 .17614 L
.76429 .32833 L
.76667 .46428 L
.76905 .4873 L
.77143 .38253 L
.77381 .22759 L
.77619 .13585 L
.77857 .17329 L
.78095 .31011 L
.78333 .44324 L
.78571 .47368 L
.7881 .38069 L
.79048 .23688 L
.79286 .15227 L
.79524 .18997 L
.79762 .3182 L
.8 .43597 L
.80238 .45234 L
.80476 .35726 L
.80714 .22827 L
.80952 .16785 L
.8119 .22176 L
.81429 .34354 L
.81667 .43366 L
.81905 .42078 L
.82143 .31894 L
.82381 .21399 L
.82619 .19162 L
.82857 .26687 L
.83095 .3738 L
.83333 .42266 L
.83571 .37546 L
.8381 .27603 L
.84048 .21021 L
.84286 .23168 L
.84524 .31772 L
.84762 .3918 L
.85 .39149 L
.85238 .32147 L
.85476 .24619 L
Mistroke
.85714 .23088 L
.85952 .28472 L
.8619 .35609 L
.86429 .38151 L
.86667 .34231 L
.86905 .27809 L
.87143 .24747 L
.87381 .27448 L
.87619 .32987 L
.87857 .36172 L
.88095 .3441 L
.88333 .29806 L
.88571 .26795 L
.8881 .27886 L
.89048 .31584 L
.89286 .3422 L
.89524 .33569 L
.89762 .30704 L
.9 .28556 L
.90238 .28945 L
.90476 .31075 L
.90714 .32696 L
.90952 .32446 L
.9119 .30945 L
.91429 .29829 L
.91667 .3001 L
.91905 .30992 L
.92143 .31673 L
.92381 .31533 L
.92619 .30957 L
.92857 .30607 L
.93095 .30709 L
.93333 .30994 L
.93571 .31132 L
.9381 .31072 L
.94048 .30965 L
.94286 .3093 L
.94524 .30954 L
.94762 .30979 L
.95 .30982 L
.95238 .30978 L
.95476 .30975 L
.95714 .30976 L
.95952 .30976 L
.9619 .30976 L
.96429 .30976 L
.96667 .30976 L
.96905 .30976 L
.97143 .30976 L
.97381 .30976 L
Mistroke
.97619 .30976 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  InitializationCell->True,
  ImageSize->{288, 177.938},
  ImageMargins->{{281, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40n007h00Oooll8Oll003ooc`Q
oc`00?oo?27o?000ooll8Oll000Ooc`2000eoc`40003oc`20004oc`2000^oc`40003oc`20004oc`2
000_oc`20004oc`20004oc`2000aoc`00`00occo?002oc`20004oc`20003oc`001ko?004003o??ll
000foc`01@00occo??ll00000_ll00@00?lloc`000;o?003003o??ll02_o?003003o??ll00?o?004
003o??ll0002oc`01000occo?000;Oll00@00?lloc`000;o?004003o??ll0002oc`01000occo?000
<?ll00D00?llocco?00000;o?004003o??ll0002oc`10001oc`1oc`001ko?004003o??ll000foc`0
1@00occo??ll00000_ll00@00?lloc`000;o?003003o??ll02co?003003o??ll00;o?004003o??ll
0002oc`01000occo?000<?ll00@00?lloc`000;o?004003o??ll0002oc`00`00occo?00[oc`50002
oc`01000occo?0000_ll00@00?lloc`000;o?0007_ll00@00?lloc`003Ko?005003o??lloc`00002
oc`01000occo?0000_ll00<00?lloc`0;Oll00D00?llocco?00000;o?004003o??ll0002oc`00`00
occo?00/oc`20003oc`01000occo?0000_ll00@00?lloc`002go?004003o??ll0003oc`01000occo
?0000_ll00@00?lloc`000;o?0007_ll00@00?lloc`003Ko?005003o??lloc`00002oc`01000occo
?0000_ll00<00?lloc`0;_ll00@00?lloc`000;o?004003o??ll0002oc`00`00occo?00^oc`01000
occo?0000_ll00@00?lloc`000;o?003003o??ll02co?003003o?00000?o?004003o??ll0002oc`0
1000occo?0000_ll000Noc`01000occo?000=?ll0`000oll00@00?lloc`000;o?004003o??ll000]
oc`01000occo?0000_ll00@00?lloc`000;o?004003o??ll000]oc`01000occo?0000_ll00@00?ll
oc`000;o?004003o??ll000_oc`20003oc`01000occo?0000_ll00@00?lloc`000;o?0007oll0P00
=oll00<00?lloc`00_ll0P001?ll0P00;oll0P001?ll0P001?ll0P00;oll0P001?ll0P001?ll0P00
<Oll00<00?lloc`00_ll0P001?ll0P000oll003ooc`Qoc`00?oo?27o?000ooll8Oll003ooc`Qoc`0
01_o??l000<000?o?0006oll0P000oll00<00?lloc`02_ll00<00?lloc`02Oll00<00?lloc`02Oll
00<00?lloc`02Oll00<00?lloc`02_ll00<00?lloc`02Oll00<00?lloc`02Oll00<00?lloc`02Oll
00<00?lloc`02_ll00<00?lloc`02Oll00<00?lloc`02Oll00<00?lloc`02Oll00<00?lloc`02_ll
00<00?lloc`02Oll00<00?lloc`02Oll00<00?lloc`02Oll00<00?lloc`02_ll00<00?lloc`02Oll
00<00?lloc`02Oll00<00?lloc`02_ll00<00?lloc`00_ll0P000oll000Koc`00`00occo?03noc`0
0`00occo?001oc`001_o?003003o??ll07[o?003003o??ll087o?003003o??ll007o?0006oll00<0
0?lloc`0K_ll00<00?lloc`02Oll00<00?lloc`02_ll00<00?lloc`0M?ll00<00?lloc`00Oll000K
oc`2001_oc`00`00occo?009oc`00`00occo?00:oc`00`00occo?006oc`00`00occo?01Zoc`20003
oc`001_o?003003o??ll06ko?003003o??ll00Wo?08000_o?08000Oo?003003o??ll06_o?003003o
??ll007o?0006oll00<00?lloc`0H_ll00<00?lloc`02Oll0P002_ll0P002oll0P001oll00<00?ll
oc`01?ll00<00?lloc`0I?ll00<00?lloc`00Oll000Koc`00`00occo?01Roc`00`00occo?009oc`2
000:oc`2000;oc`20007oc`00`00occo?004oc`00`00occo?01Toc`00`00occo?001oc`001_o?080
06?o?003003o??ll00Wo?08000[o?08000_o?08000Ko?08000Ko?003003o??ll06?o?08000?o?000
6oll00<00?lloc`0HOll00<00?ll00002_ll0P002_ll0P002oll0P001_ll0P001_ll00<00?lloc`0
I?ll00<00?lloc`00Oll000Koc`00`00occo?01Qoc`00`00oc`0000:oc`2000:oc`2000;oc`20006
oc`20006oc`00`00occo?003oc`00`00occo?003oc`00`00occo?01Hoc`00`00occo?001oc`001_o
?003003o??ll05Ko?003003o??ll00So?003003o?00000[o?08000[o?08000_o?08000Ko?08000Ko
?003003o??ll00?o?003003o??ll00?o?003003o??ll05So?003003o??ll007o?0006oll0P00Eoll
00<00?lloc`02?ll00<00?ll00002_ll0P002Oll00@00?lloc`000[o?08000Ko?08000Ko?003003o
??ll00?o?003003o??ll00?o?003003o??ll05Oo?08000?o?0006oll00<00?lloc`0EOll0P002_ll
00<00?ll00002Oll00<00?ll00002Oll00@00?lloc`000[o?08000Ko?08000Ko?003003o??ll00?o
?003003o??ll00?o?003003o??ll00;o?003003o??ll05?o?003003o??ll007o?0002?ll0P001?ll
00<00?lloc`00oll0P001Oll00<00?lloc`0EOll0P002_ll00<00?ll00002Oll00<00?ll00002Oll
00@00?lloc`000[o?003003o?00000Go?08000Ko?003003o??ll00?o?003003o??ll00?o?003003o
??ll00;o?003003o??ll05?o?003003o??ll007o?0001oll00@00?lloc`000So?004003o??ll0004
oc`00`00occo?01Eoc`2000:oc`00`00oc`00009oc`00`00oc`00009oc`01000occo?0002_ll00<0
0?ll00001Oll0P001Oll0P001Oll00<00?lloc`00oll00<00?lloc`00_ll00<00?lloc`0Doll00<0
0?lloc`00Oll0007oc`01000occo?0002oll00<00?lloc`00_ll0P00E_ll0P002_ll00<00?ll0000
2Oll00<00?ll00002Oll00@00?lloc`000[o?003003o?00000Go?08000Go?08000Go?003003o??ll
00;o?08000Co?003003o??ll00;o?003003o??ll04go?08000?o?00000?o?00000000P000_ll00@0
0?lloc`000Wo?08000Go?003003o??ll04Wo?003003o??ll00Wo?08000[o?003003o?00000Wo?003
003o?00000Wo?004003o??ll000:oc`00`00oc`00005oc`20005oc`20005oc`00`00occo?002oc`2
0004oc`00`00occo?002oc`00`00occo?01>oc`00`00occo?001oc`000Oo?004003o??ll000;oc`0
0`00occo?002oc`00`00occo?019oc`00`00occo?009oc`2000:oc`00`00oc`00009oc`00`00oc`0
0009oc`01000occo?0002_ll00<00?ll00001Oll0P001Oll0P001Oll00<00?lloc`00_ll0P001?ll
00<00?lloc`00_ll00<00?lloc`0C_ll00<00?lloc`00Oll0007oc`01000occo?0002?ll00@00?ll
oc`000Co?003003o??ll04Wo?08000[o?003003o?00000Wo?003003o?00000Wo?003003o?00000Wo
?004003o??ll000:oc`00`00oc`00005oc`20005oc`20005oc`00`00occo?002oc`20004oc`00`00
occo?002oc`00`00occo?01>oc`00`00occo?001oc`000So?08000[o?08000Go?08004[o?08000Wo
?004003o??ll0009oc`00`00oc`00009oc`00`00oc`00009oc`01000occo?0002_ll00<00?ll0000
1Oll0P001Oll0P001Oll00<00?lloc`00_ll0P001?ll00<00?lloc`00_ll00<00?lloc`00_ll00<0
0?lloc`0B?ll0P000oll000Koc`00`00occo?019oc`20009oc`01000occo?0002Oll00<00?ll0000
2Oll00<00?ll00002Oll00@00?lloc`000[o?003003o?00000Go?08000Go?08000Go?003003o??ll
00;o?08000Co?003003o??ll00;o?003003o??ll00;o?003003o??ll04Wo?003003o??ll007o?000
6oll00<00?lloc`0BOll0P002Oll00@00?lloc`000Wo?003003o?00000Wo?003003o?00000Wo?004
003o??ll0009oc`01000occo?0001Oll0P001Oll0P001Oll00<00?lloc`00_ll0P001?ll00<00?ll
oc`00_ll0P000oll00<00?lloc`00_ll00<00?lloc`0A?ll00<00?lloc`00Oll000Koc`00`00occo
?019oc`20009oc`01000occo?0002Oll00<00?ll00002Oll00<00?ll00002Oll00@00?lloc`000Wo
?004003o??ll0005oc`20005oc`20004oc`20004oc`20004oc`00`00occo?002oc`20003oc`00`00
occo?002oc`00`00occo?014oc`00`00occo?001oc`001_o?003003o??ll04Wo?08000Wo?004003o
??ll0009oc`00`00oc`00009oc`00`00oc`00009oc`01000occo?0002Oll00@00?lloc`000Go?080
00Go?08000Co?08000Co?08000Co?003003o??ll00;o?08000?o?08000?o?003003o??ll04Co?003
003o??ll007o?0006oll0P00B_ll00<00?ll00002?ll00@00?lloc`000Wo?003003o?00000Wo?003
003o?00000Wo?004003o??ll0009oc`01000occo?0001Oll0P001Oll0P001?ll0P001?ll0P001?ll
00<00?lloc`00_ll0P000oll0P000oll00<00?lloc`0@oll0P000oll000Koc`00`00occo?00moc`0
0`00occo?008oc`01000occo?0002?ll00@00?lloc`000Wo?003003o?00000Wo?003003o?00000Wo
?004003o??ll0009oc`01000occo?0001Oll0P001Oll0P001?ll0P001?ll0P001?ll0P000oll0P00
0oll0P000oll00<00?lloc`00_ll00<00?lloc`0?oll00<00?lloc`00Oll000Koc`00`00occo?00m
oc`00`00occo?008oc`01000occo?0002?ll00@00?lloc`000Wo?003003o?00000So?005003o??ll
oc`00008oc`01000occo?0002Oll00@00?lloc`000Go?08000Go?08000Co?08000Co?08000Co?080
00?o?08000?o?08000?o?003003o??ll00;o?003003o??ll03oo?003003o??ll007o?0006oll00<0
0?lloc`0??ll00<00?ll00002Oll00@00?lloc`000So?004003o??ll0009oc`00`00oc`00008oc`0
1@00occo??ll00002?ll00@00?lloc`000Wo?004003o??ll0005oc`20005oc`20004oc`00`00oc`0
0003oc`20004oc`20003oc`20003oc`20003oc`00`00occo?002oc`00`00occo?00ooc`00`00occo
?001oc`001_o?08003go?003003o?00000Wo?004003o??ll0008oc`01000occo?0002?ll00D00?ll
occo?00000Oo?005003o??lloc`00008oc`01000occo?0002Oll00@00?lloc`000Go?08000Go?080
00Co?003003o?00000?o?08000Co?08000?o?08000?o?08000?o?08000?o?005003o??lloc`0000l
oc`20003oc`001_o?003003o??ll03co?003003o?00000Wo?004003o??ll0008oc`01000occo?000
2?ll00D00?llocco?00000Oo?005003o??lloc`00008oc`01000occo?0002Oll00@00?lloc`000Go
?08000Go?003003o?00000?o?003003o?00000?o?08000Co?08000?o?08000?o?08000?o?08000?o
?005003o??lloc`0000moc`00`00occo?001oc`001_o?003003o??ll03co?003003o?00000Wo?004
003o??ll0008oc`01000occo?0002?ll00D00?llocco?00000Oo?005003o??lloc`00008oc`01000
occo?0002Oll00@00?lloc`000Go?08000Go?003003o?00000?o?003003o?00000?o?08000Co?080
00?o?08000?o?08000?o?08000;o?08000?o?003003o??ll03_o?003003o??ll007o?0006oll00<0
0?lloc`0??ll00<00?ll00002Oll00@00?lloc`000So?004003o??ll0008oc`01@00occo??ll0000
1oll00D00?llocco?00000So?004003o??ll0009oc`01000occo?0001Oll0P001Oll00<00?ll0000
0oll00<00?ll00000oll0P001?ll0P000oll0P000oll0P000oll0P000_ll0P000oll00<00?lloc`0
>oll00<00?lloc`00Oll000Koc`2000moc`00`00oc`00009oc`01000occo?0002?ll00@00?lloc`0
00So?005003o??lloc`00007oc`01@00occo??ll00002?ll00@00?lloc`000Wo?004003o??ll0005
oc`00`00oc`00004oc`00`00oc`00003oc`00`00oc`00003oc`20004oc`20003oc`20003oc`20003
oc`20002oc`20003oc`00`00occo?00joc`20003oc`001_o?003003o??ll03co?003003o?00000Wo
?004003o??ll0008oc`01000occo?0002?ll00D00?llocco?00000Oo?005003o??lloc`00008oc`0
1000occo?0002Oll00@00?lloc`000Go?003003o?00000Co?003003o?00000?o?003003o?00000?o
?08000Co?08000?o?08000?o?08000?o?08000;o?08000?o?003003o??ll00;o?003003o??ll03Ko
?003003o??ll007o?0002?ll0P001?ll00<00?lloc`00_ll10001?ll00<00?lloc`0??ll00<00?ll
00002Oll00@00?lloc`000So?004003o??ll0008oc`01@00occo??ll00001oll00D00?llocco?000
00So?004003o??ll0009oc`01000occo?0001Oll00<00?ll00001?ll00<00?ll00000oll00<00?ll
00000oll0P001?ll0P000oll0P000oll0P000oll0P000_ll0P000oll00<00?lloc`00_ll00<00?ll
oc`0=_ll00<00?lloc`00Oll0007oc`01000occo?0002?ll00<00?lloc`01Oll00<00?lloc`0??ll
00<00?ll00002Oll00@00?lloc`000So?004003o??ll0008oc`01@00occo??ll00001oll00D00?ll
occo?00000So?004003o??ll0009oc`01000occo?0001Oll00<00?ll00001?ll00<00?ll00000oll
00<00?ll00000oll0P001?ll0P000oll0P000oll0P000oll0P000_ll0P000oll00<00?lloc`00_ll
00<00?lloc`0=_ll00<00?lloc`00Oll0007oc`01000occo?0002Oll00<00?lloc`01?ll0P00?Oll
00<00?ll00002Oll00@00?lloc`000So?004003o??ll0008oc`01@00occo??ll00001oll00D00?ll
occo?00000So?004003o??ll0009oc`01000occo?0001Oll00<00?ll00001?ll00<00?ll00000oll
00<00?ll00000oll0P001?ll0P000oll0P000oll0P000oll0P000_ll0P000oll0P000oll00<00?ll
oc`0=Oll0P000oll00000oll000000020002oc`01000occo?0002_ll00<00?lloc`00oll00<00?ll
oc`0<Oll00<00?lloc`02?ll00<00?ll00002Oll00@00?lloc`000So?004003o??ll0008oc`01@00
occo??ll00001oll00D00?llocco?00000So?004003o??ll0009oc`01000occo?0001Oll00<00?ll
00001?ll00<00?ll00000oll00<00?ll00000oll0P001?ll0P000oll0P000oll0P000oll0P000_ll
0P000oll0P000oll00D00?llocco?00003Co?003003o??ll007o?0001oll00@00?lloc`000_o?003
003o??ll00;o?003003o??ll037o?003003o??ll00So?003003o?00000Wo?004003o??ll0008oc`0
1000occo?0002?ll00D00?llocco?00000Oo?005003o??lloc`00008oc`01000occo?0002Oll00@0
0?lloc`000Go?003003o?00000Co?003003o?00000?o?003003o?00000?o?08000Co?08000?o?080
00?o?08000?o?08000;o?08000?o?08000?o?005003o??lloc`0000doc`00`00occo?001oc`000Oo
?004003o??ll0008oc`01000occo?0001?ll00<00?lloc`0<?ll0P002_ll00<00?ll00002Oll00@0
0?lloc`000So?004003o??ll0008oc`01@00occo??ll00001oll00D00?llocco?00000So?004003o
??ll0009oc`01000occo?0001Oll00<00?ll00000oll00@00?lloc`000?o?003003o?00000?o?080
00Co?08000?o?08000?o?08000?o?08000;o?003003o?00000;o?08000?o?005003o??lloc`0000d
oc`00`00occo?001oc`000So?08000[o?08000Go?080037o?08000[o?003003o?00000Wo?004003o
??ll0008oc`01000occo?0002?ll00D00?llocco?00000Oo?005003o??lloc`00008oc`01000occo
?0002Oll00@00?lloc`000Go?003003o?00000?o?004003o??ll0003oc`00`00oc`00003oc`20003
oc`00`00oc`00003oc`20003oc`20003oc`20002oc`00`00oc`00002oc`20003oc`01@00occo??ll
0000<oll0P000oll000Koc`00`00occo?00`oc`2000:oc`01000occo?0002?ll00@00?lloc`000So
?004003o??ll0008oc`01@00occo??ll00001oll00D00?llocco?00000So?004003o??ll0009oc`0
1000occo?0001Oll00<00?ll00000oll00@00?lloc`000?o?003003o?00000?o?08000?o?003003o
?00000?o?08000?o?08000?o?08000;o?003003o?00000;o?08000?o?005003o??lloc`00003oc`0
0`00occo?00^oc`00`00occo?001oc`001_o?003003o??ll033o?003003o?00000Wo?004003o??ll
0008oc`01000occo?0002?ll00@00?lloc`000So?005003o??lloc`00007oc`01@00occo??ll0000
2?ll00@00?lloc`000Wo?004003o??ll0005oc`00`00oc`00003oc`01000occo?0000oll00<00?ll
00000oll0P000oll00<00?ll00000oll0P000oll0P000oll0P000_ll00<00?ll00000_ll0P000oll
00@00?llocco?08000;o?003003o??ll02ko?003003o??ll007o?0006oll00<00?lloc`0<?ll00<0
0?ll00002?ll00D00?llocco?00000So?004003o??ll0008oc`01000occo?0002?ll00D00?llocco
?00000Oo?005003o??lloc`00008oc`01000occo?0002?ll00D00?llocco?00000Go?003003o?000
00?o?004003o??ll0003oc`00`00oc`00003oc`20003oc`00`00oc`00003oc`20003oc`20003oc`2
0002oc`00`00oc`00002oc`20003oc`01000occo??ll0P000_ll00<00?lloc`0;_ll00<00?lloc`0
0Oll000Koc`2000aoc`00`00oc`00008oc`01@00occo??ll00002?ll00@00?lloc`000So?004003o
??ll0008oc`01@00occo??ll00001oll00<00?lloc`00_ll00<00?lloc`01?ll00<00?lloc`00_ll
00<00?lloc`01Oll00D00?llocco?00000Go?003003o?00000?o?004003o??ll0003oc`00`00oc`0
0003oc`20003oc`00`00oc`00003oc`20003oc`20003oc`20002oc`00`00oc`00002oc`20003oc`0
1000occo??ll0P000_ll00<00?lloc`0;Oll0P000oll000Koc`00`00occo?00`oc`00`00oc`00008
oc`01@00occo??ll00002?ll00@00?lloc`000So?004003o??ll0008oc`01@00occo??ll00001oll
00<00?lloc`00_ll00<00?lloc`01?ll00<00?lloc`00_ll00<00?lloc`01Oll00D00?llocco?000
00Go?003003o?00000?o?004003o??ll0003oc`00`00oc`00003oc`20003oc`00`00oc`00003oc`0
0`00oc`00002oc`20003oc`20002oc`00`00oc`00002oc`20002oc`20003oc`20002oc`00`00occo
?00^oc`00`00occo?001oc`001_o?003003o??ll033o?003003o?00000So?005003o??lloc`00008
oc`01000occo?0002?ll00@00?lloc`000Oo?003003o??ll00;o?003003o??ll00Go?003003o??ll
00;o?003003o??ll00Co?003003o??ll00;o?003003o??ll00Go?005003o??lloc`00005oc`00`00
oc`00003oc`01000occo?0000oll00<00?ll00000oll0P000oll00<00?ll00000oll00<00?ll0000
0_ll0P000oll0P000_ll00<00?ll00000_ll0P000_ll0P000oll0P000_ll00<00?lloc`0;_ll00<0
0?lloc`00Oll000Koc`00`00occo?00`oc`00`00oc`00008oc`01@00occo??ll00002?ll00@00?ll
oc`000So?005003o??lloc`00006oc`00`00occo?002oc`00`00occo?005oc`00`00occo?002oc`0
0`00occo?004oc`00`00occo?002oc`00`00occo?005oc`01@00occo??ll00001Oll00<00?ll0000
0oll00@00?lloc`000?o?003003o?00000?o?08000?o?003003o?00000?o?003003o?00000;o?080
00?o?08000;o?003003o?00000;o?08000;o?08000?o?08000;o?005003o??lloc`0000/oc`00`00
occo?001oc`001_o?080037o?003003o?00000So?005003o??lloc`00008oc`01000occo?0001oll
00<00?lloc`00_ll00<00?lloc`01?ll00<00?lloc`00_ll00<00?lloc`01Oll00<00?lloc`00_ll
00<00?lloc`01?ll00<00?lloc`00_ll00<00?lloc`01Oll00D00?llocco?00000Go?003003o?000
00?o?004003o??ll0003oc`00`00oc`00003oc`20003oc`00`00oc`00003oc`00`00oc`00002oc`2
0003oc`20002oc`00`00oc`00002oc`20002oc`20003oc`20002oc`01@00occo??ll0000:oll0P00
0oll000Koc`00`00occo?00`oc`01000occo?0001oll00D00?llocco?00000So?004003o??ll0007
oc`00`00occo?002oc`00`00occo?004oc`00`00occo?002oc`00`00occo?005oc`00`00occo?002
oc`00`00occo?004oc`00`00occo?002oc`00`00occo?005oc`01@00occo??ll00001Oll00<00?ll
00000oll00@00?lloc`000?o?003003o?00000?o?08000?o?003003o?00000?o?003003o?00000;o
?08000?o?08000;o?003003o?00000;o?08000;o?08000;o?003003o?00000;o?08000;o?003003o
??ll02[o?003003o??ll007o?0006oll00<00?lloc`0<?ll00@00?lloc`000Oo?005003o??lloc`0
0008oc`01@00occo??ll00001_ll00<00?lloc`00_ll00<00?lloc`01?ll00<00?lloc`00_ll00<0
0?lloc`01Oll00<00?lloc`00_ll00<00?lloc`01?ll00<00?lloc`00_ll00<00?lloc`01Oll00D0
0?llocco?00000Go?003003o?00000?o?004003o??ll0003oc`00`00oc`00003oc`20003oc`00`00
oc`00003oc`00`00oc`00002oc`20003oc`20002oc`00`00oc`00002oc`20002oc`20002oc`00`00
oc`00002oc`20002oc`00`00occo?00Zoc`00`00occo?001oc`001_o?003003o??ll02oo?005003o
??lloc`00007oc`01@00occo??ll00001oll00<00?lloc`00_ll00<00?lloc`01?ll00<00?lloc`0
0_ll00<00?lloc`01?ll00<00?lloc`00_ll00<00?lloc`01Oll00<00?lloc`00_ll00<00?lloc`0
1?ll00<00?lloc`00_ll00<00?lloc`01Oll00D00?llocco?00000Co?004003o??ll0003oc`01000
occo?0000oll00<00?ll00000oll00<00?ll00000_ll00<00?ll00000oll00<00?ll00000_ll0P00
0oll0P000_ll00<00?ll00000_ll0P000_ll0P000_ll00<00?ll00000_ll0P000_ll00<00?lloc`0
:_ll00<00?lloc`00Oll000Koc`00`00occo?00Uoc`00`00occo?007oc`01@00occo??ll00001oll
00D00?llocco?00000Oo?003003o??ll00;o?003003o??ll00Co?003003o??ll00;o?003003o??ll
00Co?003003o??ll00;o?003003o??ll00Go?003003o??ll00;o?003003o??ll00Co?003003o??ll
00;o?003003o??ll00Go?005003o??lloc`00004oc`01000occo?0000oll00@00?lloc`000?o?003
003o?00000?o?003003o?00000;o?003003o?00000?o?003003o?00000;o?08000?o?08000;o?003
003o?00000;o?08000;o?08000;o?003003o?00000;o?08000;o?005003o??lloc`0000Xoc`00`00
occo?001oc`001_o?08002Ko?003003o??ll00Oo?005003o??lloc`00007oc`01@00occo??ll0000
1oll00<00?lloc`00_ll00<00?lloc`01?ll00<00?lloc`00_ll00<00?lloc`01?ll00<00?lloc`0
0_ll00<00?lloc`01Oll00<00?lloc`00_ll00<00?lloc`01?ll00<00?lloc`00_ll00<00?lloc`0
1Oll00D00?llocco?00000Co?004003o??ll0003oc`01000occo?0000oll00<00?ll00000oll00<0
0?ll00000_ll00<00?ll00000oll00<00?ll00000_ll0P000oll0P000_ll00<00?ll00000_ll0P00
0_ll0P000_ll00<00?ll00000_ll0P000_ll00D00?llocco?00002Oo?08000?o?0006oll00<00?ll
oc`09?ll0P002Oll00D00?llocco?00000Oo?003003o??ll00;o?003003o??ll00Co?003003o??ll
00;o?003003o??ll00Co?003003o??ll00;o?003003o??ll00Co?003003o??ll00;o?003003o??ll
00Go?003003o??ll00;o?003003o??ll00Co?003003o??ll00;o?003003o??ll00Go?005003o??ll
oc`00004oc`01000occo?0000oll00@00?lloc`000?o?003003o?00000?o?003003o?00000;o?003
003o?00000?o?003003o?00000;o?08000?o?08000;o?003003o?00000;o?08000;o?08000;o?003
003o?00000;o?08000;o?005003o??lloc`0000Xoc`00`00occo?001oc`000So?08000Co?003003o
??ll00;o?0@000Co?003003o??ll02Co?003003o?00000So?005003o??lloc`00007oc`00`00occo
?002oc`00`00occo?004oc`00`00occo?002oc`00`00occo?004oc`00`00occo?002oc`00`00occo
?004oc`00`00occo?002oc`00`00occo?005oc`00`00occo?002oc`00`00occo?004oc`00`00occo
?002oc`00`00occo?005oc`01@00occo??ll00001?ll00@00?lloc`000?o?004003o??ll0003oc`0
0`00oc`00003oc`00`00oc`00002oc`00`00oc`00003oc`00`00oc`00002oc`20003oc`20002oc`0
0`00oc`00002oc`20002oc`20002oc`00`00oc`00002oc`20002oc`01000occo??ll0P009oll00<0
0?lloc`00Oll0007oc`01000occo?0002_ll00<00?lloc`00oll00<00?lloc`09?ll00<00?ll0000
2?ll00D00?llocco?00000Oo?003003o??ll00;o?003003o??ll00Co?003003o??ll00;o?003003o
??ll00Co?003003o??ll00;o?003003o??ll00Co?003003o??ll00;o?003003o??ll00Go?003003o
??ll00;o?003003o??ll00Co?003003o??ll00;o?003003o??ll00Go?005003o??lloc`00004oc`0
1000occo?0000oll00@00?lloc`000?o?003003o?00000?o?003003o?00000;o?003003o?00000?o
?003003o?00000;o?08000?o?08000;o?003003o?00000;o?08000;o?08000;o?003003o?00000;o
?08000;o?004003o??lloc`2000Woc`00`00occo?001oc`000Oo?004003o??ll000:oc`00`00occo
?003oc`2000Toc`01000occo?0002?ll00D00?llocco?00000Oo?003003o??ll00;o?003003o??ll
00Co?003003o??ll00;o?003003o??ll00Co?003003o??ll00;o?003003o??ll00Co?003003o??ll
00;o?003003o??ll00Go?003003o??ll00;o?003003o??ll00Co?003003o??ll00;o?003003o??ll
00Go?005003o??lloc`00004oc`01000occo?0000oll00@00?lloc`000?o?003003o?00000?o?003
003o?00000;o?003003o?00000?o?003003o?00000;o?08000?o?08000;o?003003o?00000;o?080
00;o?08000;o?003003o?00000;o?08000;o?08000;o?08000;o?003003o??ll027o?08000?o?000
00?o?00000000P000_ll00@00?lloc`000[o?003003o??ll00?o?003003o??ll02?o?004003o??ll
0008oc`01@00occo??ll00001oll00<00?lloc`00_ll00<00?lloc`01?ll00<00?lloc`00_ll00<0
0?lloc`01?ll00<00?lloc`00_ll00<00?lloc`01?ll00<00?lloc`00_ll00<00?lloc`01Oll00<0
0?lloc`00_ll00<00?lloc`01?ll00<00?lloc`00_ll00<00?lloc`01Oll00D00?llocco?00000Co
?004003o??ll0003oc`01000occo?0000oll00<00?ll00000oll00<00?ll00000_ll00<00?ll0000
0oll00<00?ll00000_ll0P000oll0P000_ll00<00?ll00000_ll0P000_ll0P000_ll00<00?ll0000
0_ll0P000_ll0P000_ll0P000_ll00<00?lloc`08_ll00<00?lloc`00Oll0007oc`01000occo?000
2_ll00<00?lloc`00oll00<00?lloc`08oll00@00?lloc`000So?005003o??lloc`00007oc`00`00
occo?002oc`00`00occo?004oc`00`00occo?002oc`00`00occo?004oc`00`00occo?002oc`00`00
occo?004oc`00`00occo?002oc`00`00occo?005oc`00`00occo?002oc`00`00occo?004oc`00`00
occo?002oc`00`00occo?005oc`01@00occo??ll00001?ll00@00?lloc`000?o?004003o??ll0003
oc`00`00oc`00003oc`00`00oc`00002oc`01000occo?0000_ll00<00?ll00000_ll0P000oll0P00
0_ll00<00?ll00000_ll0P000_ll0P000_ll00<00?ll00000_ll0P000_ll0P000_ll0P000_ll00<0
0?lloc`08_ll00<00?lloc`00Oll0007oc`01000occo?0002?ll0`001Oll00<00?lloc`08oll00@0
0?lloc`000So?005003o??lloc`00007oc`00`00occo?002oc`00`00occo?004oc`00`00occo?002
oc`00`00occo?004oc`00`00occo?002oc`00`00occo?004oc`00`00occo?002oc`00`00occo?005
oc`00`00occo?002oc`00`00occo?004oc`00`00occo?002oc`00`00occo?005oc`01@00occo??ll
00001?ll00@00?lloc`000?o?004003o??ll0003oc`00`00oc`00003oc`00`00oc`00002oc`01000
occo?0000_ll00<00?ll00000_ll0P000oll0P000_ll00<00?ll00000_ll0P000_ll00L00?ll003o
?000oc`00002oc`20002oc`20002oc`20002oc`00`00occo?00Roc`00`00occo?001oc`000So?080
00_o?003003o??ll00?o?08002Co?004003o??ll0007oc`00`00occo?002oc`00`00occo?005oc`0
0`00occo?002oc`00`00occo?004oc`00`00occo?002oc`00`00occo?004oc`00`00occo?002oc`0
0`00occo?004oc`00`00occo?002oc`00`00occo?005oc`00`00occo?002oc`00`00occo?004oc`0
0`00occo?002oc`00`00occo?005oc`01@00occo??ll00001?ll00@00?lloc`000?o?004003o??ll
0003oc`00`00oc`00003oc`00`00oc`00002oc`01000occo?0000_ll00<00?ll00000_ll0P000oll
0P000_ll00<00?ll00000_ll0P000_ll00L00?ll003o?000oc`00002oc`20002oc`20002oc`20002
oc`01@00occo??ll00007oll0P000oll000Koc`00`00occo?00Soc`01000occo?0001oll00<00?ll
oc`00_ll00<00?lloc`01Oll00<00?lloc`00_ll00<00?lloc`01?ll00<00?lloc`00_ll00<00?ll
oc`01?ll00<00?lloc`00_ll00<00?lloc`01?ll00<00?lloc`00_ll00<00?lloc`01Oll00<00?ll
oc`00_ll00<00?lloc`01?ll00<00?lloc`00_ll00<00?lloc`01Oll00<00?lloc`00_ll00D00?ll
occo?00000;o?005003o??lloc`00002oc`01`00occo??ll003o?00000?o?003003o?00000;o?004
003o??ll0002oc`00`00oc`00002oc`20003oc`20002oc`00`00oc`00002oc`20002oc`01`00oc`0
0?ll003o?00000;o?08000;o?08000;o?08000;o?005003o??lloc`0000Poc`00`00occo?001oc`0
01_o?003003o??ll02?o?004003o??ll0007oc`00`00occo?002oc`00`00occo?005oc`00`00occo
?002oc`00`00occo?004oc`00`00occo?002oc`00`00occo?004oc`00`00occo?002oc`00`00occo
?004oc`00`00occo?002oc`00`00occo?005oc`00`00occo?002oc`00`00occo?004oc`00`00occo
?002oc`00`00occo?005oc`00`00occo?002oc`01@00occo??ll00000_ll00D00?llocco?00000;o
?007003o??lloc`00?ll00000oll00<00?ll00000_ll00H00?lloc`00?ll0002oc`00`00occo?002
0003oc`20002oc`00`00oc`00002oc`02`00oc`00?ll003o?000oc`00?ll00000_ll0P000_ll0P00
0_ll0P000_ll00D00?llocco?000023o?003003o??ll007o?0006oll00<00?lloc`08oll00@00?ll
oc`000Oo?003003o??ll00;o?003003o??ll00Go?003003o??ll00;o?003003o??ll00Co?003003o
??ll00;o?003003o??ll00Co?003003o??ll00;o?003003o??ll00Co?003003o??ll00;o?003003o
??ll00Go?003003o??ll00;o?003003o??ll00Co?003003o??ll00;o?003003o??ll00Go?003003o
??ll00;o?005003o??lloc`00002oc`01@00occo??ll00000_ll00D00?llocco?00000;o?006003o
??ll003o?0000_ll00H00?lloc`00?ll0002oc`00`00occo?0020003oc`20002oc`00`00oc`00002
oc`02`00oc`00?ll003o?000oc`00?ll00000_ll0P000_ll0P000_ll0P000_ll00D00?llocco?000
023o?003003o??ll007o?0006oll0P009?ll00@00?lloc`000Oo?003003o??ll00;o?003003o??ll
00Go?003003o??ll00;o?003003o??ll00Co?003003o??ll00;o?003003o??ll00Co?003003o??ll
00;o?003003o??ll00Co?003003o??ll00;o?003003o??ll00Go?003003o??ll00;o?003003o??ll
00Co?003003o??ll00;o?003003o??ll00Go?003003o??ll00;o?005003o??lloc`00002oc`01@00
occo??ll00000_ll00D00?llocco?00000;o?006003o??ll003o?0000_ll00H00?lloc`00?ll0002
oc`00`00occo?0020003oc`20002oc`00`00oc`00002oc`02`00oc`00?ll003o?000oc`00?ll0000
0_ll0P000_ll0P000_ll0P000_ll0P000_ll0P007_ll0P000oll000Koc`00`00occo?00Soc`01@00
occo??ll00001_ll00<00?lloc`00_ll00<00?lloc`01Oll00<00?lloc`00_ll00<00?lloc`01?ll
00<00?lloc`00_ll00<00?lloc`01?ll00<00?lloc`00_ll00<00?lloc`01?ll00<00?lloc`00_ll
00<00?lloc`01?ll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`01Oll
00<00?lloc`00_ll00D00?llocco?00000?o?004003o??ll0002oc`01@00occo??ll00000_ll00H0
0?lloc`00?ll0002oc`01P00occo?000oc`000;o?003003o??ll008000?o?08000;o?003003o?000
00;o?00;003o?000oc`00?ll003o?000oc`00002oc`20002oc`20002oc`20002oc`20002oc`2000O
oc`00`00occo?001oc`001_o?003003o??ll02?o?005003o??lloc`00006oc`00`00occo?002oc`0
0`00occo?005oc`00`00occo?002oc`00`00occo?004oc`00`00occo?002oc`00`00occo?004oc`0
0`00occo?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo?003oc`0
0`00occo?003oc`00`00occo?003oc`00`00occo?005oc`00`00occo?002oc`01@00occo??ll0000
0oll00@00?lloc`000;o?005003o??lloc`00002oc`01P00occo?000oc`000;o?006003o??ll003o
?0000_ll00<00?lloc`00P000_ll00<00?ll00000_ll00<00?ll00000_ll00/00?ll003o?000oc`0
0?ll003o?00000;o?0800004oc`00?ll0002oc`20002oc`20002oc`20002oc`00`00occo?00Joc`0
0`00occo?001oc`001_o?003003o??ll01So?08000So?003003o??ll00;o?003003o??ll00Co?003
003o??ll00;o?003003o??ll00Go?003003o??ll00;o?003003o??ll00Co?003003o??ll00;o?003
003o??ll00Co?003003o??ll00?o?003003o??ll00?o?003003o??ll00?o?003003o??ll00?o?003
003o??ll00?o?003003o??ll00?o?003003o??ll00?o?003003o??ll00Go?003003o??ll00;o?005
003o??lloc`00003oc`01000occo?0000_ll00D00?llocco?00000;o?006003o??ll003o?0000_ll
00H00?lloc`00?ll0002oc`00`00occo?0020002oc`00`00oc`00002oc`00`00oc`00002oc`02`00
oc`00?ll003o?000oc`00?ll00000_ll0P0000Co?000oc`000;o?08000;o?08000;o?08000;o?003
003o??ll01[o?003003o??ll007o?0006oll0P006Oll00<00?ll00001oll00<00?lloc`00_ll00<0
0?lloc`01?ll00<00?lloc`00_ll00<00?lloc`01Oll00<00?lloc`00_ll00<00?lloc`00oll00<0
0?lloc`00oll00<00?lloc`01?ll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`00oll00<0
0?lloc`00oll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`01Oll00<0
0?lloc`00_ll00D00?llocco?00000?o?004003o??ll0002oc`01@00occo??ll00000_ll00H00?ll
oc`00?ll0002oc`01P00occo?000oc`000;o?003003o??ll008000;o?003003o?00000;o?005003o
?000oc`00002oc`02@00oc`00?ll003o?000oc`00002oc`200001?ll003o?0000_ll0P000_ll0P00
0_ll0P000_ll00<00?lloc`06Oll0P000oll000Koc`00`00occo?00Hoc`00`00oc`00007oc`00`00
occo?002oc`00`00occo?004oc`00`00occo?002oc`00`00occo?004oc`00`00occo?003oc`00`00
occo?003oc`00`00occo?003oc`00`00occo?004oc`00`00occo?003oc`00`00occo?003oc`00`00
occo?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo?003oc`00`00
occo?005oc`00`00occo?002oc`01@00occo??ll00000oll00@00?lloc`000;o?005003o??lloc`0
0002oc`01P00occo?000oc`000;o?006003o??ll003o?0000_ll00<00?lloc`00P000_ll00<00?ll
00000_ll00D00?ll003o?00000;o?009003o?000oc`00?ll003o?00000;o?0800004oc`00?ll0002
oc`20002oc`20002oc`20002oc`00`00occo?00Joc`00`00occo?001oc`001_o?003003o??ll01Oo
?004003o??ll0007oc`00`00occo?002oc`00`00occo?004oc`00`00occo?003oc`00`00occo?003
oc`00`00occo?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo?004oc`00`00occo?003
oc`00`00occo?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo?003
oc`00`00occo?003oc`00`00occo?005oc`00`00occo?002oc`01@00occo??ll00000oll00@00?ll
oc`000;o?005003o??lloc`00002oc`01P00occo?000oc`000;o?006003o??ll003o?0000_ll00<0
0?lloc`00P000_ll00<00?ll00000_ll00D00?ll003o?00000;o?009003o?000oc`00?ll003o?000
00;o?0800004oc`00?ll0002oc`200001?ll003o?0000_ll0P0000?o?00000000_ll00<00?lloc`0
5oll00<00?lloc`00Oll000Koc`00`00occo?00Goc`01000occo?0001oll00<00?lloc`00_ll00<0
0?lloc`01?ll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`00oll00<0
0?lloc`00oll00<00?lloc`01?ll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`00oll00<0
0?lloc`00oll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`01Oll00<0
0?lloc`00_ll00D00?llocco?00000?o?004003o??ll0002oc`01@00occo??ll00000_ll00H00?ll
oc`00?ll0002oc`01P00occo?000oc`000;o?005003o?000oc`00002oc`00`00oc`00002oc`01@00
oc`00?ll00000_ll00T00?ll003o?000oc`00?ll00000_ll0P0000Co?000oc`000;o?0800004oc`0
0?ll0002oc`200000oll00000002oc`2000Hoc`00`00occo?001oc`001_o?08001Oo?003003o??ll
00;o?003003o??ll00Co?003003o??ll00;o?003003o??ll00Co?003003o??ll00?o?003003o??ll
00?o?003003o??ll00?o?003003o??ll00?o?003003o??ll00?o?003003o??ll00Co?003003o??ll
00?o?003003o??ll00?o?003003o??ll00?o?003003o??ll00?o?003003o??ll00?o?003003o??ll
00?o?003003o??ll00?o?003003o??ll00Go?003003o??ll00;o?005003o??lloc`00003oc`01000
occo?0000_ll00D00?llocco?00000;o?006003o??ll003o?0000_ll00H00?lloc`00?ll0002oc`0
1@00oc`00?ll00000_ll00<00?ll00000_ll00D00?ll003o?00000;o?009003o?000oc`00?ll003o
?00000;o?0800004oc`00?ll0002oc`200001?ll003o?0000_ll0P0000?o?00000000_ll0P005oll
0P000oll000Koc`00`00occo?00Foc`00`00occo?002oc`00`00occo?004oc`00`00occo?003oc`0
0`00occo?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo?003oc`0
0`00occo?003oc`00`00occo?004oc`00`00occo?003oc`00`00occo?003oc`00`00occo?003oc`0
0`00occo?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo?005oc`0
0`00occo?002oc`01@00occo??ll00000oll00@00?lloc`000;o?005003o??lloc`00002oc`01P00
occo?000oc`000;o?006003o??ll003o?0000_ll00D00?ll003o?00000;o?003003o?00000;o?005
003o?000oc`00002oc`04@00oc`00?ll003o?000oc`00?ll003o?000oc`00?ll00000_ll0P0000Co
?000oc`000;o?0800003oc`0000000;o?08000;o?003003o??ll01?o?003003o??ll007o?0005?ll
0P001Oll00<00?lloc`05_ll00<00?lloc`00_ll00<00?lloc`01?ll00<00?lloc`00oll00<00?ll
oc`00oll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`00oll00<00?ll
oc`00oll00<00?lloc`01?ll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`00oll00<00?ll
oc`00oll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`01Oll00<00?ll
oc`00_ll00D00?llocco?00000?o?004003o??ll0002oc`01@00occo??ll00000_ll00H00?lloc`0
0?ll0002oc`01P00occo?000oc`000;o?005003o?000oc`00002oc`00`00oc`00002oc`01@00oc`0
0?ll00000_ll01400?ll003o?000oc`00?ll003o?000oc`00?ll003o?00000;o?0800004oc`00?ll
0002oc`200001Oll003o?000oc`00P000_ll0P005?ll00<00?lloc`00Oll000Coc`01000occo?000
1?ll00<00?lloc`05_ll00<00?lloc`00_ll00<00?lloc`01?ll00<00?lloc`00oll00<00?lloc`0
0oll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`0
0oll00<00?lloc`01?ll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`0
0oll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`01Oll00<00?lloc`0
0_ll00D00?llocco?00000?o?004003o??ll0002oc`01@00occo??ll00000_ll00H00?lloc`00?ll
0002oc`01P00occo?000oc`000;o?005003o?000oc`00002oc`00`00oc`00002oc`01@00oc`00?ll
00000_ll01400?ll003o?000oc`00?ll003o?000oc`00?ll003o?00000;o?0800004oc`00?ll0002
oc`200002Oll003o?000oc`00?ll003o?0020002oc`00`00occo?00?oc`00`00occo?001oc`001?o
?004003o??ll0004occo00030003oc`001?o?004003o??ll0004oc`00`00occo?00@oc`00`00occo
?002oc`00`00occo?003oc`00`00occo?004oc`00`00occo?003oc`00`00occo?003oc`00`00occo
?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo
?004oc`00`00occo?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo
?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo?005oc`00`00occo?002oc`01@00occo
??ll00000oll00@00?lloc`000;o?005003o??lloc`00002oc`01P00occo?000oc`000;o?006003o
??ll003o?0000_ll00D00?ll003o?00000;o?003003o?00000;o?005003o?000oc`00002oc`20002
oc`03@00oc`00?ll003o?000oc`00?ll003o?00000;o?080000Aoc`00?ll003o?000oc`00?ll003o
?000oc`00?ll003o?00200001Oll003o??ll00003oll00<00?lloc`00Oll000Coc`01000occo?000
1?ll00<00?lloc`04Oll00D00?llocco?00000Go?003003o??ll00Co?003003o??ll00?o?003003o
??ll00?o?003003o??ll00?o?003003o??ll00?o?003003o??ll00?o?003003o??ll00?o?003003o
??ll00?o?003003o??ll00Co?003003o??ll00?o?003003o??ll00?o?003003o??ll00?o?003003o
??ll00?o?003003o??ll00?o?003003o??ll00?o?003003o??ll00?o?003003o??ll00Go?003003o
??ll00;o?005003o??lloc`00003oc`01000occo?0000_ll00D00?llocco?00000;o?006003o??ll
003o?0000_ll00H00?lloc`00?ll0002oc`01@00oc`00?ll00000_ll00<00?ll00000_ll00D00?ll
003o?00000;o?08000;o?00=003o?000oc`00?ll003o?000oc`00?ll00000_ll0P0001?o?000oc`0
0?ll003o?000oc`00?ll003o?000oc`00?ll003o?002000Boc`00`00occo?001oc`001?o?004003o
??ll0004oc`00`00occo?00Boc`30007oc`00`00occo?003oc`00`00occo?003oc`00`00occo?003
oc`00`00occo?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo?003
oc`00`00occo?004oc`00`00occo?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo?003
oc`00`00occo?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo?005oc`00`00occo?002
oc`01@00occo??ll00000oll00@00?lloc`000;o?005003o??lloc`00002oc`01P00occo?000oc`0
00;o?006003o??ll003o?0000_ll00D00?ll003o?00000;o?003003o?00000;o?005003o?000oc`0
0002oc`20002oc`03@00oc`00?ll003o?000oc`00?ll003o?00000;o?080000?oc`00?ll003o?000
oc`00?ll003o?000oc`00?ll008001Ko?003003o??ll007o?0005?ll0P001Oll0P005?ll00<00?ll
oc`01_ll00<00?lloc`00_ll00<00?lloc`01?ll00<00?lloc`00oll00<00?lloc`00oll00<00?ll
oc`00oll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`01?ll00<00?ll
oc`00oll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`00oll00<00?ll
oc`00oll00<00?lloc`00oll00<00?lloc`01Oll00<00?lloc`00_ll00D00?llocco?00000?o?004
003o??ll0002oc`01@00occo??ll00000_ll00<00?ll00000_ll00@00?lloc`000;o?003003o?000
00;o?005003o?000oc`00002oc`00`00oc`00002oc`01@00oc`00?ll00000_ll0P000_ll00/00?ll
003o?000oc`00?ll003o?00000;o?006003o?000003o?0000_ll0P0000Go?000oc`00?ll008000;o
?08001Go?08000?o?0006oll00<00?lloc`07?ll00<00?lloc`00_ll00<00?lloc`01?ll00<00?ll
oc`00oll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`00oll00<00?ll
oc`00oll00<00?lloc`01?ll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`00oll00<00?ll
oc`00oll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`01?ll00<00?lloc`01?ll00<00?ll
oc`00_ll00D00?llocco?00000?o?004003o??ll0002oc`01@00occo??ll00000_ll00<00?ll0000
0_ll00@00?lloc`000;o?003003o?00000;o?005003o?000oc`00002oc`00`00oc`00002oc`01@00
oc`00?ll00000_ll0P000_ll00/00?ll003o?000oc`00?ll003o?00000;o?0800004oc`00?ll0002
oc`200001Oll003o?000oc`00P000_ll00<00?lloc`05Oll00<00?lloc`00Oll000Koc`00`00occo
?00Loc`00`00occo?002oc`00`00occo?004oc`00`00occo?002oc`00`00occo?004oc`00`00occo
?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo?004oc`00`00occo
?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo
?003oc`00`00occo?004oc`00`00occo?004oc`00`00occo?002oc`01@00occo??ll00000oll00@0
0?lloc`000;o?005003o??lloc`00002oc`00`00oc`00002oc`01000occo?0000_ll00<00?ll0000
0_ll00D00?ll003o?00000;o?003003o?00000;o?005003o?000oc`00002oc`20002oc`02`00oc`0
0?ll003o?000oc`00?ll00000_ll0P0000Co?000oc`000;o?0800004oc`00?ll0002oc`00`00occo
?00Hoc`00`00occo?001oc`001_o?003003o??ll01co?003003o??ll00;o?003003o??ll00Co?003
003o??ll00;o?003003o??ll00Co?003003o??ll00?o?003003o??ll00?o?003003o??ll00?o?003
003o??ll00?o?003003o??ll00Co?003003o??ll00?o?003003o??ll00?o?003003o??ll00?o?003
003o??ll00?o?003003o??ll00?o?003003o??ll00?o?003003o??ll00Co?003003o??ll00Co?003
003o??ll00;o?005003o??lloc`00003oc`01000occo?0000_ll00D00?llocco?00000;o?003003o
?00000;o?004003o??ll0002oc`00`00oc`00002oc`01@00oc`00?ll00000_ll00<00?ll00000_ll
00D00?ll003o?00000;o?08000;o?00;003o?000oc`00?ll003o?000oc`00002oc`200001?ll003o
?0000_ll0P0000Co?000oc`000;o?003003o??ll01So?003003o??ll007o?0006oll00<00?lloc`0
7Oll00D00?llocco?00000Ko?003003o??ll00;o?003003o??ll00Go?005003o??lloc`00006oc`0
0`00occo?003oc`00`00occo?003oc`00`00occo?004oc`00`00occo?003oc`00`00occo?003oc`0
0`00occo?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo?004oc`0
0`00occo?004oc`00`00occo?002oc`01@00occo??ll00000oll00@00?lloc`000;o?005003o??ll
oc`00002oc`00`00oc`00002oc`01000occo?0000_ll00<00?ll00000_ll00D00?ll003o?00000;o
?003003o?00000;o?005003o?000oc`00002oc`20002oc`02`00oc`00?ll003o?000oc`00?ll0000
0_ll0P0000Co?000oc`000;o?0800004oc`00?ll0002oc`00`00occo?00Hoc`00`00occo?001oc`0
01_o?08001ko?005003o??lloc`00006oc`00`00occo?002oc`00`00occo?005oc`01@00occo??ll
00001oll00<00?lloc`00_ll00<00?lloc`00oll00<00?lloc`01?ll00<00?lloc`00oll00<00?ll
oc`00oll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`00oll00<00?ll
oc`01?ll00<00?lloc`01?ll00<00?lloc`00_ll00@00?lloc`000Co?004003o??ll0002oc`01@00
occo??ll00000_ll00<00?ll00000_ll00@00?lloc`000;o?003003o?00000;o?003003o?00000;o
?005003o?000oc`00002oc`01@00oc`00?ll00000_ll0P000_ll00/00?ll003o?000oc`00?ll003o
?00000;o?0800004oc`00?ll0002oc`200001?ll003o?0000_ll00<00?lloc`05oll0P000oll000K
oc`00`00occo?00Moc`01000occo?0001oll00<00?lloc`00_ll00<00?lloc`01Oll00D00?llocco
?00000Oo?003003o??ll00;o?003003o??ll00?o?003003o??ll00Co?003003o??ll00?o?003003o
??ll00?o?003003o??ll00?o?003003o??ll00?o?003003o??ll00?o?003003o??ll00?o?003003o
??ll00Co?003003o??ll00Co?003003o??ll00;o?004003o??ll0004oc`01000occo?0000_ll00D0
0?llocco?00000;o?003003o?00000;o?004003o??ll0002oc`00`00oc`00002oc`00`00oc`00002
oc`01@00oc`00?ll00000_ll00D00?ll003o?00000;o?08000;o?00;003o?000oc`00?ll003o?000
oc`00002oc`200001?ll003o?0000_ll0P0000Co?000oc`001go?003003o??ll007o?0006oll00<0
0?lloc`07Oll00@00?lloc`000Oo?003003o??ll00;o?003003o??ll00Go?005003o??lloc`00007
oc`00`00occo?002oc`00`00occo?004oc`00`00occo?002oc`00`00occo?004oc`00`00occo?003
oc`00`00occo?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo?003oc`00`00occo?004
oc`00`00occo?004oc`00`00occo?002oc`01000occo?0001?ll00@00?lloc`000;o?005003o??ll
oc`00002oc`00`00oc`00002oc`01000occo?0000_ll00<00?ll00000_ll00<00?ll00000_ll00D0
0?ll003o?00000;o?005003o?000oc`00002oc`20002oc`02`00oc`00?ll003o?000oc`00?ll0000
0_ll0P0000Co?000oc`000;o?08000;o?08001go?003003o??ll007o?0006oll00<00?lloc`07Oll
00@00?lloc`000Oo?003003o??ll00;o?003003o??ll00Go?005003o??lloc`00007oc`00`00occo
?002oc`00`00occo?004oc`00`00occo?002oc`00`00occo?004oc`00`00occo?002oc`00`00occo
?005oc`01@00occo??ll00001_ll00<00?lloc`00oll00<00?lloc`01?ll00<00?lloc`01?ll00<0
0?lloc`00_ll00@00?lloc`000Co?004003o??ll0002oc`01@00occo??ll00000_ll00<00?ll0000
0_ll00@00?lloc`000;o?003003o?00000;o?003003o?00000;o?005003o?000oc`00002oc`01@00
oc`00?ll00000_ll0P000_ll00/00?ll003o?000oc`00?ll003o?00000;o?08000;o?08000;o?080
00;o?003003o??ll01co?003003o??ll007o?0006oll0P007_ll00@00?lloc`000Oo?003003o??ll
00;o?003003o??ll00Go?005003o??lloc`00007oc`00`00occo?002oc`00`00occo?004oc`00`00
occo?002oc`00`00occo?004oc`00`00occo?002oc`00`00occo?005oc`01@00occo??ll00001oll
00<00?lloc`00_ll00<00?lloc`01?ll00<00?lloc`01?ll00<00?lloc`00_ll00@00?lloc`000Co
?004003o??ll0002oc`01@00occo??ll00000_ll00<00?ll00000_ll00@00?lloc`000;o?003003o
?00000;o?003003o?00000;o?005003o?000oc`00002oc`01@00oc`00?ll00000_ll0P000_ll00/0
0?ll003o?000oc`00?ll003o?00000;o?08000;o?08000;o?08000;o?003003o??ll01_o?08000?o
?0006oll00<00?lloc`07Oll00@00?lloc`000Oo?003003o??ll00;o?003003o??ll00Go?005003o
??lloc`00007oc`00`00occo?002oc`00`00occo?004oc`00`00occo?002oc`00`00occo?004oc`0
0`00occo?002oc`00`00occo?005oc`01@00occo??ll00001oll00<00?lloc`00_ll00<00?lloc`0
1Oll00<00?lloc`00oll00<00?lloc`00_ll00@00?lloc`000Co?004003o??ll0002oc`01@00occo
??ll00000_ll00<00?ll00000_ll00@00?lloc`000;o?003003o?00000;o?003003o?00000;o?005
003o?000oc`00002oc`01@00oc`00?ll00000_ll0P000_ll00/00?ll003o?000oc`00?ll003o?000
00;o?08000;o?08000;o?08000;o?003003o??ll01co?003003o??ll007o?0006oll00<00?lloc`0
7_ll00<00?ll00002?ll00D00?llocco?00000Oo?005003o??lloc`00007oc`00`00occo?002oc`0
0`00occo?004oc`00`00occo?002oc`00`00occo?004oc`00`00occo?002oc`00`00occo?005oc`0
1@00occo??ll00001oll00<00?lloc`00_ll00<00?lloc`01Oll00<00?lloc`00oll00<00?lloc`0
0_ll00@00?lloc`000Co?004003o??ll0002oc`01@00occo??ll00000_ll00<00?ll00000_ll00@0
0?lloc`000;o?003003o?00000;o?003003o?00000;o?005003o?000oc`00002oc`01@00oc`00?ll
00000_ll0P000_ll00/00?ll003o?000oc`00?ll003o?00000;o?08000;o?08000;o?003003o??ll
023o?003003o??ll007o?0006oll00<00?lloc`07_ll00<00?ll00002?ll00D00?llocco?00000Oo
?005003o??lloc`00007oc`00`00occo?002oc`00`00occo?004oc`00`00occo?002oc`00`00occo
?004oc`00`00occo?002oc`00`00occo?005oc`01@00occo??ll00001oll00<00?lloc`00_ll00<0
0?lloc`01Oll00<00?lloc`00oll00<00?lloc`00_ll00@00?lloc`000Co?004003o??ll0002oc`0
1@00occo??ll00000_ll00<00?ll00000_ll00@00?lloc`000;o?003003o?00000;o?003003o?000
00;o?007003o?000oc`00?ll00000_ll00<00?ll00000_ll0P000_ll00/00?ll003o?000oc`00?ll
003o?00000;o?08000;o?08000;o?003003o??ll023o?003003o??ll007o?0006oll0P007oll0P00
2Oll00D00?llocco?00000Oo?005003o??lloc`00007oc`00`00occo?002oc`00`00occo?004oc`0
0`00occo?002oc`00`00occo?004oc`00`00occo?002oc`00`00occo?005oc`01@00occo??ll0000
1oll00<00?lloc`00_ll00<00?lloc`01Oll00<00?lloc`00oll00<00?lloc`00_ll00@00?lloc`0
00Co?004003o??ll0002oc`01@00occo??ll00000_ll00<00?ll00000oll00<00?ll00000_ll00<0
0?ll00000_ll00<00?ll00000_ll00L00?ll003o?000oc`00002oc`00`00oc`00002oc`20002oc`0
2`00oc`00?ll003o?000oc`00?ll00000_ll0P000_ll0P000_ll00<00?lloc`07oll0P000oll000K
oc`00`00occo?00Yoc`01@00occo??ll00001oll00D00?llocco?00000Oo?003003o??ll00;o?003
003o??ll00Co?003003o??ll00;o?003003o??ll00Co?003003o??ll00;o?003003o??ll00Go?005
003o??lloc`00007oc`00`00occo?002oc`00`00occo?005oc`00`00occo?003oc`00`00occo?002
oc`01000occo?0001?ll00@00?lloc`000;o?005003o??lloc`00002oc`00`00oc`00003oc`00`00
oc`00002oc`00`00oc`00002oc`00`00oc`00002oc`01`00oc`00?ll003o?00000;o?003003o?000
00;o?08000;o?00;003o?000oc`00?ll003o?000oc`00002oc`20002oc`20002oc`00`00occo?00P
oc`00`00occo?001oc`000So?08000Co?003003o??ll00;o?0@000Co?003003o??ll02Wo?005003o
??lloc`00007oc`01@00occo??ll00001oll00<00?lloc`00_ll00<00?lloc`01?ll00<00?lloc`0
0_ll00<00?lloc`01?ll00<00?lloc`00_ll00<00?lloc`01Oll00D00?llocco?00000Oo?003003o
??ll00;o?003003o??ll00Go?003003o??ll00;o?003003o??ll00?o?004003o??ll0004oc`01000
occo?0000_ll00D00?llocco?00000;o?003003o?00000?o?003003o?00000;o?003003o?00000;o
?003003o?00000;o?003003o?00000;o?08000;o?003003o?00000;o?08000;o?003003o?00000;o
?0800004oc`00?ll0002oc`20002oc`20002oc`00`00occo?00Poc`00`00occo?001oc`000Oo?004
003o??ll000:oc`00`00occo?003oc`00`00occo?00Yoc`01@00occo??ll00001oll00D00?llocco
?00000Oo?003003o??ll00;o?003003o??ll00Co?003003o??ll00;o?003003o??ll00Co?003003o
??ll00;o?003003o??ll00Go?005003o??lloc`00007oc`00`00occo?002oc`00`00occo?005oc`0
0`00occo?002oc`00`00occo?003oc`01000occo?0001?ll00@00?lloc`000;o?004003o??ll0003
oc`00`00oc`00003oc`00`00oc`00002oc`00`00oc`00002oc`00`00oc`00002oc`00`00oc`00002
oc`20002oc`00`00oc`00002oc`20002oc`00`00oc`00002oc`200001?ll003o?0000_ll0P000_ll
0P009Oll00<00?lloc`00Oll0007oc`01000occo?0002_ll00<00?lloc`00oll0P00:_ll00D00?ll
occo?00000Oo?005003o??lloc`00007oc`00`00occo?002oc`00`00occo?004oc`00`00occo?002
oc`00`00occo?004oc`00`00occo?002oc`00`00occo?005oc`01@00occo??ll00001oll00<00?ll
oc`00_ll00<00?lloc`01Oll00<00?lloc`00_ll00<00?lloc`00oll00@00?lloc`000Co?004003o
??ll0002oc`01000occo?0000oll00<00?ll00000oll00<00?ll00000_ll00<00?ll00000_ll00<0
0?ll00000_ll00<00?ll00000_ll0P000_ll00<00?ll00000_ll0P000_ll00<00?ll00000_ll0P00
0_ll0P000_ll0P000_ll0P009?ll0P000oll0007oc`01000occo?0002_ll00<00?lloc`00oll00<0
0?lloc`0:Oll00D00?llocco?00000Oo?005003o??lloc`00007oc`00`00occo?002oc`00`00occo
?004oc`00`00occo?002oc`00`00occo?004oc`00`00occo?002oc`00`00occo?005oc`01@00occo
??ll00001oll00<00?lloc`00_ll00<00?lloc`01Oll00<00?lloc`00_ll00<00?lloc`00oll00@0
0?lloc`000Co?004003o??ll0002oc`01000occo?0000oll00<00?ll00000oll00<00?ll00000_ll
00<00?ll00000_ll00<00?ll00000_ll00<00?ll00000_ll0P000_ll00<00?ll00000_ll0P000_ll
00<00?ll00000_ll0P000_ll0P000_ll0P00:Oll00<00?lloc`00Oll0007oc`01000occo?0002_ll
00<00?lloc`00oll00<00?lloc`0:Oll00D00?llocco?00000Oo?005003o??lloc`00007oc`00`00
occo?002oc`00`00occo?004oc`00`00occo?002oc`00`00occo?004oc`00`00occo?002oc`00`00
occo?005oc`01@00occo??ll00001oll00<00?lloc`00_ll00<00?lloc`01Oll00<00?lloc`00_ll
00<00?lloc`00oll00@00?lloc`000Co?004003o??ll0002oc`01000occo?0000oll00<00?ll0000
0oll00<00?ll00000_ll00<00?ll00000_ll00<00?ll00000_ll00<00?ll00000_ll0P000_ll00<0
0?ll00000_ll0P000_ll00<00?ll00000_ll0P000_ll0P000_ll0P00:Oll00<00?lloc`00Oll0007
oc`01000occo?0002?ll0`001Oll00<00?lloc`0:Oll00D00?llocco?00000Oo?005003o??lloc`0
0007oc`00`00occo?002oc`00`00occo?004oc`00`00occo?002oc`00`00occo?004oc`00`00occo
?002oc`00`00occo?005oc`01@00occo??ll00001oll00<00?lloc`00_ll00<00?lloc`01Oll00<0
0?lloc`00_ll00<00?lloc`00oll00@00?lloc`000Co?004003o??ll0002oc`01000occo?0000oll
00<00?ll00000oll00<00?ll00000_ll00<00?ll00000_ll00<00?ll00000_ll00<00?ll00000_ll
0P000_ll00<00?ll00000_ll0P000_ll00<00?ll00000_ll0P000_ll0P000_ll00<00?lloc`0:?ll
00<00?lloc`00Oll0008oc`2000;oc`00`00occo?003oc`2000Zoc`01000occo?0002?ll00D00?ll
occo?00000Oo?003003o??ll00;o?003003o??ll00Co?003003o??ll00;o?003003o??ll00Co?003
003o??ll00;o?003003o??ll00Go?005003o??lloc`00007oc`00`00occo?002oc`00`00occo?005
oc`00`00occo?002oc`00`00occo?003oc`01000occo?0001?ll00@00?lloc`000;o?004003o??ll
0003oc`00`00oc`00003oc`00`00oc`00002oc`00`00oc`00002oc`00`00oc`00002oc`00`00oc`0
0002oc`20002oc`00`00oc`00002oc`20002oc`00`00oc`00002oc`20002oc`20002oc`00`00occo
?00Woc`20003oc`001_o?003003o??ll02Wo?004003o??ll0008oc`01@00occo??ll00001oll00<0
0?lloc`00_ll00<00?lloc`01?ll00<00?lloc`00_ll00<00?lloc`01?ll00<00?lloc`00_ll00<0
0?lloc`01Oll00D00?llocco?00000Oo?003003o??ll00;o?003003o??ll00Go?003003o??ll00;o
?003003o??ll00?o?004003o??ll0004oc`01000occo?0000_ll00@00?lloc`000?o?003003o?000
00?o?003003o?00000;o?003003o?00000;o?003003o?00000;o?003003o?00000;o?08000;o?003
003o?00000;o?08000;o?003003o?00000;o?004003o??lloc`20002oc`00`00occo?00Xoc`00`00
occo?001oc`001_o?003003o??ll02Wo?004003o??ll0008oc`01@00occo??ll00001oll00D00?ll
occo?00000Oo?003003o??ll00;o?003003o??ll00Co?003003o??ll00;o?003003o??ll00Go?005
003o??lloc`00007oc`00`00occo?002oc`00`00occo?005oc`00`00occo?002oc`00`00occo?003
oc`01000occo?0001?ll00@00?lloc`000;o?004003o??ll0003oc`00`00oc`00003oc`00`00oc`0
0002oc`00`00oc`00002oc`00`00oc`00002oc`00`00oc`00002oc`20002oc`00`00oc`00002oc`2
0002oc`00`00oc`00002oc`01000occo??ll0P000_ll00<00?lloc`0:?ll00<00?lloc`00Oll000K
oc`00`00occo?00Yoc`01000occo?0002?ll00D00?llocco?00000Oo?005003o??lloc`00007oc`0
0`00occo?002oc`00`00occo?004oc`00`00occo?002oc`00`00occo?005oc`01@00occo??ll0000
1oll00<00?lloc`00_ll00<00?lloc`01Oll00<00?lloc`00_ll00<00?lloc`00oll00@00?lloc`0
00Co?004003o??ll0003oc`00`00oc`00003oc`00`00oc`00003oc`00`00oc`00002oc`00`00oc`0
0002oc`00`00oc`00002oc`00`00oc`00002oc`20002oc`00`00oc`00002oc`20002oc`00`00oc`0
0002oc`01000occo??ll0P000_ll00<00?lloc`0:?ll00<00?lloc`00Oll000Koc`2000[oc`00`00
oc`00008oc`01@00occo??ll00001oll00D00?llocco?00000Oo?003003o??ll00;o?003003o??ll
00Co?003003o??ll00;o?003003o??ll00Go?005003o??lloc`00007oc`00`00occo?002oc`00`00
occo?005oc`00`00occo?002oc`00`00occo?003oc`01000occo?0001?ll00@00?lloc`000?o?003
003o?00000?o?003003o?00000?o?003003o?00000;o?08000?o?003003o?00000;o?003003o?000
00;o?08000;o?003003o?00000;o?08000;o?003003o?00000;o?004003o??lloc`20002oc`00`00
occo?00Woc`20003oc`001_o?003003o??ll02[o?003003o?00000So?005003o??lloc`00007oc`0
1@00occo??ll00002?ll00D00?llocco?00000Ko?003003o??ll00;o?003003o??ll00Go?005003o
??lloc`00007oc`00`00occo?002oc`00`00occo?005oc`00`00occo?002oc`00`00occo?003oc`0
1000occo?0001?ll00@00?lloc`000?o?003003o?00000?o?003003o?00000?o?003003o?00000;o
?08000?o?003003o?00000;o?003003o?00000;o?08000;o?08000?o?08000;o?003003o?00000;o
?004003o??lloc`2000]oc`00`00occo?001oc`001_o?003003o??ll02[o?08000Wo?005003o??ll
oc`00007oc`01@00occo??ll00002?ll00@00?lloc`000Oo?003003o??ll00;o?003003o??ll00Go
?005003o??lloc`00007oc`00`00occo?002oc`00`00occo?005oc`00`00occo?002oc`00`00occo
?003oc`01000occo?0001?ll00@00?lloc`000?o?003003o?00000?o?003003o?00000?o?003003o
?00000;o?08000?o?003003o?00000;o?08000?o?08000;o?08000?o?08000;o?003003o?00000;o
?005003o??lloc`0000^oc`00`00occo?001oc`001_o?003003o??ll02[o?08000Wo?005003o??ll
oc`00007oc`01@00occo??ll00002?ll00@00?lloc`000So?005003o??lloc`00007oc`01@00occo
??ll00001oll00<00?lloc`00_ll00<00?lloc`01Oll00<00?lloc`00_ll00<00?lloc`00oll00@0
0?lloc`000Co?004003o??ll0003oc`00`00oc`00003oc`00`00oc`00003oc`00`00oc`00002oc`2
0003oc`00`00oc`00002oc`20003oc`20002oc`20003oc`20002oc`20003oc`01@00occo??ll0000
;_ll00<00?lloc`00Oll000Koc`2000/oc`00`00occo?008oc`01000occo?0001oll00D00?llocco
?00000So?004003o??ll0008oc`01@00occo??ll00001oll00D00?llocco?00000Oo?003003o??ll
00;o?003003o??ll00Go?003003o??ll00;o?003003o??ll00?o?004003o??ll0004oc`01000occo
?0000oll00<00?ll00000oll00<00?ll00000oll00<00?ll00000_ll0P000oll00<00?ll00000_ll
0P000oll0P000_ll0P000oll0P000_ll0P000oll00<00?lloc`0;oll0P000oll000Koc`00`00occo
?00foc`01000occo?0001oll00D00?llocco?00000So?004003o??ll0008oc`01@00occo??ll0000
1oll00D00?llocco?00000Oo?003003o??ll00;o?003003o??ll00Go?003003o??ll00;o?003003o
??ll00?o?004003o??ll0004oc`01000occo?0000oll00<00?ll00000oll00<00?ll00000oll00<0
0?ll00000_ll0P000oll00<00?ll00000_ll0P000oll0P000oll00@00?llocco?08000;o?08000?o
?003003o??ll033o?003003o??ll007o?0006oll00<00?lloc`0=_ll00<00?ll00002?ll00D00?ll
occo?00000So?004003o??ll0008oc`01@00occo??ll00001oll00D00?llocco?00000Oo?005003o
??lloc`00008oc`00`00occo?002oc`00`00occo?003oc`01000occo?0001?ll00@00?lloc`000?o
?003003o?00000?o?003003o?00000?o?003003o?00000;o?08000?o?003003o?00000;o?08000?o
?08000?o?004003o??lloc`20002oc`20003oc`00`00occo?00`oc`00`00occo?001oc`001_o?003
003o??ll03Ko?003003o?00000So?005003o??lloc`00008oc`01000occo?0002?ll00D00?llocco
?00000Oo?005003o??lloc`00007oc`01@00occo??ll00002?ll00<00?lloc`00_ll00<00?lloc`0
0oll00@00?lloc`000Co?004003o??ll0003oc`00`00oc`00003oc`00`00oc`00003oc`00`00oc`0
0002oc`20003oc`20003oc`20003oc`20003oc`01000occo??ll0P000_ll0P000oll00<00?lloc`0
<?ll00<00?lloc`00Oll000Koc`00`00occo?00foc`00`00oc`00008oc`01@00occo??ll00002?ll
00@00?lloc`000So?005003o??lloc`00007oc`01@00occo??ll00001oll00D00?llocco?00000So
?003003o??ll00;o?003003o??ll00?o?004003o??ll0004oc`01000occo?0000oll00<00?ll0000
0oll00<00?ll00000oll00<00?ll00000_ll0P000oll0P000oll0P000oll0P000oll00@00?llocco
?08000;o?08000?o?003003o??ll033o?003003o??ll007o?0006oll0P00=oll00<00?ll00002?ll
00D00?llocco?00000So?004003o??ll0008oc`01@00occo??ll00001oll00D00?llocco?00000Oo
?005003o??lloc`00008oc`00`00occo?002oc`00`00occo?003oc`01000occo?0001?ll00<00?ll
00001?ll00<00?ll00000oll00<00?ll00000oll00<00?ll00000_ll0P000oll0P000oll0P000oll
0P000oll00@00?llocco?08000;o?08003Go?08000?o?0006oll00<00?lloc`0=_ll00<00?ll0000
2?ll00D00?llocco?00000So?004003o??ll0008oc`01@00occo??ll00001oll00D00?llocco?000
00Oo?005003o??lloc`00008oc`00`00occo?002oc`00`00occo?003oc`01000occo?0001?ll00<0
0?ll00001?ll00<00?ll00000oll00<00?ll00000oll00<00?ll00000_ll0P000oll0P000oll0P00
0oll0P000oll00@00?llocco?08000;o?08003Ko?003003o??ll007o?0002?ll0P001?ll00<00?ll
oc`00_ll10001?ll00<00?lloc`0=_ll00<00?ll00002Oll00@00?lloc`000So?004003o??ll0008
oc`01@00occo??ll00001oll00D00?llocco?00000Oo?005003o??lloc`00008oc`00`00occo?002
oc`00`00occo?003oc`01000occo?0001?ll00<00?ll00001?ll00<00?ll00000oll00<00?ll0000
0oll00<00?ll00000_ll0P000oll0P000oll0P000oll0P000oll00@00?llocco?08000?o?003003o
??ll03Co?003003o??ll007o?0001oll00@00?lloc`000So?003003o??ll00Go?003003o??ll03Ko
?003003o?00000Wo?003003o?00000Wo?004003o??ll0008oc`01@00occo??ll00001oll00D00?ll
occo?00000Oo?005003o??lloc`00009oc`01@00occo??ll00001Oll00@00?lloc`000Co?003003o
?00000Co?003003o?00000?o?003003o?00000?o?003003o?00000;o?08000?o?08000?o?08000?o
?08000?o?004003o??lloc`20003oc`00`00occo?00doc`00`00occo?001oc`000Oo?004003o??ll
0009oc`00`00occo?004oc`2000goc`00`00oc`00009oc`00`00oc`00009oc`01000occo?0002?ll
00D00?llocco?00000Oo?005003o??lloc`00007oc`01@00occo??ll00002Oll00D00?llocco?000
00Go?004003o??ll0004oc`00`00oc`00004oc`00`00oc`00003oc`00`00oc`00003oc`00`00oc`0
0002oc`20003oc`20003oc`20003oc`20003oc`01000occo??ll0P000oll00<00?lloc`0<oll0P00
0oll0007oc`01000occo?0002_ll00<00?lloc`00oll00<00?lloc`0=_ll00<00?ll00002Oll00<0
0?ll00002Oll00@00?lloc`000So?005003o??lloc`00007oc`01@00occo??ll00001oll00D00?ll
occo?00000Wo?005003o??lloc`00005oc`01000occo?0001?ll00<00?ll00001?ll00<00?ll0000
0oll00<00?ll00000oll00<00?ll00000_ll0P000oll0P000oll0P000oll0P000oll00@00?llocco
?08000?o?003003o??ll03Co?003003o??ll007o?0001oll00@00?lloc`000_o?003003o??ll00;o
?003003o??ll03Ko?003003o?00000Wo?003003o?00000Wo?004003o??ll0008oc`01@00occo??ll
00001oll00D00?llocco?00000Oo?005003o??lloc`00009oc`01@00occo??ll00001Oll00@00?ll
oc`000Co?003003o?00000Co?003003o?00000?o?08000Co?003003o?00000;o?08000?o?08000?o
?08000?o?08000?o?003003o??ll00;o?003003o??ll03So?003003o??ll007o?0001oll00@00?ll
oc`000So?004003o??ll0004oc`00`00occo?00foc`00`00oc`00009oc`00`00oc`00009oc`01000
occo?0002?ll00D00?llocco?00000Oo?005003o??lloc`00007oc`01@00occo??ll00002Oll00D0
0?llocco?00000Go?004003o??ll0004oc`00`00oc`00004oc`00`00oc`00003oc`20004oc`20003
oc`20003oc`20004oc`01000occo??ll0P000oll00<00?lloc`00_ll00<00?lloc`0>?ll00<00?ll
oc`00Oll0008oc`2000:oc`20005oc`2000hoc`20009oc`00`00oc`00009oc`01000occo?0002?ll
00D00?llocco?00000Oo?005003o??lloc`00007oc`01@00occo??ll00002Oll00D00?llocco?000
00Go?004003o??ll0004oc`00`00oc`00004oc`00`00oc`00003oc`20004oc`20003oc`20003oc`2
0004oc`01000occo??ll0P000oll00<00?lloc`00_ll00<00?lloc`0=oll0P000oll000Koc`00`00
occo?00goc`00`00occo?008oc`00`00oc`00009oc`01000occo?0002?ll00D00?llocco?00000Oo
?005003o??lloc`00007oc`01@00occo??ll00002Oll00D00?llocco?00000Ko?003003o?00000Co
?003003o?00000Co?003003o?00000?o?08000Co?08000?o?08000Co?003003o??ll00;o?004003o
??lloc`20003oc`00`00occo?00moc`00`00occo?001oc`001_o?003003o??ll04;o?003003o?000
00Wo?004003o??ll0008oc`01@00occo??ll00001oll00D00?llocco?00000Oo?005003o??lloc`0
0009oc`01@00occo??ll00001_ll00<00?ll00001?ll00<00?ll00001?ll00<00?ll00000oll0P00
1?ll0P000oll0P001?ll00<00?lloc`00_ll00<00?lloc`00_ll00D00?llocco?00003oo?003003o
??ll007o?0006oll00<00?lloc`0@_ll00<00?ll00002Oll00@00?lloc`000So?005003o??lloc`0
0007oc`01@00occo??ll00001oll00D00?llocco?00000Wo?005003o??lloc`00006oc`00`00oc`0
0004oc`00`00oc`00004oc`00`00oc`00003oc`20004oc`20003oc`20004oc`00`00occo?002oc`0
0`00occo?002oc`01@00occo??ll0000?oll00<00?lloc`00Oll000Koc`20013oc`00`00oc`00009
oc`01000occo?0002Oll00<00?ll00002?ll00D00?llocco?00000Oo?005003o??lloc`00009oc`0
1@00occo??ll00001_ll00<00?ll00001?ll00<00?ll00001?ll00<00?ll00000oll0P001?ll0P00
0oll0P001?ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`0@?ll0P000oll000Koc`00`00
occo?013oc`20009oc`01000occo?0002Oll00<00?ll00002?ll00D00?llocco?00000Oo?005003o
??lloc`00009oc`01@00occo??ll00001_ll00<00?ll00001?ll00<00?ll00001?ll00<00?ll0000
0oll0P001?ll0P000oll0P001?ll00<00?lloc`00_ll00<00?lloc`00_ll00<00?lloc`0@Oll00<0
0?lloc`00Oll000Koc`00`00occo?013oc`20009oc`01000occo?0002Oll00<00?ll00002Oll00@0
0?lloc`000Oo?005003o??lloc`00009oc`01@00occo??ll00001_ll00<00?ll00001?ll00<00?ll
00001?ll00<00?ll00000oll0P001?ll0P000oll0P001?ll00<00?lloc`00_ll00<00?lloc`00_ll
00<00?lloc`0@Oll00<00?lloc`00Oll000Koc`00`00occo?013oc`20009oc`01000occo?0002Oll
00<00?ll00002Oll00<00?ll00002?ll00D00?llocco?00000Wo?005003o??lloc`00006oc`00`00
oc`00004oc`00`00oc`00004oc`00`00oc`00003oc`20004oc`20003oc`20004oc`00`00occo?002
oc`00`00occo?002oc`00`00occo?011oc`00`00occo?001oc`001_o?08004Co?08000Wo?004003o
??ll0009oc`00`00oc`00009oc`00`00oc`00009oc`01000occo?0002_ll00@00?lloc`000Ko?003
003o?00000Co?003003o?00000Co?08000Co?08000Co?08000?o?08000Co?003003o??ll00;o?003
003o??ll00;o?003003o??ll043o?08000?o?0006oll00<00?lloc`0@oll0P002Oll00@00?lloc`0
00Wo?003003o?00000Wo?003003o?00000Wo?004003o??ll000:oc`01000occo?0001_ll00<00?ll
00001?ll00<00?ll00001?ll0P001?ll0P001?ll0P000oll0P001?ll00<00?lloc`00_ll00<00?ll
oc`00_ll00<00?lloc`0@Oll00<00?lloc`00Oll000Koc`00`00occo?013oc`20009oc`01000occo
?0002Oll00<00?ll00002Oll00<00?ll00002Oll00@00?lloc`000[o?004003o??ll0006oc`00`00
oc`00004oc`00`00oc`00004oc`20004oc`20004oc`20003oc`20004oc`00`00occo?002oc`00`00
occo?002oc`00`00occo?011oc`00`00occo?001oc`001_o?003003o??ll04?o?003003o??ll00Wo
?003003o?00000Wo?003003o?00000Wo?003003o?00000Wo?004003o??ll000:oc`01000occo?000
1_ll00<00?ll00001Oll0P001?ll0P001?ll0P001?ll0P001?ll00<00?lloc`00_ll00<00?lloc`0
0_ll00<00?lloc`0A_ll00<00?lloc`00Oll000Koc`2001@oc`2000:oc`00`00oc`00009oc`00`00
oc`00009oc`01000occo?0002_ll00@00?lloc`000Ko?003003o?00000Go?08000Co?08000Co?080
00Co?08000Co?003003o??ll00;o?003003o??ll00;o?003003o??ll04Go?08000?o?0006oll00<0
0?lloc`0Coll0P002_ll00<00?ll00002Oll00<00?ll00002Oll00@00?lloc`000[o?004003o??ll
0006oc`00`00oc`00005oc`20005oc`00`00occo?002oc`20004oc`20004oc`00`00occo?002oc`0
0`00occo?01;oc`00`00occo?001oc`000So?08000Co?003003o??ll00?o?08000Go?003003o??ll
04oo?08000[o?003003o?00000Wo?003003o?00000Wo?004003o??ll000:oc`01000occo?0001_ll
00<00?ll00001Oll0P001Oll00<00?lloc`00oll00<00?lloc`00_ll0P001?ll00<00?lloc`00_ll
00<00?lloc`0Boll00<00?lloc`00Oll0007oc`01000occo?0002?ll00@00?lloc`000Co?003003o
??ll04oo?08000[o?003003o?00000Wo?003003o?00000Wo?004003o??ll000:oc`00`00oc`00007
oc`00`00oc`00005oc`20005oc`00`00occo?003oc`00`00occo?002oc`20004oc`00`00occo?01@
oc`00`00occo?001oc`000Oo?004003o??ll000;oc`00`00occo?002oc`2001@oc`2000:oc`00`00
oc`00009oc`00`00oc`00009oc`01000occo?0002_ll00<00?ll00001oll00<00?ll00001Oll0P00
1Oll00<00?lloc`00oll00<00?lloc`00_ll0P001?ll00<00?lloc`0Coll0P000oll0007oc`01000
occo?0002Oll0P001Oll00<00?lloc`0Coll0P002_ll0P002_ll00<00?ll00002Oll00@00?lloc`0
00[o?003003o?00000Oo?003003o?00000Go?08000Go?003003o??ll00?o?003003o??ll00;o?080
00Co?003003o??ll053o?003003o??ll007o?0001oll00@00?lloc`000_o?003003o??ll00;o?003
003o??ll04oo?003003o??ll00Wo?08000[o?003003o?00000Wo?004003o??ll000:oc`00`00oc`0
0007oc`00`00oc`00005oc`20005oc`00`00occo?003oc`00`00occo?002oc`00`00occo?003oc`0
0`00occo?01@oc`00`00occo?001oc`000Oo?004003o??ll0008oc`01000occo?0001?ll00<00?ll
oc`0Coll00<00?lloc`02Oll0P002_ll00<00?ll00002Oll00@00?lloc`000[o?003003o?00000Oo
?08000Ko?08000Go?003003o??ll00?o?003003o??ll00;o?003003o??ll00?o?003003o??ll053o
?003003o??ll007o?0002?ll0P002_ll0P001Oll0P00G?ll0P002_ll00<00?ll00002Oll00@00?ll
oc`000[o?003003o?00000Oo?08000Ko?08000Go?003003o??ll00?o?003003o??ll00;o?003003o
??ll05Go?08000?o?0006oll00<00?lloc`0Foll0P002_ll00<00?ll00002_ll00<00?ll00002_ll
00<00?ll00002?ll00<00?lloc`01?ll0P001Oll00<00?lloc`00oll00<00?lloc`0Foll00<00?ll
oc`00Oll000Koc`00`00occo?01Koc`2000:oc`00`00oc`0000:oc`2000;oc`00`00oc`00008oc`0
0`00occo?004oc`20005oc`00`00occo?003oc`00`00occo?01Koc`00`00occo?001oc`001_o?003
003o??ll05co?003003o??ll00So?003003o?00000[o?08000_o?003003o?00000So?003003o??ll
00Co?08000Go?003003o??ll00?o?003003o??ll05_o?003003o??ll007o?0006oll00<00?lloc`0
G?ll00<00?lloc`02?ll00<00?ll00002_ll0P002oll00<00?ll00002?ll00<00?lloc`01?ll0P00
1Oll00<00?lloc`0HOll00<00?lloc`00Oll000Koc`2001Xoc`00`00oc`0000:oc`2000;oc`00`00
oc`00008oc`00`00occo?004oc`2001Xoc`20003oc`001_o?003003o??ll06Oo?003003o?00000[o
?08000_o?08000Wo?003003o??ll00Go?003003o??ll06Oo?003003o??ll007o?0006oll00<00?ll
oc`0J?ll00<00?lloc`02Oll0P002oll0P002Oll00<00?lloc`01Oll00<00?lloc`0Ioll00<00?ll
oc`00Oll000Koc`00`00occo?01Xoc`00`00occo?009oc`2000<oc`00`00occo?007oc`00`00occo
?01_oc`00`00occo?001oc`001_o?08007Go?003003o??ll00_o?003003o??ll07So?08000?o?000
6oll00<00?lloc`0M?ll00<00?lloc`02oll00<00?lloc`0NOll00<00?lloc`00Oll000Koc`00`00
occo?03noc`00`00occo?001oc`001_o?003003o??ll00;o?003003o??ll03_o?003003o??ll03[o
?003003o??ll03[o?003003o??ll03_o?003003o??ll00?o?003003o??ll007o?0006oll0P000oll
00<00?lloc`02_ll00<00?lloc`02Oll00<00?lloc`02Oll00<00?lloc`02Oll00<00?lloc`02_ll
00<00?lloc`02Oll00<00?lloc`02Oll00<00?lloc`02Oll00<00?lloc`02_ll00<00?lloc`02Oll
00<00?lloc`02Oll00<00?lloc`02Oll00<00?lloc`02_ll00<00?lloc`02Oll00<00?lloc`02Oll
00<00?lloc`02Oll00<00?lloc`02_ll00<00?lloc`02Oll00<00?lloc`02Oll00<00?lloc`02_ll
00<00?lloc`00_ll0P000oll000Kocco00030003oc`00?oo?27o?000ooll8Oll0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-53.3943, -0.458566, \
1.63092, 0.00483875}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[Ng[0.1], Frame \[Rule] True, PlotRange \[Rule] All, 
        PlotJoined \[Rule] True];\)\)], "Input",
  InitializationCell->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0190476 0.0047619 0.0147151 0.588604 [
[.01905 -0.0125 -3 -9 ]
[.01905 -0.0125 3 0 ]
[.25714 -0.0125 -6 -9 ]
[.25714 -0.0125 6 0 ]
[.49524 -0.0125 -9 -9 ]
[.49524 -0.0125 9 0 ]
[.73333 -0.0125 -9 -9 ]
[.73333 -0.0125 9 0 ]
[.97143 -0.0125 -9 -9 ]
[.97143 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01472 -6 -4.5 ]
[-0.0125 .01472 0 4.5 ]
[-0.0125 .13244 -18 -4.5 ]
[-0.0125 .13244 0 4.5 ]
[-0.0125 .25016 -18 -4.5 ]
[-0.0125 .25016 0 4.5 ]
[-0.0125 .36788 -18 -4.5 ]
[-0.0125 .36788 0 4.5 ]
[-0.0125 .4856 -18 -4.5 ]
[-0.0125 .4856 0 4.5 ]
[-0.0125 .60332 -6 -4.5 ]
[-0.0125 .60332 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01905 0 m
.01905 .00625 L
s
[(0)] .01905 -0.0125 0 1 Mshowa
.25714 0 m
.25714 .00625 L
s
[(50)] .25714 -0.0125 0 1 Mshowa
.49524 0 m
.49524 .00625 L
s
[(100)] .49524 -0.0125 0 1 Mshowa
.73333 0 m
.73333 .00625 L
s
[(150)] .73333 -0.0125 0 1 Mshowa
.97143 0 m
.97143 .00625 L
s
[(200)] .97143 -0.0125 0 1 Mshowa
.125 Mabswid
.06667 0 m
.06667 .00375 L
s
.11429 0 m
.11429 .00375 L
s
.1619 0 m
.1619 .00375 L
s
.20952 0 m
.20952 .00375 L
s
.30476 0 m
.30476 .00375 L
s
.35238 0 m
.35238 .00375 L
s
.4 0 m
.4 .00375 L
s
.44762 0 m
.44762 .00375 L
s
.54286 0 m
.54286 .00375 L
s
.59048 0 m
.59048 .00375 L
s
.6381 0 m
.6381 .00375 L
s
.68571 0 m
.68571 .00375 L
s
.78095 0 m
.78095 .00375 L
s
.82857 0 m
.82857 .00375 L
s
.87619 0 m
.87619 .00375 L
s
.92381 0 m
.92381 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01472 m
.00625 .01472 L
s
[(0)] -0.0125 .01472 1 0 Mshowa
0 .13244 m
.00625 .13244 L
s
[(0.2)] -0.0125 .13244 1 0 Mshowa
0 .25016 m
.00625 .25016 L
s
[(0.4)] -0.0125 .25016 1 0 Mshowa
0 .36788 m
.00625 .36788 L
s
[(0.6)] -0.0125 .36788 1 0 Mshowa
0 .4856 m
.00625 .4856 L
s
[(0.8)] -0.0125 .4856 1 0 Mshowa
0 .60332 m
.00625 .60332 L
s
[(1)] -0.0125 .60332 1 0 Mshowa
.125 Mabswid
0 .04415 m
.00375 .04415 L
s
0 .07358 m
.00375 .07358 L
s
0 .10301 m
.00375 .10301 L
s
0 .16187 m
.00375 .16187 L
s
0 .1913 m
.00375 .1913 L
s
0 .22073 m
.00375 .22073 L
s
0 .27959 m
.00375 .27959 L
s
0 .30902 m
.00375 .30902 L
s
0 .33845 m
.00375 .33845 L
s
0 .39731 m
.00375 .39731 L
s
0 .42674 m
.00375 .42674 L
s
0 .45617 m
.00375 .45617 L
s
0 .51503 m
.00375 .51503 L
s
0 .54446 m
.00375 .54446 L
s
0 .57389 m
.00375 .57389 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.01905 .61178 m
.01905 .61803 L
s
.25714 .61178 m
.25714 .61803 L
s
.49524 .61178 m
.49524 .61803 L
s
.73333 .61178 m
.73333 .61803 L
s
.97143 .61178 m
.97143 .61803 L
s
.125 Mabswid
.06667 .61428 m
.06667 .61803 L
s
.11429 .61428 m
.11429 .61803 L
s
.1619 .61428 m
.1619 .61803 L
s
.20952 .61428 m
.20952 .61803 L
s
.30476 .61428 m
.30476 .61803 L
s
.35238 .61428 m
.35238 .61803 L
s
.4 .61428 m
.4 .61803 L
s
.44762 .61428 m
.44762 .61803 L
s
.54286 .61428 m
.54286 .61803 L
s
.59048 .61428 m
.59048 .61803 L
s
.6381 .61428 m
.6381 .61803 L
s
.68571 .61428 m
.68571 .61803 L
s
.78095 .61428 m
.78095 .61803 L
s
.82857 .61428 m
.82857 .61803 L
s
.87619 .61428 m
.87619 .61803 L
s
.92381 .61428 m
.92381 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .01472 m
1 .01472 L
s
.99375 .13244 m
1 .13244 L
s
.99375 .25016 m
1 .25016 L
s
.99375 .36788 m
1 .36788 L
s
.99375 .4856 m
1 .4856 L
s
.99375 .60332 m
1 .60332 L
s
.125 Mabswid
.99625 .04415 m
1 .04415 L
s
.99625 .07358 m
1 .07358 L
s
.99625 .10301 m
1 .10301 L
s
.99625 .16187 m
1 .16187 L
s
.99625 .1913 m
1 .1913 L
s
.99625 .22073 m
1 .22073 L
s
.99625 .27959 m
1 .27959 L
s
.99625 .30902 m
1 .30902 L
s
.99625 .33845 m
1 .33845 L
s
.99625 .39731 m
1 .39731 L
s
.99625 .42674 m
1 .42674 L
s
.99625 .45617 m
1 .45617 L
s
.99625 .51503 m
1 .51503 L
s
.99625 .54446 m
1 .54446 L
s
.99625 .57389 m
1 .57389 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
.5 Mabswid
.02381 .60332 m
.02857 .59415 L
.03333 .56747 L
.0381 .52572 L
.04286 .47251 L
.04762 .41216 L
.05238 .34909 L
.05714 .28733 L
.0619 .2301 L
.06667 .17963 L
.07143 .13707 L
.07619 .10269 L
.08095 .07602 L
.08571 .05611 L
.09048 .0418 L
.09524 .03189 L
.1 .02527 L
.10476 .021 L
.10952 .01834 L
.11429 .01674 L
.11905 .01581 L
.12381 .01529 L
.12857 .01501 L
.13333 .01486 L
.1381 .01478 L
.14286 .01475 L
.14762 .01473 L
.15238 .01472 L
.15714 .01472 L
.1619 .01472 L
.16667 .01472 L
.17143 .01472 L
.17619 .01472 L
.18095 .01472 L
.18571 .01472 L
.19048 .01472 L
.19524 .01472 L
.2 .01472 L
.20476 .01472 L
.20952 .01472 L
.21429 .01472 L
.21905 .01472 L
.22381 .01472 L
.22857 .01472 L
.23333 .01472 L
.2381 .01472 L
.24286 .01472 L
.24762 .01472 L
.25238 .01472 L
.25714 .01472 L
Mistroke
.2619 .01472 L
.26667 .01472 L
.27143 .01472 L
.27619 .01472 L
.28095 .01472 L
.28571 .01472 L
.29048 .01472 L
.29524 .01472 L
.3 .01472 L
.30476 .01472 L
.30952 .01472 L
.31429 .01472 L
.31905 .01472 L
.32381 .01472 L
.32857 .01472 L
.33333 .01472 L
.3381 .01472 L
.34286 .01472 L
.34762 .01472 L
.35238 .01472 L
.35714 .01472 L
.3619 .01472 L
.36667 .01472 L
.37143 .01472 L
.37619 .01472 L
.38095 .01472 L
.38571 .01472 L
.39048 .01472 L
.39524 .01472 L
.4 .01472 L
.40476 .01472 L
.40952 .01472 L
.41429 .01472 L
.41905 .01472 L
.42381 .01472 L
.42857 .01472 L
.43333 .01472 L
.4381 .01472 L
.44286 .01472 L
.44762 .01472 L
.45238 .01472 L
.45714 .01472 L
.4619 .01472 L
.46667 .01472 L
.47143 .01472 L
.47619 .01472 L
.48095 .01472 L
.48571 .01472 L
.49048 .01472 L
.49524 .01472 L
Mistroke
.5 .01472 L
.50476 .01472 L
.50952 .01472 L
.51429 .01472 L
.51905 .01472 L
.52381 .01472 L
.52857 .01472 L
.53333 .01472 L
.5381 .01472 L
.54286 .01472 L
.54762 .01472 L
.55238 .01472 L
.55714 .01472 L
.5619 .01472 L
.56667 .01472 L
.57143 .01472 L
.57619 .01472 L
.58095 .01472 L
.58571 .01472 L
.59048 .01472 L
.59524 .01472 L
.6 .01472 L
.60476 .01472 L
.60952 .01472 L
.61429 .01472 L
.61905 .01472 L
.62381 .01472 L
.62857 .01472 L
.63333 .01472 L
.6381 .01472 L
.64286 .01472 L
.64762 .01472 L
.65238 .01472 L
.65714 .01472 L
.6619 .01472 L
.66667 .01472 L
.67143 .01472 L
.67619 .01472 L
.68095 .01472 L
.68571 .01472 L
.69048 .01472 L
.69524 .01472 L
.7 .01472 L
.70476 .01472 L
.70952 .01472 L
.71429 .01472 L
.71905 .01472 L
.72381 .01472 L
.72857 .01472 L
.73333 .01472 L
Mistroke
.7381 .01472 L
.74286 .01472 L
.74762 .01472 L
.75238 .01472 L
.75714 .01472 L
.7619 .01472 L
.76667 .01472 L
.77143 .01472 L
.77619 .01472 L
.78095 .01472 L
.78571 .01472 L
.79048 .01472 L
.79524 .01472 L
.8 .01472 L
.80476 .01472 L
.80952 .01472 L
.81429 .01472 L
.81905 .01472 L
.82381 .01472 L
.82857 .01472 L
.83333 .01472 L
.8381 .01472 L
.84286 .01472 L
.84762 .01472 L
.85238 .01472 L
.85714 .01473 L
.8619 .01475 L
.86667 .01478 L
.87143 .01486 L
.87619 .01501 L
.88095 .01529 L
.88571 .01581 L
.89048 .01674 L
.89524 .01834 L
.9 .021 L
.90476 .02527 L
.90952 .03189 L
.91429 .0418 L
.91905 .05611 L
.92381 .07602 L
.92857 .10269 L
.93333 .13707 L
.9381 .17963 L
.94286 .2301 L
.94762 .28733 L
.95238 .34909 L
.95714 .41216 L
.9619 .47251 L
.96667 .52572 L
.97143 .56747 L
Mistroke
.97619 .59415 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  InitializationCell->True,
  ImageSize->{288, 177.938},
  ImageMargins->{{281, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40n007h00Oooll8Oll003ooc`Q
oc`001Wo?08003Wo?0<000Co?08003?o?0@000?o?08000Co?080033o?0@000;o?0<000Co?080033o
?0@000?o?08000Co?08000?o?0006?ll00@00?lloc`003_o?004003o??ll0002oc`00`00occo?00b
oc`01@00occo??ll00000_ll00@00?lloc`000;o?003003o??ll02oo?003003o??ll00Co?004003o
??ll0002oc`00`00occo?00]oc`00`00occo?003oc`01000occo?0000_ll00@00?lloc`000;o?000
6?ll00@00?lloc`003_o?004003o??ll0002oc`00`00occo?00boc`01@00occo??ll00000_ll00@0
0?lloc`000;o?003003o??ll02oo?003003o??ll00Co?004003o??ll0002oc`00`00occo?00^oc`0
0`00occo?002oc`01000occo?0000_ll00@00?lloc`000;o?0006?ll00@00?lloc`003So?0<000?o
?004003o??ll000doc`01@00occo??ll00000_ll00@00?lloc`000;o?003003o??ll02oo?004003o
??lloc`30003oc`01000occo?000<Oll00D00?llocco?00000;o?004003o??ll0002oc`10001oc`1
oc`001So?004003o??ll000hoc`00`00occo?003oc`01000occo?000=?ll00D00?llocco?00000;o
?004003o??ll0002oc`00`00occo?00_oc`01@00occo??ll00001Oll00@00?lloc`003;o?004003o
??ll0002oc`01000occo?0000_ll0@000Oll0Oll000Hoc`01000occo?000>?ll00<00?lloc`00oll
00@00?lloc`003;o?0<000?o?004003o??ll0002oc`01000occo?000;oll0`000oll00<00?lloc`0
0oll00@00?lloc`002oo?004003o??ll0002oc`01000occo?0000_ll00@00?lloc`000;o?0006Oll
0P00>Oll10000oll0P00=Oll00<00?lloc`00_ll0P001?ll0P00<_ll00@00?llocco?0@000?o?080
037o?08000Co?08000Co?08000?o?000ooll8Oll003ooc`Qoc`00?oo?27o?0005Ollo`002P000_ll
000Eoc`00`00occo?002oc`00`00occo?009oc`00`00occo?00:oc`00`00occo?00:oc`00`00occo
?009oc`00`00occo?00:oc`00`00occo?009oc`00`00occo?00:oc`00`00occo?00:oc`00`00occo
?009oc`00`00occo?00:oc`00`00occo?009oc`00`00occo?00:oc`00`00occo?009oc`00`00occo
?00:oc`00`00occo?00:oc`00`00occo?009oc`00`00occo?00:oc`00`00occo?009oc`00`00occo
?00:oc`00`00occo?00:oc`00`00occo?004oc`10001oc`1oc`000ko?08000Go?003003o??ll00;o
?003003o??ll03co?003003o??ll03co?003003o??ll03co?003003o??ll03co?003003o??ll00Co
?040007o?07o?0003Oll00@00?lloc`000Co?003003o??ll0?oo?0Ko?040007o?07o?0003Oll00@0
0?lloc`000Co?08001go?<`001_o?0<000;o?0003Oll00@00?lloc`000Co?003003o??ll01Wo?0<0
0<co?08001_o?040007o?07o?0003Oll00@00?lloc`000Co?003003o??ll01So?003003o??ll0<oo
?08001Wo?040007o?07o?0003Oll00@00?lloc`000Co?003003o??ll01Oo?003003o??ll0=;o?003
003o??ll01Ko?040007o?07o?0003_ll0P001Oll00<00?lloc`05oll00<00?lloc`0d_ll00<00?ll
oc`05_ll0@000Oll0Oll000Eoc`00`00occo?00Foc`00`00occo?03Doc`00`00occo?00Eoc`10001
oc`1oc`001Go?003003o??ll01Ko?003003o??ll0=Co?003003o??ll01Go?040007o?07o?0005Oll
00<00?lloc`05Oll00<00?lloc`0e_ll00<00?lloc`05?ll0@000Oll0Oll000Eoc`2000Foc`00`00
occo?03Foc`00`00occo?00Coc`20002oc`001Go?003003o??ll01Co?003003o??ll0=So?003003o
??ll01?o?040007o?07o?0005Oll00<00?lloc`05?ll00<00?lloc`0f?ll00<00?lloc`04oll0@00
0Oll0Oll000Eoc`00`00occo?00Coc`00`00occo?03Joc`00`00occo?00Boc`10001oc`1oc`001Go
?003003o??ll01?o?003003o??ll0=[o?003003o??ll01;o?040007o?07o?0005Oll00<00?lloc`0
4oll00<00?lloc`0f_ll00<00?lloc`04_ll0@000Oll0Oll000Eoc`00`00occo?00Boc`00`00occo
?03Loc`00`00occo?00Aoc`10001oc`1oc`001Go?003003o??ll01;o?003003o??ll0=co?003003o
??ll017o?040007o?07o?0005Oll0P004oll00<00?lloc`0g?ll00<00?lloc`04?ll0P000_ll000E
oc`00`00occo?00Boc`00`00occo?03Loc`00`00occo?00Aoc`10001oc`1oc`001Go?003003o??ll
01;o?003003o??ll0=co?003003o??ll017o?040007o?07o?0005Oll00<00?lloc`04_ll00<00?ll
oc`0g?ll00<00?lloc`04Oll0@000Oll0Oll000Eoc`00`00occo?00Aoc`00`00occo?03Noc`00`00
occo?00@oc`10001oc`1oc`001Go?003003o??ll017o?003003o??ll0=ko?003003o??ll013o?040
007o?07o?0005Oll00<00?lloc`04Oll00<00?lloc`0g_ll00<00?lloc`04?ll0@000Oll0Oll000E
oc`2000Boc`00`00occo?03Noc`00`00occo?00?oc`20002oc`001Go?003003o??ll017o?003003o
??ll0=ko?003003o??ll013o?040007o?07o?0005Oll00<00?lloc`04Oll00<00?lloc`0g_ll00<0
0?lloc`04?ll0@000Oll0Oll000Eoc`00`00occo?00Aoc`00`00occo?03Noc`00`00occo?00@oc`1
0001oc`1oc`001Go?003003o??ll017o?003003o??ll0=ko?003003o??ll013o?040007o?07o?000
5Oll00<00?lloc`04?ll00<00?lloc`0h?ll00<00?lloc`03oll0@000Oll0Oll0002oc`20004oc`0
0`00occo?002oc`40004oc`00`00occo?00@oc`00`00occo?03Poc`00`00occo?00?oc`10001oc`1
oc`00005oc`00?lloc`00008oc`00`00occo?005oc`00`00occo?00@oc`00`00occo?03Poc`00`00
occo?00?oc`10001oc`1oc`00005oc`00?lloc`00009oc`00`00occo?004oc`2000Aoc`00`00occo
?03Poc`00`00occo?00=oc`30002oc`00005oc`00?lloc`0000:oc`00`00occo?003oc`00`00occo
?00@oc`00`00occo?03Poc`00`00occo?00?oc`10001oc`1oc`00005oc`00?lloc`0000;oc`00`00
occo?002oc`00`00occo?00@oc`00`00occo?03Poc`00`00occo?00?oc`10001oc`1oc`00005oc`0
0?lloc`00008oc`01000occo?0001?ll00<00?lloc`04?ll00<00?lloc`0h?ll00<00?lloc`03oll
0@000Oll0Oll0002oc`2000:oc`20005oc`00`00occo?00@oc`00`00occo?03Poc`00`00occo?00?
oc`10001oc`1oc`001Go?003003o??ll00oo?003003o??ll0>;o?003003o??ll00ko?040007o?07o
?0005Oll00<00?lloc`03oll00<00?lloc`0h_ll00<00?lloc`03_ll0@000Oll0Oll000Eoc`00`00
occo?00?oc`00`00occo?03Roc`00`00occo?00>oc`10001oc`1oc`001Go?080013o?003003o??ll
0>;o?003003o??ll00go?08000;o?0005Oll00<00?lloc`03oll00<00?lloc`0h_ll00<00?lloc`0
3_ll0@000Oll0Oll000Eoc`00`00occo?00?oc`00`00occo?03Roc`00`00occo?00>oc`10001oc`1
oc`001Go?003003o??ll00ko?003003o??ll0>Co?003003o??ll00go?040007o?07o?0005Oll00<0
0?lloc`03_ll00<00?lloc`0i?ll00<00?lloc`03Oll0@000Oll0Oll000Eoc`00`00occo?00>oc`0
0`00occo?03Toc`00`00occo?00=oc`10001oc`1oc`001Go?003003o??ll00ko?003003o??ll0>Co
?003003o??ll00go?040007o?07o?0005Oll00<00?lloc`03_ll00<00?lloc`0i?ll00<00?lloc`0
3Oll0@000Oll0Oll000Eoc`2000?oc`00`00occo?03Toc`00`00occo?00<oc`20002oc`001Go?003
003o??ll00ko?003003o??ll0>Co?003003o??ll00go?040007o?07o?0005Oll00<00?lloc`03_ll
00<00?lloc`0i?ll00<00?lloc`03Oll0@000Oll0Oll000Eoc`00`00occo?00>oc`00`00occo?03T
oc`00`00occo?00=oc`10001oc`1oc`001Go?003003o??ll00go?003003o??ll0>Ko?003003o??ll
00co?040007o?07o?0005Oll00<00?lloc`03Oll00<00?lloc`0i_ll00<00?lloc`03?ll0@000Oll
0Oll000Eoc`00`00occo?00=oc`00`00occo?03Voc`00`00occo?00<oc`10001oc`1oc`001Go?003
003o??ll00go?003003o??ll0>Ko?003003o??ll00co?040007o?07o?0005Oll0P003_ll00<00?ll
oc`0i_ll00<00?lloc`02oll0P000_ll000Eoc`00`00occo?00=oc`00`00occo?03Voc`00`00occo
?00<oc`10001oc`1oc`001Go?003003o??ll00go?003003o??ll0>Ko?003003o??ll00co?040007o
?07o?0005Oll00<00?lloc`03Oll00<00?lloc`0i_ll00<00?lloc`03?ll0@000Oll0Oll000Eoc`0
0`00occo?00=oc`00`00occo?03Voc`00`00occo?00<oc`10001oc`1oc`000;o?08000Co?003003o
??ll00Co?003003o??ll00?o?003003o??ll00go?003003o??ll0>Ko?003003o??ll00co?040007o
?07o?00000Go?000occo?00000[o?003003o??ll00?o?003003o??ll00go?003003o??ll0>Ko?003
003o??ll00co?040007o?07o?00000Go?000occo?00000Oo?0D000Co?08000ko?003003o??ll0>Ko
?003003o??ll00[o?0<000;o?00000Go?000occo?00000Oo?004003o??ll0005oc`00`00occo?00=
oc`00`00occo?03Voc`00`00occo?00<oc`10001oc`1oc`00005oc`00?lloc`00008oc`00`00oc`0
0005oc`00`00occo?00=oc`00`00occo?03Voc`00`00occo?00<oc`10001oc`1oc`00005oc`00?ll
oc`00009oc`20005oc`00`00occo?00<oc`00`00occo?03Xoc`00`00occo?00;oc`10001oc`1oc`0
00;o?08000_o?003003o??ll00?o?003003o??ll00co?003003o??ll0>So?003003o??ll00_o?040
007o?07o?0005Oll00<00?lloc`03?ll00<00?lloc`0j?ll00<00?lloc`02oll0@000Oll0Oll000E
oc`00`00occo?00<oc`00`00occo?03Xoc`00`00occo?00;oc`10001oc`1oc`001Go?003003o??ll
00co?003003o??ll0>So?003003o??ll00_o?040007o?07o?0005Oll0P003Oll00<00?lloc`0j?ll
00<00?lloc`02_ll0P000_ll000Eoc`00`00occo?00<oc`00`00occo?03Xoc`00`00occo?00;oc`1
0001oc`1oc`001Go?003003o??ll00co?003003o??ll0>So?003003o??ll00_o?040007o?07o?000
5Oll00<00?lloc`03?ll00<00?lloc`0j?ll00<00?lloc`02oll0@000Oll0Oll000Eoc`00`00occo
?00<oc`00`00occo?03Xoc`00`00occo?00;oc`10001oc`1oc`001Go?003003o??ll00co?003003o
??ll0>So?003003o??ll00_o?040007o?07o?0005Oll00<00?lloc`03?ll00<00?lloc`0j?ll00<0
0?lloc`02oll0@000Oll0Oll000Eoc`00`00occo?00<oc`00`00occo?03Xoc`00`00occo?00;oc`1
0001oc`1oc`001Go?08000go?003003o??ll0>So?003003o??ll00[o?08000;o?0005Oll00<00?ll
oc`03?ll00<00?lloc`0j?ll00<00?lloc`02oll0@000Oll0Oll000Eoc`00`00occo?00<oc`00`00
occo?03Xoc`00`00occo?00;oc`10001oc`1oc`001Go?003003o??ll00_o?003003o??ll0>[o?003
003o??ll00[o?040007o?07o?0005Oll00<00?lloc`02oll00<00?lloc`0j_ll00<00?lloc`02_ll
0@000Oll0Oll000Eoc`00`00occo?00;oc`00`00occo?03Zoc`00`00occo?00:oc`10001oc`1oc`0
01Go?003003o??ll00_o?003003o??ll0>[o?003003o??ll00[o?040007o?07o?0005Oll00<00?ll
oc`02oll00<00?lloc`0j_ll00<00?lloc`02_ll0@000Oll0Oll000Eoc`2000<oc`00`00occo?03Z
oc`00`00occo?009oc`20002oc`001Go?003003o??ll00_o?003003o??ll0>[o?003003o??ll00[o
?040007o?07o?0005Oll00<00?lloc`02oll00<00?lloc`0j_ll00<00?lloc`02_ll0@000Oll0Oll
000Eoc`00`00occo?00;oc`00`00occo?03Zoc`00`00occo?00:oc`10001oc`1oc`001Go?003003o
??ll00_o?003003o??ll0>[o?003003o??ll00[o?040007o?07o?0000_ll0P001?ll00<00?lloc`0
0oll0P001Oll00<00?lloc`02oll00<00?lloc`0j_ll00<00?lloc`02_ll0@000Oll0Oll00001Oll
003o??ll00002?ll00@00?lloc`000Co?003003o??ll00_o?003003o??ll0>[o?003003o??ll00[o
?040007o?07o?00000Go?000occo?00000So?004003o??ll0004oc`2000;oc`00`00occo?03/oc`0
0`00occo?007oc`30002oc`00005oc`00?lloc`00008oc`30005oc`00`00occo?00:oc`00`00occo
?03/oc`00`00occo?009oc`10001oc`1oc`00005oc`00?lloc`00008oc`00`00occo?005oc`00`00
occo?00:oc`00`00occo?03/oc`00`00occo?009oc`10001oc`1oc`00005oc`00?lloc`00008oc`0
0`00occo?005oc`00`00occo?00:oc`00`00occo?03/oc`00`00occo?009oc`10001oc`1oc`000;o
?08000[o?0<000Co?003003o??ll00[o?003003o??ll0>co?003003o??ll00Wo?040007o?07o?000
5Oll00<00?lloc`02_ll00<00?lloc`0k?ll00<00?lloc`02Oll0@000Oll0Oll000Eoc`00`00occo
?00:oc`00`00occo?03/oc`00`00occo?009oc`10001oc`1oc`001Go?003003o??ll00[o?003003o
??ll0>co?003003o??ll00Wo?040007o?07o?0005Oll0P002_ll00<00?lloc`0k_ll00<00?lloc`0
1oll0P000_ll000Eoc`00`00occo?009oc`00`00occo?03^oc`00`00occo?008oc`10001oc`1oc`0
01Go?003003o??ll00Wo?003003o??ll0>ko?003003o??ll00So?040007o?07o?0005Oll00<00?ll
oc`02Oll00<00?lloc`0k_ll00<00?lloc`02?ll0@000Oll0Oll000Eoc`00`00occo?009oc`00`00
occo?03^oc`00`00occo?008oc`10001oc`1oc`001Go?003003o??ll00Wo?003003o??ll0>ko?003
003o??ll00So?040007o?07o?0005Oll00<00?lloc`02Oll00<00?lloc`0k_ll00<00?lloc`02?ll
0@000Oll0Oll000Eoc`00`00occo?009oc`00`00occo?03^oc`00`00occo?008oc`10001oc`1oc`0
01Go?08000[o?003003o??ll0>ko?003003o??ll00Oo?08000;o?0005Oll00<00?lloc`02Oll00<0
0?lloc`0k_ll00<00?lloc`02?ll0@000Oll0Oll000Eoc`00`00occo?009oc`00`00occo?03^oc`0
0`00occo?008oc`10001oc`1oc`001Go?003003o??ll00Wo?003003o??ll0>ko?003003o??ll00So
?040007o?07o?0005Oll00<00?lloc`02Oll00<00?lloc`0k_ll00<00?lloc`02?ll0@000Oll0Oll
000Eoc`00`00occo?008oc`00`00occo?03`oc`00`00occo?007oc`10001oc`1oc`001Go?003003o
??ll00So?003003o??ll0?3o?003003o??ll00Oo?040007o?07o?0005Oll00<00?lloc`02?ll00<0
0?lloc`0l?ll00<00?lloc`01oll0@000Oll0Oll000Eoc`20009oc`00`00occo?03`oc`00`00occo
?006oc`20002oc`001Go?003003o??ll00So?003003o??ll0?3o?003003o??ll00Oo?040007o?07o
?0005Oll00<00?lloc`02?ll00<00?lloc`0l?ll00<00?lloc`01oll0@000Oll0Oll000Eoc`00`00
occo?008oc`00`00occo?03`oc`00`00occo?007oc`10001oc`1oc`001Go?003003o??ll00So?003
003o??ll0?3o?003003o??ll00Oo?040007o?07o?0005Oll00<00?lloc`02?ll00<00?lloc`0l?ll
00<00?lloc`01oll0@000Oll0Oll0002oc`20004oc`00`00occo?003oc`20005oc`00`00occo?008
oc`00`00occo?03`oc`00`00occo?007oc`10001oc`1oc`00005oc`00?lloc`00008oc`01000occo
?0001?ll00<00?lloc`02?ll00<00?lloc`0l?ll00<00?lloc`01oll0@000Oll0Oll00001Oll003o
??ll00002?ll00@00?lloc`000Co?08000Wo?003003o??ll0?3o?003003o??ll00Go?0<000;o?000
00Go?000occo?00000Wo?08000Go?003003o??ll00So?003003o??ll0?3o?003003o??ll00Oo?040
007o?07o?00000Go?000occo?00000So?004003o??ll0004oc`00`00occo?008oc`00`00occo?03`
oc`00`00occo?007oc`10001oc`1oc`00005oc`00?lloc`00008oc`01000occo?0001?ll00<00?ll
oc`02?ll00<00?lloc`0l?ll00<00?lloc`01oll0@000Oll0Oll0002oc`2000:oc`20005oc`00`00
occo?007oc`00`00occo?03boc`00`00occo?006oc`10001oc`1oc`001Go?003003o??ll00Oo?003
003o??ll0?;o?003003o??ll00Ko?040007o?07o?0005Oll00<00?lloc`01oll00<00?lloc`0l_ll
00<00?lloc`01_ll0@000Oll0Oll000Eoc`20008oc`00`00occo?03boc`00`00occo?005oc`20002
oc`001Go?003003o??ll00Oo?003003o??ll0?;o?003003o??ll00Ko?040007o?07o?0005Oll00<0
0?lloc`01oll00<00?lloc`0l_ll00<00?lloc`01_ll0@000Oll0Oll000Eoc`00`00occo?007oc`0
0`00occo?03boc`00`00occo?006oc`10001oc`1oc`001Go?003003o??ll00Oo?003003o??ll0?;o
?003003o??ll00Ko?040007o?07o?0005Oll00<00?lloc`01oll00<00?lloc`0l_ll00<00?lloc`0
1_ll0@000Oll0Oll000Eoc`00`00occo?007oc`00`00occo?03coc`00`00occo?005oc`10001oc`1
oc`001Go?003003o??ll00Oo?003003o??ll0??o?003003o??ll00Go?040007o?07o?0005Oll0P00
2?ll00<00?lloc`0loll00<00?lloc`01?ll0P000_ll000Eoc`00`00occo?006oc`00`00occo?03d
oc`00`00occo?005oc`10001oc`1oc`001Go?003003o??ll00Ko?003003o??ll0?Co?003003o??ll
00Go?040007o?07o?0005Oll00<00?lloc`01_ll00<00?lloc`0m?ll00<00?lloc`01Oll0@000Oll
0Oll000Eoc`00`00occo?006oc`00`00occo?03eoc`00`00occo?004oc`10001oc`1oc`001Go?003
003o??ll00Ko?003003o??ll0?Go?003003o??ll00Co?040007o?07o?0005Oll00<00?lloc`01_ll
00<00?lloc`0mOll00<00?lloc`01?ll0@000Oll0Oll000Eoc`00`00occo?006oc`00`00occo?03e
oc`00`00occo?004oc`10001oc`1oc`001Go?08000Ko?003003o??ll0?Ko?003003o??ll00?o?080
00;o?0005Oll00<00?lloc`01Oll00<00?lloc`0m_ll00<00?lloc`01?ll0@000Oll0Oll000Eoc`0
0`00occo?005oc`00`00occo?03goc`00`00occo?003oc`10001oc`1oc`001Go?003003o??ll00Go
?003003o??ll0?Oo?003003o??ll00?o?040007o?07o?0005Oll00<00?lloc`01?ll00<00?lloc`0
n?ll00<00?lloc`00oll0@000Oll0Oll000Eoc`00`00occo?004oc`00`00occo?03hoc`00`00occo
?003oc`10001oc`1oc`000go?0@000Co?003003o??ll00Co?003003o??ll0?ko?040007o?07o?000
3oll00<00?lloc`00oll00<00?lloc`00oll00<00?lloc`0ooll0@000Oll0Oll000?oc`00`00occo
?003oc`20004oc`00`00occo?03moc`30002oc`000oo?003003o??ll00?o?003003o??ll0?oo?0Ko
?040007o?07o?0003oll00<00?lloc`00oll00<00?lloc`00_ll00<00?lloc`0??ll00<00?lloc`0
??ll00<00?lloc`0??ll00<00?lloc`0??ll00<00?lloc`01?ll0@000Oll0Oll000=oc`30005oc`0
0`00occo?002oc`00`00occo?009oc`00`00occo?00:oc`00`00occo?00:oc`00`00occo?009oc`0
0`00occo?00:oc`00`00occo?009oc`00`00occo?00:oc`00`00occo?00:oc`00`00occo?009oc`0
0`00occo?00:oc`00`00occo?009oc`00`00occo?00:oc`00`00occo?009oc`00`00occo?00:oc`0
0`00occo?00:oc`00`00occo?009oc`00`00occo?00:oc`00`00occo?009oc`00`00occo?00:oc`0
0`00occo?00:oc`00`00occo?004oc`10001oc`1oc`000oo?003003o??ll00?o??l000X000;o?000
\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-20.931, -0.106387, \
0.794721, 0.00642942}}]
}, Open  ]],

Cell[BoxData[
    \(Off[General::spell1]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(Nshift[f_, g_, b_] := f\ RotateRight[g, b]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(f[x_] := \((Which[x > 0, Sin[20  Pi\ x^\((1 + 0.4)\)], True, 0] + 
            Which[x \[LessEqual] 0, Sin[20  Pi\ x], True, 0])\) 
        Which[Abs[x] < 10, Exp[\(-1\)/\((1 - Abs[0.1  x]^2)\)], True, 
          0]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(NF = Nf[f, 0.001];\)\)], "Input",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["\<\
ListPlay[90000 NF, SampleRate->50000,
        PlayRange->{-2^15,2^15}]\
\>", "Input",
  CellTags->"S5.51.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.588604 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sampled sound
1 string
50000 20001 8
{ currentfile 1 index readhexstring pop }
 false 1 sampledsound
8080808080808080808080808080808080808080808080808080808080808080808080808080
8080808080808080808080808080808080808080808080808080808080808080808080808080
8080808080808080808080808080808080808080808080808080808080808080808080808080
808080808080808080808080808080808080808080808080808080808080808080808080807F
7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F
7F7F7F7F7F7F7F7F7F7F80808080808080808080808080808080808080808080808080808080
80808080808080808080808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F
7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F80808080
8080808080808080808080808080808080808080808080808080808080808080808080808080
8080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F
7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F808080808080808080808080808080808080
8080808080808080808080808080808080808080808080808080808080808080807F7F7F7F7F
7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F
7F7F7F7F7F7F8080808080808080808080808080808080808080808080808080808080808080
808080808080808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F
7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F8080808080808080
8080808080808080808080808080808080808080808080808080808080808080808080808080
80808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F
7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F80808080808080808080808080808080808080808080
808080808080808080808080808080808080808080808080808080807F7F7F7F7F7F7F7F7F7F
7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F
7F7F808080808080808080808080808080808080808080808080808080808080808080808080
80808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F
7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F808080808080808080808080
8080808080818181818181818181818181818181818181818080808080808080808080808080
7F7F7F7F7F7F7F7F7F7F7F7F7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E
7E7E7E7F7F7F7F7F7F7F7F7F8080808080808080808181818181818181818181818181828282
828282828281818181818181818181818180808080808080807F7F7F7F7F7F7E7E7E7E7E7E7E
7E7E7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7E7E7E7E7E7E7E7E7F7F7F7F7F7F80
8080808081818181818182828282828282828283838383838383838383838282828282828282
81818181818180808080807F7F7F7F7E7E7E7E7E7D7D7D7D7D7D7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C7C7D7D7D7D7D7E7E7E7E7E7F7F7F80808080818181818282828282838383
838384848484848484848484848484848484838383838383828282828181818080807F7F7F7F
7E7E7E7D7D7D7D7C7C7C7C7B7B7B7B7B7B7A7A7A7A7A7A7A7A7A7A7A7B7B7B7B7B7B7C7C7C7D
7D7D7D7E7E7E7F7F808080818181828282838383848484848585858585858686868686868686
85858585858584848484838383828282818180807F7F7F7E7E7D7D7D7C7C7C7B7B7A7A7A7A79
79797979797978787878787979797979797A7A7A7A7B7B7C7C7C7D7D7E7E7F7F808080818182
8283838484848585868686868787878787878888888887878787878786868686858584848483
8382828181807F7F7E7E7D7D7C7C7B7B7A7A7979797878787777777777777676767677777777
777778787879797A7A7A7B7B7C7D7D7E7E7F8080818182828384848585868687878888888989
898989898A8A8A8A898989898989888887878786868585848383828181807F7F7E7D7D7C7C7B
7A7A79797878777776767675757575747474747474757575757676767777787879797A7B7B7C
7D7D7E7F7F8081828283848585868787888889898A8A8B8B8B8B8C8C8C8C8C8C8C8C8B8B8B8A
8A8A8989888887868685848383828180807F7E7D7C7B7B7A7978787776767575747473737372
7272727272727272737373737474757576777778797A7A7B7C7D7E7F7F808182838485868687
8889898A8B8B8C8C8D8D8D8E8E8E8E8E8E8E8E8E8E8D8D8D8C8C8B8A8A898888878685848382
81807F7F7E7D7C7B7A7978777676757473737272717170707070707070707070707171717272
7374747576777879797A7B7C7D7E80818283848586878889898A8B8C8D8D8E8E8F8F90909091
91919191919090908F8F8E8E8D8C8C8B8A8988878685848382817F7E7D7C7B7A797877767574
73727171706F6F6E6E6E6D6D6D6D6D6D6D6D6E6E6F6F70707172737374757677787A7B7C7D7E
8081828384858788898A8B8C8D8E8F8F90919192929393939393939393939392929190908F8E
8D8C8B8A89888786858382817F7E7D7C7A7978777674737271706F6F6E6D6C6C6B6B6B6B6A6A
6A6A6B6B6B6C6C6D6D6E6F7071727374757678797A7B7D7E80818284858688898A8B8D8E8F90
9192929394949595969696969696969595959493939291908F8E8D8C8B898887858482817F7E
7D7B7A787776747372716F6E6D6C6C6B6A696968686868686868686869696A6A6B6C6D6E6F70
717274757778797B7C7E7F8183848687898A8B8D8E8F91929394959596979798989999999999
9898989797969594939291908F8D8C8A8987868483817F7E7C7B797776747371706F6D6C6B6A
696868676666656565656565656666676768696A6B6C6D6E707172747577797A7C7E80818385
86888A8B8D8E909192949596979899999A9B9B9B9B9C9C9B9B9B9A9A9998979695949392908F
8D8C8A88878583817F7E7C7A7877757372706E6D6C6A69686766656464636362626262626263
636465666667696A6B6C6E6F71737476787A7C7E8081838587898B8C8E90919394969798999A
9B9C9D9D9E9E9E9E9E9E9E9D9D9C9C9B9A999896959392908F8D8B89878583817F7E7C7A7876
7472706E6D6B6A68676664636262616060605F5F5F5F60606161626364656668696B6C6E7072
737577797B7D80828486888A8C8E8F9193959698999A9C9D9E9F9FA0A0A1A1A1A1A1A1A0A09F
9E9D9C9B9A9897959492908E8C8A888684827F7D7B79777573716F6D6B69686665636261605F
5E5E5D5D5D5C5C5D5D5D5E5F60616263646667696B6C6E70727477797B7D80828486888B8D8F
91939596989A9B9D9E9FA0A1A2A3A3A4A4A4A4A4A3A3A2A2A1A09E9D9C9A99979593918F8D8B
898684827F7D7B79767472706D6B696866646361605F5D5C5C5B5A5A5A5A5A5A5A5B5B5C5D5E
5F6162646567696B6D6F717476787B7D80828487898B8E90929496989A9C9E9FA0A2A3A4A5A5
A6A6A7A7A7A6A6A6A5A4A3A2A19F9E9C9B99979593908E8C89878482807D7A787673716E6C6A
68666462605F5D5C5B5A59585857575757575858595A5B5C5D5E6062636567696C6E70737578
7A7D808285878A8C8F919496989A9C9EA0A1A3A4A5A6A7A8A9A9A9AAA9A9A9A8A8A7A6A5A3A2
A09E9D9B989694928F8D8A8785827F7D7A777572706D6B68666462605E5D5B5A585756565555
545454545555565758595B5C5E60626466686A6D6F7275777A7D808285888A8D909295979A9C
9EA0A2A3A5A7A8A9AAABABACACACACACACABAAA9A8A7A6A4A2A09E9C9A989593908E8B888582
7F7D7A7774716F6C6A676562605E5C5A595756555453525251515152525354545657585A5C5E
60626467696C6E7174777A7D7F8285888B8E919496999B9EA0A2A4A6A7A9AAABADADAEAFAFAF
AFAFAEAEADACABA9A8A6A4A2A09E9C999794918E8B8986837F7C797674716E6B686663615E5C
5A58565554525150504F4F4F4F4F4F505152535556585A5C5E606365686B6D707376797C8083
86898C8F9295979A9D9FA2A4A6A8AAABADAEAFB0B1B1B2B2B2B1B1B0AFAEADACAAA8A6A4A2A0
9D9B9895928F8C8986837F7C797673706D6A6764615F5D5A5856545351504F4E4D4C4C4C4C4C
4D4E4E5051525456585A5C5E616466696C6F7376797C808386898C909396999C9EA1A3A6A8AA
ACAEAFB0B2B3B3B4B4B4B4B4B3B3B2B1AFAEACAAA8A6A4A19F9C999693908D898683807C7975
726F6C696663605D5B58565452504F4D4C4B4A4A4A494A4A4A4B4C4D4E50525456585A5D5F62
65686B6F7275797C7F83868A8D9094979A9DA0A3A5A8AAACAEB0B1B3B4B5B6B6B7B7B7B6B6B5
B4B3B2B0AEACAAA8A6A3A09D9A9794918D8A87837F7C7875726E6B6864615E5C59565452504E
4C4B4A4948474747474748494A4B4C4E4F515456595B5E6164676A6E7175787C8083878A8E91
95989B9EA1A4A7A9ACAEB0B2B4B5B6B7B8B9B9B9B9B9B8B8B7B5B4B2B1AFACAAA7A5A29F9C98
95928E8A87837F7C7875716D6A6763605D5A575552504E4C4A49474645454444444545464748
4A4B4D4F5254575A5D6063666A6D7174787C8083878B8E9296999CA0A3A6A9ABAEB0B2B4B6B8
B9BABBBBBCBCBCBBBBBAB9B8B6B5B3B1AEACA9A6A3A09D9996928F8B8783807C7874706D6965
625F5B585653504E4C4A484645444342424242424344454648494B4D505255585B5E6265696C
7074787C8083878B8F93969A9EA1A4A7AAADB0B2B4B6B8BABBBCBDBEBEBEBEBEBDBCBBBAB9B7
B5B3B0AEABA8A5A19E9A97938F8B87837F7C7874706C6864615D5A5754514E4C4A4846444342
4140403F4040414142444547494C4E5153565A5D6064686C6F73777B8084888C9094979B9FA2
A6A9ACAFB2B4B6B8BABCBDBFBFC0C1C1C1C0C0BFBEBCBBB9B7B4B2AFACA9A6A39F9B9894908C
88847F7B77736F6B6763605C5955524F4D4A48454442403F3E3E3D3D3D3E3E3F40424345474A
4C4F5255585C5F63676B6F73777B7F84888C9094989CA0A3A7AAAEB1B3B6B8BBBCBEC0C1C2C2
C3C3C3C3C2C1C0BEBDBBB9B6B4B1AEABA7A4A09C9995908C88847F7B77736F6A66625F5B5754
514E4B48464341403E3D3C3B3B3B3B3B3C3D3E3F414345484A4D5054575A5E62666A6E73777B
8084888C9195999DA1A5A8ACAFB2B5B8BABDBFC0C2C3C4C5C5C5C5C5C4C3C2C1BFBDBBB8B5B3
B0ACA9A5A19D9995918D88847F7B77726E6A66615E5A56524F4C494644413F3E3C3B3A393939
39393A3B3C3D3F414346494C4F5256595D6165696E72777B8084888D91969A9EA2A6AAADB1B4
B7BABCBEC1C2C4C5C6C7C7C8C7C7C6C5C4C3C1BFBDBAB7B4B1AEAAA6A29E9A96928D8984807B
76726D6965615C5855514E4A474442403D3C3A3938373736363738393A3B3D3F4244474A4D51
54585C6064696D72767B8084898D92969B9FA3A7ABAFB2B5B9BBBEC0C3C4C6C7C8C9CACACAC9
C8C7C6C5C3C1BEBCB9B6B3AFABA7A39F9B97928D89847F7B76716D6864605B5753504C494643
403E3C3A3837363534343435353638393B3D404245484C4F53575B5F64686D71767B8084898E
92979BA0A4A8ACB0B4B7BABDC0C2C4C6C8C9CACBCCCCCCCBCBCAC8C7C5C3C0BDBBB7B4B0ADA9
A4A09C97938E89847F7B76716C68635F5A56524E4B4744413E3C3A3836353433323232333334
3637393C3E4144474A4E52565A5E63676C71767B8084898E93989CA1A5A9ADB1B5B8BCBFC2C4
C6C8CACBCCCDCECECECDCDCCCAC9C7C4C2BFBCB9B5B2AEAAA5A19D98938E8984807B76716C67
625E5955514D4946423F3D3A3836343332313030303131323436383A3C3F4245494D5155595E
62676C71757A80858A8E93989DA2A6AAAFB3B6BABDC0C3C6C8CACCCDCECFD0D0D0CFCFCDCCCA
C8C6C4C1BEBAB7B3AFABA6A29D98948F8A857F7A75706B66625D5854504C4844413E3B383634
3231302F2E2E2E2F2F31323436383B3D4144484B4F54585D61666B70757A80858A8F94999EA2
A7ABB0B4B8BBBFC2C5C8CACCCECFD0D1D2D2D2D1D0CFCECCCAC8C5C2BFBCB8B4B0ACA7A39E99
948F8A857F7A75706B66615C58534F4B47433F3C39373432302F2E2D2C2C2C2D2E2F30323436
393C3F43464A4E53575C61666B70757A7F858A8F94999EA3A8ADB1B5B9BDC0C4C7C9CCCED0D1
D2D3D4D4D4D3D2D1D0CECCC9C7C4C1BDB9B5B1ADA8A49F9A958F8A857F7A75706A65605B5752
4E4945423E3B383533302F2D2C2B2A2A2A2B2C2D2E303235373A3E4145494D52565B60656A6F
757A80858A90959A9FA4A9AEB2B6BABEC2C5C8CBCDCFD1D3D4D5D5D6D5D5D4D3D2D0CECBC8C5
C2BEBBB7B2AEA9A49F9A95908A857F7A756F6A65605B56514C4844403D393633312F2D2B2A29
292829292A2B2D2E313336393C4044484C51555A5F646A6F757A80858A90959BA0A5AAAEB3B7
BCBFC3C7CACCCFD1D3D5D6D7D7D7D7D7D6D5D3D1CFCDCAC7C3C0BCB8B3AFAAA5A09B95908B85
807A746F69645F5A55504B47433F3B3835322F2D2B2A28272727272728292B2D2F3234373B3F
43474B50555A5F64696F747A7F858B90969BA0A6ABAFB4B9BDC1C4C8CBCED1D3D5D6D8D8D9D9
D9D9D8D6D5D3D1CECBC8C5C1BDB9B4B0ABA6A19B96908B857F7A746F69645E59544F4A46423E
3A3633302E2B29282726252525262628292B2D3033363A3D41464A4F54595E63696E747A8085
8B91969CA1A6ABB0B5BABEC2C6C9CDCFD2D4D6D8D9DADBDBDBDAD9D8D7D5D2D0CDCAC6C2BEBA
B5B1ACA7A19C96918B857F7A746E69635E58534E4945403C3935322F2C2A2826252423232324
2526282A2C2F3135383C4045494E53585D63686E747A7F858B91979CA2A7ACB1B6BBBFC3C7CB
CED1D4D6D8DADBDCDCDDDCDCDBDAD8D6D4D1CECBC7C3BFBBB6B2ACA7A29C97918B85807A746E
68635D58524D48443F3B3734302D2B282625232222222222232426282A2D3033373B3F44484D
52575D62686E747A80858B91979DA2A8ADB2B7BCC0C4C8CCCFD2D5D7D9DBDCDDDEDEDEDDDDDB
DAD8D5D3D0CCC9C5C0BCB7B2ADA8A29D97918B857F7A746E68625C57524C48433E3A36322F2C
2927252322212020202122232527292C2F32363A3E42474C51575C62686E737980868C91979D
A3A8AEB3B8BDC1C6CACDD1D4D6D9DBDDDEDFE0E0E0DFDEDDDBD9D7D4D1CDCAC6C2BDB8B3AEA9
A39D98928C867F79736D67625C56514C47423D3935312E2B28252322201F1F1E1F1F20212325
282A2D3135393D42464B51565C61676D73797F868C92989EA3A9AEB4B9BEC2C7CBCED2D5D8DA
DCDEE0E0E1E1E1E1E0DEDDDAD8D5D2CFCBC7C3BEB9B4AFA9A49E98928C867F79736D67615B56
504B46413C3834302C29262422201F1E1D1D1D1E1F20222426292C3033383C41454B50555B61
676D737980868C92989EA4AAAFB5BABFC3C8CCD0D3D6D9DCDEE0E1E2E3E3E3E2E1E0DEDCD9D7
D3D0CCC8C4BFBAB5AFAAA49E98928C867F79736D67615B554F4A45403B37332F2B282523201F
1D1C1C1C1C1C1D1F202225282B2F32363B40454A4F555B61676D737980868C92989FA4AAB0B5
BBC0C4C9CDD1D4D8DBDDDFE1E2E3E4E4E4E3E2E1DFDDDBD8D5D1CDC9C5C0BBB6B0AAA59F9992
8C868079736D66605A544F49443F3A36322E2A2724211F1D1C1B1A1A1A1B1C1D1F2124272A2D
31353A3F44494F545A60666C737980868C93999FA5ABB1B6BBC0C5CACED2D6D9DCDEE1E2E4E5
E5E6E5E5E4E2E1DEDCD9D6D2CECAC5C1BCB6B1ABA59F99938C867F79736C66605A544E49433E
3935302C292623201E1C1B1A1919191A1B1C1E202225292C3034393E43484E545A60666C7379
80868C93999FA5ABB1B7BCC1C6CBCFD3D7DADDE0E2E4E5E6E7E7E7E6E5E4E2E0DDDAD7D3CFCB
C6C2BCB7B1ACA6A099938C867F79726C665F59534D48423D38342F2B2824211F1D1B19181817
1818191B1C1F2124282B2F34383D42484D53595F666C72797F868D9399A0A6ACB2B8BDC2C7CC
D0D4D8DBDEE1E3E5E6E7E8E8E8E7E6E5E3E1DEDBD8D4D0CCC7C2BDB8B2ACA6A09A938D867F79
726C655F59534D47423C37332E2A2723201E1B1A18171616161718191B1D2023262A2E33373C
41474D53595F656C727980868D939AA0A6ADB2B8BEC3C8CDD1D5D9DCDFE2E4E6E8E9E9E9E9E9
E8E6E4E2DFDCD9D5D1CDC8C3BEB8B3ADA7A09A938D867F79726C655F58524C46413C37322D29
26221F1C1A1817161515151617181A1C1F2225292D32363B41464C52585E656B727980868D94
9AA1A7ADB3B9BEC4C9CED2D6DADDE0E3E5E7E9EAEAEBEBEAE9E7E6E3E1DEDAD6D2CEC9C4BFB9
B3ADA7A19A948D868079726B655E58524C46403B36312D2825211E1B19171615141414151617
191B1E2124282C31363B40464B52585E656B727980868D949AA1A7AEB4B9BFC4CACED3D7DBDE
E1E4E7E8EAEBECECECEBEAE9E7E4E2DFDBD7D3CFCAC5BFBAB4AEA7A19B948D867F79726B645E
57514B45403A35302C2724201D1A18161513131313131416181A1D2023272B30353A3F454B51
575E646B727980868D949BA1A8AEB4BAC0C5CACFD4D8DCDFE3E5E8EAEBECEDEDEDECEBEAE8E5
E3E0DCD8D4CFCBC5C0BAB4AEA8A19B948D867F79726B645E57514B453F39342F2B27231F1C19
1715131212111212131517191C1F22262B2F34393F444A51575D646B727980868D949BA2A8AF
B5BBC0C6CBD0D5D9DDE0E4E6E9EBECEDEEEEEEEDECEBE9E6E4E1DDD9D5D0CBC6C1BBB5AFA8A2
9B948D867F79726B645D57504A443E39332F2A26221E1B181614121111101111121416181B1E
22252A2E33393E444A50565D646B727980868D949BA2A9AFB5BBC1C7CCD1D5DADEE1E5E7EAEC
EDEEEFEFEFEEEDECEAE7E5E1DEDAD6D1CCC7C1BBB5AFA9A29B948E878078716B645D56504A43
3E38332E2925211D1A1715131110100F0F10111315171A1D2125292E33383D434950565D646A
717880878E959BA2A9AFB6BCC2C7CDD2D6DBDFE2E5E8EBEDEEEFF0F0F0EFEEEDEBE8E6E2DFDB
D6D2CDC7C2BCB6B0A9A29C958E877F78716A635D564F49433D37322D2824201C19161412100F
0E0E0E0F10121416191C2024282D32373D43494F565C636A717880878E959CA3A9B0B6BCC2C8
CDD2D7DBDFE3E6E9ECEEEFF0F1F1F1F0EFEEECE9E6E3E0DCD7D2CDC8C2BDB6B0A9A39C958E87
7F78716A635C564F49423C37312C28231F1B181513110F0E0E0D0E0E0F111315181B1F23272C
31373C42484F555C636A717880878E959CA3AAB0B7BDC3C9CED3D8DCE0E4E7EAEDEFF0F1F2F2
F2F1F0EFEDEAE7E4E0DCD8D3CEC9C3BDB7B0AAA39C958E877F78716A635C554F48423C36312C
27221E1B171412100E0D0D0C0D0D0E101214171B1E22272B31363C42484E555C636A71788087
8E959CA3AAB1B7BDC3C9CFD4D9DDE1E5E8EBEDEFF1F2F3F3F3F2F1F0EEEBE8E5E1DDD9D4CFC9
C4BEB7B1AAA39C958E877F78716A635C554E48413B36302B26221E1A1714110F0E0C0C0B0C0C
0D0F1114161A1D22262B30353B41484E555C636A717880878E959CA3AAB1B8BEC4CACFD4D9DE
E2E6E9ECEEF0F2F3F4F4F4F3F2F0EEECE9E6E2DED9D5CFCAC4BEB8B1AAA49D958E877F78716A
625B554E47413B35302A25211D191613100E0D0B0B0B0B0B0D0E101316191D21252A2F353B41
474E545B626A717880878E959DA4ABB1B8BEC4CAD0D5DADEE3E6EAEDEFF1F3F4F5F5F5F4F3F1
EFEDEAE6E3DFDAD5D0CAC5BEB8B2ABA49D968E877F787169625B544D47403A342F2A25201C18
1512100D0C0B0A0A0A0B0C0D0F1215181C20252A2F343A40474D545B6269717880878E969DA4
ABB2B8BFC5CBD0D6DADFE3E7EAEDF0F2F4F5F5F6F5F5F4F2F0EDEAE7E3DFDBD6D0CBC5BFB9B2
ABA49D968E877F787169625B544D46403A342E2924201B1814110F0D0B0A0909090A0B0D0F11
14181B1F24292E343A40464D545B6269717880878E969DA4ABB2B9BFC5CBD1D6DBE0E4E8EBEE
F1F3F4F6F6F6F6F6F4F3F1EEEBE8E4E0DBD6D1CBC6BFB9B2ABA49D968E8780787169625B544D
464039332E29241F1B1714110E0C0A09080808090A0C0E1013171B1F23282E33393F464D545B
6269717880878E969DA4ACB2B9C0C6CCD1D7DCE0E5E8ECEFF1F3F5F6F7F7F7F6F5F4F1EFECE8
E5E0DCD7D2CCC6C0B9B3ACA59D968F877F787069625A534C463F39332D28231E1A1613100D0B
0A0808070808090B0D1013161A1E23282D33393F464C535A6269707880878F969DA5ACB3B9C0
C6CCD2D7DCE1E5E9ECEFF2F4F6F7F8F8F8F7F6F4F2F0EDE9E5E1DCD7D2CCC6C0BAB3ACA59D96
8F877F787069615A534C453F39332D27221E1A16120F0D0B090807070708090A0D0F1216191E
22272D32383F454C535A616970787F878F969EA5ACB3BAC0C7CDD2D8DDE1E6EAEDF0F3F5F6F8
F8F9F8F8F7F5F3F0EDEAE6E2DDD8D3CDC7C0BAB3ACA59E968F877F787069615A534C453E3832
2C27221D1915120F0C0A080706060607080A0C0E1215191D22272C32383E454C535A61697078
80878F969EA5ACB3BAC1C7CDD3D8DDE2E6EAEEF1F3F5F7F8F9F9F9F8F7F6F3F1EEEAE6E2DDD8
D3CDC7C1BAB3ACA59E968F877F787069615A534C453E38322C27211D1815110E0B0908060605
060607090B0E1114181D21262C32383E454B525A6169707880878F969EA5ADB4BAC1C7CED3D9
DEE3E7EBEEF1F4F6F8F9FAFAFAF9F8F6F4F1EEEBE7E3DED9D3CEC8C1BBB4ADA59E968F877F78
7069615A524B443E37312C26211C1814100D0B0907060505050607090B0D1014181C21262B31
373E444B525A6168707880878F979EA5ADB4BBC1C8CED4D9DEE3E7EBEFF2F5F7F8FAFAFBFAFA
F8F7F5F2EFEBE7E3DED9D4CEC8C1BBB4ADA69E978F877F7870686159524B443D37312B26201C
1713100D0A0806050404040506080A0D1013171C20262B31373D444B52596168707880878F97
9EA6ADB4BBC2C8CED4DADFE3E8ECEFF2F5F7F9FAFBFBFBFAF9F7F5F2EFECE8E4DFDAD4CEC8C2
BBB4ADA69E978F877F7870686159524B443D37312B25201B17130F0C0A070605040404050607
0A0C0F13171B20252B30373D444B52596168707880878F979EA6ADB4BBC2C8CFD4DADFE4E8EC
F0F3F6F8F9FBFBFCFBFBFAF8F6F3F0ECE8E4DFDAD5CFC9C2BBB4ADA69E978F877F7870686159
524B443D36302A25201B16120F0C09070504030303040507090C0F12161B20252A30363D444A
5259616870787F878F979EA6ADB5BCC2C9CFD5DAE0E4E9EDF0F3F6F8FAFBFCFCFCFBFAF8F6F3
F0EDE9E4E0DAD5CFC9C2BCB5ADA69F978F877F7870686059524A433D36302A241F1A16120E0B
09060504030303040506090B0E12161A1F242A30363D434A5159606870787F878F979FA6AEB5
BCC3C9CFD5DBE0E5E9EDF1F4F7F9FAFCFCFDFCFCFAF9F7F4F1EDE9E5E0DBD5CFC9C3BCB5AEA6
9F978F877F7870686059514A433C36302A241F1A16120E0B08060403020202030406080B0E12
161A1F242A30363C434A51596068707880878F979FA6AEB5BCC3C9D0D5DBE0E5EAEEF1F4F7F9
FBFCFDFDFDFCFBF9F7F4F1EEEAE5E0DBD6D0C9C3BCB5AEA69F978F87807870686059514A433C
362F29241F1A15110E0A08060403020202030406080A0E11151A1E24292F353C434A51596068
707880878F979FA6AEB5BCC3CAD0D6DBE1E5EAEEF2F5F7FAFBFDFDFEFDFDFBFAF7F5F2EEEAE6
E1DBD6D0CAC3BCB5AEA69F978F87807870686058514A433C352F29231E1915110D0A07050302
010101020305070A0D1115191E23292F353C434A51586068707880878F979FA7AEB5BCC3CAD0
D6DCE1E6EAEEF2F5F8FAFCFDFEFEFEFDFCFAF8F5F2EEEAE6E1DCD6D0CAC3BCB5AEA79F978F87
7F7870686058514A433C352F29231E1915110D0A07050302010101020305070A0D1015191E23
292F353C424A5158606870787F878F979FA7AEB5BDC3CAD0D6DCE1E6EBEFF2F5F8FAFCFDFEFE
FEFDFCFAF8F5F2EFEBE6E1DCD6D0CAC4BDB6AEA79F978F877F78706860585149423B352F2923
1E1914100D090704030101000101030407090D1014191E23292E353B42495158606870788087
8F979FA7AEB6BDC4CAD1D7DCE1E6EBEFF3F6F8FBFCFEFEFFFEFEFCFBF9F6F3EFEBE6E2DCD7D1
CAC4BDB6AEA79F978F878078706860585149423B352E28231D1814100C090604020100000001
020406090C1014181D23282E353B424951586068707780888F979FA7AEB6BDC4CAD1D7DCE2E7
EBEFF3F6F9FBFDFEFFFFFFFEFDFBF9F6F3EFEBE7E2DCD7D1CAC4BDB6AEA79F978F8880777068
60585149423B342E28221D1814100C090604020100000001020406090C1014181D22282E343B
4249505860686F77808890979FA7AFB6BDC4CBD1D7DDE2E7EBEFF3F6F9FBFDFEFFFFFFFEFDFB
F9F6F3F0EBE7E2DDD7D1CBC4BDB6AFA79F9790887F776F6860585049423B342E28221D18130F
0C090604020100000001020406090C0F13181D22282E343B4249505860686F77808890979FA7
AFB6BDC4CBD1D7DDE2E7ECF0F3F7F9FCFDFFFFFFFFFFFDFCF9F7F3F0ECE7E2DDD7D1CBC4BDB6
AFA79F9890887F776F6760585049423B342E28221D18130F0B08060302000000000002030608
0B0F13181D22282E343B4249505860676F777F8890989FA7AFB6BDC4CBD1D7DDE2E7ECF0F4F7
FAFCFEFFFFFFFFFFFEFCFAF7F4F0ECE7E2DDD7D1CBC4BDB6AFA79F9890887F776F6760585049
423B342E28221D18130F0B080503010000000000010305080B0F13181D22282E343B42495058
60676F77808890989FA7AFB6BDC4CBD1D7DDE3E7ECF0F4F7FAFCFEFFFFFFFFFFFEFCFAF7F4F0
ECE8E3DDD8D1CBC4BDB6AFA79F9890887F776F6760585049423B342E27221C17130F0B080503
010000000000010305080B0F13171C22272D343B424950585F676F7780889098A0A7AFB6BEC4
CBD2D8DDE3E8ECF0F4F7FAFCFEFFFFFFFFFFFEFCFAF7F4F0ECE8E3DDD8D2CBC4BEB6AFA7A098
908880776F675F585049413A342D27221C17130F0B080503010000000000010305080B0F1317
1C22272D343A414950585F676F7780889098A0A7AFB6BEC5CBD2D8DDE3E8ECF0F4F7FAFCFEFF
FFFFFFFFFEFCFAF7F4F0ECE8E3DDD8D2CBC5BEB6AFA7A09890887F776F675F585049413A342D
27211C17130E0B080503010000000000010305080B0E13171C21272D343A414950585F676F77
80889098A0A7AFB6BEC5CBD2D8DEE3E8ECF1F4F7FAFCFEFFFFFFFFFFFEFCFAF7F4F1ECE8E3DE
D8D2CBC5BEB6AFA7A09890887F776F675F585049413A342D27211C17130E0B07050201000000
0000010205070B0E12171C21272D343A414950585F676F777F889098A0A7AFB6BEC5CBD2D8DE
E3E8EDF1F4F8FAFDFEFFFFFFFFFFFEFDFAF8F4F1EDE8E3DED8D2CBC5BEB6AFA7A09890887F77
6F675F585048413A342D27211C17120E0B070502010000000000010205070B0E12171C21272D
343A414850585F676F7780889098A0A7AFB7BEC5CBD2D8DEE3E8EDF1F4F8FAFDFEFFFFFFFFFF
FEFDFAF8F4F1EDE8E3DED8D2CBC5BEB7AFA7A09890887F776F675F585048413A342D27211C17
120E0B070502010000000000010205070B0E12171C21272D343A414850585F676F7780889098
A0A7AFB7BEC5CBD2D8DEE3E8EDF1F4F8FAFDFFFFFFFFFFFFFFFDFAF8F4F1EDE8E3DED8D2CCC5
BEB7AFA7A098908880776F675F585048413A332D27211C17120E0A0705020000000000000002
05070A0E12171C21272D333A414850585F676F7780889098A0A7AFB7BEC5CCD2D8DEE3E8EDF1
F5F8FAFDFFFFFFFFFFFFFFFDFAF8F5F1EDE8E3DED8D2CCC5BEB7AFA7A09890887F776F675F58
5048413A332D27211C17120E0A070402000000000000000204070A0E12171C21272D333A4148
50585F676F778080818283848687898B8C8E90929496989A9D9FA1A3A6A8ABADAFB2B4B7B9BC
BEC1C3C6C8CBCDD0D2D5D7D9DCDEE0E2E4E7E9EBECEEF0F2F3F5F6F8F9FAFBFCFDFEFFFFFFFF
FFFFFFFFFFFFFFFFFEFDFCFBFAF9F7F6F4F2F0EDEBE9E6E3E0DDDAD7D4D0CDC9C5C1BDB9B5B1
ADA8A49F9A96918C88837E79746F6B66615C57534E4945403C3834302C2824211D1A1714110E
0C0A08060402010000000000000000000102040507090C0E1114171B1E22262A2F33383D4247
4C51575C62686E73797F858B91979CA2A8AEB3B9BEC3C8CDD2D6DBDFE3E7EAEEF1F4F6F9FBFC
FEFFFFFFFFFFFFFFFFFEFCFAF8F6F3F0ECE9E5E1DDD8D3CEC9C4BEB8B2ACA6A099938C867F78
726B655E58514B453F3A342F2A25201B1713100D0A0705030100000000000000010305070A0D
1115191D22272C31373D434A50575E656C737A818890979EA5ACB2B9BFC5CBD1D7DCE1E6EAEE
F2F5F8FAFCFEFFFFFFFFFFFFFEFCFAF8F5F2EEEAE5E1DCD6D0CAC4BEB7B0A9A19A938B837C74
6C655D564F48413A342E28221D1814100C09060402000000000000010305080B0F13171C2127
2D333A41484F575E666E767E868E969EA6AEB5BCC3CAD1D7DDE2E7ECF0F4F7FAFCFEFFFFFFFF
FFFEFDFAF7F4F0ECE7E2DDD7D0CAC3BBB4ACA49C948B837B726A625A524A423B342D27211B16
110D0A0604020000000000010205080B0F14191E242A31383F474F5760687179828B939CA5AD
B5BDC4CCD3D9DFE5EAEFF3F7FAFCFEFFFFFFFFFFFDFBF8F4F0ECE7E1DBD5CEC6BFB7AEA69D94
8B827970675F564D453D362E28211B16110C0905030100000000010205080C10151B21272E35
3D454E565F68727B848D97A0A9B1BAC2CAD1D8DFE5EAEFF4F7FBFDFFFFFFFFFFFDFBF8F5F0EB
E6E0D9D2CBC3BBB2A9A0978D847A71675E554C433B332C241E18130E0A060301000000000103
060A0E13181E252C343C444D566069737D87909AA3ADB6BFC7CFD6DDE4EAEFF4F7FBFDFFFFFF
FFFEFCFAF6F2EDE7E1DBD3CBC3BAB1A89F958B81776D635950473E352E261F19130E0A060301
000000000205080C11161C232B333B444D56606A747F89939DA7B0BAC3CBD3DBE2E8EEF3F7FA
FDFFFFFFFFFEFCF9F5F0EBE5DED7CFC7BEB4ABA1978C82786D63594F463D342C241D17110C08
0402000000000204080C11161D242B343C464F59646E78838E98A2ACB6C0C9D1D9E0E7EDF2F7
FAFDFFFFFFFFFDFBF7F3EEE8E2DAD3CAC1B8AEA4998F84796E64594F453C332B231C15100B07
03010000000103060A0F151B232B333C464F5A646F7A85909BA5B0BAC3CCD5DDE4EAF0F5F9FC
FEFFFFFFFDFBF8F3EEE8E1DAD2C9BFB6ABA1968B80756A5F544A40372E251E17110C07040200
00000104070B10161D252D363F49535E69747F8B96A1ACB6C0CAD2DBE2E9EFF4F8FCFEFFFFFF
FDFAF7F2EDE6DFD7CEC5BBB1A69B9085796E63584D433930271F18120C080402000000020408
0C12181F273039434D58636F7A86919DA8B3BDC7D0D9E1E8EEF3F8FBFEFFFFFEFDFAF6F1EBE5
DDD5CCC2B8ADA2978B7F74685D52473D332A221A130E0905020000000204080D12192029323B
46505B67737E8A96A2ADB8C2CCD5DDE5ECF2F6FAFDFFFFFFFDFAF6F1ECE5DDD5CBC1B7ACA195
897D71655A4E443930271E17110B07040100000104070B11171F27303A444F5A66727E8A96A2
ADB8C3CDD6DFE6EDF3F7FBFDFFFFFEFCF8F4EFE8E1D8CFC5BBB0A4998D8074685C51463B3128
1F18110C07040100000204080C12192129333D48535F6B7783909CA8B3BEC9D2DBE3EBF1F6FA
FDFEFFFEFCF9F4EFE9E1D9CFC5BBAFA4988B7F73665A4E43392F251D160F0A06030100010306
0A10161E262F3944505B6874818D99A6B1BDC7D1DBE3EAF0F6FAFCFEFEFEFBF8F3EEE7DFD6CD
C2B7ACA093877A6E6155493E342A2119120C07040201010305090F151C252E38434F5B677380
8D9AA6B2BDC8D2DBE4EBF1F6FAFDFEFEFDFAF6F1EBE4DCD2C8BDB2A6998D8073665A4E42372D
241B140E09050201010205090E141C242E38434F5B6874818E9BA8B4BFCAD4DDE5EDF3F7FBFD
FEFEFCF9F4EFE8E0D7CDC3B7AB9F9285786B5E52463B30261E160F0A060301010205090E141C
252E3944505C697683909DAAB6C1CCD6DFE7EEF4F8FCFDFEFDFAF7F2ECE4DCD2C8BCB0A4978A
7D7063564A3E33292018110B070402010205090E141C242E3944505D6A7784919FABB7C3CED8
E1E9F0F5F9FCFDFDFCF9F5EFE8E1D7CDC2B7AA9E908376685B4F43372D231B130D0804020202
05080D131B232D38434F5C697684919FABB8C4CFD9E2E9F0F5F9FCFDFDFBF8F3EDE6DED4CABF
B2A6998B7E706356493D32281F17100A0603020204070B1118212A35404C596674818F9DAAB6
C2CDD8E1E9F0F5F9FCFDFDFBF7F3EDE5DDD3C8BDB0A396887B6D6053463A2F251C140E090503
020305090E151D26303B4754616E7C8A97A5B2BECAD4DEE6EEF4F8FBFDFDFBF8F3EDE6DED4C9
BDB1A497897B6D6052463A2F251C140D0805030204060A10171F28333E4B586573818F9CAAB7
C3CED8E2EAF0F6F9FCFCFCF9F5F0E9E1D8CDC2B5A89B8D7F716356493D31271E160F09060303
04060A10161F28333E4B586573818F9DABB8C4CFD9E3EBF1F6FAFCFCFBF8F4EEE7DED4CABEB1
A496887A6C5E5144382D231A120C0805030305080D141C252F3A4653616F7D8B99A7B4C1CCD7
E1E9F0F5F9FBFCFBF8F4EEE7DFD5CABEB1A49688796B5D5043372C2219120C07040304060A0F
161E27323E4A58657482909EACB9C5D1DBE4ECF2F7FAFBFBF9F6F1EAE2D9CEC3B6A99B8D7F70
6254473B2F251C140D0905040406090E151D26313C49566472818F9EABB9C5D0DBE4ECF2F7FA
FBFBF9F5F0E9E1D7CDC1B4A6988A7B6D5F5144382C2219120C08050405070B1118212B36424F
5D6B7A8897A5B2BFCBD6E0E8EFF5F9FBFBFAF6F2EBE3DAD0C4B7AA9C8D7F706254463A2E241B
130D08050405070B1118212B36424F5D6C7A8997A6B3C0CCD7E1E9F0F5F9FAFAF9F5F0E9E1D7
CDC1B4A698897A6C5D4F42362B2018110B07050506090E141C26303C495765748291A0AEBBC8
D3DDE6EEF3F7FAFAF9F6F1EBE3DACFC3B6A99A8C7D6E605244382C2219120C08050506090E14
1C26313D4A5766748392A1AFBCC9D4DEE7EEF4F8FAFAF8F5F0E9E1D7CCC0B3A59687786A5B4D
4034281F160F0A070505070B1118212B3743515F6D7C8B9AA9B6C3CFDAE3EBF2F6F9FAF9F6F2
EBE3DACFC3B6A89A8B7C6D5E5043362B2018110B070606070B1118212B3643505F6D7C8B9AA9
B7C4D0DAE4ECF2F6F9F9F8F5F0EAE2D8CDC1B3A59788796A5B4D3F33281E160F0A070606090D
131B242F3B485665748392A1AFBDC9D5DFE8EFF4F7F9F9F7F2EDE5DCD1C6B9AB9C8D7E6F6051
44372B2118110C080606080C121A232D394654627181909FADBBC8D4DEE7EEF3F7F9F8F6F2EC
E5DCD1C5B8AA9B8C7D6E5F5043362A2018110B080607090E141C25303C495766758594A3B1BF
CBD7E1E9F0F4F7F8F8F5F0E9E1D7CCBFB2A495857667584A3C30251C140E0A0707080C111821
2C3844526170808F9EADBBC7D3DEE6EEF3F6F8F8F5F1EBE3D9CEC2B4A6978878695A4C3E3227
1D150F0A0807090C1119212C384553617180909FADBBC8D4DEE7EEF3F6F8F7F4F0E9E1D7CCBF
B1A39484756556483B2F241B130D0A08080A0E141C25303D4A5867778696A5B3C1CDD9E2EAF0
F5F7F7F6F2ECE5DCD1C5B7A99A8B7B6C5C4E4033281E16100B0808090D121A232D3946556473
8392A1B0BECBD6E0E9EFF4F6F7F6F2EDE5DCD2C6B8AA9B8C7C6D5D4F4134291F16100B09080A
0D131A232E3A485665758494A3B2BFCCD7E1E9F0F4F6F7F5F1EBE3DACFC2B5A697887868594B
3D31261C140E0B09090B10161E2833404E5C6C7B8B9BAAB8C5D1DCE5ECF2F5F6F5F3EEE7DED4
C8BBAD9E8E7E6F5F5042352A2017110C09090B0E141C25303C4A5968778797A6B5C2CFDAE3EB
F1F4F6F5F3EEE7DFD5C9BCAE9F8F8070605143362A2018110C0A090B0F141C26313D4B5A6979
8898A7B6C3D0DBE4EBF1F4F6F5F2EDE6DDD2C6B9AB9C8C7C6C5D4E4033281E16100C0A0A0C11
171F293542505F6F7F8E9EADBBC8D4DEE7EEF2F5F5F3EFE9E1D8CCC0B2A3948474645546392D
221A130E0B0A0C0F151C26313D4B5A69798999A8B7C4D1DBE4ECF1F4F5F4F0EBE3DACFC2B5A6
9787776758493B2F241B140F0B0A0C0F141C25303D4A5969788898A8B6C4D0DBE4EBF0F3F4F3
F0EAE2D9CEC1B3A59585756556473A2E231A130E0B0B0C10161E2833404E5D6C7C8C9CABBAC7
D3DDE6EDF1F4F4F2EEE7DFD5C9BCAE9F8F7F6F5F5042352A2017110D0B0C0E131A232D394755
64748494A4B3C1CDD9E2EAEFF2F4F3EFEAE2D9CEC1B3A59585756556473A2D231A130F0C0C0E
1218202A36435261718191A1B0BECBD6E0E8EEF2F3F2F0EAE3DACFC3B5A69787776757483B2F
241B140F0D0C0E1218212B36445261718191A1B0BECBD7E0E8EEF1F3F2EFE9E2D9CDC1B3A494
8474645546392D221A130F0D0D0F141A232E3A475666768696A5B4C2CFD9E3EAEFF2F2F1EDE7
DED4C9BBAD9E8E7E6D5E4F4034281F17110E0D0E11171F2834414F5E6E7E8E9EADBCC9D5DFE7
EDF0F2F1EEE9E1D8CDC0B2A3948373635445382C221A130F0D0E11161D26313E4B5A6A7A8A9A
AAB9C6D2DCE5EBEFF1F1EEE9E2D9CEC2B4A5958575655647392D231A14100E0E11161D26313D
4B5A6A7A8A9AAAB9C6D2DCE5EBEFF1F0EEE9E1D8CDC0B2A3948373635445382C221A14100E0F
12171F2834404F5E6E7E8E9EADBCC9D4DEE6ECEFF1EFECE6DED5C9BCAE9E8E7E6E5E4F413428
1F18120F0F10141B232D39475565758595A5B4C2CED9E2E9EEF0F0EEE9E2D9CEC2B4A5958575
655547392D231B15110F101318202A3542505F6F8090A0AFBDCAD6DFE7ECEFF0EEEAE4DBD1C5
B7A999897968594A3C30251D1612101013181F2833404E5E6D7E8E9EADBCC9D4DEE6EBEEEFEE
EAE4DBD1C5B8A999897969594A3C30251D16121010131820293541505F6F7F8F9FAFBDCAD5DF
E6EBEEEFEDE9E2D9CFC3B5A69686766656473A2E241C15121011151B222C38455463748494A4
B3C1CDD8E1E8ECEEEEEBE6DFD6CABDAFA090806F5F5042352A201914111113181E27323F4C5B
6B7C8C9CABBAC7D3DDE4EAEDEEECE8E2DACFC3B5A69786766656483A2E241C16121113161C24
2E3A485766768797A7B6C3CFDAE2E8ECEDECE9E3DBD1C6B8AA9A8A7A695A4B3D31261E171312
13161B232D39465564748595A5B4C2CED8E1E7EBEDECE9E3DCD2C6B9AA9B8A7A6A5A4B3D3127
1E18141213161C242E3A475665768696A6B5C2CED9E1E7EBEDEBE8E2DAD0C4B6A89888776758
493B2F251D17141314181E26313D4B5A697A8A9AAAB8C5D1DBE3E8EBECEAE6DFD7CCBFB1A293
8272625244372C221B161413161B222B36435160708191A1B0BECBD6DEE5EAEBEBE8E3DBD1C6
B8AA9A8A7A6A5A4B3D31271F19151415191F27313E4B5A6A7A8B9BAAB9C6D1DBE3E8EBEBE9E4
DDD4C9BCAE9F8F7F6E5F4F41352A211A161415181D252F3B485766778797A7B6C3CFD9E1E6EA
EBE9E5DED5CBBEB0A1918171615143362B221B171515181D252F3A485666768696A6B5C2CED8
E0E6E9EAE8E4DED5CABEB0A1918070605143362B221C171516191E26303C495868788898A8B6
C4CFD9E1E6E9E9E7E3DCD3C8BBAD9D8D7D6D5D4E403429211B1716171B212933404D5C6C7C8D
9DACBAC7D2DBE2E7E9E9E6E0D9CFC3B6A79888776758493C30261F191716191D242E39465463
738494A4B2C0CCD6DEE4E8E9E7E3DCD4C9BCAE9F8F7F6F5F5042362B221C1817181B212A3440
4E5D6D7D8D9DADBBC7D2DBE2E6E8E7E4DED6CCC0B3A4948474645546392E251E1917181B2028
323D4B5969798999A9B7C4D0D9E0E5E7E7E4DFD8CEC2B5A69787776757493C30271F1A18181B
2027313C4A5868788898A7B6C3CED8DFE4E7E7E4DFD8CEC2B5A79787776757493C3027201B18
191B2128323D4B5969798999A8B7C4CFD8DFE4E6E6E3DED6CCC1B3A59585756555473A2F261F
1B19191D222A34404E5C6C7C8C9CABB9C6D1DAE0E4E6E5E1DCD3C9BDAFA0908070605144372D
241E1A191B1F252E38455362728292A2B0BECAD4DCE2E5E5E3DFD8CFC4B7A99A8A79695A4B3E
3329221D1A1A1D2229333F4C5A6A7A8A9AA9B7C4CFD8DFE3E5E4E1DBD3C9BDAFA09080706152
44382D251F1B1A1C20272F3A475564748494A3B2BFCBD5DCE1E4E4E2DDD5CCC0B3A495857565
56483B3027211D1B1C1F252E38445261708090A0AFBCC8D2DAE0E3E4E2DDD6CDC2B5A7978878
68584A3D3229221E1C1C1F252D3743515F6F7F8F9FADBBC7D1D9DFE2E3E1DDD6CDC2B5A79888
7868594B3E3329231E1C1D20262E384451607080909FAEBBC7D1D9DFE2E3E0DCD5CCC0B3A596
86766657493D3229221E1D1E2127303A465463738393A2B0BEC9D3DADFE2E2DFDAD2C9BDB0A1
9282726354463A3027221E1D1F232A333E4B5968788897A6B4C1CCD5DCE0E1E1DDD7CFC4B8AA
9C8C7C6C5D4F42362D25201E1E21262E3844515F6F7F8F9EADBAC6D0D8DDE0E1DFDAD3CABEB1
A39484746556483C3129231F1E20242B343E4B5968788897A6B4C1CCD4DBDFE0DFDCD5CDC2B6
A8998A7A6A5B4D40352C25211F202329313B475563738392A2B0BDC8D2D9DDE0DFDCD7CFC5B9
AC9D8E7E6E5F5144382F272220202328303945526170808F9FADBAC6D0D7DCDFDFDCD7D0C6BB
AD9F9080706153453A302823212023282F394451606F7F8E9EACB9C5CFD6DBDEDEDCD7CFC6BA
AD9F9080716153463A30292421212429303A455261707F8F9EADBAC5CFD6DBDEDEDBD6CEC4B9
AC9D8E7E6F605145393029242222252A323C485563738292A1AFBCC7D0D7DBDDDDD9D4CCC2B6
A89A8A7B6B5C4F42372E28242223272D353F4B5968778796A5B2BFC9D2D8DCDDDBD7D1C8BDB1
A394857666584A3E342C2723232529303944515F6E7D8D9CAAB7C3CDD4D9DCDCD9D4CDC3B8AB
9C8D7E6F6052453A312A252324272D353F4B5867768595A3B1BDC8D0D6DADCDAD6D0C7BDB0A3
94857566584A3F352D272424262B323B465361707F8F9EACB9C4CDD4D9DBDAD7D2CAC0B4A799
897A6B5C4F423830292624262A303943505E6C7B8B9AA8B5C1CAD2D7DADAD8D3CBC2B7AA9C8D
7D6E5F52453A322B2725262A2F38424E5B6A798897A6B3BFC9D0D6D9D9D7D3CCC3B8AB9D8E7F
706153473C332C2826262A3038424E5B69788796A5B2BEC8D0D5D8D9D7D2CBC2B7AB9D8E7F70
6153473C332C2826272B3038434F5C6A798897A5B2BEC8D0D5D8D8D6D1CAC1B6A99B8C7D6E60
52463B332C2827282C323A45515E6D7C8B99A7B4BFC9D0D5D7D7D5CFC8BEB3A698897A6B5D50
443A322C2828292E343D48546271808F9DABB7C2CBD1D5D7D6D3CDC5BBAFA193847567594C41
37302B29292B3038414D5A67768594A2AFBBC5CDD2D6D6D4D0C9C0B6A99B8D7E6F6154473D34
2E2A292A2E343C4753606E7D8C9AA8B4BFC8CFD4D6D5D2CCC5BBAFA2948576685A4D4239312C
2A2A2D3239424E5A68778594A2AFBBC4CCD1D4D5D3CEC7BEB3A7998B7C6E6052473D342F2B2A
2C30373F4A566472808F9DABB7C1C9CFD3D4D3CFC9C1B6AA9D8F807264564A4037312D2B2C2F
353D4853606E7D8C9AA7B3BEC7CED2D4D3D0CAC2B8ADA092837566594D4239322E2C2C2F353D
46525F6C7B8998A5B2BCC5CCD1D3D2CFCAC3B9AEA1938576685A4E433A332F2D2D30353D4651
5E6C7A8997A4B1BBC4CBD0D2D2CFCAC2B9ADA1938576685B4E443B342F2D2E31363D47525F6D
7B8997A5B1BCC4CBD0D2D1CEC9C1B7AC9F928375675A4E433A34302E2F32373F4954616F7D8B
99A6B2BCC5CBCFD1D0CDC7BFB5A99D8F817265584C423A33302E303339424C576472808E9CA9
B4BEC6CCCFD0CFCBC4BCB2A6998B7D6F615549403833302F31363C454F5C69768593A0ACB7C0
C8CDCFCFCDC8C1B8ADA19486786A5D51463D373230303339404955616E7C8A98A5B1BBC3C9CD
CFCECAC5BDB3A89B8D7F7264574C423A35313132363C454F5B687583919EABB5BFC6CBCECECC
C7C0B7ADA19486786A5D51473E38333132353A424B5662707D8B99A5B1BBC3C9CCCDCCC8C2BA
B0A5988B7D6F62564B423A35333234393F48535E6B798794A1ADB7C0C6CBCDCCC9C4BCB3A89C
8F8173665A4E453D37343334383E46505C687683919EAAB4BDC4C9CCCCC9C4BEB5AA9E918476
695C51473F39353434383D454F5A6674818E9BA8B2BCC3C8CBCBC9C5BEB5AB9F9385786B5E53
49403A363435383E454E596673808D9AA6B1BAC2C7CACAC8C4BEB5ABA09386786B5F5349413B
373536393E464F5A6673808D9AA6B1BAC1C6C9CAC8C3BDB4AA9F9285786B5E5349413B373637
3A3F47505B6774818E9BA7B1BAC1C6C9C9C6C2BBB3A99D908376695D5249413B3836383B4149
525D697683909DA8B2BBC1C6C8C8C5C0B9B0A69A8E8174675B5047403B3837393D434B55616D
7A8793A0ABB4BCC2C6C7C6C3BEB6ADA2968A7D7064584E463F3A38383B3F464F5965717E8B97
A3AEB7BEC3C6C7C5C1BBB3A99E9285786C60554B433E3A393A3D434A535E6A7683909CA7B1B9
C0C4C6C5C3BEB7AEA4988C7F73665B5148413D3A3A3C40474F5964707D8996A1ACB5BCC1C4C5
C4C0BAB2A89E9285796C61564C453F3C3A3B3F444B555F6B7784909CA7B0B8BFC2C4C4C1BCB5
ACA2968A7E71655A5048423D3B3B3E4249525C67737F8C98A3ADB5BCC1C3C3C1BDB7AFA59A8E
8275695E544B443F3D3C3E42484F59646F7C88949FAAB2BABFC2C3C1BEB8B0A79D9185796D61
574E46413E3D3E41474E57626D7985919DA7B0B8BDC1C2C1BEB8B1A89E93877B6F6359504843
3F3E3E41464E56606C77838F9BA5AFB6BCC0C1C0BDB8B2A99F94887C70655A514944403E3F42
474E56606B77838F9AA4ADB5BBBFC0C0BDB8B1A99F94887C71655B524A44413F4043474E5760
6B77838E9AA4ADB5BABEBFBFBCB7B0A89E93887C70655B524B4541404144484F58626C78848F
9AA4ADB4BABDBFBEBBB6AFA69D92867B6F645A524A45424142454A515A636E7A85919CA5AEB5
BABDBEBDB9B4ADA49A8F84796D6359514A45424243474C535C66717C88939DA7AFB5BABDBDBB
B7B2AAA1978C81766B60574F4945434345494F565F6974808B96A0A9B0B6BABCBCBAB5AFA79E
94897D72675E554E48454344474B525A636E78848F99A3ABB2B7BABBBAB7B2ABA39A8F84796E
645A524C47454446494E555E68727D88939DA6AEB4B8BABAB8B5AFA79F958A7F74696057504A
474545484C525A636D78838E98A1AAB0B5B9BAB9B6B1AAA2998F84796F655B544D494646474B
50575F69737E89939DA6ADB3B7B9B9B7B3ADA59D93887E73695F57504B4847474A4F555D6670
7A858F99A2AAB0B5B7B8B7B3AEA79F968C81776C635A534D4A48484A4E535B636D77828C969F
A7AEB3B6B7B6B4AFA9A1988E847A6F665D554F4B49484A4D5259616B757F89939DA5ACB1B5B6
B6B4AFAAA29A90867C72685F57514D4A494A4D52596069737D88919BA3AAB0B3B5B5B3AFAAA3
9B91877D736A6159534E4B4A4B4E52586069727C869099A2A9AEB2B4B4B3AFAAA39B92887E74
6B625A544F4C4B4C4E53596069727C869099A1A8ADB1B3B4B2AEA9A39B92887E746B625B5450
4D4C4C4F53596169727C868F98A1A7ADB1B3B3B1ADA8A29A91877E746B625B55504E4D4D5055
5A626A737D879099A1A7ACB0B2B2B0ACA7A09890867D736A625B55514E4D4F51565C636C757E
88919AA1A7ACB0B1B1AFABA59E978E847B7269615A55514F4E5053585E656E77808A939BA2A8
ACAFB0B0ADA9A39C948B82797067605954514F4F51555A6068707A838C949CA3A9ADAFAFAEAB
A7A19991897F766E655E585451505153575C636B747D868E979EA4A9ADAEAEACA9A49E968E85
7C736B635D5754515152555A60676F7780899199A0A6AAADAEADAAA6A19A938A81797068615B
5653525254585D636A737B848D959CA2A7ABACADABA8A39D968E867D756C655F595653535457
5B60676F77808890989FA4A8ABACABA9A5A099928A81797069625C5855545456595E656C747C
848D949BA1A6A9ABABA9A6A19B958D857C746C655F5A57555556595D63697179818991989FA4
A7AAAAA9A6A29D978F877F776F68625C59565556585C61686F777F878F969CA2A6A8A9A9A7A3
9E9891898179726A645E5A585657595C61666D757D858C949AA0A4A7A8A8A6A39F99928B837B
746C66605C595757595C60666C737B838B92989EA2A5A7A7A6A39F9A938C857D756E67625D5A
5858595C60656C737A828990979DA1A4A6A6A5A39F9A948D857E766F69635E5B59595A5D6065
6B727981888F969BA0A3A5A6A5A29E99948D867E77706A645F5C5A5A5B5D61666C727981888F
959B9FA2A4A5A4A19E99938D867E77706A65605D5B5B5C5E62666C737A81888F959A9EA2A3A4
A3A09D98928C857E77706A65615E5C5C5D5F63676D737A81888F959A9EA1A3A3A29F9C97918B
847D77706A65615E5D5D5E6064696E747B82898F959A9EA0A2A2A19E9A96908A837C76706A65
615F5E5E5F62656A70767C838A90959A9EA0A1A19F9D99948E88827B756F6965625F5E5F6063
676C71787E858B91969A9D9FA0A09E9B97928D86807A736E696562605F606265696E747A8086
8C92979B9D9F9F9F9C9995908A847E78726D68646260606163676B70767C82888E93979B9D9E
9E9D9B97938E88827C76706B67646261616365696D73787E848A9094989B9D9E9D9B9995908B
857F79746F6A666462626365686B70757B81878C9195999B9D9D9C9996928D88827D77726D69
6664636364676A6E73787E84898E9397999B9C9B9A97948F8A857F7A74706B68656464646669
6D71767C81878C9094989A9B9B9A9895918C87827C77726E6A6765646566686C70747A7F8489
8E9296989A9A999895928E89847E7974706C6967666566686B6F73787D82878C909497989999
9895928E8A85807B76726E6A68676667686B6E72777C81868A8F92959798989795938F8B8681
7C78736F6C69686767696B6E72767B7F84898D91949697979795938F8C87827E7975716D6B69
6868696B6E71757A7E83888C90939596979695938F8C88837F7A76726E6C6A69696A6B6E7175
797E82878B8F929495969594928F8C88847F7B77736F6D6B6A6A6A6C6E7175797D82868A8E91
9394959594928F8C8884807B7773706E6C6B6A6B6D6F7275797D8186898D909293949493918F
8B8884807C7874716E6D6C6B6C6D6F7276797D8185898C8F9193939392908E8B8784807C7874
716F6D6C6C6D6E7073767A7E8185898C8F9192929291908D8A87837F7C787572706E6D6D6E6F
7174777A7E8285898C8E90919291908F8C8986837F7B787572706F6E6E6E707275787B7E8286
898C8E909191918F8E8B8985827E7B787572706F6F6F6F717376787C7F8386898B8E8F909090
8E8D8A8884817E7B77757371706F7070727477797D808386898B8D8F8F8F8F8D8C898683807D
7A77757371707070717375787B7E818487898B8D8E8F8E8E8C8A8885827F7C79777573727171
71737476797C7F828487898B8D8E8E8D8D8B898784817E7C79777573727272727476787A7D80
8385888A8B8C8D8D8C8B8A888583807D7B78767473727273747577797B7E818386888A8B8C8C
8C8B8A888684827F7C7A787674747373747576787A7D7F828486888A8B8C8C8B8A8987858380
7E7B797776757474747576787A7C7E81838587898A8B8B8B8A89888684817F7D7B7977767574
74757677797B7D7F82848687898A8A8A8A8988868482807E7C7A7877767575757677797B7C7F
818385868889898A898988868583817F7D7B7978777676767677797A7C7E8082848587888989
898888868583817F7E7C7A79787776767778797A7C7D7F818384868788888888878685838280
7E7C7B7A787877777778797A7B7D7F8082848586878888888786858482807F7D7C7A79787878
7878797A7B7D7E8082838486868787878786858482817F7E7C7B7A7978787879797A7B7D7E80
81838485868687868686858482817F7E7D7B7A7A797979797A7B7C7D7E7F8182838485868686
868584838281807E7D7C7B7A7A79797A7A7B7C7D7E7F8182838485858585858584838281807F
7D7C7B7B7A7A7A7A7A7B7C7D7E7F8082838384858585858484838281807F7E7D7C7B7B7A7A7A
7B7B7C7D7E7F8081828384848484848483838281807F7E7D7C7B7B7B7B7B7B7C7D7D7E7F8081
828383848484848383828181807F7E7D7C7C7B7B7B7B7C7C7D7E7E7F80818282838384848383
83828180807F7E7D7D7C7C7C7C7C7C7D7D7E7F7F8081828283838383838382828180807F7E7D
7D7C7C7C7C7C7D7D7E7E7F8080818182828383838382828181807F7F7E7E7D7D7D7C7C7D7D7D
7E7E7F8080818182828282828282828180807F7F7E7E7D7D7D7D7D7D7D7E7E7F7F8080818182
828282828282818180807F7F7E7E7E7D7D7D7D7D7E7E7E7F7F80808181818282828281818180
80807F7F7E7E7E7E7D7D7E7E7E7E7F7F7F80808181818181818181818180807F7F7F7E7E7E7E
7E7E7E7E7E7F7F7F8080808181818181818181818080807F7F7F7E7E7E7E7E7E7E7E7F7F7F7F
8080808181818181818181808080807F7F7F7F7E7E7E7E7E7E7F7F7F7F808080808081818181
8181808080807F7F7F7F7F7E7E7E7E7E7F7F7F7F7F8080808080808181808080808080807F7F
7F7F7F7F7F7F7F7F7F7F7F7F8080808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F
7F7F7F7F8080808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F8080808080
808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F80808080808080808080808080
807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F8080808080808080808080808080807F7F7F7F7F7F7F
7F7F7F7F7F7F7F7F80808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F80
808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F80808080808080808080
80808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F8080808080808080808080808080807F7F7F7F
7F7F7F7F7F7F7F7F7F7F8080808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F
7F7F80808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F80808080808080
808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F80808080808080808080808080807F7F
7F7F7F7F7F7F7F7F7F7F7F7F7F80808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F
7F7F7F7F80808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F8080808080
8080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F8080808080808080808080808080
7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F80808080808080808080808080807F7F7F7F7F7F7F7F7F
7F7F7F7F7F8080808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F80808080
80808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F80808080808080808080808080
807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F80808080808080808080808080807F7F7F7F7F7F7F7F
7F7F7F7F7F7F7F80808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F808080
8080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F808080808080808080808080
80807F7F7F7F7F7F7F7F7F7F7F7F7F7F80808080808080808080808080808080808080808080
8080808080808080808080808080808080808080808080808080808080808080808080808080
8080808080808080808080808080808080808080808080808080808080808080808080808080
8080808080808080808080808080808080808080808080808080808080808080808080808080
80808080808080808080808080
pop
% End of sampled sound
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{281, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40n007h00Oo`008@0000000`00
occo?02Ooca8000eoc`100000003003o??ll07go?003003o?00000800004oc`00000oc`200001_ll
00000000oc`000Ko?64002Oo?040000000<00?lloc`0<oll00D00?ll00000?ll00H00003oc`00000
00@00003oc`0000000L00003oc`0000003`00005oc`00?ll003o?01]000Loc`100000003003o??ll
00;o?0<00004oc`00000oc`200000oll0000003o000=0002oc`100000003003o??ll0?l001h00000
00<00?ll0000o`0070000Oll0@0000000`00occo?00Yoc`500000oll0000000700000oll0000001C
00000oll0000001a000Joc`100000003003o??ll05_o?0800005oc`00000003o?00200001?ll0000
0?ll0`0000Co?000003o?0H00004oc`00000oc`600000oll0000000400001?ll00000?ll0`001?ll
IP009Oll0@0000000`00occo?02Koca@000aoc`100000003003o??ll0:oo?2L004Ko?040000000<0
0?lloc`0ooll7Oll0@0000000`00occo?03ooc`Moc`100000003003o??ll0?oo?1go?040000000<0
0?lloc`0ooll7Oll0@0000000`00occo?03ooc`Moc`100000003003o??ll0?oo?1go?040000000<0
0?lloc`0ooll7Oll0@0000000`00occo?03ooc`Loc`200000003003o??ll0?oo?1_o?040007o?040
000000<00?lloc`0ooll7Oll0@00003o000Q00000003003o??ll07So?0800003oc`0000000@00004
oc`00000oc`600000oll00000002oc`01@00oc`00000oc`04000Moll0@0000000`00occo?01boc`0
0`00oc`0000I00000oll0000000I001boc`100000003003o??ll06oo?003003o?00000L00003oc`0
000000@00004oc`00000oc`600001Oll00000000oc`07P00Koll0@0000000`00occo?01[oc`<0000
0oll0000000700001?ll00000?ll1P0000Co?000occo?0X00003oc`0000000<00003oc`000000100
06[o?040000000<00?lloc`0Ioll0P0000?o?00000003P0000?o?00000004@0000?o?00000009000
Ioll0@0000000`00occo?01Uoc`:00001Oll00000000oc`00P0000Co?000003o?0H00004oc`00000
oc`600000oll00000002oc`@00000oll0000000300001Oll003o?000oc`03@00IOll0@0000000`00
occo?01Qoc`00`00oc`0000<00000oll003o?00<00000oll003o?00200000oll0000000400001?ll
00000?ll1`0000[o?000003o?000oc`00?ll003o?0H00005oc`00000003o?00200000oll0000000;
001Qoc`100000003003o??ll05ko?003003o?00001T00003oc`0000000<00004oc`00000oc`60000
0oll00000002oc`600000oll0000000200001oll00000000oc`00?ll01d005ko?040000000<00?ll
oc`0GOll200000Co?000003o?0H00004oc`00000oc`600000oll000000030007oc`500001?ll0000
0?ll1@0000?o?000oc`00P0000?o?00000000`0000?o?000oc`00`0000?o?000oc`0200000Go?000
00000?ll00X005go?040000000<00?lloc`0F_ll3`0000Go?00000000?ll00800003oc`0000000@0
00;o?003003o?00000D00004oc`00000oc`500000oll00000002oc`01P00oc`00?ll003o?0<000;o
?003003o?00000?o?0@00003oc`00?ll00<00004oc`00000oc`300000oll003o?00>001Joc`10000
0003003o??ll05Wo?0l00003oc`0000000@00003oc`0000000h00005oc`00000oc`00003oc`30000
0oll00000002oc`01000oc`00?ll0`0000Co?000003o?0P00003oc`0000000@00003oc`0000001L0
05So?040000000<00?lloc`0Eoll2P0000Go?00000000?ll00L000;o?003003o?00000L000Ko?080
0003oc`0000000H00003oc`0000000;o?008003o?000oc`00?ll003o?0800003oc`0000000<00004
oc`00?lloc`30002oc`00`00oc`0000700000oll0000000200000oll0000000<001Foc`100000003
003o??ll05Co?003003o?00000P00005oc`00000003o?0040003oc`400000oll003o?004oc`40000
0oll0000000300000oll000000040009oc`01@00oc`00000oc`00`000_ll00<00?ll00001?ll1000
00Co?000003o?0H000;o?0<00003oc`0000000T00003oc`0000000D005Co?040000000<00?lloc`0
D_ll300000?o?0000000100000Go?00000000?ll00@00003oc`00?ll00P00003oc`00000008000Go
?0P00004oc`00000oc`800001?ll00000?ll0P0000?o?000oc`0100000?o?00000000`0000Co?000
003o?0X00004oc`00000oc`300000oll00000008001Boc`100000003003o??ll057o?0`00003oc`0
000000<00003oc`0000000800004oc`00?lloc`300000oll000000030007oc`>00000oll00000002
oc`200001_ll00000?ll003o?0800003oc`0000000800006oc`00?lloc`00?ll1@000_ll300000?o
?000oc`0100000?o?00000002P00DOll0@0000000`00occo?01?oc`600001_ll00000?ll003o?0<0
00?o?0@000?o?003003o?00000<000Go?0L00003oc`0000000D000go?004003o??ll0002oc`20000
1?ll003o??ll1@0000?o?000oc`00P001?ll0`0000?o?0000000100000?o?00000000_ll100000Go
?00000000?ll00<00003oc`0000000L004ko?040000000<00?lloc`0COll2P0000?o?00000001@00
00Go?00000000?ll00@00003oc`0000000?o?0800003oc`0000000H00003oc`00?ll00Oo?0P00005
oc`00000003o?00200001?ll00000?ll0`0000?o?00000000`0000?o?00000002@0000[o?000003o
?000oc`00?ll003o?0T00003oc`00?ll00h004go?040000000<00?lloc`0B_ll00<00?ll00001`00
00?o?00000001`0000?o?00000001P0000?o?00000001@0000?o?00000001Oll0`0000?o?0000000
3@0000?o?00000000_ll0P0000So?000003o?000oc`00?ll100000?o?000oc`01`0000?o?0000000
0`0000Go?00000000?ll00@00003oc`00?ll008000;o?0800003oc`0000000l004_o?040000000<0
0?lloc`0BOll2P0000Go?00000000?ll00@000;o?0D000?o?0L000Ko?0H00003oc`0000000H000co
?080000:oc`00000oc`00?ll003o?000oc`60002oc`01@00occo?000oc`00`001?ll00<00?lloc`0
0P0000?o?000oc`00`000oll00<00?ll00001@0000?o?00000000P0000?o?00000001P00B_ll0@00
00000`00occo?019oc`;0002oc`30002oc`30004oc`50005oc`400000oll00000003000@oc`50000
2?ll00000?ll003o?000oc`200000oll00000003oc`500001_ll003o??ll003o?08000?o?0T000;o
?003003o??ll00<00003oc`0000000800005oc`00?ll003o?00>0018oc`100000003003o??ll04Ko
?003003o?00001@00003oc`00?ll00D000;o?0P00003oc`0000000Ko?0800003oc`0000000d00008
oc`00000oc`00?ll003o?0800006oc`00?lloc`00?ll0P0000Go?000003o?00000;o?0<000?o?0<0
0003oc`0000000<000;o?0800003oc`0000000<00009oc`00000003o?000oc`00?ll00D00003oc`0
000000T004Ko?040000000<00?lloc`0AOll1@0000?o?00000000_ll00<00?ll00000P000_ll1000
0oll00@00?ll000000Co?0H000So?0H00003oc`0000000T000[o?004003o?0000002oc`01000oc`0
0?ll0P0000?o?000oc`01?ll0`000oll00D00?ll003o?00000;o?005003o??lloc`00002oc`00`00
oc`0000600000oll0000000500000oll003o?00200000oll000000080015oc`100000003003o??ll
04Go?0X00004oc`00000oc`40002oc`40004oc`60006oc`300000oll00000004000Goc`01000oc`0
00000_ll00<00?ll00000P000_ll0P000oll0P0000Co?000occo?0800005oc`00000003o?0020002
oc`300000oll0000000200001Oll003o??ll00000_ll1@0000?o?00000001`0000?o?00000001P00
A?ll0@0000000`00occo?012oc`<00000oll003o?00300000oll0000000500001?ll00000?ll1000
0oll200000?o?00000002_ll3`0000Co?000003o?0800005oc`00000003o?0020002oc`700001?ll
003o??ll1@000_ll00<00?ll00000P0000?o?00000000P0000Co?000oc`000;o?003003o?0000080
0004oc`00000oc`900001?ll00000?ll1`00@oll0@0000000`00occo?011oc`:00001Oll003o?000
oc`00`0000?o?00000000P000oll0`0000?o?000oc`01?ll1`002_ll500000Go?000003o?00000;o
?0<00003oc`00?ll00Co?0D000Co?003003o?000008000Co?08000;o?0800003oc`00?ll00<000;o
?004003o?000oc`400001?ll003o??ll0`000_ll00<00?ll00000`0000?o?00000001P00@Oll0@00
00000`00occo?010oc`900002?ll00000?ll003o?000oc`30003oc`50004oc`70007oc`=000Eoc`2
0003oc`00`00occo?00400000oll00000002oc`00`00oc`00002oc`00`00occo?002oc`200000oll
0000000200000oll003o?0020002oc`30003oc`01000occo?0000_ll0`0000Go?000oc`00?ll00L0
0003oc`0000000D0043o?040000000<00?lloc`0?oll3P0000?o?00000000`0000?o?000oc`01000
0oll1`001?ll3@003_ll200000Co?000003o?0800004oc`000000002oc`400000oll003o?002oc`0
1000oc`00?ll0P000oll0`0000?o?00000000P0000?o?000oc`00P0000?o?00000000`0000Oo?000
00000?ll003o?00400000oll003o?00200001?ll00000?ll0`0000?o?00000002000?_ll0@000000
0`00occo?00noc`500000oll0000000300000oll00000002oc`20003oc`01000oc`000000oll1000
00?o?000oc`01?ll2@003Oll3`0000Go?000003o?00000;o?0<000;o?003003o?00000;o?003003o
??ll00?o?0@000?o?005003o?000oc`00002oc`01000oc`00?ll0P0000Co?000occo?0800005oc`0
0000003o?0050003oc`300000oll000000030002oc`200001?ll00000?ll1P00?Oll0@0000000`00
occo?00loc`>0002oc`300001?ll000000001?ll1@001Oll1P002_ll4P003?ll10000_ll00<00?ll
00000_ll00<00?ll00001`000_ll0P0000co?00000000?ll003o?000oc`00?ll0002oc`00`00oc`0
0002oc`00`00occo?002oc`300000oll003o?00300000oll0000000200001?ll003o??ll0`0000?o
?00000000P0000?o?00000000`00??ll0@0000000`00occo?00koc`C00001?ll000000000_ll1P00
0oll0P0000?o?00000000P001_ll40005?ll0`0000Go?000occo?00000Go?0D000;o?003003o??ll
00800005oc`00000003o?00300001?ll003o?0000_ll100000Oo?000occo?000oc`00002oc`60000
1_ll00000?ll003o?0H00006oc`00000oc`00?ll1`00>oll0@0000000`00occo?00joc`500001?ll
000000000_ll00<00?lloc`00`0000Co?000000000Co?0<000Co?0@00003oc`00?ll00Ko?0X001_o
?08000;o?0800003oc`0000000;o?0800004oc`00000oc`30004oc`00`00occo?0030002oc`01`00
occo?000oc`00?ll00<00004oc`00?ll0002oc`01000occo??ll1@000oll0P000_ll1@0000?o?000
oc`00P0000?o?00000002@00>_ll0@0000000`00occo?00ioc`400000oll0000000200001?ll0000
0?ll0P000_ll0`000_ll10001?ll1@001Oll20003_ll5P000_ll00<00?ll00000`0000?o?0000000
0`0000Co?000oc`000;o?003003o?00000;o?08000Ko?006003o??lloc`00?ll1P000_ll00<00?ll
00000P0000?o?000oc`00_ll0P0000Go?000oc`00?ll008000;o?003003o??ll00@00003oc`00000
00P003Wo?040000000<00?lloc`0>?ll300000?o?00000001@0000?o?00000000`0000?o?0000000
10001?ll0P0000?o?000000010002?ll7@000oll00@00?ll003o?0800003oc`00000008000;o?080
00?o?004003o?000oc`20003oc`00`00oc`0000600002?ll00000?ll003o?000oc`200001_ll0000
0000oc`000?o?0L000;o?003003o?00000;o?08000?o?0d003Oo?040000000<00?lloc`0=_ll3`00
00Go?00000000?ll00@000;o?0H000;o?0H00003oc`0000000Ko?0l001Wo?0<000?o?003003o??ll
00;o?0D00003oc`0000000@000;o?005003o?000003o?00400000oll003o?00200000oll003o?003
00001oll00000000oc`00?ll00@00005oc`00000003o?00500001Oll00000000oc`01@0000?o?000
00002000=_ll0@0000000`00occo?00eoc`;00000oll00000002oc`01000occo??ll0`000_ll1000
1Oll1@002?ll2@005oll300000?o?000oc`00P001_ll0`0000?o?0000000100000Co?000003o?080
0008oc`00?lloc`00?ll003o?0800004oc`00?lloc`200001Oll00000000oc`010000_ll0`000_ll
0`0000?o?000oc`00`0000Co?000003o?0800003oc`0000000X003Go?040000000<00?lloc`0=Oll
300000Go?00000000?ll00<000?o?0<000Co?0@000Oo?0P000oo?1P000;o?0800004oc`00?ll0002
oc`200000oll00000002oc`20003oc`01`00oc`00000oc`00?ll00800008oc`00?ll003o?000oc`0
00;o?006003o?000003o?0001?ll0`0000?o?00000000`0000?o?000oc`00`0000?o?00000001000
00Co?000003o?0H00003oc`0000000D003Co?040000000<00?lloc`0=?ll3`000_ll0`0000?o?000
00000P000oll1P001?ll2@002?ll60002oll00@00?ll003o?08000;o?0D000;o?0<00004oc`00000
oc`200000oll0000000200001oll00000000oc`00?ll00800003oc`0000000800007oc`00?lloc`0
0?ll00000oll1@0000Ko?000003o?000oc`500000oll003o?00200000oll0000000>000coc`10000
0003003o??ll03;o?0L00003oc`0000000800005oc`00000003o?0020002oc`40003oc`40005oc`6
000:oc`=000Koc`00`00oc`00003oc`01000oc`000000oll00D00?ll003o?00000;o?0800005oc`0
0000oc`00002oc`01@00occo?000oc`00P0000Go?000003o?00000Co?003003o??ll00?o?0<000?o
?0800003oc`0000000800004oc`00?lloc`30002oc`:00000oll00000004000coc`100000003003o
??ll037o?0T00003oc`00?ll008000;o?08000;o?0<000Co?0<000Co?0H000So?0T001[o?0X00003
oc`0000000;o?08000Ko?003003o??ll00So?003003o??ll00Go?003003o??ll00;o?0<00004oc`0
0?ll0002oc`01000oc`00?ll0P001?ll100000?o?000oc`01?ll00@00?ll000000Co?0@00005oc`0
0000003o?008000boc`100000003003o??ll037o?0X00004oc`00000oc`300001?ll000000000oll
10000oll1`001?ll30003?ll6P0000So?000oc`00?ll003o?0000_ll00D00?lloc`00?ll008000;o
?0<00003oc`0000000?o?003003o?00000@00003oc`0000000T00004oc`00?ll0002oc`00`00occo
?0060003oc`00`00oc`00003oc`00`00oc`0000200000oll003o?00@000`oc`100000003003o??ll
02oo?0H00003oc`0000000800003oc`00?ll00<000;o?003003o?00000;o?0@000?o?0D000Ko?0L0
00ko?1D000co?005003o?000oc`00002oc`30002oc`200000oll0000000200000oll00000003oc`0
1@00oc`00000oc`00P0000Go?000oc`00?ll00<00005oc`00000oc`00002oc`01000occo?0000_ll
0`0000Ko?000occo?000oc`:00001?ll00000?ll1@000oll2@00<?ll0@0000000`00occo?00^oc`:
00001?ll00000?ll0P0000Co?000000000?o?0<000?o?0@000Go?0H000_o?0d001go?003003o?000
00Co?0800005oc`00000003o?0030002oc`20002oc`200001Oll00000?ll00000_ll100000Go?000
occo?00000;o?0800003oc`0000000;o?004003o?0000003oc`300001?ll00000?ll1@0000?o?000
00000P000oll00D00?ll00000?ll00800003oc`0000000L002oo?040000000<00?lloc`0;_ll2@00
00?o?00000000P0000?o?00000000P0000?o?00000000P0000?o?000000010000oll20001oll3P00
7?ll1P0000Oo?000occo?000oc`00002oc`30002oc`30002oc`00`00occo?00200000oll003o?002
0003oc`01000oc`00?ll0P0000Co?000occo?0D00003oc`0000000800003oc`00?ll00<000;o?005
003o?000003o?00600000oll003o?00300001?ll00000?ll0P0000?o?00000002P00;Oll0@000000
0`00occo?00]oc`800001?ll00000?ll0P0000Go?00000000?ll00@000;o?0@000Co?0D000Wo?0P0
01Ko?1<000;o?006003o??ll003o?0000_ll00<00?lloc`00_ll00<00?ll00000_ll00D00?llocco
?00000;o?0<000;o?08000;o?0<000Co?0D00003oc`00?ll00800005oc`00000003o?00200001?ll
003o?0000_ll0P0000?o?000oc`00_ll00<00?ll00000P0000?o?00000000`0000?o?00000002`00
;Oll0@0000000`00occo?00/oc`700001_ll00000000oc`000;o?003003o??ll00<000;o?0<000Go
?0D000Ko?0P000oo?1/000Ko?003003o??ll00800003oc`00?ll00Go?003003o??ll00;o?005003o
??lloc`00002oc`400000oll00000002oc`200000oll003o?0040004oc`01000occo?0000_ll1@00
00Ko?000003o?000oc`200001?ll003o??ll0P001Oll100000Go?00000000?ll00`002co?0400000
00<00?lloc`0:oll400000Co?000000000;o?0@000;o?0H000Co?0X000Wo?1H001Ko?0800004oc`0
0?lloc`300000oll003o?0020005oc`00`00occo?00200001_ll003o??ll003o?0<00003oc`00?ll
00800003oc`00?ll00?o?004003o??ll0002oc`30003oc`200000oll0000000200001?ll00000?ll
0P001?ll0P0000?o?000oc`00P000oll3`00:_ll0@0000000`00occo?00Zoc`@00000oll00000002
oc`30004oc`40006oc`6000:oc`<000Soc`00`00occo?003oc`30003oc`200001_ll003o?000oc`0
00;o?003003o??ll00Go?08000;o?009003o?000oc`00?ll003o?00000Ko?08000Go?005003o?000
oc`00004oc`00`00occo?003oc`90002oc`200001?ll00000?ll2`00:_ll0@0000000`00occo?00Z
oc`80002oc`400000oll00000002oc`30003oc`30006oc`4000:oc`9000Koc`A0003oc`200001?ll
003o??ll100000?o?00000001`000oll00D00?ll00000?ll00800004oc`00000oc`60002oc`01@00
oc`00000oc`00P000oll00<00?ll00000P001Oll00@00?llocco?0<00004oc`00000oc`200000oll
0000000;00000oll00000005000Yoc`100000003003o??ll02So?1800003oc`0000000800003oc`0
000000<000;o?0P000Go?0/000ko?20000?o?0<00004oc`00?lloc`40002oc`80002oc`200001?ll
00000?ll0P0000?o?000oc`00`0000Go?000oc`00?ll00800004oc`00000oc`20002oc`50002oc`0
0`00oc`0000;00000oll003o?00;00000oll0000000:000Xoc`100000003003o??ll02Oo?1D00003
oc`0000000<000;o?0L000?o?0/000[o?1X001;o?08000;o?003003o??ll00Go?0800003oc`00000
00;o?004003o??lloc`200001?ll00000?ll0P0000?o?00000000P000_ll00@00?llocco?08000;o
?08000;o?003003o?00000<00005oc`00?ll003o?00200000oll0000000500000oll003o?0080000
0oll0000000A000Woc`100000003003o??ll02Ko?0P00005oc`00000003o?0020002oc`30002oc`3
0003oc`40006oc`7000<oc`=000Roc`00`00occo?006oc`00`00occo?0020002oc`01000occo?000
0oll00<00?lloc`00P0000?o?000oc`00_ll00<00?ll00000_ll00@00?lloc`000;o?0@00003oc`0
000000;o?00:003o??lloc`00?ll003o?000oc`20002oc`400000oll003o?00300000oll003o?002
00001?ll00000?ll0`000_ll00<00?ll00002P009_ll0@0000000`00occo?00Uoc`?00001Oll0000
0000oc`00`000oll1@001?ll1@002_ll2`00;Oll0P0000Co?000003o?0@000Oo?004003o??lloc`2
0002oc`00`00oc`00002oc`01P00oc`00?ll003o?0800004oc`00?lloc`60002oc`200002Oll003o
?000oc`00?ll003o?00200001Oll00000?ll00002?ll00<00?ll00000`000_ll200000?o?0000000
2@009Oll0@0000000`00occo?00Toc`>00000oll0000000600000oll000000040002oc`80005oc`=
000Aoc`Q00001?ll00000?ll1`0000?o?00000001Oll0P0000?o?00000000`0000Go?000oc`00?ll
00@00004oc`00000oc`50003oc`200001Oll00000000oc`0100000?o?000oc`00P0000Co?000occo
?08000?o?0<00004oc`000000002oc`00`00oc`0000C000Toc`100000003003o??ll02Co?0X00004
oc`00000oc`200001?ll000000000oll10000oll1@001oll20004_ll9@000oll00D00?llocco?000
00;o?0<00004oc`00000oc`300001?ll003o??ll0`0000?o?000oc`01Oll00@00?ll003o?0D000Co
?003003o?00000?o?0L000;o?0<00004oc`00?lloc`20003oc`300000oll00000003oc`400000oll
003o?00@000Toc`100000003003o??ll02?o?0X00006oc`00000oc`00?ll0`000_ll0`001?ll1@00
1Oll1`003Oll4@008Oll0P000_ll00<00?lloc`01?ll00<00?lloc`02@002?ll0P0000So?000oc`0
0?ll003o?0001?ll00<00?lloc`00oll0`000oll00@00?lloc`000Go?005003o??ll003o?0040000
0oll0000000500000oll0000000D000Soc`100000003003o??ll02;o?1P00003oc`0000000D000;o
?0X000Oo?18002Oo?0800004oc`000000003oc`00`00occo?002oc`90003oc`200000oll00000002
0003oc`00`00oc`00002oc`00`00oc`00002oc`01000oc`00?ll0P001Oll00@00?ll000000Go?005
003o??ll003o?0040003oc`500000oll0000000600000oll0000000=000Roc`100000003003o??ll
027o?0L00003oc`0000000L000;o?0<000?o?0@000Co?0H000Wo?0`002Ko?0/000;o?0<000?o?003
003o??ll00;o?08000?o?004003o?0000003oc`200001?ll00000?ll0`0000Go?000oc`00?ll00D0
0008oc`00?ll003o?000oc`000Co?004003o?0000004oc`40002oc`40003oc`500001?ll00000?ll
0`000oll00<00?ll00000P0000?o?00000002@008Oll0@0000000`00occo?00Poc`=00001Oll0000
0000oc`00`0000?o?00000000`000oll1P001oll2@005Oll90000_ll00<00?lloc`00oll00H00?ll
00000?ll0004oc`00`00oc`00004oc`200000oll00000002oc`200002oll003o?000oc`00?ll003o
?000oc`00P000_ll00<00?ll00001?ll10000_ll00<00?ll00000`0000Ko?000003o?000oc`90000
1?ll003o??ll400000?o?00000001@008?ll0@0000000`00occo?00Poc`I0002oc`70003oc`;000=
oc`V000;oc`00`00oc`00003oc`00`00oc`000030002oc`20002oc`01000occo??ll0`0000Ko?000
oc`00?ll0002oc`30003oc`01000occo??ll0P000_ll0P000_ll00<00?lloc`00`0000Go?000oc`0
0?ll00800003oc`00?ll00@00003oc`0000000<00006oc`00000003o?0000_ll6P007oll0@000000
0`00occo?00Ooc`;00001?ll00000?ll0`0000Co?000000000?o?0D000Go?0P000go?18002Ko?005
003o??lloc`00003oc`200001?ll000000001_ll0P000_ll00<00?ll00000P000oll00<00?lloc`0
0_ll00@00?lloc`000;o?0@000;o?004003o??ll0003oc`01P00oc`00?ll003o?0800004oc`00?ll
0005oc`01000occo?0000_ll0P001?ll2@0000?o?00000001P0000?o?000000010007oll0@000000
0`00occo?00Noc`;00000oll000000020002oc`30002oc`50003oc`7000:oc`>000coc`00`00oc`0
00020005oc`20003oc`300000oll003o?002oc`50002oc`00`00occo?00200001Oll00000?ll0000
0_ll0P0000Ko?000003o?000oc`200001_ll003o?000oc`000;o?0<00003oc`0000000?o?08000Co
?0800003oc`0000000;o?0H00005oc`00000003o?0030002oc`=000Noc`100000003003o??ll01go
?1@00003oc`0000000@00003oc`0000000L000Co?10001So?2400004oc`000000002oc`30005oc`6
00000oll0000000200001Oll003o??ll00000_ll1@0000Co?000003o?0800006oc`00000oc`00?ll
0P0000Go?00000000?ll00800005oc`00?ll003o?00400001?ll000000000oll0P0000Co?000003o
?0<00003oc`0000000D00003oc`0000000800003oc`0000000d001go?040000000<00?lloc`07?ll
4`000_ll0`000oll1@001oll2`005_ll:@000_ll00<00?lloc`00_ll10001?ll1P0000Co?000oc`0
00[o?004003o?000oc`500000oll003o?003oc`20002oc`200001?ll00000?ll0P0000Co?000003o
?08000;o?08000;o?0<00006oc`00000oc`00?ll100000?o?00000000oll2@0000?o?00000002P00
7?ll0@0000000`00occo?00Koc`;00000oll0000000300000oll000000020002oc`50005oc`9000?
oc`I000Qoc`00`00oc`00002oc`01@00oc`00?ll00000_ll00<00?lloc`00_ll00<00?ll00000P00
1?ll00<00?ll00000_ll0P0000?o?000oc`00_ll00<00?ll00001Oll00<00?ll00000_ll0P0000Co
?000occo?0800003oc`0000000Co?008003o??ll003o?000oc`000Co?005003o?000003o?0020000
1?ll00000?ll2@0000Ko?000003o?000oc`:000Koc`100000003003o??ll01[o?1`000;o?0X000So
?1T002_o?004003o?000oc`20003oc`40004oc`00`00occo?0020002oc`300000oll000000040003
oc`300001?ll003o?0000_ll00@00?llocco?0<00004oc`00?lloc`300000oll003o?003oc`01@00
occo?000oc`010000oll100000Co?000003o?0800003oc`0000000800003oc`0000000800003oc`0
000000l001[o?040000000<00?lloc`06Oll90001?ll4`00:_ll400000?o?00000000`000oll0P00
00?o?00000000P000oll00@00?llocco?0<00005oc`00000003o?00200000oll0000000800001?ll
00000?ll0P0000?o?000oc`00oll1@000oll4`000_ll0P0000?o?00000001@0000?o?000oc`04`00
6Oll0@0000000`00occo?00Ioc`@00000oll000000020003oc`60006oc`<000Ooc`U00000oll0000
0002oc`01@00occo??ll00000_ll10000oll00@00?llocco?08000;o?005003o?000oc`00002oc`2
00002?ll003o?000oc`00?ll0002oc`01P00oc`00000oc`000Co?004003o?0000002oc`;00000oll
0000000200000oll000000030003oc`300000oll0000000200001?ll003o??ll1P0000?o?0000000
2`006?ll0@0000000`00occo?00Goc`D00000oll000000040004oc`:000Aoc`/000Doc`00`00occo
?0040006oc`20003oc`20003oc`40004oc`30002oc`00`00occo?002oc`20008oc`00`00oc`00003
oc`400000oll003o?00400001oll003o??ll003o?00000;o?08000?o?0800005oc`00000003o?003
00000oll0000000E000Goc`100000003003o??ll01Ko?2L000Ko?2@002So?0800003oc`0000000D0
00?o?0L000?o?0D000;o?003003o?000008000;o?005003o??ll003o?00300000oll00000002oc`0
1@00oc`00?ll00000_ll0P0000?o?000oc`01`001?ll00<00?ll00000_ll0P000_ll1`0000?o?000
00001P0000Oo?00000000?ll003o?00>000Foc`100000003003o??ll01Go?1H00003oc`0000000L0
00So?1<003ko?0800003oc`0000000?o?08000?o?0L000?o?0<00005oc`00?lloc`00002oc`01000
oc`00?ll0P0000Co?000occo?0800004oc`00000oc`200000oll003o?003oc`20002oc`600001Oll
003o??ll00000oll00H00?ll003o?000oc`80003oc`600001Oll00000000oc`00`0000?o?0000000
30005Oll0@0000000`00occo?00Doc`K0004oc`?000joc`B0005oc`00`00occo?002oc`00`00oc`0
0005oc`00`00occo?003000:oc`40002oc`01@00oc`00000oc`00P0000Co?000occo?080000:oc`0
0?ll003o?000oc`00?ll0002oc`00`00occo?002oc`20002oc`300001?ll003o?0000_ll00@00?ll
003o?0800004oc`000000002oc`00`00occo?00H000Doc`100000003003o??ll01?o?2T000go?4@0
00;o?0@000;o?0<00005oc`00000oc`00002oc`00`00occo?0030004oc`00`00occo?002oc`30000
1?ll003o??ll100000?o?00000001?ll0P0000Oo?000oc`00?ll003o?00400000oll003o?0020000
0oll00000002oc`300001Oll003o?000oc`00P0000?o?00000000P0000?o?000000010000oll6P00
4_ll0@0000000`00occo?00Boc`P000;oc`o000Boc`300000oll003o?00200002?ll00000000oc`0
0?ll0003oc`20005oc`00`00occo?0040002oc`00`00occo?00200000oll003o?004oc`00`00oc`0
0003oc`400000oll0000000400001?ll000000001?ll0`000oll00D00?ll00000?ll00@00003oc`0
0?ll00@00006oc`00000oc`00?ll0`0000?o?000oc`04P004_ll0@0000000`00occo?00@oc`i0018
oc`01P00oc`00000oc`000?o?003003o?00000?o?003003o??ll00?o?08000;o?08000;o?08000?o
?0<00004oc`00?ll0002oc`00`00occo?003oc`30003oc`01000occo?0001?ll00@00?llocco?0D0
0003oc`0000000800003oc`00?ll00;o?004003o??lloc`400000oll0000000O000?oc`100000003
003o??ll00go?2l005?o?003003o??ll00800004oc`00?ll0006oc`20004oc`30002oc`20002oc`2
00000oll0000000500000oll003o?002oc`01000oc`00?ll0P001Oll00@00?ll000000Co?004003o
?000oc`<00000oll003o?002oc`600000oll0000000700000oll0000000I000<oc`100000003003o
??ll00;o?2P00003oc`00?ll00<000;o?0D000;o?08000;o?00:003o?000003o?000oc`00?ll0002
oc`300001?ll003o??ll1@000_ll0P0000Co?000occo?0<00004oc`00000oc`20002oc`500001Oll
00000000oc`010000oll0P001?ll0`0000Co?000occo?0D000;o?0800004oc`000000003oc`00`00
oc`00003oc`300001?ll003o??ll0P000oll00<00?ll00000P000_ll0P000oll00h00?lloc`00?ll
003o?000oc`00?ll003o?0001?ll00@00?ll000000Co?004003o?000oc`400000oll000000020000
1Oll00000?ll00000oll10000oll2@0000?o?000000090000_ll0@0000000`00occo?00Y00000oll
003o?00300000oll0000000400000oll0000000700001oll00000000oc`00?ll00@00003oc`00?ll
00H00003oc`0000000/00004oc`00000oc`600000oll0000000;00000oll0000000400000oll003o
?00600000oll0000000400000oll003o?003oc`20002oc`20002oc`40003oc`50005oc`00`00oc`0
0003oc`01000oc`00?ll0P000oll0`000oll10000_ll1@0000?o?00000000P0000So?000occo?000
oc`00?ll0P000_ll1@001?ll0P0000?o?000oc`00_ll00<00?ll00000P0000Co?000003o?2<00000
00<00?ll0000<`0000?o?000oc`00P0000?o?00000000`000_ll0`0000?o?000oc`00`000_ll00<0
0?ll00000P000_ll00D00?ll00000?ll00H00005oc`00000003o?00200002?ll00000?ll003o?000
oc`200000oll00000003oc`40002oc`50002oc`00`00oc`000020002oc`00`00oc`0000500000oll
003o?00500000oll00000003oc`400000oll0000000300000oll00000002oc`00`00oc`000020002
oc`20003oc`20002oc`200000oll003o?002oc`30003oc`400000oll003o?0030004oc`00`00oc`0
000300000oll0000000300001?ll00000?ll0`0000?o?00000000_ll1@0000?o?00000008`000Oll
0@0000000`00occo?00=oc`U00000oll00000008001@oc`20003oc`90004oc`00`00occo?0040003
oc`01000occo?0000_ll00@00?llocco?08000;o?003003o??ll00@000?o?003003o?00000Co?080
0003oc`00?ll00800004oc`00?ll0006oc`200001Oll003o?000oc`00`0000?o?00000001`0000?o
?000oc`00P0000Go?00000000?ll01H000oo?040000000<00?lloc`04?ll5@0000?o?00000001P00
1?ll2P0000?o?00000007000<_ll0P0000?o?00000000_ll0`000_ll00<00?ll00000P001Oll0P00
3?ll0`000_ll00<00?lloc`00P0000Co?000003o?0H000;o?08000;o?0<00003oc`00?ll00?o?080
00;o?0<00007oc`00?ll003o?000oc`0100000?o?00000000`0000?o?00000000P0000?o?0000000
5`004Oll0@0000000`00occo?00Aoc`00`00oc`0000I00000oll000000080004oc`N00000oll0000
000d00000oll00000003oc`00`00occo?0030004oc`20003oc`01P00oc`00000oc`000;o?0<00004
oc`00?lloc`200001?ll00000?ll0P0000?o?000oc`01@0000_o?00000000?ll003o?000oc`00?ll
00800003oc`0000000;o?0<00005oc`00?ll003o?00600000oll0000000300000oll0000000K000C
oc`100000003003o??ll01?o?2@00003oc`0000000T001Oo?3D000;o?003003o??ll00;o?004003o
??ll0004oc`30003oc`500000oll000000030002oc`00`00occo?00200001Oll00000?ll00000_ll
00<00?lloc`00P0000?o?00000000`0000?o?000oc`00`0000Go?00000000?ll00800004oc`00000
0003oc`200000oll003o?002oc`700000oll0000000K000Doc`100000003003o??ll01Co?0h00003
oc`0000000800003oc`0000000D00004oc`000000004oc`;00000oll000000050013oc`200001?ll
003o??ll100000Co?000occo?0@00006oc`00?lloc`00?ll0P000_ll0`000_ll0P000oll00D00?ll
003o?00000Co?004003o??ll0002oc`40002oc`01000oc`000001?ll00D00?lloc`00?ll00@00003
oc`0000000<00004oc`00?lloc`30004oc`200001?ll003o??ll5P005_ll0@0000000`00occo?00E
oc`D00000oll0000000600000oll000000050008oc`I000boc`300000oll0000000500000oll0000
00020002oc`400000oll003o?002oc`01@00oc`00000oc`00P0000Ko?00000000?ll0002oc`00`00
oc`00008oc`00`00oc`00002oc`300000oll003o?003oc`01000occo??ll2P0000Co?000occo?080
0003oc`0000000?o?004003o??ll0002oc`00`00oc`0000600000oll0000000:000Foc`100000003
003o??ll01Ko?1400003oc`0000000l00003oc`0000000D000Oo?1800003oc`00000024000oo?080
0003oc`00?ll00;o?0<00004oc`00?ll0003oc`50003oc`500001?ll003o??ll0P0000Co?000003o
?0D000;o?004003o?000oc`20004oc`50003oc`800000oll0000000300000oll00000002oc`00`00
oc`0000300000oll0000000500000oll0000000C000Goc`100000003003o??ll01Oo?0l00003oc`0
000000800003oc`0000000@00004oc`000000003oc`700000oll00000002000Eoc`S00000oll0000
000?0003oc`20003oc`01000oc`00?ll0P000oll0P0000?o?00000000`0000?o?00000001Oll0`00
00Ko?00000000?ll0002oc`01000oc`00?ll0`000oll00@00?lloc`000;o?0X00007oc`00?ll003o
?000oc`00P000_ll00D00?ll00000?ll01000003oc`0000000/001Wo?040000000<00?lloc`06?ll
400000?o?00000000P0000Go?00000000?ll00<00003oc`0000000<000Go?0@00003oc`0000000P0
02ko?1D000Co?004003o??lloc`200001?ll003o?0000_ll10000oll00H00?llocco?000oc`30002
oc`00`00occo?003oc`20002oc`00`00oc`00004oc`30002oc`400000oll003o?0030007oc`01P00
oc`00?ll003o?0800006oc`00000oc`00?ll0P000_ll2P0000?o?00000002@006Oll0@0000000`00
occo?00Hoc`00`00oc`0000<00001Oll00000000oc`0100000?o?00000003@001?ll2P0000?o?000
00002`00<Oll0`0000?o?000oc`00`000oll00@00?lloc`000Co?0@000Oo?007003o??ll003o?000
oc`00P000_ll00<00?ll00000P0000?o?00000000_ll00<00?lloc`00`0000Ko?000003o?000oc`4
00000oll003o?0020003oc`200000oll003o?00700000oll0000000J000Joc`100000003003o??ll
01[o?0`00004oc`00000oc`:00000oll00000002oc`600000oll00000002000:oc`=00000oll0000
0006000Yoc`01@00occo?000oc`00`000oll00<00?lloc`00oll00<00?ll00003oll10000_ll00<0
0?lloc`00P0000Co?000003o?08000;o?004003o??lloc`20002oc`50003oc`30002oc`200000oll
003o?00500001?ll003o??ll20000_ll40007?ll0@0000000`00occo?00Koc`=00001?ll00000?ll
0`0000?o?0000000100000?o?00000000P001?ll100000?o?000000010004Oll200000?o?0000000
6P003_ll0`0000Go?000oc`00?ll00800003oc`00?ll00D000Co?003003o?00000<00004oc`00000
oc`300001?ll00000?ll0P0000Co?000003o?0800004oc`00?lloc`200000oll003o?0020002oc`0
1000oc`00?ll10000_ll00<00?lloc`00P000oll0P001_ll0`000oll0P0000?o?000oc`00_ll0`00
00?o?00000002@007?ll0@0000000`00occo?00Koc`00`00oc`0000900001?ll00000?ll3`0000?o
?00000000`000oll1P0000?o?00000001`004?ll700000?o?00000003P0000Go?000oc`00?ll0080
0003oc`00?ll00L00004oc`00000oc`:0002oc`200000oll0000000300000oll00000004oc`20000
0oll0000000700000oll0000000300001?ll003o??ll0`0000?o?00000001@000_ll10000_ll5P00
7Oll0@0000000`00occo?00Moc`<00001?ll00000?ll0`0000?o?00000000`0000Co?000003o?0D0
0003oc`0000000Oo?0T00003oc`00000008002So?18000;o?007003o??lloc`00?ll00001?ll0P00
00Go?000occo?00000?o?005003o?000003o?0030003oc`01@00oc`00?ll00001Oll0`000oll2000
00?o?00000000_ll00@00?llocco?0@00003oc`0000000D000;o?0D00003oc`0000001@001ko?040
000000<00?lloc`07_ll300000?o?00000001@0000?o?00000001`000oll0P0000?o?00000001000
2_ll100000?o?00000002P00:_ll0P0000Go?000oc`00?ll00<000Co?08000?o?003003o?00000Co
?0800003oc`0000000<00005oc`00000003o?00200001?ll003o?0000_ll0P001?ll10001Oll00<0
0?lloc`00_ll00<00?lloc`0100000Co?000000000?o?0H00003oc`0000000@000;o?0T00004oc`0
0000oc`3000Ooc`100000003003o??ll01ko?1L00003oc`0000000<00003oc`0000000800003oc`0
000000@00003oc`0000000@000So?1h001[o?08000;o?0@000?o?0<00007oc`00?ll003o?000oc`0
0P0000?o?00000000`001?ll0P0000?o?00000001@000oll00@00?ll003o?0<00004oc`00?lloc`4
0004oc`700001oll00000000oc`00?ll00T00003oc`00?ll00H00003oc`0000000X0023o?0400000
00<00?lloc`07oll3`0000Oo?00000000?ll003o?00200001?ll00000?ll100000?o?00000001Oll
1P0000?o?00000000P003oll8`002Oll0`0000?o?000oc`00P000oll00D00?llocco?00000Go?0@0
0004oc`00?ll0006oc`300001?ll003o?0000_ll00T00?ll003o?000oc`00?ll00001?ll0`001Oll
1@0000Wo?000oc`00?ll003o?000oc`00`0000?o?00000000`0000?o?00000001P000_ll0`0000?o
?00000001@008Oll0@0000000`00occo?00Qoc`900000oll0000000200001Oll00000000oc`01@00
00Co?000000000;o?0800003oc`0000000<000Ko?0`001Wo?1400003oc`0000000T000;o?003003o
?00000;o?0800003oc`00?ll00800004oc`00?lloc`40008oc`00`00oc`000020002oc`20002oc`0
1000oc`000000oll0`000oll0`000oll0`0000Ko?000oc`00?ll0005oc`01@00oc`00000oc`01@00
00?o?00000000P000_ll0`0000?o?00000002`008Oll0@0000000`00occo?00Qoc`=00001Oll0000
0000oc`00`0000?o?00000000`0000Go?00000000?ll00D00003oc`0000000<000Co?0P00003oc`0
000000P0023o?0`00004oc`00?ll0002oc`400001?ll00000?ll10001Oll00<00?lloc`00oll00L0
0?lloc`00?ll003o?0020002oc`01000oc`000000_ll0P0000?o?000oc`00_ll0`000oll2@0000?o
?00000000_ll100000Oo?00000000?ll003o?00200001?ll003o??ll4@008_ll0@0000000`00occo
?00Roc`>00001Oll00000000oc`0100000?o?00000000`0000?o?00000000P000_ll30001_ll5`00
7_ll00<00?ll00000_ll00<00?ll00000P000_ll20000_ll00<00?ll0000100000Co?000occo?0H0
00;o?003003o??ll00D00006oc`00?ll003o?0001?ll0P0000?o?000000010000_ll0P000_ll0`00
0_ll0P0000?o?00000000_ll00D00?ll00000?ll00/00003oc`0000000<002?o?040000000<00?ll
oc`08_ll00<00?ll00002P0000Co?000003o?0<00003oc`00?ll00<00003oc`00?ll00@00003oc`0
000000Co?0X000go?0d00003oc`0000000L001Ko?005003o??ll003o?0030003oc`200000oll003o
?00200000oll00000002oc`400000oll0000000300001?ll003o?0000_ll0P0000?o?00000000`00
00?o?000oc`00`0000Co?000occo?0800007oc`00?ll003o?000oc`00P0000Co?000occo?0<000;o
?0D000;o?0@00004oc`000000002oc`20002oc`200000oll00000003000Toc`100000003003o??ll
02Co?0X00003oc`00?ll00800005oc`00000003o?00300000oll003o?0030002oc`200000oll0000
00020006oc`300000oll00000005000Coc`900000oll0000000G0002oc`20003oc`200001?ll003o
?0000_ll0`0000?o?000oc`00_ll10000_ll00@00?lloc`000;o?0D00003oc`00?ll00Co?0D00003
oc`0000000@000;o?0@000;o?003003o?00000800003oc`0000000800003oc`0000000<00003oc`0
000000L00003oc`0000000H002Go?040000000<00?lloc`09?ll3P0000?o?00000002`0000Go?000
00000?ll00@00003oc`0000000<000Co?10001Co?1T000?o?003003o??ll00<000?o?007003o??ll
003o?000oc`00P0000Go?00000000?ll00800007oc`00000003o?000oc`00`0000?o?000oc`01?ll
0P0000Co?000003o?0D00004oc`00000oc`20002oc`00`00occo?00900000oll0000000G000Voc`1
00000003003o??ll02Go?003003o?00000D00005oc`00000003o?00200001?ll00000?ll1`0000Go
?00000000?ll008000?o?0D00004oc`000000007oc`900000oll00000002000Woc`01@00occo??ll
00000_ll0P000_ll00<00?ll00001_ll1@0000Go?00000000?ll00<00003oc`00?ll00<000;o?003
003o?00000;o?0800004oc`00?lloc`30003oc`01000occo?0000oll00P00?llocco?000oc`00?ll
1`0000?o?0000000100000Co?000003o?0H00003oc`0000000<002Oo?040000000<00?lloc`09oll
1`0000Go?00000000?ll00800005oc`00000003o?00400000oll00000002oc`200000oll00000002
0004oc`8000<oc`400000oll0000000;000Ioc`300001?ll00000?ll0P0000Ko?000003o?000oc`4
00000oll000000020002oc`01000oc`000001?ll0P0000Co?000occo?0@000?o?004003o?000oc`2
0005oc`40003oc`00`00oc`0000600000oll003o?00800000oll0000000200001?ll000000000_ll
20009oll0@0000000`00occo?00Woc`:00000oll0000000700000oll0000000200000oll0000000;
0002oc`500000oll000000050009oc`=00000oll0000000I00001?ll00000?ll10000_ll1P0000?o
?000oc`01oll00H00?llocco?000oc`30002oc`00`00oc`00002oc`01000oc`00?ll0`0000?o?000
oc`00oll0`000_ll2P001?ll1`000oll4@00:?ll0@0000000`00occo?00Xoc`A00001Oll00000000
oc`020000_ll1@0000?o?000oc`01Oll2`004oll6`0000?o?000oc`00_ll0P001?ll00<00?ll0000
0oll00D00?llocco?00000;o?003003o??ll00?o?004003o??ll0004oc`20002oc`01@00oc`00000
oc`00P0000?o?000oc`00oll0`000_ll100000?o?000oc`00P000_ll00<00?lloc`00P0000?o?000
oc`00oll00<00?lloc`0300000Co?000000002Wo?040000000<00?lloc`0:Oll2@0000?o?0000000
1@0000?o?00000000P0000Co?000003o?0800004oc`000000004oc`00`00oc`000040007oc`40000
0oll00000006000Voc`200000oll00000003oc`300001_ll003o?000oc`000;o?08000;o?0D00003
oc`00?ll00Co?004003o?0000002oc`02000oc`00000oc`00?ll0005oc`300001_ll003o??ll003o
?0800003oc`00?ll00;o?0800003oc`0000000?o?0P00003oc`0000000800003oc`0000000H002[o
?040000000<00?lloc`0:Oll00<00?ll0000300000Go?00000000?ll00@00003oc`0000000@00004
oc`000000002oc`500000oll000000030006oc`800000oll00000009000Joc`200000oll00000002
oc`400001_ll003o?000oc`000;o?0<00003oc`0000000L00005oc`00000003o?0020002oc`00`00
occo?00500001_ll003o?000oc`000?o?004003o?000oc`300001Oll00000000oc`00P0000Go?000
00000?ll00/00004oc`00000oc`8000[oc`100000003003o??ll02_o?0`00004oc`00000oc`40000
0oll0000000200001?ll00000?ll0`0000Co?000000000Co?0D00004oc`00000000;oc`;00000oll
00000006000Boc`00`00oc`00003oc`30002oc`01@00occo??ll00000_ll00<00?ll00001_ll00D0
0?ll00000?ll008000;o?08000;o?0800003oc`0000000<00003oc`00?ll00<00004oc`00?lloc`2
00001Oll003o?000oc`00`001?ll0`0000?o?00000000_ll1`0000Co?000003o?0P002_o?0800000
00<00?lloc`0;?ll2P0000?o?000oc`00`0000Go?000oc`00?ll00800004oc`00000oc`20002oc`7
0006oc`300000oll00000004000@oc`M0004oc`300001?ll003o??ll0`0000Ko?000occo?000oc`2
00000oll00000002oc`200001?ll000000000oll1P0000?o?000oc`01?ll1@0000?o?00000001P00
0oll00<00?lloc`01P0000?o?00000001@000_ll2`00:oll0@000Oll0@0000000`00occo?00/oc`0
0`00oc`0000800001?ll00000?ll0P0000?o?00000000P0000Co?000003o?0800005oc`00000003o
?00400000oll000000030004oc`600000oll00000006000?oc`J00001?ll003o?0000_ll0`0000?o
?00000000P0000Co?000003o?0800005oc`00000003o?00300001Oll00000000oc`00P0000?o?000
oc`01?ll1@0000?o?00000001`001?ll100000?o?00000000P0000?o?000000010000oll2`00;_ll
0@0000000`00occo?00^oc`;00001?ll00000?ll0`0000Go?00000000?ll00800005oc`00000003o
?0020003oc`500000oll00000008oc`=000Ooc`50004oc`01@00oc`00000oc`010001Oll00H00?ll
oc`00?ll0005oc`20002oc`200001Oll003o??ll00000_ll0P0000Co?000occo?0<000?o?003003o
?00000Co?0P000?o?0800006oc`00?lloc`00?ll1P0000?o?00000000P00;oll0@0000000`00occo
?00_oc`900000oll0000000200000oll0000000600000oll00000002oc`200000oll000000020004
oc`200000oll00000003000:oc`B000Doc`00`00occo?003oc`200001oll00000?ll003o?00000;o
?08000;o?003003o??ll00Oo?006003o??ll003o?0000_ll1@000_ll00@00?ll003o?08000Co?0@0
00?o?0<00004oc`000000005oc`200000oll0000000900000oll00000002000`oc`100000003003o
??ll02oo?0d00004oc`00000oc`300000oll0000000200001Oll00000000oc`0100000?o?0000000
0P000_ll1@0000?o?000000010002?ll3@0000?o?00000005P0000?o?000oc`00P000_ll00@00?ll
003o?0H000?o?0@000;o?003003o??ll00<000;o?0<00003oc`00?ll00800006oc`00?ll003o?000
0oll10000_ll0`0000?o?00000000P0000Co?000003o?1@0037o?040000000<00?lloc`0<Oll0`00
00?o?00000000`0000Co?000003o?0<00003oc`0000000800003oc`0000000800003oc`0000000?o
?0L000Go?0H00004oc`00000000Boc`H00000oll003o?00200000oll00000002oc`20002oc`40002
oc`40002oc`02000occo??ll003o?000oc`20004oc`20003oc`00`00oc`00003oc`30003oc`20000
0oll000000020002oc`200000oll000000030002oc`500000oll00000005000boc`100000003003o
??ll03;o?0H00006oc`00000003o?0000_ll0P0000So?000003o?000oc`00?ll0`0000?o?0000000
0P000_ll0`0000?o?00000000P001oll0`0000?o?00000001`007_ll0P0000Oo?000occo?000oc`0
0003oc`01@00oc`00?ll00000_ll00@00?ll000000Co?0@00005oc`00000003o?0020003oc`00`00
oc`0000300001oll003o??ll003o?00000Co?0800005oc`00000003o?00300001?ll003o??ll1000
00?o?0000000100000?o?00000001@00<oll0@0000000`00occo?00boc`>00001Oll00000000oc`0
0`0000?o?00000002P000_ll100000?o?00000000`001Oll2@0000?o?00000002@004_ll0P0000?o
?000oc`00_ll00<00?ll00000`0000?o?000oc`00`0000?o?00000000P0000Go?00000000?ll0080
0003oc`0000000?o?003003o??ll00800003oc`0000000@00003oc`0000000@00009oc`00000003o
?000oc`00?ll00@000;o?1@003Co?040000000<00?lloc`0<oll00<00?ll00002@0000Go?0000000
0?ll00<00003oc`0000000800003oc`0000000D00003oc`00000008000;o?0D00003oc`0000000@0
00So?1l00003oc`00?ll00<00003oc`0000000800003oc`00?ll00D00004oc`00000oc`900001Oll
003o?000oc`00`0000Co?000003o?0<00003oc`00?ll00P00003oc`00?ll00<000;o?0L00003oc`0
000000d003Go?040000000<00?lloc`0=Oll2@0000?o?00000000_ll00<00?ll00000P000_ll00<0
0?ll00000`0000Co?000occo?0@00003oc`0000000Go?0X000oo?1@00003oc`00?ll00<00003oc`0
000000Go?003003o??ll008000Co?005003o??ll003o?0020003oc`01`00oc`00?ll003o?00000;o
?003003o??ll00?o?0<000?o?007003o?000003o?000oc`00P000oll10000_ll00<00?lloc`00P00
00?o?00000002@00=_ll0@0000000`00occo?00foc`900000oll0000000400001Oll00000000oc`0
0`000_ll00<00?ll00000P000oll0P0000?o?00000000P001_ll100000?o?00000001P006oll0P00
00?o?000oc`00_ll00H00?lloc`00?ll0003oc`01000occo??ll0`000_ll00<00?lloc`01?ll00D0
0?ll00000?ll00800006oc`00000003o?0000_ll0P001?ll00<00?ll00000_ll10000_ll0`0000?o
?000oc`00`0000Co?000003o?0800003oc`0000000H003Oo?040000000<00?lloc`0=_ll00<00?ll
00002`0000?o?00000000P0000Go?00000000?ll00H00003oc`0000000800003oc`0000000800003
oc`0000000<000Go?0P00003oc`0000000X000oo?006003o?000oc`00?ll0P0000Go?000oc`00?ll
00<000?o?0<000;o?003003o?000008000;o?0800004oc`000000002oc`01000oc`00?ll0P000_ll
00<00?ll00000`001?ll0`000_ll0`0000Co?000003o?0<00003oc`0000000`003So?040000000<0
0?lloc`0>?ll1P0000?o?000oc`00P0000[o?000003o?000oc`00?ll003o?0<00004oc`00?lloc`6
0004oc`500001?ll000000002_ll300000?o?000000030000_ll00@00?ll003o?0800003oc`00?ll
00D000;o?0800006oc`00?lloc`00?ll0`000_ll0P000_ll00<00?ll00000_ll0P000_ll00D00?ll
00000?ll00@000Co?0<000;o?0800004oc`000000003oc`00`00oc`0000=000ioc`100000003003o
??ll03Wo?0H00003oc`0000000800008oc`00000oc`00?ll003o?0<00003oc`00?ll00<000;o?080
00;o?0@000Co?0<00003oc`0000000@0013o?1D000?o?0@000;o?003003o?00000800003oc`00?ll
00800003oc`00?ll00D00003oc`0000000800003oc`0000000;o?003003o?00000<00005oc`00?ll
oc`00002oc`20002oc`200000oll000000050002oc`>000joc`100000003003o??ll03Wo?0d00005
oc`00000003o?00300000oll0000000300000oll0000000200000oll0000000200000oll00000002
0003oc`600000oll00000006000Eoc`600001?ll003o??ll0P0000?o?000oc`00P0000?o?0000000
0`0000?o?00000000P0000Co?000003o?0800006oc`00000oc`00?ll0P0000Co?000003o?0H00003
oc`0000000@00005oc`00000003o?00=00000oll00000007000koc`100000003003o??ll03[o?0/0
0007oc`00000003o?000oc`01@0000?o?000oc`0100000?o?000oc`00oll100000Co?000000000Ko
?0P000;o?0D001?o?0<000;o?0800004oc`00?ll0002oc`00`00oc`000020003oc`200001?ll0000
0?ll1@0000Co?000oc`000;o?0T00003oc`00?ll00P00004oc`000000003oc`500000oll003o?008
000moc`100000003003o??ll03co?0H00003oc`0000000@00005oc`00000003o?00400001?ll0000
00000_ll00<00?lloc`010000oll0`0000?o?00000000`002_ll1@0000?o?00000004P0000?o?000
oc`00`0000?o?00000000_ll0`000oll10001Oll0P000oll00D00?ll00000?ll00<00003oc`00000
00Co?0800004oc`00?lloc`30002oc`200000oll003o?00300001_ll00000?ll003o?0P003ko?040
000000<00?lloc`0?Oll00<00?ll00002`0000?o?00000000P0000?o?00000000P0000Go?0000000
0?ll00@00003oc`00000008000;o?0D00003oc`0000000D000So?1@00007oc`00?ll003o?000oc`0
0P0000?o?00000000P000oll10000_ll1@000oll00D00?ll00000?ll00H00004oc`00?lloc`50000
1Oll00000000oc`00`0000?o?00000001P0000?o?00000002000?oll0@0000000`00occo?00ooc`6
00000oll0000000200000oll0000000200001?ll00000?ll1@0000Co?000oc`000;o?0H000Ko?0L0
0006oc`00000003o?0005oll00<00?ll00000oll0P0000Oo?00000000?ll003o?0020002oc`00`00
occo?00400001Oll003o??ll00000_ll0`000_ll00@00?ll003o?0800003oc`0000000<00003oc`0
0?ll00;o?0<000;o?0800003oc`0000000d0043o?040000000<00?lloc`0@?ll2@0000?o?000oc`0
0P0000?o?000oc`00`0000?o?00000000P0000?o?00000000`000_ll0P0000?o?000000010001oll
0`0000?o?000000030002_ll100000Co?000000000;o?005003o?000003o?00200001Oll003o?000
oc`00P000oll0P0000Co?000003o?0800003oc`00?ll00<000;o?007003o?000003o?000oc`00`00
0_ll0`0000Co?000003o?0800003oc`0000000/0047o?040000000<00?lloc`0@?ll00<00?ll0000
3P0000?o?000oc`00`0000?o?0000000100000?o?0000000200000?o?000000010001Oll3@0000?o
?00000002`0000Go?00000000?ll00@00004oc`00000oc`400000oll0000000500001_ll00000?ll
003o?0800003oc`0000000?o?003003o?00000P00004oc`00000oc`D0012oc`100000003003o??ll
04?o?0`000;o?006003o?000oc`00?ll0P000_ll00<00?lloc`0100000Co?000oc`000?o?0H00003
oc`00000008000ko?0`00003oc`0000000?o?0<000;o?0@00003oc`0000000?o?0D00005oc`00?ll
003o?00300000oll00000002oc`200000oll0000000500000oll003o?00:00000oll000000020000
0oll000000040014oc`100000003003o??ll04Co?0D00003oc`0000000D00005oc`00?ll003o?003
00000oll003o?0040002oc`00`00oc`000050005oc`400000oll003o?008000@oc`01000oc`00?ll
0P0000Co?000occo?0<00003oc`00?ll00;o?0@000Ko?003003o?00000800004oc`00?lloc`30000
1Oll00000?ll00000_ll0P0000Co?000003o?0<00003oc`0000000h004Go?040000000<00?lloc`0
A?ll00<00?ll00002@0000Go?00000000?ll00<00003oc`00?ll00@00003oc`0000000L00003oc`0
000000@000?o?003003o?00000L00003oc`0000000H00003oc`0000000L00005oc`00000oc`00002
oc`300000oll003o?0060002oc`50003oc`01@00oc`00000oc`01P0000Co?000occo?0D00003oc`0
0000018004Ko?040000000<00?lloc`0A_ll0P0000?o?0000000100000?o?00000000_ll0P0000?o
?00000000P0000?o?00000001P0000?o?0000000200000?o?00000000`0000?o?000oc`01Oll2000
00?o?00000002@000_ll00<00?ll00000`0000?o?000oc`00P0000Go?000oc`00?ll00D00003oc`0
0?ll008000;o?0<000;o?004003o?000oc`600001?ll003o?0000_ll4000B?ll0@0000000`00occo
?019oc`800000oll0000000600000oll0000000200001Oll00000000oc`0100000?o?00000001?ll
1@0000?o?000oc`01@004Oll0`0000?o?0000000100000Ko?000003o?000oc`400001oll003o?000
oc`00?ll00D00006oc`00000oc`00?ll0`0000?o?0000000100000?o?000oc`00P0000Co?000003o
?0`004[o?040000000<00?lloc`0B_ll1P0000Co?000003o?0800006oc`00000oc`00?ll1@0000Go
?000003o?00000;o?0<00003oc`0000000<000Go?0D00003oc`0000000P00003oc`0000000X00006
oc`00?lloc`00?ll0P0000?o?000oc`0100000Go?000oc`00?ll00800004oc`00000oc`400001?ll
00000?ll0P0000?o?0000000100000?o?00000003`00C?ll0@0000000`00occo?01<oc`>00001Oll
00000000oc`0100000?o?000oc`0100000?o?0000000200000?o?00000000oll2P0000?o?0000000
1`0000Ko?000003o?000oc`200001_ll00000?ll003o?0P00004oc`00000oc`200000oll00000008
00000oll0000000600000oll0000000=001=oc`100000003003o??ll04go?1@00004oc`00000oc`4
00001?ll003o?0000_ll1@0000?o?00000001P004?ll00L00?ll00000?ll003o?00200001_ll0000
0?ll003o?0800003oc`00000008000;o?005003o?000oc`00003oc`30002oc`300001Oll00000?ll
00000_ll1P000_ll2@00Coll0@0000000`00occo?01>oc`00`00oc`000080002oc`300000oll0000
00020002oc`500000oll003o?0060003oc`600001?ll00000?ll1P0000?o?00000001P000_ll00<0
0?lloc`00`0000?o?00000000P0000Oo?00000000?ll003o?00200000oll003o?00200001?ll0000
00000_ll0`000_ll2@0000?o?00000002P00DOll0@0000000`00occo?01@oc`200000oll00000007
00000oll0000000200000oll0000000400001?ll00000?ll1P0000Co?000003o?0@000;o?0800003
oc`0000000@00003oc`0000001D00003oc`00?ll00d00006oc`00000oc`00?ll5`00D_ll0@000000
0`00occo?01Coc`800001Oll00000000oc`00`0000Go?000oc`00?ll00800003oc`00?ll00<000;o
?0800003oc`0000000800003oc`0000000<000ko?0H00006oc`00000oc`00?ll0`0000?o?000oc`0
3@0000Ko?000003o?000oc`F001Doc`100000003003o??ll05Co?0H00003oc`0000000@00006oc`0
0000oc`00?ll100000Go?00000000?ll00D000Co?0D000;o?0H00003oc`0000000L00004oc`00?ll
oc`300001oll003o?000oc`00?ll00H00004oc`000000002oc`01@00oc`00000oc`00`0000?o?000
00001@000_ll2P00E_ll0@0000000`00occo?01Eoc`00`00oc`0000=00000oll000000020002oc`2
00000oll000000030002oc`?00000oll0000000700000oll0000000H00000oll003o?00400000oll
0000000@001Hoc`100000003003o??ll05So?003003o?00000P000;o?0P00004oc`00000oc`30000
0oll0000000800000oll000000040007oc`600001?ll00000?ll1P0000?o?00000003@0000Ko?000
003o?000oc`400000oll00000008001Joc`100000003003o??ll05_o?003003o?00000`000;o?080
0003oc`0000000800003oc`00?ll00D000;o?003003o?00000D000;o?0h00007oc`00?ll003o?000
oc`00`0000?o?000oc`01@0000?o?000oc`00P0000?o?00000000P0000?o?00000002`00GOll0@00
00000`00occo?01Moc`C00000oll0000000700000oll003o?00200000oll0000000A00000oll0000
000800000oll0000000300000oll0000000400000oll0000000@001Noc`100000003003o??ll05oo
?003003o?00000/000;o?0D00003oc`00?ll00@00004oc`00000oc`600000oll0000000300001oll
00000000oc`00?ll00@00003oc`0000000@00003oc`0000000<00003oc`0000000@00004oc`00000
oc`=001Qoc`100000003003o??ll06;o?003003o?00001000003oc`0000000800003oc`00?ll0080
0003oc`0000000@00003oc`00?ll00;o?0D00004oc`00?lloc`300001Oll00000000oc`03@0000Co
?000003o?0/006Co?040000000<00?lloc`0I?ll4`0000?o?00000002`0000Go?000oc`00?ll00`0
0005oc`00000003o?00L001Uoc`100000003003o??ll06So?0800003oc`0000001<00003oc`00000
00<00003oc`0000000X00003oc`0000001d006Wo?040000000<00?lloc`0K?ll00<00?ll00003`00
0_ll200000Go?00000000?ll024006ko?040000000<00?lloc`0L?ll00<00?ll00002@0000?o?000
00002P0000?o?00000007@00Loll0@0000000`00occo?01coc`01@00oc`00000oc`0;`00MOll0@00
00000`00occo?01joc`01@00oc`00000oc`01P0000Co?000003o?0<00004oc`00000oc`200001Oll
00000000oc`02@00O?ll0@0000000`00occo?03ooc`Moc`100000?l002400000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0263022, -0.0250052, \
0.00366761, 0.00593432}},
  ImageSoundCache->{{{0, 287}, {176.938, 0}} -> GraphicsData["XSound", "\<\
001>8@40`e000@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@01o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@01007o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@01o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@01007o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@01007o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`400@0100400@0100400@01
00400@0100400@0100400@010@410@410@410@410@410@410@410@410@410@41
0@410@410@400@0100400@0100400@0100400@0100400@01o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1oP7n0Oh1oP7n0Oh1oP7n0Oh1oP7n0Oh1oP7n0Oh1oP7n0Oh1
oP7n0Oh1oP7n0Oh1oP7n0Oh1oP7n0Ol1o`7o0Ol1o`7o0Ol1o`7o0@0100400@01
00400@0100400@410@410@410@410@410@410@410@410@410@420@810P420@81
0P420@810@410@410@410@410@410@410@410@4100400@0100400@0100400Ol1
o`7o0Ol1o`7o0Oh1oP7n0Oh1oP7n0Oh1oP7n0Od1o@7m0Od1o@7m0Od1o@7m0Od1
o@7m0Od1o@7m0Od1o@7m0Od1o@7m0Oh1oP7n0Oh1oP7n0Oh1oP7o0Ol1o`7o0Ol1
o`400@0100400@010@410@410@410@410P420@810P420@810P420@810`430@<1
0`430@<10`430@<10`430@810P420@810P420@810P410@410@410@410@400@01
00400@01o`7o0Ol1o`7n0Oh1oP7n0Oh1o@7m0Od1o@7m0Od1o07l0O`1o07l0O`1
o07l0O`1o07l0O`1o07l0O`1o07l0O`1o07l0O`1o@7m0Od1o@7m0Oh1oP7n0Oh1
oP7o0Ol1o`400@0100400@410@410@410P420@810P420@<10`430@<10`440@@1
10440@@110440@@110440@@110440@@110440@<10`430@<10`430@810P420@81
0@410@4100400@01o`7o0Ol1o`7n0Oh1oP7m0Od1o@7m0O`1o07l0O`1n`7k0O/1
n`7k0O/1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O/1n`7k0O/1n`7k0O`1o07l0Od1
o@7m0Od1oP7n0Oh1o`7o0@0100400@410@410@810P420@<10`430@@110440@@1
1@450@D11@450@D11P460@H11P460@H11P460@D11@450@D11@450@@110440@@1
0`430@<10P420@810@410@01007o0Ol1o`7n0Oh1o@7m0Od1o07l0O`1n`7k0OX1
nP7j0OX1n@7i0OT1n@7i0OT1n@7h0OP1n07h0OP1n@7i0OT1n@7i0OT1nP7j0OX1
nP7k0O/1o07l0O`1o@7m0Oh1oP7o0Ol100400@010@410@810P430@<110440@@1
1@450@H11P460@H11`470@L11`470@L120480@P120470@L11`470@L11`460@H1
1P460@D11@440@@110430@<10P420@410@400Ol1o`7n0Oh1o@7m0O`1o07k0O/1
nP7j0OT1n@7i0OP1n07h0OL1m`7g0OL1m`7g0OH1mP7f0OH1m`7g0OL1m`7g0OL1
n07h0OP1n@7i0OX1nP7j0O/1n`7l0Od1o@7n0Oh1o`400@010@410@810P430@@1
10450@D11P460@L11`480@P120490@T12@490@T12@4:0@X12P4:0@T12@490@T1
2@490@P120470@L11`460@H11@450@@10`430@810@410@01o`7o0Oh1o@7m0O`1
o07k0OX1nP7i0OT1n07h0OL1m`7f0OH1mP7e0OD1m@7e0O@1m07d0O@1m07d0OD1
m@7e0OD1mP7f0OH1m`7g0OP1n07i0OT1nP7k0O/1o07m0Od1oP7o0Ol100410@81
0P430@@11@450@H11`470@P120490@T12P4:0@/12`4;0@/1304<0@`1304<0@`1
304<0@/12`4;0@X12P4:0@T12@480@P11`460@H11@440@<10`420@4100400Ol1
oP7m0O`1n`7k0OX1n@7h0OP1m`7f0OH1m@7e0O@1m07c0O<1l`7b0O81lP7b0O81
lP7b0O81lP7c0O<1l`7c0O@1m07e0OD1mP7g0OL1n07i0OX1nP7k0O`1o@7n0Ol1
o`400@410P430@@11@460@H11`480@T12@4:0@/12`4<0@`13@4=0@d13P4>0@h1
3P4>0@h13P4>0@h13P4=0@d13@4<0@`12`4:0@X12@480@P11`460@D110430@81
0@400Ol1o`7n0Od1o07k0OX1n@7h0OL1mP7f0OD1m07c0O<1lP7b0O41l@7`0O01
l07`0O01l07`0O01l07`0O01l@7a0O41lP7b0O<1m07d0OD1mP7g0OP1n@7i0OX1
n`7l0Od1oP400@410P430@@11@460@L120490@T12P4;0@`13@4=0@h13P4?0@l1
404@0A014@4A0A414@4A0A41404@0A013`4?0@h13P4=0@`1304;0@X12@480@L1
1P450@@10`420@41o`7n0Od1o07k0OX1n@7h0OL1mP7e0O@1l`7b0O41l@7`0Nl1
k`7^0Nh1kP7]0Nd1k@7]0Nd1k@7]0Nd1kP7^0Nl1k`7`0O01l@7b0O<1l`7d0OD1
mP7g0OP1nP7k0O`1o@7n0@010@420@<110450@L120490@X12`4<0@d13P4?0@l1
404A0A414P4B0A<14`4C0A<14`4C0A<14`4C0A<14P4B0A41404@0@l13P4=0@`1
2`4:0@T120470@H11@430@810@7o0Oh1o@7l0OX1n@7h0OL1mP7d0O<1lP7a0O01
k`7_0Nh1k@7/0N`1j`7[0N/1j`7Z0NX1jP7Z0N/1j`7[0N`1k07]0Nd1kP7_0O01
l@7b0O<1m07e0OH1n07i0OX1n`7m0Oh100410@8110450@H120490@X12`4=0@h1
3`4@0A414P4B0A<1504D0AD15@4F0AH15P4F0AH15P4F0AD15@4E0A@14`4C0A81
4@4@0@l13P4=0@`12`490@P11`450@@10P410Ol1oP7m0O/1nP7h0OL1mP7d0O<1
lP7a0Nl1kP7]0N`1k07[0NX1j@7Y0NP1j07X0NP1j07X0NP1j07X0NT1j@7Z0NX1
j`7/0Nd1kP7_0O01l@7b0O@1m@7g0OP1n@7k0O`1oP7o0@410`440@H11`490@X1
2`4=0@h13`4A0A814`4D0AD15@4F0AL15`4H0AP16@4I0AT16@4I0AP1604H0AL1
5`4F0AD1504C0A814@4@0@l13@4<0@X12@470@H110430@41o`7n0O`1n`7i0OL1
mP7d0O<1l@7`0Nl1k@7/0N/1jP7Y0NP1j07W0NH1iP7U0ND1i@7U0ND1i@7U0NH1
iP7W0NL1j07Y0NX1j`7/0Nd1kP7`0O41lP7d0OD1m`7i0OX1o07n0@010@430@D1
1P480@X12`4=0@h1404A0A81504E0AH15`4H0AT16@4J0A/16`4K0A/1704L0A/1
6`4K0AX16P4I0AP15`4F0AD1504C0A81404?0@d1304:0@P11`450@<10@7o0Oh1
o07j0OP1m`7e0O<1lP7`0Nh1k@7/0NX1j@7X0NL1iP7U0N@1i07S0N<1hP7R0N81
hP7R0N81h`7S0N@1i@7V0NH1i`7Y0NX1j`7/0Nh1k`7a0O<1m07f0OP1nP7l0Oh1
00410@<11@470@T12`4<0@h1404A0A<1504F0AL1604I0AX16`4L0Ad17@4N0Ah1
7P4N0Ah17P4N0Ad17@4L0A`16`4J0AT1604F0AD14`4B0A013`4=0@/12@470@D1
0`410Ol1oP7l0OX1n07f0O@1lP7`0Nh1k@7[0NX1j07W0NH1i07S0N81hP7Q0N01
h07P0Ml1g`7O0Ml1h07P0N41h@7R0N<1i07U0NH1j07Y0N/1k07^0O01lP7c0OD1
m`7i0O/1o@400@8110460@P12P4<0@h13`4A0A<15@4F0AP16@4J0A`17@4N0Al1
7`4P0B018@4Q0B418@4Q0B41804P0Al17P4M0A`16`4J0AP15`4E0A@14P4@0@h1
304:0@P11P440@81o`7m0O/1n@7g0OD1l`7a0Nl1k@7[0NT1j07V0ND1h`7R0N41
h07O0Mh1gP7M0Md1g@7L0M`1g@7M0Md1gP7O0N01h@7R0N<1i07V0NL1j@7[0N`1
kP7`0O81m07g0OT1n`7m0@010P440@H1204;0@d13`4A0A<15@4F0AP16P4K0Ad1
7P4O0B018@4R0B<18`4T0B@1904T0B@18`4S0B818P4Q0B017P4M0A`16P4I0AL1
5@4C0A413`4=0@/12@460@@10P7o0Od1n`7i0OH1m07b0O01k@7[0NT1j07V0N@1
h`7Q0N01g`7M0M`1g07K0MX1fP7J0MX1fP7J0MX1f`7K0M`1g@7N0Ml1h@7R0N@1
i@7W0NT1j`7]0Nl1l@7d0OH1n07k0Od100420@@11`490@/13P4@0A81504F0AP1
6P4L0Ah17`4P0B818`4T0BD19@4V0BH19`4W0BL19P4V0BH19@4T0B<18P4Q0Al1
7P4L0A/16@4G0AD14`4@0@h130490@L110420@01o@7j0OP1mP7c0O41kP7/0NX1
j07V0N@1hP7P0Ml1g@7L0M/1fP7I0MP1f07G0ML1e`7G0ML1f07H0MT1fP7K0M`1
g@7N0N01hP7S0ND1i`7Y0N`1kP7`0O<1m@7h0OX1o@400@811@470@X1304?0A41
504F0AP16P4L0Ah1804Q0B<1904U0BH19`4X0BT1:@4Y0BX1:@4Y0BT1:04X0BL1
9P4U0B<18P4P0Ah17@4K0AP15P4D0A813`4=0@X11`450@81o`7m0OX1m`7e0O81
l07]0N/1j07V0N@1hP7P0Mh1g@7K0MX1f07G0MH1eP7E0MD1e07D0M@1e07E0MD1
eP7G0MP1f@7K0M`1gP7P0N81i07V0NP1jP7]0Nl1lP7e0OL1nP7m0@010P450@P1
2P4=0A014P4E0AL16P4L0Ah1804R0B<19@4W0BP1:@4Z0B/1:`4/0B`1;04/0B`1
;04[0BX1:@4X0BL19P4T0B81804N0A`16P4H0AD14`4@0@h12`480@D10P7o0Od1
nP7g0O@1l@7_0N`1jP7W0ND1hP7P0Mh1g07J0MT1e`7F0MD1e07C0M81dP7A0M41
d@7B0M81d`7D0M@1eP7G0MP1fP7L0Mh1h07R0N@1i`7Y0N`1kP7a0O@1m`7j0Od1
o`420@D1204;0@h14@4D0AH16@4K0Ah1804R0B@19P4W0BT1:P4[0Bd1;@4^0Bl1
;`4_0Bl1;`4^0Bh1;@4/0B/1:@4X0BH1904R0B017P4L0AT15`4D0A413P4;0@T1
1P430Ol1o07i0OH1m07a0Nh1j`7X0NH1h`7Q0Mh1g07J0MP1eP7E0M@1dP7A0M01
d07?0Ll1c`7?0Ll1c`7@0M41dP7C0MD1eP7H0MX1g07N0N01h`7U0NP1j`7]0O01
l`7f0OT1o0400@<11P490@`13`4B0AD15`4J0Ad17`4R0B@19P4X0BX1:`4]0Bh1
;`4`0C41<@4b0C81<P4a0C41<04_0Bh1;@4/0BX1:04V0B@18P4P0Ad16`4H0AD1
4P4?0@`12@460@<1o`7l0OT1mP7c0O01k@7Z0NL1i07Q0Ml1g@7J0MP1eP7D0M<1
d@7@0Ll1cP7=0L`1c07<0L`1c07=0Lh1cP7@0M41dP7D0MH1f07J0M`1gP7Q0N@1
iP7Y0N`1k`7c0OH1n@7l0@010`460@T1304@0A<15P4I0A`17P4Q0B<19P4X0BX1
;04^0Bl1<04b0C<1<`4d0C@1=04d0C@1<`4c0C81<@4_0Bh1;04Z0BP19P4T0B41
7`4L0AT15P4C0A013@490@H10`400O`1n@7e0O81k`7/0NT1iP7S0N01g@7K0MP1
eP7D0M81d07?0Ld1c07;0LX1bP7:0LT1bP7:0LX1b`7<0Ld1cP7@0M81e07F0MP1
fP7M0Ml1hP7U0NP1j`7_0O81m@7i0O`1o`430@H12P4=0A01504G0AX17@4P0B<1
9@4X0BX1;04^0C01<@4c0C@1=@4f0CH1=`4g0CL1=P4f0CD1=04c0C81<04^0B`1
:P4X0BH18`4P0Ad16P4G0A@14@4=0@X11`430Ol1o07h0OD1lP7^0N/1j07T0N41
gP7L0MT1eP7D0M81d07>0L`1b`7:0LT1b0770LL1a`770LL1b0790LX1b`7<0Lh1
c`7A0M@1eP7I0M/1gP7Q0N@1i`7Z0Nh1l@7e0OP1o0400@<11`4:0@h14@4E0AP1
6`4N0B41904W0BT1;04^0C01<P4d0CD1=P4g0CP1>@4i0CT1>@4i0CP1>04g0CD1
=04b0C41;`4/0BX19`4U0B817`4L0AP15@4B0@h12P470@<1o`7l0OP1m@7a0Nd1
jP7W0N<1h07M0MX1e`7E0M81d07>0L`1bP790LL1aP750LD1a0740L@1a@750LH1
a`780LX1b`7=0Ll1dP7D0ML1fP7M0N01h`7V0NX1k@7a0O@1n07l0@010`470@/1
3P4B0AH16@4L0B018`4V0BT1:`4^0C01<P4d0CH1>04i0CX1>`4k0C`1?04l0C/1
>`4j0CT1>04f0CD1<`4a0Bh1;04Y0BH18`4P0Ad16@4F0A813`4;0@L10`400O`1
n07d0O01k@7Y0ND1hP7O0M/1f07F0M<1d07>0L`1bP780LH1a@740L<1`P720L81
`P720L<1a0750LH1b0790L/1c@7@0M81e@7H0M/1gP7R0ND1j@7/0O01m07h0O`1
00430@L12`4?0A<15P4J0Ah18@4T0BL1:P4]0C01<P4d0CH1>04j0C/1?04m0Ch1
?P4n0Ch1?P4m0C`1>`4j0CT1=`4e0C<1<04^0B/1:04U0B417P4J0AL14`4?0@/1
1`430Ol1o07h0O@1l07/0NP1i07Q0Md1fP7G0M@1d@7>0L`1bP780LH1a0730L81
`@700L01_`700L01`@710L81a0750LL1b@7<0Lh1d@7C0MH1fP7M0N01i07X0N`1
k`7c0OL1n`400@@1204<0A01504G0A/17`4R0BH1:@4/0Bl1<P4d0CH1>04j0C`1
?@4o0Cl1@0510D41@@500D01?`4n0C`1>`4i0CL1=04b0Bl1;04Y0BH18`4O0A/1
604D0A0130480@@1o`7k0OL1l`7_0N/1i`7S0N01g07I0MD1dP7?0Ld1bP780LD1
a0720L01_`6n0Kh1_@6m0Kd1_P6n0Kl1`0720L<1a@770LX1c07?0M81e@7H0M`1
g`7S0NL1j`7_0O<1m`7k0Ol110480@`1404D0AP1704P0B<19`4Z0Bh1<@4c0CH1
>04k0C`1?P500D41@P520D<1@`530D<1@P510D01?P4m0C/1>@4f0C@1<@4^0B/1
9`4T0B01704I0AD1404<0@P1107o0O/1m`7c0Nl1jP7V0N81g`7K0ML1e07A0Lh1
b`780LH1``710L01_P6m0K`1^`6k0K/1^`6k0K`1_@6n0Kl1`@730LD1b07:0Ld1
d07D0ML1fP7N0N81iP7Z0Nh1l`7g0O/100440@P1304A0AD16@4M0B419@4X0B`1
;`4b0CD1>04j0Cd1?`500D81@`540DD1A@550DD1A@540D<1@P510Cl1?@4k0CP1
=@4c0C01;04Y0BD18@4M0AT15@4A0@d120440Ol1n`7g0O81kP7Z0NH1h@7N0MX1
eP7B0Ll1c0790LH1a0710Kl1_P6l0K/1^P6i0KT1^@6i0KT1^P6k0K`1_@6o0L41
``760LT1c07?0M81eP7I0Md1h@7U0NT1kP7b0OL1n`400@@1204=0A415P4J0Ah1
8P4V0BX1;@4a0C@1=`4j0C`1?P510D81A0550DH1A`570DP1A`570DH1A@540D<1
@@4o0Cd1>P4g0C@1<@4^0BX19P4R0Ah16P4F0A813@490@@1007k0OH1lP7]0NT1
i@7Q0M`1f07E0M41cP7:0LL1a0720L01_@6l0KX1^@6h0KL1]`6f0KH1]`6h0KT1
^P6k0Kd1_`720L@1a`7:0Ld1d@7D0MP1g07P0N@1j@7]0O81mP7k0@0110490@d1
4P4F0A/17`4S0BL1:`4_0C81=@4i0C/1?P500D<1A0560DL1B0590DX1BP5:0DT1
B0570DH1A@530D41?P4l0CT1=P4c0Bl1:`4W0B<17`4K0AL14P4=0@T1107o0O/1
mP7a0Nd1j07T0N01f`7G0M<1d07<0LT1aP730L01_P6l0KX1^06g0KH1]@6d0K@1
]06e0KD1]P6h0KT1^`6m0L01`P750LP1c07?0M<1e`7K0Ml1i07X0Nd1l@7f0O/1
00440@T13P4B0AL16`4P0B@1:04/0C01=04g0CX1?@500D81A0560DP1B@5:0D/1
C05<0D`1B`5;0DX1B0570DD1@`500Cd1>`4g0C@1<04]0BT1904P0A`15`4C0@h1
2@440Ol1n`7f0O41k07X0N<1g`7J0MH1dP7>0L/1a`740L41_P6l0KX1^06f0KD1
]06c0K81/P6b0K<1/`6d0KH1]`6i0K`1_P710L@1a`7:0Lh1dP7F0MX1gP7S0NL1
k07a0OH1n`400@@12@4>0A<1604L0B419@4Y0Bd1<@4e0CP1?04o0D81A0560DP1
BP5;0D`1C@5>0Dh1CP5=0Dd1C05:0DT1A`540D81?`4l0CT1=@4b0Bh1:P4U0B41
7@4H0A<13P490@@1007k0OH1l@7/0NL1hP7N0MT1e@7A0Ld1b@760L81_`6m0KX1
^06f0K@1/`6b0K41/06`0K01/@6a0K81]06f0KP1^P6l0Kl1`P750LT1c@7A0MD1
f@7N0N81i`7/0O41m@7j0@011@4:0@h14`4H0Ad18P4V0BX1;`4c0CH1>P4m0D01
@`560DP1BP5<0Dd1CP5?0E01D05@0Dl1C`5=0D`1BP580DH1A0510Ch1>P4g0C<1
;`4[0BH18P4M0AP1504?0@X11@7o0OX1m@7`0N/1iP7R0Md1f07D0M01c0780L@1
`@6n0K/1^06f0K@1/P6a0K01[`6^0Jh1[P6_0Jl1/@6b0K@1]P6h0K/1_@710L@1
b07;0Ll1e07H0Md1h@7V0N/1l07e0OX100450@X13`4D0AT17P4R0BL1:`4`0C@1
>04k0Cl1@P550DP1BP5<0Dh1C`5@0E41DP5B0E81D@5@0Dl1CP5<0DX1B0550D81
?`4l0CP1=04`0B`19`4S0Ah16@4D0@l12P450Ol1nP7e0O01j`7V0N41g07H0M<1
c`7;0LL1``6o0K`1^@6g0K@1/P6`0Jl1[P6]0J`1[06/0Jd1[P6_0K01/P6d0KH1
^@6l0Kl1``760LX1cP7C0ML1g07Q0NH1j`7`0OD1nP7o0@D12P4?0A@16@4N0B<1
:04]0C41=@4i0Cd1@0540DL1B@5<0Dh1D05A0E81D`5D0E@1E05C0E81D@5@0Dh1
C0590DL1A0510Cd1>@4e0C41;@4X0B@17`4J0AD13`4:0@D1o`7j0OD1l07Z0ND1
h07K0ML1dP7>0LT1a@720Kh1^`6h0KD1/`6`0Jl1[@6/0J/1ZP6Z0JX1Z`6/0Jd1
[P6`0K81]@6g0KX1_P710LD1b@7=0M81eP7K0N01i@7Z0Nl1m@7j0@011@4:0A01
5@4J0Al1904Y0Bh1<P4f0CX1?P520DD1B05;0Dd1C`5A0E<1E05E0ED1EP5E0ED1
E05C0E81D05>0D/1B0550D81?P4k0CL1<P4^0BT1904O0AX15@4@0@X11@7o0OX1
m@7_0NX1i@7P0M/1eP7A0L`1b0740L01_@6i0KH1/`6a0Jl1[@6[0JX1Z@6Y0JP1
Z@6Y0JX1Z`6]0Jh1/@6c0KH1^@6l0L01a0780L`1d@7E0MX1g`7T0NX1k`7e0OX1
00450@X1404E0A/1804U0BX1;P4c0CL1?04o0D<1A`5:0D`1C`5A0E<1E@5F0EL1
E`5G0EL1E`5F0ED1D`5A0Dl1C@5:0DL1@`500C`1>04c0Bl1:P4U0B016`4E0A01
2`450@01nP7d0Nl1j@7T0Ml1fP7E0M01b`770L<1_`6k0KP1]@6b0Jl1[@6[0JX1
Z06W0JL1Y`6W0JL1Z06Y0J/1[@6_0K81]06g0K/1_`730LL1b`7@0MD1fP7O0N@1
j@7_0O@1nP7o0@D12`4@0AH16`4P0BH1:`4_0C@1>@4m0D41A0580D/1CP5A0E<1
E@5F0EP1F05I0ET1F@5I0EP1EP5E0E<1D@5>0D/1B0550D41?@4i0C@1<04[0BH1
8@4K0AH1404;0@D1o`7j0O@1k`7Y0N@1gP7I0M@1c`7:0LH1`P6n0KX1]P6c0K01
[P6[0JT1Z06W0JH1Y@6U0JD1YP6V0JP1Z@6[0Jd1/06c0KH1^P6m0L41aP7:0Ll1
e07I0Mh1h`7Y0Nh1m07j0@011@4;0A415P4L0B419P4[0C01=@4j0Ch1@P560DT1
C@5?0E81E05F0EP1F@5J0E/1F`5K0EX1F@5H0EL1E@5B0E01C@5:0DH1@P4n0CX1
=@4a0B`19`4Q0A`15P4A0@/11@7o0OX1m07^0NT1h`7N0MP1d`7>0LT1a@700K`1
^@6e0K81[`6/0JX1Z06V0JD1Y06S0J<1X`6T0JD1YP6X0JX1[06_0K41]@6h0K`1
`0750LT1cP7C0MP1g@7S0NP1kP7d0OX1o`450@/14@4G0A`18P4W0B`1<@4f0C/1
?`530DL1B`5>0E41E05F0EP1FP5K0E`1G05M0E`1G05K0EX1F05F0E@1D@5>0D/1
A`530Cl1>`4f0C81;04W0B81704G0A412`450@01nP7d0Nh1j07S0Md1f07B0Ld1
b0740Kl1^`6g0K@1/06]0J/1Z06V0JD1X`6R0J81XP6R0J81X`6T0JH1Z06Z0Jd1
/06c0KL1^`6o0L@1b07=0M81e`7M0N81j07^0O@1nP400@D12`4A0AL17@4R0BP1
;@4b0CL1?0500D@1B05<0Dl1DP5E0EL1F@5K0E`1G@5N0Eh1GP5M0Ed1F`5J0EP1
E@5C0E01C0590DD1@04l0CL1<P4]0BP18P4M0AL14@4;0@D1o`7j0O@1kP7X0N81
g07G0M81c0780L<1_P6j0KH1/P6_0J`1Z@6W0JD1X`6R0J41X06P0J01X@6R0J<1
Y@6W0JT1[06_0K81]P6j0Kh1`P770L`1d@7G0M`1hP7X0Nh1l`7i0@011P4<0A41
5`4M0B<1:04^0C<1>04m0D41AP5:0Dd1D@5D0EH1F@5K0Ed1GP5O0F01H05P0El1
GP5M0E/1F@5G0E@1D@5=0DX1AP520Cd1>04c0Bh1:@4S0Ad1604B0@`11P7o0OT1
l`7]0NL1hP7L0MH1d@7<0LL1`P6m0KT1]@6a0Jh1Z`6X0JD1X`6R0J01W`6O0Ih1
W`6O0J01X@6S0JD1Z06Z0Jd1/@6e0KT1_@720LH1b`7A0MH1g07Q0NL1k@7c0OT1
o`460@`14P4H0Ah18`4Y0Bh1=04i0Ch1@P570D/1CP5B0ED1F05J0E`1GP5P0F01
H@5Q0F41H@5P0Eh1G@5J0EP1E@5B0Dl1B`570D<1?P4i0C@1;`4Y0B@17P4H0A81
30460Ol1n@7c0Nd1i`7Q0M/1eP7@0L/1aP710K`1^06d0K01[06Y0JH1Y06R0J01
W`6N0Id1W@6M0Ih1W`6P0J81Y06V0JT1[06`0K<1^06l0L41a@7;0M01e@7K0N41
i`7]0O<1n@400@H1304B0AP17P4T0BX1;`4e0CX1?`530DP1C05@0E<1EP5I0E`1
GP5P0F41HP5S0F<1H`5R0F41H05N0E`1F@5G0E<1D05<0DP1A04o0CX1=@4_0BX1
904N0AP14P4<0@H1o`7i0O<1k@7W0N41f`7E0Ll1bP750L01^`6g0K<1[`6[0JP1
Y@6S0J01W`6M0I`1W06L0I`1W06M0Il1X06R0JD1Z06[0Jl1/P6f0K/1`0750LX1
c`7E0M/1h@7W0Nd1l`7i0@011P4<0A81604O0B@1:P4`0CD1>`500D@1B@5=0E41
E05H0E/1G@5O0F41HP5S0F@1I05T0F<1HP5Q0El1G@5K0EP1E@5A0Dd1B@550D01
>`4f0C01:P4U0Al16@4B0@`11P400OT1l`7]0NH1h07J0M@1c`790L@1_`6j0KH1
/P6^0JX1Y`6T0J41W`6M0I`1V`6J0IX1VP6K0I`1W@6O0J41Y06W0JX1[@6a0KD1
^P6o0L@1b@7?0M@1fP7P0NH1k07c0OT100460@`14`4I0Al19@4[0C41=P4k0D01
A@5:0Dh1DP5F0ET1G05N0F41HP5T0FD1I@5V0FD1I@5T0F81H@5N0E`1F@5F0E81
CP5:0DD1@@4l0CH1<@4[0BD17`4I0A<130460Ol1n@7c0N`1iP7P0MX1e07>0LT1
``6n0KT1]@6`0J`1Z@6V0J<1X06N0I`1V`6J0IT1V@6I0IX1V`6L0Ih1X06R0JD1
Z@6/0K01]06i0Kh1``780Lh1e07J0N01iP7/0O<1n@400@H1304C0AT17`4U0B/1
<@4g0C`1@@560D/1C`5C0EL1FP5M0F01HP5T0FD1IP5W0FL1I`5V0FD1I05R0F01
G@5J0EL1D`5?0D/1AP520C`1=`4a0B`19P4P0AT14`4<0@H1o`7i0O81k07V0Ml1
f@7C0Ld1b0720Kd1^06d0Jl1Z`6X0J@1X@6O0Id1V`6I0IP1V06G0IP1V06I0I/1
W06O0J41Y06X0J/1[`6d0KP1_@720LP1c@7C0MT1g`7V0N`1lP7i0Ol11P4=0A<1
6@4P0BH1;04b0CP1?@520DL1C05@0E@1F05K0Eh1H@5S0FD1IP5W0FP1J05X0FL1
IP5U0F<1H@5N0E/1F05D0E01C0570D81?@4h0C81;04V0B016P4C0@d11P7o0OT1
lP7/0ND1g`7I0M<1c@770L81_06g0K<1[P6Z0JL1X`6P0Ih1V`6J0IP1U`6F0IH1
UP6G0IP1V@6K0Id1X06S0JH1ZP6^0K<1]`6l0L41a`7=0M<1f@7O0ND1k07b0OT1
00460@d14`4J0B019P4]0C81>04n0D<1B05=0E41E@5I0E`1G`5R0F@1IP5X0FT1
J@5Y0FT1J@5X0FH1I05R0El1G05I0ED1D@5=0DP1@`4n0CP1<`4]0BL1804J0A<1
3@460Ol1n@7b0N`1i@7O0MP1dP7<0LH1`@6l0KL1/P6]0JT1YP6R0Il1W06J0IP1
U`6F0ID1U@6E0IH1U`6H0IX1W06O0J81Y@6Y0Jd1/P6f0K/1`@760L`1dP7H0Mh1
i@7[0O81n@400@H13@4D0AX18@4W0Bd1<`4i0Ch1A0590Dh1DP5F0EX1G@5P0F<1
I@5W0FT1JP5Z0F/1J`5Z0FT1I`5V0F<1H@5N0EX1EP5B0Dh1B@540Cl1>@4c0Bd1
9`4Q0AX1504=0@H1007i0O81j`7U0Mh1f07B0L`1aP700K/1]P6a0Jd1Z06U0J41
WP6K0IT1U`6F0ID1U06D0I@1U@6F0IL1V@6K0Ih1X@6T0JP1[06a0KH1^`700LH1
b`7B0MP1gP7U0N/1lP7i0@011P4=0A@16P4Q0BL1;P4d0CT1?`540DX1CP5C0EL1
F`5N0F41I05W0FP1JP5[0F`1K05/0F/1JP5Y0FL1I05R0El1F`5G0E<1C`5:0DD1
?`4j0C@1;P4W0B416`4D0@d11P7o0OT1lP7[0N@1gP7G0M41b`750L01^P6e0K01
[06W0J@1X06M0IX1V06F0ID1T`6C0I<1T`6C0I@1UP6H0IX1W@6P0J<1Y`6[0K01
]@6j0Kl1a@7;0M41e`7N0N@1j`7b0OT100460@d1504K0B41:04^0C@1>P500DD1
BP5?0E@1F05L0El1H`5U0FP1JP5[0F`1K@5]0Fd1K05[0FX1J05U0F<1H05L0EP1
E05?0D/1A@500CX1=04^0BP18@4K0A@13@460Ol1n@7b0N/1i07N0ML1d@7;0LD1
_`6i0K@1[`6[0JL1X`6O0I`1V@6G0ID1T`6B0I81T@6B0I81T`6E0IL1V@6L0Il1
XP6V0J/1[`6d0KT1_`740LX1d@7G0Md1i07[0O81n@400@H13@4D0A/18P4X0Bl1
=@4k0D01AP5;0E01E@5I0Ed1H05T0FH1J@5[0F`1K@5^0Fh1KP5]0F`1J`5Y0FH1
I05Q0Ed1F@5E0E01B`560D41>`4e0Bl1:04R0A/1504=0@H1o`7i0O81j`7T0Md1
e`7@0LX1a06n0KT1/`6_0JX1YP6R0Ih1V`6H0IH1U06B0I41T@6@0I41T@6B0I@1
UP6H0I/1WP6R0JD1ZP6^0K<1^@6n0L@1bP7@0MH1g@7T0N/1lP7i0@011P4=0A@1
6`4R0BT1;`4e0C/1@@570D`1D@5E0EX1GP5Q0FD1I`5Z0F`1K@5^0Fl1K`5_0Fh1
K@5/0FX1I`5U0F41GP5J0EH1D@5<0DL1@@4k0CD1;`4Y0B816`4D0@h11`400OP1
l@7[0N@1g@7F0M01bP730Kh1^06c0Jh1Z@6U0J41W@6J0IL1U@6C0I41T06@0Hl1
S`6@0I41T`6E0IL1VP6M0J41Y@6Y0Jh1/`6h0Kd1``790M01eP7M0N@1jP7a0OP1
00470@h15@4K0B81:@4_0CH1?0520DL1C@5B0EH1F`5O0F81I@5X0F/1K@5^0Fl1
L05`0G01K`5^0Fd1J`5X0FH1HP5O0E/1EP5B0Dd1A`520C`1=P4`0BT18P4L0AD1
3P470Ol1n07a0NX1h`7M0MH1c`790L<1_@6g0K81[@6X0J@1X06L0IT1UP6D0I81
T06?0Hh1SP6>0Hl1T06B0I@1UP6I0I`1X06T0JP1[@6b0KL1_@730LT1c`7F0M`1
h`7Z0O41n0400@L13P4E0A`18`4Y0C01=P4l0D81B05=0E81E`5K0El1H`5V0FT1
K05^0Fl1L05a0G41L@5`0Fl1KP5/0FT1IP5S0F01G05G0E81C@580D81?@4f0C01
:@4S0A`15@4>0@L1o`7h0O41jP7S0M`1eP7?0LT1`P6l0KL1/@6/0JP1X`6O0I/1
V06E0I<1T@6?0Hh1SP6=0Hh1SP6?0I41T`6E0IP1V`6O0J<1Y`6/0K41]`6l0L81
b07?0MD1g07S0NX1l@7h0@011`4>0AD1704S0BX1<04g0Cd1@`590Dh1D`5H0E`1
H05T0FL1JP5]0Fl1L05a0G81LP5b0G41L05_0Fd1JP5W0F@1H05L0EP1D`5>0DT1
@`4m0CL1<04Z0B<1704E0@h11`7o0OP1l@7Z0N<1g07E0Ll1b0720K`1]P6a0J`1
Y`6R0Ih1V`6G0I@1TP6@0Hh1S@6=0H`1S@6=0Hh1T06B0I@1U`6K0Ih1XP6W0J/1
/@6f0K`1`P780Lh1e@7L0N<1jP7a0OP100470@h15@4L0B<1:P4a0CL1?@530DT1
C`5D0ET1G@5Q0FD1J05[0Fd1K`5a0G81L`5c0G<1LP5a0G01KP5[0FP1I@5Q0Ed1
F@5D0Dl1B@540Ch1=`4a0BX18`4L0AD13P470Ol1n07a0NX1h`7L0MD1cP780L41
^`6f0K01Z`6V0J81WP6J0IL1U06A0Hl1SP6<0H`1R`6<0H`1S@6?0I41U06F0IX1
W@6R0JH1Z`6`0KD1^`710LP1cP7E0M`1h`7Z0O41n0400@L13P4E0A`18`4Z0C41
>04n0D@1BP5?0E@1F@5N0F81IP5Y0F`1KP5`0G81L`5d0G@1M05c0G81L05^0F`1
J@5V0F81GP5I0ED1C`5:0D@1?P4h0C41:P4T0Ad15@4>0@L1o`7h0O41jP7R0M/1
e@7>0LL1`@6k0KD1/06Z0JD1X@6M0IT1UP6C0I01SP6=0H/1R`6;0H/1R`6=0Hh1
T06C0IH1V@6M0J41Y@6Z0Jl1]@6k0L41a`7>0M@1f`7R0NX1l@7h0@011`4>0AD1
7@4T0B/1<@4h0Ch1A05:0E01E@5J0Eh1H`5V0FX1K@5_0G41L`5d0GD1M@5e0G@1
L`5a0Fl1K@5Z0FH1H`5O0EX1E@5@0DX1A@4n0CP1<P4[0B@17@4F0@h11`7o0OP1
l@7Y0N81f`7D0Ld1a`700KX1]06_0JX1Y@6P0I`1V06E0I81T06=0H`1R`6:0HX1
RP6;0H`1S@6?0I81U@6H0I`1X06U0JX1[`6d0KX1`0770Ld1e07K0N81j@7a0OP1
00470@h15P4M0B@1:`4b0CP1?`550D/1D05F0EX1G`5S0FL1JP5]0G01LP5d0GD1
M@5f0GD1M@5d0G81L05]0FX1I`5S0El1F`5F0E01B`550Cl1>@4b0B/1904M0AH1
3P470Ol1n07a0NT1hP7K0M@1c@760L01^P6d0Jh1Z@6T0J01V`6H0I@1T@6?0Hd1
R`6:0HT1R@690HX1R`6=0Hl1T@6D0IP1V`6O0J@1Z@6^0K@1^P700LH1c@7D0M/1
hP7Y0O41n0400@L13P4F0Ad1904[0C81>@4o0DD1B`5A0EH1F`5P0F@1J05[0Fh1
L@5c0G@1MP5f0GH1MP5f0G@1L`5a0Fh1J`5X0F@1H05K0EH1D@5;0DH1?`4i0C81
:`4T0Ad15P4>0@L1007h0O41j@7R0M/1e07=0LH1`06i0K<1[P6Y0J@1W`6K0IL1
U06A0Hh1S06:0HT1R0680HP1R@6:0H`1SP6@0I<1U`6K0Il1X`6X0Jh1/`6i0Kl1
aP7=0M@1f`7R0NT1l@7h0@011`4>0AH17@4T0B`1<P4i0D01AP5<0E41E`5L0F01
I@5X0F`1K`5a0G<1M@5f0GL1M`5g0GH1M@5d0G41K`5/0FP1I@5P0E`1E`5B0D`1
AP500CT1<`4/0BD17@4F0@l11`7o0OP1l07Y0N81fP7C0L`1aP6o0KT1/`6]0JP1
X`6N0IX1UP6C0I01S@6;0HX1R0680HL1R0680HT1R`6=0I01T`6F0IX1WP6S0JP1
[@6c0KT1_`760L`1d`7J0N81j@7`0OP100470@l15P4M0BD1;04c0CT1@0560D`1
DP5G0E`1H@5U0FT1K05_0G81M05f0GL1N05h0GP1M`5f0G@1LP5`0Fd1J@5U0F41
G05G0E81C0560D01>P4c0B`19@4M0AH13`470Ol1n07`0NT1h@7J0M<1c0750Kl1
^@6c0Jd1Y`6R0Ih1VP6F0I81S`6=0H/1R@680HL1Q`670HP1R@6:0Hd1S`6B0IH1
V@6N0J81Y`6]0K81^06o0LD1c07C0MX1h@7Y0O01n07o0@L13`4F0Ah19@4/0C<1
>P500DL1C@5B0EP1G@5Q0FH1JP5]0G01L`5e0GH1N05h0GT1N05h0GL1M@5c0G01
K@5Z0FH1HP5M0EP1D`5=0DL1@04j0C<1;04U0Ah15P4?0@L1o`7h0O01j@7Q0MX1
d`7<0LD1_P6h0K81[06W0J81W@6I0ID1TP6?0H`1RP680HL1QP660HH1Q`680HX1
S06>0I81U@6I0Id1XP6W0J`1/P6h0Kh1a@7<0M<1fP7Q0NT1l07h0@011`4?0AH1
7P4U0B`1<`4j0D41A`5=0E<1F05M0F81IP5Z0Fh1L@5c0GD1M`5h0GT1N@5i0GP1
M`5f0G<1L@5^0FX1IP5R0Ed1F05C0Dd1A`510CX1<`4/0BD17P4F0@l11`7o0OP1
l07Y0N41fP7C0L`1a@6n0KP1/P6/0JL1X@6M0IP1U@6A0Hh1R`690HP1QP660HD1
QP660HL1R@6;0Hh1T@6D0IP1W@6Q0JH1[06b0KP1_P750L/1dP7J0N41j@7`0OP1
00470@l15P4N0BD1;@4d0CX1@@570Dh1D`5I0Eh1H`5W0F/1KP5a0G@1MP5h0GT1
NP5j0GX1N@5h0GH1M05a0Fh1J`5W0F<1GP5I0E<1CP580D41>`4d0Bd19@4N0AH1
3`470Ol1n07`0NT1h@7J0M81b`740Kh1]`6a0J`1YP6Q0I`1V06D0I01S@6;0HT1
Q`660HD1Q@650HH1Q`690H/1S@6@0I@1V06L0J41YP6[0K41]`6n0L@1b`7B0MX1
h@7X0O01n0400@L13`4G0Ah19@4]0C@1>`510DP1CP5D0ET1GP5S0FL1J`5_0G81
M@5g0GP1NP5j0G/1NP5j0GP1M`5e0G81K`5[0FL1H`5N0ET1E05>0DP1@@4k0C@1
;@4V0Ah15`4?0@L1o`7h0O01j07Q0MT1dP7;0L@1_@6g0K41Z`6V0J01W06G0I<1
T06=0HX1R0660HD1Q0640H@1Q@660HP1RP6=0I01T`6G0I`1X06V0J/1/@6g0Kd1
a07;0M81f@7Q0NP1l07h0@011`4?0AL17P4V0Bd1=04k0D81B05>0E@1FP5O0F<1
J05/0Fl1LP5e0GL1N@5j0G/1N`5k0GX1N@5g0GD1LP5_0F`1J05T0El1FP5D0Dh1
B0520C/1=04]0BH17P4G0@l11`7o0OP1l07X0N41f@7B0L/1a06m0KL1/@6[0JD1
X06K0IL1T`6?0H`1RP670HH1Q@640H@1Q0650HH1Q`6:0H`1S`6C0IL1V`6P0JD1
Z`6`0KL1_@740L/1dP7I0N41j07`0OP100470@l15`4N0BH1;@4d0C/1@P580Dl1
E05J0El1I05X0F`1L05c0GH1N05i0G/1N`5l0G/1N`5j0GP1MP5c0G01K05X0F@1
G`5J0ED1C`590D81>`4d0Bd19P4N0AL13`470Ol1n07`0NP1h@7I0M81b`740Kd1
]P6`0JX1Y@6P0I/1UP6B0Hl1S0690HL1Q@640H<1P`630H@1Q@670HT1S06?0I81
UP6K0J01Y@6Z0K01]P6m0L@1bP7B0MT1h@7X0O01n07o0@L13`4G0Ah19P4]0CD1
?0520DT1C`5E0EX1H05T0FT1K@5`0G<1MP5h0GX1N`5l0G`1O05k0GX1N05f0G<1
L05]0FT1I05P0EX1E@5?0DT1@P4l0CD1;@4V0Al15`4?0@L1o`7h0O01j07P0MT1
dP7:0L<1_@6f0K01ZP6T0Il1VP6F0I81SP6;0HT1QP650H@1P`630H<1Q0650HH1
R@6;0Hh1TP6F0IX1W`6T0JX1/06f0Kd1``7:0M41f@7P0NP1l07h0Ol11`4?0AL1
7`4V0Bh1=@4l0D<1B@5?0ED1F`5P0FD1J@5]0G41M05g0GT1NP5l0G`1O@5l0G`1
NP5i0GL1M05a0Fd1J@5U0F01F`5E0Dl1B@530C`1=@4^0BH17`4G0@l11`7o0OP1
l07X0N01f@7A0LX1``6l0KH1/06Z0J@1W`6J0IH1TP6>0H/1R0660H@1P`620H81
PP630H@1QP680H/1SP6B0IH1VP6O0J@1ZP6`0KH1_0730LX1d@7I0N01j07`0OP1
00470@l15`4O0BH1;P4e0C`1@`590E01E@5K0F01I@5Z0Fh1L@5d0GL1N@5k0G`1
O@5m0Gd1O05k0GT1M`5d0G41KP5Z0FD1H05K0EH1D0590D<1?04e0Bh19P4O0AL1
3`470@01n07`0NP1h07I0M41bP730K`1]P6_0JT1Y06O0IX1U@6A0Hh1RP680HH1
Q0630H81PP620H<1Q0660HP1RP6>0I41U@6J0Ih1Y06Y0Jl1]@6l0L<1bP7A0MT1
h07X0O01n0400@L13`4G0Al19P4^0CD1?0530DX1D05F0E/1H@5U0FX1KP5b0GD1
M`5j0G/1O@5m0Gh1O@5m0G/1NP5g0GD1LP5^0FX1IP5Q0E/1EP5@0DX1@`4l0CD1
;P4V0Al15`4?0@L1007h0O01j07P0MP1d@7:0L<1_06e0Jl1Z@6S0Ih1V@6E0I41
S@6:0HL1Q@630H81P@610H41PP630HD1Q`6:0Hd1T@6E0IT1WP6S0JT1[`6e0K`1
``7:0M41f07P0NP1l07h0@011`4?0AL17`4W0Bh1=@4l0D<1BP5@0EH1G05Q0FH1
JP5^0G81M@5h0GX1O05m0Gh1OP5n0Gd1O05j0GP1M@5b0Fh1JP5V0F41G05F0E01
BP530C`1=@4^0BL17`4G0@l11`7o0OP1l07X0N01f07A0LX1``6l0KD1[`6Y0J<1
WP6I0ID1T@6=0HX1Q`650H<1PP610H41P@620H<1Q@670HX1S@6@0ID1V@6N0J<1
Z@6_0KD1_0720LX1d@7H0N01j07`0OP1o`470@l15`4O0BL1;P4e0Cd1@`5:0E01
EP5L0F41IP5[0Fl1LP5e0GP1NP5l0Gd1OP5n0Gh1O@5l0GX1N05e0G81K`5[0FH1
H@5L0EH1D05:0D@1?@4f0Bh19`4O0AL13`470Ol1n07`0NP1h07H0M41b@720K/1
]@6_0JT1X`6N0IT1U06@0Hd1R@670H@1P`610H41P0610H41P`640HL1R@6=0I01
U06I0Ih1X`6Y0Jh1]@6k0L81b@7A0MP1h07X0O01n0400@L13`4G0Al19`4^0CH1
?@540DX1D@5G0E`1H@5V0F/1K`5c0GH1N05k0G`1OP5n0Gl1OP5n0G`1N`5i0GH1
L`5_0F/1IP5R0E`1E`5A0DX1A04m0CH1;P4W0Al15`4?0@L1007h0O01j07P0MP1
d@790L81^`6e0Jh1Z06S0Id1V06D0I01S0690HH1Q0620H41P0600H01P@620H@1
QP690H`1T06D0IP1W@6S0JP1[P6e0K/1`P790M41f07P0NP1l07g0@01204?0AL1
7`4W0Bh1=P4m0D@1BP5A0EL1G05R0FL1J`5_0G<1MP5i0G/1O@5n0Gl1O`5o0Gh1
O@5k0GT1MP5c0Fl1J`5W0F81G05G0E41BP540Cd1=P4^0BL17`4G0@l120400OL1
l07X0N01f07A0LT1`P6k0K@1[P6X0J81W@6H0I@1T06<0HT1QP640H81P@600H01
P0610H81Q0660HT1S06@0I@1V06M0J81Z06^0K@1^`720LT1d07H0N01j07_0OL1
00480A015`4O0BL1;`4f0Cd1A05;0E41E`5M0F81I`5[0Fl1L`5f0GT1N`5m0Gh1
O`5o0Gl1OP5m0G/1N@5f0G<1L05[0FL1HP5M0EL1D@5;0D@1?@4f0Bl19`4O0AL1
40480Ol1m`7_0NP1h07H0M01b@720K/1]06^0JP1XP6M0IP1T`6?0H`1R@660H@1
PP610H01P0600H41PP640HH1R@6<0Hl1T`6H0Id1XP6X0Jh1]06k0L81b@7@0MP1
h07X0Nl1m`400@P1404G0Al19`4_0CH1?@540D/1D@5G0Ed1HP5W0F`1L05c0GL1
N@5l0Gd1O`5o0Gl1O`5o0Gd1O05i0GL1L`5`0F`1I`5R0Ed1E`5A0D/1A04m0CH1
;`4W0Al1604@0@P1o`7g0Nl1i`7P0MP1d0790L81^`6d0Jh1Z06R0Id1V06C0Hl1
R`680HH1P`620H01P0600H01P0620H<1QP680H/1S`6C0IP1W@6R0JP1[P6d0K/1
`P790M01f07P0NL1k`7g0Ol1204@0AP17`4W0Bl1=P4m0D@1B`5A0EL1G@5R0FL1
K05`0G@1M`5j0G`1OP5o0Gl1O`5o0Gl1OP5l0GX1M`5d0G01K05W0F81G@5G0E41
B`540Cd1=P4_0BL17`4H0A01207o0OL1k`7W0N01f07@0LT1`P6k0K@1[P6X0J81
W@6H0I<1S`6;0HP1Q@630H41P0600H01P0600H41P`650HP1R`6?0I<1V06M0J81
Z06^0K@1^`720LT1d07H0N01i`7_0OL100480A01604O0BL1;`4f0Cd1A05;0E41
E`5M0F<1I`5/0G01M05g0GX1O05n0Gl1O`5o0Gl1O`5n0G`1NP5g0G@1L05/0FP1
H`5M0EP1D@5;0D@1?@4f0Bl19`4O0AP140480Ol1m`7_0NL1h07H0M01b@720K/1
]06^0JL1XP6L0IL1T`6?0H/1R0650H<1P@600H01P0600H01P@630HD1R06;0Hl1
T`6G0I`1XP6W0Jd1]06k0L81b@7@0MP1g`7W0Nl1m`400@P1404H0B019`4_0CH1
?P540D/1DP5H0Ed1H`5X0F`1L05d0GL1NP5l0Gh1O`5o0Gl1O`5o0Gh1O05j0GL1
M05`0F`1J05S0Ed1F05B0D/1A04n0CH1;`4W0B01604@0@P1007g0Nl1i`7O0MP1
d0790L41^P6d0Jd1Y`6R0I`1U`6C0Hl1R`680HD1P`610H01P0600H01P0610H<1
Q@680H/1S`6C0IL1W06R0JL1[@6d0KX1`@790M01f07O0NL1k`7g0@01204@0AP1
804W0Bl1=P4n0DD1B`5B0EP1G@5S0FP1K05`0G@1M`5j0G`1OP5o0Gl1O`5o0Gl1
OP5l0GX1M`5d0G01K05X0F<1G@5H0E81B`550Ch1=P4_0BL1804H0A01207o0OL1
k`7W0Ml1f07@0LT1`@6j0K@1[@6W0J41W06G0I<1SP6;0HP1Q@630H41P0600H01
P0600H41P`650HP1R`6>0I<1U`6L0J41Y`6]0K@1^P710LT1d07H0Ml1i`7_0OL1
00480A01604P0BL1;`4f0Ch1A@5;0E81F05N0F<1J05/0G41M05g0GX1O05n0Gl1
O`5o0Gl1O`5n0G`1NP5g0G@1L@5/0FP1H`5N0EP1DP5;0DD1?P4f0Bl19`4P0AP1
40480Ol1m`7_0NL1g`7H0M01b@710KX1]06]0JL1X@6L0IL1T`6>0H/1Q`650H81
P@600H01P0600H01P@620HD1Q`6;0Hh1TP6G0I`1X@6W0Jd1]06j0L41b@7@0MP1
g`7W0Nl1m`7o0@P1404H0B019`4_0CH1?P550D/1DP5H0Eh1H`5X0Fd1L@5d0GP1
NP5m0Gh1O`5o0Gl1O`5o0Gh1O@5j0GP1M05a0Fd1J05S0Eh1F05B0D/1A@4n0CH1
;`4W0B01604@0@P1o`7g0Nl1i`7O0MP1d0780L41^P6d0Jd1Y`6Q0I`1U`6B0Hh1
R`670HD1PP610H01P0600H01P0610H81Q@670H/1SP6B0IL1W06Q0JL1[@6d0KX1
`@780M01f07O0NL1k`7g0@01204@0AP1804W0Bl1=`4n0DD1B`5B0EP1GP5S0FP1
K@5a0G@1N05j0Gd1OP5o0Gl1O`5o0Gl1OP5m0GX1N05d0G41K@5X0F<1GP5H0E81
B`550Ch1=`4_0BL1804H0A01207o0OL1k`7W0Ml1f07@0LP1`@6j0K@1[@6W0J41
W06G0I81SP6;0HL1Q@620H41P0600H01P0600H41PP650HL1R`6>0I81U`6L0J41
Y`6]0K@1^P710LP1d07H0Ml1i`7_0OL100480A01604P0BL1;`4g0Ch1A@5;0E81
F05N0F<1J05]0G41M05h0GX1O@5o0Gl1O`5o0Gl1O`5o0Gd1NP5h0G@1L@5]0FP1
H`5N0EP1DP5<0DD1?P4g0Bl19`4P0AP140480@01m`7_0NL1g`7H0M01b0710KX1
/`6]0JL1X@6L0IL1TP6>0HX1Q`650H81P0600H01P0600H01P0620HD1Q`6:0Hh1
TP6G0I`1X@6W0Jd1/`6j0L41b07@0MP1g`7W0Nl1m`400@P1404H0B019`4_0CL1
?P550D`1DP5H0Eh1H`5X0Fd1L@5e0GP1NP5m0Gl1O`5o0Gl1O`5o0Gl1O@5j0GP1
M@5a0Fd1J05S0Eh1F05B0D`1A@4n0CL1;`4W0B01604@0@P1o`7g0Nl1i`7O0MP1
d0780L41^P6c0Jd1Y`6Q0I`1U`6B0Hh1RP670H@1PP600H01P0600H01P0600H81
Q0670HX1SP6B0IL1W06Q0JL1[@6c0KX1`@780M01f07O0NL1k`7g0@0100410@81
0`440@H11`490@/1304>0A014P4D0AH1604J0Ad17`4Q0B<19P4X0B/1;@4_0C81
=04g0CT1?04n0D41@`560DP1B`5=0E01DP5E0EL1F@5L0Eh1H05R0F@1I`5Y0F/1
K05^0G01LP5c0GD1MP5h0GT1NP5k0G`1O@5n0Gl1O`5o0Gl1O`5o0Gl1O`5o0Gl1
O`5o0Gh1O@5l0G/1NP5i0GL1MP5d0G81L05]0F/1J@5V0F<1H05M0EX1E`5D0E01
C@590DD1@@4m0CT1=@4a0Bd1:04T0Al16P4F0A4130480@<1oP7i0O@1k`7[0NH1
h@7L0ML1d`7>0LT1a@700K`1^06d0K01[06X0J@1X@6M0IX1U`6D0I41SP6<0HX1
R0660H@1PP610H01P0600H01P0600H01P0600H41PP640HD1Q`690H`1SP6A0I@1
U`6K0Ih1XP6V0JX1[`6c0KP1_@720LL1c07A0ML1g07R0NP1kP7c0OT1o`450@/1
4@4G0A`18P4X0Bh1<`4i0Ch1@`580Dd1DP5F0E/1G`5S0FL1JP5^0G41M05f0GT1
N`5l0Gh1O`5o0Gl1O`5o0Gl1O`5o0Gh1O05j0GP1MP5c0G01K05Y0FD1H@5M0EP1
D`5>0DT1A04n0CP1<P4/0BH1804I0A<130460Ol1n07b0N/1i@7N0MP1d@7;0LD1
_`6j0K@1[`6Z0JD1X06K0IL1T`6@0Hd1RP670HD1P`610H01P0600H01P0600H01
P@630HD1Q`6:0Hd1T@6E0IT1W@6R0JL1[06a0KL1_@730LX1d07G0Mh1i@7/0O<1
nP410@P1404G0Ah19@4/0C81>@4o0DD1B`5A0EL1G05Q0FH1JP5^0G81M@5h0GX1
O05n0Gl1O`5o0Gl1O`5o0Gh1O05j0GP1M@5b0Fh1JP5U0F41G05F0E01BP540Ch1
=`4`0BT18@4J0A<12`430O`1m07/0ND1g@7F0Ll1b0710KX1]06^0JP1XP6M0IP1
U06@0H`1R@660H@1PP600H01P0600H01P0610H<1Q@680H/1S`6C0IL1W06Q0JL1
[@6c0KX1`@780Ll1e`7N0NH1kP7f0Oh11P4>0AH17P4V0Bh1=@4l0D<1BP5A0EL1
G@5R0FL1K05`0G@1M`5j0G`1OP5o0Gl1O`5o0Gl1OP5m0GX1M`5d0G01K05W0F81
G@5G0E01BP530C/1=04/0B@1704D0@/10`7k0O81jP7R0MX1dP7:0L81^`6d0Jd1
Y`6Q0I/1UP6A0Hd1RP660H@1PP600H01P0600H01P@620HD1R06;0Hl1U06I0Ih1
Y06Z0K41^06o0LL1c`7G0N01j07a0OT10P4;0A<1704U0Bd1=@4m0D@1C05C0ET1
G`5U0FX1K`5c0GL1NP5l0Gh1O`5o0Gl1O`5o0Gd1N`5h0G@1L05/0FL1H@5K0ED1
CP560Cl1=`4^0BH17@4D0@/10P7i0O01i`7O0MH1c@750Kd1]P6^0JP1X@6K0IH1
T@6<0HT1Q@630H41P0600H01P0610H81Q@680H`1T06E0I/1X@6W0Jh1]@6m0LD1
cP7F0Ml1j07b0O/1104=0AL1804Y0C41>P520DX1D@5H0El1I@5Z0Fl1M05g0G/1
O@5o0Gl1O`5o0Gl1O@5k0GP1M@5`0F/1IP5P0ET1DP5;0D<1>`4b0BT1804G0@d1
107j0O41i`7N0MD1c0730K/1/`6/0J@1WP6H0I<1SP6:0HH1P`610H01P0600H01
P@630HH1RP6>0I<1V06N0JD1[06d0K`1a07=0MH1h07Y0O<1o@470A016P4S0Bd1
=P4o0DL1C`5F0Ed1I05Z0Fl1M05g0G/1O@5o0Gl1O`5o0Gh1O05j0GH1LP5]0FL1
H@5K0E<1B`530CX1<@4X0Al15@4;0@41m`7]0N<1f@7@0LL1_P6e0Jh1YP6O0IT1
T`6>0HX1QP630H41P0600H01P0620HD1R06<0I41UP6L0J<1Z`6c0K/1a07=0MH1
h07Z0O@1o`490A<17@4W0C01>P530D/1D`5K0F81J05^0G<1M`5j0Gd1O`5o0Gl1
O`5n0G`1N@5e0G01J`5U0Eh1E`5?0DL1?P4d0B/18@4G0@`10P7h0Nd1h`7I0Ll1
aP6m0K@1[06T0Id1U`6A0H`1R0640H81P0600H01P0620H@1R06<0I41UP6M0J@1
Z`6d0K`1aP7?0MT1i07^0OP10`4>0AP18P4/0CH1@0590E41F@5P0FL1K@5b0GL1
NP5m0Gl1O`5o0Gl1O@5k0GL1L`5^0FP1HP5J0E<1BP510CP1;P4T0AT13`440OT1
kP7T0MT1c`750K`1/`6[0J<1W06E0I01R`670H<1P@600H01P0610H<1QP6:0Hl1
U@6K0J<1Z`6c0K`1aP7?0MX1i07_0OX11@4@0A/19@4`0CX1@`5<0ED1G@5T0FX1
L05e0GT1O05n0Gl1O`5o0Gd1N`5h0G<1KP5X0F41FP5B0DT1?`4f0B/18@4F0@/1
007e0NX1g`7D0LX1`06g0Jh1Y@6N0IL1T@6<0HL1Q0620H01P0600H41Q0670H/1
T06F0Id1Y@6]0KH1_`790M<1gP7Y0O@1o`4;0AH18@4/0CH1@05:0E81F`5R0FT1
K`5d0GP1O05n0Gl1O`5o0Gd1NP5g0G81K@5V0El1E`5>0DD1>`4a0BH16`4@0@D1
n@7^0N<1f07=0L<1^@6`0JL1W`6H0I81S0680H@1PP600H01P0620H@1R06<0I81
V06O0JL1/06i0L<1c@7H0N<1k`7j0@H14@4M0BP1<`4m0DL1D05I0F41J05^0G<1
N05k0Gh1O`5o0Gh1O@5j0GH1L@5[0FD1G@5E0D`1@P4h0Bd18P4G0@/1o`7d0NP1
g@7B0LL1_@6c0JX1XP6J0I<1SP690HD1PP600H01P0620H@1R06=0I81V@6P0JT1
/P6k0LH1d07K0NL1l`7n0@X15P4R0Bd1>0520D`1E@5M0FD1K05b0GH1NP5m0Gl1
O`5o0Gd1NP5f0G41K05U0Ed1E@5;0D41=`4/0B415@490Od1l@7U0MX1cP740KT1
/06W0Ih1U`6A0H/1Q`640H41P0600H41Q0670H/1T@6G0Il1Y`6`0KX1a07?0MX1
iP7b0Oh12P4F0B81;@4h0D<1C@5F0El1IP5]0G<1M`5k0Gd1O`5o0Gh1O05h0G@1
K`5X0F41F05?0DD1>`4`0B@16@4=0@01m07X0M`1d@760K/1/@6X0Il1V06A0H`1
Q`640H41P0600H81Q0680H`1TP6I0J41Z@6c0Kd1b07C0Ml1j`7g0@<1404L0BP1
<`4n0DT1DP5K0F<1J`5a0GH1NP5m0Gh1O`5n0G`1N@5d0Fl1J@5Q0ET1C`550C/1
;`4T0AP12`7o0O<1iP7J0Lh1``6i0Jl1Y@6M0IH1S`6:0HH1P`610H01P@630HH1
RP6@0IH1WP6V0Jl1^@740M01f`7X0O@10@4=0AT19P4a0Cd1A`5A0E/1H`5Z0G01
MP5j0G`1OP5n0Gh1N`5h0G<1KP5W0El1EP5=0D81=`4/0B014`470OX1kP7Q0MD1
b@6n0K@1ZP6Q0IT1TP6<0HL1Q0620H41P@630HD1R@6?0ID1W06U0Jh1^0730Ll1
f`7W0O<1004=0AX19P4b0Cd1B05B0E/1I05[0G41MP5j0Gd1OP5n0Gd1NP5f0G41
J`5T0E`1DP580Cd1<P4V0AT13@400O<1iP7J0Lh1`P6g0Jd1Y06K0I@1SP690HD1
PP610H41PP650HT1SP6D0I`1Y06^0KP1``7?0M/1j07d0@413P4K0BP1=04o0DX1
E05M0FD1K@5c0GL1N`5m0Gh1OP5l0GT1M05_0FP1H05G0Dd1@`4g0B/17`4B0@D1
n07[0Mh1dP760K/1/06V0Ih1UP6?0HX1QP630H41P@620HD1R@6>0I@1W06U0Jh1
^@740M01g07Y0OH10`4@0Ad1:P4f0D41C05F0El1I`5^0G@1N05l0Gd1OP5m0GX1
M`5b0F`1I05L0E81B04l0C01904G0@X1o@7`0N<1eP7:0Kh1/`6Y0J01V06A0H/1
Q`640H81P@620HD1R@6>0I@1W06T0Jh1^@740M01g@7Z0OL1104A0Al1:`4g0D<1
CP5H0F41J@5`0GD1N@5l0Gd1O@5l0GT1M@5_0FP1H@5G0Dd1@P4g0BX17P4@0@<1
mP7X0M/1c`730KL1[@6S0I/1T`6=0HP1Q0620H81PP650HP1S@6C0I/1X`6]0KP1
``7?0M`1j@7f0@@14@4O0B/1>0540Dl1F@5R0FT1L05e0GT1O05m0Gd1N`5h0G<1
K@5V0Eh1E05:0Cl1<P4V0AT12`7n0O01h`7F0LT1_@6b0JP1W`6G0I01RP660H<1
PP620H@1Q`6;0I41V06Q0JX1]@700L`1f@7V0O@10@4?0Ad1:P4f0D81C@5H0F41
J@5`0GD1N@5l0Gd1O@5k0GL1L`5]0FD1G@5C0DP1?@4`0B<15P480O/1k@7P0M<1
aP6j0Jl1Y@6L0I@1SP690HD1P`620H<1Q@690Hh1U@6M0JH1/06k0LL1e07Q0Nh1
o04:0AL19@4b0Ch1BP5D0Eh1IP5^0G@1N05k0Gd1O@5k0GP1L`5]0FH1GP5D0DT1
?@4a0B@15`490O/1k@7P0M81aP6j0Jl1Y@6L0I@1S@680HD1P`620H@1QP6:0I01
U`6O0JP1/`6n0L/1f07U0O<10@4?0A`1:P4g0D<1CP5H0F81JP5`0GH1N@5l0G`1
O05i0GD1L05Y0F41F05=0D81=@4X0A/13@7o0O41h`7F0LT1_@6a0JL1WP6F0Hl1
R@660H<1P`640HH1RP6@0IH1W`6X0K<1_P7;0MP1i@7c0@413`4M0B/1>0540Dl1
F@5S0F/1L@5f0GX1O05l0G/1N05d0Fh1I`5N0E@1BP4n0C41904F0@P1nP7/0Mh1
d@740KP1[@6S0IX1TP6<0HP1Q@630H<1Q@680Hd1U06L0JD1[`6j0LH1d`7Q0Nl1
o@4;0AT19`4d0D41C05G0F41J@5`0GD1N@5k0G`1N`5h0G@1KP5W0El1E@5:0Ch1
<@4T0AH1207i0N/1g@7@0L<1]`6/0J81V@6B0H`1Q`640H<1Q0660HX1S`6F0Ih1
Y`6b0Kh1bP7H0ND1m0420A017P4/0CT1A@5A0E/1I05/0G81M`5j0G/1N`5i0GH1
L@5Z0F81F@5>0D<1=P4Y0A/13@7o0O01hP7D0LL1^`6_0JD1W06D0Hd1R@650H@1
Q0660HT1SP6E0Id1YP6a0K`1b@7F0N@1lP410@l17P4[0CT1A@5@0E/1I05/0G81
M`5j0G/1N`5i0GD1L05Y0F41E`5=0D41=04V0AP12P7k0Nd1g`7A0L@1^06/0J81
V@6B0H`1R0650H@1Q@670H/1T@6H0J41Z`6f0L81c`7M0N/1nP480AL19@4b0Cl1
B`5F0F01J05_0GD1N@5k0G/1NP5f0G81J`5S0EX1D0540CL1:P4L0@d1o`7`0N81
e0760KX1[P6T0I/1T`6=0HP1Q@640HD1Q`6;0I41V06Q0J/1]P720Ll1g@7/0OX1
2@4G0BH1<`500D`1E`5Q0FT1L05e0GT1NP5j0GT1M@5`0FT1H@5G0Dd1@@4d0BH1
60490OX1k07M0Ll1`P6f0J/1X06H0I41R`670HD1Q@660HT1SP6D0I`1YP6`0K`1
b@7G0ND1m0420A41804^0C/1B05C0Ed1IP5^0G<1M`5j0GX1N@5f0G41J`5S0EX1
C`530CH1:@4J0@`1o@7^0N01dP740KP1[06R0IT1TP6<0HP1Q@650HH1R@6>0I@1
W06V0K41_@7:0ML1iP7d0@<14P4Q0Bl1?0590E@1GP5W0Fh1M05h0GX1NP5h0GD1
L05Y0F41E`5<0D01<`4U0AH11`7h0NX1f`7=0L01]06X0Il1UP6?0HX1Q`650HD1
Q`6;0I41V06Q0J/1]`730M41g`7]0O`12`4J0BT1=P530Dl1FP5S0F/1LP5f0GT1
NP5i0GH1LP5[0F<1FP5?0D<1=P4X0AX12`7l0Nd1gP7@0L<1]P6[0J01V06A0H/1
Q`660HH1Q`6;0I41V06Q0J/1]P730M01g`7]0O`12`4J0BT1=`540E01FP5T0F`1
LP5f0GT1N@5h0GD1L05Z0F81F05=0D41<`4U0AL1207i0NX1f`7=0Kl1/`6X0Ih1
UP6?0HX1Q`660HH1R@6=0I<1V`6T0Jl1^`780MH1i@7d0@<14P4Q0Bl1?@590ED1
G`5X0Fl1M05g0GT1N@5g0G81K@5U0E`1D@560CT1:`4L0@d1oP7_0N01d@740KL1
Z`6Q0IP1T@6<0HP1QP660HP1S06B0IX1X`6]0KT1aP7D0N81l@410A017`4]0C/1
B05D0Eh1I`5^0G<1M`5i0GP1MP5b0F`1I@5L0E41A@4h0BX16`4<0Od1kP7O0M01
``6f0JX1X06H0I41R`680HH1Q`690Hh1U06L0JD1/06l0LT1e`7V0OD11@4D0B<1
<@4o0D/1E`5Q0FT1L05d0GL1N05h0GD1L05Y0F41E`5<0Cl1<P4T0AD11@7f0NL1
f07:0K`1/06U0I`1U06>0HX1Q`670HP1S06A0IP1X@6/0KP1a07B0N41l0400@l1
7P4]0C/1A`5C0Eh1IP5^0G<1MP5h0GP1M@5a0F/1H`5I0Dh1@P4d0BH15`480OP1
j@7J0L`1_P6b0JL1W@6E0Hl1RP680HL1R@6<0I41V@6Q0J`1^0750M<1h@7a0@01
404O0Bd1>`580E@1GP5W0Fh1L`5f0GP1M`5d0G01J@5Q0EL1C04o0C418`4D0@@1
m@7U0MH1b06k0Jl1Y06K0I<1S@6:0HP1R06:0Hh1U06L0JD1/06m0LX1f07W0OL1
1P4F0BD1<`510Dd1F@5R0FX1L05e0GL1M`5f0G81K05U0E`1D@550CL1:@4J0@/1
n`7/0M`1cP700K<1Z06N0IH1T06;0HP1R0690Hd1TP6J0J<1[@6i0LH1e@7T0O<1
0`4B0B41<04n0D/1EP5P0FT1K`5d0GH1M`5f0G81K@5U0E`1DP560CP1:P4K0@`1
o07]0Md1c`710K@1Z@6O0IH1T06;0HT1R06:0Hd1T`6J0J<1[P6j0LP1eP7U0OD1
104D0B<1<P4o0D`1E`5Q0FT1L05d0GH1M`5e0G41J`5S0EX1C`520CD19P4G0@P1
n07X0MT1b`6m0K41YP6L0I@1SP6;0HT1R@6;0I01UP6N0JP1/`700Lh1g07/0O/1
2`4K0BX1>0550E41G05U0F`1LP5e0GH1M@5c0Fh1I`5N0E@1B04k0Bd17P4>0Oh1
k`7O0M01`P6e0JX1X06G0I41S0690HT1R`6>0I@1W06U0K01_07:0MT1j07g0@L1
5`4V0CD1@P5?0EX1H`5[0G41M05f0GD1L`5^0FL1G`5E0DT1?04^0Al13`400O01
h07A0L<1]P6Z0J01V06A0H`1RP690H/1S`6D0I`1YP6a0Kd1b`7J0NT1n@480AP1
9`4f0D<1D05K0F@1J`5a0G@1MP5e0G81K@5V0Ed1DP560CT1:`4L0@`1o07/0Md1
cP700K<1Z06N0IH1T06<0HX1RP6<0I41U`6O0JT1]@720M01g`7_0Ol13P4N0Bd1
>`580E@1GP5W0Fh1LP5e0GD1L`5_0FT1H@5H0D`1@04b0B<150440O@1i07E0LH1
^@6]0J81VP6C0Hh1R`6:0H`1S`6E0I`1YP6a0Kd1b`7J0NT1n@490AT1:04g0D@1
D@5K0F@1K05a0G@1M@5d0G01J`5S0EX1C`520CD19P4G0@L1m`7W0MP1b@6k0Jl1
Y06K0I@1S`6;0HX1S06?0I@1W06U0K01_@7:0MT1j@7h0@P1604X0CH1A05@0E/1
I05[0G01L`5d0G<1L05Z0F81F@5>0D41<`4U0AD11@7e0ND1eP770KX1[P6S0IX1
T`6>0H/1R`6<0I01UP6N0JP1/`700Lh1g@7/0O`1304L0B/1>P570E<1G@5V0Fd1
L@5d0G@1LP5^0FL1G`5E0DT1?04^0Al13`7o0Nl1g`7@0L81]@6Z0J01U`6A0Hd1
R`6<0Hh1T`6J0J<1[@6i0LL1e@7T0O@1104D0B@1<`510Dd1F@5R0FX1K`5b0G@1
L`5_0FX1HP5I0Dh1@@4c0BD15@450OD1i@7F0LL1^P6]0J<1VP6C0Hl1S06<0Hh1
TP6H0J01ZP6f0L<1dP7Q0O410@4A0B41<04n0D/1EP5P0FP1KP5b0G<1LP5`0FX1
H`5J0Dl1@`4e0BH15`470OL1i`7G0LP1^`6_0J@1V`6D0Hl1S@6<0Hh1TP6H0J41
Z`6f0L@1dP7Q0O410@4A0B41<04n0D/1E`5P0FP1KP5a0G<1LP5_0FT1HP5I0Dd1
@@4c0B@150440O@1i07E0LH1^@6]0J81VP6C0Hl1S@6=0Hl1U06J0J<1[P6j0LL1
eP7V0OH11P4F0BD1=0520Dl1F@5S0FX1K`5b0G81L@5]0FL1GP5D0DT1>`4]0Ah1
3P7n0Nd1gP7?0L01]06X0Il1U`6A0Hh1S@6>0I41U`6O0JP1]0710Ll1gP7^0Oh1
3P4N0Bd1?0590ED1G`5W0Fd1L05b0G41KP5Y0F41F05=0D01<P4S0A@10`7c0N<1
e0750KP1[06R0IX1T`6?0Hd1SP6A0IH1W@6V0K41_P7;0MX1jP7j0@X16P4Z0CT1
AP5B0E`1I@5[0Fl1L@5a0Fh1J@5R0ET1CP520C@19@4E0@D1m@7U0MH1a`6i0Jd1
X`6J0I@1T06>0Hh1T@6F0Id1YP6a0Kd1b`7J0NX1nP4:0AX1:P4i0DH1DP5L0FD1
J`5_0G41L05^0FT1H@5H0Dd1@04b0B<150430O<1h`7D0LD1^06/0J81VP6D0I01
SP6?0I81U`6O0JP1]0700Ll1gP7^0Oh13P4N0Bd1?0590E@1GP5V0F`1K`5a0Fl1
K05V0Eh1E@590C`1;P4N0@h1oP7^0Mh1c`710K@1Z06O0IP1TP6?0Hl1T06D0I/1
X`6]0KT1a`7E0ND1m@450AD19@4d0D81CP5I0F81J@5^0G01L05^0FT1HP5I0Dh1
@P4d0BD15@450OD1i@7E0LL1^@6]0J<1V`6E0I41S`6@0I<1V06P0JX1]@720M01
g`7_0@01404P0Bl1?@5:0EH1G`5W0F`1K`5`0Fh1JP5T0E/1D@550CL1:@4I0@T1
n@7X0MT1bP6l0K01Y@6M0IH1TP6@0I01T`6H0Il1Z06c0L01cP7N0Nd1oP4>0Ah1
;@4l0DT1E05N0FH1J`5^0Fl1KP5Z0F@1F`5A0DD1>04Y0AT12@7i0NT1f@7:0K`1
/06U0Id1UP6B0I01T06C0IP1X06Y0KD1`@7@0Ml1k`7o0@l17`4_0Cd1BP5E0El1
IP5[0Fh1K`5]0FT1HP5I0Dl1@`4e0BH15P460OH1iP7F0LL1^P6^0J@1W06E0I81
T06A0ID1V`6R0J`1^0750M@1h`7d0@@1504T0C<1@@5=0EP1H@5X0F`1KP5^0F/1
IP5O0EH1BP4m0Bl1804@0@01k`7O0M01`P6e0JX1X06I0I@1T@6A0I<1V06N0JL1
/P6o0L`1f`7[0O`1304L0B/1>P570E<1G@5T0FX1K@5^0F`1J05R0EX1C`530CD1
9P4G0@H1mP7V0MH1b06j0Jh1Y06L0IH1TP6A0I<1UP6L0J@1[P6j0LP1e`7V0OH1
1`4G0BL1=P530Dl1FP5R0FP1K05]0F`1J@5S0E/1D@560CP1:P4J0@X1nP7Y0MX1
b`6m0K41YP6N0IL1T`6B0I<1UP6K0J<1[@6i0LH1e@7T0O@11@4E0BD1=0520Dh1
F05Q0FL1J`5]0F`1J@5S0E`1DP560CT1:P4K0@X1nP7Z0MX1b`6m0K41Y`6N0IP1
U06B0I<1UP6L0J@1[P6j0LL1eP7U0OH11P4F0BH1=@520Dh1F@5Q0FL1J`5]0F/1
J05R0EX1D0540CH1:04H0@P1m`7W0MP1b@6k0Jl1Y@6M0IL1U06C0I@1V06N0JH1
/@6m0L/1fP7Y0OX12P4J0BX1>0550E41F`5S0FP1J`5/0FX1IP5O0EL1C04o0C41
8P4C0@81lP7R0M81a06g0J`1XP6K0IH1U06C0IH1V`6R0J/1]P730M41h07`0@41
4@4Q0C01?P5;0EH1GP5U0FX1J`5[0FP1H`5K0E41AP4h0BX16P4:0OX1jP7J0L/1
_@6a0JL1W`6I0ID1U06E0IT1W`6W0K41_P7;0MX1jP7j0@/16`4Z0CT1AP5A0E/1
H`5X0F/1J`5Y0F@1G@5D0DT1?04^0Al13`7o0Nh1g`7?0L41]@6Z0J41VP6F0I@1
U@6H0Id1Y@6_0K/1b07G0NH1m`470AL19`4f0D<1C`5I0F41IP5Z0F/1J@5U0Eh1
E@5;0Ch1<04Q0A410@7a0N41d@730KH1Z`6R0I/1U`6E0ID1V06M0JD1[`6j0LP1
eP7V0OH11P4F0BH1=@520Dh1F05P0FH1J@5Z0FP1I05N0ED1BP4n0C018@4A0@01
l07P0M41``6f0J/1XP6L0IL1U@6F0IT1WP6V0K01_0790MP1j07h0@P1604X0CH1
A05?0ET1H@5V0FT1J@5W0F<1G05C0DP1>`4]0Ad13@7m0Nd1g@7>0L01]06Y0J41
V`6G0IH1U`6K0J41Z@6c0L01c@7L0N`1o04=0Ad1;04j0DL1DP5K0F81I`5Y0FT1
IP5P0ET1C`530CH19`4H0@P1m`7W0MP1b@6l0K01YP6O0IT1U`6F0IT1W@6T0Jh1
^@760M@1h`7c0@@1504T0C81@05<0EH1GP5T0FP1J@5W0F<1G05D0DT1?04^0Al1
3`7o0Nl1g`7@0L81]P6[0J81W06H0IL1V06K0J41ZP6d0L01cP7M0Nd1o@4=0Ad1
;@4k0DL1DP5K0F81IP5X0FL1I05N0EH1C0500C<1904D0@@1m07T0MD1aP6i0Jh1
Y@6N0IT1U`6H0I/1X06X0K81_@7;0MT1j@7i0@T16@4Y0CL1A05@0ET1H05U0FL1
I`5T0El1F05>0D81=@4V0AL11`7g0NL1e`790K`1/06W0Il1VP6H0IP1V`6P0JL1
/@6l0LX1f07X0OP1204H0BL1=P530Dh1F05O0F@1I`5W0F@1G`5H0Dh1@P4e0BL1
5`470OL1i`7G0LT1_06`0JL1X06K0IP1V@6K0J41Z06b0Kd1b`7I0NT1n@490AT1
:04g0D@1C`5H0El1I05V0FH1H`5N0EH1C0510C<19@4E0@D1m@7U0MD1a`6j0Jl1
YP6O0I/1V@6I0Id1XP6Z0K@1`07>0M`1k07l0@`1704[0CT1AP5A0EX1H05T0FH1
I@5Q0E`1D`590Cd1;`4P0A01007`0N01d@740KL1[@6T0Ih1VP6I0I/1W`6U0Jh1
^0750M<1hP7b0@814P4R0C01?P5:0E@1G05R0FD1I@5S0El1F05?0D@1=`4Y0AX1
2P7i0NT1fP7;0Kh1/`6Y0J81W@6J0IX1W@6R0JT1/`6o0L`1fP7Z0OX12P4J0BT1
=`540Dl1F05O0F<1I@5T0F41F`5C0DT1?@4_0B0140400O01h@7B0L@1^06]0JD1
W`6K0IX1W06P0JL1[`6j0LL1e@7T0O@1104D0B<1<P4o0D/1E@5L0F41I05T0F81
G@5E0D`1@04c0B@15@450OD1i@7F0LP1^`6`0JL1X@6M0I/1W06O0JD1[P6h0L@1
dP7Q0O01004@0B01;`4l0DP1DP5J0F01H`5T0F81G@5F0Dd1@P4e0BL15`480OP1
j07H0LX1_@6b0JT1XP6N0I`1W06O0JD1[@6g0L<1d@7O0Nl1o`4?0Al1;@4k0DL1
D@5I0El1HP5S0F41G@5F0Dd1@P4e0BL160480OP1j07I0L/1_P6c0JT1X`6N0I`1
W@6P0JH1[P6h0L@1d@7P0O01004@0Al1;P4k0DL1D@5I0El1HP5S0F01G05E0D`1
@04c0BD15P460OH1iP7G0LT1_@6b0JT1XP6N0Id1WP6Q0JL1/06j0LH1e07S0O<1
0`4C0B81<04n0DT1D`5J0El1HP5R0El1FP5B0DT1?@4`0B414P420O81h`7D0LH1
^P6`0JL1XP6N0Id1W`6S0JX1/`6n0L/1f@7X0OP1204G0BH1=0510D`1E@5L0F01
H@5Q0Ed1E`5?0D@1>04Z0A`1307l0N`1g@7?0L81]P6]0JD1X06N0Ih1X@6V0Jh1
^0740M41g`7_0Ol13`4N0Bd1>P560E01F05M0F01H@5O0EX1D`5:0Ch1<@4S0A@1
107d0ND1eP780K`1/@6Y0J<1W`6N0J01Y06[0K@1_P7;0MT1j07h0@P15`4V0C@1
@@5<0E@1F`5O0F01G`5L0ED1C@520CH1:04I0@X1nP7Z0M/1c@700KD1[06U0J41
W`6P0J<1Z@6a0K/1a`7E0N<1l`430A818P4`0Cd1B05B0ET1G@5P0El1G05G0Dl1
A@4i0B`17@4>0Oh1kP7O0M41a06h0Jl1Y`6R0J01X06S0JP1/06i0LD1dP7Q0O01
004?0Al1;@4j0DH1D05G0E`1G`5O0E`1E`5@0DH1>`4]0Al140400O01h@7C0LD1
^P6`0JP1X`6Q0J01X`6X0Jl1^@740M41h07_0Ol13P4N0B`1>@550Dl1EP5K0Eh1
GP5L0EL1C`560CX1;@4O0A01007a0N41d`760KX1/06Y0J@1X@6Q0J@1Z@6`0KX1
a@7B0N41l07o0@l17P4]0CX1A@5?0EH1F`5N0Eh1F`5F0Dh1A04i0B`17@4>0Oh1
k`7P0M41a@6i0K01Z@6T0J81XP6U0JX1/P6l0LP1e@7S0O<10P4B0B41;`4l0DL1
D05G0E/1G@5M0ET1E05<0D81=P4X0AX12P7k0N/1g07?0L81]`6^0JP1Y06R0J<1
Y`6]0KD1_`7;0MT1j07g0@L15P4U0C81?`590E81F05L0Ed1F`5G0E41B04m0C41
8`4D0@D1mP7V0MP1bP6n0K@1[06W0J<1X`6U0JT1/06i0L@1d@7O0Nh1o@4=0A`1
:P4g0D<1C@5D0ET1G05L0ET1E05=0D<1>04[0A`13@7n0Nl1h07B0LD1^P6a0JX1
Y@6S0J@1Y`6]0KD1_`7;0MP1i`7f0@D15@4S0C41?@580E01EP5J0E`1FP5F0E01
A`4m0C018`4D0@D1m@7V0MP1bP6o0KD1[@6W0J@1Y06V0J/1/P6k0LH1d`7Q0O01
o`4?0Ah1;04i0D@1C@5D0ET1F`5J0EL1DP5:0D01=04W0AT12@7j0N/1g07?0L81
^06`0JT1YP6T0JH1ZP6`0KT1``7@0Mh1k07k0@/16P4X0CD1@@5:0E81E`5J0EX1
F05C0D/1@P4g0BX1704=0Od1kP7O0M81a@6j0K81Z`6W0JD1YP6Z0Jl1^0720Lh1
f`7Z0OT1204G0BH1<`4o0DT1D05F0ET1F@5G0E<1C0530CP1:`4M0@h1o`7`0N41
d`770K`1/`6/0JP1YP6V0JX1/06h0L81cP7K0NT1n0470AH19@4b0Ch1B05@0ED1
F05I0EL1DP5;0D81=`4[0Ad13P7o0O01h@7C0LL1_06c0J`1Z06V0JL1Z`6`0KP1
``7?0M`1jP7i0@P15`4U0C81?P580E01E@5H0EP1EP5A0DX1@@4f0BT16`4<0Od1
kP7P0M81aP6k0K<1[06X0JL1Z06/0K81^P750M41gP7]0O`12`4I0BL1=04o0DT1
D05E0EL1E`5E0Dl1B04n0C<19P4H0@T1nP7[0Md1d0740KX1/P6/0JP1Z06Y0Jh1
]06m0LP1e07R0O41004?0Ad1:`4g0D81B`5A0ED1E`5F0E<1C@550C/1;`4Q0A<1
107e0NL1f@7<0L41]`6`0J/1Z@6Y0J/1/06h0L41c@7J0NL1mP450A@18P4_0C/1
A@5=0E81EP5F0E@1D0590D01=P4Y0A/13@7n0Nl1h@7D0LL1_@6d0Jh1ZP6Y0JX1
[P6d0K`1a`7C0N01kP7m0@`16P4X0C@1?`580Dl1E05F0ED1DP5<0DD1>`4_0B81
50450OH1j07J0Ld1`P6i0K41[06Z0JX1[@6b0KT1`P7>0MX1j07g0@D1504R0Bl1
>`540D`1D@5D0ED1D`5>0DL1?P4c0BL16@4;0O`1kP7P0M81a`6m0K@1[`6[0JX1
[06`0KL1_`7:0MH1i07b0@013`4M0B/1=`510DT1C`5C0E@1D`5?0DT1@@4f0BX1
7@4?0@01lP7T0MH1bP700KL1/@6]0J/1[06_0KD1_@780M<1h07^0Od1304J0BL1
<`4n0DL1CP5B0E@1D`5@0DX1@P4h0Bd1804B0@<1m@7V0MT1c@720KT1/P6^0J`1
[06_0KD1_@760M81g`7/0O/12@4H0BD1<P4l0DD1C05A0E<1DP5?0DX1@`4i0Bh1
8@4C0@D1mP7X0MX1cP730KX1/`6_0Jd1[@6`0KD1_@760M41gP7/0OX12@4G0B@1
<@4k0D@1B`5@0E81DP5?0DX1@P4i0Bd18@4C0@D1mP7X0M/1cP740K/1]06_0Jd1
[P6a0KH1_@770M81g`7]0O/12@4G0BD1<@4l0D@1B`5@0E81D@5>0DT1@@4g0B`1
7`4B0@<1m@7W0MX1cP730KX1]06`0Jh1[`6b0KL1_`790M@1h@7_0Od12`4I0BH1
<P4l0DD1B`5?0E41D05=0DL1?`4e0BT17@4?0@41lP7U0MP1c0720KX1/`6`0Jh1
/06c0KT1`P7<0ML1i07b0@013P4L0BT1=04n0DH1C05?0E01C`5;0D@1?04b0BH1
6@4;0Od1k`7Q0MD1b@700KP1/`6`0Jl1/@6f0K`1a@7?0M`1j@7f0@D14`4P0B`1
=`500DP1C@5?0Dl1C@580D41>04]0B4150460OP1jP7M0M41aP6m0KL1/P6`0K01
/`6i0L01b@7E0N41kP7l0@X1604U0C41>`530DT1C@5?0Dh1BP550Cd1<`4X0A/1
3@7o0O81i07G0L`1`P6j0KD1/@6a0K81]P6l0LD1c`7K0NP1m@430A417P4[0CD1
?`560D/1CP5>0D`1A`500CL1;@4Q0A@11P7h0NX1g@7A0LL1_P6h0K<1/@6b0KD1
^P720L/1eP7R0O01o@4;0AT19@4a0C/1@`590D`1C@5<0DP1@P4j0C019@4H0@/1
o@7_0N81eP7;0L81^P6e0K<1/P6d0KT1_`780M<1gP7[0OT11`4D0B41;@4g0D01
AP5;0Dd1C0590D@1?04c0BP1704?0@41l`7V0MX1cP750Kd1]`6d0K<1]06h0Kh1
aP7@0M`1j07f0@<14@4N0BX1=04m0D@1B@5<0D`1B@540Ch1=@4Z0Ah14@440OH1
j@7L0M41a`6o0KT1]@6d0K@1^06m0LD1c`7J0NH1m0410@h16`4X0C81?0530DP1
B`5;0DT1A@4n0CD1:`4O0A<11@7h0N/1gP7C0LT1`06j0KH1]06e0KP1_P750Lh1
f@7V0O<1004=0AX19P4a0CX1@P570DX1BP580D@1?P4e0B/1804C0@H1n07[0Ml1
d`790L41^`6g0KD1]P6i0Kh1aP7?0MX1iP7c0@013@4J0BH1<@4j0D41AP590DX1
B0530Cd1=04Z0Al14P450OP1j`7N0M<1b@710K/1]`6f0KL1^P6o0LL1d07K0NL1
m0410@h16`4W0C41>P510DH1B@590DH1@P4k0C<1:@4M0A010`7f0NT1g@7B0LT1
`@6k0KP1]P6h0K/1`@790M81g@7Y0OH10`4@0Ad1:04b0C/1@@560DP1B0550D01
>@4`0BH16P4>0@41m07W0M/1d0770L01^`6h0KL1^@6m0L<1b`7E0N41k@7j0@L1
4`4P0B/1=04l0D81AP570DH1@`4n0CH1;@4R0AH12P7m0O01i07H0Lh1aP6o0KX1
^06h0K/1_`760Ll1f@7U0O41oP4;0AL18`4^0CL1?P530DH1A`550D41>`4c0BT1
7P4B0@D1n07/0N01e@7;0L<1_P6j0KT1^P6m0L<1bP7C0Mh1jP7f0@<1404L0BL1
<@4i0D01A0560DD1@`4n0CL1;P4T0AP1307o0O<1iP7K0M41b0710Kd1^P6j0K`1
`0770Ll1f@7T0O01o@490AH18@4/0CD1?0510D@1A@540D01>P4b0BP17P4B0@D1
n@7/0N41eP7<0LD1_`6l0KX1^`6o0L@1b`7E0Ml1j`7g0@@1404L0BL1<04h0Cl1
@P540D@1@@4l0CD1;04R0AH12P7n0O41i@7J0M01b0720Kd1^`6k0Kh1`P790M81
g07W0O<1o`4<0AP18`4]0CD1?0510D<1@`510Cd1=`4_0BD16P4>0@81m@7Y0Mh1
e07;0L@1_`6m0K`1_P720LP1c`7I0N@1k`7l0@P1504O0BX1<P4j0Cl1@P530D41
?P4h0C019`4M0A411@7i0Nd1h@7G0Lh1aP710Kh1_@6n0L41a`7>0ML1hP7]0OT1
1@4A0Ad19`4`0CP1?@510D81@@4n0CP1<@4X0Ah14`470O/1k`7S0MT1d0780L<1
_`6n0Kh1`@760Lh1eP7P0N`1m`430@l16`4U0Bl1=P4l0D01@@500Cd1>04b0BT1
7`4D0@P1o07`0ND1fP7A0LT1a0700Kh1_`720LL1cP7F0N01j`7g0@<13`4J0B@1
;@4e0C/1?`500D01?@4h0C41:@4O0A@1207l0O41i@7K0M81bP740L41_`700L<1
a`7>0ML1h07[0OL10`4>0AX1904]0CD1>P4n0Cl1?`4l0CL1<04X0Ah14`480O`1
l07U0M/1dP7;0LD1`@700L41a0780Ll1f07R0N`1n0440@l16P4T0Bd1=04j0Cd1
?`4n0C/1=P4_0BH17@4B0@H1n`7_0N@1fP7B0LX1a@720L41`P750LX1d@7J0N<1
kP7j0@D14@4L0BD1;P4e0CX1?@4n0Cd1>@4d0Bd1904J0@l1107i0Nd1h`7I0M41
bP750L81`P730LL1c07C0M`1iP7a0O`1204C0Ad19`4_0CD1>P4m0Cd1>`4g0C81
:P4Q0AL130410OH1j`7P0ML1c`790LD1``730LD1b@7?0MH1g`7Y0O@1004;0AH1
804Y0C01=P4j0C`1?04j0CD1;`4W0Ah150490Od1lP7W0Mh1e@7>0LP1a@730L@1
a`7;0M81fP7S0Nh1n0440@l16@4S0B/1<P4g0CX1>`4j0CL1<P4[0B<16P4?0@@1
n@7^0N@1fP7B0L`1a`750L@1aP790Lh1e@7N0NP1lP7m0@P14`4M0BH1;P4d0CP1
>P4j0CP1=@4_0BL17`4E0@X1o`7d0NT1h07G0M01bP770LD1a@780L`1dP7J0N<1
k@7h0@<13P4H0B41:P4`0CD1>@4j0CT1=P4a0BX18P4I0@l1107i0Nl1i@7K0M@1
c@790LH1aP770L/1d07G0Ml1j@7c0Oh12@4C0Ad19P4]0C<1=`4i0CT1=`4c0Bd1
9@4M0A<1207n0O<1j@7O0ML1d07;0LP1a`770LX1c`7E0Md1iP7`0OX11@4?0AT1
8P4Z0C01=@4g0CP1=`4c0Bh19`4O0AH130410OL1k07S0MX1d`7=0LX1b0780LX1
cP7C0M/1h`7]0OL10P4<0AH17`4W0Bh1<`4f0CL1=P4d0Bl1:@4Q0AP13P440OX1
k`7V0Md1e@7?0L/1b@780LX1c@7B0MT1h@7[0OD1o`490A<17@4U0B`1<@4e0CH1
=P4d0Bl1:P4R0AX140460O`1lP7X0Ml1e`7A0Ld1bP790LX1c@7B0MT1h07Y0O<1
o@480A416`4S0BX1<04c0CD1=@4c0Bl1:P4S0A/14@470Od1l`7Z0N41f@7C0Lh1
b`7:0L/1cP7B0MP1h07Y0O81o0460A016@4R0BT1;P4b0C@1=04c0Bl1:P4S0A/1
4P480Oh1m07[0N81fP7D0Ll1c07;0L`1cP7C0MT1h07Y0O81o0460A016@4Q0BP1
;@4a0C<1=04b0Bh1:@4S0A/14P480Oh1m07[0N81f`7D0M01c@7<0L`1c`7C0MT1
h@7Y0O81o0460@l1604Q0BL1;@4a0C<1<`4a0Bd1:04R0AX14@470Oh1m07[0N81
f`7E0M01cP7=0Ld1d07E0MX1hP7Z0O<1o@470A016@4Q0BL1;04`0C81<P4`0B`1
9`4P0AP140460Od1l`7Z0N81f`7E0M41cP7=0Ll1d@7F0M`1h`7/0OD1oP480A41
6P4Q0BL1;04`0C41<@4_0B/19@4N0AL13P440O/1lP7Y0N41fP7E0M41c`7>0M01
d`7H0Mh1i@7^0OL1004:0A<16`4R0BP1;04_0C01<04]0BT18`4L0A@12`420OT1
l07W0N01f@7D0M41c`7?0M41e@7J0N01j07`0OX10`4<0A@1704S0BT1;@4_0Bl1
;P4[0BL18@4I0A412@7o0OH1kP7U0Mh1f07D0M41d07A0M<1e`7L0N<1j`7d0Od1
1P4>0AL17P4T0BT1;@4^0Bh1;04Y0B@17P4F0@h11@7l0O<1j`7S0Md1e`7D0M41
d@7B0MD1fP7P0NL1k`7g0@012@4A0AT1804V0BX1;@4^0Bd1:P4V0B416P4C0@X1
0@7i0O01j07Q0M/1eP7C0M81dP7D0MP1g@7S0NX1l`7k0@@13@4E0A`18P4W0B/1
;04]0B/1:04S0Ad15P4>0@H1o@7e0N`1i@7O0MT1eP7C0M<1e07G0M/1h07W0Nl1
m`400@P1404H0Al1904X0B/1;04[0BT19@4P0AT14P4:0@41n@7`0NT1hP7L0MP1
e@7D0M@1eP7I0Mh1i@7/0O@1o0440@d1504K0B419P4Y0B/1:`4Y0BH18@4K0AD1
3@450O`1m07/0ND1g`7J0ML1e@7E0MH1f@7M0N<1j@7a0OT10@490A41604O0B@1
9`4Z0BX1:@4V0B817@4G0@l11`7o0OL1k`7X0N81g07I0MH1e@7F0MP1g07Q0NP1
k`7g0Ol11`4?0AH1704R0BH1:04Y0BT19`4S0Ah1604A0@T10@7i0O81jP7T0Mh1
fP7H0MH1e`7I0M`1h@7V0Nd1m@7m0@D1304D0AX1804T0BL1:04X0BH18`4O0AT1
4P4;0@<1n`7d0N`1iP7P0M`1f@7G0ML1f@7L0N01iP7/0O<1n`430@/14P4H0Ah1
8P4U0BL19`4V0B<17`4J0A<130450Od1m@7^0NL1hP7M0MX1f07H0MT1g07P0ND1
k07c0OX10P490A015`4M0B41904V0BH19@4S0Al16P4D0@d11@7n0OH1k`7Y0N<1
gP7K0MT1f@7J0Md1h07U0N/1lP7i0@41204?0AH16`4P0B<19@4V0BD18P4N0AT1
504=0@H1oP7g0O01jP7T0Ml1g07J0MX1f`7M0N41iP7/0O81n@410@P13`4E0A/1
7`4R0B@19@4T0B417P4I0A<13@460Oh1m`7`0NX1i@7P0Md1f`7K0M`1gP7R0NH1
k07c0OX10@480@l15@4J0Ah18P4S0B@18`4P0Ad1604B0@`11@7n0OL1l07Z0ND1
h@7N0M`1g07M0Ml1h`7W0Nd1l`7j0@41204?0AD16P4N0B418`4S0B817`4L0AL1
4@4;0@@1o@7g0O01jP7U0N41gP7M0Md1gP7P0N@1j@7^0O@1n`420@T13`4E0AX1
7P4P0B818P4Q0Ah16P4F0A012P430O`1mP7`0NX1i@7Q0Ml1gP7N0Ml1hP7U0NX1
l07f0O`10`4:0A015@4J0Ah1804Q0B417`4M0AT1504>0@P10P7k0OD1k`7Y0ND1
hP7O0Mh1g`7P0N<1i`7/0O41n07n0@D12`4A0AH16P4M0Al1804P0Ah16`4G0A81
3@460@01nP7c0Nh1j@7U0N81h07O0N01hP7U0NT1kP7d0OX100460@`14P4G0A/1
7@4O0Al17`4L0AT15@4@0@X1107n0OP1lP7]0NP1i07R0N01h07Q0N<1i`7[0O01
mP7l0@81204>0A<15`4K0Ad17P4N0Ad16`4G0A<13P480@81o07f0O01j`7W0N@1
hP7Q0N41h`7U0NT1k@7c0OP1oP440@X1404D0AP16`4M0Ah17@4K0AT15@4@0@/1
1@7o0OT1m07_0NX1iP7T0N81hP7S0ND1j07[0O01m@7k0@411`4<0A415@4I0A/1
7@4M0A`16@4F0A813@480@81o@7g0O81k@7Y0NH1i07S0N<1i07W0NX1kP7c0OP1
oP440@T13P4C0AL16@4K0A`16`4J0AL1504?0@X11@7o0OX1m07`0N/1j07U0N@1
i07T0NH1j@7]0O41mP7l0@411`4<0A01504H0AX16`4K0AX1604E0A4130470@81
o07g0O81kP7Z0NL1i@7T0ND1iP7X0N`1l07d0OX1o`440@T13P4B0AH1604J0AX1
6@4H0AD14P4>0@T1107n0OT1m07`0N`1j@7W0NH1i@7V0NP1j`7_0O<1n07m0@81
1`4<0A01504G0AP16@4I0AP15@4B0@h12P450@01n`7f0O81kP7Z0NP1i`7V0NL1
j07[0Nh1lP7g0O`10@460@X13`4B0AD15`4H0AP15`4E0A<13`4;0@H10@7l0OP1
l`7_0N`1j@7X0NL1i`7Y0N/1kP7b0OH1n`7o0@@12@4=0A41504F0AL15`4G0AD1
4`4?0@`11`420Oh1n@7e0O41k@7[0NT1j07X0NT1j`7^0O41m@7j0Oh10`480@`1
404C0AD15P4G0AH15@4C0@l130480@<1o`7j0OH1lP7^0N`1jP7Y0NT1jP7[0Nh1
l@7e0OT1oP420@L12`4?0A81504E0AH15@4D0A813`4<0@P1107o0O/1m`7c0Nl1
k@7[0NX1jP7Z0N`1kP7a0OD1n@7m0@811P4:0@h14@4C0A@15@4E0A@14P4?0@`1
20440@01n`7g0O<1l07^0N`1j`7Z0N/1k@7_0O81m@7i0Od10@460@T13@4@0A81
4`4D0A@14`4A0@l12`480@@1007l0OP1m07a0Nh1k@7/0N/1k07]0Nl1lP7f0OT1
o@410@D12@4<0@l14@4C0A<14`4B0A013P4;0@L110400O`1n07d0O41k`7]0N`1
k07]0Nh1l07c0OH1nP7n0@411@490@`13`4A0A814P4B0A41404=0@X11`430Ol1
o07h0OD1lP7`0Nh1k@7]0Nh1k`7a0O@1m`7j0Oh10P450@T1304>0A014@4B0A41
404?0@`12@460@<1o`7k0OP1m@7b0O01k`7^0Nh1kP7`0O81m@7h0O/1oP420@H1
2@4<0@h1404A0A414@4?0@h12`490@D10P7n0O/1n07e0O81l07_0Nl1k`7_0O41
l`7f0OP1o07o0@<11P490@/13P4?0A01404@0@h13@4:0@P110410Oh1n`7g0OD1
l`7a0O01k`7`0O01lP7d0OL1n@7m0@010`460@T12`4=0@l13`4?0@l13@4<0@T1
1P430@01o@7j0OL1m@7c0O41l07`0O01l@7c0OD1n07k0Oh10@440@L12@4;0@d1
3P4?0@h13P4<0@X120450@81o`7l0OT1m`7e0O<1lP7a0O41l@7c0O@1mP7i0O`1
o`420@@11`490@/13@4>0@h13@4=0@/12@470@@10@7n0O`1n@7g0OD1l`7b0O81
lP7b0O@1mP7h0OX1o@400@<11@480@X12`4<0@d13@4<0@/12P480@D10`400Od1
n`7h0OH1m07c0O81lP7c0O@1m@7g0OT1n`7n0@410`460@P12P4;0@`1304<0@/1
2P480@H110420Ol1o07j0OP1mP7d0O@1l`7c0O@1m@7f0OP1nP7m0Ol10P440@H1
204:0@/1304<0@/12P490@L11@430@01oP7k0OT1m`7f0OD1m07d0O@1m@7f0OP1
nP7l0Oh10@430@D11`490@X12`4;0@/12P490@P11P440@41o`7m0O/1n@7g0OH1
m@7d0O@1m@7f0OL1n@7k0Od1o`420@@11P470@T12P4:0@X12P490@P11P440@81
007n0O`1nP7h0OL1mP7e0OD1m@7f0OL1n@7k0O`1o`410@<11@460@P12@490@X1
2@490@P11P450@<10@7o0Od1n`7i0OP1m`7f0OH1mP7f0OL1n@7j0O`1oP400@81
10450@L120490@T12@480@P11P450@<10@7o0Oh1o07j0OT1n07g0OH1mP7g0OP1
n@7j0O`1o@7o0@410`440@H11`480@P120480@L11P450@<10P400Oh1o07k0OX1
n07h0OL1m`7g0OP1n@7j0O/1o@7o0@010P440@D11P470@P120480@L11P450@@1
0P400Ol1o@7l0OX1n@7h0OP1n07h0OP1n@7j0O/1o@7n0@010P430@@11P460@L1
1`470@L11P450@@10P410Ol1oP7l0O/1nP7i0OP1n07h0OT1n@7j0O/1o@7n0@01
0@430@@11@460@H11`460@H11P450@@10P410Ol1oP7m0O/1nP7j0OT1n@7i0OT1
nP7k0O`1o@7n0Ol10@420@<110450@H11P460@H11@440@<10P410@01oP7m0O`1
n`7j0OX1n@7i0OX1nP7k0O`1o@7n0Ol10@420@<110450@D11@450@D11@440@<1
0P410@01o`7m0O`1n`7k0OX1nP7j0OX1nP7k0O`1o@7n0Ol100420@<10`440@D1
1@450@D110440@<10P410@01o`7n0Od1o07k0O/1nP7j0OX1n`7k0O`1o@7n0Ol1
00410@810`440@@110440@@110430@<10P410@01o`7n0Od1o07k0O/1n`7k0O/1
n`7l0Od1o@7n0Ol100410@810`430@@110440@@10`430@810@410@01o`7n0Od1
o07l0O/1n`7k0O/1o07l0Od1oP7n0Ol100410@810P430@<110440@<10`430@81
0@400@01o`7n0Od1o@7l0O`1o07l0O`1o07m0Od1oP7o0Ol100410@810P430@<1
0`430@<10`420@810@400@01o`7n0Od1o@7l0O`1o07l0O`1o@7m0Oh1oP7o0@01
00410@410P420@<10`430@<10P420@410@400Ol1o`7n0Oh1o@7m0Od1o07l0Od1
o@7m0Oh1oP7o0@0100410@410P420@810P420@810P420@4100400Ol1o`7n0Oh1
o@7m0Od1o@7m0Od1o@7n0Oh1o`7o0@0100410@410P420@810P420@810P410@41
00400Ol1o`7n0Oh1oP7m0Od1o@7m0Od1oP7n0Oh1o`7o0@0100410@410@420@81
0P420@410@410@0100400Ol1o`7n0Oh1oP7n0Od1o@7n0Oh1oP7n0Ol1o`7o0@01
00410@410@410@410@410@410@410@01007o0Ol1o`7n0Oh1oP7n0Oh1oP7n0Oh1
oP7o0Ol1o`400@0100410@410@410@410@410@410@400@01007o0Ol1o`7n0Oh1
oP7n0Oh1oP7n0Oh1o`7o0Ol1o`400@0100410@410@410@410@410@4100400@01
007o0Ol1o`7o0Oh1oP7n0Oh1oP7n0Ol1o`7o0Ol100400@0100400@410@410@41
0@410@0100400@01o`7o0Ol1o`7o0Oh1oP7n0Oh1oP7o0Ol1o`7o0Ol100400@01
00400@010@410@0100400@0100400@01o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0@0100400@0100400@0100400@0100400@0100400Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0@0100400@0100400@0100400@0100400@0100400Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`400@0100400@0100400@0100400@01
00400@01007o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`400@0100400@01
00400@0100400@0100400@01o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
00400@0100400@0100400@0100400@0100400@01o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol100400@0100400@0100400@0100400@0100400Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0@0100400@0100400@0100400@0100400@01
007o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`400@0100400@0100400@01
00400@0100400@01007o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol100400@01
00400@0100400@0100400@0100400@01o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0@0100400@0100400@0100400@0100400@0100400Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0@0100400@0100400@0100400@0100400@01007o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`400@0100400@0100400@0100400@01
00400@01o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol100400@0100400@01
00400@0100400@0100400Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0@01
00400@0100400@0100400@0100400@01007o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`400@0100400@0100400@0100400@0100400@01o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol100400@0100400@0100400@0100400@0100400Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0@0100400@0100400@0100400@01
00400@01007o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`400@0100400@01
00400@0100400@0100400@01o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0@01
00400@0100400@0100400@0100400@0100400Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`400@0100400@0100400@0100400@0100400@01007o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol100400@0100400@0100400@0100400@0100400Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0@0100400@0100400@0100400@01
00400@01007o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`400@0100400@01
00400@0100400@0100400@01o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0@01
00400@0100400@0100400@0100400@0100400Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`400@0100400@0100400@0100400@0100400@01o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@01004\>"]},
  ImageCacheContents->"Sound"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Sound  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(f[x_] := \((Which[x > 0, Sin[2  Pi\ x^\((1 + 0.4)\)], True, 0] + 
            Which[x \[LessEqual] 0, Sin[2  Pi\ x], True, 0])\) 
        Which[Abs[x] < 10, Exp[\(-1\)/\((1 - Abs[0.1  x]^2)\)], True, 
          0]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(NF = Nf[f, 0.1];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(NG = Ng[0.1];\)\)], "Input",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(NG // Dimensions\)], "Input"],

Cell[BoxData[
    \({30001}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(\(\(ListPlot[Nshift[NF, NG, #], Frame \[Rule] True, 
              PlotJoined \[Rule] True, 
              PlotRange \[Rule] {\(-0.3\), 0.3}];\) &\) /@ 
        Range[200];\)\)], "Input"],

Cell[BoxData[
    \(Nstft[F_, G_, t_] := 
      Take[Transpose[
          RotateLeft[
            Table[Fourier[Nshift[F, G, b]], {b, 0, 20/t}], {0, 
              Round[\(-10\)/t]}]], Round[\(-10\)/t], 
        Round[2\ 10/t]]\)], "Input",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListDensityPlot[Abs[Nstft[NF, NG, 0.1]], Mesh \[Rule] False, 
          PlotRange \[Rule] All, AspectRatio \[Rule] Automatic];\) // 
      Timing\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00480769 0.00961538 0.00480769 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -6 -9 ]
[.25962 -0.0125 6 0 ]
[.5 -0.0125 -9 -9 ]
[.5 -0.0125 9 0 ]
[.74038 -0.0125 -9 -9 ]
[.74038 -0.0125 9 0 ]
[.98077 -0.0125 -9 -9 ]
[.98077 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .00962 -6 -4.5 ]
[-0.0125 .00962 0 4.5 ]
[-0.0125 .10577 -12 -4.5 ]
[-0.0125 .10577 0 4.5 ]
[-0.0125 .20192 -12 -4.5 ]
[-0.0125 .20192 0 4.5 ]
[-0.0125 .29808 -12 -4.5 ]
[-0.0125 .29808 0 4.5 ]
[-0.0125 .39423 -12 -4.5 ]
[-0.0125 .39423 0 4.5 ]
[-0.0125 .49038 -18 -4.5 ]
[-0.0125 .49038 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .5 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(50)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(100)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(150)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(200)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.06731 0 m
.06731 .00375 L
s
.11538 0 m
.11538 .00375 L
s
.16346 0 m
.16346 .00375 L
s
.21154 0 m
.21154 .00375 L
s
.30769 0 m
.30769 .00375 L
s
.35577 0 m
.35577 .00375 L
s
.40385 0 m
.40385 .00375 L
s
.45192 0 m
.45192 .00375 L
s
.54808 0 m
.54808 .00375 L
s
.59615 0 m
.59615 .00375 L
s
.64423 0 m
.64423 .00375 L
s
.69231 0 m
.69231 .00375 L
s
.78846 0 m
.78846 .00375 L
s
.83654 0 m
.83654 .00375 L
s
.88462 0 m
.88462 .00375 L
s
.93269 0 m
.93269 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .00962 m
.00625 .00962 L
s
[(0)] -0.0125 .00962 1 0 Mshowa
0 .10577 m
.00625 .10577 L
s
[(20)] -0.0125 .10577 1 0 Mshowa
0 .20192 m
.00625 .20192 L
s
[(40)] -0.0125 .20192 1 0 Mshowa
0 .29808 m
.00625 .29808 L
s
[(60)] -0.0125 .29808 1 0 Mshowa
0 .39423 m
.00625 .39423 L
s
[(80)] -0.0125 .39423 1 0 Mshowa
0 .49038 m
.00625 .49038 L
s
[(100)] -0.0125 .49038 1 0 Mshowa
.125 Mabswid
0 .03365 m
.00375 .03365 L
s
0 .05769 m
.00375 .05769 L
s
0 .08173 m
.00375 .08173 L
s
0 .12981 m
.00375 .12981 L
s
0 .15385 m
.00375 .15385 L
s
0 .17788 m
.00375 .17788 L
s
0 .22596 m
.00375 .22596 L
s
0 .25 m
.00375 .25 L
s
0 .27404 m
.00375 .27404 L
s
0 .32212 m
.00375 .32212 L
s
0 .34615 m
.00375 .34615 L
s
0 .37019 m
.00375 .37019 L
s
0 .41827 m
.00375 .41827 L
s
0 .44231 m
.00375 .44231 L
s
0 .46635 m
.00375 .46635 L
s
.25 Mabswid
0 0 m
0 .5 L
s
.01923 .49375 m
.01923 .5 L
s
.25962 .49375 m
.25962 .5 L
s
.5 .49375 m
.5 .5 L
s
.74038 .49375 m
.74038 .5 L
s
.98077 .49375 m
.98077 .5 L
s
.125 Mabswid
.06731 .49625 m
.06731 .5 L
s
.11538 .49625 m
.11538 .5 L
s
.16346 .49625 m
.16346 .5 L
s
.21154 .49625 m
.21154 .5 L
s
.30769 .49625 m
.30769 .5 L
s
.35577 .49625 m
.35577 .5 L
s
.40385 .49625 m
.40385 .5 L
s
.45192 .49625 m
.45192 .5 L
s
.54808 .49625 m
.54808 .5 L
s
.59615 .49625 m
.59615 .5 L
s
.64423 .49625 m
.64423 .5 L
s
.69231 .49625 m
.69231 .5 L
s
.78846 .49625 m
.78846 .5 L
s
.83654 .49625 m
.83654 .5 L
s
.88462 .49625 m
.88462 .5 L
s
.93269 .49625 m
.93269 .5 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.99375 .00962 m
1 .00962 L
s
.99375 .10577 m
1 .10577 L
s
.99375 .20192 m
1 .20192 L
s
.99375 .29808 m
1 .29808 L
s
.99375 .39423 m
1 .39423 L
s
.99375 .49038 m
1 .49038 L
s
.125 Mabswid
.99625 .03365 m
1 .03365 L
s
.99625 .05769 m
1 .05769 L
s
.99625 .08173 m
1 .08173 L
s
.99625 .12981 m
1 .12981 L
s
.99625 .15385 m
1 .15385 L
s
.99625 .17788 m
1 .17788 L
s
.99625 .22596 m
1 .22596 L
s
.99625 .25 m
1 .25 L
s
.99625 .27404 m
1 .27404 L
s
.99625 .32212 m
1 .32212 L
s
.99625 .34615 m
1 .34615 L
s
.99625 .37019 m
1 .37019 L
s
.99625 .41827 m
1 .41827 L
s
.99625 .44231 m
1 .44231 L
s
.99625 .46635 m
1 .46635 L
s
.25 Mabswid
1 0 m
1 .5 L
s
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
% Start of gray image
p
.01923 .00962 translate
.96154 .48076 scale
200 string
200 100 8 [200 0 0 100 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010000000001000000000101000000
0101000000010100000001010000010101010100000000000204080D12181D212323211D
19140F0B0805030101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000101000000
010101010101010101010101010101010101010101010101010101010101010101010101
0101010101010101010101010101010202020100000000010305090E141A1F222424221E
1A15100B0805030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000010101010101010101010101010101010101010101010101
010101010101020201020202020202020202020202020202020202020202020202020202
02020202020202020202020202020303030202010000010204070C11171C212526262420
1B16110C0805030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000101010101010101010101020202020202020202020202020202
020203030303030303030303030303030303030303030304040404040404040404040404
040404040404040404040404040404040404030201020305070B0F151B2125292A292622
1D17120D0906030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000101010101010202020202020202030303030303030303030404040404
040404040405050505050505050505050606060606060606060606060606060606070707
0707070707070707070707070707070707060505040506080B10151B21262B2E2F2D2A25
1F19130E0A06040201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000010101010102020202030303030404040404040505050505060606060606
070707070707080808080808080809090909090909090A0A0A0A0A0A0A0A0A0A0A0A0B0B
0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0A090909090B0E12161C22282E323434322E29
231C16100B07040301000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000000000001010102020203030304040405050506060607070707080808090909090A
0A0A0B0B0B0B0C0C0C0C0C0D0D0D0D0D0E0E0E0E0E0F0F0F0F0F0F0F1010101010101010
111111111111111111111111111111111110100F101113161A20262C32373B3C3C39342E
271F18120D08050302010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000001010102020203030404050606070708080809090A0A0B0B0C0C0D0D0D0E0E
0F0F10101011111112121213131314141415151515161616161717171717181818181818
191919191919191A1A1A1A1A1A1A1A1919191919191B1E21262C32383E42454645413B34
2C231B140F0A060402010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000000000101020203030404050606070809090A0B0C0C0D0E0E0F1010111212131414
1516161717181819191A1A1B1B1C1C1D1D1E1E1E1F1F1F20202021212122222222232323
232424242424252525252525252525252525252526292C30353B41474C5052514F4A433B
31281F18110C080503010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000000010101020203040505060708090A0B0C0D0E0F101112131415161718191A1B1C
1D1E1E1F20212222232424252627272828292A2A2B2B2C2C2D2D2E2E2E2F2F3030303131
3132323232333333333434343434343434343435373A3D42474D52585C5F605F5B544C43
382E241C140E090603020100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
0000000001010202030405050708090A0B0D0E0F111214151618191B1C1D1F2021222425
2627292A2B2C2D2E2F3031323334353536373839393A3B3B3C3D3D3E3E3F404041414142
42434344444445454545464646464646474748494B4E52575C61676B6F70706D6860574C
41352A2018110C0705030101000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000001010102030304050608090B0C0E0F11131517191A1C1E2022242527292B2C2E30
3133343637393A3C3D3E4041424344454748494A4B4C4C4D4E4F50515152535454555556
5757585859595A5A5A5B5B5B5C5C5C5D5D5E5F6163666A6E73787D808383827D776E6357
4A3D31261C150E0A06040201000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000010102020304050607090B0C0E10121517191B1E202325272A2C2E31333537393B
3E4042444547494B4D4E505253555658595A5C5D5E5F6162636465666768696A6B6B6C6D
6E6E6F707071717272737374747575767677797B7D8084888C9194979897948F877C7063
5546392D2219120C08050302010000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
0000000101020203040507080A0C0E101315181B1D202326292C2F3235383A3D40434548
4B4D50525557595B5D6062646667696B6D6F707273757678797A7C7D7E7F808283848586
868788898A8A8B8C8C8D8D8E8F8F909191939496999C9FA3A6A9ACADADABA7A0978B7E70
60514235291E16100B070403010100000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
0000000101020304050608090B0D101215181B1E2225292C2F33373A3E4144484B4E5255
585B5E616467696C6F717476787B7D7F81838587898B8D8E909193959697999A9B9C9E9F
A0A1A2A3A4A5A5A6A7A8A8A9AAAAABACADAEB0B2B4B7B9BCBFC1C3C3C2BEB9B1A79B8D7D
6D5C4D3E30251B140E090604020101000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000001010203040506080A0C0F1114171B1E22262A2D31363A3E42464A4E52565A5D61
65686C6F7276797C7F8285888A8D90929597999C9EA0A2A4A6A8A9ABADAEB0B1B3B4B6B7
B8B9BBBCBDBEBFC0C0C1C2C3C4C4C5C6C7C8CACCCDCFD1D4D5D6D7D6D4D0CAC1B7AA9B8B
7A6958483A2D2219120C0805030201010000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000101010203040507090B0D101316191D2125292D32363B3F44494D52565B5F63686C
7074787C7F83878A8E9194979A9DA0A3A6A8ABAEB0B2B5B7B9BBBDBFC1C3C5C6C8C9CBCC
CECFD0D2D3D4D5D6D7D8D9DADBDBDCDDDEDFE0E2E3E4E6E7E7E8E7E5E3DED8CFC5B8AA99
8876655444362A1F17100C08050302010100000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000101020203040607090B0E1114171B1F23272C30353A3F44494E53585D61666B7074
797D81858A8E9195999DA0A4A7AAADB0B3B6B9BCBFC1C4C6C8CBCDCFD1D3D5D7D9DADCDD
DFE0E2E3E4E6E7E8E9EAEBECEDEEEEEFF0F1F2F2F3F4F4F4F4F3F2F0EDE8E2DAD0C4B6A7
968472604F4033271D16100B070503020101000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000101020203040607090C0E1114181C2024292D32373C42474C51565C61666B70757A
7E83888C9094999DA1A4A8ACAFB3B6B9BCBFC2C5C8CBCDD0D3D5D7D9DCDEE0E2E3E5E7E9
EAECEDEFF0F1F3F4F5F6F7F8F9FAFAFBFBFCFCFCFCFCFBFBFAF8F6F4F1EDE8E1D9CEC1B3
A3917F6D5C4C3D30251C150F0B0705030201010000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000101020203040608090C0E1115181C2025292E33383D43484D53585D62686D72777C
81858A8E93979B9FA3A7ABAFB2B6B9BDC0C3C6C9CCCFD1D4D6D9DBDDE0E2E4E6E8EAEBED
EFF0F2F3F5F6F7F8F9FAFBFCFDFEFFFFFFFFFFFFFEFDFCFAF8F6F4F1EFECE8E3DDD4CABD
AF9E8D7B6A59493B2E241B140F0A07050302010100000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000101020203040607090C0E1114181C2024292E33383D42474C52575C61676C71767A
7F84888D91959A9EA2A5A9ADB0B4B7BABEC1C4C7C9CCCFD1D4D6D9DBDDDFE1E3E5E7E8EA
ECEDEFF0F2F3F4F5F6F7F8F9FAFBFBFCFCFBFBFAF8F7F4F2EFECEAE7E6E4E2E0DCD6CFC5
B9AA9A8978665647392D231B140F0B080504020101000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000101020203040607090B0E1114171B1F23282C31363B40454A4F54595E63676C7175
7A7E83878B8F93979B9FA2A6A9ACB0B3B6B9BBBEC1C4C6C9CBCDCFD2D4D6D8D9DBDDDFE0
E2E3E5E6E7E9EAEBECEDEEEFEFF0F0F1F1F0EFEEECE9E6E3DFDCD9D7D6D6D6D7D6D4D0CA
C1B5A7978675645445382C231B140F0B0806040302010100000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000101010203040507090B0D1013161A1D21252A2E33373C40454A4E53585C6165696E
72767A7E8285898D9094979A9DA0A3A6A9ACAEB1B3B6B8BABCBFC1C3C5C6C8CACCCDCFD0
D2D3D4D6D7D8D9DADBDCDDDEDEDFDFDFDFDFDEDCDAD7D3CFCAC6C2C0C0C2C5C8CCCECECC
C6BDB2A4948473625344382C231B15100B08060403020101000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000001010203040507080A0C0F1215181B1F23262A2E33373B3F43474C5054585C5F63
676B6E7275797C7F8285888B8E919396989B9D9FA2A4A6A8AAACAEAFB1B3B4B6B7B9BABC
BDBEBFC0C1C2C3C4C5C6C7C8C8C9C9C9C9C9C8C6C3C0BCB7B1ACA8A6A6A9AEB6BDC4C8CA
C8C3BBB0A2938372625344382D241C15100C090705030202010100000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
0000000101020304050608090B0E101316191C1F23262A2D3134383C3F43464A4D515457
5B5E6164676A6D6F7275777A7C7E81838587898B8D8F9193949698999B9C9D9FA0A1A3A4
A5A6A7A8A9AAABABACADAEAEAFAFB0B0B0B0AFADABA7A39D96908B88888D959FABB6BFC5
C8C7C3BAAFA2928272625345392E251D17110D0A07050403020101000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
0000000101020203040607090A0C0F111316191B1E2124272A2D303337393C3F4245484B
4D505355585A5C5F61636567696B6D6F7173747678797B7C7E7F80828384858688898A8B
8B8C8D8E8F909091929293939495959696969594928E8A837C746D69696F7A8897A6B4BF
C6C9C8C3BBAFA29383736354473A30261F18130E0B080604030202010100000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000010102020304050608090B0D0F111315181A1C1F212426292B2E30323537393C3E
40424446484A4C4E5052535557585A5B5D5E6061626465666768696A6C6C6D6E6F707172
7273747575767677777878797A7A7B7B7C7C7C7B7A77726C645B524C4B515F708396A7B6
C1C8CBC9C4BCB0A39484746556493C3228201A14100C0907050403020101000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000001010102030304050708090B0D0E10121416181A1C1D1F21232527292B2D2E3032
343537383A3C3D3F40414344454748494A4B4C4D4E4F5051525354555656575858595A5A
5B5C5C5D5D5E5E5F5F5F6060616162626364646463615D584F453B312E36465B71879BAD
BBC5CCCECCC6BDB2A495867667594B3F342B231C16110E0A080604030202010100000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
0000000001010202030405060708090B0C0D0F101213151618191B1C1D1F202223242627
282A2B2C2D2E2F313233343536373838393A3B3C3D3D3E3F3F4041414243434444454546
464747474848494949494A4A4A4B4B4C4D4E4F50504F4C474036291C151F334B627A90A3
B4C1CAD0D1CEC8BFB4A69888796A5C4E42372E251E18130F0C0907050403020101010000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000101010203030405060708090A0B0C0D0E0F1011121314161718191A1B1C1D1E
1E1F2021222324242526272828292A2A2B2C2C2D2D2E2E2F2F3030313132323333333434
343535353636363637373737373838393A3B3C3E3F3F3E3A342C201100142A415870869A
ACBBC7CFD3D4D1CBC2B6A99B8C7C6E5F52463B3129211B16110E0B080605040302010101
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000001010202030304050506070808090A0B0C0C0D0E0F0F101112121314141516
1617181819191A1B1B1C1C1D1D1E1E1F1F20202021212222222323232424242525252526
262626272727272727282828282828292A2B2D2F313232312D271E151018293D53687E92
A4B4C2CCD3D7D7D3CDC4B9AC9E8F807264564A3F352C251E1814100C0A08060503030201
010100000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000000000101010202030304040505060607070809090A0A0B0B0C0C0D0D0E0E0E0F0F
101011111212121313141414151515161616161717171818181819191919191A1A1A1A1A
1B1B1B1B1B1B1B1C1C1C1C1C1C1C1C1C1D1E2022252729292825211C1C222E3E50637689
9BACBAC6D0D6D9D9D6D0C7BCB0A2948577695B4F44393028211B16120E0C090706040302
020101010000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
00000000000001010102020203030404040505050606060707070808080909090A0A0A0B
0B0B0B0C0C0C0D0D0D0D0E0E0E0E0E0F0F0F0F0F10101010101011111111111111121212
12121212121213131313131313131313131416181B1E2123242322222429323F4E5E6F80
91A2B1BEC9D2D8DBDBD8D2CAC0B4A6988A7C6E6154493E352C251F1915110E0B09070504
030202010101000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000010101010202020203030303040404040405050505050606060606070707
0707080808080808090909090909090A0A0A0A0A0A0A0A0B0B0B0B0B0B0B0B0B0B0B0C0C
0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0E1114171B1E20222325282D353F4B596777
8696A5B3C0CBD3D9DCDDDAD5CDC3B8AB9D908274675A4E443A3129231D1814100D0A0807
050403020201010100000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000101010101010202020202020303030303030303030404040404040404
050505050505050505050606060606060606060606060707070707070707070707070707
070707070708080808080808080707070707080B0E12161A1D202225292E353D47525F6C
7A8998A6B4C1CBD4DADDDEDCD7D0C7BCB0A395887A6D6054493F362E27211B17130F0C0A
080605040302020101010000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000010101010101010101020202020202020202020202020202020303
030303030303030303030303030304040404040404040404040404040404040404040404
04040404040405050505050505050404030304070A0E12161A1D2124282D3239414A5560
6D7A8997A6B3C0CBD3DADDDFDDD9D3CAC0B5A99B8E8174675B50463C342C251F1A16120F
0C0A08060504030202010101000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000001010101010101010101010101010101010101010101010101
010102020202020202020202020202020202020202020202020202020202020202020202
0202020202030303030303030303020201000204070B0F13171B1E22262A2E343A414A53
5E6B788795A4B2BEC9D2D9DDDFDEDBD5CEC5BAAEA295887B6E62574C423A322A241E1A15
120F0C0A0806050403020201010100000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000101010101010101
010101010101010101010101010101010101010101010101010101010101010101010101
010101010101010101010101010202010100010306090D1014181C1F2226292D32373E46
4F5B67758493A1AFBCC7D0D8DCDFDFDDD8D1C9BFB4A89C8F82766A5E534940373029231E
1915110E0C0A080605040303020101010100000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000010101010101010101020305080B0F1216191C1F212426292D3238
414B57647281909EACB9C4CED6DBDEDFDEDAD4CDC4BAAEA2968A7E71665B50473E362F28
221D1915110F0C0A08070504030302020101010000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000001010101020305070A0D101316191B1D1E1F2022262B
323C4753616F7E8C9BA9B6C1CBD3D9DDDFDEDBD7D0C8BFB4A99E92857A6E63584E453D35
2E28221D1915110F0C0A0807060404030202010101000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000001010102030507090C0F1114161718181818191B1F
262E3844515E6C7A8997A5B1BDC7D0D6DBDEDEDCD9D3CCC4BAB0A5998D82766B60564D44
3B342D27221D1915120F0C0A090706050403020201010101000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000010102030507090B0D1012131414141211101115
1B232C37424E5B69768492A0ACB8C3CCD3D8DCDDDCDAD6D0C8C0B6ACA1958A7F73695E54
4B433B342D27221D1915120F0D0B09070605040303020201010100000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000010102030506080A0C0E10111111100E0B09090D
131A222B35404C5865727F8D9AA7B3BDC7CFD5D9DBDCDAD7D2CCC4BCB2A89D92877C7167
5D534A423A332D27221D191612100D0B0908060504030302020101010100000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000001010203040608090B0D0E0F0F0F0D0B07040308
0D141B222B343E4854606D7A8794A0ACB7C1C9D0D5D8DADAD8D4CFC8C1B8AEA49A8F847A
6F655B524A423A332D27221E1A1613100E0B0A0807060504030202020101010000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000001010203040607090B0C0D0E0E0D0C0906030206
0B10151B2229313A454F5B6774808D9AA5B0BAC3CBD1D5D7D8D7D5D1CBC5BDB4ABA1978C
82786E645A5249413A332D28231E1A1613100E0C0A080706050403030202010101010000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000001010203040507080A0B0C0D0D0C0B0907050507
0A0D11151A20272E37404B56616D7A86929EA9B3BCC4CBD0D3D5D6D4D1CDC8C1B9B1A89E
948A80766C635A5149413A342E28231F1B1714110F0C0A09070605040403020201010101
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000101020304050608090A0B0C0C0B0A0908070707
090B0E1114191E242B333C45505B66727E8A96A1ABB5BDC4CACED1D3D3D1CEC9C4BDB6AD
A59B92887E746B62595149413A342E28241F1B1814120F0D0B0908070605040303020201
0101010000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000101020203050607090A0B0B0B0B0A0908080708
08090B0C0F12161B21272F37404A545F6B76828D98A2ACB5BDC3C8CCCFD0CFCDCAC6C0BA
B2AAA2998F867C736A61585048413A342E2924201C181512100D0B0A0807060504030302
0201010101010000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000102020304060708090A0B0B0B0A0909080707
070708090A0D1014181E242B333B444E58636E79848F99A3ACB4BBC1C6C9CBCCCBC9C6C1
BCB6AFA79E968D847B716960585048413A342E2924201C181512100E0C0A090706050404
0302020201010101010000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000101020304050708090A0A0A0A0A0908080706
0605050607090B0E12161B21272E363E47515B65707B859099A3ABB3B9BFC3C6C7C8C7C5
C1BDB8B2ABA39B938A817970675F574F48413A342E2925201C191613100E0C0A09070605
0504030302020201010101000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000010102030405060708090A0A0A0A0908070605
040303030405070A0D1014181D232A3138414A535D67717B858F98A1A9B0B6BBBFC1C3C3
C2C0BDB8B3ADA79F9890877F766E665E564E47403A342E2925201C191613100E0C0B0908
0706050403030202020101010100000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001010203040506070809090A0A090908070605
0302010102030507090B0E12161A1F252C333A434B555E68717B858E979FA6ADB2B7BABD
BEBEBDBBB8B3AEA9A29B948C847C746C645C544D463F39332E2924201C191613100E0C0B
0908070605040303020201010101000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001010203040506070809090909090807060504
030100000102030506080A0D1013171C21272D343C444C555E67717A838C949CA2A9AEB2
B5B7B8B8B7B5B2AEA9A49D97908881797169615A524B453E38322D2824201C181513100E
0C0A090806050504030302020101010000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001010203040506070708090909080807060504
0301010101020203040507090B0E1114181D22282E353C444C555E666F78818990989EA4
A8ACAFB1B2B2B1AFACA8A39E98928B847C756D665E575049433C36312C27231F1B181512
100D0B0A08070605040303020201010100000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001010203030405060708080908080707060504
03020101010102020303040607090C0E1115191E23292F353C444C545C656D757D858C93
999EA2A6A9AAABABAAA8A5A19D98928C867F787069625B544D46403A342F2A25211D1A16
13110E0C0B090706050403030201010100000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001010202030405060708080808080706050403
0302010101010101010203040506080A0C0F12161A1E23292F353C434B525A626A727980
878D93989C9FA2A3A4A4A2A09E9A96918C868079726B645D565049433D37312C27231F1B
1815120F0D0B0908060504030202010101000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001010202030405060707080808080706050403
03020101010100000101020203040507080A0D0F12161A1E23292E343B424950575F666E
757B81878C9195989A9B9C9B9A9896928E8A847F79726C655F58514B443E39332E292420
1C181512100D0B09080605040302020101000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001010202030405060607080808070706050403
030201010000000000000101020203040507090B0D1013161A1E23282D333940464D545B
62696F757B8185898D909293939392908D8A86817C77716B655F58524B453F39342E2925
201C1815120F0D0B090706040303020101000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001010202030405060607070707070606050403
0202010100000000000000010101020303040607090B0D1013161A1E22272C32373D444A
50575D646A6F75797E828587898A8A8A888684817D78746E69635D57514B453F39332E29
24201C1815110F0C0A0806050403020101010000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001010102030405050607070707070606050403
02020101000000000000000000010102020304050607090B0D0F1215191D21252A2F353B
40464C52585E63696D7276797C7E808080807F7D7A77736F6A65605A544F49433D37322D
28231F1B1713100E0B0907060403020201010000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102030404050606070707070605050403
020201010000000000000000000000010102020304050607090B0D0F1215181C2024282D
32373D42484D52585D62666A6D707375767676767472706C6965605B56514B45403A3530
2A26211D1915120F0C0A08060504030201010000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102030304050606070707060605050403
0202010100000000000000000000000001010102020304050607090A0C0F1114171A1E22
262B2F34393E43484D51565A5E626567696B6C6C6C6B696765615E5A55514C46413C3731
2C27231E1A1613100D0B08070504030201010000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102030304050606070707060605040403
02020101000000000000000000000000000001010102020304050607080A0C0E10131619
1C2024282C3035393E42474B4F5356595C5E6061626261605E5C5956534F4A46413C3732
2D28241F1B1714110E0B09070504030201010000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102030304050506060606060605040403
02010101000000000000000000000000000000000101010202030304050708090B0D0F12
14171A1E2125292C3035393D4044484B4E51535556575757565553514E4B47433F3B3632
2D2924201C1814110E0C09070604030201010100
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102020304050506060606060505040303
020101010000000000000000000000000000000000000101010202030304050607090A0C
0E101315181B1E2225292C3033373A3E414346484A4B4C4D4D4C4B4A484643403C383430
2C2824201C1814110E0C09070604030202010100
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102020304050506060606060505040303
020101000000000000000000000000000000000000000000010101010202030405060708
0A0B0D0F111416191C1F2225282B2E3134373A3C3E40414243434342413F3D3B3835312E
2A26221F1B1714110E0C09070604030202010100
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102020304040506060606060505040303
020101000000000000000000000000000000000000000000000000010101020203040405
0608090A0C0E10121416191B1E212426292C2E313335363839393A3A3938373533302E2B
2724211D1A1713110E0B09070604030202010100
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102020304040505060606060505040302
020101000000000000000000000000000000000000000000000000000001010102020303
0405060708090B0C0E10121416181B1D1F222426282A2C2E2F3031313130302F2D2B2927
24211E1B181512100D0B09070604030202010100
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102020304040505060606050504040302
020101000000000000000000000000000000000000000000000000000000000101010102
02030404050607080A0B0C0E1012131517191B1D1F212324262728292929292827262422
201E1B191614110F0C0A08070504030201010100
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102020304040505060606050504040302
020101000000000000000000000000000000000000000000000000000000000000000101
01020203030405050607080A0B0C0E0F1113141618191B1C1E1F20212122222221201F1E
1C1A18161412100E0C0A08060504030201010000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102020303040505050605050504040302
020101000000000000000000000000000000000000000000000000000000000000000000
01010101020203030405060607080A0B0C0D0F10111314161718191A1B1B1B1C1B1B1A19
1817151412100E0C0B0907060504030201010000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102020303040505050505050504040302
020101000000000000000000000000000000000000000000000000000000000000000000
0000000101010202020303040506060708090A0B0C0E0F10111213141515161616161615
14131211100E0C0B090807050403020201010000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010102020303040405050505050504030302
020101000000000000000000000000000000000000000000000000000000000000000000
0000000000010101010202020303040505060708090A0A0B0C0D0E0F1010111112121111
11100F0E0D0C0B0A080706050403020201010000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010101020303040405050505050504030302
020101000000000000000000000000000000000000000000000000000000000000000000
00000000000000000101010102020203030404050606070809090A0B0C0C0D0D0E0E0E0E
0D0D0D0C0B0A0908070605040303020101010000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010101020303040405050505050404030302
020101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000001010101020202030304040505060707080809090A0A0A0B0B
0B0A0A0A09080807060504040302020101000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010101020303040405050505050404030302
020101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000001010101020202030303040405050606070707080808
0808080807070606050404030302010101000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010101020203040405050505050404030302
020101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001010101020202020303030404050505060606
0606060606050505040403030202010101000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010101020203040405050505050404030302
020101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000001010101010202020203030304040404
0405050504040404030303020201010100000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010101020203040404050505050404030302
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000001010101010102020202030303
0303030303030303030202020101010100000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010101020203040404050505050404030302
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000010101010101020202
0202020202020202020202010101010000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000010101020203030404050505040404030302
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000010101010101
0101020202020202020101010101000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404050505040404030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000101
0101010101010101010101010100000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404050505040404030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000010101010101010101010000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040505040404030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040504040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000101020203030404040404040403030202
010101000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  InitializationCell->True,
  ImageSize->{288, 177.938},
  ImageMargins->{{281, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40n007h00Ooooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00
oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQ
ool001Woo`8003Woo`<000Coo`8003?oo`@000?oo`8000Coo`80033oo`@000;oo`<000Coo`80033o
o`@000?oo`8000Coo`8000?oo`006?oo00@00?ooool003_oo`04003ooooo0002ool00`00ooooo`0b
ool01@00oooooooo00000_oo00@00?ooool000;oo`03003ooooo02ooo`03003ooooo00Coo`04003o
oooo0002ool00`00ooooo`0]ool00`00ooooo`03ool01000ooooo`000_oo00@00?ooool000;oo`00
6?oo00@00?ooool003_oo`04003ooooo0002ool00`00ooooo`0bool01@00oooooooo00000_oo00@0
0?ooool000;oo`03003ooooo02ooo`03003ooooo00Coo`04003ooooo0002ool00`00ooooo`0^ool0
0`00ooooo`02ool01000ooooo`000_oo00@00?ooool000;oo`006?oo00@00?ooool003Soo`<000?o
o`04003ooooo000dool01@00oooooooo00000_oo00@00?ooool000;oo`03003ooooo02ooo`04003o
ooooool30003ool01000ooooo`00<Ooo00D00?ooooooo`0000;oo`04003ooooo0002ool10001ool1
ool001Soo`04003ooooo000hool00`00ooooo`03ool01000ooooo`00=?oo00D00?ooooooo`0000;o
o`04003ooooo0002ool00`00ooooo`0_ool01@00oooooooo00001Ooo00@00?ooool003;oo`04003o
oooo0002ool01000ooooo`000_oo0@000Ooo0Ooo000Hool01000ooooo`00>?oo00<00?ooool00ooo
00@00?ooool003;oo`<000?oo`04003ooooo0002ool01000ooooo`00;ooo0`000ooo00<00?ooool0
0ooo00@00?ooool002ooo`04003ooooo0002ool01000ooooo`000_oo00@00?ooool000;oo`006Ooo
0P00>Ooo10000ooo0P00=Ooo00<00?ooool00_oo0P001?oo0P00<_oo00@00?ooooooo`@000?oo`80
037oo`8000Coo`8000Coo`8000?oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo000>ool2
0005oooo00080004ool000goo`04003ooooo0004ool00`00ooooo`02ool00`00ooooo`09ool00`00
ooooo`0:ool00`00ooooo`0:ool00`00ooooo`09ool00`00ooooo`0:ool00`00ooooo`09ool00`00
ooooo`0:ool00`00ooooo`09ool00`00ooooo`0:ool00`00ooooo`0:ool00`00ooooo`09ool00`00
ooooo`0:ool00`00ooooo`09ool00`00ooooo`0:ool00`00ooooo`0:ool00`00ooooo`09ool00`00
ooooo`0:ool00`00ooooo`09ool00`00ooooo`0:ool00`00ooooo`0:ool00`00ooooo`02ool00`00
ooooo`02ool000goo`04003ooooo0004ool2003oool3ool30004ool000goo`04003ooooo0004ool0
0`00ooooo`02oomj000202000`Q1264@PP026<<00aSS8@@Q10038@@01ASS6<<@XQ2R26400`Q100<0
80000000JP001Ooo00<00?ooool00_oo000=ool01000ooooo`001?oo00<00?ooool00_ooNP000P0P
00<8@@QQ48800QS300<Hhb448@@00b4400DHhaS34:8@XPQQ00<8@@030200000006X000Goo`03003o
oooo00;oo`003Ooo00@00?ooool000Coo`03003ooooo00;oogX0008080032448HA2R008H``036><Q
124T008Q90038@@HhaS3008@XP054888@@Q12440801/0005ool00`00ooooo`02ool000koo`8000Go
o`03003ooooo00;oogT000<08003264@PQ2R008Hh`038@@Q924T00<Q90068@@H`a2R4:8@PPQQ0PQ1
00<080000000JP001Ooo00<00?ooool00_oo000Eool00`00ooooo`02oom:000W0207000202022440
0`QQ4:8H``028@@00b4T:DDYA@02:DD00b4T8@@Hh`024:801A222648@@Q10200K0001Ooo00<00?oo
ool00_oo000Eool00`00ooooo`02oolW001A0202244248800a2R6<<Q10028B@00bU5:FDYI@02:FD0
0bU58B@Hh`026<<011222648@@Q10P0PJ`001Ooo00<00?ooool00_oo000Eool20003oolW001A0202
244248800a2R6<<Q10028B@00bU5:FDYI@02:FD00bU58B@Hh`026<<011222648@@Q10P0PJ`001?oo
0P001?oo000Eool00`00ooooo`02oolH000M021324401`QQ488@XQ2R6><Q12U5008YI@03<HHaYS6V
008aQP03:FDYAB44008Hh`044:8@PPQ12442021[0005ool00`00ooooo`02ool001Goo`03003ooooo
00;ooa<001008188@A`8HB8@PP03264@PQ22008@PP074:8H`b448@@Q92UU<HH00S6V00<iacWW>NL0
0SW700<aYRUU8B@00QSS00HH`a222648H@Q1021[0005ool00`00ooooo`02ool001Goo`03003ooooo
00;ooa0000T080/8@@`8H@l@PQ@@XR@H``036><Q124T008YI@03<HHiacWW009220=2:0922003>LLa
YRUU008Q10056<<@XPQQ2648@@02021Z0005ool00`00ooooo`02ool001Goo`03003ooooo00;oo`h0
00L080L8@@L8H@P@PPT@XPXH```Hha8Q11TQ908YA@03:FDaQS6V008ia`03@PQ2:4YY00ABRP06BVU:
BDY9@PPiac660RU500LHhaS3488@PPQQ2440801Z0005ool00`00ooooo`02ool001Goo`03003ooooo
00;oo`h000L080L8@@L8H@P@PPT@XPXH```Hha8Q11TQ908YA@03:FDaQS6V008ia`03@PQ2:4YY00AB
RP06BVU:BDY9@PPiac660RU500LHhaS3488@PPQQ2440801Z0005ool00`00ooooo`02ool001Goo`80
00?oo``000L080D8@@D8H@D@PPD@XPDH``HHh`LQ10LQ90TYA@/YIA8aQPlaYP8ia`03>NM2248X009:
J@03DXYJbe[[009Jj`03H`aJje[;009BZP03BVU223W7008YI@078B@Hha2R4:88H@Q10200JP001?oo
0P001?oo000Eool00`00ooooo`02ool;000502052444264348834:846<<46><48@@58B@4:DD5:FD5
<HH6<JH8>LL7>NL<@PPB@RP4BTT2BVT00e::DZYJj`02H``00f</Jde[K@03Lhh01f]]JdeS36<<DZY:
JD88008aYP06:DDQ11S36<<@PPQQ0`0PJ0001Ooo00<00?ooool00_oo000Eool00`00ooooo`02ool;
000402042443264348834:826<<36><28@@48B@2:DD3:FD4<HH4<JH2>LL4>NL5@PP4@RP5BTT6BVT6
DXX9DZX=F//9F^/2H``2Hb`00f]=JfecSP02Nll00g__Q1244003Q1001g__Lji[KF]]H`aBZTY9008i
i`07<HHQ91SS6><@XPQQ24400`0PI`001Ooo00<00?ooool00_oo000Eool00`00ooooo`02ool:0005
02022443264248834:836<<00aSS8@@Q10038B@012U5:FDYIBUU0S660c6V0SW70SWW0T88148X0TY9
0dYY15::0U:Z15[;1E[[16<<1F</1V]=1f]]2W>>27>^0g_?00Ikkh@@Q124<8aAS742U982U;801YcC
U;:D/YBbS764<09kk`03LhiS35:Z0092:007>LLYIB448@@H`a2226400PQ100<080000000I@001Ooo
00<00?ooool00_oo000Eool00`00ooooo`02ool:000502022443264248834:836<<00aSS8@@Q1003
8B@012U5:FDYIBUU0S660c6V0SW70SWW0T88148X0TY90dYY15::0U:Z15[;1E[[16<<1F</1V]=1f]]
2W>>27>^0g_?00Ikkh@@Q124<8aAS742U982U;801YcCU;:D/YBbS764<09kk`03LhiS35:Z0092:007
>LLYIB448@@H`a2226400PQ100<080000000I@001Ooo00<00?ooool00_oo000Eool00`00ooooo`02
ool:000402022443264248801A2R6<<H`aS36><00b4400<Q92U5:FD00RUU00<aQS6V>LL00SW700Di
id88@PQ2248X00=:B@03BVUBRU::00=BZP9Jb`9Jj`9S30AS;09[C@=[K@AcSP9c[PAkc`Ekk`B440J4
<0N<D@R<L@FDTP>D/P06W=>LliccW?>U5:Dd0ZeE0jee0ZeE00>U=:DDU;800XaA00=kkg>>H``00U::
00M2236V:DDYAASS4:8@PP022442021V0005ool00`00ooooo`02ool001Goo`8000?oo`T000<080@8
@@05264@PQ22488@XP036<<01ASS8@@Q924T:DD00RUU0S6600<aYSW7>NL00T8800=2:4Y9BTT00TYY
00=BRU:ZF//00U[;00=Jjf<<Hb`00V</00E[CF]]Jfe[KG>>009c[P=kc`9kk`>440>4<0:<D@><L@>D
TPBD/PBLd`BLl`FU50JU=0R]E@>]M@>eUP>e]P03_MNmmkgg00G660:mm`03_MNeUZDd00:Ld`03S75k
kf]]009Jj`07BVTiic66<HHQ91S34:800PQQ00<8@@0P0200I@001?oo0P001?oo000Eool00`00oooo
o`02ool9000302032442264248824:801AS36><Hhb448B@00RU500<YIC66<JH00SW700<iid88@RP0
0TY900=:JE::DZX00U[;00EJjf<<HbaS;6]=009[K@9cSP03Ljikcg__009kk`03Q124<8aA00:<D@03
S76DTYBB00>D/P04W=>LliccW?<2YA@3YC@4[ED2[GD4]IH4]KH4_ML5_OL6aQP6aSP3cUT4cWT00mJJ
e[[F^P05e[X2eYX00liIaQRe]P02[ED00icCS55kc`02Jdd01e[;BTTiacW7:FDQ11S3008@PP032648
@@0P06D000Goo`03003ooooo00;oo`005Ooo00<00?ooool00_oo2@000`0P0`Q100L8HA22488@PQ2R
6<<Hh`028@@01b4T:DDYIBUU<HHaYSW7008ii`03@RQ:BDYY009BRP03DZYJbe[[009S3006Jde[KG>>
Lhic[W_?0g__00>448@`S5400Xaa00>DTYBbU;800YcC00>LljDDYA@00ZDd0ZeE0Zee0[FF0kFf0[gG
0kgg0/HH0lHh0liI1<ii1=JJ1MJj1]kK1Mkk1>LL1NLl0^mM0^Ll00KW7=kkg__NfliiaSP2_ML00jeE
W=><D@02Ljh01f</DZY2:48X<JHYAASS008@XP034888H@Q1008086<000Goo`03003ooooo00;oo`00
5Ooo00<00?ooool00_oo2@000`0P0`Q100L8HA22488@PQ2R6<<Hh`028@@01b4T:DDYIBUU<HHaYSW7
008ii`03@RQ:BDYY009BRP03DZYJbe[[009S3006Jde[KG>>Lhic[W_?0g__00>448@`S5400Xaa00>D
TYBbU;800YcC00>LljDDYA@00ZDd0ZeE0Zee0[FF0kFf0[gG0kgg0/HH0lHh0liI1<ii1=JJ1MJj1]kK
1Mkk1>LL1NLl0^mM0^Ll00KW7=kkg__NfliiaSP2_ML00jeEW=><D@02Ljh01f</DZY2:48X<JHYAASS
008@XP034888H@Q1008086<000Goo`03003ooooo00;oo`001ooo10000ooo0P001Ooo00<00?ooool0
0_oo2@000`0P0`Q100<8HA224:800Q2R00HH`aSS8@@Q124T:FD2<HH00c6V>LLii`02@RP00dY9BVUB
RP02F//00e[[H`aS;002Jdd01g>>Ljikcg_?Nnn448@`00:<D@03S76DTYBb00:Ld`03W?>U5:Dd00:U
=003[EF]MKFF00:eUP03]KJmekgg00:mm`04aQS6><HhaSP2cUT3cWT2eYX3e[X2g]/4g_/4ia`4ic`5
ked6kgd6mih5mkh4mih01^mmkeg_GNLLg]_FVP;6>003]KJU=9Bb00:4<007LhiS34YYBVU223668B@0
0QSS00<@XQ2224400`0PHP001Ooo00<00?ooool00_oo0007ool00`00ooooo`03ool01000ooooo`00
1?oo00<00?ooool00_oo2@000`0P0PQ10PQQ00H@PQ2R4:8H`aSS8@@28B@01bU5:FDaQS66<JHiid88
0092:003BVUBRU:Z009Jj`03H`aS;6]=009cSP07Ljikcg__Nnn448aAS7400YBB00>D/YcCW?<00ZDD
00>U=:eE[GD00Zee00>eU[Ff_ML00kgg00?66<HhaSP00/iI00C>NMJJeY[FVP;F^P;Nf`;Nn`CW70;W
?0?_G@C_O@CgWPGg_POog`Ooo`Gog`;g_P06mik_ONmmkegW7=kK0/ii00?66;FFYA@00YBB00Mkkf]]
F^]JjdYY>NLaQP028B@00aSS4:88H@022442021Q0005ool00`00ooooo`02ool000Soo`03003ooooo
00;oo`04003ooooo0004ool20003ool900020203244226401Q224:8@XQS36><Q108Q9007:DDYIC66
<HHiacWW@PP00TY900=:JE::F//00U[[00=S36]=Jfd00W>>00Mc[W__Q12448@`S56<L@02U9800iBb
W=>Ll`02YA@00jDd[EF]M@02]IH00kFf_MNmm`03aQP00lHhcUW>F@02cWT01=JJe[[F^]Jj0]kK0]kk
0^LL0nLl0nmM0nmm1?NN1?Nn1OoO3ooo0_oO0oNn00OgW^mmkgg_ONmMiacNn`02e[X00liI_ON]M@02
W?<01haaNlm[CF]=F/]:BCW7008YI@038B@H`a2R0088H@032440800P060000?oo`<000Coo`002Ooo
00D00?ooooooo`0000;oo`03003ooooo00;oo`03003ooooo00;oo`T000<08088@@88H@06488@XQ2R
6<<Hhb440R4T00LYABUU<HHaQSW7>NM22002@RP00dYYDXYBZP02F^/00f<<Hba[K@02Lhh01g>^Nlmk
kg__Q32<DHaa00:DTP03U;:Ldicc00:U5003YCB]EJee00:eUP:e]P04_MNmmkggaQP3aSP00liIcWW>
N@02eYX2e[X3g]/2g_/3ia`2ic`3ked4kgd3mih5mkh7oml2ool5oml3mkh01ONNkgg_ONmmked01>Ll
0^LL00KNnmJje[[>NLHh_ML2[ED01icCS55kcg_?HbaBZT8X008ia`03:FDQ11S3008@XP032648@@Q1
00<085d000Goo`03003ooooo00;oo`002_oo00@00?ooool000;oo`03003ooooo00;oo`03003ooooo
00;oo`T000<08088@@88H@06488@XQ2R6<<Hhb440R4T00LYABUU<HHaQSW7>NM22002@RP00dYYDXYB
ZP02F^/00f<<Hba[K@02Lhh01g>^Nlmkkg__Q32<DHaa00:DTP03U;:Ldicc00:U5003YCB]EJee00:e
UP:e]P04_MNmmkggaQP3aSP00liIcWW>N@02eYX2e[X3g]/2g_/3ia`2ic`3ked4kgd3mih5mkh7oml2
ool5oml3mkh01ONNkgg_ONmmked01>Ll0^LL00KNnmJje[[>NLHh_ML2[ED01icCS55kcg_?HbaBZT8X
008ia`03:FDQ11S3008@XP032648@@Q100<085d000Goo`03003ooooo00;oo`001ooo00@00?ooool0
00;oo`04003ooooo0004ool00`00ooooo`02ool90003020324400`QQ488@XP024:801QS36><Q1244
:DDYI@8aQP03<JHiad880092:003BTU:JE:Z009Jb`03F^]S36</009[K@07Lhic[W_?Nlmkkh@@Q300
0XaA00><LIBBU;800YcC00>LljDDYC@00ZeE00>]MKFF]IH00[Ff0[gG0[gg00?66<HhaSP00liI0/ii
0]JJ0]Jj1=kK0]kk1>LL1>Ll1>mM1^mm1_NN1>mm0^mM00?W?>LLg_/00]kk00?NfmJje[X01mJj00?F
V/iIaQP00[Ff00NU=9BbQ324<7>^HbaBZP02@RP00cW7:FDQ10026<<00a2R2648@@022442021L0005
ool00`00ooooo`02ool000Soo`8000Coo`8000Goo`03003ooooo00;oo`T000<080<8@@07264@PQ22
488@XQS36><00R4400LQ92U5:FDYIC66<JHii`02@PP00d8XBTU:J@02DXX00e[;F^]S3002Hb`01f]=
JfecSW>>Ljikcg__00:44003Q32<DHaa00:DTP:D/P03W=>Llicc00:U5003YCB]EJeE00:]M@>eUP04
]KJmekgG_ML2_OL3aQP2aSP3cUT3cWT4eYX4e[X5g]/>g_/01]kKe[[F^]JJcWW>F@;6>0G66003aSS>
FLii00C>N@05aSRmmkgg]IJU=002U;800h@`LhiS3002DXX00d8X>LLYI@028@@00aS34:8@PP032443
021J0005ool00`00ooooo`02ool001Goo`03003ooooo00;oo`T000<080<8@@88H@8@PP034:8H`aS3
008Hh`078@@Q92U5:DDYIC66<JH00SW700<iid88@RP00TYY00=BRU:ZF//00e[[00IS36</Hba[CF]]
Lhh2Ljh00g_?Nnmkk`02Q1000h@`S56<D@02S742U98019BbW=>LdicC0icc00>U5:DdYC@00jeE1:ee
0[FF1;Ff0[gG1[gg1LHH1LHh2/iI00O6><HHaQS66;gg]KJeUP02[GD00jeEYCBU=002[ED00jee]KJm
m`02aSP3cUT2aQP01kgG]IJU5:DDU9:447>>009S3003DXY2:3W7008YI@038B@Hha2R008@PP032648
@@0P008085T000Goo`03003ooooo00;oo`005Ooo00<00?ooool00_oo2@000`0P10Q100H8HA22488@
PQ2R6<<36><01R448B@Q92U5:FDaQP8aYP03>LLiicWW00922003@RQ:BDYY009BRP9BZP9Jb`03F^]S
36</009S;003Jde[KF]]009cSP9c[P04Nlmkkg__Nnl2Q103Q303S542S743U982U;84W=<4W?<3YA@6
YC@6[ED7[GD5]IH3[GD01ZeEYCBU=:DDW?>D/P:DTP><D@:<L@03U;:LljeE00:e]P03_OO6><iI00;6
>007aQRmejee[GFU59BBQ1000W>>00=S35::@RP00SW700<YIB4T6><00Q2R00@@PPQQ2448@@<085L0
00Goo`03003ooooo00;oo`005Ooo0P000ooo2@000`0P10Q100H8HA22488@PQ2R6<<36><01R448B@Q
92U5:FDaQP8aYP03>LLiicWW00922003@RQ:BDYY009BRP9BZP9Jb`03F^]S36</009S;003Jde[KF]]
009cSP9c[P04Nlmkkg__Nnl2Q103Q303S542S743U982U;84W=<4W?<3YA@6YC@6[ED7[GD5]IH3[GD0
1ZeEYCBU=:DDW?>D/P:DTP><D@:<L@03U;:LljeE00:e]P03_OO6><iI00;6>007aQRmejee[GFU59BB
Q1000W>>00=S35::@RP00SW700<YIB4T6><00Q2R00@@PPQQ2448@@<085L000Coo`8000Coo`005Ooo
00<00?ooool00_oo2P00100P0PQ10`QQ0Q2200D@XQS36<<H`aSS008Q108Q9003:DDYIBUU008aQP03
<JHiacW7008ii`03@PQ2:48X009:B@9:J@9BRP04DZYJbe[;F//2F^/3H``2Hb`3Jdd2Jfd3Lhh3Ljh3
Nll4Nnl4Q104Q306S545S749U98:U;801YBBS76<LHaAQ11kk`9c[P03Jfe[CF]=009[K@03Nln<DIBb
00:U=003]KJmmlHh00?>F@06aQRmekgG[GFU59BB0X@@00=cSV<<DZX00T8X00<iac668B@00QSS00@H
`a222648H@88@@<085D000Goo`03003ooooo00;oo`005Ooo00<00?ooool00_oo2P00100P0`Q10`QQ
0Q220Q2R0QS30aSS00@Q124T8B@Q908YA@04:FDaQS66<HH2<JH2>LL2>NL3@PP2@RP3BTT2BVT4DXX3
DZX3F//3F^/4H``5Hb`4Jdd6Jfd6Lhh9Ljh9Nll4Nnl2Nll2Ljh00g>>JfeS;002F//00e::BVU:B@02
DXX00e[[Lhj44002U;800jDd]KK66004cUT2aSP00kgg]IJU5002U;800h@`LjiS;002DZX00dY9>NLa
QP02:DD01b446<<@XQ2R4888H@Q100@085<000Goo`03003ooooo00;oo`005Ooo00<00?ooool00_oo
2`00100P10Q10PQQ0a220Q2R0aS311SS0R440b4T0RU50bUU0S66136V0cW70cWW1488148X1DY91DYY
1E::1U:Z25[;2e[[2F<<16</0f<<00=Jje[;BVT00T8X00<iac66:FD00S6V00=2:5[;Lhh00X@`00>L
djee_ML00/Hh1<ii00?6>;gg]IH00ZDd00>D/X@`Ljh00V</00=JbdY9>NL00S6V00LYAB446><Hha2R
4888H@032442021B0005ool00`00ooooo`02ool001Goo`03003ooooo00;oo`/000D080@8@@@8H@@@
PP8@XP@H``@Hh`<Q10@Q90@YA@DYI@@aQPDaYPHia`Pii`M220a2:0i:B@E:J@9BRP=:J@07@RQ2236V
<JHYAASS4:800QSS00<aQTY9H``00W_?00>DTZDD]KH00/HH00O>FMJJeY[FV/iicUVmm`02]KH00jDd
W=><D@02Nll00f]=F^]:J@02@PP01c6V:FDQ924T6><H`a2200<8H@032440800P008084l000Goo`03
003ooooo00;oo`005Ooo00<00?ooool00_oo2`001@0P10Q110QQ11220Q2R11S311SS0b44124T12U5
1BUU13661C6V1SW723WW1d88348X3TY91DYY0U::0dYY00M2:488<JHaYRU56><@XP026><00c66BTUS
3002Nll00iBBYABe]P02aQP01liIeY[FV]JJcWW>FKgg00:e]P03YCBLdhaA009kc`03JdeJjdYY0092
2007<JHYIB4T8B@HhaS348800`QQ00<8@@0P02000P0PC`001Ooo00<00?ooool00_oo000Eool20003
ool<000502052446264548834:856<<76><58@@68B@8:DD::FD;<HHC<JH6>LL7>NL01cW7<JHYIBUU
8@@@PP00008@XP03:DE225[;009cSP03Q32Ldjee00:me`07aSS>NMJJeY[F^]JJcUT00/HH00>e]ZeE
W=<00Xaa00=kkf]]F^/00U::00M2:3W7<HHaQRU58@@H``024:800a222648@@022443021=0004ool2
0004ool001Goo`03003ooooo00;oo`h000H080H8@@P8H@H@PPP@XPTH``XHh`hQ11DQ90/YA@<YI@Da
QP06:FDQ924T6><@XQ220QS300<YACWWDXX00V]=00=kkiBBYC@00[Ff00C66<iieY[FVP;F^P06eY[>
NLiiaSRmejee0Ycc00><LH@@Lhh00V</00MBZTY9>NLiic6V:FDQ90026><00aS34:8@PP0226422443
021;0005ool00`00ooooo`02ool001Goo`03003ooooo00;oo`l000X080T8@@/8H@`@PQ0@XQ/H``dH
h`<Q10<Q90<YA@8Q90038@@HhaSS008Q1003:FDiie::009S3003Ljj<DIcC00:]M@05_MO6>=JJeY[F
^P02g]/2e[X00mJJaSRmm`02]IH00jDDU;:4<002Ljh01f]=F/]:JDYY@RPiac66008YA@038@@H`a2R
008@PP88H@032440800P008084T000Goo`03003ooooo00;oo`005Ooo00<00?ooool00_oo4@00400P
40Q15PQQ:A220a2R0QS30QSS0R4400<Q92448@@00R4400HQ92U5:DDaQSWWBVT2F^/00f]]Q12DTP02
YA@01KFF_OO>FLiIeYX01MkK00OFV/iIaQS66;FfYCBLd`02S5401g__JfeS36<<DZY:BCWW008aYP03
:FDQ91SS008H``034:8@PPQQ00<8@@@084H000Goo`03003ooooo00;oo`005Ooo00<00?ooool00_oo
4@00400P40Q15PQQ:A220a2R0QS30QSS0R4400<Q92448@@00R4400HQ92U5:DDaQSWWBVT2F^/00f]]
Q12DTP02YA@01KFF_OO>FLiIeYX01MkK00OFV/iIaQS66;FfYCBLd`02S5401g__JfeS36<<DZY:BCWW
008aYP03:FDQ91SS008H``034:8@PPQQ00<8@@@084H000Goo`03003ooooo00;oo`005Ooo00<00?oo
ool00_oo5P006P0P:0Q16`QQ00H@PQ2R4:8@XQS36><48@@01b4T:DDYIBUU<JHiidY9009Jb`03Hbac
[X@`00:D/P07YCBeU/HHaQS>FMJJg]/00mkk00ONfmJjcWW>NLHH_MN]E@02W?<01iBBQ11c[W>^HbaJ
bdYY0092:003>LLaQRU5008Q10036><H`a2R008@PP032648@@Q100@084@000Goo`03003ooooo00;o
o`005Ooo0P000ooo8`00?P0P2PQ11P0P0`Q100H8HA22488@XQS36><38@@01b4T:DDYIBUU<JHiid8X
009BRP03F^][KG_?00:<D@07W=>U=;Ff]KK66<iIe[X00]kK0mkk0]Jj00?FV/Hh_OL00[FF00NU59Bb
S56<DG_?JfeS3002DZX00dY9>NLaYP02:FD00b4T8@@H``024:800a222648H@03244402110004ool2
0004ool001Goo`03003ooooo00;oocl00300808000<080062448H@QQ488@XQS30QSS00<Q124T:DD0
0RUU00<aQSW7@PP00TY900=BZV<<Jfd00W_?00N<DIBbYCBU=;FFaQS>F@02eYX00mkKg__Nn`02g_/0
0mkKeY[>F@02aQP01kFf[EFLdicCS76447>^009S;003F/]BRT8X008ii`03<JHYIB4T008Hh`036<<@
XQ2200<8H@<8@@<083l000Goo`03003ooooo00;oo`005Ooo00<00?ooool00_ooL`000P0P0PQ100<8
HA224:800QS300<Hhb448B@00RU500<YIC6V>LL00T8800=:BE::F^/00V]=00Mkch@`U;:D/ZDd]IJm
m`02cUT00mJJg]_Nn`03g_/01]kKe[[>NLiiaSRme`:]M@03YABD/XaA009kc`03JfeS35:Z009:J@03
@PPiac66008YA@038B@HhaS3008@XP044888H@QQ26422444020l0005ool00`00ooooo`02ool001Go
o`03003ooooo00;oog@000060208@@Q1264@PQ2R0QS30QSS00HQ124T8B@YABUU<HH2<JH00cWW@RQ:
J@02F//01f</Ljj4<8@`U9:U5:ee00:mm`03aSSFV]kK00GNn`;Nf`07eY[>FKgg_ONe]ZeEW?<00Xaa
00>447>^Jdd00U[[00=BRTY9@PP00S6V00<aQRU58@@00QSS00@H`a2R488@PP88H@<8@@<083X000Go
o`03003ooooo00;oo`005Ooo00<00?ooool00_ooM00000H080Q12448HA224:826<<26><01R448B@Q
92U5:FDaQP8aYP03>NM2:4YY009Jb`07Hbac[X@`Q32DTZDD[GD00[gg00?6>=JJg]/01Mkk0]kK00OF
V/iI_ONmmkFf[EFLl`02S7400h@@Lji[C@02F^/00e::BTU22002<JH00c66:DDQ10026><011S34:8@
PQ220PQQ0`Q10`0P>P001Ooo00<00?ooool00_oo0009ool00`00ooooo`02ool20005ool00`00oooo
o`02oomd00001P0P2448@@Q1264@PP8@XP036<<HhaSS008Q108Q9006:DDYIBUU<HHiad880TY900MB
ZV</LhicSX@@U9:Ll`02[GD00kgGaSS>N@02e[X00mkKg__Nn`02g_/01mkKe[[>NLiiaSRmejee00:U
5003U;:<DG__009cSP03HbaJbe::0092:003>NLaYRUU008YA@068@@HhaS36<<@XQ220`QQ0PQ1100P
=`001Ooo00<00?ooool00_oo0009ool01@00oooooooo00000_oo00<00?ooool00_oo00<00?ooool0
0_ooM0000`0P00<8@@QQ48800Q2200<@XQS36<<011SS0b4400<Q92U5<HH00SWW00M2:5::H`aS36]]
Nnn<L@02W=<00jeE]KK66002cUT00mJJg]_Nn`03g_/01]kKe[[F^]JJcUVmm`:e]P03[EFLliBB00:4
<003Nlm[KF<<009Jb`03BVU2:3WW008aYP07:FDYAB448@@HhaS34:800Q220PQQ0`Q11@0P<`001Ooo
00<00?ooool00_oo0006ool50002ool01000ooooo`001?oo0P000oooM0000`0P00<8@@QQ26400Q22
0a2R21S300HHhb4T:FDYICW7@RP2DXX00e[[Jfekc`02S5400iBbYCBeUP02_OL00lHheY[F^P02g]/4
g_/00mkKeY[>N@02aSP00kgG]IJU=002W=<00haaQ11c[P02Jdd00f<<DZY:J@02@RP01cW7<JHYIBUU
8B@Q11SS008H``034:8@PPQQ0088H@88@@D0834000?oo`<000Coo`001_oo00@00?ooool000?oo`04
003ooooo0004ool00`00ooooo`02oomd0003020224400`QQ488@PP0248844:8548801Q2R6<<Q1244
:FDaYP922003BVUJbf]=009c[P03Q32DTZDD00:]M@03_MO66<ii00;FVP03g]_Nnmkk00;Nn`07g]_F
^]JJeY[>FLHH]KH00Zee00>U59BbS5400W__00=cSV]=F^/00U:Z00M:BD88>LLiac6V:FDQ90028@@0
0aSS6<<@XP02488226432445020^0005ool00`00ooooo`02ool000Ooo`03003oo`0000?oo`04003o
oooo0004ool00`00ooooo`02oomd0003020224400`QQ488@PP0248844:8548801Q2R6<<Q1244:FDa
YP922003BVUJbf]=009c[P03Q32DTZDD00:]M@03_MO66<ii00;FVP03g]_Nnmkk00;Nn`07g]_F^]JJ
eY[>FLHH]KH00Zee00>U59BbS5400W__00=cSV]=F^/00U:Z00M:BD88>LLiac6V:FDQ90028@@00aSS
6<<@XP02488226432445020^0005ool00`00ooooo`02ool000Soo`8000?oo`04003ooooo0004ool0
0`00ooooo`02oomd000302022443264648800`QQ2448@@0224401PQQ488H`aS38@@YA@8aYP03@PQ:
JE[;009S;003Lhikkhaa00:Ld`03YCBeU[gg00;6>003cWWF^]kK00;Nf`07g__NfmJje[[FV/iiaSP0
0[gg00>eUZeEW?<00YBB00>4<7__Lhh00V</00MJje::BTU:BD88>LLaQP02:FD00b4T8@@Hh`026<<0
0a2R488@PP0226432444020/0005ool00`00ooooo`02ool000Woo`03003ooooo00;oo`8000Goo`03
003ooooo00;oog@000<080<8@@P8H@072440800P020000Q126400Q2R00LH`b44:DDYAC6V>NM:B@02
DZX00f<<Jfekc`02Q3000iBbYAB]M@02]KH01LHHcUWFV]JJe[X01MkK00OF^/iicUW>FLHH_MN]M@02
YC@00icCS764<002Nll01f]]HbaJbe[;DXY:BD88008ia`03<HHYIB4T008Q10036><H`a2R00<@PP03
2648@@Q10088@@D082P000Goo`03003ooooo00;oo`005Ooo00<00?ooool00_ooM000100P0PQ120QQ
00<8@@0P00000P0000H080Q1488@PQ2R6<<28@@00bU5<HHia`02@RP00dYYF/]S;002Ljh00h@@S76L
d`02YC@01[FF_MO66<HHcUWFVP?F^P03g]_F^]Jj00;FVP03cUW6>;gg00:e]P03[EFU59Bb00:<L@07
Q11kcf]]JfeS;5[;DXX00TY900=223W7<HH00RUU00<YAB446><00QS300<@XQ2248800`QQ0`Q11@0P
9@001Ooo00<00?ooool00_oo000Eool20003oomd0004020424452642244502001@Q12648HA224:80
0QS300<Q124T:FD00S6V00=224Y9DZX00V<<00=[KG_?Q3000YBB00NLljeE]IJeU[ggaSS>F@03eYX4
e[X00mJJcWW>F@02aQP00kgG]IJ]E@02W?<01iBbS56448@@Lji[KF<<009Jb`03DXY:BD88008ia`03
<JHYIBU5008Q10036><H`a2R008@XP044888H@QQ26422446020R0004ool20004ool001Goo`03003o
oooo00;oog@000@080@8@@D8H@88@@D080052448H@QQ488@XP026<<00b448B@YI@02<JH00d88BTUB
ZP02H``00f]]Nln4<002U9801icc[EFeU[FF_OO6><iI00?FVPCF^P03eY[>NLiI00;66003_MNeUZeE
00:Ll`07U;:<DH@@Q11c[V]]H``00U[;00=BRTY9@PP00SW700<aYRUU:DD00R4400<HhaS34:800Q2R
00@@PPQQ2648H@88@@H0828000Goo`03003ooooo00;oo`005Ooo00<00?ooool00_ooM000100P1@Q1
0PQQ1@Q1100P0`Q100L8HA224:8@XQS36><Q9002:DD00c66>NM2:002DXX00e[;HbacSP02Nnl01haA
U;:U5:DD[EFe][gg00;6>003cUW>NMJJ00CFVP06cWW>FLiIaSRmmkFf0Zee00NU=9cCU9:DTXaANnmc
[P02Jdd00f<<F/]BRP02BTT00d88>LLaYP02:FD00bU58B@Hh`036<<00a2R488@PP0226442445020O
0005ool00`00ooooo`02ool001Goo`03003ooooo00;oogD000@080d8@@030208@@Q100<8@@<8H@03
488@XQS3008Q10038B@YIC6V00922003BTUBZU[[009[C@07Ljj448aaS76LdjDD[GD00[Ff00>mmlHH
cUT00lii00OFV/iicWW>NLiIaSS66002_ML01kFF[EFU5:DDW=><LH@`009kk`03Lhi[CF<<009Jb`03
DXY:BD88008ia`03<JHYIBU5008Q90058@@HhaS36<<@XP02488226432445020M0005ool00`00oooo
o`02ool001Goo`03003ooooo00;oogD000@080d8@@D080@8@@03264@PQ2R008H``036><Q92U5008a
QP03>LM2:4YY009Jb`07H`a[KG_?Nln4<8aaW=<00ZDD00>]MKFf_ML00/HH00?6><iIcUT00/ii0/iI
00G6><HHaQRmmkFf00:]M@03YCBLliBb00:<L@03Q31kcg>>009[C@03H`aJbe::009:B@03@PPiac6V
008YI@07:DDQ92448@@HhaS34:800a220PQQ0`Q11P0P6@001Ooo00<00?ooool00_oo000Eool00`00
ooooo`02oome0004020=2449020224401PQQ488@PQ2R6<<Q108Q9003:FDaYSWW0092:007DXYJbf</
HbacSW_?Q3000YBB00>LdjDD[ED00[FF00>mekggaQP00lHh00K>FLHhaSS6><HH_OL2_ML00kFF[EFU
5002W=<00iBBS5644002Nll00g>>HbaJj`02DZX00dYYBTU22002>LL01c6V:FDYABU58B@Q11SS008H
``034:8@PQ2200<8H@88@@L081H000Goo`03003ooooo00;oo`005Ooo0P000oooM@00100P3@Q12@0P
0PQ100H8HA22488@XQS38@@28B@00bUU<JHii`02@RP01e::F/]S;6</Lhikch@`00:DTP03W=>U5:eE
00:eUP03_MNmmlHH00?6>006cUW6><HhaSS66;gg0[gG00>eUZeEYA@00YcC00>DTXaAQ1000W_?00=c
SV</F^/00U:Z00=:JDY9@PP00SW700LaYRUU:DDYAB4T8@@Hh`026<<00a2R488@PP0326422447020F
0004ool20004ool001Goo`03003ooooo00;oogD000D080X8@@D080@000@080062448H@QQ488@XQS3
0QSS00<Q12U5<HH00SW700M224Y9DXYBRU[[HbacSP02Nll00h@`S76Ld`02YA@00jeE]IJe]P02_ML0
0kggaQS66004aQP2_OL00kgG]IJ]M@02YC@00iccW=>DTP02Q3000g__Lji[K@02Hb`00e[[DZY:J@02
@RP01d88>LLaYS6V:FDYAB4T008Q10036><H`a2R00<@PP88H@@8@@D081@000Goo`03003ooooo00;o
o`005Ooo00<00?ooool00_ooM@001@0P2PQ1100P20000P0P0`Q100L8HA224:8@XQS36><Q9002:FD0
1c66>LM22488BTUBZU[[009[C@03Lhikch@`00:<L@03U;:LljDd00:]M@03]IJe][gG00Jmm`:me`06
]IJ]MJee[EFU59cC0YBb00><LH@`Nnl00W>^00=[KF</F^/00U:Z00M:JD8X>NLiicW7<HHYI@02:DD0
0b4T8@@Hh`026<<00a2R488@PP0326442445020A0005ool00`00ooooo`02ool001Goo`03003ooooo
00;oogD000D080T8@@D080T000<08088@@06264@PQ22488@XQSS0R4400LQ92UU<JHaYSWW@RQ:J@02
DZX00e[[HbacSP02Nll00h@@S76D/P02W?<00jDD[EF]M@02]IH2]KH3_ML2]KH2]IH00jee[EFU=002
W?<00iBbU9:<D@02Q1000g_?Lhi[C@02H``01e[;DXY:BDY9@RPiicW7008aQP03:FDYAB4T008Q1003
6><H`a2R00<@PP88H@@8@@D080l000Goo`03003ooooo00;oo`005Ooo00<00?ooool00_ooM@001`0P
1`Q11@0P2P00100P0`Q100<8HA224:800QS300LHhb44:DDYABUU<JHii`02@RP00dYYDZYJj`02Hb`0
0f]]Nln44002S5400iBBW=>Ll`02YC@01:eE[GF]MJee1KFF0Zee00J]EJDDYABLlicCU982S5400h@`
Nnmc[P02Jfd01f</F^]BZU:ZDXY:BD88008ii`03<JHaQRUU008Q90038@@HhaS3008H``034:8@PQ22
0088H@@8@@D080d000Goo`03003ooooo00;oo`005Ooo00<00?ooool00_ooM@001`0P1`Q11@0P2P00
100P0`Q100<8HA224:800QS300LHhb44:DDYABUU<JHii`02@RP00dYYDZYJj`02Hb`00f]]Nln44002
S5400iBBW=>Ll`02YC@01:eE[GF]MJee1KFF0Zee00J]EJDDYABLlicCU982S5400h@`Nnmc[P02Jfd0
1f</F^]BZU:ZDXY:BD88008ii`03<JHaQRUU008Q90038@@HhaS3008H``034:8@PQ220088H@@8@@D0
80d000Goo`03003ooooo00;oo`005Ooo0P000oooM`001@0P1PQ11P0P3@00100P00<8@@QQ26400Q22
00L@XQS36><Hhb44:DDYI@02<JH00cWW@RQ:J@02DZX00e[[Hba[K@02Ljh00g__Q32<L@02U9801IcC
W?>U5:DDYC@01jeE0ZDd00>U59ccW=<00YBB00><LH@`Nnl00W_?00McSV]=H`aS35[;DZY:J@02@RP0
0d88>LLaYP02:FD00bU58B@Q10026><00aS34:8@PP02488226432445020<0004ool20004ool001Go
o`03003ooooo00;oogL000D080H8@@D080l000@08088@@<8H@06488@XQ2R6<<Hhb440RU500<YIC6V
>NL00T8800=:BE::F//00V<<00=[CG>>Nll00X@@00F4<8aaU9:DTYcC00:Ll`>U50:U=0>U5007W?>L
diBbU;:DTXaaQ3000X@@00Mkcg>>Jde[CF</F^]BZP02DXX00dY9@PPii`02<JH00c66:FDQ90028@@0
0aSS6<<H``024:8011222648H@QQ0`Q1100P2`001Ooo00<00?ooool00_oo000Eool00`00ooooo`02
oomg000602052445020B00030203244326400a224:8H``026><00b44:DDYI@02<JH00cW7@PQ:B@02
DXX00e:ZF^]S;002Jfd01g>^Nln448@@Q32<LIBB00:D/P>Ld`:Ll`>Ld`:D/P03U9:<LHaA00:4<007
Nnmkcg>>Lhi[KF</F^/00U[;00=BRTY9@RP00SWW00<iac66:FD00RU500<Q92446><00QS300D@XQ22
488@PPQQ00@8@@<080X000Goo`03003ooooo00;oo`005Ooo00<00?ooool00_ooM`001P0P10Q11P0P
5000100P0`Q100<8HA2248800Q2R00<H`aSS8@@00RU500<YIC66>LL00T8800=2:4YYDZX00U[;00MS
36]=Jfe[KG>^Nln44002Q3000haAS76DTP08U9801XaaS564<8@`Q11kk`9c[P03Lhi[CF</009Jj`03
F/]BRTY90092:003>NLiac6V008YI@03:DDQ9244008Hh`046<<@XQ22488226432443020:0005ool0
0`00ooooo`02ool001Goo`03003ooooo00;oogL000H080@8@@H081@000@080<8@@03264@PQ22008@
XP036<<Hhb44008YA@03:FDaQSW700922003@RQ:JE:Z009Jb`07H`a[CF]]Jfec[W_?Q1000X@`00><
DHaaU98029BB00J<LHaAQ324<8@@Nnl2Ljh00g>>JdeS;002F^/00e[;DXY:B@02@RP00cWW>LLaYP02
:FD00bU58B@Q10026><011S34:8@PQ220PQQ0`Q10`0P2P001Ooo00<00?ooool00_oo0008ool20004
ool20005ool00`00ooooo`02oomg000@020G0004020224401PQQ488@PQ224:8H``8Hh`038@@Q92UU
008aQP03<JHiid8X009:B@07DXYBZU[[F^]S;6]=Jfd00W>^00=kcg__Q1000h@`1XaA0h@`00N447__
Nlmkcg>^Jfe[C@02H``00e[[DZYBRP02BTT00d8X>NLia`02<HH00bUU:DDQ90028@@01ASS6<<@XQ2R
48800PQQ0`Q1100P20001Ooo00<00?ooool00_oo0007ool01000ooooo`000_oo00@00?ooool000Co
o`03003ooooo00;oogL0010081P000D080<8@@88H@06488@XQ2R6<<Hhb440R4T00<YABUU<JH00SW7
00M2248XBVU:JE::F/]Jj`02H``00f]=JfecSP02Ljh00g_?Nnmkk`05Q103Nnl01W_?Ljic[W>>Jfe[
C@9S;003H`aJbe:Z009:J@03BTU223WW008aYP03<HHYIBU5008Q10046><H`a2R4:82488010QQ2448
@@Q1100P20001Ooo00<00?ooool00_oo0007ool01000ooooo`000_oo00@00?ooool000Coo`8000?o
ogL0010081/000D08088@@<8H@03488@XQS3008Hh`038@@Q92U5008YI@07<HHaYSWW>NM224Y9BVT0
0U::00=Jbe[[H``00V</00=[CF]]Lhh00W>>1g>^0g>>00M[KF]=HbaS;6<<F/]BZP02DXX00dY9@RQ2
2002>LL00c6V<HHYA@028B@01R446><H`aS34:8@PP<8H@88@@@080L000?oo`<000Coo`001ooo0`00
0ooo00@00?ooool000Coo`03003ooooo00;oogP000l081d000D080<8@@88H@06488@XQ2R4:8H`aSS
0R4400LQ92U5:FDYIC6V>LLii`02@PP00dY9BVUBRP02DZX00e[;F^]S3003Hb`2Jdd4Jfd3Jdd2Hb`2
H``00e[[F/]BZP02DXX00dYY@RQ22002>NL00c6V<HHYI@028B@01B446><H`aS34:800Q220PQQ0PQ1
100P1`001Ooo00<00?ooool00_oo0007ool00`00ooooo`03ool01000ooooo`001?oo00<00?ooool0
0_ooN0003`0P7@001@0P0`Q10PQQ00H@PQ2R4:8@XQS36><28@@01b4T:DDYIBUU<JHiacWW00922003
BTU:JE::009BZP03F/]Jjf<<00=S;09[C@A[K@=[C@9S;09S3003F^]Jbe:Z009BRP03BVU2:488008i
i`03<JHaQRUU008Q90058@@HhaS36<<@XP0248822642244402070005ool00`00ooooo`02ool000Oo
o`03003ooooo00?oo`04003ooooo0004ool00`00ooooo`02oomh000?020P00050202244326424880
1A2R6<<H`aSS8@@00R4T00<YABUU<HH00S6V00<iacWW@PP00T8X00=:BDYYDXX00U:Z00=Jbe[[F^/0
26<<0e[[00=Jbe:ZDXX00TYY00=:BD8X@PP00SWW00<aYS66:FD00RU500@Q91SS6<<H``8@XP034888
H@QQ0088@@@080L000Goo`03003ooooo00;oo`002?oo0`000ooo0P001Ooo00<00?ooool00_ooN000
3`0P8`00100P10Q10PQQ0Q220Q2R0QS300<Hhb448B@00RU500<YIC66<JH00SW700<iid88@RP00dY9
00A:JE::DXYBRPUBZP9BRP06BVU:BDY9@RQ223WW0SW700<aYS66:FD00RU500LQ92446><HhaS34:8@
PP0326400`Q10200800202070005ool00`00ooooo`02ool001Goo`03003ooooo00;oogP000h082L0
00D08088@@<8H@<@PP034:8H`aS3008Hh`038@@Q92U5008YI@8aQP04<JHiacW7>NL2@PP2@RP4BTT5
BVT3BTT2@RP2@PP01SWW>LLiac6V<HHYI@8YA@078B@Q11SS6><H`a2R48800`QQ00<8@@0P02000P0P
1`001Ooo00<00?ooool00_oo000Eool20003oomh000>020Y00050204244326401A224:8@XQ2R6<<0
0QSS0R4400<Q92U5:DD00RUU00<aQS6V<JH00SW70SWW2T880cWW0SW70S6V00<aQRUU:DD00R4T00@Q
11SS6<<H``8@XP054888H@QQ2648@@0402070004ool20004ool001Goo`03003ooooo00;oogP000h0
82T000D080@8@@<8H@05488@XQ2R4:8H``026><28@@00b4T:DDYA@02:FD00c66<JHaYP02>LL2>NL:
@PP3>NL2>LL2<JH00c66:FDYA@028B@012446><H`aS30Q2R00D@PPQQ2648H@Q100@080L000Goo`03
003ooooo00;oo`005Ooo00<00?ooool00_ooN0003P0P;0001@0P10Q10PQQ0a220Q2R0aS300<Hhb44
8B@00R4T00@YABUU:FDYI@8aQP<aYPTia`8aYP<aQP03:FDYAB4T008Q90058@@HhaS36<<@XP024882
2642244402070005ool00`00ooooo`02ool001Goo`03003ooooo00;oogP000h0830000D080@8@@88
H@<@PP8@XP<H``8Hh`048@@Q924T8B@3:DD3:FD8<HH2:FD3:DD28B@28@@01ASS6<<H`aS34:800Q22
0PQQ0PQ1100P1`001Ooo00<00?ooool00_oo000Eool00`00ooooo`02oomh000>020b000702032443
264448824:836<<26><38@@48B@7:DD48B@28@@26><26<<34:8011222648H@QQ0PQ1100P1`001Ooo
00<00?ooool00_oo000Eool00`00ooooo`02oomh000>020f000602042444264248834:846<<46><:
8@@36><36<<34:8248832642244402070005ool00`00ooooo`02ool001Goo`8000?oogP000h083H0
00H080@8@@@8H@8@PP<@XP@H``@Hh`XQ10<Hh`<H``<@XP8@PP<8H@88@@@080L000Coo`8000Coo`00
5Ooo00<00?ooool00_ooN@003@0P>P001P0P10Q110QQ11220a2R21S300<HhaS36<<011S3112R0a22
0PQQ0`Q11@0P1`001Ooo00<00?ooool00_oo000Eool00`00ooooo`02oomi000=020n000602052444
2645488<4:8648822644244402080005ool00`00ooooo`02ool001Goo`03003ooooo00;oogT000/0
84<000L080H8@@D8H@d@PPD8H@@8@@D080P000Goo`03003ooooo00;oo`005Ooo00<00?ooool00_oo
N@002`0PA`00200P1PQ13`QQ1@Q11@0P2P001Ooo00<00?ooool00_oo000Eool00`00ooooo`02oomi
000;021700080206244?26452445020:0005ool00`00ooooo`02ool001Goo`03003ooooo00;oogT0
00/084/000T081@8@@H080X000Goo`03003ooooo00;oo`005Ooo0P000oooN@002`0PD0002`0P2@Q1
2@0P2`001?oo0P001?oo000Eool00`00ooooo`02oomi000;021E000G020<0005ool00`00ooooo`02
ool001Goo`03003ooooo00;oogT000/085X000l080l000Goo`03003ooooo00;oo`005Ooo00<00?oo
ool00_ooN@002`0PFP003`0P3`001Ooo00<00?ooool00_oo0008ool20004ool20005ool00`00oooo
o`02oomi000;021h0005ool00`00ooooo`02ool000Ooo`04003ooooo0002ool01000ooooo`001?oo
00<00?ooool00_ooN@002`0PN0001Ooo00<00?ooool00_oo0007ool01000ooooo`000_oo00@00?oo
ool000Coo`8000?oogX000X087P000?oo`<000Coo`002?oo0P000ooo00@00?ooool000Coo`03003o
oooo00;oogX000X087P000Goo`03003ooooo00;oo`001ooo00@00?ooool000;oo`04003ooooo0004
ool00`00ooooo`02oomj000:021h0005ool00`00ooooo`02ool000Ooo`04003ooooo0002ool01000
ooooo`001?oo00<00?ooool00_ooNP002P0PN0001Ooo00<00?ooool00_oo0008ool20004ool20005
ool00`00ooooo`02oomj000:021h0005ool00`00ooooo`02ool001Goo`03003ooooo00;oogX000T0
87T000Goo`03003ooooo00;oo`005Ooo0P000oooNP002@0PN@001?oo0P001?oo000Eool00`00oooo
o`02oomj0009021i0005ool00`00ooooo`02ool001Goo`03003ooooo00;oogX000T087T000Goo`03
003ooooo00;oo`005Ooo00<00?ooool00_ooNP002@0PN@001Ooo00<00?ooool00_oo000Eool00`00
ooooo`02oomj0009021i0005ool00`00ooooo`02ool001Goo`03003ooooo00;oogX000T087T000Go
o`03003ooooo00;oo`005Ooo00<00?ooool00_ooNP002@0PN@001Ooo00<00?ooool00_oo000Eool2
0003oomj0009021i0004ool20004ool001Goo`03003ooooo00;oogX000T087T000Goo`03003ooooo
00;oo`005Ooo00<00?ooool00_ooNP002@0PN@001Ooo00<00?ooool00_oo000Eool00`00ooooo`02
oomj0009021i0005ool00`00ooooo`02ool001Goo`03003ooooo00;oogX000T087T000Goo`03003o
oooo00;oo`005Ooo00<00?ooool00_ooNP002@0PN@001Ooo00<00?ooool00_oo000Eool20003oomj
0009021i0004ool20004ool001Goo`03003ooooo00;oogX000T087T000Goo`03003ooooo00;oo`00
5Ooo00<00?ooool00_ooNP002@0PN@001Ooo00<00?ooool00_oo000Eool00`00ooooo`02oomj0009
021i0005ool00`00ooooo`02ool00003ool00000008000?oo`8000Coo`8000Goo`03003ooooo00;o
ogX000T087T000Goo`03003ooooo00;oo`000ooo00D00?ooooooo`0000;oo`04003ooooo0002ool0
0`00ooooo`02ool00`00ooooo`02oomj0009021i0005ool00`00ooooo`02ool000?oo`05003ooooo
ool00002ool01000ooooo`000_oo00<00?ooool00_oo0P00oooo0ooo0`001?oo0003ool01@00oooo
oooo00000_oo00@00?ooool000;oo`03003ooooo00;oo`03003ooooo00;oo`03003ooooo03coo`03
003ooooo03coo`03003ooooo03coo`03003ooooo03coo`03003ooooo00;oo`03003ooooo00;oo`00
0ooo00D00?ooooooo`0000;oo`04003ooooo0002ool00`00ooooo`02ool00`00ooooo`02ool00`00
ooooo`09ool00`00ooooo`0:ool00`00ooooo`0:ool00`00ooooo`09ool00`00ooooo`0:ool00`00
ooooo`09ool00`00ooooo`0:ool00`00ooooo`09ool00`00ooooo`0:ool00`00ooooo`0:ool00`00
ooooo`09ool00`00ooooo`0:ool00`00ooooo`09ool00`00ooooo`0:ool00`00ooooo`0:ool00`00
ooooo`09ool00`00ooooo`0:ool00`00ooooo`09ool00`00ooooo`0:ool00`00ooooo`0:ool00`00
ooooo`02ool00`00ooooo`02ool00004ool000000003ool01000ooooo`000_oo00@00?ooool000Co
ool000P000Coo`000ooo00<00?ooool00_oo0P001?oo0P00oooo4Ooo003ooolQool00?ooob7oo`00
oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-20.9043, -24.3878, \
0.794624, 0.794624}}],

Cell[BoxData[
    \({6.039999999999992`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(f[x_] := \((Which[x > 0, Sin[20  Pi\ x^\((1 + 0.4)\)], True, 0] + 
            Which[x \[LessEqual] 0, Sin[20  Pi\ x], True, 0])\) 
        Which[Abs[x] < 10, Exp[\(-1\)/\((1 - Abs[0.1  x]^2)\)], True, 
          0]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(NF = Nf[f, 0.001];\)\)], "Input",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["\<\
ListPlay[90000 NF, SampleRate->50000,
        PlayRange->{-2^15,2^15}]\
\>", "Input",
  CellTags->"S5.51.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.588604 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sampled sound
1 string
50000 20001 8
{ currentfile 1 index readhexstring pop }
 false 1 sampledsound
8080808080808080808080808080808080808080808080808080808080808080808080808080
8080808080808080808080808080808080808080808080808080808080808080808080808080
8080808080808080808080808080808080808080808080808080808080808080808080808080
808080808080808080808080808080808080808080808080808080808080808080808080807F
7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F
7F7F7F7F7F7F7F7F7F7F80808080808080808080808080808080808080808080808080808080
80808080808080808080808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F
7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F80808080
8080808080808080808080808080808080808080808080808080808080808080808080808080
8080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F
7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F808080808080808080808080808080808080
8080808080808080808080808080808080808080808080808080808080808080807F7F7F7F7F
7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F
7F7F7F7F7F7F8080808080808080808080808080808080808080808080808080808080808080
808080808080808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F
7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F8080808080808080
8080808080808080808080808080808080808080808080808080808080808080808080808080
80808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F
7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F80808080808080808080808080808080808080808080
808080808080808080808080808080808080808080808080808080807F7F7F7F7F7F7F7F7F7F
7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F
7F7F808080808080808080808080808080808080808080808080808080808080808080808080
80808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F
7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F808080808080808080808080
8080808080818181818181818181818181818181818181818080808080808080808080808080
7F7F7F7F7F7F7F7F7F7F7F7F7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E
7E7E7E7F7F7F7F7F7F7F7F7F8080808080808080808181818181818181818181818181828282
828282828281818181818181818181818180808080808080807F7F7F7F7F7F7E7E7E7E7E7E7E
7E7E7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7E7E7E7E7E7E7E7E7F7F7F7F7F7F80
8080808081818181818182828282828282828283838383838383838383838282828282828282
81818181818180808080807F7F7F7F7E7E7E7E7E7D7D7D7D7D7D7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C7C7D7D7D7D7D7E7E7E7E7E7F7F7F80808080818181818282828282838383
838384848484848484848484848484848484838383838383828282828181818080807F7F7F7F
7E7E7E7D7D7D7D7C7C7C7C7B7B7B7B7B7B7A7A7A7A7A7A7A7A7A7A7A7B7B7B7B7B7B7C7C7C7D
7D7D7D7E7E7E7F7F808080818181828282838383848484848585858585858686868686868686
85858585858584848484838383828282818180807F7F7F7E7E7D7D7D7C7C7C7B7B7A7A7A7A79
79797979797978787878787979797979797A7A7A7A7B7B7C7C7C7D7D7E7E7F7F808080818182
8283838484848585868686868787878787878888888887878787878786868686858584848483
8382828181807F7F7E7E7D7D7C7C7B7B7A7A7979797878787777777777777676767677777777
777778787879797A7A7A7B7B7C7D7D7E7E7F8080818182828384848585868687878888888989
898989898A8A8A8A898989898989888887878786868585848383828181807F7F7E7D7D7C7C7B
7A7A79797878777776767675757575747474747474757575757676767777787879797A7B7B7C
7D7D7E7F7F8081828283848585868787888889898A8A8B8B8B8B8C8C8C8C8C8C8C8C8B8B8B8A
8A8A8989888887868685848383828180807F7E7D7C7B7B7A7978787776767575747473737372
7272727272727272737373737474757576777778797A7A7B7C7D7E7F7F808182838485868687
8889898A8B8B8C8C8D8D8D8E8E8E8E8E8E8E8E8E8E8D8D8D8C8C8B8A8A898888878685848382
81807F7F7E7D7C7B7A7978777676757473737272717170707070707070707070707171717272
7374747576777879797A7B7C7D7E80818283848586878889898A8B8C8D8D8E8E8F8F90909091
91919191919090908F8F8E8E8D8C8C8B8A8988878685848382817F7E7D7C7B7A797877767574
73727171706F6F6E6E6E6D6D6D6D6D6D6D6D6E6E6F6F70707172737374757677787A7B7C7D7E
8081828384858788898A8B8C8D8E8F8F90919192929393939393939393939392929190908F8E
8D8C8B8A89888786858382817F7E7D7C7A7978777674737271706F6F6E6D6C6C6B6B6B6B6A6A
6A6A6B6B6B6C6C6D6D6E6F7071727374757678797A7B7D7E80818284858688898A8B8D8E8F90
9192929394949595969696969696969595959493939291908F8E8D8C8B898887858482817F7E
7D7B7A787776747372716F6E6D6C6C6B6A696968686868686868686869696A6A6B6C6D6E6F70
717274757778797B7C7E7F8183848687898A8B8D8E8F91929394959596979798989999999999
9898989797969594939291908F8D8C8A8987868483817F7E7C7B797776747371706F6D6C6B6A
696868676666656565656565656666676768696A6B6C6D6E707172747577797A7C7E80818385
86888A8B8D8E909192949596979899999A9B9B9B9B9C9C9B9B9B9A9A9998979695949392908F
8D8C8A88878583817F7E7C7A7877757372706E6D6C6A69686766656464636362626262626263
636465666667696A6B6C6E6F71737476787A7C7E8081838587898B8C8E90919394969798999A
9B9C9D9D9E9E9E9E9E9E9E9D9D9C9C9B9A999896959392908F8D8B89878583817F7E7C7A7876
7472706E6D6B6A68676664636262616060605F5F5F5F60606161626364656668696B6C6E7072
737577797B7D80828486888A8C8E8F9193959698999A9C9D9E9F9FA0A0A1A1A1A1A1A1A0A09F
9E9D9C9B9A9897959492908E8C8A888684827F7D7B79777573716F6D6B69686665636261605F
5E5E5D5D5D5C5C5D5D5D5E5F60616263646667696B6C6E70727477797B7D80828486888B8D8F
91939596989A9B9D9E9FA0A1A2A3A3A4A4A4A4A4A3A3A2A2A1A09E9D9C9A99979593918F8D8B
898684827F7D7B79767472706D6B696866646361605F5D5C5C5B5A5A5A5A5A5A5A5B5B5C5D5E
5F6162646567696B6D6F717476787B7D80828487898B8E90929496989A9C9E9FA0A2A3A4A5A5
A6A6A7A7A7A6A6A6A5A4A3A2A19F9E9C9B99979593908E8C89878482807D7A787673716E6C6A
68666462605F5D5C5B5A59585857575757575858595A5B5C5D5E6062636567696C6E70737578
7A7D808285878A8C8F919496989A9C9EA0A1A3A4A5A6A7A8A9A9A9AAA9A9A9A8A8A7A6A5A3A2
A09E9D9B989694928F8D8A8785827F7D7A777572706D6B68666462605E5D5B5A585756565555
545454545555565758595B5C5E60626466686A6D6F7275777A7D808285888A8D909295979A9C
9EA0A2A3A5A7A8A9AAABABACACACACACACABAAA9A8A7A6A4A2A09E9C9A989593908E8B888582
7F7D7A7774716F6C6A676562605E5C5A595756555453525251515152525354545657585A5C5E
60626467696C6E7174777A7D7F8285888B8E919496999B9EA0A2A4A6A7A9AAABADADAEAFAFAF
AFAFAEAEADACABA9A8A6A4A2A09E9C999794918E8B8986837F7C797674716E6B686663615E5C
5A58565554525150504F4F4F4F4F4F505152535556585A5C5E606365686B6D707376797C8083
86898C8F9295979A9D9FA2A4A6A8AAABADAEAFB0B1B1B2B2B2B1B1B0AFAEADACAAA8A6A4A2A0
9D9B9895928F8C8986837F7C797673706D6A6764615F5D5A5856545351504F4E4D4C4C4C4C4C
4D4E4E5051525456585A5C5E616466696C6F7376797C808386898C909396999C9EA1A3A6A8AA
ACAEAFB0B2B3B3B4B4B4B4B4B3B3B2B1AFAEACAAA8A6A4A19F9C999693908D898683807C7975
726F6C696663605D5B58565452504F4D4C4B4A4A4A494A4A4A4B4C4D4E50525456585A5D5F62
65686B6F7275797C7F83868A8D9094979A9DA0A3A5A8AAACAEB0B1B3B4B5B6B6B7B7B7B6B6B5
B4B3B2B0AEACAAA8A6A3A09D9A9794918D8A87837F7C7875726E6B6864615E5C59565452504E
4C4B4A4948474747474748494A4B4C4E4F515456595B5E6164676A6E7175787C8083878A8E91
95989B9EA1A4A7A9ACAEB0B2B4B5B6B7B8B9B9B9B9B9B8B8B7B5B4B2B1AFACAAA7A5A29F9C98
95928E8A87837F7C7875716D6A6763605D5A575552504E4C4A49474645454444444545464748
4A4B4D4F5254575A5D6063666A6D7174787C8083878B8E9296999CA0A3A6A9ABAEB0B2B4B6B8
B9BABBBBBCBCBCBBBBBAB9B8B6B5B3B1AEACA9A6A3A09D9996928F8B8783807C7874706D6965
625F5B585653504E4C4A484645444342424242424344454648494B4D505255585B5E6265696C
7074787C8083878B8F93969A9EA1A4A7AAADB0B2B4B6B8BABBBCBDBEBEBEBEBEBDBCBBBAB9B7
B5B3B0AEABA8A5A19E9A97938F8B87837F7C7874706C6864615D5A5754514E4C4A4846444342
4140403F4040414142444547494C4E5153565A5D6064686C6F73777B8084888C9094979B9FA2
A6A9ACAFB2B4B6B8BABCBDBFBFC0C1C1C1C0C0BFBEBCBBB9B7B4B2AFACA9A6A39F9B9894908C
88847F7B77736F6B6763605C5955524F4D4A48454442403F3E3E3D3D3D3E3E3F40424345474A
4C4F5255585C5F63676B6F73777B7F84888C9094989CA0A3A7AAAEB1B3B6B8BBBCBEC0C1C2C2
C3C3C3C3C2C1C0BEBDBBB9B6B4B1AEABA7A4A09C9995908C88847F7B77736F6A66625F5B5754
514E4B48464341403E3D3C3B3B3B3B3B3C3D3E3F414345484A4D5054575A5E62666A6E73777B
8084888C9195999DA1A5A8ACAFB2B5B8BABDBFC0C2C3C4C5C5C5C5C5C4C3C2C1BFBDBBB8B5B3
B0ACA9A5A19D9995918D88847F7B77726E6A66615E5A56524F4C494644413F3E3C3B3A393939
39393A3B3C3D3F414346494C4F5256595D6165696E72777B8084888D91969A9EA2A6AAADB1B4
B7BABCBEC1C2C4C5C6C7C7C8C7C7C6C5C4C3C1BFBDBAB7B4B1AEAAA6A29E9A96928D8984807B
76726D6965615C5855514E4A474442403D3C3A3938373736363738393A3B3D3F4244474A4D51
54585C6064696D72767B8084898D92969B9FA3A7ABAFB2B5B9BBBEC0C3C4C6C7C8C9CACACAC9
C8C7C6C5C3C1BEBCB9B6B3AFABA7A39F9B97928D89847F7B76716D6864605B5753504C494643
403E3C3A3837363534343435353638393B3D404245484C4F53575B5F64686D71767B8084898E
92979BA0A4A8ACB0B4B7BABDC0C2C4C6C8C9CACBCCCCCCCBCBCAC8C7C5C3C0BDBBB7B4B0ADA9
A4A09C97938E89847F7B76716C68635F5A56524E4B4744413E3C3A3836353433323232333334
3637393C3E4144474A4E52565A5E63676C71767B8084898E93989CA1A5A9ADB1B5B8BCBFC2C4
C6C8CACBCCCDCECECECDCDCCCAC9C7C4C2BFBCB9B5B2AEAAA5A19D98938E8984807B76716C67
625E5955514D4946423F3D3A3836343332313030303131323436383A3C3F4245494D5155595E
62676C71757A80858A8E93989DA2A6AAAFB3B6BABDC0C3C6C8CACCCDCECFD0D0D0CFCFCDCCCA
C8C6C4C1BEBAB7B3AFABA6A29D98948F8A857F7A75706B66625D5854504C4844413E3B383634
3231302F2E2E2E2F2F31323436383B3D4144484B4F54585D61666B70757A80858A8F94999EA2
A7ABB0B4B8BBBFC2C5C8CACCCECFD0D1D2D2D2D1D0CFCECCCAC8C5C2BFBCB8B4B0ACA7A39E99
948F8A857F7A75706B66615C58534F4B47433F3C39373432302F2E2D2C2C2C2D2E2F30323436
393C3F43464A4E53575C61666B70757A7F858A8F94999EA3A8ADB1B5B9BDC0C4C7C9CCCED0D1
D2D3D4D4D4D3D2D1D0CECCC9C7C4C1BDB9B5B1ADA8A49F9A958F8A857F7A75706A65605B5752
4E4945423E3B383533302F2D2C2B2A2A2A2B2C2D2E303235373A3E4145494D52565B60656A6F
757A80858A90959A9FA4A9AEB2B6BABEC2C5C8CBCDCFD1D3D4D5D5D6D5D5D4D3D2D0CECBC8C5
C2BEBBB7B2AEA9A49F9A95908A857F7A756F6A65605B56514C4844403D393633312F2D2B2A29
292829292A2B2D2E313336393C4044484C51555A5F646A6F757A80858A90959BA0A5AAAEB3B7
BCBFC3C7CACCCFD1D3D5D6D7D7D7D7D7D6D5D3D1CFCDCAC7C3C0BCB8B3AFAAA5A09B95908B85
807A746F69645F5A55504B47433F3B3835322F2D2B2A28272727272728292B2D2F3234373B3F
43474B50555A5F64696F747A7F858B90969BA0A6ABAFB4B9BDC1C4C8CBCED1D3D5D6D8D8D9D9
D9D9D8D6D5D3D1CECBC8C5C1BDB9B4B0ABA6A19B96908B857F7A746F69645E59544F4A46423E
3A3633302E2B29282726252525262628292B2D3033363A3D41464A4F54595E63696E747A8085
8B91969CA1A6ABB0B5BABEC2C6C9CDCFD2D4D6D8D9DADBDBDBDAD9D8D7D5D2D0CDCAC6C2BEBA
B5B1ACA7A19C96918B857F7A746E69635E58534E4945403C3935322F2C2A2826252423232324
2526282A2C2F3135383C4045494E53585D63686E747A7F858B91979CA2A7ACB1B6BBBFC3C7CB
CED1D4D6D8DADBDCDCDDDCDCDBDAD8D6D4D1CECBC7C3BFBBB6B2ACA7A29C97918B85807A746E
68635D58524D48443F3B3734302D2B282625232222222222232426282A2D3033373B3F44484D
52575D62686E747A80858B91979DA2A8ADB2B7BCC0C4C8CCCFD2D5D7D9DBDCDDDEDEDEDDDDDB
DAD8D5D3D0CCC9C5C0BCB7B2ADA8A29D97918B857F7A746E68625C57524C48433E3A36322F2C
2927252322212020202122232527292C2F32363A3E42474C51575C62686E737980868C91979D
A3A8AEB3B8BDC1C6CACDD1D4D6D9DBDDDEDFE0E0E0DFDEDDDBD9D7D4D1CDCAC6C2BDB8B3AEA9
A39D98928C867F79736D67625C56514C47423D3935312E2B28252322201F1F1E1F1F20212325
282A2D3135393D42464B51565C61676D73797F868C92989EA3A9AEB4B9BEC2C7CBCED2D5D8DA
DCDEE0E0E1E1E1E1E0DEDDDAD8D5D2CFCBC7C3BEB9B4AFA9A49E98928C867F79736D67615B56
504B46413C3834302C29262422201F1E1D1D1D1E1F20222426292C3033383C41454B50555B61
676D737980868C92989EA4AAAFB5BABFC3C8CCD0D3D6D9DCDEE0E1E2E3E3E3E2E1E0DEDCD9D7
D3D0CCC8C4BFBAB5AFAAA49E98928C867F79736D67615B554F4A45403B37332F2B282523201F
1D1C1C1C1C1C1D1F202225282B2F32363B40454A4F555B61676D737980868C92989FA4AAB0B5
BBC0C4C9CDD1D4D8DBDDDFE1E2E3E4E4E4E3E2E1DFDDDBD8D5D1CDC9C5C0BBB6B0AAA59F9992
8C868079736D66605A544F49443F3A36322E2A2724211F1D1C1B1A1A1A1B1C1D1F2124272A2D
31353A3F44494F545A60666C737980868C93999FA5ABB1B6BBC0C5CACED2D6D9DCDEE1E2E4E5
E5E6E5E5E4E2E1DEDCD9D6D2CECAC5C1BCB6B1ABA59F99938C867F79736C66605A544E49433E
3935302C292623201E1C1B1A1919191A1B1C1E202225292C3034393E43484E545A60666C7379
80868C93999FA5ABB1B7BCC1C6CBCFD3D7DADDE0E2E4E5E6E7E7E7E6E5E4E2E0DDDAD7D3CFCB
C6C2BCB7B1ACA6A099938C867F79726C665F59534D48423D38342F2B2824211F1D1B19181817
1818191B1C1F2124282B2F34383D42484D53595F666C72797F868D9399A0A6ACB2B8BDC2C7CC
D0D4D8DBDEE1E3E5E6E7E8E8E8E7E6E5E3E1DEDBD8D4D0CCC7C2BDB8B2ACA6A09A938D867F79
726C655F59534D47423C37332E2A2723201E1B1A18171616161718191B1D2023262A2E33373C
41474D53595F656C727980868D939AA0A6ADB2B8BEC3C8CDD1D5D9DCDFE2E4E6E8E9E9E9E9E9
E8E6E4E2DFDCD9D5D1CDC8C3BEB8B3ADA7A09A938D867F79726C655F58524C46413C37322D29
26221F1C1A1817161515151617181A1C1F2225292D32363B41464C52585E656B727980868D94
9AA1A7ADB3B9BEC4C9CED2D6DADDE0E3E5E7E9EAEAEBEBEAE9E7E6E3E1DEDAD6D2CEC9C4BFB9
B3ADA7A19A948D868079726B655E58524C46403B36312D2825211E1B19171615141414151617
191B1E2124282C31363B40464B52585E656B727980868D949AA1A7AEB4B9BFC4CACED3D7DBDE
E1E4E7E8EAEBECECECEBEAE9E7E4E2DFDBD7D3CFCAC5BFBAB4AEA7A19B948D867F79726B645E
57514B45403A35302C2724201D1A18161513131313131416181A1D2023272B30353A3F454B51
575E646B727980868D949BA1A8AEB4BAC0C5CACFD4D8DCDFE3E5E8EAEBECEDEDEDECEBEAE8E5
E3E0DCD8D4CFCBC5C0BAB4AEA8A19B948D867F79726B645E57514B453F39342F2B27231F1C19
1715131212111212131517191C1F22262B2F34393F444A51575D646B727980868D949BA2A8AF
B5BBC0C6CBD0D5D9DDE0E4E6E9EBECEDEEEEEEEDECEBE9E6E4E1DDD9D5D0CBC6C1BBB5AFA8A2
9B948D867F79726B645D57504A443E39332F2A26221E1B181614121111101111121416181B1E
22252A2E33393E444A50565D646B727980868D949BA2A9AFB5BBC1C7CCD1D5DADEE1E5E7EAEC
EDEEEFEFEFEEEDECEAE7E5E1DEDAD6D1CCC7C1BBB5AFA9A29B948E878078716B645D56504A43
3E38332E2925211D1A1715131110100F0F10111315171A1D2125292E33383D434950565D646A
717880878E959BA2A9AFB6BCC2C7CDD2D6DBDFE2E5E8EBEDEEEFF0F0F0EFEEEDEBE8E6E2DFDB
D6D2CDC7C2BCB6B0A9A29C958E877F78716A635D564F49433D37322D2824201C19161412100F
0E0E0E0F10121416191C2024282D32373D43494F565C636A717880878E959CA3A9B0B6BCC2C8
CDD2D7DBDFE3E6E9ECEEEFF0F1F1F1F0EFEEECE9E6E3E0DCD7D2CDC8C2BDB6B0A9A39C958E87
7F78716A635C564F49423C37312C28231F1B181513110F0E0E0D0E0E0F111315181B1F23272C
31373C42484F555C636A717880878E959CA3AAB0B7BDC3C9CED3D8DCE0E4E7EAEDEFF0F1F2F2
F2F1F0EFEDEAE7E4E0DCD8D3CEC9C3BDB7B0AAA39C958E877F78716A635C554F48423C36312C
27221E1B171412100E0D0D0C0D0D0E101214171B1E22272B31363C42484E555C636A71788087
8E959CA3AAB1B7BDC3C9CFD4D9DDE1E5E8EBEDEFF1F2F3F3F3F2F1F0EEEBE8E5E1DDD9D4CFC9
C4BEB7B1AAA39C958E877F78716A635C554E48413B36302B26221E1A1714110F0E0C0C0B0C0C
0D0F1114161A1D22262B30353B41484E555C636A717880878E959CA3AAB1B8BEC4CACFD4D9DE
E2E6E9ECEEF0F2F3F4F4F4F3F2F0EEECE9E6E2DED9D5CFCAC4BEB8B1AAA49D958E877F78716A
625B554E47413B35302A25211D191613100E0D0B0B0B0B0B0D0E101316191D21252A2F353B41
474E545B626A717880878E959DA4ABB1B8BEC4CAD0D5DADEE3E6EAEDEFF1F3F4F5F5F5F4F3F1
EFEDEAE6E3DFDAD5D0CAC5BEB8B2ABA49D968E877F787169625B544D47403A342F2A25201C18
1512100D0C0B0A0A0A0B0C0D0F1215181C20252A2F343A40474D545B6269717880878E969DA4
ABB2B8BFC5CBD0D6DADFE3E7EAEDF0F2F4F5F5F6F5F5F4F2F0EDEAE7E3DFDBD6D0CBC5BFB9B2
ABA49D968E877F787169625B544D46403A342E2924201B1814110F0D0B0A0909090A0B0D0F11
14181B1F24292E343A40464D545B6269717880878E969DA4ABB2B9BFC5CBD1D6DBE0E4E8EBEE
F1F3F4F6F6F6F6F6F4F3F1EEEBE8E4E0DBD6D1CBC6BFB9B2ABA49D968E8780787169625B544D
464039332E29241F1B1714110E0C0A09080808090A0C0E1013171B1F23282E33393F464D545B
6269717880878E969DA4ACB2B9C0C6CCD1D7DCE0E5E8ECEFF1F3F5F6F7F7F7F6F5F4F1EFECE8
E5E0DCD7D2CCC6C0B9B3ACA59D968F877F787069625A534C463F39332D28231E1A1613100D0B
0A0808070808090B0D1013161A1E23282D33393F464C535A6269707880878F969DA5ACB3B9C0
C6CCD2D7DCE1E5E9ECEFF2F4F6F7F8F8F8F7F6F4F2F0EDE9E5E1DCD7D2CCC6C0BAB3ACA59D96
8F877F787069615A534C453F39332D27221E1A16120F0D0B090807070708090A0D0F1216191E
22272D32383F454C535A616970787F878F969EA5ACB3BAC0C7CDD2D8DDE1E6EAEDF0F3F5F6F8
F8F9F8F8F7F5F3F0EDEAE6E2DDD8D3CDC7C0BAB3ACA59E968F877F787069615A534C453E3832
2C27221D1915120F0C0A080706060607080A0C0E1215191D22272C32383E454C535A61697078
80878F969EA5ACB3BAC1C7CDD3D8DDE2E6EAEEF1F3F5F7F8F9F9F9F8F7F6F3F1EEEAE6E2DDD8
D3CDC7C1BAB3ACA59E968F877F787069615A534C453E38322C27211D1815110E0B0908060605
060607090B0E1114181D21262C32383E454B525A6169707880878F969EA5ADB4BAC1C7CED3D9
DEE3E7EBEEF1F4F6F8F9FAFAFAF9F8F6F4F1EEEBE7E3DED9D3CEC8C1BBB4ADA59E968F877F78
7069615A524B443E37312C26211C1814100D0B0907060505050607090B0D1014181C21262B31
373E444B525A6168707880878F979EA5ADB4BBC1C8CED4D9DEE3E7EBEFF2F5F7F8FAFAFBFAFA
F8F7F5F2EFEBE7E3DED9D4CEC8C1BBB4ADA69E978F877F7870686159524B443D37312B26201C
1713100D0A0806050404040506080A0D1013171C20262B31373D444B52596168707880878F97
9EA6ADB4BBC2C8CED4DADFE3E8ECEFF2F5F7F9FAFBFBFBFAF9F7F5F2EFECE8E4DFDAD4CEC8C2
BBB4ADA69E978F877F7870686159524B443D37312B25201B17130F0C0A070605040404050607
0A0C0F13171B20252B30373D444B52596168707880878F979EA6ADB4BBC2C8CFD4DADFE4E8EC
F0F3F6F8F9FBFBFCFBFBFAF8F6F3F0ECE8E4DFDAD5CFC9C2BBB4ADA69E978F877F7870686159
524B443D36302A25201B16120F0C09070504030303040507090C0F12161B20252A30363D444A
5259616870787F878F979EA6ADB5BCC2C9CFD5DAE0E4E9EDF0F3F6F8FAFBFCFCFCFBFAF8F6F3
F0EDE9E4E0DAD5CFC9C2BCB5ADA69F978F877F7870686059524A433D36302A241F1A16120E0B
09060504030303040506090B0E12161A1F242A30363D434A5159606870787F878F979FA6AEB5
BCC3C9CFD5DBE0E5E9EDF1F4F7F9FAFCFCFDFCFCFAF9F7F4F1EDE9E5E0DBD5CFC9C3BCB5AEA6
9F978F877F7870686059514A433C36302A241F1A16120E0B08060403020202030406080B0E12
161A1F242A30363C434A51596068707880878F979FA6AEB5BCC3C9D0D5DBE0E5EAEEF1F4F7F9
FBFCFDFDFDFCFBF9F7F4F1EEEAE5E0DBD6D0C9C3BCB5AEA69F978F87807870686059514A433C
362F29241F1A15110E0A08060403020202030406080A0E11151A1E24292F353C434A51596068
707880878F979FA6AEB5BCC3CAD0D6DBE1E5EAEEF2F5F7FAFBFDFDFEFDFDFBFAF7F5F2EEEAE6
E1DBD6D0CAC3BCB5AEA69F978F87807870686058514A433C352F29231E1915110D0A07050302
010101020305070A0D1115191E23292F353C434A51586068707880878F979FA7AEB5BCC3CAD0
D6DCE1E6EAEEF2F5F8FAFCFDFEFEFEFDFCFAF8F5F2EEEAE6E1DCD6D0CAC3BCB5AEA79F978F87
7F7870686058514A433C352F29231E1915110D0A07050302010101020305070A0D1015191E23
292F353C424A5158606870787F878F979FA7AEB5BDC3CAD0D6DCE1E6EBEFF2F5F8FAFCFDFEFE
FEFDFCFAF8F5F2EFEBE6E1DCD6D0CAC4BDB6AEA79F978F877F78706860585149423B352F2923
1E1914100D090704030101000101030407090D1014191E23292E353B42495158606870788087
8F979FA7AEB6BDC4CAD1D7DCE1E6EBEFF3F6F8FBFCFEFEFFFEFEFCFBF9F6F3EFEBE6E2DCD7D1
CAC4BDB6AEA79F978F878078706860585149423B352E28231D1814100C090604020100000001
020406090C1014181D23282E353B424951586068707780888F979FA7AEB6BDC4CAD1D7DCE2E7
EBEFF3F6F9FBFDFEFFFFFFFEFDFBF9F6F3EFEBE7E2DCD7D1CAC4BDB6AEA79F978F8880777068
60585149423B342E28221D1814100C090604020100000001020406090C1014181D22282E343B
4249505860686F77808890979FA7AFB6BDC4CBD1D7DDE2E7EBEFF3F6F9FBFDFEFFFFFFFEFDFB
F9F6F3F0EBE7E2DDD7D1CBC4BDB6AFA79F9790887F776F6860585049423B342E28221D18130F
0C090604020100000001020406090C0F13181D22282E343B4249505860686F77808890979FA7
AFB6BDC4CBD1D7DDE2E7ECF0F3F7F9FCFDFFFFFFFFFFFDFCF9F7F3F0ECE7E2DDD7D1CBC4BDB6
AFA79F9890887F776F6760585049423B342E28221D18130F0B08060302000000000002030608
0B0F13181D22282E343B4249505860676F777F8890989FA7AFB6BDC4CBD1D7DDE2E7ECF0F4F7
FAFCFEFFFFFFFFFFFEFCFAF7F4F0ECE7E2DDD7D1CBC4BDB6AFA79F9890887F776F6760585049
423B342E28221D18130F0B080503010000000000010305080B0F13181D22282E343B42495058
60676F77808890989FA7AFB6BDC4CBD1D7DDE3E7ECF0F4F7FAFCFEFFFFFFFFFFFEFCFAF7F4F0
ECE8E3DDD8D1CBC4BDB6AFA79F9890887F776F6760585049423B342E27221C17130F0B080503
010000000000010305080B0F13171C22272D343B424950585F676F7780889098A0A7AFB6BEC4
CBD2D8DDE3E8ECF0F4F7FAFCFEFFFFFFFFFFFEFCFAF7F4F0ECE8E3DDD8D2CBC4BEB6AFA7A098
908880776F675F585049413A342D27221C17130F0B080503010000000000010305080B0F1317
1C22272D343A414950585F676F7780889098A0A7AFB6BEC5CBD2D8DDE3E8ECF0F4F7FAFCFEFF
FFFFFFFFFEFCFAF7F4F0ECE8E3DDD8D2CBC5BEB6AFA7A09890887F776F675F585049413A342D
27211C17130E0B080503010000000000010305080B0E13171C21272D343A414950585F676F77
80889098A0A7AFB6BEC5CBD2D8DEE3E8ECF1F4F7FAFCFEFFFFFFFFFFFEFCFAF7F4F1ECE8E3DE
D8D2CBC5BEB6AFA7A09890887F776F675F585049413A342D27211C17130E0B07050201000000
0000010205070B0E12171C21272D343A414950585F676F777F889098A0A7AFB6BEC5CBD2D8DE
E3E8EDF1F4F8FAFDFEFFFFFFFFFFFEFDFAF8F4F1EDE8E3DED8D2CBC5BEB6AFA7A09890887F77
6F675F585048413A342D27211C17120E0B070502010000000000010205070B0E12171C21272D
343A414850585F676F7780889098A0A7AFB7BEC5CBD2D8DEE3E8EDF1F4F8FAFDFEFFFFFFFFFF
FEFDFAF8F4F1EDE8E3DED8D2CBC5BEB7AFA7A09890887F776F675F585048413A342D27211C17
120E0B070502010000000000010205070B0E12171C21272D343A414850585F676F7780889098
A0A7AFB7BEC5CBD2D8DEE3E8EDF1F4F8FAFDFFFFFFFFFFFFFFFDFAF8F4F1EDE8E3DED8D2CCC5
BEB7AFA7A098908880776F675F585048413A332D27211C17120E0A0705020000000000000002
05070A0E12171C21272D333A414850585F676F7780889098A0A7AFB7BEC5CCD2D8DEE3E8EDF1
F5F8FAFDFFFFFFFFFFFFFFFDFAF8F5F1EDE8E3DED8D2CCC5BEB7AFA7A09890887F776F675F58
5048413A332D27211C17120E0A070402000000000000000204070A0E12171C21272D333A4148
50585F676F778080818283848687898B8C8E90929496989A9D9FA1A3A6A8ABADAFB2B4B7B9BC
BEC1C3C6C8CBCDD0D2D5D7D9DCDEE0E2E4E7E9EBECEEF0F2F3F5F6F8F9FAFBFCFDFEFFFFFFFF
FFFFFFFFFFFFFFFFFEFDFCFBFAF9F7F6F4F2F0EDEBE9E6E3E0DDDAD7D4D0CDC9C5C1BDB9B5B1
ADA8A49F9A96918C88837E79746F6B66615C57534E4945403C3834302C2824211D1A1714110E
0C0A08060402010000000000000000000102040507090C0E1114171B1E22262A2F33383D4247
4C51575C62686E73797F858B91979CA2A8AEB3B9BEC3C8CDD2D6DBDFE3E7EAEEF1F4F6F9FBFC
FEFFFFFFFFFFFFFFFFFEFCFAF8F6F3F0ECE9E5E1DDD8D3CEC9C4BEB8B2ACA6A099938C867F78
726B655E58514B453F3A342F2A25201B1713100D0A0705030100000000000000010305070A0D
1115191D22272C31373D434A50575E656C737A818890979EA5ACB2B9BFC5CBD1D7DCE1E6EAEE
F2F5F8FAFCFEFFFFFFFFFFFFFEFCFAF8F5F2EEEAE5E1DCD6D0CAC4BEB7B0A9A19A938B837C74
6C655D564F48413A342E28221D1814100C09060402000000000000010305080B0F13171C2127
2D333A41484F575E666E767E868E969EA6AEB5BCC3CAD1D7DDE2E7ECF0F4F7FAFCFEFFFFFFFF
FFFEFDFAF7F4F0ECE7E2DDD7D0CAC3BBB4ACA49C948B837B726A625A524A423B342D27211B16
110D0A0604020000000000010205080B0F14191E242A31383F474F5760687179828B939CA5AD
B5BDC4CCD3D9DFE5EAEFF3F7FAFCFEFFFFFFFFFFFDFBF8F4F0ECE7E1DBD5CEC6BFB7AEA69D94
8B827970675F564D453D362E28211B16110C0905030100000000010205080C10151B21272E35
3D454E565F68727B848D97A0A9B1BAC2CAD1D8DFE5EAEFF4F7FBFDFFFFFFFFFFFDFBF8F5F0EB
E6E0D9D2CBC3BBB2A9A0978D847A71675E554C433B332C241E18130E0A060301000000000103
060A0E13181E252C343C444D566069737D87909AA3ADB6BFC7CFD6DDE4EAEFF4F7FBFDFFFFFF
FFFEFCFAF6F2EDE7E1DBD3CBC3BAB1A89F958B81776D635950473E352E261F19130E0A060301
000000000205080C11161C232B333B444D56606A747F89939DA7B0BAC3CBD3DBE2E8EEF3F7FA
FDFFFFFFFFFEFCF9F5F0EBE5DED7CFC7BEB4ABA1978C82786D63594F463D342C241D17110C08
0402000000000204080C11161D242B343C464F59646E78838E98A2ACB6C0C9D1D9E0E7EDF2F7
FAFDFFFFFFFFFDFBF7F3EEE8E2DAD3CAC1B8AEA4998F84796E64594F453C332B231C15100B07
03010000000103060A0F151B232B333C464F5A646F7A85909BA5B0BAC3CCD5DDE4EAF0F5F9FC
FEFFFFFFFDFBF8F3EEE8E1DAD2C9BFB6ABA1968B80756A5F544A40372E251E17110C07040200
00000104070B10161D252D363F49535E69747F8B96A1ACB6C0CAD2DBE2E9EFF4F8FCFEFFFFFF
FDFAF7F2EDE6DFD7CEC5BBB1A69B9085796E63584D433930271F18120C080402000000020408
0C12181F273039434D58636F7A86919DA8B3BDC7D0D9E1E8EEF3F8FBFEFFFFFEFDFAF6F1EBE5
DDD5CCC2B8ADA2978B7F74685D52473D332A221A130E0905020000000204080D12192029323B
46505B67737E8A96A2ADB8C2CCD5DDE5ECF2F6FAFDFFFFFFFDFAF6F1ECE5DDD5CBC1B7ACA195
897D71655A4E443930271E17110B07040100000104070B11171F27303A444F5A66727E8A96A2
ADB8C3CDD6DFE6EDF3F7FBFDFFFFFEFCF8F4EFE8E1D8CFC5BBB0A4998D8074685C51463B3128
1F18110C07040100000204080C12192129333D48535F6B7783909CA8B3BEC9D2DBE3EBF1F6FA
FDFEFFFEFCF9F4EFE9E1D9CFC5BBAFA4988B7F73665A4E43392F251D160F0A06030100010306
0A10161E262F3944505B6874818D99A6B1BDC7D1DBE3EAF0F6FAFCFEFEFEFBF8F3EEE7DFD6CD
C2B7ACA093877A6E6155493E342A2119120C07040201010305090F151C252E38434F5B677380
8D9AA6B2BDC8D2DBE4EBF1F6FAFDFEFEFDFAF6F1EBE4DCD2C8BDB2A6998D8073665A4E42372D
241B140E09050201010205090E141C242E38434F5B6874818E9BA8B4BFCAD4DDE5EDF3F7FBFD
FEFEFCF9F4EFE8E0D7CDC3B7AB9F9285786B5E52463B30261E160F0A060301010205090E141C
252E3944505C697683909DAAB6C1CCD6DFE7EEF4F8FCFDFEFDFAF7F2ECE4DCD2C8BCB0A4978A
7D7063564A3E33292018110B070402010205090E141C242E3944505D6A7784919FABB7C3CED8
E1E9F0F5F9FCFDFDFCF9F5EFE8E1D7CDC2B7AA9E908376685B4F43372D231B130D0804020202
05080D131B232D38434F5C697684919FABB8C4CFD9E2E9F0F5F9FCFDFDFBF8F3EDE6DED4CABF
B2A6998B7E706356493D32281F17100A0603020204070B1118212A35404C596674818F9DAAB6
C2CDD8E1E9F0F5F9FCFDFDFBF7F3EDE5DDD3C8BDB0A396887B6D6053463A2F251C140E090503
020305090E151D26303B4754616E7C8A97A5B2BECAD4DEE6EEF4F8FBFDFDFBF8F3EDE6DED4C9
BDB1A497897B6D6052463A2F251C140D0805030204060A10171F28333E4B586573818F9CAAB7
C3CED8E2EAF0F6F9FCFCFCF9F5F0E9E1D8CDC2B5A89B8D7F716356493D31271E160F09060303
04060A10161F28333E4B586573818F9DABB8C4CFD9E3EBF1F6FAFCFCFBF8F4EEE7DED4CABEB1
A496887A6C5E5144382D231A120C0805030305080D141C252F3A4653616F7D8B99A7B4C1CCD7
E1E9F0F5F9FBFCFBF8F4EEE7DFD5CABEB1A49688796B5D5043372C2219120C07040304060A0F
161E27323E4A58657482909EACB9C5D1DBE4ECF2F7FAFBFBF9F6F1EAE2D9CEC3B6A99B8D7F70
6254473B2F251C140D0905040406090E151D26313C49566472818F9EABB9C5D0DBE4ECF2F7FA
FBFBF9F5F0E9E1D7CDC1B4A6988A7B6D5F5144382C2219120C08050405070B1118212B36424F
5D6B7A8897A5B2BFCBD6E0E8EFF5F9FBFBFAF6F2EBE3DAD0C4B7AA9C8D7F706254463A2E241B
130D08050405070B1118212B36424F5D6C7A8997A6B3C0CCD7E1E9F0F5F9FAFAF9F5F0E9E1D7
CDC1B4A698897A6C5D4F42362B2018110B07050506090E141C26303C495765748291A0AEBBC8
D3DDE6EEF3F7FAFAF9F6F1EBE3DACFC3B6A99A8C7D6E605244382C2219120C08050506090E14
1C26313D4A5766748392A1AFBCC9D4DEE7EEF4F8FAFAF8F5F0E9E1D7CCC0B3A59687786A5B4D
4034281F160F0A070505070B1118212B3743515F6D7C8B9AA9B6C3CFDAE3EBF2F6F9FAF9F6F2
EBE3DACFC3B6A89A8B7C6D5E5043362B2018110B070606070B1118212B3643505F6D7C8B9AA9
B7C4D0DAE4ECF2F6F9F9F8F5F0EAE2D8CDC1B3A59788796A5B4D3F33281E160F0A070606090D
131B242F3B485665748392A1AFBDC9D5DFE8EFF4F7F9F9F7F2EDE5DCD1C6B9AB9C8D7E6F6051
44372B2118110C080606080C121A232D394654627181909FADBBC8D4DEE7EEF3F7F9F8F6F2EC
E5DCD1C5B8AA9B8C7D6E5F5043362A2018110B080607090E141C25303C495766758594A3B1BF
CBD7E1E9F0F4F7F8F8F5F0E9E1D7CCBFB2A495857667584A3C30251C140E0A0707080C111821
2C3844526170808F9EADBBC7D3DEE6EEF3F6F8F8F5F1EBE3D9CEC2B4A6978878695A4C3E3227
1D150F0A0807090C1119212C384553617180909FADBBC8D4DEE7EEF3F6F8F7F4F0E9E1D7CCBF
B1A39484756556483B2F241B130D0A08080A0E141C25303D4A5867778696A5B3C1CDD9E2EAF0
F5F7F7F6F2ECE5DCD1C5B7A99A8B7B6C5C4E4033281E16100B0808090D121A232D3946556473
8392A1B0BECBD6E0E9EFF4F6F7F6F2EDE5DCD2C6B8AA9B8C7C6D5D4F4134291F16100B09080A
0D131A232E3A485665758494A3B2BFCCD7E1E9F0F4F6F7F5F1EBE3DACFC2B5A697887868594B
3D31261C140E0B09090B10161E2833404E5C6C7B8B9BAAB8C5D1DCE5ECF2F5F6F5F3EEE7DED4
C8BBAD9E8E7E6F5F5042352A2017110C09090B0E141C25303C4A5968778797A6B5C2CFDAE3EB
F1F4F6F5F3EEE7DFD5C9BCAE9F8F8070605143362A2018110C0A090B0F141C26313D4B5A6979
8898A7B6C3D0DBE4EBF1F4F6F5F2EDE6DDD2C6B9AB9C8C7C6C5D4E4033281E16100C0A0A0C11
171F293542505F6F7F8E9EADBBC8D4DEE7EEF2F5F5F3EFE9E1D8CCC0B2A3948474645546392D
221A130E0B0A0C0F151C26313D4B5A69798999A8B7C4D1DBE4ECF1F4F5F4F0EBE3DACFC2B5A6
9787776758493B2F241B140F0B0A0C0F141C25303D4A5969788898A8B6C4D0DBE4EBF0F3F4F3
F0EAE2D9CEC1B3A59585756556473A2E231A130E0B0B0C10161E2833404E5D6C7C8C9CABBAC7
D3DDE6EDF1F4F4F2EEE7DFD5C9BCAE9F8F7F6F5F5042352A2017110D0B0C0E131A232D394755
64748494A4B3C1CDD9E2EAEFF2F4F3EFEAE2D9CEC1B3A59585756556473A2D231A130F0C0C0E
1218202A36435261718191A1B0BECBD6E0E8EEF2F3F2F0EAE3DACFC3B5A69787776757483B2F
241B140F0D0C0E1218212B36445261718191A1B0BECBD7E0E8EEF1F3F2EFE9E2D9CDC1B3A494
8474645546392D221A130F0D0D0F141A232E3A475666768696A5B4C2CFD9E3EAEFF2F2F1EDE7
DED4C9BBAD9E8E7E6D5E4F4034281F17110E0D0E11171F2834414F5E6E7E8E9EADBCC9D5DFE7
EDF0F2F1EEE9E1D8CDC0B2A3948373635445382C221A130F0D0E11161D26313E4B5A6A7A8A9A
AAB9C6D2DCE5EBEFF1F1EEE9E2D9CEC2B4A5958575655647392D231A14100E0E11161D26313D
4B5A6A7A8A9AAAB9C6D2DCE5EBEFF1F0EEE9E1D8CDC0B2A3948373635445382C221A14100E0F
12171F2834404F5E6E7E8E9EADBCC9D4DEE6ECEFF1EFECE6DED5C9BCAE9E8E7E6E5E4F413428
1F18120F0F10141B232D39475565758595A5B4C2CED9E2E9EEF0F0EEE9E2D9CEC2B4A5958575
655547392D231B15110F101318202A3542505F6F8090A0AFBDCAD6DFE7ECEFF0EEEAE4DBD1C5
B7A999897968594A3C30251D1612101013181F2833404E5E6D7E8E9EADBCC9D4DEE6EBEEEFEE
EAE4DBD1C5B8A999897969594A3C30251D16121010131820293541505F6F7F8F9FAFBDCAD5DF
E6EBEEEFEDE9E2D9CFC3B5A69686766656473A2E241C15121011151B222C38455463748494A4
B3C1CDD8E1E8ECEEEEEBE6DFD6CABDAFA090806F5F5042352A201914111113181E27323F4C5B
6B7C8C9CABBAC7D3DDE4EAEDEEECE8E2DACFC3B5A69786766656483A2E241C16121113161C24
2E3A485766768797A7B6C3CFDAE2E8ECEDECE9E3DBD1C6B8AA9A8A7A695A4B3D31261E171312
13161B232D39465564748595A5B4C2CED8E1E7EBEDECE9E3DCD2C6B9AA9B8A7A6A5A4B3D3127
1E18141213161C242E3A475665768696A6B5C2CED9E1E7EBEDEBE8E2DAD0C4B6A89888776758
493B2F251D17141314181E26313D4B5A697A8A9AAAB8C5D1DBE3E8EBECEAE6DFD7CCBFB1A293
8272625244372C221B161413161B222B36435160708191A1B0BECBD6DEE5EAEBEBE8E3DBD1C6
B8AA9A8A7A6A5A4B3D31271F19151415191F27313E4B5A6A7A8B9BAAB9C6D1DBE3E8EBEBE9E4
DDD4C9BCAE9F8F7F6E5F4F41352A211A161415181D252F3B485766778797A7B6C3CFD9E1E6EA
EBE9E5DED5CBBEB0A1918171615143362B221B171515181D252F3A485666768696A6B5C2CED8
E0E6E9EAE8E4DED5CABEB0A1918070605143362B221C171516191E26303C495868788898A8B6
C4CFD9E1E6E9E9E7E3DCD3C8BBAD9D8D7D6D5D4E403429211B1716171B212933404D5C6C7C8D
9DACBAC7D2DBE2E7E9E9E6E0D9CFC3B6A79888776758493C30261F191716191D242E39465463
738494A4B2C0CCD6DEE4E8E9E7E3DCD4C9BCAE9F8F7F6F5F5042362B221C1817181B212A3440
4E5D6D7D8D9DADBBC7D2DBE2E6E8E7E4DED6CCC0B3A4948474645546392E251E1917181B2028
323D4B5969798999A9B7C4D0D9E0E5E7E7E4DFD8CEC2B5A69787776757493C30271F1A18181B
2027313C4A5868788898A7B6C3CED8DFE4E7E7E4DFD8CEC2B5A79787776757493C3027201B18
191B2128323D4B5969798999A8B7C4CFD8DFE4E6E6E3DED6CCC1B3A59585756555473A2F261F
1B19191D222A34404E5C6C7C8C9CABB9C6D1DAE0E4E6E5E1DCD3C9BDAFA0908070605144372D
241E1A191B1F252E38455362728292A2B0BECAD4DCE2E5E5E3DFD8CFC4B7A99A8A79695A4B3E
3329221D1A1A1D2229333F4C5A6A7A8A9AA9B7C4CFD8DFE3E5E4E1DBD3C9BDAFA09080706152
44382D251F1B1A1C20272F3A475564748494A3B2BFCBD5DCE1E4E4E2DDD5CCC0B3A495857565
56483B3027211D1B1C1F252E38445261708090A0AFBCC8D2DAE0E3E4E2DDD6CDC2B5A7978878
68584A3D3229221E1C1C1F252D3743515F6F7F8F9FADBBC7D1D9DFE2E3E1DDD6CDC2B5A79888
7868594B3E3329231E1C1D20262E384451607080909FAEBBC7D1D9DFE2E3E0DCD5CCC0B3A596
86766657493D3229221E1D1E2127303A465463738393A2B0BEC9D3DADFE2E2DFDAD2C9BDB0A1
9282726354463A3027221E1D1F232A333E4B5968788897A6B4C1CCD5DCE0E1E1DDD7CFC4B8AA
9C8C7C6C5D4F42362D25201E1E21262E3844515F6F7F8F9EADBAC6D0D8DDE0E1DFDAD3CABEB1
A39484746556483C3129231F1E20242B343E4B5968788897A6B4C1CCD4DBDFE0DFDCD5CDC2B6
A8998A7A6A5B4D40352C25211F202329313B475563738392A2B0BDC8D2D9DDE0DFDCD7CFC5B9
AC9D8E7E6E5F5144382F272220202328303945526170808F9FADBAC6D0D7DCDFDFDCD7D0C6BB
AD9F9080706153453A302823212023282F394451606F7F8E9EACB9C5CFD6DBDEDEDCD7CFC6BA
AD9F9080716153463A30292421212429303A455261707F8F9EADBAC5CFD6DBDEDEDBD6CEC4B9
AC9D8E7E6F605145393029242222252A323C485563738292A1AFBCC7D0D7DBDDDDD9D4CCC2B6
A89A8A7B6B5C4F42372E28242223272D353F4B5968778796A5B2BFC9D2D8DCDDDBD7D1C8BDB1
A394857666584A3E342C2723232529303944515F6E7D8D9CAAB7C3CDD4D9DCDCD9D4CDC3B8AB
9C8D7E6F6052453A312A252324272D353F4B5867768595A3B1BDC8D0D6DADCDAD6D0C7BDB0A3
94857566584A3F352D272424262B323B465361707F8F9EACB9C4CDD4D9DBDAD7D2CAC0B4A799
897A6B5C4F423830292624262A303943505E6C7B8B9AA8B5C1CAD2D7DADAD8D3CBC2B7AA9C8D
7D6E5F52453A322B2725262A2F38424E5B6A798897A6B3BFC9D0D6D9D9D7D3CCC3B8AB9D8E7F
706153473C332C2826262A3038424E5B69788796A5B2BEC8D0D5D8D9D7D2CBC2B7AB9D8E7F70
6153473C332C2826272B3038434F5C6A798897A5B2BEC8D0D5D8D8D6D1CAC1B6A99B8C7D6E60
52463B332C2827282C323A45515E6D7C8B99A7B4BFC9D0D5D7D7D5CFC8BEB3A698897A6B5D50
443A322C2828292E343D48546271808F9DABB7C2CBD1D5D7D6D3CDC5BBAFA193847567594C41
37302B29292B3038414D5A67768594A2AFBBC5CDD2D6D6D4D0C9C0B6A99B8D7E6F6154473D34
2E2A292A2E343C4753606E7D8C9AA8B4BFC8CFD4D6D5D2CCC5BBAFA2948576685A4D4239312C
2A2A2D3239424E5A68778594A2AFBBC4CCD1D4D5D3CEC7BEB3A7998B7C6E6052473D342F2B2A
2C30373F4A566472808F9DABB7C1C9CFD3D4D3CFC9C1B6AA9D8F807264564A4037312D2B2C2F
353D4853606E7D8C9AA7B3BEC7CED2D4D3D0CAC2B8ADA092837566594D4239322E2C2C2F353D
46525F6C7B8998A5B2BCC5CCD1D3D2CFCAC3B9AEA1938576685A4E433A332F2D2D30353D4651
5E6C7A8997A4B1BBC4CBD0D2D2CFCAC2B9ADA1938576685B4E443B342F2D2E31363D47525F6D
7B8997A5B1BCC4CBD0D2D1CEC9C1B7AC9F928375675A4E433A34302E2F32373F4954616F7D8B
99A6B2BCC5CBCFD1D0CDC7BFB5A99D8F817265584C423A33302E303339424C576472808E9CA9
B4BEC6CCCFD0CFCBC4BCB2A6998B7D6F615549403833302F31363C454F5C69768593A0ACB7C0
C8CDCFCFCDC8C1B8ADA19486786A5D51463D373230303339404955616E7C8A98A5B1BBC3C9CD
CFCECAC5BDB3A89B8D7F7264574C423A35313132363C454F5B687583919EABB5BFC6CBCECECC
C7C0B7ADA19486786A5D51473E38333132353A424B5662707D8B99A5B1BBC3C9CCCDCCC8C2BA
B0A5988B7D6F62564B423A35333234393F48535E6B798794A1ADB7C0C6CBCDCCC9C4BCB3A89C
8F8173665A4E453D37343334383E46505C687683919EAAB4BDC4C9CCCCC9C4BEB5AA9E918476
695C51473F39353434383D454F5A6674818E9BA8B2BCC3C8CBCBC9C5BEB5AB9F9385786B5E53
49403A363435383E454E596673808D9AA6B1BAC2C7CACAC8C4BEB5ABA09386786B5F5349413B
373536393E464F5A6673808D9AA6B1BAC1C6C9CAC8C3BDB4AA9F9285786B5E5349413B373637
3A3F47505B6774818E9BA7B1BAC1C6C9C9C6C2BBB3A99D908376695D5249413B3836383B4149
525D697683909DA8B2BBC1C6C8C8C5C0B9B0A69A8E8174675B5047403B3837393D434B55616D
7A8793A0ABB4BCC2C6C7C6C3BEB6ADA2968A7D7064584E463F3A38383B3F464F5965717E8B97
A3AEB7BEC3C6C7C5C1BBB3A99E9285786C60554B433E3A393A3D434A535E6A7683909CA7B1B9
C0C4C6C5C3BEB7AEA4988C7F73665B5148413D3A3A3C40474F5964707D8996A1ACB5BCC1C4C5
C4C0BAB2A89E9285796C61564C453F3C3A3B3F444B555F6B7784909CA7B0B8BFC2C4C4C1BCB5
ACA2968A7E71655A5048423D3B3B3E4249525C67737F8C98A3ADB5BCC1C3C3C1BDB7AFA59A8E
8275695E544B443F3D3C3E42484F59646F7C88949FAAB2BABFC2C3C1BEB8B0A79D9185796D61
574E46413E3D3E41474E57626D7985919DA7B0B8BDC1C2C1BEB8B1A89E93877B6F6359504843
3F3E3E41464E56606C77838F9BA5AFB6BCC0C1C0BDB8B2A99F94887C70655A514944403E3F42
474E56606B77838F9AA4ADB5BBBFC0C0BDB8B1A99F94887C71655B524A44413F4043474E5760
6B77838E9AA4ADB5BABEBFBFBCB7B0A89E93887C70655B524B4541404144484F58626C78848F
9AA4ADB4BABDBFBEBBB6AFA69D92867B6F645A524A45424142454A515A636E7A85919CA5AEB5
BABDBEBDB9B4ADA49A8F84796D6359514A45424243474C535C66717C88939DA7AFB5BABDBDBB
B7B2AAA1978C81766B60574F4945434345494F565F6974808B96A0A9B0B6BABCBCBAB5AFA79E
94897D72675E554E48454344474B525A636E78848F99A3ABB2B7BABBBAB7B2ABA39A8F84796E
645A524C47454446494E555E68727D88939DA6AEB4B8BABAB8B5AFA79F958A7F74696057504A
474545484C525A636D78838E98A1AAB0B5B9BAB9B6B1AAA2998F84796F655B544D494646474B
50575F69737E89939DA6ADB3B7B9B9B7B3ADA59D93887E73695F57504B4847474A4F555D6670
7A858F99A2AAB0B5B7B8B7B3AEA79F968C81776C635A534D4A48484A4E535B636D77828C969F
A7AEB3B6B7B6B4AFA9A1988E847A6F665D554F4B49484A4D5259616B757F89939DA5ACB1B5B6
B6B4AFAAA29A90867C72685F57514D4A494A4D52596069737D88919BA3AAB0B3B5B5B3AFAAA3
9B91877D736A6159534E4B4A4B4E52586069727C869099A2A9AEB2B4B4B3AFAAA39B92887E74
6B625A544F4C4B4C4E53596069727C869099A1A8ADB1B3B4B2AEA9A39B92887E746B625B5450
4D4C4C4F53596169727C868F98A1A7ADB1B3B3B1ADA8A29A91877E746B625B55504E4D4D5055
5A626A737D879099A1A7ACB0B2B2B0ACA7A09890867D736A625B55514E4D4F51565C636C757E
88919AA1A7ACB0B1B1AFABA59E978E847B7269615A55514F4E5053585E656E77808A939BA2A8
ACAFB0B0ADA9A39C948B82797067605954514F4F51555A6068707A838C949CA3A9ADAFAFAEAB
A7A19991897F766E655E585451505153575C636B747D868E979EA4A9ADAEAEACA9A49E968E85
7C736B635D5754515152555A60676F7780899199A0A6AAADAEADAAA6A19A938A81797068615B
5653525254585D636A737B848D959CA2A7ABACADABA8A39D968E867D756C655F595653535457
5B60676F77808890989FA4A8ABACABA9A5A099928A81797069625C5855545456595E656C747C
848D949BA1A6A9ABABA9A6A19B958D857C746C655F5A57555556595D63697179818991989FA4
A7AAAAA9A6A29D978F877F776F68625C59565556585C61686F777F878F969CA2A6A8A9A9A7A3
9E9891898179726A645E5A585657595C61666D757D858C949AA0A4A7A8A8A6A39F99928B837B
746C66605C595757595C60666C737B838B92989EA2A5A7A7A6A39F9A938C857D756E67625D5A
5858595C60656C737A828990979DA1A4A6A6A5A39F9A948D857E766F69635E5B59595A5D6065
6B727981888F969BA0A3A5A6A5A29E99948D867E77706A645F5C5A5A5B5D61666C727981888F
959B9FA2A4A5A4A19E99938D867E77706A65605D5B5B5C5E62666C737A81888F959A9EA2A3A4
A3A09D98928C857E77706A65615E5C5C5D5F63676D737A81888F959A9EA1A3A3A29F9C97918B
847D77706A65615E5D5D5E6064696E747B82898F959A9EA0A2A2A19E9A96908A837C76706A65
615F5E5E5F62656A70767C838A90959A9EA0A1A19F9D99948E88827B756F6965625F5E5F6063
676C71787E858B91969A9D9FA0A09E9B97928D86807A736E696562605F606265696E747A8086
8C92979B9D9F9F9F9C9995908A847E78726D68646260606163676B70767C82888E93979B9D9E
9E9D9B97938E88827C76706B67646261616365696D73787E848A9094989B9D9E9D9B9995908B
857F79746F6A666462626365686B70757B81878C9195999B9D9D9C9996928D88827D77726D69
6664636364676A6E73787E84898E9397999B9C9B9A97948F8A857F7A74706B68656464646669
6D71767C81878C9094989A9B9B9A9895918C87827C77726E6A6765646566686C70747A7F8489
8E9296989A9A999895928E89847E7974706C6967666566686B6F73787D82878C909497989999
9895928E8A85807B76726E6A68676667686B6E72777C81868A8F92959798989795938F8B8681
7C78736F6C69686767696B6E72767B7F84898D91949697979795938F8C87827E7975716D6B69
6868696B6E71757A7E83888C90939596979695938F8C88837F7A76726E6C6A69696A6B6E7175
797E82878B8F929495969594928F8C88847F7B77736F6D6B6A6A6A6C6E7175797D82868A8E91
9394959594928F8C8884807B7773706E6C6B6A6B6D6F7275797D8186898D909293949493918F
8B8884807C7874716E6D6C6B6C6D6F7276797D8185898C8F9193939392908E8B8784807C7874
716F6D6C6C6D6E7073767A7E8185898C8F9192929291908D8A87837F7C787572706E6D6D6E6F
7174777A7E8285898C8E90919291908F8C8986837F7B787572706F6E6E6E707275787B7E8286
898C8E909191918F8E8B8985827E7B787572706F6F6F6F717376787C7F8386898B8E8F909090
8E8D8A8884817E7B77757371706F7070727477797D808386898B8D8F8F8F8F8D8C898683807D
7A77757371707070717375787B7E818487898B8D8E8F8E8E8C8A8885827F7C79777573727171
71737476797C7F828487898B8D8E8E8D8D8B898784817E7C79777573727272727476787A7D80
8385888A8B8C8D8D8C8B8A888583807D7B78767473727273747577797B7E818386888A8B8C8C
8C8B8A888684827F7C7A787674747373747576787A7D7F828486888A8B8C8C8B8A8987858380
7E7B797776757474747576787A7C7E81838587898A8B8B8B8A89888684817F7D7B7977767574
74757677797B7D7F82848687898A8A8A8A8988868482807E7C7A7877767575757677797B7C7F
818385868889898A898988868583817F7D7B7978777676767677797A7C7E8082848587888989
898888868583817F7E7C7A79787776767778797A7C7D7F818384868788888888878685838280
7E7C7B7A787877777778797A7B7D7F8082848586878888888786858482807F7D7C7A79787878
7878797A7B7D7E8082838486868787878786858482817F7E7C7B7A7978787879797A7B7D7E80
81838485868687868686858482817F7E7D7B7A7A797979797A7B7C7D7E7F8182838485868686
868584838281807E7D7C7B7A7A79797A7A7B7C7D7E7F8182838485858585858584838281807F
7D7C7B7B7A7A7A7A7A7B7C7D7E7F8082838384858585858484838281807F7E7D7C7B7B7A7A7A
7B7B7C7D7E7F8081828384848484848483838281807F7E7D7C7B7B7B7B7B7B7C7D7D7E7F8081
828383848484848383828181807F7E7D7C7C7B7B7B7B7C7C7D7E7E7F80818282838384848383
83828180807F7E7D7D7C7C7C7C7C7C7D7D7E7F7F8081828283838383838382828180807F7E7D
7D7C7C7C7C7C7D7D7E7E7F8080818182828383838382828181807F7F7E7E7D7D7D7C7C7D7D7D
7E7E7F8080818182828282828282828180807F7F7E7E7D7D7D7D7D7D7D7E7E7F7F8080818182
828282828282818180807F7F7E7E7E7D7D7D7D7D7E7E7E7F7F80808181818282828281818180
80807F7F7E7E7E7E7D7D7E7E7E7E7F7F7F80808181818181818181818180807F7F7F7E7E7E7E
7E7E7E7E7E7F7F7F8080808181818181818181818080807F7F7F7E7E7E7E7E7E7E7E7F7F7F7F
8080808181818181818181808080807F7F7F7F7E7E7E7E7E7E7F7F7F7F808080808081818181
8181808080807F7F7F7F7F7E7E7E7E7E7F7F7F7F7F8080808080808181808080808080807F7F
7F7F7F7F7F7F7F7F7F7F7F7F8080808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F
7F7F7F7F8080808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F8080808080
808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F80808080808080808080808080
807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F8080808080808080808080808080807F7F7F7F7F7F7F
7F7F7F7F7F7F7F7F80808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F80
808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F80808080808080808080
80808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F8080808080808080808080808080807F7F7F7F
7F7F7F7F7F7F7F7F7F7F8080808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F
7F7F80808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F80808080808080
808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F80808080808080808080808080807F7F
7F7F7F7F7F7F7F7F7F7F7F7F7F80808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F
7F7F7F7F80808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F8080808080
8080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F8080808080808080808080808080
7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F80808080808080808080808080807F7F7F7F7F7F7F7F7F
7F7F7F7F7F8080808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F80808080
80808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F80808080808080808080808080
807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F80808080808080808080808080807F7F7F7F7F7F7F7F
7F7F7F7F7F7F7F80808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F808080
8080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F808080808080808080808080
80807F7F7F7F7F7F7F7F7F7F7F7F7F7F80808080808080808080808080808080808080808080
8080808080808080808080808080808080808080808080808080808080808080808080808080
8080808080808080808080808080808080808080808080808080808080808080808080808080
8080808080808080808080808080808080808080808080808080808080808080808080808080
80808080808080808080808080
pop
% End of sampled sound
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{281, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40n007h00Oo`008@0000000`00
ooooo`2GoomL000Yool100000003003ooooo02;oo`03003oo`0006T00003ool0000007D001Koo`40
000000<00?ooool0o`007P0000000`00ool0003o000L0001ool100000003003ooooo03coo`<00004
ool00000ool600000ooo0000000700000ooo0000000>00000ooo0000000H00000ooo0000000;0002
ool00`00ool0001Z000Pool100000003003ooooo09ooodP003Goo`40000000<00?ooool0oooo7Ooo
0@0000000`00ooooo`3ooolMool100000003003ooooo0?oooagoo`40000000<00?ooool0oooo7Ooo
0@0000000`00ooooo`3ooolMool100000003003ooooo0?oooagoo`40000000<00?ooool0oooo7Ooo
0@0000000`00ooooo`3ooolMool100000003003ooooo0?oooagoo`40000000<00?ooool0oooo7Ooo
0@0000000`00ooooo`3ooolMool100000003003ooooo0?oooacoo`80000000<00?ooool0oooo6ooo
0@000Ooo0@0000000`00ooooo`3ooolMool100000?l00240000000<00?ooool0N?oo0P0000?oo`00
0000100000Coo`00003oo`H00003ool0000000;oo`05003oo`00003oo`0@001gool100000003003o
oooo07;oo`03003oo`0001T00003ool0000001T007;oo`40000000<00?ooool0Kooo00<00?oo0000
1`0000?oo`000000100000Coo`00003oo`H00005ool00000003oo`0N001_ool100000003003ooooo
06_oo``00003ool0000000L00004ool00000ool600001?oo003ooooo2P0000?oo`0000000`0000?o
o`0000004000J_oo0@0000000`00ooooo`1Wool200000ooo0000000>00000ooo0000000A00000ooo
0000000T001Wool100000003003ooooo06Goo`X00005ool00000003oo`0200001?oo00000?oo1P00
00Coo`00003oo`H00003ool0000000;ooa000003ool0000000<00005ool00?oo003oo`0=001Uool1
00000003003ooooo067oo`03003oo`0000`00003ool00?oo00`00003ool00?oo00800003ool00000
00@00004ool00000ool700002_oo00000?oo003oo`00ool00?oo1P0000Goo`0000000?oo00800003
ool0000000/0067oo`40000000<00?ooool0G_oo00<00?oo00006@0000?oo`0000000`0000Coo`00
003oo`H00003ool0000000;oo`H00003ool0000000800007ool00000003oo`00ool07@00G_oo0@00
00000`00ooooo`1Mool800001?oo00000?oo1P0000Coo`00003oo`H00003ool0000000<000Ooo`D0
0004ool00000ool500000ooo003oo`0200000ooo0000000300000ooo003oo`0300000ooo003oo`08
00001Ooo00000000ool02P00GOoo0@0000000`00ooooo`1Jool?00001Ooo00000000ool00P0000?o
o`00000010000_oo00<00?oo00001@0000Coo`00003oo`D00003ool0000000;oo`06003oo`00ool0
0?oo0`000_oo00<00?oo00000ooo100000?oo`00ool00`0000Coo`00003oo`<00003ool00?oo00h0
05[oo`40000000<00?ooool0FOoo3`0000?oo`000000100000?oo`0000003P0000Goo`00003oo`00
00?oo`<00003ool0000000;oo`04003oo`00ool300001?oo00000?oo200000?oo`000000100000?o
o`0000005`00F?oo0@0000000`00ooooo`1Gool:00001Ooo00000000ool01`000_oo00<00?oo0000
1`001_oo0P0000?oo`0000001P0000?oo`0000000_oo00P00?oo003oo`00ool00?oo0P0000?oo`00
00000`0000Coo`00ooooo`<000;oo`03003oo`0000L00003ool0000000800003ool0000000`005Ko
o`40000000<00?ooool0E?oo00<00?oo0000200000Goo`0000000?oo00@000?oo`@00003ool00?oo
00Coo`@00003ool0000000<00003ool0000000@000Woo`05003oo`00003oo`030002ool00`00ool0
0004ool400001?oo00000?oo1P000_oo0`0000?oo`0000002@0000?oo`0000001@00E?oo0@000000
0`00ooooo`1Bool<00000ooo0000000400001Ooo00000000ool0100000?oo`00ool0200000?oo`00
00000P001Ooo200000Coo`00003oo`P00004ool00000ool200000ooo003oo`0400000ooo00000003
00001?oo00000?oo2P0000Coo`00003oo`<00003ool0000000P005;oo`40000000<00?ooool0DOoo
300000?oo`0000000`0000?oo`0000000P0000Coo`00ooooo`<00003ool0000000<000Ooo`h00003
ool0000000;oo`800006ool00000ool00?oo0P0000?oo`0000000P0000Koo`00ooooo`00ool50002
ool<00000ooo003oo`0400000ooo0000000:001Aool100000003003ooooo04ooo`H00006ool00000
ool00?oo0`000ooo10000ooo00<00?oo00000`001Ooo1`0000?oo`0000001@003Ooo00@00?ooool0
00;oo`800004ool00?ooool500000ooo003oo`020004ool300000ooo0000000400000ooo00000002
ool400001Ooo00000000ool00`0000?oo`0000001`00C_oo0@0000000`00ooooo`1=ool:00000ooo
0000000500001Ooo00000000ool0100000?oo`0000000ooo0P0000?oo`0000001P0000?oo`00ool0
1ooo200000Goo`0000000?oo00800004ool00000ool300000ooo0000000300000ooo000000090000
2_oo00000?oo003oo`00ool00?oo2@0000?oo`00ool03P00COoo0@0000000`00ooooo`1:ool00`00
ool0000700000ooo0000000700000ooo0000000600000ooo0000000500000ooo00000005ool30000
0ooo0000000=00000ooo00000002ool200002?oo00000?oo003oo`00ool400000ooo003oo`070000
0ooo0000000300001Ooo00000000ool0100000?oo`00ool00P000_oo0P0000?oo`0000003`00Booo
0@0000000`00ooooo`19ool:00001Ooo00000000ool010000_oo1@000ooo1`001_oo1P0000?oo`00
00001P003?oo0P0000[oo`00003oo`00ool00?oo003oo`H000;oo`05003ooooo003oo`030004ool0
0`00ooooo`0200000ooo003oo`030003ool00`00ool0000500000ooo0000000200000ooo00000006
001:ool100000003003ooooo04Woo`/000;oo`<000;oo`<000Coo`D000Goo`@00003ool0000000<0
013oo`D00008ool00000ool00?oo003oo`800003ool0000000?oo`D00006ool00?ooool00?oo0P00
0ooo2@000_oo00<00?ooool00`0000?oo`0000000P0000Goo`00ool00?oo00h004Soo`40000000<0
0?ooool0A_oo00<00?oo0000500000?oo`00ool01@000_oo200000?oo`0000001_oo0P0000?oo`00
00003@0000Soo`00003oo`00ool00?oo0P0000Koo`00ooooo`00ool200001Ooo00000?oo00000_oo
0`000ooo0`0000?oo`0000000`000_oo0P0000?oo`0000000`0000Woo`0000000?oo003oo`00ool0
1@0000?oo`0000002@00A_oo0@0000000`00ooooo`15ool500000ooo00000002ool00`00ool00002
0002ool40003ool01000ool000001?oo1P002?oo1P0000?oo`0000002@002_oo00@00?oo000000;o
o`04003oo`00ool200000ooo003oo`04ool30003ool01@00ool00?oo00000_oo00D00?ooooooo`00
00;oo`03003oo`0000H00003ool0000000D00003ool00?oo00800003ool0000000P004Goo`400000
00<00?ooool0AOoo2P0000Coo`00003oo`@000;oo`@000Coo`H000Koo`<00003ool0000000@001Oo
o`04003oo`000002ool00`00ool000020002ool20003ool200001?oo003ooooo0P0000Goo`000000
0?oo008000;oo`<00003ool0000000800005ool00?ooool00002ool500000ooo0000000700000ooo
000000060014ool100000003003ooooo04;oo``00003ool00?oo00<00003ool0000000D00004ool0
0000ool40003ool800000ooo0000000:ool?00001?oo00000?oo0P0000Goo`0000000?oo008000;o
o`L00004ool00?ooool50002ool00`00ool0000200000ooo0000000200001?oo003oo`000_oo00<0
0?oo00000P0000Coo`00003oo`T00004ool00000ool70013ool100000003003ooooo047oo`X00005
ool00?oo003oo`0300000ooo000000020003ool300000ooo003oo`04ool7000:oolD00001Ooo0000
0?oo00000_oo0`0000?oo`00ool01?oo1@001?oo00<00?oo00000P001?oo0P000_oo0P0000?oo`00
ool00`000_oo00@00?oo003oo`@00004ool00?ooool30002ool00`00ool0000300000ooo00000006
0011ool100000003003ooooo043oo`T00008ool00000ool00?oo003oo`<000?oo`D000Coo`L000Oo
o`d001Goo`8000?oo`03003ooooo00@00003ool0000000;oo`03003oo`0000;oo`03003ooooo00;o
o`800003ool0000000800003ool00?oo008000;oo`<000?oo`04003ooooo0002ool300001Ooo003o
o`00ool01`0000?oo`0000001@00@?oo0@0000000`00ooooo`0oool>00000ooo0000000300000ooo
003oo`040003ool70004ool=000>ool800001?oo00000?oo0P0000Coo`00000000;oo`@00003ool0
0?oo00;oo`04003oo`00ool20003ool300000ooo0000000200000ooo003oo`0200000ooo00000003
00001ooo00000000ool00?oo00@00003ool00?oo00800004ool00000ool300000ooo00000008000n
ool100000003003ooooo03koo`D00003ool0000000<00003ool0000000;oo`8000?oo`04003oo`00
0003ool400000ooo003oo`04ool9000=ool?00001Ooo00000?oo00000_oo0`000_oo00<00?oo0000
0_oo00<00?ooool00ooo10000ooo00D00?oo003oo`0000;oo`04003oo`00ool200001?oo003ooooo
0P0000Goo`0000000?oo00D000?oo`<00003ool0000000<000;oo`800004ool00000ool6000mool1
00000003003ooooo03coo`h000;oo`<00004ool000000004ool50005ool6000:oolB000<ool40002
ool00`00ool00002ool00`00ool000070002ool200003?oo00000000ool00?oo003oo`00ool000;o
o`03003oo`0000;oo`03003ooooo00;oo`<00003ool00?oo00<00003ool0000000800004ool00?oo
ool300000ooo0000000200000ooo00000003000lool100000003003ooooo03_ooa<00004ool00000
0002ool60003ool200000ooo000000020006ool@000Dool300001Ooo003ooooo00001Ooo1@000_oo
00<00?ooool00P0000Goo`0000000?oo00<00004ool00?oo0002ool400001ooo003ooooo003oo`00
00;oo`H00006ool00000ool00?oo1P0000Koo`00003oo`00ool7000kool100000003003ooooo03[o
o`D00004ool000000002ool00`00ooooo`0300001?oo000000001?oo0`001?oo100000?oo`00ool0
1_oo2P006ooo0P000_oo0P0000?oo`0000000_oo0P0000Coo`00003oo`<000Coo`03003ooooo00<0
00;oo`07003ooooo003oo`00ool00`0000Coo`00ool000;oo`04003oooooool50003ool20002ool5
00000ooo003oo`0200000ooo00000009000jool100000003003ooooo03Woo`@00003ool000000080
0004ool00000ool20002ool30002ool40004ool50005ool8000>oolF0002ool00`00ool000030000
0ooo0000000300001?oo003oo`000_oo00<00?oo00000_oo0P001_oo00H00?ooooooo`00ool60002
ool00`00ool0000200000ooo003oo`02ool200001Ooo003oo`00ool00P000_oo00<00?ooool01000
00?oo`0000002000>Ooo0@0000000`00ooooo`0hool<00000ooo0000000500000ooo000000030000
0ooo000000040004ool200000ooo000000040008oolM0003ool01000ool00?oo0P0000?oo`000000
0P000_oo0P000ooo00@00?oo003oo`8000?oo`03003oo`0000H00008ool00000ool00?oo003oo`80
0006ool00000003oo`000ooo1`000_oo00<00?oo00000_oo0P000ooo3@00=ooo0@0000000`00oooo
o`0fool?00001Ooo00000000ool010000_oo1P000_oo1P0000?oo`0000001_oo3`006Ooo0`000ooo
00<00?ooool00_oo1@0000?oo`00000010000_oo00D00?oo00000?oo00@00003ool00?oo00800003
ool00?oo00<00007ool00000003oo`00ool0100000Goo`0000000?oo00D00005ool00000003oo`05
00000ooo00000008000fool100000003003ooooo03Goo`/00003ool0000000;oo`04003oooooool3
0002ool40005ool50008ool9000Gool<00000ooo003oo`020006ool300000ooo0000000400001?oo
00000?oo0P0000Soo`00ooooo`00ool00?oo0P0000Coo`00ooooo`800005ool00000003oo`040002
ool30002ool300000ooo003oo`0300001?oo00000?oo0P0000?oo`0000002P00=Ooo0@0000000`00
ooooo`0eool<00001Ooo00000000ool00`000ooo0`001?oo10001ooo20003ooo60000_oo0P0000Co
o`00ool000;oo`800003ool0000000;oo`8000?oo`07003oo`00003oo`00ool00P0000Soo`00ool0
0?oo003oo`000_oo00H00?oo00000?oo0004ool300000ooo0000000300000ooo003oo`0300000ooo
0000000400001?oo00000?oo1P0000?oo`0000001@00=?oo0@0000000`00ooooo`0dool?0002ool3
00000ooo000000020003ool60004ool90008oolH000;ool01000ool00?oo0P000_oo1@000_oo0`00
00Coo`00003oo`800003ool0000000800007ool00000003oo`00ool00P0000?oo`0000000P0000Oo
o`00ooooo`00ool00003ool500001_oo00000?oo003oo`D00003ool00?oo00800003ool0000000h0
03?oo`40000000<00?ooool0<_oo1`0000?oo`0000000P0000Goo`0000000?oo008000;oo`@000?o
o`@000Goo`H000[oo`d001_oo`03003oo`0000?oo`04003oo`000003ool01@00ool00?oo00000_oo
0P0000Goo`00003oo`0000;oo`05003ooooo003oo`0200001Ooo00000?oo00001?oo00<00?ooool0
0ooo0`000ooo0P0000?oo`0000000P0000Coo`00ooooo`<000;oo`X00003ool0000000@003?oo`40
000000<00?ooool0<Ooo2@0000?oo`00ool00P000_oo0P000_oo0`001?oo0`001?oo1P002?oo2@00
6_oo2P0000?oo`0000000_oo0P001_oo00<00?ooool02?oo00<00?ooool01Ooo00<00?ooool00_oo
0`0000Coo`00ool000;oo`04003oo`00ool20004ool400000ooo003oo`04ool01000ool000001?oo
100000Goo`0000000?oo00P003;oo`40000000<00?ooool0<Ooo2P0000Coo`00003oo`<00004ool0
00000003ool40003ool70004ool<000<oolJ00002?oo003oo`00ool00?oo0002ool01@00ooooo`00
ool00P000_oo0`0000?oo`0000000ooo00<00?oo0000100000?oo`0000002@0000Coo`00ool000;o
o`03003ooooo00H000?oo`03003oo`0000?oo`03003oo`0000800003ool00?oo0100033oo`400000
00<00?ooool0;ooo1P0000?oo`0000000P0000?oo`00ool00`000_oo00<00?oo00000_oo10000ooo
1@001_oo1`003_oo5@003?oo00D00?oo003oo`0000;oo`<000;oo`800003ool0000000800003ool0
000000?oo`05003oo`00003oo`0200001Ooo003oo`00ool00`0000Goo`00003oo`0000;oo`04003o
oooo0002ool300001_oo003ooooo003oo`X00004ool00000ool50003ool9000`ool100000003003o
oooo02koo`X00004ool00000ool200001?oo000000000ooo0`000ooo10001Ooo1P002ooo3@007Ooo
00<00?oo00001?oo0P0000Goo`0000000?oo00<000;oo`8000;oo`800005ool00000ool00002ool4
00001Ooo003ooooo00000_oo0P0000?oo`0000000_oo00@00?oo000000?oo`<00004ool00000ool5
00000ooo000000020003ool01@00ool00000ool00P0000?oo`0000001`00;ooo0@0000000`00oooo
o`0^ool900000ooo0000000200000ooo0000000200000ooo0000000200000ooo000000040003ool8
0007ool>000Lool600001ooo003ooooo003oo`0000;oo`<000;oo`<000;oo`03003ooooo00800003
ool00?oo008000?oo`04003oo`00ool200001?oo003ooooo1@0000?oo`0000000P0000?oo`00ool0
0`000_oo00D00?oo00000?oo00H00003ool00?oo00<00004ool00000ool200000ooo0000000:000]
ool100000003003ooooo02goo`P00004ool00000ool200001Ooo00000000ool010000_oo10001?oo
1@002Ooo20005_oo4`000_oo00H00?ooool00?oo0002ool00`00ooooo`02ool00`00ool00002ool0
1@00oooooooo00000_oo0`000_oo0P000_oo0`001?oo1@0000?oo`00ool00P0000Goo`0000000?oo
00800004ool00?oo0002ool200000ooo003oo`02ool00`00ool0000200000ooo0000000300000ooo
0000000;000]ool100000003003ooooo02coo`L00006ool00000003oo`000_oo00<00?ooool00`00
0_oo0`001Ooo1@001_oo20003ooo6`001_oo00<00?ooool00P0000?oo`00ool01Ooo00<00?ooool0
0_oo00D00?ooooooo`0000;oo`@00003ool0000000;oo`800003ool00?oo00@000Coo`04003ooooo
0002ool500001_oo00000?oo003oo`800004ool00?ooool20005ool400001Ooo00000000ool03000
;?oo0@0000000`00ooooo`0[ool@00001?oo000000000_oo10000_oo1P001?oo2P002Ooo5P005_oo
0P0000Coo`00ooooo`<00003ool00?oo008000Goo`03003ooooo00800006ool00?ooool00?oo0`00
00?oo`00ool00P0000?oo`00ool00ooo00@00?ooool000;oo`<000?oo`800003ool0000000800004
ool00000ool20004ool200000ooo003oo`020003ool?000Zool100000003003ooooo02[ooa000003
ool0000000;oo`<000Coo`@000Koo`H000[oo``002?oo`03003ooooo00?oo`<000?oo`800006ool0
0?oo003oo`000_oo00<00?ooool01Ooo0P000_oo00T00?oo003oo`00ool00?oo00001_oo0P001Ooo
00D00?oo003oo`0000Coo`03003ooooo00?oo`T000;oo`800004ool00000ool;000Zool100000003
003ooooo02[oo`P000;oo`@00003ool0000000;oo`<000?oo`<000Koo`@000[oo`T001_ooa4000?o
o`800004ool00?ooool400000ooo000000070003ool01@00ool00000ool00P0000Coo`00003oo`H0
00;oo`05003oo`00003oo`020003ool00`00ool000020005ool01000oooooooo0`0000Coo`00003o
o`800003ool0000000/00003ool0000000D002Woo`40000000<00?ooool0:?oo4P0000?oo`000000
0P0000?oo`0000000`000_oo20001Ooo2`003_oo80000ooo0`0000Coo`00ooooo`@000;oo`P000;o
o`800004ool00000ool200000ooo003oo`0300001Ooo003oo`00ool00P0000Coo`00003oo`8000;o
o`D000;oo`03003oo`0000/00003ool00?oo00/00003ool0000000X002Soo`40000000<00?ooool0
9ooo5@0000?oo`0000000`000_oo1`000ooo2`002_oo6P004_oo0P000_oo00<00?ooool01Ooo0P00
00?oo`0000000_oo00@00?ooooooo`800004ool00000ool200000ooo000000020002ool01000oooo
oooo0P000_oo0P000_oo00<00?oo00000`0000Goo`00ool00?oo00800003ool0000000D00003ool0
0?oo00P00003ool00000014002Ooo`40000000<00?ooool09_oo200000Goo`0000000?oo008000;o
o`<000;oo`<000?oo`@000Koo`L000coo`d002;oo`03003ooooo00Koo`03003ooooo008000;oo`04
003ooooo0003ool00`00ooooo`0200000ooo003oo`02ool00`00ool00002ool01000ooooo`000_oo
100000?oo`0000000_oo00X00?ooooooo`00ool00?oo003oo`8000;oo`@00003ool00?oo00<00003
ool00?oo00800004ool00000ool30002ool00`00ool0000:000Vool100000003003ooooo02Goo`l0
0005ool00000003oo`030003ool50004ool5000:ool;000]ool200001?oo00000?oo10001ooo00@0
0?ooooooo`8000;oo`03003oo`0000;oo`06003oo`00ool00?oo0P0000Coo`00ooooo`H000;oo`80
0009ool00?oo003oo`00ool00?oo00800005ool00000ool00008ool00`00ool000030002ool80000
0ooo00000009000Uool100000003003ooooo02Coo`h00003ool0000000H00003ool0000000@000;o
o`P000Goo`d0017oob400004ool00000ool700000ooo00000005ool200000ooo0000000300001Ooo
003oo`00ool0100000Coo`00003oo`D000?oo`800005ool00000003oo`0400000ooo003oo`020000
1?oo003ooooo0P000ooo0`0000Coo`00000000;oo`03003oo`0001<002Coo`40000000<00?ooool0
9?oo2P0000Coo`00003oo`800004ool000000003ool40003ool50007ool8000BoolU0003ool01@00
oooooooo00000_oo0`0000Coo`00003oo`<00004ool00?ooool300000ooo003oo`05ool01000ool0
0?oo1@001?oo00<00?oo00000ooo1`000_oo0`0000Coo`00ooooo`8000?oo`<00003ool0000000?o
o`@00003ool00?oo010002Coo`40000000<00?ooool08ooo2P0000Koo`00003oo`00ool30002ool3
0004ool50005ool7000=oolA000Qool20002ool00`00ooooo`04ool00`00ooooo`090008ool20000
2?oo003oo`00ool00?oo0004ool00`00ooooo`03ool30003ool01000ooooo`001Ooo00D00?ooool0
0?oo00@00003ool0000000D00003ool0000001@002?oo`40000000<00?ooool08_oo600000?oo`00
00001@000_oo2P001ooo4P009ooo0P0000Coo`00000000?oo`03003ooooo00;oo`T000?oo`800003
ool00000008000?oo`03003oo`0000;oo`03003oo`0000;oo`04003oo`00ool20005ool01000ool0
00001Ooo00D00?ooool00?oo00@000?oo`D00003ool0000000H00003ool0000000d002;oo`400000
00<00?ooool08Ooo1`0000?oo`0000001`000_oo0`000ooo10001?oo1P002Ooo30009_oo2`000_oo
0`000ooo00<00?ooool00_oo0P000ooo00@00?oo000000?oo`800004ool00000ool300001Ooo003o
o`00ool01@0000Soo`00ool00?oo003oo`001?oo00@00?oo000000Coo`@000;oo`@000?oo`D00004
ool00000ool30003ool00`00ool0000200000ooo00000009000Qool100000003003ooooo023oo`d0
0005ool00000003oo`0300000ooo000000030003ool60007ool9000EoolT0002ool00`00ooooo`03
ool01P00ool00000ool000Coo`03003oo`0000Coo`800003ool0000000;oo`80000;ool00?oo003o
o`00ool00?oo003oo`020002ool00`00ool00004ool40002ool00`00ool0000300001_oo00000?oo
003oo`T00004ool00?ooool@00000ooo00000005000Pool100000003003ooooo023ooaT000;oo`L0
00?oo`/000goobH000_oo`03003oo`0000?oo`03003oo`0000<000;oo`8000;oo`04003oooooool3
00001_oo003oo`00ool000;oo`<000?oo`04003oooooool20002ool20002ool00`00ooooo`030000
1Ooo003oo`00ool00P0000?oo`00ool0100000?oo`0000000`0000Koo`0000000?oo0002oolJ000O
ool100000003003ooooo01ooo`/00004ool00000ool300001?oo000000000ooo1@001Ooo20003Ooo
4P009_oo00D00?ooooooo`0000?oo`800004ool000000006ool20002ool00`00ool000020003ool0
0`00ooooo`02ool01000ooooo`000_oo10000_oo00@00?ooool000?oo`06003oo`00ool00?oo0P00
00Coo`00ool000Goo`04003ooooo0002ool20004ool900000ooo0000000600000ooo00000004000O
ool100000003003ooooo01koo`/00003ool00000008000;oo`<000;oo`D000?oo`L000[oo`h003?o
o`03003oo`00008000Goo`8000?oo`<00003ool00?oo00;oo`D000;oo`03003ooooo00800005ool0
0000ool00002ool200001_oo00000?oo003oo`800006ool00?oo003oo`000_oo0`0000?oo`000000
0ooo0P001?oo0P0000?oo`0000000_oo1P0000Goo`0000000?oo00<000;oo`d001koo`40000000<0
0?ooool07Ooo500000?oo`000000100000?oo`0000001`001?oo40006?oo8@0000Coo`00000000;o
o`<000Goo`H00003ool0000000800005ool00?ooool00002ool500001?oo00000?oo0P0000Koo`00
003oo`00ool200001Ooo00000000ool00P0000Goo`00ool00?oo00@00004ool000000003ool20000
1?oo00000?oo0`0000?oo`0000001@0000?oo`0000000P0000?oo`0000003@007Ooo0@0000000`00
ooooo`0LoolC0002ool30003ool50007ool;000FoolY0002ool00`00ooooo`02ool40004ool60000
1?oo003oo`002_oo00@00?oo003oo`D00003ool00?oo00?oo`8000;oo`800004ool00000ool20000
1?oo00000?oo0P000_oo0P000_oo0`0000Koo`00003oo`00ool400000ooo00000003ool900000ooo
0000000:000Lool100000003003ooooo01_oo`/00003ool0000000<00003ool00000008000;oo`D0
00Goo`T000oooaT0027oo`03003oo`0000;oo`05003oo`00ool00002ool00`00ooooo`02ool00`00
ool000020004ool00`00ool00002ool200000ooo003oo`02ool00`00ool00005ool00`00ool00002
ool200001?oo003ooooo0P0000?oo`0000001?oo00P00?ooool00?oo003oo`001?oo00D00?oo0000
0?oo00800004ool00000ool900001_oo00000?oo003oo`X001_oo`40000000<00?ooool06_oo7000
0_oo2P002?oo6@00:ooo00@00?oo003oo`8000?oo`@000Coo`03003ooooo008000;oo`<00003ool0
000000@000?oo`<00004ool00?oo0002ool01000oooooooo0`0000Coo`00ooooo`<00003ool00?oo
00?oo`05003ooooo003oo`040003ool400001?oo00000?oo0P0000?oo`0000000P0000?oo`000000
0P0000?oo`0000003`006_oo0@0000000`00ooooo`0IoolT0004oolC000Zool@00000ooo00000003
0003ool200000ooo000000020003ool01000oooooooo0`0000Goo`0000000?oo00800003ool00000
00P00004ool00000ool200000ooo003oo`03ool50003oolC0002ool200000ooo0000000500000ooo
003oo`0C000Iool100000003003ooooo01Wooa000003ool00000008000?oo`H000Koo``001ooobD0
0003ool0000000;oo`05003oooooool00002ool40003ool01000oooooooo0P000_oo00D00?oo003o
o`0000;oo`800008ool00?oo003oo`00ool000;oo`06003oo`00003oo`001?oo00@00?oo000000;o
o`/00003ool0000000800003ool0000000<000?oo`<00003ool0000000800004ool00?ooool60000
0ooo0000000;000Hool100000003003ooooo01Oooa@00003ool0000000@000Coo`X0017oob`001Co
o`03003ooooo00@000Koo`8000?oo`8000?oo`@000Coo`<000;oo`03003ooooo00;oo`8000Soo`03
003oo`0000?oo`@00003ool00?oo00@00007ool00?ooool00?oo00000_oo0P000ooo0P0000Goo`00
00000?oo00<00003ool0000001D001Ooo`40000000<00?ooool05_oo9`001_oo9000:?oo0P0000?o
o`0000001@000ooo1`000ooo1@000_oo00<00?oo00000P000_oo00D00?ooool00?oo00<00003ool0
000000;oo`05003oo`00ool00002ool200000ooo003oo`070004ool00`00ool00002ool20002ool7
00000ooo0000000600001ooo00000000ool00?oo00h001Koo`40000000<00?ooool05Ooo5P0000?o
o`0000001`002?oo4`00?_oo0P0000?oo`0000000ooo0P000ooo1`000ooo0`0000Goo`00ooooo`00
00;oo`04003oo`00ool200001?oo003ooooo0P0000Coo`00003oo`800003ool00?oo00?oo`8000;o
o`H00005ool00?ooool00003ool01P00ool00?oo003oo`P000?oo`H00005ool00000003oo`030000
0ooo0000000<000Eool100000003003ooooo01Cooa/000Coo`l003[ooa8000Goo`03003ooooo00;o
o`03003oo`0000Goo`03003ooooo00<000[oo`@000;oo`05003oo`00003oo`0200001?oo003ooooo
0P0000[oo`00ool00?oo003oo`00ool000;oo`03003ooooo00;oo`8000;oo`<00004ool00?oo0002
ool01000ool00?oo0P0000Coo`00000000;oo`03003ooooo01P001Coo`40000000<00?ooool04ooo
:@003OooA0000_oo10000_oo0`0000Goo`00003oo`0000;oo`03003ooooo00<000Coo`03003ooooo
00;oo`<00004ool00?ooool400000ooo00000004ool200001ooo003oo`00ool00?oo00@00003ool0
0?oo00800003ool0000000;oo`<00005ool00?oo003oo`0200000ooo0000000200000ooo00000004
0003oolJ000Bool100000003003ooooo01;oob0000_oocl001;oo`<00003ool00?oo00800008ool0
0000003oo`00ool000?oo`8000Goo`03003ooooo00@000;oo`03003ooooo00800003ool00?oo00Co
o`03003oo`0000?oo`@00003ool0000000@00004ool000000004ool30003ool01@00ool00000ool0
100000?oo`00ool0100000Koo`00003oo`00ool300000ooo003oo`0B000Bool100000003003ooooo
013oocT004Soo`06003oo`00003oo`000ooo00<00?oo00000ooo00<00?ooool00ooo0P000_oo0P00
0_oo0P000ooo0`0000Coo`00ool000;oo`03003ooooo00?oo`<000?oo`04003ooooo0004ool01000
oooooooo1@0000?oo`0000000P0000?oo`00ool00_oo00@00?ooooooo`@00003ool0000001l000oo
o`40000000<00?ooool03Ooo;`00Dooo00<00?ooool00P0000Coo`00ool000Koo`8000Coo`<000;o
o`8000;oo`800003ool0000000D00003ool00?oo00;oo`04003oo`00ool20005ool01000ool00000
1?oo00@00?oo003oo``00003ool00?oo00;oo`H00003ool0000000L00003ool0000001T000coo`40
000000<00?ooool00_oo:00000?oo`00ool00`000_oo1@000_oo0P000_oo00X00?oo00000?oo003o
o`00ool000;oo`<00004ool00?ooool50002ool200001?oo003ooooo0`0000Coo`00003oo`8000;o
o`D00005ool00000003oo`040003ool20004ool300001?oo003ooooo1@000_oo0P0000Coo`000000
00?oo`03003oo`0000?oo`<00004ool00?ooool20003ool00`00ool000020002ool20003ool03P00
ooooo`00ool00?oo003oo`00ool00?oo0004ool01000ool000001?oo00@00?oo003oo`@00003ool0
000000800005ool00000ool00003ool40003ool900000ooo0000000T0002ool100000003003ooooo
02T00003ool00?oo00<00003ool0000000@00003ool0000000L00007ool00000003oo`00ool01000
00?oo`00ool01P0000?oo`0000002`0000Coo`00003oo`H00003ool0000000/00003ool0000000@0
0003ool00?oo00H00003ool0000000@00003ool00?oo00?oo`8000;oo`8000;oo`@000?oo`D000Go
o`03003oo`0000?oo`04003oo`00ool20003ool30003ool40002ool500000ooo0000000200002?oo
003ooooo003oo`00ool20002ool50004ool200000ooo003oo`02ool00`00ool0000200001?oo0000
0?oo8`0000000`00ool0000c00000ooo003oo`0200000ooo000000030002ool300000ooo003oo`03
0002ool00`00ool000020002ool01@00ool00000ool01P0000Goo`0000000?oo00800008ool00000
ool00?oo003oo`800003ool0000000?oo`@000;oo`D000;oo`03003oo`00008000;oo`03003oo`00
00D00003ool00?oo00D00003ool0000000?oo`@00003ool0000000<00003ool0000000;oo`03003o
o`00008000;oo`8000?oo`8000;oo`800003ool00?oo00;oo`<000?oo`@00003ool00?oo00<000Co
o`03003oo`0000<00003ool0000000<00004ool00000ool300000ooo00000002ool500000ooo0000
000S0001ool100000003003ooooo00goobD00003ool0000000P0053oo`8000?oo`T000Coo`03003o
oooo00@000?oo`04003ooooo0002ool01000oooooooo0P000_oo00<00?ooool010000ooo00<00?oo
00001?oo0P0000?oo`00ool00P0000Coo`00ool000Koo`800005ool00?oo003oo`0300000ooo0000
000700000ooo003oo`0200001Ooo00000000ool05P003ooo0@0000000`00ooooo`0@oolE00000ooo
000000060004ool:00000ooo0000000L000bool200000ooo00000002ool30002ool00`00ool00002
0005ool2000<ool30002ool00`00ooooo`0200001?oo00000?oo1P000_oo0P000_oo0`0000?oo`00
ool00ooo0P000_oo0`0000Ooo`00ool00?oo003oo`0400000ooo0000000300000ooo000000020000
0ooo0000000G000Aool100000003003ooooo017oo`03003oo`0001T00003ool0000000P000Cooah0
0003ool0000003@00003ool0000000?oo`03003ooooo00<000Coo`8000?oo`06003oo`00003oo`00
0_oo0`0000Coo`00ooooo`800004ool00000ool200000ooo003oo`0500002ooo00000000ool00?oo
003oo`00ool00P0000?oo`0000000_oo0`0000Goo`00ool00?oo00H00003ool0000000<00003ool0
000001/001?oo`40000000<00?ooool04ooo900000?oo`0000002@005ooo=@000_oo00<00?ooool0
0_oo00@00?ooool000Coo`<000?oo`D00003ool0000000<000;oo`03003ooooo00800005ool00000
ool00002ool00`00ooooo`0200000ooo0000000300000ooo003oo`0300001Ooo00000000ool00P00
00Coo`00000000?oo`800003ool00?oo00;oo`L00003ool0000001/001Coo`40000000<00?ooool0
5?oo3P0000?oo`0000000P0000?oo`0000001@0000Coo`00000000Coo`/00003ool0000000D004?o
o`800004ool00?ooool400001?oo003ooooo100000Koo`00ooooo`00ool20002ool30002ool20003
ool01@00ool00?oo00001?oo00@00?ooool000;oo`@000;oo`04003oo`000004ool01@00ooooo`00
ool0100000?oo`0000000`0000Coo`00ooooo`<000Coo`800004ool00?oooolF000Fool100000003
003ooooo01Gooa@00003ool0000000H00003ool0000000D000SooaT003;oo`<00003ool0000000D0
0003ool00000008000;oo`@00003ool00?oo00;oo`05003oo`00003oo`0200001_oo00000000ool0
00;oo`03003oo`0000Soo`03003oo`0000;oo`<00003ool00?oo00?oo`04003oooooool:00001?oo
003ooooo0P0000?oo`0000000ooo00@00?ooool000;oo`03003oo`0000H00003ool0000000X001Ko
o`40000000<00?ooool05_oo4@0000?oo`0000003`0000?oo`0000001@001ooo4P0000?oo`000000
8@003ooo0P0000?oo`00ool00_oo0`0000Coo`00ool000?oo`D000?oo`D00004ool00?ooool20000
1?oo00000?oo1@000_oo00@00?oo003oo`8000Coo`D000?oo`P00003ool0000000<00003ool00000
00;oo`03003oo`0000<00003ool0000000D00003ool0000001<001Ooo`40000000<00?ooool05ooo
3`0000?oo`0000000P0000?oo`000000100000Coo`00000000?oo`L00003ool00000008001Goob<0
0003ool0000000l000?oo`8000?oo`04003oo`00ool20003ool200000ooo0000000300000ooo0000
0005ool300001_oo00000000ool000;oo`04003oo`00ool30003ool01000ooooo`000_oo2P0000Oo
o`00ool00?oo003oo`020002ool01@00ool00000ool0400000?oo`0000002`006Ooo0@0000000`00
ooooo`0Hool@00000ooo0000000200001Ooo00000000ool00`0000?oo`0000000`001Ooo100000?o
o`0000002000;_oo5@001?oo00@00?ooooooo`800004ool00?oo0002ool40003ool01P00oooooooo
003oo`<000;oo`03003ooooo00?oo`8000;oo`03003oo`0000Coo`<000;oo`@00003ool00?oo00<0
00Ooo`06003oo`00ool00?oo0P0000Koo`00003oo`00ool20002ool:00000ooo00000009000Iool1
00000003003ooooo01Soo`03003oo`0000`00005ool00000003oo`0400000ooo0000000=0004ool:
00000ooo0000000;000aool300000ooo003oo`030003ool01000ooooo`001?oo10001ooo00L00?oo
ool00?oo003oo`020002ool00`00ool0000200000ooo00000002ool00`00ooooo`0300001_oo0000
0?oo003oo`@00003ool00?oo008000?oo`800003ool00?oo00L00003ool0000001X001[oo`400000
00<00?ooool06_oo300000Coo`00003oo`X00003ool0000000;oo`H00003ool00000008000[oo`d0
0003ool0000000H002Woo`05003ooooo003oo`030003ool00`00ooooo`03ool00`00ool0000?ool4
0002ool00`00ooooo`0200001?oo00000?oo0P000_oo00@00?ooooooo`8000;oo`D000?oo`<000;o
o`800003ool00?oo00D00004ool00?ooool80002ool@000Lool100000003003ooooo01_oo`d00004
ool00000ool300000ooo0000000400000ooo000000020004ool400000ooo00000004000Aool80000
0ooo0000000J000>ool300001Ooo003oo`00ool00P0000?oo`00ool01@001?oo00<00?oo00000`00
00Coo`00003oo`<00004ool00000ool200001?oo00000?oo0P0000Coo`00ooooo`800003ool00?oo
008000;oo`04003oo`00ool40002ool00`00ooooo`020003ool20006ool30003ool200000ooo003o
o`02ool300000ooo00000009000Lool100000003003ooooo01_oo`03003oo`0000T00004ool00000
ool?00000ooo000000030003ool600000ooo00000007000@oolL00000ooo0000000>00001Ooo003o
o`00ool00P0000?oo`00ool01`0000Coo`00003oo`X000;oo`800003ool0000000<00003ool00000
00Coo`800003ool0000000L00003ool0000000<00004ool00?ooool300000ooo000000050002ool4
0002oolF000Mool100000003003ooooo01goo``00004ool00000ool300000ooo0000000300001?oo
00000?oo1@0000?oo`0000001ooo2@0000?oo`0000000P00:?oo4P000_oo00L00?ooooooo`00ool0
0004ool200001Ooo003ooooo00000ooo00D00?oo00000?oo00<000?oo`05003oo`00ool00005ool3
0003ool800000ooo00000002ool01000oooooooo100000?oo`0000001@000_oo1@0000?oo`000000
50007_oo0@0000000`00ooooo`0Nool<00000ooo0000000500000ooo000000070003ool200000ooo
00000004000:ool400000ooo0000000:000Zool200001Ooo003oo`00ool00`001?oo0P000ooo00<0
0?oo00001?oo0P0000?oo`0000000`0000Goo`0000000?oo00800004ool00?oo0002ool20004ool4
0005ool00`00ooooo`02ool00`00ooooo`0400001?oo000000000ooo1P0000?oo`00000010000_oo
2@0000Coo`00003oo`<001ooo`40000000<00?ooool07_oo5`0000?oo`0000000`0000?oo`000000
0P0000?oo`000000100000?oo`00000010002?oo7P006_oo0P000_oo10000ooo0`0000Ooo`00ool0
0?oo003oo`0200000ooo000000030004ool200000ooo000000050003ool01000ool00?oo0`0000Co
o`00ooooo`@000Coo`L00007ool00000003oo`00ool02@0000?oo`00ool01P0000?oo`0000002P00
8?oo0@0000000`00ooooo`0Oool?00001ooo00000000ool00?oo00800004ool00000ool400000ooo
00000005ool600000ooo00000002000?oolS0009ool300000ooo003oo`020003ool01@00oooooooo
00001Ooo100000Coo`00ool000Koo`<00004ool00?oo0002ool02@00ool00?oo003oo`00ool00004
ool30005ool500002Ooo003oo`00ool00?oo003oo`0300000ooo0000000300000ooo000000060002
ool300000ooo00000005000Qool100000003003ooooo027oo`T00003ool0000000800005ool00000
003oo`0500001?oo000000000_oo0P0000?oo`0000000`001_oo30006Ooo4@0000?oo`0000002@00
0_oo00<00?oo00000_oo0P0000?oo`00ool00P0000Coo`00ooooo`@000Soo`03003oo`00008000;o
o`8000;oo`04003oo`000003ool30003ool30003ool300001_oo003oo`00ool000Goo`05003oo`00
003oo`0500000ooo000000020002ool300000ooo0000000;000Qool100000003003ooooo027oo`d0
0005ool00000003oo`0300000ooo0000000300001Ooo00000000ool01@0000?oo`0000000`001?oo
200000?oo`00000020008?oo300000Coo`00ool000;oo`@00004ool00000ool40005ool00`00oooo
o`03ool01`00ooooo`00ool00?oo008000;oo`04003oo`000002ool200000ooo003oo`02ool30003
ool900000ooo00000002ool400001ooo00000000ool00?oo00800004ool00?oooolA000Rool10000
0003003ooooo02;oo`h00005ool00000003oo`0400000ooo0000000300000ooo000000020002ool<
0006oolG000Nool00`00ool00002ool00`00ool000020002ool80002ool00`00ool0000400001?oo
003ooooo1P000_oo00<00?ooool01@0000Koo`00ool00?oo0004ool200000ooo000000040002ool2
0002ool30002ool200000ooo00000002ool01@00ool00000ool02`0000?oo`0000000`008ooo0@00
00000`00ooooo`0Rool00`00ool0000:00001?oo00000?oo0`0000?oo`00ool00`0000?oo`00ool0
100000?oo`0000001?oo2P003Ooo3@0000?oo`0000001`005_oo00D00?ooool00?oo00<000?oo`80
0003ool00?oo00800003ool0000000;oo`@00003ool0000000<00004ool00?oo0002ool200000ooo
0000000300000ooo003oo`0300001?oo003ooooo0P0000Ooo`00ool00?oo003oo`0200001?oo003o
oooo0`000_oo1@000_oo100000Coo`00000000;oo`8000;oo`800003ool0000000<002Coo`400000
00<00?ooool09?oo2P0000?oo`00ool00P0000Goo`0000000?oo00<00003ool00?oo00<000;oo`80
0003ool00000008000Koo`<00003ool0000000D001?oo`T00003ool0000001L000;oo`8000?oo`80
0004ool00?oo0002ool300000ooo003oo`02ool40002ool01000ooooo`000_oo1@0000?oo`00ool0
1?oo1@0000?oo`00000010000_oo10000_oo00<00?oo00000P0000?oo`0000000P0000?oo`000000
0`0000?oo`0000001`0000?oo`0000001P009Ooo0@0000000`00ooooo`0Tool>00000ooo0000000;
00001Ooo00000000ool0100000?oo`0000000`001?oo40005?oo6@000ooo00<00?ooool00`000ooo
00L00?ooool00?oo003oo`0200001Ooo00000000ool00P0000Ooo`0000000?oo003oo`0300000ooo
003oo`04ool200001?oo00000?oo1@0000Coo`00003oo`8000;oo`03003ooooo00T00003ool00000
01L002Koo`40000000<00?ooool09Ooo00<00?oo00001@0000Goo`0000000?oo00800004ool00000
ool700001Ooo00000000ool00P000ooo1@0000Coo`00000000Ooo`T00003ool00000008002Ooo`05
003oooooool00002ool20002ool00`00ool00006ool500001Ooo00000000ool00`0000?oo`00ool0
0`000_oo00<00?oo00000_oo0P0000Coo`00ooooo`<000?oo`04003ooooo0003ool02000oooooooo
003oo`00ool700000ooo0000000400001?oo00000?oo1P0000?oo`0000000`009ooo0@0000000`00
ooooo`0Wool700001Ooo00000000ool00P0000Goo`0000000?oo00@00003ool0000000;oo`800003
ool00000008000Coo`P000coo`@00003ool0000000/001Woo`<00004ool00000ool200001_oo0000
0?oo003oo`@00003ool00000008000;oo`04003oo`000004ool200001?oo003ooooo10000ooo00@0
0?oo003oo`8000Goo`@000?oo`03003oo`0000H00003ool00?oo00P00003ool0000000800004ool0
00000002ool8000Wool100000003003ooooo02Ooo`X00003ool0000000L00003ool0000000800003
ool0000000/000;oo`D00003ool0000000D000Woo`d00003ool0000001T00004ool00000ool40002
ool600000ooo003oo`07ool01P00oooooooo003oo`<000;oo`03003oo`0000;oo`04003oo`00ool3
00000ooo003oo`03ool30002ool:0004ool70003oolA000Xool100000003003ooooo02Sooa400005
ool00000003oo`080002ool500000ooo003oo`05ool;000CoolK00000ooo003oo`02ool20004ool0
0`00ool00003ool01@00oooooooo00000_oo00<00?ooool00ooo00@00?ooool000Coo`8000;oo`05
003oo`00003oo`0200000ooo003oo`03ool30002ool400000ooo003oo`020002ool00`00ooooo`02
00000ooo003oo`03ool00`00ooooo`0<00001?oo00000000:Ooo0@0000000`00ooooo`0Yool90000
0ooo0000000500000ooo0000000200001?oo00000?oo0P0000Coo`00000000Coo`03003oo`0000@0
00Ooo`@00003ool0000000H002Koo`800003ool0000000?oo`<00006ool00?oo003oo`000_oo0P00
0_oo1@0000?oo`00ool01?oo00@00?oo000000;oo`08003oo`00003oo`00ool000Goo`<00006ool0
0?ooool00?oo0P0000?oo`00ool00_oo0P0000?oo`0000000ooo200000?oo`0000000P0000?oo`00
00001P00:_oo0@0000000`00ooooo`0Yool00`00ool0000<00001Ooo00000000ool0100000?oo`00
0000100000Coo`00000000;oo`D00003ool0000000<000Koo`P00003ool0000000T001[oo`800003
ool0000000;oo`@00006ool00?oo003oo`000_oo0`0000?oo`0000001`0000Goo`0000000?oo0080
00;oo`03003ooooo00D00006ool00?oo003oo`000ooo00@00?oo003oo`<00005ool00000003oo`02
00001Ooo00000000ool02`0000Coo`00003oo`P002_oo`40000000<00?ooool0:ooo300000Coo`00
003oo`@00003ool0000000800004ool00000ool300001?oo000000001?oo1@0000Coo`00000000_o
o`/00003ool0000000H001;oo`03003oo`0000?oo`<000;oo`05003oooooool00002ool00`00ool0
0006ool01@00ool00000ool00P000_oo0P000_oo0P0000?oo`0000000`0000?oo`00ool00`0000Co
o`00ooooo`800005ool00?oo003oo`030004ool300000ooo00000002ool700001?oo00000?oo2000
;?oo0@0000000`00ooooo`0/ool:00000ooo003oo`0300001Ooo003oo`00ool00P0000Coo`00003o
o`8000;oo`L000Koo`<00003ool0000000@0013ooad000Coo`<00004ool00?ooool300001_oo003o
oooo003oo`800003ool0000000;oo`800004ool000000003ool600000ooo003oo`04ool500000ooo
000000060003ool00`00ooooo`0600000ooo000000050002ool;000]ool100000003003ooooo02co
o`03003oo`0000P00004ool00000ool200000ooo0000000200001?oo00000?oo0P0000Goo`000000
0?oo00@00003ool0000000<000Coo`H00003ool0000000H000oooaX00004ool00?oo0002ool30000
0ooo0000000200001?oo00000?oo0P0000Goo`0000000?oo00<00005ool00000003oo`0200000ooo
003oo`04ool500000ooo000000070004ool400000ooo0000000200000ooo000000040003ool;000^
ool100000003003ooooo02koo`/00004ool00000ool300001Ooo00000000ool00P0000Goo`000000
0?oo008000?oo`D00003ool0000000Soo`d001ooo`D000Coo`05003oo`00003oo`040005ool01P00
ooooo`00ool000Goo`8000;oo`800005ool00?ooool00002ool200001?oo003ooooo0`000ooo00<0
0?oo00001?oo20000ooo0P0000Koo`00ooooo`00ool600000ooo00000002000_ool100000003003o
oooo02ooo`T00003ool0000000800003ool0000000H00003ool0000000;oo`800003ool000000080
00Coo`800003ool0000000<000[ooa8001Coo`03003ooooo00?oo`800007ool00000ool00?oo0000
0_oo0P000_oo00<00?ooool01ooo00H00?ooool00?oo0002ool50002ool01000ool00?oo0P001?oo
10000ooo0`0000Coo`00000000Goo`800003ool0000000T00003ool000000080033oo`40000000<0
0?ooool0;ooo3@0000Coo`00003oo`<00003ool0000000800005ool00000003oo`0400000ooo0000
00020002ool500000ooo000000040008ool=00000ooo0000000F00000ooo003oo`020002ool01000
ool00?oo1P000ooo10000_oo00<00?ooool00`000_oo0`0000?oo`00ool00P0000Koo`00ool00?oo
0003ool40002ool300000ooo0000000200001?oo00000?oo5000<Ooo0@0000000`00ooooo`0aool3
00000ooo0000000300001?oo00000?oo0`0000?oo`0000000P0000?oo`0000000P0000?oo`000000
0ooo1`001Ooo1P0000Coo`00000001;ooaP00003ool00?oo00800003ool0000000;oo`8000;oo`@0
00;oo`@000;oo`08003oooooool00?oo003oo`8000Coo`8000?oo`03003oo`0000?oo`<000?oo`80
0003ool00000008000;oo`800003ool0000000<000;oo`D00003ool0000000D003;oo`40000000<0
0?ooool0<_oo1P0000Koo`0000000?oo0002ool200002?oo00000?oo003oo`00ool300000ooo0000
00020002ool300000ooo000000020007ool300000ooo00000007000Nool200001ooo003ooooo003o
o`0000?oo`05003oo`00ool00002ool01000ool000001?oo100000Goo`0000000?oo008000?oo`03
003oo`0000<00007ool00?ooool00?oo00001?oo0P0000Goo`0000000?oo00<00004ool00?ooool4
00000ooo0000000400000ooo00000005000cool100000003003ooooo03;oo`h00005ool00000003o
o`0300000ooo0000000:0002ool400000ooo000000030005ool900000ooo00000009000Bool20000
0ooo003oo`02ool00`00ool0000300000ooo003oo`0300000ooo0000000200001Ooo00000000ool0
0P0000?oo`0000000ooo00<00?ooool00P0000?oo`000000100000?oo`000000100000Woo`000000
0?oo003oo`00ool010000_oo5000=?oo0@0000000`00ooooo`0cool00`00ool0000900001Ooo0000
0000ool00`0000?oo`0000000P0000?oo`0000001@0000?oo`0000000P000_oo1@0000?oo`000000
10002?oo7`0000?oo`00ool00`0000?oo`0000000P0000?oo`00ool01@0000Coo`00003oo`T00005
ool00?oo003oo`0300001?oo00000?oo0`0000?oo`00ool0200000?oo`00ool00`000_oo1`0000?o
o`0000003@00=Ooo0@0000000`00ooooo`0eool900000ooo00000002ool00`00ool000020002ool0
0`00ool0000300001?oo003ooooo100000?oo`0000001Ooo2P003ooo500000?oo`00ool00`0000?o
o`0000001Ooo00<00?ooool00P001?oo00D00?ooool00?oo008000?oo`07003oo`00ool00?oo0000
0_oo00<00?ooool00ooo0`000ooo00L00?oo00000?oo003oo`020003ool40002ool00`00ooooo`02
00000ooo00000009000fool100000003003ooooo03Koo`T00003ool0000000@00005ool00000003o
o`030002ool00`00ool000020003ool200000ooo000000020006ool400000ooo00000006000Kool2
00000ooo003oo`02ool01P00ooooo`00ool000?oo`04003oooooool30002ool00`00ooooo`04ool0
1@00ool00000ool00P0000Koo`0000000?oo0002ool20004ool00`00ool00002ool40002ool30000
0ooo003oo`0300001?oo00000?oo0P0000?oo`0000001P00=ooo0@0000000`00ooooo`0fool00`00
ool0000;00000ooo0000000200001Ooo00000000ool01P0000?oo`0000000P0000?oo`0000000P00
00?oo`0000000`001Ooo200000?oo`0000002P003ooo00H00?oo003oo`00ool200001Ooo003oo`00
ool00`000ooo0`000_oo00<00?oo00000P000_oo0P0000Coo`00000000;oo`04003oo`00ool20002
ool00`00ool000030004ool30002ool300001?oo00000?oo0`0000?oo`0000003000>?oo0@000000
0`00ooooo`0hool600000ooo003oo`0200002_oo00000?oo003oo`00ool00?oo0`0000Coo`00oooo
o`H000Coo`D00004ool00000000:ool<00000ooo0000000<0002ool01000ool00?oo0P0000?oo`00
ool01@000_oo0P0000Koo`00ooooo`00ool30002ool20002ool00`00ool00002ool20002ool01@00
ool00000ool010001?oo0`000_oo0P0000Coo`00000000?oo`03003oo`0000d003Woo`40000000<0
0?ooool0>Ooo1P0000?oo`0000000P0000Soo`00003oo`00ool00?oo0`0000?oo`00ool00`000_oo
0P000_oo10001?oo0`0000?oo`00000010004?oo5@000ooo10000_oo00<00?oo00000P0000?oo`00
ool00P0000?oo`00ool01@0000?oo`0000000P0000?oo`0000000_oo00<00?oo00000`0000Goo`00
ooooo`0000;oo`8000;oo`800003ool0000000D000;oo`h003[oo`40000000<00?ooool0>Ooo3@00
00Goo`0000000?oo00<00003ool0000000<00003ool0000000800003ool0000000800003ool00000
008000?oo`H00003ool0000000H001Goo`H00004ool00?ooool200000ooo003oo`0200000ooo0000
000300000ooo0000000200001?oo00000?oo0P0000Koo`00003oo`00ool200001?oo00000?oo1P00
00?oo`000000100000Goo`0000000?oo00d00003ool0000000L003_oo`40000000<00?ooool0>_oo
2`0000Ooo`0000000?oo003oo`0500000ooo003oo`0400000ooo003oo`03ool400001?oo00000000
1_oo20000_oo1@004ooo0`000_oo0P0000Coo`00ool000;oo`03003oo`00008000?oo`800004ool0
0000ool500001?oo003oo`000_oo2@0000?oo`00ool0200000Coo`00000000?oo`D00003ool00?oo
00P003goo`40000000<00?ooool0??oo1P0000?oo`000000100000Goo`0000000?oo00@00004ool0
00000002ool00`00ooooo`040003ool300000ooo00000003000:ool500000ooo0000000B00000ooo
003oo`0300000ooo00000002ool30003ool40005ool20003ool01@00ool00000ool00`0000?oo`00
00001?oo0P0000Coo`00ooooo`<000;oo`800003ool00?oo00<00006ool00000ool00?oo2000?_oo
0@0000000`00ooooo`0mool00`00ool0000;00000ooo0000000200000ooo0000000200001Ooo0000
0000ool0100000?oo`0000000P000_oo1@0000?oo`0000001@002?oo500000Ooo`00ool00?oo003o
o`0200000ooo000000020003ool40002ool50003ool01@00ool00000ool01P0000Coo`00ooooo`D0
0005ool00000003oo`0300000ooo0000000600000ooo00000008000oool100000003003ooooo03oo
o`H00003ool0000000800003ool0000000800004ool00000ool500001?oo003oo`000_oo1P001_oo
1`0000Koo`0000000?oo000Gool00`00ool00003ool200001ooo00000000ool00?oo008000;oo`03
003ooooo00@00005ool00?ooool00002ool30002ool01000ool00?oo0P0000?oo`0000000`0000?o
o`00ool00_oo0`000_oo0P0000?oo`0000003@00@?oo0@0000000`00ooooo`10ool900000ooo003o
o`0200000ooo003oo`0300000ooo0000000200000ooo000000030002ool200000ooo000000040007
ool300000ooo0000000<000:ool400001?oo000000000_oo00D00?oo00000?oo00800005ool00?oo
003oo`020003ool200001?oo00000?oo0P0000?oo`00ool00`000_oo00L00?oo00000?oo003oo`03
0002ool300001?oo00000?oo0P0000?oo`0000002`00@Ooo0@0000000`00ooooo`10ool00`00ool0
000>00000ooo003oo`0300000ooo0000000400000ooo0000000800000ooo000000040005ool=0000
0ooo0000000;00001Ooo00000000ool0100000Coo`00003oo`@00003ool0000000D00006ool00000
ool00?oo0P0000?oo`0000000ooo00<00?oo0000200000Coo`00003ooa@004;oo`40000000<00?oo
ool0@ooo30000_oo00H00?oo003oo`00ool20002ool00`00ooooo`0400001?oo003oo`000ooo1P00
00?oo`0000000P003_oo300000?oo`0000000ooo0`000_oo100000?oo`0000000ooo1@0000Goo`00
ool00?oo00<00003ool0000000;oo`800003ool0000000D00003ool00?oo00X00003ool000000080
0003ool0000000@004Coo`40000000<00?ooool0A?oo1@0000?oo`0000001@0000Goo`00ool00?oo
00<00003ool00?oo00@000;oo`03003oo`0000D000Goo`@00003ool00?oo00P0013oo`04003oo`00
ool200001?oo003ooooo0`0000?oo`00ool00_oo10001_oo00<00?oo00000P0000Coo`00ooooo`<0
0005ool00000ool00002ool200001?oo00000?oo0`0000?oo`0000003P00AOoo0@0000000`00oooo
o`14ool00`00ool0000900001Ooo00000000ool00`0000?oo`00ool0100000?oo`0000001`0000?o
o`00000010000ooo00<00?oo00001`0000?oo`0000001P0000?oo`0000001`0000Goo`00003oo`00
00;oo`<00003ool00?oo00H000;oo`D000?oo`05003oo`00003oo`0600001?oo003ooooo1@0000?o
o`0000004P00A_oo0@0000000`00ooooo`16ool200000ooo0000000400000ooo00000002ool20000
0ooo0000000200000ooo0000000600000ooo0000000800000ooo0000000300000ooo003oo`05ool8
00000ooo000000090002ool00`00ool0000300000ooo003oo`0200001Ooo003oo`00ool01@0000?o
o`00ool00P000_oo0`000_oo00@00?oo003oo`H00004ool00?oo0002ool@0018ool100000003003o
oooo04Woo`P00003ool0000000H00003ool0000000800005ool00000003oo`0400000ooo00000004
ool500000ooo003oo`05000Aool300000ooo0000000400001_oo00000?oo003oo`@00007ool00?oo
003oo`00ool01@0000Koo`00003oo`00ool300000ooo0000000400000ooo003oo`0200001?oo0000
0?oo3000B_oo0@0000000`00ooooo`1:ool600001?oo00000?oo0P0000Koo`00003oo`00ool50000
1Ooo00000?oo00000_oo0`0000?oo`0000000`001Ooo1@0000?oo`000000200000?oo`0000002P00
00Koo`00ooooo`00ool200000ooo003oo`0400001Ooo003oo`00ool00P0000Coo`00003oo`@00004
ool00000ool200000ooo0000000400000ooo0000000?001<ool100000003003ooooo04coo`h00005
ool00000003oo`0400000ooo003oo`0400000ooo0000000800000ooo00000003ool:00000ooo0000
000700001_oo00000?oo003oo`800006ool00000ool00?oo200000Coo`00003oo`800003ool00000
00P00003ool0000000H00003ool0000000d004goo`40000000<00?ooool0COoo500000Coo`00003o
o`@00004ool00?oo0002ool500000ooo00000006000@ool01`00ool00000ool00?oo00800006ool0
0000ool00?oo0P0000?oo`0000000P000_oo00D00?oo003oo`0000?oo`<000;oo`<00005ool00000
ool00002ool60002ool9001?ool100000003003ooooo04koo`03003oo`0000P000;oo`<00003ool0
0000008000;oo`D00003ool00?oo00H000?oo`H00004ool00000ool600000ooo000000060002ool0
0`00ooooo`0300000ooo0000000200001ooo00000000ool00?oo00800003ool00?oo00800004ool0
00000002ool30002ool900000ooo0000000:001Aool100000003003ooooo053oo`800003ool00000
00L00003ool0000000800003ool0000000@00004ool00000ool600001?oo00000?oo10000_oo0P00
00?oo`000000100000?oo`0000005@0000?oo`00ool03@0000Koo`00003oo`00oolG001Bool10000
0003003ooooo05?oo`P00005ool00000003oo`0300001Ooo003oo`00ool00P0000?oo`00ool00`00
0_oo0P0000?oo`0000000P0000?oo`0000000`003_oo1P0000Koo`00003oo`00ool300000ooo003o
o`0=00001_oo00000?oo003ooaH005Coo`40000000<00?ooool0E?oo1P0000?oo`000000100000Ko
o`00003oo`00ool400001Ooo00000000ool01@001?oo1@000_oo1P0000?oo`0000001`0000Coo`00
ooooo`<00007ool00?oo003oo`00ool01P0000Coo`00000000;oo`05003oo`00003oo`0300000ooo
000000050002ool:001Fool100000003003ooooo05Goo`03003oo`0000d00003ool00000008000;o
o`800003ool0000000<000;oo`l00003ool0000000L00003ool0000001P00003ool00?oo00@00003
ool00000010005Soo`40000000<00?ooool0F?oo00<00?oo000020000_oo200000Coo`00003oo`<0
0003ool0000000P00003ool0000000@000Ooo`H00004ool00000ool600000ooo0000000=00001_oo
00000?oo003oo`@00003ool0000000P005Woo`80000000<00?ooool0Fooo00<00?oo000030000_oo
0P0000?oo`0000000P0000?oo`00ool01@000_oo00<00?oo00001@000_oo3P0000Ooo`00ool00?oo
003oo`0300000ooo003oo`0500000ooo003oo`0200000ooo0000000200000ooo0000000;001Kool1
0001ool100000003003ooooo05gooa<00003ool0000000L00003ool00?oo00800003ool000000140
0003ool0000000P00003ool0000000<00003ool0000000@00003ool00000010005koo`40000000<0
0?ooool0Gooo00<00?oo00002`000_oo1@0000?oo`00ool0100000Coo`00003oo`H00003ool00000
00<00007ool00000003oo`00ool0100000?oo`000000100000?oo`0000000`0000?oo`0000001000
00Coo`00003oo`d0067oo`40000000<00?ooool0H_oo00<00?oo0000400000?oo`0000000P0000?o
o`00ool00P0000?oo`000000100000?oo`00ool00_oo1@0000Coo`00ooooo`<00005ool00000003o
o`0=00001?oo00000?oo2`00I?oo0@0000000`00ooooo`1ToolC00000ooo0000000;00001Ooo003o
o`00ool0300000Goo`0000000?oo01`006Goo`40000000<00?ooool0J?oo0P0000?oo`0000004`00
00?oo`0000000`0000?oo`0000002P0000?oo`0000007@00JOoo0@0000000`00ooooo`1/ool00`00
ool0000?0002ool800001Ooo00000000ool08@00K_oo0@0000000`00ooooo`1`ool00`00ool00009
00000ooo0000000:00000ooo0000000M001cool100000003003ooooo07?oo`05003oo`00003oo`0_
001eool100000003003ooooo07[oo`05003oo`00003oo`0600001?oo00000?oo0`0000Coo`00003o
o`800005ool00000003oo`09001lool100000003003ooooo0?oooagoo`400000o`008@000000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0263022, -0.0250052, \
0.00366761, 0.00593432}},
  ImageSoundCache->{{{0, 287}, {176.938, 0}} -> GraphicsData["XSound", "\<\
001>8@40`e000@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@01o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@01007o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@01o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@01007o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@01007o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`400@0100400@0100400@01
00400@0100400@0100400@010@410@410@410@410@410@410@410@410@410@41
0@410@410@400@0100400@0100400@0100400@0100400@01o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1oP7n0Oh1oP7n0Oh1oP7n0Oh1oP7n0Oh1oP7n0Oh1oP7n0Oh1
oP7n0Oh1oP7n0Oh1oP7n0Oh1oP7n0Ol1o`7o0Ol1o`7o0Ol1o`7o0@0100400@01
00400@0100400@410@410@410@410@410@410@410@410@410@420@810P420@81
0P420@810@410@410@410@410@410@410@410@4100400@0100400@0100400Ol1
o`7o0Ol1o`7o0Oh1oP7n0Oh1oP7n0Oh1oP7n0Od1o@7m0Od1o@7m0Od1o@7m0Od1
o@7m0Od1o@7m0Od1o@7m0Od1o@7m0Oh1oP7n0Oh1oP7n0Oh1oP7o0Ol1o`7o0Ol1
o`400@0100400@010@410@410@410@410P420@810P420@810P420@810`430@<1
0`430@<10`430@<10`430@810P420@810P420@810P410@410@410@410@400@01
00400@01o`7o0Ol1o`7n0Oh1oP7n0Oh1o@7m0Od1o@7m0Od1o07l0O`1o07l0O`1
o07l0O`1o07l0O`1o07l0O`1o07l0O`1o07l0O`1o@7m0Od1o@7m0Oh1oP7n0Oh1
oP7o0Ol1o`400@0100400@410@410@410P420@810P420@<10`430@<10`440@@1
10440@@110440@@110440@@110440@@110440@<10`430@<10`430@810P420@81
0@410@4100400@01o`7o0Ol1o`7n0Oh1oP7m0Od1o@7m0O`1o07l0O`1n`7k0O/1
n`7k0O/1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O/1n`7k0O/1n`7k0O`1o07l0Od1
o@7m0Od1oP7n0Oh1o`7o0@0100400@410@410@810P420@<10`430@@110440@@1
1@450@D11@450@D11P460@H11P460@H11P460@D11@450@D11@450@@110440@@1
0`430@<10P420@810@410@01007o0Ol1o`7n0Oh1o@7m0Od1o07l0O`1n`7k0OX1
nP7j0OX1n@7i0OT1n@7i0OT1n@7h0OP1n07h0OP1n@7i0OT1n@7i0OT1nP7j0OX1
nP7k0O/1o07l0O`1o@7m0Oh1oP7o0Ol100400@010@410@810P430@<110440@@1
1@450@H11P460@H11`470@L11`470@L120480@P120470@L11`470@L11`460@H1
1P460@D11@440@@110430@<10P420@410@400Ol1o`7n0Oh1o@7m0O`1o07k0O/1
nP7j0OT1n@7i0OP1n07h0OL1m`7g0OL1m`7g0OH1mP7f0OH1m`7g0OL1m`7g0OL1
n07h0OP1n@7i0OX1nP7j0O/1n`7l0Od1o@7n0Oh1o`400@010@410@810P430@@1
10450@D11P460@L11`480@P120490@T12@490@T12@4:0@X12P4:0@T12@490@T1
2@490@P120470@L11`460@H11@450@@10`430@810@410@01o`7o0Oh1o@7m0O`1
o07k0OX1nP7i0OT1n07h0OL1m`7f0OH1mP7e0OD1m@7e0O@1m07d0O@1m07d0OD1
m@7e0OD1mP7f0OH1m`7g0OP1n07i0OT1nP7k0O/1o07m0Od1oP7o0Ol100410@81
0P430@@11@450@H11`470@P120490@T12P4:0@/12`4;0@/1304<0@`1304<0@`1
304<0@/12`4;0@X12P4:0@T12@480@P11`460@H11@440@<10`420@4100400Ol1
oP7m0O`1n`7k0OX1n@7h0OP1m`7f0OH1m@7e0O@1m07c0O<1l`7b0O81lP7b0O81
lP7b0O81lP7c0O<1l`7c0O@1m07e0OD1mP7g0OL1n07i0OX1nP7k0O`1o@7n0Ol1
o`400@410P430@@11@460@H11`480@T12@4:0@/12`4<0@`13@4=0@d13P4>0@h1
3P4>0@h13P4>0@h13P4=0@d13@4<0@`12`4:0@X12@480@P11`460@D110430@81
0@400Ol1o`7n0Od1o07k0OX1n@7h0OL1mP7f0OD1m07c0O<1lP7b0O41l@7`0O01
l07`0O01l07`0O01l07`0O01l@7a0O41lP7b0O<1m07d0OD1mP7g0OP1n@7i0OX1
n`7l0Od1oP400@410P430@@11@460@L120490@T12P4;0@`13@4=0@h13P4?0@l1
404@0A014@4A0A414@4A0A41404@0A013`4?0@h13P4=0@`1304;0@X12@480@L1
1P450@@10`420@41o`7n0Od1o07k0OX1n@7h0OL1mP7e0O@1l`7b0O41l@7`0Nl1
k`7^0Nh1kP7]0Nd1k@7]0Nd1k@7]0Nd1kP7^0Nl1k`7`0O01l@7b0O<1l`7d0OD1
mP7g0OP1nP7k0O`1o@7n0@010@420@<110450@L120490@X12`4<0@d13P4?0@l1
404A0A414P4B0A<14`4C0A<14`4C0A<14`4C0A<14P4B0A41404@0@l13P4=0@`1
2`4:0@T120470@H11@430@810@7o0Oh1o@7l0OX1n@7h0OL1mP7d0O<1lP7a0O01
k`7_0Nh1k@7/0N`1j`7[0N/1j`7Z0NX1jP7Z0N/1j`7[0N`1k07]0Nd1kP7_0O01
l@7b0O<1m07e0OH1n07i0OX1n`7m0Oh100410@8110450@H120490@X12`4=0@h1
3`4@0A414P4B0A<1504D0AD15@4F0AH15P4F0AH15P4F0AD15@4E0A@14`4C0A81
4@4@0@l13P4=0@`12`490@P11`450@@10P410Ol1oP7m0O/1nP7h0OL1mP7d0O<1
lP7a0Nl1kP7]0N`1k07[0NX1j@7Y0NP1j07X0NP1j07X0NP1j07X0NT1j@7Z0NX1
j`7/0Nd1kP7_0O01l@7b0O@1m@7g0OP1n@7k0O`1oP7o0@410`440@H11`490@X1
2`4=0@h13`4A0A814`4D0AD15@4F0AL15`4H0AP16@4I0AT16@4I0AP1604H0AL1
5`4F0AD1504C0A814@4@0@l13@4<0@X12@470@H110430@41o`7n0O`1n`7i0OL1
mP7d0O<1l@7`0Nl1k@7/0N/1jP7Y0NP1j07W0NH1iP7U0ND1i@7U0ND1i@7U0NH1
iP7W0NL1j07Y0NX1j`7/0Nd1kP7`0O41lP7d0OD1m`7i0OX1o07n0@010@430@D1
1P480@X12`4=0@h1404A0A81504E0AH15`4H0AT16@4J0A/16`4K0A/1704L0A/1
6`4K0AX16P4I0AP15`4F0AD1504C0A81404?0@d1304:0@P11`450@<10@7o0Oh1
o07j0OP1m`7e0O<1lP7`0Nh1k@7/0NX1j@7X0NL1iP7U0N@1i07S0N<1hP7R0N81
hP7R0N81h`7S0N@1i@7V0NH1i`7Y0NX1j`7/0Nh1k`7a0O<1m07f0OP1nP7l0Oh1
00410@<11@470@T12`4<0@h1404A0A<1504F0AL1604I0AX16`4L0Ad17@4N0Ah1
7P4N0Ah17P4N0Ad17@4L0A`16`4J0AT1604F0AD14`4B0A013`4=0@/12@470@D1
0`410Ol1oP7l0OX1n07f0O@1lP7`0Nh1k@7[0NX1j07W0NH1i07S0N81hP7Q0N01
h07P0Ml1g`7O0Ml1h07P0N41h@7R0N<1i07U0NH1j07Y0N/1k07^0O01lP7c0OD1
m`7i0O/1o@400@8110460@P12P4<0@h13`4A0A<15@4F0AP16@4J0A`17@4N0Al1
7`4P0B018@4Q0B418@4Q0B41804P0Al17P4M0A`16`4J0AP15`4E0A@14P4@0@h1
304:0@P11P440@81o`7m0O/1n@7g0OD1l`7a0Nl1k@7[0NT1j07V0ND1h`7R0N41
h07O0Mh1gP7M0Md1g@7L0M`1g@7M0Md1gP7O0N01h@7R0N<1i07V0NL1j@7[0N`1
kP7`0O81m07g0OT1n`7m0@010P440@H1204;0@d13`4A0A<15@4F0AP16P4K0Ad1
7P4O0B018@4R0B<18`4T0B@1904T0B@18`4S0B818P4Q0B017P4M0A`16P4I0AL1
5@4C0A413`4=0@/12@460@@10P7o0Od1n`7i0OH1m07b0O01k@7[0NT1j07V0N@1
h`7Q0N01g`7M0M`1g07K0MX1fP7J0MX1fP7J0MX1f`7K0M`1g@7N0Ml1h@7R0N@1
i@7W0NT1j`7]0Nl1l@7d0OH1n07k0Od100420@@11`490@/13P4@0A81504F0AP1
6P4L0Ah17`4P0B818`4T0BD19@4V0BH19`4W0BL19P4V0BH19@4T0B<18P4Q0Al1
7P4L0A/16@4G0AD14`4@0@h130490@L110420@01o@7j0OP1mP7c0O41kP7/0NX1
j07V0N@1hP7P0Ml1g@7L0M/1fP7I0MP1f07G0ML1e`7G0ML1f07H0MT1fP7K0M`1
g@7N0N01hP7S0ND1i`7Y0N`1kP7`0O<1m@7h0OX1o@400@811@470@X1304?0A41
504F0AP16P4L0Ah1804Q0B<1904U0BH19`4X0BT1:@4Y0BX1:@4Y0BT1:04X0BL1
9P4U0B<18P4P0Ah17@4K0AP15P4D0A813`4=0@X11`450@81o`7m0OX1m`7e0O81
l07]0N/1j07V0N@1hP7P0Mh1g@7K0MX1f07G0MH1eP7E0MD1e07D0M@1e07E0MD1
eP7G0MP1f@7K0M`1gP7P0N81i07V0NP1jP7]0Nl1lP7e0OL1nP7m0@010P450@P1
2P4=0A014P4E0AL16P4L0Ah1804R0B<19@4W0BP1:@4Z0B/1:`4/0B`1;04/0B`1
;04[0BX1:@4X0BL19P4T0B81804N0A`16P4H0AD14`4@0@h12`480@D10P7o0Od1
nP7g0O@1l@7_0N`1jP7W0ND1hP7P0Mh1g07J0MT1e`7F0MD1e07C0M81dP7A0M41
d@7B0M81d`7D0M@1eP7G0MP1fP7L0Mh1h07R0N@1i`7Y0N`1kP7a0O@1m`7j0Od1
o`420@D1204;0@h14@4D0AH16@4K0Ah1804R0B@19P4W0BT1:P4[0Bd1;@4^0Bl1
;`4_0Bl1;`4^0Bh1;@4/0B/1:@4X0BH1904R0B017P4L0AT15`4D0A413P4;0@T1
1P430Ol1o07i0OH1m07a0Nh1j`7X0NH1h`7Q0Mh1g07J0MP1eP7E0M@1dP7A0M01
d07?0Ll1c`7?0Ll1c`7@0M41dP7C0MD1eP7H0MX1g07N0N01h`7U0NP1j`7]0O01
l`7f0OT1o0400@<11P490@`13`4B0AD15`4J0Ad17`4R0B@19P4X0BX1:`4]0Bh1
;`4`0C41<@4b0C81<P4a0C41<04_0Bh1;@4/0BX1:04V0B@18P4P0Ad16`4H0AD1
4P4?0@`12@460@<1o`7l0OT1mP7c0O01k@7Z0NL1i07Q0Ml1g@7J0MP1eP7D0M<1
d@7@0Ll1cP7=0L`1c07<0L`1c07=0Lh1cP7@0M41dP7D0MH1f07J0M`1gP7Q0N@1
iP7Y0N`1k`7c0OH1n@7l0@010`460@T1304@0A<15P4I0A`17P4Q0B<19P4X0BX1
;04^0Bl1<04b0C<1<`4d0C@1=04d0C@1<`4c0C81<@4_0Bh1;04Z0BP19P4T0B41
7`4L0AT15P4C0A013@490@H10`400O`1n@7e0O81k`7/0NT1iP7S0N01g@7K0MP1
eP7D0M81d07?0Ld1c07;0LX1bP7:0LT1bP7:0LX1b`7<0Ld1cP7@0M81e07F0MP1
fP7M0Ml1hP7U0NP1j`7_0O81m@7i0O`1o`430@H12P4=0A01504G0AX17@4P0B<1
9@4X0BX1;04^0C01<@4c0C@1=@4f0CH1=`4g0CL1=P4f0CD1=04c0C81<04^0B`1
:P4X0BH18`4P0Ad16P4G0A@14@4=0@X11`430Ol1o07h0OD1lP7^0N/1j07T0N41
gP7L0MT1eP7D0M81d07>0L`1b`7:0LT1b0770LL1a`770LL1b0790LX1b`7<0Lh1
c`7A0M@1eP7I0M/1gP7Q0N@1i`7Z0Nh1l@7e0OP1o0400@<11`4:0@h14@4E0AP1
6`4N0B41904W0BT1;04^0C01<P4d0CD1=P4g0CP1>@4i0CT1>@4i0CP1>04g0CD1
=04b0C41;`4/0BX19`4U0B817`4L0AP15@4B0@h12P470@<1o`7l0OP1m@7a0Nd1
jP7W0N<1h07M0MX1e`7E0M81d07>0L`1bP790LL1aP750LD1a0740L@1a@750LH1
a`780LX1b`7=0Ll1dP7D0ML1fP7M0N01h`7V0NX1k@7a0O@1n07l0@010`470@/1
3P4B0AH16@4L0B018`4V0BT1:`4^0C01<P4d0CH1>04i0CX1>`4k0C`1?04l0C/1
>`4j0CT1>04f0CD1<`4a0Bh1;04Y0BH18`4P0Ad16@4F0A813`4;0@L10`400O`1
n07d0O01k@7Y0ND1hP7O0M/1f07F0M<1d07>0L`1bP780LH1a@740L<1`P720L81
`P720L<1a0750LH1b0790L/1c@7@0M81e@7H0M/1gP7R0ND1j@7/0O01m07h0O`1
00430@L12`4?0A<15P4J0Ah18@4T0BL1:P4]0C01<P4d0CH1>04j0C/1?04m0Ch1
?P4n0Ch1?P4m0C`1>`4j0CT1=`4e0C<1<04^0B/1:04U0B417P4J0AL14`4?0@/1
1`430Ol1o07h0O@1l07/0NP1i07Q0Md1fP7G0M@1d@7>0L`1bP780LH1a0730L81
`@700L01_`700L01`@710L81a0750LL1b@7<0Lh1d@7C0MH1fP7M0N01i07X0N`1
k`7c0OL1n`400@@1204<0A01504G0A/17`4R0BH1:@4/0Bl1<P4d0CH1>04j0C`1
?@4o0Cl1@0510D41@@500D01?`4n0C`1>`4i0CL1=04b0Bl1;04Y0BH18`4O0A/1
604D0A0130480@@1o`7k0OL1l`7_0N/1i`7S0N01g07I0MD1dP7?0Ld1bP780LD1
a0720L01_`6n0Kh1_@6m0Kd1_P6n0Kl1`0720L<1a@770LX1c07?0M81e@7H0M`1
g`7S0NL1j`7_0O<1m`7k0Ol110480@`1404D0AP1704P0B<19`4Z0Bh1<@4c0CH1
>04k0C`1?P500D41@P520D<1@`530D<1@P510D01?P4m0C/1>@4f0C@1<@4^0B/1
9`4T0B01704I0AD1404<0@P1107o0O/1m`7c0Nl1jP7V0N81g`7K0ML1e07A0Lh1
b`780LH1``710L01_P6m0K`1^`6k0K/1^`6k0K`1_@6n0Kl1`@730LD1b07:0Ld1
d07D0ML1fP7N0N81iP7Z0Nh1l`7g0O/100440@P1304A0AD16@4M0B419@4X0B`1
;`4b0CD1>04j0Cd1?`500D81@`540DD1A@550DD1A@540D<1@P510Cl1?@4k0CP1
=@4c0C01;04Y0BD18@4M0AT15@4A0@d120440Ol1n`7g0O81kP7Z0NH1h@7N0MX1
eP7B0Ll1c0790LH1a0710Kl1_P6l0K/1^P6i0KT1^@6i0KT1^P6k0K`1_@6o0L41
``760LT1c07?0M81eP7I0Md1h@7U0NT1kP7b0OL1n`400@@1204=0A415P4J0Ah1
8P4V0BX1;@4a0C@1=`4j0C`1?P510D81A0550DH1A`570DP1A`570DH1A@540D<1
@@4o0Cd1>P4g0C@1<@4^0BX19P4R0Ah16P4F0A813@490@@1007k0OH1lP7]0NT1
i@7Q0M`1f07E0M41cP7:0LL1a0720L01_@6l0KX1^@6h0KL1]`6f0KH1]`6h0KT1
^P6k0Kd1_`720L@1a`7:0Ld1d@7D0MP1g07P0N@1j@7]0O81mP7k0@0110490@d1
4P4F0A/17`4S0BL1:`4_0C81=@4i0C/1?P500D<1A0560DL1B0590DX1BP5:0DT1
B0570DH1A@530D41?P4l0CT1=P4c0Bl1:`4W0B<17`4K0AL14P4=0@T1107o0O/1
mP7a0Nd1j07T0N01f`7G0M<1d07<0LT1aP730L01_P6l0KX1^06g0KH1]@6d0K@1
]06e0KD1]P6h0KT1^`6m0L01`P750LP1c07?0M<1e`7K0Ml1i07X0Nd1l@7f0O/1
00440@T13P4B0AL16`4P0B@1:04/0C01=04g0CX1?@500D81A0560DP1B@5:0D/1
C05<0D`1B`5;0DX1B0570DD1@`500Cd1>`4g0C@1<04]0BT1904P0A`15`4C0@h1
2@440Ol1n`7f0O41k07X0N<1g`7J0MH1dP7>0L/1a`740L41_P6l0KX1^06f0KD1
]06c0K81/P6b0K<1/`6d0KH1]`6i0K`1_P710L@1a`7:0Lh1dP7F0MX1gP7S0NL1
k07a0OH1n`400@@12@4>0A<1604L0B419@4Y0Bd1<@4e0CP1?04o0D81A0560DP1
BP5;0D`1C@5>0Dh1CP5=0Dd1C05:0DT1A`540D81?`4l0CT1=@4b0Bh1:P4U0B41
7@4H0A<13P490@@1007k0OH1l@7/0NL1hP7N0MT1e@7A0Ld1b@760L81_`6m0KX1
^06f0K@1/`6b0K41/06`0K01/@6a0K81]06f0KP1^P6l0Kl1`P750LT1c@7A0MD1
f@7N0N81i`7/0O41m@7j0@011@4:0@h14`4H0Ad18P4V0BX1;`4c0CH1>P4m0D01
@`560DP1BP5<0Dd1CP5?0E01D05@0Dl1C`5=0D`1BP580DH1A0510Ch1>P4g0C<1
;`4[0BH18P4M0AP1504?0@X11@7o0OX1m@7`0N/1iP7R0Md1f07D0M01c0780L@1
`@6n0K/1^06f0K@1/P6a0K01[`6^0Jh1[P6_0Jl1/@6b0K@1]P6h0K/1_@710L@1
b07;0Ll1e07H0Md1h@7V0N/1l07e0OX100450@X13`4D0AT17P4R0BL1:`4`0C@1
>04k0Cl1@P550DP1BP5<0Dh1C`5@0E41DP5B0E81D@5@0Dl1CP5<0DX1B0550D81
?`4l0CP1=04`0B`19`4S0Ah16@4D0@l12P450Ol1nP7e0O01j`7V0N41g07H0M<1
c`7;0LL1``6o0K`1^@6g0K@1/P6`0Jl1[P6]0J`1[06/0Jd1[P6_0K01/P6d0KH1
^@6l0Kl1``760LX1cP7C0ML1g07Q0NH1j`7`0OD1nP7o0@D12P4?0A@16@4N0B<1
:04]0C41=@4i0Cd1@0540DL1B@5<0Dh1D05A0E81D`5D0E@1E05C0E81D@5@0Dh1
C0590DL1A0510Cd1>@4e0C41;@4X0B@17`4J0AD13`4:0@D1o`7j0OD1l07Z0ND1
h07K0ML1dP7>0LT1a@720Kh1^`6h0KD1/`6`0Jl1[@6/0J/1ZP6Z0JX1Z`6/0Jd1
[P6`0K81]@6g0KX1_P710LD1b@7=0M81eP7K0N01i@7Z0Nl1m@7j0@011@4:0A01
5@4J0Al1904Y0Bh1<P4f0CX1?P520DD1B05;0Dd1C`5A0E<1E05E0ED1EP5E0ED1
E05C0E81D05>0D/1B0550D81?P4k0CL1<P4^0BT1904O0AX15@4@0@X11@7o0OX1
m@7_0NX1i@7P0M/1eP7A0L`1b0740L01_@6i0KH1/`6a0Jl1[@6[0JX1Z@6Y0JP1
Z@6Y0JX1Z`6]0Jh1/@6c0KH1^@6l0L01a0780L`1d@7E0MX1g`7T0NX1k`7e0OX1
00450@X1404E0A/1804U0BX1;P4c0CL1?04o0D<1A`5:0D`1C`5A0E<1E@5F0EL1
E`5G0EL1E`5F0ED1D`5A0Dl1C@5:0DL1@`500C`1>04c0Bl1:P4U0B016`4E0A01
2`450@01nP7d0Nl1j@7T0Ml1fP7E0M01b`770L<1_`6k0KP1]@6b0Jl1[@6[0JX1
Z06W0JL1Y`6W0JL1Z06Y0J/1[@6_0K81]06g0K/1_`730LL1b`7@0MD1fP7O0N@1
j@7_0O@1nP7o0@D12`4@0AH16`4P0BH1:`4_0C@1>@4m0D41A0580D/1CP5A0E<1
E@5F0EP1F05I0ET1F@5I0EP1EP5E0E<1D@5>0D/1B0550D41?@4i0C@1<04[0BH1
8@4K0AH1404;0@D1o`7j0O@1k`7Y0N@1gP7I0M@1c`7:0LH1`P6n0KX1]P6c0K01
[P6[0JT1Z06W0JH1Y@6U0JD1YP6V0JP1Z@6[0Jd1/06c0KH1^P6m0L41aP7:0Ll1
e07I0Mh1h`7Y0Nh1m07j0@011@4;0A415P4L0B419P4[0C01=@4j0Ch1@P560DT1
C@5?0E81E05F0EP1F@5J0E/1F`5K0EX1F@5H0EL1E@5B0E01C@5:0DH1@P4n0CX1
=@4a0B`19`4Q0A`15P4A0@/11@7o0OX1m07^0NT1h`7N0MP1d`7>0LT1a@700K`1
^@6e0K81[`6/0JX1Z06V0JD1Y06S0J<1X`6T0JD1YP6X0JX1[06_0K41]@6h0K`1
`0750LT1cP7C0MP1g@7S0NP1kP7d0OX1o`450@/14@4G0A`18P4W0B`1<@4f0C/1
?`530DL1B`5>0E41E05F0EP1FP5K0E`1G05M0E`1G05K0EX1F05F0E@1D@5>0D/1
A`530Cl1>`4f0C81;04W0B81704G0A412`450@01nP7d0Nh1j07S0Md1f07B0Ld1
b0740Kl1^`6g0K@1/06]0J/1Z06V0JD1X`6R0J81XP6R0J81X`6T0JH1Z06Z0Jd1
/06c0KL1^`6o0L@1b07=0M81e`7M0N81j07^0O@1nP400@D12`4A0AL17@4R0BP1
;@4b0CL1?0500D@1B05<0Dl1DP5E0EL1F@5K0E`1G@5N0Eh1GP5M0Ed1F`5J0EP1
E@5C0E01C0590DD1@04l0CL1<P4]0BP18P4M0AL14@4;0@D1o`7j0O@1kP7X0N81
g07G0M81c0780L<1_P6j0KH1/P6_0J`1Z@6W0JD1X`6R0J41X06P0J01X@6R0J<1
Y@6W0JT1[06_0K81]P6j0Kh1`P770L`1d@7G0M`1hP7X0Nh1l`7i0@011P4<0A41
5`4M0B<1:04^0C<1>04m0D41AP5:0Dd1D@5D0EH1F@5K0Ed1GP5O0F01H05P0El1
GP5M0E/1F@5G0E@1D@5=0DX1AP520Cd1>04c0Bh1:@4S0Ad1604B0@`11P7o0OT1
l`7]0NL1hP7L0MH1d@7<0LL1`P6m0KT1]@6a0Jh1Z`6X0JD1X`6R0J01W`6O0Ih1
W`6O0J01X@6S0JD1Z06Z0Jd1/@6e0KT1_@720LH1b`7A0MH1g07Q0NL1k@7c0OT1
o`460@`14P4H0Ah18`4Y0Bh1=04i0Ch1@P570D/1CP5B0ED1F05J0E`1GP5P0F01
H@5Q0F41H@5P0Eh1G@5J0EP1E@5B0Dl1B`570D<1?P4i0C@1;`4Y0B@17P4H0A81
30460Ol1n@7c0Nd1i`7Q0M/1eP7@0L/1aP710K`1^06d0K01[06Y0JH1Y06R0J01
W`6N0Id1W@6M0Ih1W`6P0J81Y06V0JT1[06`0K<1^06l0L41a@7;0M01e@7K0N41
i`7]0O<1n@400@H1304B0AP17P4T0BX1;`4e0CX1?`530DP1C05@0E<1EP5I0E`1
GP5P0F41HP5S0F<1H`5R0F41H05N0E`1F@5G0E<1D05<0DP1A04o0CX1=@4_0BX1
904N0AP14P4<0@H1o`7i0O<1k@7W0N41f`7E0Ll1bP750L01^`6g0K<1[`6[0JP1
Y@6S0J01W`6M0I`1W06L0I`1W06M0Il1X06R0JD1Z06[0Jl1/P6f0K/1`0750LX1
c`7E0M/1h@7W0Nd1l`7i0@011P4<0A81604O0B@1:P4`0CD1>`500D@1B@5=0E41
E05H0E/1G@5O0F41HP5S0F@1I05T0F<1HP5Q0El1G@5K0EP1E@5A0Dd1B@550D01
>`4f0C01:P4U0Al16@4B0@`11P400OT1l`7]0NH1h07J0M@1c`790L@1_`6j0KH1
/P6^0JX1Y`6T0J41W`6M0I`1V`6J0IX1VP6K0I`1W@6O0J41Y06W0JX1[@6a0KD1
^P6o0L@1b@7?0M@1fP7P0NH1k07c0OT100460@`14`4I0Al19@4[0C41=P4k0D01
A@5:0Dh1DP5F0ET1G05N0F41HP5T0FD1I@5V0FD1I@5T0F81H@5N0E`1F@5F0E81
CP5:0DD1@@4l0CH1<@4[0BD17`4I0A<130460Ol1n@7c0N`1iP7P0MX1e07>0LT1
``6n0KT1]@6`0J`1Z@6V0J<1X06N0I`1V`6J0IT1V@6I0IX1V`6L0Ih1X06R0JD1
Z@6/0K01]06i0Kh1``780Lh1e07J0N01iP7/0O<1n@400@H1304C0AT17`4U0B/1
<@4g0C`1@@560D/1C`5C0EL1FP5M0F01HP5T0FD1IP5W0FL1I`5V0FD1I05R0F01
G@5J0EL1D`5?0D/1AP520C`1=`4a0B`19P4P0AT14`4<0@H1o`7i0O81k07V0Ml1
f@7C0Ld1b0720Kd1^06d0Jl1Z`6X0J@1X@6O0Id1V`6I0IP1V06G0IP1V06I0I/1
W06O0J41Y06X0J/1[`6d0KP1_@720LP1c@7C0MT1g`7V0N`1lP7i0Ol11P4=0A<1
6@4P0BH1;04b0CP1?@520DL1C05@0E@1F05K0Eh1H@5S0FD1IP5W0FP1J05X0FL1
IP5U0F<1H@5N0E/1F05D0E01C0570D81?@4h0C81;04V0B016P4C0@d11P7o0OT1
lP7/0ND1g`7I0M<1c@770L81_06g0K<1[P6Z0JL1X`6P0Ih1V`6J0IP1U`6F0IH1
UP6G0IP1V@6K0Id1X06S0JH1ZP6^0K<1]`6l0L41a`7=0M<1f@7O0ND1k07b0OT1
00460@d14`4J0B019P4]0C81>04n0D<1B05=0E41E@5I0E`1G`5R0F@1IP5X0FT1
J@5Y0FT1J@5X0FH1I05R0El1G05I0ED1D@5=0DP1@`4n0CP1<`4]0BL1804J0A<1
3@460Ol1n@7b0N`1i@7O0MP1dP7<0LH1`@6l0KL1/P6]0JT1YP6R0Il1W06J0IP1
U`6F0ID1U@6E0IH1U`6H0IX1W06O0J81Y@6Y0Jd1/P6f0K/1`@760L`1dP7H0Mh1
i@7[0O81n@400@H13@4D0AX18@4W0Bd1<`4i0Ch1A0590Dh1DP5F0EX1G@5P0F<1
I@5W0FT1JP5Z0F/1J`5Z0FT1I`5V0F<1H@5N0EX1EP5B0Dh1B@540Cl1>@4c0Bd1
9`4Q0AX1504=0@H1007i0O81j`7U0Mh1f07B0L`1aP700K/1]P6a0Jd1Z06U0J41
WP6K0IT1U`6F0ID1U06D0I@1U@6F0IL1V@6K0Ih1X@6T0JP1[06a0KH1^`700LH1
b`7B0MP1gP7U0N/1lP7i0@011P4=0A@16P4Q0BL1;P4d0CT1?`540DX1CP5C0EL1
F`5N0F41I05W0FP1JP5[0F`1K05/0F/1JP5Y0FL1I05R0El1F`5G0E<1C`5:0DD1
?`4j0C@1;P4W0B416`4D0@d11P7o0OT1lP7[0N@1gP7G0M41b`750L01^P6e0K01
[06W0J@1X06M0IX1V06F0ID1T`6C0I<1T`6C0I@1UP6H0IX1W@6P0J<1Y`6[0K01
]@6j0Kl1a@7;0M41e`7N0N@1j`7b0OT100460@d1504K0B41:04^0C@1>P500DD1
BP5?0E@1F05L0El1H`5U0FP1JP5[0F`1K@5]0Fd1K05[0FX1J05U0F<1H05L0EP1
E05?0D/1A@500CX1=04^0BP18@4K0A@13@460Ol1n@7b0N/1i07N0ML1d@7;0LD1
_`6i0K@1[`6[0JL1X`6O0I`1V@6G0ID1T`6B0I81T@6B0I81T`6E0IL1V@6L0Il1
XP6V0J/1[`6d0KT1_`740LX1d@7G0Md1i07[0O81n@400@H13@4D0A/18P4X0Bl1
=@4k0D01AP5;0E01E@5I0Ed1H05T0FH1J@5[0F`1K@5^0Fh1KP5]0F`1J`5Y0FH1
I05Q0Ed1F@5E0E01B`560D41>`4e0Bl1:04R0A/1504=0@H1o`7i0O81j`7T0Md1
e`7@0LX1a06n0KT1/`6_0JX1YP6R0Ih1V`6H0IH1U06B0I41T@6@0I41T@6B0I@1
UP6H0I/1WP6R0JD1ZP6^0K<1^@6n0L@1bP7@0MH1g@7T0N/1lP7i0@011P4=0A@1
6`4R0BT1;`4e0C/1@@570D`1D@5E0EX1GP5Q0FD1I`5Z0F`1K@5^0Fl1K`5_0Fh1
K@5/0FX1I`5U0F41GP5J0EH1D@5<0DL1@@4k0CD1;`4Y0B816`4D0@h11`400OP1
l@7[0N@1g@7F0M01bP730Kh1^06c0Jh1Z@6U0J41W@6J0IL1U@6C0I41T06@0Hl1
S`6@0I41T`6E0IL1VP6M0J41Y@6Y0Jh1/`6h0Kd1``790M01eP7M0N@1jP7a0OP1
00470@h15@4K0B81:@4_0CH1?0520DL1C@5B0EH1F`5O0F81I@5X0F/1K@5^0Fl1
L05`0G01K`5^0Fd1J`5X0FH1HP5O0E/1EP5B0Dd1A`520C`1=P4`0BT18P4L0AD1
3P470Ol1n07a0NX1h`7M0MH1c`790L<1_@6g0K81[@6X0J@1X06L0IT1UP6D0I81
T06?0Hh1SP6>0Hl1T06B0I@1UP6I0I`1X06T0JP1[@6b0KL1_@730LT1c`7F0M`1
h`7Z0O41n0400@L13P4E0A`18`4Y0C01=P4l0D81B05=0E81E`5K0El1H`5V0FT1
K05^0Fl1L05a0G41L@5`0Fl1KP5/0FT1IP5S0F01G05G0E81C@580D81?@4f0C01
:@4S0A`15@4>0@L1o`7h0O41jP7S0M`1eP7?0LT1`P6l0KL1/@6/0JP1X`6O0I/1
V06E0I<1T@6?0Hh1SP6=0Hh1SP6?0I41T`6E0IP1V`6O0J<1Y`6/0K41]`6l0L81
b07?0MD1g07S0NX1l@7h0@011`4>0AD1704S0BX1<04g0Cd1@`590Dh1D`5H0E`1
H05T0FL1JP5]0Fl1L05a0G81LP5b0G41L05_0Fd1JP5W0F@1H05L0EP1D`5>0DT1
@`4m0CL1<04Z0B<1704E0@h11`7o0OP1l@7Z0N<1g07E0Ll1b0720K`1]P6a0J`1
Y`6R0Ih1V`6G0I@1TP6@0Hh1S@6=0H`1S@6=0Hh1T06B0I@1U`6K0Ih1XP6W0J/1
/@6f0K`1`P780Lh1e@7L0N<1jP7a0OP100470@h15@4L0B<1:P4a0CL1?@530DT1
C`5D0ET1G@5Q0FD1J05[0Fd1K`5a0G81L`5c0G<1LP5a0G01KP5[0FP1I@5Q0Ed1
F@5D0Dl1B@540Ch1=`4a0BX18`4L0AD13P470Ol1n07a0NX1h`7L0MD1cP780L41
^`6f0K01Z`6V0J81WP6J0IL1U06A0Hl1SP6<0H`1R`6<0H`1S@6?0I41U06F0IX1
W@6R0JH1Z`6`0KD1^`710LP1cP7E0M`1h`7Z0O41n0400@L13P4E0A`18`4Z0C41
>04n0D@1BP5?0E@1F@5N0F81IP5Y0F`1KP5`0G81L`5d0G@1M05c0G81L05^0F`1
J@5V0F81GP5I0ED1C`5:0D@1?P4h0C41:P4T0Ad15@4>0@L1o`7h0O41jP7R0M/1
e@7>0LL1`@6k0KD1/06Z0JD1X@6M0IT1UP6C0I01SP6=0H/1R`6;0H/1R`6=0Hh1
T06C0IH1V@6M0J41Y@6Z0Jl1]@6k0L41a`7>0M@1f`7R0NX1l@7h0@011`4>0AD1
7@4T0B/1<@4h0Ch1A05:0E01E@5J0Eh1H`5V0FX1K@5_0G41L`5d0GD1M@5e0G@1
L`5a0Fl1K@5Z0FH1H`5O0EX1E@5@0DX1A@4n0CP1<P4[0B@17@4F0@h11`7o0OP1
l@7Y0N81f`7D0Ld1a`700KX1]06_0JX1Y@6P0I`1V06E0I81T06=0H`1R`6:0HX1
RP6;0H`1S@6?0I81U@6H0I`1X06U0JX1[`6d0KX1`0770Ld1e07K0N81j@7a0OP1
00470@h15P4M0B@1:`4b0CP1?`550D/1D05F0EX1G`5S0FL1JP5]0G01LP5d0GD1
M@5f0GD1M@5d0G81L05]0FX1I`5S0El1F`5F0E01B`550Cl1>@4b0B/1904M0AH1
3P470Ol1n07a0NT1hP7K0M@1c@760L01^P6d0Jh1Z@6T0J01V`6H0I@1T@6?0Hd1
R`6:0HT1R@690HX1R`6=0Hl1T@6D0IP1V`6O0J@1Z@6^0K@1^P700LH1c@7D0M/1
hP7Y0O41n0400@L13P4F0Ad1904[0C81>@4o0DD1B`5A0EH1F`5P0F@1J05[0Fh1
L@5c0G@1MP5f0GH1MP5f0G@1L`5a0Fh1J`5X0F@1H05K0EH1D@5;0DH1?`4i0C81
:`4T0Ad15P4>0@L1007h0O41j@7R0M/1e07=0LH1`06i0K<1[P6Y0J@1W`6K0IL1
U06A0Hh1S06:0HT1R0680HP1R@6:0H`1SP6@0I<1U`6K0Il1X`6X0Jh1/`6i0Kl1
aP7=0M@1f`7R0NT1l@7h0@011`4>0AH17@4T0B`1<P4i0D01AP5<0E41E`5L0F01
I@5X0F`1K`5a0G<1M@5f0GL1M`5g0GH1M@5d0G41K`5/0FP1I@5P0E`1E`5B0D`1
AP500CT1<`4/0BD17@4F0@l11`7o0OP1l07Y0N81fP7C0L`1aP6o0KT1/`6]0JP1
X`6N0IX1UP6C0I01S@6;0HX1R0680HL1R0680HT1R`6=0I01T`6F0IX1WP6S0JP1
[@6c0KT1_`760L`1d`7J0N81j@7`0OP100470@l15P4M0BD1;04c0CT1@0560D`1
DP5G0E`1H@5U0FT1K05_0G81M05f0GL1N05h0GP1M`5f0G@1LP5`0Fd1J@5U0F41
G05G0E81C0560D01>P4c0B`19@4M0AH13`470Ol1n07`0NT1h@7J0M<1c0750Kl1
^@6c0Jd1Y`6R0Ih1VP6F0I81S`6=0H/1R@680HL1Q`670HP1R@6:0Hd1S`6B0IH1
V@6N0J81Y`6]0K81^06o0LD1c07C0MX1h@7Y0O01n07o0@L13`4F0Ah19@4/0C<1
>P500DL1C@5B0EP1G@5Q0FH1JP5]0G01L`5e0GH1N05h0GT1N05h0GL1M@5c0G01
K@5Z0FH1HP5M0EP1D`5=0DL1@04j0C<1;04U0Ah15P4?0@L1o`7h0O01j@7Q0MX1
d`7<0LD1_P6h0K81[06W0J81W@6I0ID1TP6?0H`1RP680HL1QP660HH1Q`680HX1
S06>0I81U@6I0Id1XP6W0J`1/P6h0Kh1a@7<0M<1fP7Q0NT1l07h0@011`4?0AH1
7P4U0B`1<`4j0D41A`5=0E<1F05M0F81IP5Z0Fh1L@5c0GD1M`5h0GT1N@5i0GP1
M`5f0G<1L@5^0FX1IP5R0Ed1F05C0Dd1A`510CX1<`4/0BD17P4F0@l11`7o0OP1
l07Y0N41fP7C0L`1a@6n0KP1/P6/0JL1X@6M0IP1U@6A0Hh1R`690HP1QP660HD1
QP660HL1R@6;0Hh1T@6D0IP1W@6Q0JH1[06b0KP1_P750L/1dP7J0N41j@7`0OP1
00470@l15P4N0BD1;@4d0CX1@@570Dh1D`5I0Eh1H`5W0F/1KP5a0G@1MP5h0GT1
NP5j0GX1N@5h0GH1M05a0Fh1J`5W0F<1GP5I0E<1CP580D41>`4d0Bd19@4N0AH1
3`470Ol1n07`0NT1h@7J0M81b`740Kh1]`6a0J`1YP6Q0I`1V06D0I01S@6;0HT1
Q`660HD1Q@650HH1Q`690H/1S@6@0I@1V06L0J41YP6[0K41]`6n0L@1b`7B0MX1
h@7X0O01n0400@L13`4G0Ah19@4]0C@1>`510DP1CP5D0ET1GP5S0FL1J`5_0G81
M@5g0GP1NP5j0G/1NP5j0GP1M`5e0G81K`5[0FL1H`5N0ET1E05>0DP1@@4k0C@1
;@4V0Ah15`4?0@L1o`7h0O01j07Q0MT1dP7;0L@1_@6g0K41Z`6V0J01W06G0I<1
T06=0HX1R0660HD1Q0640H@1Q@660HP1RP6=0I01T`6G0I`1X06V0J/1/@6g0Kd1
a07;0M81f@7Q0NP1l07h0@011`4?0AL17P4V0Bd1=04k0D81B05>0E@1FP5O0F<1
J05/0Fl1LP5e0GL1N@5j0G/1N`5k0GX1N@5g0GD1LP5_0F`1J05T0El1FP5D0Dh1
B0520C/1=04]0BH17P4G0@l11`7o0OP1l07X0N41f@7B0L/1a06m0KL1/@6[0JD1
X06K0IL1T`6?0H`1RP670HH1Q@640H@1Q0650HH1Q`6:0H`1S`6C0IL1V`6P0JD1
Z`6`0KL1_@740L/1dP7I0N41j07`0OP100470@l15`4N0BH1;@4d0C/1@P580Dl1
E05J0El1I05X0F`1L05c0GH1N05i0G/1N`5l0G/1N`5j0GP1MP5c0G01K05X0F@1
G`5J0ED1C`590D81>`4d0Bd19P4N0AL13`470Ol1n07`0NP1h@7I0M81b`740Kd1
]P6`0JX1Y@6P0I/1UP6B0Hl1S0690HL1Q@640H<1P`630H@1Q@670HT1S06?0I81
UP6K0J01Y@6Z0K01]P6m0L@1bP7B0MT1h@7X0O01n07o0@L13`4G0Ah19P4]0CD1
?0520DT1C`5E0EX1H05T0FT1K@5`0G<1MP5h0GX1N`5l0G`1O05k0GX1N05f0G<1
L05]0FT1I05P0EX1E@5?0DT1@P4l0CD1;@4V0Al15`4?0@L1o`7h0O01j07P0MT1
dP7:0L<1_@6f0K01ZP6T0Il1VP6F0I81SP6;0HT1QP650H@1P`630H<1Q0650HH1
R@6;0Hh1TP6F0IX1W`6T0JX1/06f0Kd1``7:0M41f@7P0NP1l07h0Ol11`4?0AL1
7`4V0Bh1=@4l0D<1B@5?0ED1F`5P0FD1J@5]0G41M05g0GT1NP5l0G`1O@5l0G`1
NP5i0GL1M05a0Fd1J@5U0F01F`5E0Dl1B@530C`1=@4^0BH17`4G0@l11`7o0OP1
l07X0N01f@7A0LX1``6l0KH1/06Z0J@1W`6J0IH1TP6>0H/1R0660H@1P`620H81
PP630H@1QP680H/1SP6B0IH1VP6O0J@1ZP6`0KH1_0730LX1d@7I0N01j07`0OP1
00470@l15`4O0BH1;P4e0C`1@`590E01E@5K0F01I@5Z0Fh1L@5d0GL1N@5k0G`1
O@5m0Gd1O05k0GT1M`5d0G41KP5Z0FD1H05K0EH1D0590D<1?04e0Bh19P4O0AL1
3`470@01n07`0NP1h07I0M41bP730K`1]P6_0JT1Y06O0IX1U@6A0Hh1RP680HH1
Q0630H81PP620H<1Q0660HP1RP6>0I41U@6J0Ih1Y06Y0Jl1]@6l0L<1bP7A0MT1
h07X0O01n0400@L13`4G0Al19P4^0CD1?0530DX1D05F0E/1H@5U0FX1KP5b0GD1
M`5j0G/1O@5m0Gh1O@5m0G/1NP5g0GD1LP5^0FX1IP5Q0E/1EP5@0DX1@`4l0CD1
;P4V0Al15`4?0@L1007h0O01j07P0MP1d@7:0L<1_06e0Jl1Z@6S0Ih1V@6E0I41
S@6:0HL1Q@630H81P@610H41PP630HD1Q`6:0Hd1T@6E0IT1WP6S0JT1[`6e0K`1
``7:0M41f07P0NP1l07h0@011`4?0AL17`4W0Bh1=@4l0D<1BP5@0EH1G05Q0FH1
JP5^0G81M@5h0GX1O05m0Gh1OP5n0Gd1O05j0GP1M@5b0Fh1JP5V0F41G05F0E01
BP530C`1=@4^0BL17`4G0@l11`7o0OP1l07X0N01f07A0LX1``6l0KD1[`6Y0J<1
WP6I0ID1T@6=0HX1Q`650H<1PP610H41P@620H<1Q@670HX1S@6@0ID1V@6N0J<1
Z@6_0KD1_0720LX1d@7H0N01j07`0OP1o`470@l15`4O0BL1;P4e0Cd1@`5:0E01
EP5L0F41IP5[0Fl1LP5e0GP1NP5l0Gd1OP5n0Gh1O@5l0GX1N05e0G81K`5[0FH1
H@5L0EH1D05:0D@1?@4f0Bh19`4O0AL13`470Ol1n07`0NP1h07H0M41b@720K/1
]@6_0JT1X`6N0IT1U06@0Hd1R@670H@1P`610H41P0610H41P`640HL1R@6=0I01
U06I0Ih1X`6Y0Jh1]@6k0L81b@7A0MP1h07X0O01n0400@L13`4G0Al19`4^0CH1
?@540DX1D@5G0E`1H@5V0F/1K`5c0GH1N05k0G`1OP5n0Gl1OP5n0G`1N`5i0GH1
L`5_0F/1IP5R0E`1E`5A0DX1A04m0CH1;P4W0Al15`4?0@L1007h0O01j07P0MP1
d@790L81^`6e0Jh1Z06S0Id1V06D0I01S0690HH1Q0620H41P0600H01P@620H@1
QP690H`1T06D0IP1W@6S0JP1[P6e0K/1`P790M41f07P0NP1l07g0@01204?0AL1
7`4W0Bh1=P4m0D@1BP5A0EL1G05R0FL1J`5_0G<1MP5i0G/1O@5n0Gl1O`5o0Gh1
O@5k0GT1MP5c0Fl1J`5W0F81G05G0E41BP540Cd1=P4^0BL17`4G0@l120400OL1
l07X0N01f07A0LT1`P6k0K@1[P6X0J81W@6H0I@1T06<0HT1QP640H81P@600H01
P0610H81Q0660HT1S06@0I@1V06M0J81Z06^0K@1^`720LT1d07H0N01j07_0OL1
00480A015`4O0BL1;`4f0Cd1A05;0E41E`5M0F81I`5[0Fl1L`5f0GT1N`5m0Gh1
O`5o0Gl1OP5m0G/1N@5f0G<1L05[0FL1HP5M0EL1D@5;0D@1?@4f0Bl19`4O0AL1
40480Ol1m`7_0NP1h07H0M01b@720K/1]06^0JP1XP6M0IP1T`6?0H`1R@660H@1
PP610H01P0600H41PP640HH1R@6<0Hl1T`6H0Id1XP6X0Jh1]06k0L81b@7@0MP1
h07X0Nl1m`400@P1404G0Al19`4_0CH1?@540D/1D@5G0Ed1HP5W0F`1L05c0GL1
N@5l0Gd1O`5o0Gl1O`5o0Gd1O05i0GL1L`5`0F`1I`5R0Ed1E`5A0D/1A04m0CH1
;`4W0Al1604@0@P1o`7g0Nl1i`7P0MP1d0790L81^`6d0Jh1Z06R0Id1V06C0Hl1
R`680HH1P`620H01P0600H01P0620H<1QP680H/1S`6C0IP1W@6R0JP1[P6d0K/1
`P790M01f07P0NL1k`7g0Ol1204@0AP17`4W0Bl1=P4m0D@1B`5A0EL1G@5R0FL1
K05`0G@1M`5j0G`1OP5o0Gl1O`5o0Gl1OP5l0GX1M`5d0G01K05W0F81G@5G0E41
B`540Cd1=P4_0BL17`4H0A01207o0OL1k`7W0N01f07@0LT1`P6k0K@1[P6X0J81
W@6H0I<1S`6;0HP1Q@630H41P0600H01P0600H41P`650HP1R`6?0I<1V06M0J81
Z06^0K@1^`720LT1d07H0N01i`7_0OL100480A01604O0BL1;`4f0Cd1A05;0E41
E`5M0F<1I`5/0G01M05g0GX1O05n0Gl1O`5o0Gl1O`5n0G`1NP5g0G@1L05/0FP1
H`5M0EP1D@5;0D@1?@4f0Bl19`4O0AP140480Ol1m`7_0NL1h07H0M01b@720K/1
]06^0JL1XP6L0IL1T`6?0H/1R0650H<1P@600H01P0600H01P@630HD1R06;0Hl1
T`6G0I`1XP6W0Jd1]06k0L81b@7@0MP1g`7W0Nl1m`400@P1404H0B019`4_0CH1
?P540D/1DP5H0Ed1H`5X0F`1L05d0GL1NP5l0Gh1O`5o0Gl1O`5o0Gh1O05j0GL1
M05`0F`1J05S0Ed1F05B0D/1A04n0CH1;`4W0B01604@0@P1007g0Nl1i`7O0MP1
d0790L41^P6d0Jd1Y`6R0I`1U`6C0Hl1R`680HD1P`610H01P0600H01P0610H<1
Q@680H/1S`6C0IL1W06R0JL1[@6d0KX1`@790M01f07O0NL1k`7g0@01204@0AP1
804W0Bl1=P4n0DD1B`5B0EP1G@5S0FP1K05`0G@1M`5j0G`1OP5o0Gl1O`5o0Gl1
OP5l0GX1M`5d0G01K05X0F<1G@5H0E81B`550Ch1=P4_0BL1804H0A01207o0OL1
k`7W0Ml1f07@0LT1`@6j0K@1[@6W0J41W06G0I<1SP6;0HP1Q@630H41P0600H01
P0600H41P`650HP1R`6>0I<1U`6L0J41Y`6]0K@1^P710LT1d07H0Ml1i`7_0OL1
00480A01604P0BL1;`4f0Ch1A@5;0E81F05N0F<1J05/0G41M05g0GX1O05n0Gl1
O`5o0Gl1O`5n0G`1NP5g0G@1L@5/0FP1H`5N0EP1DP5;0DD1?P4f0Bl19`4P0AP1
40480Ol1m`7_0NL1g`7H0M01b@710KX1]06]0JL1X@6L0IL1T`6>0H/1Q`650H81
P@600H01P0600H01P@620HD1Q`6;0Hh1TP6G0I`1X@6W0Jd1]06j0L41b@7@0MP1
g`7W0Nl1m`7o0@P1404H0B019`4_0CH1?P550D/1DP5H0Eh1H`5X0Fd1L@5d0GP1
NP5m0Gh1O`5o0Gl1O`5o0Gh1O@5j0GP1M05a0Fd1J05S0Eh1F05B0D/1A@4n0CH1
;`4W0B01604@0@P1o`7g0Nl1i`7O0MP1d0780L41^P6d0Jd1Y`6Q0I`1U`6B0Hh1
R`670HD1PP610H01P0600H01P0610H81Q@670H/1SP6B0IL1W06Q0JL1[@6d0KX1
`@780M01f07O0NL1k`7g0@01204@0AP1804W0Bl1=`4n0DD1B`5B0EP1GP5S0FP1
K@5a0G@1N05j0Gd1OP5o0Gl1O`5o0Gl1OP5m0GX1N05d0G41K@5X0F<1GP5H0E81
B`550Ch1=`4_0BL1804H0A01207o0OL1k`7W0Ml1f07@0LP1`@6j0K@1[@6W0J41
W06G0I81SP6;0HL1Q@620H41P0600H01P0600H41PP650HL1R`6>0I81U`6L0J41
Y`6]0K@1^P710LP1d07H0Ml1i`7_0OL100480A01604P0BL1;`4g0Ch1A@5;0E81
F05N0F<1J05]0G41M05h0GX1O@5o0Gl1O`5o0Gl1O`5o0Gd1NP5h0G@1L@5]0FP1
H`5N0EP1DP5<0DD1?P4g0Bl19`4P0AP140480@01m`7_0NL1g`7H0M01b0710KX1
/`6]0JL1X@6L0IL1TP6>0HX1Q`650H81P0600H01P0600H01P0620HD1Q`6:0Hh1
TP6G0I`1X@6W0Jd1/`6j0L41b07@0MP1g`7W0Nl1m`400@P1404H0B019`4_0CL1
?P550D`1DP5H0Eh1H`5X0Fd1L@5e0GP1NP5m0Gl1O`5o0Gl1O`5o0Gl1O@5j0GP1
M@5a0Fd1J05S0Eh1F05B0D`1A@4n0CL1;`4W0B01604@0@P1o`7g0Nl1i`7O0MP1
d0780L41^P6c0Jd1Y`6Q0I`1U`6B0Hh1RP670H@1PP600H01P0600H01P0600H81
Q0670HX1SP6B0IL1W06Q0JL1[@6c0KX1`@780M01f07O0NL1k`7g0@0100410@81
0`440@H11`490@/1304>0A014P4D0AH1604J0Ad17`4Q0B<19P4X0B/1;@4_0C81
=04g0CT1?04n0D41@`560DP1B`5=0E01DP5E0EL1F@5L0Eh1H05R0F@1I`5Y0F/1
K05^0G01LP5c0GD1MP5h0GT1NP5k0G`1O@5n0Gl1O`5o0Gl1O`5o0Gl1O`5o0Gl1
O`5o0Gh1O@5l0G/1NP5i0GL1MP5d0G81L05]0F/1J@5V0F<1H05M0EX1E`5D0E01
C@590DD1@@4m0CT1=@4a0Bd1:04T0Al16P4F0A4130480@<1oP7i0O@1k`7[0NH1
h@7L0ML1d`7>0LT1a@700K`1^06d0K01[06X0J@1X@6M0IX1U`6D0I41SP6<0HX1
R0660H@1PP610H01P0600H01P0600H01P0600H41PP640HD1Q`690H`1SP6A0I@1
U`6K0Ih1XP6V0JX1[`6c0KP1_@720LL1c07A0ML1g07R0NP1kP7c0OT1o`450@/1
4@4G0A`18P4X0Bh1<`4i0Ch1@`580Dd1DP5F0E/1G`5S0FL1JP5^0G41M05f0GT1
N`5l0Gh1O`5o0Gl1O`5o0Gl1O`5o0Gh1O05j0GP1MP5c0G01K05Y0FD1H@5M0EP1
D`5>0DT1A04n0CP1<P4/0BH1804I0A<130460Ol1n07b0N/1i@7N0MP1d@7;0LD1
_`6j0K@1[`6Z0JD1X06K0IL1T`6@0Hd1RP670HD1P`610H01P0600H01P0600H01
P@630HD1Q`6:0Hd1T@6E0IT1W@6R0JL1[06a0KL1_@730LX1d07G0Mh1i@7/0O<1
nP410@P1404G0Ah19@4/0C81>@4o0DD1B`5A0EL1G05Q0FH1JP5^0G81M@5h0GX1
O05n0Gl1O`5o0Gl1O`5o0Gh1O05j0GP1M@5b0Fh1JP5U0F41G05F0E01BP540Ch1
=`4`0BT18@4J0A<12`430O`1m07/0ND1g@7F0Ll1b0710KX1]06^0JP1XP6M0IP1
U06@0H`1R@660H@1PP600H01P0600H01P0610H<1Q@680H/1S`6C0IL1W06Q0JL1
[@6c0KX1`@780Ll1e`7N0NH1kP7f0Oh11P4>0AH17P4V0Bh1=@4l0D<1BP5A0EL1
G@5R0FL1K05`0G@1M`5j0G`1OP5o0Gl1O`5o0Gl1OP5m0GX1M`5d0G01K05W0F81
G@5G0E01BP530C/1=04/0B@1704D0@/10`7k0O81jP7R0MX1dP7:0L81^`6d0Jd1
Y`6Q0I/1UP6A0Hd1RP660H@1PP600H01P0600H01P@620HD1R06;0Hl1U06I0Ih1
Y06Z0K41^06o0LL1c`7G0N01j07a0OT10P4;0A<1704U0Bd1=@4m0D@1C05C0ET1
G`5U0FX1K`5c0GL1NP5l0Gh1O`5o0Gl1O`5o0Gd1N`5h0G@1L05/0FL1H@5K0ED1
CP560Cl1=`4^0BH17@4D0@/10P7i0O01i`7O0MH1c@750Kd1]P6^0JP1X@6K0IH1
T@6<0HT1Q@630H41P0600H01P0610H81Q@680H`1T06E0I/1X@6W0Jh1]@6m0LD1
cP7F0Ml1j07b0O/1104=0AL1804Y0C41>P520DX1D@5H0El1I@5Z0Fl1M05g0G/1
O@5o0Gl1O`5o0Gl1O@5k0GP1M@5`0F/1IP5P0ET1DP5;0D<1>`4b0BT1804G0@d1
107j0O41i`7N0MD1c0730K/1/`6/0J@1WP6H0I<1SP6:0HH1P`610H01P0600H01
P@630HH1RP6>0I<1V06N0JD1[06d0K`1a07=0MH1h07Y0O<1o@470A016P4S0Bd1
=P4o0DL1C`5F0Ed1I05Z0Fl1M05g0G/1O@5o0Gl1O`5o0Gh1O05j0GH1LP5]0FL1
H@5K0E<1B`530CX1<@4X0Al15@4;0@41m`7]0N<1f@7@0LL1_P6e0Jh1YP6O0IT1
T`6>0HX1QP630H41P0600H01P0620HD1R06<0I41UP6L0J<1Z`6c0K/1a07=0MH1
h07Z0O@1o`490A<17@4W0C01>P530D/1D`5K0F81J05^0G<1M`5j0Gd1O`5o0Gl1
O`5n0G`1N@5e0G01J`5U0Eh1E`5?0DL1?P4d0B/18@4G0@`10P7h0Nd1h`7I0Ll1
aP6m0K@1[06T0Id1U`6A0H`1R0640H81P0600H01P0620H@1R06<0I41UP6M0J@1
Z`6d0K`1aP7?0MT1i07^0OP10`4>0AP18P4/0CH1@0590E41F@5P0FL1K@5b0GL1
NP5m0Gl1O`5o0Gl1O@5k0GL1L`5^0FP1HP5J0E<1BP510CP1;P4T0AT13`440OT1
kP7T0MT1c`750K`1/`6[0J<1W06E0I01R`670H<1P@600H01P0610H<1QP6:0Hl1
U@6K0J<1Z`6c0K`1aP7?0MX1i07_0OX11@4@0A/19@4`0CX1@`5<0ED1G@5T0FX1
L05e0GT1O05n0Gl1O`5o0Gd1N`5h0G<1KP5X0F41FP5B0DT1?`4f0B/18@4F0@/1
007e0NX1g`7D0LX1`06g0Jh1Y@6N0IL1T@6<0HL1Q0620H01P0600H41Q0670H/1
T06F0Id1Y@6]0KH1_`790M<1gP7Y0O@1o`4;0AH18@4/0CH1@05:0E81F`5R0FT1
K`5d0GP1O05n0Gl1O`5o0Gd1NP5g0G81K@5V0El1E`5>0DD1>`4a0BH16`4@0@D1
n@7^0N<1f07=0L<1^@6`0JL1W`6H0I81S0680H@1PP600H01P0620H@1R06<0I81
V06O0JL1/06i0L<1c@7H0N<1k`7j0@H14@4M0BP1<`4m0DL1D05I0F41J05^0G<1
N05k0Gh1O`5o0Gh1O@5j0GH1L@5[0FD1G@5E0D`1@P4h0Bd18P4G0@/1o`7d0NP1
g@7B0LL1_@6c0JX1XP6J0I<1SP690HD1PP600H01P0620H@1R06=0I81V@6P0JT1
/P6k0LH1d07K0NL1l`7n0@X15P4R0Bd1>0520D`1E@5M0FD1K05b0GH1NP5m0Gl1
O`5o0Gd1NP5f0G41K05U0Ed1E@5;0D41=`4/0B415@490Od1l@7U0MX1cP740KT1
/06W0Ih1U`6A0H/1Q`640H41P0600H41Q0670H/1T@6G0Il1Y`6`0KX1a07?0MX1
iP7b0Oh12P4F0B81;@4h0D<1C@5F0El1IP5]0G<1M`5k0Gd1O`5o0Gh1O05h0G@1
K`5X0F41F05?0DD1>`4`0B@16@4=0@01m07X0M`1d@760K/1/@6X0Il1V06A0H`1
Q`640H41P0600H81Q0680H`1TP6I0J41Z@6c0Kd1b07C0Ml1j`7g0@<1404L0BP1
<`4n0DT1DP5K0F<1J`5a0GH1NP5m0Gh1O`5n0G`1N@5d0Fl1J@5Q0ET1C`550C/1
;`4T0AP12`7o0O<1iP7J0Lh1``6i0Jl1Y@6M0IH1S`6:0HH1P`610H01P@630HH1
RP6@0IH1WP6V0Jl1^@740M01f`7X0O@10@4=0AT19P4a0Cd1A`5A0E/1H`5Z0G01
MP5j0G`1OP5n0Gh1N`5h0G<1KP5W0El1EP5=0D81=`4/0B014`470OX1kP7Q0MD1
b@6n0K@1ZP6Q0IT1TP6<0HL1Q0620H41P@630HD1R@6?0ID1W06U0Jh1^0730Ll1
f`7W0O<1004=0AX19P4b0Cd1B05B0E/1I05[0G41MP5j0Gd1OP5n0Gd1NP5f0G41
J`5T0E`1DP580Cd1<P4V0AT13@400O<1iP7J0Lh1`P6g0Jd1Y06K0I@1SP690HD1
PP610H41PP650HT1SP6D0I`1Y06^0KP1``7?0M/1j07d0@413P4K0BP1=04o0DX1
E05M0FD1K@5c0GL1N`5m0Gh1OP5l0GT1M05_0FP1H05G0Dd1@`4g0B/17`4B0@D1
n07[0Mh1dP760K/1/06V0Ih1UP6?0HX1QP630H41P@620HD1R@6>0I@1W06U0Jh1
^@740M01g07Y0OH10`4@0Ad1:P4f0D41C05F0El1I`5^0G@1N05l0Gd1OP5m0GX1
M`5b0F`1I05L0E81B04l0C01904G0@X1o@7`0N<1eP7:0Kh1/`6Y0J01V06A0H/1
Q`640H81P@620HD1R@6>0I@1W06T0Jh1^@740M01g@7Z0OL1104A0Al1:`4g0D<1
CP5H0F41J@5`0GD1N@5l0Gd1O@5l0GT1M@5_0FP1H@5G0Dd1@P4g0BX17P4@0@<1
mP7X0M/1c`730KL1[@6S0I/1T`6=0HP1Q0620H81PP650HP1S@6C0I/1X`6]0KP1
``7?0M`1j@7f0@@14@4O0B/1>0540Dl1F@5R0FT1L05e0GT1O05m0Gd1N`5h0G<1
K@5V0Eh1E05:0Cl1<P4V0AT12`7n0O01h`7F0LT1_@6b0JP1W`6G0I01RP660H<1
PP620H@1Q`6;0I41V06Q0JX1]@700L`1f@7V0O@10@4?0Ad1:P4f0D81C@5H0F41
J@5`0GD1N@5l0Gd1O@5k0GL1L`5]0FD1G@5C0DP1?@4`0B<15P480O/1k@7P0M<1
aP6j0Jl1Y@6L0I@1SP690HD1P`620H<1Q@690Hh1U@6M0JH1/06k0LL1e07Q0Nh1
o04:0AL19@4b0Ch1BP5D0Eh1IP5^0G@1N05k0Gd1O@5k0GP1L`5]0FH1GP5D0DT1
?@4a0B@15`490O/1k@7P0M81aP6j0Jl1Y@6L0I@1S@680HD1P`620H@1QP6:0I01
U`6O0JP1/`6n0L/1f07U0O<10@4?0A`1:P4g0D<1CP5H0F81JP5`0GH1N@5l0G`1
O05i0GD1L05Y0F41F05=0D81=@4X0A/13@7o0O41h`7F0LT1_@6a0JL1WP6F0Hl1
R@660H<1P`640HH1RP6@0IH1W`6X0K<1_P7;0MP1i@7c0@413`4M0B/1>0540Dl1
F@5S0F/1L@5f0GX1O05l0G/1N05d0Fh1I`5N0E@1BP4n0C41904F0@P1nP7/0Mh1
d@740KP1[@6S0IX1TP6<0HP1Q@630H<1Q@680Hd1U06L0JD1[`6j0LH1d`7Q0Nl1
o@4;0AT19`4d0D41C05G0F41J@5`0GD1N@5k0G`1N`5h0G@1KP5W0El1E@5:0Ch1
<@4T0AH1207i0N/1g@7@0L<1]`6/0J81V@6B0H`1Q`640H<1Q0660HX1S`6F0Ih1
Y`6b0Kh1bP7H0ND1m0420A017P4/0CT1A@5A0E/1I05/0G81M`5j0G/1N`5i0GH1
L@5Z0F81F@5>0D<1=P4Y0A/13@7o0O01hP7D0LL1^`6_0JD1W06D0Hd1R@650H@1
Q0660HT1SP6E0Id1YP6a0K`1b@7F0N@1lP410@l17P4[0CT1A@5@0E/1I05/0G81
M`5j0G/1N`5i0GD1L05Y0F41E`5=0D41=04V0AP12P7k0Nd1g`7A0L@1^06/0J81
V@6B0H`1R0650H@1Q@670H/1T@6H0J41Z`6f0L81c`7M0N/1nP480AL19@4b0Cl1
B`5F0F01J05_0GD1N@5k0G/1NP5f0G81J`5S0EX1D0540CL1:P4L0@d1o`7`0N81
e0760KX1[P6T0I/1T`6=0HP1Q@640HD1Q`6;0I41V06Q0J/1]P720Ll1g@7/0OX1
2@4G0BH1<`500D`1E`5Q0FT1L05e0GT1NP5j0GT1M@5`0FT1H@5G0Dd1@@4d0BH1
60490OX1k07M0Ll1`P6f0J/1X06H0I41R`670HD1Q@660HT1SP6D0I`1YP6`0K`1
b@7G0ND1m0420A41804^0C/1B05C0Ed1IP5^0G<1M`5j0GX1N@5f0G41J`5S0EX1
C`530CH1:@4J0@`1o@7^0N01dP740KP1[06R0IT1TP6<0HP1Q@650HH1R@6>0I@1
W06V0K41_@7:0ML1iP7d0@<14P4Q0Bl1?0590E@1GP5W0Fh1M05h0GX1NP5h0GD1
L05Y0F41E`5<0D01<`4U0AH11`7h0NX1f`7=0L01]06X0Il1UP6?0HX1Q`650HD1
Q`6;0I41V06Q0J/1]`730M41g`7]0O`12`4J0BT1=P530Dl1FP5S0F/1LP5f0GT1
NP5i0GH1LP5[0F<1FP5?0D<1=P4X0AX12`7l0Nd1gP7@0L<1]P6[0J01V06A0H/1
Q`660HH1Q`6;0I41V06Q0J/1]P730M01g`7]0O`12`4J0BT1=`540E01FP5T0F`1
LP5f0GT1N@5h0GD1L05Z0F81F05=0D41<`4U0AL1207i0NX1f`7=0Kl1/`6X0Ih1
UP6?0HX1Q`660HH1R@6=0I<1V`6T0Jl1^`780MH1i@7d0@<14P4Q0Bl1?@590ED1
G`5X0Fl1M05g0GT1N@5g0G81K@5U0E`1D@560CT1:`4L0@d1oP7_0N01d@740KL1
Z`6Q0IP1T@6<0HP1QP660HP1S06B0IX1X`6]0KT1aP7D0N81l@410A017`4]0C/1
B05D0Eh1I`5^0G<1M`5i0GP1MP5b0F`1I@5L0E41A@4h0BX16`4<0Od1kP7O0M01
``6f0JX1X06H0I41R`680HH1Q`690Hh1U06L0JD1/06l0LT1e`7V0OD11@4D0B<1
<@4o0D/1E`5Q0FT1L05d0GL1N05h0GD1L05Y0F41E`5<0Cl1<P4T0AD11@7f0NL1
f07:0K`1/06U0I`1U06>0HX1Q`670HP1S06A0IP1X@6/0KP1a07B0N41l0400@l1
7P4]0C/1A`5C0Eh1IP5^0G<1MP5h0GP1M@5a0F/1H`5I0Dh1@P4d0BH15`480OP1
j@7J0L`1_P6b0JL1W@6E0Hl1RP680HL1R@6<0I41V@6Q0J`1^0750M<1h@7a0@01
404O0Bd1>`580E@1GP5W0Fh1L`5f0GP1M`5d0G01J@5Q0EL1C04o0C418`4D0@@1
m@7U0MH1b06k0Jl1Y06K0I<1S@6:0HP1R06:0Hh1U06L0JD1/06m0LX1f07W0OL1
1P4F0BD1<`510Dd1F@5R0FX1L05e0GL1M`5f0G81K05U0E`1D@550CL1:@4J0@/1
n`7/0M`1cP700K<1Z06N0IH1T06;0HP1R0690Hd1TP6J0J<1[@6i0LH1e@7T0O<1
0`4B0B41<04n0D/1EP5P0FT1K`5d0GH1M`5f0G81K@5U0E`1DP560CP1:P4K0@`1
o07]0Md1c`710K@1Z@6O0IH1T06;0HT1R06:0Hd1T`6J0J<1[P6j0LP1eP7U0OD1
104D0B<1<P4o0D`1E`5Q0FT1L05d0GH1M`5e0G41J`5S0EX1C`520CD19P4G0@P1
n07X0MT1b`6m0K41YP6L0I@1SP6;0HT1R@6;0I01UP6N0JP1/`700Lh1g07/0O/1
2`4K0BX1>0550E41G05U0F`1LP5e0GH1M@5c0Fh1I`5N0E@1B04k0Bd17P4>0Oh1
k`7O0M01`P6e0JX1X06G0I41S0690HT1R`6>0I@1W06U0K01_07:0MT1j07g0@L1
5`4V0CD1@P5?0EX1H`5[0G41M05f0GD1L`5^0FL1G`5E0DT1?04^0Al13`400O01
h07A0L<1]P6Z0J01V06A0H`1RP690H/1S`6D0I`1YP6a0Kd1b`7J0NT1n@480AP1
9`4f0D<1D05K0F@1J`5a0G@1MP5e0G81K@5V0Ed1DP560CT1:`4L0@`1o07/0Md1
cP700K<1Z06N0IH1T06<0HX1RP6<0I41U`6O0JT1]@720M01g`7_0Ol13P4N0Bd1
>`580E@1GP5W0Fh1LP5e0GD1L`5_0FT1H@5H0D`1@04b0B<150440O@1i07E0LH1
^@6]0J81VP6C0Hh1R`6:0H`1S`6E0I`1YP6a0Kd1b`7J0NT1n@490AT1:04g0D@1
D@5K0F@1K05a0G@1M@5d0G01J`5S0EX1C`520CD19P4G0@L1m`7W0MP1b@6k0Jl1
Y06K0I@1S`6;0HX1S06?0I@1W06U0K01_@7:0MT1j@7h0@P1604X0CH1A05@0E/1
I05[0G01L`5d0G<1L05Z0F81F@5>0D41<`4U0AD11@7e0ND1eP770KX1[P6S0IX1
T`6>0H/1R`6<0I01UP6N0JP1/`700Lh1g@7/0O`1304L0B/1>P570E<1G@5V0Fd1
L@5d0G@1LP5^0FL1G`5E0DT1?04^0Al13`7o0Nl1g`7@0L81]@6Z0J01U`6A0Hd1
R`6<0Hh1T`6J0J<1[@6i0LL1e@7T0O@1104D0B@1<`510Dd1F@5R0FX1K`5b0G@1
L`5_0FX1HP5I0Dh1@@4c0BD15@450OD1i@7F0LL1^P6]0J<1VP6C0Hl1S06<0Hh1
TP6H0J01ZP6f0L<1dP7Q0O410@4A0B41<04n0D/1EP5P0FP1KP5b0G<1LP5`0FX1
H`5J0Dl1@`4e0BH15`470OL1i`7G0LP1^`6_0J@1V`6D0Hl1S@6<0Hh1TP6H0J41
Z`6f0L@1dP7Q0O410@4A0B41<04n0D/1E`5P0FP1KP5a0G<1LP5_0FT1HP5I0Dd1
@@4c0B@150440O@1i07E0LH1^@6]0J81VP6C0Hl1S@6=0Hl1U06J0J<1[P6j0LL1
eP7V0OH11P4F0BD1=0520Dl1F@5S0FX1K`5b0G81L@5]0FL1GP5D0DT1>`4]0Ah1
3P7n0Nd1gP7?0L01]06X0Il1U`6A0Hh1S@6>0I41U`6O0JP1]0710Ll1gP7^0Oh1
3P4N0Bd1?0590ED1G`5W0Fd1L05b0G41KP5Y0F41F05=0D01<P4S0A@10`7c0N<1
e0750KP1[06R0IX1T`6?0Hd1SP6A0IH1W@6V0K41_P7;0MX1jP7j0@X16P4Z0CT1
AP5B0E`1I@5[0Fl1L@5a0Fh1J@5R0ET1CP520C@19@4E0@D1m@7U0MH1a`6i0Jd1
X`6J0I@1T06>0Hh1T@6F0Id1YP6a0Kd1b`7J0NX1nP4:0AX1:P4i0DH1DP5L0FD1
J`5_0G41L05^0FT1H@5H0Dd1@04b0B<150430O<1h`7D0LD1^06/0J81VP6D0I01
SP6?0I81U`6O0JP1]0700Ll1gP7^0Oh13P4N0Bd1?0590E@1GP5V0F`1K`5a0Fl1
K05V0Eh1E@590C`1;P4N0@h1oP7^0Mh1c`710K@1Z06O0IP1TP6?0Hl1T06D0I/1
X`6]0KT1a`7E0ND1m@450AD19@4d0D81CP5I0F81J@5^0G01L05^0FT1HP5I0Dh1
@P4d0BD15@450OD1i@7E0LL1^@6]0J<1V`6E0I41S`6@0I<1V06P0JX1]@720M01
g`7_0@01404P0Bl1?@5:0EH1G`5W0F`1K`5`0Fh1JP5T0E/1D@550CL1:@4I0@T1
n@7X0MT1bP6l0K01Y@6M0IH1TP6@0I01T`6H0Il1Z06c0L01cP7N0Nd1oP4>0Ah1
;@4l0DT1E05N0FH1J`5^0Fl1KP5Z0F@1F`5A0DD1>04Y0AT12@7i0NT1f@7:0K`1
/06U0Id1UP6B0I01T06C0IP1X06Y0KD1`@7@0Ml1k`7o0@l17`4_0Cd1BP5E0El1
IP5[0Fh1K`5]0FT1HP5I0Dl1@`4e0BH15P460OH1iP7F0LL1^P6^0J@1W06E0I81
T06A0ID1V`6R0J`1^0750M@1h`7d0@@1504T0C<1@@5=0EP1H@5X0F`1KP5^0F/1
IP5O0EH1BP4m0Bl1804@0@01k`7O0M01`P6e0JX1X06I0I@1T@6A0I<1V06N0JL1
/P6o0L`1f`7[0O`1304L0B/1>P570E<1G@5T0FX1K@5^0F`1J05R0EX1C`530CD1
9P4G0@H1mP7V0MH1b06j0Jh1Y06L0IH1TP6A0I<1UP6L0J@1[P6j0LP1e`7V0OH1
1`4G0BL1=P530Dl1FP5R0FP1K05]0F`1J@5S0E/1D@560CP1:P4J0@X1nP7Y0MX1
b`6m0K41YP6N0IL1T`6B0I<1UP6K0J<1[@6i0LH1e@7T0O@11@4E0BD1=0520Dh1
F05Q0FL1J`5]0F`1J@5S0E`1DP560CT1:P4K0@X1nP7Z0MX1b`6m0K41Y`6N0IP1
U06B0I<1UP6L0J@1[P6j0LL1eP7U0OH11P4F0BH1=@520Dh1F@5Q0FL1J`5]0F/1
J05R0EX1D0540CH1:04H0@P1m`7W0MP1b@6k0Jl1Y@6M0IL1U06C0I@1V06N0JH1
/@6m0L/1fP7Y0OX12P4J0BX1>0550E41F`5S0FP1J`5/0FX1IP5O0EL1C04o0C41
8P4C0@81lP7R0M81a06g0J`1XP6K0IH1U06C0IH1V`6R0J/1]P730M41h07`0@41
4@4Q0C01?P5;0EH1GP5U0FX1J`5[0FP1H`5K0E41AP4h0BX16P4:0OX1jP7J0L/1
_@6a0JL1W`6I0ID1U06E0IT1W`6W0K41_P7;0MX1jP7j0@/16`4Z0CT1AP5A0E/1
H`5X0F/1J`5Y0F@1G@5D0DT1?04^0Al13`7o0Nh1g`7?0L41]@6Z0J41VP6F0I@1
U@6H0Id1Y@6_0K/1b07G0NH1m`470AL19`4f0D<1C`5I0F41IP5Z0F/1J@5U0Eh1
E@5;0Ch1<04Q0A410@7a0N41d@730KH1Z`6R0I/1U`6E0ID1V06M0JD1[`6j0LP1
eP7V0OH11P4F0BH1=@520Dh1F05P0FH1J@5Z0FP1I05N0ED1BP4n0C018@4A0@01
l07P0M41``6f0J/1XP6L0IL1U@6F0IT1WP6V0K01_0790MP1j07h0@P1604X0CH1
A05?0ET1H@5V0FT1J@5W0F<1G05C0DP1>`4]0Ad13@7m0Nd1g@7>0L01]06Y0J41
V`6G0IH1U`6K0J41Z@6c0L01c@7L0N`1o04=0Ad1;04j0DL1DP5K0F81I`5Y0FT1
IP5P0ET1C`530CH19`4H0@P1m`7W0MP1b@6l0K01YP6O0IT1U`6F0IT1W@6T0Jh1
^@760M@1h`7c0@@1504T0C81@05<0EH1GP5T0FP1J@5W0F<1G05D0DT1?04^0Al1
3`7o0Nl1g`7@0L81]P6[0J81W06H0IL1V06K0J41ZP6d0L01cP7M0Nd1o@4=0Ad1
;@4k0DL1DP5K0F81IP5X0FL1I05N0EH1C0500C<1904D0@@1m07T0MD1aP6i0Jh1
Y@6N0IT1U`6H0I/1X06X0K81_@7;0MT1j@7i0@T16@4Y0CL1A05@0ET1H05U0FL1
I`5T0El1F05>0D81=@4V0AL11`7g0NL1e`790K`1/06W0Il1VP6H0IP1V`6P0JL1
/@6l0LX1f07X0OP1204H0BL1=P530Dh1F05O0F@1I`5W0F@1G`5H0Dh1@P4e0BL1
5`470OL1i`7G0LT1_06`0JL1X06K0IP1V@6K0J41Z06b0Kd1b`7I0NT1n@490AT1
:04g0D@1C`5H0El1I05V0FH1H`5N0EH1C0510C<19@4E0@D1m@7U0MD1a`6j0Jl1
YP6O0I/1V@6I0Id1XP6Z0K@1`07>0M`1k07l0@`1704[0CT1AP5A0EX1H05T0FH1
I@5Q0E`1D`590Cd1;`4P0A01007`0N01d@740KL1[@6T0Ih1VP6I0I/1W`6U0Jh1
^0750M<1hP7b0@814P4R0C01?P5:0E@1G05R0FD1I@5S0El1F05?0D@1=`4Y0AX1
2P7i0NT1fP7;0Kh1/`6Y0J81W@6J0IX1W@6R0JT1/`6o0L`1fP7Z0OX12P4J0BT1
=`540Dl1F05O0F<1I@5T0F41F`5C0DT1?@4_0B0140400O01h@7B0L@1^06]0JD1
W`6K0IX1W06P0JL1[`6j0LL1e@7T0O@1104D0B<1<P4o0D/1E@5L0F41I05T0F81
G@5E0D`1@04c0B@15@450OD1i@7F0LP1^`6`0JL1X@6M0I/1W06O0JD1[P6h0L@1
dP7Q0O01004@0B01;`4l0DP1DP5J0F01H`5T0F81G@5F0Dd1@P4e0BL15`480OP1
j07H0LX1_@6b0JT1XP6N0I`1W06O0JD1[@6g0L<1d@7O0Nl1o`4?0Al1;@4k0DL1
D@5I0El1HP5S0F41G@5F0Dd1@P4e0BL160480OP1j07I0L/1_P6c0JT1X`6N0I`1
W@6P0JH1[P6h0L@1d@7P0O01004@0Al1;P4k0DL1D@5I0El1HP5S0F01G05E0D`1
@04c0BD15P460OH1iP7G0LT1_@6b0JT1XP6N0Id1WP6Q0JL1/06j0LH1e07S0O<1
0`4C0B81<04n0DT1D`5J0El1HP5R0El1FP5B0DT1?@4`0B414P420O81h`7D0LH1
^P6`0JL1XP6N0Id1W`6S0JX1/`6n0L/1f@7X0OP1204G0BH1=0510D`1E@5L0F01
H@5Q0Ed1E`5?0D@1>04Z0A`1307l0N`1g@7?0L81]P6]0JD1X06N0Ih1X@6V0Jh1
^0740M41g`7_0Ol13`4N0Bd1>P560E01F05M0F01H@5O0EX1D`5:0Ch1<@4S0A@1
107d0ND1eP780K`1/@6Y0J<1W`6N0J01Y06[0K@1_P7;0MT1j07h0@P15`4V0C@1
@@5<0E@1F`5O0F01G`5L0ED1C@520CH1:04I0@X1nP7Z0M/1c@700KD1[06U0J41
W`6P0J<1Z@6a0K/1a`7E0N<1l`430A818P4`0Cd1B05B0ET1G@5P0El1G05G0Dl1
A@4i0B`17@4>0Oh1kP7O0M41a06h0Jl1Y`6R0J01X06S0JP1/06i0LD1dP7Q0O01
004?0Al1;@4j0DH1D05G0E`1G`5O0E`1E`5@0DH1>`4]0Al140400O01h@7C0LD1
^P6`0JP1X`6Q0J01X`6X0Jl1^@740M41h07_0Ol13P4N0B`1>@550Dl1EP5K0Eh1
GP5L0EL1C`560CX1;@4O0A01007a0N41d`760KX1/06Y0J@1X@6Q0J@1Z@6`0KX1
a@7B0N41l07o0@l17P4]0CX1A@5?0EH1F`5N0Eh1F`5F0Dh1A04i0B`17@4>0Oh1
k`7P0M41a@6i0K01Z@6T0J81XP6U0JX1/P6l0LP1e@7S0O<10P4B0B41;`4l0DL1
D05G0E/1G@5M0ET1E05<0D81=P4X0AX12P7k0N/1g07?0L81]`6^0JP1Y06R0J<1
Y`6]0KD1_`7;0MT1j07g0@L15P4U0C81?`590E81F05L0Ed1F`5G0E41B04m0C41
8`4D0@D1mP7V0MP1bP6n0K@1[06W0J<1X`6U0JT1/06i0L@1d@7O0Nh1o@4=0A`1
:P4g0D<1C@5D0ET1G05L0ET1E05=0D<1>04[0A`13@7n0Nl1h07B0LD1^P6a0JX1
Y@6S0J@1Y`6]0KD1_`7;0MP1i`7f0@D15@4S0C41?@580E01EP5J0E`1FP5F0E01
A`4m0C018`4D0@D1m@7V0MP1bP6o0KD1[@6W0J@1Y06V0J/1/P6k0LH1d`7Q0O01
o`4?0Ah1;04i0D@1C@5D0ET1F`5J0EL1DP5:0D01=04W0AT12@7j0N/1g07?0L81
^06`0JT1YP6T0JH1ZP6`0KT1``7@0Mh1k07k0@/16P4X0CD1@@5:0E81E`5J0EX1
F05C0D/1@P4g0BX1704=0Od1kP7O0M81a@6j0K81Z`6W0JD1YP6Z0Jl1^0720Lh1
f`7Z0OT1204G0BH1<`4o0DT1D05F0ET1F@5G0E<1C0530CP1:`4M0@h1o`7`0N41
d`770K`1/`6/0JP1YP6V0JX1/06h0L81cP7K0NT1n0470AH19@4b0Ch1B05@0ED1
F05I0EL1DP5;0D81=`4[0Ad13P7o0O01h@7C0LL1_06c0J`1Z06V0JL1Z`6`0KP1
``7?0M`1jP7i0@P15`4U0C81?P580E01E@5H0EP1EP5A0DX1@@4f0BT16`4<0Od1
kP7P0M81aP6k0K<1[06X0JL1Z06/0K81^P750M41gP7]0O`12`4I0BL1=04o0DT1
D05E0EL1E`5E0Dl1B04n0C<19P4H0@T1nP7[0Md1d0740KX1/P6/0JP1Z06Y0Jh1
]06m0LP1e07R0O41004?0Ad1:`4g0D81B`5A0ED1E`5F0E<1C@550C/1;`4Q0A<1
107e0NL1f@7<0L41]`6`0J/1Z@6Y0J/1/06h0L41c@7J0NL1mP450A@18P4_0C/1
A@5=0E81EP5F0E@1D0590D01=P4Y0A/13@7n0Nl1h@7D0LL1_@6d0Jh1ZP6Y0JX1
[P6d0K`1a`7C0N01kP7m0@`16P4X0C@1?`580Dl1E05F0ED1DP5<0DD1>`4_0B81
50450OH1j07J0Ld1`P6i0K41[06Z0JX1[@6b0KT1`P7>0MX1j07g0@D1504R0Bl1
>`540D`1D@5D0ED1D`5>0DL1?P4c0BL16@4;0O`1kP7P0M81a`6m0K@1[`6[0JX1
[06`0KL1_`7:0MH1i07b0@013`4M0B/1=`510DT1C`5C0E@1D`5?0DT1@@4f0BX1
7@4?0@01lP7T0MH1bP700KL1/@6]0J/1[06_0KD1_@780M<1h07^0Od1304J0BL1
<`4n0DL1CP5B0E@1D`5@0DX1@P4h0Bd1804B0@<1m@7V0MT1c@720KT1/P6^0J`1
[06_0KD1_@760M81g`7/0O/12@4H0BD1<P4l0DD1C05A0E<1DP5?0DX1@`4i0Bh1
8@4C0@D1mP7X0MX1cP730KX1/`6_0Jd1[@6`0KD1_@760M41gP7/0OX12@4G0B@1
<@4k0D@1B`5@0E81DP5?0DX1@P4i0Bd18@4C0@D1mP7X0M/1cP740K/1]06_0Jd1
[P6a0KH1_@770M81g`7]0O/12@4G0BD1<@4l0D@1B`5@0E81D@5>0DT1@@4g0B`1
7`4B0@<1m@7W0MX1cP730KX1]06`0Jh1[`6b0KL1_`790M@1h@7_0Od12`4I0BH1
<P4l0DD1B`5?0E41D05=0DL1?`4e0BT17@4?0@41lP7U0MP1c0720KX1/`6`0Jh1
/06c0KT1`P7<0ML1i07b0@013P4L0BT1=04n0DH1C05?0E01C`5;0D@1?04b0BH1
6@4;0Od1k`7Q0MD1b@700KP1/`6`0Jl1/@6f0K`1a@7?0M`1j@7f0@D14`4P0B`1
=`500DP1C@5?0Dl1C@580D41>04]0B4150460OP1jP7M0M41aP6m0KL1/P6`0K01
/`6i0L01b@7E0N41kP7l0@X1604U0C41>`530DT1C@5?0Dh1BP550Cd1<`4X0A/1
3@7o0O81i07G0L`1`P6j0KD1/@6a0K81]P6l0LD1c`7K0NP1m@430A417P4[0CD1
?`560D/1CP5>0D`1A`500CL1;@4Q0A@11P7h0NX1g@7A0LL1_P6h0K<1/@6b0KD1
^P720L/1eP7R0O01o@4;0AT19@4a0C/1@`590D`1C@5<0DP1@P4j0C019@4H0@/1
o@7_0N81eP7;0L81^P6e0K<1/P6d0KT1_`780M<1gP7[0OT11`4D0B41;@4g0D01
AP5;0Dd1C0590D@1?04c0BP1704?0@41l`7V0MX1cP750Kd1]`6d0K<1]06h0Kh1
aP7@0M`1j07f0@<14@4N0BX1=04m0D@1B@5<0D`1B@540Ch1=@4Z0Ah14@440OH1
j@7L0M41a`6o0KT1]@6d0K@1^06m0LD1c`7J0NH1m0410@h16`4X0C81?0530DP1
B`5;0DT1A@4n0CD1:`4O0A<11@7h0N/1gP7C0LT1`06j0KH1]06e0KP1_P750Lh1
f@7V0O<1004=0AX19P4a0CX1@P570DX1BP580D@1?P4e0B/1804C0@H1n07[0Ml1
d`790L41^`6g0KD1]P6i0Kh1aP7?0MX1iP7c0@013@4J0BH1<@4j0D41AP590DX1
B0530Cd1=04Z0Al14P450OP1j`7N0M<1b@710K/1]`6f0KL1^P6o0LL1d07K0NL1
m0410@h16`4W0C41>P510DH1B@590DH1@P4k0C<1:@4M0A010`7f0NT1g@7B0LT1
`@6k0KP1]P6h0K/1`@790M81g@7Y0OH10`4@0Ad1:04b0C/1@@560DP1B0550D01
>@4`0BH16P4>0@41m07W0M/1d0770L01^`6h0KL1^@6m0L<1b`7E0N41k@7j0@L1
4`4P0B/1=04l0D81AP570DH1@`4n0CH1;@4R0AH12P7m0O01i07H0Lh1aP6o0KX1
^06h0K/1_`760Ll1f@7U0O41oP4;0AL18`4^0CL1?P530DH1A`550D41>`4c0BT1
7P4B0@D1n07/0N01e@7;0L<1_P6j0KT1^P6m0L<1bP7C0Mh1jP7f0@<1404L0BL1
<@4i0D01A0560DD1@`4n0CL1;P4T0AP1307o0O<1iP7K0M41b0710Kd1^P6j0K`1
`0770Ll1f@7T0O01o@490AH18@4/0CD1?0510D@1A@540D01>P4b0BP17P4B0@D1
n@7/0N41eP7<0LD1_`6l0KX1^`6o0L@1b`7E0Ml1j`7g0@@1404L0BL1<04h0Cl1
@P540D@1@@4l0CD1;04R0AH12P7n0O41i@7J0M01b0720Kd1^`6k0Kh1`P790M81
g07W0O<1o`4<0AP18`4]0CD1?0510D<1@`510Cd1=`4_0BD16P4>0@81m@7Y0Mh1
e07;0L@1_`6m0K`1_P720LP1c`7I0N@1k`7l0@P1504O0BX1<P4j0Cl1@P530D41
?P4h0C019`4M0A411@7i0Nd1h@7G0Lh1aP710Kh1_@6n0L41a`7>0ML1hP7]0OT1
1@4A0Ad19`4`0CP1?@510D81@@4n0CP1<@4X0Ah14`470O/1k`7S0MT1d0780L<1
_`6n0Kh1`@760Lh1eP7P0N`1m`430@l16`4U0Bl1=P4l0D01@@500Cd1>04b0BT1
7`4D0@P1o07`0ND1fP7A0LT1a0700Kh1_`720LL1cP7F0N01j`7g0@<13`4J0B@1
;@4e0C/1?`500D01?@4h0C41:@4O0A@1207l0O41i@7K0M81bP740L41_`700L<1
a`7>0ML1h07[0OL10`4>0AX1904]0CD1>P4n0Cl1?`4l0CL1<04X0Ah14`480O`1
l07U0M/1dP7;0LD1`@700L41a0780Ll1f07R0N`1n0440@l16P4T0Bd1=04j0Cd1
?`4n0C/1=P4_0BH17@4B0@H1n`7_0N@1fP7B0LX1a@720L41`P750LX1d@7J0N<1
kP7j0@D14@4L0BD1;P4e0CX1?@4n0Cd1>@4d0Bd1904J0@l1107i0Nd1h`7I0M41
bP750L81`P730LL1c07C0M`1iP7a0O`1204C0Ad19`4_0CD1>P4m0Cd1>`4g0C81
:P4Q0AL130410OH1j`7P0ML1c`790LD1``730LD1b@7?0MH1g`7Y0O@1004;0AH1
804Y0C01=P4j0C`1?04j0CD1;`4W0Ah150490Od1lP7W0Mh1e@7>0LP1a@730L@1
a`7;0M81fP7S0Nh1n0440@l16@4S0B/1<P4g0CX1>`4j0CL1<P4[0B<16P4?0@@1
n@7^0N@1fP7B0L`1a`750L@1aP790Lh1e@7N0NP1lP7m0@P14`4M0BH1;P4d0CP1
>P4j0CP1=@4_0BL17`4E0@X1o`7d0NT1h07G0M01bP770LD1a@780L`1dP7J0N<1
k@7h0@<13P4H0B41:P4`0CD1>@4j0CT1=P4a0BX18P4I0@l1107i0Nl1i@7K0M@1
c@790LH1aP770L/1d07G0Ml1j@7c0Oh12@4C0Ad19P4]0C<1=`4i0CT1=`4c0Bd1
9@4M0A<1207n0O<1j@7O0ML1d07;0LP1a`770LX1c`7E0Md1iP7`0OX11@4?0AT1
8P4Z0C01=@4g0CP1=`4c0Bh19`4O0AH130410OL1k07S0MX1d`7=0LX1b0780LX1
cP7C0M/1h`7]0OL10P4<0AH17`4W0Bh1<`4f0CL1=P4d0Bl1:@4Q0AP13P440OX1
k`7V0Md1e@7?0L/1b@780LX1c@7B0MT1h@7[0OD1o`490A<17@4U0B`1<@4e0CH1
=P4d0Bl1:P4R0AX140460O`1lP7X0Ml1e`7A0Ld1bP790LX1c@7B0MT1h07Y0O<1
o@480A416`4S0BX1<04c0CD1=@4c0Bl1:P4S0A/14@470Od1l`7Z0N41f@7C0Lh1
b`7:0L/1cP7B0MP1h07Y0O81o0460A016@4R0BT1;P4b0C@1=04c0Bl1:P4S0A/1
4P480Oh1m07[0N81fP7D0Ll1c07;0L`1cP7C0MT1h07Y0O81o0460A016@4Q0BP1
;@4a0C<1=04b0Bh1:@4S0A/14P480Oh1m07[0N81f`7D0M01c@7<0L`1c`7C0MT1
h@7Y0O81o0460@l1604Q0BL1;@4a0C<1<`4a0Bd1:04R0AX14@470Oh1m07[0N81
f`7E0M01cP7=0Ld1d07E0MX1hP7Z0O<1o@470A016@4Q0BL1;04`0C81<P4`0B`1
9`4P0AP140460Od1l`7Z0N81f`7E0M41cP7=0Ll1d@7F0M`1h`7/0OD1oP480A41
6P4Q0BL1;04`0C41<@4_0B/19@4N0AL13P440O/1lP7Y0N41fP7E0M41c`7>0M01
d`7H0Mh1i@7^0OL1004:0A<16`4R0BP1;04_0C01<04]0BT18`4L0A@12`420OT1
l07W0N01f@7D0M41c`7?0M41e@7J0N01j07`0OX10`4<0A@1704S0BT1;@4_0Bl1
;P4[0BL18@4I0A412@7o0OH1kP7U0Mh1f07D0M41d07A0M<1e`7L0N<1j`7d0Od1
1P4>0AL17P4T0BT1;@4^0Bh1;04Y0B@17P4F0@h11@7l0O<1j`7S0Md1e`7D0M41
d@7B0MD1fP7P0NL1k`7g0@012@4A0AT1804V0BX1;@4^0Bd1:P4V0B416P4C0@X1
0@7i0O01j07Q0M/1eP7C0M81dP7D0MP1g@7S0NX1l`7k0@@13@4E0A`18P4W0B/1
;04]0B/1:04S0Ad15P4>0@H1o@7e0N`1i@7O0MT1eP7C0M<1e07G0M/1h07W0Nl1
m`400@P1404H0Al1904X0B/1;04[0BT19@4P0AT14P4:0@41n@7`0NT1hP7L0MP1
e@7D0M@1eP7I0Mh1i@7/0O@1o0440@d1504K0B419P4Y0B/1:`4Y0BH18@4K0AD1
3@450O`1m07/0ND1g`7J0ML1e@7E0MH1f@7M0N<1j@7a0OT10@490A41604O0B@1
9`4Z0BX1:@4V0B817@4G0@l11`7o0OL1k`7X0N81g07I0MH1e@7F0MP1g07Q0NP1
k`7g0Ol11`4?0AH1704R0BH1:04Y0BT19`4S0Ah1604A0@T10@7i0O81jP7T0Mh1
fP7H0MH1e`7I0M`1h@7V0Nd1m@7m0@D1304D0AX1804T0BL1:04X0BH18`4O0AT1
4P4;0@<1n`7d0N`1iP7P0M`1f@7G0ML1f@7L0N01iP7/0O<1n`430@/14P4H0Ah1
8P4U0BL19`4V0B<17`4J0A<130450Od1m@7^0NL1hP7M0MX1f07H0MT1g07P0ND1
k07c0OX10P490A015`4M0B41904V0BH19@4S0Al16P4D0@d11@7n0OH1k`7Y0N<1
gP7K0MT1f@7J0Md1h07U0N/1lP7i0@41204?0AH16`4P0B<19@4V0BD18P4N0AT1
504=0@H1oP7g0O01jP7T0Ml1g07J0MX1f`7M0N41iP7/0O81n@410@P13`4E0A/1
7`4R0B@19@4T0B417P4I0A<13@460Oh1m`7`0NX1i@7P0Md1f`7K0M`1gP7R0NH1
k07c0OX10@480@l15@4J0Ah18P4S0B@18`4P0Ad1604B0@`11@7n0OL1l07Z0ND1
h@7N0M`1g07M0Ml1h`7W0Nd1l`7j0@41204?0AD16P4N0B418`4S0B817`4L0AL1
4@4;0@@1o@7g0O01jP7U0N41gP7M0Md1gP7P0N@1j@7^0O@1n`420@T13`4E0AX1
7P4P0B818P4Q0Ah16P4F0A012P430O`1mP7`0NX1i@7Q0Ml1gP7N0Ml1hP7U0NX1
l07f0O`10`4:0A015@4J0Ah1804Q0B417`4M0AT1504>0@P10P7k0OD1k`7Y0ND1
hP7O0Mh1g`7P0N<1i`7/0O41n07n0@D12`4A0AH16P4M0Al1804P0Ah16`4G0A81
3@460@01nP7c0Nh1j@7U0N81h07O0N01hP7U0NT1kP7d0OX100460@`14P4G0A/1
7@4O0Al17`4L0AT15@4@0@X1107n0OP1lP7]0NP1i07R0N01h07Q0N<1i`7[0O01
mP7l0@81204>0A<15`4K0Ad17P4N0Ad16`4G0A<13P480@81o07f0O01j`7W0N@1
hP7Q0N41h`7U0NT1k@7c0OP1oP440@X1404D0AP16`4M0Ah17@4K0AT15@4@0@/1
1@7o0OT1m07_0NX1iP7T0N81hP7S0ND1j07[0O01m@7k0@411`4<0A415@4I0A/1
7@4M0A`16@4F0A813@480@81o@7g0O81k@7Y0NH1i07S0N<1i07W0NX1kP7c0OP1
oP440@T13P4C0AL16@4K0A`16`4J0AL1504?0@X11@7o0OX1m07`0N/1j07U0N@1
i07T0NH1j@7]0O41mP7l0@411`4<0A01504H0AX16`4K0AX1604E0A4130470@81
o07g0O81kP7Z0NL1i@7T0ND1iP7X0N`1l07d0OX1o`440@T13P4B0AH1604J0AX1
6@4H0AD14P4>0@T1107n0OT1m07`0N`1j@7W0NH1i@7V0NP1j`7_0O<1n07m0@81
1`4<0A01504G0AP16@4I0AP15@4B0@h12P450@01n`7f0O81kP7Z0NP1i`7V0NL1
j07[0Nh1lP7g0O`10@460@X13`4B0AD15`4H0AP15`4E0A<13`4;0@H10@7l0OP1
l`7_0N`1j@7X0NL1i`7Y0N/1kP7b0OH1n`7o0@@12@4=0A41504F0AL15`4G0AD1
4`4?0@`11`420Oh1n@7e0O41k@7[0NT1j07X0NT1j`7^0O41m@7j0Oh10`480@`1
404C0AD15P4G0AH15@4C0@l130480@<1o`7j0OH1lP7^0N`1jP7Y0NT1jP7[0Nh1
l@7e0OT1oP420@L12`4?0A81504E0AH15@4D0A813`4<0@P1107o0O/1m`7c0Nl1
k@7[0NX1jP7Z0N`1kP7a0OD1n@7m0@811P4:0@h14@4C0A@15@4E0A@14P4?0@`1
20440@01n`7g0O<1l07^0N`1j`7Z0N/1k@7_0O81m@7i0Od10@460@T13@4@0A81
4`4D0A@14`4A0@l12`480@@1007l0OP1m07a0Nh1k@7/0N/1k07]0Nl1lP7f0OT1
o@410@D12@4<0@l14@4C0A<14`4B0A013P4;0@L110400O`1n07d0O41k`7]0N`1
k07]0Nh1l07c0OH1nP7n0@411@490@`13`4A0A814P4B0A41404=0@X11`430Ol1
o07h0OD1lP7`0Nh1k@7]0Nh1k`7a0O@1m`7j0Oh10P450@T1304>0A014@4B0A41
404?0@`12@460@<1o`7k0OP1m@7b0O01k`7^0Nh1kP7`0O81m@7h0O/1oP420@H1
2@4<0@h1404A0A414@4?0@h12`490@D10P7n0O/1n07e0O81l07_0Nl1k`7_0O41
l`7f0OP1o07o0@<11P490@/13P4?0A01404@0@h13@4:0@P110410Oh1n`7g0OD1
l`7a0O01k`7`0O01lP7d0OL1n@7m0@010`460@T12`4=0@l13`4?0@l13@4<0@T1
1P430@01o@7j0OL1m@7c0O41l07`0O01l@7c0OD1n07k0Oh10@440@L12@4;0@d1
3P4?0@h13P4<0@X120450@81o`7l0OT1m`7e0O<1lP7a0O41l@7c0O@1mP7i0O`1
o`420@@11`490@/13@4>0@h13@4=0@/12@470@@10@7n0O`1n@7g0OD1l`7b0O81
lP7b0O@1mP7h0OX1o@400@<11@480@X12`4<0@d13@4<0@/12P480@D10`400Od1
n`7h0OH1m07c0O81lP7c0O@1m@7g0OT1n`7n0@410`460@P12P4;0@`1304<0@/1
2P480@H110420Ol1o07j0OP1mP7d0O@1l`7c0O@1m@7f0OP1nP7m0Ol10P440@H1
204:0@/1304<0@/12P490@L11@430@01oP7k0OT1m`7f0OD1m07d0O@1m@7f0OP1
nP7l0Oh10@430@D11`490@X12`4;0@/12P490@P11P440@41o`7m0O/1n@7g0OH1
m@7d0O@1m@7f0OL1n@7k0Od1o`420@@11P470@T12P4:0@X12P490@P11P440@81
007n0O`1nP7h0OL1mP7e0OD1m@7f0OL1n@7k0O`1o`410@<11@460@P12@490@X1
2@490@P11P450@<10@7o0Od1n`7i0OP1m`7f0OH1mP7f0OL1n@7j0O`1oP400@81
10450@L120490@T12@480@P11P450@<10@7o0Oh1o07j0OT1n07g0OH1mP7g0OP1
n@7j0O`1o@7o0@410`440@H11`480@P120480@L11P450@<10P400Oh1o07k0OX1
n07h0OL1m`7g0OP1n@7j0O/1o@7o0@010P440@D11P470@P120480@L11P450@@1
0P400Ol1o@7l0OX1n@7h0OP1n07h0OP1n@7j0O/1o@7n0@010P430@@11P460@L1
1`470@L11P450@@10P410Ol1oP7l0O/1nP7i0OP1n07h0OT1n@7j0O/1o@7n0@01
0@430@@11@460@H11`460@H11P450@@10P410Ol1oP7m0O/1nP7j0OT1n@7i0OT1
nP7k0O`1o@7n0Ol10@420@<110450@H11P460@H11@440@<10P410@01oP7m0O`1
n`7j0OX1n@7i0OX1nP7k0O`1o@7n0Ol10@420@<110450@D11@450@D11@440@<1
0P410@01o`7m0O`1n`7k0OX1nP7j0OX1nP7k0O`1o@7n0Ol100420@<10`440@D1
1@450@D110440@<10P410@01o`7n0Od1o07k0O/1nP7j0OX1n`7k0O`1o@7n0Ol1
00410@810`440@@110440@@110430@<10P410@01o`7n0Od1o07k0O/1n`7k0O/1
n`7l0Od1o@7n0Ol100410@810`430@@110440@@10`430@810@410@01o`7n0Od1
o07l0O/1n`7k0O/1o07l0Od1oP7n0Ol100410@810P430@<110440@<10`430@81
0@400@01o`7n0Od1o@7l0O`1o07l0O`1o07m0Od1oP7o0Ol100410@810P430@<1
0`430@<10`420@810@400@01o`7n0Od1o@7l0O`1o07l0O`1o@7m0Oh1oP7o0@01
00410@410P420@<10`430@<10P420@410@400Ol1o`7n0Oh1o@7m0Od1o07l0Od1
o@7m0Oh1oP7o0@0100410@410P420@810P420@810P420@4100400Ol1o`7n0Oh1
o@7m0Od1o@7m0Od1o@7n0Oh1o`7o0@0100410@410P420@810P420@810P410@41
00400Ol1o`7n0Oh1oP7m0Od1o@7m0Od1oP7n0Oh1o`7o0@0100410@410@420@81
0P420@410@410@0100400Ol1o`7n0Oh1oP7n0Od1o@7n0Oh1oP7n0Ol1o`7o0@01
00410@410@410@410@410@410@410@01007o0Ol1o`7n0Oh1oP7n0Oh1oP7n0Oh1
oP7o0Ol1o`400@0100410@410@410@410@410@410@400@01007o0Ol1o`7n0Oh1
oP7n0Oh1oP7n0Oh1o`7o0Ol1o`400@0100410@410@410@410@410@4100400@01
007o0Ol1o`7o0Oh1oP7n0Oh1oP7n0Ol1o`7o0Ol100400@0100400@410@410@41
0@410@0100400@01o`7o0Ol1o`7o0Oh1oP7n0Oh1oP7o0Ol1o`7o0Ol100400@01
00400@010@410@0100400@0100400@01o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0@0100400@0100400@0100400@0100400@0100400Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0@0100400@0100400@0100400@0100400@0100400Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`400@0100400@0100400@0100400@01
00400@01007o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`400@0100400@01
00400@0100400@0100400@01o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
00400@0100400@0100400@0100400@0100400@01o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol100400@0100400@0100400@0100400@0100400Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0@0100400@0100400@0100400@0100400@01
007o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`400@0100400@0100400@01
00400@0100400@01007o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol100400@01
00400@0100400@0100400@0100400@01o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0@0100400@0100400@0100400@0100400@0100400Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0@0100400@0100400@0100400@0100400@01007o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`400@0100400@0100400@0100400@01
00400@01o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol100400@0100400@01
00400@0100400@0100400Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0@01
00400@0100400@0100400@0100400@01007o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`400@0100400@0100400@0100400@0100400@01o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol100400@0100400@0100400@0100400@0100400Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0@0100400@0100400@0100400@01
00400@01007o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`400@0100400@01
00400@0100400@0100400@01o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0@01
00400@0100400@0100400@0100400@0100400Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`400@0100400@0100400@0100400@0100400@01007o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol100400@0100400@0100400@0100400@0100400Ol1
o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0@0100400@0100400@0100400@01
00400@01007o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`400@0100400@01
00400@0100400@0100400@01o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1o`7o0@01
00400@0100400@0100400@0100400@0100400Ol1o`7o0Ol1o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`400@0100400@0100400@0100400@0100400@01o`7o0Ol1o`7o0Ol1
o`7o0Ol1o`7o0Ol1o`7o0@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@0100400@0100400@0100400@0100400@01
00400@0100400@0100400@0100400@01004\>"]},
  ImageCacheContents->"Sound"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Sound  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(g[x_] := Exp[\(-Pi\)\ x^2]; \(NG = N[Ng[0.1]];\) // Timing\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \({0.009999999999999787`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell["\<\
Just a different signal with a sinusoidal behavior of the frequency \
for x>0\
\>", "Subsubsection"],

Cell[BoxData[
    \(f[x_] := \((Which[x > 0, Sin[2  Pi\ \((2  Sin[x])\)], True, 0] + 
          Which[x \[LessEqual] 0, Sin[2  Pi\ x], True, 0])\); 
    NF = Nf[f, 0.1];\)], "Input",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListDensityPlot[Abs[Nstft[NF, NG, 0.1]], Mesh \[Rule] False, 
          PlotRange \[Rule] All, AspectRatio \[Rule] Automatic];\) // 
      Timing\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00480769 0.00961538 0.00480769 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -6 -9 ]
[.25962 -0.0125 6 0 ]
[.5 -0.0125 -9 -9 ]
[.5 -0.0125 9 0 ]
[.74038 -0.0125 -9 -9 ]
[.74038 -0.0125 9 0 ]
[.98077 -0.0125 -9 -9 ]
[.98077 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .00962 -6 -4.5 ]
[-0.0125 .00962 0 4.5 ]
[-0.0125 .10577 -12 -4.5 ]
[-0.0125 .10577 0 4.5 ]
[-0.0125 .20192 -12 -4.5 ]
[-0.0125 .20192 0 4.5 ]
[-0.0125 .29808 -12 -4.5 ]
[-0.0125 .29808 0 4.5 ]
[-0.0125 .39423 -12 -4.5 ]
[-0.0125 .39423 0 4.5 ]
[-0.0125 .49038 -18 -4.5 ]
[-0.0125 .49038 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .5 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(50)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(100)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(150)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(200)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.06731 0 m
.06731 .00375 L
s
.11538 0 m
.11538 .00375 L
s
.16346 0 m
.16346 .00375 L
s
.21154 0 m
.21154 .00375 L
s
.30769 0 m
.30769 .00375 L
s
.35577 0 m
.35577 .00375 L
s
.40385 0 m
.40385 .00375 L
s
.45192 0 m
.45192 .00375 L
s
.54808 0 m
.54808 .00375 L
s
.59615 0 m
.59615 .00375 L
s
.64423 0 m
.64423 .00375 L
s
.69231 0 m
.69231 .00375 L
s
.78846 0 m
.78846 .00375 L
s
.83654 0 m
.83654 .00375 L
s
.88462 0 m
.88462 .00375 L
s
.93269 0 m
.93269 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .00962 m
.00625 .00962 L
s
[(0)] -0.0125 .00962 1 0 Mshowa
0 .10577 m
.00625 .10577 L
s
[(20)] -0.0125 .10577 1 0 Mshowa
0 .20192 m
.00625 .20192 L
s
[(40)] -0.0125 .20192 1 0 Mshowa
0 .29808 m
.00625 .29808 L
s
[(60)] -0.0125 .29808 1 0 Mshowa
0 .39423 m
.00625 .39423 L
s
[(80)] -0.0125 .39423 1 0 Mshowa
0 .49038 m
.00625 .49038 L
s
[(100)] -0.0125 .49038 1 0 Mshowa
.125 Mabswid
0 .03365 m
.00375 .03365 L
s
0 .05769 m
.00375 .05769 L
s
0 .08173 m
.00375 .08173 L
s
0 .12981 m
.00375 .12981 L
s
0 .15385 m
.00375 .15385 L
s
0 .17788 m
.00375 .17788 L
s
0 .22596 m
.00375 .22596 L
s
0 .25 m
.00375 .25 L
s
0 .27404 m
.00375 .27404 L
s
0 .32212 m
.00375 .32212 L
s
0 .34615 m
.00375 .34615 L
s
0 .37019 m
.00375 .37019 L
s
0 .41827 m
.00375 .41827 L
s
0 .44231 m
.00375 .44231 L
s
0 .46635 m
.00375 .46635 L
s
.25 Mabswid
0 0 m
0 .5 L
s
.01923 .49375 m
.01923 .5 L
s
.25962 .49375 m
.25962 .5 L
s
.5 .49375 m
.5 .5 L
s
.74038 .49375 m
.74038 .5 L
s
.98077 .49375 m
.98077 .5 L
s
.125 Mabswid
.06731 .49625 m
.06731 .5 L
s
.11538 .49625 m
.11538 .5 L
s
.16346 .49625 m
.16346 .5 L
s
.21154 .49625 m
.21154 .5 L
s
.30769 .49625 m
.30769 .5 L
s
.35577 .49625 m
.35577 .5 L
s
.40385 .49625 m
.40385 .5 L
s
.45192 .49625 m
.45192 .5 L
s
.54808 .49625 m
.54808 .5 L
s
.59615 .49625 m
.59615 .5 L
s
.64423 .49625 m
.64423 .5 L
s
.69231 .49625 m
.69231 .5 L
s
.78846 .49625 m
.78846 .5 L
s
.83654 .49625 m
.83654 .5 L
s
.88462 .49625 m
.88462 .5 L
s
.93269 .49625 m
.93269 .5 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.99375 .00962 m
1 .00962 L
s
.99375 .10577 m
1 .10577 L
s
.99375 .20192 m
1 .20192 L
s
.99375 .29808 m
1 .29808 L
s
.99375 .39423 m
1 .39423 L
s
.99375 .49038 m
1 .49038 L
s
.125 Mabswid
.99625 .03365 m
1 .03365 L
s
.99625 .05769 m
1 .05769 L
s
.99625 .08173 m
1 .08173 L
s
.99625 .12981 m
1 .12981 L
s
.99625 .15385 m
1 .15385 L
s
.99625 .17788 m
1 .17788 L
s
.99625 .22596 m
1 .22596 L
s
.99625 .25 m
1 .25 L
s
.99625 .27404 m
1 .27404 L
s
.99625 .32212 m
1 .32212 L
s
.99625 .34615 m
1 .34615 L
s
.99625 .37019 m
1 .37019 L
s
.99625 .41827 m
1 .41827 L
s
.99625 .44231 m
1 .44231 L
s
.99625 .46635 m
1 .46635 L
s
.25 Mabswid
1 0 m
1 .5 L
s
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
% Start of gray image
p
.01923 .00962 translate
.96154 .48076 scale
200 string
200 100 8 [200 0 0 100 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
78766B563C200B0C100B060F16160E060E16160E060E16160E060E16160E060E16160E06
0E16160E060E16160E060E16160E060E16160E060E16160E060E16160E060E16160E060E
16160E060E16160E060E16160E060E16160E060D14120A0F22333F423E35291F1A1B2435
4B657E93A3ADB2B5B5B4B0A89A876F553B26150A04010000000001050C18293F59738A9D
A9B1B4B5B4B2ACA1907960462E1B0E0602000000000003081221364E688196A5AEB3B5B5
B3AFA697836A503722120803060C141F2E3F5162
78776D594026141213100D131918130E131818130E131818130E131818130E131818130E
131818130E131818130E131818130E131818130E131818130E131818130E131818130E13
1818130E131818130E131818130E131818130E1217161217263641443F35291E17182234
4B657E92A2ABAFB1B1B0ADA69A876F553C27160B04010000000001050C182A405A738A9C
A8AEB1B1B1AFAAA08F7960462F1C0F0702000000000103091322364F698195A4ACB0B1B1
B0ACA597836B513823140A06080D141F2E3E5162
7979705E462F1F1A191615191D1D1916191D1D1916191D1D1916191D1D1916191D1D1916
191D1D1916191D1D1916191D1D1916191D1D1916191D1D1916191D1D1916191D1D191619
1D1D1916191D1D1916191D1D1916191D1D1915181C1C1B202D3B44464036291C12132034
4C657E92A0A7ABABABABA9A4988770563D28170C05020000000102060D192B415B748A9B
A5AAABABABAAA79E8F7A6148301D1007030100000001040A142338506A8195A1A8ABABAB
ABA9A296836C523A25150C08090D141F2D3E5062
7A7C74644F3A2B24211E1D202424211F212424211F212424211F212424211F212424211F
212424211F212424211F212424211F212424211F212424211F212424211F212424211F21
2424211F212424211F212424211F212424211F202324252A354148494237291A0D0D1E33
4C667E919DA3A4A3A3A4A4A0978771583F29190D06020100010103070F1B2D435C758A99
A1A4A3A3A3A4A29B8E7A6249321F1108040101000102050B152539526B82939EA3A4A3A3
A4A39F94836D543B27170D09090D141F2D3E5062
7B7E796B5946372F2B29282A2C2C2A292A2D2D2A292A2D2D2A292A2D2D2A292A2D2D2A29
2A2D2D2A292A2D2D2A292A2D2D2A292A2D2D2A292A2D2D2A292A2D2D2A292A2D2D2A292A
2D2D2A292A2D2D2A292A2D2D2A292A2D2C2A292A2D2E30353F484E4C45392A1A09091D34
4E677E909A9D9B99989A9D9C9586725A412C1A0F0703020101020408101D2F455E768996
9C9C9A98999C9D998D7B644B3421130A050201010103060C17273C546C82929B9D9B9898
9B9D9B93836E563E29190F09080C131F2D3E5062
7D817E736453453D38353435373736353637373635363737363536373736353637373635
363737363536373736353637373635363737363536373736353637373635363737363536
3737363536373736353637373635363737363536383A3C4249515451483B2C1B0C0C1F37
50697F8E9696918C8B8F94979386735C442E1D10090402010102050A121F324860778994
97948E8B8D9296958C7C664E3723150B060302010204070E19293E566E82909695908C8C
90959791847058402B1B1009070B131E2C3D4F61
7E84847C6F61544B46434142434343424344444342434444434243444443424344444342
434444434243444443424344444342434444434243444443424344444342434444434243
444443424344444342434444434243444443424345474A4F555A5B564C3E2F201314243B
536C808D928E867E7D828B919087755F47311F120A0503020203060B1422354B63798991
918A817C7F878F928C7D69513A26170D07040202020409101C2C415970838F928D847D7D
848C928F84725B432E1D1008040A131E2C3D4F61
7F8789857B6F645C56525151525251515152525151515252515151525251515152525151
515252515151525251515152525151515252515151525251515152525151515252515151
52525151515252515151525251515152525151525456595D6164625B504233251C1D2B40
586F818C8E86796E6C74818B8E8777624B3522150C0603020204070D1725384F667A898E
8A7F726B707C888E8B7F6B543D291A0F0804020203050A121F30455C72848D8D84776D6D
76838C8D85745E47311F11070109131E2C3C4E60
7F8A8F8D877E746D67636262626262616262626261626262626162626262616262626261
626262626162626262616262626261626262626162626262616262626261626262626162
62626261626262626162626262616262626262636466696B6E6E6A615445372B24263246
5C72838B8A7E6C5D596577868C877A664F3926170E0704020204080F19293C53697D898C
847462595F70818B8A806F58412D1D110A05020103060C152233496075858C887B695B5A
687A878C8677624B35221409030A131E2C3B4D5F
7F8C9496938C857E79767473747373737373737373737373737373737373737373737373
737373737373737373737373737373737373737373737373737373737373737373737373
73737373737373737373737373737374747374747677797B7B79726759493B302B2E3A4C
6276858B8677604B46566E818A887D6A533D291A1009040102050A111D2C40576D7F8989
7E6A52454D647A888A83725D463120140B06020103070E1725384D6478868B84735C4847
5A71838B877A664F3926170C080C141F2B3A4B5D
7F8D989E9E9B95908C898786868686868686868686868686868686868686868686868686
868686868686868686868686868686868686868686868686868686868686868686868686
868686868686868686868686868686868686868788898A8A88837A6D5D4C3E3431354152
677A878B837055383148667D898A806E58422E1E120A050102060B142031455C71828B88
7A6143303C5A74868B8576614B3624160D0702000409101A293C52697C888B816C4F3533
4D6A808A897D6A543E2A1B100D0F161F2B39495B
7D8E9CA4A8A8A6A29F9C9B9A999999999999999999999999999999999999999999999999
999999999999999999999999999999999999999999999999999999999999999999999999
999999999999999999999999999999999999999A9A9B9B99968E8373604E3F36343A4758
6C7E8A8C826C4C281D3D607A898C84735D473221150C060203070D1724354A6176868C88
775A371A2E5271858C887B66503A281A0F080402050A121E2E41586E808B8B7F67462321
43657E8B8B816F59432F1F151112171F2A374758
7B8E9EAAB2B5B5B3B1AFAEADADADADACACADADACACACADADACACACADADACACACADADACAC
ACADADACACACADADACACACADADACACACADADACACACADADACACACADADACACACADADACACAC
ADADACACACADADACACACADADACACACADADADADADADADABA8A3998B78644F3E35353D4B5E
72838E8E826A481F0D385D7A8A8F8878634C3726180F08050509101A283B50677B8A8F88
76583106264F6F858E8C7F6C56402C1D120A0604070D152233475D73858E8D7F65421814
3F637D8C8E86755F4935241A1414181F29354454
778CA0AFBAC0C3C3C2C1C0C0BFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBF
BFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBF
BFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBEBBB7AFA3937E664F3C32333E4F63
77889191846C4A24163A5F7B8D928C7E69523D2A1C110B07080C131E2D40566D818E928B
775934132A507187919085725C463121150D08070A0F1926384D647989928F8167441E1B
41647F8E928A7B654F3A291E1715171E27334050
738AA0B3C1CACFD1D2D2D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1
D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1
D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D0D0CFCECAC5BBAD9B83694E382B2E3D5268
7D8D9694877051322943647F909692847059432F20150E0A0B0E162232465D738793968E
7B5E3E283656748A95958A79634C372619100B0A0C131D2B3E536A7F8F9693846B4B2E2C
496982929690816C56402E211815161C25303C4B
6E87A0B5C6D2D9DDDFE0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0
E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0
E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0DFDEDCD8D1C6B7A2896C4E3221273C546D
82929A988C765B433D506B83949B978A776049352418100D0D111A27384D647A8D989A92
80664C3C465F7A8E999A907F6A533D2B1D130E0C0F162130445A7186959B97887256403F
546F87969B9587735C4633241913131A232D3845
68839EB6CAD8E2E7EBECEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDED
EDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDED
EDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDECEAE8E3DCD0C0AA8F6F4E2D14203B5872
88989F9D917D6654505D748999A09D917E67503B291B120E0F141D2C3E546B81939E9F97
86705A4F566A81949E9F9786715A433020160F0E111925364B62798D9BA09C8E79635251
61788D9BA09B8E7A644D3826180F1018212A333E
617F9CB7CCDDE8EFF3F5F6F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7
F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7
F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F6F6F4F1ECE5D9C8B19574512C071C3D5C78
8E9EA4A296857263606B7D909EA5A398866F58412E1F140F0F162131455C73899AA4A49C
8D7A686065758899A3A59D8E79614A352418100E121C2A3C52698094A1A5A194826F6261
6D8093A0A5A195826B543D29180B0B1620272D37
5B7A9AB6CEDFEBF3F8FBFCFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFD
FDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFD
FDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFCFAF8F3EBE0CFB89C7B5731112143637F
95A4AAA69C8C7C706E768596A3AAA89E8D7860483322150D0E1725374C647B91A1A9A9A1
9383746E727F8F9EA8AAA395816A523C291A100C131E2F435A72889BA7AAA59A897A6F6F
788898A5AAA79C8A735B432D190708161F24272E
547698B5CDE0ECF5FAFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFBF7F0E5D5BFA484603D252F4D6C87
9CAAAEABA092847B79808C9BA7AEAEA5958068503926160A0C18293D546C8498A7AEAEA6
998A7E797C8795A3ACAFAA9D89725A422E1C0E091222344A627A90A2ACAFAA9E90827A7A
818F9DA9AFADA3927C634A321C0A0B171F222024
4F7396B4CCDEEBF3F8FBFDFDFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFDFCFBF7F1E8D9C6AC8E6D4E3B425B7791
A4AFB3AEA4978A828186919FABB2B3AC9D897158412B18070A1B2E445D758DA0ADB3B1A9
9C8F8580838C99A6B0B3B0A4927B634A341F0E0313263B526B8399A9B2B3ADA295898181
8894A1ACB3B2AA9A856C533A2313121B2120191A
4C7194B2CADBE7EFF4F6F7F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8
F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8
F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F7F5F0E8DCCBB4997B6152576B849B
ACB5B6B0A6998E86858A94A1ADB5B7B2A5927B6249321C0A0D20354D667F96A8B3B7B4AB
9E928985878F9BA8B2B7B5AB9B856C533B251107172C435C758DA1AFB6B6AFA4978C8585
8B96A3AEB6B7B0A28E765C432D1E1C212420130F
4C7193B0C6D7E1E8ECEEEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEF
EFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEF
EFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFF0F0F0F0EFECE7DDCFBCA48B75696D7D92A5
B3BAB9B1A6998E87858A94A0ADB6BAB7AD9B856C533B251416283F5771899FAFB8BAB5AB
9E928985878F9BA8B3BAB9B2A38F775D452D1A1220354D667F96A9B5BAB8B0A4978C8686
8B96A3AFB8BAB6AA9881684F392B272928211107
4F7393AEC2D0D9DEE1E2E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3
E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3
E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E4E4E5E5E6E5E3DDD2C3B09B8980838FA0AF
BABDBAB1A4968B838287919EACB7BDBCB4A490785F46312324344A637C94A7B6BDBCB5A9
9C8F8682848C98A6B3BBBDB8AC998269503927212C4058728AA0B0BBBDB9AFA194898383
8893A0AEB8BDBBB1A18C745C473933322F261611
557693ABBDC8CFD2D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4
D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4
D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D5D5D7D8DADCDCD9D3C8BAAA9C9597A1AEB9
C0C0BAAEA091857D7C818B9AA8B5BEC0BAAD9B846C54403435435870889EB0BCC0BDB3A6
9789807B7E8693A2B0BBC0BDB4A38E765E4837323C4F667E96A9B8BFBFB8AC9D8F837C7C
828E9CABB7BFBFB8AB98816B5749413D382E2120
5D7A94A8B6BFC3C4C4C4C4C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3
C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3
C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C4C4C6C9CCCFD3D4D2CCC2B7ADA8AAB1BAC2
C5C2B8AB9A8A7C7472788393A4B3BEC2C0B6A6917B6452474854687F95A9B8C1C2BCB0A1
90817672757E8C9DADBAC1C2BBAD9A846D594A464E5F758CA1B3BEC2BFB6A897877A7373
798696A6B5BFC2BFB4A38F7A6759504A43393030
678095A5AFB4B5B5B4B2B1B1B1B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0
B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0
B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B1B1B2B4B7BBC1C7CCCECDC9C2BCB9BABFC5C9
C8C2B6A592807168666D798B9DAFBCC4C4BEB19F8A76655C5D68798EA2B3BFC5C3BAAC9A
88776B6669738395A8B7C1C5C1B7A7937E6C5F5B6271859AADBBC3C5BFB2A28F7D6F6767
6E7C8EA0B1BEC4C4BCAF9D8A786A605850473F41
718595A1A7A8A7A4A2A09E9E9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D
9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D
9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9E9FA0A4A9B1BAC2C9CDCDCBC8C7C8CBCECE
CAC0B19E8A76655A585F6E8196A9B9C4C8C5BBAC9A897A72727C8B9EAFBDC6C8C3B7A692
7E6B5E585B67798DA1B3C0C7C7C0B3A2907F7471778496A8B8C3C8C6BCAE9B8672635959
61718499ACBCC5C8C4BAAB9A8A7C71685F565152
7B8A959C9D9B97938F8C8B8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A
8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A
8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8B8D90969FAAB6C1C9CFD1D1D2D3D5D5D2
CABDAC97806A574B495162768DA3B5C3CACBC4B9AA9B8F8888909EADBBC6CBC9C1B29F89
735F4F494D5A6D849AAEBEC8CBC8BEB1A1938A878C98A7B6C2CACBC5B9A8927C67554A4A
54657A91A6B8C5CBCAC4B8AA9B8E82786F676264
848E9496938D87817C797877777777777777777777777777777777777777777777777777
777777777777777777777777777777777777777777777777777777777777777777777777
7777777777777777777777777777777777777777797C838D9AA9B8C4CED4D8DADBDCD9D3
C9B9A58E765E4A3C3943556C849BB0C1CBCFCDC5BAADA39D9EA5AFBCC6CDCFCABEAD9780
685241393E4D627A92A8BAC7CECEC9BFB2A79F9DA1AAB7C2CBCFCDC4B5A18A725B473B3A
465970889FB3C3CCCFCCC4B8AB9F948A80797474
8D91928F887F766F6A676665656565656565656565656565656565656565656565656565
656565656565656565656565656565656565656565656565656565656565656565656565
65656565656565656565656565656565656565656669707A899BACBDCAD4DBDFE1E0DBD3
C6B39E856C533D2D2A3549617A93AABDCAD2D3CFC7BEB6B2B2B7C0C9D0D3D1C9BAA68F76
5D4633292F40577089A1B6C6D0D3D1CBC2B9B3B1B5BCC5CED3D3CDC1AF9981674F3A2C2B
384D657F97AEC0CCD3D3CEC5BBB0A59B928A8584
93928F877C71665E59565555555555555555555555555555555555555555555555555555
555555555555555555555555555555555555555555555555555555555555555555555555
555555555555555555555555555555555454545454575D68788BA0B4C5D2DCE1E3E1DBD0
C1AD967C624932201B293F58718BA3B8C8D3D8D8D4CDC8C5C5C9CED4D8D8D2C6B59F876D
533B261B22354D678099B0C2CFD7D8D6D0CAC5C4C7CCD2D7D8D5CCBDA991785E452E1E1D
2D435C768FA7BBCBD4D8D7D1C9BFB6ACA39B9592
98938A7E7062564D48464545464646464646464646464646464646464646464646464646
464646464646464646464646464646464646464646464646464646464646464646464646
464646464646464646464646464646464645454444464B56677C94AABECEDAE1E3E0D9CC
BBA58D73594029150F20364F69839CB2C5D3DBDEDDDAD7D5D5D7DBDEDEDAD1C2AF987E64
4B331C0D182D455E7891A9BECED8DDDEDCD8D5D5D6D9DDDEDCD5C9B7A2896F553C251211
243A536D87A0B6C7D4DBDDDBD5CDC5BBB2AAA39F
9B9185756454473E3A383838383838383838383838383838383838383838383838383838
383838383838383838383838383838383838383838383838383838383838383838383838
383838383838383838383838383838383838383736363B45576E87A0B6C9D6DEE0DDD4C6
B49D856B523A230E061A3047607A94ABC0D0DCE2E5E5E3E2E2E3E5E5E1DACEBDA88F765C
432C170312273E566F89A2B8CAD8E0E4E5E4E3E2E3E4E5E3DED4C4B19A81674E36200B09
1E344C657E98AFC3D2DCE2E2DFD9D2C9C1B8B0A9
9D8F7F6C594739312D2C2C2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D
2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D
2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2C2B2A292C3648607A95ADC2D0D9DCD8CEBF
AC957C634B34200E08182C4159728BA4BACCDAE4E9ECECECECECECE9E3D8C9B6A0876E55
3D2815071123384F67819AB1C5D5E0E7EBECECECECECEAE6DDD0BFA991785F47311D0C0A
1B2F455D768FA8BDCFDBE4E7E6E3DDD5CDC4BBB2
9D8B78634E3B2D2522212223232323232323232323232323232323232323232323232323
232323232323232323232323232323232323232323232323232323232323232323232323
2323232323232323232323232323232323232322201E1F293B536F8AA4B9C9D3D5D1C7B7
A38C735B44301F110E19293C526A829BB2C7D7E3EBF0F2F3F3F2EFEAE1D4C3AF977E654E
3826160E132234485F7891A9BFD1DEE8EEF2F3F3F3F1EDE5DACBB8A1897057412D1C100F
1B2C3F566E879FB6C9D8E3E9EBEAE5DFD7CDC3B8
9B87715A4430221A18191A1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B
1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B
1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1A1815151E304864809AB1C1CBCEC9BEAE
99826A543F2D1E14121A26374B617A92AABFD1E0EAF1F5F7F7F4F0E9DECFBCA68E755D47
3424181216203042586F88A0B7CADAE6EFF4F6F7F6F2ECE3D5C4AF988067503C2A1C1313
1B293A4E657E96AEC2D4E0E9EDEEEBE6DED4C9BC
98826A523B27191111121414151515151515151515151515151515151515151515151515
151515151515151515151515151515151515151515151515151515151515151515151515
1515151515151515151515151515151515151514120E0C15273F5A7791A8B9C2C5C0B5A4
8F79624C39291D16151A243244597189A1B7CADAE6EFF4F7F7F4EEE5D8C7B39D856D5641
30221814171F2C3C50677F97AEC3D4E2ECF3F6F7F5F1E9DECFBCA68F775F4937271C1515
1B2635485D758DA4BACDDCE6EDEFEEE9E2D8CCBD
957D644B3420110A0B0D0F0F100F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F
0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F
0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F1010100F0D09050F2138526E889FAFB9BBB6AA99
856F5A4534261C161519212E3E52687F97ADC1D3E0EAF1F4F3F0E9DED0BEA9937B644E3B
2B201815171D2837495E758DA4B9CCDBE7EEF3F4F2ECE3D6C6B29C856D574331241B1615
1A233041556B839AB1C4D5E1E9EEEEEAE4DACDBD
90775D442D1A0C05070A0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B
0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B
0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0C0C0C0B07000C1D324C668096A6AFB1ABA08F
7B66513F2F22191514171E29384A5F758CA3B7C9D8E3EAEEEDE9E1D6C7B49F88715B4735
271D1614151B243142566B8299AFC2D2DFE8EDEEEBE5DBCDBCA8927B644F3C2C21181414
18202B3B4D627990A6BBCCDAE4E9EBE9E3D9CCBB
8B72583F2917090005070808080808080808080808080808080808080808080808080808
080808080808080808080808080808080808080808080808080808080808080808080808
08080808080808080808080808080808080809090906040B1A2E465F788D9CA5A6A19584
715D4938291E161212141B243242566B8197ACBFCEDAE1E5E5E0D8CCBCA9947E67523F2F
231914111318202C3B4D62788EA4B7C8D5DFE4E5E3DCD1C3B19D87705B4736271D161212
151C263445596F859BB0C2D1DCE3E6E4DFD6C9B7
866C533A2514080204060606060606060606060606060606060606060606060606060606
060606060606060606060606060606060606060606060606060606060606060606060606
06060606060606060606060606060606060607070707070D192B41597084939B9C968A7A
67544232241A130F0F1117202C3B4D61768CA0B3C2CED6DADAD5CDC0B09D88735E4A382A
1E16100E10141C263445596D8398ABBCCAD4D9DBD8D1C6B7A5917C66523F2F2219120F0F
1218222E3E50657A90A4B6C6D2DADEDED9D1C3B2
80674E372313090404050504040404040404040404040404040404040404040404040404
040404040404040404040404040404040404040404040404040404040404040404040404
04040404040404040404040404040404040405060607080E19293E54697C8A91918B7F6F
5E4C3B2C2016100C0B0E131B263445586C8094A6B6C2CACECDC9C0B3A3917D6854423224
1A120D0B0C1118212E3E5063788C9FAFBDC7CDCECBC4B9AA9985715C49382A1E150F0C0B
0E141D2937485B6F8498AAB9C6CFD4D5D1C9BDAC
7A624A3421130A0504040303030202030303030303030303030303030303030303030303
030303030303030303030303030303030303030303030303030303030303030303030303
030303030303030303030303030302020203030406070A0F19283A4F6374818787807465
544334261B130C09080A1017212E3D4E61748799A8B4BCC0C0BBB2A69684715E4B3A2C1F
160F0A08090D141D283647596C8092A2AFB9BFC0BEB6AB9D8C7966534131241A110C0808
0B11192330405164788B9DACB9C3C8CAC8C1B5A5
745D463120130A0604030302020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020101020305070A101927384A5D6D787E7D766A5C
4C3C2E21170F0A0605080D141D28364557697B8B9AA6AEB2B1ADA498897866544333261B
120C0705060A101923303F4F61738594A1ABB0B2AFA89D8F7F6D5B4A392B1F160E090505
080E151E2A38485A6C7E8F9FABB5BBBEBDB7AC9D
6E58422F1F130B0704030201010101010101010101010101010101010101010101010101
010101010101010101010101010101010101010101010101010101010101010101010101
010101010101010101010101010101010101010204070A101925354657667074736C6052
4335281D140D070302050A1019232F3D4D5E6E7E8C979FA2A29E958A7C6C5B4A3B2D2117
0F09050204080E151E2A374657687886939CA1A3A0998F827262514132261B120C070303
060B121A25314050617282909DA7ADB1B0ACA295
68533F2D1E120B0704020100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000204060A1018243343525F686B6962574A
3C2F2319110B06020104080E151E2936445363717E889093938F877C6F60514133271C14
0D08030003060B121A24303E4D5C6B79858D9294918B8175665748392C20170F0A050101
05090F16202B3847566675828E989FA3A3A0988C
624F3C2B1D120B0604020100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000103060A101823303F4D59616360594E42
35291E150E0905020103070C121A232F3B495765717A81848480796F625547392D211811
0B06030102050A0F161F2A3643515F6C777F8385827C73685B4D3F32261C140D08040101
04080D131B25313E4C5A68748089909496948D82
5C4A39291C120B0603020000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000010306090F17222E3C4853595B5851463A
2E231A120C0704020203060A0F161E2834404D59646D737676726B62574A3E32261D140E
090503010205080D131A242F3B47545F69717576746E665C5043372B2118110B07040202
04070B1017202A36424F5B67717A818688878279
564636271B110A0603010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000010305090F16202C38444D535450493F34
281E160F0A060402020305080D121A222D37434E5860656868655E564C41362B2118110C
080503020204070B10161F28333E49545D63676866615A50463A2F251C140E0906030202
0306090D141B242E3945505A646C72787B7B7770
514233251A100A0603010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000010205090E161F2A3540484C4D4941382D
231A130D08050302020304070B0F161D26303A434C54595B5B58524B42382E251C150F0A
06040302020406090D131A222C363F4951575A5B5A554E463C32281F17110C0805030202
0305070B10171F28313B454E575E646A6D6F6D67
4B3E302318100A0503010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000010205080E151E28323C434646423A3128
1E16100B0704030202020406090D12192029323A42484D4F4F4C47413930271F18110C08
05030202020305070B10161D252E373F464B4F4F4E4A443C342B221B140E0A0604030202
020406090E131A222A333B434A51575C6063625E
463A2E22170F090503010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000010205080D141C262F383E41403B342C22
1A130D090603020101020305070B0F151B232A32393E424444423D383129211A140E0A07
0403020102020406090D121920272F363C414444433F3A342C241D16100C080503020101
020305080B10161C242B32393F454A4F54585856
41372B20160F090503010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000010204080D131B242D343A3C3A362E261E
16100B07040302010101020406090D11171D242A3035393A3A38342F29231C16100C0805
0302010101020305070B0F141A21282E33373A3B3936322C251F18130E0A060402010101
01020406090D12181E242B30353A3F44494D4F4E
3C33291E150E090502010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000010204080C121A222A313537353029221A
130D0906040201010001020305070A0E13181E24292D303231302C28231D17120E0A0704
030101000101020406090D11161C21272B2F3132312E2A251F1A140F0B08050302010101
01020305080B0F14191E24282C3034393E434646
3830261D140D080502010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000010204070C121920282E3132302B251D16
100B070503010100000001020406080C1014191E2226282A2A2825211D18130F0B080503
020100000001020305070A0E12171C202428292A2927231F1A15110D0906040201010000
0101020406090C1015191E2124272A2F343A3E40
342D241B130D080402010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000010204070B11171F252B2E2E2C27201913
0D09060402010000000001020305070A0D1115191C20222323211F1C1814100C09060403
01010000000001020406080B0F13171B1E21232322201D1A16120E0A0705030201000000
0001020305070A0D1115181B1D1F22262B323739
302A221A130C080402010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000010204070B10161D23282B2A28231D1610
0B0705030201000000000001020405080A0E1114181A1C1D1D1C1A1714100D0A07050302
0100000000000102030507090C101316191B1D1D1C1B1815120E0B080604030101000000
000101020406080B0E11141617181A1E232A3033
2D272019120C070402010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000010204070A0F151B21252727241F19130E
09060402010000000000000102030406080B0E111315171818171513100D0B0806040302
0100000000000101020405070A0D0F1215161818171614110F0C09070503020100000000
00000102030507090B0E1012131313171D242A2E
2A251F18110B070402010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000010204060A0F141A1F232524211C16110C
0805030101000000000000010102030507090B0E101213141313110F0D0B080605030201
000000000000000102030406080A0D0F111213141312100E0C0907050402010100000000
0000010102040507090B0D0E0F0E0E11171E252A
27231D16100B070402010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000010204060A0E13191D2122211E19140E0A
060402010000000000000000010203040507090B0D0E0F10100F0E0C0B09070504020101
00000000000000010102030506080A0C0E0F10100F0F0D0B090806040302010000000000
000000010203040607090B0C0B0A090C121A2126
24211B15100A060402010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000001020306090E12171C1F201E1B17120C08
05030101000000000000000001010203040607090A0B0C0D0D0C0B0A0807050403020101
0000000000000000010202040506080A0B0C0D0D0C0C0A09080604030201010000000000
000000010102030406070909090705080E161D23
221F1A140F0A060402010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000001020306090D12161A1D1D1C1914100B07
040201000000000000000000000101020304060708090A0A0A0A09080705040302010100
00000000000000000101020304050608090A0A0A0A090807060503020201000000000000
000000000102020305060708070502050C141B20
201D19140E0A060302010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000001020305090C1115191B1B1A17130E0906
030100000000000000000000000101020203040506070808080807060504030202010000
000000000000000000010102030405060708080808070706050403020101000000000000
000000000101020304050606060401040A12191E
1E1C18130E09060302010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000001020305080C101417191A1815110C0805
030100000000000000000000000001010203030405060606060605050403020201010000
000000000000000000010102020304050506060606060504040302010100000000000000
000000000001010203040505050402040A11171C
1D1B17120D09060302010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000001020305080B0F1316181816130F0B0704
020100000000000000000000000000010102030304040505050504040302020101000000
000000000000000000000101020203040405050505040403030201010100000000000000
000000000000010102030405050404050A10161A
1C1A16110D09050302010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000001010305080B0F1215171715120E0A0704
020000000000000000000000000000010101020203030404040403030202010100000000
000000000000000000000001010202030303040404030303020101010000000000000000
000000000000010102020304040505060A101519
1B1915110C08050301010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000001010305070B0E1114151514110D090603
010000000000000000000000000000000101010202020303030302020201010100000000
000000000000000000000000010102020203030303030202010101000000000000000000
000000000000000101020303040506070B101418
1A1814100C08050301010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000001010305070A0D1113141412100C090503
010000000000000000000000000000000001010102020202020202010101010000000000
000000000000000000000000000101010202020202020201010100000000000000000000
000000000000000001010203040506080B101418
191714100C08050301000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000001010304070A0D10121313110F0B080503
010000000000000000000000000000000000010101010101010101010101000000000000
000000000000000000000000000001010101010101010101010000000000000000000000
000000000000000000010203040506090C101417
1816130F0B08050301000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000001030407090C0F111212100E0B070503
010000000000000000000000000000000000000101010101010101010000000000000000
000000000000000000000000000000010101010101010101000000000000000000000000
000000000000000000010102030507090C101417
1716120F0B07050301000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000001020406090C0F111211100D0A070402
010000000000000000000000000000000000000000010101010101000000000000000000
000000000000000000000000000000000001010101010000000000000000000000000000
000000000000000000000102030507090C101316
1715120E0B07050301000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000001020406090C0E1011100F0C09070402
010000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000102030507090C101316
1614120E0A07040301000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000001020406090B0E0F10100E0C09060402
010000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000101030406090C101315
1614110E0A07040201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000001020406080B0D0F0F0F0E0B09060402
010000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000001020406090C101315
1514110D0A07040201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000001020406080B0D0E0F0E0D0B08060402
010000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000001020406090C0F1215
1513100D0A07040201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000001020406080A0C0E0E0E0D0A08060402
010000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000001020406090C0F1214
1513100D0906040201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000001020405080A0C0D0E0D0C0A08050402
010000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000001020406090C0F1214
1412100C0906040201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000001020305070A0C0D0E0D0C0A08050302
010000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000001020406090C0F1214
14120F0C0906040201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000102030507090B0D0D0D0B0A07050302
010000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000001020406080B0F1114
14120F0C0906040201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000102030507090B0C0D0C0B0907050302
010000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000001020306080B0E1113
13120F0C0906040201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000102030507090B0C0C0C0B0907050302
010000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000001020305080B0E1113
13110F0C0906040201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000102030507090B0C0C0C0B0907050302
010000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000001020305080B0E1113
13110F0C0906040201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000102030507090A0C0C0C0A0907050302
010000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000001020305080B0E1113
13110E0B0806040201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000102030507080A0B0C0B0A0807050302
010000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000001020305080B0E1012
12110E0B0806040201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000102030506080A0B0B0B0A0806050302
010000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000001020305080B0E1012
12110E0B0806030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000102030506080A0B0B0B0A0806050302
010000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000001020305080B0E1012
12100E0B0806030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000102030406080A0B0B0B0A0806040302
010000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000001020305080A0D1012
12100E0B0805030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000102030406080A0B0B0B0A0806040302
010000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000001020305080A0D1012
12100E0B0805030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000010203040608090A0B0A090806040302
010000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000001020305080A0D1012
12100E0B0805030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000010203040608090A0B0A090806040302
010000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000001020305070A0D1011
11100D0B0805030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000010203040608090A0B0A090806040302
010000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000001020305070A0D1011
11100D0B0805030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000010203040608090A0B0A090806040302
010000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000001020305070A0D0F11
11100D0B0805030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000010203040608090A0A0A090806040302
010000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000001020305070A0D0F11
11100D0A0805030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000010203040608090A0A0A090806040302
010000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000001020305070A0D0F11
11100D0A0805030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000010203040607090A0A0A090706040302
010000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000001020305070A0D0F11
11100D0A0805030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000010203040607090A0A0A090706040302
010000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000001020305070A0D0F11
110F0D0A0805030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000010203040607090A0A0A090706040302
010000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000001020305070A0D0F11
110F0D0A0805030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000010203040607090A0A0A090706040302
010000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000001020305070A0D0F11
110F0D0A0805030201000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000010203040607090A0A0A090706040302
010000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000001020305070A0D0F11
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  InitializationCell->True,
  ImageSize->{288, 177.938},
  ImageMargins->{{281, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40n007h00Ooooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00
oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQ
ool001Woo`8003Woo`<000Coo`8003?oo`@000?oo`8000Coo`80033oo`@000;oo`<000Coo`80033o
o`@000?oo`8000Coo`8000?oo`006?oo00@00?ooool003_oo`04003ooooo0002ool00`00ooooo`0b
ool01@00oooooooo00000_oo00@00?ooool000;oo`03003ooooo02ooo`03003ooooo00Coo`04003o
oooo0002ool00`00ooooo`0]ool00`00ooooo`03ool01000ooooo`000_oo00@00?ooool000;oo`00
6?oo00@00?ooool003_oo`04003ooooo0002ool00`00ooooo`0bool01@00oooooooo00000_oo00@0
0?ooool000;oo`03003ooooo02ooo`03003ooooo00Coo`04003ooooo0002ool00`00ooooo`0^ool0
0`00ooooo`02ool01000ooooo`000_oo00@00?ooool000;oo`006?oo00@00?ooool003Soo`<000?o
o`04003ooooo000dool01@00oooooooo00000_oo00@00?ooool000;oo`03003ooooo02ooo`04003o
ooooool30003ool01000ooooo`00<Ooo00D00?ooooooo`0000;oo`04003ooooo0002ool10001ool1
ool001Soo`04003ooooo000hool00`00ooooo`03ool01000ooooo`00=?oo00D00?ooooooo`0000;o
o`04003ooooo0002ool00`00ooooo`0_ool01@00oooooooo00001Ooo00@00?ooool003;oo`04003o
oooo0002ool01000ooooo`000_oo0@000Ooo0Ooo000Hool01000ooooo`00>?oo00<00?ooool00ooo
00@00?ooool003;oo`<000?oo`04003ooooo0002ool01000ooooo`00;ooo0`000ooo00<00?ooool0
0ooo00@00?ooool002ooo`04003ooooo0002ool01000ooooo`000_oo00@00?ooool000;oo`006Ooo
0P00>Ooo10000ooo0P00=Ooo00<00?ooool00_oo0P001?oo0P00<_oo00@00?ooooooo`@000?oo`80
037oo`8000Coo`8000Coo`8000?oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo000>ool2
0005oooo00080004ool000goo`04003ooooo0004ool00`00ooooo`02ool00`00ooooo`09ool00`00
ooooo`0:ool00`00ooooo`0:ool00`00ooooo`09ool00`00ooooo`0:ool00`00ooooo`09ool00`00
ooooo`0:ool00`00ooooo`09ool00`00ooooo`0:ool00`00ooooo`0:ool00`00ooooo`09ool00`00
ooooo`0:ool00`00ooooo`09ool00`00ooooo`0:ool00`00ooooo`0:ool00`00ooooo`09ool00`00
ooooo`0:ool00`00ooooo`09ool00`00ooooo`0:ool00`00ooooo`0:ool00`00ooooo`02ool00`00
ooooo`02ool000goo`04003ooooo0004ool2003oool3ool30004ool000goo`04003ooooo0004ool0
0`00ooooo`02ool01g_?Lji[CF]=DZXiib440088@@03264@PPQ100808003264@XQ2R0088H@030208
HA2R008@XP04264080QQ26424:8010QQ020080QQ0Q2R0PQQ00<080QQ4:800Q2R00@8H@0P2648H@8@
XP042640800P26424:8226400`0P264@XP024:800`QQ0208H@034:8010QQ020080QQ0Q2R0PQQ00<0
80QQ4:800Q2R00<8H@0P26400a2R00@8H@0P2648H@8@XP88H@030208HA2R008@XP03264080QQ00<@
XP04264080QQ26424:801@QQ020080QQ4:800Q2200<8@@QQ8@@00S6600<iid88>NL00S6V00<YAASS
6<<00QS300<Q936VBTT00V</00IkkiBBYABU5:ee]IH4]KH01kFF[EFLdicCQ31[KE:Z008ia`058B@@
XPQ124408007000202000`QQ6<<YA@02>NL00e[;Lhj<D@02W?<00jeE]IJe]P03]KH01[FF[GF]MJDD
U99kc`9S3003@RPYIAS30088H@030200000000L00007244@PR448@@aYTYYJdd00X@@00>D/ZDd[GD0
0[FF0[Ff00FeUZee[GFU=9Bb00:44003JdeBRS6V008Q10034888@@0000808003264@XQSS008YI@03
>NMBRV<<00Goo`03003ooooo00;oo`003Ooo00@00?ooool000Coo`03003ooooo00;oo`07Nlmc[V]=
JdeBZSWW8@@00PQ100<8HA2224400P0P00<8HA2R4:800PQQ00<080QQ4:800Q2R00@8H@0P2648H@8@
XP042640800P26424:8226400`0P264@XP024:8010QQ0208H@QQ0Q2R00@8H@0P0208H@8@XP88H@03
0208HA2R008@XP03264080QQ00<@XP042640800P26424:8226400`0P264@XP024:800`QQ0208H@03
4:8010QQ0208H@QQ0Q2R0PQQ00<080QQ4:800Q2R00<8H@0P26400a2R00@8H@0P2648H@8@XP052640
800P264@XP0248800`Q1264Q1002<HH00cWW@PPii`02<JH00bU56><H``026<<00b4T<JI:B@02Hb`0
1W__U9:U5:DD[GFeUPBe]P07]IJ]EIcCW=>4<6]]DZX00SW700DQ912R2448@@0P00L000808003264H
`bU5008ii`03F/]cSXaA00:Ll`03[EFeU[Ff00>e]P06]IJ]MJeeYABDTW_?0V<<00=2:2UU6<<00PQQ
00<0800000001`0000L8@A228@@Q136VBVU[C@02Q1000iBbYCB]M@02]IH2]KH01KFF[GF]MJDdU;80
0X@@00=[CE::<JH00R4400<@PPQ100000P0P00<8HA2R6><00RUU00<iie::H``01Ooo00<00?ooool0
0_oo000=ool01000ooooo`001?oo00<00?ooool00_oo00Mkcg>^Jfe[KE[;@PPQ90024:8348822640
0a226<<H``0248800`QQ488H``026<<01122264@PQ220QS300@@PPQQ264@PP8H``8@PP03264@PQS3
008H``044888HA2248826<<011222648HA220QS30Q2200<8HA226<<00QS300<@PPQQ48800aS300@@
PPQQ264@PP8H``8@PP03264@PQS3008H``034888HA2200<H``044888HA2248826<<248800`QQ488H
``026<<00a22264@PP036<<01122264@PQ220QS300@@PPQQ264@PP<@XP03488@XR4T008aYP03@PQ2
:3WW008aYP03:DDHha2R008H``038@@aYTY9009S;006NnnDTZDDYAB]EJee1;FF00N]MJDdW=>Ldh@`
JfeBZP02>NL01B4T4:88@@Q102001`000P0P00<8HAS3:DD00T8800=Jbg>>S5400Ycc00>]EJee]IH0
0kFF00J]MJeE[EFU58aaNll2H``00d8X:FDHh`0226400`0P0000000700001`Q1488Q1244<JI:JF]=
00:44003U;:U=:ee00FeUP:]M@07YCBD/X@@Q11[CE::>LL00R4400<@XPQ102000PQ100<8HA2R6><0
0RUU00<iie::H``01Ooo00<00?ooool00_oo000>ool20005ool00`00ooooo`02ool2Nll2Lhh00e[[
@RPYI@026><26<<34:800aS36><Hh`026<<00a2R6<<Hh`026><011S34:8H`aS30QSS00@H`a2R4:8H
``8Hh`8H``034:8H`aSS008Hh`046<<@XQS36<<26><011S34:8@XQS30QSS0QS300<@XQS36><00QSS
00<H`a2R6<<00aSS00@H`a2R4:8H``8Hh`8H``034:8H`aSS008Hh`036<<@XQS300<Hh`046<<@XQS3
6<<26><26<<00a2R6<<Hh`026><00aS34:8H``036><011S34:8H`aS30QSS00@H`a2R4:8H``<Hh`03
6<<Q12UU008ia`92:005@PPaYS6V:DDHh`0348800b44<JI:J@02Hb`01G__U9:U5:DDYC@01ZeE00JU
=9cCW=>4<7>>DZX2>NL01BU54:88H@QQ02001`000P0P00<8HAS3:DD00T8800=Jbg>^S5400YcC00>U
=:eE[ED01:eE0ZDd00>LlhaaNll00V<<00=:BC666><00Q2200<0800000001P0000<080Q14:800R44
00<iae::Jdd00X@@00>D/ZDD[ED01jeE00NU59BbQ12446]]DXXia`028B@00a2R2648@@0224400`QQ
4:8Hh`02:FD00cWWDXYS3005ool00`00ooooo`02ool001Goo`03003ooooo00;oo`07Nlmkkg>^LjiS
;4YY>LL00RU500<Q92446><00QSS00<Q124T8B@00R4400<Hhb448B@00R4T00@Q11SS8@@Q108Q9004
8@@HhaSS8@@28B@28@@00aSS8@@Q90028B@012446><Q12440R4T00@Q11SS6><Q108Q908Q10036><Q
124T008Q90038@@Hhb4400<Q90048@@HhaSS8@@28B@28@@00aSS8@@Q90028B@00b446><Q10038B@0
12446><Q12440R4T0R4400<Hhb448B@00R4T00<Q11SS8@@00b4T00@Q11SS8@@Q108Q90038@@HhaSS
008Q10<Q9004:DDaYT88@PP2BTT01D88<JHaYRU56<<00`QQ00<Hhc66BVT00V</00IkkiBBW?>LljDD
YC@3YA@2YC@01ZDDU;:D/X@`LhiJb`8ii`05:DDH``QQ26408007000202000`QQ6<<YI@02@PP00e[[
Ljj<D@02W=<00jDDYCBU5003YA@01ZDdYABU59cCS75kc`9S3003BTTaQQSS008@PP032440800000H0
00030208@A2R008Q9003>LMBRV]=00:44003U9:LljDD00:U=0:U5005YCBU5:DDW?>D/P02Q1000f]]
DZXia`028B@00a2R2648@@0224400`QQ4:8Hh`02:FD00cWWDXYS3005ool00`00ooooo`02ool001Go
o`03003ooooo00;oo`07Nlmkkg_?Nlm[CE[;@RP00S6V00<YIBU5:DD00bU50RUU12U50bUU12U50RUU
12U50RUU12U50bUU12U50RUU12U50RUU12U50bUU0bU50bUU12U50RUU12U50bUU0bU50bUU12U50RUU
12U50bUU0bU50bUU12U50RUU12U50bUU00<aQS6V>NL00TY90TYY00E2:3W7>LLYAAS300<8@@036><a
YTYY009S;005NnnDTYcCW=>Ll`05W=<2W?<2U;800h@`LhiJb`02@PP01BUU6<<8H@QQ02001P0000H0
80Q1244@PQSS:FD2@RP00e[[Ljj<D@02U;82W?<4W=<3W?<00icCS75kc`02Hb`00dY9<JHQ10024880
0`Q10200000600000`0P264@XP028B@00cWWDZY[K@02Q1000iBBW=>Ll`05W=<2W?<01icCU9:448@@
JfeBZSWW008YA@036<<8H@Q10088@@03264@PQSS008YI@03>NMBRV<<00Goo`03003ooooo00;oo`00
5Ooo0P000ooo00Mkcg__Nlmkcf]=F/]2:002<JH00bUU:DDYA@03:DD2:FD4:DD3:FD4:DD2:FD4:DD2
:FD4:DD3:FD4:DD2:FD4:DD2:FD4:DD3:FD3:DD3:FD4:DD2:FD4:DD3:FD3:DD3:FD4:DD2:FD4:DD3
:FD3:DD3:FD4:DD2:FD4:DD3:FD00c66<JHii`02BTT2BVT01D8X>LLiabU56<<00`Q100<Hhc6VBVT0
0V</00EkkiBBW=>Ldicc00FLd`:Ll`:D/P03Q31cSU[;00922005:FDH``QQ2640800600001P0P2448
@A226><YI@92:003F^]c[XaA00:D/P:Ll`BLd`>Ll`03W=><LG_?009S;003BTTaYR44008@PP032440
800000H000030208HA2R008Q9003>NMBZV]]00:44003U9:Ldicc00FLd`:Ll`07W=>DTX@@Q11[KE:Z
>NL00RU500<H``QQ24400PQ100<8HA226><00RUU00<iie::H``01?oo0P001?oo000Eool00`00oooo
o`02ool01g__Q11kkg__LhiS;5::0092:003>NLiac6V06PaYP<ia`03>NM224Y9009BRP03DZYBRTY9
008ia`03:FDH``QQ0088H@036><aYU::009[C@03Nnn<LIBb00:D/P05U9:<LHaAS56<L@02U;82U980
0h@`LhiJj`02@RP01RUU6><@PQ22244080D000060208@@Q1488Hhc660TY900=S37>^S54019Bb0Xaa
00><DHaaU9800iBb00N<LG__HbaS;4YY<JHQ10024:800`Q102000004000302001`QQ6<<YABU5>NMB
ZV]]00:44003U9:D/YBb00:DTP:<L@05U9:D/YBbU;:DTP02Q3000g>>F/]22002:DD00aS34888@@02
02000`Q1488Hh`02:FD00cWWBVUS3005ool00`00ooooo`02ool001Goo`03003ooooo00;oo`07Nnn4
<8@`Q31kkf]]H``00U:Z00=:BD8X@PP02D880d8X14880T8X14880T8X14880d8X14880T8X14880T8X
14880d8X0d880d8X14880T8X14880d8X0d880d8X14880T8X14880d8X0d880d8X14880T8X14880d8X
00=:BDYYDZX00e[;00MBZTYY>NLiibUU8@@@PP024:800b4T>LMBRP02Jfd01X@@S76DTYBBS764<0=k
k`03Q12<DIBB00:DTP03Q31c[U[[0092:006<HHHha224888@@0P1@0000H080Q1244@XR44<JH2BTT0
0f<<Nln<D@03U9800haAQ1244002Nnl01X@`S76<LIBBS75kk`9[C@03DXXiab4T008@XP032640800P
00@000808003244@PQSS008YI@03@PQJbg>>00:44003S76DTXaa00:4<09kk`05Q32<LHaaU9:<L@02
Q3000g>>F/]22002:FD00aSS4888@@0202000`Q1488Hh`02:FD00cWWBVUS3005ool00`00ooooo`02
ool001Goo`03003ooooo00;oo`07Nnn4<8aAS564<7_?Jfd00V</00=Jje:ZDXX0J5::0e:Z00=Jbe[[
H``00V</00=S35[;DXX00T8800<aQR4T6><00QSS00<YAD88F//00V]]00J448aaS76<LH@`Nll3Jfd0
0g>^Q12<D@02S7400h@`LjiS3002BTT01S6V8@@@XQ2R264080@000808088H@034:8Q93W7009:J@03
HbakchaA00:<L@07S55kkg>>Lhi[CG>>Nnl00XaA00><LHaANnl00V]=00=BZSWW:DD00QS300<8H@Q1
020010000P0P00<8@A226><00S6600=2:5[[Lhh00X@`0Xaa00>4<7>^Ljh00V]]00=c[X@@Q1000Xaa
0X@`00=c[U[[@RP00S6600<Hha2202000P0000<8@A226><00RUU00<iidYYH``01Ooo00<00?ooool0
0_oo000Eool00`00ooooo`02ool00g__S56<L@02S7401X@`Nnmc[W>^JfeS;6US30=S;09[C@=[K@03
JdeS35:Z0092:003<JHYAB4T008Q9003<HI2:5[[009cSP07Q12<DHaAS55kkf]]F^/00U[;00=S;7>^
Q3000Xaa00>4<7_?Hb`00TYY00Diab4T4:8@XPQQ008080<000070208@@QQ264H`bU5>NL00U::00=[
CG__S5400Xaa00N4<7>^H`aS35[;F^]cSP02Q102S5401X@@Jfe[KE[;@PPYI@8Hh`034888@@0P00@0
00808003264@XR44008aQP03BTUS37>^00:4<003S76<DG_?009[C@9Jb`05Jdekcg_?Q32<L@02Q300
0g>^H`a:B@02<JH00b444:88@@0200000`Q1488Hh`02:FD00cW7BVUJj`05ool00`00ooooo`02ool0
01Goo`03003ooooo00;oo`03Nnn<DHaa00:<L@06Q31kkg>^Lji[KF</JF<<0f</0V]=0f]]00=[CF<<
DZX00T8X00<aYRU58B@00R4T00<aQT8XF^/00W>>00N448aAS56<DG__JfeJj`02F//00f</Ljj4<002
S7400h@`NlmS;002BVT01CW78B@@XQ2R26400P0P0`0000L080Q12648HAS3:DDii`02DXX00f]=Nnn<
D@02S7401h@`LjiS36<<F/]Jjg>>00:440:<D@06Q11[KF]]F/]222UU0QSS00<@PPQ1020010000P0P
00<8HA2R8@@00S6600=:BF<<Ljh00X@`00><LHaANll00V]=0U[;00E[CG_?Nln4<8aa00:4<003LjiS
34Y9008aYP038@@@XPQ100800003244@PQSS008YI@03>LM:JE[[00Goo`03003ooooo00;oo`005Ooo
0P000ooo00=kkhaaU;800YBb00JDTXaaQ324<7__Nll3Ljh00g>>LjicSP1MLhh2Ljh00g>>Ljic[P04
Ljh5Nll00g>>HbaJb`02BTT00cW7<HHYA@02:FD00cW7BVUS3002Ljh01h@`S564<8@`LjiS34Y90092
:003DZY[KH@@00><D@06Nnm[CE::DXXiibU50QS300<@PPQ102000`0000L080Q1488@PQSS:FE22002
DZX00f]]Nnn<D@02S5401g__JdeBRU::@RQ:JF</009kc`:<D@06Q11cSW>>F^]2:3660R4400<@XPQ1
020010000P0P00<8HA2R8B@00SW700=:JF</Nll00X@`00><DH@`Lhh00U[[00=:BD8XF//00W>>00N4
48aAQ324<7_?Hba:J@02>LL00b4T4:88H@0224400`QQ4:8Hh`02:DD00cW7BTUJj`04ool20004ool0
01Goo`03003ooooo00;oo`04Nnn<LIcCW=<2W?<01YcCU;:D/YBBS76<DFR4<0J<D@:44003Nlm[KE[[
009:J@03>NLaYS66008aYP03@PQBRV</009kc`07Q32<DH@@Q11cSU:Z>LL00S6600=:BF</Nnl00haA
00J446]]F/]Jbd88:FD26><00a222440800300001`0P244@XQ2R8@@aQT8X009Jj`03Lhj448aA00:<
D@07NlmS3488@PPaQSWWF//00W>^00>4<8aAQ3000W>^00=S34Y9<JH00R4T00<@XPQQ02000`0000H0
80Q1244@PQS3:DD2>NL00e::Jdekk`03S5401h@@Jfe:JDYY<JHaQTYY009[C@07Q12<DHaAS55kkf]=
DZX00SWW00<YAAS348800`QQ00L@XQSS:DDYACW7BTUJb`05ool00`00ooooo`02ool001Goo`03003o
oooo00;oo`05Nnn<LIccW?>U=002[ED2YC@00jDDW?>Ll`1]W=<01YBbS76<LH@@LhiS309:J@03>NLa
YS6V008ia`03@RQJbf]]009kk`07S56<LH@@Q11[KDYY:DD00QSS00<iif<<Nll00XaA00><LH@`Lhh0
0U[[00M2:3668@@Q112R2640800300001`0P264@XQ2R8B@aYTY9009S3003Ljj4<8aa00:<D@07LjiJ
bc6V<JHH`bUUDXX00W>>00>4<8aaS5400W_?00=S;5::>LL00RU500<H``QQ24400P0P00L0000P2448
@A226><YI@02@PP00e[;Jff44003S54017__Hba2:48X0R4400A226</Hbakk`><D@03Q11[KE[;0092
2003:FDHha2R00<@PP074:8HhbU5:DDaYT8XF//01Ooo00<00?ooool00_oo000Eool00`00ooooo`02
ool01W_?S76Llicc[EFeUP>e]P:eUVb]M@:]E@06YABLdicCS55kcf</0TYY00<iic6V<JH00SWW00=:
BE[[Lhh00X@@0Xaa0X@@00=[CDY96><00PQQ00<iae[[Nll00XaA00><LHaANll00V<<00M:JC6V8B@Q
91S32648@@0302001`Q1488H`aS3:DDiae::009S;003Nln<DHaa00:<D@07LjiJbc66<HH0824TBVT0
0V]]00>4<8aaS7400W__00=[KE:Z@PP00RUU00<Hha222440100P0PQQ00<@XR44<HH00T8X00=Jjg>>
Q3000haa00Mkkf</@PQ221S34:8ii`02H``01g__S76<LHaaQ31c[U[[009:B@03<JHQ91S300<@XP07
6<<HhbU5:DDaYT8XDZX01Ooo00<00?ooool00_oo000Eool00`00ooooo`02ool01W_?S76Llicc[EFe
UP>e]P:eUVb]M@:]E@06YABLdicCS55kcf</0TYY00<iic6V<JH00SWW00=:BE[[Lhh00X@@0Xaa0X@@
00=[CDY96><00PQQ00<iae[[Nll00XaA00><LHaANll00V<<00M:JC6V8B@Q91S32648@@0302001`Q1
488H`aS3:DDiae::009S;003Nln<DHaa00:<D@07LjiJbc66<HH0824TBVT00V]]00>4<8aaS7400W__
00=[KE:Z@PP00RUU00<Hha222440100P0PQQ00<@XR44<HH00T8X00=Jjg>>Q3000haa00Mkkf</@PQ2
21S34:8ii`02H``01g__S76<LHaaQ31c[U[[009:B@03<JHQ91S300<@XP076<<HhbU5:DDaYT8XDZX0
1Ooo00<00?ooool00_oo000Eool00`00ooooo`02ool01W>^S76U5:DD[GFme`W666Rmm`03_MNe]Zee
00:U5003U99kkf</009:J@03>NLaQS66008ii`03BVUS37>^00:<D@:DTP:4<003Jfe:BB4T008@XP03
>LMJjg_?00:<L@03U9:<LG__009[C@07DXXiibU5:DDHha2224400P0P00<8@@QQ48800QSS00<YID88
DZX00V]]00>448aaU9800XaA00Mc[U[;<JHaYQ22:DEBRP02Lhh00h@`U9:DTP02Q3000g>>F^]2:002
<HH00b444:88H@0224401`0P2448H@QQ6<<Q93W7009:J@03HbakchaA00:DTP03S76446</0092:003
6><H`d88009S;007Nnn<LIBBU9:<DG_?Hb`00TYY00<iabU56><0112R00HHhb4T8B@aQT88DXX5ool0
0`00ooooo`02ool001Goo`8000?oo`07Lhj<DJDDYABeU/HHcUT00/iiJmJJ0lii00?>FLHh_ML00Zee
00>Ldh@@Jdd00TYY00<iabU5:FD00SWW00=BRV]=Nnl00Xaa0YBb0X@`00=cSU::<HH00RU500=226</
Nnl00YBB00>D/YBBQ3000W>>00MJbd88:FDYIB444:88H@0324401`QQ4:8Q1244<HI2:5[[009cSP03
Q32DTYBb00:<L@07NlmJjcWW>NLYAC6VDZX00W>^00><DIBbU;800XaA00=kcf<<BVT00S6V00<Q91S3
48800`Q100H8HA22488HhbU5>NL2DXX00f]=Nnn<L@02U;800iBBQ31[C@02BTT2:FD01DY9Jde[CH@@
U9800YBb00>DTX@@Jfd00U:Z00=222UU8@@00QS30Q2R00HHhb4T8B@aQSWWBTT4ool20004ool001Go
o`03003ooooo00;oo`07Jff4<:DDYABe]/HheYX00]kK0]kkJ>LL1=kk00?NfmJJaSP00[Ff00>U58aA
Jfd00TYY00<aQR448B@00SWW00=BZV]]Q1000YBB0YcC0Xaa00=c[U[;@PP00SWW00=BRV]=Q1000YBb
00>LdiBbS5400W>^00MS34Y9<JHaYR4T6<<@PP0326401a226<<Q924T>LM:JF</009kc`03S76LdicC
00:DTP07Q11S;4YYBVTiid8XF^/00W_?00><LIcCW=<00YBB00=kkf]=DXX00SWW00<YAASS488010QQ
0Q2R00<Q1366@RP00U[;00=cSX@`U;800YcC00>D/XaALhh00U:Z00=223WWDZX00V]]00N4<9BbW=>L
diBbQ31cSP02F^/00d8X<HHQ90026<<248801QS38@@Q12UU>LM2:0Goo`03003ooooo00;oo`005Ooo
00<00?ooool00_oo00M[CH@@W?>LlkFfcUWNf`02ia`00nLlkeg_O@1Xkgd3ked00nLLg__FVP02aQP0
0jeES75[K@02BVT00bUU4:8Q1002>LL00e[;Lhj<D@02W=<2W?<2U9800g__HbaBZP02DXX00e[[Ljj<
D@02W=<00jDDW?>DTP02Nnl01f</DXXiacW7:DDH`a2200<8H@074:8HhbUU:FDiie:ZJdd00X@@00>D
TYccW?<00YBb00N4<7>>F/]JbdYYDZY[C@02Q1000iBbW?>Ll`02U;800h@`LhiJb`02@PP00c668@@@
XP0326401Q226<<H`b4T<JI:B@9S3003Nln<LIcC00:U5003W?><LG_?009S309BRP05H`akcg_?S76L
d`02YA@00icCS75kc`02Hb`00dYY>LLQ90026<<00`QQ488H``028@@00bU5<HHii`05ool00`00oooo
o`02ool001Goo`03003ooooo00;oo`07Jdf449ccW?>e]/iIg]/00^LL00?W?>mMkgd0J>mm0nmM00?W
7=kkeYX00/HH00>]EHaaJfd00TYY00<YIA2R8@@00SW700=Jbg>>S5400YcC0Ycc0YBB00=kkf</DZX0
0U::00=Jjg>^S5400YcC00>U59ccU9800W__00MS;5::>LLiabU56<<@PP0326401a2R6><YIBUU>NMB
ZV]=00:44003U9:Llicc00:D/P07Q31cSU[;F/]:JE:ZJdd00X@@00>D/YccW?<00YBb00>4<7>>F//0
0T8800<aQR444:800`QQ00H@PQS36<<Q936VBTT2H``00g_?S76Ld`02YA@00iccS75kc`02H``2DXX0
1F<<NlmkchaaW=<00ZDD00>LdhaaNll00V</00=:JCW78B@00QS300<8HA226<<00R4400<YAC66>NL0
1Ooo00<00?ooool00_oo0007ool40003ool20005ool00`00ooooo`02ool01f<<NnnLlicc]KK>NMkk
00;_G@03kgggW_Nn06Wg_P;gWP03kggW?=kK00;>F@03]IJD/W>^009BRP03:FD081SS008ii`03F^]k
chaa00:Ll`06YCBU59BbU;:4<7>>0f<<00=[CG__U9800Ycc00>U=:DDW=<00X@`00M[KE[;@PQ222UU
6><@XP0326401a2R8@@aQS66@RQJjg>>00:<D@03W=>U=:Dd00:Ll`07S75kcf]=JdeS36</Ljh00XaA
00>LdjDDYC@00Ycc00><LG_?H``00TY900<aYR4T6<<00Q2200L8HA226><HhbU5>NMBRP02Jdd00h@@
U;:U5002YC@00jDDU;:44002Jfd2H``01F]]Q12449BBYA@00ZDd00>U59BbQ1000V]=00=BZSWW:DD0
0QS30PQ100H@XR448@@Q92UU<JH5ool00`00ooooo`02ool000Ooo`03003ooooo00?oo`04003ooooo
0004ool00`00ooooo`02ool01e[;NlnLdicC]KK>NMkk00;_G@03mikogooO06Soo`?og`03mik_GNLL
00;>N@03_MNLlg_?009BZP03<HH@PR4400922003H`akkiBb00:U=007[EFU=9ccW?><LG__Lhh00V]]
00=c[X@`U;800ZDD0ZeE00FLlhaaS75kcf<<009:B@03<HHQ112R00<8H@074:8Q936V<JI:JF</Nll0
0YBB00>U5:eE[ED00ZDD00NDTX@@Ljic[V]]Lhikk`02S7400icc[EF]E@02YA@00iBbQ11[C@02DXX0
0cWW:DDH``0248801`QQ488HhaSS:FE225[;009cSP03S56LdjDd00:]E@03YCBLdhaA009kc`9[K@05
Nln<DHaAW=>U=002[ED00jDdW?><D@02Lhh00e[;@PPYI@026<<00`0P244@XP026><28B@00bUUoooo
o`03ool00`00ooooo`02ool000Soo`03003ooooo00;oo`04003ooooo0004ool20003ool01e:ZLjjL
dicC]KK>NNLL00;_O@03mkkogooo06Woo`;og`03mkkgW^Ll00;F^P03_ONU=8@`009S3003>NLQ92UU
009:J@03Jff4<9cc00:]E@06[GF]EJDDYABDTX@`0g_?00>448aaW=<00ZDd0Zee00FU=9BbU;:446]=
009BRP03>LLQ912R0088@@03264H`bU5008ii`03DZY[KH@`00:Ld`03YCB]MJee00:U=007W=><DG__
Nnmkcg__Q3000YBb00>U5:ee[GD00ZeE00>LlhaALhh00U[;00=222UU6><00PQQ00L8@A228@@Q136V
BTUS3002Nll00iBBYAB]M@02[GD00jeEW?>DTP02Q102Nll01H@@S76<LIcc[ED00jee00NU59BBNnmk
kf<<BTTaQP026><224400a2R6><Hh`028@@0124Toooooooo0`001?oo0009ool01@00oooooooo0000
0_oo00<00?ooool00_oo00<00?ooool00_oo00M:JG>>U;:D/[FfcWWNn`02ked00oNNomoog`1Yool2
oml00oNnmik_G@02g]/00lHh[GF<L@02Jfd00dYY>LM22002F//00g>^U9:U=002[GD01[FF[GFU=:Dd
U;:<D@>44003Q32DTYcc00:]E@:eUP05[GFLliccS55cSP02F//00d88:DDH``0202000`Q16<<YI@02
@RP00e[[Ljj<L@02YA@00jee]IJeUP02[ED019ccS764<8@`0X@@00B<LIcCW=>U=0BeUP03YCBDTW_?
009S3003BTTaYQSS0088H@07000@PR4T8B@iae::Jdd00X@@00>LdjeE]IH00[FF00>]MJDDU;800XaA
0X@@00F<DIBbU;:U5:ee00>eUP07[EFLdh@`Q31[KE::>LL00R440Q2200@H`b448@@Q108H``Goo`03
003ooooo00;oo`002_oo00@00?ooool000;oo`03003ooooo00;oo`03003ooooo00;oo`07BVUcSYBb
U;:e]/iig_/00^mM00?gW_oOoml0JOoo0_oO00?g__NNked00]kK00?6>:eeS7400V]]00=:JCW7@PP0
0U[;00=c[YBBYC@00Zee00JeUZeeYCBU=9BbS543Q1000h@`U9:Ll`02[ED2]IH01JeeW?>LlhaALhh0
0U[;00=222U56<<00P0P00<8@AS3:FD00T8X00=Jjg>^S7400ZDD00>]MKFF]IH00ZeE00BLlhaaQ324
<0:44004S76LdicCYC@4]IH00jDdU99kc`02H``00dY9<JHHh`0226401`00488Q924T>LMBRV]=00:4
4003W=>]EKFF00:eUP03[GFU59Bb00:<D@:44005S56D/YBbYAB]M@03]IH01jeEW=>4<8@`JfeBRSW7
008Q108@PP046<<Q12448@@26<<5ool00`00ooooo`02ool000Ooo`04003ooooo0002ool01000oooo
o`001?oo00<00?ooool00_oo00M:JG>>U;:D/[FFcUWNf`02ic`00nmmmkkg_P02mkiWoml3mkh01oNN
kegNnmkkcUVe]YcC009kc`03H`aBRU:Z009[C@03Q32Ldjee00>e]P05]IJU=:DdW=><L@03Q3000haA
U;:U5002[GD2]KH01KFFYCBU=9BBNll00V<<00=:BC666><00PQ100<8HB44<JH00TYY00=S;7__U;80
0ZeE00>eU[Ff]KH00ZeE00BLliBBS56<D@:4<005S76LdicC[EFeUP03]KH00jeEW=>4<002Jfd00e::
>LLQ900248801`0P4:8YIBUU@PQJjg>^00:<L@03YAB]MKFf00:e]P03[GFU=9Bb00:<L@:4<005S56D
/YBbYAB]M@03]KH01kFFYAB<LHaaLjiJjd88008YI@8Hh`068@@Q924T8@@@PPQQ1Ooo00<00?ooool0
0_oo0008ool20004ool20005ool00`00ooooo`02ool01dYYLhjDTYBB]IK6>=Jj00;W7003keg_ONmm
06G_O@KgWP;_O@06iccNnmkkcWVmmjDd0XaA00=c[V]=Jfd00W__00>DTZDd]IH00kgG00FeUZDdYCBL
dhaa00>4<003S56D/ZDD00:]M@03]KJmekFf00:]M@07W=>4<6]]JfeBRSW78B@00a2R00LYACWWDZYB
ZW>>S56Ll`02[GD2_ML01KFf[EF]EIccU9800XaA0X@`00F<LIcCW=>]EKFF00>me`03]IJU58aa009c
[P03F^]2:2UU008H``07488Q136V<JI:JF</Nnl00YBb00>]EKFf_ML00[gG00>eUZDdU;800Xaa0X@`
00F<DIBbU;:U5:ee00>me`07]KJ]EIcCW=>446]=BVT00SW700<YAB4T:DD00RU500<Q112202001Ooo
00<00?ooool00_oo000Eool00`00ooooo`02ool01dYYLhjDTYBB[GG66=JJ00;Nf`03g__W7>LL06GW
70SW?006iacNnmkkeY[66;FF0YcC00><DH@@Q1000Xaa00>U5:ee_ML00[gg00JmekFFYCBU=9BbS543
Q1000h@`U9:Ll`02[GD00kFf_ONmm`02]KH01jDdU99kcg_?F^]2:366008Q10038B@aYTY9009S3003
NnnD/ZDd00:e]P:mm`05]KJ]EJeEW?><L@02Q3000h@@Q32<L@02W=<00jDd]IJme`02_OL00kgG[GFL
d`02Q1000f]=DXXia`028B@01b44:FE22488F/]cSXaA00:U5003]IJmekgg00:me`03[GFU59Bb00:<
D@:44005S56DTYBBYAB]M@02_ML00kgg_MNeUP02YA@00haaLjiJj`02@RP00cW7<HHaQP02:FD00b4T
4:8@PP05ool00`00ooooo`02ool001Goo`03003ooooo00;oo`07DZYc[YBBU9:]EKggcUT00/ii00?F
V]Jje[X0JMJj0mkK0]kk0]kK00?FV/iI_ML00ZeE00>LliBbU;800ZDD00>]MKgGaQP00/HH00Jmejee
YABU59BBQ303Nnl00h@@S56Ld`02[ED00kFf_OO66002_ML01jeeW=>4<8@`JfeBZT8800<aYP07@PQJ
bg>>Lhj<DIcc]IH00[gg00?66;gg]IH00ZDd00ND/XaAQ12447_?Nnn4<002U9800jDD]IJme`02aQP0
0kgg]KJU5002S7400g>^F^]:B@02<JH01c66>NM:JDYYHbakkiBb00:]E@03_MNmmkgg00:me`03[GFL
lhaa00:4409kk`05Q12<LHaaW?>]E@02]KH2_OL01[gG[EF]EIcCQ11[C@9BZP03BTU223WW008ia`03
:FDQ124400Goo`03003ooooo00;oo`005Ooo0P000ooo00MBZW>^U9:DTZeE_OO>F@02cWT00mJJe[[F
^P1Ye[X3g]/2g_/2g]/00mJJcUVme`02[ED00iccU;:D/P02YA@00jee_MO66002aQP01[gG[GFU5:DD
U9:4<0=kk`03Q12<DIcC00:]E@03]KJmmlHH00:me`07[GFLdh@`Q31[KE:Z@PP00c6V00M225[;Lhic
SXaAW?>eUP02_OL00lHH_ONeUP02YC@01iBbS56448@@Nlmkkh@`00:DTP03YABeU[gG00;66003_ONe
]ZDD00:<L@03LjiJjdY9008aYP07<HHiidYYBVUS;7__U;800ZeE00>mekgg_OL00[gG00>]MIccS740
0X@@0W__00F448aaS76LljeE00:e]P:mm`06_MN]EJeEW=>446]=0U:Z00=:BD88>NL00SW700<YIB44
8@@01?oo0P001?oo000Eool00`00ooooo`02ool01e[[NlnD/YBb[EFe][gg00;660G6>6?660C6>0;>
F@;>N@06eY[F^]JjeY[>NLHH0[Ff00>]MJeE[ED00[FF00>melHHaSP00/HH00NmejeEW=>LdhaANnmc
[P02Lhh00g_?Q12DTP02YC@00kFF_OO66002aQP01kFfYCBDTYBBNlmS;5::0092:003BTUBZV]=009k
k`03U;:]EKgG00?66006_ONeUZDDYABDTX@@0W>^00=cSW>^Nnl00Xaa00>Lljee_ML00lHH00Nmejee
W=>Ldh@`JfeJb`02BTT01d8XBVUJje[[Ljj<LJDD00:eUP03_OO66;gg00:e]P03[EFD/X@`009kc`9c
SP05Nln4<8@`U;:U=002]KH00kggaQRmm`02]KH00jDDS75kc`02Hb`00e[;DXY:B@02@PP00cW7<HHa
QP05ool00`00ooooo`02ool001Goo`03003ooooo00;oo`06Hbb449BbU;:U=:ee1KFfJKFF0kFf00>m
elHHaSP01<ii00C>FLHHaQRmm`:me`:mm`03aSS>FLiI00;66007]KJU=9BBU9:447>>Jdd00V</00=[
KG_?S5400Ycc00>]MKggaSP00/Hh00NmmkFFW?>LlhaALjiS;003F^/01f]=Nln<LHaaYABeU[gg00;6
>003aQRmejee00:Ld`07S55c[V]=JdeS;6]=Lhh00X@@00>D/ZeE]KH00/HH00?6><HH]KH00ZDd00>D
TW__Jfd00U[[00MJbf<<LhicSX@`W=>]M@02_ML00lHHaSRmm`02]IH00jDDS75kk`02Jfd2Hb`01F]]
NnmkkhaaYA@00[FF00>mmlHhaSP00[gg00>]MIccS5400W_?00=[CF<<F//00U::00=2:3WW@PP01Ooo
00<00?ooool00_oo000Eool00`00ooooo`02ool01g>>Q32D/YBbYABU=:eE00>U=0:U56RLl`06YABU
=:Dd[EFeU[gG0/HH00?>FLiicWT00liI00C6><iIcUW>F@;>N@05cUW66<HH]IJLl`02S5400g>^HbaJ
b`02F//00e[[Jff44002U;800jeE_MO6>002cUT01lHh_MN]MJeeW=><DG_?00=cSP07Nnn<DIccW?>]
MKggaSP00/iI00?66;FfYC@00YBB00Akkf]=F^]Jj`9Jb`06Hbakcg_?S76U5;FF0/HH0/Hh00K66;FF
]IJU59BBNnl2Ljh01g>>Ljj4<8@`U;:]EKgG00;66003cUW6>;gg00:]M@03W=>4<7>>009S309Jb`05
H`acSW>>Q32Ld`02[GD00kggaSS>F@02aSP00kgG[EFLd`02S5400g__Lhi[C@02F^/00e:ZDXYBRP05
ool00`00ooooo`02ool001Goo`03003ooooo00;oo`04Nln<DIBbU;82W?<019cCU;:D/YBB0XaaJ8aA
00J<LIBBU9:D/Ycc[ED2]KH00lHHcUW>N@05eYX3e[X01]JJcUVmmkgg[GFD/P:44003JdeBZTY9009:
B@03DXYS37>^00:<L@03YABe]/HH00?>F@06aSRmekgG[EFLdhaa0haA00JDTYcc[GF]MKgGaSP3cUT0
0lHH]IJLl`02S5401g>>F^]:JDYYBTU:JE[;009[K@03Q32Ldjee00:mm`?>F@:mm`03]IJU59BB00:<
D@07Q32<LIcCW=>U=;FfaQP00liI00O6>;gG[EF]EIBBNnmS;002DZX2BTT01E:ZHbaS;7_?U9800ZDd
00>melHhcUT00/iI00?6>;gG[ED00YcC00><LH@@Nll00V]]00=S;6<<Hb`01Ooo00<00?ooool00_oo
000Eool00`00ooooo`02ool017_?S56D/YBb0Ycc00BLdiBbU;:DTP:<LFR<D@06S76DTYBBU;:LljeE
0[Ff00?66<iIcWT01MJJ0mJj00KFV/iI_ONmmjeeU;82Q1000f]=DZY:B@02BTT00e::H`ac[P02S740
0jDD]KK66003cUT01/Hh_MNmejeEW=><L@><D@06U9:Lljee[GFmelHh0liI00?66;FFW?<00XaA00Mc
SU[[BVU:JDY9BVUJb`02Jfd00h@`W=>]M@02_OL3cUT2_OL00kFFYABDTP02S5401h@`S76LdicCYCBe
]/HH00?>F@07aSRmejeE[EFDTW__Hb`00U:Z0TY900EBZV</HbakciBB00:U=003_MO6><iI00;>F@03
aSRmejeE00:Ld`03S76447_?009[K@03HbaS36</00Goo`03003ooooo00;oo`005Ooo0P000ooo00>4
<8aaU;800YBb00JDTXaaQ324<8@@Nnl3NlmVLjh01W_?Nnmkkh@@S76Ld`:]E@03_MO6><ii00;F^P?N
f`;Nn`03g]_FV/iI00:me`07YCB<LG>^LjiJjdY9>NL00SW700=225:ZJfd00X@`00>LdkFFaQP00/iI
0/ii0/Hh00>mejeeYA@00icc00FU=:ee_ONmmlHh00;>N@;>F@03_ON]MIBb00:44007JdeBRT88@PPi
acWWBVT00V<<00=kciBB[ED00[gG00?6><iicWT00/iI00>mmkFFYC@00icc00JU5:eE[EFe]/HHcUT3
cWT01lHh]KJU5:DDS55cSU[;0092:08ia`05@RQJbe[;Lhj<D@02W?<00kFFaQS>N@03cWT01lHh_MN]
EJeEW?>D/XaA00:44003Nlmc[W>^00Coo`8000Coo`005Ooo00<00?ooool00_oo00N<LIBBU9:DTXaa
S55kk`02Ljh00f]]JdeS;01YHb`2Jdd00g>>Nln<D@02W=<00jee_OO>F@02e[X00mkKg__W7002ia`0
0mkKeY[6>002]IH01iccQ31[KF]]DXXiibUU008YA@03<JI:BF<<009kc`03U9:]EKgg00;>F@;FVP;>
N@03aSRmmkFf00>eUP04]KK66<iIcUT3eYX2cUT00kgGYCB<L@02Ljh01e[[@RPaQS66:DDYID88009B
ZP03Lhj<DJDD00:e]P03aSSFV]JJ00;FVP03cUW66;gG00>eUP05]KJmmkggaSS>N@03eYX00liiaQR]
M@02W=<00h@@Hba:J@02>LL00bUU:DDia`02BVT01f</NnnD/YBb[GG66<ii00?FVP07cWW6>;gG_MNe
UZDdW=<00YBB00><DH@`Q3001Ooo00<00?ooool00_oo000Eool00`00ooooo`02ool2U982S7400h@`
NnmcSP02Hb`00e[[F/]BZP1[DZX00e[[Jdekc`02S5400jDD]KK6>002eYX00mkkiacW7002ia`00mkK
eY[66002[GD01iBbNnmS36<<BTTaQR44008H``03:DDiie[;009cSP03S56U5;gG00;>F@07eY[NfmkK
g]_F^/iicUT00lHh00C>FLiie[[F^P;Nf`06eY[6><Hh]KJLlh@`0V]]00MBRSW78B@Q91S38@@aYP02
BVT00f</Q12Ld`02]IH00lHHcWWF^P02g]/00mJjeY[>F@04aSP2cWT00mJJe[[Nf`02e[X00lii_ON]
E@02U9800g_?F^]2:002:FD26><01BUU@PQ225[[Ljh00Xaa00>U=;gGcUT00]Jj00?NfmJjeYX00/iI
00>mmkFf[GD00ZDD00>LdiBbU9801Ooo00<00?ooool00_oo000Eool00`00ooooo`02ool01icCU9:<
DHaANnmcSV<<009BZP03BVU:BD8X06]2:003BTUBZV</009kk`03U;:]EKgg00;>N@03g]_W7>LL00;W
7003g]_>NKgG00:U=007S75cSU[;F/]222U54:800PQQ00<Q136VBVT00V]=00>449cc]IH00/Hh00?F
V]kKg_/00]kk00?NfmJje[X00mJj00KNfmkkg__NnmkKeYX2aQP00jeeW==kk`02Hb`01dY9<HHHhaSS
264H`bUU0092:003F^]kciBB00:]E@03_OO>NMkK00CNn`03g]_F^]Jj00;F^P;Nf`?Nn`;F^P03cUVe
]ZDD00:<D@03JfeBZSWW008Q908@PP058B@iacW7DXY[K@02Q3000jDD]KK6>002e[X00mkKg__Nf`02
e[X00liiaSRme`02]IH00jeEYABLl`05ool00`00ooooo`02ool001Goo`03003ooooo00;oo`07W=>D
TXaAS55kkg>>H``00U:Z00=:JDY9@RP0Jd8X00=:BE:ZHb`00W__00>D/ZeE_OL00/ii00?NfnLLia`0
0^LL00?Nflii_ML00ZDd00N<LG>>F/]Jbd88:DD@XP0226400b44<JI:J@02Jdd00h@@W?>eUP02aSP0
0mJJg]_Nn`02g_/00mkKe[[F^P03e[X01]kKg__Nnmkkg]_FVP;66003[GFLdg__009S;007BTTaQQSS
6><8HAS3:FD00T8X00=Jjg_?U9800ZeE00>mmliig]/01=kk00?NfmJje[X00]Jj0]kK0mkk0]Jj00?>
FKFfYA@00XaA00=[KE:Z>NL00R4T0Q2200DQ93W7>LMBRV]]00:4<003YABe]/Hh00;F^P03g]_NnmkK
00;F^P03cWW6>;gG00:eUP03[EFU59cc00Goo`03003ooooo00;oo`005Ooo00<00?ooool00_oo00NL
diBBQ324<7>^HbaBZP02@RP00cWW>LLia`1W>LL4<JH00cW7@RQBZP02Jfd00h@`YABe]P02cUT00mJj
g__W7002g_/00mJjaSRe]P02W?<01h@`JdeBRU::>LLQ10QQ008080036<<aQT8X009S3003NlnD/ZeE
00;66004eY[NnnLLia`2ic`5ia`3ic`00nLLg]_>N@02_OL00jeES75c[P02F^/01d88:FD@XQ2R000@
PR4T008ii`03DZY[KHaA00:U5003_MO>FMkK00;W70?W?0CW70?W?007iacNnmJje[[6>;FFW=<00X@@
00=S;4YY<JH00R440PQ100DHhc6V<JI:JF</009kk`03W=>]MLHH00;FVP03g__W7>LL00;Nn`03g]_F
V/iI00;66003_MNeUZeE00Goo`03003ooooo00;oo`005Ooo0P000ooo00NLlhaaNnmkkf]]F/]2:002
>LL00c66:FDYI@1W:FD4:DD00bUU<JI:B@02H``00g_?U;:]M@02aQP00mJJg]_Nn`02g]/00lii_ON]
M@02U;801g__H`a:BDY9<JHQ10QQ0088@@036<<YID88009Jb`03Lhj<DJDd00:me`05cWWNfnLlicc_
G@07kgd2ked00nLLg]_>F@02]KH00jDDQ31[K@02DZX01cWW:DD@XQ2R020@PR44008ia`03BVUS;8@@
00:Ld`03]IK6>=Jj00;W7003icc_GNmm00K_O@03kegW?=kk00;FVP03_ON]EIBB009kc`03F^]2:366
008Hh`032648@AS3008YI@07@RQJjg>^Ljj<LJeE_OL00/ii00?NfnLlic`00^Ll00?W7=kke[X00/ii
00?6>;gG]IH01?oo0P001?oo000Eool00`00ooooo`02ool01iccS55kcg_?H`a:JCW7008YI@038B@Q
124406TQ10<Hh`07:DDiae::DXY[KHaAYC@00[gG00?>FMJJe[X00]JJ00?6>;FfYA@00Xaa00McSU[;
@RQ2:3666><@PP0226400aS3:DDii`02DXX00f]=Q12Ld`02]IH01LHhe[[W7>LLked01_NN00K_ONmM
kegW7=JjaQP2[GD00iBbNnmS;002BVT01cW78B@@XQ2R264@PR44008aYP03BTUJjg_?00:DTP03[EFm
mmJJ00;Nn`03keg_OONN00KgWP03kggW?=kK00;>F@03_MNU58aA009cSP03DZY222UU008Hh`034888
HAS3008YI@07>NMBZV]]Jff4<9cc]KH00/iI00?NfnLLked00nmM00OW?=kke[[F^/iiaQRme`05ool0
0`00ooooo`02ool001Goo`03003ooooo00;oo`07W=>4<7>>LhiJbd8X<HH00R44K1S30a2R00LHhc66
BTU:BF</Q12Ld`02]IH00lHHcUW>N@02cUT00kgg[GFLd`02Q1001f]=DZXiicWW:FDHha2R008@PP03
6<<Q936V009:B@03H`akciBB00:]E@06_OOFV^LLiac_GONN1ONn00KgW^mMkegNnlii_OL2YC@00haa
LjiJj`02@RP01c6V8B@H`aS3488@XR44008aQP03@PQJbf]]00:<D@03YABe]/iI00;Nf`03icc_OONn
00Cg_P;gWP03kggW7=Jj00;6>003[GFLdh@@009S;003DXXiibU5008Hh`8@PP056<<YABU5>LM:J@02
Hb`00g__U;:]M@02aQP00mJjiac_G@03kgd01nmMiccNnmkke[[>FKgg00Goo`03003ooooo00;oo`00
5Ooo00<00?ooool00_oo00NLdh@@Jde[CE::>LLQ90026<<3489X4:801Q222648H@QQ4:8Q908ii`03
F/]c[YBB00:]E@03_MO66<Hh00;66003]KJU=8aa009kc`06H`a:JCW7>LLYAASS0a2R00<H`b4T<HH0
0T8X00=Jbg>>S5400ZDD00Je]/iIg]_NfnLlkgd5mkh01^mmiccW?=kKaSReUP:Ll`03Q31[KE:Z0092
2004<HHQ11S36<<24:801QSS:FDYICWWDXYS;09kk`03U;:]MLHH00;F^P03iac_OONN00Cg_P;gWP03
kegNnlii00:mm`03YCB<LG>^009Jj`03BTTaYR4T008Hh`8@XP056<<Q924T<JI:B@02F^/00g>^S76U
=002_ML00liig__W?004kgd01^mMiacW7=kKcWVmm`Goo`03003ooooo00;oo`005Ooo00<00?ooool0
0_oo00NLdh@@Jde[CE::>LLQ90026<<3489X4:801Q222648H@QQ4:8Q908ii`03F/]c[YBB00:]E@03
_MO66<Hh00;66003]KJU=8aa009kc`06H`a:JCW7>LLYAASS0a2R00<H`b4T<HH00T8X00=Jbg>>S540
0ZDD00Je]/iIg]_NfnLlkgd5mkh01^mmiccW?=kKaSReUP:Ll`03Q31[KE:Z00922004<HHQ11S36<<2
4:801QSS:FDYICWWDXYS;09kk`03U;:]MLHH00;F^P03iac_OONN00Cg_P;gWP03kegNnlii00:mm`03
YCB<LG>^009Jj`03BTTaYR4T008Hh`8@XP056<<Q924T<JI:B@02F^/00g>^S76U=002_ML00liig__W
?004kgd01^mMiacW7=kKcWVmm`Goo`03003ooooo00;oo`002Ooo00<00?ooool00_oo0P001Ooo00<0
0?ooool00_oo00ND/W__HbaS;4Y9<JHQ10024882244426400a222648H@1M26444882264224400`0P
264Q1002>LL00e::Jff<D@02W?<00jee_MNme`02]KH00jeEW=>4<002Jfd01U[;@RPaYS6V8B@Hh`<@
XP036<<Q12UU008ii`03DXY[CG__00:D/P07[GG66=JJeY[W7>mMmih00_Nn0_NN00K_GMkkg__FV[gg
[ED2U9800g_?Hba:J@02>LL012U58@@H`aS30Q2R00HHhbU5:DDaYTY9F^/2Ljh00haaYCBme`02cWT0
0mkKicc_O@02mih01oNnmik_ONmmiacF^/Hh00:eUP03W?>4<6]]009BZP03@PPaQR4T008H``8@XP05
6<<Q1244<HI22002DZX00f]=Q12Ld`02]IH00lHhe[[W7002ked2kgd01^mMiccW?=kKcWVmm`Goo`03
003ooooo00;oo`002Ooo00D00?ooooooo`0000;oo`03003ooooo00;oo`03003ooooo00;oo`07U99c
[U[[F^]2:2UU6<<00PQQ0P0PI@Q110QQ00H8@@0P020000QQ6><2<HH00dYYHbb44002U;800jDd[GFe
UP02[ED00jDDS75kc`02Hb`01U::>NLYIBUU8@@H``@@XP076><YACW7>LM:BE[[Ljh00Xaa00NU5;Ff
cUW>FMkKiac_G@03kgd01nmMiacF^]JjaSRe]Ycc00:<D@03LhiJbd8X008aYP038B@Hha2R00<@XP06
6<<Q924T<HI225:Z0V]=00>449cC[GD00/HH00?FV]kkked00nmm00K_GNLliccNflii_OL2[ED00iBB
NlmS;002BVT00cWW:FDQ10026<<24:801AS38@@Q12U5>LL00TYY00=S37_?U9800ZDd00>meliig]/0
0^Ll0nmM0^LL00?Nflii_ML01Ooo00<00?ooool00_oo0006ool50002ool01000ooooo`001?oo0P00
0ooo00N<DG>>F/]JbcWW:DD@XP0224400`000200801Y244302001`Q16<<YIBUU@RQJjg_?00:<L@03
W?>U=:Dd00:U5003U;:4<7>>009Jj`06BTTiabU5:DDHha2R0a2200<@XQS38B@00S6600=225:ZJdd0
0X@@00ND/Zee_ONmmliig]_W7003ic`01nLLg]_>NLii_ON]EIBb009kk`03HbaBRSWW008YI@048@@H
`a2R4:8248801QS38@@Q12UU>LM:J@9S3003Nln<LJDd00:e]P03cUWF^]kk00?W?006iacNnmkkeY[6
6;FF0Ycc00>4<7>>F//00T8X00<aYR4T6><00Q2R0Q2200D@XQSS6><Q936V0092:003F/][KH@`00:L
d`03]IK66=JJ00;Nn`03iacW?>Ll00;Nn`03e[[>FKFf00?oo`<000Coo`001_oo00@00?ooool000?o
o`04003ooooo0004ool00`00ooooo`02ool01h@`JfeBRU::>LLQ912R0088@@030000800P06`08007
264H`bU5:DE225[;Lhh00X@`00>DTYcCW?<00YBb00><DG_?Hb`00U:Z00I223668B@Q91S348832640
0a224:8Q1002:FD00cW7BVUS3002Ljh01haaYABeU[FFaQS>NMJj00?Nf`07e[[>NLHHaQReUYccS540
0W>>00=JjdY9>LL00RU500LHha2R488@PPQQ488@XP026><00b4T<JI2:002F//00f]]Q12Ld`02[ED0
0kggcUWF^P04g]/2eYX00lHh]KJU=002U9800g__HbaBRP02>NL00bUU8@@H``02488226401A226<<H
`b44:FD00SWW00=BRV</Nll00YBB00>U=;FfaSP00]JJ00?Nfmkkg_/00]kK00?FV/HH]IH01Ooo00<0
0?ooool00_oo0007ool00`00ool00003ool01000ooooo`001?oo00<00?ooool00_oo00N4<6]]DXYB
RSW78B@@XP0224400`000200801/02001`QQ6<<YABU5@PQJbg>>00:4<003U9:Ldicc00:D/P03S55k
cf</009BZP06@PPaQR4T8B@H`a220`QQ00<@PQ2R8@@00RUU00<iadYYH``00W>^00N<LJDD]IJeU/HH
cWWF^P03g]/01mJjcWW66<HH]IJLlhaA009cSP03F^]:BCW7008YA@076><@XQ224888HA224:800QSS
00<Q936V@RP00U[;00=[KH@@W=<00ZeE00>mmliIe[X01=kK0]JJ00?6>;FfYC@00YBB00=kkf</DXX0
0SWW00<YIB446<<00Q220PQQ00D@PQS36<<Q12UU008ii`03DXYS;7_?00:DTP03YCBe]/Hh00;FVP03
g]_Nnmkk00;Nf`03eY[66;FF00Goo`03003ooooo00;oo`002?oo0P000ooo00@00?ooool000Coo`03
003ooooo00;oo`07Q11S;4YYBVTaYR4448800PQ1KP0P00<8@@QQ6<<00RU500<iie:ZJdd00W__00><
DIBBU9800XaA00=kkf]]F^/00TYY00LiabUU8@@Q112R4888H@0224400`QQ488H``028B@00c6V@RQJ
b`02Jfd01h@@U;:U=:Dd]KK66<iI00?>N@07cUW66;FF]IJU59BBNnl00V]=00=BZT88<HH00R4T00LH
`a222648H@Q1264@PP026<<00b44:FDii`02DXX00f<<Nln<L@02W?<00jee_OO6>003cWT01/iIaSS6
>;gG[EFLd`:4<003LhiJjdY9008ia`03:DDHha2R00<8H@062448HA2R4:8HhbU50S6V00=:BE[;Jfd0
0X@`00>LdjeE_ML00/Hh00?>NMJje[X00]JJ00?>FKgg[GD01Ooo00<00?ooool00_oo0009ool00`00
ooooo`02ool20005ool00`00ooooo`02ool01g_?H`a:BDY9<JHQ11220088@@<086L000@080032448
HAS3008YA@03>LM:JF<<009c[P03Q124<8@`00:44003LjiS;5:Z00922006<JHQ91S36<<@PPQQ10Q1
00L@PQ2R8@@Q12UU>NM:J@02H``01g>^Q32LdicC[EFe][gg00?66007_MNeUZDdYCBD/X@`Lhh00U[[
00=:BCW7:FD00QSS00<@XPQQ24400`Q100H8HA2R4:8HhbU5<JH2@RP00e[;Jff44002U9800jDD[GFm
e`02_OL01lHH_ONe][Ff[EFLlhaa009kc`03HbaBRT88008aQP038B@H`a220088H@<8@@8@PP076<<Q
1366<HI225::Hb`00W_?00><DIcc[GD00[gG00?66<iIcUT00/iI00?66;FfYC@01Ooo00<00?ooool0
0_oo000Eool00`00ooooo`02ool01g>^F^]2:48X<HHQ11220088@@8086T000<08003244@PQS3008Q
9003>LM:BE[[009[K@03Nlmkkg__009c[P03JdeJjdYY008ii`06:FDQ112R4:88H@Q10`0P00<8@@QQ
4:800QSS00<YAC6V@RP00U:Z00M[CG_?S56<DIcCYCB]M@03]IH01jeeYCBLdicCS55kcf</009BZP03
@PPaQR4T008H``034888H@0P00<08006244@PQ226<<Q13660SWW00=:JF<<Lhh00X@`00>D/ZDD[ED0
0kFF00J]MJeE[EFLlhaaNnl2Jfd00e[;BTTia`02:DD00aSS4:88H@02244202001@Q12648HA2R6><0
0RU500<iadY9F//00V]]00=kkhaaW?<00ZeE00>e][gG_OL00[gg00>e]ZeeW?<01Ooo00<00?ooool0
0_oo000Eool20003ool01f]]F/]22488:FDHha220088@@8086T000<08003244@PQS3008Q9003<JI2
:5:Z009S;003Lhic[W>>009[K@03H`aBRT88008aYP06:DDHha2R4:88H@0P0`0000<080Q148800QS3
00<Q12UU>NL00TYY00MJjf]]NnmkkhaaU;:Ll`03YA@01iccU;:<DHaANnm[KE[;009:B@03>LLYIB44
008@XP072648@@0P0200000P24400PQQ00<@XQSS:DD00S6V00=2:5:ZJdd00W_?00>4<9BBW?<01:DD
0YcC00><LH@@Lhh00V<<00=BRT88<HH00R4T00<H`a2226400P0P0P0000D080Q1244@PQS3008Q9003
<HI225::009S3003Lhj449BB00:Ll`03YCB]MKFF00:eUP03[GFU59Bb00Coo`8000Coo`005Ooo00<0
0?ooool00_oo00M[KE[;@PQ222UU6><@PP022442021Y000302000`Q1488H``028B@00c6V@RQBZP02
Hb`00g>>LjicSP02Jfd00f<<DXY22002<JH01RU56><@XQ2R264080<000030208@A22008H``038@@Y
ICWW009:J@07F^][KG__Nnn<LIBbW?<00jDD00NLliBbS56<DG__JfeJb`02BTT00cW7:FDQ10024:80
1`QQ2440800P000080Q10088H@034:8HhbU5008aYP03@RQBZV]=009kc`03Q32DTYcc00BU50:Ld`03
S76447>>009S3003DXY22366008Q90036<<@PPQQ0080808000050208@@Q1488H``028B@00c66@PQB
RP02H``00g>>Q12DTP02W?<00jDd[GFeUP02]IH00jeeYABD/P05ool00`00ooooo`02ool001Goo`03
003ooooo00;oo`07JdeBRSWW>NLYIASS48800PQ10P0PJ@000`0P00<8@A226<<00R4T00<aQT88DXX0
0U[[0f]=0V<<00=BZTY9>NL00RUU00HQ11S3488@PPQ1020300000`0P2448H@024:800aSS:DDaYP02
@RP01U::H`acSW>>Nnn<D@BDTP07S764<7__Nnm[KF<<DXX00T8800<aQR4T6><00Q2R00<8H@Q10000
0`0000H080Q1244@PQS38B@2<HH00cWWBVUJj`02Jdd00g_?Q32<L@02U9801iBbU9:<DHaAQ11c[V</
009BZP03BTTiabUU008Q10034:88H@Q10080808000050208@@Q1264@XP028@@00bU5>LM2:002DZX0
0f</Ljj44002S7400icCW?>U5003YA@00icCS77oo`04ool00`00ooooo`02ool001Goo`03003ooooo
00;oo`07H`a:JCWW>NLYAASS48800PQ10P0PJP000P0P00<8@A226<<00R4400<aQSWWBVT00U[;0f<<
0U[;00=:JD88<JH00RU500HHha2R2648H@Q1020400001`0P264@PQ226<<Q12UU008ia`07BTUBZV</
HbacSW_?Q1000h@`00N447_?Jfe[KF<<DZY2:002>LL00bUU8@@H``0248800`Q10200000300001P0P
2448@@QQ4:8Hh`8YA@03<JI225::009Jj`03Jfec[W__00:44007Q32447__NnmcSV]=F//00TYY00<i
ic668B@00QSS00<@XPQQ24400P0P0P0000D080Q12448HA22008H``038B@aQSWW009:J@03F/][CG>^
00:44003S56DTYBb00>D/P03S7644?oo00Coo`03003ooooo00;oo`005Ooo00<00?ooool00_oo00MJ
jdY9>LLiabU56><@PP0224400`0P0000001Y000202000`Q1264@XP028@@00bUU>NM:B@02DXX3F//2
DXX00d8X>LLYI@028@@011S34888H@QQ0P0P100000L080Q12648HA2R6><YA@02<JH01d88BVUJbe[;
Hba[KG>>00=c[P07Lhi[CF<<H`aBZTY9>NL00S6600<Q91SS4:800PQQ00<8@@0P00000`0000H080Q1
2448HA226<<28B@00bUU>LM2:002DZX00e[[JdecSP04Ljh2Jfd00f</F^]BRP02@PP00c6V:DDQ1002
6<<00a22244080020202000302001`Q1488@XQ2R8@@YAC6V00922003BVUJbf</009cSP03Nln448@`
00:<D@03Q32447_?00Goo`03003ooooo00;oo`005Ooo00<00?ooool00_oo00MBZT8X<JHaYR4T6<<@
PP0224400`0P0000001Y000202000`Q1264@XP028@@00bUU>LM2:002BVT00e::DZYBRP02BTT00cWW
<JHYA@026><0112R2648@@Q10P0P100000L080Q12648HA226<<Q1002:FD01