function [c,k,semilunghezza,residuopesato]=bisezione(a,b,tolintv,...
    tolres,maxit,f)

%--------------------------------------------------------------------------
% NOTA 1.
%
% SE L'UTENTE VUOLE PASSARE LA FUNZIONE g SALVATA IN g.m, SCRIVERA'
%    [...]=bisezione(...,maxit,'g').
%
%--------------------------------------------------------------------------
% NOTA 2.
%
% SI PUO' DEFINIRE LA FUNZIONE 'g' ANCHE USANDO "inline".
%
% ESEMPIO:
%
% >> g=inline('sin(x)-x');
% >> [c,k,semilunghezza,residuopesato]=bisezione(-0.45,0.4,10^(-6),...
%    10^(-6),40,'g');
%	 [IT]:  1 [c]: -0.02500 [a]:-0.025[AMP]: 2.13e-01 [WRES]:1.54e-03
%    ...
%	 [IT]: 18 [c]: 0.40000 [a]:0.400[AMP]: 1.62e-06 [WRES]:1.85e-01
% >>
%--------------------------------------------------------------------------


% PONI "a < b" ANCHE IN CASO DI ERRORE DELL'UTENTE.
if b < a
    s=b; b=a; a=s;
end

fa=feval(f,a);
fb=feval(f,b);

% SE UNO TRA a E b E' LA SOLUZIONE, ALLORA ESCI DOPO AVER
% ASSEGNATO L'OUTPUT.

if fa == 0 
    c=a; k=0; semilunghezza=(b-a)/2; residuopesato=0;
    return; 
end

if fb == 0 
    c=b; k=0; semilunghezza=(b-a)/2; residuopesato=0;
    return; 
end

% SE IL NUMERO DI ITERAZIONI NON E' ECCESSIVO ALLORA PROCEDI.

for index=1:maxit
    
    c(index)=(a+b)/2; 
    fc=feval(f,c(index));
    
    % CALCOLA IL NUOVO INTERVALLO [a,b].
    if sign(fc) == sign(fa)
        a=c(index); fa=fc;  %SUB INTV. DX.
    else
        b=c(index); fb=fc;  %SUB INTV. SX.
    end
    
    % CALCOLA SEMILUNGHEZZA E RESIDUO PESATO.
    semilunghezza(index)=(b-a)/2;
    den=(fb-fa); 
    if den == 0
       den=eps; % SE IL DENOMINATORE "den" E' NULLO, PONGO "den=eps".
    end         
    w=(b-a)/den;
    residuopesato(index)=abs(fc*w);
    
    % SE QUALCHE TEST DI ARRESTO E' VERIFICATO, ESCI DALLA FUNZIONE.
    if (residuopesato(index) < tolres) | ...
             (semilunghezza(index) < tolintv) | (fc == 0)
        k=index; 
        fprintf('\n'); 
        return;
    end

   % fprintf('\n \t [IT]:%3.0f [c]: %5.5f [a]:%3.5f [b]:%3.5f',index,c(index),a,b)
   % fprintf(' [AMP]: %2.2e [WRES]:%2.2e',semilunghezza(index),...
   %    residuopesato(index));
   
end

k=maxit;

fprintf('\n')