function [aa,bb,cc]=bisezione2011(a,b,...
                          tolintv,tolres,maxit,f)

% Aggiusta errori utente.
if b < a
    s=b; b=a; a=s;
end
fa=feval(f,a); fb=feval(f,b);
% Esci se un estremo e' sol.
if fa == 0 
    c=a; k=0;
    return; 
end
if fb == 0 
    c=b; k=0; 
    return; 
end
aa=[a]; bb=[b]; cc=[(a+b)/2];
% Procedi se num. iter. non eccessivo.
for index=1:maxit
    c=(a+b)/2;  fc=feval(f,c); cc=[cc; c];
    % Nuovo intervallo.
    if sign(fc) == sign(fa)
        aa=[aa; c]; bb=[bb; b]; a=c; fa=fc; 
    else
        aa=[aa; a]; bb=[bb; c]; b=c; fb=fc; 
    end
    % Calcola residuo pesato "wres".
    semilung=(b-a)/2; den=(fb-fa); 
    if den == 0 den=eps; end   % trucco      
    w=(b-a)/den; wres=abs(fc*w);    
    % Test arresto
    if (wres<tolres)|(semilung<tolintv)|(fc==0)
        k=index; fprintf('\n');  return;
    end 
end
k=maxit; fprintf('\n')