function [x,k,scarto,errflag]=newton(x0,tol,kmax,funct,dfunct)

%---------------------------------
% METODO DI NEWTON.
%---------------------------------
% INPUT.
%---------
% x0: punto iniziale.
% tol: tolleranza criterio dello step/residuo pesato.
% kmax: numero massimo di iterazioni.
% funct: funzione di cui cercare lo zero "funct(x)=0".
% funct: derivata di "funct".
%---------------------------------
% OUTPUT.
%---------
% x: vettore iterazioni del metodo di Newton.
% k: ultima iterazione.
% scarto: vettore degli scarti -fx/dfx.
% errflag: 0: uscita corretta, 1: uscita per errore.
%---------------------------------
% ESEMPIO.
%---------
% >>f=inline('x.^2-2');
% >>df=inline('2*x');
% >>[x,k,scarto,errflag]=newton(0.8,10^(-6),40,f,df)
% [ITER.]:   1[VALORE]: 0.80000 [ABS.SCARTO]: 8.50e-01
% [ITER.]:   2[VALORE]: 1.65000 [ABS.SCARTO]: 2.19e-01
% [ITER.]:   3[VALORE]: 1.43106 [ABS.SCARTO]: 1.67e-02
% [ITER.]:   4[VALORE]: 1.41431 [ABS.SCARTO]: 9.92e-05
% [ITER.]:   5[VALORE]: 1.41421 [ABS.SCARTO]: 3.48e-09
% x =
% 
%     0.8000
%     1.6500
%     1.4311
%     1.4143
%     1.4142
% 
% k =
% 
%      5
% 
% scarto =
% 
%     0.8500
%    -0.2189
%    -0.0167
%    -0.0001
%    -0.0000
% 
%  errflag =
% 
%      0
%
%---------------------------------
% NOTA.
%---------
% IN ALCUNI MATLAB, SE QUANTO PROVATO DA' ERRORE
% ESEGUIRE
% 
% [x,k,scarto,errflag]=newton(1,10^(-6),40,f,df)
%
%---------------------------------

%---------------------------------------
% PRIMA ITERAZIONE DEL METODO DI NEWTON.
%---------------------------------------
k=1;
x(1,1)=x0;

% VALUTAZIONE FUNZIONE.
fx=feval(funct,x(k,1));

if fx == 0 % x(1) E' SOLUZIONE.
    scarto(k,1)=0;
    errflag=0;
    return;
end

% VALUTAZIONE DERIVATA.
dfx=feval(dfunct,x(k,1));

if dfx == 0 % NEWTON NON PUO' PROSEGUIRE.
    scarto(k)=realmax;
    errflag=1;
    return;
else
    scarto(k,1)=-fx/dfx;
end

fprintf('\n \t [ITER.]: %3.0f',k);
fprintf('[VALORE]: %5.5f [ABS.SCARTO]: %2.2e',x(k,1),abs(scarto(k,1)));

%--------------------------------------------
% ITERAZIONI SUCCESSIVE DEL METODO DI NEWTON.
%--------------------------------------------
while (abs(scarto(k)) > tol) & (k < kmax)
    k=k+1;
    x(k,1)=x(k-1,1)+scarto(k-1,1);

    % VALUTAZIONE FUNZIONE.
    fx=feval(funct,x(k));

    if fx == 0 % x(1) E' SOLUZIONE.
        scarto(k,1)=0;
        errflag=0;
        return;
    end

    % VALUTAZIONE DERIVATA.
    dfx=feval(dfunct,x(k,1));

    if dfx == 0 % NEWTON NON PUO' PROSEGUIRE.
        scarto(k,1)=realmax;
        errflag=1;
        return;
    else
        scarto(k,1)=-fx/dfx;
    end

    fprintf('\n \t [ITER.]: %3.0f',k);
    fprintf('[VALORE]: %5.5f [ABS.SCARTO]: %2.2e',x(k),abs(scarto(k)));
end

% ANALISI DELL'USCITA DI NEWTON.
if (abs(scarto(k,1)) > tol) > 0
    errflag=1;
else
    errflag=0;
end