function [x,k,step,errflag]=newton2011(x0,tol,...
    kmax,funct,dfunct)

% PRIMA ITERAZIONE DEL METODO DI NEWTON.
k=1; x(1,1)=x0; fx=feval(funct,x(k,1)); errflag=0; 
% x(1) E' SOLUZIONE.
if fx == 0 
    step(k,1)=0; return;
end
dfx=feval(dfunct,x(k,1)); % VALUTAZIONE DERIVATA.
if dfx == 0 % NEWTON NON PUO' PROSEGUIRE.
    step(k)=realmax; errflag=1; return;
else
    step(k,1)=-fx/dfx;
end
fprintf('\n \t [ITER.]: %3.0f ',k);
fprintf('[VAL.]: %5.5f ',x(k));
fprintf('[ERR.EST.]: %2.2e',abs(step(k,1)));
% ITERAZIONI SUCCESSIVE DEL METODO DI NEWTON.
while (abs(step(k)) > tol) & (k < kmax)
    k=k+1; x(k,1)=x(k-1,1)+step(k-1,1); 
    fx=feval(funct,x(k));
    if fx == 0 % x(k) E' SOLUZIONE.
        step(k,1)=0; return;
    end
    dfx=feval(dfunct,x(k,1)); % VALUTAZIONE DERIVATA.
    if dfx == 0 % NEWTON NON PUO' PROSEGUIRE.
        step(k,1)=realmax; errflag=1; return;
    else
        step(k,1)=-fx/dfx;
    end
    fprintf('\n \t [ITER.]: %3.0f ',k);
    fprintf('[VAL.]: %5.5f ',x(k));
    fprintf('[ABS.STEP]: %2.2e',abs(step(k,1)));
end