
function [v_hist, step_hist, residual_hist]=newton_sistemi(v0,maxit,tol)

% INPUT:
% v0      : APPROSSIMAZIONE INIZIALE.
% maxit   : NUMERO MASSIMO DI ITERAZIONI.
% tol     : TOLLERANZA DEL CRITERIO D'ARRESTO.
% F       : FUNZIONE.
% DF      : FUNZIONE DA CUI VIENE CALCOLATA LA JACOBIANA DI F.

% OUTPUT:
% v_hist : VETTORE CONTENENTE LE APPROSSIMAZIONI DELLA SOLUZIONE.
% step_hist    : VETTORE DEGLI STEP.
% residual_hist: VETTORE DEI RESIDUI.

v_old=v0;
v_hist=[v0'];


JF=DF(v_old);  % CALCOLIAMO LA MATRICE JACOBIANA.
Fv=F(v_old);   % VALUTIAMO LA FUNZIONE.
residual=norm(Fv);
residual_hist=[residual];

h=-JF\Fv;       % CALCOLIAMO LA CORREZIONE.

v_new=v_old+h;  % NUOVA APPROSSIMAZIONE.
v_hist=[v_hist; v_new'];

step_hist=[];

for index=1:maxit
    
    
    Fv=F(v_new);  % VALUTIAMO LA FUNZIONE.
    residual=norm(Fv,2);             % RESIDUO.
    residual_hist=[residual_hist; residual];
    
    loc_step=norm(v_new-v_old,2);    % STEP.
    step_hist=[step_hist; loc_step];
   
    if max(loc_step,residual) < tol
        return;
    else
        v_old=v_new;
        JF=DF(v_old);  % CALCOLIAMO LA MATRICE JACOBIANA.
        
        h=-JF\Fv;       % CALCOLIAMO LA CORREZIONE.
        v_new=v_old+h;  % NUOVA APPROSSIMAZIONE.
        v_hist=[v_hist; v_new'];
    end
    
end

    
fprintf('\n \t [WARNING]: NUMERO MASSIMO DI ITERAZIONI RAGGIUNTO.')


function res=F(v)

res(1,1)=0.5*cos(v(2))-v(1);
res(2,1)=0.5*sin(v(1))-v(2);


function res=DF(v)

% res(1,1)=0.5*cos(v(2));
% res(2,1)=0.5*sin(v(1));

res=[-1 -0.5*sin(v(2)); 0.5*cos(v(1)) -1];

