
function xhist=punto_fisso(x0, maxit, tol, g)

% INPUT.
% x0      : PUNTO INIZIALE.
% maxit   : NUMERO MASSIMO DI ITERAZIONI.
% tol     : TOLLERANZA CRITERIO DI ARRESTO.
% g       : EQUAZIONE DA RISOLVERE x=g(x) 

x_old=x0;
xhist=[x_old'];

for index=1:maxit
    x_new=feval(g,x_old);
    if norm(x_new-x_old,inf) < tol
       return
   else
      xhist=[xhist; x_new'];
      x_old=x_new;
   end
end

fprintf('\n \t [WARNING]: RAGGIUNTO MASSIMO NUMERO DI ITERAZIONI ');