
function [x_tpz,w_tpz,I_tpz,x_simp,w_simp,I_simp,x_jac_ab,w_jac_ab,I_jac,x_cc,w_cc,I_cc,timing]=demo_block(N,a,b,ftype)

% FORMULA DEI TRAPEZI COMPOSTA.
timing(1)=cputime;
N_tpz=N;
[x_tpz,w_tpz]=trapezi_composta(N_tpz,a,b); % NODI E PESI.
fx_tpz=f(x_tpz,ftype);                 % VALUT. FUNZIONE.
I_tpz=w_tpz'*fx_tpz;                   % VALORE INTEGRALE.
timing(2)=cputime;

% FORMULA DI SIMPSON. COMPOSTA.
timing(3)=cputime;
N_simp=max(ceil((N-1)/2),1);
[x_simp,w_simp]=simpson_composta(N_simp,a,b); % NODI E PESI.
fx_simp=f(x_simp,ftype);                 % VALUT. FUNZIONE.
I_simp=w_simp'*fx_simp;                  % VALORE INTEGRALE.
timing(4)=cputime;

% FORMULA DI GAUSS-LEGENDRE: "w(x)=1". 
% VISTA COME GAUSS-JACOBI "w(t)=(1-t)^ajac (1+t)^bjac"
% PER "ajac=0" E "bjac=0".
timing(5)=cputime;
ajac=0; bjac=0;              
ab_jac=r_jacobi(N,ajac,bjac);    % TERM. RICORSIVI.
xw_jac=gauss(N,ab_jac);          % NODI E PESI IN MATRICE.
x_jac=xw_jac(:,1);                   % NODI GAUSS-LEGENDRE [-1,1].
x_jac_ab=((a+b)/2)+((b-a)/2)*x_jac;  % NODI GAUSS-LEGENDRE [a,b].  
w_jac=xw_jac(:,2);                   % PESI GAUSS-LEGENDRE [-1,1].
w_jac_ab=((b-a)/2)*w_jac;            % PESI GAUSS-LEGENDRE [a,b].
fx_jac_ab=f(x_jac_ab,ftype);         % VALUTAZIONE FUNZIONE.  
I_jac=w_jac_ab'*fx_jac_ab;           % VALORE INTEGRALE.
timing(6)=cputime;


% FORMULA DI CLENSHAW-CURTIS.
timing(7)=cputime;
N_cc=max(N-1,2);
[x_cc,w_cc]=clenshaw_curtis(N_cc,a,b);  % NODI E PESI DI CL.-CURTIS.
fx_cc=f(x_cc,ftype);                 % VALUTAZIONE FUNZIONE.  
I_cc=w_cc'*fx_cc;                    % VALORE INTEGRALE.
timing(8)=cputime;