hold off;

N=10;
a=-1; b=1;
ftype=1;

[x_tpz,w_tpz,I_tpz,x_simp,w_simp,I_simp,x_jac_ab,w_jac_ab,I_jac,x_cc,w_cc,I_cc,timing]=demo_block(N,a,b,ftype);

I_romb=romberg(a,b,N,ftype);

% RISULTATI.
fprintf('\n \t [RISULTATO][TRAPEZI COMPOSTA]: %18.18f',I_tpz);
fprintf('\n \t [RISULTATO][SIMPSON COMPOSTA]: %18.18f',I_simp);
fprintf('\n \t [RISULTATO][GAUSS-LEGENDRE  ]: %18.18f',I_jac);
fprintf('\n \t [RISULTATO][CLENSHAW-CURTIS ]: %18.18f',I_cc);
fprintf('\n \t [RISULTATO][ROMBERG         ]: %18.18f',I_romb);

% RISULTATI.
res=exact_results(ftype);
fprintf('\n \n \t [TRAPEZI COMPOSTA][ERR.ASS.]: %2.2e',abs(I_tpz-res));
fprintf(' [ERR.REL.]: %2.2e',abs(I_tpz-res)/abs(res) );
fprintf('\n \t [SIMPSON COMPOSTA][ERR.ASS.]: %2.2e',abs(I_simp-res)); 
fprintf(' [ERR.REL.]: %2.2e',abs(I_simp-res)/abs(res) );
fprintf('\n \t [GAUSS-LEGENDRE  ][ERR.ASS.]: %2.2e',abs(I_jac-res)); 
fprintf(' [ERR.REL.]: %2.2e',abs(I_jac-res)/abs(res));
fprintf('\n \t [CLENSHAW-CURTIS ][ERR.ASS.]: %2.2e',abs(I_cc-res)); 
fprintf(' [ERR.REL.]: %2.2e',abs(I_cc-res)/abs(res));

% CPUTIMES.
fprintf('\n \n \t [CPUTIME] [TRAPEZI COMPOSTA]: %2.2e',timing(2)-timing(1));
fprintf('\n \t [CPUTIME] [SIMPSON COMPOSTA]: %2.2e',timing(4)-timing(3));
fprintf('\n \t [CPUTIME] [GAUSS - LEGENDRE]: %2.2e',timing(6)-timing(5));
fprintf('\n \t [CPUTIME] [CLENSHAW-CURTIS ]: %2.2e',timing(8)-timing(7));

% VALUTAZIONI FATTE.
fprintf('\n \n \t [VALUTAZIONI] [TRAPEZI COMPOSTA]: %4.0f',length(x_tpz));
fprintf('\n \t [VALUTAZIONI] [SIMPSON COMPOSTA]: %4.0f',length(x_simp));
fprintf('\n \t [VALUTAZIONI] [GAUSS - LEGENDRE]: %4.0f',length(x_jac_ab));
fprintf('\n \t [VALUTAZIONI] [CLENSHAW-CURTIS ]: %4.0f',length(x_cc));

% SOMMA ABS. PESI.
sw_tpz=sum(abs(w_tpz)); sw_simp=sum(abs(w_simp));
sw_jac=sum(abs(w_jac_ab)); sw_cc=sum(abs(w_cc));
fprintf('\n \n \t [SOMMA ABS. PESI][TRAPEZI COMPOSTA]: %2.2e',sw_tpz);
fprintf('\n \t [SOMMA ABS. PESI][SIMPSON COMPOSTA]: %2.2e',sw_simp);
fprintf('\n \t [SOMMA ABS. PESI][GAUSS - LEGENDRE]: %2.2e',sw_jac);
fprintf('\n \t [SOMMA ABS. PESI][CLENSHAW-CURTIS ]: %2.2e',sw_cc);

% PLOT PESI.
hold off;
semilogy(1:length(w_tpz),w_tpz,'ro-'); hold on;
semilogy(1:length(w_simp),w_simp,'ko-'); hold on;
semilogy(1:length(w_jac_ab),w_jac_ab,'mo-'); hold on;
semilogy(1:length(w_cc),real(w_cc),'go-'); hold on;
