%====================================================================
% Script per interpolazione con la forma di Newton
% Necessita delle function polnewton e horner
%====================================================================

clear all

% Definisce la funzione
f = inline('1./(1+x.^2)');  % oppure f = @(x) 1./(1+x.^2);
% Definisce l'intervallo
a = -5; b = 5;
% Definisce il numero di nodi
nnodi= 11;
% Definisce la tabulazione dei punti
xn = linspace(a,b,nnodi);
fxn = feval(f,xn);

% Calcola i coefficienti del polinomio con la base di Newton
c = polnewton (xn,fxn);

% Grafici

% Definisce le ascisse per i grafici
xint = linspace(a,b,201);
xint = xint(:);
% Valuta la funzione nelle 201 ascisse
y = feval(f,xint);
% Valuta il polinomio nelle 201 ascisse
for i=1:201
    fxstar(i) = horner (xn,c,xint(i));
end
fxstar=fxstar(:);

% Funzione e polinomio interpolante
figure(1)
plot(xn,fxn,'ro')
hold on
plot(xint,y,'k-')
plot(xint,fxstar,'r--')
legend('Punti dati','Funzione','Polinomio','Location','Best')
title(['Polinomio interpolante e funzione ',formula(f)])
hold off

