%====================================================================
% Script per interpolazione con la forma di Newton con nodi di Chebyshev
% Necessita delle function polnewton e horner 
%====================================================================

clear all

% Definisce la funzione
f = inline('1./(1+x.^2)');  % oppure f = @(x) 1./(1+x.^2);
% Definisce l'intervallo
a = -5; b = 5;
% Definisce il numero di nodi
nnodi= 11; % provare con un numero più alto di nodi? cosa succede? 15, 21, 29
% Definisce i nodi di Chebyshev
xn = cos( pi* (2*(0:(nnodi-1)) + 1)/(2*(nnodi-1) + 2) );
xn = (a + b)/2 + (b-a)/2 * xn;
fxn = f(xn);


% Calcola i coefficienti del polinomio con la base di Newton
c = polnewton (xn,fxn);

% Grafici

% Definisce le ascisse per i grafici
xint = linspace(a,b,201);
xint = xint(:);
% Valuta la funzione nelle 201 ascisse
y = feval(f,xint);
% Valuta il polinomio nelle 201 ascisse
for i=1:201
    fxstar(i) = horner (xn,c,xint(i));
end
fxstar=fxstar(:);

% Funzione e polinomio interpolante
figure(1)
plot(xn,fxn,'ro')
hold on
plot(xint,y,'k-')
plot(xint,fxstar,'r--')
legend('Punti dati','Funzione','Polinomio','Location','Best')
title(['Polinomio interpolante e funzione ',formula(f)])
hold off

