function fxstar = horner (x,c,xstar)
% HORNER Calcola il valore del polinomio interpolatore in x^*
%        utilizzando la forma di Newton e l'algoritmo di Horner
%
% Uso:
%   fxstar = horner (x,c,xstar)
%
% Dati di ingresso:
%   x      vettore dei nodi
%   c      vettore dei coefficienti della forma di Newton
%          ordinati per indici crescenti (c_0, c_1, ... )
%   xstar  valore in cui si vuole valutare il polinomio
%
% Dati di uscita:
%   fxstar valore di P(x^*)

n1 = length(x);
if n1 ~= length(c)
    error('numero di nodi e di coefficienti inconsistente')
end

% Algoritmo di Horner
fxstar = c(n1);
for i = n1-1:-1:1
    fxstar = fxstar*(xstar - x(i)) + c(i);
end

