function c = polnewton (x,y)
% POLNEWTON Calcola i coefficienti del polinomio interpolatore
%           utilizzando la forma di Newton con le differenze
%           divise
%
% Uso:
%   c = polnewton (x,y)
%
% Dati di ingresso:
%   x    vettore dei nodi
%   y    vettore dei valori della funzione da interpolare nei nodi
%
% Dati di uscita:
%   c    vettore colonna dei coefficienti ordinati per indici
%        crescenti (c_0, c_1, ... )

n1 = length(x);
if n1 ~= length(y)
    error('Tabulazione errata: numero inconsistente di nodi e valori')
end

% prealloca la tabella delle differenze divise
ctab = zeros(n1,n1);

% inizializza la prima colonna
ctab(:,1) = y;

% costruisce la tabella per colonne
for j = 2:n1
    for i = 1:n1-j+1
        ctab(i,j) = (ctab(i,j-1)-ctab(i+1,j-1))/(x(i)-x(i+j-1));
    end
end

% definisce il vettore dei coefficienti
c = ctab(1,:);
c = c(:);

