function a = minquad(x,y,w,n);
% MINQUAD calcola i coefficienti del polinomio approssimante di grado n,
% soluzione del sistema ai minimi quadrati.
% Utilizza le function trisup e triinf
%
% Uso:
% a = minquad (x,y,w,n);
%
% Dati di ingresso:
% x vettore colonna con ascisse dei punti
% y vettore colonna con ordinate dei punti
% w vettore colonna con i pesi
% n grado del polinomio approssimante
%
% Dati di uscita:
% a vettore colonna che contiene i coefficienti rispetto alla
% base canonica ordinati per potenze crescenti della x.
%


% Controllo sul grado del polinomio rispetto al numero di punti
m1 = length(x);
if n >= m1
error ('Grado del polinomio troppo elevato')
end
% Costruzione della matrice A
A = fliplr(vander(x));
A = repmat(sqrt(w),1,n+1).*A(:,1:n+1);
% Costruzione del vettore b
b = sqrt(w).*y;
% Calcolo coefficienti con risoluzione sistema delle equazioni normali
M=A'*A;
z=A'*b;
[L,flag] = chol(M,'lower');
yy=L\z;
a = L'\yy;