%====================================================================
% Script per determinare il polinomio al piu’ di quinto grado
% approssimante ai minimi quadrati. Pesi qualsiasi.
% Necessita della function minquad
%====================================================================
clear all
% Definizione dati e controllo
x = [-3.490 -2.948 -2.574 -2.157 -1.377 -1.234 -0.861 -0.116 ...
0.235 0.558 1.036 1.318 2.139 2.566 2.736 3.312]';
y = [27.200 4.720 -0.978 4.100 16.013 19.656 22.498 21.650 ...
16.770 12.671 4.042 -2.158 -16.901 -11.437 -13.449 31.1840]';
n = 5;
m1 = length(x);
w = ones(m1,1);
if length(y) ~= m1
error('Le dimensioni di x e di y non sono compatibili')
end
% Chiama la function minquad
a = minquad (x,y,w,n);
% Calcolo coefficienti con polyfit (attenzione vengono restituiti
% per potenze decrescenti della x!)
c = polyfit(x,y,n);
% Calcola il baricentro
disp('Baricentro')
xbari=sum(x)/m1;
ybari=sum(y)/m1;
disp([xbari,ybari])
% Calcola l’errore quadratico
yapp = polyval(c, x);
err2 = sum(w.*(yapp-y).^2);
disp ('L''errore quadratico e''')
disp(err2)
% Grafici
minx=min(x);
maxx=max(x);
xs = linspace(minx, maxx, 200);
xs = xs(:);
ys = polyval(flipud(a), xs);
ysc = polyval(c, xs);
subplot(2,1,1)
plot([minx maxx], [0 0], 'k', x, y, 'b*', xs, ys, 'r', xbari,ybari,'go')
title(['Approssimazione ai minimi quadrati con polinomio di grado ', num2str(n)])
subplot(2,1,2)
plot([minx maxx], [0 0], 'k', x, y, 'b*', xs, ysc, 'r', xbari,ybari,'go')
title(['Approssimazione polyfit con polinomio di grado ', num2str(n)])