%====================================================================
% Script per determinare la soluzione di un sistema lineare
% con il metodo SOR. Ciclo per piu` valori w.
% Necessita della function SOR
%====================================================================

clear all

% Definizione dati 
n = 50;  % 250 per esercizion 6
A = diag(4*ones(n,1)) + diag(-2*ones(n-1,1),1) + diag(ones(n-1,1),-1);
sol = ones(n,1);
b = A*sol;
toll = 1e-5;
x0 = zeros(n,1);
kmax = 100;

% Controlli generali
[mA,nA] = size(A);
if (mA~=nA)
    error('La matrice A non e'' quadrata')
end
if length(b) ~= nA
    error('Le dimensioni di A e b non sono compatibili')
end

% Visualizzazioni di controllo
disp('Dimensione del sistema')
disp(mA)
disp('Tolleranza')
disp(toll)

cont = 'S';
while (cont ~= 'N')
    % Definizione del fattore di rilassamento
    % Inserimento valore alfa
    w = input ('Inserisci il valore di w: ');
    if (w <=0) || (w >= 2)
        error('Il valore di w deve essere 0<w<2')
        hold off
    end

    % Risoluzione
    % Metodo SOR
    [x,k,flag] = SOR(A,b,w,x0,toll,kmax);

    % Controlli
    if flag ~= 0  
        error('Non si puo` applicare il metodo SOR: M singolare!') 
    end

    disp('Numero di iterate')
    disp(k)
    if k == kmax
        disp('Massimo numero di iterate raggiunto')
    end

    % Uscita risultati
    disp('Fattore di rilassamento w =')
    disp(w)
    % Grafico
    for j = 1:k+1
        err(j) = norm(x(:,j)-sol);
    end
    xk = 0:k;
    semilogy(xk,err(1:k+1));
    text(k+1-9,err(k+1),['w=',num2str(w)])
    hold on
    
    % controllo per la continuazione 
    cont = input (' Se NON vuoi continuare digita N, altrimenti S ','s');
    % considera solo il primo carattere di quanto scritto
    cont = upper(cont(1));
end
% Commenta la figura
title('Metodo SOR')
xlabel('iterate')
ylabel('norma dell''errore')
hold off
