function [int,h] = simpson (f,a,b,m);
%SIMPSON Metodo di Cavalieri-Simpson composto
%
% [int,h] = simpson (f,a,b,m);
%
% Dati di ingresso:
% f: funzione integranda
% a: estremo sinistro dell'intervallo di integrazione
% b: estremo destro dell'intervallo di integrazione
% m: numero di sottointervalli
%
% Dati di uscita:
% int: approssimazione dell'integrale definito
% h: passo di integrazione


h=(b-a)/m; 
x=a:h/2:b; 
y=f(x);
int=(h/6)*(y(1)+2*sum(y(3:2:2*m-1))+4*sum(y(2:2:2*m))+y(2*m+1));

