
function [xv, fxv, n] = secfis (f, x0, x1, toll, nmax)

%SECFIS Metodo della secante fissa per equazione non lineare
%
% Uso:
%   [xv, fxv, n] = secfis(f, x0, x1, toll, nmax)
%
% Dati di ingresso:
%   f:      funzione
%   x0:     prima iterata
%   x1:     seconda iterata
%   toll:   tolleranza richiesta per il valore assoluto
%           tra due iterate successive
%   nmax:   massimo numero di iterate permesse
%
% Dati di uscita:
%   xv:     vettore contenente le iterate
%   fxv:    vettore contenente i corrispondenti residui
%   n:      numero di iterate della successione

xv(1)=x0; fxv(1)=feval(f,xv(1));
xv(2)=x1; fxv(2)=feval(f,xv(2));

if fxv(1) == fxv(2)
    n=length(xv); 
    fprintf('\n \t Rapporto incrementale non calcolabile.');
    return;
else
    m=(xv(2)-xv(1))/(fxv(2)-fxv(1));
end

if abs(xv(2)-xv(1)) <= toll
    n=length(xv); return;
end

for k=2:nmax-1
    xv(k+1)=xv(k)-fxv(k)*m;
    fxv(k+1)=feval(f,xv(k+1));
    if abs(xv(end)-xv(end-1)) <= toll
        n=length(xv); return;
    end
end

n=length(xv);
fprintf('\n \t Il metodo ha svolto troppe iterazioni.');

