
function demo_I
% Demo: Metodo della secante fissa per equazione non lineare

% dati
f=@(x) x-0.9*cos(x)+1;
x0=-0.5;
x1=0;
toll=1.0e-12;
nmax=1000;

% metodo secante fissa
[xv, fxv, n] = secfis (f, x0, x1, toll, nmax);

% plot
hold on;
semilogy(1:length(fxv),abs(fxv));
title('errore secanti fisse');
xlabel('iterazioni');
ylabel('residuo');
hold off;
print('grafico_errore','-dpdf');

% statistiche
fprintf('\n \t soluzione  : %1.15e',xv(end));
fprintf('\n \t residuo    : %1.15e',fxv(end));
fprintf('\n \t iterazioni : %4.0f \n',n);

