function [x,w]=clenshaw_curtis(n,a,b)

N=[1:2:n-1]'; l=length(N); m=n-l; K=[0:m-1]';

g0=-ones(n,1); g0(1+l)=g0(1+l)+n; g0(1+m)=g0(1+m)+n;
g=g0/(n^2-1+mod(n,2));
end_N=length(N);
v0=[2./N./(N-2); 1/N(end_N); zeros(m,1)];
end_v0=length(v0);
v2=-v0(1:end_v0-1)-v0(end_v0:-1:2);
wcc=ifft(v2+g); weights=[wcc;wcc(1,1)];
k=0:n; nodes=(cos(k*pi/n))';

x=(a+b)/2+((b-a)/2)*nodes;
w=weights*((b-a)/2);

x=real(x);
w=real(w);
