function varargout = Euler_Back_GUI(varargin)
% EULER_BACK_GUI M-file for Euler_Back_GUI.fig
%      EULER_BACK_GUI, by itself, creates a new EULER_BACK_GUI or raises the existing
%      singleton*.
%
%      H = EULER_BACK_GUI returns the handle to a new EULER_BACK_GUI or the handle to
%      the existing singleton*.
%
%      EULER_BACK_GUI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in EULER_BACK_GUI.M with the given input arguments.
%
%      EULER_BACK_GUI('Property','Value',...) creates a new EULER_BACK_GUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Euler_Back_GUI_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Euler_Back_GUI_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Copyright 2002-2003 The MathWorks, Inc.

% Edit the above text to modify the response to help Euler_Back_GUI

% Last Modified by GUIDE v2.5 22-Nov-2005 20:15:35

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Euler_Back_GUI_OpeningFcn, ...
                   'gui_OutputFcn',  @Euler_Back_GUI_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before Euler_Back_GUI is made visible.
function Euler_Back_GUI_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Euler_Back_GUI (see VARARGIN)

% Choose default command line output for Euler_Back_GUI
handles.output = hObject;

% Initialize variables
handles.param_c = -1;
handles.param_d = 1;
handles.param_x0 = 0;
handles.param_b = 2*pi;
handles.param_stepsize = .1;
handles.param_Y0 = 1;
handles.indexfcn = 1;
handles.param_print_M = 5;
handles.it_method = 1;  % 1: 'fixed point iteration' 
                        % 2: 'Newton iteration'
                        % 3: 'Exact numerical solution'
handles.it_number = 1;  % The number of iterates to be computed
handles.fcn_data = [handles.indexfcn,handles.param_c,handles.param_d];
handles.prob_data = [handles.param_x0,handles.param_b,handles.param_Y0];
handles.solve_data = [handles.param_stepsize,handles.param_print_M];
handles.it_method_data = [handles.it_method,handles.it_number];
% Update handles structure
% disp('Euler_Back_GUI_OpeningFcn')
handles;
guidata(hObject, handles);

% UIWAIT makes Euler_Back_GUI wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = Euler_Back_GUI_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on selection change in popupmenu_f.
function popupmenu_f_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu_f (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu_f contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu_f

indexfcn = get(hObject,'Value');
handles.indexfcn = indexfcn;
handles.fcn_data = [indexfcn,handles.param_c,handles.param_d];

handles.param_Y0 = InitialValue(handles.fcn_data);
handles.prob_data = [handles.param_x0,handles.param_b,handles.param_Y0];
handles.solve_data = [handles.param_stepsize,handles.param_print_M];

% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function popupmenu_f_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu_f (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function Parameter_c_Callback(hObject, eventdata, handles)
% hObject    handle to Parameter_c (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Parameter_c as text
%        str2double(get(hObject,'String')) returns contents of Parameter_c as a double

param_c = eval(get(handles.Parameter_c,'String'));
handles.param_c = param_c;
handles.fcn_data = [handles.indexfcn,handles.param_c,handles.param_d];

% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function Parameter_c_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Parameter_c (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Parameter_d_Callback(hObject, eventdata, handles)
% hObject    handle to Parameter_d (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Parameter_d as text
%        str2double(get(hObject,'String')) returns contents of Parameter_d as a double

param_d = eval(get(handles.Parameter_d,'String'));
handles.param_d = param_d;
handles.fcn_data = [handles.indexfcn,handles.param_c,handles.param_d];

% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function Parameter_d_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Parameter_d (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function Endpoint_b_Callback(hObject, eventdata, handles)
% hObject    handle to Endpoint_b (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Endpoint_b as text
%        str2double(get(hObject,'String')) returns contents of Endpoint_b as a double

param_b = eval(get(handles.Endpoint_b,'String'));
handles.param_b = param_b;
handles.prob_data = [handles.param_x0,handles.param_b,handles.param_Y0];

% Update handles structure
% disp('Endpoint_b_Callback')
handles;
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function Endpoint_b_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Endpoint_b (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Stepsize_Callback(hObject, eventdata, handles)
% hObject    handle to Stepsize (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Stepsize as text
%        str2double(get(hObject,'String')) returns contents of Stepsize as a double

stepsize_h = eval(get(handles.Stepsize,'String'));
handles.param_stepsize = stepsize_h;
handles.solve_data = [handles.param_stepsize,handles.param_print_M];

% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function Stepsize_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Stepsize (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function Param_M_Callback(hObject, eventdata, handles)
% hObject    handle to Param_M (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Param_M as text
%        str2double(get(hObject,'String')) returns contents of Param_M as a double

print_M = eval(get(handles.Param_M,'String'));
handles.param_print_M = print_M;
handles.solve_data = [handles.param_stepsize,handles.param_print_M];

% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function Param_M_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Param_M (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in OutputBox.
function OutputBox_Callback(hObject, eventdata, handles)
% hObject    handle to OutputBox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns OutputBox contents as cell array
%        contents{get(hObject,'Value')} returns selected item from OutputBox


% --- Executes during object creation, after setting all properties.
function OutputBox_CreateFcn(hObject, eventdata, handles)
% hObject    handle to OutputBox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --------------------------------------------------------------------
function FileTag_Callback(hObject, eventdata, handles)
% hObject    handle to FileTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if isempty(get(handles.axes1,'Children'))
    set(handles.LeftGraphTag,'Enable','off')
    set(handles.RightGraphTag,'Enable','off')
else
    set(handles.LeftGraphTag,'Enable','on')
    set(handles.RightGraphTag,'Enable','on')
end


% --------------------------------------------------------------------
function HelpTag_Callback(hObject, eventdata, handles)
% hObject    handle to HelpTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

Euler_Back_Help


% --------------------------------------------------------------------
function TableOutput_Callback(hObject, eventdata, handles)
% hObject    handle to TableOutput (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Load data from handles structure
StringData = handles.StringData;

fid = fopen('output_Euler','w');
disp('The table is saved under the name "output_Euler"')

[num_rows,num_cols] = size(StringData);

for i=1:num_rows
    fprintf(fid,'%c',StringData(i,1:num_cols));
    fprintf(fid,'\n');
end

fclose(fid);


% --------------------------------------------------------------------
function LeftGraphTag_Callback(hObject, eventdata, handles)
% hObject    handle to LeftGraphTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

h_invisible = figure('visible','off'); 
hax = copyobj(handles.axes1,h_invisible);
set(hax,'units',get(0,'defaultaxesunits'),'position',get(0,'defaultaxesposition'))
print(h_invisible,'-depsc','Solutions') 
close(h_invisible);
disp('The graph is stored under the name "Solutions.eps"')


% --------------------------------------------------------------------
function RightGraphTag_Callback(hObject, eventdata, handles)
% hObject    handle to RightGraphTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

h_invisible = figure('visible','off'); 
hax = copyobj(handles.axes2,h_invisible);
set(hax,'units',get(0,'defaultaxesunits'),'position',get(0,'defaultaxesposition'))
print(h_invisible,'-depsc','Errors') 
close(h_invisible);
disp('The graph is stored under the name "Errors.eps"')


% --------------------------------------------------------------------
function CloseTag_Callback(hObject, eventdata, handles)
% hObject    handle to CloseTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

delete(handles.figure1)


% --------------------------------------------------------------------
% --- Executes on selection change in iteration_menu.
function iteration_menu_Callback(hObject, eventdata, handles)
% hObject    handle to iteration_menu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns iteration_menu contents as cell array
%        contents{get(hObject,'Value')} returns selected item from iteration_menu
it_method = get(hObject,'Value');
handles.it_method = it_method;
handles.it_method_data = [handles.it_method,handles.it_number];

handles.param_Y0 = InitialValue(handles.fcn_data);
handles.prob_data = [handles.param_x0,handles.param_b,handles.param_Y0];
handles.solve_data = [handles.param_stepsize,handles.param_print_M];

% Update handles structure
guidata(hObject, handles);


% --------------------------------------------------------------------
% --- Executes during object creation, after setting all properties.
function iteration_menu_CreateFcn(hObject, eventdata, handles)
% hObject    handle to iteration_menu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --------------------------------------------------------------------
function iteration_number_Callback(hObject, eventdata, handles)
% hObject    handle to iteration_number (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of iteration_number as text
%        str2double(get(hObject,'String')) returns contents of iteration_number as a double
it_number = eval(get(handles.iteration_number,'String'));
handles.it_number = it_number;
handles.it_method_data = [handles.it_method,handles.it_number];

% Update handles structure
guidata(hObject, handles);


% --------------------------------------------------------------------
% --- Executes during object creation, after setting all properties.
function iteration_number_CreateFcn(hObject, eventdata, handles)
% hObject    handle to iteration_number (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in Solve_Pushbutton.
function Solve_Pushbutton_Callback(hObject, eventdata, handles)
% hObject    handle to Solve_Pushbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
fcn_data = handles.fcn_data;
prob_data = handles.prob_data;
solve_data = handles.solve_data;
it_method_data = handles.it_method_data;
it_method = it_method_data(1);
it_number = it_method_data(2);
h = solve_data(1);
M = solve_data(2);

switch it_method
case 1
    % Use fixed point iteration
    [x_h,y_h]=euler_back_fp(fcn_data,prob_data,h,it_number);
case 2
    % Use Newton's iteration method
    [x_h,y_h]=euler_back_Newton(fcn_data,prob_data,h,it_number);
case 3
    % Solve the backward Euler equation exactly
    [x_h,y_h]=euler_back_exact(fcn_data,prob_data,h);
end

TrueY_h = Y(x_h,fcn_data);
Error_h = TrueY_h - y_h;
n_h = length(x_h);

switch it_method
case 1
    % Use fixed point iteration
    [x_2h,y_2h]=euler_back_fp(fcn_data,prob_data,2*h,it_number);
case 2
    % Use Newton's iteration method
    [x_2h,y_2h]=euler_back_Newton(fcn_data,prob_data,2*h,it_number);
case 3
    % Solve the backward Euler equation exactly
    [x_2h,y_2h]=euler_back_exact(fcn_data,prob_data,2*h);
end

n_2h = length(x_2h);
upper_limit = n_h;
Error_2h = TrueY_h(1:2:upper_limit) - y_2h;
rich_error = y_h(1:2:upper_limit)-y_2h;

axes(handles.axes1)
plot(x_h,TrueY_h,'g-',x_h,y_h,'b:',x_2h,y_2h,'r-.')
legend('True Y(x)','y_h(x)','y_{2h}(x)','Location','Best')

axes(handles.axes2)
plot(x_h,Error_h,'b:',x_2h,Error_2h,'r-.')
legend('Y(x)-y_h(x)','Y(x)-y_{2h}(x)','Location','Best')

L = floor((n_2h-1)/M) + 1;
celldata = cellstr(num2str(zeros(L+3,1)));
celldata(1) = cellstr('                             EULER METHOD OUTPUT');
celldata(2) = cellstr('         x          y_2h(x)         error          y_h(x)          error      Richardson');
celldata(3) = cellstr('                                                                             Estimate');
for np=1:M:n_2h
    n = (np-1)/M +1;
    celldata(n+3) = cellstr(sprintf('%14.3e%18.7e%13.3e%18.7e%13.3e%13.3e',...
       x_2h(np),y_2h(np),Error_2h(np),y_h(2*np-1),Error_h(2*np-1),rich_error(np)));
end

StringData = char(celldata);
set(handles.OutputBox,'string',StringData);

handles.StringData = StringData;

% Update handles structure
guidata(hObject, handles);


function [x,y] = euler_back_fp(fcn_data,prob_data,h,it_number)
%
% Use ordinary fixed point iteration to solve the backward Euler equation.
%
% Output:
% The routine euler_back_fp will return two vectors, x and y.
% The vector x will contain the node points
%   x(1)=x0, x(j)=x0+(j-1)*h, j=1,2,...,N
% with 
%   x(N) <= x_end-h,  x(N)+h > x_end-h
% The vector y will contain the estimates of the solution Y 
% at the node points in x.
%

x0 = prob_data(1);
x_end = prob_data(2);
y0 = prob_data(3);

n = floor((x_end-x0)/h);
x = x0 + h*[0:n]';
y = zeros(n+1,1);
y(1) = y0;
for i = 1:n
  y(i+1)=y(i)+h*f_ode(x(i),y(i),fcn_data);
  % Carry out simple fixed point iteration
  for j=1:it_number
    y(i+1)=y(i)+h*f_ode(x(i+1),y(i+1),fcn_data);
  end
end


function [x,y] = euler_back_Newton(fcn_data,prob_data,h,it_number)
%
% Use Newton's iteration method to solve the backward Euler equation.
%
% Output:
% The routine euler_back_fp will return two vectors, x and y.
% The vector x will contain the node points
%   x(1)=x0, x(j)=x0+(j-1)*h, j=1,2,...,N
% with 
%   x(N) <= x_end-h,  x(N)+h > x_end-h
% The vector y will contain the estimates of the solution Y 
% at the node points in x.
%

x0 = prob_data(1);
x_end = prob_data(2);
y0 = prob_data(3);

n = floor((x_end-x0)/h);
x = x0 + h*[0:n]';
y = zeros(n+1,1);
y(1) = y0;
for i = 1:n
  y(i+1)=y(i)+h*f_ode(x(i),y(i),fcn_data);
  % Carry out Newton method iteration
  for j=1:it_number
    z = y(i+1);
    y(i+1)=z-(z-(y(i)+h*f_ode(x(i+1),z,fcn_data)))/(1-h*f_ode_partial(x(i+1),z,fcn_data));
  end
end


function [x,y] = euler_back_exact(fcn_data,prob_data,h)
%
% Solve the backward Euler equation exactly.  For generality, we use
% Newton's method and solve to a precision of approximately double
% precision.
%
% Output:
% The routine euler_back_fp will return two vectors, x and y.
% The vector x will contain the node points
%   x(1)=x0, x(j)=x0+(j-1)*h, j=1,2,...,N
% with 
%   x(N) <= x_end-h,  x(N)+h > x_end-h
% The vector y will contain the estimates of the solution Y 
% at the node points in x.
%

x0 = prob_data(1);
x_end = prob_data(2);
y0 = prob_data(3);

n = floor((x_end-x0)/h);
x = x0 + h*[0:n]';
y = zeros(n+1,1);
y(1) = y0;
itnum = 0;
max_iter = 11;
for i = 1:n
  %Solve exactly the Backward Euler equation.
  %disp(['euler_back_exact: i= ',num2str(i)])
  y0 = y(i)+h*f_ode(x(i),y(i),fcn_data);
  error = inf;
  lower = 1;
  iter = 0;
  while abs(error) > lower & iter < max_iter
      iter = iter + 1;
      y1=y0-(y0-(y(i)+h*f_ode(x(i+1),y0,fcn_data)))/(1-h*f_ode_partial(x(i+1),y0,fcn_data));
      if y1 ~= 0
          error = max([abs(y1-y0),abs((y1-y0)/y1)]);
      else
          error = abs(y1-y0)
      end
      y0 = y1;
      lower = 100*eps;
%      disp(['iter = ',num2str(iter)])
%      disp(['y1 = ',num2str(y1)])
  end
  y(i+1) = y1;
  itnum = max([itnum,iter]);
  %disp(['iter  = ',num2str(itnum)])
  %disp(['error = ',num2str(abs(error))])
%  disp(['solution = ',num2str(y1)])
end

function deriv = f_ode(x,z,fcn_data)

index_f = fcn_data(1);
c = fcn_data(2);
d = fcn_data(3);

switch index_f
case 1
    deriv = c*z + (d-c)*cos(d*x) - (d+c)*sin(d*x);
case 2
    deriv = c*z;
case 3
    deriv = (z + x.^2 - 2)./(x+1);
case 4
    deriv = c*z + (d-c)*exp(d*x);
case 5
    deriv = cos(z).^2;
case 6
    deriv = c*z.^2;
case 7
    if d ~= 1
        deriv = c*z.*(d-z);
    else
        deriv = 0;     % Because d=1 and Y(0)=1 implies Y(x) = 1 for all x
    end
end

function partial_deriv = f_ode_partial(x,z,fcn_data)

index_f = fcn_data(1);
c = fcn_data(2);
d = fcn_data(3);

switch index_f
case 1
    partial_deriv = c*ones(size(z));
case 2
    partial_deriv = c*ones(size(z));
case 3
    partial_deriv = ones(size(z));
case 4
    partial_deriv = c*ones(size(z));
case 5
    partial_deriv = -sin(2*z);
case 6
    partial_deriv = 2*c*z;
case 7
    if d ~= 1
        partial_deriv = c*(d-2*z);
    else
        partial_deriv = zeros(size(z));    % Because d=1 and Y(0)=1 implies Y(x) = 1 for all x
    end
end


function Y0 = InitialValue(fcn_data)

indexfcn = fcn_data(1);
c = fcn_data(2);
d = fcn_data(3);

switch indexfcn
case 1
    Y0 = 1;
case 2
    Y0 = 1;
case 3
    Y0 = 2;
case 4
    Y0 = 1;
case 5
    Y0 = 0;
case 6
    Y0 = 1;
case 7
    Y0 = 1;
end


function true = Y(x,fcn_data)

indexfcn = fcn_data(1);
c = fcn_data(2);
d = fcn_data(3);

switch indexfcn
case 1
    true = sin(d*x) + cos(d*x);
case 2
    true = exp(c*x);
case 3
    true = x.^2 + 2*x +2 - 2*(x+1).*log(x+1);
case 4
    true = exp(d*x);
case 5
    true = atan(x);
case 6
    true = 1 ./(1-c*x);
case 7
    if d == 1
        true = ones(size(x));
    elseif d == 0
        true = 1 ./(1+c*x);
    else
        denom = (1/(d-1))*exp(c*d*x)+1;
        true = d*(1 - 1./denom);
    end
end
