function [I_cc,x_cc,w_cc]=integrazione_clenshaw_curtis(N_cc,a,b,f)

% INTEGRAZIONE DI CLENSHAW-CURTIS.

% INPUT: 
% N_cc: GRADO DI CLENSHAW-CURTIS, CIOE' NUMERO DI NODI MENO UNO.
% a, b: ESTREMI DI INTEGRAZIONE.
% f   : FUNZIONE DA INTEGRARE.

% OUTPUT:
% I_cc: APPROSSIMAZIONE DELL'INTEGRALE CON FORMULA DI CLENSHAW-CURTIS.
% x_cc: NODI DI CLENSHAW-CURTIS.
% w_cc: PESI DI CLENSHAW-CURTIS.

% ROUTINES ESTERNE: clenshaw_curtis.

[x_cc,w_cc]=clenshaw_curtis(N_cc,a,b);  % NODI E PESI DI CL.-CURTIS.
fx_cc=feval(f,x_cc);                    % VALUTAZIONE FUNZIONE.  
I_cc=w_cc'*fx_cc;                       % VALORE INTEGRALE.
