function [t,y] = euler_for(t0,y0,t_end,h,fcn)
%
% function [t,y]=euler_for(t0,y0,t_end,h,fcn)
%   
% Solve the initial value problem
%    y' = f(t,y),  t0 <= t <= b,  y(t0)=y0
% Use Euler's method with a stepsize of h.  The user must 
% supply a program to define the right side function of the
% differential equation. Use some name, say deriv, and a first 
% line of the form
%   function ans=deriv(t,y)
% A sample call would be
%   [t,z]=eulercls(t0,z0,b,delta,'deriv')
%
% Output:
% The routine euler_for will return two vectors, t and y.
% The vector t will contain the node points
%   t(1)=t0, t(j)=t0+(j-1)*h, j=1,2,...,n
% with 
%   t(n) <= t_end,  t(n)+h > t_end
% The vector y will contain the estimates of the solution Y 
% at the node points in t.
%
n = fix((t_end-t0)/h)+1;
t = linspace(t0,t0+(n-1)*h,n)';
y = zeros(n,1);
y(1) = y0;
for i = 2:n
  y(i) = y(i-1) + h*feval(fcn,t(i-1),y(i-1));
end

end % euler_for