
function demo_wam_lune

%--------------------------------------------------------------------------
% Object:
%--------------------------------------------------------------------------
% Demo on Weakly Admissible Meshes on circular lunes.
%
% This routine determines such a mesh for fixed degree " deg" on specific
% circular lunes.
%--------------------------------------------------------------------------
% Reference paper
%--------------------------------------------------------------------------
% Discrete norming inequalities on sections of sphere, ball and torus,
% Journal of Inequalities and Special Functions, Volume 9, 2018, 
% pp. 113-121.
% A. Sommariva and M. Vianello.
%--------------------------------------------------------------------------
% Dates:
%--------------------------------------------------------------------------
% Refurbished on January 6, 2026 (by A. Sommariva and M. Vianello).
%--------------------------------------------------------------------------
%% Copyright (C) 2018-
%% Alvise Sommariva, Marco Vianello.
%%
%% This program is free software; you can redistribute it and/or modify
%% it under the terms of the GNU General Public License as published by
%% the Free Software Foundation; either version 2 of the License, or
%% (at your option) any later version.
%%
%% This program is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%% GNU General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; if not, write to the Free Software
%% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
%%
%% Authors:
%% Alvise Sommariva, Marco Vianello.
%%
%% Date       : 2018
%% Modified on: JANUARY 6, 2026
%--------------------------------------------------------------------------

% WAM degree
degree=10;

x1=0; y1=0; r1=1; 
x2=0.5; y2=0; r2=1; 


%-------------------------- main code below -------------------------------

wam = wam_lune(ade,x1,y1,r1,x2,y2,r2);
x=wam(:,1); y=wam(:,2); 

%---------------------------- statistics ----------------------------------

fprintf('\n \t deg  : %-2.0f',deg);
fprintf('\n \t card : %-2.0f',length(x));

fprintf('\n \n');

%------------------------------ plot --------------------------------------

figure(1)

% circle r1
thetaC=linspace(0,2*pi,1000);
xx=x1+r1*cos(thetaC); yy=y1+r1*sin(thetaC);
plot(xx,yy,'k-','LineWidth',1);

hold on;

% circle r2
xx=x2+r2*cos(thetaC); yy=y2+r2*sin(thetaC);
plot(xx,yy,'k-','LineWidth',1);

% plot pointset
plot(x,y,'o','MarkerFaceColor','red','MarkerSize',3);

axis equal;

title('WAM on circular lune');

hold off;






