function demo_wam_polygon_quad(example)

%--------------------------------------------------------------------------
% Object:
%--------------------------------------------------------------------------
% In this demo we show how to determine WAM over polygons without
% self-intersections
%
% A figure with the domain and the WAM mesh is given.
%--------------------------------------------------------------------------
% Input:
%--------------------------------------------------------------------------
% example: 1: convex polygon. 
%          2: non-convex polygon.
%--------------------------------------------------------------------------
% Subroutines:
%--------------------------------------------------------------------------
% 1.  wam_polygon_quad (external)
% as well as its subroutines.
%--------------------------------------------------------------------------
% Examples:
%--------------------------------------------------------------------------
% >> demo_wam_polygon_quad(1)
% 
%  ..................... Summary .............................
%   Example    : 1 
%   Vertices   : 6      
%   Quadrangles: 2      
% 
%   Degree WAM : 10 
%   Card. WAM  : 288    
% 
% >> demo_wam_polygon_quad(2)
% 
%  ..................... Summary .............................
%   Example    : 2 
%   Vertices   : 9      
%   Quadrangles: 4      
% 
%   Degree WAM : 10 
%   Card. WAM  : 510    
% 
% >>
%--------------------------------------------------------------------------
% Copyright
%--------------------------------------------------------------------------
%% Copyright (C) 2026- Alvise Sommariva, Marco Vianello.
%%
%% This program is free software; you can redistribute it and/or modify
%% it under the terms of the GNU General Public License as published by
%% the Free Software Foundation; either version 2 of the License, or
%% (at your option) any later version.
%%
%% This program is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%% GNU General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; if not, write to the Free Software
%% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
%%
%% Author:  
%%          Alvise Sommariva <alvise@math.unipd.it>
%%          Marco Vianello   <marcov@math.unipd.it>
%%
%% Date       : January 2, 2026
%% Modified on: January 2, 2026
%--------------------------------------------------------------------------

if nargin < 1, example=1; end
deg=10;


% ........................... main code below .............................  

switch example
    case 1
        vertices=[0.1 0; 0.7 0.2; 1 0.5; 0.75 0.85; 0.5 1; 0 0.25; 0.1 0];
    case 2
        vertices=(1/4)*[1 2; 1 0; 3 2; 3 0; 4 2; 3 3; 3 0.85*4; 2 4;
            0 3; 1 2];
end

% ............................ compute WAM ................................

[pts_wam,quadrangles_storage]=wam_polygon_quad(deg,vertices);


% .............................. plot .....................................

figure(1)
plot(vertices(:,1),vertices(:,2),'k-','LineWidth',3);
hold on;
plot(pts_wam(:,1),pts_wam(:,2),'o','MarkerFaceColor','g',...
    'MarkerEdgeColor','k','MarkerSize',3);

for k=1:length(quadrangles_storage)
    quadrangleL=quadrangles_storage{k};
    plot(quadrangleL(:,1),quadrangleL(:,2),'r-','LineWidth',1);
end

hold off;


% ........................... statistics ..................................

fprintf('\n ..................... Summary .............................');
fprintf('\n  Example    : %-2.0f',example);
fprintf('\n  Vertices   : %-7.0f',size(vertices,1)-1);
fprintf('\n  Quadrangles: %-7.0f',length(quadrangles_storage));
fprintf('\n \n  Degree WAM : %-3.0f',deg);
fprintf('\n  Card. WAM  : %-7.0f',size(pts_wam,1));
fprintf('\n \n');