
function demo_02_26

%--------------------------------------------------------------------------
% Object:
%--------------------------------------------------------------------------
% Cubature test over polyhedra (convex or concave, even with odd shapes).
% Demo expaining the subroutines usage.
%--------------------------------------------------------------------------
% Warning:
%--------------------------------------------------------------------------
% If ade > 10, then "demo_cubature_polyhedron" can be very time consuming
% also offering bad compression results.
%
% The test requires Matlab built-in "polyshape" toolbox.
%--------------------------------------------------------------------------
% Example
%--------------------------------------------------------------------------
% >> demo_02_26
% 
%  	 IT :  2.485660443496637e-02
%  	 ITC:  2.485661943917204e-02
%  	 ITF:  2.485660185802515e-02
% 
%  	 .................... Legend ...........................
%  	 IT : Cubature via Triangulation algorithm
%  	 ITC: Cubature via Compressed Triangulation algorithm
%  	 ITF: Cubature via Triangulation Free algorithm
% 
%  	 .................... Figure ...........................
%  	 Figure 1. Integration domain
%  	 ....................................................... 
% >>
%--------------------------------------------------------------------------

ade=6;

vertices=[
    7.019456892102048e-01 6.559481695335554e-01 8.318498806648059e-01
    3.928739144202648e-01 8.565376013216209e-01 3.944709820411555e-01
    5.718686630258228e-01 2.709404658120863e-01 9.663634688171530e-02
    2.497737351837366e-01 8.959477796220956e-01 2.653916148253564e-01
    7.273467331114006e-01 2.087903958723814e-01 7.919450125521071e-01
    3.433291453593958e-01 9.641681802460583e-01 9.368607426003079e-01
    7.863467486325948e-02 4.143600880391674e-01 5.682585883425429e-01
    3.022309282744359e-01 2.295652138635622e-01 9.380215572322496e-01
    3.004024819239974e-01 8.183701989647573e-01 5.972483945500038e-01
    2.322119759663466e-02 3.604434932620764e-01 9.879519676560238e-01
    1.761142516577059e-01 5.015240681494324e-01 7.623485025252664e-01
    8.609187966110264e-01 7.476741184362131e-01 1.856158686068560e-01
    ];
alphashape_radius=4e-01;

% Method using triangulation.
SHP = alphaShape(vertices(:,1),vertices(:,2),vertices(:,3),...
    alphashape_radius);

% Each facet is coded as indices of vertices (k-th row in matrix). 
% In our example:
% facets =
% 
%     10     8    11
%      7    10    11
%      ... ... ...
%      4    12     3

facets = boundaryFacets(SHP);

% Each tetrahedron is coded as indices of vertices (k-th row in matrix). 
% In our example:
% tri =
%      7    10     8    11
%      4     7     3     2
%      ...   ...   ...   ...
%      4     3    12     2

tri = alphaTriangulation(SHP);

% Full rule with triangulation.
XYZW=cub_polyhedron_tri_26(vertices,ade,tri);

% Full rule and compressed with triangulation.
[XYZW,XYZWC]=cub_polyhedron_tri_26(vertices,ade,tri);

% Triangulation free method.
[XYZWF,flag,iteration_stats]=cub_polyhedron_free_26(vertices,facets,...
    ade);


% .... Cubature test ....
f=@(x,y,z) exp(-(x-1).^2-(y-0.5).^2-(z-0.1).^2);

% triangulation algorithm (full)
fT=feval(f,XYZW(:,1),XYZW(:,2),XYZW(:,3)); % function eval. at nodes
WT=XYZW(:,4); % weights.
IT= WT'*fT; % numerical result

% triangulation algorithm (compressed)
fTC=feval(f,XYZWC(:,1),XYZWC(:,2),XYZWC(:,3)); % function eval. at nodes
WTC=XYZWC(:,4); % weights.
ITC= WTC'*fTC; % numerical result

% triangulation free algorithm
fTF=feval(f,XYZWF(:,1),XYZWF(:,2),XYZWF(:,3)); % function eval. at nodes
WTF=XYZWF(:,4); % weights.
ITF= WTF'*fTF; % numerical result

% Show results.
fprintf('\n \t IT :  %1.15e',IT);
fprintf('\n \t ITC:  %1.15e',ITC);
fprintf('\n \t ITF:  %1.15e',ITF);

fprintf('\n \n \t .................... Legend ...........................');

fprintf('\n \t IT : Cubature via Triangulation algorithm');
fprintf('\n \t ITC: Cubature via Compressed Triangulation algorithm');
fprintf('\n \t ITF: Cubature via Triangulation Free algorithm');


% Plot domain
clf;
plot(SHP);

fprintf('\n \n \t .................... Figure ...........................');

fprintf('\n \t Figure 1. Integration domain');

fprintf('\n \t ....................................................... \n');