
function plot_QMC_union_spheres_26(centers,radii,xyz)

%--------------------------------------------------------------------------
% OBJECT
%--------------------------------------------------------------------------
% This routine plots
%
% 1. n spheres, in which the k-th one has center "centers(k,:)" and radius
%   "radii(k)",
%
% 2. the pointset "xyz" in which the k-th point is "xyw(k,:)".
%--------------------------------------------------------------------------
% LICENSE:
%--------------------------------------------------------------------------
% Copyright (C) 2026- 
%
% Giacomo Elefante, Alvise Sommariva, Marco Vianello.
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
%
% Authors:
%
% Giacomo Elefante <giacomo.elefante@usi.ch>
% Alvise Sommariva <alvise@math.unipd.it>
% Marco Vianello   <marcov@math.unipd.it>
%
% Date: January 24, 2026
%--------------------------------------------------------------------------


[XX,YY,ZZ] = sphere;
for i = 1:length(radii)
    XXi=radii(i)*XX + centers(i,1);
    YYi=radii(i)*YY + centers(i,2);
    ZZi=radii(i)*ZZ + centers(i,3);

    surf(XXi,YYi,ZZi,...
        'EdgeColor','none','FaceLighting','gouraud',...
        'FaceColor',[220 220 220]/256,'FaceAlpha',0.05);
    axis equal
    hold on;
end

if size(xyz,1) > 0
    plot3(xyz(:,1),xyz(:,2),xyz(:,3),...
        '.',"MarkerEdgeColor",[149 149 149]/256,'MarkerSize',4)
end