
function demo_am_00

%--------------------------------------------------------------------------
% Object:
%--------------------------------------------------------------------------
% This routine computes and plots an AM of a spherical triangle of the
% unit-sphere.
%--------------------------------------------------------------------------
% Example:
%--------------------------------------------------------------------------
%
% >> % ......................... EXAMPLE 1  ............................... 
% >> % setting "n=3" 
% >> demo_am_00
% 
%  	 AM degree:    3
%  	 Subtriangles:    1 
% 
%  	 Cardinality AM  :        813
%  	 .........................................................
%  	 Legend:
%  	 .........................................................
%  	 * Subtriangles: the routine may subdivide the spherical
%  	         triangle in smaller spherical triangles;
%  	 .........................................................
% 
% >> % ......................... EXAMPLE 2  ............................... 
% >> % setting "n=10"
% >> demo_am_00
% 
%  	 AM degree:   10
%  	 Subtriangles:    1 
% 
%  	 Cardinality AM  :       8557
%  	 .........................................................
%  	 Legend:
%  	 .........................................................
%  	 * Subtriangles: the routine may subdivide the spherical
%  	         triangle in smaller spherical triangles;
%  	 .........................................................
% 
% >>
%--------------------------------------------------------------------------
% Reference paper:
%--------------------------------------------------------------------------
% Chebyshev-Dubiner norming grids and Fekete-like interpolation
% on spherical triangles
% A. Sommariva and M. Vianello
% Department of Mathematics, University of Padova, Italy
%--------------------------------------------------------------------------
% Dates:
%--------------------------------------------------------------------------
% Written on 08/02/2021: A. Sommariva and M. Vianello.
% Modified on 31/12/2025 by A. Sommariva and M. Vianello.
%--------------------------------------------------------------------------
% License:
%--------------------------------------------------------------------------
% Copyright (C) 2021- Alvise Sommariva, Marco Vianello.
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
%
% Authors:
%
% Alvise Sommariva <alvise@math.unipd.it>
% Marco Vianello <marcov@math.unipd.it>
%
% Date: December 31, 2025
%--------------------------------------------------------------------------

% ............................. settings ..................................

% ... AM degree (on spherical triangle) ...
n=10;

% ... coordinates planar triangle determining the spherical counterpart ...

% k-th point of the spherical triangle as k-th row
Q=[ -3.189827176852499e-01                     0  9.477605318951260e-01
     3.216349554603996e-01 -4.082482904638630e-01 8.543326569664302e-01
    -2.652237775149153e-03  4.082482904638631e-01 9.128670762866395e-01];


% ............................. experiment ................................

[am_sphtr,deg_am] = am_sphtri(n,Q);

% ............................. stats .....................................
fprintf('\n \t AM degree: %4.0f',n);
fprintf('\n \t Subtriangles: %4.0f \n',length(deg_am));
fprintf('\n \t Cardinality AM  : %10.0f',size(am_sphtr,1));

fprintf('\n \t .........................................................');
fprintf('\n \t Legend:');
fprintf('\n \t .........................................................');
fprintf('\n \t * Subtriangles: the routine may subdivide the spherical');
fprintf('\n \t         triangle in smaller spherical triangles;');
fprintf('\n \t .........................................................');
fprintf('\n \n');



% .............................. plot .....................................

clf;
[X,Y,Z] = sphere(30);
plot3(X,Y,Z,'MarkerFaceColor','red');
hold on;
plot3(am_sphtr(:,1),am_sphtr(:,2),am_sphtr(:,3),'r.','MarkerSize',10);
hold off;


