
function demo_wam_toroidal_slice

%--------------------------------------------------------------------------
% Object:
%--------------------------------------------------------------------------
% Demo on "weakly admissible meshes" on toroidal (surface) slices.
%
% This routine determines such a mesh for fixed degree " deg" on specific
% domains.
%--------------------------------------------------------------------------
% Reference paper
%--------------------------------------------------------------------------
% [1] Discrete norming inequalities on sections of sphere, ball and torus,
% Journal of Inequalities and Special Functions, Volume 9, 2018,
% pp. 113-121.
% A. Sommariva and M. Vianello.
%--------------------------------------------------------------------------
% Dates:
%--------------------------------------------------------------------------
% Written in 2018, modified on January 6, 2026.
%--------------------------------------------------------------------------
%% Copyright (C) 2018-
%% Alvise Sommariva, Marco Vianello.
%%
%% This program is free software; you can redistribute it and/or modify
%% it under the terms of the GNU General Public License as published by
%% the Free Software Foundation; either version 2 of the License, or
%% (at your option) any later version.
%%
%% This program is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%% GNU General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; if not, write to the Free Software
%% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
%%
%% Authors:
%% Alvise Sommariva, Marco Vianello.
%%
%% Date       : 2018
%% Modified on: JANUARY 6, 2026
%--------------------------------------------------------------------------

n=10; % WAM degree

r=1; R=2; % minor and major radii of the torus
phi(1)=pi/8; phi(2)=pi/4; % longitudinal interval

wam=wam_toroidal_slice(n,r,R,phi);

% ............................... statistics ..............................

fprintf('\n \t ............. WAM on toroidal slice ............. \n');
fprintf('\n \t minor radius ''r''  : %1.5e',r);
fprintf('\n \t major radius ''R''  : %1.5e',R);
fprintf('\n \t minor theta       : %1.5e',-pi);
fprintf('\n \t major theta       : %1.5e',-pi);
fprintf('\n \t minor phi         : %1.5e',phi(1));
fprintf('\n \t major phi         : %1.5e',phi(2));
fprintf('\n ');
fprintf('\n \t degree WAM        : %-8.0f',n);
fprintf('\n \t cardinality       : %-8.0f',size(wam,1));
fprintf('\n ');
fprintf('\n \t a) the angle "theta" describes the latitude;');
fprintf('\n \t b) the angle "phi" describes the longitude.');
fprintf('\n \n');

% ............................. plot pointset .............................

figure(1);
plot_torus(r,R);
hold on; 
plot3(wam(:,1),wam(:,2),wam(:,3),'ko','MarkerSize',4);
title('WAM on toroidal slice');
hold off;












function plot_torus(r,R)

[theta,phi] = meshgrid(linspace(0,2*pi,30));
x = (R + r*cos(theta)).*cos(phi);
y = (R + r*cos(theta)).*sin(phi);
z = r*sin(theta);
surf(x,y,z)
shading interp
colormap parula
axis equal
