
function [leb_M,leb1,wam_size,ls_norm]=computing_lebesgue_constant(basis_type,...
    M,wam_select,Pmat,ind,C,V_ls)

leb1=[]; ls_norm=[];
% fprintf('\n \n \t >> LEBESGUE - LEAST SQUARES STATS. ');
leb_M=[M 2*M 3*M 4*M 5*M]; % INCREASING sequence of M.

large_mesh=0;

for ii=1:length(leb_M)

    if (leb_M(ii) <= 100) & (large_mesh == 0)

        [test_leb_nodes_x,test_leb_nodes_y,...
            rect]=wam2D(leb_M(ii),wam_select);

        if length(test_leb_nodes_x) < 10000

            V_leb_test=vandermonde_2D(basis_type,...
                [test_leb_nodes_x test_leb_nodes_y],M,...
                rect);

            C_leb_test=V_leb_test*Pmat;

            leb1(ii)=norm(C(:,ind)\C_leb_test',1);
            wam_size(ii)=length(test_leb_nodes_x);
            ls_norm(ii)=norm((V_ls*Pmat)*(V_leb_test*Pmat)',1);

        else

            large_mesh=1;

        end

    end

end

if length(leb1) == 0

    fprintf('\n \t [WARNING]: LARGE WAMS. RESULTS MAY BE INACCURATE.');

    leb_M=[2 3 4];

    for ii=1:length(leb_M)

        if leb_M(ii) <= 100

            [test_leb_nodes_x,test_leb_nodes_y,rect]=wam2D(leb_M(ii),...
                wam_select);

            if length(test_leb_nodes_x) < 10000

                V_leb_test=vandermonde_2D(basis_type,...
                    [test_leb_nodes_x test_leb_nodes_y],M,rect);

                C_leb_test=V_leb_test*Pmat;

                leb1(ii)=norm(C(:,ind)\C_leb_test',1);
                wam_size(ii)=length(test_leb_nodes_x);
                ls_norm(ii)=norm((V_ls*Pmat)*(V_leb_test*Pmat)',1);

            end

        end

    end

end