
function [nodes_x,nodes_y,rect]=wam2D(M,wam_select)

%--------------------------------------------------------------------------
% OBJECT:
%----------
%
% THIS ROUTINE DEFINES CERTAIN WAMS ON 2D DOMAINS.
%
%---------
% INPUT.
%---------
%
% M : DEGREE OF THE VANDERMONDE BASIS.
%
% wam_select: SPECIFIES THE 2D DOMAIN.
%
%             1: SQUARE.
%
%----------
% OUTPUT.
%----------
%
% nodes_x,nodes_y: x,y COMPONENTS OF WAM POINTS.
%
% rect: REFERENCE RECTANGLE WITH SIDES PARALLEL TO THE x,y AXIS.
%
%--------------------------------------------------------------------------
% HOW TO ADD WAMS.
%------------------
% IF YOU INTEND TO ADD YOUR OWN WAM, ADD IT TO THE ROUTINE "wam2D.m".
% SET A RIGHT CASE IN "switch wam_select" COMMAND AT THE BEGINNING OF 
% THE ROUTINE "wam2D.m".
%--------------------------------------------------------------------------
%% Copyright (C) 2010 Alvise Sommariva, Marco Vianello.
%%
%% This program is free software; you can redistribute it and/or modify
%% it under the terms of the GNU General Public License as published by
%% the Free Software Foundation; either version 2 of the License, or
%% (at your option) any later version.
%%
%% This program is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%% GNU General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; if not, write to the Free Software
%% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
%%
%% Authors: Alvise Sommariva <alvise@euler.math.unipd.it>
%%          Marco Vianello   <marcov@euler.math.unipd.it>
%%
%% Date: March 01, 2010
%--------------------------------------------------------------------------

switch wam_select
    
    case 1
        n=M;
        [nodes1D,weights]=quadrature_rules_1D(n,4);
        [Xmat,Ymat]=meshgrid(nodes1D);
        
        nodes_x=Xmat(:);
        nodes_y=Ymat(:);
        
        rect=[-1 1 -1 1];
        
end

