
function demo_am_00

%--------------------------------------------------------------------------
% Object:
% This routine computes and plots an AM of a spherical triangle of the
% unit-sphere.
%--------------------------------------------------------------------------
% Reference paper:
% Chebyshev-Dubiner norming grids and Fekete-like interpolation
% on spherical triangles
% A. Sommariva and M. Vianello
% Department of Mathematics, University of Padova, Italy
%--------------------------------------------------------------------------
% Dates:
% Written on 08/02/2021: A. Sommariva and M. Vianello.
% Modified on 13/02/2021 by A. Sommariva and M. Vianello.
%--------------------------------------------------------------------------

% ............................. settings ..................................

% ... AM degree (on spherical triangle) ...
n=3;

% ... coordinates planar triangle determining the spherical counterpart ...

% k-th point of the spherical triangle as k-th row
Q=[ -3.189827176852499e-01                     0  9.477605318951260e-01
     3.216349554603996e-01 -4.082482904638630e-01 8.543326569664302e-01
    -2.652237775149153e-03  4.082482904638631e-01 9.128670762866395e-01];


% ............................. experiment ................................

[am_sphtr,deg_am] = am_sphtri(n,Q);

% ............................. stats .....................................
fprintf('\n \t AM degree: %4.0f',n);
fprintf('\n \t Subtriangles: %4.0f \n',length(deg_am));
fprintf('\n \t Cardinality AM  : %10.0f',size(am_sphtr,1));

fprintf('\n \t .........................................................');
fprintf('\n \t Legend:');
fprintf('\n \t .........................................................');
fprintf('\n \t * Subtriangles: the routine may subdivide the spherical');
fprintf('\n \t         triangle in smaller spherical triangles;');
fprintf('\n \t .........................................................');
fprintf('\n \n');



% .............................. plot .....................................

clf;
[X,Y,Z] = sphere(30);
plot3(X,Y,Z,'MarkerFaceColor','red');
hold on;
plot3(am_sphtr(:,1),am_sphtr(:,2),am_sphtr(:,3),'r.','MarkerSize',10);
hold off;


