
function demo_figure_02A

%--------------------------------------------------------------------------
% Object:
% deg + 1 = 9 radially mapped Chebyshev-Lobatto nodes Cm(A, Q) from
% the segment [A,Q] to the arc with ? = ?/8 (red dots), together with the 
% set of equispaced points in the Dubiner distance (black dots). 
% Notice that Q in (H,B],where H is such that BAH=?* =?/6.
%--------------------------------------------------------------------------
% Reference:
% A. Sommariva and M. Vianello
% "Norming grids and polynomial interpolation on spherical triangles".
% See Figure 2.
%--------------------------------------------------------------------------

clf;

deg=8;
w=pi/8;
w_star=pi/6;
w_starQ=pi/17;

% ........................... settings ..........................
L_up=1;
s_starQ=1-2*(sin(w))^2-2*sin(w)*cos(w)*tan(w_starQ-w); 
s_star=1-2*(sin(w))^2-2*sin(w)*cos(w)*tan(w_star-w); 
L_low=s_starQ;

% ....................... special points .......................
A=L_up*[cos(w) sin(w)]; Q=L_low*[cos(w) -sin(w)]; B=[cos(w) -sin(w)];

% ........................... point H ...........................
H=s_star*[cos(w) -sin(w)];

% ....................... segment pointset .......................
t=gauss_lobatto_01(deg); % column vector
PsegmX=t*Q(1)+(1-t)*A(1); PsegmY=t*Q(2)+(1-t)*A(2);
theta=angle(PsegmX+i*PsegmY);

% ....................... radial pointset .......................
PsegmXsph=cos(theta); PsegmYsph=sin(theta);




% ....................... plot figure .......................

clf;

hold on; axis equal;

% ....................... sides OA, OB .......................
plot([0 A(1)],[0 A(2)],'k-');  plot([0 B(1)],[0 B(2)],'k-');

% ....................... arc .......................
tt=linspace(-w+pi/2,w+pi/2,1000); plot(sin(tt),cos(tt),'k-');

% ....................... segment pointset .......................
ii=1:deg+1; plot(PsegmX(ii),PsegmY(ii),'k-','LineWidth',0.5);
plot(PsegmX,PsegmY,'r.','MarkerSize',14);

% ....................... arc pointsets .......................

% radial points on arc
plot(PsegmXsph,PsegmYsph,'r.','MarkerSize',14);


% equispaced points on arc
tt=arc_equispaced(deg,w);
plot(cos(tt),sin(tt),'k.','LineWidth',2,'MarkerEdgeColor','k',...
    'MarkerFaceColor','g','MarkerSize',8)


% ....................... radial lines .......................
for k=1:deg+1
    plot([0 PsegmXsph(k)],[0 PsegmYsph(k)],':','LineWidth',1);
end

% ....................... horizontal chord .......................
plot([cos(w) cos(w)],[-sin(w) sin(w)],'k:','LineWidth',1);


% ....................... height point  .......................
if L_up >= L_low
    c=A*B'; L=c*B; plot([A(1) L(1)],[A(2) L(2)],'k:','LineWidth',0.1);
else
    c=A*B'; L=c*A; plot([B(1) L(1)],[B(2) L(2)],'k:','LineWidth',0.1);
end

plot(L(1),L(2),'ko','LineWidth',2,'MarkerEdgeColor','k','MarkerFaceColor',...
    'k','MarkerSize',1)

% ....................... segment OM  .......................

plot([0 1],[0 0],'k-.','LineWidth',0.1);


% ....................... segment AH  .......................

plot([A(1) H(1)],[A(2) H(2)],'k:','LineWidth',1);


% ....................... segment A1 Q1  .......................

A1=A/2;
Q1=Q/2;
plot([A1(1) Q1(1)],[A1(2) Q1(2)],'k-','LineWidth',0.5);
A1Q1t=t*A1+(1-t)*Q1;
plot(A1Q1t(:,1),A1Q1t(:,2),'r.','MarkerSize',14);



% ....................... text  .......................

text(A(1),A(2)+10^(-1)*A(2),'A','fontsize',14);
text(B(1),B(2)-10^(-1)*B(2),'B','fontsize',14);
text(L(1),L(2)-10^(-1)*L(2),'L','fontsize',14);
text(H(1),H(2)-10^(-1)*H(2),'H','fontsize',14);
text(Q(1),Q(2)-10^(-1)*Q(2),'Q^{\prime}','fontsize',14);
text(A1(1),A1(2)+10^(-1)*A1(2),'P','fontsize',14);
text(Q1(1),Q1(2)-10^(-1)*Q1(2),'Q','fontsize',14);
text(0,0,'O','fontsize',14);
text(1,0,'M','fontsize',14);

% no ticks
set(gca,'xtick',[])
set(gca,'xticklabel',[])

set(gca,'ytick',[])
set(gca,'yticklabel',[])

set(gca,'visible','off')

% ax = gca; ax.FontSize = 6; ay = gca; ay.FontSize = 6;


% ....................... bigger hole  .......................
% color_dots='blue';
% plot(PsegmX(imax)./norms_P(imax),PsegmY(imax)./norms_P(imax),...
%     'mo','Color',color_dots,'MarkerSize',3,...
%     'MarkerEdgeColor',color_dots,'MarkerFaceColor',color_dots);
hold off







function [t,c]=gauss_lobatto_01(deg)

j=(0:1:deg);
c=cos(j*pi/deg);
t=(c'+1)/2;







function tt=arc_equispaced(deg,w)

[t,c]=gauss_lobatto_01(deg);

tt=2*asin(c*sin(w/2));





function dub=dubiner_filldistance(x,w)

F=@(t,w) 2*asin(sin(t/2)/sin(w/2));

x=sort(x);
L=length(x);

for k=1:L-1
    xm=x(k); xM=x(k+1);
    dub(k)=abs(F(xm,w)-F(xM,w))/2;
end


