
function demo_figure_03A

%--------------------------------------------------------------------------
% Object:
% The maximal ratio maxs?[?(?,??),1] R(m, ?, s))/(?/m) for m = 1,...,2000 
% and ? ? [?/100,??] with ?? = ?/6 (Example1) and ?? = 0.999?/4 (Example2).
%--------------------------------------------------------------------------
% Reference:
% A. Sommariva and M. Vianello
% "Norming grids and polynomial interpolation on spherical triangles".
% See Figure 3.
%--------------------------------------------------------------------------

clear all; clf;

% Example 1:
% degV=10:20:2000; wV=fliplr(linspace(pi/100,pi/6,100));

% Example 2:
 degV=10:20:2000; wV=fliplr(linspace(pi/6,0.9999*pi/4,200));


[degM,wM]=meshgrid(degV,wV);

for j=1:length(degV)
    for k=1:length(wV)
        deg=degV(j); w=wV(k);
        dub_equi=2*pi/deg;
        x=set_1(deg,w);
        y=set_2(deg,w);
        dubx=dubiner_distance(x,w);
        duby=dubiner_distance(y,w);
        fill_dist(k,j)=(max(dubx)/2)/(max(duby)/2);
    end
end

% .................. plot figure ..................  

clf;
figure(1)
surf(degM,wM,fill_dist);
hold on;
shading faceted;
colormap('cool')
% colormap hot;
% colormap([127/255 1 212/255])
% brighten(.1);

h=xlabel('m');
set(h, 'FontSize', 14);
set(h,'FontWeight','bold');
h=ylabel('\omega');
set(h, 'FontSize', 18);
set(h,'FontWeight','bold');
h=zlabel('Ratio');
set(h, 'FontSize', 14);
set(h,'FontWeight','bold');
hold off;



for k=1:length(wV)
    w=wV(k);
    mx(k)=min(fill_dist(k,:));
    Mx(k)=max(fill_dist(k,:));
end


% %plot(wV,mx,'r-','LineWidth',1.5);
% figure(2)
% plot(wV,Mx./mx,'b-','LineWidth',1.5);
% hold on;
% grid minor;
% hold off;






function t=chebyshev_lobatto(m)

%--------------------------------------------------------------------------
% Object:
% Chebyshev-Lobatto set consisting of "m+1" points (good for interpolation
% at degree m)
%--------------------------------------------------------------------------

j=0:m;
t=cos(j*pi/m);







function th1=set_1(m,w)

%--------------------------------------------------------------------------
% Object:
% First set interesting in the paper.
%--------------------------------------------------------------------------

t=chebyshev_lobatto(m);
th1=atan(t*tan(w));
th1=th1';







function th2=set_2(m,w)

%--------------------------------------------------------------------------
% Object:
% Second set interesting in the paper (Dubiner-equispaced in the interval
% (-w,w) for trigonometric polynomials).
%--------------------------------------------------------------------------

t=chebyshev_lobatto(m);
th2=2*asin(t*sin(w/2));
th2=th2';







function dub=dubiner_distance(x,w)

%--------------------------------------------------------------------------
% Object:
% Dubiner distance of successive points X in the interval (-w,w) for 
% trigonometric polynomials. The set X must include [-w,w].
% Fill-distance is half the largest of this quantity.
%--------------------------------------------------------------------------

F=@(t,w) 2*asin(sin(t/2)/sin(w/2));

x=sort(x);
L=length(x);

for k=1:L-1
    xm=x(k); xM=x(k+1);
    dub(k)=abs(F(xm,w)-F(xM,w));
end

