
function demo_figure_04A

%--------------------------------------------------------------------------
% Object:
% The function ?(??) for ?? ? (0, 0.9999 ?/4]; the horizontal lines are
% y = 1.1 and y = 1.3 (log scale).
%--------------------------------------------------------------------------
% Reference:
% A. Sommariva and M. Vianello
% "Norming grids and polynomial interpolation on spherical triangles".
% See Figure 4.
%--------------------------------------------------------------------------

%  ......................... variable w_star ..............................
% w_starV=(pi/4)./(10:-1:1);

example=2;

switch example
    case 1 % curves plot
        Nw=10; angle_max=0.9999*pi/4; % Nw=10;
        w_starV=union(angle_max/4./(1:Nw),linspace(angle_max/4,angle_max,25));
        w_starV=union(angle_max./(100:10:200),w_starV);
        w_starV=union(linspace(0.8*angle_max,angle_max,20),w_starV);
    case 2 % special points
        w_starV=[pi/12 pi/10 pi/9 pi/8 pi/6 pi/5 0.9*pi/4 0.999*pi/4 0.9999*pi/4];
end

%  ............................. degrees ..................................
mV=10:10:2000; % mV=10:10:2000;

% ............................ w cardinality ..............................
Nw=50; % Nw=50;
set_type=1; % 1: Gauss-Chebyshev-Lobatto, 2: Gauss-Chebyshev (open)

% ........................... function evals ..............................

tic;
for i=1:length(w_starV)
    w_starL=w_starV(i);
    denw=1:Nw;
    wVL=union(w_starL./(1:Nw),linspace(w_starL/4,w_starL,50));
    alpha_w_star(i)=max_rat_eval(wVL,mV,w_starL,set_type);
    fprintf('\n \t w*: %1.5e alpha(w*): %1.5e',w_starL,alpha_w_star(i));
end


fprintf('\n \t max alpha(w*) : %1.5e \n \n',max(alpha_w_star));
toc;
fprintf('\n \n');

semilogy(w_starV,alpha_w_star,'k-','LineWidth',2);
hold on;
grid minor;
plot([0 0.8],[1.3 1.3],'r:','LineWidth',2);
plot([0 0.8],[1.1 1.1],'c:','LineWidth',2);
% xlabel('w^*');
% ylabel('\alpha(w^*)');
hold off





function value=max_rat_eval(wVL,mV,w_starL,set_type)

for j=1:length(wVL)
    wL=wVL(j);
    for k=1:length(mV)
        mL=mV(k);
        [~,filldistL0]=sector_filldistance(mL,wL,w_starL,[],set_type);
        arg_value(j,k)=filldistL0/(pi/mL);
    end
end

value=max(max(arg_value));
