
function demo_figure_05A

%--------------------------------------------------------------------------
% Object:
% Demo on dubiner distances spherical triangles.
%--------------------------------------------------------------------------
% Dates:
% Written on 01/02/2021: A. Sommariva and M. Vianello.
%--------------------------------------------------------------------------

clear; clf;

warning off;


deg=10;


% ........................ Main code below ................................

% vertices: k-th represents k-th point cartesian coordinates
% Note: the triangles in our examples are at the north pole and
% "horizontal".

Q=[  5.999999999999999e-01                         0
    -1.854101966249684e-01     5.706339097770921e-01
    -3.000000000000002e-01    -5.196152422706630e-01];


% ... wam over a planar triangle ...
wam_triangle=wamquadrangle(deg,Q([1:3 1],1:2));

% ... lines defining the grids on the planar domain ...
[pts_VW,pts_tri]=define_lines(Q,deg);
[pts_UV,pts_UW]=define_lines2(Q,deg);


% ........................ plot figure ....................................

hold on;

% ... plot mesh planar triangle ...

color_dots='red';
linewidths=0.8;
plot(wam_triangle(:,1),wam_triangle(:,2),...
    'ko','Color',color_dots,'MarkerSize',6,...
    'MarkerEdgeColor',color_dots,'MarkerFaceColor',color_dots);

% ... plot lines connecting vertex U and VW ...
color_lines=[17 17 17]/255;
plot(pts_tri(:,1),pts_tri(:,2),':','color',color_lines,'LineWidth',...
    linewidths);


% ... plot lines connecting UV with UW ...
L=size(pts_UV,1);

for k=1:L
    UV0=pts_UV(k,:);
    UW0=pts_UW(k,:);
    
    plot([UV0(1) UW0(1) ],[UV0(2) UW0(2)],':','color',color_lines,...
        'LineWidth',linewidths);
end

% ... plot lines connecting P' with P and with U ...
tP1=0.72; P1=tP1*Q(2,:)+(1-tP1)*Q(3,:);

tP=0.6; P=tP*P1+(1-tP)*Q(1,:);

plot([Q(1,1) P1(1)],[Q(1,2) P1(2)],':','color','b',...
    'LineWidth',1.3);

t=chebyshev_lobatto_01(deg);

U=(Q(1,:));
ChLUP1=t*P1+(1-t)*U;
plot(ChLUP1(:,1),ChLUP1(:,2),'.','MarkerEdgeColor','k',...
    'MarkerFaceColor','k',...
    'MarkerSize',12);

plot(P1(1),P1(2),'o','MarkerEdgeColor','m',...
    'MarkerFaceColor','k',...
    'MarkerSize',5);

plot(P(1),P(2),'o','MarkerEdgeColor','m',...
    'MarkerFaceColor','k',...
    'MarkerSize',5);


% ... adding text ...
text(Q(1,1),Q(1,2),'U','fontsize',14);
text(Q(2,1),Q(2,2)+0.05,'V','fontsize',14);
text(Q(3,1)-0.02,Q(3,2)-0.05,'W','fontsize',14);
text(P(1),P(2)-0.05,'P','fontsize',14);
text(P1(1)-0.05,P1(2)-0.05,'P^{\prime}','fontsize',14);

% ... no ticks ...
set(gca,'xtick',[])
set(gca,'xticklabel',[])

set(gca,'ytick',[])
set(gca,'yticklabel',[])

set(gca,'visible','off')

hold off;




















function [pts_VW,pts_tri]=define_lines(Q,deg)

% Chebyshev-Lobatto grid
j=(0:1:deg);
t=cos(j*pi/deg); t=((t+1)/2)';
tt=linspace(0,1,400); tt=tt';

A=Q(1,:);
B=Q(2,:);
C=Q(3,:);

X=t*B(1)+(1-t)*C(1); Y=t*B(2)+(1-t)*C(2); 
pts_VW=[X Y];

pts_tri=[];
for k=1:length(t)
    D=pts_VW(k,:);
    
    X1=tt*A(1)+(1-tt)*D(1);
    Y1=tt*A(2)+(1-tt)*D(2);
    
    pts_tri=[pts_tri; X1 Y1];
    
end






function t=chebyshev_lobatto_01(deg)

j=(0:1:deg);
t=cos(j*pi/deg); t=((t+1)/2)';





function [pts_UV,pts_UW]=define_lines2(Q,deg)

% Chebyshev-Lobatto grid
j=(0:1:deg);
t=cos(j*pi/deg); t=((t+1)/2)';
tt=linspace(0,1,400); tt=tt';

A=Q(1,:);
B=Q(2,:);
C=Q(3,:);


X=t*A(1)+(1-t)*B(1); Y=t*A(2)+(1-t)*B(2);
pts_UV=[X Y];



X=t*A(1)+(1-t)*C(1); Y=t*A(2)+(1-t)*C(2); 
pts_UW=[X Y];

























