
function demo_figure_06A

% .......... plot circle ..........  
th=linspace(0,2*pi,1000);
plot(cos(th),sin(th),'k-','LineWidth',2);
hold on;
axis equal;

colorpts='red';

% .......... point A ..........
thA=pi/2+pi/4-pi/18;
A=[cos(thA) sin(thA)];
plot(A(1),A(2),'.','color',colorpts,'MarkerSize',14);
text(A(1),A(2)+0.2,'A','fontsize',14);

% .......... point B ..........
thB=1.808795770248669e+00;
B=[cos(thB) sin(thB)];
plot(B(1),B(2),'.','color',colorpts,'MarkerSize',14);
text(B(1),B(2)+0.1,'B','fontsize',14);

% .......... point Q1 ..........
yA=A(2);
thB1=thB-pi/2;
Q1=[-yA*tan(thB1) yA];
plot(Q1(1),Q1(2),'.','color',colorpts,'MarkerSize',14);
text(Q1(1)-0.1,Q1(2),'Q^{\prime}','fontsize',14);

% .......... point W ..........
thW=2.490834175346193e+00;
W=[cos(thW) sin(thW)];
plot(W(1),W(2),'.','color',colorpts,'MarkerSize',14);
text(W(1)-0.1,W(2),'W','fontsize',14);

% .......... point P ..........
yW=W(2);
thP1=thA-pi/2;
P=[-yW*tan(thP1) yW];
plot(P(1),P(2),'.','color',colorpts,'MarkerSize',14);
text(P(1),P(2)+0.1,'P','fontsize',14);

% .......... point Q ..........
Q=[-yW*tan(thB1) yW];
plot(Q(1),Q(2),'.','color',colorpts,'MarkerSize',14);
text(Q(1),Q(2)+0.1,'Q','fontsize',14);

% .......... point E ..........
E=[-cos(thW) sin(thW)];
plot(E(1),E(2),'.','color',colorpts,'MarkerSize',14);
text(E(1),E(2)+0.1,'E','fontsize',14);

% .......... point 0 ..........
O=[0 0];
plot(O(1),O(2),'.','color',colorpts,'MarkerSize',14);
text(O(1),O(2)-0.1,'O','fontsize',14);

% .......... point N ..........
N=[0 1];
plot(N(1),N(2),'.','color',colorpts,'MarkerSize',14);
text(N(1),N(2)+0.1,'N','fontsize',14);

% .......... segm 0 horiz ..........
linewidths=1;
plot([-1 1],[0 0],'k-','LineWidth',linewidths);

% .......... segm WE ..........
plot([W(1) E(1)],[W(2) E(2)],'k-','LineWidth',linewidths);

% .......... segm A Q1 ..........
plot([A(1)  Q1(1)],[A(2) Q1(2)],'k-','LineWidth',linewidths);

% .......... segm AO ..........
plot([A(1)  O(1)],[A(2) O(2)],'k-','LineWidth',linewidths);

% .......... segm AB ..........
plot([A(1)  B(1)],[A(2) B(2)],'k-','LineWidth',linewidths);

% .......... segm BO ..........
plot([B(1)  O(1)],[B(2) O(2)],'k-','LineWidth',linewidths);

% .......... segm NO ..........
plot([N(1)  O(1)],[N(2) O(2)],'k:','LineWidth',linewidths);

% .......... segm WO ..........
plot([W(1)  O(1)],[W(2) O(2)],'k:','LineWidth',linewidths);

% .......... segm EO ..........
plot([E(1)  O(1)],[E(2) O(2)],'k:','LineWidth',linewidths);

% .......... tangent ..........
Wtan=[-sin(thW) cos(thW)];
W0=W-0.6*Wtan;
W1=W+0.6*Wtan;
plot([W0(1)  W1(1)],[W0(2) W1(2)],'b-','LineWidth',linewidths+0.3);

% .......... no ticks ..........
set(gca,'xtick',[])
set(gca,'xticklabel',[])

set(gca,'ytick',[])
set(gca,'yticklabel',[])

set(gca,'visible','off')
hold off;

